/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.resumo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditMascara;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboBox;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.dialogs.PainelDadosRestituicao;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.resumo.CalculoImposto;
import serpro.ppgd.irpf.resumo.ObservadorDebitoAutomatico;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaLinks;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class SubPainelDadosBancarios
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private WeakReference<DeclaracaoIRPF> weakDec = null;
    private JLabel lblTextoExplic1 = null;
    private JLabel lblTextoExplic2 = null;
    private JLabel lblCodigoBanco = null;
    private JCheckBox chkPix;
    private JAutoCompleteEditCodigo cmbBanco;
    private JAutoCompleteEditCPF cmbContas;
    private JEditMascara edtAgencia;
    private JEditMascara edtConta;
    private JEditAlfa edtDV;
    private JEditAlfa edtOperacao;
    private JSeparator jsSeparador;
    private JLabel lblAgencia;
    private JLabel lblBanco;
    private JLabel lblConta;
    private JLabel lblContasBens;
    private JLabel lblContasBens1;
    private JLabel lblDV;
    private JLabel lblInfoContas;
    private JLabel lblInfoPix;
    private JLabel lblOperacao;
    private JLabel lblTipoConta;
    private JPanel pnlInformacoesBancarias;

    public SubPainelDadosBancarios() {
        this.initComponents();
    }

    public SubPainelDadosBancarios(JLabel lblTextoExplic1, JLabel lblTextoExplic2, JLabel lblCodigoBanco) {
        this.initComponents();
        this.lblTextoExplic1 = lblTextoExplic1;
        this.lblTextoExplic2 = lblTextoExplic2;
        this.lblCodigoBanco = lblCodigoBanco;
    }

    private WeakReference<DeclaracaoIRPF> getWeakDec() {
        return this.weakDec;
    }

    private void alterarTextoLblInfoContas() {
        this.lblInfoContas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GuiUtil.mostrarInfoHTML((String)SubPainelDadosBancarios.this.retornaUrlBancosRedeArrecadadora().getConteudo(2));
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SubPainelDadosBancarios.this.lblInfoContas.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SubPainelDadosBancarios.this.lblInfoContas.setCursor(new Cursor(0));
            }
        });
    }

    private ElementoTabela retornaUrlBancosRedeArrecadadora() {
        ElementoTabela elemento = new ElementoTabela();
        if (((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getSaldoImpostoPagar().comparacao(">", "0,00")) {
            elemento.setConteudo(0, CadastroTabelasIRPF.recuperarDescricaoLink((CodigoTabelaLinks)CodigoTabelaLinks.CODIGO_LinkDebitoAutomatico));
            elemento.setConteudo(1, CadastroTabelasIRPF.recuperarURLLink((CodigoTabelaLinks)CodigoTabelaLinks.CODIGO_LinkDebitoAutomatico));
            elemento.setConteudo(2, "<html><body>Selecione uma das contas cadastradas na ficha de Bens e Direitos, <br> para programa\u00e7\u00e3o do pagamento via d\u00e9bito autom\u00e1tico. Somente <br> <a href=\"" + elemento.getConteudo(1) + "\" target=\"_blank\">" + elemento.getConteudo(0) + "</a> podem ser selecionados.<br><br></body></html>");
        } else {
            elemento.setConteudo(0, CadastroTabelasIRPF.recuperarDescricaoLink((CodigoTabelaLinks)CodigoTabelaLinks.CODIGO_LinkImpostoARestituir));
            elemento.setConteudo(1, CadastroTabelasIRPF.recuperarURLLink((CodigoTabelaLinks)CodigoTabelaLinks.CODIGO_LinkImpostoARestituir));
            elemento.setConteudo(2, "<html><body>Selecione uma das contas cadastradas na ficha de Bens e Direitos, <br> como a conta em que deseja receber a restitui\u00e7\u00e3o, desde que seja em um dos <br> <a href=\"" + elemento.getConteudo(1) + "\" target=\"_blank\">" + elemento.getConteudo(0) + "</a>. \u00c9 poss\u00edvel selecionar o recebimento de <br> restitui\u00e7\u00e3o por Pix; nesse caso, a chave Pix \u00e9 o CPF do titular da declara\u00e7\u00e3o.</body></html>");
        }
        String texto = !elemento.getConteudo(1).equals("") ? "<html><a href=''>" + elemento.getConteudo(0) + "</a></html>" : "<html>Contas desta declara\u00e7\u00e3o em bancos da rede arrecadadora</html>";
        this.lblContasBens.setText(texto);
        return elemento;
    }

    private void alterarLblContasBens() {
        this.lblContasBens.setText("<html><a href=''>" + this.retornaUrlBancosRedeArrecadadora().getConteudo(0) + "</a></html>");
        this.lblContasBens.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    Desktop.getDesktop().browse(new URI(SubPainelDadosBancarios.this.retornaUrlBancosRedeArrecadadora().getConteudo(1)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void setDeclaracao(DeclaracaoIRPF dec) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.adicionarObservadores();
        this.atualizaLabelContaDebitoCredito();
        this.mostrarComboContas();
        this.alterarLblContasBens();
    }

    private void associaInformacao() {
        this.cmbBanco.setInformacao((Informacao)((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getBanco());
        this.cmbBanco.getInformacao().addObservador(this.cmbBanco.getInformacao().getNomeCampo(), new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo.toString().isEmpty()) {
                    ((JAutoCompleteComboBox)SubPainelDadosBancarios.this.cmbBanco.getComponenteEditor()).setSelectedItem(null);
                }
            }
        });
        this.edtAgencia.setInformacao((Informacao)((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getAgencia());
        this.edtOperacao.setInformacao((Informacao)((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getOperacao());
        this.edtConta.setInformacao((Informacao)((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getContaCredito());
        this.edtDV.setInformacao((Informacao)((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getDvContaCredito());
    }

    public void configurarTela(boolean debito, boolean painelAba) {
        Color bg;
        if (!painelAba) {
            bg = new Color(241, 245, 249);
            this.pnlInformacoesBancarias.setBackground(bg);
            this.pnlInformacoesBancarias.getParent().setBackground(bg);
            this.pnlInformacoesBancarias.setBorder(BorderFactory.createEmptyBorder());
            this.chkPix.setBackground(bg);
        } else {
            bg = new Color(255, 255, 255);
            Color bgPai = new Color(241, 245, 249);
            this.pnlInformacoesBancarias.getParent().setBackground(bgPai);
            this.pnlInformacoesBancarias.setBackground(bg);
            Color color = new Color(212, 231, 233);
            this.pnlInformacoesBancarias.setBorder(BorderFactory.createLineBorder(color));
            this.chkPix.setBackground(bg);
        }
        if (debito) {
            this.chkPix.setVisible(false);
            this.chkPix.setSelected(false);
            Dimension dimension = new Dimension(527, 222);
            this.pnlInformacoesBancarias.getParent().setPreferredSize(dimension);
        }
    }

    private void adicionarObservadores() {
        ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getImpostoRestituir().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                SubPainelDadosBancarios.this.atualizaLabelContaDebitoCredito();
                SubPainelDadosBancarios.this.alterarTextoLblInfoContas();
                SubPainelDadosBancarios.this.repaint();
            }
        });
        ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getDebitoAutomatico().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                SubPainelDadosBancarios.this.mostrarComboContas();
                SubPainelDadosBancarios.this.habilitarBancoDadosConta();
                SubPainelDadosBancarios.this.retornaUrlBancosRedeArrecadadora();
            }
        });
        ObservadorDebitoAutomatico observadorDebitoAutomatico = new ObservadorDebitoAutomatico(((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto());
        observadorDebitoAutomatico.habilitaDesabilitaDadosBancarios();
    }

    public void preExibir() {
        this.atualizaLabelContaDebitoCredito();
    }

    public void configurarComponentes() {
        this.associaInformacao();
        this.preencherComboContas();
        final Codigo banco = ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getBanco();
        final Codigo tipoConta = ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getTipoConta();
        this.chkPix.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String codigo = "4";
                    tipoConta.setConteudo(codigo);
                } else if (e.getStateChange() == 2) {
                    tipoConta.clear();
                }
            }
        });
        final JComboBox jContas = (JComboBox)this.cmbContas.getComponenteEditor();
        jContas.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (jContas.getSelectedItem() != null) {
                    ElementoTabela et = (ElementoTabela)jContas.getSelectedItem();
                    String codigoBanco = et.getConteudo(2);
                    String agencia = et.getConteudo(3);
                    String conta = et.getConteudo(4);
                    String dvConta = et.getConteudo(5);
                    String nomeBanco = et.getConteudo(6);
                    String operacao = et.getConteudo(7);
                    String tipoContaCaixa = et.getConteudo(8);
                    String inContaPagamento = et.getConteudo(9);
                    String grupo = et.getConteudo(10);
                    String codigoBem = et.getConteudo(11);
                    SubPainelDadosBancarios.this.setarCampos(codigoBanco, agencia, conta, dvConta, nomeBanco, operacao, tipoContaCaixa, inContaPagamento, grupo, codigoBem);
                }
            }
        });
        banco.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("Banco")) {
                    SubPainelDadosBancarios.this.configuraNumeroCaracteresDV(banco.naoFormatado(), tipoConta.naoFormatado());
                    SubPainelDadosBancarios.this.configurarConta(banco, tipoConta);
                    SubPainelDadosBancarios.this.habilitarCampoOperacao();
                }
            }
        });
        tipoConta.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("Tipo de Conta")) {
                    SubPainelDadosBancarios.this.configurarPix(tipoConta.naoFormatado());
                    SubPainelDadosBancarios.this.mostrarComboContas();
                    SubPainelDadosBancarios.this.lblTipoConta.setText(tipoConta.getConteudoAtual(1));
                    SubPainelDadosBancarios.this.configuraNumeroCaracteresDV(banco.naoFormatado(), tipoConta.naoFormatado());
                    SubPainelDadosBancarios.this.configurarConta(banco, tipoConta);
                    SubPainelDadosBancarios.this.habilitarCampoOperacao();
                    SubPainelDadosBancarios.this.setarVisibilidadeCampos(tipoConta.naoFormatado());
                    SubPainelDadosBancarios.this.configurarTextoExplicativo(tipoConta.naoFormatado());
                }
            }
        });
        this.configurarConta(banco, tipoConta);
        this.configuraNumeroCaracteresDV(banco.naoFormatado(), tipoConta.naoFormatado());
        this.habilitarCampoOperacao();
        this.chkPix.setSelected("4".equals(tipoConta.naoFormatado()));
        this.configurarPix(tipoConta.naoFormatado());
        this.mostrarComboContas();
        this.setarVisibilidadeCampos(tipoConta.naoFormatado());
        this.configurarTextoExplicativo(tipoConta.naoFormatado());
        this.habilitarBancoDadosConta();
        this.alterarTextoLblInfoContas();
        this.lblTipoConta.setText(tipoConta.getConteudoAtual(1));
    }

    public void preencherComboContas() {
        Bens bens = ((DeclaracaoIRPF)this.weakDec.get()).getBens();
        boolean impostoAPagar = ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getSaldoImpostoPagar().comparacao(">", "0,00");
        boolean flagDebito = impostoAPagar;
        List contas = CadastroTabelasIRPF.obterBensComContasCadastradas((Bens)bens, (boolean)flagDebito);
        this.cmbContas.setDados(contas);
        boolean dadosValidos = ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().validarContaBancaria(contas);
        if (!dadosValidos) {
            ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getTipoConta().clear();
            this.cmbBanco.getInformacao().clear();
            this.limpaDadosConta();
        }
    }

    private void limpaDadosConta() {
        this.edtOperacao.getInformacao().setConteudo("");
        this.edtAgencia.getInformacao().setConteudo("");
        this.edtConta.getInformacao().setConteudo("");
        this.edtDV.getInformacao().setConteudo("");
    }

    private void configurarPix(String codigo) {
        if (codigo.equals("4")) {
            this.cmbBanco.getInformacao().clear();
            this.limpaDadosConta();
        }
    }

    public void setarVisibilidadeCampos(String codigo) {
        if ("4".equals(codigo)) {
            this.lblBanco.setVisible(false);
            this.cmbBanco.setVisible(false);
            this.lblAgencia.setVisible(false);
            this.edtAgencia.setVisible(false);
            this.lblConta.setVisible(false);
            this.edtConta.setVisible(false);
            this.lblDV.setVisible(false);
            this.edtDV.setVisible(false);
            this.lblInfoContas.setVisible(false);
            this.lblContasBens.setVisible(false);
            this.cmbContas.setVisible(false);
            this.lblTipoConta.setVisible(false);
        } else {
            this.lblBanco.setVisible(true);
            this.cmbBanco.setVisible(true);
            this.lblAgencia.setVisible(true);
            this.edtAgencia.setVisible(true);
            this.lblConta.setVisible(true);
            this.edtConta.setVisible(true);
            this.lblDV.setVisible(true);
            this.edtDV.setVisible(true);
            this.lblInfoContas.setVisible(true);
            this.lblContasBens.setVisible(true);
            this.cmbContas.setVisible(true);
            this.lblTipoConta.setVisible(true);
        }
    }

    public void configurarTextoExplicativo(String codigo) {
        if (this.lblTextoExplic1 != null && this.lblTextoExplic2 != null) {
            if ("4".equals(codigo)) {
                this.lblTextoExplic1.setText(PainelDadosRestituicao.TEXTO_EXP_PIX);
                this.lblTextoExplic2.setText("");
                this.lblCodigoBanco.setText("");
            } else {
                this.lblTextoExplic1.setText(PainelDadosRestituicao.TEXTO_EXP_1);
                this.lblTextoExplic2.setText(PainelDadosRestituicao.TEXTO_EXP_2);
                this.lblCodigoBanco.setText(PainelDadosRestituicao.TEXTO_CODIGO_BANCO);
            }
        } else if ("4".equals(codigo)) {
            this.lblInfoPix.setText(PainelDadosRestituicao.TEXTO_EXP_PIX);
        } else {
            this.lblInfoPix.setText("");
        }
    }

    private void habilitarBancoDadosConta() {
        ((JComboBox)this.cmbBanco.getComponenteEditor()).setEnabled(false);
        ((JTextField)this.edtOperacao.getComponenteEditor()).setEnabled(false);
        ((JTextField)this.edtAgencia.getComponenteEditor()).setEnabled(false);
        ((JTextField)this.edtConta.getComponenteEditor()).setEnabled(false);
        ((JTextField)this.edtDV.getComponenteEditor()).setEnabled(false);
    }

    private void setarCampos(String codBanco, String agencia, String conta, String dvConta, String nomeBanco, String operacao, String tipoContaCaixa, String inContaPagamento, String grupo, String codigoBem) {
        this.edtOperacao.getInformacao().setConteudo(operacao);
        this.cmbBanco.getInformacao().setConteudo(codBanco);
        ElementoTabela elb = new ElementoTabela();
        elb.setConteudo(0, codBanco);
        elb.setConteudo(1, nomeBanco);
        ((JAutoCompleteComboBox)this.cmbBanco.getComponenteEditor()).setSelectedItem((Object)elb);
        if ("1".equals(inContaPagamento)) {
            ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getTipoConta().setConteudo("3");
        } else if ("04".equals(grupo) && "01".equals(codigoBem)) {
            ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getTipoConta().setConteudo("2");
        } else if ("06".equals(grupo) && "01".equals(codigoBem)) {
            ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getTipoConta().setConteudo("1");
        } else {
            ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getTipoConta().clear();
        }
        this.edtAgencia.getInformacao().setConteudo(agencia);
        this.edtConta.getInformacao().setConteudo(conta);
        this.edtDV.getInformacao().setConteudo(dvConta);
        this.lblTipoConta.setText(((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getTipoConta().getConteudoAtual(1));
        JComboBox jConta = (JComboBox)this.cmbContas.getComponenteEditor();
        jConta.setSelectedIndex(-1);
    }

    private void configuraNumeroCaracteresDV(String banco, String codTipoConta) {
        String dv = this.edtDV.getConteudo().toString();
        if ("3".equals(codTipoConta)) {
            this.edtDV.setMaxChars(2);
            ((Alfa)this.edtDV.getInformacao()).setMaximoCaracteres(2);
        } else if (CalculoImposto.getBancosDebito().contains(banco)) {
            this.edtDV.setMaxChars(1);
            ((Alfa)this.edtDV.getInformacao()).setMaximoCaracteres(1);
            if (dv != null && dv.trim().length() > 1) {
                this.edtDV.getInformacao().setConteudo(dv.substring(0, 1));
            }
        } else if ("104".equals(banco)) {
            this.edtDV.setMaxChars(1);
            ((Alfa)this.edtDV.getInformacao()).setMaximoCaracteres(1);
        } else {
            this.edtDV.setMaxChars(2);
            ((Alfa)this.edtDV.getInformacao()).setMaximoCaracteres(2);
        }
    }

    private void configurarConta(Codigo banco, Codigo tipoConta) {
        this.edtConta.setMascara(this.gerarMascaraConta(20));
    }

    public String gerarMascaraConta(int digitos) {
        return IRPFUtil.repetirString((String)"*", (int)digitos);
    }

    private void mostrarComboContas() {
        boolean flagDebito;
        Bens bens = ((DeclaracaoIRPF)this.weakDec.get()).getBens();
        String tipoConta = ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getTipoConta().naoFormatado();
        boolean impostoArestituir = ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getImpostoRestituir().comparacao(">", "0,00");
        boolean impostoAPagar = ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getSaldoImpostoPagar().comparacao(">", "0,00");
        boolean bl = flagDebito = impostoAPagar;
        if (CadastroTabelasIRPF.obterBensComContasCadastradas((Bens)bens, (boolean)flagDebito).size() > 0 && (impostoArestituir || impostoAPagar)) {
            if (impostoArestituir && !"4".equals(tipoConta) || impostoAPagar && "autorizado".equals(((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getDebitoAutomatico().naoFormatado())) {
                ((JComboBox)this.cmbContas.getComponenteEditor()).setEnabled(true);
            } else {
                ((JComboBox)this.cmbContas.getComponenteEditor()).setEnabled(false);
            }
        }
    }

    private void habilitarCampoOperacao() {
        if (this.weakDec.get() != null && ((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().temOperacao()) {
            this.lblOperacao.setVisible(true);
            this.edtOperacao.setVisible(true);
        } else {
            this.lblOperacao.setVisible(false);
            this.edtOperacao.setVisible(false);
        }
    }

    private void atualizaLabelContaDebitoCredito() {
        if (((DeclaracaoIRPF)this.weakDec.get()).getResumo().getCalculoImposto().getImpostoRestituir().comparacao(">", "0,00")) {
            this.lblConta.setText("Conta para cr\u00e9dito");
        } else {
            this.lblConta.setText("Conta para d\u00e9bito");
        }
    }

    private void initComponents() {
        this.pnlInformacoesBancarias = new JPanel();
        this.lblContasBens = new JLabel();
        this.cmbContas = new JAutoCompleteEditCPF();
        this.jsSeparador = new JSeparator();
        this.cmbBanco = new JAutoCompleteEditCodigo();
        this.lblBanco = new JLabel();
        this.edtAgencia = new JEditMascara();
        this.lblAgencia = new JLabel();
        this.edtConta = new JEditMascara();
        this.lblConta = new JLabel();
        this.lblDV = new JLabel();
        this.edtDV = new JEditAlfa();
        this.lblOperacao = new JLabel();
        this.edtOperacao = new JEditAlfa();
        this.chkPix = new JCheckBox();
        this.lblInfoPix = new JLabel();
        this.lblTipoConta = new JLabel();
        this.lblInfoContas = new JLabel();
        this.lblContasBens1 = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setPreferredSize(new Dimension(550, 273));
        this.pnlInformacoesBancarias.setBackground(new Color(255, 255, 255));
        this.pnlInformacoesBancarias.setBorder(BorderFactory.createTitledBorder(null, "Informa\u00e7\u00f5es banc\u00e1rias", 0, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.lblContasBens.setFont(FontesUtil.FONTE_NORMAL);
        this.lblContasBens.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblContasBens.setLabelFor((Component)this.cmbBanco);
        this.lblContasBens.setText("bancos da rede arrecadadora");
        this.lblContasBens.setBorder(null);
        this.lblContasBens.setMaximumSize(new Dimension(165, 20));
        this.lblContasBens.setMinimumSize(new Dimension(165, 20));
        this.lblContasBens.setName("");
        this.lblContasBens.setPreferredSize(new Dimension(165, 20));
        this.cmbBanco.setToolTipText("Informe o c\u00f3digo do banco ou parte do nome para pesquisa; ou selecione o banco utilizando a seta \u00e0 direita.");
        this.lblBanco.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBanco.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBanco.setLabelFor((Component)this.cmbBanco);
        this.lblBanco.setText("Banco");
        this.edtAgencia.setCaracteresValidos("0123456789 ");
        this.edtAgencia.setMascara("****");
        this.lblAgencia.setFont(FontesUtil.FONTE_NORMAL);
        this.lblAgencia.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblAgencia.setLabelFor((Component)this.edtAgencia);
        this.lblAgencia.setText("Ag\u00eancia (sem DV)");
        this.edtConta.setCaracteresValidos("0123456789 ");
        this.edtConta.setMascara("********************");
        this.lblConta.setFont(FontesUtil.FONTE_NORMAL);
        this.lblConta.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblConta.setLabelFor((Component)this.edtConta);
        this.lblConta.setText("Conta para cr\u00e9dito");
        this.lblDV.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDV.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDV.setLabelFor((Component)this.edtDV);
        this.lblDV.setText("DV");
        this.edtDV.setMaxChars(2);
        ((JTextField)this.edtDV.getComponenteEditor()).setHorizontalAlignment(0);
        this.lblOperacao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblOperacao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblOperacao.setLabelFor((Component)this.edtOperacao);
        this.lblOperacao.setText("Opera\u00e7\u00e3o");
        this.edtOperacao.setMaxChars(3);
        ((JTextField)this.edtDV.getComponenteEditor()).setHorizontalAlignment(0);
        this.chkPix.setBackground(new Color(255, 255, 255));
        this.chkPix.setText("Pix (a chave ser\u00e1 o CPF do titular da declara\u00e7\u00e3o)");
        this.lblInfoPix.setFont(FontesUtil.FONTE_NORMAL);
        this.lblInfoPix.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblInfoPix.setHorizontalAlignment(0);
        this.lblTipoConta.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipoConta.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblTipoConta.setHorizontalAlignment(2);
        this.lblTipoConta.setText("Tipo Conta");
        this.lblInfoContas.setFont(FontesUtil.FONTE_TITULO_MAIOR);
        this.lblInfoContas.setForeground(new Color(0, 74, 106));
        this.lblInfoContas.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icones/png10px/info.png")));
        this.lblContasBens1.setFont(FontesUtil.FONTE_NORMAL);
        this.lblContasBens1.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblContasBens1.setLabelFor((Component)this.cmbBanco);
        this.lblContasBens1.setText("Contas desta declara\u00e7\u00e3o em");
        GroupLayout pnlInformacoesBancariasLayout = new GroupLayout(this.pnlInformacoesBancarias);
        this.pnlInformacoesBancarias.setLayout(pnlInformacoesBancariasLayout);
        pnlInformacoesBancariasLayout.setHorizontalGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlInformacoesBancariasLayout.createSequentialGroup().addContainerGap().addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlInformacoesBancariasLayout.createSequentialGroup().addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlInformacoesBancariasLayout.createSequentialGroup().addComponent(this.lblBanco, -1, -1, Short.MAX_VALUE).addGap(80, 80, 80)).addGroup(pnlInformacoesBancariasLayout.createSequentialGroup().addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAgencia, -2, 123, -2).addComponent(this.lblConta, -2, 139, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(pnlInformacoesBancariasLayout.createSequentialGroup().addComponent((Component)this.edtAgencia, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblOperacao).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtOperacao, -2, 65, -2)).addGroup(GroupLayout.Alignment.LEADING, pnlInformacoesBancariasLayout.createSequentialGroup().addComponent((Component)this.edtConta, -2, 180, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDV).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtDV, -2, 65, -2))).addComponent((Component)this.cmbBanco, -2, 300, -2))).addComponent(this.lblTipoConta, -1, -1, Short.MAX_VALUE).addComponent(this.lblInfoPix, -1, -1, Short.MAX_VALUE).addGroup(pnlInformacoesBancariasLayout.createSequentialGroup().addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkPix).addComponent((Component)this.cmbContas, -2, 479, -2).addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, pnlInformacoesBancariasLayout.createSequentialGroup().addComponent(this.lblInfoContas).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblContasBens1, -2, 162, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblContasBens, -2, -1, -2)).addComponent(this.jsSeparador, -2, 467, -2))).addGap(25, 25, 25)))));
        pnlInformacoesBancariasLayout.setVerticalGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlInformacoesBancariasLayout.createSequentialGroup().addContainerGap().addComponent(this.chkPix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlInformacoesBancariasLayout.createSequentialGroup().addComponent(this.jsSeparador, -2, 6, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblContasBens, -2, -1, -2).addComponent(this.lblContasBens1))).addComponent(this.lblInfoContas)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.cmbContas, -2, -1, -2).addGap(12, 12, 12).addComponent(this.lblTipoConta, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.cmbBanco, -2, -1, -2).addComponent(this.lblBanco, -2, 32, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtAgencia, -2, -1, -2).addComponent(this.lblOperacao).addComponent((Component)this.edtOperacao, -2, -1, -2)).addComponent(this.lblAgencia, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlInformacoesBancariasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtConta, -1, -1, Short.MAX_VALUE).addComponent(this.lblDV).addComponent((Component)this.edtDV, -2, -1, -2)).addComponent(this.lblConta, -2, 32, -2)).addGap(24, 24, 24).addComponent(this.lblInfoPix).addContainerGap()));
        pnlInformacoesBancariasLayout.linkSize(1, new Component[]{this.edtConta, this.edtDV, this.lblDV});
        this.cmbContas.getAccessibleContext().setAccessibleName("Contas pr\u00e9-cadastradas");
        this.cmbContas.getAccessibleContext().setAccessibleDescription("");
        this.cmbBanco.getAccessibleContext().setAccessibleName("Banco");
        this.edtAgencia.getAccessibleContext().setAccessibleName("Ag\u00eancia (sem d\u00edgito verificador)");
        this.edtConta.getAccessibleContext().setAccessibleName("Conta para cr\u00e9dito");
        this.edtDV.getAccessibleContext().setAccessibleName("D\u00edgito Verificador");
        this.edtOperacao.getAccessibleContext().setAccessibleName("Opera\u00e7\u00e3o");
        this.edtOperacao.getAccessibleContext().setAccessibleDescription("");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnlInformacoesBancarias, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnlInformacoesBancarias, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    public JAutoCompleteEditCodigo getCmbBanco() {
        return this.cmbBanco;
    }

    public JAutoCompleteEditCPF getCmbContas() {
        return this.cmbContas;
    }

    public JEditMascara getEdtAgencia() {
        return this.edtAgencia;
    }

    public JEditMascara getEdtConta() {
        return this.edtConta;
    }

    public JEditAlfa getEdtDV() {
        return this.edtDV;
    }

    public JEditAlfa getEdtOperacao() {
        return this.edtOperacao;
    }
}

