/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.resumo;

import br.gov.serpro.midas.exception.AplicacaoException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditInteiro;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.ObservadorTipoDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelAbaAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.resumo.CalculoImposto;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaDatasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class PainelAbaParcelamento
extends PainelAbaAb {
    private static final long serialVersionUID = 1L;
    private JEditInteiro edtNumQuotas;
    private JEditValor edtValorQuota;
    private JButtonGroupPanel grpQuotas;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel lblDebitoAutomatico;
    private JLabel lblMensagem;
    private JLabel lblNumQuotas;
    private JLabel lblValorQuota;
    private JEditLogico lgcDebitoAutomatico;
    private PPGDRadioItem rdbPrimeiraQuota;
    private PPGDRadioItem rdbSegundaQuota;

    public PainelAbaParcelamento(PainelDemonstrativoIf painelPai) {
        super(painelPai);
        this.initComponents();
        PPGDRadioItem radioVazio = new PPGDRadioItem();
        radioVazio.setText("Vazio");
        radioVazio.setValorSelecionadoTrue("2");
        this.grpQuotas.adicionaOpcao((Component)radioVazio);
        this.adicionarObservadores();
        this.configuraDebitoAutomatico();
        Component[] componentes = this.jPanel1.getComponents();
        for (int i = 0; i < componentes.length; ++i) {
            if (componentes[i] instanceof JEditInteiro) {
                JSpinner spinner = (JSpinner)((JEditInteiro)componentes[i]).getComponenteEditor();
                spinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        ObservadorTipoDeclaracao.chamarMensagensObservadores = true;
                    }
                });
                continue;
            }
            if (componentes[i] instanceof JEditLogico) {
                Iterator it = ((JEditLogico)componentes[i]).getRadios().values().iterator();
                while (it.hasNext()) {
                    ((JRadioButton)it.next()).addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            ObservadorTipoDeclaracao.chamarMensagensObservadores = true;
                        }
                    });
                }
                continue;
            }
            if (componentes[i] instanceof JEditCampo) {
                componentes[i].addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        ObservadorTipoDeclaracao.chamarMensagensObservadores = true;
                    }
                });
                continue;
            }
            componentes[i].addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ObservadorTipoDeclaracao.chamarMensagensObservadores = true;
                }
            });
        }
        ((JSpinner.DefaultEditor)((JSpinner)this.edtNumQuotas.getComponenteEditor()).getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() >= 48 && e.getKeyCode() <= 57 || e.getKeyCode() >= 37 && e.getKeyCode() <= 40 || e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                    super.keyPressed(e);
                } else {
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.isDigit(e.getKeyChar())) {
                    super.keyTyped(e);
                } else {
                    e.consume();
                }
                JFormattedTextField formatText = ((JSpinner.DefaultEditor)((JSpinner)PainelAbaParcelamento.this.edtNumQuotas.getComponenteEditor()).getEditor()).getTextField();
                if (formatText != null && formatText.getText() != null && formatText.getText().length() >= 1) {
                    e.setKeyChar('\f');
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() >= 48 && e.getKeyCode() <= 57 || e.getKeyCode() >= 37 && e.getKeyCode() <= 40 || e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                    super.keyReleased(e);
                } else {
                    e.consume();
                }
            }
        });
        ((JSpinner)this.edtNumQuotas.getComponenteFoco()).getEditor().getAccessibleContext().setAccessibleName("N\u00famero de quotas at\u00e9 " + TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().naoFormatado());
        this.getAccessibleContext().setAccessibleDescription(this.obterMensagemQuotas());
        this.configurarSelecaoDatas();
    }

    private void habilitaRadio(boolean habilita) {
        for (Map.Entry radio : this.lgcDebitoAutomatico.getRadios().entrySet()) {
            JRadioButton radioButton = (JRadioButton)radio.getValue();
            if (habilita) {
                radioButton.setEnabled(habilita);
                radioButton.setVisible(habilita);
                continue;
            }
            radioButton.setEnabled(radioButton.isSelected());
            radioButton.setVisible(radioButton.isSelected());
        }
    }

    private void configurarSelecaoDatas() {
        String dataLimiteDebitoAutomatico = TabelaDatasIRPF.ConstantesDatas.dataLimiteDebitoAutomatico.getDataFormatada();
        if (IRPFFacade.getInstancia().getDeclaracao().getEmCalamidade().booleanValue()) {
            dataLimiteDebitoAutomatico = TabelaDatasIRPF.ConstantesDatas.dataLimiteDebitoAutomaticoCalamidade.getDataFormatada();
        }
        this.rdbPrimeiraQuota.setText("<html>Quota \u00fanica ou a partir da <br>1a quota (apenas para<br>transmiss\u00e3o at\u00e9 " + dataLimiteDebitoAutomatico + ")<html>");
        this.rdbPrimeiraQuota.getAccessibleContext().setAccessibleName("<html>Quota \u00fanica ou a partir da <br>1a quota (apenas para<br>transmiss\u00e3o at\u00e9 " + dataLimiteDebitoAutomatico + ")<html>");
    }

    public String obterMensagemQuotas() {
        int qtdMaxQuotas = Integer.parseInt(TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().formatado());
        Valor valorMinimoImpostoQuotas = new Valor();
        valorMinimoImpostoQuotas.setConteudo("2,00");
        valorMinimoImpostoQuotas.append('*', TabelaAliquotasIRPF.ConstantesAliquotas.valorMinQuota.getValor());
        StringBuilder mensagem = new StringBuilder("<html>O imposto de valor igual ou superior a R$ ").append(valorMinimoImpostoQuotas.formatado()).append(" poder\u00e1 ser pago em at\u00e9 ").append(qtdMaxQuotas).append("<br>quotas, desde que cada uma n\u00e3o seja inferior a R$ ").append(TabelaAliquotasIRPF.ConstantesAliquotas.valorMinQuota.getValor().formatado()).append(".");
        if (qtdMaxQuotas != 8) {
            mensagem.append("<br>A quantidade m\u00e1xima de quotas para o parcelamento do imposto a pagar foi<br>alterada de 8 para <font color=#FF0000><b>").append(qtdMaxQuotas).append(" quotas</b></font>. Observe as novas datas de vencimento.");
        }
        mensagem.append("</html>");
        return mensagem.toString();
    }

    public String obterMensagemInfoQuotas() {
        StringBuilder texto = new StringBuilder("<html>");
        int qtdMaxQuotas = TabelaDatasIRPF.getQuantidadeMaxQuotas();
        texto.append("Caso tenha selecionado originalmente mais de ").append(qtdMaxQuotas).append(" quotas e j\u00e1 tenha feito<br>o pagamento de alguma quota, os novos Darfs devem ser emitidos<br>exclusivamente por meio do Portal e-CAC.<br><br>").append("Para isso, acesse o Portal e-CAC no site da RFB<br>https://www.gov.br/receitafederal/, clique em \"Declara\u00e7\u00f5es e Demonstrativos\" e<br>selecione o servi\u00e7o \"Meu Imposto de Renda (Extrato da Dirpf)\". Na lista de<br>servi\u00e7os clique em Pagamento - Consultar D\u00e9bitos, Emitir Darf e Alterar Quotas.");
        return texto.toString();
    }

    public boolean exibirInfoQuotas() {
        return TabelaDatasIRPF.getQuantidadeMaxQuotas() != 8;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblNumQuotas = new JLabel();
        this.edtNumQuotas = new JEditInteiro();
        this.lblDebitoAutomatico = new JLabel();
        this.edtValorQuota = new JEditValor();
        this.lblValorQuota = new JLabel();
        this.lgcDebitoAutomatico = new JEditLogico();
        this.grpQuotas = new JButtonGroupPanel();
        this.rdbPrimeiraQuota = new PPGDRadioItem();
        this.rdbSegundaQuota = new PPGDRadioItem();
        this.lblMensagem = new JLabel();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblNumQuotas.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNumQuotas.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNumQuotas.setLabelFor((Component)this.edtNumQuotas);
        this.lblNumQuotas.setText("<html>N\u00famero de<br>quotas (at\u00e9 " + TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().naoFormatado() + ")</html>");
        this.edtNumQuotas.setInformacaoAssociada("resumo.calculoImposto.numQuotas");
        this.lblDebitoAutomatico.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDebitoAutomatico.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDebitoAutomatico.setLabelFor((Component)this.lgcDebitoAutomatico);
        this.lblDebitoAutomatico.setText("D\u00e9bito autom\u00e1tico");
        this.edtValorQuota.setInformacaoAssociada("resumo.calculoImposto.valorQuota");
        this.lblValorQuota.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValorQuota.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValorQuota.setLabelFor((Component)this.edtValorQuota);
        this.lblValorQuota.setText("Valor da quota");
        this.lgcDebitoAutomatico.setCorBackgroundComponenteReadOnly(new Color(255, 255, 255));
        this.lgcDebitoAutomatico.setInformacaoAssociada("resumo.calculoImposto.debitoAutomatico");
        this.lgcDebitoAutomatico.setOrientacaoTexto(0);
        this.grpQuotas.setBorder(null);
        this.grpQuotas.setCorBackgroundComponenteNormal(new Color(255, 255, 255));
        this.grpQuotas.setCorBackgroundComponenteReadOnly(new Color(255, 255, 255));
        this.grpQuotas.setInformacaoAssociada("resumo.calculoImposto.indicadorPrimeiraQuota");
        this.rdbPrimeiraQuota.setBackground(new Color(255, 255, 255));
        this.rdbPrimeiraQuota.setBorder(null);
        this.rdbPrimeiraQuota.setText("<html>Quota \u00fanica ou a partir da <br>1a quota (apenas para  <br> transmiss\u00e3o at\u00e9  " + TabelaDatasIRPF.ConstantesDatas.dataLimiteDebitoAutomatico.getDataFormatada() + ")<html>");
        this.rdbPrimeiraQuota.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbPrimeiraQuota.setName("rdbPrimeiraQuota");
        this.rdbPrimeiraQuota.setVerticalTextPosition(1);
        this.rdbSegundaQuota.setBackground(new Color(255, 255, 255));
        this.rdbSegundaQuota.setBorder(null);
        this.rdbSegundaQuota.setText("A partir da 2a quota");
        this.rdbSegundaQuota.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbSegundaQuota.setName("rdbSegundaQuota");
        this.rdbSegundaQuota.setValorSelecionadoTrue("0");
        this.rdbSegundaQuota.setVerticalTextPosition(1);
        GroupLayout grpQuotasLayout = new GroupLayout((Container)this.grpQuotas);
        this.grpQuotas.setLayout((LayoutManager)grpQuotasLayout);
        grpQuotasLayout.setHorizontalGroup(grpQuotasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpQuotasLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.rdbPrimeiraQuota, -2, 233, -2).addGap(18, 18, 18).addComponent((Component)this.rdbSegundaQuota, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        grpQuotasLayout.setVerticalGroup(grpQuotasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpQuotasLayout.createSequentialGroup().addGroup(grpQuotasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdbPrimeiraQuota, -2, -1, -2).addComponent((Component)this.rdbSegundaQuota, -2, -1, -2)).addGap(0, 9, Short.MAX_VALUE)));
        grpQuotasLayout.linkSize(1, new Component[]{this.rdbPrimeiraQuota, this.rdbSegundaQuota});
        this.rdbPrimeiraQuota.getAccessibleContext().setAccessibleName("<html>Quota \u00fanica ou a partir da <br>1a quota (apenas para  <br> transmiss\u00e3o at\u00e9  " + TabelaDatasIRPF.ConstantesDatas.dataLimiteDebitoAutomatico.getDataFormatada() + ")<html>");
        this.lblMensagem.setFont(FontesUtil.FONTE_NORMAL);
        this.lblMensagem.setForeground(Color.red);
        this.lblMensagem.setIcon(GuiUtil.getImage((String)"/icones/png10px/info.png"));
        this.lblMensagem.setText("O d\u00e9bito autom\u00e1tico poder\u00e1 ser feito no Portal MIR.");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMensagem, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblDebitoAutomatico).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lgcDebitoAutomatico, -2, 164, -2)).addComponent((Component)this.grpQuotas, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblNumQuotas).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNumQuotas, -2, 62, -2).addGap(18, 18, 18).addComponent(this.lblValorQuota).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtValorQuota, -2, 120, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblNumQuotas).addComponent((Component)this.edtNumQuotas, -2, -1, -2).addComponent((Component)this.edtValorQuota, -2, -1, -2).addComponent(this.lblValorQuota)).addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblDebitoAutomatico, -1, -1, Short.MAX_VALUE).addComponent((Component)this.lgcDebitoAutomatico, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMensagem).addGap(5, 5, 5).addComponent((Component)this.grpQuotas, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, new Component[]{this.edtValorQuota, this.lblDebitoAutomatico, this.lblValorQuota});
        this.edtNumQuotas.getAccessibleContext().setAccessibleName("N\u00famero de quotas");
        this.edtNumQuotas.getAccessibleContext().setAccessibleDescription("N\u00famero de quotas");
        this.edtValorQuota.getAccessibleContext().setAccessibleName("Valor da Quota");
        this.lgcDebitoAutomatico.getAccessibleContext().setAccessibleName("Debito Autom\u00e1tico");
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel1.setIcon(GuiUtil.getImage((String)"/icones/png10px/info.png"));
        this.jLabel1.setText(this.obterMensagemQuotas());
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 468, -2).addGap(0, 15, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void adicionarObservadores() {
        final CalculoImposto calcImposto = IRPFFacade.getInstancia().getResumo().getCalculoImposto();
        calcImposto.getDebitoAutomatico().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelAbaParcelamento.this.habilitarSegundaQuota(calcImposto);
            }
        });
        calcImposto.getDebitoAutomatico().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (ObservadorTipoDeclaracao.chamarMensagensObservadores) {
                    DeclaracaoIRPF dec = IRPFFacade.getInstancia().getDeclaracao();
                    if (PainelAbaParcelamento.this.lgcDebitoAutomatico.isShowing() && dec != null && nomePropriedade.equals("D\u00e9bito autom\u00e1tico") && dec.getResumo().getCalculoImposto().getDebitoAutomatico().naoFormatado().equals("autorizado")) {
                        boolean emCalamidade = dec.getEmCalamidade();
                        String dataLimiteDebitoAutomatico = TabelaDatasIRPF.ConstantesDatas.dataLimiteDebitoAutomatico.getDataFormatada();
                        String dataFimRecepcao = TabelaDatasIRPF.ConstantesDatas.dataFimRecepcao.getDataFormatada();
                        if (emCalamidade) {
                            dataLimiteDebitoAutomatico = TabelaDatasIRPF.ConstantesDatas.dataLimiteDebitoAutomaticoCalamidade.getDataFormatada();
                            dataFimRecepcao = TabelaDatasIRPF.ConstantesDatas.dataFimRecepcaoCalamidade.getDataFormatada();
                        }
                        String[] parametros = new String[]{dataLimiteDebitoAutomatico, TabelaDatasIRPF.obterPrimeiroDiaAposDataLimiteDebitoAutomatico((boolean)emCalamidade), dataFimRecepcao};
                        GuiUtil.mostrarInfo((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)MensagemUtil.getMensagem((String)"info_debito_automatico", (String[])parametros));
                    }
                }
            }
        });
        calcImposto.getNumQuotas().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelAbaParcelamento.this.habilitarSegundaQuota(calcImposto);
            }
        });
        calcImposto.getNumQuotas().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelAbaParcelamento.this.configuraDebitoAutomatico();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ObservadorTipoDeclaracao.chamarMensagensObservadores) {
                            DeclaracaoIRPF dec = IRPFFacade.getInstancia().getDeclaracao();
                            if (dec != null && PainelAbaParcelamento.this.edtNumQuotas.isShowing() && dec.getResumo().getCalculoImposto().getNumQuotas().getConteudoAntigo().equals("1") && dec.getResumo().getCalculoImposto().getNumQuotas().asInteger() > 1) {
                                String[] params = new String[]{TabelaDatasIRPF.obterDataReaberturaEntregaFormatada((boolean)dec.getEmCalamidade())};
                                GuiUtil.mostrarInfo((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String[])new String[]{MensagemUtil.getMensagem((String)"info_quotas", (String[])params)});
                                PainelAbaParcelamento.this.resetaSpinner();
                            }
                            if (dec != null) {
                                int limite = dec.getResumo().getCalculoImposto().getNumQuotas().getLimiteMaximo();
                                if (!PainelAbaParcelamento.this.edtNumQuotas.isShowing() || dec.getResumo().getCalculoImposto().getNumQuotas().asInteger() == limite) {
                                    // empty if block
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private void habilitarSegundaQuota(CalculoImposto calcImposto) {
        if (calcImposto.isDebitoAutomatico()) {
            if (calcImposto.getNumQuotas().asInteger() > 1) {
                this.rdbSegundaQuota.setEnabled(true);
            } else {
                this.rdbSegundaQuota.setEnabled(false);
                calcImposto.getIndicadorPrimeiraQuota().setConteudo("1");
            }
        } else {
            calcImposto.getIndicadorPrimeiraQuota().clear();
        }
    }

    private void configuraDebitoAutomatico() {
        DeclaracaoIRPF dec = IRPFFacade.getInstancia().getDeclaracao();
        this.lblMensagem.setVisible(false);
        if (dec.getIdentificadorDeclaracao().isTransmitida()) {
            return;
        }
        if (dec != null) {
            try {
                boolean temSaldoAPagar = dec.getResumo().getCalculoImposto().getSaldoImpostoPagar().comparacao(">=", TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor());
                try {
                    if (temSaldoAPagar && ControladorGui.emFaseEntrega((boolean)dec.getEmCalamidade())) {
                        this.lgcDebitoAutomatico.getInformacao().setHabilitado(true);
                        this.habilitaRadio(true);
                        this.lblMensagem.setVisible(false);
                    } else {
                        this.lgcDebitoAutomatico.getInformacao().setHabilitado(false);
                        this.lgcDebitoAutomatico.getInformacao().setConteudo("N");
                        this.habilitaRadio(false);
                        if (temSaldoAPagar) {
                            this.lblMensagem.setVisible(true);
                        }
                    }
                }
                catch (serpro.ppgd.irpf.exception.AplicacaoException e) {
                    e.printStackTrace();
                }
                if (dec.getResumo().getCalculoImposto().getSaldoImpostoPagar().comparacao("<", TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor())) {
                    if (dec.getResumo().getCalculoImposto().getSaldoImpostoPagar().comparacao(">", "0,00")) {
                        this.lgcDebitoAutomatico.getInformacao().setConteudo("N");
                    } else {
                        this.lgcDebitoAutomatico.getInformacao().clear();
                    }
                }
            }
            catch (AplicacaoException ex) {
                Logger.getLogger(PainelAbaParcelamento.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void resetaSpinner() {
        JSpinner spin = (JSpinner)this.edtNumQuotas.getComponenteEditor();
        for (Component c : spin.getComponents()) {
            MouseListener[] mouseListeners = c.getMouseListeners();
            MouseEvent mouseEvent = new MouseEvent(c, 502, System.currentTimeMillis(), 1024, c.getX() + 1, c.getY() + 1, 1, false, 1);
            int n2 = mouseListeners.length;
            for (int j = 0; j < n2; ++j) {
                mouseListeners[j].mouseReleased(mouseEvent);
            }
        }
        spin.setValue(spin.getValue());
    }

    public String getNomeAba() {
        return "Parcelamento";
    }

    public class DocumentoLimitado
    extends PlainDocument {
        private int tamanhoMax = 10;

        public DocumentoLimitado(int tamanhoMax) {
            this.tamanhoMax = tamanhoMax;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            String stringAntiga = this.getText(0, this.getLength());
            int tamanhoNovo = stringAntiga.length() + str.length();
            if (tamanhoNovo <= this.tamanhoMax) {
                super.insertString(offset, str, attr);
            } else {
                super.insertString(offset, "", attr);
            }
        }
    }
}

