/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpj;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.JComponent;
import serpro.ppgd.app.acoes.ImportarInformeRendimentosAction;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelComAbasAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.rendpj.PainelAbaRendPJDependentesLista;
import serpro.ppgd.irpf.gui.rendpj.PainelAbaRendPJTitularLista;

public class PainelDadosRendPJ
extends PainelComAbasAb {
    private static final long serialVersionUID = 1L;
    private PainelAbaRendPJTitularLista painelAbaTitular;
    private PainelAbaRendPJDependentesLista painelAbaDependente;

    public PainelDadosRendPJ() {
        super("/icones/png40px/DE_rend_pj.png");
        this.configurarHelpID();
        this.getTabbedPane().setName("tabRendPJ");
    }

    public PainelDadosRendPJ(String nomeAba) {
        this();
        this.acionarAba(nomeAba, true);
    }

    protected void montarAbas() {
        this.painelAbaTitular = new PainelAbaRendPJTitularLista((PainelDemonstrativoIf)this);
        this.painelAbaDependente = new PainelAbaRendPJDependentesLista((PainelDemonstrativoIf)this);
        this.getTabbedPane().addTab("Titular", (Component)((Object)this.painelAbaTitular));
        this.getTabbedPane().addTab("Dependentes", (Component)((Object)this.painelAbaDependente));
        this.getTabbedPane().setMnemonicAt(0, 85);
        this.getTabbedPane().setMnemonicAt(1, 83);
    }

    protected void tratarMudancaTabbedPane() {
        ControladorGui.alterarCabecalhoFicha((String)this.getTituloPainel());
        this.getAccessibleContext().setAccessibleName(this.getTituloPainel());
        this.configurarHelpID();
    }

    protected String[] definirNomeAbas() {
        return new String[]{"Rendimentos Tribut\u00e1veis Recebidos de PJ pelo Titular", "Rendimentos Tribut\u00e1veis Recebidos de PJ pelos Dependentes"};
    }

    protected void configObservadores() {
    }

    public String getTituloPainel() {
        return this.getNomeAbas()[this.getTabbedPane().getSelectedIndex()];
    }

    private void configurarHelpID() {
        ControladorGui.alterarHelpId((String)this.getHelpIdAba(this.getTabbedPane().getSelectedIndex()));
        if (this.getTabbedPane().getSelectedIndex() == 0) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), this.painelAbaTitular.getButtonHelpID());
        } else {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), this.painelAbaDependente.getButtonHelpID());
        }
    }

    private String getHelpIdAba(int indiceAba) {
        if (indiceAba == 0) {
            return this.painelAbaTitular.getButtonHelpID();
        }
        return this.painelAbaDependente.getButtonHelpID();
    }

    public String getHelpID() {
        return this.getHelpIdAba(this.getTabbedPane().getSelectedIndex());
    }

    public boolean isTelaComImportacao() {
        return true;
    }

    public String getLabelImportacao() {
        return "Importar arquivo da fonte pagadora";
    }

    public Action obterImportacaoAction() {
        return new ImportarInformeRendimentosAction();
    }

    public void preExibir() {
        this.configurarHelpID();
    }

    public boolean isTelaComFavoritos() {
        return true;
    }

    public boolean isTelaComSubtitulo() {
        return true;
    }
}

