/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.doacaodiretamentedeclaracao;

import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoIdoso;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoIdoso;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelEstatutoIdoso
extends TableListaModel {
    private static final long serialVersionUID = 1L;

    public TableModelEstatutoIdoso(ColecaoEstatutoIdoso pObj) {
        super((ObjetoNegocio)pObj);
    }

    public int getColumnCount() {
        return 5;
    }

    public Informacao getInformacaoAt(int row, int col) {
        Colecao colecaoEstatutoIdoso = (Colecao)this.getObjetoNegocio();
        EstatutoIdoso item = (EstatutoIdoso)colecaoEstatutoIdoso.itens().get(row);
        String tipoFundo = item.getTipoFundo().naoFormatado();
        switch (col) {
            case 0: {
                return super.getInformacaoAt(row, col);
            }
            case 1: {
                Alfa a = new Alfa("Tipo Fundo");
                a.setConteudo(tipoFundo.equals("N") ? "Nacional" : (tipoFundo.equals("E") ? "Estadual" : (tipoFundo.equals("M") ? "Municipal" : "")));
                return a;
            }
            case 2: {
                Alfa b = new Alfa("Fundo");
                if (tipoFundo.equals("N")) {
                    b.setConteudo("Nacional");
                } else if (tipoFundo.equals("E")) {
                    b.setConteudo(item.getUf().getDescricaoDefault());
                } else if (tipoFundo.equals("M")) {
                    b.setConteudo(item.getUf().getDescricaoDefault() + " - " + item.getMunicipio().getConteudoAtual(3));
                }
                return b;
            }
            case 3: {
                return item.getCnpjFundo();
            }
            case 4: {
                return item.getValor();
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(0);
            }
            case 1: {
                return "<html><center>Tipo de Fundo</center></html>";
            }
            case 2: {
                return "<html><center>Fundo</center></html>";
            }
            case 3: {
                return "<html><center>CNPJ</center></html>";
            }
            case 4: {
                return "<html><center>Valor</center></html>";
            }
        }
        return "";
    }
}

