/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dividas;

import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.dividas.Divida;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.TableListaSumarioModel;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;

public class TableModelDividas
extends TableListaSumarioModel {
    private static final long serialVersionUID = 1L;

    public TableModelDividas(Dividas pObj) {
        super((Colecao)pObj);
    }

    public int getColumnCount() {
        return 6;
    }

    public Informacao getInformacaoAt(int row, int col) {
        boolean ultimaLinha;
        Divida item = null;
        Dividas dividas = (Dividas)this.getObjetoNegocio();
        boolean bl = ultimaLinha = row == this.getRowCount() - 1;
        if (!ultimaLinha) {
            item = (Divida)dividas.itens().get(row);
        }
        switch (col) {
            case 0: {
                return ultimaLinha ? this.labelTotal : super.getInformacaoAt(row, col);
            }
            case 1: {
                if (ultimaLinha || item.getCodigo().formatado().equals("-1")) {
                    return null;
                }
                return item.getCodigo();
            }
            case 2: {
                return ultimaLinha ? null : item.getDiscriminacao();
            }
            case 3: {
                return ultimaLinha ? dividas.getTotalExercicioAnterior() : item.getValorExercicioAnterior();
            }
            case 4: {
                return ultimaLinha ? dividas.getTotalExercicioAtual() : item.getValorExercicioAtual();
            }
            case 5: {
                return ultimaLinha ? dividas.getTotalPgtoAnual() : item.getValorPgtoAnual();
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(column);
            }
            case 1: {
                return "<html><center>C\u00f3d.</center></html>";
            }
            case 2: {
                return "<html><center>Discrimina\u00e7\u00e3o</center></html>";
            }
            case 3: {
                if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida()) {
                    if (ControladorGui.getDemonstrativoAberto().entrouSaiuNoMesmoAno()) {
                        return "<html><center>Situa\u00e7\u00e3o na<br>data da<br>caracteriza\u00e7\u00e3o<br>da condi\u00e7\u00e3o de<br>residente<br>R$</center></html>";
                    }
                    return "<html><center>Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "<br>R$</center></html>";
                }
                return "<html><center>Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "<br>R$</center></html>";
            }
            case 4: {
                StringBuilder tituloColuna3 = new StringBuilder();
                tituloColuna3.append("<html><center>");
                if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio()) {
                    tituloColuna3.append("Situa\u00e7\u00e3o na data<br>da partilha<br>R$</center></html>");
                } else if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida()) {
                    tituloColuna3.append("Situa\u00e7\u00e3o na<br>data da<br>caracteriza\u00e7\u00e3o<br>da condi\u00e7\u00e3o de<br>n\u00e3o residente<br>R$</center></html>");
                } else {
                    tituloColuna3.append("Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE + "<br>R$</center></html>");
                }
                return tituloColuna3.toString();
            }
            case 5: {
                return "<html><center>Valor Pago em<br>" + ConstantesGlobais.ANO_BASE + "<br>R$</center></html>";
            }
        }
        return "";
    }
}

