/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.contribuinte;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.GroupPanelEvent;
import serpro.ppgd.gui.xbeans.GroupPanelListener;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditCPF;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.JFlipComponentes;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboBox;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.JEditOcupacaoPrincipal;
import serpro.ppgd.irpf.gui.JanelaPrincipalIRPF;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.componente.DashedBorder;
import serpro.ppgd.irpf.gui.componente.JImagemPanel;
import serpro.ppgd.irpf.gui.contribuinte.PainelEnderecoBrasil;
import serpro.ppgd.irpf.gui.contribuinte.PainelEnderecoExterior;
import serpro.ppgd.irpf.gui.contribuinte.PainelReciboAnterior;
import serpro.ppgd.irpf.gui.contribuinte.PainelReciboRetif;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaLinks;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.util.LogPPGD;

public class PainelContribuinte
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Identifica\u00e7\u00e3o do Contribuinte";
    private boolean telaPronta = false;
    private JButtonMensagem btnMsgConjuge;
    private JButtonMensagem btnMsgEnderecoDiferente;
    private JButtonMensagem btnMsgExterior;
    private JButtonMensagem btnMsgResidente;
    private JButtonMensagem btnMsgRetif;
    private JCheckBox chkDeficiencia;
    private JEditCPF edtCpfConjuge;
    private JEditCPF edtCpfProcurador;
    public JEditData edtDataResidente;
    public JEditData edtDtNasc;
    public JAutoCompleteEditCodigo edtNatureza;
    public JEditAlfa edtNome;
    public JEditOcupacaoPrincipal edtOcupacao;
    private JEditCPF edtProcessoDigital;
    private JEditCPF edtProcessoDigital1;
    private JEditAlfa edtRegistroProfissional;
    public JFlipComponentes flipEndereco;
    public JFlipComponentes flipRecibo;
    private JButtonGroupPanel grpConjuge;
    private JButtonGroupPanel grpEnderecoDiferente;
    private JButtonGroupPanel grpEnderecoExterior;
    private JButtonGroupPanel grpResidente;
    private JButtonGroupPanel grpTipoDeclaracao;
    private IRPFLabelInfo iRPFLabelInfo1;
    private IRPFLabelInfo iRPFLabelInfo2;
    private IRPFLabelInfo iRPFLabelInfo3;
    private IRPFLabelInfo iRPFLabelInfo4;
    private IRPFLabelInfo iRPFLabelInfoDadosCadastrais;
    private JLabel lblCpfConjuge;
    private JLabel lblCpfProcurador;
    private JLabel lblDadosContribuinte;
    private JLabel lblDataResidente;
    private JLabel lblDtNasc;
    private JLabel lblEnderecoDiferente;
    private JLabel lblInfoNaoResidente;
    private JLabel lblLinhaHorizontal;
    private JLabel lblNatureza;
    private JLabel lblNome;
    private JLabel lblOcupacao;
    private JLabel lblOriginal;
    private JLabel lblPerguntaConjuge;
    private JLabel lblPerguntaResidente;
    private JLabel lblPerguntaTipo;
    private JLabel lblProcessoDigital;
    private JLabel lblProcessoDigital1;
    private JLabel lblRegistroProfissional;
    private JLabel lblRetificadora;
    private JPanel panelEndereco;
    private JPanel panelOcupacaoPrincipal;
    private JPanel panelPrincipal;
    private JImagemPanel panelTipoDeclaracao;
    private JPanel pnlPerguntaConjuge;
    private JPanel pnlPerguntaRetorno;
    private PPGDRadioItem rdbBrasil;
    private PPGDRadioItem rdbExterior;
    private PPGDRadioItem rdbNao;
    private PPGDRadioItem rdbNaoConjuge;
    private PPGDRadioItem rdbNaoResidente;
    private PPGDRadioItem rdbOriginal;
    private PPGDRadioItem rdbRetificadora;
    private PPGDRadioItem rdbSim;
    private PPGDRadioItem rdbSimConjuge;
    private PPGDRadioItem rdbSimResidente;
    private PainelEnderecoBrasil painelEnderecoBrasil = new PainelEnderecoBrasil();
    private PainelEnderecoExterior painelEnderecoExterior = new PainelEnderecoExterior();

    public PainelContribuinte() {
        this.initComponents();
        this.lblInfoNaoResidente.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GuiUtil.mostrarInfoHTML((String)("<html><body>Detalhes sobre residentes no Brasil e n\u00e3o residentes podem ser obtidos <a href=\"" + CadastroTabelasIRPF.recuperarURLLink((CodigoTabelaLinks)CodigoTabelaLinks.CODIGO_LinkNaoResidente) + "\" target=\"_blank\">aqui</a>.</body></html>"));
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PainelContribuinte.this.lblInfoNaoResidente.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PainelContribuinte.this.lblInfoNaoResidente.setCursor(new Cursor(0));
            }
        });
        if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isAjuste()) {
            this.lblOriginal.setText("Declara\u00e7\u00e3o de Ajuste Anual Original");
        } else if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida()) {
            this.lblOriginal.setText("Declara\u00e7\u00e3o de Sa\u00edda Definitiva Original");
        }
        this.lblPerguntaResidente.setText(MensagemUtil.getMensagem((String)"txt_pergunta_assumiu_condicao_residente", (String[])new String[]{ConstantesGlobais.ANO_BASE}));
        this.rdbSimResidente.getAccessibleContext().setAccessibleName("Sim, " + this.lblPerguntaResidente.getText());
        this.rdbNaoResidente.getAccessibleContext().setAccessibleName("N\u00e3o " + this.lblPerguntaResidente.getText());
        this.rdbOriginal.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PainelContribuinte.this.lblOriginal.setBorder((Border)new DashedBorder(new Color(0, 0, 0), 2, 2, 1));
            }

            @Override
            public void focusLost(FocusEvent e) {
                PainelContribuinte.this.lblOriginal.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
        this.rdbRetificadora.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PainelContribuinte.this.lblRetificadora.setBorder((Border)new DashedBorder(new Color(0, 0, 0), 2, 2, 1));
            }

            @Override
            public void focusLost(FocusEvent e) {
                PainelContribuinte.this.lblRetificadora.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
        this.rdbOriginal.setOpaque(false);
        this.rdbRetificadora.setOpaque(false);
        ((JTextField)this.edtNome.getComponenteFoco()).addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String cpf = IRPFFacade.getInstancia().getIdDeclaracaoAberto() != null ? IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().formatado() : "";
                ((JanelaPrincipalIRPF)PlataformaPPGD.getPlataforma().getJanelaPrincipal()).getjMenuInfoContribuinte().setText("Contribuinte: " + PainelContribuinte.this.edtNome.getInformacao().formatado() + " - (CPF: " + cpf + ")");
            }
        });
        this.atualizaSubPainelEndereco();
        this.atualizaVisivelNumRecibo();
        this.atualizaVisivelCpfProcurador();
        this.atualizaVisivelCpfConjuge();
        this.atualizaVisivelRegistroProfissional();
        this.atualizaVisivelProcessoDigital();
        this.atualizaVisivelDataRetorno();
        this.atualizaVisibilidadePerguntaResidente();
        this.habilitarRadioAlteracaoDadosCadastrais();
        this.edtOcupacao.getInformacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelContribuinte.this.atualizaVisivelRegistroProfissional();
            }
        });
        ((JAutoCompleteComboBox)this.edtNatureza.getComponenteEditor()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PainelContribuinte.this.atualizaVisivelProcessoDigital();
                    if (e.getItem().toString().equals("81")) {
                        GuiUtil.mostrarAviso((Component)ControladorGui.getJanelaPrincipal(), (String)MensagemUtil.getMensagem((String)"ocuc_principal_espolio_em_ajuste", (String[])new String[]{String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1)}));
                    } else if (e.getItem().toString().equals("13") || e.getItem().toString().equals("14") || e.getItem().toString().equals("61") || e.getItem().toString().equals("62") || e.getItem().toString().equals("71") || e.getItem().toString().equals("72")) {
                        GuiUtil.mostrarAviso((String)"ocup_principal_desnecessaria");
                    }
                }
            }
        });
        this.telaPronta = true;
    }

    public void preExibir() {
        this.chkDeficiencia.setSelected(IRPFFacade.getInstancia().getContribuinte().getDeficiente().naoFormatado().equals("S"));
    }

    private void atualizaSubPainelEndereco() {
        if (IRPFFacade.getInstancia().getContribuinte().getExterior().naoFormatado().equals(Logico.NAO)) {
            this.flipEndereco.exibeComponenteA();
            this.iRPFLabelInfo4.setVisible(false);
        } else {
            this.flipEndereco.exibeComponenteB();
            this.iRPFLabelInfo4.setVisible(true);
        }
    }

    private void atualizaVisivelNumRecibo() {
        boolean isRetif = this.grpTipoDeclaracao.getInformacao().naoFormatado().equals(Logico.SIM);
        if (isRetif) {
            this.flipRecibo.exibeComponenteA();
        } else {
            this.flipRecibo.exibeComponenteB();
        }
    }

    private void atualizaVisivelCpfProcurador() {
        DeclaracaoIRPF declaracaoAberta = ControladorGui.getDemonstrativoAberto();
        boolean isAjuste = declaracaoAberta.getIdentificadorDeclaracao().isAjuste();
        boolean visibilidade = isAjuste && declaracaoAberta.getContribuinte().getExterior().naoFormatado().equals(Logico.SIM);
        this.lblCpfProcurador.setVisible(visibilidade);
        this.edtCpfProcurador.setVisible(visibilidade);
    }

    private void atualizaVisivelCpfConjuge() {
        DeclaracaoIRPF declaracaoAberta = ControladorGui.getDemonstrativoAberto();
        boolean visibilidade = declaracaoAberta.getContribuinte().getConjuge().naoFormatado().equals(Logico.SIM);
        this.lblCpfConjuge.setVisible(visibilidade);
        this.edtCpfConjuge.setVisible(visibilidade);
    }

    private void atualizaVisivelDataRetorno() {
        DeclaracaoIRPF declaracaoAberta = ControladorGui.getDemonstrativoAberto();
        boolean visibilidade = declaracaoAberta.getContribuinte().getRetornoPais().naoFormatado().equals(Logico.SIM);
        this.lblDataResidente.setVisible(visibilidade);
        this.edtDataResidente.setVisible(visibilidade);
    }

    private void atualizaVisibilidadePerguntaResidente() {
        boolean visibilidade = IRPFFacade.getInstancia().getIdDeclaracaoAberto().isAjuste();
        if (!visibilidade) {
            IRPFFacade.getInstancia().getContribuinte().getRetornoPais().clear();
            IRPFFacade.getInstancia().getContribuinte().getDataRetorno().clear();
            this.grpResidente.getGroup().clearSelection();
        }
        this.lblDataResidente.setVisible(visibilidade);
        this.edtDataResidente.setVisible(visibilidade);
        this.lblPerguntaResidente.setVisible(visibilidade);
        this.rdbSimResidente.setVisible(visibilidade);
        this.rdbNaoResidente.setVisible(visibilidade);
        this.btnMsgResidente.setVisible(visibilidade);
        this.lblInfoNaoResidente.setVisible(visibilidade);
        this.atualizaVisivelDataRetorno();
    }

    private void atualizaVisivelProcessoDigital() {
        DeclaracaoIRPF declaracaoAberta = ControladorGui.getDemonstrativoAberto();
        String codigoNaturezaOcupacaoAtual = declaracaoAberta.getContribuinte().getNaturezaOcupacao().naoFormatado();
        this.edtProcessoDigital.setVisible(false);
        this.lblProcessoDigital.setVisible(false);
        this.iRPFLabelInfo2.setVisible(false);
        if (!codigoNaturezaOcupacaoAtual.equals("62")) {
            this.edtProcessoDigital.setVisible(false);
            this.lblProcessoDigital.setVisible(false);
            this.iRPFLabelInfo2.setVisible(false);
        }
    }

    private void atualizaVisivelRegistroProfissional() {
        DeclaracaoIRPF declaracaoAberta = ControladorGui.getDemonstrativoAberto();
        boolean visibilidade = declaracaoAberta.getContribuinte().isOcupacaoComRegistroProfissionalObrigatorio(declaracaoAberta.getIdentificadorDeclaracao().getTipoDeclaracaoAES().naoFormatado());
        this.lblRegistroProfissional.setVisible(visibilidade);
        this.edtRegistroProfissional.setVisible(visibilidade);
    }

    private void habilitarRadioAlteracaoDadosCadastrais() {
        DeclaracaoIRPF declaracaoAberta = ControladorGui.getDemonstrativoAberto();
        try {
            if (!ControladorGui.emFaseEntrega((boolean)declaracaoAberta.getEmCalamidade()) && this.rdbRetificadora.isSelected()) {
                this.rdbNao.setSelected(this.telaPronta);
                this.rdbSim.setEnabled(false);
                this.rdbNao.setEnabled(false);
            } else {
                this.rdbSim.setEnabled(true);
                this.rdbNao.setEnabled(true);
            }
        }
        catch (AplicacaoException e) {
            e.printStackTrace();
        }
    }

    public String getTituloPainel() {
        return TITULO;
    }

    private void initComponents() {
        this.panelTipoDeclaracao = new JImagemPanel(GuiUtil.getImage((String)"/imagens/IRPF_Box_Retificadora_So_1600px.png").getImage());
        this.lblPerguntaTipo = new JLabel();
        this.grpTipoDeclaracao = new JButtonGroupPanel();
        this.rdbOriginal = new PPGDRadioItem();
        this.lblOriginal = new JLabel();
        this.rdbRetificadora = new PPGDRadioItem();
        this.lblRetificadora = new JLabel();
        this.btnMsgRetif = new JButtonMensagem();
        this.lblLinhaHorizontal = new JLabel();
        this.flipRecibo = new JFlipComponentes();
        this.lblDadosContribuinte = new JLabel();
        this.panelPrincipal = new JPanel();
        this.lblNome = new JLabel();
        this.edtNome = new JEditAlfa();
        this.lblDtNasc = new JLabel();
        this.edtDtNasc = new JEditData();
        this.chkDeficiencia = new JCheckBox();
        this.panelEndereco = new JPanel();
        this.grpEnderecoExterior = new JButtonGroupPanel();
        this.rdbBrasil = new PPGDRadioItem();
        this.rdbExterior = new PPGDRadioItem();
        this.btnMsgExterior = new JButtonMensagem();
        this.lblCpfProcurador = new JLabel();
        this.edtCpfProcurador = new JEditCPF();
        this.flipEndereco = new JFlipComponentes();
        this.iRPFLabelInfo4 = new IRPFLabelInfo(CadastroTabelasIRPF.recuperarMensagemHTML((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00041, (int)500), true);
        this.panelOcupacaoPrincipal = new JPanel();
        this.lblNatureza = new JLabel();
        this.edtNatureza = new JAutoCompleteEditCodigo();
        this.lblOcupacao = new JLabel();
        this.edtOcupacao = new JEditOcupacaoPrincipal();
        this.lblRegistroProfissional = new JLabel();
        this.edtRegistroProfissional = new JEditAlfa();
        this.lblProcessoDigital = new JLabel();
        this.edtProcessoDigital = new JEditCPF();
        this.iRPFLabelInfo2 = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"info_processo_digital"), true);
        this.lblProcessoDigital1 = new JLabel();
        this.edtProcessoDigital1 = new JEditCPF();
        this.iRPFLabelInfo3 = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"info_processo_digital"), true);
        this.iRPFLabelInfo1 = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"info_deficientes"), true);
        this.btnMsgEnderecoDiferente = new JButtonMensagem();
        this.lblEnderecoDiferente = new JLabel();
        this.grpEnderecoDiferente = new JButtonGroupPanel();
        this.rdbSim = new PPGDRadioItem();
        this.rdbNao = new PPGDRadioItem();
        this.iRPFLabelInfoDadosCadastrais = new IRPFLabelInfo(CadastroTabelasIRPF.recuperarMensagemComQuebra((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00502), true);
        this.pnlPerguntaRetorno = new JPanel();
        this.lblPerguntaResidente = new JLabel();
        this.grpResidente = new JButtonGroupPanel();
        this.rdbSimResidente = new PPGDRadioItem();
        this.rdbNaoResidente = new PPGDRadioItem();
        this.btnMsgResidente = new JButtonMensagem();
        this.lblDataResidente = new JLabel();
        this.edtDataResidente = new JEditData();
        this.lblInfoNaoResidente = new JLabel();
        this.pnlPerguntaConjuge = new JPanel();
        this.lblCpfConjuge = new JLabel();
        this.edtCpfConjuge = new JEditCPF();
        this.btnMsgConjuge = new JButtonMensagem();
        this.lblPerguntaConjuge = new JLabel();
        this.grpConjuge = new JButtonGroupPanel();
        this.rdbSimConjuge = new PPGDRadioItem();
        this.rdbNaoConjuge = new PPGDRadioItem();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.panelTipoDeclaracao.setBackground(new Color(255, 255, 255));
        this.panelTipoDeclaracao.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblPerguntaTipo.setFont(FontesUtil.FONTE_TITULO_MAIOR);
        this.lblPerguntaTipo.setForeground(new Color(26, 135, 191));
        this.lblPerguntaTipo.setText("Que tipo de declara\u00e7\u00e3o voc\u00ea deseja fazer?");
        this.grpTipoDeclaracao.setBorder(null);
        this.grpTipoDeclaracao.setFont(FontesUtil.FONTE_NORMAL);
        this.grpTipoDeclaracao.setInformacaoAssociada("contribuinte.declaracaoRetificadora");
        this.grpTipoDeclaracao.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelContribuinte.this.grpTipoDeclaracaoAtualizaPainel(evt);
            }
        });
        this.rdbOriginal.setBackground(new Color(255, 255, 255));
        this.rdbOriginal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbOriginal.setName("rdbOriginal");
        this.rdbOriginal.setValorSelecionadoTrue(Logico.NAO);
        this.rdbOriginal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PainelContribuinte.this.rdbOriginalItemStateChanged(evt);
            }
        });
        this.lblOriginal.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblOriginal.setForeground(new Color(0, 74, 106));
        this.lblOriginal.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icones/ico_Declaracao_Original.png")));
        this.lblOriginal.setText("Declara\u00e7\u00e3o de Ajuste Anual Original");
        this.lblOriginal.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.rdbRetificadora.setBackground(new Color(255, 255, 255));
        this.rdbRetificadora.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbRetificadora.setName("rdbRetificadora");
        this.rdbRetificadora.setValorSelecionadoTrue(Logico.SIM);
        this.rdbRetificadora.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PainelContribuinte.this.rdbRetificadoraItemStateChanged(evt);
            }
        });
        this.lblRetificadora.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblRetificadora.setForeground(new Color(0, 74, 106));
        this.lblRetificadora.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icones/ico_Declaracao_Retificadora.png")));
        this.lblRetificadora.setText("Declara\u00e7\u00e3o Retificadora");
        this.lblRetificadora.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnMsgRetif.setText("jButtonMensagem1");
        GroupLayout grpTipoDeclaracaoLayout = new GroupLayout((Container)this.grpTipoDeclaracao);
        this.grpTipoDeclaracao.setLayout((LayoutManager)grpTipoDeclaracaoLayout);
        grpTipoDeclaracaoLayout.setHorizontalGroup((GroupLayout.Group)grpTipoDeclaracaoLayout.createParallelGroup(1).add((GroupLayout.Group)grpTipoDeclaracaoLayout.createSequentialGroup().addContainerGap(64, Short.MAX_VALUE).add((Component)this.rdbOriginal, -2, 18, -2).addPreferredGap(0).add((Component)this.lblOriginal).add(58, 58, 58).add((Component)this.rdbRetificadora, -2, 15, -2).addPreferredGap(0).add((Component)this.lblRetificadora).addPreferredGap(0).add((Component)this.btnMsgRetif, -2, -1, -2)));
        grpTipoDeclaracaoLayout.setVerticalGroup((GroupLayout.Group)grpTipoDeclaracaoLayout.createParallelGroup(1).add((GroupLayout.Group)grpTipoDeclaracaoLayout.createSequentialGroup().add((GroupLayout.Group)grpTipoDeclaracaoLayout.createParallelGroup(1).add((GroupLayout.Group)grpTipoDeclaracaoLayout.createParallelGroup(3).add((Component)this.rdbOriginal, -2, -1, -2).add((Component)this.lblOriginal).add((Component)this.rdbRetificadora, -2, -1, -2).add((Component)this.lblRetificadora)).add((Component)this.btnMsgRetif, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.rdbOriginal.getAccessibleContext().setAccessibleName("Declara\u00e7\u00e3o de Ajuste Anual Original");
        this.rdbRetificadora.getAccessibleContext().setAccessibleName("Declara\u00e7\u00e3o Retificadora");
        this.lblLinhaHorizontal.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/imagens/IRPF_LinhaDiv_Declaracao650px.png")));
        this.lblLinhaHorizontal.setMaximumSize(new Dimension(300, 17));
        this.lblLinhaHorizontal.setMinimumSize(new Dimension(300, 17));
        this.lblLinhaHorizontal.setPreferredSize(new Dimension(300, 17));
        this.flipRecibo.setBackground(new Color(255, 255, 255));
        this.flipRecibo.setComponenteA((JComponent)new PainelReciboRetif());
        this.flipRecibo.setComponenteB((JComponent)new PainelReciboAnterior());
        this.flipRecibo.setMaximumSize(new Dimension(116, 19));
        this.flipRecibo.setOpaque(false);
        GroupLayout panelTipoDeclaracaoLayout = new GroupLayout((Container)this.panelTipoDeclaracao);
        this.panelTipoDeclaracao.setLayout((LayoutManager)panelTipoDeclaracaoLayout);
        panelTipoDeclaracaoLayout.setHorizontalGroup((GroupLayout.Group)panelTipoDeclaracaoLayout.createParallelGroup(1).add((GroupLayout.Group)panelTipoDeclaracaoLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelTipoDeclaracaoLayout.createParallelGroup(1).add((Component)this.lblPerguntaTipo).add((Component)this.lblLinhaHorizontal, -1, -1, Short.MAX_VALUE).add((Component)this.grpTipoDeclaracao, -2, -1, -2).add((GroupLayout.Group)panelTipoDeclaracaoLayout.createSequentialGroup().add(65, 65, 65).add((Component)this.flipRecibo, -2, 580, -2))).addContainerGap()));
        panelTipoDeclaracaoLayout.setVerticalGroup((GroupLayout.Group)panelTipoDeclaracaoLayout.createParallelGroup(1).add((GroupLayout.Group)panelTipoDeclaracaoLayout.createSequentialGroup().addContainerGap().add((Component)this.lblPerguntaTipo).add(18, 18, 18).add((Component)this.grpTipoDeclaracao, -2, 32, -2).add(0, 0, 0).add((Component)this.lblLinhaHorizontal, -2, 5, -2).addPreferredGap(0).add((Component)this.flipRecibo, -2, 28, -2).addContainerGap()));
        this.lblDadosContribuinte.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblDadosContribuinte.setForeground(new Color(0, 74, 106));
        this.lblDadosContribuinte.setText("Dados do Contribuinte");
        this.panelPrincipal.setBackground(new Color(255, 255, 255));
        this.panelPrincipal.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.panelPrincipal.setMaximumSize(new Dimension(759, 617));
        this.lblNome.setText("Nome");
        this.lblNome.setAlignmentY(0.0f);
        this.edtNome.setInformacaoAssociada("idDeclaracaoAberto.nome");
        this.lblDtNasc.setText("Data de nascimento");
        this.edtDtNasc.setToolTipText("Informe a data de nascimento com dois d\u00edgitos para dia, m\u00eas e quatro para ano");
        this.edtDtNasc.setEstiloFonte(0);
        this.edtDtNasc.setInformacaoAssociada("contribuinte.dataNascimento");
        this.chkDeficiencia.setBackground(new Color(255, 255, 255));
        this.chkDeficiencia.setText("<html>&nbsp;Um dos declarantes \u00e9 pessoa com doen\u00e7a grave&nbsp;ou defici\u00eancia f\u00edsica ou mental?</html>");
        this.chkDeficiencia.setVerticalTextPosition(1);
        this.chkDeficiencia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelContribuinte.this.chkDeficienciaActionPerformed(evt);
            }
        });
        this.panelEndereco.setBackground(new Color(255, 255, 255));
        this.panelEndereco.setBorder(BorderFactory.createTitledBorder(null, "Endere\u00e7o", 1, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.grpEnderecoExterior.setBorder(null);
        this.grpEnderecoExterior.setButtonMensagem(this.btnMsgExterior);
        this.grpEnderecoExterior.setInformacaoAssociada("contribuinte.exterior");
        this.grpEnderecoExterior.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelContribuinte.this.grpEnderecoExteriorAtualizaPainel(evt);
            }
        });
        this.rdbBrasil.setBackground(new Color(255, 255, 255));
        this.rdbBrasil.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbBrasil.setText("Brasil");
        this.rdbBrasil.setValorSelecionadoTrue(Logico.NAO);
        this.rdbExterior.setBackground(new Color(255, 255, 255));
        this.rdbExterior.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbExterior.setText("Exterior");
        this.rdbExterior.setValorSelecionadoTrue(Logico.SIM);
        GroupLayout grpEnderecoExteriorLayout = new GroupLayout((Container)this.grpEnderecoExterior);
        this.grpEnderecoExterior.setLayout((LayoutManager)grpEnderecoExteriorLayout);
        grpEnderecoExteriorLayout.setHorizontalGroup((GroupLayout.Group)grpEnderecoExteriorLayout.createParallelGroup(1).add((GroupLayout.Group)grpEnderecoExteriorLayout.createSequentialGroup().add((Component)this.rdbBrasil, -2, -1, -2).add(18, 18, 18).add((Component)this.rdbExterior, -2, 80, -2).addContainerGap()));
        grpEnderecoExteriorLayout.setVerticalGroup((GroupLayout.Group)grpEnderecoExteriorLayout.createParallelGroup(1).add(2, (GroupLayout.Group)grpEnderecoExteriorLayout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((GroupLayout.Group)grpEnderecoExteriorLayout.createParallelGroup(3).add((Component)this.rdbBrasil, -2, -1, -2).add((Component)this.rdbExterior, -2, -1, -2))));
        this.rdbBrasil.getAccessibleContext().setAccessibleName("Endere\u00e7o no Brasil ");
        this.rdbBrasil.getAccessibleContext().setAccessibleDescription("");
        this.rdbExterior.getAccessibleContext().setAccessibleName("Endere\u00e7o no exterior ");
        this.btnMsgExterior.setText("jButtonMensagem1");
        this.lblCpfProcurador.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCpfProcurador.setText("CPF do procurador residente no Brasil");
        this.edtCpfProcurador.setInformacaoAssociada("contribuinte.cpfProcurador");
        this.flipEndereco.setBackground(new Color(255, 255, 255));
        this.flipEndereco.setComponenteA((JComponent)this.painelEnderecoBrasil);
        this.flipEndereco.setComponenteB((JComponent)this.painelEnderecoExterior);
        this.flipEndereco.setFocusable(false);
        GroupLayout panelEnderecoLayout = new GroupLayout((Container)this.panelEndereco);
        this.panelEndereco.setLayout((LayoutManager)panelEnderecoLayout);
        panelEnderecoLayout.setHorizontalGroup((GroupLayout.Group)panelEnderecoLayout.createParallelGroup(1).add((GroupLayout.Group)panelEnderecoLayout.createSequentialGroup().add((GroupLayout.Group)panelEnderecoLayout.createParallelGroup(1).add((Component)this.flipEndereco, -2, 660, -2).add((GroupLayout.Group)panelEnderecoLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelEnderecoLayout.createParallelGroup(1).add((Component)this.edtCpfProcurador, -2, 169, -2).add((Component)this.lblCpfProcurador).add((GroupLayout.Group)panelEnderecoLayout.createSequentialGroup().add((Component)this.grpEnderecoExterior, -2, -1, -2).addPreferredGap(0).add((Component)this.btnMsgExterior, -2, 12, -2).add(18, 18, 18).add((Component)this.iRPFLabelInfo4, -2, -1, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        panelEnderecoLayout.setVerticalGroup((GroupLayout.Group)panelEnderecoLayout.createParallelGroup(1).add((GroupLayout.Group)panelEnderecoLayout.createSequentialGroup().add((GroupLayout.Group)panelEnderecoLayout.createParallelGroup(1).add((GroupLayout.Group)panelEnderecoLayout.createParallelGroup(1, false).add((Component)this.btnMsgExterior, 0, -1, Short.MAX_VALUE).add((Component)this.grpEnderecoExterior, -1, -1, Short.MAX_VALUE)).add((Component)this.iRPFLabelInfo4, -2, -1, -2)).addPreferredGap(1).add((Component)this.lblCpfProcurador).add(1, 1, 1).add((Component)this.edtCpfProcurador, -2, -1, -2).addPreferredGap(1).add((Component)this.flipEndereco, -1, 149, Short.MAX_VALUE).addContainerGap()));
        this.edtCpfProcurador.getAccessibleContext().setAccessibleName("CPF do procurador residente no Brasil");
        this.panelOcupacaoPrincipal.setBackground(new Color(255, 255, 255));
        this.panelOcupacaoPrincipal.setBorder(BorderFactory.createTitledBorder(null, "Ocupa\u00e7\u00e3o Principal", 1, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.lblNatureza.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNatureza.setText("Natureza da ocupa\u00e7\u00e3o");
        this.edtNatureza.setInformacaoAssociada("contribuinte.naturezaOcupacao");
        this.edtNatureza.setMaximumSize(new Dimension(174, 27));
        this.lblOcupacao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblOcupacao.setText("Ocupa\u00e7\u00e3o principal");
        this.edtOcupacao.setInformacaoAssociada("contribuinte.ocupacaoPrincipal");
        this.edtOcupacao.setMaximumSize(new Dimension(80, 29));
        this.lblRegistroProfissional.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblRegistroProfissional.setText("Registro profissional");
        this.edtRegistroProfissional.setInformacaoAssociada("contribuinte.registroProfissional");
        this.lblProcessoDigital.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblProcessoDigital.setText("Processo Digital");
        this.edtProcessoDigital.setInformacaoAssociada("contribuinte.processoDigital");
        this.edtProcessoDigital.setMascara("*****.******/****-**");
        this.lblProcessoDigital1.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblProcessoDigital1.setText("Processo Digital");
        this.edtProcessoDigital1.setInformacaoAssociada("contribuinte.processoDigital");
        this.edtProcessoDigital1.setMascara("*****.******/****-**");
        GroupLayout panelOcupacaoPrincipalLayout = new GroupLayout((Container)this.panelOcupacaoPrincipal);
        this.panelOcupacaoPrincipal.setLayout((LayoutManager)panelOcupacaoPrincipalLayout);
        panelOcupacaoPrincipalLayout.setHorizontalGroup((GroupLayout.Group)panelOcupacaoPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createSequentialGroup().add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createParallelGroup(1).add(2, (Component)this.edtNatureza, -2, 488, -2).add((Component)this.lblNatureza).add((Component)this.lblOcupacao).add((Component)this.lblRegistroProfissional).add((Component)this.edtRegistroProfissional, -2, 237, -2)).addPreferredGap(0).add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createParallelGroup(1).add((Component)this.lblProcessoDigital).add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createSequentialGroup().add((Component)this.edtProcessoDigital, -2, 168, -2).add(0, 0, 0).add((Component)this.iRPFLabelInfo2, -2, -1, -2)))).add((Component)this.edtOcupacao, -2, 608, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        panelOcupacaoPrincipalLayout.setVerticalGroup((GroupLayout.Group)panelOcupacaoPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createSequentialGroup().add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createParallelGroup(2).add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createSequentialGroup().add((Component)this.lblNatureza).addPreferredGap(0).add((Component)this.edtNatureza, -2, -1, -2)).add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createSequentialGroup().add((Component)this.lblProcessoDigital).addPreferredGap(0).add((GroupLayout.Group)panelOcupacaoPrincipalLayout.createParallelGroup(1, false).add(2, (Component)this.iRPFLabelInfo2, -1, -1, Short.MAX_VALUE).add(2, (Component)this.edtProcessoDigital, -2, -1, -2)))).add(3, 3, 3).add((Component)this.lblOcupacao).addPreferredGap(0).add((Component)this.edtOcupacao, -2, -1, -2).addPreferredGap(0).add((Component)this.lblRegistroProfissional).addPreferredGap(0).add((Component)this.edtRegistroProfissional, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtNatureza.getAccessibleContext().setAccessibleName("Natureza da ocupa\u00e7\u00e3o do contribuinte");
        this.edtRegistroProfissional.getAccessibleContext().setAccessibleName("Registro profissional");
        this.btnMsgEnderecoDiferente.setText("jButtonMensagem1");
        this.lblEnderecoDiferente.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblEnderecoDiferente.setText(" Houve altera\u00e7\u00e3o de dados cadastrais?");
        this.grpEnderecoDiferente.setBorder(null);
        this.grpEnderecoDiferente.setButtonMensagem(this.btnMsgEnderecoDiferente);
        this.grpEnderecoDiferente.setFont(FontesUtil.FONTE_NORMAL);
        this.grpEnderecoDiferente.setInformacaoAssociada("contribuinte.enderecoDiferente");
        this.rdbSim.setBackground(new Color(255, 255, 255));
        this.rdbSim.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbSim.setText("Sim");
        this.rdbSim.setValorSelecionadoTrue(Logico.SIM);
        this.rdbSim.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelContribuinte.this.rdbSimFocusLost(evt);
            }
        });
        this.rdbNao.setBackground(new Color(255, 255, 255));
        this.rdbNao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbNao.setText("N\u00e3o");
        this.rdbNao.setValorSelecionadoTrue(Logico.NAO);
        this.rdbNao.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelContribuinte.this.rdbNaoFocusLost(evt);
            }
        });
        GroupLayout grpEnderecoDiferenteLayout = new GroupLayout((Container)this.grpEnderecoDiferente);
        this.grpEnderecoDiferente.setLayout((LayoutManager)grpEnderecoDiferenteLayout);
        grpEnderecoDiferenteLayout.setHorizontalGroup((GroupLayout.Group)grpEnderecoDiferenteLayout.createParallelGroup(1).add((GroupLayout.Group)grpEnderecoDiferenteLayout.createSequentialGroup().add((Component)this.rdbSim, -2, -1, -2).add(18, 18, 18).add((Component)this.rdbNao, -2, -1, -2).addContainerGap(34, Short.MAX_VALUE)));
        grpEnderecoDiferenteLayout.setVerticalGroup((GroupLayout.Group)grpEnderecoDiferenteLayout.createParallelGroup(1).add((GroupLayout.Group)grpEnderecoDiferenteLayout.createParallelGroup(3).add((Component)this.rdbSim, -2, -1, -2).add((Component)this.rdbNao, -2, -1, -2)));
        this.rdbSim.getAccessibleContext().setAccessibleName("Sim, houve altera\u00e7\u00e3o de dados cadastrais?");
        this.rdbSim.getAccessibleContext().setAccessibleDescription("");
        this.rdbNao.getAccessibleContext().setAccessibleName("N\u00e3o houve altera\u00e7\u00e3o de dados cadastrais?");
        this.pnlPerguntaRetorno.setOpaque(false);
        this.pnlPerguntaRetorno.setPreferredSize(new Dimension(446, 60));
        this.lblPerguntaResidente.setText("[pergunta residente]");
        this.grpResidente.setBorder(null);
        this.grpResidente.setButtonMensagem(this.btnMsgResidente);
        this.grpResidente.setFont(FontesUtil.FONTE_NORMAL);
        this.grpResidente.setInformacaoAssociada("contribuinte.retornoPais");
        this.rdbSimResidente.setBackground(new Color(255, 255, 255));
        this.rdbSimResidente.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbSimResidente.setText("Sim");
        this.rdbSimResidente.setValorSelecionadoTrue(Logico.SIM);
        this.rdbSimResidente.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelContribuinte.this.rdbSimResidenteFocusLost(evt);
            }
        });
        this.rdbSimResidente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelContribuinte.this.rdbSimResidenteActionPerformed(evt);
            }
        });
        this.rdbNaoResidente.setBackground(new Color(255, 255, 255));
        this.rdbNaoResidente.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbNaoResidente.setText("N\u00e3o");
        this.rdbNaoResidente.setValorSelecionadoTrue(Logico.NAO);
        this.rdbNaoResidente.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelContribuinte.this.rdbNaoResidenteFocusLost(evt);
            }
        });
        this.rdbNaoResidente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelContribuinte.this.rdbNaoResidenteActionPerformed(evt);
            }
        });
        GroupLayout grpResidenteLayout = new GroupLayout((Container)this.grpResidente);
        this.grpResidente.setLayout((LayoutManager)grpResidenteLayout);
        grpResidenteLayout.setHorizontalGroup((GroupLayout.Group)grpResidenteLayout.createParallelGroup(1).add(2, (GroupLayout.Group)grpResidenteLayout.createSequentialGroup().add((Component)this.rdbSimResidente, -2, -1, -2).add(18, 18, 18).add((Component)this.rdbNaoResidente, -2, -1, -2).addContainerGap(36, Short.MAX_VALUE)));
        grpResidenteLayout.setVerticalGroup((GroupLayout.Group)grpResidenteLayout.createParallelGroup(1).add((GroupLayout.Group)grpResidenteLayout.createParallelGroup(3).add((Component)this.rdbSimResidente, -2, -1, -2).add((Component)this.rdbNaoResidente, -2, -1, -2)));
        this.rdbNaoResidente.getAccessibleContext().setAccessibleName("N\u00e3o ");
        this.btnMsgResidente.setText("jButtonMensagem1");
        this.lblDataResidente.setText("Data de retorno ao Brasil");
        this.edtDataResidente.setToolTipText("Informe a data de retorno ao Brasil com dois d\u00edgitos para dia, m\u00eas e quatro para ano");
        this.edtDataResidente.setEstiloFonte(0);
        this.edtDataResidente.setInformacaoAssociada("contribuinte.dataRetorno");
        this.lblInfoNaoResidente.setFont(FontesUtil.FONTE_TITULO_MAIOR);
        this.lblInfoNaoResidente.setForeground(new Color(0, 74, 106));
        this.lblInfoNaoResidente.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icones/png16px/info.png")));
        GroupLayout pnlPerguntaRetornoLayout = new GroupLayout((Container)this.pnlPerguntaRetorno);
        this.pnlPerguntaRetorno.setLayout((LayoutManager)pnlPerguntaRetornoLayout);
        pnlPerguntaRetornoLayout.setHorizontalGroup((GroupLayout.Group)pnlPerguntaRetornoLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPerguntaRetornoLayout.createSequentialGroup().add((GroupLayout.Group)pnlPerguntaRetornoLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPerguntaRetornoLayout.createSequentialGroup().add((Component)this.grpResidente, -2, -1, -2).addPreferredGap(0).add((Component)this.btnMsgResidente, -2, -1, -2)).add((GroupLayout.Group)pnlPerguntaRetornoLayout.createSequentialGroup().add((Component)this.lblPerguntaResidente).add(18, 18, 18).add((Component)this.lblInfoNaoResidente))).add(86, 86, 86).add((GroupLayout.Group)pnlPerguntaRetornoLayout.createParallelGroup(1).add((Component)this.edtDataResidente, -2, 158, -2).add((Component)this.lblDataResidente)).addContainerGap(239, Short.MAX_VALUE)));
        pnlPerguntaRetornoLayout.setVerticalGroup((GroupLayout.Group)pnlPerguntaRetornoLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPerguntaRetornoLayout.createSequentialGroup().add((GroupLayout.Group)pnlPerguntaRetornoLayout.createParallelGroup(1).add((Component)this.lblInfoNaoResidente, -2, 16, -2).add((GroupLayout.Group)pnlPerguntaRetornoLayout.createParallelGroup(3).add((Component)this.lblPerguntaResidente).add((Component)this.lblDataResidente, -2, 14, -2))).addPreferredGap(0).add((GroupLayout.Group)pnlPerguntaRetornoLayout.createParallelGroup(1).add((Component)this.btnMsgResidente, -2, -1, -2).add((Component)this.grpResidente, -2, -1, -2).add((Component)this.edtDataResidente, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.lblPerguntaResidente.getAccessibleContext().setAccessibleName("Informou residente?");
        this.edtDataResidente.getAccessibleContext().setAccessibleName("Data de retorno ao Brasil");
        this.pnlPerguntaConjuge.setOpaque(false);
        this.lblCpfConjuge.setText("CPF do c\u00f4njuge ou companheiro(a)");
        this.edtCpfConjuge.setInformacaoAssociada("contribuinte.cpfConjuge");
        this.btnMsgConjuge.setText("jButtonMensagem1");
        this.lblPerguntaConjuge.setText("Possui c\u00f4njuge ou companheiro(a)?");
        this.grpConjuge.setBorder(null);
        this.grpConjuge.setButtonMensagem(this.btnMsgConjuge);
        this.grpConjuge.setFont(FontesUtil.FONTE_NORMAL);
        this.grpConjuge.setInformacaoAssociada("contribuinte.conjuge");
        this.grpConjuge.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelContribuinte.this.grpConjugeAtualizaPainel(evt);
            }
        });
        this.rdbSimConjuge.setBackground(new Color(255, 255, 255));
        this.rdbSimConjuge.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbSimConjuge.setText("Sim");
        this.rdbSimConjuge.setValorSelecionadoTrue(Logico.SIM);
        this.rdbSimConjuge.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelContribuinte.this.rdbSimConjugeFocusLost(evt);
            }
        });
        this.rdbNaoConjuge.setBackground(new Color(255, 255, 255));
        this.rdbNaoConjuge.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbNaoConjuge.setText("N\u00e3o");
        this.rdbNaoConjuge.setValorSelecionadoTrue(Logico.NAO);
        this.rdbNaoConjuge.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelContribuinte.this.rdbNaoConjugeFocusLost(evt);
            }
        });
        GroupLayout grpConjugeLayout = new GroupLayout((Container)this.grpConjuge);
        this.grpConjuge.setLayout((LayoutManager)grpConjugeLayout);
        grpConjugeLayout.setHorizontalGroup((GroupLayout.Group)grpConjugeLayout.createParallelGroup(1).add(2, (GroupLayout.Group)grpConjugeLayout.createSequentialGroup().add((Component)this.rdbSimConjuge, -2, -1, -2).add(18, 18, 18).add((Component)this.rdbNaoConjuge, -2, -1, -2).addContainerGap(36, Short.MAX_VALUE)));
        grpConjugeLayout.setVerticalGroup((GroupLayout.Group)grpConjugeLayout.createParallelGroup(1).add((GroupLayout.Group)grpConjugeLayout.createParallelGroup(3).add((Component)this.rdbSimConjuge, -2, -1, -2).add((Component)this.rdbNaoConjuge, -2, -1, -2)));
        this.rdbSimConjuge.getAccessibleContext().setAccessibleName("Sim, possui c\u00f4njuge ou companheiro(a)?");
        this.rdbSimConjuge.getAccessibleContext().setAccessibleDescription("");
        this.rdbNaoConjuge.getAccessibleContext().setAccessibleName("N\u00e3o possui c\u00f4njuge ou companheiro(a)?");
        GroupLayout pnlPerguntaConjugeLayout = new GroupLayout((Container)this.pnlPerguntaConjuge);
        this.pnlPerguntaConjuge.setLayout((LayoutManager)pnlPerguntaConjugeLayout);
        pnlPerguntaConjugeLayout.setHorizontalGroup((GroupLayout.Group)pnlPerguntaConjugeLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPerguntaConjugeLayout.createSequentialGroup().add((GroupLayout.Group)pnlPerguntaConjugeLayout.createParallelGroup(1).add((Component)this.lblPerguntaConjuge).add((GroupLayout.Group)pnlPerguntaConjugeLayout.createSequentialGroup().add((Component)this.grpConjuge, -2, -1, -2).addPreferredGap(0).add((Component)this.btnMsgConjuge, -2, -1, -2))).add(18, 18, 18).add((GroupLayout.Group)pnlPerguntaConjugeLayout.createParallelGroup(1).add((Component)this.lblCpfConjuge).add((Component)this.edtCpfConjuge, -2, 169, -2)).add(0, 117, Short.MAX_VALUE)));
        pnlPerguntaConjugeLayout.setVerticalGroup((GroupLayout.Group)pnlPerguntaConjugeLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPerguntaConjugeLayout.createSequentialGroup().add((GroupLayout.Group)pnlPerguntaConjugeLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPerguntaConjugeLayout.createSequentialGroup().add((Component)this.lblCpfConjuge, -2, 14, -2).add(2, 2, 2).add((Component)this.edtCpfConjuge, -2, -1, -2)).add((GroupLayout.Group)pnlPerguntaConjugeLayout.createSequentialGroup().add((Component)this.lblPerguntaConjuge).addPreferredGap(0).add((GroupLayout.Group)pnlPerguntaConjugeLayout.createParallelGroup(1).add((Component)this.btnMsgConjuge, -2, -1, -2).add((Component)this.grpConjuge, -2, -1, -2)))).addContainerGap(16, Short.MAX_VALUE)));
        this.edtCpfConjuge.getAccessibleContext().setAccessibleName("CPF do c\u00f4njuge ou companheiro(a)");
        GroupLayout panelPrincipalLayout = new GroupLayout((Container)this.panelPrincipal);
        this.panelPrincipal.setLayout((LayoutManager)panelPrincipalLayout);
        panelPrincipalLayout.setHorizontalGroup((GroupLayout.Group)panelPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)panelPrincipalLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelPrincipalLayout.createParallelGroup(1).add((Component)this.panelEndereco, -1, -1, Short.MAX_VALUE).add((Component)this.panelOcupacaoPrincipal, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)panelPrincipalLayout.createSequentialGroup().add((GroupLayout.Group)panelPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)panelPrincipalLayout.createSequentialGroup().add((GroupLayout.Group)panelPrincipalLayout.createParallelGroup(1).add((Component)this.lblDtNasc).add((GroupLayout.Group)panelPrincipalLayout.createSequentialGroup().add((Component)this.edtDtNasc, -2, 158, -2).add(18, 18, 18).add((Component)this.chkDeficiencia, -2, -1, -2))).add(18, 18, 18).add((Component)this.iRPFLabelInfo1, -2, -1, -2)).add((Component)this.edtNome, -2, 698, -2).add((Component)this.lblNome).add((GroupLayout.Group)panelPrincipalLayout.createSequentialGroup().add((Component)this.grpEnderecoDiferente, -2, -1, -2).addPreferredGap(0).add((Component)this.btnMsgEnderecoDiferente, -2, -1, -2)).add((GroupLayout.Group)panelPrincipalLayout.createSequentialGroup().add((Component)this.lblEnderecoDiferente).add(18, 18, 18).add((Component)this.iRPFLabelInfoDadosCadastrais, -2, -1, -2)).add((Component)this.pnlPerguntaConjuge, -2, -1, -2).add((Component)this.pnlPerguntaRetorno, -2, 677, -2)).add(0, 21, Short.MAX_VALUE))).addContainerGap()));
        panelPrincipalLayout.setVerticalGroup((GroupLayout.Group)panelPrincipalLayout.createParallelGroup(1).add(2, (GroupLayout.Group)panelPrincipalLayout.createSequentialGroup().addContainerGap().add((Component)this.lblNome, -2, 16, -2).add(2, 2, 2).add((Component)this.edtNome, -2, -1, -2).addPreferredGap(1).add((Component)this.lblDtNasc).add((GroupLayout.Group)panelPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)panelPrincipalLayout.createSequentialGroup().add(2, 2, 2).add((Component)this.edtDtNasc, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)panelPrincipalLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.chkDeficiencia, -2, -1, -2)).add(2, (GroupLayout.Group)panelPrincipalLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.iRPFLabelInfo1, -2, -1, -2))).add(10, 10, 10).add((GroupLayout.Group)panelPrincipalLayout.createParallelGroup(1).add(2, (Component)this.lblEnderecoDiferente, -2, 13, -2).add(2, (Component)this.iRPFLabelInfoDadosCadastrais, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panelPrincipalLayout.createParallelGroup(2).add((Component)this.grpEnderecoDiferente, -2, -1, -2).add((Component)this.btnMsgEnderecoDiferente, -2, 18, -2)).addPreferredGap(0).add((Component)this.pnlPerguntaConjuge, -2, -1, -2).add(0, 0, 0).add((Component)this.pnlPerguntaRetorno, -2, -1, -2).add(0, 0, 0).add((Component)this.panelEndereco, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.panelOcupacaoPrincipal, -2, -1, -2).addContainerGap()));
        panelPrincipalLayout.linkSize(new Component[]{this.edtDtNasc, this.edtNome}, 2);
        this.edtNome.getAccessibleContext().setAccessibleName("Nome do contribuinte");
        this.edtDtNasc.getAccessibleContext().setAccessibleName("Data de nascimento do contribuinte");
        this.chkDeficiencia.getAccessibleContext().setAccessibleName("Um dos declarantes \u00e9 pessoa com doen\u00e7a grave ou portadora de defici\u00eancia f\u00edsica ou mental?");
        this.chkDeficiencia.getAccessibleContext().setAccessibleDescription(MensagemUtil.getMensagem((String)"info_deficientes"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.panelTipoDeclaracao, -1, -1, Short.MAX_VALUE).add((Component)this.lblDadosContribuinte).add((Component)this.panelPrincipal, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.panelTipoDeclaracao, -2, -1, -2).addPreferredGap(0).add((Component)this.lblDadosContribuinte).addPreferredGap(0).add((Component)this.panelPrincipal, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void grpTipoDeclaracaoAtualizaPainel(GroupPanelEvent evt) {
        this.atualizaVisivelNumRecibo();
    }

    private void rdbRetificadoraItemStateChanged(ItemEvent evt) {
        if (this.telaPronta && evt.getStateChange() == 1) {
            if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isAjuste()) {
                GuiUtil.mostrarAviso((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)MensagemUtil.getMensagem((String)"retificacao_nao_admitida"));
            }
            try {
                Date dataAtual = (Date)GuiUtil.executarTarefa((String)"Obtendo data atual...", (int)5, BarramentoIRPFService::obterDataServidor);
                IRPFFacade.getInstancia().getDeclaracao().getIdentificadorDeclaracao().getDataCriacao().setConteudo(dataAtual);
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.toString());
            }
            this.habilitarRadioAlteracaoDadosCadastrais();
        }
    }

    private void rdbNaoConjugeFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbNaoConjuge) {
            this.grpConjuge.chamaValidacao();
        }
    }

    private void rdbSimConjugeFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbSimConjuge) {
            this.grpConjuge.chamaValidacao();
        }
    }

    private void rdbNaoFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbSim) {
            this.grpEnderecoDiferente.chamaValidacao();
        }
    }

    private void rdbSimFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbNao) {
            this.grpEnderecoDiferente.chamaValidacao();
        }
    }

    private void grpConjugeAtualizaPainel(GroupPanelEvent evt) {
        this.atualizaVisivelCpfConjuge();
    }

    private void grpEnderecoExteriorAtualizaPainel(GroupPanelEvent evt) {
        this.atualizaSubPainelEndereco();
        this.atualizaVisivelCpfProcurador();
        if (this.telaPronta && this.rdbExterior.isSelected()) {
            GuiUtil.mostrarInfoHTML((String)CadastroTabelasIRPF.recuperarMensagemHTML((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00041, (int)500));
        }
        this.atualizaVisibilidadePerguntaResidente();
    }

    private void chkDeficienciaActionPerformed(ActionEvent evt) {
        IRPFFacade.getInstancia().getContribuinte().getDeficiente().setConteudo(this.chkDeficiencia.isSelected() ? "S" : "N");
    }

    private void rdbSimResidenteActionPerformed(ActionEvent evt) {
        IRPFFacade.getInstancia().getContribuinte().getRetornoPais().setConteudo(this.rdbSimResidente.isSelected() ? Logico.SIM : Logico.NAO);
        this.atualizaVisivelDataRetorno();
    }

    private void rdbNaoResidenteActionPerformed(ActionEvent evt) {
        IRPFFacade.getInstancia().getContribuinte().getRetornoPais().setConteudo(this.rdbNaoResidente.isSelected() ? Logico.NAO : Logico.SIM);
        this.atualizaVisivelDataRetorno();
    }

    private void rdbNaoResidenteFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbNaoResidente) {
            this.grpResidente.chamaValidacao();
        }
    }

    private void rdbSimResidenteFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbSimResidente) {
            this.grpResidente.chamaValidacao();
        }
    }

    private void rdbOriginalItemStateChanged(ItemEvent evt) {
        if (this.telaPronta && evt.getStateChange() == 1) {
            this.habilitarRadioAlteracaoDadosCadastrais();
        }
    }

    public JComponent getDefaultFocus() {
        return this.grpTipoDeclaracao;
    }
}

