/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.bens;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditNI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.bens.ItemPercentualParticipacaoInventario;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.herdeiros.Herdeiro;
import serpro.ppgd.irpf.herdeiros.Herdeiros;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;

public class PainelPercentualParticipacaoInventarioDetalhe
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ItemPercentualParticipacaoInventario percentualEdicao;
    private ItemPercentualParticipacaoInventario percentualOriginal;
    private JButton btnCancelar;
    private JButton btnOk;
    private JAutoCompleteEditNI cmbNI;
    private JEditValor edtPercentagem;
    private IRPFLabelInfo iRPFLabelInfo1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JPanel jPanel1;

    public PainelPercentualParticipacaoInventarioDetalhe() {
        this.initComponents();
        this.inibirEnterNavegacaoFocoBotoes();
    }

    public PainelPercentualParticipacaoInventarioDetalhe(ItemPercentualParticipacaoInventario percentual) {
        this();
        this.percentualOriginal = new ItemPercentualParticipacaoInventario();
        this.percentualEdicao = percentual;
        this.copiarInformacao(this.percentualEdicao, this.percentualOriginal);
        this.associarInformacao(this.percentualEdicao);
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.btnOk.setFocusTraversalKeys(0, set);
        this.btnCancelar.setFocusTraversalKeys(0, set);
    }

    protected void associarInformacao(ItemPercentualParticipacaoInventario percentual) {
        this.cmbNI.setInformacao((Informacao)percentual.getNi());
        this.edtPercentagem.setInformacao((Informacao)percentual.getPercentual());
    }

    protected void copiarInformacao(ItemPercentualParticipacaoInventario original, ItemPercentualParticipacaoInventario copia) {
        copia.getNi().setConteudo(original.getNi());
        copia.getPercentual().setConteudo((Valor)original.getPercentual());
        copia.getNome().setConteudo(original.getNome());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.edtPercentagem = new JEditValor();
        this.cmbNI = new JAutoCompleteEditNI();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.iRPFLabelInfo1 = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Herdeiros/Meeiro"}));
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel2.setText("CPF/CNPJ");
        this.jLabel4.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel4.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel4.setText("Percentual");
        this.cmbNI.setDados(CadastroTabelasIRPF.recuperarHerdeiros());
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPercentualParticipacaoInventarioDetalhe.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPercentualParticipacaoInventarioDetalhe.this.btnCancelarActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.cmbNI, -1, 551, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.iRPFLabelInfo1, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtPercentagem, -2, 82, -2).addComponent(this.jLabel4))).addGroup(jPanel1Layout.createSequentialGroup().addGap(182, 182, 182).addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancelar))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.btnCancelar, this.btnOk);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.iRPFLabelInfo1, -2, -1, -2)).addGap(2, 2, 2).addComponent((Component)this.cmbNI, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(1, 1, 1).addComponent((Component)this.edtPercentagem, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.btnOk).addComponent(this.btnCancelar)).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtPercentagem.getAccessibleContext().setAccessibleName("Percentual de Participa\u00e7\u00e3o");
        this.cmbNI.getAccessibleContext().setAccessibleName("CPF/CNPJ do Participante");
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Dados do Percentual do Participante no Invent\u00e1rio");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(35, Short.MAX_VALUE)));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.cmbNI.getInformacao().validar();
        this.edtPercentagem.getInformacao().validar();
        if (!this.edtPercentagem.getInformacao().isValido()) {
            String msg = this.edtPercentagem.getInformacao().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao();
            GuiUtil.mostrarInfo((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)msg);
            this.edtPercentagem.getComponenteFoco().requestFocusInWindow();
        } else if (!this.cmbNI.getInformacao().isValido()) {
            String msg = this.cmbNI.getInformacao().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao();
            GuiUtil.mostrarInfo((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)msg);
            this.cmbNI.getComponenteFoco().requestFocusInWindow();
        } else {
            Herdeiros col = IRPFFacade.getInstancia().getHerdeiros();
            String ni = this.percentualEdicao.getNi().naoFormatado();
            for (Herdeiro d : col.itens()) {
                if (!d.getNiHerdeiro().naoFormatado().equals(ni)) continue;
                this.percentualEdicao.getNome().setConteudo(d.getNome().naoFormatado());
                break;
            }
            ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        this.copiarInformacao(this.percentualOriginal, this.percentualEdicao);
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }
}

