/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.bens;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.xbeans.GroupPanelEvent;
import serpro.ppgd.gui.xbeans.GroupPanelListener;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.JEditMascara;
import serpro.ppgd.gui.xbeans.JEditMemo;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.JFlipComponentes;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboBox;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.TransferFocus;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalheEspolioBrasil;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalheEspolioExterior;
import serpro.ppgd.irpf.gui.bens.PainelPercentualParticipacaoInventarioLista;
import serpro.ppgd.irpf.gui.bens.PainelQuadroAuxiliarProprietariosUsufrutuariosLista;
import serpro.ppgd.irpf.gui.bens.PainelSelecaoCodigoBem;
import serpro.ppgd.irpf.gui.bens.PainelSelecaoGrupoCodigoBem;
import serpro.ppgd.irpf.gui.componente.JTaskAction;
import serpro.ppgd.irpf.gui.dialogs.PainelHtmlText;
import serpro.ppgd.irpf.gui.rendIsentos.PainelAbaRendIsentosDetalhes;
import serpro.ppgd.irpf.gui.rendIsentos.PainelDadosRendIsentos;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.PainelAbaRendTributEclusivaDetalhes;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.PainelDadosRendTributExclusiva;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.resumo.CalculoImposto;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class PainelBensDetalheEspolio
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Bens e Direitos";
    private static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Bens e Direitos";
    private Bem bem = null;
    private Bem itemInicial = null;
    private PainelBensDetalheEspolioBrasil painelImovelBrasil = new PainelBensDetalheEspolioBrasil();
    private PainelBensDetalheEspolioExterior painelImovelExterior = new PainelBensDetalheEspolioExterior();
    private ActionListener listenerPais = null;
    private ActionListener listenerGrupo = null;
    private ActionListener listenerCodigo = null;
    private boolean emEdicao;
    private int indiceRollback = -1;
    private JButton btProprietarioUsufrutuario;
    private JButton btnPercentualParticipacao;
    private JButton btnReclassificar;
    private JButton btnRendExclusivo;
    private JButton btnRendIsento;
    private JButton btnRepetir;
    private JCheckBox chkAtualizacaoValorBem;
    private JCheckBox chkBemComUsufruto;
    private JCheckBox chkBemInventariar;
    private JCheckBox chkContaPagamento;
    private JEditMascara edtAgencia;
    private JEditValor edtAreaTotal;
    private JEditAlfa edtBairro;
    private JAutoCompleteEditCodigo edtBanco;
    private JEditAlfa edtCodNegociacao;
    private JAutoCompleteEditCodigo edtCodigoBem;
    private JAutoCompleteEditCodigo edtCodigoCripto;
    private JEditAlfa edtComplemento;
    private JEditMascara edtConta;
    private JEditAlfa edtDV;
    private JEditData edtDataAquisicao;
    private JEditMemo edtDiscriminacao;
    private JAutoCompleteEditCodigo edtGrupo;
    private JEditValor edtImpostoExteriorIRRF;
    private JEditValor edtImpostoPagoExt;
    private JAutoCompleteEditCodigo edtLocalizacao;
    private JEditAlfa edtLogradouro;
    private JEditValor edtLucroPrejuizo;
    private JEditAlfa edtMatriculaImovel;
    private JButtonGroupPanel edtNegociadoBolsa;
    private JEditNI edtNiBem;
    private JEditAlfa edtNomeCartorio;
    private JEditAlfa edtNumero;
    private JEditMascara edtNumeroRegistroBem;
    private JEditValor edtPercentualParticipacao;
    private JButtonGroupPanel edtRegistroCartorio;
    private JButtonGroupPanel edtUnidade;
    private JEditValor edtValorAnterior;
    private JEditValor edtValorAtual;
    private JEditValor edtValorRecebido;
    private JFlipComponentes flpLocalizacao;
    private JButtonGroupPanel grpAutoCustodiante;
    private JButtonGroupPanel grpProprietarioUsufrutuario;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel lbRepetir;
    private JLabel lbSituacaoAnoAnterior;
    private JLabel lbSituacaoAnoAtual;
    private JLabel lblAgencia;
    private JLabel lblAreaTotal;
    private JLabel lblAutoCustodiante;
    private JLabel lblBairro;
    private JLabel lblBanco;
    private JLabel lblCodCripto;
    private JLabel lblCodNegociacao;
    private JLabel lblComplemento;
    private JLabel lblConta;
    private JLabel lblDV;
    private JLabel lblDataAquisicao;
    private JLabel lblImpostoExteriorIRRF;
    private JLabel lblImpostoPagoExt;
    private IRPFLabelInfo lblInfo;
    private IRPFLabelInfo lblInfoIPTU;
    private JLabel lblLogradouro;
    private JLabel lblLucroPrejuizo;
    private JLabel lblMatricula;
    private JLabel lblMsgDepositoRemunerado;
    private JLabel lblNegociacao;
    private JLabel lblNiBem;
    private JLabel lblNomeCartorio;
    private JLabel lblNumero;
    private JLabel lblNumeroRegistroBem;
    private JLabel lblProprietarioUsufrutuario;
    private JLabel lblRegistrado;
    private JLabel lblUnidade;
    private JLabel lblValorRecebido;
    private JButtonMensagem msgRegistrado;
    private JButtonMensagem msgRegistrado1;
    private JButtonMensagem msgUnidade;
    private JPanel pnlAplicacaoFinanceira;
    private JPanel pnlDadosBancarios;
    private JPanel pnlDadosBemImovel;
    private JPanel pnlLucrosDividendos;
    private JPanel pnlNegociacaoBolsa;
    private JPanel pnlRendimentos;
    private PPGDRadioItem rdbAutoCustodianteNao;
    private PPGDRadioItem rdbAutoCustodianteSim;
    private PPGDRadioItem rdbProprietario;
    private PPGDRadioItem rdbUsufrutuario;
    private PPGDRadioItem rdoNegociadoBolsaNao;
    private PPGDRadioItem rdoNegociadoBolsaSim;
    private PPGDRadioItem rdoRegistroCartorioNao;
    private PPGDRadioItem rdoRegistroCartorioSim;
    private PPGDRadioItem rdoUnidadeHa;
    private PPGDRadioItem rdoUnidadeM2;

    public PainelBensDetalheEspolio() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
        this.edtPercentualParticipacao.getComponenteEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent() == PainelBensDetalheEspolio.this.btnPercentualParticipacao) {
                    ((JComponent)e.getSource()).transferFocus();
                } else {
                    PainelBensDetalheEspolio.this.btnPercentualParticipacao.requestFocusInWindow();
                }
            }
        });
        this.addListenerLei14754(this.edtLucroPrejuizo, CodigoTabelaMensagens.CODIGO_00520);
        this.addListenerLei14754(this.edtImpostoPagoExt, CodigoTabelaMensagens.CODIGO_00521);
        this.addListenerLei14754(this.edtValorRecebido, CodigoTabelaMensagens.CODIGO_00522);
        this.addListenerLei14754(this.edtImpostoExteriorIRRF, CodigoTabelaMensagens.CODIGO_00523);
    }

    public PainelBensDetalheEspolio(Bem bem, boolean emEdicao) {
        this();
        this.bem = bem;
        this.emEdicao = emEdicao;
        if (emEdicao) {
            this.itemInicial = bem.obterCopia();
        }
        PPGDRadioItem radioVazioRegistroCartorio = new PPGDRadioItem();
        radioVazioRegistroCartorio.setText("Vazio");
        radioVazioRegistroCartorio.setValorSelecionadoTrue("2");
        this.edtRegistroCartorio.adicionaOpcao((Component)radioVazioRegistroCartorio);
        PPGDRadioItem radioVazioUnidade = new PPGDRadioItem();
        radioVazioUnidade.setText("Vazio");
        radioVazioUnidade.setValorSelecionadoTrue("2");
        this.edtUnidade.adicionaOpcao((Component)radioVazioUnidade);
        this.associarInformacao(bem);
        this.painelImovelBrasil.associarInformacao(bem);
        this.painelImovelExterior.associaInformacao(bem);
        this.habilitarPainelBemImovel(bem.getGrupo().naoFormatado(), bem.getCodigo().naoFormatado(), this.getBem().getPais().naoFormatado());
        this.alteraPainelLocalizacaoBemImovel(bem.getGrupo().naoFormatado(), bem.getCodigo().naoFormatado(), bem.getPais().naoFormatado());
        this.habilitarPaineisAplicacaoFinanceiraLucrosDividendos(bem.getGrupo().naoFormatado(), bem.getCodigo().naoFormatado(), bem.getPais().naoFormatado());
        this.configurarComboGrupo();
        this.configurarComboCodigo();
        this.configurarComboPais();
        final JComboBox j = (JComboBox)this.edtBanco.getComponenteEditor();
        j.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (j.getSelectedItem() != null) {
                    PainelBensDetalheEspolio.this.configurarExibicaoInfoConta();
                }
            }
        });
        final Codigo banco = bem.getBanco();
        banco.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (nomePropriedade.equals("Banco")) {
                    PainelBensDetalheEspolio.this.configuraNumeroCaracteresDV(banco.naoFormatado());
                    PainelBensDetalheEspolio.this.configurarContaCorrente(banco);
                    PainelBensDetalheEspolio.this.configurarExibicaoInfoConta();
                }
            }
        });
        this.configurarContaCorrente(banco);
        this.configuraNumeroCaracteresDV(banco.naoFormatado());
        this.configurarExibicaoInfoConta();
        this.habilitarRadioProprietarioUsufrutuario();
        this.edtUnidade.setButtonMensagem(this.msgUnidade);
        this.edtRegistroCartorio.setButtonMensagem(this.msgRegistrado);
        this.mostrarCampoIndicadorBemInventariar();
        this.habilitarBotaoPercentualParticipacao();
        this.habilitarBotoesRendimento(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado());
        this.atualizarComboPais(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado());
        this.configurarMensagemReservaRemunerada(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), this.getBem().getPais().naoFormatado());
        TransferFocus.patch((Component)this.edtDiscriminacao.getComponenteFoco());
        this.chkBemComUsufruto.setVisible(false);
        this.lblProprietarioUsufrutuario.setVisible(false);
        this.grpProprietarioUsufrutuario.setVisible(false);
        this.btProprietarioUsufrutuario.setVisible(false);
    }

    private void addListenerLei14754(JEditValor campoValor, final CodigoTabelaMensagens codigo) {
        campoValor.getComponenteEditor().addFocusListener(new FocusAdapter(){
            private boolean flag = true;

            @Override
            public void focusGained(FocusEvent e) {
                if (this.flag) {
                    new Thread(){

                        @Override
                        public void run() {
                            GuiUtil.exibeDialog((JComponent)new PainelHtmlText(CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)codigo)), (boolean)true, (String)"Aviso", (boolean)false);
                        }
                    }.start();
                }
                this.flag = !this.flag;
            }
        });
    }

    private void exibirMensagem524ou525(final String grupo, final String pais) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!(grupo == null || pais == null || "105".equals(pais) || "".equals(pais.trim()) || PainelBensDetalheEspolio.this.bem.isBemApenasBrasil(grupo, PainelBensDetalheEspolio.this.bem.getCodigo().naoFormatado()))) {
                    if ("01".equals(grupo) || "02".equals(grupo) || "04".equals(grupo) || "05".equals(grupo) || "06".equals(grupo) || "08".equals(grupo) || "99".equals(grupo)) {
                        GuiUtil.exibeDialog((JComponent)new PainelHtmlText(CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00524)), (boolean)true, (String)"Aviso", (boolean)false);
                    } else if ("03".equals(grupo) || "07".equals(grupo)) {
                        String msg525 = CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00525);
                        if ("Aviso 1".equals(msg525)) {
                            msg525 = "&lt;b&gt;Aten\u00e7\u00e3o 1&lt;/b&gt;: Dever\u00e3o ser observadas as determina\u00e7\u00f5es dos arts. 5\u00ba a 9\u00ba da Lei n\u00ba 14.754, de 2023, e dos arts. 13 a 40 da Instru\u00e7\u00e3o Normativa RFB n\u00ba 2.180, de 2024 no caso de investimentos em pessoas jur\u00eddicas ou outras entidades no exterior nas quais o contribuinte detenha o controle (por exemplo, participa\u00e7\u00e3o acima de 50%) e tais investidas:&lt;/p&gt;&lt;ul style='list-style-type:none'&gt;&lt;li&gt;(i) estejam localizadas em pa\u00eds com tributa\u00e7\u00e3o favorecida ou sejam benefici\u00e1rias de regime fiscal privilegiado; ou&lt;/li&gt;&lt;li&gt;(ii) apurem renda ativa pr\u00f3pria inferior a 60% da renda total, ainda que n\u00e3o estejam em tais localiza\u00e7\u00f5es ou n\u00e3o sejam benefici\u00e1rias de tais regimes.&lt;/li&gt;&lt;/ul&gt;&lt;b&gt;Aten\u00e7\u00e3o 2&lt;/b&gt;: As participa\u00e7\u00f5es em controladas no exterior que sejam controladas indiretas e estejam sujeitas ao regime de tributa\u00e7\u00e3o autom\u00e1tica previsto na Lei n\u00ba 14.754, de 2023, dever\u00e3o ser inclu\u00eddas como &quot;bem e direto&quot;.&lt;br&gt;&lt;br&gt;&lt;b&gt;Aten\u00e7\u00e3o 3&lt;/b&gt;: Nos casos referidos acima, devem ser informadas no campo &quot;Discrimina\u00e7\u00e3o&quot; as informa\u00e7\u00f5es relevantes do investimento no exterior para fins de aplica\u00e7\u00e3o da referida Lei, incluindo:&lt;ul style='list-style-type:none'&gt;&lt;li&gt;(i)\tpercentual de participa\u00e7\u00e3o na investida e se \u00e9 uma controlada direta ou indireta;&lt;/li&gt;&lt;li&gt;(ii)\tindicar se \u00e9 uma controlada indireta, detida por meio de uma controlada direta sujeita ao regime de transpar\u00eancia fiscal previsto nos arts. 36 a 49 da IN RFB 2.180, de 2023, ou detida por meio de um trust no exterior;&lt;/li&gt;&lt;li&gt;(iii)\to percentual de renda ativa, caso a investida n\u00e3o esteja localizada em pa\u00eds com tributa\u00e7\u00e3o favorecida, ou seja, benefici\u00e1ria de regime fiscal privilegiado;&lt;/li&gt;&lt;li&gt;(iv)\tdata de aquisi\u00e7\u00e3o;&lt;/li&gt;&lt;li&gt;(v)\to valor dos lucros ou preju\u00edzos acumulados registrados na contabilidade e apurados at\u00e9 31/12/2023;&lt;/li&gt;&lt;li&gt;(vi)\to valor dos lucros distribu\u00eddos no ano-calend\u00e1rio para o contribuinte, se houver, e indicar se correspondem ou n\u00e3o a lucros acumulados registrados na contabilidade e apurados at\u00e9 31/12/2023;&lt;/li&gt;&lt;li&gt;(vii)\to valor dos lucros recebidos pela investida de outras controladas no ano-calend\u00e1rio, se houver, indicando a raz\u00e3o social da controlada e sua localiza\u00e7\u00e3o;&lt;/li&gt;&lt;li&gt;(viii)\to valor do preju\u00edzo apurado no ano-calend\u00e1rio pela investida, se for o caso;&lt;/li&gt;&lt;li&gt;(ix)\tinformar se a investida foi submetida ou n\u00e3o ao regime de atualiza\u00e7\u00e3o previsto no art. 50 da IN RFB n\u00ba 2.180, de 2023;&lt;/li&gt;&lt;li&gt;(x)\tinformar o valor dos saldos registrados em 31 de dezembro de 2024 na conta de &quot;resultados abrangentes&quot;, fora do resultado do exerc\u00edcio. Destaca-se que o registro de valores em &quot;resultados abrangentes&quot; poder\u00e1 ser posteriormente sujeito \u00e0 fiscaliza\u00e7\u00e3o com especial rigor.&lt;/li&gt;&lt;/ul&gt;&lt;a HREF='https://www.gov.br/fazenda/pt-br/acesso-a-informacao/perguntas-frequentes/tributacao-offshore/29-4-24-perguntas-e-respostas-offshores-lei-14-754-e-in-rfb-2-180.pdf'&gt;Clique aqui&lt;/a&gt; para mais informa\u00e7\u00f5es";
                        }
                        GuiUtil.exibeDialog((JComponent)new PainelHtmlText(msg525, 800, 400), (boolean)true, (String)"Aviso", (boolean)false);
                    }
                }
            }
        });
    }

    private void trocaPais(String pais) {
        this.habilitarBotoesRendimento(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado());
        this.alteraPainelLocalizacaoBemImovel(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais);
        this.habilitarPainelBemImovel(this.bem.getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais);
        this.habilitarPainelRegistroBem(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais);
        this.habilitarCampoNI(this.bem.getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais, this.getBem().getIndicadorAutoCustodiante().naoFormatado());
        this.habilitarCampoBanco(pais, this.bem.getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado());
        this.habilitarPaineisAplicacaoFinanceiraLucrosDividendos(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado(), pais);
        this.configurarExibicaoInfoConta();
        if (!"105".equals(this.getBem().getPais().naoFormatado()) && !this.getBem().getIndicadorReclassificar().naoFormatado().equals("1")) {
            this.edtNumeroRegistroBem.setConteudo("");
            this.edtNiBem.setConteudo("");
        }
        this.configurarMensagemReservaRemunerada(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), pais);
    }

    private void configurarExibicaoInfoConta() {
        if (this.getBem().getBanco().isVazio()) {
            this.lblInfo.setVisible(false);
        } else if (this.lblInfo.getMensagem().isBlank()) {
            this.lblInfo.setVisible(false);
        } else {
            this.lblInfo.setVisible(true);
            this.mensagemInformacaoContaAcessivel();
        }
    }

    private void associarInformacao(Bem bem) {
        this.habilitarPainelRegistroBem(bem.getGrupo().naoFormatado(), bem.getCodigo().toString(), bem.getPais().toString());
        this.habilitarCampoDataAquisicao(bem.getGrupo().naoFormatado(), bem.getCodigo().toString());
        this.habilitarCampoNI(this.getBem().getGrupo().naoFormatado(), bem.getCodigo().toString(), bem.getPais().toString(), this.getBem().getIndicadorAutoCustodiante().naoFormatado());
        this.habilitarPainelDadosBancarios(this.getBem().getGrupo().naoFormatado(), bem.getCodigo().toString());
        this.habilitarPainelNegociacao(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().toString());
        this.habilitarCamposCriptoativos(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().toString());
        this.habilitarPaineisAplicacaoFinanceiraLucrosDividendos(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().toString(), bem.getPais().toString());
        this.habilitaInformacaoCPFCNPJProprietarioUsufrutuario(this.getBem().getIndicadorProprietarioUsufrutuario().naoFormatado());
        this.edtGrupo.setInformacao((Informacao)bem.getGrupo());
        this.edtCodigoBem.setInformacao((Informacao)bem.getCodigo());
        this.edtLocalizacao.setInformacao((Informacao)bem.getPais());
        this.edtDiscriminacao.setInformacao((Informacao)bem.getDiscriminacao());
        this.edtValorAnterior.setInformacao((Informacao)bem.getValorExercicioAnterior());
        this.edtValorAtual.setInformacao((Informacao)bem.getValorExercicioAtual());
        this.edtNumeroRegistroBem.setInformacao((Informacao)bem.getRegistroBem());
        if ("00000000".equals(bem.getDataAquisicao().naoFormatado())) {
            bem.getDataAquisicao().clear();
        }
        this.edtDataAquisicao.setInformacao((Informacao)bem.getDataAquisicao());
        this.edtPercentualParticipacao.setInformacao((Informacao)bem.getValorExercicioAnteriorAssociadoJButton());
        this.edtLogradouro.setInformacao((Informacao)bem.getLogradouro());
        this.edtNumero.setInformacao((Informacao)bem.getNumero());
        this.edtComplemento.setInformacao((Informacao)bem.getComplemento());
        this.edtBairro.setInformacao((Informacao)bem.getBairro());
        this.edtRegistroCartorio.setInformacao((Informacao)bem.getRegistrado());
        this.edtMatriculaImovel.setInformacao((Informacao)bem.getMatricula());
        this.edtAreaTotal.setInformacao((Informacao)bem.getAreaTotal());
        this.edtUnidade.setInformacao((Informacao)bem.getUnidade());
        this.edtNomeCartorio.setInformacao((Informacao)bem.getNomeCartorio());
        this.edtNiBem.setInformacao((Informacao)bem.getNiEmpresa());
        this.edtAgencia.setInformacao((Informacao)bem.getAgencia());
        this.edtConta.setInformacao((Informacao)bem.getConta());
        this.edtDV.setInformacao((Informacao)bem.getDVConta());
        this.edtBanco.setInformacao((Informacao)bem.getBanco());
        this.chkBemInventariar.setSelected(bem.getIndicadorBemInventariar().naoFormatado().equals("1"));
        this.edtNegociadoBolsa.setInformacao((Informacao)bem.getNegociadoBolsa());
        this.edtCodNegociacao.setInformacao((Informacao)bem.getCodigoNegociacao());
        this.grpAutoCustodiante.setInformacao((Informacao)bem.getIndicadorAutoCustodiante());
        this.edtLucroPrejuizo.setInformacao((Informacao)bem.getLucroPrejuizo());
        this.edtImpostoPagoExt.setInformacao((Informacao)bem.getImpostoPagoExterior());
        this.edtValorRecebido.setInformacao((Informacao)bem.getValorRecebido());
        this.edtImpostoExteriorIRRF.setInformacao((Informacao)bem.getImpostoPagoExteriorIRRF());
        this.chkBemComUsufruto.setSelected(bem.getIndicadorBemComUsufruto().naoFormatado().equals("1"));
        this.grpProprietarioUsufrutuario.setInformacao((Informacao)bem.getIndicadorProprietarioUsufrutuario());
        this.chkContaPagamento.setSelected(bem.getIndicadorContaPagamento().naoFormatado().equals("1"));
    }

    public void atualizarCodigoBem(String codBem) {
        this.atualizarComboPais(this.getBem().getGrupo().naoFormatado(), codBem);
        this.habilitarCamposCriptoativos(this.getBem().getGrupo().naoFormatado(), codBem);
        this.verificarLimparNI(codBem);
        this.habilitarPainelBemImovel(this.bem.getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado());
        this.alteraPainelLocalizacaoBemImovel(this.bem.getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado());
        this.habilitarPainelRegistroBem(this.getBem().getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado());
        this.habilitarCampoDataAquisicao(this.getBem().getGrupo().naoFormatado(), codBem);
        this.habilitarCampoNI(this.bem.getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado(), this.getBem().getIndicadorAutoCustodiante().naoFormatado());
        this.habilitarPainelDadosBancarios(this.getBem().getGrupo().naoFormatado(), codBem);
        this.habilitarPainelNegociacao(this.getBem().getGrupo().naoFormatado(), codBem);
        this.edtNumeroRegistroBem.setConteudo("");
        JAutoCompleteComboBox editorBanco = (JAutoCompleteComboBox)this.edtBanco.getComponenteEditor();
        editorBanco.clearSelection();
        this.habilitarBotoesRendimento(this.getBem().getGrupo().naoFormatado(), codBem);
        this.habilitarPaineisAplicacaoFinanceiraLucrosDividendos(this.getBem().getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado());
        this.confirmarReclassificacao(codBem);
        this.configurarMensagemReservaRemunerada(this.getBem().getGrupo().naoFormatado(), codBem, this.getBem().getPais().naoFormatado());
    }

    private void verificarLimparNI(String codBem) {
        boolean localizacaoBrasil = this.getBem().getPais().naoFormatado().equals("105");
        this.getBem();
        if (!Bem.isBemComNI((String)this.getBem().getGrupo().naoFormatado(), (String)codBem, (boolean)localizacaoBrasil, (String)this.getBem().getIndicadorAutoCustodiante().naoFormatado()) && !"-1".equals(codBem)) {
            this.edtNiBem.setConteudo("");
        }
    }

    private void configurarComboGrupo() {
        this.listenerCodigo = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JComboBox comboGrupo = (JComboBox)PainelBensDetalheEspolio.this.edtGrupo.getComponenteEditor();
                String grupoCombo = "";
                if (comboGrupo.getSelectedIndex() != -1) {
                    grupoCombo = ((ElementoTabela)comboGrupo.getSelectedItem()).getConteudo(0);
                }
                String grupoNegocio = PainelBensDetalheEspolio.this.getBem().getGrupo().naoFormatado();
                boolean rollback = false;
                if (!grupoCombo.equals(grupoNegocio)) {
                    PainelBensDetalheEspolio.this.exibirMensagem524ou525(grupoCombo, PainelBensDetalheEspolio.this.bem.getPais().naoFormatado());
                    if (!PainelBensDetalheEspolio.this.bem.processarTrocaGrupoCodigoPais(grupoNegocio, "Grupo")) {
                        int indice = -1;
                        rollback = true;
                        for (ElementoTabela elemento : PainelBensDetalheEspolio.this.bem.getGrupo().getColecaoElementoTabela()) {
                            ++indice;
                            if (!elemento.getConteudo(0).equals(grupoNegocio)) continue;
                            PainelBensDetalheEspolio.this.indiceRollback = indice;
                            break;
                        }
                        comboGrupo.removeActionListener(PainelBensDetalheEspolio.this.listenerGrupo);
                        comboGrupo.setSelectedIndex(PainelBensDetalheEspolio.this.indiceRollback);
                        comboGrupo.addActionListener(PainelBensDetalheEspolio.this.listenerGrupo);
                    }
                    if (!rollback) {
                        if (comboGrupo.getSelectedIndex() == -1) {
                            PainelBensDetalheEspolio.this.getBem().getGrupo().clear();
                        } else {
                            PainelBensDetalheEspolio.this.getBem().getGrupo().setConteudo(((ElementoTabela)comboGrupo.getSelectedItem()).getConteudo(0));
                        }
                        ((JComboBox)PainelBensDetalheEspolio.this.edtCodigoBem.getComponenteEditor()).removeActionListener(PainelBensDetalheEspolio.this.listenerCodigo);
                        ((JComboBox)PainelBensDetalheEspolio.this.edtCodigoBem.getComponenteEditor()).setSelectedIndex(-1);
                        ((JComboBox)PainelBensDetalheEspolio.this.edtCodigoBem.getComponenteEditor()).addActionListener(PainelBensDetalheEspolio.this.listenerCodigo);
                        PainelBensDetalheEspolio.this.getBem().getCodigo().clear();
                        PainelBensDetalheEspolio.this.atualizarCodigoBem("-1");
                    }
                }
            }
        };
        ((JComboBox)this.edtGrupo.getComponenteEditor()).addActionListener(this.listenerCodigo);
    }

    private void configurarComboCodigo() {
        this.listenerCodigo = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String codigoNegocio;
                JComboBox comboCodigo = (JComboBox)PainelBensDetalheEspolio.this.edtCodigoBem.getComponenteEditor();
                String codigoCombo = "";
                if (comboCodigo.getSelectedIndex() != -1) {
                    codigoCombo = ((ElementoTabela)comboCodigo.getSelectedItem()).getConteudo(0);
                }
                if (!codigoCombo.equals(codigoNegocio = PainelBensDetalheEspolio.this.getBem().getCodigo().naoFormatado())) {
                    if (!PainelBensDetalheEspolio.this.bem.processarTrocaGrupoCodigoPais(codigoNegocio, "C\u00f3digo")) {
                        int indice = -1;
                        for (ElementoTabela elemento : PainelBensDetalheEspolio.this.bem.getCodigo().getColecaoElementoTabela()) {
                            ++indice;
                            if (!elemento.getConteudo(0).equals(codigoNegocio)) continue;
                            PainelBensDetalheEspolio.this.indiceRollback = indice;
                            break;
                        }
                        comboCodigo.removeActionListener(PainelBensDetalheEspolio.this.listenerCodigo);
                        comboCodigo.setSelectedIndex(PainelBensDetalheEspolio.this.indiceRollback);
                        comboCodigo.addActionListener(PainelBensDetalheEspolio.this.listenerCodigo);
                    }
                    if (comboCodigo.getSelectedItem() == null) {
                        PainelBensDetalheEspolio.this.atualizarCodigoBem("-1");
                    } else {
                        PainelBensDetalheEspolio.this.atualizarCodigoBem(((ElementoTabela)comboCodigo.getSelectedItem()).getConteudo(0));
                    }
                }
            }
        };
        ((JComboBox)this.edtCodigoBem.getComponenteEditor()).addActionListener(this.listenerCodigo);
    }

    private void limpaDadosConta() {
        this.getBem().getAgencia().setConteudo("");
        this.getBem().getOperacao().setConteudo("");
        this.getBem().getConta().setConteudo("");
        this.getBem().getDVConta().setConteudo("");
    }

    private void configurarComboPais() {
        this.listenerPais = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String paisNegocio;
                JComboBox comboPais = (JComboBox)PainelBensDetalheEspolio.this.edtLocalizacao.getComponenteEditor();
                String paisCombo = "";
                if (comboPais.getSelectedIndex() != -1) {
                    paisCombo = ((ElementoTabela)comboPais.getSelectedItem()).getConteudo(0);
                }
                if (!paisCombo.equals(paisNegocio = PainelBensDetalheEspolio.this.getBem().getPais().naoFormatado())) {
                    ElementoTabela et;
                    PainelBensDetalheEspolio.this.exibirMensagem524ou525(PainelBensDetalheEspolio.this.bem.getGrupo().naoFormatado(), paisCombo);
                    if (!PainelBensDetalheEspolio.this.bem.processarTrocaGrupoCodigoPais(paisNegocio, "Localiza\u00e7\u00e3o(Pa\u00eds)")) {
                        int indice = -1;
                        for (ElementoTabela elemento : PainelBensDetalheEspolio.this.bem.getPais().getColecaoElementoTabela()) {
                            ++indice;
                            if (!elemento.getConteudo(0).equals(paisNegocio)) continue;
                            PainelBensDetalheEspolio.this.indiceRollback = indice;
                            break;
                        }
                        comboPais.removeActionListener(PainelBensDetalheEspolio.this.listenerPais);
                        comboPais.setSelectedIndex(PainelBensDetalheEspolio.this.indiceRollback);
                        comboPais.addActionListener(PainelBensDetalheEspolio.this.listenerPais);
                    }
                    if ((et = (ElementoTabela)comboPais.getSelectedItem()) != null) {
                        PainelBensDetalheEspolio.this.trocaPais(et.getConteudo(0));
                    }
                }
            }
        };
        ((JComboBox)this.edtLocalizacao.getComponenteEditor()).addActionListener(this.listenerPais);
    }

    protected boolean isLocalizacaoBrasil(String codPais) {
        return codPais.equals("105");
    }

    protected boolean isLocalizacaoExterior(String codPais) {
        return !codPais.equals("105");
    }

    private void atualizarComboPais(String grupo, String codigo) {
        String paisSelecionado = null;
        boolean soExterior = false;
        if (((JComboBox)this.edtLocalizacao.getComponenteFoco()).getSelectedIndex() != -1) {
            paisSelecionado = ((ElementoTabela)((JComboBox)this.edtLocalizacao.getComponenteFoco()).getSelectedItem()).getConteudo(0);
        }
        if (this.bem.isBemApenasBrasil(grupo, codigo)) {
            this.bem.getPais().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarPaises());
            ElementoTabela elementoSelecionado = (ElementoTabela)((JComboBox)this.edtLocalizacao.getComponenteEditor()).getSelectedItem();
            if (((JComboBox)this.edtLocalizacao.getComponenteEditor()).getSelectedIndex() == -1 || !"105".equals(elementoSelecionado.getConteudo(0))) {
                for (int pos = 0; pos < ((JComboBox)this.edtLocalizacao.getComponenteEditor()).getItemCount(); ++pos) {
                    ElementoTabela elem = (ElementoTabela)((JComboBox)this.edtLocalizacao.getComponenteEditor()).getItemAt(pos);
                    if (!"105".equals(elem.getConteudo(0))) continue;
                    ((JComboBox)this.edtLocalizacao.getComponenteEditor()).setSelectedItem(elem);
                    break;
                }
            }
            this.edtLocalizacao.getComponenteFoco().setEnabled(false);
        } else if (Bem.isBemApenasExterior((String)grupo, (String)codigo)) {
            this.bem.getPais().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarPaisesExterior());
            this.edtLocalizacao.getComponenteFoco().setEnabled(true);
            soExterior = true;
        } else {
            this.bem.getPais().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarPaises());
            this.edtLocalizacao.getComponenteFoco().setEnabled(true);
        }
        if (!(((JComboBox)this.edtLocalizacao.getComponenteFoco()).getSelectedIndex() != -1 || paisSelecionado == null || soExterior && "105".equals(paisSelecionado))) {
            for (int i = 0; i < ((JComboBox)this.edtLocalizacao.getComponenteFoco()).getItemCount(); ++i) {
                if (!((ElementoTabela)((JComboBox)this.edtLocalizacao.getComponenteFoco()).getItemAt(i)).getConteudo(0).equals(paisSelecionado)) continue;
                ((JComboBox)this.edtLocalizacao.getComponenteFoco()).setSelectedIndex(i);
                break;
            }
        }
    }

    private void configurarMensagemReservaRemunerada(String grupo, String codigo, String pais) {
        if ("06".equals(grupo) && ("01".equals(codigo) || "99".equals(codigo)) && !"105".equals(pais)) {
            this.lblMsgDepositoRemunerado.setVisible(true);
        } else {
            this.lblMsgDepositoRemunerado.setVisible(false);
        }
    }

    protected void habilitarCampoNI(String grupo, String codBem, String codPais, String autoCustodiante) {
        if (Bem.isBemComNI((String)grupo, (String)codBem, (boolean)this.isLocalizacaoBrasil(codPais), (String)autoCustodiante)) {
            String nomeCampo = Bem.tituloCampoNI((String)grupo, (String)codBem);
            this.lblNiBem.setText(nomeCampo);
            this.lblNiBem.setEnabled(true);
            this.edtNiBem.setEnabled(true);
            this.lblNiBem.setVisible(true);
            this.edtNiBem.setVisible(true);
            this.edtNiBem.getAccessibleContext().setAccessibleName(nomeCampo);
            this.bem.getNiEmpresa().setNomeCampo(nomeCampo);
        } else {
            this.lblNiBem.setEnabled(false);
            this.edtNiBem.setEnabled(false);
            this.lblNiBem.setVisible(false);
            this.edtNiBem.setVisible(false);
            this.edtNiBem.getAccessibleContext().setAccessibleName("");
        }
    }

    protected void habilitarPainelRegistroBem(String grupo, String codBem, String codPais) {
        if (Bem.isBemRegistravel((String)grupo, (String)codBem, (boolean)this.isLocalizacaoBrasil(codPais))) {
            String nomeCampo = Bem.tituloCampoRegistro((String)grupo, (String)codBem, (boolean)this.isLocalizacaoBrasil(codPais));
            this.lblNumeroRegistroBem.setText(nomeCampo);
            this.lblNumeroRegistroBem.setEnabled(true);
            this.edtNumeroRegistroBem.setEnabled(true);
            this.lblNumeroRegistroBem.setVisible(true);
            this.edtNumeroRegistroBem.setVisible(true);
            this.edtNumeroRegistroBem.getAccessibleContext().setAccessibleDescription(nomeCampo);
            if (nomeCampo.equals("Inscri\u00e7\u00e3o Municipal (IPTU)")) {
                this.lblInfoIPTU.setVisible(true);
            } else {
                this.lblInfoIPTU.setVisible(false);
            }
            int tamanhoCampo = Bem.tamanhoCampoRegistro((String)grupo, (String)codBem, (boolean)this.isLocalizacaoBrasil(codPais));
            String mascara = "******************************".substring(0, tamanhoCampo);
            String caracteres = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz0123456789$%& -,./!#*):;(+<>?@_";
            if (this.bem.isImovelImovelRuralNoBrasil(grupo, codBem, codPais)) {
                mascara = "*******-*";
                caracteres = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz0123456789";
            } else if (this.bem.isImovelEmConstrucaoNoBrasil(grupo, codBem, codPais)) {
                mascara = "**.***.*****/**";
                caracteres = "0123456789";
            }
            this.edtNumeroRegistroBem.setMascara(mascara);
            this.edtNumeroRegistroBem.setCaracteresValidos(caracteres);
            this.bem.getRegistroBem().setMaximoCaracteres(tamanhoCampo);
            this.bem.getRegistroBem().setNomeCampo(nomeCampo);
        } else {
            this.lblNumeroRegistroBem.setEnabled(false);
            this.edtNumeroRegistroBem.setEnabled(false);
            this.lblNumeroRegistroBem.setVisible(false);
            this.edtNumeroRegistroBem.setVisible(false);
            this.edtNumeroRegistroBem.getAccessibleContext().setAccessibleDescription("");
            this.lblInfoIPTU.setVisible(false);
            this.edtNumeroRegistroBem.setConteudo("");
        }
    }

    protected void habilitarPainelDadosBancarios(String grupo, String codBem) {
        if (Bem.isBemComDadosBancarios((String)grupo, (String)codBem)) {
            this.pnlDadosBancarios.setVisible(true);
            if (grupo.equals("06") && codBem.contentEquals("01")) {
                this.chkContaPagamento.setVisible(true);
            } else {
                this.chkContaPagamento.setSelected(false);
                this.chkContaPagamento.setVisible(false);
            }
        } else {
            this.pnlDadosBancarios.setVisible(false);
            this.edtAgencia.setConteudo("");
            this.edtConta.setConteudo("");
            this.edtDV.setConteudo("");
        }
    }

    private void habilitarCampoBanco(String codPais, String grupo, String codBem) {
        if (this.isLocalizacaoBrasil(codPais)) {
            this.lblBanco.setVisible(true);
            this.edtBanco.setVisible(true);
            if (grupo.equals("06") && codBem.contentEquals("01")) {
                this.chkContaPagamento.setVisible(true);
            } else {
                this.chkContaPagamento.setSelected(false);
                this.chkContaPagamento.setVisible(false);
            }
        } else {
            this.lblBanco.setVisible(false);
            this.edtBanco.setVisible(false);
            this.edtBanco.getInformacao().clear();
            ((JComboBox)this.edtBanco.getComponenteEditor()).setSelectedIndex(-1);
            this.chkContaPagamento.setSelected(false);
            this.chkContaPagamento.setVisible(false);
            this.bem.getIndicadorContaPagamento().setConteudo("0");
        }
    }

    protected void habilitarCampoDataAquisicao(String grupo, String codBem) {
        Boolean flag = Bem.isBemImovelRegistravel((String)grupo, (String)codBem);
        this.lblDataAquisicao.setEnabled(flag);
        this.edtDataAquisicao.setEnabled(flag.booleanValue());
        this.lblDataAquisicao.setVisible(flag);
        this.edtDataAquisicao.setVisible(flag.booleanValue());
        if (!flag.booleanValue()) {
            this.edtDataAquisicao.setConteudo("");
        }
    }

    private void configuraNumeroCaracteresDV(String banco) {
        String dv = this.edtDV.getConteudo().toString();
        if (CalculoImposto.getBancosDebito().contains(banco)) {
            this.edtDV.setMaxChars(1);
            ((Alfa)this.edtDV.getInformacao()).setMaximoCaracteres(1);
            if (dv != null && dv.trim().length() > 1) {
                this.edtDV.getInformacao().setConteudo(dv.substring(0, 1));
            }
        } else {
            this.edtDV.setMaxChars(2);
            ((Alfa)this.edtDV.getInformacao()).setMaximoCaracteres(2);
        }
    }

    private void configurarContaCorrente(Codigo banco) {
        String codBanco = banco.naoFormatado();
        if (CalculoImposto.getBancosDebito().contains(codBanco)) {
            try {
                String digitos = String.valueOf(this.definirDigitosConta(banco));
                if ("070".equals(codBanco)) {
                    this.lblInfo.setMensagem(MensagemUtil.getMensagem((String)"msg_informacao_conta_caixa_brb_bem", (String[])new String[]{"cr\u00e9dito"}));
                } else if (this.getBem().possuiDadosContaPoupanca() && "001".equals(codBanco)) {
                    this.lblInfo.setMensagem(MensagemUtil.getMensagem((String)"msg_informacao_conta_bb", (String[])new String[]{"cr\u00e9dito"}));
                } else {
                    this.lblInfo.setMensagem(MensagemUtil.getMensagem((String)"msg_informacao_digitos_conta_bem", (String[])new String[]{digitos}));
                }
                this.edtConta.setMascara(IRPFUtil.repetirString((String)"*", (int)Integer.parseInt(digitos)));
                JTextField t = (JTextField)this.edtConta.getComponenteEditor();
                this.edtConta.setConteudo(t.getText());
            }
            catch (Exception e) {
                this.edtConta.setMascara("*************");
            }
        }
    }

    public int definirDigitosConta(Codigo banco) {
        int digitos;
        String codBanco = banco.naoFormatado();
        try {
            digitos = Integer.parseInt(banco.getConteudoAtual(6));
        }
        catch (Exception e) {
            digitos = 13;
        }
        if ("001".equals(codBanco) && this.getBem().possuiDadosContaPoupanca()) {
            digitos = 9;
        } else if ("104".equals(codBanco)) {
            digitos = 12;
        }
        return digitos;
    }

    public final void mostrarCampoIndicadorBemInventariar() {
        Espolio espolio = IRPFFacade.getInstancia().getDeclaracao().getEspolio();
        if (espolio.getIndicadorBensInventariar().naoFormatado().equals("1")) {
            this.chkBemInventariar.setVisible(true);
        } else {
            this.chkBemInventariar.setVisible(false);
        }
    }

    private void habilitarPainelBemImovel(String grupo, String codBem, String codPais) {
        if (Bem.isBemImovel((String)grupo, (String)codBem)) {
            this.pnlDadosBemImovel.setVisible(true);
            if (Bem.isBemImovelRegistravel((String)grupo, (String)codBem)) {
                this.lblRegistrado.setVisible(true);
                this.edtRegistroCartorio.setVisible(true);
                this.habilitaCampoBemImovelRegistrado(this.rdoRegistroCartorioSim.isSelected() ? "1" : (this.rdoRegistroCartorioNao.isSelected() ? "0" : "2"), codPais);
                this.edtRegistroCartorio.chamaValidacao();
            } else {
                this.lblRegistrado.setVisible(false);
                this.edtRegistroCartorio.setVisible(false);
                this.lblMatricula.setVisible(false);
                this.edtMatriculaImovel.setVisible(false);
                this.lblNomeCartorio.setVisible(false);
                this.edtNomeCartorio.setVisible(false);
                this.edtRegistroCartorio.setConteudo("2");
                this.edtMatriculaImovel.setConteudo("");
                this.edtNomeCartorio.setConteudo("");
            }
            this.chkAtualizacaoValorBem.setVisible(IRPFFacade.getInstancia().getBens().getExisteAtualizacaoValorBem().naoFormatado().equals(Logico.SIM));
            this.chkAtualizacaoValorBem.setSelected(this.bem.getAtualizadoValorBem().naoFormatado().equals(Logico.SIM));
        } else {
            this.pnlDadosBemImovel.setVisible(false);
            this.edtRegistroCartorio.setConteudo("2");
            this.edtMatriculaImovel.setConteudo("");
            this.edtNomeCartorio.setConteudo("");
            this.chkAtualizacaoValorBem.setSelected(false);
            this.chkAtualizacaoValorBem.setVisible(false);
        }
    }

    protected void habilitaCampoBemImovelRegistrado(String registrado, String codPais) {
        if (this.isLocalizacaoBrasil(codPais)) {
            if (registrado.equals("1")) {
                this.lblMatricula.setVisible(true);
                this.edtMatriculaImovel.setVisible(true);
                this.lblNomeCartorio.setVisible(true);
                this.edtNomeCartorio.setVisible(true);
            } else if (registrado.equals("0")) {
                this.lblMatricula.setVisible(false);
                this.edtMatriculaImovel.setVisible(false);
                this.lblNomeCartorio.setVisible(false);
                this.edtNomeCartorio.setVisible(false);
                this.edtMatriculaImovel.setConteudo("");
                this.edtNomeCartorio.setConteudo("");
            } else {
                this.lblMatricula.setVisible(false);
                this.edtMatriculaImovel.setVisible(false);
                this.lblNomeCartorio.setVisible(false);
                this.edtNomeCartorio.setVisible(false);
                this.edtMatriculaImovel.setConteudo("");
                this.edtNomeCartorio.setConteudo("");
            }
        } else {
            this.lblRegistrado.setVisible(false);
            this.edtRegistroCartorio.setVisible(false);
            this.lblMatricula.setVisible(false);
            this.edtMatriculaImovel.setVisible(false);
            this.lblNomeCartorio.setVisible(false);
            this.edtNomeCartorio.setVisible(false);
            this.edtRegistroCartorio.setConteudo("2");
            this.edtMatriculaImovel.setConteudo("");
            this.edtNomeCartorio.setConteudo("");
        }
    }

    private void alteraPainelLocalizacaoBemImovel(String grupo, String codBem, String codPais) {
        if (Bem.isBemImovel((String)grupo, (String)codBem)) {
            if (codPais.equals("105")) {
                this.flpLocalizacao.exibeComponenteA();
            } else {
                this.flpLocalizacao.exibeComponenteB();
            }
        }
    }

    private void mensagemInformacaoContaAcessivel() {
        if (!this.bem.getBanco().naoFormatado().equals("104")) {
            this.edtConta.getAccessibleContext().setAccessibleDescription(this.lblInfo.getMensagem());
        }
    }

    protected void habilitarPainelNegociacao(String grupo, String codBem) {
        if (Bem.isBemNegociadoBolsa((String)grupo, (String)codBem)) {
            this.pnlNegociacaoBolsa.setVisible(true);
            this.habilitaCampoCodigoNegociacao(this.rdoNegociadoBolsaSim.isSelected() ? "1" : (this.rdoNegociadoBolsaNao.isSelected() ? "0" : "2"));
        } else {
            this.pnlNegociacaoBolsa.setVisible(false);
        }
    }

    protected void habilitaCampoCodigoNegociacao(String negociadoBolsa) {
        if (negociadoBolsa.equals("1")) {
            this.lblCodNegociacao.setVisible(true);
            this.edtCodNegociacao.setVisible(true);
        } else {
            this.lblCodNegociacao.setVisible(false);
            this.edtCodNegociacao.setVisible(false);
            this.edtCodNegociacao.setConteudo("");
        }
    }

    private void habilitarCamposCriptoativos(String grupo, String codBem) {
        if (Bem.isCriptoativos((String)grupo, (String)codBem)) {
            this.habilitarComboCodigoCriptoativos(codBem);
            this.lblAutoCustodiante.setVisible(true);
            this.grpAutoCustodiante.setVisible(true);
        } else {
            this.lblAutoCustodiante.setVisible(false);
            this.grpAutoCustodiante.setVisible(false);
            this.lblCodCripto.setVisible(false);
            this.edtCodigoCripto.setVisible(false);
            this.bem.getIndicadorAutoCustodiante().setConteudo("0");
        }
    }

    private void habilitarComboCodigoCriptoativos(String codBem) {
        if ("02".equals(codBem) || "03".equals(codBem)) {
            this.lblCodCripto.setVisible(true);
            this.edtCodigoCripto.setVisible(true);
            if ("02".equals(codBem)) {
                this.lblCodCripto.setText("C\u00f3digo Altcoin");
                this.edtCodigoCripto.setInformacao((Informacao)this.bem.getCodigoAltcoin());
                this.edtCodigoCripto.getAccessibleContext().setAccessibleName("C\u00f3digo Altcoin");
                this.bem.getCodigoStablecoin().setConteudo("");
            } else {
                this.lblCodCripto.setText("C\u00f3digo Stablecoin");
                this.edtCodigoCripto.setInformacao((Informacao)this.bem.getCodigoStablecoin());
                this.edtCodigoCripto.getAccessibleContext().setAccessibleName("C\u00f3digo Stablecoin");
                this.bem.getCodigoAltcoin().setConteudo("");
            }
        } else {
            this.lblCodCripto.setVisible(false);
            this.edtCodigoCripto.setVisible(false);
        }
    }

    private void habilitarPaineisAplicacaoFinanceiraLucrosDividendos(String grupo, String codBem, String codPais) {
        if (Bem.isBemComAplicacaoFinanceira((String)grupo, (String)codBem, (boolean)this.isLocalizacaoExterior(codPais))) {
            this.pnlAplicacaoFinanceira.setVisible(true);
        } else {
            this.pnlAplicacaoFinanceira.setVisible(false);
            this.edtLucroPrejuizo.setConteudo("");
            this.edtImpostoPagoExt.setConteudo("");
        }
        if (Bem.isBemComLucrosDividendos((String)grupo, (String)codBem, (boolean)this.isLocalizacaoExterior(codPais))) {
            this.pnlLucrosDividendos.setVisible(true);
        } else {
            this.pnlLucrosDividendos.setVisible(false);
            this.edtValorRecebido.setConteudo("");
            this.edtImpostoExteriorIRRF.setConteudo("");
        }
    }

    private void habilitarRadioProprietarioUsufrutuario() {
    }

    protected void habilitaInformacaoCPFCNPJProprietarioUsufrutuario(String proprietarioUsufrutuario) {
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.edtLocalizacao = new JAutoCompleteEditCodigo();
        this.jLabel2 = new JLabel();
        this.edtCodigoBem = new JAutoCompleteEditCodigo();
        this.edtDiscriminacao = new JEditMemo();
        this.lblNumeroRegistroBem = new JLabel();
        this.lblDataAquisicao = new JLabel();
        this.edtDataAquisicao = new JEditData();
        this.lblNiBem = new JLabel();
        this.edtNiBem = new JEditNI();
        this.lblInfoIPTU = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"bem_info_iptu"));
        this.pnlDadosBemImovel = new JPanel();
        this.lblComplemento = new JLabel();
        this.edtComplemento = new JEditAlfa();
        this.lblBairro = new JLabel();
        this.edtBairro = new JEditAlfa();
        this.flpLocalizacao = new JFlipComponentes();
        this.edtLogradouro = new JEditAlfa();
        this.lblLogradouro = new JLabel();
        this.lblNumero = new JLabel();
        this.edtNumero = new JEditAlfa();
        this.lblAreaTotal = new JLabel();
        this.edtAreaTotal = new JEditValor();
        this.msgUnidade = new JButtonMensagem();
        this.lblUnidade = new JLabel();
        this.edtUnidade = new JButtonGroupPanel();
        this.rdoUnidadeM2 = new PPGDRadioItem();
        this.rdoUnidadeHa = new PPGDRadioItem();
        this.lblMatricula = new JLabel();
        this.edtRegistroCartorio = new JButtonGroupPanel();
        this.rdoRegistroCartorioSim = new PPGDRadioItem();
        this.rdoRegistroCartorioNao = new PPGDRadioItem();
        this.msgRegistrado = new JButtonMensagem();
        this.lblRegistrado = new JLabel();
        this.lblNomeCartorio = new JLabel();
        this.edtMatriculaImovel = new JEditAlfa();
        this.edtNomeCartorio = new JEditAlfa();
        this.pnlDadosBancarios = new JPanel();
        this.edtDV = new JEditAlfa();
        this.lblConta = new JLabel();
        this.lblInfo = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"msg_informacao_conta_caixa_debito", (String[])new String[]{"d\u00e9bito"}));
        this.lblAgencia = new JLabel();
        this.edtAgencia = new JEditMascara();
        this.edtConta = new JEditMascara();
        this.lblDV = new JLabel();
        this.edtBanco = new JAutoCompleteEditCodigo();
        this.lblBanco = new JLabel();
        this.chkContaPagamento = new JCheckBox();
        this.chkBemInventariar = new JCheckBox();
        this.edtGrupo = new JAutoCompleteEditCodigo();
        this.jLabel5 = new JLabel();
        this.edtNumeroRegistroBem = new JEditMascara();
        this.pnlNegociacaoBolsa = new JPanel();
        this.lblNegociacao = new JLabel();
        this.edtNegociadoBolsa = new JButtonGroupPanel();
        this.rdoNegociadoBolsaSim = new PPGDRadioItem();
        this.rdoNegociadoBolsaNao = new PPGDRadioItem();
        this.msgRegistrado1 = new JButtonMensagem();
        this.lblCodNegociacao = new JLabel();
        this.edtCodNegociacao = new JEditAlfa();
        this.lblCodCripto = new JLabel();
        this.edtCodigoCripto = new JAutoCompleteEditCodigo();
        this.lblAutoCustodiante = new JLabel();
        this.grpAutoCustodiante = new JButtonGroupPanel();
        this.rdbAutoCustodianteSim = new PPGDRadioItem();
        this.rdbAutoCustodianteNao = new PPGDRadioItem();
        this.chkAtualizacaoValorBem = new JCheckBox();
        this.grpProprietarioUsufrutuario = new JButtonGroupPanel();
        this.rdbProprietario = new PPGDRadioItem();
        this.rdbUsufrutuario = new PPGDRadioItem();
        this.chkBemComUsufruto = new JCheckBox();
        this.lblProprietarioUsufrutuario = new JLabel();
        this.btProprietarioUsufrutuario = new JButton();
        this.btnReclassificar = new JButton();
        this.jPanel2 = new JPanel();
        this.lbSituacaoAnoAtual = new JLabel();
        this.lbSituacaoAnoAnterior = new JLabel();
        this.edtPercentualParticipacao = new JEditValor();
        this.edtValorAnterior = new JEditValor();
        this.edtValorAtual = new JEditValor();
        this.btnPercentualParticipacao = new JButton();
        this.lbRepetir = new JLabel();
        this.btnRepetir = new JButton();
        this.pnlRendimentos = new JPanel();
        this.jPanel4 = new JPanel();
        this.btnRendIsento = new JButton();
        this.btnRendExclusivo = new JButton();
        this.pnlAplicacaoFinanceira = new JPanel();
        this.lblLucroPrejuizo = new JLabel();
        this.edtLucroPrejuizo = new JEditValor();
        this.lblImpostoPagoExt = new JLabel();
        this.edtImpostoPagoExt = new JEditValor();
        this.lblMsgDepositoRemunerado = new JLabel();
        this.pnlLucrosDividendos = new JPanel();
        this.edtValorRecebido = new JEditValor();
        this.lblValorRecebido = new JLabel();
        this.lblImpostoExteriorIRRF = new JLabel();
        this.edtImpostoExteriorIRRF = new JEditValor();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jLabel4.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel4.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel4.setLabelFor((Component)this.edtDiscriminacao);
        this.jLabel4.setText("Discrimina\u00e7\u00e3o");
        this.jLabel3.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel3.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel3.setLabelFor((Component)this.edtLocalizacao);
        this.jLabel3.setText("Localiza\u00e7\u00e3o (Pa\u00eds)");
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel2.setLabelFor((Component)this.edtCodigoBem);
        this.jLabel2.setText("C\u00f3digo");
        this.edtDiscriminacao.setMaxChars(512);
        this.lblNumeroRegistroBem.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNumeroRegistroBem.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNumeroRegistroBem.setText("IPTU");
        this.lblDataAquisicao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDataAquisicao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDataAquisicao.setText("Data de Aquisi\u00e7\u00e3o");
        this.lblNiBem.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNiBem.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNiBem.setText("CNPJ");
        this.lblNiBem.setToolTipText("");
        this.edtNiBem.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalheEspolio.this.edtNiBemFocusLost(evt);
            }
        });
        this.pnlDadosBemImovel.setBackground(new Color(255, 255, 255));
        this.lblComplemento.setFont(FontesUtil.FONTE_NORMAL);
        this.lblComplemento.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblComplemento.setText("Complemento");
        this.lblBairro.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBairro.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBairro.setText("Bairro/Distrito");
        this.flpLocalizacao.setBackground(new Color(255, 255, 255));
        this.flpLocalizacao.setBorder(null);
        this.flpLocalizacao.setComponenteA((JComponent)this.painelImovelBrasil);
        this.flpLocalizacao.setComponenteB((JComponent)this.painelImovelExterior);
        this.lblLogradouro.setFont(FontesUtil.FONTE_NORMAL);
        this.lblLogradouro.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblLogradouro.setText("Logradouro");
        this.lblNumero.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNumero.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNumero.setText("N\u00famero");
        this.lblAreaTotal.setFont(FontesUtil.FONTE_NORMAL);
        this.lblAreaTotal.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblAreaTotal.setText("\u00c1rea Total do Im\u00f3vel");
        this.msgUnidade.setText("jButtonMensagem1");
        this.lblUnidade.setFont(FontesUtil.FONTE_NORMAL);
        this.lblUnidade.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblUnidade.setText("Unidade");
        this.edtUnidade.setBorder(null);
        this.rdoUnidadeM2.setBackground(new Color(255, 255, 255));
        this.rdoUnidadeM2.setText("<html>M<sup>2</sup></html>");
        this.rdoUnidadeM2.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoUnidadeM2.setName("rdoUnidadeM2");
        this.rdoUnidadeM2.setValorSelecionadoTrue("0");
        this.rdoUnidadeM2.setVerticalAlignment(1);
        this.rdoUnidadeM2.setVerticalTextPosition(1);
        this.rdoUnidadeM2.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalheEspolio.this.rdoUnidadeM2FocusLost(evt);
            }
        });
        this.rdoUnidadeHa.setBackground(new Color(255, 255, 255));
        this.rdoUnidadeHa.setText("<html>Ha<sup>&nbsp;</sup></html>");
        this.rdoUnidadeHa.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoUnidadeHa.setName("rdoUnidadeHa");
        this.rdoUnidadeHa.setValorSelecionadoTrue("1");
        this.rdoUnidadeHa.setVerticalAlignment(1);
        this.rdoUnidadeHa.setVerticalTextPosition(1);
        this.rdoUnidadeHa.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalheEspolio.this.rdoUnidadeHaFocusLost(evt);
            }
        });
        GroupLayout edtUnidadeLayout = new GroupLayout((Container)this.edtUnidade);
        this.edtUnidade.setLayout((LayoutManager)edtUnidadeLayout);
        edtUnidadeLayout.setHorizontalGroup(edtUnidadeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edtUnidadeLayout.createSequentialGroup().addComponent((Component)this.rdoUnidadeM2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdoUnidadeHa, -2, -1, -2).addContainerGap()));
        edtUnidadeLayout.setVerticalGroup(edtUnidadeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.rdoUnidadeHa).addComponent((Component)this.rdoUnidadeM2));
        this.rdoUnidadeM2.getAccessibleContext().setAccessibleName("Unidade em metros quadrados");
        this.rdoUnidadeHa.getAccessibleContext().setAccessibleName("Unidade em hectares");
        this.lblMatricula.setFont(FontesUtil.FONTE_NORMAL);
        this.lblMatricula.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblMatricula.setText("Matr\u00edcula do Im\u00f3vel");
        this.edtRegistroCartorio.setBorder(null);
        this.edtRegistroCartorio.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelBensDetalheEspolio.this.edtRegistroCartorioAtualizaPainel(evt);
            }
        });
        this.rdoRegistroCartorioSim.setBackground(new Color(255, 255, 255));
        this.rdoRegistroCartorioSim.setText("Sim");
        this.rdoRegistroCartorioSim.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoRegistroCartorioSim.setValorSelecionadoTrue("1");
        this.rdoRegistroCartorioSim.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalheEspolio.this.rdoRegistroCartorioSimFocusLost(evt);
            }
        });
        this.rdoRegistroCartorioNao.setBackground(new Color(255, 255, 255));
        this.rdoRegistroCartorioNao.setText("N\u00e3o");
        this.rdoRegistroCartorioNao.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoRegistroCartorioNao.setValorSelecionadoTrue("0");
        this.rdoRegistroCartorioNao.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalheEspolio.this.rdoRegistroCartorioNaoFocusLost(evt);
            }
        });
        this.msgRegistrado.setText("jButtonMensagem1");
        GroupLayout edtRegistroCartorioLayout = new GroupLayout((Container)this.edtRegistroCartorio);
        this.edtRegistroCartorio.setLayout((LayoutManager)edtRegistroCartorioLayout);
        edtRegistroCartorioLayout.setHorizontalGroup(edtRegistroCartorioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edtRegistroCartorioLayout.createSequentialGroup().addComponent((Component)this.rdoRegistroCartorioSim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.rdoRegistroCartorioNao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.msgRegistrado, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        edtRegistroCartorioLayout.setVerticalGroup(edtRegistroCartorioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edtRegistroCartorioLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdoRegistroCartorioSim, -2, -1, -2).addComponent((Component)this.rdoRegistroCartorioNao, -2, -1, -2)).addComponent((Component)this.msgRegistrado, -2, -1, -2));
        this.rdoRegistroCartorioSim.getAccessibleContext().setAccessibleName("Registrado no Cart\u00f3rio de Registro de Im\u00f3veis? Sim");
        this.rdoRegistroCartorioNao.getAccessibleContext().setAccessibleName("Registrado no Cart\u00f3rio de Registro de Im\u00f3veis? N\u00e3o");
        this.lblRegistrado.setFont(FontesUtil.FONTE_NORMAL);
        this.lblRegistrado.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblRegistrado.setText("<html>Registrado no Cart\u00f3rio<br>de Registro de Im\u00f3veis?</html>");
        this.lblNomeCartorio.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNomeCartorio.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNomeCartorio.setText("Nome Cart\u00f3rio");
        GroupLayout pnlDadosBemImovelLayout = new GroupLayout(this.pnlDadosBemImovel);
        this.pnlDadosBemImovel.setLayout(pnlDadosBemImovelLayout);
        pnlDadosBemImovelLayout.setHorizontalGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addContainerGap().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblComplemento).addComponent((Component)this.edtComplemento, -2, 360, -2)).addGap(18, 18, 18).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblBairro).addComponent((Component)this.edtBairro, -1, -1, Short.MAX_VALUE))).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtLogradouro, -2, 516, -2).addComponent(this.lblLogradouro)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtNumero, -2, 110, -2).addComponent(this.lblNumero))).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtAreaTotal, -2, 163, -2).addComponent(this.lblAreaTotal)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtUnidade, -2, -1, -2).addComponent(this.lblUnidade)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.msgUnidade, -2, -1, -2))).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblRegistrado, -2, -1, -2).addComponent((Component)this.edtRegistroCartorio, -2, -1, -2)).addGap(41, 41, 41).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtMatriculaImovel, -2, 217, -2).addComponent(this.lblMatricula)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtNomeCartorio, -2, 277, -2).addComponent(this.lblNomeCartorio))).addComponent((Component)this.flpLocalizacao, -2, 750, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlDadosBemImovelLayout.setVerticalGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblLogradouro).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtLogradouro, -2, -1, -2)).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblNumero).addGap(2, 2, 2).addComponent((Component)this.edtNumero, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblComplemento).addComponent(this.lblBairro)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.edtComplemento, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtBairro, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.flpLocalizacao, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblUnidade).addGap(2, 2, 2).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.msgUnidade, -2, -1, -2).addComponent((Component)this.edtUnidade, -2, -1, -2))).addGroup(GroupLayout.Alignment.TRAILING, pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblAreaTotal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtAreaTotal, -2, -1, -2))).addGap(18, 18, Short.MAX_VALUE).addGroup(pnlDadosBemImovelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblNomeCartorio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNomeCartorio, -2, -1, -2)).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblMatricula, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtMatriculaImovel, -2, -1, -2)).addGroup(pnlDadosBemImovelLayout.createSequentialGroup().addComponent(this.lblRegistrado, -2, -1, -2).addGap(2, 2, 2).addComponent((Component)this.edtRegistroCartorio, -2, -1, -2)))));
        this.edtComplemento.getAccessibleContext().setAccessibleName("Complemento");
        this.edtBairro.getAccessibleContext().setAccessibleName("Bairro/Distrito");
        this.edtLogradouro.getAccessibleContext().setAccessibleName("Logradouro");
        this.edtNumero.getAccessibleContext().setAccessibleName("N\u00famero");
        this.edtAreaTotal.getAccessibleContext().setAccessibleName("\u00c1rea Total do Im\u00f3vel");
        this.edtAreaTotal.getAccessibleContext().setAccessibleDescription("");
        this.edtMatriculaImovel.getAccessibleContext().setAccessibleName("Matr\u00edcula do Im\u00f3vel");
        this.edtMatriculaImovel.getAccessibleContext().setAccessibleDescription("");
        this.edtNomeCartorio.getAccessibleContext().setAccessibleName("Nome Cart\u00f3rio");
        this.edtNomeCartorio.getAccessibleContext().setAccessibleDescription("");
        this.pnlDadosBancarios.setBackground(new Color(255, 255, 255));
        ((JTextField)this.edtDV.getComponenteEditor()).setHorizontalAlignment(0);
        this.lblConta.setFont(FontesUtil.FONTE_NORMAL);
        this.lblConta.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblConta.setText("Conta");
        this.lblAgencia.setFont(FontesUtil.FONTE_NORMAL);
        this.lblAgencia.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblAgencia.setText("Ag\u00eancia (sem DV)");
        this.edtAgencia.setCaracteresValidos("0123456789 ");
        this.edtAgencia.setMascara("****");
        this.edtConta.setCaracteresValidos("0123456789 ");
        this.edtConta.setMascara("*************");
        this.lblDV.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDV.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDV.setText("DV");
        this.lblBanco.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBanco.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBanco.setText("Banco");
        this.chkContaPagamento.setBackground(new Color(255, 255, 255));
        this.chkContaPagamento.setText("Conta Pagamento? ");
        this.chkContaPagamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalheEspolio.this.chkContaPagamentoActionPerformed(evt);
            }
        });
        GroupLayout pnlDadosBancariosLayout = new GroupLayout(this.pnlDadosBancarios);
        this.pnlDadosBancarios.setLayout(pnlDadosBancariosLayout);
        pnlDadosBancariosLayout.setHorizontalGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addContainerGap().addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAgencia).addComponent((Component)this.edtAgencia, -2, 111, -2)).addGap(31, 31, 31).addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addComponent(this.lblConta).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lblInfo, -2, -1, -2)).addComponent((Component)this.edtConta, -2, 154, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDV).addComponent((Component)this.edtDV, -2, 64, -2))).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addComponent((Component)this.edtBanco, -2, 450, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkContaPagamento)).addComponent(this.lblBanco, -2, 79, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlDadosBancariosLayout.setVerticalGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlDadosBancariosLayout.createSequentialGroup().addComponent(this.lblBanco).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.chkContaPagamento, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtBanco, -1, -1, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addComponent(this.lblAgencia).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtAgencia, -2, -1, -2)).addGroup(pnlDadosBancariosLayout.createSequentialGroup().addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblConta).addComponent(this.lblDV).addComponent((Component)this.lblInfo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDadosBancariosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtConta, -2, -1, -2).addComponent((Component)this.edtDV, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtDV.getAccessibleContext().setAccessibleName("DV");
        this.edtAgencia.getAccessibleContext().setAccessibleName("Ag\u00eancia (sem DV)");
        this.edtConta.getAccessibleContext().setAccessibleName("Conta");
        this.edtBanco.getAccessibleContext().setAccessibleName("Banco");
        this.chkBemInventariar.setBackground(new Color(255, 255, 255));
        this.chkBemInventariar.setText("Bem a Inventariar");
        this.chkBemInventariar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalheEspolio.this.chkBemInventariarActionPerformed(evt);
            }
        });
        this.edtGrupo.setToolTipText("Grupo");
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setText("Grupo");
        this.pnlNegociacaoBolsa.setBackground(new Color(255, 255, 255));
        this.lblNegociacao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNegociacao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNegociacao.setText("Negociados em Bolsa?");
        this.edtNegociadoBolsa.setBorder(null);
        this.edtNegociadoBolsa.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelBensDetalheEspolio.this.edtNegociadoBolsaAtualizaPainel(evt);
            }
        });
        this.rdoNegociadoBolsaSim.setBackground(new Color(255, 255, 255));
        this.rdoNegociadoBolsaSim.setText("Sim");
        this.rdoNegociadoBolsaSim.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoNegociadoBolsaSim.setValorSelecionadoTrue("1");
        this.rdoNegociadoBolsaSim.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalheEspolio.this.rdoNegociadoBolsaSimFocusLost(evt);
            }
        });
        this.rdoNegociadoBolsaNao.setBackground(new Color(255, 255, 255));
        this.rdoNegociadoBolsaNao.setText("N\u00e3o");
        this.rdoNegociadoBolsaNao.setFont(FontesUtil.FONTE_NORMAL);
        this.rdoNegociadoBolsaNao.setValorSelecionadoTrue("0");
        this.rdoNegociadoBolsaNao.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelBensDetalheEspolio.this.rdoNegociadoBolsaNaoFocusLost(evt);
            }
        });
        this.msgRegistrado1.setText("jButtonMensagem1");
        GroupLayout edtNegociadoBolsaLayout = new GroupLayout((Container)this.edtNegociadoBolsa);
        this.edtNegociadoBolsa.setLayout((LayoutManager)edtNegociadoBolsaLayout);
        edtNegociadoBolsaLayout.setHorizontalGroup(edtNegociadoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edtNegociadoBolsaLayout.createSequentialGroup().addComponent((Component)this.rdoNegociadoBolsaSim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdoNegociadoBolsaNao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.msgRegistrado1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        edtNegociadoBolsaLayout.setVerticalGroup(edtNegociadoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(edtNegociadoBolsaLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdoNegociadoBolsaSim, -2, -1, -2).addComponent((Component)this.rdoNegociadoBolsaNao, -2, -1, -2)).addComponent((Component)this.msgRegistrado1, -2, -1, -2));
        this.lblCodNegociacao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCodNegociacao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCodNegociacao.setText("C\u00f3digo de Negocia\u00e7\u00e3o");
        GroupLayout pnlNegociacaoBolsaLayout = new GroupLayout(this.pnlNegociacaoBolsa);
        this.pnlNegociacaoBolsa.setLayout(pnlNegociacaoBolsaLayout);
        pnlNegociacaoBolsaLayout.setHorizontalGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlNegociacaoBolsaLayout.createSequentialGroup().addContainerGap().addGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNegociacao).addComponent((Component)this.edtNegociadoBolsa, -2, -1, -2)).addGap(29, 29, 29).addGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtCodNegociacao, -2, 217, -2).addComponent(this.lblCodNegociacao)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlNegociacaoBolsaLayout.setVerticalGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlNegociacaoBolsaLayout.createSequentialGroup().addGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblNegociacao).addComponent(this.lblCodNegociacao)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlNegociacaoBolsaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtNegociadoBolsa, -2, -1, -2).addComponent((Component)this.edtCodNegociacao, -2, -1, -2))));
        this.lblCodCripto.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCodCripto.setText("C\u00f3digo Altcoin");
        this.lblAutoCustodiante.setText("\u00c9 autocustodiante? ");
        this.grpAutoCustodiante.setBorder(null);
        this.grpAutoCustodiante.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelBensDetalheEspolio.this.grpAutoCustodianteAtualizaPainel(evt);
            }
        });
        this.rdbAutoCustodianteSim.setBackground(new Color(255, 255, 255));
        this.rdbAutoCustodianteSim.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbAutoCustodianteSim.setText("Sim");
        this.rdbAutoCustodianteSim.setValorSelecionadoTrue("1");
        this.rdbAutoCustodianteNao.setBackground(new Color(255, 255, 255));
        this.rdbAutoCustodianteNao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbAutoCustodianteNao.setText("N\u00e3o");
        this.rdbAutoCustodianteNao.setValorSelecionadoTrue("0");
        GroupLayout grpAutoCustodianteLayout = new GroupLayout((Container)this.grpAutoCustodiante);
        this.grpAutoCustodiante.setLayout((LayoutManager)grpAutoCustodianteLayout);
        grpAutoCustodianteLayout.setHorizontalGroup(grpAutoCustodianteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpAutoCustodianteLayout.createSequentialGroup().addComponent((Component)this.rdbAutoCustodianteSim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdbAutoCustodianteNao, -2, -1, -2).addContainerGap(44, Short.MAX_VALUE)));
        grpAutoCustodianteLayout.setVerticalGroup(grpAutoCustodianteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpAutoCustodianteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdbAutoCustodianteSim, -2, -1, -2).addComponent((Component)this.rdbAutoCustodianteNao, -2, -1, -2)));
        this.chkAtualizacaoValorBem.setBackground(new Color(255, 255, 255));
        this.chkAtualizacaoValorBem.setFont(FontesUtil.FONTE_NORMAL);
        this.chkAtualizacaoValorBem.setText("Houve a op\u00e7\u00e3o pela atualiza\u00e7\u00e3o deste bem de acordo com a Lei n\u00ba 14.973/2024?");
        this.chkAtualizacaoValorBem.setPreferredSize(new Dimension(503, 30));
        this.chkAtualizacaoValorBem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalheEspolio.this.chkAtualizacaoValorBemActionPerformed(evt);
            }
        });
        this.grpProprietarioUsufrutuario.setBorder(null);
        this.grpProprietarioUsufrutuario.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelBensDetalheEspolio.this.grpProprietarioUsufrutuarioAtualizaPainel(evt);
            }
        });
        this.rdbProprietario.setBackground(new Color(255, 255, 255));
        this.rdbProprietario.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbProprietario.setText("Propriet\u00e1rio");
        this.rdbProprietario.setValorSelecionadoTrue("1");
        this.rdbUsufrutuario.setBackground(new Color(255, 255, 255));
        this.rdbUsufrutuario.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbUsufrutuario.setText("Usufrutu\u00e1rio");
        this.rdbUsufrutuario.setValorSelecionadoTrue("2");
        GroupLayout grpProprietarioUsufrutuarioLayout = new GroupLayout((Container)this.grpProprietarioUsufrutuario);
        this.grpProprietarioUsufrutuario.setLayout((LayoutManager)grpProprietarioUsufrutuarioLayout);
        grpProprietarioUsufrutuarioLayout.setHorizontalGroup(grpProprietarioUsufrutuarioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpProprietarioUsufrutuarioLayout.createSequentialGroup().addComponent((Component)this.rdbProprietario, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdbUsufrutuario, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        grpProprietarioUsufrutuarioLayout.setVerticalGroup(grpProprietarioUsufrutuarioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpProprietarioUsufrutuarioLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdbProprietario, -2, -1, -2).addComponent((Component)this.rdbUsufrutuario, -2, -1, -2)));
        this.chkBemComUsufruto.setBackground(new Color(255, 255, 255));
        this.chkBemComUsufruto.setText("Bem com usufruto? ");
        this.chkBemComUsufruto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalheEspolio.this.chkBemComUsufrutoActionPerformed(evt);
            }
        });
        this.lblProprietarioUsufrutuario.setText("Voc\u00ea \u00e9:");
        this.btProprietarioUsufrutuario.setText("Usufrutu\u00e1rios");
        this.btProprietarioUsufrutuario.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalheEspolio.this.btProprietarioUsufrutuarioActionPerformed(evt);
            }
        });
        this.btnReclassificar.setText("Reclassificar");
        this.btnReclassificar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalheEspolio.this.btnReclassificarActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.chkBemInventariar).addComponent(this.jLabel5).addComponent((Component)this.edtGrupo, -2, 485, -2).addComponent((Component)this.edtLocalizacao, -2, 485, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent((Component)this.edtCodigoBem, -2, 485, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReclassificar)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblNumeroRegistroBem, -2, 156, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lblInfoIPTU, -2, -1, -2)).addComponent((Component)this.edtNumeroRegistroBem, -2, 319, -2)).addGap(13, 13, 13).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtDataAquisicao, -2, 158, -2).addComponent(this.lblDataAquisicao, -2, 135, -2))).addComponent(this.lblCodCripto).addComponent((Component)this.edtCodigoCripto, -2, 485, -2).addComponent(this.lblAutoCustodiante).addComponent((Component)this.grpAutoCustodiante, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.lblNiBem, -2, 338, -2).addComponent((Component)this.edtDiscriminacao, -2, 670, -2).addComponent((Component)this.edtNiBem, -2, 168, -2).addComponent(this.chkAtualizacaoValorBem, -2, 612, -2).addComponent(this.chkBemComUsufruto).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblProprietarioUsufrutuario).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.grpProprietarioUsufrutuario, -2, -1, -2).addGap(37, 37, 37).addComponent(this.btProprietarioUsufrutuario))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlDadosBemImovel, -2, -1, -2).addComponent(this.pnlNegociacaoBolsa, -2, -1, -2).addComponent(this.pnlDadosBancarios, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtGrupo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.edtCodigoBem, -2, -1, -2).addComponent(this.btnReclassificar)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtLocalizacao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkBemInventariar).addGap(10, 10, 10).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNumeroRegistroBem, GroupLayout.Alignment.TRAILING).addComponent(this.lblDataAquisicao)).addComponent((Component)this.lblInfoIPTU, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtDataAquisicao, -2, -1, -2).addComponent((Component)this.edtNumeroRegistroBem, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkAtualizacaoValorBem, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblCodCripto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtCodigoCripto, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAutoCustodiante).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.grpAutoCustodiante, -2, -1, -2).addGap(10, 10, 10).addComponent(this.lblNiBem).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNiBem, -2, -1, -2).addGap(10, 10, 10).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtDiscriminacao, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.chkBemComUsufruto).addGap(12, 12, 12).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblProprietarioUsufrutuario).addComponent((Component)this.grpProprietarioUsufrutuario, -2, -1, -2))).addComponent(this.btProprietarioUsufrutuario)).addGap(5, 5, 5).addComponent(this.pnlDadosBemImovel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlDadosBancarios, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlNegociacaoBolsa, -2, -1, -2)));
        this.edtLocalizacao.getAccessibleContext().setAccessibleName("Localiza\u00e7\u00e3o (Pa\u00eds)");
        this.edtCodigoBem.getAccessibleContext().setAccessibleName("C\u00f3digo");
        this.edtDiscriminacao.getAccessibleContext().setAccessibleName("Discrimina\u00e7\u00e3o");
        this.edtDataAquisicao.getAccessibleContext().setAccessibleName("Data de Aquisi\u00e7\u00e3o");
        this.edtNiBem.getAccessibleContext().setAccessibleName("CNPJ");
        this.edtGrupo.getAccessibleContext().setAccessibleName("Grupo");
        this.edtNumeroRegistroBem.getAccessibleContext().setAccessibleDescription(this.bem != null ? (this.bem.isBemImovelRegistravel() ? MensagemUtil.getMensagem((String)"bem_info_iptu") : "") : "");
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.lbSituacaoAnoAtual.setFont(FontesUtil.FONTE_NORMAL);
        this.lbSituacaoAnoAtual.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbSituacaoAnoAtual.setLabelFor((Component)this.edtValorAtual);
        this.lbSituacaoAnoAtual.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
        this.lbSituacaoAnoAnterior.setFont(FontesUtil.FONTE_NORMAL);
        this.lbSituacaoAnoAnterior.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbSituacaoAnoAnterior.setLabelFor((Component)this.edtValorAnterior);
        this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
        this.edtPercentualParticipacao.getComponenteEditor().setFocusable(false);
        this.btnPercentualParticipacao.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icones/png20px/RE_calc.png")));
        this.btnPercentualParticipacao.setToolTipText("Percentual de Participa\u00e7\u00e3o");
        this.btnPercentualParticipacao.setActionCommand("OK");
        this.btnPercentualParticipacao.setName("btnPercentualParticipacao");
        this.btnPercentualParticipacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalheEspolio.this.btnPercentualParticipacaoActionPerformed(evt);
            }
        });
        this.lbRepetir.setFont(FontesUtil.FONTE_NORMAL);
        this.lbRepetir.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbRepetir.setText("<HTML>Repete em 31/12/" + ConstantesGlobais.ANO_BASE + " o valor<BR>em reais de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        this.lbRepetir.setVerticalAlignment(1);
        this.btnRepetir.setMnemonic('R');
        this.btnRepetir.setText("Repetir");
        this.btnRepetir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalheEspolio.this.btnRepetirActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbSituacaoAnoAnterior).addGroup(jPanel2Layout.createSequentialGroup().addComponent((Component)this.edtValorAnterior, -2, 156, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPercentualParticipacao))).addGap(1, 1, 1).addComponent((Component)this.edtPercentualParticipacao, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbSituacaoAnoAtual).addGroup(jPanel2Layout.createSequentialGroup().addComponent((Component)this.edtValorAtual, -2, 148, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRepetir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbRepetir))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.lbSituacaoAnoAnterior).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtValorAnterior, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.lbSituacaoAnoAtual).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(2, 2, 2).addComponent((Component)this.edtPercentualParticipacao, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPercentualParticipacao, -2, 27, -2)).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnRepetir, -2, 27, -2).addComponent(this.lbRepetir, -2, 35, -2).addComponent((Component)this.edtValorAtual, -2, -1, -2)))))).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtValorAnterior.getAccessibleContext().setAccessibleName((String)(this.isEspolio() ? "Situa\u00e7\u00e3o na data da partilha (R$)" : "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)"));
        this.edtValorAtual.getAccessibleContext().setAccessibleName(this.isSaida() ? "Situa\u00e7\u00e3o na data da caracteriza\u00e7\u00e3o de n\u00e3o residente (R$)" : "Valor de transfer\u00eancia (R$)");
        this.btnPercentualParticipacao.getAccessibleContext().setAccessibleName("Quadro auxiliar para preenchimendo dos percentuais de participa\u00e7\u00e3o no bem");
        this.btnRepetir.getAccessibleContext().setAccessibleName((String)(this.isSaida() ? "Se o valor na data da caracteriza\u00e7\u00e3o de n\u00e3o residente for igual ao valor de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR : "Se o valor de transfer\u00eancia for igual ao valor na data da partilha"));
        this.pnlRendimentos.setBorder(BorderFactory.createTitledBorder(null, "Rendimentos Associados", 1, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.pnlRendimentos.setOpaque(false);
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new FlowLayout(1, 10, 5));
        this.btnRendIsento.setText("Informar Rend. Isento");
        this.btnRendIsento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalheEspolio.this.btnRendIsentoActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnRendIsento);
        this.btnRendExclusivo.setText("Informar Rend. Exclusivo");
        this.btnRendExclusivo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensDetalheEspolio.this.btnRendExclusivoActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnRendExclusivo);
        GroupLayout pnlRendimentosLayout = new GroupLayout(this.pnlRendimentos);
        this.pnlRendimentos.setLayout(pnlRendimentosLayout);
        pnlRendimentosLayout.setHorizontalGroup(pnlRendimentosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRendimentosLayout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        pnlRendimentosLayout.setVerticalGroup(pnlRendimentosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -2, 49, -2));
        this.pnlAplicacaoFinanceira.setBorder(BorderFactory.createTitledBorder(null, "Aplica\u00e7\u00e3o Financeira", 1, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.pnlAplicacaoFinanceira.setOpaque(false);
        this.lblLucroPrejuizo.setFont(FontesUtil.FONTE_NORMAL);
        this.lblLucroPrejuizo.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblLucroPrejuizo.setText("Lucro ou Preju\u00edzo");
        this.edtLucroPrejuizo.setAceitaNumerosNegativos(true);
        this.lblImpostoPagoExt.setFont(FontesUtil.FONTE_NORMAL);
        this.lblImpostoPagoExt.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblImpostoPagoExt.setText("Imposto pago no Exterior ");
        this.lblMsgDepositoRemunerado.setFont(FontesUtil.FONTE_NORMAL);
        this.lblMsgDepositoRemunerado.setForeground(Color.red);
        this.lblMsgDepositoRemunerado.setText("Somente se forem remunerados");
        GroupLayout pnlAplicacaoFinanceiraLayout = new GroupLayout(this.pnlAplicacaoFinanceira);
        this.pnlAplicacaoFinanceira.setLayout(pnlAplicacaoFinanceiraLayout);
        pnlAplicacaoFinanceiraLayout.setHorizontalGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAplicacaoFinanceiraLayout.createSequentialGroup().addContainerGap().addGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLucroPrejuizo).addComponent((Component)this.edtLucroPrejuizo, -2, 156, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblImpostoPagoExt).addGroup(pnlAplicacaoFinanceiraLayout.createSequentialGroup().addComponent((Component)this.edtImpostoPagoExt, -2, 156, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMsgDepositoRemunerado))).addContainerGap(-1, Short.MAX_VALUE)));
        pnlAplicacaoFinanceiraLayout.setVerticalGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAplicacaoFinanceiraLayout.createSequentialGroup().addContainerGap().addGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlAplicacaoFinanceiraLayout.createSequentialGroup().addComponent(this.lblImpostoPagoExt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlAplicacaoFinanceiraLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtImpostoPagoExt, -2, -1, -2).addComponent(this.lblMsgDepositoRemunerado))).addGroup(pnlAplicacaoFinanceiraLayout.createSequentialGroup().addComponent(this.lblLucroPrejuizo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtLucroPrejuizo, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlLucrosDividendos.setBorder(BorderFactory.createTitledBorder(null, "Lucros e Dividendos", 1, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.pnlLucrosDividendos.setOpaque(false);
        this.lblValorRecebido.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValorRecebido.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValorRecebido.setText("Valor Recebido");
        this.lblImpostoExteriorIRRF.setFont(FontesUtil.FONTE_NORMAL);
        this.lblImpostoExteriorIRRF.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblImpostoExteriorIRRF.setText("Imposto Pago Exterior/IRRF Brasil");
        GroupLayout pnlLucrosDividendosLayout = new GroupLayout(this.pnlLucrosDividendos);
        this.pnlLucrosDividendos.setLayout(pnlLucrosDividendosLayout);
        pnlLucrosDividendosLayout.setHorizontalGroup(pnlLucrosDividendosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlLucrosDividendosLayout.createSequentialGroup().addContainerGap().addGroup(pnlLucrosDividendosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblValorRecebido).addComponent((Component)this.edtValorRecebido, -2, 156, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlLucrosDividendosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblImpostoExteriorIRRF).addComponent((Component)this.edtImpostoExteriorIRRF, -2, 156, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlLucrosDividendosLayout.setVerticalGroup(pnlLucrosDividendosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlLucrosDividendosLayout.createSequentialGroup().addContainerGap().addGroup(pnlLucrosDividendosLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlLucrosDividendosLayout.createSequentialGroup().addComponent(this.lblImpostoExteriorIRRF).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtImpostoExteriorIRRF, -2, -1, -2)).addGroup(pnlLucrosDividendosLayout.createSequentialGroup().addComponent(this.lblValorRecebido).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtValorRecebido, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.pnlAplicacaoFinanceira, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlLucrosDividendos, -2, -1, -2)).addComponent(this.pnlRendimentos, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlRendimentos, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlAplicacaoFinanceira, -2, -1, -2).addComponent(this.pnlLucrosDividendos, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Dados do Bem / Direito");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnPercentualParticipacaoActionPerformed(ActionEvent evt) {
        GuiUtil.exibeDialog((JComponent)((Object)new PainelPercentualParticipacaoInventarioLista(this.getBem().getParticipacoesInventario())), (boolean)true, (String)"Quadro Auxiliar Percentual de Participa\u00e7\u00e3o no Invent\u00e1rio", (boolean)false, (boolean)true);
        this.bem.getValorExercicioAnteriorAssociadoJButton().forcaDisparoObservadores();
    }

    private void btnRepetirActionPerformed(ActionEvent evt) {
        this.edtValorAtual.getInformacao().setConteudo(this.edtValorAnterior.getInformacao().formatado());
    }

    private void edtNiBemFocusLost(FocusEvent evt) {
        this.edtNiBem.chamaValidacao();
    }

    private void rdoUnidadeM2FocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdoUnidadeHa) {
            this.edtUnidade.chamaValidacao();
        }
    }

    private void rdoUnidadeHaFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdoUnidadeM2) {
            this.edtUnidade.chamaValidacao();
        }
    }

    private void rdoRegistroCartorioSimFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdoRegistroCartorioNao) {
            this.edtRegistroCartorio.chamaValidacao();
        }
    }

    private void rdoRegistroCartorioNaoFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdoRegistroCartorioSim) {
            this.edtRegistroCartorio.chamaValidacao();
        }
    }

    private void edtRegistroCartorioAtualizaPainel(GroupPanelEvent evt) {
        this.habilitaCampoBemImovelRegistrado(evt.getInformacao().naoFormatado(), this.getBem().getPais().naoFormatado());
    }

    private void chkBemInventariarActionPerformed(ActionEvent evt) {
        this.bem.getIndicadorBemInventariar().setConteudo(this.chkBemInventariar.isSelected() ? "1" : "0");
        this.habilitarBotaoPercentualParticipacao();
        this.alterarLabel();
    }

    private void btnRendIsentoActionPerformed(ActionEvent evt) {
        String codigoRendimento = this.bem.buscarTipoRendimentoIsento(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado());
        ItemQuadroAuxiliarAb rendimento = this.bem.buscarRendimentoIsentoAssociado(codigoRendimento, ControladorGui.getDemonstrativoAberto());
        boolean novoItemBem = false;
        if (rendimento == null && (rendimento = this.bem.buscarRendimentoIsentoVazio(ControladorGui.getDemonstrativoAberto())) == null) {
            rendimento = ControladorGui.getDemonstrativoAberto().getRendIsentos().criarNovoRendimentoIsento(this.bem, codigoRendimento);
            rendimento.getTipoBeneficiario().setConteudo("Titular");
            rendimento.getCpfBeneficiario().setConteudo(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf());
            novoItemBem = true;
        }
        if (RendIsentos.TIPO_RENDISENTO_26.equals(codigoRendimento)) {
            codigoRendimento = RendIsentos.TIPO_RENDISENTO_OUTROS_TELA;
        }
        PainelDadosRendIsentos painelPai = new PainelDadosRendIsentos();
        PainelAbaRendIsentosDetalhes painelRendIsentos = new PainelAbaRendIsentosDetalhes((PainelDemonstrativoIf)painelPai, codigoRendimento, rendimento, true, novoItemBem);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painelRendIsentos);
        JTaskAction task = new JTaskAction("Rendimentos Isentos e N\u00e3o Tribut\u00e1veis", NavegacaoIf.PAINEL_REND_ISENTOS, (Icon)GuiUtil.getImage((String)"/icones/png20px/DE_rend_isent.png"), true);
        ControladorGui.getJanelaPrincipal().getAbas().setFicha("Rendimentos Isentos e N\u00e3o Tribut\u00e1veis", task, true);
    }

    private void btnRendExclusivoActionPerformed(ActionEvent evt) {
        String codigoRendimento = this.bem.buscarTipoRendimentoExclusivo(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado());
        ItemQuadroAuxiliarAb rendimento = this.bem.buscarRendimentoExclusivoAssociado(codigoRendimento, ControladorGui.getDemonstrativoAberto());
        boolean novoItemBem = false;
        if (rendimento == null && (rendimento = this.bem.buscarRendimentoExclusivoVazio(ControladorGui.getDemonstrativoAberto())) == null) {
            rendimento = ControladorGui.getDemonstrativoAberto().getRendTributacaoExclusiva().criarNovoRendimentoExclusivo(this.bem, codigoRendimento);
            rendimento.getTipoBeneficiario().setConteudo("Titular");
            rendimento.getCpfBeneficiario().setConteudo(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf());
            novoItemBem = true;
        }
        PainelDadosRendTributExclusiva painelPai = new PainelDadosRendTributExclusiva();
        PainelAbaRendTributEclusivaDetalhes painelRendExclusivo = new PainelAbaRendTributEclusivaDetalhes((PainelDemonstrativoIf)painelPai, codigoRendimento, rendimento, true, novoItemBem);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painelRendExclusivo);
        JTaskAction task = new JTaskAction("Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva", NavegacaoIf.PAINEL_REND_SUJ_TRIB_EXCLUSIVA, (Icon)GuiUtil.getImage((String)"/icones/png20px/DE_rend_excl.png"), true);
        ControladorGui.getJanelaPrincipal().getAbas().setFicha("Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva", task, true);
    }

    private void rdoNegociadoBolsaSimFocusLost(FocusEvent evt) {
    }

    private void rdoNegociadoBolsaNaoFocusLost(FocusEvent evt) {
    }

    private void edtNegociadoBolsaAtualizaPainel(GroupPanelEvent evt) {
        this.habilitaCampoCodigoNegociacao(evt.getInformacao().naoFormatado());
    }

    private void grpAutoCustodianteAtualizaPainel(GroupPanelEvent evt) {
        this.habilitarCampoNI(this.getBem().getGrupo().naoFormatado(), this.getBem().getCodigo().naoFormatado(), this.getBem().getPais().naoFormatado(), evt.getInformacao().naoFormatado());
    }

    private void chkAtualizacaoValorBemActionPerformed(ActionEvent evt) {
        if (this.chkAtualizacaoValorBem.isSelected()) {
            this.bem.getAtualizadoValorBem().setConteudo(Logico.SIM);
        } else {
            this.bem.getAtualizadoValorBem().setConteudo(Logico.NAO);
        }
    }

    private void grpProprietarioUsufrutuarioAtualizaPainel(GroupPanelEvent evt) {
        this.habilitaInformacaoCPFCNPJProprietarioUsufrutuario(evt.getInformacao().naoFormatado());
    }

    private void chkBemComUsufrutoActionPerformed(ActionEvent evt) {
        this.bem.getIndicadorBemComUsufruto().setConteudo(this.chkBemComUsufruto.isSelected() ? "1" : "0");
        this.habilitarRadioProprietarioUsufrutuario();
    }

    private void btProprietarioUsufrutuarioActionPerformed(ActionEvent evt) {
        GuiUtil.exibeDialog((JComponent)((Object)new PainelQuadroAuxiliarProprietariosUsufrutuariosLista(this.bem.getProprietariosUsufrutuariosBem(), "Proprietarios/Usufrutuarios", this.bem.getIndice().naoFormatado())), (boolean)true, (String)"Proprietarios/Usufrutuarios", (boolean)true);
    }

    private void chkContaPagamentoActionPerformed(ActionEvent evt) {
        this.bem.getIndicadorContaPagamento().setConteudo(this.chkContaPagamento.isSelected() ? "1" : "0");
    }

    private void btnReclassificarActionPerformed(ActionEvent evt) {
        if ("99".equals(this.bem.getGrupo().naoFormatado()) && "99".equals(this.bem.getCodigo().naoFormatado())) {
            GuiUtil.exibeDialog((JComponent)((Object)new PainelSelecaoGrupoCodigoBem(this.bem, this)), (boolean)true, (String)"Selecione o Grupo/c\u00f3digo do bem", (boolean)false);
        } else {
            GuiUtil.exibeDialog((JComponent)((Object)new PainelSelecaoCodigoBem(this.bem, this)), (boolean)true, (String)"Selecione o c\u00f3digo do bem", (boolean)false);
        }
    }

    private void habilitarBotaoPercentualParticipacao() {
        this.edtPercentualParticipacao.chamaValidacao();
        if (this.bem.getIndicadorBemInventariar().naoFormatado().equals("1")) {
            this.btnPercentualParticipacao.setEnabled(false);
            this.bem.getParticipacoesInventario().clear();
        } else {
            this.btnPercentualParticipacao.setEnabled(true);
        }
    }

    private void habilitarBotoesRendimento(String grupo, String codBem) {
        boolean localizacaoBrasil = true;
        if (((JComboBox)this.edtLocalizacao.getComponenteEditor()).getSelectedIndex() != -1) {
            ElementoTabela elem = (ElementoTabela)((JComboBox)this.edtLocalizacao.getComponenteEditor()).getSelectedItem();
            if (!"105".equals(elem.getConteudo(0))) {
                localizacaoBrasil = false;
            }
        } else {
            localizacaoBrasil = false;
        }
        String isento = this.bem.buscarTipoRendimentoIsento(grupo, codBem);
        String exclusivo = this.bem.buscarTipoRendimentoExclusivo(grupo, codBem);
        this.pnlRendimentos.setVisible(localizacaoBrasil && (isento != null || exclusivo != null));
        this.btnRendIsento.setVisible(isento != null);
        this.btnRendExclusivo.setVisible(exclusivo != null);
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_bens.png");
    }

    public JComponent getDefaultFocus() {
        return this.edtGrupo;
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (this.emEdicao) {
            if (ehTransmitida) {
                return "Detalhe Bem e Direito";
            }
            return "Editar Bem e Direito";
        }
        return "Novo Bem e Direito";
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_BENS_DIREITOS);
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            ControladorGui.getDemonstrativoAberto().getBens().remove((ObjetoNegocio)this.bem);
            ControladorGui.getDemonstrativoAberto().getBens().add((ObjetoNegocio)this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getBens().remove((ObjetoNegocio)this.bem);
        }
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_BENS_DIREITOS);
    }

    public void preExibir() {
        this.alterarLabel();
        this.habilitarCampoBanco(this.bem.getPais().naoFormatado(), this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado());
        this.corrigirCNPJRendimentos();
        this.habilitarSelecaoGrupoCodigo();
        if (this.emEdicao) {
            this.exibirMensagem524ou525(this.bem.getGrupo().naoFormatado(), this.bem.getPais().naoFormatado());
        }
    }

    private void corrigirCNPJRendimentos() {
        String codigoRendimento = this.bem.buscarTipoRendimentoIsento(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado());
        ItemQuadroAuxiliarAb rendimento = this.bem.buscarRendimentoIsentoAssociado(codigoRendimento, ControladorGui.getDemonstrativoAberto());
        if (rendimento != null) {
            rendimento.getNIFontePagadora().setConteudo(this.bem.getNiEmpresa());
        }
        if ((rendimento = this.bem.buscarRendimentoExclusivoAssociado(codigoRendimento = this.bem.buscarTipoRendimentoExclusivo(this.bem.getGrupo().naoFormatado(), this.bem.getCodigo().naoFormatado()), ControladorGui.getDemonstrativoAberto())) != null) {
            rendimento.getNIFontePagadora().setConteudo(this.bem.getNiEmpresa());
        }
    }

    private void alterarLabel() {
        if (this.isEspolio() && !this.bem.isBemInventariarMarcado()) {
            this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o na data da partilha (R$)");
            this.lbSituacaoAnoAtual.setText("Valor de transfer\u00eancia (R$)");
            this.lbRepetir.setText("<HTML>Se o valor de transfer\u00eancia for igual<BR>ao valor na data da partilha</HTML>");
        } else if (this.isSaida()) {
            this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
            this.lbSituacaoAnoAtual.setText("<HTML>Situa\u00e7\u00e3o na data da<BR>caracteriza\u00e7\u00e3o de n\u00e3o residente (R$)</HTML>");
            this.lbRepetir.setText("<HTML>Se o valor na data da caracteriza\u00e7\u00e3o de n\u00e3o residente for igual ao valor de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        } else {
            this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
            this.lbSituacaoAnoAtual.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
            this.lbRepetir.setText("<HTML>Repete em 31/12/" + ConstantesGlobais.ANO_BASE + " o valor<BR>em reais de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        }
    }

    private boolean isEspolio() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio();
    }

    private boolean isSaida() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida();
    }

    public PainelBensDetalheEspolioBrasil getPainelImovelBrasil() {
        return this.painelImovelBrasil;
    }

    public void setPainelImovelBrasil(PainelBensDetalheEspolioBrasil painelImovelBrasil) {
        this.painelImovelBrasil = painelImovelBrasil;
    }

    public PainelBensDetalheEspolioExterior getPainelImovelExterior() {
        return this.painelImovelExterior;
    }

    public void setPainelImovelExterior(PainelBensDetalheEspolioExterior painelImovelExterior) {
        this.painelImovelExterior = painelImovelExterior;
    }

    public Bem getBem() {
        return this.bem;
    }

    public void setBem(Bem bem) {
        this.bem = bem;
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }

    public String getMensagemTela() {
        return this.obterMensagemTela();
    }

    public boolean isTelaComMensagem() {
        return this.obterMensagemTela() != null;
    }

    private String obterMensagemTela() {
        String msg = null;
        if (this.bem.getGrupo().naoFormatado().equals("07") && this.bem.getIndicadorReclassificar().naoFormatado().equals("1") && this.bem.getCodigo().naoFormatado().equals("99")) {
            msg = MensagemUtil.getMensagem((String)"bem_07_99_reclassificar");
        }
        return msg;
    }

    private void habilitarSelecaoGrupoCodigo() {
        if (this.bem.getIndicadorReclassificar().naoFormatado().equals("1")) {
            this.edtGrupo.getComponenteFoco().setEnabled(false);
            this.edtCodigoBem.getComponenteFoco().setEnabled(false);
            this.btnReclassificar.setVisible(true);
        } else {
            this.edtGrupo.getComponenteFoco().setEnabled(true);
            this.edtCodigoBem.getComponenteFoco().setEnabled(true);
            this.btnReclassificar.setVisible(false);
        }
    }

    private void confirmarReclassificacao(String codBem) {
        if (!"-1".equals(codBem) && this.bem.getIndicadorReclassificar().naoFormatado().equals("1")) {
            this.bem.getIndicadorReclassificar().setConteudo("2");
        }
    }

    public JAutoCompleteEditCodigo getEdtGrupoBem() {
        return this.edtGrupo;
    }

    public JAutoCompleteEditCodigo getEdtCodigoBem() {
        return this.edtCodigoBem;
    }

    public JButton getBtnReclassificar() {
        return this.btnReclassificar;
    }
}

