/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.bens;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.bens.BensToolBarListener;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.ConstantesGlobais;

public class JIRPFToolbarBens
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private List<BensToolBarListener> listaEscutadores;
    private IRPFLabelInfo iRPFLabelInfo1;
    private JButton jButtonAbrir;
    private JButton jButtonExcluir;
    private JButton jButtonNovo;
    private JButton jButtonRepetir;

    public JIRPFToolbarBens() {
        this.initComponents();
        this.inibirEnterNavegacaoFocoBotoes();
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.jButtonNovo.setFocusTraversalKeys(0, set);
        this.jButtonAbrir.setFocusTraversalKeys(0, set);
        this.jButtonExcluir.setFocusTraversalKeys(0, set);
        this.jButtonRepetir.setFocusTraversalKeys(0, set);
    }

    private void dispatchOnBtnAbrirClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (BensToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnAbrirClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    private void dispatchOnBtnExcluirClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (BensToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnExcluirClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    private void dispatchOnBtnNovoClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (BensToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnNovoClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    private void dispatchOnBtnRepetirClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (BensToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnRepetirClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    public void addToolBarListener(BensToolBarListener pListener) {
        if (this.listaEscutadores == null) {
            this.listaEscutadores = new ArrayList<BensToolBarListener>();
        }
        this.listaEscutadores.add(pListener);
    }

    public void removeToolBarListener(BensToolBarListener pListener) {
        if (this.listaEscutadores != null) {
            this.listaEscutadores.remove(pListener);
            if (this.listaEscutadores.isEmpty()) {
                this.listaEscutadores = null;
            }
        }
    }

    public JButton getBtnAbrir() {
        return this.jButtonAbrir;
    }

    public JButton getBtnNovo() {
        return this.jButtonNovo;
    }

    public JButton getBtnExcluir() {
        return this.jButtonExcluir;
    }

    private void initComponents() {
        this.iRPFLabelInfo1 = new IRPFLabelInfo(this.obterTextoInformacao(), true);
        this.jButtonRepetir = new JButton();
        this.jButtonNovo = new JButton();
        this.jButtonAbrir = new JButton();
        this.jButtonExcluir = new JButton();
        this.setBorder(null);
        this.setOpaque(false);
        this.setLayout(new FlowLayout(2));
        this.add((Component)this.iRPFLabelInfo1);
        this.jButtonRepetir.setMnemonic('r');
        this.jButtonRepetir.setText("Repetir valores");
        this.jButtonRepetir.setEnabled(false);
        this.jButtonRepetir.setPreferredSize(new Dimension(150, 25));
        this.jButtonRepetir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIRPFToolbarBens.this.jButtonRepetirActionPerformed(evt);
            }
        });
        this.add(this.jButtonRepetir);
        this.jButtonRepetir.getAccessibleContext().setAccessibleDescription(this.obterTextoInformacao());
        this.jButtonNovo.setMnemonic('n');
        this.jButtonNovo.setText("Novo");
        this.jButtonNovo.setToolTipText("Novo");
        this.jButtonNovo.setPreferredSize(new Dimension(90, 25));
        this.jButtonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIRPFToolbarBens.this.jButtonNovoActionPerformed(evt);
            }
        });
        this.add(this.jButtonNovo);
        this.jButtonAbrir.setMnemonic('e');
        this.jButtonAbrir.setText("Editar");
        this.jButtonAbrir.setToolTipText("Editar");
        this.jButtonAbrir.setEnabled(false);
        this.jButtonAbrir.setPreferredSize(new Dimension(90, 25));
        this.jButtonAbrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIRPFToolbarBens.this.jButtonAbrirActionPerformed(evt);
            }
        });
        this.add(this.jButtonAbrir);
        this.jButtonExcluir.setMnemonic('x');
        this.jButtonExcluir.setText("Excluir");
        this.jButtonExcluir.setToolTipText("Excluir");
        this.jButtonExcluir.setEnabled(false);
        this.jButtonExcluir.setPreferredSize(new Dimension(90, 25));
        this.jButtonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIRPFToolbarBens.this.jButtonExcluirActionPerformed(evt);
            }
        });
        this.add(this.jButtonExcluir);
    }

    private void jButtonNovoActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnNovoClick(evt);
    }

    private void jButtonAbrirActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnAbrirClick(evt);
    }

    private void jButtonExcluirActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnExcluirClick(evt);
    }

    private void jButtonRepetirActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnRepetirClick(evt);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        this.jButtonAbrir.setEnabled(!lsm.isSelectionEmpty() && lsm.getMinSelectionIndex() == lsm.getMaxSelectionIndex());
        if (ControladorGui.isReadOnly()) {
            this.jButtonExcluir.setEnabled(false);
            this.jButtonRepetir.setEnabled(false);
        } else {
            this.jButtonExcluir.setEnabled(!lsm.isSelectionEmpty());
            this.jButtonRepetir.setEnabled(!lsm.isSelectionEmpty());
        }
    }

    private String obterTextoInformacao() {
        IdentificadorDeclaracao id = IRPFFacade.getInstancia().getIdDeclaracaoAberto();
        StringBuilder retorno = new StringBuilder();
        if (id != null) {
            if (id.isAjuste()) {
                retorno.append("<HTML>Repete em 31/12/" + ConstantesGlobais.ANO_BASE + " o(s) valor(es) em reais de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " do(s) bem(ns) selecionado(s).");
            } else if (id.isEspolio()) {
                retorno.append("<HTML>Se valor de transfer\u00eancia igual ao valor na data da partilha do(s) bem(ns) selecionado(s).");
            } else if (id.isSaida()) {
                retorno.append("<HTML>Repete na data da caracteriza\u00e7\u00e3o da condi\u00e7\u00e3o de n\u00e3o residente, o(s) valor(es) em reais de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " do(s) bem(ns) selecionado(s).");
            }
        } else {
            return "";
        }
        String tecla = System.getProperty("os.name").toLowerCase().startsWith("mac") ? "Command" : "Ctrl";
        retorno.append("<BR><BR><I>Mantenha pressionada a tecla " + tecla + " para selecionar mais de um item.</I></HTML>");
        return retorno.toString();
    }
}

