/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.alimentandos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.JIRPFToolbar;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelPrincipalAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.TableListaSumario;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandosDetalhe;
import serpro.ppgd.irpf.gui.alimentandos.TableModelAlimentandos;
import serpro.ppgd.irpf.gui.listener.ToolBarListener;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.IRPFTableDecorator;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAlimentandosLista
extends PainelPrincipalAb {
    private static final long serialVersionUID = 1L;
    protected Colecao<? extends ObjetoNegocio> colecao;
    private static final String TITULO = "Alimentandos";
    private JCheckBox chkConfirmacao;
    private JIRPFToolbar irpfToolbar;
    private JScrollPane jScrollPane1;
    private TableLista tableLista;

    public PainelAlimentandosLista(boolean construir, boolean exibirBotoesToolbar) {
        if (construir) {
            this.construirUI();
        }
        if (this.irpfToolbar != null) {
            this.irpfToolbar.setVisible(exibirBotoesToolbar);
        }
    }

    public void ajustarToolBarImportar() {
        this.getIrpfToolbar().getBtnNovo().setText("Importar");
        this.getIrpfToolbar().getBtnAbrir().setText("Abrir");
    }

    public void ocultarToolBar() {
        if (this.getIrpfToolbar() != null) {
            this.getIrpfToolbar().setVisible(false);
        }
    }

    public PainelAlimentandosLista() {
        this.colecao = null;
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), this.getButtonHelpID());
        this.initComponents();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        IRPFTableDecorator.decorate((IRPFTableAb)this.getTabela(), (ToolBarListener)this);
        this.getTabela().getSelectionModel().addListSelectionListener((ListSelectionListener)this.irpfToolbar);
        if (this.getTabela().getModel().getRowCount() > 0) {
            this.getTabela().selecionaCelula(1, 0);
        }
        this.limparReferenciasInvalidas();
    }

    public PainelAlimentandosLista(Colecao<? extends ObjetoNegocio> colecao) {
        this.construirUI();
    }

    public void construirUI() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), this.getButtonHelpID());
        this.initComponents();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        IRPFTableDecorator.decorate((IRPFTableAb)this.getTabela(), (ToolBarListener)this);
        this.getTabela().getSelectionModel().addListSelectionListener((ListSelectionListener)this.irpfToolbar);
        if (this.getTabela().getModel().getRowCount() > 0) {
            this.getTabela().selecionaCelula(1, 0);
        }
        this.limparReferenciasInvalidas();
    }

    private void limparReferenciasInvalidas() {
        if (ControladorGui.getDemonstrativoAberto() != null) {
            ControladorGui.getDemonstrativoAberto().getAlimentandos().limparReferenciasInvalidasAlimentando(ControladorGui.getDemonstrativoAberto());
        }
    }

    private void initComponents() {
        this.chkConfirmacao = new JCheckBox();
        this.irpfToolbar = new JIRPFToolbar();
        this.jScrollPane1 = new JScrollPane();
        this.tableLista = this.instanciarTabela(this.getTableModel(), this.getColunaOrdenacao(), this.getColunasOrdenaveis());
        this.setBackground(new Color(241, 245, 249));
        this.chkConfirmacao.setBackground(new Color(241, 245, 249));
        this.chkConfirmacao.setFont(FontesUtil.FONTE_NORMAL);
        this.chkConfirmacao.setText("<html> Estou ciente de que os alimentandos informados devem se enquadrar nos requisitos acima.</html>");
        this.chkConfirmacao.setVerticalTextPosition(1);
        this.chkConfirmacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAlimentandosLista.this.chkConfirmacaoActionPerformed(evt);
            }
        });
        this.irpfToolbar.addToolBarListener((ToolBarListener)this);
        this.jScrollPane1.setViewportView((Component)this.tableLista);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.irpfToolbar, -2, -1, -2).add(24, 24, 24)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 590, Short.MAX_VALUE).addContainerGap()).add((Component)this.chkConfirmacao, -2, 0, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.chkConfirmacao, -2, -1, -2).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 338, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.irpfToolbar, -2, -1, -2)));
    }

    private void chkConfirmacaoActionPerformed(ActionEvent evt) {
        IRPFFacade.getInstancia().getAlimentandos().getConfirmacao().setConteudo(this.chkConfirmacao.isSelected() ? "S" : "N");
    }

    public IRPFTableAb getTabela() {
        return this.tableLista;
    }

    public void preExibir() {
        if (((IRPFTableModelAb)this.getTabela().getModel()).getObjetoNegocio() instanceof Colecao) {
            ((Colecao)((IRPFTableModelAb)this.getTabela().getModel()).getObjetoNegocio()).excluirRegistrosEmBranco();
        }
        ((IRPFTableModelAb)this.getTabela().getModel()).refresh();
        this.chkConfirmacao.setSelected(IRPFFacade.getInstancia().getAlimentandos().getConfirmacao().naoFormatado().equals("S"));
    }

    public void onBtnExcluirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        boolean temSumario = tabela instanceof TableListaSumario;
        if (!(tabela.getSelectedRowCount() <= 0 || temSumario && tabela.getSelectedRow() >= tabela.getRowCount() - 1)) {
            int[] linhasTabela = tabela.getSelectedRows();
            if (GuiUtil.mostrarConfirmaNaoPadrao((String)this.getMensagemExclusao(), (String[])this.getParametrosMensagemExclusao())) {
                TableListaModel model = (TableListaModel)tabela.getModel();
                ArrayList<Integer> linhasExcluidas = new ArrayList<Integer>();
                for (int linhaTabela : linhasTabela) {
                    int indiceVetor;
                    ObjetoNegocio objetoNegocio;
                    if (temSumario && linhaTabela >= tabela.getRowCount() - 1 || !this.validarExclusao(objetoNegocio = model.getObjetoNegocio(indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela)))) continue;
                    linhasExcluidas.add(new Integer(indiceVetor));
                }
                model.removeObjetoNegocio(linhasExcluidas.toArray(new Integer[linhasExcluidas.size()]));
            }
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public JComponent getDefaultFocus() {
        return this.chkConfirmacao;
    }

    public JIRPFToolbar getIrpfToolbar() {
        return this.irpfToolbar;
    }

    public Colecao<? extends ObjetoNegocio> getColecao() {
        return this.colecao;
    }

    public String getHelpID() {
        return this.getButtonHelpID();
    }

    protected String getButtonHelpID() {
        return "Fichas da Declara\u00e7\u00e3o/Alimentandos";
    }

    protected String getClassePainelNavegacao() {
        return PainelAlimentandosDetalhe.class.getName();
    }

    public String getTituloPainel() {
        return TITULO;
    }

    protected int getColunaOrdenacao() {
        return 1;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    protected TableListaModel getTableModel() {
        return new TableModelAlimentandos(IRPFFacade.getInstancia().getAlimentandos());
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista2 = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista2.accessibleColumnHeader = new String[]{"Item", "Nome", "Residente", "Data de Nascimento", "CPF"};
        return tableLista2;
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(200);
        tcm.getColumn(2).setPreferredWidth(50);
        tcm.getColumn(3).setPreferredWidth(50);
        tcm.getColumn(4).setPreferredWidth(50);
    }

    public void onBtnNovoClick(ActionEvent e) {
        TableModelAlimentandos lModel = (TableModelAlimentandos)((Object)this.getTabela().getModel());
        Alimentando lItem = new Alimentando(IRPFFacade.getInstancia().getDeclaracao());
        IRPFFacade.getInstancia().getAlimentandos().itens().add(lItem);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelAlimentandosDetalhe((PainelDemonstrativoIf)this, lItem, false));
        lModel.refresh();
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
            Alimentandos colAlimentandos = (Alimentandos)model.getObjetoNegocio();
            Alimentando alimentando = (Alimentando)colAlimentandos.itens().get(indiceVetor);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelAlimentandosDetalhe((PainelDemonstrativoIf)this, alimentando, true));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public boolean validarExclusao(ObjetoNegocio objetoNegocio) {
        Alimentando alimentando = (Alimentando)objetoNegocio;
        return IRPFFacade.getInstancia().getAlimentandos().confirmaExclusaoRelacionadasAlimentando(alimentando.getNome().naoFormatado());
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens1";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"alimentando(s)"};
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_aliment.png");
    }

    public boolean isTelaComFavoritos() {
        return true;
    }

    public String getMensagemTela() {
        return "<html>Nesta ficha devem ser informados os alimentandos que,  em raz\u00e3o de decis\u00e3o judicial, acordo homologado judicialmente ou escritura p\u00fablica a que se refere o art. 733 da Lei n\u00ba 13.105, de 16 de mar\u00e7o de 2015 - C\u00f3digo de Processo Civil, o declarante tenha pago em favor deles:<br><br> a) pens\u00e3o aliment\u00edcia; ou <br>b) despesas com instru\u00e7\u00e3o ou m\u00e9dicas.</html>";
    }

    public boolean isTelaComMensagem() {
        return true;
    }
}

