'use strict';Object.defineProperty(exports,'__esModule',{value:true});var require$$0$6=require('util'),require$$1$5=require('console'),require$$0$p=require('process'),require$$0$9=require('dns'),require$$0$7=require('net'),require$$0$8=require('events'),require$$0$a=require('crypto'),require$$0$b=require('stream'),require$$1$1=require('tls'),require$$0$c=require('os'),require$$1$2=require('path'),require$$0$d=require('fs'),require$$2$3=require('https'),require$$0$e=require('zlib'),require$$0$f=require('url'),require$$0$g=require('vm'),http=require('http'),require$$0$i=require('assert'),require$$0$h=require('tty'),node_path=require('node:path'),child_process=require('child_process'),require$$0$j=require('node:events'),require$$0$k=require('buffer'),require$$1$3=require('querystring'),require$$13=require('stream/web'),require$$0$l=require('node:stream'),require$$1$4=require('node:util'),require$$0$m=require('worker_threads'),require$$2$4=require('perf_hooks'),require$$5$2=require('util/types'),require$$4$1=require('async_hooks'),require$$1$6=require('string_decoder'),require$$0$n=require('diagnostics_channel'),require$$0$o=require('timers'),require$$0$q=require('fs/promises'),require$$0$r=require('timers/promises'),require$$5$3=require('constants'),os=require('node:os'),process$2=require('node:process'),http$1=require('node:http'),https=require('node:https'),zlib=require('node:zlib'),fs=require('node:fs'),require$$0$s=require('dgram'),require$$2$5=require('node:url'),rustyStoreKv=require('rusty-store-kv');function _interopNamespaceDefault(e){var n=Object.create(null);if(e){Object.keys(e).forEach(function(k){if(k!=='default'){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}});}})}n.default=e;return Object.freeze(n)}var child_process__namespace=/*#__PURE__*/_interopNamespaceDefault(child_process);var os__namespace=/*#__PURE__*/_interopNamespaceDefault(os);var process__namespace=/*#__PURE__*/_interopNamespaceDefault(process$2);var http__namespace=/*#__PURE__*/_interopNamespaceDefault(http$1);var https__namespace=/*#__PURE__*/_interopNamespaceDefault(https);var zlib__namespace=/*#__PURE__*/_interopNamespaceDefault(zlib);// @ts-nocheck
/**
 * 2011 Peter 'Pita' Martischka
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS-IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * This module is made for the case, you want to use a SQL-Based Databse or a KeyValue Database that
 * can only save strings(and no objects), as a JSON KeyValue Store.
 *
 * The idea of the dbWrapper is to provide following features:
 *
 *   * automatic JSON serialize/deserialize to abstract that away from the database driver and the
 *     module user.
 *   * cache reads. A amount of KeyValues are hold in the memory, so that reading is faster.
 *   * Buffer DB Writings. Sets and deletes should be buffered to make them in a setted interval
 *     with a bulk. This reduces the overhead of database transactions and makes the database
 *     faster. But there is also a danger to loose data integrity, to keep that, we should provide a
 *     flush function.
 *
 * All Features can be disabled or configured. The Wrapper provides default settings that can be
 * overwriden by the driver and by the module user.
 */
/**
 * Cache with Least Recently Used eviction policy.
 */
class LRU {
    /**
     * @param evictable Optional predicate that dictates whether it is permissable to evict the entry
     *     if it is old and the cache is over capacity. The predicate is passed two arguments (key,
     *     value). If no predicate is provided, all entries are evictable. Warning: Non-evictable
     *     entries can cause the cache to go over capacity. If the number of non-evictable entries is
     *     greater than or equal to the capacity, all new evictable entries will be evicted
     *     immediately.
     */
    constructor(capacity, evictable = (k, v) => true) {
        this._capacity = capacity;
        this._evictable = evictable;
        this._cache = new Map();
    }
    /**
     * The entries accessed via this iterator are not considered to have been "used" (for purposes of
     * determining least recently used).
     */
    [Symbol.iterator]() {
        return this._cache.entries();
    }
    /**
     * @param isUse Optional boolean indicating whether this get() should be considered a "use" of the
     *     entry (for determining least recently used). Defaults to true.
     * @returns undefined if there is no entry matching the given key.
     */
    get(k, isUse = true) {
        if (!this._cache.has(k))
            return;
        const v = this._cache.get(k);
        if (isUse) {
            // Mark this entry as the most recently used entry.
            this._cache.delete(k);
            this._cache.set(k, v);
        }
        return v;
    }
    /**
     * Adds or updates an entry in the cache. This marks the entry as the most recently used entry.
     */
    set(k, v) {
        this._cache.delete(k); // Make sure this entry is marked as the most recently used entry.
        this._cache.set(k, v);
        this.evictOld();
    }
    /**
     * Evicts the oldest evictable entries until the number of entries is equal to or less than the
     * cache's capacity. This method is automatically called by set(). Call this if you need to evict
     * newly evictable entries before the next call to set().
     */
    evictOld() {
        // ES Map objects iterate in insertion order, so the first items are the ones that have been
        // accessed least recently.
        for (const [k, v] of this._cache.entries()) {
            if (this._cache.size <= this._capacity)
                break;
            if (!this._evictable(k, v))
                continue;
            this._cache.delete(k);
        }
    }
}
// Same as Promise but with a `done` property set to a Node-style callback that resolves/rejects the
// Promise.
class SelfContainedPromise extends Promise {
    constructor(executor = null) {
        let done;
        super((resolve, reject) => {
            done = (err, val) => err != null ? reject(err) : resolve(val);
            if (executor != null)
                executor(resolve, reject);
        });
        this.done = done;
    }
}
const defaultSettings = {
    // Maximum number of operations that can be passed to the wrapped database's doBulk() method.
    // Falsy means no limit. EXPERIMENTAL.
    bulkLimit: 0,
    // the number of elements that should be cached. To Disable cache just set it to zero
    cache: 10000,
    // the interval in ms the wrapper writes to the database. To Disable interval writes just set it
    // to zero
    writeInterval: 100,
    // a flag if the data sould be serialized/deserialized to json
    json: true,
    // use utf8mb4 as default
    charset: 'utf8mb4',
};
const Database$1 = class Database {
    /**
     * @param wrappedDB The Database that should be wrapped
     * @param settings (optional) The settings that should be applied to the wrapper
     */
    constructor(wrappedDB, settings, logger) {
        // wrappedDB.isAsync is a temporary boolean that will go away once we have migrated all of the
        // database drivers from callback-based methods to async methods.
        if (wrappedDB.isAsync) {
            this.wrappedDB = wrappedDB;
        }
        else {
            this.wrappedDB = {};
            for (const fn of ['close', 'doBulk', 'findKeys', 'get', 'init', 'remove', 'set']) {
                const f = wrappedDB[fn];
                if (typeof f !== 'function')
                    continue;
                this.wrappedDB[fn] = require$$0$6.promisify(f.bind(wrappedDB));
            }
        }
        this.logger = logger;
        this.settings = Object.freeze({
            ...defaultSettings,
            ...(wrappedDB.settings || {}),
            ...(settings || {}),
        });
        // The key is the database key. The value is an object with the following properties:
        //   - value: The entry's value.
        //   - dirty: If the value has not yet been written, this is a Promise that will resolve once
        //     the write to the underlying database returns. If the value has been written this is null.
        //   - writingInProgress: Boolean that if true indicates that the value has been sent to the
        //     underlying database and we are awaiting commit.
        this.buffer = new LRU(this.settings.cache, (k, v) => !v.dirty && !v.writingInProgress);
        // Either null if flushing is currently allowed, or a Promise that will resolve when it is OK to
        // start flushing. The Promise has a `count` property that tracks the number of operations that
        // are currently preventing flush() from running.
        this._flushPaused = null;
        // Maps database key to a Promise that is resolved when the record is unlocked.
        this._locks = new Map();
        this.metrics = {
            // Count of times a database operation had to wait for the release of a record lock.
            lockAwaits: 0,
            // Count of times a record was locked.
            lockAcquires: 0,
            // Count of times a record was unlocked.
            lockReleases: 0,
            // Count of read operations (number of times `get()`, `getSub()`, and `setSub()` were called).
            // This minus `readsFinished` is the number of currently pending read operations.
            reads: 0,
            // Count of times a read operation failed, including JSON parsing errors. This divided by
            // `readsFinished` is the overall read error rate.
            readsFailed: 0,
            // Count of completed (successful or failed) read operations.
            readsFinished: 0,
            // Count of read operations that were satisfied from in-memory state (including the write
            // buffer).
            readsFromCache: 0,
            // Count of times the database was queried for a value. This minus `readsFromDbFinished` is
            // the number of in-progress reads.
            readsFromDb: 0,
            // Count of times the database failed to return a value. This does not include JSON parsing
            // errors.
            readsFromDbFailed: 0,
            // Count of completed (successful or failed) value reads from the database. This plus
            // `readsFromCache` equals `readsFinished`.
            readsFromDbFinished: 0,
            // Count of write operations (number of times `remove()`, `set()`, or `setSub()` was called)
            // regardless of whether the value actually changed. This minus `writesFinished` is the
            // current number of pending write operations.
            writes: 0,
            // Count of times a write operation failed, including JSON serialization errors. This divided
            // by `writesFinished` is the overall write error rate.
            writesFailed: 0,
            // Count of completed (successful or failed) write operations.
            writesFinished: 0,
            // Count of times a pending write operation was not sent to the underlying database because a
            // call to `remove()`, `set()`, or `setSub()` superseded the write, rendering it unnecessary.
            writesObsoleted: 0,
            // Count of times a value was sent to the underlying database, including record deletes but
            // excluding retries. This minus `writesToDbFinished` is the number of in-progress writes.
            writesToDb: 0,
            // Count of times ueberDB failed to write a change to the underlying database, including
            // failed record deletes. This does not include JSON serialization errors or write errors that
            // later succeeded thanks to a retry by ueberDB.
            writesToDbFailed: 0,
            // Count of completed (successful or failed) value writes to the database. This plus
            // `writesObsoleted` equals `writesFinished`.
            writesToDbFinished: 0,
            // Count of times a write operation was retried.
            writesToDbRetried: 0,
        };
        // start the write Interval
        this.flushInterval = this.settings.writeInterval > 0
            ? setInterval(() => this.flush(), this.settings.writeInterval) : null;
    }
    async _lock(key) {
        while (true) {
            const l = this._locks.get(key);
            if (l == null)
                break;
            ++this.metrics.lockAwaits;
            await l;
        }
        ++this.metrics.lockAcquires;
        this._locks.set(key, new SelfContainedPromise());
    }
    async _unlock(key) {
        ++this.metrics.lockReleases;
        this._locks.get(key).done();
        this._locks.delete(key);
    }
    // Block flush() until _resumeFlush() is called. This is needed so that a call to flush() after a
    // write (set(), setSub(), or remove() call) in the same ECMAScript macro- or microtask will see
    // the enqueued write and flush it.
    //
    // An alternative would be to change flush() to schedule its actions in a future microtask after
    // the write has been queued in the buffer, but:
    //
    //   * That would be fragile: Every use of await moves the subsequent processing to a new
    //     microtask, so flush() would need to do a number of `await Promise.resolve();` calls equal
    //     to the number of awaits before a write is actually buffered.
    //
    //   * It won't work for setSub() because it must wait for a read to complete before it buffers
    //     the write.
    _pauseFlush() {
        if (this._flushPaused == null) {
            this._flushPaused = new SelfContainedPromise();
            this._flushPaused.count = 0;
        }
        ++this._flushPaused.count;
    }
    _resumeFlush() {
        if (--this._flushPaused.count > 0)
            return;
        this._flushPaused.done();
        this._flushPaused = null;
    }
    /**
     * wraps the init function of the original DB
     */
    async init() {
        await this.wrappedDB.init();
    }
    /**
     * wraps the close function of the original DB
     */
    async close() {
        clearInterval(this.flushInterval);
        await this.flush();
        await this.wrappedDB.close();
        this.wrappedDB = null;
    }
    /**
     * Gets the value trough the wrapper.
     */
    async get(key) {
        let v;
        await this._lock(key);
        try {
            v = await this._getLocked(key);
        }
        finally {
            this._unlock(key);
        }
        return clone(v);
    }
    async _getLocked(key) {
        ++this.metrics.reads;
        try {
            const entry = this.buffer.get(key);
            if (entry != null) {
                ++this.metrics.readsFromCache;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(`GET    - ${key} - ${JSON.stringify(entry.value)} - ` +
                        `from ${entry.dirty ? 'dirty buffer' : 'cache'}`);
                }
                return entry.value;
            }
            // get it direct
            let value;
            ++this.metrics.readsFromDb;
            try {
                value = await this.wrappedDB.get(key);
            }
            catch (err) {
                ++this.metrics.readsFromDbFailed;
                throw err;
            }
            finally {
                ++this.metrics.readsFromDbFinished;
            }
            if (this.settings.json) {
                try {
                    value = JSON.parse(value);
                }
                catch (err) {
                    this.logger.error(`JSON-PROBLEM:${value}`);
                    throw err;
                }
            }
            // cache the value if caching is enabled
            if (this.settings.cache > 0) {
                this.buffer.set(key, {
                    value,
                    dirty: null,
                    writingInProgress: false,
                });
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(`GET    - ${key} - ${JSON.stringify(value)} - from database `);
            }
            return value;
        }
        catch (err) {
            ++this.metrics.readsFailed;
            throw err;
        }
        finally {
            ++this.metrics.readsFinished;
        }
    }
    /**
     * Find keys function searches the db sets for matching entries and
     * returns the key entries via callback.
     */
    async findKeys(key, notKey) {
        await this.flush();
        const keyValues = await this.wrappedDB.findKeys(key, notKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(`GET    - ${key}-${notKey} - ${JSON.stringify(keyValues)} - from database `);
        }
        return clone(keyValues);
    }
    /**
     * Remove a record from the database
     */
    async remove(key) {
        if (this.logger.isDebugEnabled())
            this.logger.debug(`DELETE - ${key} - from database `);
        await this.set(key, null);
    }
    /**
     * Sets the value trough the wrapper
     */
    async set(key, value) {
        value = clone(value);
        let p;
        this._pauseFlush();
        try {
            await this._lock(key);
            try {
                p = this._setLocked(key, value);
            }
            finally {
                this._unlock(key);
            }
        }
        finally {
            this._resumeFlush();
        }
        await p;
    }
    // Implementation of the `set()` method. The record must already be locked before calling this. It
    // is safe to unlock the record before the returned Promise resolves.
    async _setLocked(key, value) {
        // IMPORTANT: This function MUST NOT use the `await` keyword before the entry in `this.buffer`
        // is added/updated. Using `await` causes execution to return to the caller, and the caller must
        // be able to immediately unlock the record to avoid unnecessary blocking while the value is
        // committed to the underlying database. If `await` is used before the entry is updated then the
        // record will be unlocked prematurely, possibly resulting in inconsistent state.
        ++this.metrics.writes;
        try {
            let entry = this.buffer.get(key);
            // If there is a write of a different value for the same key already in progress then don't
            // update the existing entry object -- create a new entry object instead and replace the old
            // one in this.buffer. (If the existing entry was updated instead, then entry.dirty would
            // resolve when the old value is committed, not the new value.)
            if (!entry || entry.writingInProgress)
                entry = {};
            else if (entry.dirty)
                ++this.metrics.writesObsoleted;
            entry.value = value;
            // Always mark as dirty even if the value did not change. This simplifies the implementation:
            // this function doesn't need to perform deep comparisons, and setSub() doesn't need to
            // perform a deep copy of the object returned from get().
            if (!entry.dirty)
                entry.dirty = new SelfContainedPromise();
            // buffer.set() is called even if the value is unchanged so that the cache entry is marked as
            // most recently used.
            this.buffer.set(key, entry);
            const buffered = this.settings.writeInterval > 0;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(`SET    - ${key} - ${JSON.stringify(value)} - to ${buffered ? 'buffer' : 'database'}`);
            }
            // Write it immediately if write buffering is disabled. If write buffering is enabled,
            // this.flush() will eventually take care of it.
            if (!buffered)
                this._write([[key, entry]]); // await is unnecessary.
            await entry.dirty;
        }
        catch (err) {
            ++this.metrics.writesFailed;
            throw err;
        }
        finally {
            ++this.metrics.writesFinished;
        }
    }
    /**
     * Sets a subvalue
     */
    async setSub(key, sub, value) {
        value = clone(value);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(`SETSUB - ${key}${JSON.stringify(sub)} - ${JSON.stringify(value)}`);
        }
        let p;
        this._pauseFlush();
        try {
            await this._lock(key);
            try {
                let base;
                try {
                    const fullValue = await this._getLocked(key);
                    base = { fullValue };
                    // Emulate a pointer to the property that should be set to `value`.
                    const ptr = { obj: base, prop: 'fullValue' };
                    for (let i = 0; i < sub.length; i++) {
                        if (sub[i] === '__proto__') {
                            throw new Error('Modifying object prototype is not supported for security reasons');
                        }
                        let o = ptr.obj[ptr.prop];
                        if (o == null)
                            ptr.obj[ptr.prop] = o = {};
                        // If o is a primitive (string, number, etc.), then setting `o.foo` has no effect
                        // because ECMAScript automatically wraps primitives in a temporary wrapper object.
                        if (typeof o !== 'object') {
                            throw new TypeError(`Cannot set property ${JSON.stringify(sub[i])} on non-object ` +
                                `${JSON.stringify(o)} (key: ${JSON.stringify(key)} ` +
                                `value in db: ${JSON.stringify(fullValue)} ` +
                                `sub: ${JSON.stringify(sub.slice(0, i + 1))})`);
                        }
                        ptr.obj = ptr.obj[ptr.prop];
                        ptr.prop = sub[i];
                    }
                    ptr.obj[ptr.prop] = value;
                }
                catch (err) {
                    // this._setLocked() will not be called but it should still count as a write failure.
                    ++this.metrics.writes;
                    ++this.metrics.writesFailed;
                    ++this.metrics.writesFinished;
                    throw err;
                }
                p = this._setLocked(key, base.fullValue);
            }
            finally {
                this._unlock(key);
            }
        }
        finally {
            this._resumeFlush();
        }
        await p;
    }
    /**
     * Returns a sub value of the object
     * @param sub is a array, for example if you want to access object.test.bla, the array is ["test",
     *     "bla"]
     */
    async getSub(key, sub) {
        await this._lock(key);
        try {
            let v = await this._getLocked(key);
            for (const k of sub) {
                if (typeof v !== 'object' || (v != null && !Object.prototype.hasOwnProperty.call(v, k)) ||
                    // __proto__ is not an "own" property but we check for it explicitly for added safety,
                    // to improve readability, and to help static code analysis tools rule out prototype
                    // pollution vulnerabilities.
                    k === '__proto__') {
                    v = null;
                }
                if (v == null)
                    break;
                v = v[k];
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(`GETSUB - ${key}${JSON.stringify(sub)} - ${JSON.stringify(v)}`);
            }
            return clone(v);
        }
        finally {
            this._unlock(key);
        }
    }
    /**
     * Writes all dirty values to the database
     */
    async flush() {
        if (this._flushDone == null) {
            this._flushDone = (async () => {
                while (true) {
                    while (this._flushPaused != null)
                        await this._flushPaused;
                    const dirtyEntries = [];
                    for (const entry of this.buffer) {
                        if (entry[1].dirty && !entry[1].writingInProgress) {
                            dirtyEntries.push(entry);
                            if (this.settings.bulkLimit && dirtyEntries.length >= this.settings.bulkLimit)
                                break;
                        }
                    }
                    if (dirtyEntries.length === 0)
                        return;
                    await this._write(dirtyEntries);
                }
            })();
        }
        await this._flushDone;
        this._flushDone = null;
    }
    async _write(dirtyEntries) {
        const markDone = (entry, err) => {
            if (entry.writingInProgress) {
                entry.writingInProgress = false;
                if (err != null)
                    ++this.metrics.writesToDbFailed;
                ++this.metrics.writesToDbFinished;
            }
            // If err != null then the entry is still technically dirty, but the responsibility is on the
            // user to retry failures so from ueberDB's perspective the entry is no longer dirty.
            entry.dirty.done(err);
            entry.dirty = null;
        };
        const ops = [];
        const entries = [];
        for (const [key, entry] of dirtyEntries) {
            let value = entry.value;
            try {
                value = this.settings.json && value != null ? JSON.stringify(value) : clone(value);
            }
            catch (err) {
                markDone(entry, err);
                continue;
            }
            entry.writingInProgress = true;
            ops.push({ type: value == null ? 'remove' : 'set', key, value });
            entries.push(entry);
        }
        if (ops.length === 0)
            return;
        this.metrics.writesToDb += ops.length;
        const writeOneOp = async (op, entry) => {
            let writeErr = null;
            try {
                switch (op.type) {
                    case 'remove':
                        await this.wrappedDB.remove(op.key);
                        break;
                    case 'set':
                        await this.wrappedDB.set(op.key, op.value);
                        break;
                    default:
                        throw new Error(`unsupported operation type: ${op.type}`);
                }
            }
            catch (err) {
                writeErr = err || new Error(err);
            }
            markDone(entry, writeErr);
        };
        if (ops.length === 1) {
            await writeOneOp(ops[0], entries[0]);
        }
        else {
            let success = false;
            try {
                await this.wrappedDB.doBulk(ops);
                success = true;
            }
            catch (err) {
                this.logger.error(`Bulk write of ${ops.length} ops failed, retrying individually: ${err.stack || err}`);
                this.metrics.writesToDbRetried += ops.length;
                await Promise.all(ops.map(async (op, i) => await writeOneOp(op, entries[i])));
            }
            if (success)
                entries.forEach((entry) => markDone(entry, null));
        }
        // This call to this.buffer.evictOld() can be safely removed (if we haven't run out of memory by
        // this point then it is probably safe to continue using the memory until the next call to
        // this.buffer.set() evicts the old entries), except removing it would cause some reads to be
        // satisfied from the cache even when this.settings.cache = 0. That would contradict the
        // documented behavior for cache = 0.
        this.buffer.evictOld();
    }
};
const clone = (obj, key = '') => {
    // Handle the 3 simple types, and null or undefined
    if (null == obj || 'object' !== typeof obj)
        return obj;
    if (typeof obj.toJSON === 'function')
        return clone(obj.toJSON(key));
    // Handle Date
    if (obj instanceof Date) {
        const copy = new Date();
        copy.setTime(obj.getTime());
        return copy;
    }
    // Handle Array
    if (obj instanceof Array) {
        const copy = [];
        for (let i = 0, len = obj.length; i < len; ++i) {
            copy[i] = clone(obj[i], String(i));
        }
        return copy;
    }
    // Handle Object
    if (obj instanceof Object) {
        const copy = {};
        for (const attr in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, attr))
                copy[attr] = clone(obj[attr], attr);
        }
        return copy;
    }
    throw new Error("Unable to copy obj! Its type isn't supported.");
};const normalizeLogger = (logger) => {
    const logLevelsUsed = ['debug', 'info', 'warn', 'error'];
    logger = Object.create(logger || {});
    for (const level of logLevelsUsed) {
        const enabledFnName = `is${level.charAt(0).toUpperCase() + level.slice(1)}Enabled`;
        // @ts-ignore
        if (typeof logger[level] !== 'function') {
            // @ts-ignore
            logger[level] = () => { };
            // @ts-ignore
            logger[enabledFnName] = () => false;
            // @ts-ignore
        }
        else if (typeof logger[enabledFnName] !== 'function') {
            // @ts-ignore
            logger[enabledFnName] = () => true;
        }
    }
    return logger;
};const nullLogger = normalizeLogger(null);
// Format: All characters match themselves except * matches any zero or more characters. No
// backslash escaping is supported, so it is impossible to create a pattern that matches only the
// '*' character.
const simpleGlobToRegExp = (s) => s.replace(/[.+?^${}()|[\]\\]/g, '\\$&').replace(/\*/g, '.*');
class AbstractDatabase {
    logger;
    settings;
    constructor(settings) {
        if (new.target === module.exports) {
            throw new TypeError('cannot instantiate Abstract Database directly');
        }
        for (const fn of ['init', 'close', 'get', 'findKeys', 'remove', 'set']) {
            // @ts-ignore
            if (typeof this[fn] !== 'function')
                throw new TypeError(`method ${fn} not defined`);
        }
        this.logger = nullLogger;
        this.settings = settings;
    }
    /**
     * For findKey regex. Used by document dbs like mongodb or dirty.
     */
    createFindRegex(key, notKey) {
        let regex = `^(?=${simpleGlobToRegExp(key)}$)`;
        if (notKey != null)
            regex += `(?!${simpleGlobToRegExp(notKey)}$)`;
        return new RegExp(regex);
    }
    doBulk(operations, cb) {
        throw new Error('the doBulk method must be implemented if write caching is enabled');
    }
    get isAsync() { return false; }
}var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function getAugmentedNamespace(n) {
  if (n.__esModule) return n;
  var f = n.default;
	if (typeof f == "function") {
		var a = function a () {
			if (this instanceof a) {
        return Reflect.construct(f, arguments, this.constructor);
			}
			return f.apply(this, arguments);
		};
		a.prototype = f.prototype;
  } else a = {};
  Object.defineProperty(a, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}var cassandraDriver = {};var clientOptions = {};var policies = {};var addressResolution = {};var utils$c = {};var errors$d = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredErrors$c;

function requireErrors$c () {
	if (hasRequiredErrors$c) return errors$d;
	hasRequiredErrors$c = 1;
	const util = require$$0$6;
	/**
	 * Contains the error classes exposed by the driver.
	 * @module errors
	 */

	/**
	 * Base Error
	 * @private
	 */
	function DriverError (message) {
	  Error.call(this, message);
	  Error.captureStackTrace(this, this.constructor);
	  this.name = this.constructor.name;
	  this.info = 'Cassandra Driver Error';
	  // Explicitly set the message property as the Error.call() doesn't set the property on v8
	  this.message = message;
	}

	util.inherits(DriverError, Error);

	/**
	 * Represents an error when a query cannot be performed because no host is available or could be reached by the driver.
	 * @param {Object} innerErrors An object map containing the error per host tried
	 * @param {String} [message]
	 * @constructor
	 */
	function NoHostAvailableError(innerErrors, message) {
	  DriverError.call(this, message);
	  this.innerErrors = innerErrors;
	  this.info = 'Represents an error when a query cannot be performed because no host is available or could be reached by the driver.';
	  if (!message) {
	    this.message = 'All host(s) tried for query failed.';
	    if (innerErrors) {
	      const hostList = Object.keys(innerErrors);
	      if (hostList.length > 0) {
	        const host = hostList[0];
	        this.message += util.format(' First host tried, %s: %s. See innerErrors.', host, innerErrors[host]);
	      }
	    }
	  }
	}

	util.inherits(NoHostAvailableError, DriverError);

	/**
	 * Represents an error message from the server
	 * @param {Number} code Cassandra exception code
	 * @param {String} message
	 * @constructor
	 */
	function ResponseError(code, message) {
	  DriverError.call(this, message);
	  /**
	   * The error code as defined in [responseErrorCodes]{@link module:types~responseErrorCodes}.
	   * @type {Number}
	   */
	  this.code = code;
	  this.info = 'Represents an error message from the server';
	}

	util.inherits(ResponseError, DriverError);

	/**
	 * Represents a bug inside the driver or in a Cassandra host.
	 * @param {String} message
	 * @constructor
	 */
	function DriverInternalError(message) {
	  DriverError.call(this, message);
	  this.info = 'Represents a bug inside the driver or in a Cassandra host.';
	}

	util.inherits(DriverInternalError, DriverError);

	/**
	 * Represents an error when trying to authenticate with auth-enabled host
	 * @param {String} message
	 * @constructor
	 */
	function AuthenticationError(message) {
	  DriverError.call(this, message);
	  this.info = 'Represents an authentication error from the driver or from a Cassandra node.';
	}

	util.inherits(AuthenticationError, DriverError);

	/**
	 * Represents an error that is raised when one of the arguments provided to a method is not valid
	 * @param {String} message
	 * @constructor
	 */
	function ArgumentError(message) {
	  DriverError.call(this, message);
	  this.info = 'Represents an error that is raised when one of the arguments provided to a method is not valid.';
	}

	util.inherits(ArgumentError, DriverError);

	/**
	 * Represents a client-side error that is raised when the client didn't hear back from the server within
	 * {@link ClientOptions.socketOptions.readTimeout}.
	 * @param {String} message The error message.
	 * @param {String} [host] Address of the server host that caused the operation to time out.
	 * @constructor
	 */
	function OperationTimedOutError(message, host) {
	  DriverError.call(this, message, this.constructor);
	  this.info = 'Represents a client-side error that is raised when the client did not hear back from the server ' +
	    'within socketOptions.readTimeout';

	  /**
	   * When defined, it gets the address of the host that caused the operation to time out.
	   * @type {String|undefined}
	   */
	  this.host = host;
	}

	util.inherits(OperationTimedOutError, DriverError);

	/**
	 * Represents an error that is raised when a feature is not supported in the driver or in the current Cassandra version.
	 * @param message
	 * @constructor
	 */
	function NotSupportedError(message) {
	  DriverError.call(this, message, this.constructor);
	  this.info = 'Represents a feature that is not supported in the driver or in the Cassandra version.';
	}

	util.inherits(NotSupportedError, DriverError);

	/**
	 * Represents a client-side error indicating that all connections to a certain host have reached
	 * the maximum amount of in-flight requests supported.
	 * @param {String} address
	 * @param {Number} maxRequestsPerConnection
	 * @param {Number} connectionLength
	 * @constructor
	 */
	function BusyConnectionError(address, maxRequestsPerConnection, connectionLength) {
	  const message = util.format('All connections to host %s are busy, %d requests are in-flight on %s',
	    address, maxRequestsPerConnection, connectionLength === 1 ? 'a single connection': 'each connection');
	  DriverError.call(this, message, this.constructor);
	  this.info = 'Represents a client-side error indicating that all connections to a certain host have reached ' +
	    'the maximum amount of in-flight requests supported (pooling.maxRequestsPerConnection)';
	}

	util.inherits(BusyConnectionError, DriverError);

	errors$d.ArgumentError = ArgumentError;
	errors$d.AuthenticationError = AuthenticationError;
	errors$d.BusyConnectionError = BusyConnectionError;
	errors$d.DriverError = DriverError;
	errors$d.OperationTimedOutError = OperationTimedOutError;
	errors$d.DriverInternalError = DriverInternalError;
	errors$d.NoHostAvailableError = NoHostAvailableError;
	errors$d.NotSupportedError = NotSupportedError;
	errors$d.ResponseError = ResponseError;
	return errors$d;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var promiseUtils;
var hasRequiredPromiseUtils;

function requirePromiseUtils () {
	if (hasRequiredPromiseUtils) return promiseUtils;
	hasRequiredPromiseUtils = 1;

	/**
	 * Creates a non-clearable timer that resolves the promise once elapses.
	 * @param {number} ms
	 * @returns {Promise<void>}
	 */
	function delay(ms) {
	  return new Promise(r => setTimeout(r, ms || 0));
	}

	/**
	 * Creates a Promise that gets resolved or rejected based on an event.
	 * @param {object} emitter
	 * @param {string} eventName
	 * @returns {Promise}
	 */
	function fromEvent(emitter, eventName) {
	  return new Promise((resolve, reject) =>
	    emitter.once(eventName, (err, result) => {
	      if (err) {
	        reject(err);
	      } else {
	        resolve(result);
	      }
	    }));
	}

	/**
	 * Creates a Promise from a callback based function.
	 * @param {Function} fn
	 * @returns {Promise}
	 */
	function fromCallback(fn) {
	  return new Promise((resolve, reject) =>
	    fn((err, result) => {
	      if (err) {
	        reject(err);
	      } else {
	        resolve(result);
	      }
	    }));
	}

	/**
	 * Gets a function that has the signature of a callback that invokes the appropriate promise handler parameters.
	 * @param {Function} resolve
	 * @param {Function} reject
	 * @returns {Function}
	 */
	function getCallback(resolve, reject) {
	  return function (err, result) {
	    if (err) {
	      reject(err);
	    } else {
	      resolve(result);
	    }
	  };
	}

	async function invokeSequentially(info, length, fn) {
	  let index;
	  while ((index = info.counter++) < length) {
	    await fn(index);
	  }
	}

	/**
	 * Invokes the new query plan of the load balancing policy and returns a Promise.
	 * @param {LoadBalancingPolicy} lbp The load balancing policy.
	 * @param {String} keyspace Name of currently logged keyspace at <code>Client</code> level.
	 * @param {ExecutionOptions|null} executionOptions The information related to the execution of the request.
	 * @returns {Promise<Iterator>}
	 */
	function newQueryPlan(lbp, keyspace, executionOptions) {
	  return new Promise((resolve, reject) => {
	    lbp.newQueryPlan(keyspace, executionOptions, (err, iterator) => {
	      if (err) {
	        reject(err);
	      } else {
	        resolve(iterator);
	      }
	    });
	  });
	}

	/**
	 * Method that handles optional callbacks (dual promise and callback support).
	 * When callback is undefined it returns the promise.
	 * When using a callback, it will use it as handlers of the continuation of the promise.
	 * @param {Promise} promise
	 * @param {Function?} callback
	 * @returns {Promise|undefined}
	 */
	function optionalCallback(promise, callback) {
	  if (!callback) {
	    return promise;
	  }

	  toCallback(promise, callback);
	}

	/**
	 * Invokes the provided function multiple times, considering the concurrency level limit.
	 * @param {Number} count
	 * @param {Number} limit
	 * @param {Function} fn
	 * @returns {Promise}
	 */
	function times(count, limit, fn) {
	  if (limit > count) {
	    limit = count;
	  }

	  const promises = new Array(limit);

	  const info = {
	    counter: 0
	  };

	  for (let i = 0; i < limit; i++) {
	    promises[i] = invokeSequentially(info, count, fn);
	  }

	  return Promise.all(promises);
	}

	/**
	 * Deals with unexpected rejections in order to avoid the unhandled promise rejection warning or failure.
	 * @param {Promise} promise
	 * @returns {undefined}
	 */
	function toBackground(promise) {
	  promise.catch(() => {});
	}

	/**
	 * Invokes the callback once outside the promise chain the promise is resolved or rejected.
	 * @param {Promise} promise
	 * @param {Function?} callback
	 * @returns {undefined}
	 */
	function toCallback(promise, callback) {
	  promise
	    .then(
	      result => process.nextTick(() => callback(null, result)),
	      // Avoid marking the promise as rejected
	      err => process.nextTick(() => callback(err)));
	}

	promiseUtils = {
	  delay,
	  fromCallback,
	  fromEvent,
	  getCallback,
	  newQueryPlan,
	  optionalCallback,
	  times,
	  toBackground,
	  toCallback
	};
	return promiseUtils;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredUtils$c;

function requireUtils$c () {
	if (hasRequiredUtils$c) return utils$c;
	hasRequiredUtils$c = 1;

	const util = require$$0$6;
	const net = require$$0$7;
	const { EventEmitter } = require$$0$8;

	const errors = requireErrors$c();
	const promiseUtils = requirePromiseUtils();

	/**
	 * Max int that can be accurately represented with 64-bit Number (2^53)
	 * @type {number}
	 * @const
	 */
	const maxInt = 9007199254740992;

	const maxInt32 = 0x7fffffff;

	const emptyObject = Object.freeze({});

	const emptyArray = Object.freeze([]);

	function noop() {}

	/**
	 * Forward-compatible allocation of buffer, filled with zeros.
	 * @type {Function}
	 */
	const allocBuffer = Buffer.alloc || allocBufferFillDeprecated;

	/**
	 * Forward-compatible unsafe allocation of buffer.
	 * @type {Function}
	 */
	const allocBufferUnsafe = Buffer.allocUnsafe || allocBufferDeprecated;

	/**
	 * Forward-compatible allocation of buffer to contain a string.
	 * @type {Function}
	 */
	const allocBufferFromString = (Int8Array.from !== Buffer.from && Buffer.from) || allocBufferFromStringDeprecated;

	/**
	 * Forward-compatible allocation of buffer from an array of bytes
	 * @type {Function}
	 */
	const allocBufferFromArray = (Int8Array.from !== Buffer.from && Buffer.from) || allocBufferFromArrayDeprecated;

	function allocBufferDeprecated(size) {
	  // eslint-disable-next-line
	  return new Buffer(size);
	}

	function allocBufferFillDeprecated(size) {
	  const b = allocBufferDeprecated(size);
	  b.fill(0);
	  return b;
	}

	function allocBufferFromStringDeprecated(text, encoding) {
	  if (typeof text !== 'string') {
	    throw new TypeError('Expected string, obtained ' + util.inspect(text));
	  }
	  // eslint-disable-next-line
	  return new Buffer(text, encoding);
	}

	function allocBufferFromArrayDeprecated(arr) {
	  if (!Array.isArray(arr)) {
	    throw new TypeError('Expected Array, obtained ' + util.inspect(arr));
	  }
	  // eslint-disable-next-line
	  return new Buffer(arr);
	}

	/**
	 * @returns {Function} Returns a wrapper function that invokes the underlying callback only once.
	 * @param {Function} callback
	 */
	function callbackOnce(callback) {
	  let cb = callback;

	  return (function wrapperCallback(err, result) {
	    cb(err, result);
	    cb = noop;
	  });
	}

	/**
	 * Creates a copy of a buffer
	 */
	function copyBuffer(buf) {
	  const targetBuffer = allocBufferUnsafe(buf.length);
	  buf.copy(targetBuffer);
	  return targetBuffer;
	}

	/**
	 * Appends the original stack trace to the error after a tick of the event loop
	 */
	function fixStack(stackTrace, error) {
	  if (stackTrace) {
	    error.stack += '\n  (event loop)\n' + stackTrace.substr(stackTrace.indexOf("\n") + 1);
	  }
	  return error;
	}

	/**
	 * Uses the logEmitter to emit log events
	 * @param {String} type
	 * @param {String} info
	 * @param [furtherInfo]
	 */
	function log(type, info, furtherInfo, options) {
	  if (!this.logEmitter) {
	    const effectiveOptions = options || this.options;
	    if (!effectiveOptions || !effectiveOptions.logEmitter) {
	      throw new Error('Log emitter not defined');
	    }
	    this.logEmitter = effectiveOptions.logEmitter;
	  }
	  this.logEmitter('log', type, this.constructor.name, info, furtherInfo || '');
	}

	/**
	 * Gets the sum of the length of the items of an array
	 */
	function totalLength (arr) {
	  if (arr.length === 1) {
	    return arr[0].length;
	  }
	  let total = 0;
	  arr.forEach(function (item) {
	    let length = item.length;
	    length = length ? length : 0;
	    total += length;
	  });
	  return total;
	}

	/**
	 * Merge the contents of two or more objects together into the first object. Similar to jQuery.extend / Object.assign.
	 * The main difference between this method is that declared properties with an <code>undefined</code> value are not set
	 * to the target.
	 */
	function extend(target) {
	  const sources = Array.prototype.slice.call(arguments, 1);
	  sources.forEach(function (source) {
	    if (!source) {
	      return;
	    }
	    const keys = Object.keys(source);
	    for (let i = 0; i < keys.length; i++) {
	      const key = keys[i];
	      const value = source[key];
	      if (value === undefined) {
	        continue;
	      }
	      target[key] = value;
	    }
	  });
	  return target;
	}

	/**
	 * Returns a new object with the property names set to lowercase.
	 */
	function toLowerCaseProperties(obj) {
	  const keys = Object.keys(obj);
	  const result = {};
	  for (let i = 0; i < keys.length; i++) {
	    const k = keys[i];
	    result[k.toLowerCase()] = obj[k];
	  }
	  return result;
	}

	/**
	 * Extends the target by the most inner props of sources
	 * @param {Object} target
	 * @returns {Object}
	 */
	function deepExtend(target) {
	  const sources = Array.prototype.slice.call(arguments, 1);
	  sources.forEach(function (source) {
	    for (const prop in source) {
	      // eslint-disable-next-line no-prototype-builtins
	      if (!source.hasOwnProperty(prop)) {
	        continue;
	      }
	      const targetProp = target[prop];
	      const targetType = (typeof targetProp);
	      //target prop is
	      // a native single type
	      // or not existent
	      // or is not an anonymous object (not class instance)
	      if (!targetProp ||
	        targetType === 'number' ||
	        targetType === 'string' ||
	        Array.isArray(targetProp) ||
	        util.isDate(targetProp) ||
	        targetProp.constructor.name !== 'Object') {
	        target[prop] = source[prop];
	      }
	      else {
	        //inner extend
	        target[prop] = deepExtend({}, targetProp, source[prop]);
	      }
	    }
	  });
	  return target;
	}

	function propCompare(propName) {
	  return function (a, b) {
	    if (a[propName] > b[propName]) {
	      return 1;
	    }
	    if (a[propName] < b[propName]) {
	      return -1;
	    }
	    return 0;
	  };
	}

	function funcCompare(name, argArray) {
	  return (function (a, b) {
	    if (typeof a[name] === 'undefined') {
	      return 0;
	    }
	    const valA = a[name].apply(a, argArray);
	    const valB = b[name].apply(b, argArray);
	    if (valA > valB) {
	      return 1;
	    }
	    if (valA < valB) {
	      return -1;
	    }
	    return 0;
	  });
	}
	/**
	 * Uses the iterator protocol to go through the items of the Array
	 * @param {Array} arr
	 * @returns {Iterator}
	 */
	function arrayIterator (arr) {
	  return arr[Symbol.iterator]();
	}

	/**
	 * Convert the iterator values into an array
	 * @param iterator
	 * @returns {Array}
	 */
	function iteratorToArray(iterator) {
	  const values = [];
	  let item = iterator.next();
	  while (!item.done) {
	    values.push(item.value);
	    item = iterator.next();
	  }
	  return values;
	}

	/**
	 * Searches the specified Array for the provided key using the binary
	 * search algorithm.  The Array must be sorted.
	 * @param {Array} arr
	 * @param key
	 * @param {function} compareFunc
	 * @returns {number} The position of the key in the Array, if it is found.
	 * If it is not found, it returns a negative number which is the bitwise complement of the index of the first element that is larger than key.
	 */
	function binarySearch(arr, key, compareFunc) {
	  let low = 0;
	  let high = arr.length-1;

	  while (low <= high) {
	    const mid = (low + high) >>> 1;
	    const midVal = arr[mid];
	    const cmp = compareFunc(midVal, key);
	    if (cmp < 0) {
	      low = mid + 1;
	    }
	    else if (cmp > 0) {
	      high = mid - 1;
	    }
	    else
	    {
	      //The key was found in the Array
	      return mid;
	    }
	  }
	  // key not found
	  return ~low;
	}

	/**
	 * Inserts the value in the position determined by its natural order determined by the compare func
	 * @param {Array} arr
	 * @param item
	 * @param {function} compareFunc
	 */
	function insertSorted(arr, item, compareFunc) {
	  if (arr.length === 0) {
	    return arr.push(item);
	  }
	  let position = binarySearch(arr, item, compareFunc);
	  if (position < 0) {
	    position = ~position;
	  }
	  arr.splice(position, 0, item);
	}

	/**
	 * Validates the provided parameter is of type function.
	 * @param {Function} fn The instance to validate.
	 * @param {String} [name] Name of the function to use in the error message. Defaults to 'callback'.
	 * @returns {Function}
	 */
	function validateFn(fn, name) {
	  if (typeof fn !== 'function') {
	    throw new errors.ArgumentError(util.format('%s is not a function', name || 'callback'));
	  }
	  return fn;
	}

	/**
	 * Adapts the parameters based on the prepared metadata.
	 * If the params are passed as an associative array (Object),
	 * it adapts the object into an array with the same order as columns
	 * @param {Array|Object} params
	 * @param {Array} columns
	 * @returns {Array} Returns an array of parameters.
	 * @throws {Error} In case a parameter with a specific name is not defined
	 */
	function adaptNamedParamsPrepared(params, columns) {
	  if (!params || Array.isArray(params) || !columns || columns.length === 0) {
	    // params is an array or there aren't parameters
	    return params;
	  }
	  const paramsArray = new Array(columns.length);
	  params = toLowerCaseProperties(params);
	  for (let i = 0; i < columns.length; i++) {
	    const name = columns[i].name;
	    // eslint-disable-next-line no-prototype-builtins
	    if (!params.hasOwnProperty(name)) {
	      throw new errors.ArgumentError(util.format('Parameter "%s" not defined', name));
	    }
	    paramsArray[i] = params[name];
	  }
	  return paramsArray;
	}

	/**
	 * Adapts the associative-array of parameters and hints for simple statements
	 * into Arrays based on the (arbitrary) position of the keys.
	 * @param {Array|Object} params
	 * @param {ExecutionOptions} execOptions
	 * @returns {{ params: Array<{name, value}>, namedParameters: boolean, keyIndexes: object }} Returns an array of
	 * parameters and the keys as an associative array.
	 */
	function adaptNamedParamsWithHints(params, execOptions) {
	  if (!params || Array.isArray(params)) {
	    //The parameters is an Array or there isn't parameter
	    return { params: params, namedParameters: false, keyIndexes: null };
	  }

	  const keys = Object.keys(params);
	  const paramsArray = new Array(keys.length);
	  const hints = new Array(keys.length);
	  const userHints = execOptions.getHints() || emptyObject;
	  const keyIndexes = {};

	  for (let i = 0; i < keys.length; i++) {
	    const key = keys[i];
	    // As lower cased identifiers
	    paramsArray[i] = { name: key.toLowerCase(), value: params[key]};
	    hints[i] = userHints[key];
	    keyIndexes[key] = i;
	  }

	  execOptions.setHints(hints);

	  return { params: paramsArray, namedParameters: true, keyIndexes };
	}

	/**
	 * Returns a string with a value repeated n times
	 * @param {String} val
	 * @param {Number} times
	 * @returns {String}
	 */
	function stringRepeat(val, times) {
	  if (!times || times < 0) {
	    return null;
	  }
	  if (times === 1) {
	    return val;
	  }
	  return new Array(times + 1).join(val);
	}

	/**
	 * Returns an array containing the values of the Object, similar to Object.values().
	 * If obj is null or undefined, it will return an empty array.
	 * @param {Object} obj
	 * @returns {Array}
	 */
	function objectValues(obj) {
	  if (!obj) {
	    return emptyArray;
	  }
	  const keys = Object.keys(obj);
	  const values = new Array(keys.length);
	  for (let i = 0; i < keys.length; i++) {
	    values[i] = obj[keys[i]];
	  }
	  return values;
	}

	/**
	 * Wraps the callback-based method. When no originalCallback is not defined, it returns a Promise.
	 * @param {ClientOptions} options
	 * @param {Function} originalCallback
	 * @param {Function} handler
	 * @returns {Promise|undefined}
	 */
	function promiseWrapper(options, originalCallback, handler) {
	  if (typeof originalCallback === 'function') {
	    // Callback-based invocation
	    handler.call(this, originalCallback);
	    return undefined;
	  }
	  const factory = options.promiseFactory || defaultPromiseFactory;
	  const self = this;
	  return factory(function handlerWrapper(callback) {
	    handler.call(self, callback);
	  });
	}

	/**
	 * @param {Function} handler
	 * @returns {Promise}
	 */
	function defaultPromiseFactory(handler) {
	  return new Promise(function executor(resolve, reject) {
	    handler(function handlerCallback(err, result) {
	      if (err) {
	        return reject(err);
	      }
	      resolve(result);
	    });
	  });
	}

	/**
	 * Returns the first not undefined param
	 */
	function ifUndefined(v1, v2) {
	  return v1 !== undefined ? v1 : v2;
	}

	/**
	 * Returns the first not undefined param
	 */
	function ifUndefined3(v1, v2, v3) {
	  if (v1 !== undefined) {
	    return v1;
	  }
	  return v2 !== undefined ? v2 : v3;
	}

	/**
	 * Shuffles an Array in-place.
	 * @param {Array} arr
	 * @returns {Array}
	 * @private
	 */
	function shuffleArray(arr) {
	  // Fisher–Yates algorithm
	  for (let i = arr.length - 1; i > 0; i--) {
	    // Math.random() has an extremely short permutation cycle length but we don't care about collisions
	    const j = Math.floor(Math.random() * (i + 1));
	    const temp = arr[i];
	    arr[i] = arr[j];
	    arr[j] = temp;
	  }

	  return arr;
	}

	// Classes

	/**
	 * Represents a unique set of values.
	 * @constructor
	 */
	function HashSet() {
	  this.length = 0;
	  this.items = {};
	}

	/**
	 * Adds a new item to the set.
	 * @param {Object} key
	 * @returns {boolean} Returns true if it was added to the set; false if the key is already present.
	 */
	HashSet.prototype.add = function (key) {
	  if (this.contains(key)) {
	    return false;
	  }
	  this.items[key] = true;
	  this.length++;
	  return true;
	};

	/**
	 * @returns {boolean} Returns true if the key is present in the set.
	 */
	HashSet.prototype.contains = function (key) {
	  return this.length > 0 && this.items[key] === true;
	};

	/**
	 * Removes the item from set.
	 * @param key
	 * @return {boolean} Returns true if the key existed and was removed, otherwise it returns false.
	 */
	HashSet.prototype.remove = function (key) {
	  if (!this.contains(key)) {
	    return false;
	  }
	  delete this.items[key];
	  this.length--;
	};

	/**
	 * Returns an array containing the set items.
	 * @returns {Array}
	 */
	HashSet.prototype.toArray = function () {
	  return Object.keys(this.items);
	};

	/**
	 * Utility class that resolves host names into addresses.
	 */
	class AddressResolver {

	  /**
	   * Creates a new instance of the resolver.
	   * @param {Object} options
	   * @param {String} options.nameOrIp
	   * @param {Object} [options.dns]
	   */
	  constructor(options) {
	    if (!options || !options.nameOrIp || !options.dns) {
	      throw new Error('nameOrIp and dns lib must be provided as part of the options');
	    }

	    this._resolve4 = util.promisify(options.dns.resolve4);
	    this._nameOrIp = options.nameOrIp;
	    this._isIp = net.isIP(options.nameOrIp);
	    this._index = 0;
	    this._addresses = null;
	    this._refreshing = null;
	  }

	  /**
	   * Resolves the addresses for the host name.
	   */
	  async init() {
	    if (this._isIp) {
	      return;
	    }

	    await this._resolve();
	  }

	  /**
	   * Tries to resolve the addresses for the host name.
	   */
	  async refresh() {
	    if (this._isIp) {
	      return;
	    }

	    if (this._refreshing) {
	      return await promiseUtils.fromEvent(this._refreshing, 'finished');
	    }

	    this._refreshing = new EventEmitter().setMaxListeners(0);

	    try {
	      await this._resolve();
	    } catch (err) {
	      // Ignore the possible resolution error
	    }

	    this._refreshing.emit('finished');
	    this._refreshing = null;
	  }

	  async _resolve() {
	    const arr = await this._resolve4(this._nameOrIp);

	    if (!arr || arr.length === 0) {
	      throw new Error(`${this._nameOrIp} could not be resolved`);
	    }

	    this._addresses = arr;
	  }

	  /**
	   * Returns resolved ips in a round-robin fashion.
	   */
	  getIp() {
	    if (this._isIp) {
	      return this._nameOrIp;
	    }

	    const item = this._addresses[this._index % this._addresses.length];
	    this._index = (this._index !== maxInt32) ? (this._index + 1) : 0;

	    return item;
	  }
	}

	/**
	 * @param {Array} arr
	 * @param {Function} fn
	 * @param {Function} [callback]
	 */
	function each(arr, fn, callback) {
	  if (!Array.isArray(arr)) {
	    throw new TypeError('First parameter is not an Array');
	  }
	  callback = callback || noop;
	  const length = arr.length;
	  if (length === 0) {
	    return callback();
	  }
	  let completed = 0;
	  for (let i = 0; i < length; i++) {
	    fn(arr[i], next);
	  }
	  function next(err) {
	    if (err) {
	      const cb = callback;
	      callback = noop;
	      cb(err);
	      return;
	    }
	    if (++completed !== length) {
	      return;
	    }
	    callback();
	  }
	}

	/**
	 * @param {Array} arr
	 * @param {Function} fn
	 * @param {Function} [callback]
	 */
	function eachSeries(arr, fn, callback) {
	  if (!Array.isArray(arr)) {
	    throw new TypeError('First parameter is not an Array');
	  }
	  callback = callback || noop;
	  const length = arr.length;
	  if (length === 0) {
	    return callback();
	  }
	  let sync;
	  let index = 1;
	  fn(arr[0], next);
	  if (sync === undefined) {
	    sync = false;
	  }

	  function next(err) {
	    if (err) {
	      return callback(err);
	    }
	    if (index >= length) {
	      return callback();
	    }
	    if (sync === undefined) {
	      sync = true;
	    }
	    if (sync) {
	      return process.nextTick(function () {
	        fn(arr[index++], next);
	      });
	    }
	    fn(arr[index++], next);
	  }
	}

	/**
	 * @param {Array} arr
	 * @param {Function} fn
	 * @param {Function} [callback]
	 */
	function forEachOf(arr, fn, callback) {
	  return mapEach(arr, fn, true, callback);
	}

	/**
	 * @param {Array} arr
	 * @param {Function} fn
	 * @param {Function} [callback]
	 */
	function map(arr, fn, callback) {
	  return mapEach(arr, fn, false, callback);
	}

	function mapEach(arr, fn, useIndex, callback) {
	  if (!Array.isArray(arr)) {
	    throw new TypeError('First parameter must be an Array');
	  }
	  callback = callback || noop;
	  const length = arr.length;
	  if (length === 0) {
	    return callback(null, []);
	  }
	  const result = new Array(length);
	  let completed = 0;
	  const invoke = useIndex ? invokeWithIndex : invokeWithoutIndex;
	  for (let i = 0; i < length; i++) {
	    invoke(i);
	  }

	  function invokeWithoutIndex(i) {
	    fn(arr[i], function mapItemCallback(err, transformed) {
	      result[i] = transformed;
	      next(err);
	    });
	  }

	  function invokeWithIndex(i) {
	    fn(arr[i], i, function mapItemCallback(err, transformed) {
	      result[i] = transformed;
	      next(err);
	    });
	  }

	  function next(err) {
	    if (err) {
	      const cb = callback;
	      callback = noop;
	      cb(err);
	      return;
	    }
	    if (++completed !== length) {
	      return;
	    }
	    callback(null, result);
	  }
	}

	/**
	 * @param {Array} arr
	 * @param {Function} fn
	 * @param {Function} [callback]
	 */
	function mapSeries(arr, fn, callback) {
	  if (!Array.isArray(arr)) {
	    throw new TypeError('First parameter must be an Array');
	  }
	  callback = callback || noop;
	  const length = arr.length;
	  if (length === 0) {
	    return callback(null, []);
	  }
	  const result = new Array(length);
	  let index = 0;
	  let sync;
	  invoke(0);
	  if (sync === undefined) {
	    sync = false;
	  }

	  function invoke(i) {
	    fn(arr[i], function mapItemCallback(err, transformed) {
	      result[i] = transformed;
	      next(err);
	    });
	  }

	  function next(err) {
	    if (err) {
	      return callback(err);
	    }
	    if (++index === length) {
	      return callback(null, result);
	    }
	    if (sync === undefined) {
	      sync = true;
	    }
	    const i = index;
	    if (sync) {
	      return process.nextTick(function () {
	        invoke(i);
	      });
	    }
	    invoke(index);
	  }
	}

	/**
	 * @param {Array.<Function>} arr
	 * @param {Function} [callback]
	 */
	function parallel(arr, callback) {
	  if (!Array.isArray(arr)) {
	    throw new TypeError('First parameter must be an Array');
	  }
	  callback = callback || noop;
	  const length = arr.length;
	  let completed = 0;
	  for (let i = 0; i < length; i++) {
	    arr[i](next);
	  }
	  function next(err) {
	    if (err) {
	      const cb = callback;
	      callback = noop;
	      return cb(err);
	    }
	    if (++completed !== length) {
	      return;
	    }
	    callback();
	  }
	}

	/**
	 * Similar to async.series(), but instead accumulating the result in an Array, it callbacks with the result of the last
	 * function in the array.
	 * @param {Array.<Function>} arr
	 * @param {Function} [callback]
	 */
	function series(arr, callback) {
	  if (!Array.isArray(arr)) {
	    throw new TypeError('First parameter must be an Array');
	  }
	  callback = callback || noop;
	  let index = 0;
	  let sync;
	  next();
	  function next(err, result) {
	    if (err) {
	      return callback(err);
	    }
	    if (index === arr.length) {
	      return callback(null, result);
	    }
	    if (sync) {
	      return process.nextTick(function () {
	        sync = true;
	        arr[index++](next);
	        sync = false;
	      });
	    }
	    sync = true;
	    arr[index++](next);
	    sync = false;
	  }
	}

	/**
	 * @param {Number} count
	 * @param {Function} iteratorFunc
	 * @param {Function} [callback]
	 */
	function times(count, iteratorFunc, callback) {
	  callback = callback || noop;
	  count = +count;
	  if (isNaN(count) || count === 0) {
	    return callback();
	  }
	  let completed = 0;
	  for (let i = 0; i < count; i++) {
	    iteratorFunc(i, next);
	  }
	  function next(err) {
	    if (err) {
	      const cb = callback;
	      callback = noop;
	      return cb(err);
	    }
	    if (++completed !== count) {
	      return;
	    }
	    callback();
	  }
	}

	/**
	 * @param {Number} count
	 * @param {Number} limit
	 * @param {Function} iteratorFunc
	 * @param {Function} [callback]
	 */
	function timesLimit(count, limit, iteratorFunc, callback) {
	  let sync = undefined;
	  callback = callback || noop;
	  limit = Math.min(limit, count);
	  let index = limit - 1;
	  let i;
	  let completed = 0;
	  for (i = 0; i < limit; i++) {
	    iteratorFunc(i, next);
	  }
	  i = -1;
	  function next(err) {
	    if (err) {
	      const cb = callback;
	      callback = noop;
	      cb(err);
	      return;
	    }
	    if (++completed === count) {
	      return callback();
	    }
	    index++;
	    if (index >= count) {
	      return;
	    }
	    if (sync === undefined) {
	      sync = (i >= 0);
	    }
	    if (sync) {
	      const captureIndex = index;
	      return process.nextTick(function () {
	        iteratorFunc(captureIndex, next);
	      });
	    }
	    iteratorFunc(index, next);
	  }
	}

	/**
	 * @param {Number} count
	 * @param {Function} iteratorFunction
	 * @param {Function} callback
	 */
	function timesSeries(count, iteratorFunction, callback) {
	  count = +count;
	  if (isNaN(count) || count < 1) {
	    return callback();
	  }
	  let index = 1;
	  let sync;
	  iteratorFunction(0, next);
	  if (sync === undefined) {
	    sync = false;
	  }
	  function next(err) {
	    if (err) {
	      return callback(err);
	    }
	    if (index === count) {
	      return callback();
	    }
	    if (sync === undefined) {
	      sync = true;
	    }
	    const i = index++;
	    if (sync) {
	      //Prevent "Maximum call stack size exceeded"
	      return process.nextTick(function () {
	        iteratorFunction(i, next);
	      });
	    }
	    //do a sync call as the callback is going to call on a future tick
	    iteratorFunction(i, next);
	  }
	}

	/**
	 * @param {Function} condition
	 * @param {Function} fn
	 * @param {Function} callback
	 */
	function whilst(condition, fn, callback) {
	  let sync = 0;
	  next();
	  function next(err) {
	    if (err) {
	      return callback(err);
	    }
	    if (!condition()) {
	      return callback();
	    }
	    if (sync === 0) {
	      sync = 1;
	      fn(function (err) {
	        if (sync === 1) {
	          //sync function
	          sync = 4;
	        }
	        next(err);
	      });
	      if (sync === 1) {
	        //async function
	        sync = 2;
	      }
	      return;
	    }
	    if (sync === 4) {
	      //Prevent "Maximum call stack size exceeded"
	      return process.nextTick(function () {
	        fn(next);
	      });
	    }
	    //do a sync call as the callback is going to call on a future tick
	    fn(next);
	  }
	}

	utils$c.adaptNamedParamsPrepared = adaptNamedParamsPrepared;
	utils$c.adaptNamedParamsWithHints = adaptNamedParamsWithHints;
	utils$c.AddressResolver = AddressResolver;
	utils$c.allocBuffer = allocBuffer;
	utils$c.allocBufferUnsafe = allocBufferUnsafe;
	utils$c.allocBufferFromArray = allocBufferFromArray;
	utils$c.allocBufferFromString = allocBufferFromString;
	utils$c.arrayIterator = arrayIterator;
	utils$c.binarySearch = binarySearch;
	utils$c.callbackOnce = callbackOnce;
	utils$c.copyBuffer = copyBuffer;
	utils$c.deepExtend = deepExtend;
	utils$c.each = each;
	utils$c.eachSeries = eachSeries;
	/** @const */
	utils$c.emptyArray = Object.freeze([]);
	/** @const */
	utils$c.emptyObject = emptyObject;
	utils$c.extend = extend;
	utils$c.fixStack = fixStack;
	utils$c.forEachOf = forEachOf;
	utils$c.funcCompare = funcCompare;
	utils$c.ifUndefined = ifUndefined;
	utils$c.ifUndefined3 = ifUndefined3;
	utils$c.insertSorted = insertSorted;
	utils$c.iteratorToArray = iteratorToArray;
	utils$c.log = log;
	utils$c.map = map;
	utils$c.mapSeries = mapSeries;
	utils$c.maxInt = maxInt;
	utils$c.noop = noop;
	utils$c.objectValues = objectValues;
	utils$c.parallel = parallel;
	utils$c.promiseWrapper = promiseWrapper;
	utils$c.propCompare = propCompare;
	utils$c.series = series;
	utils$c.shuffleArray = shuffleArray;
	utils$c.stringRepeat = stringRepeat;
	utils$c.times = times;
	utils$c.timesLimit = timesLimit;
	utils$c.timesSeries = timesSeries;
	utils$c.totalLength = totalLength;
	utils$c.validateFn = validateFn;
	utils$c.whilst = whilst;
	utils$c.HashSet = HashSet;
	return utils$c;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredAddressResolution;

function requireAddressResolution () {
	if (hasRequiredAddressResolution) return addressResolution;
	hasRequiredAddressResolution = 1;
	const dns = require$$0$9;
	const util = require$$0$6;
	const utils = requireUtils$c();
	/** @module policies/addressResolution */
	/**
	 * @class
	 * @classdesc
	 * Translates IP addresses received from Cassandra nodes into locally queryable
	 * addresses.
	 * <p>
	 * The driver auto-detects new Cassandra nodes added to the cluster through server
	 * side pushed notifications and through checking the system tables. For each
	 * node, the address received will correspond to the address set as
	 * <code>rpc_address</code> in the node yaml file. In most case, this is the correct
	 * address to use by the driver and that is what is used by default. However,
	 * sometimes the addresses received through this mechanism will either not be
	 * reachable directly by the driver or should not be the preferred address to use
	 * to reach the node (for instance, the <code>rpc_address</code> set on Cassandra nodes
	 * might be a private IP, but some clients  may have to use a public IP, or
	 * pass by a router to reach that node). This interface allows to deal with
	 * such cases, by allowing to translate an address as sent by a Cassandra node
	 * to another address to be used by the driver for connection.
	 * <p>
	 * Please note that the contact points addresses provided while creating the
	 * {@link Client} instance are not "translated", only IP address retrieve from or sent
	 * by Cassandra nodes to the driver are.
	 * @constructor
	 */
	function AddressTranslator() {

	}

	/**
	 * Translates a Cassandra <code>rpc_address</code> to another address if necessary.
	 * @param {String} address the address of a node as returned by Cassandra.
	 * <p>
	 * Note that if the <code>rpc_address</code> of a node has been configured to <code>0.0.0.0</code>
	 * server side, then the provided address will be the node <code>listen_address</code>,
	 * *not* <code>0.0.0.0</code>.
	 * </p>
	 * @param {Number} port The port number, as specified in the [protocolOptions]{@link ClientOptions} at Client instance creation (9042 by default).
	 * @param {Function} callback Callback to invoke with endpoint as first parameter.
	 * The endpoint is an string composed of the IP address and the port number in the format <code>ipAddress:port</code>.
	 */
	AddressTranslator.prototype.translate = function (address, port, callback) {
	  callback(address + ':' + port);
	};

	/**
	 * @class
	 * @classdesc
	 * {@link AddressTranslator} implementation for multi-region EC2 deployments <strong>where clients are also deployed in EC2</strong>.
	 * <p>
	 * Its distinctive feature is that it translates addresses according to the location of the Cassandra host:
	 * </p>
	 * <ul>
	 *  <li>addresses in different EC2 regions (than the client) are unchanged</li>
	 *  <li>addresses in the same EC2 region are <strong>translated to private IPs</strong></li>
	 * </ul>
	 * <p>
	 * This optimizes network costs, because Amazon charges more for communication over public IPs.
	 * </p>
	 * @constructor
	 */
	function EC2MultiRegionTranslator() {

	}

	util.inherits(EC2MultiRegionTranslator, AddressTranslator);

	/**
	 * Addresses in the same EC2 region are translated to private IPs and addresses in
	 * different EC2 regions (than the client) are unchanged
	 */
	EC2MultiRegionTranslator.prototype.translate = function (address, port, callback) {
	  let newAddress = address;
	  const self = this;
	  let name;
	  utils.series([
	    function resolve(next) {
	      dns.reverse(address, function (err, hostNames) {
	        if (err) {
	          return next(err);
	        }
	        if (!hostNames) {
	          return next();
	        }
	        name = hostNames[0];
	        next();
	      });
	    },
	    function lookup(next) {
	      if (!name) {
	        return next();
	      }
	      dns.lookup(name, function (err, lookupAddress) {
	        if (err) {
	          return next(err);
	        }
	        newAddress = lookupAddress;
	        next();
	      });
	    }], function (err) {
	    if (err) {
	      //there was an issue while doing dns resolution
	      self.logError(address, err);
	    }
	    callback(newAddress + ':' + port);
	  });
	};

	/**
	 * Log method called to log errors that occurred while performing dns resolution.
	 * You can assign your own method to the class instance to do proper logging.
	 * @param {String} address
	 * @param {Error} err
	 */
	EC2MultiRegionTranslator.prototype.logError = function (address, err) {
	  //Do nothing by default
	};

	addressResolution.AddressTranslator = AddressTranslator;
	addressResolution.EC2MultiRegionTranslator = EC2MultiRegionTranslator;
	return addressResolution;
}var types$9 = {};var umd = {exports: {}};var hasRequiredUmd;

function requireUmd () {
	if (hasRequiredUmd) return umd.exports;
	hasRequiredUmd = 1;
	(function (module, exports) {
		// GENERATED FILE. DO NOT EDIT.
		var Long = (function(exports) {
		  
		  Object.defineProperty(exports, "__esModule", {
		    value: true
		  });
		  exports.default = void 0;
		  
		  /**
		   * @license
		   * Copyright 2009 The Closure Library Authors
		   * Copyright 2020 Daniel Wirtz / The long.js Authors.
		   *
		   * Licensed under the Apache License, Version 2.0 (the "License");
		   * you may not use this file except in compliance with the License.
		   * You may obtain a copy of the License at
		   *
		   *     http://www.apache.org/licenses/LICENSE-2.0
		   *
		   * Unless required by applicable law or agreed to in writing, software
		   * distributed under the License is distributed on an "AS IS" BASIS,
		   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		   * See the License for the specific language governing permissions and
		   * limitations under the License.
		   *
		   * SPDX-License-Identifier: Apache-2.0
		   */
		  // WebAssembly optimizations to do native i64 multiplication and divide
		  var wasm = null;
		  
		  try {
		    wasm = new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0, 97, 115, 109, 1, 0, 0, 0, 1, 13, 2, 96, 0, 1, 127, 96, 4, 127, 127, 127, 127, 1, 127, 3, 7, 6, 0, 1, 1, 1, 1, 1, 6, 6, 1, 127, 1, 65, 0, 11, 7, 50, 6, 3, 109, 117, 108, 0, 1, 5, 100, 105, 118, 95, 115, 0, 2, 5, 100, 105, 118, 95, 117, 0, 3, 5, 114, 101, 109, 95, 115, 0, 4, 5, 114, 101, 109, 95, 117, 0, 5, 8, 103, 101, 116, 95, 104, 105, 103, 104, 0, 0, 10, 191, 1, 6, 4, 0, 35, 0, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 126, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 127, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 128, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 129, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 130, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11])), {}).exports;
		  } catch (e) {// no wasm support :(
		  }
		  /**
		   * Constructs a 64 bit two's-complement integer, given its low and high 32 bit values as *signed* integers.
		   *  See the from* functions below for more convenient ways of constructing Longs.
		   * @exports Long
		   * @class A Long class for representing a 64 bit two's-complement integer value.
		   * @param {number} low The low (signed) 32 bits of the long
		   * @param {number} high The high (signed) 32 bits of the long
		   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
		   * @constructor
		   */
		  
		  
		  function Long(low, high, unsigned) {
		    /**
		     * The low 32 bits as a signed value.
		     * @type {number}
		     */
		    this.low = low | 0;
		    /**
		     * The high 32 bits as a signed value.
		     * @type {number}
		     */
		  
		    this.high = high | 0;
		    /**
		     * Whether unsigned or not.
		     * @type {boolean}
		     */
		  
		    this.unsigned = !!unsigned;
		  } // The internal representation of a long is the two given signed, 32-bit values.
		  // We use 32-bit pieces because these are the size of integers on which
		  // Javascript performs bit-operations.  For operations like addition and
		  // multiplication, we split each number into 16 bit pieces, which can easily be
		  // multiplied within Javascript's floating-point representation without overflow
		  // or change in sign.
		  //
		  // In the algorithms below, we frequently reduce the negative case to the
		  // positive case by negating the input(s) and then post-processing the result.
		  // Note that we must ALWAYS check specially whether those values are MIN_VALUE
		  // (-2^63) because -MIN_VALUE == MIN_VALUE (since 2^63 cannot be represented as
		  // a positive number, it overflows back into a negative).  Not handling this
		  // case would often result in infinite recursion.
		  //
		  // Common constant values ZERO, ONE, NEG_ONE, etc. are defined below the from*
		  // methods on which they depend.
		  
		  /**
		   * An indicator used to reliably determine if an object is a Long or not.
		   * @type {boolean}
		   * @const
		   * @private
		   */
		  
		  
		  Long.prototype.__isLong__;
		  Object.defineProperty(Long.prototype, "__isLong__", {
		    value: true
		  });
		  /**
		   * @function
		   * @param {*} obj Object
		   * @returns {boolean}
		   * @inner
		   */
		  
		  function isLong(obj) {
		    return (obj && obj["__isLong__"]) === true;
		  }
		  /**
		   * @function
		   * @param {*} value number
		   * @returns {number}
		   * @inner
		   */
		  
		  
		  function ctz32(value) {
		    var c = Math.clz32(value & -value);
		    return value ? 31 - c : c;
		  }
		  /**
		   * Tests if the specified object is a Long.
		   * @function
		   * @param {*} obj Object
		   * @returns {boolean}
		   */
		  
		  
		  Long.isLong = isLong;
		  /**
		   * A cache of the Long representations of small integer values.
		   * @type {!Object}
		   * @inner
		   */
		  
		  var INT_CACHE = {};
		  /**
		   * A cache of the Long representations of small unsigned integer values.
		   * @type {!Object}
		   * @inner
		   */
		  
		  var UINT_CACHE = {};
		  /**
		   * @param {number} value
		   * @param {boolean=} unsigned
		   * @returns {!Long}
		   * @inner
		   */
		  
		  function fromInt(value, unsigned) {
		    var obj, cachedObj, cache;
		  
		    if (unsigned) {
		      value >>>= 0;
		  
		      if (cache = 0 <= value && value < 256) {
		        cachedObj = UINT_CACHE[value];
		        if (cachedObj) return cachedObj;
		      }
		  
		      obj = fromBits(value, 0, true);
		      if (cache) UINT_CACHE[value] = obj;
		      return obj;
		    } else {
		      value |= 0;
		  
		      if (cache = -128 <= value && value < 128) {
		        cachedObj = INT_CACHE[value];
		        if (cachedObj) return cachedObj;
		      }
		  
		      obj = fromBits(value, value < 0 ? -1 : 0, false);
		      if (cache) INT_CACHE[value] = obj;
		      return obj;
		    }
		  }
		  /**
		   * Returns a Long representing the given 32 bit integer value.
		   * @function
		   * @param {number} value The 32 bit integer in question
		   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
		   * @returns {!Long} The corresponding Long value
		   */
		  
		  
		  Long.fromInt = fromInt;
		  /**
		   * @param {number} value
		   * @param {boolean=} unsigned
		   * @returns {!Long}
		   * @inner
		   */
		  
		  function fromNumber(value, unsigned) {
		    if (isNaN(value)) return unsigned ? UZERO : ZERO;
		  
		    if (unsigned) {
		      if (value < 0) return UZERO;
		      if (value >= TWO_PWR_64_DBL) return MAX_UNSIGNED_VALUE;
		    } else {
		      if (value <= -TWO_PWR_63_DBL) return MIN_VALUE;
		      if (value + 1 >= TWO_PWR_63_DBL) return MAX_VALUE;
		    }
		  
		    if (value < 0) return fromNumber(-value, unsigned).neg();
		    return fromBits(value % TWO_PWR_32_DBL | 0, value / TWO_PWR_32_DBL | 0, unsigned);
		  }
		  /**
		   * Returns a Long representing the given value, provided that it is a finite number. Otherwise, zero is returned.
		   * @function
		   * @param {number} value The number in question
		   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
		   * @returns {!Long} The corresponding Long value
		   */
		  
		  
		  Long.fromNumber = fromNumber;
		  /**
		   * @param {number} lowBits
		   * @param {number} highBits
		   * @param {boolean=} unsigned
		   * @returns {!Long}
		   * @inner
		   */
		  
		  function fromBits(lowBits, highBits, unsigned) {
		    return new Long(lowBits, highBits, unsigned);
		  }
		  /**
		   * Returns a Long representing the 64 bit integer that comes by concatenating the given low and high bits. Each is
		   *  assumed to use 32 bits.
		   * @function
		   * @param {number} lowBits The low 32 bits
		   * @param {number} highBits The high 32 bits
		   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
		   * @returns {!Long} The corresponding Long value
		   */
		  
		  
		  Long.fromBits = fromBits;
		  /**
		   * @function
		   * @param {number} base
		   * @param {number} exponent
		   * @returns {number}
		   * @inner
		   */
		  
		  var pow_dbl = Math.pow; // Used 4 times (4*8 to 15+4)
		  
		  /**
		   * @param {string} str
		   * @param {(boolean|number)=} unsigned
		   * @param {number=} radix
		   * @returns {!Long}
		   * @inner
		   */
		  
		  function fromString(str, unsigned, radix) {
		    if (str.length === 0) throw Error('empty string');
		  
		    if (typeof unsigned === 'number') {
		      // For goog.math.long compatibility
		      radix = unsigned;
		      unsigned = false;
		    } else {
		      unsigned = !!unsigned;
		    }
		  
		    if (str === "NaN" || str === "Infinity" || str === "+Infinity" || str === "-Infinity") return unsigned ? UZERO : ZERO;
		    radix = radix || 10;
		    if (radix < 2 || 36 < radix) throw RangeError('radix');
		    var p;
		    if ((p = str.indexOf('-')) > 0) throw Error('interior hyphen');else if (p === 0) {
		      return fromString(str.substring(1), unsigned, radix).neg();
		    } // Do several (8) digits each time through the loop, so as to
		    // minimize the calls to the very expensive emulated div.
		  
		    var radixToPower = fromNumber(pow_dbl(radix, 8));
		    var result = ZERO;
		  
		    for (var i = 0; i < str.length; i += 8) {
		      var size = Math.min(8, str.length - i),
		          value = parseInt(str.substring(i, i + size), radix);
		  
		      if (size < 8) {
		        var power = fromNumber(pow_dbl(radix, size));
		        result = result.mul(power).add(fromNumber(value));
		      } else {
		        result = result.mul(radixToPower);
		        result = result.add(fromNumber(value));
		      }
		    }
		  
		    result.unsigned = unsigned;
		    return result;
		  }
		  /**
		   * Returns a Long representation of the given string, written using the specified radix.
		   * @function
		   * @param {string} str The textual representation of the Long
		   * @param {(boolean|number)=} unsigned Whether unsigned or not, defaults to signed
		   * @param {number=} radix The radix in which the text is written (2-36), defaults to 10
		   * @returns {!Long} The corresponding Long value
		   */
		  
		  
		  Long.fromString = fromString;
		  /**
		   * @function
		   * @param {!Long|number|string|!{low: number, high: number, unsigned: boolean}} val
		   * @param {boolean=} unsigned
		   * @returns {!Long}
		   * @inner
		   */
		  
		  function fromValue(val, unsigned) {
		    if (typeof val === 'number') return fromNumber(val, unsigned);
		    if (typeof val === 'string') return fromString(val, unsigned); // Throws for non-objects, converts non-instanceof Long:
		  
		    return fromBits(val.low, val.high, typeof unsigned === 'boolean' ? unsigned : val.unsigned);
		  }
		  /**
		   * Converts the specified value to a Long using the appropriate from* function for its type.
		   * @function
		   * @param {!Long|number|string|!{low: number, high: number, unsigned: boolean}} val Value
		   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
		   * @returns {!Long}
		   */
		  
		  
		  Long.fromValue = fromValue; // NOTE: the compiler should inline these constant values below and then remove these variables, so there should be
		  // no runtime penalty for these.
		  
		  /**
		   * @type {number}
		   * @const
		   * @inner
		   */
		  
		  var TWO_PWR_16_DBL = 1 << 16;
		  /**
		   * @type {number}
		   * @const
		   * @inner
		   */
		  
		  var TWO_PWR_24_DBL = 1 << 24;
		  /**
		   * @type {number}
		   * @const
		   * @inner
		   */
		  
		  var TWO_PWR_32_DBL = TWO_PWR_16_DBL * TWO_PWR_16_DBL;
		  /**
		   * @type {number}
		   * @const
		   * @inner
		   */
		  
		  var TWO_PWR_64_DBL = TWO_PWR_32_DBL * TWO_PWR_32_DBL;
		  /**
		   * @type {number}
		   * @const
		   * @inner
		   */
		  
		  var TWO_PWR_63_DBL = TWO_PWR_64_DBL / 2;
		  /**
		   * @type {!Long}
		   * @const
		   * @inner
		   */
		  
		  var TWO_PWR_24 = fromInt(TWO_PWR_24_DBL);
		  /**
		   * @type {!Long}
		   * @inner
		   */
		  
		  var ZERO = fromInt(0);
		  /**
		   * Signed zero.
		   * @type {!Long}
		   */
		  
		  Long.ZERO = ZERO;
		  /**
		   * @type {!Long}
		   * @inner
		   */
		  
		  var UZERO = fromInt(0, true);
		  /**
		   * Unsigned zero.
		   * @type {!Long}
		   */
		  
		  Long.UZERO = UZERO;
		  /**
		   * @type {!Long}
		   * @inner
		   */
		  
		  var ONE = fromInt(1);
		  /**
		   * Signed one.
		   * @type {!Long}
		   */
		  
		  Long.ONE = ONE;
		  /**
		   * @type {!Long}
		   * @inner
		   */
		  
		  var UONE = fromInt(1, true);
		  /**
		   * Unsigned one.
		   * @type {!Long}
		   */
		  
		  Long.UONE = UONE;
		  /**
		   * @type {!Long}
		   * @inner
		   */
		  
		  var NEG_ONE = fromInt(-1);
		  /**
		   * Signed negative one.
		   * @type {!Long}
		   */
		  
		  Long.NEG_ONE = NEG_ONE;
		  /**
		   * @type {!Long}
		   * @inner
		   */
		  
		  var MAX_VALUE = fromBits(0xFFFFFFFF | 0, 0x7FFFFFFF | 0, false);
		  /**
		   * Maximum signed value.
		   * @type {!Long}
		   */
		  
		  Long.MAX_VALUE = MAX_VALUE;
		  /**
		   * @type {!Long}
		   * @inner
		   */
		  
		  var MAX_UNSIGNED_VALUE = fromBits(0xFFFFFFFF | 0, 0xFFFFFFFF | 0, true);
		  /**
		   * Maximum unsigned value.
		   * @type {!Long}
		   */
		  
		  Long.MAX_UNSIGNED_VALUE = MAX_UNSIGNED_VALUE;
		  /**
		   * @type {!Long}
		   * @inner
		   */
		  
		  var MIN_VALUE = fromBits(0, 0x80000000 | 0, false);
		  /**
		   * Minimum signed value.
		   * @type {!Long}
		   */
		  
		  Long.MIN_VALUE = MIN_VALUE;
		  /**
		   * @alias Long.prototype
		   * @inner
		   */
		  
		  var LongPrototype = Long.prototype;
		  /**
		   * Converts the Long to a 32 bit integer, assuming it is a 32 bit integer.
		   * @this {!Long}
		   * @returns {number}
		   */
		  
		  LongPrototype.toInt = function toInt() {
		    return this.unsigned ? this.low >>> 0 : this.low;
		  };
		  /**
		   * Converts the Long to a the nearest floating-point representation of this value (double, 53 bit mantissa).
		   * @this {!Long}
		   * @returns {number}
		   */
		  
		  
		  LongPrototype.toNumber = function toNumber() {
		    if (this.unsigned) return (this.high >>> 0) * TWO_PWR_32_DBL + (this.low >>> 0);
		    return this.high * TWO_PWR_32_DBL + (this.low >>> 0);
		  };
		  /**
		   * Converts the Long to a string written in the specified radix.
		   * @this {!Long}
		   * @param {number=} radix Radix (2-36), defaults to 10
		   * @returns {string}
		   * @override
		   * @throws {RangeError} If `radix` is out of range
		   */
		  
		  
		  LongPrototype.toString = function toString(radix) {
		    radix = radix || 10;
		    if (radix < 2 || 36 < radix) throw RangeError('radix');
		    if (this.isZero()) return '0';
		  
		    if (this.isNegative()) {
		      // Unsigned Longs are never negative
		      if (this.eq(MIN_VALUE)) {
		        // We need to change the Long value before it can be negated, so we remove
		        // the bottom-most digit in this base and then recurse to do the rest.
		        var radixLong = fromNumber(radix),
		            div = this.div(radixLong),
		            rem1 = div.mul(radixLong).sub(this);
		        return div.toString(radix) + rem1.toInt().toString(radix);
		      } else return '-' + this.neg().toString(radix);
		    } // Do several (6) digits each time through the loop, so as to
		    // minimize the calls to the very expensive emulated div.
		  
		  
		    var radixToPower = fromNumber(pow_dbl(radix, 6), this.unsigned),
		        rem = this;
		    var result = '';
		  
		    while (true) {
		      var remDiv = rem.div(radixToPower),
		          intval = rem.sub(remDiv.mul(radixToPower)).toInt() >>> 0,
		          digits = intval.toString(radix);
		      rem = remDiv;
		      if (rem.isZero()) return digits + result;else {
		        while (digits.length < 6) digits = '0' + digits;
		  
		        result = '' + digits + result;
		      }
		    }
		  };
		  /**
		   * Gets the high 32 bits as a signed integer.
		   * @this {!Long}
		   * @returns {number} Signed high bits
		   */
		  
		  
		  LongPrototype.getHighBits = function getHighBits() {
		    return this.high;
		  };
		  /**
		   * Gets the high 32 bits as an unsigned integer.
		   * @this {!Long}
		   * @returns {number} Unsigned high bits
		   */
		  
		  
		  LongPrototype.getHighBitsUnsigned = function getHighBitsUnsigned() {
		    return this.high >>> 0;
		  };
		  /**
		   * Gets the low 32 bits as a signed integer.
		   * @this {!Long}
		   * @returns {number} Signed low bits
		   */
		  
		  
		  LongPrototype.getLowBits = function getLowBits() {
		    return this.low;
		  };
		  /**
		   * Gets the low 32 bits as an unsigned integer.
		   * @this {!Long}
		   * @returns {number} Unsigned low bits
		   */
		  
		  
		  LongPrototype.getLowBitsUnsigned = function getLowBitsUnsigned() {
		    return this.low >>> 0;
		  };
		  /**
		   * Gets the number of bits needed to represent the absolute value of this Long.
		   * @this {!Long}
		   * @returns {number}
		   */
		  
		  
		  LongPrototype.getNumBitsAbs = function getNumBitsAbs() {
		    if (this.isNegative()) // Unsigned Longs are never negative
		      return this.eq(MIN_VALUE) ? 64 : this.neg().getNumBitsAbs();
		    var val = this.high != 0 ? this.high : this.low;
		  
		    for (var bit = 31; bit > 0; bit--) if ((val & 1 << bit) != 0) break;
		  
		    return this.high != 0 ? bit + 33 : bit + 1;
		  };
		  /**
		   * Tests if this Long's value equals zero.
		   * @this {!Long}
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.isZero = function isZero() {
		    return this.high === 0 && this.low === 0;
		  };
		  /**
		   * Tests if this Long's value equals zero. This is an alias of {@link Long#isZero}.
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.eqz = LongPrototype.isZero;
		  /**
		   * Tests if this Long's value is negative.
		   * @this {!Long}
		   * @returns {boolean}
		   */
		  
		  LongPrototype.isNegative = function isNegative() {
		    return !this.unsigned && this.high < 0;
		  };
		  /**
		   * Tests if this Long's value is positive or zero.
		   * @this {!Long}
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.isPositive = function isPositive() {
		    return this.unsigned || this.high >= 0;
		  };
		  /**
		   * Tests if this Long's value is odd.
		   * @this {!Long}
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.isOdd = function isOdd() {
		    return (this.low & 1) === 1;
		  };
		  /**
		   * Tests if this Long's value is even.
		   * @this {!Long}
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.isEven = function isEven() {
		    return (this.low & 1) === 0;
		  };
		  /**
		   * Tests if this Long's value equals the specified's.
		   * @this {!Long}
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.equals = function equals(other) {
		    if (!isLong(other)) other = fromValue(other);
		    if (this.unsigned !== other.unsigned && this.high >>> 31 === 1 && other.high >>> 31 === 1) return false;
		    return this.high === other.high && this.low === other.low;
		  };
		  /**
		   * Tests if this Long's value equals the specified's. This is an alias of {@link Long#equals}.
		   * @function
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.eq = LongPrototype.equals;
		  /**
		   * Tests if this Long's value differs from the specified's.
		   * @this {!Long}
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  LongPrototype.notEquals = function notEquals(other) {
		    return !this.eq(
		    /* validates */
		    other);
		  };
		  /**
		   * Tests if this Long's value differs from the specified's. This is an alias of {@link Long#notEquals}.
		   * @function
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.neq = LongPrototype.notEquals;
		  /**
		   * Tests if this Long's value differs from the specified's. This is an alias of {@link Long#notEquals}.
		   * @function
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  LongPrototype.ne = LongPrototype.notEquals;
		  /**
		   * Tests if this Long's value is less than the specified's.
		   * @this {!Long}
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  LongPrototype.lessThan = function lessThan(other) {
		    return this.comp(
		    /* validates */
		    other) < 0;
		  };
		  /**
		   * Tests if this Long's value is less than the specified's. This is an alias of {@link Long#lessThan}.
		   * @function
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.lt = LongPrototype.lessThan;
		  /**
		   * Tests if this Long's value is less than or equal the specified's.
		   * @this {!Long}
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  LongPrototype.lessThanOrEqual = function lessThanOrEqual(other) {
		    return this.comp(
		    /* validates */
		    other) <= 0;
		  };
		  /**
		   * Tests if this Long's value is less than or equal the specified's. This is an alias of {@link Long#lessThanOrEqual}.
		   * @function
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.lte = LongPrototype.lessThanOrEqual;
		  /**
		   * Tests if this Long's value is less than or equal the specified's. This is an alias of {@link Long#lessThanOrEqual}.
		   * @function
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  LongPrototype.le = LongPrototype.lessThanOrEqual;
		  /**
		   * Tests if this Long's value is greater than the specified's.
		   * @this {!Long}
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  LongPrototype.greaterThan = function greaterThan(other) {
		    return this.comp(
		    /* validates */
		    other) > 0;
		  };
		  /**
		   * Tests if this Long's value is greater than the specified's. This is an alias of {@link Long#greaterThan}.
		   * @function
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.gt = LongPrototype.greaterThan;
		  /**
		   * Tests if this Long's value is greater than or equal the specified's.
		   * @this {!Long}
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  LongPrototype.greaterThanOrEqual = function greaterThanOrEqual(other) {
		    return this.comp(
		    /* validates */
		    other) >= 0;
		  };
		  /**
		   * Tests if this Long's value is greater than or equal the specified's. This is an alias of {@link Long#greaterThanOrEqual}.
		   * @function
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  
		  LongPrototype.gte = LongPrototype.greaterThanOrEqual;
		  /**
		   * Tests if this Long's value is greater than or equal the specified's. This is an alias of {@link Long#greaterThanOrEqual}.
		   * @function
		   * @param {!Long|number|string} other Other value
		   * @returns {boolean}
		   */
		  
		  LongPrototype.ge = LongPrototype.greaterThanOrEqual;
		  /**
		   * Compares this Long's value with the specified's.
		   * @this {!Long}
		   * @param {!Long|number|string} other Other value
		   * @returns {number} 0 if they are the same, 1 if the this is greater and -1
		   *  if the given one is greater
		   */
		  
		  LongPrototype.compare = function compare(other) {
		    if (!isLong(other)) other = fromValue(other);
		    if (this.eq(other)) return 0;
		    var thisNeg = this.isNegative(),
		        otherNeg = other.isNegative();
		    if (thisNeg && !otherNeg) return -1;
		    if (!thisNeg && otherNeg) return 1; // At this point the sign bits are the same
		  
		    if (!this.unsigned) return this.sub(other).isNegative() ? -1 : 1; // Both are positive if at least one is unsigned
		  
		    return other.high >>> 0 > this.high >>> 0 || other.high === this.high && other.low >>> 0 > this.low >>> 0 ? -1 : 1;
		  };
		  /**
		   * Compares this Long's value with the specified's. This is an alias of {@link Long#compare}.
		   * @function
		   * @param {!Long|number|string} other Other value
		   * @returns {number} 0 if they are the same, 1 if the this is greater and -1
		   *  if the given one is greater
		   */
		  
		  
		  LongPrototype.comp = LongPrototype.compare;
		  /**
		   * Negates this Long's value.
		   * @this {!Long}
		   * @returns {!Long} Negated Long
		   */
		  
		  LongPrototype.negate = function negate() {
		    if (!this.unsigned && this.eq(MIN_VALUE)) return MIN_VALUE;
		    return this.not().add(ONE);
		  };
		  /**
		   * Negates this Long's value. This is an alias of {@link Long#negate}.
		   * @function
		   * @returns {!Long} Negated Long
		   */
		  
		  
		  LongPrototype.neg = LongPrototype.negate;
		  /**
		   * Returns the sum of this and the specified Long.
		   * @this {!Long}
		   * @param {!Long|number|string} addend Addend
		   * @returns {!Long} Sum
		   */
		  
		  LongPrototype.add = function add(addend) {
		    if (!isLong(addend)) addend = fromValue(addend); // Divide each number into 4 chunks of 16 bits, and then sum the chunks.
		  
		    var a48 = this.high >>> 16;
		    var a32 = this.high & 0xFFFF;
		    var a16 = this.low >>> 16;
		    var a00 = this.low & 0xFFFF;
		    var b48 = addend.high >>> 16;
		    var b32 = addend.high & 0xFFFF;
		    var b16 = addend.low >>> 16;
		    var b00 = addend.low & 0xFFFF;
		    var c48 = 0,
		        c32 = 0,
		        c16 = 0,
		        c00 = 0;
		    c00 += a00 + b00;
		    c16 += c00 >>> 16;
		    c00 &= 0xFFFF;
		    c16 += a16 + b16;
		    c32 += c16 >>> 16;
		    c16 &= 0xFFFF;
		    c32 += a32 + b32;
		    c48 += c32 >>> 16;
		    c32 &= 0xFFFF;
		    c48 += a48 + b48;
		    c48 &= 0xFFFF;
		    return fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
		  };
		  /**
		   * Returns the difference of this and the specified Long.
		   * @this {!Long}
		   * @param {!Long|number|string} subtrahend Subtrahend
		   * @returns {!Long} Difference
		   */
		  
		  
		  LongPrototype.subtract = function subtract(subtrahend) {
		    if (!isLong(subtrahend)) subtrahend = fromValue(subtrahend);
		    return this.add(subtrahend.neg());
		  };
		  /**
		   * Returns the difference of this and the specified Long. This is an alias of {@link Long#subtract}.
		   * @function
		   * @param {!Long|number|string} subtrahend Subtrahend
		   * @returns {!Long} Difference
		   */
		  
		  
		  LongPrototype.sub = LongPrototype.subtract;
		  /**
		   * Returns the product of this and the specified Long.
		   * @this {!Long}
		   * @param {!Long|number|string} multiplier Multiplier
		   * @returns {!Long} Product
		   */
		  
		  LongPrototype.multiply = function multiply(multiplier) {
		    if (this.isZero()) return this;
		    if (!isLong(multiplier)) multiplier = fromValue(multiplier); // use wasm support if present
		  
		    if (wasm) {
		      var low = wasm["mul"](this.low, this.high, multiplier.low, multiplier.high);
		      return fromBits(low, wasm["get_high"](), this.unsigned);
		    }
		  
		    if (multiplier.isZero()) return this.unsigned ? UZERO : ZERO;
		    if (this.eq(MIN_VALUE)) return multiplier.isOdd() ? MIN_VALUE : ZERO;
		    if (multiplier.eq(MIN_VALUE)) return this.isOdd() ? MIN_VALUE : ZERO;
		  
		    if (this.isNegative()) {
		      if (multiplier.isNegative()) return this.neg().mul(multiplier.neg());else return this.neg().mul(multiplier).neg();
		    } else if (multiplier.isNegative()) return this.mul(multiplier.neg()).neg(); // If both longs are small, use float multiplication
		  
		  
		    if (this.lt(TWO_PWR_24) && multiplier.lt(TWO_PWR_24)) return fromNumber(this.toNumber() * multiplier.toNumber(), this.unsigned); // Divide each long into 4 chunks of 16 bits, and then add up 4x4 products.
		    // We can skip products that would overflow.
		  
		    var a48 = this.high >>> 16;
		    var a32 = this.high & 0xFFFF;
		    var a16 = this.low >>> 16;
		    var a00 = this.low & 0xFFFF;
		    var b48 = multiplier.high >>> 16;
		    var b32 = multiplier.high & 0xFFFF;
		    var b16 = multiplier.low >>> 16;
		    var b00 = multiplier.low & 0xFFFF;
		    var c48 = 0,
		        c32 = 0,
		        c16 = 0,
		        c00 = 0;
		    c00 += a00 * b00;
		    c16 += c00 >>> 16;
		    c00 &= 0xFFFF;
		    c16 += a16 * b00;
		    c32 += c16 >>> 16;
		    c16 &= 0xFFFF;
		    c16 += a00 * b16;
		    c32 += c16 >>> 16;
		    c16 &= 0xFFFF;
		    c32 += a32 * b00;
		    c48 += c32 >>> 16;
		    c32 &= 0xFFFF;
		    c32 += a16 * b16;
		    c48 += c32 >>> 16;
		    c32 &= 0xFFFF;
		    c32 += a00 * b32;
		    c48 += c32 >>> 16;
		    c32 &= 0xFFFF;
		    c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
		    c48 &= 0xFFFF;
		    return fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
		  };
		  /**
		   * Returns the product of this and the specified Long. This is an alias of {@link Long#multiply}.
		   * @function
		   * @param {!Long|number|string} multiplier Multiplier
		   * @returns {!Long} Product
		   */
		  
		  
		  LongPrototype.mul = LongPrototype.multiply;
		  /**
		   * Returns this Long divided by the specified. The result is signed if this Long is signed or
		   *  unsigned if this Long is unsigned.
		   * @this {!Long}
		   * @param {!Long|number|string} divisor Divisor
		   * @returns {!Long} Quotient
		   */
		  
		  LongPrototype.divide = function divide(divisor) {
		    if (!isLong(divisor)) divisor = fromValue(divisor);
		    if (divisor.isZero()) throw Error('division by zero'); // use wasm support if present
		  
		    if (wasm) {
		      // guard against signed division overflow: the largest
		      // negative number / -1 would be 1 larger than the largest
		      // positive number, due to two's complement.
		      if (!this.unsigned && this.high === -0x80000000 && divisor.low === -1 && divisor.high === -1) {
		        // be consistent with non-wasm code path
		        return this;
		      }
		  
		      var low = (this.unsigned ? wasm["div_u"] : wasm["div_s"])(this.low, this.high, divisor.low, divisor.high);
		      return fromBits(low, wasm["get_high"](), this.unsigned);
		    }
		  
		    if (this.isZero()) return this.unsigned ? UZERO : ZERO;
		    var approx, rem, res;
		  
		    if (!this.unsigned) {
		      // This section is only relevant for signed longs and is derived from the
		      // closure library as a whole.
		      if (this.eq(MIN_VALUE)) {
		        if (divisor.eq(ONE) || divisor.eq(NEG_ONE)) return MIN_VALUE; // recall that -MIN_VALUE == MIN_VALUE
		        else if (divisor.eq(MIN_VALUE)) return ONE;else {
		          // At this point, we have |other| >= 2, so |this/other| < |MIN_VALUE|.
		          var halfThis = this.shr(1);
		          approx = halfThis.div(divisor).shl(1);
		  
		          if (approx.eq(ZERO)) {
		            return divisor.isNegative() ? ONE : NEG_ONE;
		          } else {
		            rem = this.sub(divisor.mul(approx));
		            res = approx.add(rem.div(divisor));
		            return res;
		          }
		        }
		      } else if (divisor.eq(MIN_VALUE)) return this.unsigned ? UZERO : ZERO;
		  
		      if (this.isNegative()) {
		        if (divisor.isNegative()) return this.neg().div(divisor.neg());
		        return this.neg().div(divisor).neg();
		      } else if (divisor.isNegative()) return this.div(divisor.neg()).neg();
		  
		      res = ZERO;
		    } else {
		      // The algorithm below has not been made for unsigned longs. It's therefore
		      // required to take special care of the MSB prior to running it.
		      if (!divisor.unsigned) divisor = divisor.toUnsigned();
		      if (divisor.gt(this)) return UZERO;
		      if (divisor.gt(this.shru(1))) // 15 >>> 1 = 7 ; with divisor = 8 ; true
		        return UONE;
		      res = UZERO;
		    } // Repeat the following until the remainder is less than other:  find a
		    // floating-point that approximates remainder / other *from below*, add this
		    // into the result, and subtract it from the remainder.  It is critical that
		    // the approximate value is less than or equal to the real value so that the
		    // remainder never becomes negative.
		  
		  
		    rem = this;
		  
		    while (rem.gte(divisor)) {
		      // Approximate the result of division. This may be a little greater or
		      // smaller than the actual value.
		      approx = Math.max(1, Math.floor(rem.toNumber() / divisor.toNumber())); // We will tweak the approximate result by changing it in the 48-th digit or
		      // the smallest non-fractional digit, whichever is larger.
		  
		      var log2 = Math.ceil(Math.log(approx) / Math.LN2),
		          delta = log2 <= 48 ? 1 : pow_dbl(2, log2 - 48),
		          // Decrease the approximation until it is smaller than the remainder.  Note
		      // that if it is too large, the product overflows and is negative.
		      approxRes = fromNumber(approx),
		          approxRem = approxRes.mul(divisor);
		  
		      while (approxRem.isNegative() || approxRem.gt(rem)) {
		        approx -= delta;
		        approxRes = fromNumber(approx, this.unsigned);
		        approxRem = approxRes.mul(divisor);
		      } // We know the answer can't be zero... and actually, zero would cause
		      // infinite recursion since we would make no progress.
		  
		  
		      if (approxRes.isZero()) approxRes = ONE;
		      res = res.add(approxRes);
		      rem = rem.sub(approxRem);
		    }
		  
		    return res;
		  };
		  /**
		   * Returns this Long divided by the specified. This is an alias of {@link Long#divide}.
		   * @function
		   * @param {!Long|number|string} divisor Divisor
		   * @returns {!Long} Quotient
		   */
		  
		  
		  LongPrototype.div = LongPrototype.divide;
		  /**
		   * Returns this Long modulo the specified.
		   * @this {!Long}
		   * @param {!Long|number|string} divisor Divisor
		   * @returns {!Long} Remainder
		   */
		  
		  LongPrototype.modulo = function modulo(divisor) {
		    if (!isLong(divisor)) divisor = fromValue(divisor); // use wasm support if present
		  
		    if (wasm) {
		      var low = (this.unsigned ? wasm["rem_u"] : wasm["rem_s"])(this.low, this.high, divisor.low, divisor.high);
		      return fromBits(low, wasm["get_high"](), this.unsigned);
		    }
		  
		    return this.sub(this.div(divisor).mul(divisor));
		  };
		  /**
		   * Returns this Long modulo the specified. This is an alias of {@link Long#modulo}.
		   * @function
		   * @param {!Long|number|string} divisor Divisor
		   * @returns {!Long} Remainder
		   */
		  
		  
		  LongPrototype.mod = LongPrototype.modulo;
		  /**
		   * Returns this Long modulo the specified. This is an alias of {@link Long#modulo}.
		   * @function
		   * @param {!Long|number|string} divisor Divisor
		   * @returns {!Long} Remainder
		   */
		  
		  LongPrototype.rem = LongPrototype.modulo;
		  /**
		   * Returns the bitwise NOT of this Long.
		   * @this {!Long}
		   * @returns {!Long}
		   */
		  
		  LongPrototype.not = function not() {
		    return fromBits(~this.low, ~this.high, this.unsigned);
		  };
		  /**
		   * Returns count leading zeros of this Long.
		   * @this {!Long}
		   * @returns {!number}
		   */
		  
		  
		  LongPrototype.countLeadingZeros = function countLeadingZeros() {
		    return this.high ? Math.clz32(this.high) : Math.clz32(this.low) + 32;
		  };
		  /**
		   * Returns count leading zeros. This is an alias of {@link Long#countLeadingZeros}.
		   * @function
		   * @param {!Long}
		   * @returns {!number}
		   */
		  
		  
		  LongPrototype.clz = LongPrototype.countLeadingZeros;
		  /**
		   * Returns count trailing zeros of this Long.
		   * @this {!Long}
		   * @returns {!number}
		   */
		  
		  LongPrototype.countTrailingZeros = function countTrailingZeros() {
		    return this.low ? ctz32(this.low) : ctz32(this.high) + 32;
		  };
		  /**
		   * Returns count trailing zeros. This is an alias of {@link Long#countTrailingZeros}.
		   * @function
		   * @param {!Long}
		   * @returns {!number}
		   */
		  
		  
		  LongPrototype.ctz = LongPrototype.countTrailingZeros;
		  /**
		   * Returns the bitwise AND of this Long and the specified.
		   * @this {!Long}
		   * @param {!Long|number|string} other Other Long
		   * @returns {!Long}
		   */
		  
		  LongPrototype.and = function and(other) {
		    if (!isLong(other)) other = fromValue(other);
		    return fromBits(this.low & other.low, this.high & other.high, this.unsigned);
		  };
		  /**
		   * Returns the bitwise OR of this Long and the specified.
		   * @this {!Long}
		   * @param {!Long|number|string} other Other Long
		   * @returns {!Long}
		   */
		  
		  
		  LongPrototype.or = function or(other) {
		    if (!isLong(other)) other = fromValue(other);
		    return fromBits(this.low | other.low, this.high | other.high, this.unsigned);
		  };
		  /**
		   * Returns the bitwise XOR of this Long and the given one.
		   * @this {!Long}
		   * @param {!Long|number|string} other Other Long
		   * @returns {!Long}
		   */
		  
		  
		  LongPrototype.xor = function xor(other) {
		    if (!isLong(other)) other = fromValue(other);
		    return fromBits(this.low ^ other.low, this.high ^ other.high, this.unsigned);
		  };
		  /**
		   * Returns this Long with bits shifted to the left by the given amount.
		   * @this {!Long}
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Shifted Long
		   */
		  
		  
		  LongPrototype.shiftLeft = function shiftLeft(numBits) {
		    if (isLong(numBits)) numBits = numBits.toInt();
		    if ((numBits &= 63) === 0) return this;else if (numBits < 32) return fromBits(this.low << numBits, this.high << numBits | this.low >>> 32 - numBits, this.unsigned);else return fromBits(0, this.low << numBits - 32, this.unsigned);
		  };
		  /**
		   * Returns this Long with bits shifted to the left by the given amount. This is an alias of {@link Long#shiftLeft}.
		   * @function
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Shifted Long
		   */
		  
		  
		  LongPrototype.shl = LongPrototype.shiftLeft;
		  /**
		   * Returns this Long with bits arithmetically shifted to the right by the given amount.
		   * @this {!Long}
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Shifted Long
		   */
		  
		  LongPrototype.shiftRight = function shiftRight(numBits) {
		    if (isLong(numBits)) numBits = numBits.toInt();
		    if ((numBits &= 63) === 0) return this;else if (numBits < 32) return fromBits(this.low >>> numBits | this.high << 32 - numBits, this.high >> numBits, this.unsigned);else return fromBits(this.high >> numBits - 32, this.high >= 0 ? 0 : -1, this.unsigned);
		  };
		  /**
		   * Returns this Long with bits arithmetically shifted to the right by the given amount. This is an alias of {@link Long#shiftRight}.
		   * @function
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Shifted Long
		   */
		  
		  
		  LongPrototype.shr = LongPrototype.shiftRight;
		  /**
		   * Returns this Long with bits logically shifted to the right by the given amount.
		   * @this {!Long}
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Shifted Long
		   */
		  
		  LongPrototype.shiftRightUnsigned = function shiftRightUnsigned(numBits) {
		    if (isLong(numBits)) numBits = numBits.toInt();
		    if ((numBits &= 63) === 0) return this;
		    if (numBits < 32) return fromBits(this.low >>> numBits | this.high << 32 - numBits, this.high >>> numBits, this.unsigned);
		    if (numBits === 32) return fromBits(this.high, 0, this.unsigned);
		    return fromBits(this.high >>> numBits - 32, 0, this.unsigned);
		  };
		  /**
		   * Returns this Long with bits logically shifted to the right by the given amount. This is an alias of {@link Long#shiftRightUnsigned}.
		   * @function
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Shifted Long
		   */
		  
		  
		  LongPrototype.shru = LongPrototype.shiftRightUnsigned;
		  /**
		   * Returns this Long with bits logically shifted to the right by the given amount. This is an alias of {@link Long#shiftRightUnsigned}.
		   * @function
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Shifted Long
		   */
		  
		  LongPrototype.shr_u = LongPrototype.shiftRightUnsigned;
		  /**
		   * Returns this Long with bits rotated to the left by the given amount.
		   * @this {!Long}
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Rotated Long
		   */
		  
		  LongPrototype.rotateLeft = function rotateLeft(numBits) {
		    var b;
		    if (isLong(numBits)) numBits = numBits.toInt();
		    if ((numBits &= 63) === 0) return this;
		    if (numBits === 32) return fromBits(this.high, this.low, this.unsigned);
		  
		    if (numBits < 32) {
		      b = 32 - numBits;
		      return fromBits(this.low << numBits | this.high >>> b, this.high << numBits | this.low >>> b, this.unsigned);
		    }
		  
		    numBits -= 32;
		    b = 32 - numBits;
		    return fromBits(this.high << numBits | this.low >>> b, this.low << numBits | this.high >>> b, this.unsigned);
		  };
		  /**
		   * Returns this Long with bits rotated to the left by the given amount. This is an alias of {@link Long#rotateLeft}.
		   * @function
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Rotated Long
		   */
		  
		  
		  LongPrototype.rotl = LongPrototype.rotateLeft;
		  /**
		   * Returns this Long with bits rotated to the right by the given amount.
		   * @this {!Long}
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Rotated Long
		   */
		  
		  LongPrototype.rotateRight = function rotateRight(numBits) {
		    var b;
		    if (isLong(numBits)) numBits = numBits.toInt();
		    if ((numBits &= 63) === 0) return this;
		    if (numBits === 32) return fromBits(this.high, this.low, this.unsigned);
		  
		    if (numBits < 32) {
		      b = 32 - numBits;
		      return fromBits(this.high << b | this.low >>> numBits, this.low << b | this.high >>> numBits, this.unsigned);
		    }
		  
		    numBits -= 32;
		    b = 32 - numBits;
		    return fromBits(this.low << b | this.high >>> numBits, this.high << b | this.low >>> numBits, this.unsigned);
		  };
		  /**
		   * Returns this Long with bits rotated to the right by the given amount. This is an alias of {@link Long#rotateRight}.
		   * @function
		   * @param {number|!Long} numBits Number of bits
		   * @returns {!Long} Rotated Long
		   */
		  
		  
		  LongPrototype.rotr = LongPrototype.rotateRight;
		  /**
		   * Converts this Long to signed.
		   * @this {!Long}
		   * @returns {!Long} Signed long
		   */
		  
		  LongPrototype.toSigned = function toSigned() {
		    if (!this.unsigned) return this;
		    return fromBits(this.low, this.high, false);
		  };
		  /**
		   * Converts this Long to unsigned.
		   * @this {!Long}
		   * @returns {!Long} Unsigned long
		   */
		  
		  
		  LongPrototype.toUnsigned = function toUnsigned() {
		    if (this.unsigned) return this;
		    return fromBits(this.low, this.high, true);
		  };
		  /**
		   * Converts this Long to its byte representation.
		   * @param {boolean=} le Whether little or big endian, defaults to big endian
		   * @this {!Long}
		   * @returns {!Array.<number>} Byte representation
		   */
		  
		  
		  LongPrototype.toBytes = function toBytes(le) {
		    return le ? this.toBytesLE() : this.toBytesBE();
		  };
		  /**
		   * Converts this Long to its little endian byte representation.
		   * @this {!Long}
		   * @returns {!Array.<number>} Little endian byte representation
		   */
		  
		  
		  LongPrototype.toBytesLE = function toBytesLE() {
		    var hi = this.high,
		        lo = this.low;
		    return [lo & 0xff, lo >>> 8 & 0xff, lo >>> 16 & 0xff, lo >>> 24, hi & 0xff, hi >>> 8 & 0xff, hi >>> 16 & 0xff, hi >>> 24];
		  };
		  /**
		   * Converts this Long to its big endian byte representation.
		   * @this {!Long}
		   * @returns {!Array.<number>} Big endian byte representation
		   */
		  
		  
		  LongPrototype.toBytesBE = function toBytesBE() {
		    var hi = this.high,
		        lo = this.low;
		    return [hi >>> 24, hi >>> 16 & 0xff, hi >>> 8 & 0xff, hi & 0xff, lo >>> 24, lo >>> 16 & 0xff, lo >>> 8 & 0xff, lo & 0xff];
		  };
		  /**
		   * Creates a Long from its byte representation.
		   * @param {!Array.<number>} bytes Byte representation
		   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
		   * @param {boolean=} le Whether little or big endian, defaults to big endian
		   * @returns {Long} The corresponding Long value
		   */
		  
		  
		  Long.fromBytes = function fromBytes(bytes, unsigned, le) {
		    return le ? Long.fromBytesLE(bytes, unsigned) : Long.fromBytesBE(bytes, unsigned);
		  };
		  /**
		   * Creates a Long from its little endian byte representation.
		   * @param {!Array.<number>} bytes Little endian byte representation
		   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
		   * @returns {Long} The corresponding Long value
		   */
		  
		  
		  Long.fromBytesLE = function fromBytesLE(bytes, unsigned) {
		    return new Long(bytes[0] | bytes[1] << 8 | bytes[2] << 16 | bytes[3] << 24, bytes[4] | bytes[5] << 8 | bytes[6] << 16 | bytes[7] << 24, unsigned);
		  };
		  /**
		   * Creates a Long from its big endian byte representation.
		   * @param {!Array.<number>} bytes Big endian byte representation
		   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
		   * @returns {Long} The corresponding Long value
		   */
		  
		  
		  Long.fromBytesBE = function fromBytesBE(bytes, unsigned) {
		    return new Long(bytes[4] << 24 | bytes[5] << 16 | bytes[6] << 8 | bytes[7], bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3], unsigned);
		  };
		  
		  var _default = Long;
		  exports.default = _default;
		  return "default" in exports ? exports.default : exports;
		})({});
		module.exports = Long; 
	} (umd));
	return umd.exports;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var uuid;
var hasRequiredUuid;

function requireUuid () {
	if (hasRequiredUuid) return uuid;
	hasRequiredUuid = 1;

	const crypto = require$$0$a;
	const utils = requireUtils$c();

	/** @module types */

	/**
	 * Creates a new instance of Uuid based on a Buffer
	 * @class
	 * @classdesc Represents an immutable universally unique identifier (UUID). A UUID represents a 128-bit value.
	 * @param {Buffer} buffer The 16-length buffer.
	 * @constructor
	 */
	function Uuid(buffer) {
	  if (!buffer || buffer.length !== 16) {
	    throw new Error('You must provide a buffer containing 16 bytes');
	  }
	  this.buffer = buffer;
	}

	/**
	 * Parses a string representation of a Uuid
	 * @param {String} value
	 * @returns {Uuid}
	 */
	Uuid.fromString = function (value) {
	  //36 chars: 32 + 4 hyphens
	  if (typeof value !== 'string' || value.length !== 36) {
	    throw new Error('Invalid string representation of Uuid, it should be in the 00000000-0000-0000-0000-000000000000');
	  }
	  return new Uuid(utils.allocBufferFromString(value.replace(/-/g, ''), 'hex'));
	};

	/**
	 * Creates a new random (version 4) Uuid.
	 * @param {function} [callback] Optional callback to be invoked with the error as first parameter and the created Uuid as
	 * second parameter.
	 * @returns {Uuid}
	 */
	Uuid.random = function (callback) {
	  if (callback) {
	    getRandomBytes(function(err, buffer) {
	      if (err) {
	        return callback(err);
	      }
	      return callback(null, createUuidFromBuffer(buffer));
	    });
	  } else {
	    const buffer = getRandomBytes();
	    return createUuidFromBuffer(buffer);
	  }
	};

	/**
	 * Gets the bytes representation of a Uuid
	 * @returns {Buffer}
	 */
	Uuid.prototype.getBuffer = function () {
	  return this.buffer;
	};
	/**
	 * Compares this object to the specified object.
	 * The result is true if and only if the argument is not null, is a UUID object, and contains the same value, bit for bit, as this UUID.
	 * @param {Uuid} other The other value to test for equality.
	 */
	Uuid.prototype.equals = function (other) {
	  return other instanceof Uuid && this.buffer.equals(other.buffer);
	};

	/**
	 * Returns a string representation of the value of this Uuid instance.
	 * 32 hex separated by hyphens, in the form of 00000000-0000-0000-0000-000000000000.
	 * @returns {String}
	 */
	Uuid.prototype.toString = function () {
	  //32 hex representation of the Buffer
	  const hexValue = getHex(this);
	  return (
	    hexValue.substr(0, 8) + '-' +
	    hexValue.substr(8, 4) + '-' +
	    hexValue.substr(12, 4) + '-' +
	    hexValue.substr(16, 4) + '-' +
	    hexValue.substr(20, 12));
	};

	/**
	 * Provide the name of the constructor and the string representation
	 * @returns {string}
	 */
	Uuid.prototype.inspect = function () {
	  return this.constructor.name + ': ' + this.toString();
	};

	/**
	 * Returns the string representation.
	 * Method used by the native JSON.stringify() to serialize this instance.
	 */
	Uuid.prototype.toJSON = function () {
	  return this.toString();
	};


	/**
	 * Returns new Uuid
	 * @private
	 * @returns {Uuid}
	 */
	function createUuidFromBuffer (buffer) {
	  //clear the version
	  buffer[6] &= 0x0f;
	  //set the version 4
	  buffer[6] |= 0x40;
	  //clear the variant
	  buffer[8] &= 0x3f;
	  //set the IETF variant
	  buffer[8] |= 0x80;
	  return new Uuid(buffer);
	}

	/**
	 * @private
	 * @returns {String} 32 hex representation of the instance, without separators
	 */
	function getHex (uuid) {
	  return uuid.buffer.toString('hex');
	}

	/**
	 * Gets a crypto generated 16 bytes
	 * @private
	 * @returns {Buffer}
	 */
	function getRandomBytes (cb) {
	  return crypto.randomBytes(16, cb);
	}

	uuid = Uuid;
	return uuid;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var timeUuid;
var hasRequiredTimeUuid;

function requireTimeUuid () {
	if (hasRequiredTimeUuid) return timeUuid;
	hasRequiredTimeUuid = 1;
	const util = require$$0$6;
	const crypto = require$$0$a;
	const Long = requireUmd();

	const Uuid = requireUuid();
	const utils = requireUtils$c();

	/** @module types */
	/**
	 * Oct 15, 1582 in milliseconds since unix epoch
	 * @const
	 * @private
	 */
	const _unixToGregorian = 12219292800000;
	/**
	 * 10,000 ticks in a millisecond
	 * @const
	 * @private
	 */
	const _ticksInMs = 10000;

	const minNodeId = utils.allocBufferFromString('808080808080', 'hex');
	const minClockId = utils.allocBufferFromString('8080', 'hex');
	const maxNodeId = utils.allocBufferFromString('7f7f7f7f7f7f', 'hex');
	const maxClockId = utils.allocBufferFromString('7f7f', 'hex');

	/**
	 * Counter used to generate up to 10000 different timeuuid values with the same Date
	 * @private
	 * @type {number}
	 */
	let _ticks = 0;
	/**
	 * Counter used to generate ticks for the current time
	 * @private
	 * @type {number}
	 */
	let _ticksForCurrentTime = 0;
	/**
	 * Remember the last time when a ticks for the current time so that it can be reset
	 * @private
	 * @type {number}
	 */
	let _lastTimestamp = 0;

	/**
	 * Creates a new instance of Uuid based on the parameters provided according to rfc4122.
	 * If any of the arguments is not provided, it will be randomly generated, except for the date that will use the current
	 * date.
	 * <p>
	 *   Note that when nodeId and/or clockId portions are not provided, the constructor will generate them using
	 *   <code>crypto.randomBytes()</code>. As it's possible that <code>crypto.randomBytes()</code> might block, it's
	 *   recommended that you use the callback-based version of the static methods <code>fromDate()</code> or
	 *   <code>now()</code> in that case.
	 * </p>
	 * @class
	 * @classdesc Represents an immutable version 1 universally unique identifier (UUID). A UUID represents a 128-bit value.
	 * <p>Usage: <code>TimeUuid.now()</code></p>
	 * @extends module:types~Uuid
	 * @param {Date} [value] The datetime for the instance, if not provided, it will use the current Date.
	 * @param {Number} [ticks] A number from 0 to 10000 representing the 100-nanoseconds units for this instance to fill in the information not available in the Date,
	 * as Ecmascript Dates have only milliseconds precision.
	 * @param {String|Buffer} [nodeId] A 6-length Buffer or string of 6 ascii characters representing the node identifier, ie: 'host01'.
	 * @param {String|Buffer} [clockId] A 2-length Buffer or string of 6 ascii characters representing the clock identifier.
	 * @constructor
	 */
	function TimeUuid(value, ticks, nodeId, clockId) {
	  let buffer;
	  if (value instanceof Buffer) {
	    if (value.length !== 16) {
	      throw new Error('Buffer for v1 uuid not valid');
	    }
	    buffer = value;
	  }
	  else {
	    buffer = generateBuffer(value, ticks, nodeId, clockId);
	  }
	  Uuid.call(this, buffer);
	}

	util.inherits(TimeUuid, Uuid);

	/**
	 * Generates a TimeUuid instance based on the Date provided using random node and clock values.
	 * @param {Date} date Date to generate the v1 uuid.
	 * @param {Number} [ticks] A number from 0 to 10000 representing the 100-nanoseconds units for this instance to fill in the information not available in the Date,
	 * as Ecmascript Dates have only milliseconds precision.
	 * @param {String|Buffer} [nodeId] A 6-length Buffer or string of 6 ascii characters representing the node identifier, ie: 'host01'.
	 * If not provided, a random nodeId will be generated.
	 * @param {String|Buffer} [clockId] A 2-length Buffer or string of 6 ascii characters representing the clock identifier.
	 * If not provided a random clockId will be generated.
	 * @param {Function} [callback] An optional callback to be invoked with the error as first parameter and the created
	 * <code>TimeUuid</code> as second parameter. When a callback is provided, the random portions of the
	 * <code>TimeUuid</code> instance are created asynchronously.
	 * <p>
	 *   When nodeId and/or clockId portions are not provided, this method will generate them using
	 *   <code>crypto.randomBytes()</code>. As it's possible that <code>crypto.randomBytes()</code> might block, it's
	 *   recommended that you use the callback-based version of this method in that case.
	 * </p>
	 * @example <caption>Generate a TimeUuid from a ECMAScript Date</caption>
	 * const timeuuid = TimeUuid.fromDate(new Date());
	 * @example <caption>Generate a TimeUuid from a Date with ticks portion</caption>
	 * const timeuuid = TimeUuid.fromDate(new Date(), 1203);
	 * @example <caption>Generate a TimeUuid from a Date without any random portion</caption>
	 * const timeuuid = TimeUuid.fromDate(new Date(), 1203, 'host01', '02');
	 * @example <caption>Generate a TimeUuid from a Date with random node and clock identifiers</caption>
	 * TimeUuid.fromDate(new Date(), 1203, function (err, timeuuid) {
	 *   // do something with the generated timeuuid
	 * });
	 */
	TimeUuid.fromDate = function (date, ticks, nodeId, clockId, callback) {
	  if (typeof ticks === 'function') {
	    callback = ticks;
	    ticks = nodeId = clockId = null;
	  } else if (typeof nodeId === 'function') {
	    callback = nodeId;
	    nodeId = clockId = null;
	  } else if (typeof clockId === 'function') {
	    callback = clockId;
	    clockId = null;
	  }

	  if (!callback) {
	    return new TimeUuid(date, ticks, nodeId, clockId);
	  }

	  utils.parallel([
	    next => getOrGenerateRandom(nodeId, 6, (err, buffer) => next(err, nodeId = buffer)),
	    next => getOrGenerateRandom(clockId, 2, (err, buffer) => next(err, clockId = buffer)),
	  ], (err) => {
	    if (err) {
	      return callback(err);
	    }

	    let timeUuid;
	    try {
	      timeUuid = new TimeUuid(date, ticks, nodeId, clockId);
	    }
	    catch (e) {
	      return callback(e);
	    }

	    callback(null, timeUuid);
	  });
	};

	/**
	 * Parses a string representation of a TimeUuid
	 * @param {String} value
	 * @returns {TimeUuid}
	 */
	TimeUuid.fromString = function (value) {
	  return new TimeUuid(Uuid.fromString(value).getBuffer());
	};

	/**
	 * Returns the smaller possible type 1 uuid with the provided Date.
	 */
	TimeUuid.min = function (date, ticks) {
	  return new TimeUuid(date, ticks, minNodeId, minClockId);
	};

	/**
	 * Returns the biggest possible type 1 uuid with the provided Date.
	 */
	TimeUuid.max = function (date, ticks) {
	  return new TimeUuid(date, ticks, maxNodeId, maxClockId);
	};

	/**
	 * Generates a TimeUuid instance based on the current date using random node and clock values.
	 * @param {String|Buffer} [nodeId] A 6-length Buffer or string of 6 ascii characters representing the node identifier, ie: 'host01'.
	 * If not provided, a random nodeId will be generated.
	 * @param {String|Buffer} [clockId] A 2-length Buffer or string of 6 ascii characters representing the clock identifier.
	 * If not provided a random clockId will be generated.
	 * @param {Function} [callback] An optional callback to be invoked with the error as first parameter and the created
	 * <code>TimeUuid</code> as second parameter. When a callback is provided, the random portions of the
	 * <code>TimeUuid</code> instance are created asynchronously.
	 * <p>
	 *   When nodeId and/or clockId portions are not provided, this method will generate them using
	 *   <code>crypto.randomBytes()</code>. As it's possible that <code>crypto.randomBytes()</code> might block, it's
	 *   recommended that you use the callback-based version of this method in that case.
	 * </p>
	 * @example <caption>Generate a TimeUuid from a Date without any random portion</caption>
	 * const timeuuid = TimeUuid.now('host01', '02');
	 * @example <caption>Generate a TimeUuid with random node and clock identifiers</caption>
	 * TimeUuid.now(function (err, timeuuid) {
	 *   // do something with the generated timeuuid
	 * });
	 * @example <caption>Generate a TimeUuid based on the current date (might block)</caption>
	 * const timeuuid = TimeUuid.now();
	 */
	TimeUuid.now = function (nodeId, clockId, callback) {
	  return TimeUuid.fromDate(null, null, nodeId, clockId, callback);
	};


	/**
	 * Gets the Date and 100-nanoseconds units representation of this instance.
	 * @returns {{date: Date, ticks: Number}}
	 */
	TimeUuid.prototype.getDatePrecision = function () {
	  const timeLow = this.buffer.readUInt32BE(0);

	  let timeHigh = 0;
	  timeHigh |= ( this.buffer[4] & 0xff ) << 8;
	  timeHigh |= this.buffer[5] & 0xff;
	  timeHigh |= ( this.buffer[6] & 0x0f ) << 24;
	  timeHigh |= ( this.buffer[7] & 0xff ) << 16;

	  const val = Long.fromBits(timeLow, timeHigh);
	  const ticksInMsLong = Long.fromNumber(_ticksInMs);
	  const ticks = val.modulo(ticksInMsLong);
	  const time = val
	    .div(ticksInMsLong)
	    .subtract(Long.fromNumber(_unixToGregorian));
	  return { date: new Date(time.toNumber()), ticks: ticks.toNumber()};
	};

	/**
	 * Gets the Date representation of this instance.
	 * @returns {Date}
	 */
	TimeUuid.prototype.getDate = function () {
	  return this.getDatePrecision().date;
	};

	/**
	 * Returns the node id this instance
	 * @returns {Buffer}
	 */
	TimeUuid.prototype.getNodeId = function () {
	  return this.buffer.slice(10);
	};

	/**
	 * Returns the clock id this instance, with the variant applied (first 2 msb being 1 and 0).
	 * @returns {Buffer}
	 */
	TimeUuid.prototype.getClockId = function () {
	  return this.buffer.slice(8, 10);
	};

	/**
	 * Returns the node id this instance as an ascii string
	 * @returns {String}
	 */
	TimeUuid.prototype.getNodeIdString = function () {
	  return this.buffer.slice(10).toString('ascii');
	};

	function writeTime(buffer, time, ticks) {
	  //value time expressed in ticks precision
	  const val = Long
	    .fromNumber(time + _unixToGregorian)
	    .multiply(Long.fromNumber(10000))
	    .add(Long.fromNumber(ticks));
	  const timeHigh = val.getHighBitsUnsigned();
	  buffer.writeUInt32BE(val.getLowBitsUnsigned(), 0);
	  buffer.writeUInt16BE(timeHigh & 0xffff, 4);
	  buffer.writeUInt16BE(timeHigh >>> 16 & 0xffff, 6);
	}

	/**
	 * Returns a buffer of length 2 representing the clock identifier
	 * @param {String|Buffer} clockId
	 * @returns {Buffer}
	 * @private
	 */
	function getClockId(clockId) {
	  let buffer = clockId;
	  if (typeof clockId === 'string') {
	    buffer = utils.allocBufferFromString(clockId, 'ascii');
	  }
	  if (!(buffer instanceof Buffer)) {
	    //Generate
	    buffer = getRandomBytes(2);
	  }
	  else if (buffer.length !== 2) {
	    throw new Error('Clock identifier must have 2 bytes');
	  }
	  return buffer;
	}

	/**
	 * Returns a buffer of length 6 representing the clock identifier
	 * @param {String|Buffer} nodeId
	 * @returns {Buffer}
	 * @private
	 */
	function getNodeId(nodeId) {
	  let buffer = nodeId;
	  if (typeof nodeId === 'string') {
	    buffer = utils.allocBufferFromString(nodeId, 'ascii');
	  }
	  if (!(buffer instanceof Buffer)) {
	    //Generate
	    buffer = getRandomBytes(6);
	  }
	  else if (buffer.length !== 6) {
	    throw new Error('Node identifier must have 6 bytes');
	  }
	  return buffer;
	}

	/**
	 * Returns the ticks portion of a timestamp.  If the ticks are not provided an internal counter is used that gets reset at 10000.
	 * @private
	 * @param {Number} [ticks] 
	 * @returns {Number} 
	 */
	function getTicks(ticks) {
	  if (typeof ticks !== 'number'|| ticks >= _ticksInMs) {
	    _ticks++;
	    if (_ticks >= _ticksInMs) {
	      _ticks = 0;
	    }
	    ticks = _ticks;
	  }
	  return ticks;
	}

	/**
	 * Returns an object with the time representation of the date expressed in milliseconds since unix epoch 
	 * and a ticks property for the 100-nanoseconds precision.
	 * @private
	 * @returns {{time: Number, ticks: Number}} 
	 */
	function getTimeWithTicks(date, ticks) {
	  if (!(date instanceof Date) || isNaN(date.getTime())) {
	    // time with ticks for the current time
	    date = new Date();
	    const time = date.getTime();
	    _ticksForCurrentTime++;
	    if(_ticksForCurrentTime > _ticksInMs || time > _lastTimestamp) {
	      _ticksForCurrentTime = 0;
	      _lastTimestamp = time;
	    }
	    ticks = _ticksForCurrentTime;
	  }
	  return {
	    time: date.getTime(),
	    ticks: getTicks(ticks)
	  };
	}

	function getRandomBytes(length) {
	  return crypto.randomBytes(length);
	}

	function getOrGenerateRandom(id, length, callback) {
	  if (id) {
	    return callback(null, id);
	  }
	  crypto.randomBytes(length, callback);
	}

	/**
	 * Generates a 16-length Buffer instance
	 * @private
	 * @param {Date} date
	 * @param {Number} ticks
	 * @param {String|Buffer} nodeId
	 * @param {String|Buffer} clockId
	 * @returns {Buffer}
	 */
	function generateBuffer(date, ticks, nodeId, clockId) {
	  const timeWithTicks = getTimeWithTicks(date, ticks);
	  nodeId = getNodeId(nodeId);
	  clockId = getClockId(clockId);
	  const buffer = utils.allocBufferUnsafe(16);
	  //Positions 0-7 Timestamp
	  writeTime(buffer, timeWithTicks.time, timeWithTicks.ticks);
	  //Position 8-9 Clock
	  clockId.copy(buffer, 8, 0);
	  //Positions 10-15 Node
	  nodeId.copy(buffer, 10, 0);
	  //Version Byte: Time based
	  //0001xxxx
	  //turn off first 4 bits
	  buffer[6] = buffer[6] & 0x0f;
	  //turn on fifth bit
	  buffer[6] = buffer[6] | 0x10;

	  //IETF Variant Byte: 1.0.x
	  //10xxxxxx
	  //turn off first 2 bits
	  buffer[8] = buffer[8] & 0x3f;
	  //turn on first bit
	  buffer[8] = buffer[8] | 0x80;
	  return buffer;
	}

	timeUuid = TimeUuid;
	return timeUuid;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var versionNumber;
var hasRequiredVersionNumber;

function requireVersionNumber () {
	if (hasRequiredVersionNumber) return versionNumber;
	hasRequiredVersionNumber = 1;

	const _versionPattern = /(\d+)\.(\d+)(?:\.(\d+))?(?:\.(\d+)?)?(?:[-~]([\w+]*(?:-\w[.\w]*)*))?(?:\+([.\w]+))?/;

	/**
	 * Represents a version number in the form of X.Y.Z with optional pre-release and build metadata.
	 *
	 * Version numbers compare the usual way, the major version number (X) is compared first, then
	 * the minor one (Y) and then the patch level one (Z).  If pre-release or other build metadata
	 * is present for a version, that version is considered less than an otherwise equivalent version
	 * that doesn't have these labels, otherwise they are considered equal.
	 *
	 * As of initial implementation versions are only compared against those with at most patch versions
	 * more refined comparisons are not needed.
	 *
	 * @property {Number} major The major version, X of X.Y.Z.
	 * @property {Number} minor The minor version, Y of X.Y.Z.
	 * @property {Number} patch The patch version, Z of X.Y.Z.
	 * @property {Number} dsePatch The dsePatch version, A of X.Y.Z.A or undefined if not present.
	 * @property {String[]} preReleases Prerelease indicators if present, i.e. SNAPSHOT of X.Y.Z-SNAPSHOT.
	 * @property {String} build Build string if present, i.e. build1 of X.Y.Z+build1.
	 *
	 * @ignore
	 */
	class VersionNumber {
	  constructor(major, minor, patch, dsePatch, preReleases, build) {
	    this.major = major;
	    this.minor = minor;
	    this.patch = patch;
	    this.dsePatch = dsePatch;
	    this.preReleases = preReleases;
	    this.build = build;
	  }

	  /**
	   * @return {String} String representation of this version.
	   */
	  toString() {
	    let str = this.major + '.' + this.minor;
	    if (this.patch !== undefined) {
	      str += '.' + this.patch;
	    }
	    if (this.dsePatch !== undefined) {
	      str += '.' + this.dsePatch;
	    }
	    if (this.preReleases !== undefined) {
	      this.preReleases.forEach((preRelease) => {
	        str += '-' + preRelease;
	      });
	    }
	    if (this.build) {
	      str += '+' + this.build;
	    }
	    return str;
	  }

	  /**
	   * Compares this version with the provided version. 
	   * @param {VersionNumber} other 
	   * @return {Number} -1 if less than other, 0 if equal, 1 if greater than.
	   */
	  compare(other) {
	    if (this.major < other.major) {
	      return -1;
	    } else if (this.major > other.major) {
	      return 1;
	    } else if (this.minor < other.minor) {
	      return -1;
	    } else if (this.minor > other.minor) {
	      return 1;
	    }

	    // sanitize patch by setting to 0 if undefined.
	    const thisPatch = this.patch || 0;
	    const otherPatch = other.patch || 0;
	    if (thisPatch < otherPatch) {
	      return -1;
	    } else if (thisPatch > otherPatch) {
	      return 1;
	    }

	    // if dsePatch is set in one case, but not other, consider the one where it is set as greater.
	    if (this.dsePatch === undefined) {
	      if (other.dsePatch !== undefined) {
	        return -1;
	      }
	    } else if (other.dsePatch === undefined) {
	      return 1;
	    } else {
	      if (this.dsePatch < other.dsePatch) {
	        return -1;
	      } else if (this.dsePatch > other.dsePatch) {
	        return 1;
	      }
	    }

	    // If prereleases are present, consider less than those that don't have any.
	    if (this.preReleases === undefined) {
	      if (other.preReleases !== undefined) {
	        return 1;
	      }
	    } else if (other.preReleases === undefined) {
	      return -1;
	    }
	   
	    // Don't consider build.
	    return 0;
	  }

	  static parse(version) {
	    if (!version) {
	      return null;
	    }

	    const match = version.match(_versionPattern);
	    if (match) {
	      const major = parseInt(match[1], 10);
	      const minor = parseInt(match[2], 10);
	      const patch = match[3] ? parseInt(match[3], 10) : undefined;
	      const dsePatch = match[4] ? parseInt(match[4], 10) : undefined;
	      const preReleases = match[5] ? match[5].split('-') : undefined;
	      const build = match[6];
	      return new VersionNumber(major, minor, patch, dsePatch, preReleases, build);
	    }
	    throw new TypeError('Could not extract version from \'' + version + '\'');
	  }
	}

	versionNumber = VersionNumber;
	return versionNumber;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var protocolVersion_1;
var hasRequiredProtocolVersion;

function requireProtocolVersion () {
	if (hasRequiredProtocolVersion) return protocolVersion_1;
	hasRequiredProtocolVersion = 1;

	const utils = requireUtils$c();
	const VersionNumber = requireVersionNumber();
	const v200 = VersionNumber.parse('2.0.0');
	const v210 = VersionNumber.parse('2.1.0');
	const v220 = VersionNumber.parse('2.2.0');
	const v300 = VersionNumber.parse('3.0.0');
	const v510 = VersionNumber.parse('5.1.0');
	const v600 = VersionNumber.parse('6.0.0');

	/**
	 * Contains information for the different protocol versions supported by the driver.
	 * @type {Object}
	 * @property {Number} v1 Cassandra protocol v1, supported in Apache Cassandra 1.2-->2.2.
	 * @property {Number} v2 Cassandra protocol v2, supported in Apache Cassandra 2.0-->2.2.
	 * @property {Number} v3 Cassandra protocol v3, supported in Apache Cassandra 2.1-->3.x.
	 * @property {Number} v4 Cassandra protocol v4, supported in Apache Cassandra 2.2-->3.x.
	 * @property {Number} v5 Cassandra protocol v5, in beta from Apache Cassandra 3.x+. Currently not supported by the
	 * driver.
	 * @property {Number} dseV1 DataStax Enterprise protocol v1, DSE 5.1+
	 * @property {Number} dseV2 DataStax Enterprise protocol v2, DSE 6.0+
	 * @property {Number} maxSupported Returns the higher protocol version that is supported by this driver.
	 * @property {Number} minSupported Returns the lower protocol version that is supported by this driver.
	 * @property {Function} isSupported A function that returns a boolean determining whether a given protocol version
	 * is supported.
	 * @alias module:types~protocolVersion
	 */
	const protocolVersion = {
	  // Strict equality operators to compare versions are allowed, other comparison operators are discouraged. Instead,
	  // use a function that checks if a functionality is present on a certain version, for maintainability purposes.
	  v1: 0x01,
	  v2: 0x02,
	  v3: 0x03,
	  v4: 0x04,
	  v5: 0x05,
	  v6: 0x06,
	  dseV1: 0x41,
	  dseV2: 0x42,
	  maxSupported: 0x42,
	  minSupported: 0x01,

	  /**
	   * Determines whether the protocol version is a DSE-specific protocol version.
	   * @param {Number} version
	   * @returns {Boolean}
	   * @ignore
	   */
	  isDse: function(version) {
	    return ((version >= this.dseV1 && version <= this.dseV2));
	  },
	  /**
	   * Returns true if the protocol version represents a version of Cassandra
	   * supported by this driver, false otherwise
	   * @param {Number} version
	   * @returns {Boolean}
	   * @ignore
	   */
	  isSupportedCassandra: function(version) {
	    return (version <= 0x04 && version >= 0x01);
	  },
	  /**
	   * Determines whether the protocol version is supported by this driver.
	   * @param {Number} version
	   * @returns {Boolean}
	   * @ignore
	   */
	  isSupported: function (version) {
	    return (this.isDse(version) || this.isSupportedCassandra(version));
	  },

	  /**
	   * Determines whether the protocol includes flags for PREPARE messages.
	   * @param {Number} version
	   * @returns {Boolean}
	   * @ignore
	   */
	  supportsPrepareFlags: function (version) {
	    return (version === this.dseV2);
	  },
	  /**
	   * Determines whether the protocol supports sending the keyspace as part of PREPARE, QUERY, EXECUTE, and BATCH.
	   * @param {Number} version
	   * @returns {Boolean}
	   * @ignore
	   */
	  supportsKeyspaceInRequest: function (version) {
	    return (version === this.dseV2);
	  },
	  /**
	   * Determines whether the protocol supports result_metadata_id on `prepared` response and
	   * and `execute` request.
	   * @param {Number} version
	   * @returns {Boolean}
	   * @ignore
	   */
	  supportsResultMetadataId: function (version) {
	    return (version === this.dseV2);
	  },
	  /**
	   * Determines whether the protocol supports partition key indexes in the `prepared` RESULT responses.
	   * @param {Number} version
	   * @returns {Boolean}
	   * @ignore
	   */
	  supportsPreparedPartitionKey: function (version) {
	    return (version >= this.v4);
	  },
	  /**
	   * Determines whether the protocol supports up to 4 strings (ie: change_type, target, keyspace and table) in the
	   * schema change responses.
	   * @param version
	   * @return {boolean}
	   * @ignore
	   */
	  supportsSchemaChangeFullMetadata: function (version) {
	    return (version >= this.v3);
	  },
	  /**
	   * Determines whether the protocol supports continuous paging.
	   * @param version
	   * @return {boolean}
	   * @ignore
	   */
	  supportsContinuousPaging: function (version) {
	    return (this.isDse(version));
	  },
	  /**
	   * Determines whether the protocol supports paging state and serial consistency parameters in QUERY and EXECUTE
	   * requests.
	   * @param version
	   * @return {boolean}
	   * @ignore
	   */
	  supportsPaging: function (version) {
	    return (version >= this.v2);
	  },
	  /**
	   * Determines whether the protocol supports timestamps parameters in BATCH, QUERY and EXECUTE requests.
	   * @param {Number} version
	   * @return {boolean}
	   * @ignore
	   */
	  supportsTimestamp: function (version) {
	    return (version >= this.v3);
	  },
	  /**
	   * Determines whether the protocol supports named parameters in QUERY and EXECUTE requests.
	   * @param {Number} version
	   * @return {boolean}
	   * @ignore
	   */
	  supportsNamedParameters: function (version) {
	    return (version >= this.v3);
	  },
	  /**
	   * Determines whether the protocol supports unset parameters.
	   * @param {Number} version
	   * @return {boolean}
	   * @ignore
	   */
	  supportsUnset: function (version) {
	    return (version >= this.v4);
	  },
	  /**
	   * Determines whether the protocol provides a reason map for read and write failure errors.
	   * @param version
	   * @return {boolean}
	   * @ignore
	   */
	  supportsFailureReasonMap: function (version) {
	    return (version >= this.v5);
	  },
	  /**
	   * Determines whether the protocol supports timestamp and serial consistency parameters in BATCH requests.
	   * @param {Number} version
	   * @return {boolean}
	   * @ignore
	   */
	  uses2BytesStreamIds: function (version) {
	    return (version >= this.v3);
	  },
	  /**
	   * Determines whether the collection length is encoded using 32 bits.
	   * @param {Number} version
	   * @return {boolean}
	   * @ignore
	   */
	  uses4BytesCollectionLength: function (version) {
	    return (version >= this.v3);
	  },
	  /**
	   * Determines whether the QUERY, EXECUTE and BATCH flags are encoded using 32 bits.
	   * @param {Number} version
	   * @return {boolean}
	   * @ignore
	   */
	  uses4BytesQueryFlags: function (version) {
	    return (this.isDse(version));
	  },
	  /**
	   * Startup responses using protocol v4+ can be a SERVER_ERROR wrapping a ProtocolException, this method returns true
	   * when is possible to receive such error.
	   * @param {Number} version
	   * @return {boolean}
	   * @ignore
	   */
	  canStartupResponseErrorBeWrapped: function (version) {
	    return (version >= this.v4);
	  },
	  /**
	   * Gets the first version number that is supported, lower than the one provided.
	   * Returns zero when there isn't a lower supported version.
	   * @param {Number} version
	   * @return {Number}
	   * @ignore
	   */
	  getLowerSupported: function (version) {
	    if (version >= this.v5) {
	      return this.v4;
	    }
	    if (version <= this.v1) {
	      return 0;
	    }
	    return version - 1;
	  },

	  /**
	   * Computes the highest supported protocol version collectively by the given hosts.
	   *
	   * Considers the cassandra_version of the input hosts to determine what protocol versions
	   * are supported and uses the highest common protocol version among them.
	   *
	   * If hosts >= C* 3.0 are detected, any hosts older than C* 2.1 will not be considered
	   * as those cannot be connected to.  In general this will not be a problem as C* does
	   * not support clusters with nodes that have versions that are more than one major
	   * version away from each other.
	   * @param {Connection} connection Connection hosts were discovered from.
	   * @param {Array.<Host>} hosts The hosts to determine highest protocol version from.
	   * @return {Number} Highest supported protocol version among hosts.
	   */
	  getHighestCommon: function(connection, hosts) {
	    const log = connection.log ? connection.log.bind(connection) : utils.noop;
	    let maxVersion = connection.protocolVersion;
	    // whether or not protocol v3 is required (nodes detected that don't support < 3).
	    let v3Requirement = false;
	    // track the common protocol version >= v3 in case we encounter older versions.
	    let maxVersionWith3OrMore = maxVersion;
	    hosts.forEach(h => {
	      let dseVersion = null;
	      if (h.dseVersion) {
	        // As of DSE 5.1, DSE has it's own specific protocol versions.  If we detect 5.1+
	        // consider those protocol versions.
	        dseVersion = VersionNumber.parse(h.dseVersion);
	        log('verbose', `Encountered host ${h.address} with dse version ${dseVersion}`);
	        if (dseVersion.compare(v510) >= 0) {
	          v3Requirement = true;
	          if (dseVersion.compare(v600) >= 0) {
	            maxVersion = Math.min(this.dseV2, maxVersion);
	          } else {
	            maxVersion = Math.min(this.dseV1, maxVersion);
	          }
	          maxVersionWith3OrMore = maxVersion;
	          return;
	        }
	        // If DSE < 5.1, we fall back on the cassandra protocol logic.
	      }

	      if (!h.cassandraVersion || h.cassandraVersion.length === 0) {
	        log('warning', 'Encountered host ' + h.address + ' with no cassandra version,' +
	          ' skipping as part of protocol version evaluation');
	        return;
	      }

	      try {
	        const cassandraVersion = VersionNumber.parse(h.cassandraVersion);
	        if (!dseVersion) {
	          log('verbose', 'Encountered host ' + h.address + ' with cassandra version ' + cassandraVersion);
	        }
	        if (cassandraVersion.compare(v300) >= 0) {
	          // Anything 3.0.0+ has a max protocol version of V4 and requires at least V3.
	          v3Requirement = true;
	          maxVersion = Math.min(this.v4, maxVersion);
	          maxVersionWith3OrMore = maxVersion;
	        } else if (cassandraVersion.compare(v220) >= 0) {
	          // Cassandra 2.2.x has a max protocol version of V4.
	          maxVersion = Math.min(this.v4, maxVersion);
	          maxVersionWith3OrMore = maxVersion;
	        } else if (cassandraVersion.compare(v210) >= 0) {
	          // Cassandra 2.1.x has a max protocol version of V3.
	          maxVersion = Math.min(this.v3, maxVersion);
	          maxVersionWith3OrMore = maxVersion;
	        } else if (cassandraVersion.compare(v200) >= 0) {
	          // Cassandra 2.0.x has a max protocol version of V2.
	          maxVersion = Math.min(this.v2, maxVersion);
	        } else {
	          // Anything else is < 2.x and requires protocol version V1.
	          maxVersion = this.v1;
	        }
	      } catch (e) {
	        log('warning', 'Encountered host ' + h.address + ' with unparseable cassandra version ' + h.cassandraVersion
	          + ' skipping as part of protocol version evaluation');
	      }
	    });

	    if (v3Requirement && maxVersion < this.v3) {
	      const addendum = '. This should not be possible as nodes within a cluster can\'t be separated by more than one major version';
	      if (maxVersionWith3OrMore < this.v3) {
	        log('error', 'Detected hosts that require at least protocol version 0x3, but currently connected to '
	         + connection.address + ':' + connection.port + ' using protocol version 0x' + maxVersionWith3OrMore
	         + '. Will not be able to connect to these hosts' + addendum);
	      } else {
	        log('error', 'Detected hosts with maximum protocol version of 0x' + maxVersion.toString(16)
	          + ' but there are some hosts that require at least version 0x3. Will not be able to connect to these older hosts'
	          + addendum);
	      }
	      maxVersion = maxVersionWith3OrMore;
	    }

	    log('verbose', 'Resolved protocol version 0x' + maxVersion.toString(16) + ' as the highest common protocol version among hosts');
	    return maxVersion;
	  },

	  /**
	   * Determines if the protocol is a BETA version of the protocol.
	   * @param {Number} version
	   * @return {Number}
	   */
	  isBeta: function (version) {
	    return version === this.v5;
	  }
	};

	protocolVersion_1 = protocolVersion;
	return protocolVersion_1;
}var integer;
var hasRequiredInteger;

function requireInteger () {
	if (hasRequiredInteger) return integer;
	hasRequiredInteger = 1;
	// Copyright 2009 The Closure Library Authors. All Rights Reserved.
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS-IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.

	/** @module types */

	var utils = requireUtils$c();

	/**
	 * Constructs a two's-complement integer an array containing bits of the
	 * integer in 32-bit (signed) pieces, given in little-endian order (i.e.,
	 * lowest-order bits in the first piece), and the sign of -1 or 0.
	 *
	 * See the from* functions below for other convenient ways of constructing
	 * Integers.
	 *
	 * The internal representation of an integer is an array of 32-bit signed
	 * pieces, along with a sign (0 or -1) that indicates the contents of all the
	 * other 32-bit pieces out to infinity.  We use 32-bit pieces because these are
	 * the size of integers on which Javascript performs bit-operations.  For
	 * operations like addition and multiplication, we split each number into 16-bit
	 * pieces, which can easily be multiplied within Javascript's floating-point
	 * representation without overflow or change in sign.
	 *
	 * @constructor
	 * @param {Array.<number>} bits Array containing the bits of the number.
	 * @param {number} sign The sign of the number: -1 for negative and 0 positive.
	 * @final
	 */
	function Integer (bits, sign) {
	  /**
	   * @type {!Array.<number>}
	   * @private
	   */
	  this.bits_ = [];

	  /**
	   * @type {number}
	   * @private
	   */
	  this.sign_ = sign;

	  // Copy the 32-bit signed integer values passed in.  We prune out those at the
	  // top that equal the sign since they are redundant.
	  var top = true;
	  for (var i = bits.length - 1; i >= 0; i--) {
	    var val = bits[i] | 0;
	    if (!top || val != sign) {
	      this.bits_[i] = val;
	      top = false;
	    }
	  }
	}


	// NOTE: Common constant values ZERO, ONE, NEG_ONE, etc. are defined below the
	// from* methods on which they depend.


	/**
	 * A cache of the Integer representations of small integer values.
	 * @type {!Object}
	 * @private
	 */
	Integer.IntCache_ = {};


	/**
	 * Returns an Integer representing the given (32-bit) integer value.
	 * @param {number} value A 32-bit integer value.
	 * @return {!Integer} The corresponding Integer value.
	 */
	Integer.fromInt = function(value) {
	  if (-128 <= value && value < 128) {
	    var cachedObj = Integer.IntCache_[value];
	    if (cachedObj) {
	      return cachedObj;
	    }
	  }

	  var obj = new Integer([value | 0], value < 0 ? -1 : 0);
	  if (-128 <= value && value < 128) {
	    Integer.IntCache_[value] = obj;
	  }
	  return obj;
	};


	/**
	 * Returns an Integer representing the given value, provided that it is a finite
	 * number.  Otherwise, zero is returned.
	 * @param {number} value The value in question.
	 * @return {!Integer} The corresponding Integer value.
	 */
	Integer.fromNumber = function(value) {
	  if (isNaN(value) || !isFinite(value)) {
	    return Integer.ZERO;
	  } else if (value < 0) {
	    return Integer.fromNumber(-value).negate();
	  } else {
	    var bits = [];
	    var pow = 1;
	    for (var i = 0; value >= pow; i++) {
	      bits[i] = (value / pow) | 0;
	      pow *= Integer.TWO_PWR_32_DBL_;
	    }
	    return new Integer(bits, 0);
	  }
	};


	/**
	 * Returns a Integer representing the value that comes by concatenating the
	 * given entries, each is assumed to be 32 signed bits, given in little-endian
	 * order (lowest order bits in the lowest index), and sign-extending the highest
	 * order 32-bit value.
	 * @param {Array.<number>} bits The bits of the number, in 32-bit signed pieces,
	 *     in little-endian order.
	 * @return {!Integer} The corresponding Integer value.
	 */
	Integer.fromBits = function(bits) {
	  var high = bits[bits.length - 1];
	  //noinspection JSBitwiseOperatorUsage
	  return new Integer(bits, high & (1 << 31) ? -1 : 0);
	};


	/**
	 * Returns an Integer representation of the given string, written using the
	 * given radix.
	 * @param {string} str The textual representation of the Integer.
	 * @param {number=} opt_radix The radix in which the text is written.
	 * @return {!Integer} The corresponding Integer value.
	 */
	Integer.fromString = function(str, opt_radix) {
	  if (str.length == 0) {
	    throw TypeError('number format error: empty string');
	  }

	  var radix = opt_radix || 10;
	  if (radix < 2 || 36 < radix) {
	    throw Error('radix out of range: ' + radix);
	  }

	  if (str.charAt(0) == '-') {
	    return Integer.fromString(str.substring(1), radix).negate();
	  } else if (str.indexOf('-') >= 0) {
	    throw TypeError('number format error: interior "-" character');
	  }

	  // Do several (8) digits each time through the loop, so as to
	  // minimize the calls to the very expensive emulated div.
	  var radixToPower = Integer.fromNumber(Math.pow(radix, 8));

	  var result = Integer.ZERO;
	  for (var i = 0; i < str.length; i += 8) {
	    var size = Math.min(8, str.length - i);
	    var value = parseInt(str.substring(i, i + size), radix);
	    if (size < 8) {
	      var power = Integer.fromNumber(Math.pow(radix, size));
	      result = result.multiply(power).add(Integer.fromNumber(value));
	    } else {
	      result = result.multiply(radixToPower);
	      result = result.add(Integer.fromNumber(value));
	    }
	  }
	  return result;
	};

	/**
	 * Returns an Integer representation of a given big endian Buffer.
	 * The internal representation of bits contains bytes in groups of 4
	 * @param {Buffer} buf
	 * @returns {Integer}
	 */
	Integer.fromBuffer = function (buf) {
	  var bits = new Array(Math.ceil(buf.length / 4));
	  //noinspection JSBitwiseOperatorUsage
	  var sign = buf[0] & (1 << 7) ? -1 : 0;
	  for (var i = 0; i < bits.length; i++) {
	    var offset = buf.length - ((i + 1) * 4);
	    var value;
	    if (offset < 0) {
	      //The buffer length is not multiple of 4
	      offset = offset + 4;
	      value = 0;
	      for (var j = 0; j < offset; j++) {
	        var byte = buf[j];
	        if (sign === -1) {
	          //invert the bits
	          byte = ~byte & 0xff;
	        }
	        value = value | (byte << (offset - j - 1) * 8);
	      }
	      if (sign === -1) {
	        //invert all the bits
	        value = ~value;
	      }
	    }
	    else {
	      value = buf.readInt32BE(offset);
	    }
	    bits[i] = value;
	  }
	  return new Integer(bits, sign);
	};

	/**
	 * Returns a big endian buffer representation of an Integer.
	 * Internally the bits are represented using 4 bytes groups (numbers),
	 * in the Buffer representation there might be the case where we need less than the 4 bytes.
	 * For example: 0x00000001 -> '01', 0xFFFFFFFF -> 'FF', 0xFFFFFF01 -> 'FF01'
	 * @param {Integer} value
	 * @returns {Buffer}
	*/
	Integer.toBuffer = function (value) {
	  var sign = value.sign_;
	  var bits = value.bits_;
	  if (bits.length === 0) {
	    //[0] or [0xffffffff]
	    return utils.allocBufferFromArray([value.sign_]);
	  }
	  //the high bits might need to be represented in less than 4 bytes
	  var highBits = bits[bits.length-1];
	  if (sign === -1) {
	    highBits = ~highBits;
	  }
	  var high = [];
	  if (highBits >>> 24 > 0) {
	    high.push((highBits >> 24) & 0xff);
	  }
	  if (highBits >>> 16 > 0) {
	    high.push((highBits >> 16) & 0xff);
	  }
	  if (highBits >>> 8 > 0) {
	    high.push((highBits >> 8) & 0xff);
	  }
	  high.push(highBits & 0xff);
	  if (sign === -1) {
	    //The byte containing the sign bit got removed
	    if (high[0] >> 7 !== 0) {
	      //it is going to be negated
	      high.unshift(0);
	    }
	  }
	  else if (high[0] >> 7 !== 0) {
	    //its positive but it lost the byte containing the sign bit
	    high.unshift(0);
	  }
	  var buf = utils.allocBufferUnsafe(high.length + ((bits.length-1) * 4));
	  for (var j = 0; j < high.length; j++) {
	    var b = high[j];
	    if (sign === -1) {
	      buf[j] = ~b;
	    }
	    else {
	      buf[j] = b;
	    }
	  }
	  for (var i = 0; i < bits.length - 1; i++) {
	    var group = bits[bits.length - 2 - i];
	    var offset = high.length + i * 4;
	    buf.writeInt32BE(group, offset);
	  }
	  return buf;
	};


	/**
	 * A number used repeatedly in calculations.  This must appear before the first
	 * call to the from* functions below.
	 * @type {number}
	 * @private
	 */
	Integer.TWO_PWR_32_DBL_ = (1 << 16) * (1 << 16);


	/** @type {!Integer} */
	Integer.ZERO = Integer.fromInt(0);


	/** @type {!Integer} */
	Integer.ONE = Integer.fromInt(1);


	/**
	 * @type {!Integer}
	 * @private
	 */
	Integer.TWO_PWR_24_ = Integer.fromInt(1 << 24);


	/**
	 * Returns the value, assuming it is a 32-bit integer.
	 * @return {number} The corresponding int value.
	 */
	Integer.prototype.toInt = function() {
	  return this.bits_.length > 0 ? this.bits_[0] : this.sign_;
	};


	/** @return {number} The closest floating-point representation to this value. */
	Integer.prototype.toNumber = function() {
	  if (this.isNegative()) {
	    return -this.negate().toNumber();
	  } else {
	    var val = 0;
	    var pow = 1;
	    for (var i = 0; i < this.bits_.length; i++) {
	      val += this.getBitsUnsigned(i) * pow;
	      pow *= Integer.TWO_PWR_32_DBL_;
	    }
	    return val;
	  }
	};


	/**
	 * @param {number=} opt_radix The radix in which the text should be written.
	 * @return {string} The textual representation of this value.
	 * @override
	 */
	Integer.prototype.toString = function(opt_radix) {
	  var radix = opt_radix || 10;
	  if (radix < 2 || 36 < radix) {
	    throw Error('radix out of range: ' + radix);
	  }

	  if (this.isZero()) {
	    return '0';
	  } else if (this.isNegative()) {
	    return '-' + this.negate().toString(radix);
	  }

	  // Do several (6) digits each time through the loop, so as to
	  // minimize the calls to the very expensive emulated div.
	  var radixToPower = Integer.fromNumber(Math.pow(radix, 6));

	  var rem = this;
	  var result = '';
	  while (true) {
	    var remDiv = rem.divide(radixToPower);
	    var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt();
	    var digits = intval.toString(radix);

	    rem = remDiv;
	    if (rem.isZero()) {
	      return digits + result;
	    } else {
	      while (digits.length < 6) {
	        digits = '0' + digits;
	      }
	      result = '' + digits + result;
	    }
	  }
	};


	/**
	 * Returns the index-th 32-bit (signed) piece of the Integer according to
	 * little-endian order (i.e., index 0 contains the smallest bits).
	 * @param {number} index The index in question.
	 * @return {number} The requested 32-bits as a signed number.
	 */
	Integer.prototype.getBits = function(index) {
	  if (index < 0) {
	    return 0;  // Allowing this simplifies bit shifting operations below...
	  } else if (index < this.bits_.length) {
	    return this.bits_[index];
	  } else {
	    return this.sign_;
	  }
	};


	/**
	 * Returns the index-th 32-bit piece as an unsigned number.
	 * @param {number} index The index in question.
	 * @return {number} The requested 32-bits as an unsigned number.
	 */
	Integer.prototype.getBitsUnsigned = function(index) {
	  var val = this.getBits(index);
	  return val >= 0 ? val : Integer.TWO_PWR_32_DBL_ + val;
	};


	/** @return {number} The sign bit of this number, -1 or 0. */
	Integer.prototype.getSign = function() {
	  return this.sign_;
	};


	/** @return {boolean} Whether this value is zero. */
	Integer.prototype.isZero = function() {
	  if (this.sign_ != 0) {
	    return false;
	  }
	  for (var i = 0; i < this.bits_.length; i++) {
	    if (this.bits_[i] != 0) {
	      return false;
	    }
	  }
	  return true;
	};


	/** @return {boolean} Whether this value is negative. */
	Integer.prototype.isNegative = function() {
	  return this.sign_ == -1;
	};


	/** @return {boolean} Whether this value is odd. */
	Integer.prototype.isOdd = function() {
	  return (this.bits_.length == 0) && (this.sign_ == -1) ||
	    (this.bits_.length > 0) && ((this.bits_[0] & 1) != 0);
	};


	/**
	 * @param {Integer} other Integer to compare against.
	 * @return {boolean} Whether this Integer equals the other.
	 */
	Integer.prototype.equals = function(other) {
	  if (this.sign_ != other.sign_) {
	    return false;
	  }
	  var len = Math.max(this.bits_.length, other.bits_.length);
	  for (var i = 0; i < len; i++) {
	    if (this.getBits(i) != other.getBits(i)) {
	      return false;
	    }
	  }
	  return true;
	};


	/**
	 * @param {Integer} other Integer to compare against.
	 * @return {boolean} Whether this Integer does not equal the other.
	 */
	Integer.prototype.notEquals = function(other) {
	  return !this.equals(other);
	};


	/**
	 * @param {Integer} other Integer to compare against.
	 * @return {boolean} Whether this Integer is greater than the other.
	 */
	Integer.prototype.greaterThan = function(other) {
	  return this.compare(other) > 0;
	};


	/**
	 * @param {Integer} other Integer to compare against.
	 * @return {boolean} Whether this Integer is greater than or equal to the other.
	 */
	Integer.prototype.greaterThanOrEqual = function(other) {
	  return this.compare(other) >= 0;
	};


	/**
	 * @param {Integer} other Integer to compare against.
	 * @return {boolean} Whether this Integer is less than the other.
	 */
	Integer.prototype.lessThan = function(other) {
	  return this.compare(other) < 0;
	};


	/**
	 * @param {Integer} other Integer to compare against.
	 * @return {boolean} Whether this Integer is less than or equal to the other.
	 */
	Integer.prototype.lessThanOrEqual = function(other) {
	  return this.compare(other) <= 0;
	};


	/**
	 * Compares this Integer with the given one.
	 * @param {Integer} other Integer to compare against.
	 * @return {number} 0 if they are the same, 1 if the this is greater, and -1
	 *     if the given one is greater.
	 */
	Integer.prototype.compare = function(other) {
	  var diff = this.subtract(other);
	  if (diff.isNegative()) {
	    return -1;
	  } else if (diff.isZero()) {
	    return 0;
	  } else {
	    return +1;
	  }
	};


	/**
	 * Returns an integer with only the first numBits bits of this value, sign
	 * extended from the final bit.
	 * @param {number} numBits The number of bits by which to shift.
	 * @return {!Integer} The shorted integer value.
	 */
	Integer.prototype.shorten = function(numBits) {
	  var arr_index = (numBits - 1) >> 5;
	  var bit_index = (numBits - 1) % 32;
	  var bits = [];
	  for (var i = 0; i < arr_index; i++) {
	    bits[i] = this.getBits(i);
	  }
	  var sigBits = bit_index == 31 ? 0xFFFFFFFF : (1 << (bit_index + 1)) - 1;
	  var val = this.getBits(arr_index) & sigBits;
	  //noinspection JSBitwiseOperatorUsage
	  if (val & (1 << bit_index)) {
	    val |= 0xFFFFFFFF - sigBits;
	    bits[arr_index] = val;
	    return new Integer(bits, -1);
	  } else {
	    bits[arr_index] = val;
	    return new Integer(bits, 0);
	  }
	};


	/** @return {!Integer} The negation of this value. */
	Integer.prototype.negate = function() {
	  return this.not().add(Integer.ONE);
	};


	/**
	 * Returns the sum of this and the given Integer.
	 * @param {Integer} other The Integer to add to this.
	 * @return {!Integer} The Integer result.
	 */
	Integer.prototype.add = function(other) {
	  var len = Math.max(this.bits_.length, other.bits_.length);
	  var arr = [];
	  var carry = 0;

	  for (var i = 0; i <= len; i++) {
	    var a1 = this.getBits(i) >>> 16;
	    var a0 = this.getBits(i) & 0xFFFF;

	    var b1 = other.getBits(i) >>> 16;
	    var b0 = other.getBits(i) & 0xFFFF;

	    var c0 = carry + a0 + b0;
	    var c1 = (c0 >>> 16) + a1 + b1;
	    carry = c1 >>> 16;
	    c0 &= 0xFFFF;
	    c1 &= 0xFFFF;
	    arr[i] = (c1 << 16) | c0;
	  }
	  return Integer.fromBits(arr);
	};


	/**
	 * Returns the difference of this and the given Integer.
	 * @param {Integer} other The Integer to subtract from this.
	 * @return {!Integer} The Integer result.
	 */
	Integer.prototype.subtract = function(other) {
	  return this.add(other.negate());
	};


	/**
	 * Returns the product of this and the given Integer.
	 * @param {Integer} other The Integer to multiply against this.
	 * @return {!Integer} The product of this and the other.
	 */
	Integer.prototype.multiply = function(other) {
	  if (this.isZero()) {
	    return Integer.ZERO;
	  } else if (other.isZero()) {
	    return Integer.ZERO;
	  }

	  if (this.isNegative()) {
	    if (other.isNegative()) {
	      return this.negate().multiply(other.negate());
	    } else {
	      return this.negate().multiply(other).negate();
	    }
	  } else if (other.isNegative()) {
	    return this.multiply(other.negate()).negate();
	  }

	  // If both numbers are small, use float multiplication
	  if (this.lessThan(Integer.TWO_PWR_24_) &&
	    other.lessThan(Integer.TWO_PWR_24_)) {
	    return Integer.fromNumber(this.toNumber() * other.toNumber());
	  }

	  // Fill in an array of 16-bit products.
	  var len = this.bits_.length + other.bits_.length;
	  var arr = [];
	  for (var i = 0; i < 2 * len; i++) {
	    arr[i] = 0;
	  }
	  for (var i = 0; i < this.bits_.length; i++) {
	    for (var j = 0; j < other.bits_.length; j++) {
	      var a1 = this.getBits(i) >>> 16;
	      var a0 = this.getBits(i) & 0xFFFF;

	      var b1 = other.getBits(j) >>> 16;
	      var b0 = other.getBits(j) & 0xFFFF;

	      arr[2 * i + 2 * j] += a0 * b0;
	      Integer.carry16_(arr, 2 * i + 2 * j);
	      arr[2 * i + 2 * j + 1] += a1 * b0;
	      Integer.carry16_(arr, 2 * i + 2 * j + 1);
	      arr[2 * i + 2 * j + 1] += a0 * b1;
	      Integer.carry16_(arr, 2 * i + 2 * j + 1);
	      arr[2 * i + 2 * j + 2] += a1 * b1;
	      Integer.carry16_(arr, 2 * i + 2 * j + 2);
	    }
	  }

	  // Combine the 16-bit values into 32-bit values.
	  for (var i = 0; i < len; i++) {
	    arr[i] = (arr[2 * i + 1] << 16) | arr[2 * i];
	  }
	  for (var i = len; i < 2 * len; i++) {
	    arr[i] = 0;
	  }
	  return new Integer(arr, 0);
	};


	/**
	 * Carries any overflow from the given index into later entries.
	 * @param {Array.<number>} bits Array of 16-bit values in little-endian order.
	 * @param {number} index The index in question.
	 * @private
	 */
	Integer.carry16_ = function(bits, index) {
	  while ((bits[index] & 0xFFFF) != bits[index]) {
	    bits[index + 1] += bits[index] >>> 16;
	    bits[index] &= 0xFFFF;
	  }
	};


	/**
	 * Returns this Integer divided by the given one.
	 * @param {Integer} other Th Integer to divide this by.
	 * @return {!Integer} This value divided by the given one.
	 */
	Integer.prototype.divide = function(other) {
	  if (other.isZero()) {
	    throw Error('division by zero');
	  } else if (this.isZero()) {
	    return Integer.ZERO;
	  }

	  if (this.isNegative()) {
	    if (other.isNegative()) {
	      return this.negate().divide(other.negate());
	    } else {
	      return this.negate().divide(other).negate();
	    }
	  } else if (other.isNegative()) {
	    return this.divide(other.negate()).negate();
	  }

	  // Repeat the following until the remainder is less than other:  find a
	  // floating-point that approximates remainder / other *from below*, add this
	  // into the result, and subtract it from the remainder.  It is critical that
	  // the approximate value is less than or equal to the real value so that the
	  // remainder never becomes negative.
	  var res = Integer.ZERO;
	  var rem = this;
	  while (rem.greaterThanOrEqual(other)) {
	    // Approximate the result of division. This may be a little greater or
	    // smaller than the actual value.
	    var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));

	    // We will tweak the approximate result by changing it in the 48-th digit or
	    // the smallest non-fractional digit, whichever is larger.
	    var log2 = Math.ceil(Math.log(approx) / Math.LN2);
	    var delta = (log2 <= 48) ? 1 : Math.pow(2, log2 - 48);

	    // Decrease the approximation until it is smaller than the remainder.  Note
	    // that if it is too large, the product overflows and is negative.
	    var approxRes = Integer.fromNumber(approx);
	    var approxRem = approxRes.multiply(other);
	    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
	      approx -= delta;
	      approxRes = Integer.fromNumber(approx);
	      approxRem = approxRes.multiply(other);
	    }

	    // We know the answer can't be zero... and actually, zero would cause
	    // infinite recursion since we would make no progress.
	    if (approxRes.isZero()) {
	      approxRes = Integer.ONE;
	    }

	    res = res.add(approxRes);
	    rem = rem.subtract(approxRem);
	  }
	  return res;
	};


	/**
	 * Returns this Integer modulo the given one.
	 * @param {Integer} other The Integer by which to mod.
	 * @return {!Integer} This value modulo the given one.
	 */
	Integer.prototype.modulo = function(other) {
	  return this.subtract(this.divide(other).multiply(other));
	};


	/** @return {!Integer} The bitwise-NOT of this value. */
	Integer.prototype.not = function() {
	  var len = this.bits_.length;
	  var arr = [];
	  for (var i = 0; i < len; i++) {
	    arr[i] = ~this.bits_[i];
	  }
	  return new Integer(arr, ~this.sign_);
	};


	/**
	 * Returns the bitwise-AND of this Integer and the given one.
	 * @param {Integer} other The Integer to AND with this.
	 * @return {!Integer} The bitwise-AND of this and the other.
	 */
	Integer.prototype.and = function(other) {
	  var len = Math.max(this.bits_.length, other.bits_.length);
	  var arr = [];
	  for (var i = 0; i < len; i++) {
	    arr[i] = this.getBits(i) & other.getBits(i);
	  }
	  return new Integer(arr, this.sign_ & other.sign_);
	};


	/**
	 * Returns the bitwise-OR of this Integer and the given one.
	 * @param {Integer} other The Integer to OR with this.
	 * @return {!Integer} The bitwise-OR of this and the other.
	 */
	Integer.prototype.or = function(other) {
	  var len = Math.max(this.bits_.length, other.bits_.length);
	  var arr = [];
	  for (var i = 0; i < len; i++) {
	    arr[i] = this.getBits(i) | other.getBits(i);
	  }
	  return new Integer(arr, this.sign_ | other.sign_);
	};


	/**
	 * Returns the bitwise-XOR of this Integer and the given one.
	 * @param {Integer} other The Integer to XOR with this.
	 * @return {!Integer} The bitwise-XOR of this and the other.
	 */
	Integer.prototype.xor = function(other) {
	  var len = Math.max(this.bits_.length, other.bits_.length);
	  var arr = [];
	  for (var i = 0; i < len; i++) {
	    arr[i] = this.getBits(i) ^ other.getBits(i);
	  }
	  return new Integer(arr, this.sign_ ^ other.sign_);
	};


	/**
	 * Returns this value with bits shifted to the left by the given amount.
	 * @param {number} numBits The number of bits by which to shift.
	 * @return {!Integer} This shifted to the left by the given amount.
	 */
	Integer.prototype.shiftLeft = function(numBits) {
	  var arr_delta = numBits >> 5;
	  var bit_delta = numBits % 32;
	  var len = this.bits_.length + arr_delta + (bit_delta > 0 ? 1 : 0);
	  var arr = [];
	  for (var i = 0; i < len; i++) {
	    if (bit_delta > 0) {
	      arr[i] = (this.getBits(i - arr_delta) << bit_delta) |
	      (this.getBits(i - arr_delta - 1) >>> (32 - bit_delta));
	    } else {
	      arr[i] = this.getBits(i - arr_delta);
	    }
	  }
	  return new Integer(arr, this.sign_);
	};


	/**
	 * Returns this value with bits shifted to the right by the given amount.
	 * @param {number} numBits The number of bits by which to shift.
	 * @return {!Integer} This shifted to the right by the given amount.
	 */
	Integer.prototype.shiftRight = function(numBits) {
	  var arr_delta = numBits >> 5;
	  var bit_delta = numBits % 32;
	  var len = this.bits_.length - arr_delta;
	  var arr = [];
	  for (var i = 0; i < len; i++) {
	    if (bit_delta > 0) {
	      arr[i] = (this.getBits(i + arr_delta) >>> bit_delta) |
	      (this.getBits(i + arr_delta + 1) << (32 - bit_delta));
	    } else {
	      arr[i] = this.getBits(i + arr_delta);
	    }
	  }
	  return new Integer(arr, this.sign_);
	};

	/**
	 * Provide the name of the constructor and the string representation
	 * @returns {string}
	 */
	Integer.prototype.inspect = function () {
	  return this.constructor.name + ': ' + this.toString();
	};

	/**
	 * Returns a Integer whose value is the absolute value of this
	 * @returns {Integer}
	 */
	Integer.prototype.abs = function () {
	  return this.sign_ === 0 ? this : this.negate();
	};

	/**
	 * Returns the string representation.
	 * Method used by the native JSON.stringify() to serialize this instance.
	 */
	Integer.prototype.toJSON = function () {
	  return this.toString();
	};

	integer = Integer;
	return integer;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var bigDecimal;
var hasRequiredBigDecimal;

function requireBigDecimal () {
	if (hasRequiredBigDecimal) return bigDecimal;
	hasRequiredBigDecimal = 1;
	const Integer = requireInteger();
	const utils = requireUtils$c();

	/** @module types */
	/**
	 * Constructs an immutable arbitrary-precision signed decimal number.
	 * A <code>BigDecimal</code> consists of an [arbitrary precision integer]{@link module:types~Integer}
	 * <i>unscaled value</i> and a 32-bit integer <i>scale</i>.  If zero
	 * or positive, the scale is the number of digits to the right of the
	 * decimal point.  If negative, the unscaled value of the number is
	 * multiplied by ten to the power of the negation of the scale.  The
	 * value of the number represented by the <code>BigDecimal</code> is
	 * therefore <tt>(unscaledValue &times; 10<sup>-scale</sup>)</tt>.
	 * @class
	 * @classdesc The <code>BigDecimal</code> class provides operations for
	 * arithmetic, scale manipulation, rounding, comparison and
	 * format conversion.  The {@link #toString} method provides a
	 * canonical representation of a <code>BigDecimal</code>.
	 * @param {Integer|Number} unscaledValue The integer part of the decimal.
	 * @param {Number} scale The scale of the decimal.
	 * @constructor
	 */
	function BigDecimal(unscaledValue, scale) {
	  if (typeof unscaledValue === 'number') {
	    unscaledValue = Integer.fromNumber(unscaledValue);
	  }
	  /**
	   * @type {Integer}
	   * @private
	   */
	  this._intVal = unscaledValue;
	  /**
	   * @type {Number}
	   * @private
	   */
	  this._scale = scale;
	}

	/**
	 * Returns the BigDecimal representation of a buffer composed of the scale (int32BE) and the unsigned value (varint BE)
	 * @param {Buffer} buf
	 * @returns {BigDecimal}
	 */
	BigDecimal.fromBuffer = function (buf) {
	  const scale = buf.readInt32BE(0);
	  const unscaledValue = Integer.fromBuffer(buf.slice(4));
	  return new BigDecimal(unscaledValue, scale);
	};

	/**
	 * Returns a buffer representation composed of the scale as a BE int 32 and the unsigned value as a BE varint
	 * @param {BigDecimal} value
	 * @returns {Buffer}
	 */
	BigDecimal.toBuffer = function (value) {
	  const unscaledValueBuffer = Integer.toBuffer(value._intVal);
	  const scaleBuffer = utils.allocBufferUnsafe(4);
	  scaleBuffer.writeInt32BE(value._scale, 0);
	  return Buffer.concat([scaleBuffer, unscaledValueBuffer], scaleBuffer.length + unscaledValueBuffer.length);
	};

	/**
	 * Returns a BigDecimal representation of the string
	 * @param {String} value
	 * @returns {BigDecimal}
	 */
	BigDecimal.fromString = function (value) {
	  if (!value) {
	    throw new TypeError('Invalid null or undefined value');
	  }
	  value = value.trim();
	  const scaleIndex = value.indexOf('.');
	  let scale = 0;
	  if (scaleIndex >= 0) {
	    scale = value.length - 1 - scaleIndex;
	    value = value.substr(0, scaleIndex) + value.substr(scaleIndex + 1);
	  }
	  return new BigDecimal(Integer.fromString(value), scale);
	};

	/**
	 * Returns a BigDecimal representation of the Number
	 * @param {Number} value
	 * @returns {BigDecimal}
	 */
	BigDecimal.fromNumber = function (value) {
	  if (isNaN(value)) {
	    return new BigDecimal(Integer.ZERO, 0);
	  }
	  let textValue = value.toString();
	  if (textValue.indexOf('e') >= 0) {
	    //get until scale 20
	    textValue = value.toFixed(20);
	  }
	  return BigDecimal.fromString(textValue);
	};

	/**
	 * Returns true if the value of the BigDecimal instance and other are the same
	 * @param {BigDecimal} other
	 * @returns {Boolean}
	 */
	BigDecimal.prototype.equals = function (other) {
	  return ((other instanceof BigDecimal) && this.compare(other) === 0);
	};

	BigDecimal.prototype.inspect = function () {
	  return this.constructor.name + ': ' + this.toString();
	};

	/**
	 * @param {BigDecimal} other
	 * @returns {boolean}
	 */
	BigDecimal.prototype.notEquals = function (other) {
	  return !this.equals(other);
	};

	/**
	 * Compares this BigDecimal with the given one.
	 * @param {BigDecimal} other Integer to compare against.
	 * @return {number} 0 if they are the same, 1 if the this is greater, and -1
	 *     if the given one is greater.
	 */
	BigDecimal.prototype.compare = function (other) {
	  const diff = this.subtract(other);
	  if (diff.isNegative()) {
	    return -1;
	  }
	  if (diff.isZero()) {
	    return 0;
	  }
	  return +1;
	};

	/**
	 * Returns the difference of this and the given BigDecimal.
	 * @param {BigDecimal} other The BigDecimal to subtract from this.
	 * @return {!BigDecimal} The BigDecimal result.
	 */
	BigDecimal.prototype.subtract = function (other) {
	  const first = this;
	  if (first._scale === other._scale) {
	    return new BigDecimal(first._intVal.subtract(other._intVal), first._scale);
	  }
	  let diffScale;
	  let unscaledValue;
	  if (first._scale < other._scale) {
	    //The scale of this is lower
	    diffScale = other._scale - first._scale;
	    //multiple this unScaledValue to compare in the same scale
	    unscaledValue = first._intVal
	      .multiply(Integer.fromNumber(Math.pow(10, diffScale)))
	      .subtract(other._intVal);
	    return new BigDecimal(unscaledValue, other._scale);
	  }
	  //The scale of this is higher
	  diffScale = first._scale - other._scale;
	  //multiple this unScaledValue to compare in the same scale
	  unscaledValue = first._intVal
	    .subtract(
	      other._intVal.multiply(Integer.fromNumber(Math.pow(10, diffScale))));
	  return new BigDecimal(unscaledValue, first._scale);
	};

	/**
	 * Returns the sum of this and the given <code>BigDecimal</code>.
	 * @param {BigDecimal} other The BigDecimal to sum to this.
	 * @return {!BigDecimal} The BigDecimal result.
	 */
	BigDecimal.prototype.add = function (other) {
	  const first = this;
	  if (first._scale === other._scale) {
	    return new BigDecimal(first._intVal.add(other._intVal), first._scale);
	  }
	  let diffScale;
	  let unscaledValue;
	  if (first._scale < other._scale) {
	    //The scale of this is lower
	    diffScale = other._scale - first._scale;
	    //multiple this unScaledValue to compare in the same scale
	    unscaledValue = first._intVal
	      .multiply(Integer.fromNumber(Math.pow(10, diffScale)))
	      .add(other._intVal);
	    return new BigDecimal(unscaledValue, other._scale);
	  }
	  //The scale of this is higher
	  diffScale = first._scale - other._scale;
	  //multiple this unScaledValue to compare in the same scale
	  unscaledValue = first._intVal
	    .add(
	      other._intVal.multiply(Integer.fromNumber(Math.pow(10, diffScale))));
	  return new BigDecimal(unscaledValue, first._scale);
	};

	/**
	 * Returns true if the current instance is greater than the other
	 * @param {BigDecimal} other
	 * @returns {boolean}
	 */
	BigDecimal.prototype.greaterThan = function (other) {
	  return this.compare(other) === 1;
	};

	/** @return {boolean} Whether this value is negative. */
	BigDecimal.prototype.isNegative = function () {
	  return this._intVal.isNegative();
	};

	/** @return {boolean} Whether this value is zero. */
	BigDecimal.prototype.isZero = function () {
	  return this._intVal.isZero();
	};

	/**
	 * Returns the string representation of this <code>BigDecimal</code>
	 * @returns {string}
	 */
	BigDecimal.prototype.toString = function () {
	  let intString = this._intVal.toString();
	  if (this._scale === 0) {
	    return intString;
	  }
	  let signSymbol = '';
	  if (intString.charAt(0) === '-') {
	    signSymbol = '-';
	    intString = intString.substr(1);
	  }
	  let separatorIndex = intString.length - this._scale;
	  if (separatorIndex <= 0) {
	    //add zeros at the beginning, plus an additional zero
	    intString = utils.stringRepeat('0', (-separatorIndex) + 1) + intString;
	    separatorIndex = intString.length - this._scale;
	  }
	  return signSymbol + intString.substr(0, separatorIndex) + '.' + intString.substr(separatorIndex);
	};

	/**
	 * Returns a Number representation of this <code>BigDecimal</code>.
	 * @returns {Number}
	 */
	BigDecimal.prototype.toNumber = function () {
	  return parseFloat(this.toString());
	};

	/**
	 * Returns the string representation.
	 * Method used by the native JSON.stringify() to serialize this instance.
	 */
	BigDecimal.prototype.toJSON = function () {
	  return this.toString();
	};


	bigDecimal = BigDecimal;
	return bigDecimal;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var duration;
var hasRequiredDuration;

function requireDuration () {
	if (hasRequiredDuration) return duration;
	hasRequiredDuration = 1;
	const Long = requireUmd();
	const util = require$$0$6;
	const utils = requireUtils$c();

	/** @module types */

	// Reuse the same buffers that should perform slightly better than built-in buffer pool
	const reusableBuffers = {
	  months: utils.allocBuffer(9),
	  days: utils.allocBuffer(9),
	  nanoseconds: utils.allocBuffer(9)
	};

	const maxInt32 = 0x7FFFFFFF;
	const longOneThousand = Long.fromInt(1000);
	const nanosPerMicro = longOneThousand;
	const nanosPerMilli = longOneThousand.multiply(nanosPerMicro);
	const nanosPerSecond = longOneThousand.multiply(nanosPerMilli);
	const nanosPerMinute = Long.fromInt(60).multiply(nanosPerSecond);
	const nanosPerHour = Long.fromInt(60).multiply(nanosPerMinute);
	const daysPerWeek = 7;
	const monthsPerYear = 12;
	const standardRegex = /(\d+)(y|mo|w|d|h|s|ms|us|µs|ns|m)/gi;
	const iso8601Regex = /P((\d+)Y)?((\d+)M)?((\d+)D)?(T((\d+)H)?((\d+)M)?((\d+)S)?)?/;
	const iso8601WeekRegex = /P(\d+)W/;
	const iso8601AlternateRegex = /P(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})/;

	/**
	 * Creates a new instance of {@link Duration}.
	 * @classdesc
	 * Represents a duration. A duration stores separately months, days, and seconds due to the fact that the number of
	 * days in a month varies, and a day can have 23 or 25 hours if a daylight saving is involved.
	 * @param {Number} months The number of months.
	 * @param {Number} days The number of days.
	 * @param {Number|Long} nanoseconds The number of nanoseconds.
	 * @constructor
	 */
	function Duration(months, days, nanoseconds) {
	  /**
	   * Gets the number of months.
	   * @type {Number}
	   */
	  this.months = months;
	  /**
	   * Gets the number of days.
	   * @type {Number}
	   */
	  this.days = days;
	  /**
	   * Gets the number of nanoseconds represented as a <code>int64</code>.
	   * @type {Long}
	   */
	  this.nanoseconds = typeof nanoseconds === 'number' ? Long.fromNumber(nanoseconds) : nanoseconds;
	}

	Duration.prototype.equals = function (other) {
	  if (!(other instanceof Duration)) {
	    return false;
	  }
	  return this.months === other.months &&
	    this.days === other.days &&
	    this.nanoseconds.equals(other.nanoseconds);
	};

	/**
	 * Serializes the duration and returns the representation of the value in bytes.
	 * @returns {Buffer}
	 */
	Duration.prototype.toBuffer = function () {
	  const lengthMonths = VIntCoding.writeVInt(Long.fromNumber(this.months), reusableBuffers.months);
	  const lengthDays = VIntCoding.writeVInt(Long.fromNumber(this.days), reusableBuffers.days);
	  const lengthNanoseconds = VIntCoding.writeVInt(this.nanoseconds, reusableBuffers.nanoseconds);
	  const buffer = utils.allocBufferUnsafe(lengthMonths + lengthDays + lengthNanoseconds);
	  reusableBuffers.months.copy(buffer, 0, 0, lengthMonths);
	  let offset = lengthMonths;
	  reusableBuffers.days.copy(buffer, offset, 0, lengthDays);
	  offset += lengthDays;
	  reusableBuffers.nanoseconds.copy(buffer, offset, 0, lengthNanoseconds);
	  return buffer;
	};

	/**
	 * Returns the string representation of the value.
	 * @return {string}
	 */
	Duration.prototype.toString = function () {
	  let value = '';
	  function append(dividend, divisor, unit) {
	    if (dividend === 0 || dividend < divisor) {
	      return dividend;
	    }
	    // string concatenation is supposed to be fasted than join()
	    value += (dividend / divisor).toFixed(0) + unit;
	    return dividend % divisor;
	  }
	  function append64(dividend, divisor, unit) {
	    if (dividend.equals(Long.ZERO) || dividend.lessThan(divisor)) {
	      return dividend;
	    }
	    // string concatenation is supposed to be fasted than join()
	    value += dividend.divide(divisor).toString() + unit;
	    return dividend.modulo(divisor);
	  }
	  if (this.months < 0 || this.days < 0 || this.nanoseconds.isNegative()) {
	    value = '-';
	  }
	  let remainder = append(Math.abs(this.months), monthsPerYear, "y");
	  append(remainder, 1, "mo");
	  append(Math.abs(this.days), 1, "d");

	  if (!this.nanoseconds.equals(Long.ZERO)) {
	    const nanos = this.nanoseconds.isNegative() ? this.nanoseconds.negate() : this.nanoseconds;
	    remainder = append64(nanos, nanosPerHour, "h");
	    remainder = append64(remainder, nanosPerMinute, "m");
	    remainder = append64(remainder, nanosPerSecond, "s");
	    remainder = append64(remainder, nanosPerMilli, "ms");
	    remainder = append64(remainder, nanosPerMicro, "us");
	    append64(remainder, Long.ONE, "ns");
	  }
	  return value;
	};

	/**
	 * Creates a new {@link Duration} instance from the binary representation of the value.
	 * @param {Buffer} buffer
	 * @returns {Duration}
	 */
	Duration.fromBuffer = function (buffer) {
	  const offset = { value: 0 };
	  const months = VIntCoding.readVInt(buffer, offset).toNumber();
	  const days = VIntCoding.readVInt(buffer, offset).toNumber();
	  const nanoseconds = VIntCoding.readVInt(buffer, offset);
	  return new Duration(months, days, nanoseconds);
	};

	/**
	 * Creates a new {@link Duration} instance from the string representation of the value.
	 * <p>
	 *   Accepted formats:
	 * </p>
	 * <ul>
	 * <li>multiple digits followed by a time unit like: 12h30m where the time unit can be:
	 *   <ul>
	 *     <li>{@code y}: years</li>
	 *     <li>{@code m}: months</li>
	 *     <li>{@code w}: weeks</li>
	 *     <li>{@code d}: days</li>
	 *     <li>{@code h}: hours</li>
	 *     <li>{@code m}: minutes</li>
	 *     <li>{@code s}: seconds</li>
	 *     <li>{@code ms}: milliseconds</li>
	 *     <li>{@code us} or {@code µs}: microseconds</li>
	 *     <li>{@code ns}: nanoseconds</li>
	 *   </ul>
	 * </li>
	 * <li>ISO 8601 format:  <code>P[n]Y[n]M[n]DT[n]H[n]M[n]S or P[n]W</code></li>
	 * <li>ISO 8601 alternative format: <code>P[YYYY]-[MM]-[DD]T[hh]:[mm]:[ss]</code></li>
	 * </ul>
	 * @param {String} input
	 * @returns {Duration}
	 */
	Duration.fromString = function (input) {
	  const isNegative = input.charAt(0) === '-';
	  const source = isNegative ? input.substr(1) : input;
	  if (source.charAt(0) === 'P') {
	    if (source.charAt(source.length - 1) === 'W') {
	      return parseIso8601WeekFormat(isNegative, source);
	    }
	    if (source.indexOf('-') > 0) {
	      return parseIso8601AlternativeFormat(isNegative, source);
	    }
	    return parseIso8601Format(isNegative, source);
	  }
	  return parseStandardFormat(isNegative, source);
	};

	/**
	 * @param {Boolean} isNegative
	 * @param {String} source
	 * @returns {Duration}
	 * @private
	 */
	function parseStandardFormat(isNegative, source) {
	  const builder = new Builder(isNegative);
	  standardRegex.lastIndex = 0;
	  let matches;
	  while ((matches = standardRegex.exec(source)) && matches.length <= 3) {
	    builder.add(matches[1], matches[2]);
	  }
	  return builder.build();
	}

	/**
	 * @param {Boolean} isNegative
	 * @param {String} source
	 * @returns {Duration}
	 * @private
	 */
	function parseIso8601Format(isNegative, source) {
	  const matches = iso8601Regex.exec(source);
	  if (!matches || matches[0] !== source) {
	    throw new TypeError(util.format("Unable to convert '%s' to a duration", source));
	  }
	  const builder = new Builder(isNegative);
	  if (matches[1]) {
	    builder.addYears(matches[2]);
	  }
	  if (matches[3]) {
	    builder.addMonths(matches[4]);
	  }
	  if (matches[5]) {
	    builder.addDays(matches[6]);
	  }
	  if (matches[7]) {
	    if (matches[8]) {
	      builder.addHours(matches[9]);
	    }
	    if (matches[10]) {
	      builder.addMinutes(matches[11]);
	    }
	    if (matches[12]) {
	      builder.addSeconds(matches[13]);
	    }
	  }
	  return builder.build();
	}

	/**
	 * @param {Boolean} isNegative
	 * @param {String} source
	 * @returns {Duration}
	 * @private
	 */
	function parseIso8601WeekFormat(isNegative, source) {
	  const matches = iso8601WeekRegex.exec(source);
	  if (!matches || matches[0] !== source) {
	    throw new TypeError(util.format("Unable to convert '%s' to a duration", source));
	  }
	  return new Builder(isNegative)
	    .addWeeks(matches[1])
	    .build();
	}

	/**
	 * @param {Boolean} isNegative
	 * @param {String} source
	 * @returns {Duration}
	 * @private
	 */
	function parseIso8601AlternativeFormat(isNegative, source) {
	  const matches = iso8601AlternateRegex.exec(source);
	  if (!matches || matches[0] !== source) {
	    throw new TypeError(util.format("Unable to convert '%s' to a duration", source));
	  }
	  return new Builder(isNegative).addYears(matches[1])
	    .addMonths(matches[2])
	    .addDays(matches[3])
	    .addHours(matches[4])
	    .addMinutes(matches[5])
	    .addSeconds(matches[6])
	    .build();
	}

	/**
	 * @param {Boolean} isNegative
	 * @private
	 * @constructor
	 */
	function Builder(isNegative) {
	  this._isNegative = isNegative;
	  this._unitIndex = 0;
	  this._months = 0;
	  this._days = 0;
	  this._nanoseconds = Long.ZERO;
	  this._addMethods = {
	    'y': this.addYears,
	    'mo': this.addMonths,
	    'w': this.addWeeks,
	    'd': this.addDays,
	    'h': this.addHours,
	    'm': this.addMinutes,
	    's': this.addSeconds,
	    'ms': this.addMillis,
	    // µs
	    '\u00B5s': this.addMicros,
	    'us': this.addMicros,
	    'ns': this.addNanos
	  };
	  this._unitByIndex = [
	    null, 'years', 'months', 'weeks', 'days', 'hours', 'minutes', 'seconds', 'milliseconds', 'microseconds',
	    'nanoseconds'
	  ];
	}

	Builder.prototype._validateOrder = function (unitIndex) {
	  if (unitIndex === this._unitIndex) {
	    throw new TypeError(util.format("Invalid duration. The %s are specified multiple times", this._getUnitName(unitIndex)));
	  }

	  if (unitIndex <= this._unitIndex) {
	    throw new TypeError(util.format("Invalid duration. The %s should be after %s",
	      this._getUnitName(this._unitIndex),
	      this._getUnitName(unitIndex)));
	  }
	  this._unitIndex = unitIndex;
	};

	/**
	 * @param {Number} units
	 * @param {Number} monthsPerUnit
	 */
	Builder.prototype._validateMonths = function(units, monthsPerUnit) {
	  this._validate32(units, (maxInt32 - this._months) / monthsPerUnit, "months");
	};

	/**
	 * @param {Number} units
	 * @param {Number} daysPerUnit
	 */
	Builder.prototype._validateDays = function(units, daysPerUnit) {
	  this._validate32(units, (maxInt32 - this._days) / daysPerUnit, "days");
	};

	/**
	 * @param {Long} units
	 * @param {Long} nanosPerUnit
	 */
	Builder.prototype._validateNanos = function(units, nanosPerUnit) {
	  this._validate64(units, Long.MAX_VALUE.subtract(this._nanoseconds).divide(nanosPerUnit), "nanoseconds");
	};

	/**
	 * @param {Number} units
	 * @param {Number} limit
	 * @param {String} unitName
	 */
	Builder.prototype._validate32 = function(units, limit, unitName) {
	  if (units > limit) {
	    throw new TypeError(util.format('Invalid duration. The total number of %s must be less or equal to %s',
	      unitName,
	      maxInt32));
	  }
	};

	/**
	 * @param {Long} units
	 * @param {Long} limit
	 * @param {String} unitName
	 */
	Builder.prototype._validate64 = function(units, limit, unitName) {
	  if (units.greaterThan(limit)) {
	    throw new TypeError(util.format('Invalid duration. The total number of %s must be less or equal to %s',
	      unitName,
	      Long.MAX_VALUE.toString()));
	  }
	};

	Builder.prototype._getUnitName = function(unitIndex) {
	  const name = this._unitByIndex[+unitIndex];
	  if (!name) {
	    throw new Error('unknown unit index: ' + unitIndex);
	  }
	  return name;
	};

	Builder.prototype.add = function (textValue, symbol) {
	  const addMethod = this._addMethods[symbol.toLowerCase()];
	  if (!addMethod) {
	    throw new TypeError(util.format("Unknown duration symbol '%s'", symbol));
	  }
	  return addMethod.call(this, textValue);
	};

	/**
	 * @param {String|Number} years
	 * @return {Builder}
	 */
	Builder.prototype.addYears = function (years) {
	  const value = +years;
	  this._validateOrder(1);
	  this._validateMonths(value, monthsPerYear);
	  this._months += value * monthsPerYear;
	  return this;
	};

	/**
	 * @param {String|Number} months
	 * @return {Builder}
	 */
	Builder.prototype.addMonths = function(months) {
	  const value = +months;
	  this._validateOrder(2);
	  this._validateMonths(value, 1);
	  this._months += value;
	  return this;
	};

	/**
	 * @param {String|Number} weeks
	 * @return {Builder}
	 */
	Builder.prototype.addWeeks = function(weeks) {
	  const value = +weeks;
	  this._validateOrder(3);
	  this._validateDays(value, daysPerWeek);
	  this._days += value * daysPerWeek;
	  return this;
	};

	/**
	 * @param {String|Number} days
	 * @return {Builder}
	 */
	Builder.prototype.addDays = function(days) {
	  const value = +days;
	  this._validateOrder(4);
	  this._validateDays(value, 1);
	  this._days += value;
	  return this;
	};

	/**
	 * @param {String|Long} hours
	 * @return {Builder}
	 */
	Builder.prototype.addHours = function(hours) {
	  const value = typeof hours === 'string' ? Long.fromString(hours) : hours;
	  this._validateOrder(5);
	  this._validateNanos(value, nanosPerHour);
	  this._nanoseconds = this._nanoseconds.add(value.multiply(nanosPerHour));
	  return this;
	};

	/**
	 * @param {String|Long} minutes
	 * @return {Builder}
	 */
	Builder.prototype.addMinutes = function(minutes) {
	  const value = typeof minutes === 'string' ? Long.fromString(minutes) : minutes;
	  this._validateOrder(6);
	  this._validateNanos(value, nanosPerMinute);
	  this._nanoseconds = this._nanoseconds.add(value.multiply(nanosPerMinute));
	  return this;
	};

	/**
	 * @param {String|Long} seconds
	 * @return {Builder}
	 */
	Builder.prototype.addSeconds = function(seconds) {
	  const value = typeof seconds === 'string' ? Long.fromString(seconds) : seconds;
	  this._validateOrder(7);
	  this._validateNanos(value, nanosPerSecond);
	  this._nanoseconds = this._nanoseconds.add(value.multiply(nanosPerSecond));
	  return this;
	};

	/**
	 * @param {String|Long} millis
	 * @return {Builder}
	 */
	Builder.prototype.addMillis = function(millis) {
	  const value = typeof millis === 'string' ? Long.fromString(millis) : millis;
	  this._validateOrder(8);
	  this._validateNanos(value, nanosPerMilli);
	  this._nanoseconds = this._nanoseconds.add(value.multiply(nanosPerMilli));
	  return this;
	};

	/**
	 * @param {String|Long} micros
	 * @return {Builder}
	 */
	Builder.prototype.addMicros = function(micros) {
	  const value = typeof micros === 'string' ? Long.fromString(micros) : micros;
	  this._validateOrder(9);
	  this._validateNanos(value, nanosPerMicro);
	  this._nanoseconds = this._nanoseconds.add(value.multiply(nanosPerMicro));
	  return this;
	};

	/**
	 * @param {String|Long} nanos
	 * @return {Builder}
	 */
	Builder.prototype.addNanos = function(nanos) {
	  const value = typeof nanos === 'string' ? Long.fromString(nanos) : nanos;
	  this._validateOrder(10);
	  this._validateNanos(value, Long.ONE);
	  this._nanoseconds = this._nanoseconds.add(value);
	  return this;
	};

	/** @return {Duration} */
	Builder.prototype.build = function () {
	  return (this._isNegative ?
	    new Duration(-this._months, -this._days, this._nanoseconds.negate()) :
	    new Duration(this._months, this._days, this._nanoseconds));
	};

	/**
	 * Contains the methods for reading and writing vints into binary format.
	 * Exposes only 2 internal methods, the rest are hidden.
	 * @private
	 */
	const VIntCoding = (function () {
	  /** @param {Long} n */
	  function encodeZigZag64(n) {
	    //     (n << 1) ^ (n >> 63);
	    return n.toUnsigned().shiftLeft(1).xor(n.shiftRight(63));
	  }

	  /** @param {Long} n */
	  function decodeZigZag64(n) {
	    //     (n >>> 1) ^ -(n & 1);
	    return n.shiftRightUnsigned(1).xor(n.and(Long.ONE).negate());
	  }

	  /**
	   * @param {Long} value
	   * @param {Buffer} buffer
	   * @returns {Number}
	   */
	  function writeVInt(value, buffer) {
	    return writeUnsignedVInt(encodeZigZag64(value), buffer);
	  }

	  /**
	   * @param {Long} value
	   * @param {Buffer} buffer
	   * @returns {number}
	   */
	  function writeUnsignedVInt(value, buffer) {
	    const size = computeUnsignedVIntSize(value);
	    if (size === 1) {
	      buffer[0] = value.getLowBits();
	      return 1;
	    }
	    encodeVInt(value, size, buffer);
	    return size;
	  }

	  /**
	   * @param {Long} value
	   * @returns {number}
	   */
	  function computeUnsignedVIntSize(value) {
	    const magnitude = numberOfLeadingZeros(value.or(Long.ONE));
	    return (639 - magnitude * 9) >> 6;
	  }

	  /**
	   * @param {Long} value
	   * @param {Number} size
	   * @param {Buffer} buffer
	   */
	  function encodeVInt(value, size, buffer) {
	    const extraBytes = size - 1;
	    let intValue = value.getLowBits();
	    let i;
	    let intBytes = 4;
	    for (i = extraBytes; i >= 0 && (intBytes--) > 0; i--) {
	      buffer[i] = 0xFF & intValue;
	      intValue >>= 8;
	    }
	    intValue = value.getHighBits();
	    for (; i >= 0; i--) {
	      buffer[i] = 0xFF & intValue;
	      intValue >>= 8;
	    }
	    buffer[0] |= encodeExtraBytesToRead(extraBytes);
	  }
	  /**
	   * Returns the number of zero bits preceding the highest-order one-bit in the binary representation of the value.
	   * @param {Long} value
	   * @returns {Number}
	   */
	  function numberOfLeadingZeros(value) {
	    if (value.equals(Long.ZERO)) {
	      return 64;
	    }
	    let n = 1;
	    let x = value.getHighBits();
	    if (x === 0) {
	      n += 32;
	      x = value.getLowBits();
	    }
	    if (x >>> 16 === 0) {
	      n += 16;
	      x <<= 16;
	    }
	    if (x >>> 24 === 0) {
	      n += 8;
	      x <<= 8;
	    }
	    if (x >>> 28 === 0) {
	      n += 4;
	      x <<= 4;
	    }
	    if (x >>> 30 === 0) {
	      n += 2;
	      x <<= 2;
	    }
	    n -= x >>> 31;
	    return n;
	  }


	  function encodeExtraBytesToRead(extraBytesToRead) {
	    return ~(0xff >> extraBytesToRead);
	  }

	  /**
	   * @param {Buffer} buffer
	   * @param {{value: number}} offset
	   * @returns {Long}
	   */
	  function readVInt(buffer, offset) {
	    return decodeZigZag64(readUnsignedVInt(buffer, offset));
	  }

	  /**
	   * @param {Buffer} input
	   * @param {{ value: number}} offset
	   * @returns {Long}
	   */
	  function readUnsignedVInt(input, offset) {
	    const firstByte = input[offset.value++];
	    if ((firstByte & 0x80) === 0) {
	      return Long.fromInt(firstByte);
	    }
	    const sByteInt = fromSignedByteToInt(firstByte);
	    const size = numberOfExtraBytesToRead(sByteInt);
	    let result = Long.fromInt(sByteInt & firstByteValueMask(size));
	    for (let ii = 0; ii < size; ii++) {
	      const b = Long.fromInt(input[offset.value++]);
	      //       (result << 8) | b
	      result = result.shiftLeft(8).or(b);
	    }
	    return result;
	  }

	  function fromSignedByteToInt(value) {
	    if (value > 0x7f) {
	      return value - 0x0100;
	    }
	    return value;
	  }

	  function numberOfLeadingZerosInt32(i) {
	    if (i === 0) {
	      return 32;
	    }
	    let n = 1;
	    if (i >>> 16 === 0) {
	      n += 16;
	      i <<= 16;
	    }
	    if (i >>> 24 === 0) {
	      n += 8;
	      i <<= 8;
	    }
	    if (i >>> 28 === 0) {
	      n += 4;
	      i <<= 4;
	    }
	    if (i >>> 30 === 0) {
	      n += 2;
	      i <<= 2;
	    }
	    n -= i >>> 31;
	    return n;
	  }

	  /**
	   * @param {Number} firstByte
	   * @returns {Number}
	   */
	  function numberOfExtraBytesToRead(firstByte) {
	    // Instead of counting 1s of the byte, we negate and count 0 of the byte
	    return numberOfLeadingZerosInt32(~firstByte) - 24;
	  }

	  /**
	   * @param {Number} extraBytesToRead
	   * @returns {Number}
	   */
	  function firstByteValueMask(extraBytesToRead) {
	    return 0xff >> extraBytesToRead;
	  }

	  return {
	    readVInt: readVInt,
	    writeVInt: writeVInt
	  };
	})();

	duration = Duration;
	return duration;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var inetAddress;
var hasRequiredInetAddress;

function requireInetAddress () {
	if (hasRequiredInetAddress) return inetAddress;
	hasRequiredInetAddress = 1;

	const utils = requireUtils$c();

	/** @module types */
	/**
	 * Creates a new instance of InetAddress
	 * @class
	 * @classdesc Represents an v4 or v6 Internet Protocol (IP) address.
	 * @param {Buffer} buffer
	 * @constructor
	 */
	function InetAddress(buffer) {
	  if (!(buffer instanceof Buffer) || (buffer.length !== 4 && buffer.length !== 16)) {
	    throw new TypeError('The ip address must contain 4 or 16 bytes');
	  }

	  /**
	   * Immutable buffer that represents the IP address 
	   * @type Array
	   */
	  this.buffer = buffer;

	  /**
	   * Returns the length of the underlying buffer
	   * @type Number
	   */
	  this.length = buffer.length;

	  /**
	   * Returns the Ip version (4 or 6)
	   * @type Number
	   */
	  this.version = buffer.length === 4 ? 4 : 6;
	}

	/**
	 * Parses the string representation and returns an Ip address
	 * @param {String} value
	 */
	InetAddress.fromString = function (value) {
	  if (!value) {
	    return new InetAddress(utils.allocBufferFromArray([0, 0, 0, 0]));
	  }
	  const ipv4Pattern = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
	  const ipv6Pattern = /^[\da-f:.]+$/i;
	  let parts;
	  if (ipv4Pattern.test(value)) {
	    parts = value.split('.');
	    return new InetAddress(utils.allocBufferFromArray(parts));
	  }
	  if (!ipv6Pattern.test(value)) {
	    throw new TypeError('Value could not be parsed as InetAddress: ' + value);
	  }
	  parts = value.split(':');
	  if (parts.length < 3) {
	    throw new TypeError('Value could not be parsed as InetAddress: ' + value);
	  }
	  const buffer = utils.allocBufferUnsafe(16);
	  let filling = 8 - parts.length + 1;
	  let applied = false;
	  let offset = 0;
	  const embeddedIp4 = ipv4Pattern.test(parts[parts.length - 1]);
	  if (embeddedIp4) {
	    // Its IPv6 address with an embedded IPv4 address:
	    // subtract 1 from the potential empty filling as ip4 contains 4 bytes instead of 2 of a ipv6 section
	    filling -= 1;
	  }
	  function writeItem(uIntValue) {
	    buffer.writeUInt8(+uIntValue, offset++);
	  }
	  for (let i = 0; i < parts.length; i++) {
	    const item = parts[i];
	    if (item) {
	      if (embeddedIp4 && i === parts.length - 1) {
	        item.split('.').forEach(writeItem);
	        break;
	      }
	      buffer.writeUInt16BE(parseInt(item, 16), offset);
	      offset = offset + 2;
	      continue;
	    }
	    //its an empty string
	    if (applied) {
	      //there could be 2 occurrences of empty string
	      filling = 1;
	    }
	    applied = true;
	    for (let j = 0; j < filling; j++) {
	      buffer[offset++] = 0;
	      buffer[offset++] = 0;
	    }
	  }
	  if (embeddedIp4 && !isValidIPv4Mapped(buffer)) {
	    throw new TypeError('Only IPv4-Mapped IPv6 addresses are allowed as IPv6 address with embedded IPv4 address');
	  }
	  return new InetAddress(buffer);
	};

	/**
	 * Compares 2 addresses and returns true if the underlying bytes are the same
	 * @param {InetAddress} other
	 * @returns {Boolean}
	 */
	InetAddress.prototype.equals = function (other) {
	  if (!(other instanceof InetAddress)) {
	    return false;
	  }
	  return (this.buffer.length === other.buffer.length &&
	    this.buffer.toString('hex') === other.buffer.toString('hex'));
	};

	/**
	 * Returns the underlying buffer
	 * @returns {Buffer}
	 */
	InetAddress.prototype.getBuffer = function () {
	  return this.buffer;
	};

	/**
	 * Provide the name of the constructor and the string representation
	 * @returns {string}
	 */
	InetAddress.prototype.inspect = function () {
	  return this.constructor.name + ': ' + this.toString();
	};

	/**
	 * Returns the string representation of the IP address.
	 * <p>For v4 IP addresses, a string in the form of d.d.d.d is returned.</p>
	 * <p>
	 *   For v6 IP addresses, a string in the form of x:x:x:x:x:x:x:x is returned, where the 'x's are the hexadecimal
	 *   values of the eight 16-bit pieces of the address, according to rfc5952.
	 *   In cases where there is more than one field of only zeros, it can be shortened. For example, 2001:0db8:0:0:0:1:0:1
	 *   will be expressed as 2001:0db8::1:0:1.
	 * </p>
	 * @param {String} [encoding]
	 * @returns {String}
	 */
	InetAddress.prototype.toString = function (encoding) {
	  if (encoding === 'hex') {
	    //backward compatibility: behave in the same way as the buffer
	    return this.buffer.toString('hex');
	  }
	  if (this.buffer.length === 4) {
	    return (
	      this.buffer[0] + '.' +
	      this.buffer[1] + '.' +
	      this.buffer[2] + '.' +
	      this.buffer[3]
	    );
	  }
	  let start = -1;
	  const longest = { length: 0, start: -1};
	  function checkLongest (i) {
	    if (start >= 0) {
	      //close the group
	      const length = i - start;
	      if (length > longest.length) {
	        longest.length = length;
	        longest.start = start;
	        start = -1;
	      }
	    }
	  }
	  //get the longest 16-bit group of zeros
	  for (let i = 0; i < this.buffer.length; i = i + 2) {
	    if (this.buffer[i] === 0 && this.buffer[i + 1] === 0) {
	      //its a group of zeros
	      if (start < 0) {
	        start = i;
	      }

	      // at the end of the buffer, make a final call to checkLongest.
	      if(i === this.buffer.length - 2) {
	        checkLongest(i+2);
	      }
	      continue;
	    }
	    //its a group of non-zeros
	    checkLongest(i);
	  }

	  let address = '';
	  for (let h = 0; h < this.buffer.length; h = h + 2) {
	    if (h === longest.start) {
	      address += ':';
	      continue;
	    }
	    if (h < (longest.start + longest.length) && h > longest.start) {
	      //its a group of zeros
	      continue;
	    }
	    if (address.length > 0) {
	      address += ':';
	    }
	    address += ((this.buffer[h] << 8) | this.buffer[h+1]).toString(16);
	  }
	  if (address.charAt(address.length-1) === ':') {
	    address += ':';
	  }
	  return address;
	};

	/**
	 * Returns the string representation.
	 * Method used by the native JSON.stringify() to serialize this instance.
	 */
	InetAddress.prototype.toJSON = function () {
	  return this.toString();
	};

	/**
	 * Validates for a IPv4-Mapped IPv6 according to https://tools.ietf.org/html/rfc4291#section-2.5.5
	 * @private
	 * @param {Buffer} buffer
	 */
	function isValidIPv4Mapped(buffer) {
	  // check the form
	  // |      80 bits   | 16 |   32 bits
	  // +----------------+----+-------------
	  // |0000........0000|FFFF| IPv4 address

	  for (let i = 0; i < buffer.length - 6; i++) {
	    if (buffer[i] !== 0) {
	      return false;
	    }
	  }
	  return !(buffer[10] !== 255 || buffer[11] !== 255);
	}

	inetAddress = InetAddress;
	return inetAddress;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var localDate;
var hasRequiredLocalDate;

function requireLocalDate () {
	if (hasRequiredLocalDate) return localDate;
	hasRequiredLocalDate = 1;
	const util = require$$0$6;

	const utils = requireUtils$c();
	/** @module types */

	/**
	 * @private
	 * @const
	 */
	const millisecondsPerDay = 86400000;
	/**
	 * @private
	 */
	const dateCenter = Math.pow(2,31);
	/**
	 *
	 * Creates a new instance of LocalDate.
	 * @class
	 * @classdesc A date without a time-zone in the ISO-8601 calendar system, such as 2010-08-05.
	 * <p>
	 *   LocalDate is an immutable object that represents a date, often viewed as year-month-day. For example, the value "1st October 2014" can be stored in a LocalDate.
	 * </p>
	 * <p>
	 *   This class does not store or represent a time or time-zone. Instead, it is a description of the date, as used for birthdays. It cannot represent an instant on the time-line without additional information such as an offset or time-zone.
	 * </p>
	 * <p>
	 *   Note that this type can represent dates in the range [-5877641-06-23; 5881580-07-17] while the ES5 date type can only represent values in the range of [-271821-04-20; 275760-09-13].
	 *   In the event that year, month, day parameters do not fall within the ES5 date range an Error will be thrown.  If you wish to represent a date outside of this range, pass a single
	 *   parameter indicating the days since epoch.  For example, -1 represents 1969-12-31.
	 * </p>
	 * @param {Number} year The year or days since epoch.  If days since epoch, month and day should not be provided.
	 * @param {Number} month Between 1 and 12 inclusive.
	 * @param {Number} day Between 1 and the number of days in the given month of the given year.
	 *
	 * @property {Date} date The date representation if falls within a range of an ES5 data type, otherwise an invalid date.
	 *
	 * @constructor
	 */
	function LocalDate(year, month, day) {
	  //implementation detail: internally uses a UTC based date
	  if (typeof year === 'number' && typeof month === 'number' && typeof day === 'number') {
	    // Use setUTCFullYear as if there is a 2 digit year, Date.UTC() assumes
	    // that is the 20th century.
	    this.date = new Date();
	    this.date.setUTCHours(0, 0, 0, 0);
	    this.date.setUTCFullYear(year, month-1, day);
	    if(isNaN(this.date.getTime())) {
	      throw new Error(util.format('%d-%d-%d does not form a valid ES5 date!',
	        year, month, day));
	    }
	  }
	  else if (typeof month === 'undefined' && typeof day === 'undefined') {
	    if (typeof year === 'number') {
	      //in days since epoch.
	      if(year < -2147483648 || year > 2147483647) {
	        throw new Error('You must provide a valid value for days since epoch (-2147483648 <= value <= 2147483647).');
	      }
	      this.date = new Date(year * millisecondsPerDay);
	    }
	  }

	  if (typeof this.date === 'undefined') {
	    throw new Error('You must provide a valid year, month and day');
	  }

	  /** 
	   * If date cannot be represented yet given a valid days since epoch, track
	   * it internally.
	   */
	  this._value = isNaN(this.date.getTime()) ? year : null;

	  /**
	   * A number representing the year.  May return NaN if cannot be represented as
	   * a Date.
	   * @type Number
	   */
	  this.year = this.date.getUTCFullYear();
	  /**
	   * A number between 1 and 12 inclusive representing the month.  May return
	   * NaN if cannot be represented as a Date.
	   * @type Number
	   */
	  this.month = this.date.getUTCMonth() + 1;
	  /**
	   * A number between 1 and the number of days in the given month of the given year (28, 29, 30, 31).
	   * May return NaN if cannot be represented as a Date.
	   * @type Number
	   */
	  this.day = this.date.getUTCDate();
	}

	/**
	 * Creates a new instance of LocalDate using the current year, month and day from the system clock in the default time-zone.
	 */
	LocalDate.now = function () {
	  return LocalDate.fromDate(new Date());
	};

	/**
	 * Creates a new instance of LocalDate using the current date from the system clock at UTC.
	 */
	LocalDate.utcNow = function () {
	  return new LocalDate(Date.now());
	};


	/**
	 * Creates a new instance of LocalDate using the year, month and day from the provided local date time.
	 * @param {Date} date
	 */
	LocalDate.fromDate = function (date) {
	  if (isNaN(date.getTime())) {
	    throw new TypeError('Invalid date: ' + date);
	  }
	  return new LocalDate(date.getFullYear(), date.getMonth() + 1, date.getDate());
	};

	/**
	 * Creates a new instance of LocalDate using the year, month and day provided in the form: yyyy-mm-dd or
	 * days since epoch (i.e. -1 for Dec 31, 1969).
	 * @param {String} value
	 */
	LocalDate.fromString = function (value) {
	  const dashCount = (value.match(/-/g) || []).length;
	  if(dashCount >= 2) {
	    let multiplier = 1;
	    if (value[0] === '-') {
	      value = value.substring(1);
	      multiplier = -1;
	    }
	    const parts = value.split('-');
	    return new LocalDate(multiplier * parseInt(parts[0], 10), parseInt(parts[1], 10), parseInt(parts[2], 10));
	  }
	  if(value.match(/^-?\d+$/)) {
	    // Parse as days since epoch.
	    return new LocalDate(parseInt(value, 10));
	  }
	  throw new Error("Invalid input '" + value + "'.");
	};

	/**
	 * Creates a new instance of LocalDate using the bytes representation.
	 * @param {Buffer} buffer
	 */
	LocalDate.fromBuffer = function (buffer) {
	  //move to unix epoch: 0.
	  return new LocalDate((buffer.readUInt32BE(0) - dateCenter));
	};

	/**
	 * Compares this LocalDate with the given one.
	 * @param {LocalDate} other date to compare against.
	 * @return {number} 0 if they are the same, 1 if the this is greater, and -1
	 * if the given one is greater.
	 */
	LocalDate.prototype.compare = function (other) {
	  const thisValue = isNaN(this.date.getTime()) ? this._value * millisecondsPerDay : this.date.getTime();
	  const otherValue = isNaN(other.date.getTime()) ? other._value * millisecondsPerDay : other.date.getTime();
	  const diff = thisValue - otherValue;
	  if (diff < 0) {
	    return -1;
	  }
	  if (diff > 0) {
	    return 1;
	  }
	  return 0;
	};

	/**
	 * Returns true if the value of the LocalDate instance and other are the same
	 * @param {LocalDate} other
	 * @returns {Boolean}
	 */
	LocalDate.prototype.equals = function (other) {
	  return ((other instanceof LocalDate)) && this.compare(other) === 0;
	};

	LocalDate.prototype.inspect = function () {
	  return this.constructor.name + ': ' + this.toString();
	};

	/**
	 * Gets the bytes representation of the instance.
	 * @returns {Buffer}
	 */
	LocalDate.prototype.toBuffer = function () {
	  //days since unix epoch
	  const daysSinceEpoch = isNaN(this.date.getTime()) ? this._value : Math.floor(this.date.getTime() / millisecondsPerDay);
	  const value = daysSinceEpoch + dateCenter;
	  const buf = utils.allocBufferUnsafe(4);
	  buf.writeUInt32BE(value, 0);
	  return buf;
	};

	/**
	 * Gets the string representation of the instance in the form: yyyy-mm-dd if
	 * the value can be parsed as a Date, otherwise days since epoch.
	 * @returns {String}
	 */
	LocalDate.prototype.toString = function () {
	  let result;
	  //if cannot be parsed as date, return days since epoch representation.
	  if (isNaN(this.date.getTime())) {
	    return this._value.toString();
	  }
	  if (this.year < 0) {
	    result = '-' + fillZeros((this.year * -1).toString(), 4);
	  }
	  else {
	    result = fillZeros(this.year.toString(), 4);
	  }
	  result += '-' + fillZeros(this.month.toString(), 2) + '-' + fillZeros(this.day.toString(), 2);
	  return result;
	};

	/**
	 * Gets the string representation of the instance in the form: yyyy-mm-dd, valid for JSON.
	 * @returns {String}
	 */
	LocalDate.prototype.toJSON = function () {
	  return this.toString();
	};

	/**
	 * @param {String} value
	 * @param {Number} amount
	 * @private
	 */
	function fillZeros(value, amount) {
	  if (value.length >= amount) {
	    return value;
	  }
	  return utils.stringRepeat('0', amount - value.length) + value;
	}

	localDate = LocalDate;
	return localDate;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var localTime;
var hasRequiredLocalTime;

function requireLocalTime () {
	if (hasRequiredLocalTime) return localTime;
	hasRequiredLocalTime = 1;
	const Long = requireUmd();
	const util = require$$0$6;
	const utils = requireUtils$c();
	/** @module types */

	/**
	 * @const
	 * @private
	 * */
	const maxNanos = Long.fromString('86399999999999');
	/**
	 * Nanoseconds in a second
	 * @const
	 * @private
	 * */
	const nanoSecInSec = Long.fromNumber(1000000000);
	/**
	 * Nanoseconds in a millisecond
	 * @const
	 * @private
	 * */
	const nanoSecInMillis = Long.fromNumber(1000000);
	/**
	 * Milliseconds in day
	 * @const
	 * @private
	 * */
	const millisInDay = 86400000;
	/**
	 *
	 * Creates a new instance of LocalTime.
	 * @class
	 * @classdesc A time without a time-zone in the ISO-8601 calendar system, such as 10:30:05.
	 * <p>
	 *   LocalTime is an immutable date-time object that represents a time, often viewed as hour-minute-second. Time is represented to nanosecond precision. For example, the value "13:45.30.123456789" can be stored in a LocalTime.
	 * </p>
	 * @param {Long} totalNanoseconds Total nanoseconds since midnight.
	 * @constructor
	 */
	function LocalTime(totalNanoseconds) {
	  if (!(totalNanoseconds instanceof Long)) {
	    throw new Error('You must specify a Long value as totalNanoseconds');
	  }
	  if (totalNanoseconds.lessThan(Long.ZERO) || totalNanoseconds.greaterThan(maxNanos)) {
	    throw new Error('Total nanoseconds out of range');
	  }
	  this.value = totalNanoseconds;
	  
	  /**
	   * Gets the hour component of the time represented by the current instance, a number from 0 to 23.
	   * @type Number
	   */
	  this.hour = this._getParts()[0];
	  /**
	   * Gets the minute component of the time represented by the current instance, a number from 0 to 59.
	   * @type Number
	   */
	  this.minute = this._getParts()[1];
	  /**
	   * Gets the second component of the time represented by the current instance, a number from 0 to 59.
	   * @type Number
	   */
	  this.second = this._getParts()[2];
	  /**
	   * Gets the nanoseconds component of the time represented by the current instance, a number from 0 to 999999999.
	   * @type Number
	   */
	  this.nanosecond = this._getParts()[3];
	}

	/**
	 * Parses an string representation and returns a new LocalDate.
	 * @param {String} value
	 * @returns {LocalTime}
	 */
	LocalTime.fromString = function (value) {
	  if (typeof value !== 'string') {
	    throw new Error('Argument type invalid: ' + util.inspect(value));
	  }
	  const parts = value.split(':');
	  let millis = parseInt(parts[0], 10) * 3600000 + parseInt(parts[1], 10) * 60000;
	  let nanos;
	  if (parts.length === 3) {
	    const secParts = parts[2].split('.');
	    millis += parseInt(secParts[0], 10) * 1000;
	    if (secParts.length === 2) {
	      nanos = secParts[1];
	      //add zeros at the end
	      nanos = nanos + utils.stringRepeat('0', 9 - nanos.length);
	    }
	  }
	  return LocalTime.fromMilliseconds(millis, parseInt(nanos, 10) || 0);
	};

	/**
	 * Uses the current local time (in milliseconds) and the nanoseconds to create a new instance of LocalTime
	 * @param {Number} [nanoseconds] A Number from 0 to 999,999, representing the time nanosecond portion.
	 * @returns {LocalTime}
	 */
	LocalTime.now = function (nanoseconds) {
	  return LocalTime.fromDate(new Date(), nanoseconds);
	};

	/**
	 * Uses the provided local time (in milliseconds) and the nanoseconds to create a new instance of LocalTime
	 * @param {Date} date Local date portion to extract the time passed since midnight.
	 * @param {Number} [nanoseconds] A Number from 0 to 999,999, representing the nanosecond time portion.
	 * @returns {LocalTime}
	 */
	LocalTime.fromDate = function (date, nanoseconds) {
	  if (!util.isDate(date)) {
	    throw new Error('Not a valid date');
	  }
	  //Use the local representation, only the milliseconds portion
	  const millis = (date.getTime() + date.getTimezoneOffset() * -60000) % millisInDay;
	  return LocalTime.fromMilliseconds(millis, nanoseconds);
	};

	/**
	 * Uses the provided local time (in milliseconds) and the nanoseconds to create a new instance of LocalTime
	 * @param {Number} milliseconds A Number from 0 to 86,399,999.
	 * @param {Number} [nanoseconds] A Number from 0 to 999,999, representing the time nanosecond portion.
	 * @returns {LocalTime}
	 */
	LocalTime.fromMilliseconds = function (milliseconds, nanoseconds) {
	  if (typeof nanoseconds !== 'number') {
	    nanoseconds = 0;
	  }
	  return new LocalTime(Long
	    .fromNumber(milliseconds)
	    .multiply(nanoSecInMillis)
	    .add(Long.fromNumber(nanoseconds)));
	};

	/**
	 * Creates a new instance of LocalTime from the bytes representation.
	 * @param {Buffer} value
	 * @returns {LocalTime}
	 */
	LocalTime.fromBuffer = function (value) {
	  if (!(value instanceof Buffer)) {
	    throw new TypeError('Expected Buffer, obtained ' + util.inspect(value));
	  }
	  return new LocalTime(new Long(value.readInt32BE(4), value.readInt32BE(0)));
	};

	/**
	 * Compares this LocalTime with the given one.
	 * @param {LocalTime} other time to compare against.
	 * @return {number} 0 if they are the same, 1 if the this is greater, and -1
	 * if the given one is greater.
	 */
	LocalTime.prototype.compare = function (other) {
	  return this.value.compare(other.value);
	};

	/**
	 * Returns true if the value of the LocalTime instance and other are the same
	 * @param {LocalTime} other
	 * @returns {Boolean}
	 */
	LocalTime.prototype.equals = function (other) {
	  return ((other instanceof LocalTime)) && this.compare(other) === 0;
	};

	/**
	 * Gets the total amount of nanoseconds since midnight for this instance.
	 * @returns {Long}
	 */
	LocalTime.prototype.getTotalNanoseconds = function () {
	  return this.value;
	};

	LocalTime.prototype.inspect = function () {
	  return this.constructor.name + ': ' + this.toString();
	};

	/**
	 * Returns a big-endian bytes representation of the instance
	 * @returns {Buffer}
	 */
	LocalTime.prototype.toBuffer = function () {
	  const buffer = utils.allocBufferUnsafe(8);
	  buffer.writeUInt32BE(this.value.getHighBitsUnsigned(), 0);
	  buffer.writeUInt32BE(this.value.getLowBitsUnsigned(), 4);
	  return buffer;
	};

	/**
	 * Returns the string representation of the instance in the form of hh:MM:ss.ns
	 * @returns {String}
	 */
	LocalTime.prototype.toString = function () {
	  return formatTime(this._getParts());
	};

	/**
	 * Gets the string representation of the instance in the form: hh:MM:ss.ns
	 * @returns {String}
	 */
	LocalTime.prototype.toJSON = function () {
	  return this.toString();
	};

	/**
	 * @returns {Array.<Number>}
	 * @ignore
	 */
	LocalTime.prototype._getParts = function () {
	  if (!this._partsCache) {
	    //hours, minutes, seconds and nanos
	    const parts = [0, 0, 0, 0];
	    const secs = this.value.div(nanoSecInSec);
	    //faster modulo
	    //total nanos
	    parts[3] = this.value.subtract(secs.multiply(nanoSecInSec)).toNumber();
	    //seconds
	    parts[2] = secs.toNumber();
	    if (parts[2] >= 60) {
	      //minutes
	      parts[1] = Math.floor(parts[2] / 60);
	      parts[2] = parts[2] % 60;
	    }
	    if (parts[1] >= 60) {
	      //hours
	      parts[0] = Math.floor(parts[1] / 60);
	      parts[1] = parts[1] % 60;
	    }
	    this._partsCache = parts;
	  }
	  return this._partsCache;
	};

	/**
	 * @param {Array.<Number>} values
	 * @private
	 */
	function formatTime(values) {
	  let result;
	  if (values[0] < 10) {
	    result = '0' + values[0] + ':';
	  }
	  else {
	    result = values[0] + ':';
	  }
	  if (values[1] < 10) {
	    result += '0' + values[1] + ':';
	  }
	  else {
	    result += values[1] + ':';
	  }
	  if (values[2] < 10) {
	    result += '0' + values[2];
	  }
	  else {
	    result += values[2];
	  }
	  if (values[3] > 0) {
	    let nanos = values[3].toString();
	    //nine digits
	    if (nanos.length < 9) {
	      nanos = utils.stringRepeat('0', 9 - nanos.length) + nanos;
	    }
	    let lastPosition;
	    for (let i = nanos.length - 1; i > 0; i--) {
	      if (nanos[i] !== '0') {
	        break;
	      }
	      lastPosition = i;
	    }
	    if (lastPosition) {
	      nanos = nanos.substring(0, lastPosition);
	    }
	    result += '.' + nanos;
	  }
	  return result;
	}

	localTime = LocalTime;
	return localTime;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var resultSet$1;
var hasRequiredResultSet$1;

function requireResultSet$1 () {
	if (hasRequiredResultSet$1) return resultSet$1;
	hasRequiredResultSet$1 = 1;

	const utils = requireUtils$c();
	const errors = requireErrors$c();

	const asyncIteratorSymbol = Symbol.asyncIterator || '@@asyncIterator';

	/** @module types */

	/**
	 * Creates a new instance of ResultSet.
	 * @class
	 * @classdesc Represents the result of a query.
	 * @param {Object} response
	 * @param {String} host
	 * @param {Object} triedHosts
	 * @param {Number} speculativeExecutions
	 * @param {Number} consistency
	 * @param {Boolean} isSchemaInAgreement
	 * @constructor
	 */
	function ResultSet(response, host, triedHosts, speculativeExecutions, consistency, isSchemaInAgreement) {
	  // if no execution was made at all, set to 0.
	  if (speculativeExecutions === -1) {
	    speculativeExecutions = 0;
	  }
	  /**
	   * Information on the execution of a successful query:
	   * @member {Object}
	   * @property {Number} achievedConsistency The consistency level that has been actually achieved by the query.
	   * @property {String} queriedHost The Cassandra host that coordinated this query.
	   * @property {Object} triedHosts Gets the associative array of host that were queried before getting a valid response,
	   * being the last host the one that replied correctly.
	   * @property {Object} speculativeExecutions The number of speculative executions (not including the first) executed before
	   * getting a valid response.
	   * @property {Uuid} traceId Identifier of the trace session.
	   * @property {Array.<string>} warnings Warning messages generated by the server when executing the query.
	   * @property {Boolean} isSchemaInAgreement Whether the cluster had reached schema agreement after the execution of
	   * this query.
	   * <p>
	   *   After a successful schema-altering query (ex: creating a table), the driver will check if
	   *   the cluster's nodes agree on the new schema version. If not, it will keep retrying for a given
	   *   delay (see <code>protocolOptions.maxSchemaAgreementWaitSeconds</code>).
	   * </p>
	   * <p>
	   *   Note that the schema agreement check is only performed for schema-altering queries For other
	   *   query types, this method will always return <code>true</code>. If this method returns <code>false</code>,
	   *   clients can call [Metadata.checkSchemaAgreement()]{@link module:metadata~Metadata#checkSchemaAgreement} later to
	   *   perform the check manually.
	   * </p>
	   */
	  this.info = {
	    queriedHost: host,
	    triedHosts: triedHosts,
	    speculativeExecutions: speculativeExecutions,
	    achievedConsistency: consistency,
	    traceId: null,
	    warnings: null,
	    customPayload: null,
	    isSchemaInAgreement
	  };

	  if (response.flags) {
	    this.info.traceId = response.flags.traceId;
	    this.info.warnings = response.flags.warnings;
	    this.info.customPayload = response.flags.customPayload;
	  }

	  /**
	   * Gets an array rows returned by the query.
	   * When the result set represents a response from a write query, this property will be <code>undefined</code>.
	   * When the read query result contains more rows than the fetch size (5000), this property will only contain the
	   * first rows up to fetch size. To obtain all the rows, you can use the built-in async iterator that will retrieve the
	   * following pages of results.
	   * @type {Array<Row>|undefined}
	   */
	  this.rows = response.rows;

	  /**
	   * Gets the row length of the result, regardless if the result has been buffered or not
	   * @type {Number|undefined}
	   */
	  this.rowLength = this.rows ? this.rows.length : response.rowLength;

	  /**
	   * Gets the columns returned in this ResultSet.
	   * @type {Array.<{name, type}>}
	   * @default null
	   */
	  this.columns = null;

	  /**
	   * A string token representing the current page state of query. It can be used in the following executions to
	   * continue paging and retrieve the remained of the result for the query.
	   * @type {String|null}
	   * @default null
	   */
	  this.pageState = null;

	  /**
	   * Method used to manually fetch the next page of results.
	   * This method is only exposed when using the {@link Client#eachRow} method and there are more rows available in
	   * following pages.
	   * @type Function
	   */
	  this.nextPage = undefined;

	  /**
	   * Method used internally to fetch the next page of results using promises.
	   * @internal
	   * @ignore
	   * @type {Function}
	   */
	  this.nextPageAsync = undefined;

	  const meta = response.meta;

	  if (meta) {
	    this.columns = meta.columns;

	    if (meta.pageState) {
	      this.pageState = meta.pageState.toString('hex');

	      // Expose rawPageState internally
	      Object.defineProperty(this, 'rawPageState', { value: meta.pageState, enumerable: false });
	    }
	  }
	}

	/**
	 * Returns the first row or null if the result rows are empty.
	 */
	ResultSet.prototype.first = function () {
	  if (this.rows && this.rows.length) {
	    return this.rows[0];
	  }
	  return null;
	};

	ResultSet.prototype.getPageState = function () {
	  // backward-compatibility
	  return this.pageState;
	};

	ResultSet.prototype.getColumns = function () {
	  // backward-compatibility
	  return this.columns;
	};

	/**
	 * When this instance is the result of a conditional update query, it returns whether it was successful.
	 * Otherwise, it returns <code>true</code>.
	 * <p>
	 *   For consistency, this method always returns <code>true</code> for non-conditional queries (although there is
	 *   no reason to call the method in that case). This is also the case for conditional DDL statements
	 *   (CREATE KEYSPACE... IF NOT EXISTS, CREATE TABLE... IF NOT EXISTS), for which the server doesn't return
	 *   information whether it was applied or not.
	 * </p>
	 */
	ResultSet.prototype.wasApplied = function () {
	  if (!this.rows || this.rows.length === 0) {
	    return true;
	  }
	  const firstRow = this.rows[0];
	  const applied = firstRow['[applied]'];
	  return typeof applied === 'boolean' ? applied : true;
	};

	/**
	 * Gets the iterator function.
	 * <p>
	 *   Retrieves the iterator of the underlying fetched rows, without causing the driver to fetch the following
	 *   result pages. For more information on result paging,
	 *   [visit the documentation]{@link http://docs.datastax.com/en/developer/nodejs-driver/latest/features/paging/}.
	 * </p>
	 * @alias module:types~ResultSet#@@iterator
	 * @see {@link module:types~ResultSet#@@asyncIterator}
	 * @example <caption>Using for...of statement</caption>
	 * const query = 'SELECT user_id, post_id, content FROM timeline WHERE user_id = ?';
	 * const result = await client.execute(query, [ id ], { prepare: true });
	 * for (const row of result) {
	 *   console.log(row['email']);
	 * }
	 * @returns {Iterator.<Row>}
	 */
	ResultSet.prototype[Symbol.iterator] = function getIterator() {
	  if (!this.rows) {
	    return utils.emptyArray[Symbol.iterator]();
	  }
	  return this.rows[Symbol.iterator]();
	};

	/**
	 * Gets the async iterator function.
	 * <p>
	 *   Retrieves the async iterator representing the entire query result, the driver will fetch the following result
	 *   pages.
	 * </p>
	 * <p>Use the async iterator when the query result might contain more rows than the <code>fetchSize</code>.</p>
	 * <p>
	 *   Note that using the async iterator will not affect the internal state of the <code>ResultSet</code> instance.
	 *   You should avoid using both <code>rows</code> property that contains the row instances of the first page of
	 *   results, and the async iterator, that will yield all the rows in the result regardless on the number of pages.
	 * </p>
	 * <p>Multiple concurrent async iterations are not supported.</p>
	 * @alias module:types~ResultSet#@@asyncIterator
	 * @example <caption>Using for await...of statement</caption>
	 * const query = 'SELECT user_id, post_id, content FROM timeline WHERE user_id = ?';
	 * const result = await client.execute(query, [ id ], { prepare: true });
	 * for await (const row of result) {
	 *   console.log(row['email']);
	 * }
	 * @returns {AsyncIterator<Row>}
	 */
	ResultSet.prototype[asyncIteratorSymbol] = function getAsyncGenerator() {
	  let index = 0;
	  let pageState = this.rawPageState;
	  let rows = this.rows;

	  if (!rows || rows.length === 0) {
	    return { next: () => Promise.resolve({ done: true }) };
	  }

	  const self = this;

	  // Async generators are not present in Node.js 8, implement it manually
	  return {
	    async next() {
	      if (index >= rows.length && pageState) {
	        if (!self.nextPageAsync) {
	          throw new errors.DriverInternalError('Property nextPageAsync should be set when pageState is defined');
	        }

	        const rs = await self.nextPageAsync(pageState);
	        rows = rs.rows;
	        index = 0;
	        pageState = rs.rawPageState;
	      }

	      if (index < rows.length) {
	        return { done: false, value: rows[index++] };
	      }

	      return { done: true };
	    }
	  };
	};

	/**
	 * Determines whether there are more pages of results.
	 * If so, the driver will initially retrieve and contain only the first page of results.
	 * To obtain all the rows, use the [AsyncIterator]{@linkcode module:types~ResultSet#@@asyncIterator}.
	 * @returns {boolean}
	 */
	ResultSet.prototype.isPaged = function() {
	  return !!this.rawPageState;
	};

	resultSet$1 = ResultSet;
	return resultSet$1;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var resultStream;
var hasRequiredResultStream;

function requireResultStream () {
	if (hasRequiredResultStream) return resultStream;
	hasRequiredResultStream = 1;

	const { Readable } = require$$0$b;
	const utils = requireUtils$c();
	const errors = requireErrors$c();
	const clientOptions = requireClientOptions();

	/** @module types */
	/**
	 * Readable stream using to yield data from a result or a field
	 */
	class ResultStream extends Readable {
	  constructor(opt) {
	    super(opt);
	    this.buffer = [];
	    this.paused = true;
	    this._cancelAllowed = false;
	    this._handlersObject = null;
	    this._highWaterMarkRows = 0;
	  }

	  _read() {
	    this.paused = false;
	    if (this.buffer.length === 0) {
	      this._readableState.reading = false;
	    }
	    while (!this.paused && this.buffer.length > 0) {
	      this.paused = !this.push(this.buffer.shift());
	    }
	    this._checkBelowHighWaterMark();
	    if (!this.paused && !this.buffer.length && this._readNext) {
	      this._readNext();
	      this._readNext = null;
	    }
	  }

	  /**
	   * Allows for throttling, helping nodejs keep the internal buffers reasonably sized.
	   * @param {function} readNext function that triggers reading the next result chunk
	   * @ignore
	   */
	  _valve(readNext) {
	    this._readNext = null;
	    if (!readNext) {
	      return;
	    }
	    if (this.paused || this.buffer.length) {
	      this._readNext = readNext;
	    }
	    else {
	      readNext();
	    }
	  }

	  add(chunk) {
	    const length = this.buffer.push(chunk);
	    this.read(0);
	    this._checkAboveHighWaterMark();
	    return length;
	  }

	  _checkAboveHighWaterMark() {
	    if (!this._handlersObject || !this._handlersObject.resumeReadingHandler) {
	      return;
	    }
	    if (this._highWaterMarkRows === 0 || this.buffer.length !== this._highWaterMarkRows) {
	      return;
	    }
	    this._handlersObject.resumeReadingHandler(false);
	  }

	  _checkBelowHighWaterMark() {
	    if (!this._handlersObject || !this._handlersObject.resumeReadingHandler) {
	      return;
	    }
	    if (this._highWaterMarkRows === 0 || this.buffer.length >= this._highWaterMarkRows) {
	      return;
	    }
	    // The consumer has dequeued below the watermark
	    this._handlersObject.resumeReadingHandler(true);
	  }

	  /**
	   * When continuous paging is enabled, allows the client to notify to the server to stop pushing further pages.
	   * <p>Note: This is not part of the public API yet.</p>
	   * @param {Function} [callback] The cancel method accepts an optional callback.
	   * @example <caption>Cancelling a continuous paging execution</caption>
	   * const stream = client.stream(query, params, { prepare: true, continuousPaging: true });
	   * // ...
	   * // Ask the server to stop pushing rows.
	   * stream.cancel();
	   * @ignore
	   */
	  cancel(callback) {
	    if (!this._cancelAllowed) {
	      const err = new Error('You can only cancel streaming executions when continuous paging is enabled');
	      if (!callback) {
	        throw err;
	      }
	      return callback(err);
	    }
	    if (!this._handlersObject) {
	      throw new errors.DriverInternalError('ResultStream cancel is allowed but the cancel options were not set');
	    }
	    callback = callback || utils.noop;
	    if (!this._handlersObject.cancelHandler) {
	      // The handler is not yet set
	      // Set the callback as a flag to identify that the cancel handler must be invoked when set
	      this._handlersObject.cancelHandler = callback;
	      return;
	    }
	    this._handlersObject.cancelHandler(callback);
	  }

	  /**
	   * Sets the pointer to the handler to be used to cancel the continuous page execution.
	   * @param options
	   * @internal
	   * @ignore
	   */
	  setHandlers(options) {
	    if (!options.continuousPaging) {
	      return;
	    }
	    this._cancelAllowed = true;
	    this._handlersObject = options;
	    this._highWaterMarkRows =
	      options.continuousPaging.highWaterMarkRows || clientOptions.continuousPageDefaultHighWaterMark;
	  }
	}

	resultStream = ResultStream;
	return resultStream;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var row;
var hasRequiredRow;

function requireRow () {
	if (hasRequiredRow) return row;
	hasRequiredRow = 1;
	/** @module types */
	/**
	 * Represents a result row
	 * @param {Array} columns
	 * @constructor
	 */
	function Row(columns) {
	  if (!columns) {
	    throw new Error('Columns not defined');
	  }
	  //Private non-enumerable properties, with double underscore to avoid interfering with column names
	  Object.defineProperty(this, '__columns', { value: columns, enumerable: false, writable: false});
	}

	/**
	 * Returns the cell value.
	 * @param {String|Number} columnName Name or index of the column
	 */
	Row.prototype.get = function (columnName) {
	  if (typeof columnName === 'number') {
	    //its an index
	    return this[this.__columns[columnName].name];
	  }
	  return this[columnName];
	};

	/**
	 * Returns an array of the values of the row
	 * @returns {Array}
	 */
	Row.prototype.values = function () {
	  const valuesArray = [];
	  this.forEach(function (val) {
	    valuesArray.push(val);
	  });
	  return valuesArray;
	};

	/**
	 * Returns an array of the column names of the row
	 * @returns {Array}
	 */
	Row.prototype.keys = function () {
	  const keysArray = [];
	  this.forEach(function (val, key) {
	    keysArray.push(key);
	  });
	  return keysArray;
	};

	/**
	 * Executes the callback for each field in the row, containing the value as first parameter followed by the columnName
	 * @param {Function} callback
	 */
	Row.prototype.forEach = function (callback) {
	  for (const columnName in this) {
	    if (!this.hasOwnProperty(columnName)) {
	      continue;
	    }
	    callback(this[columnName], columnName);
	  }
	};

	row = Row;
	return row;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var tuple;
var hasRequiredTuple;

function requireTuple () {
	if (hasRequiredTuple) return tuple;
	hasRequiredTuple = 1;

	/** @module types */

	/**
	 * Creates a new sequence of immutable objects with the parameters provided.
	 * @class
	 * @classdesc A tuple is a sequence of immutable objects.
	 * Tuples are sequences, just like [Arrays]{@link Array}. The only difference is that tuples can't be changed.
	 * <p>
	 *   As tuples can be used as a Map keys, the {@link Tuple#toString toString()} method calls toString of each element,
	 *   to try to get a unique string key.
	 * </p>
	 * @param args The sequence elements as arguments.
	 * @constructor
	 */
	function Tuple(...args) {

	  /**
	   * Immutable elements of Tuple object.
	   * @type Array
	   */
	  this.elements = args;

	  if (this.elements.length === 0) {
	    throw new TypeError('Tuple must contain at least one value');
	  }

	  /**
	   * Returns the number of the elements.
	   * @type Number
	   */
	  this.length = this.elements.length;
	}

	/**
	 * Creates a new instance of a tuple based on the Array
	 * @param {Array} elements
	 * @returns {Tuple}
	 */
	Tuple.fromArray = function (elements) {
	  // Apply the elements Array as parameters
	  return new Tuple(...elements);
	};

	/**
	 * Returns the value located at the index.
	 * @param {Number} index Element index
	 */
	Tuple.prototype.get = function (index) {
	  return this.elements[index || 0];
	};

	/**
	 * Returns the string representation of the sequence surrounded by parenthesis, ie: (1, 2).
	 * <p>
	 *   The returned value attempts to be a unique string representation of its values.
	 * </p>
	 * @returns {string}
	 */
	Tuple.prototype.toString = function () {
	  return ('(' +
	    this.elements.reduce(function (prev, x, i) {
	      return prev + (i > 0 ? ',' : '') + x.toString();
	    }, '') +
	    ')');
	};

	/**
	 * Returns the Array representation of the sequence.
	 * @returns {Array}
	 */
	Tuple.prototype.toJSON = function () {
	  return this.elements;
	};

	/**
	 * Gets the elements as an array
	 * @returns {Array}
	 */
	Tuple.prototype.values = function () {
	  // Clone the elements
	  return this.elements.slice(0);
	};

	tuple = Tuple;
	return tuple;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredTypes$2;

function requireTypes$2 () {
	if (hasRequiredTypes$2) return types$9;
	hasRequiredTypes$2 = 1;
	const util = require$$0$6;

	const errors = requireErrors$c();
	const TimeUuid = requireTimeUuid();
	const Uuid = requireUuid();
	const protocolVersion = requireProtocolVersion();
	const utils = requireUtils$c();

	/** @module types */
	/**
	 * Long constructor, wrapper of the internal library used: {@link https://github.com/dcodeIO/long.js Long.js}.
	 * @constructor
	 */
	const Long = requireUmd();

	/**
	 * Consistency levels
	 * @type {Object}
	 * @property {Number} any Writing: A write must be written to at least one node. If all replica nodes for the given row key are down, the write can still succeed after a hinted handoff has been written. If all replica nodes are down at write time, an ANY write is not readable until the replica nodes for that row have recovered.
	 * @property {Number} one Returns a response from the closest replica, as determined by the snitch.
	 * @property {Number} two Returns the most recent data from two of the closest replicas.
	 * @property {Number} three Returns the most recent data from three of the closest replicas.
	 * @property {Number} quorum Reading: Returns the record with the most recent timestamp after a quorum of replicas has responded regardless of data center. Writing: A write must be written to the commit log and memory table on a quorum of replica nodes.
	 * @property {Number} all Reading: Returns the record with the most recent timestamp after all replicas have responded. The read operation will fail if a replica does not respond. Writing: A write must be written to the commit log and memory table on all replica nodes in the cluster for that row.
	 * @property {Number} localQuorum Reading: Returns the record with the most recent timestamp once a quorum of replicas in the current data center as the coordinator node has reported. Writing: A write must be written to the commit log and memory table on a quorum of replica nodes in the same data center as the coordinator node. Avoids latency of inter-data center communication.
	 * @property {Number} eachQuorum Reading: Returns the record once a quorum of replicas in each data center of the cluster has responded. Writing: Strong consistency. A write must be written to the commit log and memtable on a quorum of replica nodes in all data centers.
	 * @property {Number} serial Achieves linearizable consistency for lightweight transactions by preventing unconditional updates.
	 * @property {Number} localSerial Same as serial but confined to the data center. A write must be written conditionally to the commit log and memtable on a quorum of replica nodes in the same data center.
	 * @property {Number} localOne Similar to One but only within the DC the coordinator is in.
	 */
	const consistencies = {
	  any:          0x00,
	  one:          0x01,
	  two:          0x02,
	  three:        0x03,
	  quorum:       0x04,
	  all:          0x05,
	  localQuorum:  0x06,
	  eachQuorum:   0x07,
	  serial:       0x08,
	  localSerial:  0x09,
	  localOne:     0x0a
	};

	/**
	 * Mapping of consistency level codes to their string representation.
	 * @type {Object}
	 */
	const consistencyToString = {};
	consistencyToString[consistencies.any] = 'ANY';
	consistencyToString[consistencies.one] = 'ONE';
	consistencyToString[consistencies.two] = 'TWO';
	consistencyToString[consistencies.three] = 'THREE';
	consistencyToString[consistencies.quorum] = 'QUORUM';
	consistencyToString[consistencies.all] = 'ALL';
	consistencyToString[consistencies.localQuorum] = 'LOCAL_QUORUM';
	consistencyToString[consistencies.eachQuorum] = 'EACH_QUORUM';
	consistencyToString[consistencies.serial] = 'SERIAL';
	consistencyToString[consistencies.localSerial] = 'LOCAL_SERIAL';
	consistencyToString[consistencies.localOne] = 'LOCAL_ONE';

	/**
	 * CQL data types
	 * @type {Object}
	 * @property {Number} custom A custom type.
	 * @property {Number} ascii ASCII character string.
	 * @property {Number} bigint 64-bit signed long.
	 * @property {Number} blob Arbitrary bytes (no validation).
	 * @property {Number} boolean true or false.
	 * @property {Number} counter Counter column (64-bit signed value).
	 * @property {Number} decimal Variable-precision decimal.
	 * @property {Number} double 64-bit IEEE-754 floating point.
	 * @property {Number} float 32-bit IEEE-754 floating point.
	 * @property {Number} int 32-bit signed integer.
	 * @property {Number} text UTF8 encoded string.
	 * @property {Number} timestamp A timestamp.
	 * @property {Number} uuid Type 1 or type 4 UUID.
	 * @property {Number} varchar UTF8 encoded string.
	 * @property {Number} varint Arbitrary-precision integer.
	 * @property {Number} timeuuid  Type 1 UUID.
	 * @property {Number} inet An IP address. It can be either 4 bytes long (IPv4) or 16 bytes long (IPv6).
	 * @property {Number} date A date without a time-zone in the ISO-8601 calendar system.
	 * @property {Number} time A value representing the time portion of the day.
	 * @property {Number} smallint 16-bit two's complement integer.
	 * @property {Number} tinyint 8-bit two's complement integer.
	 * @property {Number} list A collection of elements.
	 * @property {Number} map Key/value pairs.
	 * @property {Number} set A collection that contains no duplicate elements.
	 * @property {Number} udt User-defined type.
	 * @property {Number} tuple A sequence of values.
	 */
	const dataTypes = {
	  custom:     0x0000,
	  ascii:      0x0001,
	  bigint:     0x0002,
	  blob:       0x0003,
	  boolean:    0x0004,
	  counter:    0x0005,
	  decimal:    0x0006,
	  double:     0x0007,
	  float:      0x0008,
	  int:        0x0009,
	  text:       0x000a,
	  timestamp:  0x000b,
	  uuid:       0x000c,
	  varchar:    0x000d,
	  varint:     0x000e,
	  timeuuid:   0x000f,
	  inet:       0x0010,
	  date:       0x0011,
	  time:       0x0012,
	  smallint:   0x0013,
	  tinyint:    0x0014,
	  duration:   0x0015,
	  list:       0x0020,
	  map:        0x0021,
	  set:        0x0022,
	  udt:        0x0030,
	  tuple:      0x0031,
	  /**
	   * Returns the typeInfo of a given type name
	   * @param name
	   * @returns {{code: number, info: *|Object}}
	   */
	  getByName:  function(name) {
	    name = name.toLowerCase();
	    if (name.indexOf('<') > 0) {
	      const listMatches = /^(list|set)<(.+)>$/.exec(name);
	      if (listMatches) {
	        return { code: this[listMatches[1]], info: this.getByName(listMatches[2])};
	      }
	      const mapMatches = /^(map)< *(.+) *, *(.+)>$/.exec(name);
	      if (mapMatches) {
	        return { code: this[mapMatches[1]], info: [this.getByName(mapMatches[2]), this.getByName(mapMatches[3])]};
	      }
	      const udtMatches = /^(udt)<(.+)>$/.exec(name);
	      if (udtMatches) {
	        //udt name as raw string
	        return { code: this[udtMatches[1]], info: udtMatches[2]};
	      }
	      const tupleMatches = /^(tuple)<(.+)>$/.exec(name);
	      if (tupleMatches) {
	        //tuple info as an array of types
	        return { code: this[tupleMatches[1]], info: tupleMatches[2].split(',').map(function (x) {
	          return this.getByName(x.trim());
	        }, this)};
	      }
	    }
	    const typeInfo = { code: this[name], info: null};
	    if (typeof typeInfo.code !== 'number') {
	      throw new TypeError('Data type with name ' + name + ' not valid');
	    }
	    return typeInfo;
	  }
	};

	/**
	 * Map of Data types by code
	 * @internal
	 * @private
	 */
	const _dataTypesByCode = (function () {
	  const result = {};
	  for (const key in dataTypes) {
	    if (!dataTypes.hasOwnProperty(key)) {
	      continue;
	    }
	    const val = dataTypes[key];
	    if (typeof val !== 'number') {
	      continue;
	    }
	    result[val] = key;
	  }
	  return result;
	})();

	/**
	 * Represents the distance of Cassandra node as assigned by a LoadBalancingPolicy relatively to the driver instance.
	 * @type {Object}
	 * @property {Number} local A local node.
	 * @property {Number} remote A remote node.
	 * @property {Number} ignored A node that is meant to be ignored.
	 */
	const distance = {
	  local:    0,
	  remote:   1,
	  ignored:  2
	};

	/**
	 * An integer byte that distinguish the actual message from and to Cassandra
	 * @internal
	 * @ignore
	 */
	const opcodes = {
	  error:          0x00,
	  startup:        0x01,
	  ready:          0x02,
	  authenticate:   0x03,
	  credentials:    0x04,
	  options:        0x05,
	  supported:      0x06,
	  query:          0x07,
	  result:         0x08,
	  prepare:        0x09,
	  execute:        0x0a,
	  register:       0x0b,
	  event:          0x0c,
	  batch:          0x0d,
	  authChallenge:  0x0e,
	  authResponse:   0x0f,
	  authSuccess:    0x10,
	  cancel:         0xff,

	  /**
	   * Determines if the code is a valid opcode
	   */
	  isInRange: function (code) {
	    return code > this.error && code > this.event;
	  }
	};

	/**
	 * Event types from Cassandra
	 * @type {{topologyChange: string, statusChange: string, schemaChange: string}}
	 * @internal
	 * @ignore
	 */
	const protocolEvents = {
	  topologyChange: 'TOPOLOGY_CHANGE',
	  statusChange: 'STATUS_CHANGE',
	  schemaChange: 'SCHEMA_CHANGE'
	};

	/**
	 * Server error codes returned by Cassandra
	 * @type {Object}
	 * @property {Number} serverError Something unexpected happened.
	 * @property {Number} protocolError Some client message triggered a protocol violation.
	 * @property {Number} badCredentials Authentication was required and failed.
	 * @property {Number} unavailableException Raised when coordinator knows there is not enough replicas alive to perform a query with the requested consistency level.
	 * @property {Number} overloaded The request cannot be processed because the coordinator is overloaded.
	 * @property {Number} isBootstrapping The request was a read request but the coordinator node is bootstrapping.
	 * @property {Number} truncateError Error encountered during a truncate request.
	 * @property {Number} writeTimeout Timeout encountered on write query on coordinator waiting for response(s) from replicas.
	 * @property {Number} readTimeout Timeout encountered on read query on coordinator waitign for response(s) from replicas.
	 * @property {Number} readFailure A non-timeout error encountered during a read request.
	 * @property {Number} functionFailure A (user defined) function encountered during execution.
	 * @property {Number} writeFailure A non-timeout error encountered during a write request.
	 * @property {Number} syntaxError The submitted query has a syntax error.
	 * @property {Number} unauthorized The logged user doesn't have the right to perform the query.
	 * @property {Number} invalid The query is syntactically correct but invalid.
	 * @property {Number} configError The query is invalid because of some configuration issue.
	 * @property {Number} alreadyExists The query attempted to create a schema element (i.e. keyspace, table) that already exists.
	 * @property {Number} unprepared Can be thrown while a prepared statement tries to be executed if the provided statement is not known by the coordinator.
	 */
	const responseErrorCodes = {
	  serverError:            0x0000,
	  protocolError:          0x000A,
	  badCredentials:         0x0100,
	  unavailableException:   0x1000,
	  overloaded:             0x1001,
	  isBootstrapping:        0x1002,
	  truncateError:          0x1003,
	  writeTimeout:           0x1100,
	  readTimeout:            0x1200,
	  readFailure:            0x1300,
	  functionFailure:        0x1400,
	  writeFailure:           0x1500,
	  syntaxError:            0x2000,
	  unauthorized:           0x2100,
	  invalid:                0x2200,
	  configError:            0x2300,
	  alreadyExists:          0x2400,
	  unprepared:             0x2500,
	  clientWriteFailure:     0x8000,
	};

	/**
	 * Type of result included in a response
	 * @internal
	 * @ignore
	 */
	const resultKind = {
	  voidResult:      0x0001,
	  rows:            0x0002,
	  setKeyspace:     0x0003,
	  prepared:        0x0004,
	  schemaChange:    0x0005
	};

	/**
	 * Message frame flags
	 * @internal
	 * @ignore
	 */
	const frameFlags = {
	  compression:    0x01,
	  tracing:        0x02,
	  customPayload:  0x04,
	  warning:        0x08
	};

	/**
	 * Unset representation.
	 * <p>
	 *   Use this field if you want to set a parameter to <code>unset</code>. Valid for Cassandra 2.2 and above.
	 * </p>
	 */
	const unset = Object.freeze({'unset': true});

	/**
	 * A long representing the value 1000
	 * @const
	 * @private
	 */
	const _longOneThousand = Long.fromInt(1000);

	/**
	 * Counter used to generate up to 1000 different timestamp values with the same Date
	 * @private
	 */
	let _timestampTicks = 0;

	/**
	 * <p><strong>Backward compatibility only, use [TimeUuid]{@link module:types~TimeUuid} instead</strong>.</p>
	 * Generates and returns a RFC4122 v1 (timestamp based) UUID in a string representation.
	 * @param {{msecs, node, clockseq, nsecs}} [options]
	 * @param {Buffer} [buffer]
	 * @param {Number} [offset]
	 * @deprecated Use [TimeUuid]{@link module:types~TimeUuid} instead
	 */
	function timeuuid(options, buffer, offset) {
	  let date;
	  let ticks;
	  let nodeId;
	  let clockId;
	  if (options) {
	    if (typeof options.msecs === 'number') {
	      date = new Date(options.msecs);
	    }
	    if (options.msecs instanceof Date) {
	      date = options.msecs;
	    }
	    if (Array.isArray(options.node)) {
	      nodeId = utils.allocBufferFromArray(options.node);
	    }
	    if (typeof options.clockseq === 'number') {
	      clockId = utils.allocBufferUnsafe(2);
	      clockId.writeUInt16BE(options.clockseq, 0);
	    }
	    if (typeof options.nsecs === 'number') {
	      ticks = options.nsecs;
	    }
	  }
	  const uuid = new TimeUuid(date, ticks, nodeId, clockId);
	  if (buffer instanceof Buffer) {
	    //copy the values into the buffer
	    uuid.getBuffer().copy(buffer, offset || 0);
	    return buffer;
	  }
	  return uuid.toString();
	}

	/**
	 * <p><strong>Backward compatibility only, use [Uuid]{@link module:types~Uuid} class instead</strong>.</p>
	 * Generate and return a RFC4122 v4 UUID in a string representation.
	 * @deprecated Use [Uuid]{@link module:types~Uuid} class instead
	 */
	function uuid(options, buffer, offset) {
	  let uuid;
	  if (options) {
	    if (Array.isArray(options.random)) {
	      uuid = new Uuid(utils.allocBufferFromArray(options.random));
	    }
	  }
	  if (!uuid) {
	    uuid = Uuid.random();
	  }
	  if (buffer instanceof Buffer) {
	    //copy the values into the buffer
	    uuid.getBuffer().copy(buffer, offset || 0);
	    return buffer;
	  }
	  return uuid.toString();
	}

	/**
	 * Gets the data type name for a given type definition
	 * @internal
	 * @ignore
	 * @throws {ArgumentError}
	 */
	function getDataTypeNameByCode(item) {
	  if (!item || typeof item.code !== 'number') {
	    throw new errors.ArgumentError('Invalid signature type definition');
	  }
	  const typeName = _dataTypesByCode[item.code];
	  if (!typeName) {
	    throw new errors.ArgumentError(util.format('Type with code %d not found', item.code));
	  }
	  if (!item.info) {
	    return typeName;
	  }
	  if (Array.isArray(item.info)) {
	    return (typeName +
	      '<' +
	      item.info.map(function (t) {
	        return getDataTypeNameByCode(t);
	      }).join(', ') +
	      '>');
	  }
	  if (typeof item.info.code === 'number') {
	    return typeName + '<' + getDataTypeNameByCode(item.info) + '>';
	  }
	  return typeName;
	}

	//classes

	/**
	 * Represents a frame header that could be used to read from a Buffer or to write to a Buffer
	 * @ignore
	 * @param {Number} version Protocol version
	 * @param {Number} flags
	 * @param {Number} streamId
	 * @param {Number} opcode
	 * @param {Number} bodyLength
	 * @constructor
	 */
	function FrameHeader(version, flags, streamId, opcode, bodyLength) {
	  this.version = version;
	  this.flags = flags;
	  this.streamId = streamId;
	  this.opcode = opcode;
	  this.bodyLength = bodyLength;
	}

	/**
	 * The length of the header of the frame based on the protocol version
	 * @returns {Number}
	 */
	FrameHeader.size = function (version) {
	  if (protocolVersion.uses2BytesStreamIds(version)) {
	    return 9;
	  }
	  return 8;
	};

	/**
	 * Gets the protocol version based on the first byte of the header
	 * @param {Buffer} buffer
	 * @returns {Number}
	 */
	FrameHeader.getProtocolVersion = function (buffer) {
	  return buffer[0] & 0x7F;
	};

	/**
	 * @param {Buffer} buf
	 * @param {Number} [offset]
	 * @returns {FrameHeader}
	 */
	FrameHeader.fromBuffer = function (buf, offset) {
	  let streamId = 0;
	  if (!offset) {
	    offset = 0;
	  }
	  const version = buf[offset++] & 0x7F;
	  const flags = buf.readUInt8(offset++);
	  if (!protocolVersion.uses2BytesStreamIds(version)) {
	    streamId = buf.readInt8(offset++);
	  }
	  else {
	    streamId = buf.readInt16BE(offset);
	    offset += 2;
	  }
	  return new FrameHeader(version, flags, streamId, buf.readUInt8(offset++), buf.readUInt32BE(offset));
	};

	/** @returns {Buffer} */
	FrameHeader.prototype.toBuffer = function () {
	  const buf = utils.allocBufferUnsafe(FrameHeader.size(this.version));
	  buf.writeUInt8(this.version, 0);
	  buf.writeUInt8(this.flags, 1);
	  let offset = 3;
	  if (!protocolVersion.uses2BytesStreamIds(this.version)) {
	    buf.writeInt8(this.streamId, 2);
	  }
	  else {
	    buf.writeInt16BE(this.streamId, 2);
	    offset = 4;
	  }
	  buf.writeUInt8(this.opcode, offset++);
	  buf.writeUInt32BE(this.bodyLength, offset);
	  return buf;
	};
	/**
	 * Returns a long representation.
	 * Used internally for deserialization
	 */
	Long.fromBuffer = function (value) {
	  if (!(value instanceof Buffer)) {
	    throw new TypeError('Expected Buffer, obtained ' + util.inspect(value));
	  }
	  return new Long(value.readInt32BE(4), value.readInt32BE(0));
	};

	/**
	 * Returns a big-endian buffer representation of the Long instance
	 * @param {Long} value
	 */
	Long.toBuffer = function (value) {
	  if (!(value instanceof Long)) {
	    throw new TypeError('Expected Long, obtained ' + util.inspect(value));
	  }
	  const buffer = utils.allocBufferUnsafe(8);
	  buffer.writeUInt32BE(value.getHighBitsUnsigned(), 0);
	  buffer.writeUInt32BE(value.getLowBitsUnsigned(), 4);
	  return buffer;
	};

	/**
	 * Provide the name of the constructor and the string representation
	 * @returns {string}
	 */
	Long.prototype.inspect = function () {
	  return 'Long: ' + this.toString();
	};

	/**
	 * Returns the string representation.
	 * Method used by the native JSON.stringify() to serialize this instance
	 */
	Long.prototype.toJSON = function () {
	  return this.toString();
	};

	/**
	 * Generates a value representing the timestamp for the query in microseconds based on the date and the microseconds provided
	 * @param {Date} [date] The date to generate the value, if not provided it will use the current date.
	 * @param {Number} [microseconds] A number from 0 to 999 used to build the microseconds part of the date.
	 * @returns {Long}
	 */
	function generateTimestamp(date, microseconds) {
	  if (!date) {
	    date = new Date();
	  }
	  let longMicro = Long.ZERO;
	  if (typeof microseconds === 'number' && microseconds >= 0 && microseconds < 1000) {
	    longMicro = Long.fromInt(microseconds);
	  }
	  else {
	    if (_timestampTicks > 999) {
	      _timestampTicks = 0;
	    }
	    longMicro = Long.fromInt(_timestampTicks);
	    _timestampTicks++;
	  }
	  return Long
	    .fromNumber(date.getTime())
	    .multiply(_longOneThousand)
	    .add(longMicro);
	}

	//error classes

	/** @private */
	function QueryParserError(e) {
	  QueryParserError.super_.call(this, e.message, this.constructor);
	  this.internalError = e;
	}
	util.inherits(QueryParserError, errors.DriverError);

	/** @private */
	function TimeoutError (message) {
	  TimeoutError.super_.call(this, message, this.constructor);
	  this.info = 'Represents an error that happens when the maximum amount of time for an operation passed.';
	}
	util.inherits(TimeoutError, errors.DriverError);

	types$9.opcodes = opcodes;
	types$9.consistencies = consistencies;
	types$9.consistencyToString = consistencyToString;
	types$9.dataTypes = dataTypes;
	types$9.getDataTypeNameByCode = getDataTypeNameByCode;
	types$9.distance = distance;
	types$9.frameFlags = frameFlags;
	types$9.protocolEvents = protocolEvents;
	types$9.protocolVersion = protocolVersion;
	types$9.responseErrorCodes = responseErrorCodes;
	types$9.resultKind = resultKind;
	types$9.timeuuid = timeuuid;
	types$9.uuid = uuid;
	types$9.BigDecimal = requireBigDecimal();
	types$9.Duration = requireDuration();
	types$9.FrameHeader = FrameHeader;
	types$9.InetAddress = requireInetAddress();
	types$9.Integer = requireInteger();
	types$9.LocalDate = requireLocalDate();
	types$9.LocalTime = requireLocalTime();
	types$9.Long = Long;
	types$9.ResultSet = requireResultSet$1();
	types$9.ResultStream = requireResultStream();
	types$9.Row = requireRow();
	//export DriverError for backward-compatibility
	types$9.DriverError = errors.DriverError;
	types$9.TimeoutError = TimeoutError;
	types$9.TimeUuid = TimeUuid;
	types$9.Tuple = requireTuple();
	types$9.Uuid = Uuid;
	types$9.unset = unset;
	types$9.generateTimestamp = generateTimestamp;
	return types$9;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var loadBalancing;
var hasRequiredLoadBalancing;

function requireLoadBalancing () {
	if (hasRequiredLoadBalancing) return loadBalancing;
	hasRequiredLoadBalancing = 1;

	const util = require$$0$6;
	const types = requireTypes$2();
	const utils = requireUtils$c();
	const errors = requireErrors$c();

	const doneIteratorObject = Object.freeze({ done: true });
	const newlyUpInterval = 60000;

	/** @module policies/loadBalancing */
	/**
	 * Base class for Load Balancing Policies
	 * @constructor
	 */
	function LoadBalancingPolicy() {

	}

	/**
	 * Initializes the load balancing policy, called after the driver obtained the information of the cluster.
	 * @param {Client} client
	 * @param {HostMap} hosts
	 * @param {Function} callback
	 */
	LoadBalancingPolicy.prototype.init = function (client, hosts, callback) {
	  this.client = client;
	  this.hosts = hosts;
	  callback();
	};

	/**
	 * Returns the distance assigned by this policy to the provided host.
	 * @param {Host} host
	 */
	LoadBalancingPolicy.prototype.getDistance = function (host) {
	  return types.distance.local;
	};

	/**
	 * Returns an iterator with the hosts for a new query.
	 * Each new query will call this method. The first host in the result will
	 * then be used to perform the query.
	 * @param {String} keyspace Name of currently logged keyspace at <code>Client</code> level.
	 * @param {ExecutionOptions|null} executionOptions The information related to the execution of the request.
	 * @param {Function} callback The function to be invoked with the error as first parameter and the host iterator as
	 * second parameter.
	 */
	LoadBalancingPolicy.prototype.newQueryPlan = function (keyspace, executionOptions, callback) {
	  callback(new Error('You must implement a query plan for the LoadBalancingPolicy class'));
	};

	/**
	 * Gets an associative array containing the policy options.
	 */
	LoadBalancingPolicy.prototype.getOptions = function () {
	  return new Map();
	};

	/**
	 * This policy yield nodes in a round-robin fashion.
	 * @extends LoadBalancingPolicy
	 * @constructor
	 */
	function RoundRobinPolicy() {
	  this.index = 0;
	}

	util.inherits(RoundRobinPolicy, LoadBalancingPolicy);

	/**
	 * Returns an iterator with the hosts to be used as coordinator for a query.
	 * @param {String} keyspace Name of currently logged keyspace at <code>Client</code> level.
	 * @param {ExecutionOptions|null} executionOptions The information related to the execution of the request.
	 * @param {Function} callback The function to be invoked with the error as first parameter and the host iterator as
	 * second parameter.
	 */
	RoundRobinPolicy.prototype.newQueryPlan = function (keyspace, executionOptions, callback) {
	  if (!this.hosts) {
	    return callback(new Error('Load balancing policy not initialized'));
	  }
	  const hosts = this.hosts.values();
	  const self = this;
	  let counter = 0;

	  let planIndex = self.index % hosts.length;
	  self.index += 1;
	  if (self.index >= utils.maxInt) {
	    self.index = 0;
	  }

	  callback(null, {
	    next: function () {
	      if (++counter > hosts.length) {
	        return doneIteratorObject;
	      }
	      return {value: hosts[planIndex++ % hosts.length], done: false};
	    }
	  });
	};

	/**
	 * A data-center aware Round-robin load balancing policy.
	 * This policy provides round-robin queries over the nodes of the local
	 * data center.
	 * @param {?String} [localDc] local datacenter name.  This value overrides the 'localDataCenter' Client option \
	 * and is useful for cases where you have multiple execution profiles that you intend on using for routing
	 * requests to different data centers.
	 * @extends {LoadBalancingPolicy}
	 * @constructor
	 */
	function DCAwareRoundRobinPolicy(localDc) {
	  this.localDc = localDc;
	  this.index = 0;
	  /** @type {Array} */
	  this.localHostsArray = null;
	}

	util.inherits(DCAwareRoundRobinPolicy, LoadBalancingPolicy);

	/**
	 * Initializes the load balancing policy.
	 * @param {Client} client
	 * @param {HostMap} hosts
	 * @param {Function} callback
	 */
	DCAwareRoundRobinPolicy.prototype.init = function (client, hosts, callback) {
	  this.client = client;
	  this.hosts = hosts;
	  hosts.on('add', this._cleanHostCache.bind(this));
	  hosts.on('remove', this._cleanHostCache.bind(this));

	  try {
	    setLocalDc(this, client, this.hosts);
	  } catch (err) {
	    return callback(err);
	  }

	  callback();
	};

	/**
	 * Returns the distance depending on the datacenter.
	 * @param {Host} host
	 */
	DCAwareRoundRobinPolicy.prototype.getDistance = function (host) {
	  if (host.datacenter === this.localDc) {
	    return types.distance.local;
	  }

	  return types.distance.ignored;
	};

	DCAwareRoundRobinPolicy.prototype._cleanHostCache = function () {
	  this.localHostsArray = null;
	};

	DCAwareRoundRobinPolicy.prototype._resolveLocalHosts = function() {
	  const hosts = this.hosts.values();
	  if (this.localHostsArray) {
	    //there were already calculated
	    return;
	  }
	  this.localHostsArray = [];
	  hosts.forEach(function (h) {
	    if (!h.datacenter) {
	      //not a remote dc node
	      return;
	    }
	    if (h.datacenter === this.localDc) {
	      this.localHostsArray.push(h);
	    }
	  }, this);
	};

	/**
	 * It returns an iterator that yields local nodes.
	 * @param {String} keyspace Name of currently logged keyspace at <code>Client</code> level.
	 * @param {ExecutionOptions|null} executionOptions The information related to the execution of the request.
	 * @param {Function} callback The function to be invoked with the error as first parameter and the host iterator as
	 * second parameter.
	 */
	DCAwareRoundRobinPolicy.prototype.newQueryPlan = function (keyspace, executionOptions, callback) {
	  if (!this.hosts) {
	    return callback(new Error('Load balancing policy not initialized'));
	  }
	  this.index += 1;
	  if (this.index >= utils.maxInt) {
	    this.index = 0;
	  }
	  this._resolveLocalHosts();
	  // Use a local reference of hosts
	  const localHostsArray = this.localHostsArray;
	  let planLocalIndex = this.index;
	  let counter = 0;
	  callback(null, {
	    next: function () {
	      let host;
	      if (counter++ < localHostsArray.length) {
	        host = localHostsArray[planLocalIndex++ % localHostsArray.length];
	        return { value: host, done: false };
	      }
	      return doneIteratorObject;
	    }
	  });
	};

	/**
	 * Gets an associative array containing the policy options.
	 */
	DCAwareRoundRobinPolicy.prototype.getOptions = function () {
	  return new Map([
	    ['localDataCenter', this.localDc ]
	  ]);
	};

	/**
	 * A wrapper load balancing policy that add token awareness to a child policy.
	 * @param {LoadBalancingPolicy} childPolicy
	 * @extends LoadBalancingPolicy
	 * @constructor
	 */
	function TokenAwarePolicy (childPolicy) {
	  if (!childPolicy) {
	    throw new Error("You must specify a child load balancing policy");
	  }
	  this.childPolicy = childPolicy;
	}

	util.inherits(TokenAwarePolicy, LoadBalancingPolicy);

	TokenAwarePolicy.prototype.init = function (client, hosts, callback) {
	  this.client = client;
	  this.hosts = hosts;
	  this.childPolicy.init(client, hosts, callback);
	};

	TokenAwarePolicy.prototype.getDistance = function (host) {
	  return this.childPolicy.getDistance(host);
	};

	/**
	 * Returns the hosts to use for a new query.
	 * The returned plan will return local replicas first, if replicas can be determined, followed by the plan of the
	 * child policy.
	 * @param {String} keyspace Name of currently logged keyspace at <code>Client</code> level.
	 * @param {ExecutionOptions|null} executionOptions The information related to the execution of the request.
	 * @param {Function} callback The function to be invoked with the error as first parameter and the host iterator as
	 * second parameter.
	 */
	TokenAwarePolicy.prototype.newQueryPlan = function (keyspace, executionOptions, callback) {
	  let routingKey;
	  if (executionOptions) {
	    routingKey = executionOptions.getRoutingKey();
	    if (executionOptions.getKeyspace()) {
	      keyspace = executionOptions.getKeyspace();
	    }
	  }
	  let replicas;
	  if (routingKey) {
	    replicas = this.client.getReplicas(keyspace, routingKey);
	  }
	  if (!routingKey || !replicas) {
	    return this.childPolicy.newQueryPlan(keyspace, executionOptions, callback);
	  }
	  const iterator = new TokenAwareIterator(keyspace, executionOptions, replicas, this.childPolicy);
	  iterator.iterate(callback);
	};

	/**
	 * An iterator that holds the context for the subsequent next() calls
	 * @param {String} keyspace
	 * @param {ExecutionOptions} execOptions
	 * @param {Array} replicas
	 * @param childPolicy
	 * @constructor
	 * @ignore
	 */
	function TokenAwareIterator(keyspace, execOptions, replicas, childPolicy) {
	  this.keyspace = keyspace;
	  this.childPolicy = childPolicy;
	  this.options = execOptions;
	  this.localReplicas = [];
	  this.replicaIndex = 0;
	  this.replicaMap = {};
	  this.childIterator = null;
	  // Memoize the local replicas
	  // The amount of local replicas should be defined before start iterating, in order to select an
	  // appropriate (pseudo random) startIndex
	  for (let i = 0; i < replicas.length; i++) {
	    const host = replicas[i];
	    if (this.childPolicy.getDistance(host) !== types.distance.local) {
	      continue;
	    }
	    this.replicaMap[host.address] = true;
	    this.localReplicas.push(host);
	  }
	  // We use a PRNG to set the replica index
	  // We only care about proportional fair scheduling between replicas of a given token
	  // Math.random() has an extremely short permutation cycle length but we don't care about collisions
	  this.startIndex = Math.floor(Math.random() * this.localReplicas.length);
	}

	TokenAwareIterator.prototype.iterate = function (callback) {
	  //Load the child policy hosts
	  const self = this;
	  this.childPolicy.newQueryPlan(this.keyspace, this.options, function (err, iterator) {
	    if (err) {
	      return callback(err);
	    }
	    //get the iterator of the child policy in case is needed
	    self.childIterator = iterator;
	    callback(null, {
	      next: function () { return self.computeNext(); }
	    });
	  });
	};

	TokenAwareIterator.prototype.computeNext = function () {
	  let host;
	  if (this.replicaIndex < this.localReplicas.length) {
	    host = this.localReplicas[(this.startIndex + (this.replicaIndex++)) % this.localReplicas.length];
	    return { value: host, done: false };
	  }
	  // Return hosts from child policy
	  let item;
	  while ((item = this.childIterator.next()) && !item.done) {
	    if (this.replicaMap[item.value.address]) {
	      // Avoid yielding local replicas from the child load balancing policy query plan
	      continue;
	    }
	    return item;
	  }
	  return doneIteratorObject;
	};

	/**
	 * Gets an associative array containing the policy options.
	 */
	TokenAwarePolicy.prototype.getOptions = function () {
	  const map = new Map([
	    ['childPolicy', this.childPolicy.constructor !== undefined ? this.childPolicy.constructor.name : null ]
	  ]);

	  if (this.childPolicy instanceof DCAwareRoundRobinPolicy) {
	    map.set('localDataCenter', this.childPolicy.localDc);
	  }

	  return map;
	};

	/**
	 * Create a new policy that wraps the provided child policy but only "allow" hosts
	 * from the provided list.
	 * @class
	 * @classdesc
	 * A load balancing policy wrapper that ensure that only hosts from a provided
	 * allow list will ever be returned.
	 * <p>
	 * This policy wraps another load balancing policy and will delegate the choice
	 * of hosts to the wrapped policy with the exception that only hosts contained
	 * in the allow list provided when constructing this policy will ever be
	 * returned. Any host not in the while list will be considered ignored
	 * and thus will not be connected to.
	 * <p>
	 * This policy can be useful to ensure that the driver only connects to a
	 * predefined set of hosts. Keep in mind however that this policy defeats
	 * somewhat the host auto-detection of the driver. As such, this policy is only
	 * useful in a few special cases or for testing, but is not optimal in general.
	 * If all you want to do is limiting connections to hosts of the local
	 * data-center then you should use DCAwareRoundRobinPolicy and *not* this policy
	 * in particular.
	 * @param {LoadBalancingPolicy} childPolicy the wrapped policy.
	 * @param {Array.<string>}  allowList The hosts address in the format ipAddress:port.
	 * Only hosts from this list may get connected
	 * to (whether they will get connected to or not depends on the child policy).
	 * @extends LoadBalancingPolicy
	 * @constructor
	 */
	function AllowListPolicy (childPolicy, allowList) {
	  if (!childPolicy) {
	    throw new Error("You must specify a child load balancing policy");
	  }
	  if (!Array.isArray(allowList)) {
	    throw new Error("You must provide the list of allowed host addresses");
	  }

	  this.childPolicy = childPolicy;
	  this.allowList = new Map(allowList.map(address => [ address, true ]));
	}

	util.inherits(AllowListPolicy, LoadBalancingPolicy);

	AllowListPolicy.prototype.init = function (client, hosts, callback) {
	  this.childPolicy.init(client, hosts, callback);
	};

	/**
	 * Uses the child policy to return the distance to the host if included in the allow list.
	 * Any host not in the while list will be considered ignored.
	 * @param host
	 */
	AllowListPolicy.prototype.getDistance = function (host) {
	  if (!this._contains(host)) {
	    return types.distance.ignored;
	  }
	  return this.childPolicy.getDistance(host);
	};

	/**
	 * @param {Host} host
	 * @returns {boolean}
	 * @private
	 */
	AllowListPolicy.prototype._contains = function (host) {
	  return !!this.allowList.get(host.address);
	};

	/**
	 * Returns the hosts to use for a new query filtered by the allow list.
	 */
	AllowListPolicy.prototype.newQueryPlan = function (keyspace, info, callback) {
	  const self = this;
	  this.childPolicy.newQueryPlan(keyspace, info, function (err, iterator) {
	    if (err) {
	      return callback(err);
	    }
	    callback(null, self._filter(iterator));
	  });
	};

	AllowListPolicy.prototype._filter = function (childIterator) {
	  const self = this;
	  return {
	    next: function () {
	      const item = childIterator.next();
	      if (!item.done && !self._contains(item.value)) {
	        return this.next();
	      }
	      return item;
	    }
	  };
	};

	/**
	 * Gets an associative array containing the policy options.
	 */
	AllowListPolicy.prototype.getOptions = function () {
	  return new Map([
	    ['childPolicy', this.childPolicy.constructor !== undefined ? this.childPolicy.constructor.name : null ],
	    ['allowList', Array.from(this.allowList.keys())]
	  ]);
	};

	/**
	 * Creates a new instance of the policy.
	 * @classdesc
	 * Exposed for backward-compatibility only, it's recommended that you use {@link AllowListPolicy} instead.
	 * @param {LoadBalancingPolicy} childPolicy the wrapped policy.
	 * @param {Array.<string>} allowList The hosts address in the format ipAddress:port.
	 * Only hosts from this list may get connected to (whether they will get connected to or not depends on the child
	 * policy).
	 * @extends AllowListPolicy
	 * @deprecated Use allow-list instead. It will be removed in future major versions.
	 * @constructor
	 */
	function WhiteListPolicy(childPolicy, allowList) {
	  AllowListPolicy.call(this, childPolicy, allowList);
	}

	util.inherits(WhiteListPolicy, AllowListPolicy);

	/**
	 * A load-balancing policy implementation that attempts to fairly distribute the load based on the amount of in-flight
	 * request per hosts. The local replicas are initially shuffled and
	 * <a href="https://www.eecs.harvard.edu/~michaelm/postscripts/mythesis.pdf">between the first two nodes in the
	 * shuffled list, the one with fewer in-flight requests is selected as coordinator</a>.
	 *
	 * <p>
	 *   Additionally, it detects unresponsive replicas and reorders them at the back of the query plan.
	 * </p>
	 *
	 * <p>
	 *   For graph analytics queries, it uses the preferred analytics graph server previously obtained by driver as first
	 *   host in the query plan.
	 * </p>
	 */
	class DefaultLoadBalancingPolicy extends LoadBalancingPolicy {

	  /**
	   * Creates a new instance of <code>DefaultLoadBalancingPolicy</code>.
	   * @param {String|Object} [options] The local data center name or the optional policy options object.
	   * <p>
	   *   Note that when providing the local data center name, it overrides <code>localDataCenter</code> option at
	   *   <code>Client</code> level.
	   * </p>
	   * @param {String} [options.localDc] local data center name.  This value overrides the 'localDataCenter' Client option
	   * and is useful for cases where you have multiple execution profiles that you intend on using for routing
	   * requests to different data centers.
	   * @param {Function} [options.filter] A function to apply to determine if hosts are included in the query plan.
	   * The function takes a Host parameter and returns a Boolean.
	   */
	  constructor(options) {
	    super();

	    if (typeof options === 'string') {
	      options = { localDc: options };
	    } else if (!options) {
	      options = utils.emptyObject;
	    }

	    this._client = null;
	    this._hosts = null;
	    this._filteredHosts = null;
	    this._preferredHost = null;
	    this._index = 0;
	    this.localDc = options.localDc;
	    this._filter = options.filter || this._defaultFilter;

	    // Allow some checks to be injected
	    if (options.isHostNewlyUp) {
	      this._isHostNewlyUp = options.isHostNewlyUp;
	    }
	    if (options.healthCheck) {
	      this._healthCheck = options.healthCheck;
	    }
	    if (options.compare) {
	      this._compare = options.compare;
	    }
	    if (options.getReplicas) {
	      this._getReplicas = options.getReplicas;
	    }
	  }

	  /**
	   * Initializes the load balancing policy, called after the driver obtained the information of the cluster.
	   * @param {Client} client
	   * @param {HostMap} hosts
	   * @param {Function} callback
	   */
	  init(client, hosts, callback) {
	    this._client = client;
	    this._hosts = hosts;

	    // Clean local host cache
	    this._hosts.on('add', () => this._filteredHosts = null);
	    this._hosts.on('remove', () => this._filteredHosts = null);

	    try {
	      setLocalDc(this, client, this._hosts);
	    } catch (err) {
	      return callback(err);
	    }

	    callback();
	  }

	  /**
	   * Returns the distance assigned by this policy to the provided host, relatively to the client instance.
	   * @param {Host} host
	   */
	  getDistance(host) {
	    if (this._preferredHost !== null && host === this._preferredHost) {
	      // Set the last preferred host as local.
	      // It ensures that the pool for the graph analytics host has the appropriate size
	      return types.distance.local;
	    }

	    if (!this._filter(host)) {
	      return types.distance.ignored;
	    }

	    return host.datacenter === this.localDc ? types.distance.local : types.distance.ignored;
	  }

	  /**
	   * Returns a host iterator to be used for a query execution.
	   * @override
	   * @param {String} keyspace
	   * @param {ExecutionOptions} executionOptions
	   * @param {Function} callback
	   */
	  newQueryPlan(keyspace, executionOptions, callback) {
	    let routingKey;
	    let preferredHost;

	    if (executionOptions) {
	      routingKey = executionOptions.getRoutingKey();

	      if (executionOptions.getKeyspace()) {
	        keyspace = executionOptions.getKeyspace();
	      }

	      preferredHost = executionOptions.getPreferredHost();
	    }

	    let iterable;

	    if (!keyspace || !routingKey) {
	      iterable = this._getLocalHosts();
	    } else {
	      iterable = this._getReplicasAndLocalHosts(keyspace, routingKey);
	    }

	    if (preferredHost) {
	      // Set it on an instance level field to set the distance
	      this._preferredHost = preferredHost;
	      iterable = DefaultLoadBalancingPolicy._getPreferredHostFirst(preferredHost, iterable);
	    }

	    return callback(null, iterable);
	  }

	  /**
	   * Yields the preferred host first, followed by the host in the provided iterable
	   * @param preferredHost
	   * @param iterable
	   * @private
	   */
	  static *_getPreferredHostFirst(preferredHost, iterable) {
	    yield preferredHost;

	    for (const host of iterable) {
	      if (host !== preferredHost) {
	        yield host;
	      }
	    }
	  }

	  /**
	   * Yields the local hosts without the replicas already yielded
	   * @param {Array<Host>} [localReplicas] The local replicas that we should avoid to include again
	   * @private
	   */
	  *_getLocalHosts(localReplicas) {
	    // Use a local reference
	    const hosts = this._getFilteredLocalHosts();
	    const initialIndex = this._getIndex();

	    // indexOf() over an Array is a O(n) operation but given that there should be 3 to 7 replicas,
	    // it shouldn't be an expensive call. Additionally, this will only be executed when the local replicas
	    // have been exhausted in a lazy manner.
	    const canBeYield = localReplicas
	      ? h => localReplicas.indexOf(h) === -1
	      : h => true;

	    for (let i = 0; i < hosts.length; i++) {
	      const h = hosts[(i + initialIndex) % hosts.length];
	      if (canBeYield(h) && h.isUp()) {
	        yield h;
	      }
	    }
	  }

	  _getReplicasAndLocalHosts(keyspace, routingKey) {
	    let replicas = this._getReplicas(keyspace, routingKey);
	    if (replicas === null) {
	      return this._getLocalHosts();
	    }

	    const filteredReplicas = [];
	    let newlyUpReplica = null;
	    let newlyUpReplicaTimestamp = Number.MIN_SAFE_INTEGER;
	    let unhealthyReplicas = 0;

	    // Filter by DC, predicate and UP replicas
	    // Use the same iteration to perform other checks: whether if its newly UP or unhealthy
	    // As this is part of the hot path, we use a simple loop and avoid using Array.prototype.filter() + closure
	    for (let i = 0; i < replicas.length; i++) {
	      const h = replicas[i];
	      if (!this._filter(h) || h.datacenter !== this.localDc || !h.isUp()) {
	        continue;
	      }
	      const isUpSince = this._isHostNewlyUp(h);
	      if (isUpSince !== null && isUpSince > newlyUpReplicaTimestamp) {
	        newlyUpReplica = h;
	        newlyUpReplicaTimestamp = isUpSince;
	      }
	      if (newlyUpReplica === null && !this._healthCheck(h)) {
	        unhealthyReplicas++;
	      }
	      filteredReplicas.push(h);
	    }

	    replicas = filteredReplicas;

	    // Shuffle remaining local replicas
	    utils.shuffleArray(replicas);

	    if (replicas.length < 3) {
	      // Avoid reordering replicas of a set of 2 as we could be doing more harm than good
	      return this.yieldReplicasFirst(replicas);
	    }

	    let temp;

	    if (newlyUpReplica === null) {
	      if (unhealthyReplicas > 0 && unhealthyReplicas < Math.floor(replicas.length / 2 + 1)) {
	        // There is one or more unhealthy replicas and there is a majority of healthy replicas
	        this._sendUnhealthyToTheBack(replicas, unhealthyReplicas);
	      }
	    }
	    else if ((newlyUpReplica === replicas[0] || newlyUpReplica === replicas[1]) && Math.random() * 4 >= 1) {
	      // There is a newly UP replica and the replica in first or second position is the most recent replica
	      // marked as UP and dice roll 1d4!=1 -> Send it to the back of the Array
	      const index = newlyUpReplica === replicas[0] ? 0 : 1;
	      temp = replicas[replicas.length - 1];
	      replicas[replicas.length - 1] = replicas[index];
	      replicas[index] = temp;
	    }

	    if (this._compare(replicas[1], replicas[0]) > 0) {
	      // Power of two random choices
	      temp = replicas[0];
	      replicas[0] = replicas[1];
	      replicas[1] = temp;
	    }

	    return this.yieldReplicasFirst(replicas);
	  }

	  /**
	   * Yields the local replicas followed by the rest of local nodes.
	   * @param {Array<Host>} replicas The local replicas
	   */
	  *yieldReplicasFirst(replicas) {
	    for (let i = 0; i < replicas.length; i++) {
	      yield replicas[i];
	    }
	    yield* this._getLocalHosts(replicas);
	  }

	  _isHostNewlyUp(h) {
	    return (h.isUpSince !== null && Date.now() - h.isUpSince < newlyUpInterval) ? h.isUpSince : null;
	  }

	  /**
	   * Returns a boolean determining whether the host health is ok or not.
	   * A Host is considered unhealthy when there are enough items in the queue (10 items in-flight) but the
	   * Host is not responding to those requests.
	   * @param {Host} h
	   * @return {boolean}
	   * @private
	   */
	  _healthCheck(h) {
	    return !(h.getInFlight() >= 10 && h.getResponseCount() <= 1);
	  }

	  /**
	   * Compares to host and returns 1 if it needs to favor the first host otherwise, -1.
	   * @return {number}
	   * @private
	   */
	  _compare(h1, h2) {
	    return h1.getInFlight() < h2.getInFlight() ? 1 : -1;
	  }

	  _getReplicas(keyspace, routingKey) {
	    return this._client.getReplicas(keyspace, routingKey);
	  }

	  /**
	   * Returns an Array of hosts filtered by DC and predicate.
	   * @returns {Array<Host>}
	   * @private
	   */
	  _getFilteredLocalHosts() {
	    if (this._filteredHosts === null) {
	      this._filteredHosts = this._hosts.values()
	        .filter(h => this._filter(h) && h.datacenter === this.localDc);
	    }
	    return this._filteredHosts;
	  }

	  _getIndex() {
	    const result = this._index++;
	    // Overflow protection
	    if (this._index === 0x7fffffff) {
	      this._index = 0;
	    }
	    return result;
	  }

	  _sendUnhealthyToTheBack(replicas, unhealthyReplicas) {
	    let counter = 0;

	    // Start from the back, move backwards and stop once all unhealthy replicas are at the back
	    for (let i = replicas.length - 1; i >= 0 && counter < unhealthyReplicas; i--) {
	      const host = replicas[i];
	      if (this._healthCheck(host)) {
	        continue;
	      }

	      const targetIndex = replicas.length - 1 - counter;
	      if (targetIndex !== i) {
	        const temp = replicas[targetIndex];
	        replicas[targetIndex] = host;
	        replicas[i] = temp;
	      }
	      counter++;
	    }
	  }

	  _defaultFilter() {
	    return true;
	  }

	  /**
	   * Gets an associative array containing the policy options.
	   */
	  getOptions() {
	    return new Map([
	      ['localDataCenter', this.localDc ],
	      ['filterFunction', this._filter !== this._defaultFilter ]
	    ]);
	  }
	}

	/**
	 * Validates and sets the local data center to be used.
	 * @param {LoadBalancingPolicy} lbp
	 * @param {Client} client
	 * @param {HostMap} hosts
	 * @private
	 */
	function setLocalDc(lbp, client, hosts) {
	  if (!(lbp instanceof LoadBalancingPolicy)) {
	    throw new errors.DriverInternalError('LoadBalancingPolicy instance was not provided');
	  }

	  if (client && client.options) {
	    if (lbp.localDc && !client.options.localDataCenter) {
	      client.log('info', `Local data center '${lbp.localDc}' was provided as an argument to the load-balancing` +
	        ` policy. It is preferable to specify the local data center using 'localDataCenter' in Client` +
	        ` options instead when your application is targeting a single data center.`);
	    }

	    // If localDc is unset, use value set in client options.
	    lbp.localDc = lbp.localDc || client.options.localDataCenter;
	  }

	  const dcs = getDataCenters(hosts);

	  if (!lbp.localDc) {
	    throw new errors.ArgumentError(
	      `'localDataCenter' is not defined in Client options and also was not specified in constructor.` +
	      ` At least one is required. Available DCs are: [${Array.from(dcs)}]`);
	  }

	  if (!dcs.has(lbp.localDc)) {
	    throw new errors.ArgumentError(`Datacenter ${lbp.localDc} was not found. Available DCs are: [${Array.from(dcs)}]`);
	  }
	}

	function getDataCenters(hosts) {
	  return new Set(hosts.values().map(h => h.datacenter));
	}

	loadBalancing = {
	  AllowListPolicy,
	  DCAwareRoundRobinPolicy,
	  DefaultLoadBalancingPolicy,
	  LoadBalancingPolicy,
	  RoundRobinPolicy,
	  TokenAwarePolicy,
	  // Deprecated: for backward compatibility only.
	  WhiteListPolicy
	};
	return loadBalancing;
}var reconnection = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredReconnection;

function requireReconnection () {
	if (hasRequiredReconnection) return reconnection;
	hasRequiredReconnection = 1;
	const util = require$$0$6;

	/** @module policies/reconnection */
	/**
	 * Base class for Reconnection Policies
	 * @constructor
	 */
	function ReconnectionPolicy() {

	}

	/**
	 * A new reconnection schedule.
	 * @returns {{next: function}} An infinite iterator
	 */
	ReconnectionPolicy.prototype.newSchedule = function () {
	  throw new Error('You must implement a new schedule for the Reconnection class');
	};

	/**
	 * Gets an associative array containing the policy options.
	 */
	ReconnectionPolicy.prototype.getOptions = function () {
	  return new Map();
	};

	/**
	 * A reconnection policy that waits a constant time between each reconnection attempt.
	 * @param {Number} delay Delay in ms
	 * @constructor
	 */
	function ConstantReconnectionPolicy(delay) {
	  this.delay = delay;
	}

	util.inherits(ConstantReconnectionPolicy, ReconnectionPolicy);

	/**
	 * A new reconnection schedule that returns the same next delay value
	 * @returns {{next: Function}} An infinite iterator
	 */
	ConstantReconnectionPolicy.prototype.newSchedule = function () {
	  const self = this;
	  return {
	    next: function () {
	      return {value: self.delay, done: false};
	    }
	  };
	};

	/**
	 * Gets an associative array containing the policy options.
	 */
	ConstantReconnectionPolicy.prototype.getOptions = function () {
	  return new Map([['delay', this.delay ]]);
	};

	/**
	 * A reconnection policy that waits exponentially longer between each
	 * reconnection attempt (but keeps a constant delay once a maximum delay is reached).
	 * <p>
	 *   A random amount of jitter (+/- 15%) will be added to the pure exponential delay value to avoid situations
	 *   where many clients are in the reconnection process at exactly the same time. The jitter will never cause the
	 *   delay to be less than the base delay, or more than the max delay.
	 * </p>
	 * @param {Number} baseDelay The base delay in milliseconds to use for the schedules created by this policy.
	 * @param {Number} maxDelay The maximum delay in milliseconds to wait between two reconnection attempt.
	 * @param {Boolean} startWithNoDelay Determines if the first attempt should be zero delay
	 * @constructor
	 */
	function ExponentialReconnectionPolicy(baseDelay, maxDelay, startWithNoDelay) {
	  this.baseDelay = baseDelay;
	  this.maxDelay = maxDelay;
	  this.startWithNoDelay = startWithNoDelay;
	}

	util.inherits(ExponentialReconnectionPolicy, ReconnectionPolicy);

	/**
	 * A new schedule that uses an exponentially growing delay between reconnection attempts.
	 * @returns {{next: Function}} An infinite iterator.
	 */
	ExponentialReconnectionPolicy.prototype.newSchedule = function* () {
	  let index = this.startWithNoDelay ? -1 : 0;

	  while (true) {
	    let delay = 0;

	    if (index >= 64) {
	      delay = this.maxDelay;
	    } else if (index !== -1) {
	      delay = Math.min(Math.pow(2, index) * this.baseDelay, this.maxDelay);
	    }

	    index++;

	    yield this._addJitter(delay);
	  }
	};

	/**
	 * Adds a random portion of +-15% to the delay provided.
	 * Initially, its adds a random value of 15% to avoid reconnection before reaching the base delay.
	 * When the schedule reaches max delay, only subtracts a random portion of 15%.
	 */
	ExponentialReconnectionPolicy.prototype._addJitter = function (value) {
	  if (value === 0) {
	    // Instant reconnection without jitter
	    return value;
	  }

	  // Use the formula: 85% + rnd() * 30% to calculate the percentage of the original delay
	  let minPercentage = 0.85;
	  let range = 0.30;

	  if (!this.startWithNoDelay && value === this.baseDelay) {
	    // Between 100% to 115% of the original value
	    minPercentage = 1;
	    range = 0.15;
	  } else if (value === this.maxDelay) {
	    // Between 85% to 100% of the original value
	    range = 0.15;
	  }

	  return Math.floor(value * (Math.random() * range + minPercentage));
	};

	/**
	 * Gets an associative array containing the policy options.
	 */
	ExponentialReconnectionPolicy.prototype.getOptions = function () {
	  return new Map([
	    ['baseDelay', this.baseDelay ],
	    ['maxDelay', this.maxDelay ],
	    ['startWithNoDelay', this.startWithNoDelay ]
	  ]);
	};

	reconnection.ReconnectionPolicy = ReconnectionPolicy;
	reconnection.ConstantReconnectionPolicy = ConstantReconnectionPolicy;
	reconnection.ExponentialReconnectionPolicy = ExponentialReconnectionPolicy;
	return reconnection;
}var retry$1 = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredRetry;

function requireRetry () {
	if (hasRequiredRetry) return retry$1;
	hasRequiredRetry = 1;
	const util = require$$0$6;


	/** @module policies/retry */
	/**
	 * Base and default RetryPolicy.
	 * Determines what to do when the drivers runs into an specific Cassandra exception
	 * @constructor
	 */
	function RetryPolicy() {

	}

	/**
	 * Determines what to do when the driver gets an UnavailableException response from a Cassandra node.
	 * @param {OperationInfo} info
	 * @param {Number} consistency The [consistency]{@link module:types~consistencies} level of the query that triggered
	 * the exception.
	 * @param {Number} required The number of replicas whose response is required to achieve the
	 * required [consistency]{@link module:types~consistencies}.
	 * @param {Number} alive The number of replicas that were known to be alive when the request had been processed
	 * (since an unavailable exception has been triggered, there will be alive &lt; required)
	 * @returns {DecisionInfo}
	 */
	RetryPolicy.prototype.onUnavailable = function (info, consistency, required, alive) {
	  if (info.nbRetry > 0) {
	    return this.rethrowResult();
	  }
	  return this.retryResult(undefined, false);
	};

	/**
	 * Determines what to do when the driver gets a ReadTimeoutException response from a Cassandra node.
	 * @param {OperationInfo} info
	 * @param {Number} consistency The [consistency]{@link module:types~consistencies} level of the query that triggered
	 * the exception.
	 * @param {Number} received The number of nodes having answered the request.
	 * @param {Number} blockFor The number of replicas whose response is required to achieve the
	 * required [consistency]{@link module:types~consistencies}.
	 * @param {Boolean} isDataPresent When <code>false</code>, it means the replica that was asked for data has not responded.
	 * @returns {DecisionInfo}
	 */
	RetryPolicy.prototype.onReadTimeout = function (info, consistency, received, blockFor, isDataPresent) {
	  if (info.nbRetry > 0) {
	    return this.rethrowResult();
	  }
	  return ((received >= blockFor && !isDataPresent) ?
	    this.retryResult() :
	    this.rethrowResult());
	};

	/**
	 * Determines what to do when the driver gets a WriteTimeoutException response from a Cassandra node.
	 * @param {OperationInfo} info
	 * @param {Number} consistency The [consistency]{@link module:types~consistencies} level of the query that triggered
	 * the exception.
	 * @param {Number} received The number of nodes having acknowledged the request.
	 * @param {Number} blockFor The number of replicas whose acknowledgement is required to achieve the required
	 * [consistency]{@link module:types~consistencies}.
	 * @param {String} writeType A <code>string</code> that describes the type of the write that timed out ("SIMPLE"
	 * / "BATCH" / "BATCH_LOG" / "UNLOGGED_BATCH" / "COUNTER").
	 * @returns {DecisionInfo}
	 */
	RetryPolicy.prototype.onWriteTimeout = function (info, consistency, received, blockFor, writeType) {
	  if (info.nbRetry > 0) {
	    return this.rethrowResult();
	  }
	  // If the batch log write failed, retry the operation as this might just be we were unlucky at picking candidates
	  return writeType === "BATCH_LOG" ? this.retryResult() : this.rethrowResult();
	};

	/**
	 * Defines whether to retry and at which consistency level on an unexpected error.
	 * <p>
	 * This method might be invoked in the following situations:
	 * </p>
	 * <ol>
	 * <li>On a client timeout, while waiting for the server response
	 * (see [socketOptions.readTimeout]{@link ClientOptions}), being the error an instance of
	 * [OperationTimedOutError]{@link module:errors~OperationTimedOutError}.</li>
	 * <li>On a connection error (socket closed, etc.).</li>
	 * <li>When the contacted host replies with an error, such as <code>overloaded</code>, <code>isBootstrapping</code>,
	 * </code>serverError, etc. In this case, the error is instance of [ResponseError]{@link module:errors~ResponseError}.
	 * </li>
	 * </ol>
	 * <p>
	 * Note that when this method is invoked, <em>the driver cannot guarantee that the mutation has been effectively
	 * applied server-side</em>; a retry should only be attempted if the request is known to be idempotent.
	 * </p>
	 * @param {OperationInfo} info
	 * @param {Number|undefined} consistency The [consistency]{@link module:types~consistencies} level of the query that triggered
	 * the exception.
	 * @param {Error} err The error that caused this request to fail.
	 * @returns {DecisionInfo}
	 */
	RetryPolicy.prototype.onRequestError = function (info, consistency, err) {
	  // The default implementation triggers a retry on the next host in the query plan with the same consistency level,
	  // regardless of the statement's idempotence, for historical reasons.
	  return this.retryResult(undefined, false);
	};

	/**
	 * Returns a {@link DecisionInfo} to retry the request with the given [consistency]{@link module:types~consistencies}.
	 * @param {Number|undefined} [consistency] When specified, it retries the request with the given consistency.
	 * @param {Boolean} [useCurrentHost] When specified, determines if the retry should be made using the same coordinator.
	 * Default: true.
	 * @returns {DecisionInfo}
	 */
	RetryPolicy.prototype.retryResult = function (consistency, useCurrentHost) {
	  return {
	    decision: RetryPolicy.retryDecision.retry,
	    consistency: consistency,
	    useCurrentHost: useCurrentHost !== false
	  };
	};

	/**
	 * Returns a {@link DecisionInfo} to callback in error when a err is obtained for a given request.
	 * @returns {DecisionInfo}
	 */
	RetryPolicy.prototype.rethrowResult = function () {
	  return { decision: RetryPolicy.retryDecision.rethrow };
	};

	/**
	 * Determines the retry decision for the retry policies.
	 * @type {Object}
	 * @property {Number} rethrow
	 * @property {Number} retry
	 * @property {Number} ignore
	 * @static
	 */
	RetryPolicy.retryDecision = {
	  rethrow:  0,
	  retry:    1,
	  ignore:   2
	};

	/**
	 * Creates a new instance of <code>IdempotenceAwareRetryPolicy</code>.
	 * @classdesc
	 * A retry policy that avoids retrying non-idempotent statements.
	 * <p>
	 * In case of write timeouts or unexpected errors, this policy will always return
	 * [rethrowResult()]{@link module:policies/retry~RetryPolicy#rethrowResult} if the statement is deemed non-idempotent
	 * (see [QueryOptions.isIdempotent]{@link QueryOptions}).
	 * <p/>
	 * For all other cases, this policy delegates the decision to the child policy.
	 * @param {RetryPolicy} [childPolicy] The child retry policy to wrap. When not defined, it will use an instance of
	 * [RetryPolicy]{@link module:policies/retry~RetryPolicy} as child policy.
	 * @extends module:policies/retry~RetryPolicy
	 * @constructor
	 * @deprecated Since version 4.0 non-idempotent operations are never tried for write timeout or request error, use the
	 * default retry policy instead.
	 */
	function IdempotenceAwareRetryPolicy(childPolicy) {
	  this._childPolicy = childPolicy || new RetryPolicy();
	}

	util.inherits(IdempotenceAwareRetryPolicy, RetryPolicy);

	IdempotenceAwareRetryPolicy.prototype.onReadTimeout = function (info, consistency, received, blockFor, isDataPresent) {
	  return this._childPolicy.onReadTimeout(info, consistency, received, blockFor, isDataPresent);
	};

	/**
	 * If the query is not idempotent, it returns a rethrow decision. Otherwise, it relies on the child policy to decide.
	 */
	IdempotenceAwareRetryPolicy.prototype.onRequestError = function (info, consistency, err) {
	  if (info.executionOptions.isIdempotent()) {
	    return this._childPolicy.onRequestError(info, consistency, err);
	  }
	  return this.rethrowResult();
	};

	IdempotenceAwareRetryPolicy.prototype.onUnavailable = function (info, consistency, required, alive) {
	  return this._childPolicy.onUnavailable(info, consistency, required, alive);
	};

	/**
	 * If the query is not idempotent, it return a rethrow decision. Otherwise, it relies on the child policy to decide.
	 */
	IdempotenceAwareRetryPolicy.prototype.onWriteTimeout = function (info, consistency, received, blockFor, writeType) {
	  if (info.executionOptions.isIdempotent()) {
	    return this._childPolicy.onWriteTimeout(info, consistency, received, blockFor, writeType);
	  }
	  return this.rethrowResult();
	};

	/**
	 * Creates a new instance of FallthroughRetryPolicy.
	 * @classdesc
	 * A retry policy that never retries nor ignores.
	 * <p>
	 * All of the methods of this retry policy unconditionally return
	 * [rethrow]{@link module:policies/retry~Retry#rethrowResult()}. If this policy is used, retry logic will have to be
	 * implemented in business code.
	 * </p>
	 * @alias module:policies/retry~FallthroughRetryPolicy
	 * @extends RetryPolicy
	 * @constructor
	 */
	function FallthroughRetryPolicy() {

	}

	util.inherits(FallthroughRetryPolicy, RetryPolicy);

	/**
	 * Implementation of RetryPolicy method that returns [rethrow]{@link module:policies/retry~Retry#rethrowResult()}.
	 */
	FallthroughRetryPolicy.prototype.onReadTimeout = function () {
	  return this.rethrowResult();
	};

	/**
	 * Implementation of RetryPolicy method that returns [rethrow]{@link module:policies/retry~Retry#rethrowResult()}.
	 */
	FallthroughRetryPolicy.prototype.onRequestError = function () {
	  return this.rethrowResult();
	};

	/**
	 * Implementation of RetryPolicy method that returns [rethrow]{@link module:policies/retry~Retry#rethrowResult()}.
	 */
	FallthroughRetryPolicy.prototype.onUnavailable = function () {
	  return this.rethrowResult();
	};

	/**
	 * Implementation of RetryPolicy method that returns [rethrow]{@link module:policies/retry~Retry#rethrowResult()}.
	 */
	FallthroughRetryPolicy.prototype.onWriteTimeout = function () {
	  return this.rethrowResult();
	};

	/**
	 * Decision information
	 * @typedef {Object} DecisionInfo
	 * @property {Number} decision The decision as specified in
	 * [retryDecision]{@link module:policies/retry~RetryPolicy.retryDecision}.
	 * @property {Number} [consistency] The [consistency level]{@link module:types~consistencies}.
	 * @property {useCurrentHost} [useCurrentHost] Determines if it should use the same host to retry the request.
	 * <p>
	 *   In the case that the current host is not available anymore, it will be retried on the next host even when
	 *   <code>useCurrentHost</code> is set to <code>true</code>.
	 * </p>
	 */

	/**
	 * Information of the execution to be used to determine whether the operation should be retried.
	 * @typedef {Object} OperationInfo
	 * @property {String} query The query that was executed.
	 * @param {ExecutionOptions} executionOptions The options related to the execution of the request.
	 * @property {Number} nbRetry The number of retries already performed for this operation.
	 */

	retry$1.IdempotenceAwareRetryPolicy = IdempotenceAwareRetryPolicy;
	retry$1.FallthroughRetryPolicy = FallthroughRetryPolicy;
	retry$1.RetryPolicy = RetryPolicy;
	return retry$1;
}var speculativeExecution = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredSpeculativeExecution;

function requireSpeculativeExecution () {
	if (hasRequiredSpeculativeExecution) return speculativeExecution;
	hasRequiredSpeculativeExecution = 1;

	const util = require$$0$6;
	const errors = requireErrors$c();

	/** @module policies/speculativeExecution */

	/**
	 * @classdesc
	 * The policy that decides if the driver will send speculative queries to the next hosts when the current host takes too
	 * long to respond.
	 * <p>Note that only idempotent statements will be speculatively retried.</p>
	 * @constructor
	 * @abstract
	 */
	function SpeculativeExecutionPolicy() {
	  
	}

	/**
	 * Initialization method that gets invoked on Client startup.
	 * @param {Client} client
	 * @abstract
	 */
	SpeculativeExecutionPolicy.prototype.init = function (client) {

	};

	/**
	 * Gets invoked at client shutdown, giving the opportunity to the implementor to perform cleanup.
	 * @abstract
	 */
	SpeculativeExecutionPolicy.prototype.shutdown = function () {

	};

	/**
	 * Gets the plan to use for a new query.
	 * Returns an object with a <code>nextExecution()</code> method, which returns a positive number representing the
	 * amount of milliseconds to delay the next execution or a non-negative number to avoid further executions.
	 * @param {String} keyspace The currently logged keyspace.
	 * @param {String|Array<String>} queryInfo The query, or queries in the case of batches, for which to build a plan.
	 * @return {{nextExecution: function}}
	 * @abstract
	 */
	SpeculativeExecutionPolicy.prototype.newPlan = function (keyspace, queryInfo) {
	  throw new Error('You must implement newPlan() method in the SpeculativeExecutionPolicy');
	};

	/**
	 * Gets an associative array containing the policy options.
	 */
	SpeculativeExecutionPolicy.prototype.getOptions = function () {
	  return new Map();
	};

	/**
	 * Creates a new instance of NoSpeculativeExecutionPolicy.
	 * @classdesc
	 * A {@link SpeculativeExecutionPolicy} that never schedules speculative executions.
	 * @constructor
	 * @extends {SpeculativeExecutionPolicy}
	 */
	function NoSpeculativeExecutionPolicy() {
	  this._plan = {
	    nextExecution: function () {
	      return -1;
	    }
	  };
	}

	util.inherits(NoSpeculativeExecutionPolicy, SpeculativeExecutionPolicy);

	NoSpeculativeExecutionPolicy.prototype.newPlan = function () {
	  return this._plan;
	};


	/**
	 * Creates a new instance of ConstantSpeculativeExecutionPolicy.
	 * @classdesc
	 * A {@link SpeculativeExecutionPolicy} that schedules a given number of speculative executions,
	 * separated by a fixed delay.
	 * @constructor
	 * @param {Number} delay The delay between each speculative execution.
	 * @param {Number} maxSpeculativeExecutions The amount of speculative executions that should be scheduled after the
	 * initial execution. Must be strictly positive.
	 * @extends {SpeculativeExecutionPolicy}
	 */
	function ConstantSpeculativeExecutionPolicy(delay, maxSpeculativeExecutions) {
	  if (!(delay >= 0)) {
	    throw new errors.ArgumentError('delay must be a positive number or zero');
	  }
	  if (!(maxSpeculativeExecutions > 0)) {
	    throw new errors.ArgumentError('maxSpeculativeExecutions must be a positive number');
	  }
	  this._delay = delay;
	  this._maxSpeculativeExecutions = maxSpeculativeExecutions;
	}

	util.inherits(ConstantSpeculativeExecutionPolicy, SpeculativeExecutionPolicy);

	ConstantSpeculativeExecutionPolicy.prototype.newPlan = function () {
	  let executions = 0;
	  const self = this;
	  return {
	    nextExecution: function () {
	      if (executions++ < self._maxSpeculativeExecutions) {
	        return self._delay;
	      }
	      return -1;
	    }
	  };
	};

	/**
	 * Gets an associative array containing the policy options.
	 */
	ConstantSpeculativeExecutionPolicy.prototype.getOptions = function () {
	  return new Map([
	    ['delay', this._delay ],
	    ['maxSpeculativeExecutions', this._maxSpeculativeExecutions ]
	  ]);
	};

	speculativeExecution.NoSpeculativeExecutionPolicy = NoSpeculativeExecutionPolicy;
	speculativeExecution.SpeculativeExecutionPolicy = SpeculativeExecutionPolicy;
	speculativeExecution.ConstantSpeculativeExecutionPolicy = ConstantSpeculativeExecutionPolicy;
	return speculativeExecution;
}var timestampGeneration = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredTimestampGeneration;

function requireTimestampGeneration () {
	if (hasRequiredTimestampGeneration) return timestampGeneration;
	hasRequiredTimestampGeneration = 1;

	const util = require$$0$6;
	const { Long } = requireTypes$2();
	const errors = requireErrors$c();

	/** @module policies/timestampGeneration */

	/**
	 * Defines the maximum date in milliseconds that can be represented in microseconds using Number ((2 ^ 53) / 1000)
	 * @const
	 * @private
	 */
	const _maxSafeNumberDate = 9007199254740;

	/**
	 * A long representing the value 1000
	 * @const
	 * @private
	 */
	const _longOneThousand = Long.fromInt(1000);

	/**
	 * Creates a new instance of {@link TimestampGenerator}.
	 * @classdesc
	 * Generates client-side, microsecond-precision query timestamps.
	 * <p>
	 *   Given that Cassandra uses those timestamps to resolve conflicts, implementations should generate
	 *   monotonically increasing timestamps for successive invocations of {@link TimestampGenerator.next()}.
	 * </p>
	 * @constructor
	 */
	function TimestampGenerator() {

	}

	/**
	 * Returns the next timestamp.
	 * <p>
	 *   Implementors should enforce increasing monotonicity of timestamps, that is,
	 *   a timestamp returned should always be strictly greater that any previously returned
	 *   timestamp.
	 * <p/>
	 * <p>
	 *   Implementors should strive to achieve microsecond precision in the best possible way,
	 *   which is usually largely dependent on the underlying operating system's capabilities.
	 * </p>
	 * @param {Client} client The {@link Client} instance to generate timestamps to.
	 * @returns {Long|Number|null} the next timestamp (in microseconds). If it's equals to <code>null</code>, it won't be
	 * sent by the driver, letting the server to generate the timestamp.
	 * @abstract
	 */
	TimestampGenerator.prototype.next = function (client) {
	  throw new Error('next() must be implemented');
	};

	/**
	 * A timestamp generator that guarantees monotonically increasing timestamps and logs warnings when timestamps
	 * drift in the future.
	 * <p>
	 *   {@link Date} has millisecond precision and client timestamps require microsecond precision. This generator
	 *   keeps track of the last generated timestamp, and if the current time is within the same millisecond as the last,
	 *   it fills the microsecond portion of the new timestamp with the value of an incrementing counter.
	 * </p>
	 * @param {Number} [warningThreshold] Determines how far in the future timestamps are allowed to drift before a
	 * warning is logged, expressed in milliseconds. Default: <code>1000</code>.
	 * @param {Number} [minLogInterval] In case of multiple log events, it determines the time separation between log
	 * events, expressed in milliseconds. Use 0 to disable. Default: <code>1000</code>.
	 * @extends {TimestampGenerator}
	 * @constructor
	 */
	function MonotonicTimestampGenerator(warningThreshold, minLogInterval) {
	  if (warningThreshold < 0) {
	    throw new errors.ArgumentError('warningThreshold can not be lower than 0');
	  }
	  this._warningThreshold = warningThreshold || 1000;
	  this._minLogInterval = 1000;
	  if (typeof minLogInterval === 'number') {
	    // A value under 1 will disable logging
	    this._minLogInterval = minLogInterval;
	  }
	  this._micros = -1;
	  this._lastDate = 0;
	  this._lastLogDate = 0;
	}

	util.inherits(MonotonicTimestampGenerator, TimestampGenerator);

	/**
	 * Returns the current time in milliseconds since UNIX epoch
	 * @returns {Number}
	 */
	MonotonicTimestampGenerator.prototype.getDate = function () {
	  return Date.now();
	};

	MonotonicTimestampGenerator.prototype.next = function (client) {
	  let date = this.getDate();
	  let drifted = 0;
	  if (date > this._lastDate) {
	    this._micros = 0;
	    this._lastDate = date;
	    return this._generateMicroseconds();
	  }

	  if (date < this._lastDate) {
	    drifted = this._lastDate - date;
	    date = this._lastDate;
	  }
	  if (++this._micros === 1000) {
	    this._micros = 0;
	    if (date === this._lastDate) {
	      // Move date 1 millisecond into the future
	      date++;
	      drifted++;
	    }
	  }
	  const lastDate = this._lastDate;
	  this._lastDate = date;
	  const result = this._generateMicroseconds();
	  if (drifted >= this._warningThreshold) {
	    // Avoid logging an unbounded amount of times within a clock-skew event or during an interval when more than 1
	    // query is being issued by microsecond
	    const currentLogDate = Date.now();
	    if (this._minLogInterval > 0 && this._lastLogDate + this._minLogInterval <= currentLogDate){
	      const message = util.format(
	        'Timestamp generated using current date was %d milliseconds behind the last generated timestamp (which ' +
	        'millisecond portion was %d), the returned value (%s) is being artificially incremented to guarantee ' +
	        'monotonicity.',
	        drifted, lastDate, result);
	      this._lastLogDate = currentLogDate;
	      client.log('warning', message);
	    }
	  }
	  return result;
	};

	/**
	 * @private
	 * @returns {Number|Long}
	 */
	MonotonicTimestampGenerator.prototype._generateMicroseconds = function () {
	  if (this._lastDate < _maxSafeNumberDate) {
	    // We are safe until Jun 06 2255, its faster to perform this operations on Number than on Long
	    // We hope to have native int64 by then :)
	    return this._lastDate * 1000 + this._micros;
	  }
	  return Long
	    .fromNumber(this._lastDate)
	    .multiply(_longOneThousand)
	    .add(Long.fromInt(this._micros));
	};

	timestampGeneration.TimestampGenerator = TimestampGenerator;
	timestampGeneration.MonotonicTimestampGenerator = MonotonicTimestampGenerator;
	return timestampGeneration;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredPolicies;

function requirePolicies () {
	if (hasRequiredPolicies) return policies;
	hasRequiredPolicies = 1;

	/**
	 * Contains driver tuning policies to determine [load balancing]{@link module:policies/loadBalancing},
	 *  [retrying]{@link module:policies/retry} queries, [reconnecting]{@link module:policies/reconnection} to a node,
	 *  [address resolution]{@link module:policies/addressResolution},
	 *  [timestamp generation]{@link module:policies/timestampGeneration} and
	 *  [speculative execution]{@link module:policies/speculativeExecution}.
	 * @module policies
	 */
	const addressResolution = policies.addressResolution = requireAddressResolution();
	const loadBalancing = policies.loadBalancing = requireLoadBalancing();
	const reconnection = policies.reconnection = requireReconnection();
	const retry = policies.retry = requireRetry();
	const speculativeExecution = policies.speculativeExecution = requireSpeculativeExecution();
	const timestampGeneration = policies.timestampGeneration = requireTimestampGeneration();

	/**
	 * Returns a new instance of the default address translator policy used by the driver.
	 * @returns {AddressTranslator}
	 */
	policies.defaultAddressTranslator = function () {
	  return new addressResolution.AddressTranslator();
	};

	/**
	 * Returns a new instance of the default load-balancing policy used by the driver.
	 * @param {string} [localDc] When provided, it sets the data center that is going to be used as local for the
	 * load-balancing policy instance.
	 * <p>When localDc is undefined, the load-balancing policy instance will use the <code>localDataCenter</code>
	 * provided in the {@link ClientOptions}.</p>
	 * @returns {LoadBalancingPolicy}
	 */
	policies.defaultLoadBalancingPolicy = function (localDc) {
	  return new loadBalancing.DefaultLoadBalancingPolicy(localDc);
	};

	/**
	 * Returns a new instance of the default retry policy used by the driver.
	 * @returns {RetryPolicy}
	 */
	policies.defaultRetryPolicy = function () {
	  return new retry.RetryPolicy();
	};

	/**
	 * Returns a new instance of the default reconnection policy used by the driver.
	 * @returns {ReconnectionPolicy}
	 */
	policies.defaultReconnectionPolicy = function () {
	  return new reconnection.ExponentialReconnectionPolicy(1000, 10 * 60 * 1000, false);
	};


	/**
	 * Returns a new instance of the default speculative execution policy used by the driver.
	 * @returns {SpeculativeExecutionPolicy}
	 */
	policies.defaultSpeculativeExecutionPolicy = function () {
	  return new speculativeExecution.NoSpeculativeExecutionPolicy();
	};

	/**
	 * Returns a new instance of the default timestamp generator used by the driver.
	 * @returns {TimestampGenerator}
	 */
	policies.defaultTimestampGenerator = function () {
	  return new timestampGeneration.MonotonicTimestampGenerator();
	};
	return policies;
}var tracker = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var requestTracker;
var hasRequiredRequestTracker;

function requireRequestTracker () {
	if (hasRequiredRequestTracker) return requestTracker;
	hasRequiredRequestTracker = 1;

	/**
	 * Tracks request execution for a {@link Client}.
	 * <p>
	 *   A {@link RequestTracker} can be configured in the client options. The <code>Client</code> will execute
	 *   {@link RequestTracker#onSuccess} or {@link RequestTracker#onError} for every query or batch
	 *   executed (QUERY, EXECUTE and BATCH requests).
	 * </p>
	 * @interface
	 * @alias module:tracker~RequestTracker
	 */
	class RequestTracker {

	  /**
	   * Invoked each time a query or batch request succeeds.
	   * @param {Host} host The node that acted as coordinator of the request.
	   * @param {String|Array} query In the case of prepared or unprepared query executions, the provided
	   * query string. For batch requests, an Array containing the queries and parameters provided.
	   * @param {Array|Object|null} parameters In the case of prepared or unprepared query executions, the provided
	   * parameters.
	   * @param {ExecutionOptions} executionOptions The information related to the execution of the request.
	   * @param {Number} requestLength Length of the body of the request.
	   * @param {Number} responseLength Length of the body of the response.
	   * @param {Array<Number>} latency An array containing [seconds, nanoseconds] tuple, where nanoseconds is the
	   * remaining part of the real time that can't be represented in second precision (see <code>process.hrtime()</code>).
	   */
	  onSuccess(host, query, parameters, executionOptions, requestLength, responseLength, latency) {

	  }

	  /**
	   * Invoked each time a query or batch request fails.
	   * @param {Host} host The node that acted as coordinator of the request.
	   * @param {String|Array} query In the case of prepared or unprepared query executions, the provided
	   * query string. For batch requests, an Array containing the queries and parameters provided.
	   * @param {Array|Object|null} parameters In the case of prepared or unprepared query executions, the provided
	   * parameters.
	   * @param {ExecutionOptions} executionOptions The information related to the execution of the request.
	   * @param {Number} requestLength Length of the body of the request. When the failure occurred before the request was
	   * written to the wire, the length will be <code>0</code>.
	   * @param {Error} err The error that caused that caused the request to fail.
	   * @param {Array<Number>} latency An array containing [seconds, nanoseconds] tuple, where nanoseconds is the
	   * remaining part of the real time that can't be represented in second precision (see <code>process.hrtime()</code>).
	   */
	  onError(host, query, parameters, executionOptions, requestLength, err, latency) {

	  }

	  /**
	   * Invoked when the Client is being shutdown.
	   */
	  shutdown() {

	  }
	}

	requestTracker = RequestTracker;
	return requestTracker;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var requestLogger;
var hasRequiredRequestLogger;

function requireRequestLogger () {
	if (hasRequiredRequestLogger) return requestLogger;
	hasRequiredRequestLogger = 1;

	const events = require$$0$8;
	const RequestTracker = requireRequestTracker();
	const errors = requireErrors$c();
	const { format } = require$$0$6;

	const nanosToMillis = 1000000;
	const defaultMessageMaxQueryLength = 500;
	const defaultMaxParameterValueLength = 50;
	const defaultMaxErrorStackTraceLength = 200;

	/**
	 * A request tracker that logs the requests executed through the session, according to a set of
	 * configurable options.
	 * @implements {module:tracker~RequestTracker}
	 * @alias module:tracker~RequestLogger
	 * @example <caption>Logging slow queries</caption>
	 * const requestLogger = new RequestLogger({ slowThreshold: 1000 });
	 * requestLogger.emitter.on('show', message => console.log(message));
	 * // Add the requestLogger to the client options
	 * const client = new Client({ contactPoints, requestTracker: requestLogger });
	 */
	class RequestLogger extends RequestTracker {

	  /**
	   * Creates a new instance of {@link RequestLogger}.
	   * @param {Object} options
	   * @param {Number} [options.slowThreshold] The threshold in milliseconds beyond which queries are considered 'slow'
	   * and logged as such by the driver.
	   * @param {Number} [options.requestSizeThreshold] The threshold in bytes beyond which requests are considered 'large'
	   * and logged as such by the driver.
	   * @param {Boolean} [options.logNormalRequests] Determines whether it should emit 'normal' events for every
	   * EXECUTE, QUERY and BATCH request executed successfully, useful only for debugging. This option can be modified
	   * after the client is connected using the property {@link RequestLogger#logNormalRequests}.
	   * @param {Boolean} [options.logErroredRequests] Determines whether it should emit 'failure' events for every
	   * EXECUTE, QUERY and BATCH request execution that resulted in an error. This option can be modified
	   * after the client is connected using the property {@link RequestLogger#logErroredRequests}.
	   * @param {Number} [options.messageMaxQueryLength] The maximum amount of characters that are logged from the query
	   * portion of the message. Defaults to 500.
	   * @param {Number} [options.messageMaxParameterValueLength] The maximum amount of characters of each query parameter
	   * value that will be included in the message. Defaults to 50.
	   * @param {Number} [options.messageMaxErrorStackTraceLength] The maximum amount of characters of the stack trace
	   * that will be included in the message. Defaults to 200.
	   */
	  constructor(options) {
	    super();
	    if (!options) {
	      throw new errors.ArgumentError('RequestLogger options parameter is required');
	    }

	    this._options = options;

	    /**
	     * Determines whether it should emit 'normal' events for every EXECUTE, QUERY and BATCH request executed
	     * successfully, useful only for debugging
	     * @type {Boolean}
	     */
	    this.logNormalRequests = this._options.logNormalRequests;

	    /**
	     * Determines whether it should emit 'failure' events for every EXECUTE, QUERY and BATCH request execution that
	     * resulted in an error
	     * @type {Boolean}
	     */
	    this.logErroredRequests = this._options.logErroredRequests;

	    /**
	     * The object instance that emits <code>'slow'</code>, <code>'large'</code>, <code>'normal'</code> and
	     * <code>'failure'</code> events.
	     * @type {EventEmitter}
	     */
	    this.emitter = new events.EventEmitter();
	  }

	  /**
	   * Logs message if request execution was deemed too slow, large or if normal requests are logged.
	   * @override
	   */
	  onSuccess(host, query, parameters, execOptions, requestLength, responseLength, latency) {
	    if (this._options.slowThreshold > 0 && toMillis(latency) > this._options.slowThreshold) {
	      this._logSlow(host, query, parameters, execOptions, requestLength, responseLength, latency);
	    }
	    else if (this._options.requestSizeThreshold > 0 && requestLength > this._options.requestSizeThreshold) {
	      this._logLargeRequest(host, query, parameters, execOptions, requestLength, responseLength, latency);
	    }
	    else if (this.logNormalRequests) {
	      this._logNormalRequest(host, query, parameters, execOptions, requestLength, responseLength, latency);
	    }
	  }

	  /**
	   * Logs message if request execution was too large and/or encountered an error.
	   * @override
	   */
	  onError(host, query, parameters, execOptions, requestLength, err, latency) {
	    if (this._options.requestSizeThreshold > 0 && requestLength > this._options.requestSizeThreshold) {
	      this._logLargeErrorRequest(host, query, parameters, execOptions, requestLength, err, latency);
	    }
	    else if (this.logErroredRequests) {
	      this._logErrorRequest(host, query, parameters, execOptions, requestLength, err, latency);
	    }
	  }

	  _logSlow(host, query, parameters, execOptions, requestLength, responseLength, latency) {
	    const message = format('[%s] Slow request, took %d ms (%s): %s', host.address, Math.floor(toMillis(latency)),
	      getPayloadSizes(requestLength, responseLength), getStatementInfo(query, parameters, execOptions, this._options));
	    this.emitter.emit('slow', message);
	  }

	  _logLargeRequest(host, query, parameters, execOptions, requestLength, responseLength, latency) {
	    const message = format('[%s] Request exceeded length, %s (took %d ms): %s', host.address,
	      getPayloadSizes(requestLength, responseLength), ~~toMillis(latency),
	      getStatementInfo(query, parameters, execOptions, this._options));
	    this.emitter.emit('large', message);
	  }

	  _logNormalRequest(host, query, parameters, execOptions, requestLength, responseLength, latency) {
	    const message = format('[%s] Request completed normally, took %d ms (%s): %s', host.address, ~~toMillis(latency),
	      getPayloadSizes(requestLength, responseLength), getStatementInfo(query, parameters, execOptions, this._options));
	    this.emitter.emit('normal', message);
	  }

	  _logLargeErrorRequest(host, query, parameters, execOptions, requestLength, err, latency) {
	    const maxStackTraceLength = this._options.messageMaxErrorStackTraceLength || defaultMaxErrorStackTraceLength;
	    const message = format('[%s] Request exceeded length and execution failed, %s (took %d ms): %s; error: %s',
	      host.address, getPayloadSizes(requestLength), ~~toMillis(latency),
	      getStatementInfo(query, parameters, execOptions, this._options), err.stack.substr(0, maxStackTraceLength));

	    // Use 'large' event and not 'failure' as this log is caused by exceeded length
	    this.emitter.emit('large', message);
	  }

	  _logErrorRequest(host, query, parameters, execOptions, requestLength, err, latency) {
	    const maxStackTraceLength = this._options.messageMaxErrorStackTraceLength || defaultMaxErrorStackTraceLength;
	    const message = format('[%s] Request execution failed, took %d ms (%s): %s; error: %s', host.address,
	      ~~toMillis(latency), getPayloadSizes(requestLength),
	      getStatementInfo(query, parameters, execOptions, this._options), err.stack.substr(0, maxStackTraceLength));

	    // Avoid using 'error' as its a special event
	    this.emitter.emit('failure', message);
	  }
	}

	function toMillis(latency) {
	  return latency[0] * 1000 + latency[1] / nanosToMillis;
	}

	function getStatementInfo(query, parameters, execOptions, options) {
	  const maxQueryLength = options.messageMaxQueryLength || defaultMessageMaxQueryLength;
	  const maxParameterLength = options.messageMaxParameterValueLength || defaultMaxParameterValueLength;

	  if (Array.isArray(query)) {
	    return getBatchStatementInfo(query, execOptions, maxQueryLength, maxParameterLength);
	  }

	  // String concatenation is usually faster than Array#join() in V8
	  let message = query.substr(0, maxQueryLength);
	  const remaining = maxQueryLength - message.length - 1;
	  message += getParametersInfo(parameters, remaining, maxParameterLength);

	  if (!execOptions.isPrepared()) {
	    // This part of the message is not accounted for in "maxQueryLength"
	    message += ' (not prepared)';
	  }

	  return message;
	}

	function getBatchStatementInfo(queries, execOptions, maxQueryLength, maxParameterLength) {
	  // This part of the message is not accounted for in "maxQueryLength"
	  let message = (execOptions.isBatchLogged() ? 'LOGGED ' : '') + 'BATCH w/ ' + queries.length +
	    (!execOptions.isPrepared() ? ' not prepared' : '') + ' queries (';
	  let remaining = maxQueryLength;
	  let i;

	  for (i = 0; i < queries.length && remaining > 0; i++) {
	    let q = queries[i];
	    const params = q.params;
	    if (typeof q !== 'string') {
	      q = q.query;
	    }

	    if (i > 0) {
	      message += ',';
	      remaining--;
	    }

	    const queryLength = Math.min(remaining, q.length);
	    message += q.substr(0, queryLength);
	    remaining -= queryLength;

	    if (remaining <= 0) {
	      break;
	    }

	    const parameters = getParametersInfo(params, remaining, maxParameterLength);
	    remaining -= parameters.length;
	    message += parameters;
	  }

	  message += i < queries.length ? ',...)' : ')';
	  return message;
	}

	function getParametersInfo(params, remaining, maxParameterLength) {
	  if (remaining <= 3) {
	    // We need at least 3 chars to describe the parameters
	    // its OK to add more chars in an effort to be descriptive
	    return ' [...]';
	  }

	  if (!params) {
	    return ' []';
	  }

	  let paramStringifier = (index, length) => formatParam(params[index], length);
	  if (!Array.isArray(params)) {
	    const obj = params;
	    params = Object.keys(params);
	    paramStringifier = (index, length) => {
	      const key = params[index];
	      let result = key.substr(0, length);
	      const rem = length - result.length - 1;
	      if (rem <= 0) {
	        return result;
	      }
	      result += ":" + formatParam(obj[key], rem);
	      return result;
	    };
	  }

	  let message = ' [';
	  let i;
	  for (i = 0; remaining > 0 && i < params.length; i++) {
	    if (i > 0) {
	      message += ',';
	      remaining--;
	    }

	    const paramString = paramStringifier(i, Math.min(maxParameterLength, remaining));
	    remaining -= paramString.length;
	    message += paramString;
	  }

	  if (i < params.length) {
	    message += '...';
	  }

	  message += ']';
	  return message;
	}

	function formatParam(value, maxLength) {
	  if (value === undefined) {
	    return 'undefined';
	  }

	  if (value === null) {
	    return 'null';
	  }

	  return value.toString().substr(0, maxLength);
	}

	function getPayloadSizes(requestLength, responseLength) {
	  let message = 'request size ' + formatSize(requestLength);
	  if (responseLength !== undefined) {
	    message += ' / response size ' + formatSize(responseLength);
	  }
	  return message;
	}

	function formatSize(length) {
	  return length > 1000 ? Math.round(length / 1024) + ' KB' : length + ' bytes';
	}

	requestLogger = RequestLogger;
	return requestLogger;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredTracker;

function requireTracker () {
	if (hasRequiredTracker) return tracker;
	hasRequiredTracker = 1;

	/**
	 * Tracker module.
	 * @module tracker
	 */

	tracker.RequestLogger = requireRequestLogger();
	tracker.RequestTracker = requireRequestTracker();
	return tracker;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var clientMetrics;
var hasRequiredClientMetrics;

function requireClientMetrics () {
	if (hasRequiredClientMetrics) return clientMetrics;
	hasRequiredClientMetrics = 1;

	/**
	 * Represents a base class that is used to measure events from the server and the client as seen by the driver.
	 * @alias module:metrics~ClientMetrics
	 * @interface
	 */
	class ClientMetrics {
	  /**
	   * Method invoked when an authentication error is obtained from the server.
	   * @param {AuthenticationError|Error} e The error encountered.
	   */
	  onAuthenticationError(e) {}

	  /**
	   * Method invoked when an error (different than a server or client timeout, authentication or connection error) is
	   * encountered when executing a request.
	   * @param {OperationTimedOutError} e The timeout error.
	   */
	  onClientTimeoutError(e) {}

	  /**
	   * Method invoked when there is a connection error.
	   * @param {Error} e The error encountered.
	   */
	  onConnectionError(e) {}

	  /**
	   * Method invoked when an error (different than a server or client timeout, authentication or connection error) is
	   * encountered when executing a request.
	   * @param {Error} e The error encountered.
	   */
	  onOtherError(e) {}

	  /**
	   * Method invoked when a read timeout error is obtained from the server.
	   * @param {ResponseError} e The error encountered.
	   */
	  onReadTimeoutError(e) {}

	  /**
	   * Method invoked when a write timeout error is obtained from the server.
	   * @param {ResponseError} e The error encountered.
	   */
	  onWriteTimeoutError(e) {}

	  /**
	   * Method invoked when an unavailable error is obtained from the server.
	   * @param {ResponseError} e The error encountered.
	   */
	  onUnavailableError(e) {}

	  /**
	   * Method invoked when an execution is retried as a result of a client-level timeout.
	   * @param {Error} e The error that caused the retry.
	   */
	  onClientTimeoutRetry(e) {}

	  /**
	   * Method invoked when an error (other than a server or client timeout) is retried.
	   * @param {Error} e The error that caused the retry.
	   */
	  onOtherErrorRetry(e) {}

	  /**
	   * Method invoked when an execution is retried as a result of a read timeout from the server (coordinator to replica).
	   * @param {Error} e The error that caused the retry.
	   */
	  onReadTimeoutRetry(e) {}

	  /**
	   * Method invoked when an execution is retried as a result of an unavailable error from the server.
	   * @param {Error} e The error that caused the retry.
	   */
	  onUnavailableRetry(e) {}

	  /**
	   * Method invoked when an execution is retried as a result of a write timeout from the server (coordinator to
	   * replica).
	   * @param {Error} e The error that caused the retry.
	   */
	  onWriteTimeoutRetry(e) {}

	  /**
	   * Method invoked when an error is marked as ignored by the retry policy.
	   * @param {Error} e The error that was ignored by the retry policy.
	   */
	  onIgnoreError(e) {}

	  /**
	   * Method invoked when a speculative execution is started.
	   */
	  onSpeculativeExecution() {}

	  /**
	   * Method invoked when a response is obtained successfully.
	   * @param {Array<Number>} latency The latency represented in a <code>[seconds, nanoseconds]</code> tuple
	   * Array, where nanoseconds is the remaining part of the real time that can't be represented in second precision.
	   */
	  onSuccessfulResponse(latency) {}

	  /**
	   * Method invoked when any response is obtained, the response can be the result of a successful execution or a
	   * server-side error.
	   * @param {Array<Number>} latency The latency represented in a <code>[seconds, nanoseconds]</code> tuple
	   * Array, where nanoseconds is the remaining part of the real time that can't be represented in second precision.
	   */
	  onResponse(latency) {

	  }
	}

	clientMetrics = ClientMetrics;
	return clientMetrics;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var defaultMetrics;
var hasRequiredDefaultMetrics;

function requireDefaultMetrics () {
	if (hasRequiredDefaultMetrics) return defaultMetrics;
	hasRequiredDefaultMetrics = 1;

	const ClientMetrics = requireClientMetrics();
	const EventEmitter = require$$0$8;

	/**
	 * A default implementation of [ClientMetrics]{@link module:metrics~ClientMetrics} that exposes the driver events as
	 * Node.js events.
	 * <p>
	 *   An instance of [DefaultMetrics]{@link module:metrics~DefaultMetrics} is configured by default in the client,
	 *   you can access this instance using [Client#metrics]{@link Client#metrics} property.
	 * </p>
	 * @implements {module:metrics~ClientMetrics}
	 * @alias module:metrics~DefaultMetrics
	 * @example <caption>Listening to events emitted</caption>
	 * defaultMetrics.errors.on('increment', err => totalErrors++);
	 * defaultMetrics.errors.clientTimeout.on('increment', () => clientTimeoutErrors++);
	 * defaultMetrics.speculativeRetries.on('increment', () => specExecsCount++);
	 * defaultMetrics.responses.on('increment', latency => myHistogram.record(latency));
	 */
	class DefaultMetrics extends ClientMetrics {
	  /**
	   * Creates a new instance of [DefaultMetrics]{@link module:metrics~DefaultMetrics}.
	   */
	  constructor() {
	    super();

	    /**
	     * Emits all the error events.
	     * <p>Use each of the properties to measure events of specific errors.</p>
	     * @type {EventEmitter}
	     * @property {EventEmitter} authentication Emits the authentication timeout error events.
	     * @property {EventEmitter} clientTimeout Emits the client timeout error events.
	     * @property {EventEmitter} connection Emits the connection error events.
	     * @property {EventEmitter} readTimeout Emits the read timeout error events obtained from the server.
	     * @property {EventEmitter} other Emits the error events, that are not part of the other categories.
	     * @property {EventEmitter} unavailable Emits the unavailable error events obtained from the server.
	     * @property {EventEmitter} writeTimeout Emits the write timeout error events obtained from the server
	     */
	    this.errors = new EventEmitter();
	    this.errors.authentication = new EventEmitter();
	    this.errors.clientTimeout = new EventEmitter();
	    this.errors.connection = new EventEmitter();
	    this.errors.other = new EventEmitter();
	    this.errors.readTimeout = new EventEmitter();
	    this.errors.unavailable = new EventEmitter();
	    this.errors.writeTimeout = new EventEmitter();

	    /**
	     * Emits all the retry events.
	     * <p>Use each of the properties to measure events of specific retries.</p>
	     * @type {EventEmitter}
	     * @property {EventEmitter} clientTimeout Emits when an execution is retried as a result of an client timeout.
	     * @property {EventEmitter} other Emits the error events, that are not part of the other categories.
	     * @property {EventEmitter} readTimeout Emits an execution is retried as a result of an read timeout error from the
	     * server (coordinator to replica).
	     * @property {EventEmitter} unavailable Emits an execution is retried as a result of an unavailable error from the
	     * server.
	     * @property {EventEmitter} writeTimeout Emits an execution is retried as a result of a write timeout error from the
	     * server (coordinator to replica).
	     */
	    this.retries = new EventEmitter();
	    this.retries.clientTimeout = new EventEmitter();
	    this.retries.other = new EventEmitter();
	    this.retries.readTimeout = new EventEmitter();
	    this.retries.unavailable = new EventEmitter();
	    this.retries.writeTimeout = new EventEmitter();

	    /**
	     * Emits events when a speculative execution is started.
	     * @type {EventEmitter}
	     */
	    this.speculativeExecutions = new EventEmitter();

	    /**
	     * Emits events when an error is ignored by the retry policy.
	     * @type {EventEmitter}
	     */
	    this.ignoredErrors = new EventEmitter();

	    /**
	     * Emits events when a response message is obtained.
	     * @type {EventEmitter}
	     * @property {EventEmitter} success Emits when a response was obtained as the result of a successful execution.
	     */
	    this.responses = new EventEmitter();
	    this.responses.success = new EventEmitter();
	  }

	  /** @override */
	  onAuthenticationError(e) {
	    this.errors.authentication.emit('increment', e);
	    this.errors.emit('increment', e);}

	  /** @override */
	  onConnectionError(e) {
	    this.errors.connection.emit('increment', e);
	    this.errors.emit('increment', e);
	  }

	  /** @override */
	  onReadTimeoutError(e) {
	    this.errors.readTimeout.emit('increment', e);
	    this.errors.emit('increment', e);
	  }

	  /** @override */
	  onWriteTimeoutError(e) {
	    this.errors.writeTimeout.emit('increment', e);
	    this.errors.emit('increment', e);
	  }

	  /** @override */
	  onUnavailableError(e) {
	    this.errors.unavailable.emit('increment', e);
	    this.errors.emit('increment', e);
	  }

	  /** @override */
	  onClientTimeoutError(e) {
	    this.errors.clientTimeout.emit('increment', e);
	    this.errors.emit('increment', e);
	  }

	  /** @override */
	  onOtherError(e) {
	    this.errors.other.emit('increment', e);
	    this.errors.emit('increment', e);
	  }

	  /** @override */
	  onClientTimeoutRetry(e) {
	    this.retries.clientTimeout.emit('increment', e);
	    this.retries.emit('increment', e);
	  }

	  /** @override */
	  onOtherErrorRetry(e) {
	    this.retries.other.emit('increment', e);
	    this.retries.emit('increment', e);
	  }

	  /** @override */
	  onReadTimeoutRetry(e) {
	    this.retries.readTimeout.emit('increment', e);
	    this.retries.emit('increment', e);
	  }

	  /** @override */
	  onUnavailableRetry(e) {
	    this.retries.unavailable.emit('increment', e);
	    this.retries.emit('increment', e);
	  }

	  /** @override */
	  onWriteTimeoutRetry(e) {
	    this.retries.writeTimeout.emit('increment', e);
	    this.retries.emit('increment', e);
	  }

	  /** @override */
	  onIgnoreError(e) {
	    this.ignoredErrors.emit('increment', e);
	  }

	  /** @override */
	  onSpeculativeExecution() {
	    this.speculativeExecutions.emit('increment');
	  }

	  /** @override */
	  onSuccessfulResponse(latency) {
	    this.responses.success.emit('increment', latency);
	  }

	  /** @override */
	  onResponse(latency) {
	    this.responses.emit('increment', latency);
	  }
	}

	defaultMetrics = DefaultMetrics;
	return defaultMetrics;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var metrics$1;
var hasRequiredMetrics$1;

function requireMetrics$1 () {
	if (hasRequiredMetrics$1) return metrics$1;
	hasRequiredMetrics$1 = 1;

	const ClientMetrics = requireClientMetrics();
	const DefaultMetrics = requireDefaultMetrics();

	/**
	 * The <code>metrics</code> module contains interfaces and implementations used by the driver to expose
	 * measurements of its internal behavior and of the server as seen from the driver side.
	 * @module metrics
	 */

	metrics$1 = { ClientMetrics, DefaultMetrics };
	return metrics$1;
}var provider = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredProvider;

function requireProvider () {
	if (hasRequiredProvider) return provider;
	hasRequiredProvider = 1;
	/**
	 * @classdesc Provides [Authenticator]{@link module:auth~Authenticator} instances to be used when connecting to a host.
	 * @constructor
	 * @abstract
	 * @alias module:auth~AuthProvider
	 */
	function AuthProvider() {

	}

	/**
	 * Returns an [Authenticator]{@link module:auth~Authenticator} instance to be used when connecting to a host.
	 * @param {String} endpoint The ip address and port number in the format ip:port
	 * @param {String} name Authenticator name
	 * @abstract
	 * @returns {Authenticator}
	 */
	AuthProvider.prototype.newAuthenticator = function (endpoint, name) {
	  throw new Error('This is an abstract class, you must implement newAuthenticator method or ' +
	    'use another auth provider that inherits from this class');
	};

	/**
	 * @class
	 * @classdesc Handles SASL authentication with Cassandra servers.
	 * Each time a new connection is created and the server requires authentication,
	 * a new instance of this class will be created by the corresponding.
	 * @constructor
	 * @alias module:auth~Authenticator
	 */
	function Authenticator() {

	}

	/**
	 * Obtain an initial response token for initializing the SASL handshake.
	 * @param {Function} callback
	 */
	Authenticator.prototype.initialResponse = function (callback) {
	  callback(new Error('Not implemented'));
	};

	/**
	 * Evaluates a challenge received from the Server. Generally, this method should callback with
	 * no error and no additional params when authentication is complete from the client perspective.
	 * @param {Buffer} challenge
	 * @param {Function} callback
	 */
	Authenticator.prototype.evaluateChallenge = function (challenge, callback) {
	  callback(new Error('Not implemented'));
	};

	/**
	 * Called when authentication is successful with the last information
	 * optionally sent by the server.
	 * @param {Buffer} [token]
	 */
	Authenticator.prototype.onAuthenticationSuccess = function (token) {

	};

	provider.AuthProvider = AuthProvider;
	provider.Authenticator = Authenticator;
	return provider;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var plainTextAuthProvider;
var hasRequiredPlainTextAuthProvider;

function requirePlainTextAuthProvider () {
	if (hasRequiredPlainTextAuthProvider) return plainTextAuthProvider;
	hasRequiredPlainTextAuthProvider = 1;
	const util = require$$0$6;

	const provider = requireProvider();
	const utils = requireUtils$c();
	const AuthProvider = provider.AuthProvider;
	const Authenticator = provider.Authenticator;
	/**
	 * Creates a new instance of the Authenticator provider
	 * @classdesc Provides plain text [Authenticator]{@link module:auth~Authenticator} instances to be used when
	 * connecting to a host.
	 * @extends module:auth~AuthProvider
	 * @example
	 * var authProvider = new cassandra.auth.PlainTextAuthProvider('my_user', 'p@ssword1!');
	 * //Set the auth provider in the clientOptions when creating the Client instance
	 * const client = new Client({ contactPoints: contactPoints, authProvider: authProvider });
	 * @param {String} username User name in plain text
	 * @param {String} password Password in plain text
	 * @alias module:auth~PlainTextAuthProvider
	 * @constructor
	 */
	function PlainTextAuthProvider(username, password) {
	  this.username = username;
	  this.password = password;
	}

	util.inherits(PlainTextAuthProvider, AuthProvider);

	/**
	 * Returns a new [Authenticator]{@link module:auth~Authenticator} instance to be used for plain text authentication.
	 * @override
	 * @returns {Authenticator}
	 */
	PlainTextAuthProvider.prototype.newAuthenticator = function () {
	  return new PlainTextAuthenticator(this.username, this.password);
	};

	/**
	 * @ignore
	 */
	function PlainTextAuthenticator(username, password) {
	  this.username = username;
	  this.password = password;
	}

	util.inherits(PlainTextAuthenticator, Authenticator);

	PlainTextAuthenticator.prototype.initialResponse = function (callback) {
	  const initialToken = Buffer.concat([
	    utils.allocBufferFromArray([0]),
	    utils.allocBufferFromString(this.username, 'utf8'),
	    utils.allocBufferFromArray([0]),
	    utils.allocBufferFromString(this.password, 'utf8')
	  ]);
	  callback(null, initialToken);
	};

	PlainTextAuthenticator.prototype.evaluateChallenge = function (challenge, callback) {
	  //noop
	  callback();
	};

	plainTextAuthProvider = {
	  PlainTextAuthenticator,
	  PlainTextAuthProvider,
	};
	return plainTextAuthProvider;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var baseDseAuthenticator;
var hasRequiredBaseDseAuthenticator;

function requireBaseDseAuthenticator () {
	if (hasRequiredBaseDseAuthenticator) return baseDseAuthenticator;
	hasRequiredBaseDseAuthenticator = 1;
	const util = require$$0$6;
	const { Authenticator } = requireProvider();

	const dseAuthenticatorName = 'com.datastax.bdp.cassandra.auth.DseAuthenticator';

	/**
	 * Base class for Authenticator implementations that want to make use of
	 * the authentication scheme negotiation in the DseAuthenticator
	 * @param {String} authenticatorName
	 * @extends Authenticator
	 * @constructor
	 * @ignore
	 */
	function BaseDseAuthenticator(authenticatorName) {
	  this.authenticatorName = authenticatorName;
	}

	util.inherits(BaseDseAuthenticator, Authenticator);

	/**
	 * Return a Buffer containing the required SASL mechanism.
	 * @abstract
	 * @returns {Buffer}
	 */
	BaseDseAuthenticator.prototype.getMechanism = function () {
	  throw new Error('Not implemented');
	};

	/**
	 * Return a byte array containing the expected successful server challenge.
	 * @abstract
	 * @returns {Buffer}
	 */
	BaseDseAuthenticator.prototype.getInitialServerChallenge = function () {
	  throw new Error('Not implemented');
	};

	/**
	 * @param {Function} callback
	 * @override
	 */
	BaseDseAuthenticator.prototype.initialResponse = function (callback) {
	  if (!this._isDseAuthenticator()) {
	    //fallback
	    return this.evaluateChallenge(this.getInitialServerChallenge(), callback);
	  }
	  //send the mechanism as a first auth message
	  callback(null, this.getMechanism());
	};

	/**
	 * Determines if the name of the authenticator matches DSE 5+
	 * @protected
	 * @ignore
	 */
	BaseDseAuthenticator.prototype._isDseAuthenticator = function () {
	  return this.authenticatorName === dseAuthenticatorName;
	};

	baseDseAuthenticator = BaseDseAuthenticator;
	return baseDseAuthenticator;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var gssapiClient;
var hasRequiredGssapiClient;

function requireGssapiClient () {
	if (hasRequiredGssapiClient) return gssapiClient;
	hasRequiredGssapiClient = 1;

	const util = require$$0$6;
	const utils = requireUtils$c();

	/**
	 * GSSAPI Client interface.
	 * @ignore
	 */
	class GssapiClient {
	  /**
	   * @param {String} [authorizationId]
	   * @param {String} [service]
	   */
	  constructor(authorizationId, service) {
	    this.authorizationId = authorizationId;
	    this.service = service !== undefined ? service : 'dse';
	  }

	  /**
	   * @abstract
	   * @param {String} host Host name or ip
	   * @param {Function} callback
	   */
	  init(host, callback) {
	    throw new Error('Not implemented');
	  }

	  /**
	   * @param {Buffer} challenge
	   * @param {Function} callback
	   * @abstract
	   */
	  evaluateChallenge(challenge, callback) {
	    throw new Error('Not implemented');
	  }

	  /**
	   * @abstract
	   * @param {Function} [callback]
	   */
	  shutdown(callback) {
	    throw new Error('Not implemented');
	  }

	  /**
	   * Factory to get the actual implementation of GSSAPI (unix or win)
	   * @param {Object} kerberosModule Kerberos client library dependency
	   * @param {String} [authorizationId] An identity to act as (for proxy authentication).
	   * @param {String} [service] The service to use. (defaults to 'dse')
	   * @returns GssapiClient
	   */
	  static createNew(kerberosModule, authorizationId, service) {
	    return new StandardGssClient(kerberosModule, authorizationId, service);
	  }
	}

	/**
	 * GSSAPI Client implementation using kerberos module.
	 * @ignore
	 */
	class StandardGssClient extends GssapiClient {
	  constructor(kerberosModule, authorizationId, service) {
	    if (typeof kerberosModule.initializeClient !== 'function') {
	      throw new Error('The driver expects version 1.x of the kerberos library');
	    }

	    super(authorizationId, service);
	    this.kerberos = kerberosModule;
	    this.transitionIndex = 0;
	  }

	  init(host, callback) {
	    this.host = host;
	    let uri = this.service;
	    if (this.host) {
	      //For the principal    "dse/cassandra1.datastax.com@DATASTAX.COM"
	      //the expected uri is: "dse@cassandra1.datastax.com"
	      uri = util.format("%s@%s", this.service, this.host);
	    }
	    const options = {
	      gssFlags: this.kerberos.GSS_C_MUTUAL_FLAG //authenticate itself flag
	    };
	    this.kerberos.initializeClient(uri, options, (err, kerberosClient) => {
	      if (err) {
	        return callback(err);
	      }
	      this.kerberosClient = kerberosClient;
	      callback();
	    });
	  }

	  /** @override */
	  evaluateChallenge(challenge, callback) {
	    this['transition' + this.transitionIndex](challenge, (err, response) => {
	      if (err) {
	        return callback(err);
	      }
	      this.transitionIndex++;
	      callback(null, response ? utils.allocBufferFromString(response, 'base64') : utils.allocBuffer(0));
	    });
	  }

	  transition0(challenge, callback) {
	    this.kerberosClient.step('', callback);
	  }

	  transition1(challenge, callback) {
	    const charPointerChallenge = challenge.toString('base64');
	    this.kerberosClient.step(charPointerChallenge, callback);
	  }

	  transition2(challenge, callback) {
	    this.kerberosClient.unwrap(challenge.toString('base64'), (err, response) => {
	      if (err) {
	        return callback(err, false);
	      }
	      const cb = function (err, wrapped) {
	        if (err) {
	          return callback(err);
	        }
	        callback(null, wrapped);
	      };
	      if (this.authorizationId !== undefined) {
	        this.kerberosClient.wrap(response, { user: this.authorizationId }, cb);
	      }
	      else {
	        this.kerberosClient.wrap(response, null, cb);
	      }
	    });
	  }

	  shutdown(callback) {
	    this.kerberosClient = null;
	    callback();
	  }
	}

	gssapiClient = GssapiClient;
	return gssapiClient;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var dseGssapiAuthProvider;
var hasRequiredDseGssapiAuthProvider;

function requireDseGssapiAuthProvider () {
	if (hasRequiredDseGssapiAuthProvider) return dseGssapiAuthProvider;
	hasRequiredDseGssapiAuthProvider = 1;
	const util = require$$0$6;
	const { AuthProvider } = requireProvider();
	const BaseDseAuthenticator = requireBaseDseAuthenticator();
	const GssapiClient = requireGssapiClient();
	const dns = require$$0$9;
	const utils = requireUtils$c();

	const mechanism = utils.allocBufferFromString('GSSAPI');
	const initialServerChallenge = 'GSSAPI-START';
	const emptyBuffer = utils.allocBuffer(0);

	/**
	 * Creates a new instance of <code>DseGssapiAuthProvider</code>.
	 * @classdesc
	 * AuthProvider that provides GSSAPI authenticator instances for clients to connect
	 * to DSE clusters secured with the DseAuthenticator.
	 * @param {Object} [gssOptions] GSSAPI authenticator options
	 * @param {String} [gssOptions.authorizationId] The optional authorization ID. Providing an authorization ID allows the
	 * currently authenticated user to act as a different user (a.k.a. proxy authentication).
	 * @param {String} [gssOptions.service] The service to use. Defaults to 'dse'.
	 * @param {Function} [gssOptions.hostNameResolver] A method to be used to resolve the name of the Cassandra node based
	 * on the IP Address.  Defaults to [lookupServiceResolver]{@link module:auth~DseGssapiAuthProvider.lookupServiceResolver}
	 * which resolves the FQDN of the provided IP to generate principals in the format of
	 * <code>dse/example.com@MYREALM.COM</code>.
	 * Alternatively, you can use [reverseDnsResolver]{@link module:auth~DseGssapiAuthProvider.reverseDnsResolver} to do a
	 * reverse DNS lookup or [useIpResolver]{@link module:auth~DseGssapiAuthProvider.useIpResolver} to simply use the IP
	 * address provided.
	 * @param {String} [gssOptions.user] DEPRECATED, it will be removed in future versions. For proxy authentication, use
	 * <code>authorizationId</code> instead.
	 * @example
	 * const client = new cassandra.Client({
	 *   contactPoints: ['h1', 'h2'],
	 *   authProvider: new cassandra.auth.DseGssapiAuthProvider()
	 * });
	 * @alias module:auth~DseGssapiAuthProvider
	 * @constructor
	 */
	function DseGssapiAuthProvider(gssOptions) {
	  //load the kerberos at construction time
	  try {
	    // eslint-disable-next-line
	    this._kerberos = require('kerberos');
	  }
	  catch (err) {
	    if (err.code === 'MODULE_NOT_FOUND') {
	      const newErr = new Error('You must install module "kerberos" to use GSSAPI auth provider: ' +
	        'https://www.npmjs.com/package/kerberos');
	      newErr.code = err.code;
	      throw newErr;
	    }
	    throw err;
	  }
	  gssOptions = gssOptions || utils.emptyObject;
	  this.authorizationId = gssOptions.authorizationId || gssOptions.user;
	  this.service = gssOptions.service;
	  this.hostNameResolver = gssOptions.hostNameResolver || DseGssapiAuthProvider.lookupServiceResolver;
	}

	util.inherits(DseGssapiAuthProvider, AuthProvider);

	/**
	 * Returns an Authenticator instance to be used by the driver when connecting to a host.
	 * @param {String} endpoint The IP address and port number in the format ip:port.
	 * @param {String} name Authenticator name.
	 * @override
	 * @returns {Authenticator}
	 */
	DseGssapiAuthProvider.prototype.newAuthenticator = function (endpoint, name) {
	  let address = endpoint;
	  if (endpoint.indexOf(':') > 0) {
	    address = endpoint.split(':')[0];
	  }
	  return new GssapiAuthenticator(
	    this._kerberos, address, name, this.authorizationId, this.service, this.hostNameResolver);
	};

	/**
	 * Performs a lookupService query that resolves an IPv4 or IPv6 address to a hostname.  This ultimately makes a
	 * <code>getnameinfo()</code> system call which depends on the OS to do hostname resolution.
	 * <p/>
	 * <b>Note:</b> Depends on <code>dns.lookupService</code> which was added in 0.12.  For older versions falls back on
	 * [reverseDnsResolver]{@link module:auth~DseGssapiAuthProvider.reverseDnsResolver}.
	 *
	 * @param {String} ip IP address to resolve.
	 * @param {Function} callback The callback function with <code>err</code> and <code>hostname</code> arguments.
	 */
	DseGssapiAuthProvider.lookupServiceResolver = function (ip, callback) {
	  if (!dns.lookupService) {
	    return DseGssapiAuthProvider.reverseDnsResolver(ip, callback);
	  }
	  dns.lookupService(ip, 0, function (err, hostname) {
	    if (err) {
	      return callback(err);
	    }
	    if (!hostname) {
	      //fallback to ip
	      return callback(null, ip);
	    }
	    callback(null, hostname);
	  });
	};

	/**
	 * Performs a reverse DNS query that resolves an IPv4 or IPv6 address to a hostname.
	 * @param {String} ip IP address to resolve.
	 * @param {Function} callback The callback function with <code>err</code> and <code>hostname</code> arguments.
	 */
	DseGssapiAuthProvider.reverseDnsResolver = function (ip, callback) {
	  dns.reverse(ip, function (err, names) {
	    if (err) {
	      return callback(err);
	    }
	    if (!names || !names.length) {
	      //fallback to ip
	      return callback(null, ip);
	    }
	    callback(null, names[0]);
	  });
	};

	/**
	 * Effectively a no op operation, returns the IP address provided.
	 * @param {String} ip IP address to use.
	 * @param {Function} callback The callback function with <code>err</code> and <code>hostname</code> arguments.
	 */
	DseGssapiAuthProvider.useIpResolver = function (ip, callback) {
	  callback(null, ip);
	};

	/**
	 * @param {Object} kerberosModule
	 * @param {String} address Host address.
	 * @param {String} authenticatorName
	 * @param {String} authorizationId
	 * @param {String} service
	 * @param {Function} hostNameResolver
	 * @extends Authenticator
	 * @private
	 */
	function GssapiAuthenticator(kerberosModule, address, authenticatorName, authorizationId, service, hostNameResolver) {
	  BaseDseAuthenticator.call(this, authenticatorName);
	  this.authorizationId = authorizationId;
	  this.address = address;
	  this.client = GssapiClient.createNew(kerberosModule, authorizationId, service);
	  this.hostNameResolver = hostNameResolver;
	}

	//noinspection JSCheckFunctionSignatures
	util.inherits(GssapiAuthenticator, BaseDseAuthenticator);

	GssapiAuthenticator.prototype.getMechanism = function () {
	  return mechanism;
	};

	GssapiAuthenticator.prototype.getInitialServerChallenge = function () {
	  return utils.allocBufferFromString(initialServerChallenge);
	};

	//noinspection JSUnusedGlobalSymbols
	/**
	 * Obtain an initial response token for initializing the SASL handshake.
	 * @param {Function} callback
	 */
	GssapiAuthenticator.prototype.initialResponse = function (callback) {
	  const self = this;
	  //initialize the GSS client
	  let host = this.address;
	  utils.series([
	    function getHostName(next) {
	      self.hostNameResolver(self.address, function (err, name) {
	        if (!err && name) {
	          host = name;
	        }
	        next();
	      });
	    },
	    function initClient(next) {
	      self.client.init(host, function (err) {
	        if (err) {
	          return next(err);
	        }
	        if (!self._isDseAuthenticator()) {
	          //fallback
	          return self.evaluateChallenge(self.getInitialServerChallenge(), next);
	        }
	        //send the mechanism as a first auth message
	        next(null, self.getMechanism());
	      });
	    }
	  ], callback);
	};

	/**
	 * Evaluates a challenge received from the Server. Generally, this method should callback with
	 * no error and no additional params when authentication is complete from the client perspective.
	 * @param {Buffer} challenge
	 * @param {Function} callback
	 * @override
	 */
	GssapiAuthenticator.prototype.evaluateChallenge = function (challenge, callback) {
	  if (!challenge || challenge.toString() === initialServerChallenge) {
	    challenge = emptyBuffer;
	  }
	  this.client.evaluateChallenge(challenge, callback);
	};

	/**
	 * @override
	 */
	GssapiAuthenticator.prototype.onAuthenticationSuccess = function (token) {
	  this.client.shutdown(function noop() { });
	};


	dseGssapiAuthProvider = DseGssapiAuthProvider;
	return dseGssapiAuthProvider;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var dsePlainTextAuthProvider;
var hasRequiredDsePlainTextAuthProvider;

function requireDsePlainTextAuthProvider () {
	if (hasRequiredDsePlainTextAuthProvider) return dsePlainTextAuthProvider;
	hasRequiredDsePlainTextAuthProvider = 1;
	const util = require$$0$6;
	const { AuthProvider } = requireProvider();
	const BaseDseAuthenticator = requireBaseDseAuthenticator();
	const utils = requireUtils$c();

	const mechanism = utils.allocBufferFromString('PLAIN');
	const separatorBuffer = utils.allocBufferFromArray([0]);
	const initialServerChallenge = 'PLAIN-START';

	/**
	 * Creates a new instance of <code>DsePlainTextAuthProvider</code>.
	 * @classdesc
	 * AuthProvider that provides plain text authenticator instances for clients to connect
	 * to DSE clusters secured with the DseAuthenticator.
	 * @param {String} username The username; cannot be <code>null</code>.
	 * @param {String} password The password; cannot be <code>null</code>.
	 * @param {String} [authorizationId] The optional authorization ID. Providing an authorization ID allows the currently
	 * authenticated user to act as a different user (a.k.a. proxy authentication).
	 * @extends AuthProvider
	 * @alias module:auth~DsePlainTextAuthProvider
	 * @example
	 * const client = new cassandra.Client({
	 *   contactPoints: ['h1', 'h2'],
	 *   authProvider: new cassandra.auth.DsePlainTextAuthProvider('user', 'p@ssword1');
	 * });
	 * @constructor
	 */
	function DsePlainTextAuthProvider(username, password, authorizationId) {
	  if (typeof username !== 'string' || typeof password !== 'string') {
	    // Validate for null and undefined
	    throw new TypeError('Username and password must be a string');
	  }
	  this.username = username;
	  this.password = password;
	  this.authorizationId = authorizationId;
	}

	util.inherits(DsePlainTextAuthProvider, AuthProvider);

	/**
	 * Returns an Authenticator instance to be used by the driver when connecting to a host.
	 * @param {String} endpoint The IP address and port number in the format ip:port.
	 * @param {String} name Authenticator name.
	 * @override
	 * @returns {Authenticator}
	 */
	DsePlainTextAuthProvider.prototype.newAuthenticator = function (endpoint, name) {
	  return new PlainTextAuthenticator(name, this.username, this.password, this.authorizationId);
	};

	/**
	 * @param {String} authenticatorName
	 * @param {String} authenticatorId
	 * @param {String} password
	 * @param {String} authorizationId
	 * @extends BaseDseAuthenticator
	 * @constructor
	 * @private
	 */
	function PlainTextAuthenticator(authenticatorName, authenticatorId, password, authorizationId) {
	  BaseDseAuthenticator.call(this, authenticatorName);
	  this.authenticatorId = utils.allocBufferFromString(authenticatorId);
	  this.password = utils.allocBufferFromString(password);
	  this.authorizationId = utils.allocBufferFromString(authorizationId || '');
	}

	util.inherits(PlainTextAuthenticator, BaseDseAuthenticator);

	/** @override */
	PlainTextAuthenticator.prototype.getMechanism = function () {
	  return mechanism;
	};

	/** @override */
	PlainTextAuthenticator.prototype.getInitialServerChallenge = function () {
	  return utils.allocBufferFromString(initialServerChallenge);
	};

	/** @override */
	PlainTextAuthenticator.prototype.evaluateChallenge = function (challenge, callback) {
	  if (!challenge || challenge.toString() !== initialServerChallenge) {
	    return callback(new Error('Incorrect SASL challenge from server'));
	  }
	  // The SASL plain text format is authorizationId 0 username 0 password
	  callback(null, Buffer.concat([
	    this.authorizationId,
	    separatorBuffer,
	    this.authenticatorId,
	    separatorBuffer,
	    this.password
	  ]));
	};

	dsePlainTextAuthProvider = DsePlainTextAuthProvider;
	return dsePlainTextAuthProvider;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var noAuthProvider;
var hasRequiredNoAuthProvider;

function requireNoAuthProvider () {
	if (hasRequiredNoAuthProvider) return noAuthProvider;
	hasRequiredNoAuthProvider = 1;

	const { AuthProvider, Authenticator } = requireProvider();
	const { PlainTextAuthenticator } = requirePlainTextAuthProvider();
	const errors = requireErrors$c();

	const dseAuthenticator = 'com.datastax.bdp.cassandra.auth.DseAuthenticator';

	/**
	 * Internal authentication provider that is used when no provider has been set by the user.
	 * @ignore
	 */
	class NoAuthProvider extends AuthProvider {
	  newAuthenticator(endpoint, name) {
	    if (name === dseAuthenticator) {
	      // Try to use transitional mode
	      return new TransitionalModePlainTextAuthenticator();
	    }

	    // Use an authenticator that doesn't allow auth flow
	    return new NoAuthAuthenticator(endpoint);
	  }
	}

	/**
	 * An authenticator throws an error when authentication flow is started.
	 * @ignore
	 */
	class NoAuthAuthenticator extends Authenticator {
	  constructor(endpoint) {
	    super();
	    this.endpoint = endpoint;
	  }

	  initialResponse(callback) {
	    callback(new errors.AuthenticationError(
	      `Host ${this.endpoint} requires authentication, but no authenticator found in the options`));
	  }
	}

	/**
	 * Authenticator that accounts for DSE authentication configured with transitional mode: normal.
	 *
	 * In this situation, the client is allowed to connect without authentication, but DSE
	 * would still send an AUTHENTICATE response. This Authenticator handles this situation
	 * by sending back a dummy credential.
	 */
	class TransitionalModePlainTextAuthenticator extends PlainTextAuthenticator {
	  constructor() {
	    super('', '');
	  }
	}

	noAuthProvider = NoAuthProvider;
	return noAuthProvider;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var auth;
var hasRequiredAuth;

function requireAuth () {
	if (hasRequiredAuth) return auth;
	hasRequiredAuth = 1;

	/**
	 * DSE Authentication module.
	 * <p>
	 *   Contains the classes used for connecting to a DSE cluster secured with DseAuthenticator.
	 * </p>
	 * @module auth
	 */

	const { Authenticator, AuthProvider } = requireProvider();
	const { PlainTextAuthProvider } = requirePlainTextAuthProvider();
	const DseGssapiAuthProvider = requireDseGssapiAuthProvider();
	const DsePlainTextAuthProvider = requireDsePlainTextAuthProvider();
	const NoAuthProvider = requireNoAuthProvider();

	auth = {
	  Authenticator,
	  AuthProvider,
	  DseGssapiAuthProvider,
	  DsePlainTextAuthProvider,
	  NoAuthProvider,
	  PlainTextAuthProvider
	};
	return auth;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredClientOptions;

function requireClientOptions () {
	if (hasRequiredClientOptions) return clientOptions;
	hasRequiredClientOptions = 1;

	const util = require$$0$6;
	const policies = requirePolicies();
	const types = requireTypes$2();
	const utils = requireUtils$c();
	const tracker = requireTracker();
	const metrics = requireMetrics$1();
	const auth = requireAuth();

	/** Core connections per host for protocol versions 1 and 2 */
	const coreConnectionsPerHostV2 = {
	  [types.distance.local]: 2,
	  [types.distance.remote]: 1,
	  [types.distance.ignored]: 0
	};

	/** Core connections per host for protocol version 3 and above */
	const coreConnectionsPerHostV3 = {
	  [types.distance.local]: 1,
	  [types.distance.remote]: 1,
	  [types.distance.ignored]: 0
	};

	/** Default maxRequestsPerConnection value for protocol v1 and v2 */
	const maxRequestsPerConnectionV2 = 128;

	/** Default maxRequestsPerConnection value for protocol v3+ */
	const maxRequestsPerConnectionV3 = 2048;

	const continuousPageUnitBytes = 'bytes';
	const continuousPageDefaultSize = 5000;
	const continuousPageDefaultHighWaterMark = 10000;

	/**
	 * @returns {ClientOptions}
	 */
	function defaultOptions () {
	  return ({
	    policies: {
	      addressResolution: policies.defaultAddressTranslator(),
	      loadBalancing: policies.defaultLoadBalancingPolicy(),
	      reconnection: policies.defaultReconnectionPolicy(),
	      retry: policies.defaultRetryPolicy(),
	      speculativeExecution: policies.defaultSpeculativeExecutionPolicy(),
	      timestampGeneration: policies.defaultTimestampGenerator()
	    },
	    queryOptions: {
	      fetchSize: 5000,
	      prepare: false,
	      captureStackTrace: false
	    },
	    protocolOptions: {
	      port: 9042,
	      maxSchemaAgreementWaitSeconds: 10,
	      maxVersion: 0,
	      noCompact: false
	    },
	    pooling: {
	      heartBeatInterval: 30000,
	      warmup: true
	    },
	    socketOptions: {
	      connectTimeout: 5000,
	      defunctReadTimeoutThreshold: 64,
	      keepAlive: true,
	      keepAliveDelay: 0,
	      readTimeout: 12000,
	      tcpNoDelay: true,
	      coalescingThreshold: 65536
	    },
	    authProvider: null,
	    requestTracker: null,
	    metrics: new metrics.DefaultMetrics(),
	    maxPrepared: 500,
	    refreshSchemaDelay: 1000,
	    isMetadataSyncEnabled: true,
	    prepareOnAllHosts: true,
	    rePrepareOnUp: true,
	    encoding: {
	      copyBuffer: true,
	      useUndefinedAsUnset: true
	    },
	    monitorReporting: {
	      enabled: true
	    }
	  });
	}

	/**
	 * Extends and validates the user options
	 * @param {Object} [baseOptions] The source object instance that will be overridden
	 * @param {Object} userOptions
	 * @returns {Object}
	 */
	function extend(baseOptions, userOptions) {
	  if (arguments.length === 1) {
	    userOptions = arguments[0];
	    baseOptions = {};
	  }
	  const options = utils.deepExtend(baseOptions, defaultOptions(), userOptions);

	  if (!options.cloud) {
	    if (!Array.isArray(options.contactPoints) || options.contactPoints.length === 0) {
	      throw new TypeError('Contacts points are not defined.');
	    }

	    for (let i = 0; i < options.contactPoints.length; i++) {
	      const hostName = options.contactPoints[i];
	      if (!hostName) {
	        throw new TypeError(util.format('Contact point %s (%s) is not a valid host name, ' +
	          'the following values are valid contact points: ipAddress, hostName or ipAddress:port', i, hostName));
	      }
	    }

	    options.sni = undefined;
	  } else {
	    validateCloudOptions(options);
	  }

	  if (!options.logEmitter) {
	    options.logEmitter = function () {};
	  }
	  if (!options.queryOptions) {
	    throw new TypeError('queryOptions not defined in options');
	  }

	  if (options.requestTracker !== null && !(options.requestTracker instanceof tracker.RequestTracker)) {
	    throw new TypeError('requestTracker must be an instance of RequestTracker');
	  }

	  if (!(options.metrics instanceof metrics.ClientMetrics)) {
	    throw new TypeError('metrics must be an instance of ClientMetrics');
	  }

	  validatePoliciesOptions(options.policies);

	  validateProtocolOptions(options.protocolOptions);

	  validateSocketOptions(options.socketOptions);

	  validateAuthenticationOptions(options);

	  options.encoding = options.encoding || {};

	  validateEncodingOptions(options.encoding);

	  if (options.profiles && !Array.isArray(options.profiles)) {
	    throw new TypeError('profiles must be an Array of ExecutionProfile instances');
	  }

	  validateApplicationInfo(options);

	  validateMonitorReporting(options);

	  return options;
	}

	/**
	 * Validates the options to connect to a cloud instance.
	 * @private
	 */
	function validateCloudOptions(options) {
	  const bundle = options.cloud.secureConnectBundle;

	  // eslint-disable-next-line no-undef
	  if (!(typeof bundle === 'string' || (typeof URL !== 'undefined' && bundle instanceof URL))) {
	    throw new TypeError('secureConnectBundle in cloud options must be of type string');
	  }

	  if (options.contactPoints) {
	    throw new TypeError('Contact points can not be defined when cloud settings are provided');
	  }

	  if (options.sslOptions) {
	    throw new TypeError('SSL options can not be defined when cloud settings are provided');
	  }
	}

	/**
	 * Validates the policies from the client options.
	 * @param {ClientOptions.policies} policiesOptions
	 * @private
	 */
	function validatePoliciesOptions(policiesOptions) {
	  if (!policiesOptions) {
	    throw new TypeError('policies not defined in options');
	  }
	  if (!(policiesOptions.loadBalancing instanceof policies.loadBalancing.LoadBalancingPolicy)) {
	    throw new TypeError('Load balancing policy must be an instance of LoadBalancingPolicy');
	  }
	  if (!(policiesOptions.reconnection instanceof policies.reconnection.ReconnectionPolicy)) {
	    throw new TypeError('Reconnection policy must be an instance of ReconnectionPolicy');
	  }
	  if (!(policiesOptions.retry instanceof policies.retry.RetryPolicy)) {
	    throw new TypeError('Retry policy must be an instance of RetryPolicy');
	  }
	  if (!(policiesOptions.addressResolution instanceof policies.addressResolution.AddressTranslator)) {
	    throw new TypeError('Address resolution policy must be an instance of AddressTranslator');
	  }
	  if (policiesOptions.timestampGeneration !== null &&
	    !(policiesOptions.timestampGeneration instanceof policies.timestampGeneration.TimestampGenerator)) {
	    throw new TypeError('Timestamp generation policy must be an instance of TimestampGenerator');
	  }
	}

	/**
	 * Validates the protocol options.
	 * @param {ClientOptions.protocolOptions} protocolOptions
	 * @private
	 */
	function validateProtocolOptions(protocolOptions) {
	  if (!protocolOptions) {
	    throw new TypeError('protocolOptions not defined in options');
	  }
	  const version = protocolOptions.maxVersion;
	  if (version && (typeof version !== 'number' || !types.protocolVersion.isSupported(version))) {
	    throw new TypeError(util.format('protocolOptions.maxVersion provided (%s) is invalid', version));
	  }
	}

	/**
	 * Validates the socket options.
	 * @param {ClientOptions.socketOptions} socketOptions
	 * @private
	 */
	function validateSocketOptions(socketOptions) {
	  if (!socketOptions) {
	    throw new TypeError('socketOptions not defined in options');
	  }
	  if (typeof socketOptions.readTimeout !== 'number') {
	    throw new TypeError('socketOptions.readTimeout must be a Number');
	  }
	  if (typeof socketOptions.coalescingThreshold !== 'number' || socketOptions.coalescingThreshold <= 0) {
	    throw new TypeError('socketOptions.coalescingThreshold must be a positive Number');
	  }
	}

	/**
	 * Validates authentication provider and credentials.
	 * @param {ClientOptions} options
	 * @private
	 */
	function validateAuthenticationOptions(options) {
	  if (!options.authProvider) {
	    const credentials = options.credentials;
	    if (credentials) {
	      if (typeof credentials.username !== 'string' || typeof credentials.password !== 'string') {
	        throw new TypeError('credentials username and password must be a string');
	      }

	      options.authProvider = new auth.PlainTextAuthProvider(credentials.username, credentials.password);
	    } else {
	      options.authProvider = new auth.NoAuthProvider();
	    }
	  } else if (!(options.authProvider instanceof auth.AuthProvider)) {
	    throw new TypeError('options.authProvider must be an instance of AuthProvider');
	  }
	}

	/**
	 * Validates the encoding options.
	 * @param {ClientOptions.encoding} encodingOptions
	 * @private
	 */
	function validateEncodingOptions(encodingOptions) {
	  if (encodingOptions.map) {
	    const mapConstructor = encodingOptions.map;
	    if (typeof mapConstructor !== 'function' ||
	      typeof mapConstructor.prototype.forEach !== 'function' ||
	      typeof mapConstructor.prototype.set !== 'function') {
	      throw new TypeError('Map constructor not valid');
	    }
	  }

	  if (encodingOptions.set) {
	    const setConstructor = encodingOptions.set;
	    if (typeof setConstructor !== 'function' ||
	      typeof setConstructor.prototype.forEach !== 'function' ||
	      typeof setConstructor.prototype.add !== 'function') {
	      throw new TypeError('Set constructor not valid');
	    }
	  }

	  if ((encodingOptions.useBigIntAsLong || encodingOptions.useBigIntAsVarint) && typeof BigInt === 'undefined') {
	    throw new TypeError('BigInt is not supported by the JavaScript engine');
	  }
	}

	function validateApplicationInfo(options) {
	  function validateString(key) {
	    const str = options[key];

	    if (str !== null && str !== undefined && typeof str !== 'string') {
	      throw new TypeError(`${key} should be a String`);
	    }
	  }

	  validateString('applicationName');
	  validateString('applicationVersion');

	  if (options.id !== null && options.id !== undefined && !(options.id instanceof types.Uuid)) {
	    throw new TypeError('Client id must be a Uuid');
	  }
	}

	function validateMonitorReporting(options) {
	  const o = options.monitorReporting;
	  if (o === null || typeof o !== 'object') {
	    throw new TypeError(`Monitor reporting must be an object, obtained: ${o}`);
	  }
	}

	/**
	 * Sets the default options that depend on the protocol version and other metadata.
	 * @param {Client} client
	 */
	function setMetadataDependent(client) {
	  const version = client.controlConnection.protocolVersion;
	  let coreConnectionsPerHost = coreConnectionsPerHostV3;
	  let maxRequestsPerConnection = maxRequestsPerConnectionV3;

	  if (!types.protocolVersion.uses2BytesStreamIds(version)) {
	    coreConnectionsPerHost = coreConnectionsPerHostV2;
	    maxRequestsPerConnection = maxRequestsPerConnectionV2;
	  }

	  if (client.options.queryOptions.consistency === undefined) {
	    client.options.queryOptions.consistency =
	      client.metadata.isDbaas() ? types.consistencies.localQuorum : types.consistencies.localOne;
	  }

	  client.options.pooling = utils.deepExtend(
	    {}, { coreConnectionsPerHost, maxRequestsPerConnection }, client.options.pooling);
	}

	clientOptions.extend = extend;
	clientOptions.defaultOptions = defaultOptions;
	clientOptions.coreConnectionsPerHostV2 = coreConnectionsPerHostV2;
	clientOptions.coreConnectionsPerHostV3 = coreConnectionsPerHostV3;
	clientOptions.maxRequestsPerConnectionV2 = maxRequestsPerConnectionV2;
	clientOptions.maxRequestsPerConnectionV3 = maxRequestsPerConnectionV3;
	clientOptions.setMetadataDependent = setMetadataDependent;
	clientOptions.continuousPageUnitBytes = continuousPageUnitBytes;
	clientOptions.continuousPageDefaultSize = continuousPageDefaultSize;
	clientOptions.continuousPageDefaultHighWaterMark = continuousPageDefaultHighWaterMark;
	return clientOptions;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var executionProfile;
var hasRequiredExecutionProfile;

function requireExecutionProfile () {
	if (hasRequiredExecutionProfile) return executionProfile;
	hasRequiredExecutionProfile = 1;

	const utils = requireUtils$c();
	const types = requireTypes$2();
	const promiseUtils = requirePromiseUtils();

	/**
	 * Creates a new instance of {@link ExecutionProfile}.
	 * @classdesc
	 * Represents a set configurations to be used in a statement execution to be used for a single {@link Client} instance.
	 * <p>
	 *   An {@link ExecutionProfile} instance should not be shared across different {@link Client} instances.
	 * </p>
	 * @param {String} name Name of the execution profile.
	 * <p>
	 *   Use <code>'default'</code> to specify that the new instance should be the default {@link ExecutionProfile} if no
	 *   profile is specified in the execution.
	 * </p>
	 * @param {Object} [options] Profile options, when any of the options is not specified the {@link Client} will the use
	 * the ones defined in the default profile.
	 * @param {Number} [options.consistency] The consistency level to use for this profile.
	 * @param {LoadBalancingPolicy} [options.loadBalancing] The load-balancing policy to use for this profile.
	 * @param {Number} [options.readTimeout] The client per-host request timeout to use for this profile.
	 * @param {RetryPolicy} [options.retry] The retry policy to use for this profile.
	 * @param {Number} [options.serialConsistency] The serial consistency level to use for this profile.
	 * @param {Object} [options.graphOptions]
	 * @param {String} [options.graphOptions.language] The graph language to use for graph queries.
	 * <p>
	 *   Note that this setting should normally be <code>undefined</code> or set by a utility method and it's not expected
	 *   to be defined manually by the user.
	 * </p>
	 * @param {String} [options.graphOptions.results] The protocol to use for serializing and deserializing graph results.
	 * <p>
	 *   Note that this setting should normally be <code>undefined</code> or set by a utility method and it's not expected
	 *   to be defined manually by the user.
	 * </p>
	 * @param {String} [options.graphOptions.name] The graph name to use for graph queries.
	 * @param {Number} [options.graphOptions.readConsistency] The consistency level to use for graph read queries.
	 * @param {String} [options.graphOptions.source] The graph traversal source name to use for graph queries.
	 * @param {Number} [options.graphOptions.writeConsistency] The consistency level to use for graph write queries.
	 * @param {LoadBalancingPolicy} [options.loadBalancing] The load-balancing policy to use for this profile.
	 * @param {Number} [options.readTimeout] The client per-host request timeout to use for this profile.
	 * @param {RetryPolicy} [options.retry] The retry policy to use for this profile.
	 * @param {Number} [options.serialConsistency] The serial consistency level to use for this profile.
	 * @example
	 * const { Client, ExecutionProfile } = require('cassandra-driver');
	 * const client = new Client({
	 *   contactPoints: ['host1', 'host2'],
	 *   profiles: [
	 *     new ExecutionProfile('metrics-oltp', {
	 *       consistency: consistency.localQuorum,
	 *       retry: myRetryPolicy
	 *     })
	 *   ]
	 * });
	 *
	 * client.execute(query, params, { executionProfile: 'metrics-oltp' }, callback);
	 * @constructor
	 */
	function ExecutionProfile(name, options) {
	  if (typeof name !== 'string') {
	    throw new TypeError('Execution profile name must be a string');
	  }
	  options = options || utils.emptyObject;
	  const graphOptions = options.graphOptions || utils.emptyObject;
	  /**
	   * Name of the execution profile.
	   * @type {String}
	   */
	  this.name = name;
	  /**
	   * Consistency level.
	   * @type {Number}
	   */
	  this.consistency = options.consistency;
	  /**
	   * Load-balancing policy
	   * @type {LoadBalancingPolicy}
	   */
	  this.loadBalancing = options.loadBalancing;
	  /**
	   * Client read timeout.
	   * @type {Number}
	   */
	  this.readTimeout = options.readTimeout;
	  /**
	   * Retry policy.
	   * @type {RetryPolicy}
	   */
	  this.retry = options.retry;
	  /**
	   * Serial consistency level.
	   * @type {Number}
	   */
	  this.serialConsistency = options.serialConsistency;
	  /**
	   * The graph options for this profile.
	   * @type {Object}
	   * @property {String} language The graph language.
	   * @property {String} name The graph name.
	   * @property {String} readConsistency The consistency to use for graph write queries.
	   * @property {String} source The graph traversal source.
	   * @property {String} writeConsistency The consistency to use for graph write queries.
	   */
	  this.graphOptions = {
	    language: graphOptions.language,
	    results: graphOptions.results,
	    name: graphOptions.name,
	    readConsistency: graphOptions.readConsistency,
	    source: graphOptions.source,
	    writeConsistency: graphOptions.writeConsistency
	  };
	}

	/**
	 * Contains the logic to handle the different execution profiles of a {@link Client}.
	 * @ignore
	 */
	class ProfileManager {

	  /**
	   * @param {ClientOptions} options
	   */
	  constructor(options) {
	    this._profiles = options.profiles || [];
	    this._defaultConfiguredRetryPolicy = undefined;
	    this._setDefault(options);
	    // A array of unique load balancing policies
	    this._loadBalancingPolicies = [];
	    // A dictionary of name keys and profile values
	    this._profilesMap = {};
	    // A dictionary of name keys and custom payload dictionaries as values
	    this._customPayloadCache = {};
	    // A dictionary of name keys and graph options as values
	    this._graphOptionsCache = {};
	    this._profiles.forEach(function (p) {
	      this._profilesMap[p.name] = p;
	      // Set required properties
	      p.loadBalancing = p.loadBalancing || this._defaultProfile.loadBalancing;
	      // Using array indexOf is not very efficient (O(n)) but the amount of profiles should be limited
	      // and a handful of load-balancing policies (no hashcode for load-Balancing policies)
	      if (this._loadBalancingPolicies.indexOf(p.loadBalancing) === -1) {
	        this._loadBalancingPolicies.push(p.loadBalancing);
	      }
	      return p;
	    }, this);
	  }

	  /**
	   * @param {Client} client
	   * @param {HostMap} hosts
	   */
	  async init(client, hosts) {
	    for (const lbp of this._loadBalancingPolicies) {
	      await promiseUtils.fromCallback(callback => lbp.init(client, hosts, callback));
	    }
	  }

	  /**
	   * Uses the load-balancing policies to get the relative distance to the host and return the closest one.
	   * @param {Host} host
	   */
	  getDistance(host) {
	    let distance = types.distance.ignored;
	    // this is performance critical: we can't use any other language features than for-loop :(
	    for (let i = 0; i < this._loadBalancingPolicies.length; i++) {
	      const d = this._loadBalancingPolicies[i].getDistance(host);
	      if (d < distance) {
	        distance = d;
	        if (distance === types.distance.local) {
	          break;
	        }
	      }
	    }

	    host.setDistance(distance);
	    return distance;
	  }

	  /**
	   * @param {String|ExecutionProfile} name
	   * @returns {ExecutionProfile|undefined} It returns the execution profile by name or the default profile when name is
	   * undefined. It returns undefined when the profile does not exist.
	   */
	  getProfile(name) {
	    if (name instanceof ExecutionProfile) {
	      return name;
	    }
	    return this._profilesMap[name || 'default'];
	  }

	  /** @returns {ExecutionProfile} */
	  getDefault() {
	    return this._defaultProfile;
	  }

	  /** @returns {LoadBalancingPolicy} */
	  getDefaultLoadBalancing() {
	    return this._defaultProfile.loadBalancing;
	  }

	  /**
	   * Gets the cached default graph options for a given profile. If it doesn't exist, it creates new options using the
	   * handler and inserts it into the cache
	   * @param {ExecutionProfile} profile
	   * @param {Function} createHandler
	   */
	  getOrCreateGraphOptions(profile, createHandler) {
	    let graphOptions = this._graphOptionsCache[profile.name];
	    if (!graphOptions) {
	      graphOptions = (this._graphOptionsCache[profile.name] = createHandler());
	    }
	    return graphOptions;
	  }

	  /**
	   * @private
	   * @param {ClientOptions} options
	   */
	  _setDefault(options) {
	    this._defaultProfile = this._profiles.filter(function (p) { return p.name === 'default'; })[0];
	    if (!this._defaultProfile) {
	      this._profiles.push(this._defaultProfile = new ExecutionProfile('default'));
	    }

	    // Store the default configured retry policy
	    this._defaultConfiguredRetryPolicy = this._defaultProfile.retry;

	    // Set the required properties
	    this._defaultProfile.loadBalancing = this._defaultProfile.loadBalancing || options.policies.loadBalancing;
	    this._defaultProfile.retry = this._defaultProfile.retry || options.policies.retry;
	  }

	  /**
	   * Gets all the execution profiles currently defined.
	   * @returns {Array.<ExecutionProfile>}
	   */
	  getAll() {
	    return this._profiles;
	  }

	  getDefaultConfiguredRetryPolicy() {
	    return this._defaultConfiguredRetryPolicy;
	  }
	}

	executionProfile = {
	  ProfileManager,
	  ExecutionProfile
	};
	return executionProfile;
}var requests = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var writers;
var hasRequiredWriters;

function requireWriters () {
	if (hasRequiredWriters) return writers;
	hasRequiredWriters = 1;
	const events = require$$0$8;

	const types = requireTypes$2();
	const utils = requireUtils$c();
	const FrameHeader = types.FrameHeader;

	/**
	 * Contains the logic to write all the different types to the frame.
	 */
	class FrameWriter {
	  /**
	   * Creates a new instance of FrameWriter.
	   * @param {Number} opcode
	   */
	  constructor(opcode) {
	    if (!opcode) {
	      throw new Error('Opcode not provided');
	    }
	    this.buffers = [];
	    this.opcode = opcode;
	    this.bodyLength = 0;
	  }

	  add(buf) {
	    this.buffers.push(buf);
	    this.bodyLength += buf.length;
	  }

	  writeShort(num) {
	    const buf = utils.allocBufferUnsafe(2);
	    buf.writeUInt16BE(num, 0);
	    this.add(buf);
	  }

	  writeInt(num) {
	    const buf = utils.allocBufferUnsafe(4);
	    buf.writeInt32BE(num, 0);
	    this.add(buf);
	  }

	  /** @param {Long} num */
	  writeLong(num) {
	    this.add(types.Long.toBuffer(num));
	  }

	  /**
	   * Writes bytes according to Cassandra <int byteLength><bytes>
	   * @param {Buffer|null|types.unset} bytes
	   */
	  writeBytes(bytes) {
	    if (bytes === null) {
	      //Only the length buffer containing -1
	      this.writeInt(-1);
	      return;
	    }
	    if (bytes === types.unset) {
	      this.writeInt(-2);
	      return;
	    }
	    //Add the length buffer
	    this.writeInt(bytes.length);
	    //Add the actual buffer
	    this.add(bytes);
	  }

	  /**
	   * Writes a buffer according to Cassandra protocol: bytes.length (2) + bytes
	   * @param {Buffer} bytes
	   */
	  writeShortBytes(bytes) {
	    if(bytes === null) {
	      //Only the length buffer containing -1
	      this.writeShort(-1);
	      return;
	    }
	    //Add the length buffer
	    this.writeShort(bytes.length);
	    //Add the actual buffer
	    this.add(bytes);
	  }

	  /**
	   * Writes a single byte
	   * @param {Number} num Value of the byte, a number between 0 and 255.
	   */
	  writeByte(num) {
	    this.add(utils.allocBufferFromArray([num]));
	  }

	  writeString(str) {
	    if (typeof str === "undefined") {
	      throw new Error("can not write undefined");
	    }
	    const len = Buffer.byteLength(str, 'utf8');
	    const buf = utils.allocBufferUnsafe(2 + len);
	    buf.writeUInt16BE(len, 0);
	    buf.write(str, 2, buf.length-2, 'utf8');
	    this.add(buf);
	  }

	  writeLString(str) {
	    const len = Buffer.byteLength(str, 'utf8');
	    const buf = utils.allocBufferUnsafe(4 + len);
	    buf.writeInt32BE(len, 0);
	    buf.write(str, 4, buf.length-4, 'utf8');
	    this.add(buf);
	  }

	  writeStringList(values) {
	    this.writeShort(values.length);
	    values.forEach(this.writeString, this);
	  }

	  writeCustomPayload(payload) {
	    const keys = Object.keys(payload);
	    this.writeShort(keys.length);
	    keys.forEach(k => {
	      this.writeString(k);
	      this.writeBytes(payload[k]);
	    });
	  }

	  writeStringMap(map) {
	    const keys = [];
	    for (const k in map) {
	      if (map.hasOwnProperty(k)) {
	        keys.push(k);
	      }
	    }

	    this.writeShort(keys.length);

	    for(let i = 0; i < keys.length; i++) {
	      const key = keys[i];
	      this.writeString(key);
	      this.writeString(map[key]);
	    }
	  }

	  /**
	   * @param {Number} version
	   * @param {Number} streamId
	   * @param {Number} [flags] Header flags
	   * @returns {Buffer}
	   * @throws {TypeError}
	   */
	  write(version, streamId, flags) {
	    const header = new FrameHeader(version, flags || 0, streamId, this.opcode, this.bodyLength);
	    const headerBuffer = header.toBuffer();
	    this.buffers.unshift(headerBuffer);
	    return Buffer.concat(this.buffers, headerBuffer.length + this.bodyLength);
	  }
	}

	/**
	 * Represents a queue that process one write at a time (FIFO).
	 * @extends {EventEmitter}
	 */
	class WriteQueue extends events.EventEmitter {
	  /**
	   * Creates a new WriteQueue instance.
	   * @param {Socket} netClient
	   * @param {Encoder} encoder
	   * @param {ClientOptions} options
	   */
	  constructor(netClient, encoder, options) {
	    super();
	    this.netClient = netClient;
	    this.encoder = encoder;
	    this.isRunning = false;
	    /** @type {Array<{operation: OperationState, callback: Function}>} */
	    this.queue = [];
	    this.coalescingThreshold = options.socketOptions.coalescingThreshold;
	    this.error = null;
	    this.canWrite = true;

	    // Listen to drain event that is going to be fired once
	    // the underlying buffer is empty
	    netClient.on('drain', () => {
	      this.canWrite = true;
	      this.run();
	    });
	  }

	  /**
	   * Enqueues a new request
	   * @param {OperationState} operation
	   * @param {Function} callback The write callback.
	   */
	  push(operation, callback) {
	    const self = this;

	    if (this.error) {
	      // There was a write error, there is no point in further trying to write to the socket.
	      return process.nextTick(function writePushError() {
	        callback(self.error);
	      });
	    }

	    this.queue.push({ operation: operation, callback: callback});
	    this.run();
	  }

	  run() {
	    if (!this.isRunning && this.canWrite) {
	      this.isRunning = true;
	      // Use nextTick to allow the queue to build up on the current phase
	      process.nextTick(() => this.process());
	    }
	  }

	  process() {
	    if (this.error) {
	      return;
	    }

	    const buffers = [];
	    const callbacks = [];
	    let totalLength = 0;

	    while (this.queue.length > 0 && totalLength < this.coalescingThreshold) {
	      const writeItem = this.queue.shift();
	      if (!writeItem.operation.canBeWritten()) {
	        // Invoke the write callback with an error that is not going to be yielded to user
	        // as the operation has timed out or was cancelled.
	        writeItem.callback(new Error('The operation was already cancelled or timeout elapsed'));
	        continue;
	      }
	      let data;
	      try {
	        data = writeItem.operation.request.write(this.encoder, writeItem.operation.streamId);
	      }
	      catch (err) {
	        writeItem.callback(err);
	        continue;
	      }
	      totalLength += data.length;
	      buffers.push(data);
	      callbacks.push(writeItem.callback);
	    }

	    if (totalLength === 0) {
	      this.isRunning = false;
	      return;
	    }

	    // We have to invoke the callbacks to avoid race conditions.
	    // There is a performance benefit from executing all of them in a loop
	    for (let i = 0; i < callbacks.length; i++) {
	      callbacks[i]();
	    }

	    // Concatenate buffers and write it to the socket
	    // Further writes will be throttled until flushed
	    this.canWrite = this.netClient.write(Buffer.concat(buffers, totalLength), err => {
	      if (err) {
	        this.setWriteError(err);
	        return;
	      }

	      if (this.queue.length === 0 || !this.canWrite) {
	        // It will start running once we get the next message or has drained
	        this.isRunning = false;
	        return;
	      }

	      // Allow IO between writes
	      setImmediate(() => this.process());
	    });
	  }

	  /**
	   * Emits the 'error' event and callbacks items that haven't been written and clears them from the queue.
	   * @param err
	   */
	  setWriteError(err) {
	    err.isSocketError = true;
	    this.error = new types.DriverError('Socket was closed');
	    this.error.isSocketError = true;
	    // Use an special flag for items that haven't been written
	    this.error.requestNotWritten = true;
	    this.error.innerError = err;
	    const q = this.queue;
	    // Not more items can be added to the queue.
	    this.queue = utils.emptyArray;
	    for (let i = 0; i < q.length; i++) {
	      const item = q[i];
	      // Use the error marking that it was not written
	      item.callback(this.error);
	    }
	  }
	}

	writers = { FrameWriter, WriteQueue };
	return writers;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var executionOptions;
var hasRequiredExecutionOptions;

function requireExecutionOptions () {
	if (hasRequiredExecutionOptions) return executionOptions;
	hasRequiredExecutionOptions = 1;

	const utils = requireUtils$c();
	const types = requireTypes$2();
	const errors = requireErrors$c();

	const proxyExecuteKey = 'ProxyExecute';

	/**
	 * A base class that represents a wrapper around the user provided query options with getter methods and proper
	 * default values.
	 * <p>
	 *   Note that getter methods might return <code>undefined</code> when not set on the query options or default
	 *  {@link Client} options.
	 * </p>
	 */
	class ExecutionOptions {

	  /**
	   * Creates a new instance of {@link ExecutionOptions}.
	   */
	  constructor() {
	  }

	  /**
	   * Creates an empty instance, where all methods return undefined, used internally.
	   * @ignore
	   * @return {ExecutionOptions}
	   */
	  static empty() {
	    return new ExecutionOptions();
	  }

	  /**
	   * Determines if the stack trace before the query execution should be maintained.
	   * @abstract
	   * @returns {Boolean}
	   */
	  getCaptureStackTrace() {

	  }

	  /**
	   * Gets the [Consistency level]{@link module:types~consistencies} to be used for the execution.
	   * @abstract
	   * @returns {Number}
	   */
	  getConsistency() {

	  }

	  /**
	   * Key-value payload to be passed to the server. On the server side, implementations of QueryHandler can use
	   * this data.
	   * @abstract
	   * @returns {Object}
	   */
	  getCustomPayload() {

	  }

	  /**
	   * Gets the amount of rows to retrieve per page.
	   * @abstract
	   * @returns {Number}
	   */
	  getFetchSize() {

	  }

	  /**
	   * When a fixed host is set on the query options and the query plan for the load-balancing policy is not used, it
	   * gets the host that should handle the query.
	   * @returns {Host}
	   */
	  getFixedHost() {

	  }

	  /**
	   * Gets the type hints for parameters given in the query, ordered as for the parameters.
	   * @abstract
	   * @returns {Array|Array<Array>}
	   */
	  getHints() {

	  }

	  /**
	   * Determines whether the driver must retrieve the following result pages automatically.
	   * <p>
	   *   This setting is only considered by the [Client#eachRow()]{@link Client#eachRow} method.
	   * </p>
	   * @abstract
	   * @returns {Boolean}
	   */
	  isAutoPage() {

	  }

	  /**
	   * Determines whether its a counter batch. Only valid for [Client#batch()]{@link Client#batch}, it will be ignored by
	   * other methods.
	   * @abstract
	   * @returns {Boolean} A <code>Boolean</code> value, it can't be <code>undefined</code>.
	   */
	  isBatchCounter() {

	  }

	  /**
	   * Determines whether the batch should be written to the batchlog. Only valid for
	   * [Client#batch()]{@link Client#batch}, it will be ignored by other methods.
	   * @abstract
	   * @returns {Boolean} A <code>Boolean</code> value, it can't be <code>undefined</code>.
	   */
	  isBatchLogged() {

	  }

	  /**
	   * Determines whether the query can be applied multiple times without changing the result beyond the initial
	   * application.
	   * @abstract
	   * @returns {Boolean}
	   */
	  isIdempotent() {

	  }

	  /**
	   * Determines whether the query must be prepared beforehand.
	   * @abstract
	   * @returns {Boolean} A <code>Boolean</code> value, it can't be <code>undefined</code>.
	   */
	  isPrepared() {

	  }

	  /**
	   * Determines whether query tracing is enabled for the execution.
	   * @abstract
	   * @returns {Boolean}
	   */
	  isQueryTracing() {

	  }

	  /**
	   * Gets the keyspace for the query when set at query options level.
	   * <p>
	   *   Note that this method will return <code>undefined</code> when the keyspace is not set at query options level.
	   *   It will only return the keyspace name when the user provided a different keyspace than the current
	   *   {@link Client} keyspace.
	   * </p>
	   * @abstract
	   * @returns {String}
	   */
	  getKeyspace() {

	  }

	  /**
	   * Gets the load balancing policy used for this execution.
	   * @returns {LoadBalancingPolicy} A <code>LoadBalancingPolicy</code> instance, it can't be <code>undefined</code>.
	   */
	  getLoadBalancingPolicy() {

	  }

	  /**
	   * Gets the Buffer representing the paging state.
	   * @abstract
	   * @returns {Buffer}
	   */
	  getPageState() {

	  }

	  /**
	   * Internal method that gets the preferred host.
	   * @abstract
	   * @ignore
	   */
	  getPreferredHost() {

	  }

	  /**
	   * Gets the query options as provided to the execution method without setting the default values.
	   * @returns {QueryOptions}
	   */
	  getRawQueryOptions() {

	  }

	  /**
	   * Gets the timeout in milliseconds to be used for the execution per coordinator.
	   * <p>
	   *   A value of <code>0</code> disables client side read timeout for the execution. Default: <code>undefined</code>.
	   * </p>
	   * @abstract
	   * @returns {Number}
	   */
	  getReadTimeout() {

	  }

	  /**
	   * Gets the [retry policy]{@link module:policies/retry} to be used.
	   * @abstract
	   * @returns {RetryPolicy} A <code>RetryPolicy</code> instance, it can't be <code>undefined</code>.
	   */
	  getRetryPolicy() {

	  }

	  /**
	   * Internal method to obtain the row callback, for "by row" results.
	   * @abstract
	   * @ignore
	   */
	  getRowCallback() {

	  }

	  /**
	   * Internal method to get or generate a timestamp for the request execution.
	   * @ignore
	   * @returns {Long|null}
	   */
	  getOrGenerateTimestamp() {

	  }

	  /**
	   * Gets the index of the parameters that are part of the partition key to determine the routing.
	   * @abstract
	   * @ignore
	   * @returns {Array}
	   */
	  getRoutingIndexes() {

	  }

	  /**
	   * Gets the partition key(s) to determine which coordinator should be used for the query.
	   * @abstract
	   * @returns {Buffer|Array<Buffer>}
	   */
	  getRoutingKey() {

	  }

	  /**
	   * Gets the array of the parameters names that are part of the partition key to determine the
	   * routing. Only valid for non-prepared requests.
	   * @abstract
	   * @ignore
	   */
	  getRoutingNames() {

	  }

	  /**
	   * Gets the the consistency level to be used for the serial phase of conditional updates.
	   * @abstract
	   * @returns {Number}
	   */
	  getSerialConsistency() {

	  }

	  /**
	   * Gets the provided timestamp for the execution in microseconds from the unix epoch (00:00:00, January 1st, 1970).
	   * <p>When a timestamp generator is used, this method returns <code>undefined</code>.</p>
	   * @abstract
	   * @returns {Number|Long|undefined|null}
	   */
	  getTimestamp() {

	  }

	  /**
	   * @param {Array} hints
	   * @abstract
	   * @ignore
	   */
	  setHints(hints) {

	  }

	  /**
	   * Sets the keyspace for the execution.
	   * @ignore
	   * @abstract
	   * @param {String} keyspace
	   */
	  setKeyspace(keyspace) {

	  }

	  /**
	   * @abstract
	   * @ignore
	   */
	  setPageState() {

	  }

	  /**
	   * Internal method that sets the preferred host.
	   * @abstract
	   * @ignore
	   */
	  setPreferredHost() {

	  }

	  /**
	   * Sets the index of the parameters that are part of the partition key to determine the routing.
	   * @param {Array} routingIndexes
	   * @abstract
	   * @ignore
	   */
	  setRoutingIndexes(routingIndexes) {

	  }

	  /**
	   * Sets the routing key.
	   * @abstract
	   * @ignore
	   */
	  setRoutingKey(value) {

	  }
	}

	/**
	 * Internal implementation of {@link ExecutionOptions} that uses the value from the client options and execution
	 * profile into account.
	 * @ignore
	 */
	class DefaultExecutionOptions extends ExecutionOptions {
	  /**
	   * Creates a new instance of {@link ExecutionOptions}.
	   * @param {QueryOptions} queryOptions
	   * @param {Client} client
	   * @param {Function|null} rowCallback
	   */
	  constructor(queryOptions, client, rowCallback) {
	    super();

	    this._queryOptions = queryOptions;
	    this._rowCallback = rowCallback;
	    this._routingKey = this._queryOptions.routingKey;
	    this._hints = this._queryOptions.hints;
	    this._keyspace = this._queryOptions.keyspace;
	    this._routingIndexes = this._queryOptions.routingIndexes;
	    this._pageState = typeof this._queryOptions.pageState === 'string' ?
	      utils.allocBufferFromString(this._queryOptions.pageState, 'hex') : this._queryOptions.pageState;
	    this._preferredHost = null;

	    this._client = client;
	    this._defaultQueryOptions = client.options.queryOptions;
	    this._profile = client.profileManager.getProfile(this._queryOptions.executionProfile);

	    // Build a custom payload object designed for DSE-specific functionality
	    this._customPayload = DefaultExecutionOptions.createCustomPayload(this._queryOptions, this._defaultQueryOptions);

	    if (!this._profile) {
	      throw new errors.ArgumentError(`Execution profile "${this._queryOptions.executionProfile}" not found`);
	    }
	  }

	  /**
	   * Creates a payload for given user.
	   * @param {QueryOptions} userOptions
	   * @param {QueryOptions} defaultQueryOptions
	   * @private
	   */
	  static createCustomPayload(userOptions, defaultQueryOptions) {
	    let customPayload = userOptions.customPayload || defaultQueryOptions.customPayload;
	    const executeAs = userOptions.executeAs || defaultQueryOptions.executeAs;

	    if (executeAs) {
	      if (!customPayload) {
	        customPayload = {};
	        customPayload[proxyExecuteKey] = utils.allocBufferFromString(executeAs);
	      } else if (!customPayload[proxyExecuteKey]) {
	        // Avoid appending to the existing payload object
	        customPayload = utils.extend({}, customPayload);
	        customPayload[proxyExecuteKey] = utils.allocBufferFromString(executeAs);
	      }
	    }

	    return customPayload;
	  }

	  /**
	   * Creates a new instance {@link ExecutionOptions}, based on the query options.
	   * @param {QueryOptions|null} queryOptions
	   * @param {Client} client
	   * @param {Function|null} [rowCallback]
	   * @ignore
	   * @return {ExecutionOptions}
	   */
	  static create(queryOptions, client, rowCallback) {
	    if (!queryOptions || typeof queryOptions === 'function') {
	      // queryOptions can be null/undefined and could be of type function when is an optional parameter
	      queryOptions = utils.emptyObject;
	    }
	    return new DefaultExecutionOptions(queryOptions, client, rowCallback);
	  }

	  getCaptureStackTrace() {
	    return ifUndefined(this._queryOptions.captureStackTrace, this._defaultQueryOptions.captureStackTrace);
	  }

	  getConsistency() {
	    return ifUndefined3(this._queryOptions.consistency, this._profile.consistency,
	      this._defaultQueryOptions.consistency);
	  }

	  getCustomPayload() {
	    return this._customPayload;
	  }

	  getFetchSize() {
	    return ifUndefined(this._queryOptions.fetchSize, this._defaultQueryOptions.fetchSize);
	  }

	  getFixedHost() {
	    return this._queryOptions.host;
	  }

	  getHints() {
	    return this._hints;
	  }

	  isAutoPage() {
	    return ifUndefined(this._queryOptions.autoPage, this._defaultQueryOptions.autoPage);
	  }

	  isBatchCounter() {
	    return ifUndefined(this._queryOptions.counter, false);
	  }

	  isBatchLogged() {
	    return ifUndefined3(this._queryOptions.logged, this._defaultQueryOptions.logged, true);
	  }

	  isIdempotent() {
	    return ifUndefined(this._queryOptions.isIdempotent, this._defaultQueryOptions.isIdempotent);
	  }

	  /**
	   * Determines if the query execution must be prepared beforehand.
	   * @return {Boolean}
	   */
	  isPrepared() {
	    return ifUndefined(this._queryOptions.prepare, this._defaultQueryOptions.prepare);
	  }

	  isQueryTracing() {
	    return ifUndefined(this._queryOptions.traceQuery, this._defaultQueryOptions.traceQuery);
	  }

	  getKeyspace() {
	    return this._keyspace;
	  }

	  getLoadBalancingPolicy() {
	    return this._profile.loadBalancing;
	  }

	  getOrGenerateTimestamp() {
	    let result = this.getTimestamp();

	    if (result === undefined) {
	      const generator = this._client.options.policies.timestampGeneration;

	      if ( types.protocolVersion.supportsTimestamp(this._client.controlConnection.protocolVersion) && generator) {
	        result = generator.next(this._client);
	      } else {
	        result = null;
	      }
	    }

	    return typeof result === 'number' ? types.Long.fromNumber(result) : result;
	  }

	  getPageState() {
	    return this._pageState;
	  }

	  /**
	   * Gets the profile defined by the user or the default profile
	   * @internal
	   * @ignore
	   */
	  getProfile() {
	    return this._profile;
	  }

	  getRawQueryOptions() {
	    return this._queryOptions;
	  }

	  getReadTimeout() {
	    return ifUndefined3(this._queryOptions.readTimeout, this._profile.readTimeout,
	      this._client.options.socketOptions.readTimeout);
	  }

	  getRetryPolicy() {
	    return ifUndefined3(this._queryOptions.retry, this._profile.retry, this._client.options.policies.retry);
	  }

	  getRoutingIndexes() {
	    return this._routingIndexes;
	  }

	  getRoutingKey() {
	    return this._routingKey;
	  }

	  getRoutingNames() {
	    return this._queryOptions.routingNames;
	  }

	  /**
	   * Internal method to obtain the row callback, for "by row" results.
	   * @ignore
	   */
	  getRowCallback() {
	    return this._rowCallback;
	  }

	  getSerialConsistency() {
	    return ifUndefined3(
	      this._queryOptions.serialConsistency, this._profile.serialConsistency, this._defaultQueryOptions.serialConsistency);
	  }

	  getTimestamp() {
	    return this._queryOptions.timestamp;
	  }

	  /**
	   * Internal property to set the custom payload.
	   * @ignore
	   * @internal
	   * @param {Object} payload
	   */
	  setCustomPayload(payload) {
	    this._customPayload = payload;
	  }

	  /**
	   * @param {Array} hints
	   */
	  setHints(hints) {
	    this._hints = hints;
	  }

	  /**
	   * @param {String} keyspace
	   */
	  setKeyspace(keyspace) {
	    this._keyspace = keyspace;
	  }

	  /**
	   * @param {Buffer} pageState
	   */
	  setPageState(pageState) {
	    this._pageState = pageState;
	  }

	  /**
	   * @param {Array} routingIndexes
	   */
	  setRoutingIndexes(routingIndexes) {
	    this._routingIndexes = routingIndexes;
	  }

	  setRoutingKey(value) {
	    this._routingKey = value;
	  }
	}

	function ifUndefined(v1, v2) {
	  return v1 !== undefined ? v1 : v2;
	}

	function ifUndefined3(v1, v2, v3) {
	  if (v1 !== undefined) {
	    return v1;
	  }
	  return v2 !== undefined ? v2 : v3;
	}

	executionOptions = { ExecutionOptions, DefaultExecutionOptions, proxyExecuteKey };
	return executionOptions;
}var name$9 = "cassandra-driver";
var version$9 = "4.7.2";
var description$6 = "DataStax Node.js Driver for Apache Cassandra";
var author$5 = "DataStax";
var keywords$7 = [
	"cassandra",
	"cql",
	"cql3",
	"connection",
	"gremlin",
	"datastax",
	"nosql",
	"driver",
	"database",
	"dse",
	"graph",
	"graphdb"
];
var license$8 = "Apache-2.0";
var types$8 = "./index.d.ts";
var dependencies$7 = {
	"@types/long": "~5.0.0",
	"@types/node": ">=8",
	"adm-zip": "~0.5.10",
	long: "~5.2.3"
};
var devDependencies$7 = {
	chai: "~4.3.8",
	kerberos: "~2.0.3",
	mocha: "~10.2.0",
	"mocha-jenkins-reporter": "~0.4.8",
	proxyquire: "~2.1.3",
	sinon: "~15.2.0",
	temp: ">= 0.8.3"
};
var repository$7 = {
	type: "git",
	url: "https://github.com/datastax/nodejs-driver.git"
};
var bugs$5 = {
	url: "https://groups.google.com/a/lists.datastax.com/forum/#!forum/nodejs-driver-user"
};
var scripts$7 = {
	test: "./node_modules/.bin/mocha test/unit -R spec -t 5000 --recursive",
	unit: "./node_modules/.bin/mocha test/unit -R spec -t 5000 --recursive",
	integration_short: "./node_modules/.bin/mocha test/integration/short -R spec -t 5000 --recursive",
	integration_long: "./node_modules/.bin/mocha test/integration/long -R spec -t 5000 --recursive",
	ci_jenkins: "./node_modules/.bin/mocha test/unit test/integration/short --recursive -R mocha-jenkins-reporter --exit",
	ci_appveyor: "./node_modules/.bin/mocha test/unit test/integration/short --recursive -R mocha-appveyor-reporter --exit",
	ci_unit_appveyor: "./node_modules/.bin/mocha test/unit --recursive -R mocha-appveyor-reporter --exit",
	server_api: "./node_modules/.bin/mocha test/integration/short -g '@SERVER_API' --recursive --exit",
	eslint: "eslint lib test"
};
var engines$7 = {
	node: ">=16"
};
var require$$17 = {
	name: name$9,
	version: version$9,
	description: description$6,
	author: author$5,
	keywords: keywords$7,
	license: license$8,
	types: types$8,
	dependencies: dependencies$7,
	devDependencies: devDependencies$7,
	repository: repository$7,
	bugs: bugs$5,
	scripts: scripts$7,
	engines: engines$7
};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredRequests;

function requireRequests () {
	if (hasRequiredRequests) return requests;
	hasRequiredRequests = 1;
	const util = require$$0$6;

	const { FrameWriter } = requireWriters();
	const types = requireTypes$2();
	const utils = requireUtils$c();
	const { ExecutionOptions } = requireExecutionOptions();
	const packageInfo = require$$17;

	/**
	 * Options for the execution of the query / prepared statement
	 * @private
	 */
	const queryFlag = {
	  values:                 0x01,
	  skipMetadata:           0x02,
	  pageSize:               0x04,
	  withPagingState:        0x08,
	  withSerialConsistency:  0x10,
	  withDefaultTimestamp:   0x20,
	  withNameForValues:      0x40,
	  withKeyspace:           0x80,
	  withPageSizeBytes: 0x40000000,
	  withContinuousPaging: 0x80000000
	};

	/**
	 * Options for the execution of a batch request from protocol v3 and above
	 * @private
	 */
	const batchFlag = {
	  withSerialConsistency:  0x10,
	  withDefaultTimestamp:   0x20,
	  withNameForValues:      0x40,
	  withKeyspace:           0x80
	};

	/**
	 * Options for execution of a prepare request from protocol DSE_V2 and above
	 * @private
	 */
	const prepareFlag = {
	  withKeyspace:           0x01
	};

	const batchType = {
	  logged: 0,
	  unlogged: 1,
	  counter: 2
	};

	/**
	 * Abstract class Request
	 */
	class Request {
	  constructor() {
	    this.length = 0;
	  }

	  /**
	   * @abstract
	   * @param {Encoder} encoder
	   * @param {Number} streamId
	   * @throws {TypeError}
	   * @returns {Buffer}
	   */
	  write(encoder, streamId) {
	    throw new Error('Method must be implemented');
	  }

	  /**
	   * Creates a new instance using the same constructor as the current instance, copying the properties.
	   * @return {Request}
	   */
	  clone() {
	    const newRequest = new (this.constructor)();
	    const keysArray = Object.keys(this);
	    for (let i = 0; i < keysArray.length; i++) {
	      const key = keysArray[i];
	      newRequest[key] = this[key];
	    }
	    return newRequest;
	  }
	}

	/**
	 * Writes a execute query (given a prepared queryId)
	 * @param {String} query
	 * @param {Buffer} queryId
	 * @param {Array} params
	 * @param options
	 */
	class ExecuteRequest extends Request {
	  /**
	   * @param {String} query
	   * @param queryId
	   * @param params
	   * @param {ExecutionOptions} execOptions
	   * @param meta
	   */
	  constructor(query, queryId, params, execOptions, meta) {
	    super();

	    this.query = query;
	    this.queryId = queryId;
	    this.params = params;
	    this.meta = meta;
	    this.options = execOptions || ExecutionOptions.empty();
	    this.consistency = this.options.getConsistency() || types.consistencies.one;
	    // Only QUERY request parameters are encoded as named parameters
	    // EXECUTE request parameters are always encoded as positional parameters
	    this.namedParameters = false;
	  }

	  getParamType(index) {
	    const columnInfo = this.meta.columns[index];
	    return columnInfo ? columnInfo.type : null;
	  }

	  write(encoder, streamId) {
	    //v1: <queryId>
	    //      <n><value_1>....<value_n><consistency>
	    //v2: <queryId>
	    //      <consistency><flags>[<n><value_1>...<value_n>][<result_page_size>][<paging_state>][<serial_consistency>]
	    //v3: <queryId>
	    //      <consistency><flags>[<n>[name_1]<value_1>...[name_n]<value_n>][<result_page_size>][<paging_state>][<serial_consistency>][<timestamp>]
	    const frameWriter = new FrameWriter(types.opcodes.execute);
	    let headerFlags = this.options.isQueryTracing() ? types.frameFlags.tracing : 0;
	    if (this.options.getCustomPayload()) {
	      //The body may contain the custom payload
	      headerFlags |= types.frameFlags.customPayload;
	      frameWriter.writeCustomPayload(this.options.getCustomPayload());
	    }
	    frameWriter.writeShortBytes(this.queryId);
	    if(types.protocolVersion.supportsResultMetadataId(encoder.protocolVersion)) {
	      frameWriter.writeShortBytes(this.meta.resultId);
	    }
	    this.writeQueryParameters(frameWriter, encoder);

	    // Record the length of the body of the request before writing it
	    this.length = frameWriter.bodyLength;

	    return frameWriter.write(encoder.protocolVersion, streamId, headerFlags);
	  }

	  /**
	   * Writes v1 and v2 execute query parameters
	   * @param {FrameWriter} frameWriter
	   * @param {Encoder} encoder
	   * @param {Boolean} [isQuery] True if query, otherwise assumed to be execute request.
	   */
	  writeQueryParameters(frameWriter, encoder, isQuery) {
	    //v1: <n><value_1>....<value_n><consistency>
	    //v2: <consistency><flags>[<n><value_1>...<value_n>][<result_page_size>][<paging_state>][<serial_consistency>]
	    //v3: <consistency><flags>[<n>[name_1]<value_1>...[name_n]<value_n>][<result_page_size>][<paging_state>][<serial_consistency>][<timestamp>]
	    //dse_v1: <consistency><flags>[<n>[name_1]<value_1>...[name_n]<value_n>][<result_page_size>][<paging_state>]
	    //          [<serial_consistency>][<timestamp>][continuous_paging_options]
	    //dse_v2: <consistency><flags>[<n>[name_1]<value_1>...[name_n]<value_n>][<result_page_size>][<paging_state>]
	    //          [<serial_consistency>][<timestamp>][keyspace][continuous_paging_options]
	    let flags = 0;

	    const timestamp = this.options.getOrGenerateTimestamp();

	    if (types.protocolVersion.supportsPaging(encoder.protocolVersion)) {
	      flags |= (this.params && this.params.length) ? queryFlag.values : 0;
	      flags |= (this.options.getFetchSize() > 0) ? queryFlag.pageSize : 0;
	      flags |= this.options.getPageState() ? queryFlag.withPagingState : 0;
	      flags |= this.options.getSerialConsistency() ? queryFlag.withSerialConsistency : 0;
	      flags |= timestamp !== null && timestamp !== undefined ? queryFlag.withDefaultTimestamp : 0;
	      flags |= this.namedParameters ? queryFlag.withNameForValues : 0;

	      // Don't inject keyspace for EXECUTE requests as inherited from prepared statement.
	      const supportsKeyspace = isQuery && types.protocolVersion.supportsKeyspaceInRequest(encoder.protocolVersion);
	      flags |= supportsKeyspace && this.options.getKeyspace() ? queryFlag.withKeyspace : 0;

	      frameWriter.writeShort(this.consistency);
	      if (types.protocolVersion.uses4BytesQueryFlags(encoder.protocolVersion)) {
	        frameWriter.writeInt(flags);
	      }
	      else {
	        frameWriter.writeByte(flags);
	      }
	    }

	    if (this.params && this.params.length) {
	      frameWriter.writeShort(this.params.length);
	      for (let i = 0; i < this.params.length; i++) {
	        let paramValue = this.params[i];
	        if (flags & queryFlag.withNameForValues) {
	          //parameter is composed by name / value
	          frameWriter.writeString(paramValue.name);
	          paramValue = paramValue.value;
	        }
	        frameWriter.writeBytes(encoder.encode(paramValue, this.getParamType(i)));
	      }
	    }

	    if (!types.protocolVersion.supportsPaging(encoder.protocolVersion)) {
	      if (!this.params || !this.params.length) {
	        //zero parameters
	        frameWriter.writeShort(0);
	      }
	      frameWriter.writeShort(this.consistency);
	      return;
	    }
	    if (flags & queryFlag.pageSize) {
	      frameWriter.writeInt(this.options.getFetchSize());
	    }
	    if (flags & queryFlag.withPagingState) {
	      frameWriter.writeBytes(this.options.getPageState());
	    }
	    if (flags & queryFlag.withSerialConsistency) {
	      frameWriter.writeShort(this.options.getSerialConsistency());
	    }
	    if (flags & queryFlag.withDefaultTimestamp) {
	      frameWriter.writeLong(timestamp);
	    }
	    if (flags & queryFlag.withKeyspace) {
	      frameWriter.writeString(this.options.getKeyspace());
	    }
	  }
	}

	class QueryRequest extends ExecuteRequest {
	  /**
	   * @param {String} query
	   * @param params
	   * @param {ExecutionOptions} [execOptions]
	   * @param {Boolean} [namedParameters]
	   */
	  constructor(query, params, execOptions, namedParameters) {
	    super(query, null, params, execOptions, null);
	    this.hints = this.options.getHints() || utils.emptyArray;
	    this.namedParameters = namedParameters;
	  }

	  getParamType(index) {
	    return this.hints[index];
	  }

	  write(encoder, streamId) {
	    //v1: <query><consistency>
	    //v2: <query>
	    //      <consistency><flags>[<n><value_1>...<value_n>][<result_page_size>][<paging_state>][<serial_consistency>]
	    //v3: <query>
	    //      <consistency><flags>[<n>[name_1]<value_1>...[name_n]<value_n>][<result_page_size>][<paging_state>][<serial_consistency>][<timestamp>]
	    const frameWriter = new FrameWriter(types.opcodes.query);
	    let headerFlags = this.options.isQueryTracing() ? types.frameFlags.tracing : 0;
	    if (this.options.getCustomPayload()) {
	      //The body may contain the custom payload
	      headerFlags |= types.frameFlags.customPayload;
	      frameWriter.writeCustomPayload(this.options.getCustomPayload());
	    }

	    frameWriter.writeLString(this.query);

	    if (!types.protocolVersion.supportsPaging(encoder.protocolVersion)) {
	      frameWriter.writeShort(this.consistency);
	    } else {
	      //Use the same fields as the execute writer
	      this.writeQueryParameters(frameWriter, encoder, true);
	    }

	    // Record the length of the body of the request before writing it
	    this.length = frameWriter.bodyLength;

	    return frameWriter.write(encoder.protocolVersion, streamId, headerFlags);
	  }
	}

	class PrepareRequest extends Request {
	  constructor(query, keyspace) {
	    super();
	    this.query = query;
	    this.keyspace = keyspace;
	  }

	  write(encoder, streamId) {
	    const frameWriter = new FrameWriter(types.opcodes.prepare);
	    frameWriter.writeLString(this.query);
	    if (types.protocolVersion.supportsPrepareFlags(encoder.protocolVersion)) {
	      const flags = this.keyspace && types.protocolVersion.supportsKeyspaceInRequest(encoder.protocolVersion) ? prepareFlag.withKeyspace : 0;
	      frameWriter.writeInt(flags);
	      if (flags & prepareFlag.withKeyspace) {
	        frameWriter.writeString(this.keyspace);
	      }
	    }
	    return frameWriter.write(encoder.protocolVersion, streamId);
	  }
	}

	class StartupRequest extends Request {

	  /**
	   * Creates a new instance of {@link StartupRequest}.
	   * @param {Object} [options]
	   * @param [options.cqlVersion]
	   * @param [options.noCompact]
	   * @param [options.clientId]
	   * @param [options.applicationName]
	   * @param [options.applicationVersion]
	   */
	  constructor(options) {
	    super();
	    this.options = options || {};
	  }

	  write(encoder, streamId) {
	    const frameWriter = new FrameWriter(types.opcodes.startup);

	    const startupOptions = {
	      CQL_VERSION: this.options.cqlVersion || '3.0.0',
	      DRIVER_NAME: packageInfo.description,
	      DRIVER_VERSION: packageInfo.version
	    };

	    if(this.options.noCompact) {
	      startupOptions['NO_COMPACT'] = 'true';
	    }

	    if (this.options.clientId) {
	      startupOptions['CLIENT_ID'] = this.options.clientId.toString();
	    }

	    if (this.options.applicationName) {
	      startupOptions['APPLICATION_NAME'] = this.options.applicationName;
	    }

	    if (this.options.applicationVersion) {
	      startupOptions['APPLICATION_VERSION'] = this.options.applicationVersion;
	    }

	    frameWriter.writeStringMap(startupOptions);
	    return frameWriter.write(encoder.protocolVersion, streamId);
	  }
	}

	class RegisterRequest extends Request {
	  constructor(events) {
	    super();
	    this.events = events;
	  }

	  write(encoder, streamId) {
	    const frameWriter = new FrameWriter(types.opcodes.register);
	    frameWriter.writeStringList(this.events);
	    return frameWriter.write(encoder.protocolVersion, streamId);
	  }
	}

	/**
	 * Represents an AUTH_RESPONSE request
	 * @param {Buffer} token
	 */
	class AuthResponseRequest extends Request {
	  constructor(token) {
	    super();
	    this.token = token;
	  }

	  write(encoder, streamId) {
	    const frameWriter = new FrameWriter(types.opcodes.authResponse);
	    frameWriter.writeBytes(this.token);
	    return frameWriter.write(encoder.protocolVersion, streamId);
	  }
	}

	/**
	 * Represents a protocol v1 CREDENTIALS request message
	 */
	class CredentialsRequest extends Request {
	  constructor(username, password) {
	    super();
	    this.username = username;
	    this.password = password;
	  }

	  write(encoder, streamId) {
	    const frameWriter = new FrameWriter(types.opcodes.credentials);
	    frameWriter.writeStringMap({ username:this.username, password:this.password });
	    return frameWriter.write(encoder.protocolVersion, streamId);
	  }
	}

	class BatchRequest extends Request {
	  /**
	   * Creates a new instance of BatchRequest.
	   * @param {Array.<{query, params, [info]}>} queries Array of objects with the properties query and params
	   * @param {ExecutionOptions} execOptions
	   */
	  constructor(queries, execOptions) {
	    super();
	    this.queries = queries;
	    this.options = execOptions;
	    this.hints = execOptions.getHints() || utils.emptyArray;
	    this.type = batchType.logged;

	    if (execOptions.isBatchCounter()) {
	      this.type = batchType.counter;
	    } else if (!execOptions.isBatchLogged()) {
	      this.type = batchType.unlogged;
	    }
	  }

	  /**
	  * Writes a batch request
	  */
	  write(encoder, streamId) {
	    //v2: <type><n><query_1>...<query_n><consistency>
	    //v3: <type><n><query_1>...<query_n><consistency><flags>[<serial_consistency>][<timestamp>]
	    //dseV1+: similar to v3/v4, flags is an int instead of a byte
	    if (!this.queries || !(this.queries.length > 0)) {
	      throw new TypeError(util.format('Invalid queries provided %s', this.queries));
	    }
	    const frameWriter = new FrameWriter(types.opcodes.batch);
	    let headerFlags = this.options.isQueryTracing() ? types.frameFlags.tracing : 0;
	    if (this.options.getCustomPayload()) {
	      //The body may contain the custom payload
	      headerFlags |= types.frameFlags.customPayload;
	      frameWriter.writeCustomPayload(this.options.getCustomPayload());
	    }
	    frameWriter.writeByte(this.type);
	    frameWriter.writeShort(this.queries.length);
	    const self = this;
	    this.queries.forEach(function eachQuery(item, i) {
	      const hints = self.hints[i];
	      const params = item.params || utils.emptyArray;
	      let getParamType;
	      if (item.queryId) {
	        // Contains prepared queries
	        frameWriter.writeByte(1);
	        frameWriter.writeShortBytes(item.queryId);
	        getParamType = i => item.meta.columns[i].type;
	      }
	      else {
	        // Contains string queries
	        frameWriter.writeByte(0);
	        frameWriter.writeLString(item.query);
	        getParamType = hints ? (i => hints[i]) : (() => null);
	      }

	      frameWriter.writeShort(params.length);
	      params.forEach((param, index) => frameWriter.writeBytes(encoder.encode(param, getParamType(index))));
	    }, this);

	    frameWriter.writeShort(this.options.getConsistency());

	    if (types.protocolVersion.supportsTimestamp(encoder.protocolVersion)) {
	      // Batch flags
	      let flags = this.options.getSerialConsistency() ? batchFlag.withSerialConsistency : 0;
	      const timestamp = this.options.getOrGenerateTimestamp();
	      flags |= timestamp !== null && timestamp !== undefined ? batchFlag.withDefaultTimestamp : 0;

	      flags |= this.options.getKeyspace() && types.protocolVersion.supportsKeyspaceInRequest(encoder.protocolVersion)
	        ? batchFlag.withKeyspace : 0;

	      if (types.protocolVersion.uses4BytesQueryFlags(encoder.protocolVersion)) {
	        frameWriter.writeInt(flags);
	      }
	      else {
	        frameWriter.writeByte(flags);
	      }

	      if (flags & batchFlag.withSerialConsistency) {
	        frameWriter.writeShort(this.options.getSerialConsistency());
	      }

	      if (flags & batchFlag.withDefaultTimestamp) {
	        frameWriter.writeLong(timestamp);
	      }

	      if (flags & batchFlag.withKeyspace) {
	        frameWriter.writeString(this.options.getKeyspace());
	      }
	    }

	    // Set the length of the body of the request before writing it
	    this.length = frameWriter.bodyLength;

	    return frameWriter.write(encoder.protocolVersion, streamId, headerFlags);
	  }

	  clone() {
	    return new BatchRequest(this.queries, this.options);
	  }
	}

	function CancelRequest(operationId) {
	  this.streamId = null;
	  this.operationId = operationId;
	}

	util.inherits(CancelRequest, Request);

	CancelRequest.prototype.write = function (encoder, streamId) {
	  const frameWriter = new FrameWriter(types.opcodes.cancel);
	  frameWriter.writeInt(1);
	  frameWriter.writeInt(this.operationId);
	  return frameWriter.write(encoder.protocolVersion, streamId);
	};

	class OptionsRequest extends Request {

	  write(encoder, streamId) {
	    const frameWriter = new FrameWriter(types.opcodes.options);
	    return frameWriter.write(encoder.protocolVersion, streamId, 0);
	  }

	  clone() {
	    // since options has no unique state, simply return self.
	    return this;
	  }
	}

	const options = new OptionsRequest();

	requests.AuthResponseRequest = AuthResponseRequest;
	requests.BatchRequest = BatchRequest;
	requests.CancelRequest = CancelRequest;
	requests.CredentialsRequest = CredentialsRequest;
	requests.ExecuteRequest = ExecuteRequest;
	requests.PrepareRequest = PrepareRequest;
	requests.QueryRequest = QueryRequest;
	requests.Request = Request;
	requests.RegisterRequest = RegisterRequest;
	requests.StartupRequest = StartupRequest;
	requests.options = options;
	return requests;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var clientState;
var hasRequiredClientState;

function requireClientState () {
	if (hasRequiredClientState) return clientState;
	hasRequiredClientState = 1;

	const util = require$$0$6;
	const errors = requireErrors$c();

	/**
	 * Represents the state of a {@link Client}.
	 * <p>
	 * Exposes information on the connections maintained by a Client at a specific time.
	 * </p>
	 * @alias module:metadata~ClientState
	 * @constructor
	 */
	class ClientState {

	  /**
	   * Creates a new instance of <code>ClientState</code>.
	   * @param {Array<Host>} hosts
	   * @param {Object.<String, Number>} openConnections
	   * @param {Object.<String, Number>} inFlightQueries
	   */
	  constructor(hosts, openConnections, inFlightQueries) {
	    this._hosts = hosts;
	    this._openConnections = openConnections;
	    this._inFlightQueries = inFlightQueries;
	  }

	  /**
	   * Get an array of hosts to which the client is connected to.
	   * @return {Array<Host>}
	   */
	  getConnectedHosts() {
	    return this._hosts;
	  }

	  /**
	   * Gets the amount of open connections to a given host.
	   * @param {Host} host
	   * @return {Number}
	   */
	  getOpenConnections(host) {
	    if (!host) {
	      throw new errors.ArgumentError('Host is not defined');
	    }

	    return this._openConnections[host.address] || 0;
	  }

	  /**
	   * Gets the amount of queries that are currently being executed through a given host.
	   * <p>
	   * This corresponds to the number of queries that have been sent by the Client to server Host on one of its connections
	   * but haven't yet obtained a response.
	   * </p>
	   * @param {Host} host
	   * @return {Number}
	   */
	  getInFlightQueries(host) {
	    if (!host) {
	      throw new errors.ArgumentError('Host is not defined');
	    }

	    return this._inFlightQueries[host.address] || 0;
	  }

	  /**
	   * Returns the string representation of the instance.
	   */
	  toString() {
	    return util.format('{"hosts": %j, "openConnections": %j, "inFlightQueries": %j}',
	      this._hosts.map(function (h) { return h.address; }), this._openConnections, this._inFlightQueries);
	  }

	  /**
	   * Creates a new instance from the provided client.
	   * @param {Client} client
	   * @internal
	   * @ignore
	   */
	  static from(client) {
	    const openConnections = {};
	    const inFlightQueries = {};
	    const hostArray = [];

	    client.hosts.forEach(host => {
	      if (host.pool.connections.length === 0) {
	        return;
	      }

	      hostArray.push(host);
	      openConnections[host.address] = host.pool.connections.length;
	      inFlightQueries[host.address] = host.getInFlight();
	    });

	    return new ClientState(hostArray, openConnections, inFlightQueries);
	  }
	}

	clientState = ClientState;
	return clientState;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var mutableLong;
var hasRequiredMutableLong;

function requireMutableLong () {
	if (hasRequiredMutableLong) return mutableLong;
	hasRequiredMutableLong = 1;

	const Long = requireUmd();

	const TWO_PWR_16_DBL = 1 << 16;
	const TWO_PWR_32_DBL = TWO_PWR_16_DBL * TWO_PWR_16_DBL;

	/**
	 * Constructs a signed int64 representation.
	 * @ignore
	 */
	class MutableLong {
	  constructor(b00, b16, b32, b48) {
	    // Use an array of uint16
	    this._arr = [b00 & 0xffff, b16 & 0xffff, b32 & 0xffff, b48 & 0xffff];
	  }

	  toString() {
	    return this.toImmutable().toString();
	  }

	  /**
	   * Compares this value with the provided value.
	   * @param {MutableLong} other
	   * @return {number}
	   */
	  compare(other) {
	    const thisNeg = this.isNegative();
	    const otherNeg = other.isNegative();
	    if (thisNeg && !otherNeg) {
	      return -1;
	    }
	    if (!thisNeg && otherNeg) {
	      return 1;
	    }
	    // At this point the sign bits are the same
	    return this._compareBits(other);
	  }

	  _compareBits(other) {
	    for (let i = 3; i >= 0; i--) {
	      if (this._arr[i] > other._arr[i]) {
	        return 1;
	      }
	      if (this._arr[i] < other._arr[i]) {
	        return -1;
	      }
	    }
	    return 0;
	  }

	  getUint16(index) {
	    return this._arr[index];
	  }

	  getLowBitsUnsigned() {
	    return (this._arr[0] | ((this._arr[1] & 0xffff) << 16)) >>> 0;
	  }

	  getHighBitsUnsigned() {
	    return (this._arr[2] | (this._arr[3] << 16)) >>> 0;
	  }

	  toNumber() {
	    return (this._arr[3] << 16 | this._arr[2]) * TWO_PWR_32_DBL + ((this._arr[1] << 16 | this._arr[0]) >>> 0);
	  }

	  /**
	   * Performs the bitwise NOT of this value.
	   * @return {MutableLong}
	   */
	  not() {
	    this._arr[0] = ~this._arr[0] & 0xffff;
	    this._arr[1] = ~this._arr[1] & 0xffff;
	    this._arr[2] = ~this._arr[2] & 0xffff;
	    this._arr[3] = ~this._arr[3] & 0xffff;
	    return this;
	  }

	  add(addend) {
	    let c48 = 0, c32 = 0, c16 = 0, c00 = 0;
	    c00 += this._arr[0] + addend._arr[0];
	    this._arr[0] = c00 & 0xffff;
	    c16 += c00 >>> 16;
	    c16 += this._arr[1] + addend._arr[1];
	    this._arr[1] = c16 & 0xffff;
	    c32 += c16 >>> 16;
	    c32 += this._arr[2] + addend._arr[2];
	    this._arr[2] = c32 & 0xffff;
	    c48 += c32 >>> 16;
	    c48 += this._arr[3] + addend._arr[3];
	    this._arr[3] = c48 & 0xffff;
	    return this;
	  }

	  shiftLeft(numBits) {
	    if (numBits === 0) {
	      return this;
	    }
	    if (numBits >= 64) {
	      return this.toZero();
	    }
	    const remainingBits = numBits % 16;
	    const pos = Math.floor(numBits / 16);
	    if (pos > 0) {
	      this._arr[3] = this._arr[3 - pos];
	      this._arr[2] = pos > 2 ? 0 : this._arr[2 - pos];
	      this._arr[1] = pos > 1 ? 0 : this._arr[0];
	      this._arr[0] = 0;
	    }
	    if (remainingBits > 0) {
	      // shift left within the int16 and the next one
	      this._arr[3] = ((this._arr[3] << remainingBits) | (this._arr[2] >>> (16 - remainingBits))) & 0xffff;
	      this._arr[2] = ((this._arr[2] << remainingBits) | (this._arr[1] >>> (16 - remainingBits))) & 0xffff;
	      this._arr[1] = ((this._arr[1] << remainingBits) | (this._arr[0] >>> (16 - remainingBits))) & 0xffff;
	      this._arr[0] = (this._arr[0] << remainingBits) & 0xffff;
	    }
	    return this;
	  }

	  shiftRightUnsigned(numBits) {
	    if (numBits === 0) {
	      return this;
	    }
	    if (numBits >= 64) {
	      return this.toZero();
	    }
	    const remainingBits = numBits % 16;
	    const pos = Math.floor(numBits / 16);
	    if (pos > 0) {
	      this._arr[0] = this._arr[pos];
	      this._arr[1] = pos > 2 ? 0 : this._arr[1 + pos];
	      this._arr[2] = pos > 1 ? 0 : this._arr[3];
	      this._arr[3] = 0;
	    }
	    if (remainingBits > 0) {
	      this._arr[0] = (this._arr[0] >>> remainingBits) | ((this._arr[1] << (16 - remainingBits)) & 0xffff);
	      this._arr[1] = (this._arr[1] >>> remainingBits) | ((this._arr[2] << (16 - remainingBits)) & 0xffff);
	      this._arr[2] = (this._arr[2] >>> remainingBits) | ((this._arr[3] << (16 - remainingBits)) & 0xffff);
	      this._arr[3] = this._arr[3] >>> remainingBits;
	    }
	    return this;
	  }

	  or(other) {
	    this._arr[0] |= other._arr[0];
	    this._arr[1] |= other._arr[1];
	    this._arr[2] |= other._arr[2];
	    this._arr[3] |= other._arr[3];
	    return this;
	  }

	  /**
	   * Returns the bitwise XOR of this Long and the given one.
	   * @param {MutableLong} other
	   * @returns {MutableLong} this instance.
	   */
	  xor(other) {
	    this._arr[0] ^= other._arr[0];
	    this._arr[1] ^= other._arr[1];
	    this._arr[2] ^= other._arr[2];
	    this._arr[3] ^= other._arr[3];
	    return this;
	  }

	  clone() {
	    return new MutableLong(this._arr[0], this._arr[1], this._arr[2], this._arr[3]);
	  }

	  /**
	   * Performs the product of this and the specified Long.
	   * @param {MutableLong} multiplier
	   * @returns {MutableLong} this instance.
	   */
	  multiply(multiplier) {
	    let negate = false;
	    if (this.isZero() || multiplier.isZero()) {
	      return this.toZero();
	    }
	    if (this.isNegative()) {
	      this.negate();
	      negate = !negate;
	    }
	    if (multiplier.isNegative()) {
	      multiplier = multiplier.clone().negate();
	      negate = !negate;
	    }
	    // We can skip products that would overflow.
	    let c48 = 0, c32 = 0, c16 = 0, c00 = 0;
	    c00 += this._arr[0] * multiplier._arr[0];
	    c16 += c00 >>> 16;
	    c16 += this._arr[1] * multiplier._arr[0];
	    c32 += c16 >>> 16;
	    c16 &= 0xFFFF;
	    c16 += this._arr[0] * multiplier._arr[1];
	    c32 += c16 >>> 16;
	    c32 += this._arr[2] * multiplier._arr[0];
	    c48 += c32 >>> 16;
	    c32 &= 0xFFFF;
	    c32 += this._arr[1] * multiplier._arr[1];
	    c48 += c32 >>> 16;
	    c32 &= 0xFFFF;
	    c32 += this._arr[0] * multiplier._arr[2];
	    c48 += c32 >>> 16;
	    c48 += this._arr[3] * multiplier._arr[0] + this._arr[2] * multiplier._arr[1] +
	      this._arr[1] * multiplier._arr[2] + this._arr[0] * multiplier._arr[3];
	    this._arr[0] = c00 & 0xffff;
	    this._arr[1] = c16 & 0xffff;
	    this._arr[2] = c32 & 0xffff;
	    this._arr[3] = c48 & 0xffff;
	    if (negate) {
	      this.negate();
	    }
	    return this;
	  }

	  toZero() {
	    this._arr[3] = this._arr[2] = this._arr[1] = this._arr[0] = 0;
	    return this;
	  }

	  isZero() {
	    return (this._arr[3] === 0 && this._arr[2] === 0 && this._arr[1] === 0 && this._arr[0] === 0);
	  }

	  isNegative() {
	    // most significant bit turned on
	    return (this._arr[3] & 0x8000) > 0;
	  }

	  /**
	   * Negates this value.
	   * @return {MutableLong}
	   */
	  negate() {
	    return this.not().add(MutableLong.one);
	  }

	  equals(other) {
	    if (!(other instanceof MutableLong)) {
	      return false;
	    }
	    return (this._arr[0] === other._arr[0] && this._arr[1] === other._arr[1] &&
	      this._arr[2] === other._arr[2] && this._arr[3] === other._arr[3]);
	  }

	  toImmutable() {
	    return Long.fromBits(this.getLowBitsUnsigned(), this.getHighBitsUnsigned(), false);
	  }

	  static fromNumber(value) {
	    if (isNaN(value) || !isFinite(value)) {
	      return new MutableLong();
	    }
	    if (value < 0) {
	      return MutableLong.fromNumber(-value).negate();
	    }
	    const low32Bits = value % TWO_PWR_32_DBL;
	    const high32Bits = value / TWO_PWR_32_DBL;
	    return MutableLong.fromBits(low32Bits, high32Bits);
	  }

	  static fromBits(low32Bits, high32Bits) {
	    return new MutableLong(low32Bits, low32Bits >>> 16, high32Bits, high32Bits >>> 16);
	  }

	  /**
	   * Returns a Long representation of the given string, written using the specified radix.
	   * @param {String} str
	   * @param {Number} [radix]
	   * @return {MutableLong}
	   */
	  static fromString(str, radix) {
	    if (typeof str !== 'string') {
	      throw new Error('String format is not valid: ' + str);
	    }
	    if (str.length === 0) {
	      throw Error('number format error: empty string');
	    }
	    if (str === "NaN" || str === "Infinity" || str === "+Infinity" || str === "-Infinity") {
	      return new MutableLong();
	    }
	    radix = radix || 10;
	    if (radix < 2 || radix > 36) {
	      throw Error('radix out of range: ' + radix);
	    }
	    let p;
	    if ((p = str.indexOf('-')) > 0) {
	      throw Error('number format error: interior "-" character: ' + str);
	    }
	    if (p === 0) {
	      return MutableLong.fromString(str.substring(1), radix).negate();
	    }
	    // Do several (8) digits each time through the loop
	    const radixToPower = MutableLong.fromNumber(Math.pow(radix, 8));
	    const result = new MutableLong();
	    for (let i = 0; i < str.length; i += 8) {
	      const size = Math.min(8, str.length - i);
	      const value = parseInt(str.substring(i, i + size), radix);
	      if (size < 8) {
	        const power = MutableLong.fromNumber(Math.pow(radix, size));
	        result.multiply(power).add(MutableLong.fromNumber(value));
	        break;
	      }
	      result.multiply(radixToPower);
	      result.add(MutableLong.fromNumber(value));
	    }
	    return result;
	  }
	}

	MutableLong.one = new MutableLong(1, 0, 0, 0);

	mutableLong = MutableLong;
	return mutableLong;
}var token$1 = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredToken$1;

function requireToken$1 () {
	if (hasRequiredToken$1) return token$1;
	hasRequiredToken$1 = 1;

	const types = requireTypes$2();
	const util = require$$0$6;

	const _Murmur3TokenType = types.dataTypes.getByName('bigint');
	const _RandomTokenType = types.dataTypes.getByName('varint');
	const _OrderedTokenType = types.dataTypes.getByName('blob');

	/**
	 * Represents a token on the Cassandra ring.
	 */
	class Token {
	  constructor(value) {
	    this._value = value;
	  }

	  /**
	   * @returns {{code: number, info: *|Object}} The type info for the
	   *                                           type of the value of the token.
	   */
	  getType() {
	    throw new Error('You must implement a getType function for this Token instance');
	  }

	  /**
	   * @returns {*} The raw value of the token.
	   */
	  getValue() {
	    return this._value;
	  }

	  toString() {
	    return this._value.toString();
	  }

	  /**
	   * Returns 0 if the values are equal, 1 if greater than other, -1
	   * otherwise.
	   *
	   * @param {Token} other 
	   * @returns {Number}
	   */
	  compare(other) {
	    return this._value.compare(other._value);
	  }

	  equals(other) {
	    return this.compare(other) === 0;
	  }

	  inspect() {
	    return this.constructor.name + ' { ' + this.toString() + ' }';
	  }
	}

	/**
	 * Represents a token from a Cassandra ring where the partitioner
	 * is Murmur3Partitioner.
	 * 
	 * The raw token type is a varint (represented by MutableLong).
	 */
	class Murmur3Token extends Token {
	  constructor(value) {
	    super(value);
	  }

	  getType() {
	    return _Murmur3TokenType;
	  }
	}

	/**
	 * Represents a token from a Cassandra ring where the partitioner
	 * is RandomPartitioner.
	 * 
	 * The raw token type is a bigint (represented by Number).
	 */
	class RandomToken extends Token {
	  constructor(value) {
	    super(value);
	  }

	  getType() {
	    return _RandomTokenType;
	  }
	}

	/**
	 * Represents a token from a Cassandra ring where the partitioner
	 * is ByteOrderedPartitioner.
	 * 
	 * The raw token type is a blob (represented by Buffer or Array).
	 */
	class ByteOrderedToken extends Token {
	  constructor(value) {
	    super(value);
	  }

	  getType() {
	    return _OrderedTokenType;
	  }

	  toString() {
	    return this._value.toString('hex').toUpperCase();
	  }
	}

	/** 
	 * Represents a range of tokens on a Cassandra ring.
	 *
	 * A range is start-exclusive and end-inclusive.  It is empty when
	 * start and end are the same token, except if that is the minimum
	 * token, in which case the range covers the whole ring (this is
	 * consistent with the behavior of CQL range queries).
	 *
	 * Note that CQL does not handle wrapping.  To query all partitions
	 * in a range, see {@link unwrap}.
	 */
	class TokenRange {
	  constructor(start, end, tokenizer) {
	    this.start = start;
	    this.end = end;
	    Object.defineProperty(this, '_tokenizer', { value: tokenizer, enumerable: false});
	  }

	  /**
	   * Splits this range into a number of smaller ranges of equal "size"
	   * (referring to the number of tokens, not the actual amount of data).
	   *
	   * Splitting an empty range is not permitted.  But not that, in edge
	   * cases, splitting a range might produce one or more empty ranges.
	   *
	   * @param {Number} numberOfSplits Number of splits to make.
	   * @returns {TokenRange[]} Split ranges.
	   * @throws {Error} If splitting an empty range.
	   */
	  splitEvenly(numberOfSplits) {
	    if (numberOfSplits < 1) {
	      throw new Error(util.format("numberOfSplits (%d) must be greater than 0.", numberOfSplits));
	    }
	    if (this.isEmpty()) {
	      throw new Error("Can't split empty range " + this.toString());
	    }

	    const tokenRanges = [];
	    const splitPoints = this._tokenizer.split(this.start, this.end, numberOfSplits);
	    let splitStart = this.start;
	    let splitEnd;
	    for (let splitIndex = 0; splitIndex < splitPoints.length; splitIndex++) {
	      splitEnd = splitPoints[splitIndex];
	      tokenRanges.push(new TokenRange(splitStart, splitEnd, this._tokenizer));
	      splitStart = splitEnd;
	    }
	    tokenRanges.push(new TokenRange(splitStart, this.end, this._tokenizer));
	    return tokenRanges;
	  }

	  /**
	   * A range is empty when start and end are the same token, except if
	   * that is the minimum token, in which case the range covers the
	   * whole ring.  This is consistent with the behavior of CQL range
	   * queries.
	   *
	   * @returns {boolean} Whether this range is empty.
	   */
	  isEmpty() {
	    return this.start.equals(this.end) && !this.start.equals(this._tokenizer.minToken());
	  }

	  /**
	   * A range wraps around the end of the ring when the start token
	   * is greater than the end token and the end token is not the 
	   * minimum token.
	   *
	   * @returns {boolean} Whether this range wraps around.
	   */
	  isWrappedAround() {
	    return this.start.compare(this.end) > 0 && !this.end.equals(this._tokenizer.minToken());
	  }

	  /**
	   * Splits this range into a list of two non-wrapping ranges.
	   *
	   * This will return the range itself if it is non-wrapped, or two
	   * ranges otherwise.
	   *
	   * This is useful for CQL range queries, which do not handle
	   * wrapping.
	   *
	   * @returns {TokenRange[]} The list of non-wrapping ranges.
	   */
	  unwrap() {
	    if (this.isWrappedAround()) {
	      return [
	        new TokenRange(this.start, this._tokenizer.minToken(), this._tokenizer),
	        new TokenRange(this._tokenizer.minToken(), this.end, this._tokenizer)
	      ];
	    }
	    return [this];
	  }

	  /**
	   * Whether this range contains a given Token.
	   * 
	   * @param {*} token Token to check for.
	   * @returns {boolean} Whether or not the Token is in this range.
	   */
	  contains(token) {
	    if (this.isEmpty()) {
	      return false;
	    }
	    const minToken = this._tokenizer.minToken();
	    if (this.end.equals(minToken)) {
	      if (this.start.equals(minToken)) {
	        return true; // ]minToken, minToken] === full ring
	      } else if (token.equals(minToken)) {
	        return true;
	      }
	      return token.compare(this.start) > 0;
	    }

	    const isAfterStart = token.compare(this.start) > 0;
	    const isBeforeEnd = token.compare(this.end) <= 0;
	    // if wrapped around ring, token is in ring if its after start or before end.
	    // otherwise, token is in ring if its after start and before end.
	    return this.isWrappedAround() 
	      ? isAfterStart || isBeforeEnd
	      : isAfterStart && isBeforeEnd;
	  }

	  /**
	   * Determines if the input range is equivalent to this one.
	   * 
	   * @param {TokenRange} other Range to compare with.
	   * @returns {boolean} Whether or not the ranges are equal.
	   */
	  equals(other) {
	    if (other === this) {
	      return true;
	    } else if (other instanceof TokenRange) {
	      return this.compare(other) === 0;
	    }
	    return false;
	  }

	  /**
	   * Returns 0 if the values are equal, otherwise compares against
	   * start, if start is equal, compares against end.
	   *  
	   * @param {TokenRange} other Range to compare with.
	   * @returns {Number} 
	   */
	  compare(other) {
	    const compareStart = this.start.compare(other.start);
	    return compareStart !== 0 ? compareStart : this.end.compare(other.end);
	  }

	  toString() {
	    return util.format(']%s, %s]', 
	      this.start.toString(),
	      this.end.toString()
	    );
	  }
	}

	token$1.Token = Token;
	token$1.TokenRange = TokenRange;
	token$1.ByteOrderedToken = ByteOrderedToken;
	token$1.Murmur3Token = Murmur3Token;
	token$1.RandomToken = RandomToken;
	return token$1;
}var search$1 = {};var dateRange = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredDateRange;

function requireDateRange () {
	if (hasRequiredDateRange) return dateRange;
	hasRequiredDateRange = 1;

	const utils = requireUtils$c();
	const Long = requireUmd();

	/**
	 * Regex to parse dates in the following format YYYY-MM-DDThh:mm:ss.mssZ
	 * Looks cumbersome but it's straightforward:
	 * - "(\d{1,6})": year mandatory 1 to 6 digits
	 * - (?:-(\d{1,2}))?(?:-(\d{1,2}))? two non-capturing groups representing the month and day (1 to 2 digits captured).
	 * - (?:T(\d{1,2}?)?(?::(\d{1,2}))?(?::(\d{1,2}))?)?Z? A non-capturing group for the time portion
	 * @private
	 */
	const dateRegex =
	  /^[-+]?(\d{1,6})(?:-(\d{1,2}))?(?:-(\d{1,2}))?(?:T(\d{1,2}?)?(?::(\d{1,2}))?(?::(\d{1,2})(?:\.(\d{1,3}))?)?)?Z?$/;
	const multipleBoundariesRegex = /^\[(.+?) TO (.+)]$/;
	const unbounded = Object.freeze(new DateRangeBound(null, -1));

	const dateRangeType = {
	  // single value as in "2001-01-01"
	  singleValue: 0,
	  // closed range as in "[2001-01-01 TO 2001-01-31]"
	  closedRange: 1,
	  // open range high as in "[2001-01-01 TO *]"
	  openRangeHigh: 2,
	  // - 0x03 - open range low as in "[* TO 2001-01-01]"
	  openRangeLow: 3,
	  // - 0x04 - both ranges open as in "[* TO *]"
	  openBoth: 4,
	  // - 0x05 - single open range as in "[*]"
	  openSingle: 5
	};

	/**
	 * Defines the possible values of date range precision.
	 * @type {Object}
	 * @property {Number} year
	 * @property {Number} month
	 * @property {Number} day
	 * @property {Number} hour
	 * @property {Number} minute
	 * @property {Number} second
	 * @property {Number} millisecond
	 * @memberof module:search
	 */
	const dateRangePrecision = {
	  year: 0,
	  month: 1,
	  day: 2,
	  hour: 3,
	  minute: 4,
	  second: 5,
	  millisecond: 6
	};

	/**
	 * Creates a new instance of <code>DateRange</code> using a lower bound and an upper bound.
	 * <p>Consider using <code>DateRange.fromString()</code> to create instances more easily.</p>
	 * @classdesc
	 * Represents a range of dates, corresponding to the Apache Solr type
	 * <a href="https://cwiki.apache.org/confluence/display/solr/Working+with+Dates"><code>DateRangeField</code></a>.
	 * <p>
	 *   A date range can have one or two bounds, namely lower bound and upper bound, to represent an interval of time.
	 *   Date range bounds are both inclusive. For example:
	 * </p>
	 * <ul>
	 *   <li><code>2015 TO 2016-10</code> represents from the first day of 2015 to the last day of October 2016</li>
	 *   <li><code>2015</code> represents during the course of the year 2015.</li>
	 *   <li><code>2017 TO *</code> represents any date greater or equals to the first day of the year 2017.</li>
	 * </ul>
	 * <p>
	 *   Note that this JavaScript representation of <code>DateRangeField</code> does not support Dates outside of the range
	 *   supported by ECMAScript Date: –100,000,000 days to 100,000,000 days measured relative to midnight at the
	 *   beginning of 01 January, 1970 UTC. Being <code>-271821-04-20T00:00:00.000Z</code> the minimum lower boundary
	 *   and <code>275760-09-13T00:00:00.000Z</code> the maximum higher boundary.
	 * <p>
	 * @param {DateRangeBound} lowerBound A value representing the range lower bound, composed by a
	 * <code>Date</code> and a precision. Use <code>DateRangeBound.unbounded</code> for an open lower bound.
	 * @param {DateRangeBound} [upperBound] A value representing the range upper bound, composed by a
	 * <code>Date</code> and a precision. Use <code>DateRangeBound.unbounded</code> for an open upper bound. When it's not
	 * defined, the <code>DateRange</code> instance is considered as a single value range.
	 * @constructor
	 * @memberOf module:datastax/search
	 */
	function DateRange(lowerBound, upperBound) {
	  if (!lowerBound) {
	    throw new TypeError('The lower boundaries must be defined');
	  }
	  /**
	   * Gets the lower bound of this range (inclusive).
	   * @type {DateRangeBound}
	   */
	  this.lowerBound = lowerBound;
	  /**
	   * Gets the upper bound of this range (inclusive).
	   * @type {DateRangeBound|null}
	   */
	  this.upperBound = upperBound || null;

	  // Define the type
	  if (this.upperBound === null) {
	    if (this.lowerBound !== unbounded) {
	      this._type = dateRangeType.singleValue;
	    }
	    else {
	      this._type = dateRangeType.openSingle;
	    }
	  }
	  else {
	    if (this.lowerBound !== unbounded) {
	      this._type = this.upperBound !== unbounded ? dateRangeType.closedRange : dateRangeType.openRangeHigh;
	    }
	    else {
	      this._type = this.upperBound !== unbounded ? dateRangeType.openRangeLow : dateRangeType.openBoth;
	    }
	  }
	}

	/**
	 * Returns true if the value of this DateRange instance and other are the same.
	 * @param {DateRange} other
	 * @returns {Boolean}
	 */
	DateRange.prototype.equals = function (other) {
	  if (!(other instanceof DateRange)) {
	    return false;
	  }
	  return (other.lowerBound.equals(this.lowerBound) &&
	  (other.upperBound ? other.upperBound.equals(this.upperBound) : !this.upperBound));
	};

	/**
	 * Returns the string representation of the instance.
	 * @return {String}
	 */
	DateRange.prototype.toString = function () {
	  if (this.upperBound === null) {
	    return this.lowerBound.toString();
	  }
	  return '[' + this.lowerBound.toString() + ' TO ' + this.upperBound.toString() + ']';
	};

	DateRange.prototype.toBuffer = function () {
	  // Serializes the value containing:
	  // <type>[<time0><precision0><time1><precision1>]
	  if (this._type === dateRangeType.openBoth || this._type === dateRangeType.openSingle) {
	    return utils.allocBufferFromArray([ this._type ]);
	  }
	  let buffer;
	  let offset = 0;
	  if (this._type !== dateRangeType.closedRange) {
	    // byte + long + byte
	    const boundary = this._type !== dateRangeType.openRangeLow ? this.lowerBound : this.upperBound;
	    buffer = utils.allocBufferUnsafe(10);
	    buffer.writeUInt8(this._type, offset++);
	    offset = writeDate(boundary.date, buffer, offset);
	    buffer.writeUInt8(boundary.precision, offset);
	    return buffer;
	  }
	  // byte + long + byte + long + byte
	  buffer = utils.allocBufferUnsafe(19);
	  buffer.writeUInt8(this._type, offset++);
	  offset = writeDate(this.lowerBound.date, buffer, offset);
	  buffer.writeUInt8(this.lowerBound.precision, offset++);
	  offset = writeDate(this.upperBound.date, buffer, offset);
	  buffer.writeUInt8(this.upperBound.precision, offset);
	  return buffer;
	};

	/**
	 * Returns the <code>DateRange</code> representation of a given string.
	 * <p>String representations of dates are always expressed in Coordinated Universal Time (UTC)</p>
	 * @param {String} dateRangeString
	 */
	DateRange.fromString = function (dateRangeString) {
	  const matches = multipleBoundariesRegex.exec(dateRangeString);
	  if (!matches) {
	    return new DateRange(DateRangeBound.toLowerBound(DateRangeBound.fromString(dateRangeString)));
	  }
	  return new DateRange(DateRangeBound.toLowerBound(DateRangeBound.fromString(matches[1])), DateRangeBound.toUpperBound(DateRangeBound.fromString(matches[2])));
	};

	/**
	 * Deserializes the buffer into a <code>DateRange</code>
	 * @param {Buffer} buffer
	 * @return {DateRange}
	 */
	DateRange.fromBuffer = function (buffer) {
	  if (buffer.length === 0) {
	    throw new TypeError('DateRange serialized value must have at least 1 byte');
	  }
	  const type = buffer.readUInt8(0);
	  if (type === dateRangeType.openBoth) {
	    return new DateRange(unbounded, unbounded);
	  }
	  if (type === dateRangeType.openSingle) {
	    return new DateRange(unbounded);
	  }
	  let offset = 1;
	  let date1;
	  let lowerBound;
	  let upperBound = null;
	  if (type !== dateRangeType.closedRange) {
	    date1 = readDate(buffer, offset);
	    offset += 8;
	    lowerBound = new DateRangeBound(date1, buffer.readUInt8(offset));
	    if (type === dateRangeType.openRangeLow) {
	      // lower boundary is open, the first serialized boundary is the upperBound
	      upperBound = lowerBound;
	      lowerBound = unbounded;
	    }
	    else {
	      upperBound = type === dateRangeType.openRangeHigh ? unbounded : null;
	    }
	    return new DateRange(lowerBound, upperBound);
	  }
	  date1 = readDate(buffer, offset);
	  offset += 8;
	  lowerBound = new DateRangeBound(date1, buffer.readUInt8(offset++));
	  const date2 = readDate(buffer, offset);
	  offset += 8;
	  upperBound = new DateRangeBound(date2, buffer.readUInt8(offset));
	  return new DateRange(lowerBound, upperBound);
	};

	/**
	 * Writes a Date, long millis since epoch, to a buffer starting from offset.
	 * @param {Date} date
	 * @param {Buffer} buffer
	 * @param {Number} offset
	 * @return {Number} The new offset.
	 * @private
	 */
	function writeDate(date, buffer, offset) {
	  const long = Long.fromNumber(date.getTime());
	  buffer.writeUInt32BE(long.getHighBitsUnsigned(), offset);
	  buffer.writeUInt32BE(long.getLowBitsUnsigned(), offset + 4);
	  return offset + 8;
	}

	/**
	 * Reads a Date, long millis since epoch, from a buffer starting from offset.
	 * @param {Buffer} buffer
	 * @param {Number} offset
	 * @return {Date}
	 * @private
	 */
	function readDate(buffer, offset) {
	  const long = new Long(buffer.readInt32BE(offset+4), buffer.readInt32BE(offset));
	  return new Date(long.toNumber());
	}

	/**
	 * @classdesc
	 * Represents a date range boundary, composed by a <code>Date</code> and a precision.
	 * @param {Date} date The timestamp portion, representing a single moment in time. Consider using
	 * <code>Date.UTC()</code> method to build the <code>Date</code> instance.
	 * @param {Number} precision The precision portion. Valid values for <code>DateRangeBound</code> precision are
	 * defined in the [dateRangePrecision]{@link module:datastax/search~dateRangePrecision} member.
	 * @constructor
	 * @memberOf module:datastax/search
	 */
	function DateRangeBound(date, precision) {
	  /**
	   * The timestamp portion of the boundary.
	   * @type {Date}
	   */
	  this.date = date;
	  /**
	   * The precision portion of the boundary. Valid values are defined in the
	   * [dateRangePrecision]{@link module:datastax/search~dateRangePrecision} member.
	   * @type {Number}
	   */
	  this.precision = precision;
	}

	/**
	 * Returns the string representation of the instance.
	 * @return {String}
	 */
	DateRangeBound.prototype.toString = function () {
	  if (this.precision === -1) {
	    return '*';
	  }
	  let precision = 0;
	  const isoString = this.date.toISOString();
	  let i;
	  let char;
	  // The years take at least the first 4 characters
	  for (i = 4; i < isoString.length && precision <= this.precision; i++) {
	    char = isoString.charAt(i);
	    if (precision === dateRangePrecision.day && char === 'T') {
	      precision = dateRangePrecision.hour;
	      continue;
	    }
	    if (precision >= dateRangePrecision.hour && char === ':' || char === '.') {
	      precision++;
	      continue;
	    }
	    if (precision < dateRangePrecision.day && char === '-') {
	      precision++;
	    }
	  }
	  let start = 0;
	  const firstChar = isoString.charAt(0);
	  let sign = '';
	  let toRemoveIndex = 4;
	  if (firstChar === '+' || firstChar === '-') {
	    sign = firstChar;
	    if (firstChar === '-') {
	      // since we are retaining the -, don't remove as many zeros.
	      toRemoveIndex = 3;
	    }
	    // Remove additional zeros
	    for (start = 1; start < toRemoveIndex; start++) {
	      if (isoString.charAt(start) !== '0') {
	        break;
	      }
	    }
	  }
	  if (this.precision !== dateRangePrecision.millisecond) {
	    // i holds the position of the first char that marks the end of a precision (ie: '-', 'T', ...),
	    // we should not include it in the result, except its the 'Z' char for the complete representation
	    i--;
	  }
	  return sign + isoString.substring(start, i);
	};

	/**
	 * Returns true if the value of this DateRange instance and other are the same.
	 * @param {DateRangeBound} other
	 * @return {boolean}
	 */
	DateRangeBound.prototype.equals = function (other) {
	  if (!(other instanceof DateRangeBound)) {
	    return false;
	  }
	  if (other.precision !== this.precision) {
	    return false;
	  }
	  return datesEqual(other.date, this.date);
	};

	function datesEqual(d1, d2) {
	  const t1 = d1 ? d1.getTime() : null;
	  const t2 = d2 ? d2.getTime() : null;
	  return t1 === t2;
	}

	DateRangeBound.prototype.isUnbounded = function () {
	  return (this.precision === -1);
	};

	/**
	 * Parses a date string and returns a DateRangeBound.
	 * @param {String} boundaryString
	 * @return {DateRangeBound}
	 */
	DateRangeBound.fromString = function(boundaryString) {
	  if (!boundaryString) {
	    return null;
	  }
	  if (boundaryString === '*') {
	    return unbounded;
	  }
	  const matches = dateRegex.exec(boundaryString);
	  if (!matches) {
	    throw TypeError('String provided is not a valid date ' + boundaryString);
	  }
	  if (matches[7] !== undefined && matches[5] === undefined) {
	    // Due to a limitation in the regex, its possible to match dates like 2015T03:02.001, without the seconds
	    // portion but with the milliseconds specified.
	    throw new TypeError('String representation of the date contains the milliseconds portion but not the seconds: ' +
	      boundaryString);
	  }
	  const builder = new BoundaryBuilder(boundaryString.charAt(0) === '-');
	  for (let i = 1; i < matches.length; i++) {
	    builder.set(i-1, matches[i], boundaryString);
	  }
	  return builder.build();
	};

	/**
	 * The unbounded {@link DateRangeBound} instance. Unbounded bounds are syntactically represented by a <code>*</code>
	 * (star) sign.
	 * @type {DateRangeBound}
	 */
	DateRangeBound.unbounded = unbounded;

	/**
	 * Converts a {DateRangeBound} into a lower-bounded bound by rounding down its date
	 * based on its precision.
	 *
	 * @param {DateRangeBound} bound The bound to round down.
	 * @returns {DateRangeBound} with the date rounded down to the given precision.
	 */
	DateRangeBound.toLowerBound = function (bound) {
	  if(bound === unbounded) {
	    return bound;
	  }
	  const rounded = new Date(bound.date.getTime());
	  // in this case we want to fallthrough
	  /* eslint-disable no-fallthrough */
	  switch (bound.precision) {
	    case dateRangePrecision.year:
	      rounded.setUTCMonth(0);
	    case dateRangePrecision.month:
	      rounded.setUTCDate(1);
	    case dateRangePrecision.day:
	      rounded.setUTCHours(0);
	    case dateRangePrecision.hour:
	      rounded.setUTCMinutes(0);
	    case dateRangePrecision.minute:
	      rounded.setUTCSeconds(0);
	    case dateRangePrecision.second:
	      rounded.setUTCMilliseconds(0);
	  }
	  /* eslint-enable no-fallthrough */
	  return new DateRangeBound(rounded, bound.precision);
	};

	/**
	 * Converts a {DateRangeBound} into a upper-bounded bound by rounding up its date
	 * based on its precision.
	 *
	 * @param {DateRangeBound} bound The bound to round up.
	 * @returns {DateRangeBound} with the date rounded up to the given precision.
	 */
	DateRangeBound.toUpperBound = function (bound) {
	  if (bound === unbounded) {
	    return bound;
	  }
	  const rounded = new Date(bound.date.getTime());
	  // in this case we want to fallthrough
	  /* eslint-disable no-fallthrough */
	  switch (bound.precision) {
	    case dateRangePrecision.year:
	      rounded.setUTCMonth(11);
	    case dateRangePrecision.month:
	      // Advance to the beginning of next month and set day of month to 0
	      // which sets the date to the last day of the previous month.
	      // This gives us the effect of YYYY-MM-LastDayOfThatMonth
	      rounded.setUTCMonth(rounded.getUTCMonth() + 1, 0);
	    case dateRangePrecision.day:
	      rounded.setUTCHours(23);
	    case dateRangePrecision.hour:
	      rounded.setUTCMinutes(59);
	    case dateRangePrecision.minute:
	      rounded.setUTCSeconds(59);
	    case dateRangePrecision.second:
	      rounded.setUTCMilliseconds(999);
	  }
	  /* eslint-enable no-fallthrough */
	  return new DateRangeBound(rounded, bound.precision);
	};

	/** @private */
	function BoundaryBuilder(isNegative) {
	  this._sign = isNegative ? -1 : 1;
	  this._index = 0;
	  this._values = new Int32Array(7);
	}

	BoundaryBuilder.prototype.set = function (index, value, stringDate) {
	  if (value === undefined) {
	    return;
	  }
	  if (index > 6) {
	    throw new TypeError('Index out of bounds: ' + index);
	  }
	  if (index > this._index) {
	    this._index = index;
	  }
	  const numValue = +value;
	  switch (index) {
	    case dateRangePrecision.month:
	      if (numValue < 1 || numValue > 12) {
	        throw new TypeError('Month portion is not valid for date: ' + stringDate);
	      }
	      break;
	    case dateRangePrecision.day:
	      if (numValue < 1 || numValue > 31) {
	        throw new TypeError('Day portion is not valid for date: ' + stringDate);
	      }
	      break;
	    case dateRangePrecision.hour:
	      if (numValue > 23) {
	        throw new TypeError('Hour portion is not valid for date: ' + stringDate);
	      }
	      break;
	    case dateRangePrecision.minute:
	    case dateRangePrecision.second:
	      if (numValue > 59) {
	        throw new TypeError('Minute/second portion is not valid for date: ' + stringDate);
	      }
	      break;
	    case dateRangePrecision.millisecond:
	      if (numValue > 999) {
	        throw new TypeError('Millisecond portion is not valid for date: ' + stringDate);
	      }
	      break;
	  }
	  this._values[index] = numValue;
	};

	/** @return {DateRangeBound} */
	BoundaryBuilder.prototype.build = function () {
	  const date = new Date(0);
	  let month = this._values[1];
	  if (month) {
	    // ES Date months are represented from 0 to 11
	    month--;
	  }
	  date.setUTCFullYear(this._sign * this._values[0], month, this._values[2] || 1);
	  date.setUTCHours(this._values[3], this._values[4], this._values[5], this._values[6]);
	  return new DateRangeBound(date, this._index);
	};

	dateRange.unbounded = unbounded;
	dateRange.dateRangePrecision = dateRangePrecision;
	dateRange.DateRange = DateRange;
	dateRange.DateRangeBound = DateRangeBound;
	return dateRange;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredSearch$1;

function requireSearch$1 () {
	if (hasRequiredSearch$1) return search$1;
	hasRequiredSearch$1 = 1;

	const dateRangeModule = requireDateRange();

	/**
	 * Search module.
	 * <p>
	 *   Contains the classes to represent the set of  types for search data that come with DSE 5.1+
	 * </p>
	 * @module datastax/search
	 */

	search$1.DateRange = dateRangeModule.DateRange;
	search$1.DateRangeBound = dateRangeModule.DateRangeBound;
	search$1.dateRangePrecision = dateRangeModule.dateRangePrecision;
	return search$1;
}var geometry$1 = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var geometry;
var hasRequiredGeometry$1;

function requireGeometry$1 () {
	if (hasRequiredGeometry$1) return geometry;
	hasRequiredGeometry$1 = 1;

	const endianness = {
	  '0': 'BE',
	  '1': 'LE'
	};

	function Geometry() {

	}

	Geometry.types = {
	  Point2D: 1,
	  LineString: 2,
	  Polygon: 3
	};

	/**
	 * @protected
	 * @param {Number} code
	 * @returns {String}
	 * @ignore
	 */
	Geometry.getEndianness = function (code) {
	  const value = endianness[code.toString()];
	  if (typeof value === 'undefined') {
	    throw new TypeError('Invalid endianness with code ' + code);
	  }
	  return value;
	};

	/**
	 * Reads an int32 from binary representation based on endianness.
	 * @protected
	 * @param {Buffer} buffer
	 * @param {String} endianness
	 * @param {Number} offset
	 * @returns Number
	 * @ignore
	 */
	Geometry.readInt32 = function (buffer, endianness, offset) {
	  if (endianness === 'BE') {
	    return buffer.readInt32BE(offset, true);
	  }
	  return buffer.readInt32LE(offset, true);
	};

	/**
	 * Reads an 64-bit double from binary representation based on endianness.
	 * @protected
	 * @param {Buffer} buffer
	 * @param {String} endianness
	 * @param {Number} offset
	 * @returns Number
	 * @ignore
	 */
	Geometry.readDouble = function (buffer, endianness, offset) {
	  if (endianness === 'BE') {
	    return buffer.readDoubleBE(offset, true);
	  }
	  return buffer.readDoubleLE(offset, true);
	};

	/**
	 * Writes an 32-bit integer to binary representation based on OS endianness.
	 * @protected
	 * @param {Number} val
	 * @param {Buffer} buffer
	 * @param {Number} offset
	 * @ignore
	 */
	Geometry.prototype.writeInt32 = function (val, buffer, offset) {
	  if (this.useBESerialization()) {
	    return buffer.writeInt32BE(val, offset, true);
	  }
	  return buffer.writeInt32LE(val, offset, true);
	};

	/**
	 * Writes an 64-bit double to binary representation based on OS endianness.
	 * @protected
	 * @param {Number} val
	 * @param {Buffer} buffer
	 * @param {Number} offset
	 * @ignore
	 */
	Geometry.prototype.writeDouble = function (val, buffer, offset) {
	  if (this.useBESerialization()) {
	    return buffer.writeDoubleBE(val, offset, true);
	  }
	  return buffer.writeDoubleLE(val, offset, true);
	};

	/**
	 * Writes an 8-bit int that represents the OS endianness.
	 * @protected
	 * @param {Buffer} buffer
	 * @param {Number} offset
	 * @ignore
	 */
	Geometry.prototype.writeEndianness = function (buffer, offset) {
	  if (this.useBESerialization()) {
	    return buffer.writeInt8(0, offset, true);
	  }
	  return buffer.writeInt8(1, offset, true);
	};

	/**
	 * Returns true if the serialization must be done in big-endian format.
	 * Designed to allow injection of OS endianness.
	 * @abstract
	 * @ignore
	 */
	Geometry.prototype.useBESerialization = function () {
	  throw new Error('Not Implemented');
	};

	geometry = Geometry;
	return geometry;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var point;
var hasRequiredPoint;

function requirePoint () {
	if (hasRequiredPoint) return point;
	hasRequiredPoint = 1;
	const util = require$$0$6;
	const utils = requireUtils$c();
	const Geometry = requireGeometry$1();

	/**
	 * Creates a new {@link Point} instance.
	 * @classdesc
	 * A Point is a zero-dimensional object that represents a specific (X,Y)
	 * location in a two-dimensional XY-Plane. In case of Geographic Coordinate
	 * Systems, the X coordinate is the longitude and the Y is the latitude.
	 * @param {Number} x The X coordinate.
	 * @param {Number} y The Y coordinate.
	 * @extends {Geometry}
	 * @alias module:geometry~Point
	 * @constructor
	 */
	function Point(x, y) {
	  if (typeof x !== 'number' || typeof y !== 'number') {
	    throw new TypeError('X and Y must be numbers');
	  }
	  if (isNaN(x) || isNaN(y)) {
	    throw new TypeError('X and Y must be numbers');
	  }
	  /**
	   * Returns the X coordinate of this 2D point.
	   * @type {Number}
	   */
	  this.x = x;
	  /**
	   * Returns the Y coordinate of this 2D point.
	   * @type {Number}
	   */
	  this.y = y;
	}

	//noinspection JSCheckFunctionSignatures
	util.inherits(Point, Geometry);

	/**
	 * Creates a {@link Point} instance from
	 * a <a href="https://en.wikipedia.org/wiki/Well-known_text">Well-known Text (WKT)</a>
	 * representation of a 2D point.
	 * @param {Buffer} buffer
	 * @returns {Point}
	 */
	Point.fromBuffer = function (buffer) {
	  if (!buffer || buffer.length !== 21) {
	    throw new TypeError('2D Point buffer should contain 21 bytes');
	  }
	  const endianness = Geometry.getEndianness(buffer.readInt8(0, true));
	  if (Geometry.readInt32(buffer, endianness, 1) !== Geometry.types.Point2D) {
	    throw new TypeError('Binary representation was not a point');
	  }
	  return new Point(Geometry.readDouble(buffer, endianness, 5), Geometry.readDouble(buffer, endianness, 13));
	};

	/**
	 * Creates a {@link Point} instance from
	 * a <a href="https://en.wikipedia.org/wiki/Well-known_text">Well-known Text (WKT)</a>
	 * representation of a 2D point.
	 * @param {String} textValue
	 * @returns {Point}
	 */
	Point.fromString = function (textValue) {
	  const wktRegex = /^POINT\s?\(([-0-9.]+) ([-0-9.]+)\)$/g;
	  const matches = wktRegex.exec(textValue);
	  if (!matches || matches.length !== 3) {
	    throw new TypeError('2D Point WTK should contain 2 coordinates');
	  }
	  return new Point(parseFloat(matches[1]), parseFloat(matches[2]));
	};

	/**
	 * Returns a <a href="https://en.wikipedia.org/wiki/Well-known_text#Well-known_binary">Well-known Binary</a> (WKB)
	 * representation of this instance.
	 * @returns {Buffer}
	 */
	Point.prototype.toBuffer = function () {
	  const buffer = utils.allocBufferUnsafe(21);
	  this.writeEndianness(buffer, 0);
	  this.writeInt32(Geometry.types.Point2D, buffer, 1);
	  this.writeDouble(this.x, buffer, 5);
	  this.writeDouble(this.y, buffer, 13);
	  return buffer;
	};

	/**
	 * Returns true if the values of the point are the same, otherwise it returns false.
	 * @param {Point} other
	 * @returns {Boolean}
	 */
	Point.prototype.equals = function (other) {
	  if (!(other instanceof Point)) {
	    return false;
	  }
	  return (this.x === other.x && this.y === other.y);
	};

	/**
	 * Returns Well-known text (WKT) representation of the geometry object.
	 * @returns {String}
	 */
	Point.prototype.toString = function () {
	  return util.format('POINT (%d %d)', this.x, this.y);
	};

	Point.prototype.useBESerialization = function () {
	  return false;
	};

	/**
	 * Returns a JSON representation of this geo-spatial type.
	 */
	Point.prototype.toJSON = function () {
	  return { type: 'Point', coordinates: [ this.x, this.y ]};
	};

	point = Point;
	return point;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var lineString;
var hasRequiredLineString;

function requireLineString () {
	if (hasRequiredLineString) return lineString;
	hasRequiredLineString = 1;
	const util = require$$0$6;
	const utils = requireUtils$c();
	const Geometry = requireGeometry$1();
	const Point = requirePoint();

	/**
	 * Creates a new {@link LineString} instance.
	 * @classdesc
	 * A LineString is a one-dimensional object representing a sequence of points and the line segments connecting them.
	 * @param {...Point}[point] A sequence of [Point]{@link module:geometry~Point} items as arguments.
	 * @example
	 * new LineString(new Point(10.99, 20.02), new Point(14, 26), new Point(34, 1.2));
	 * @constructor
	 * @alias module:geometry~LineString
	 * @extends {Geometry}
	 */
	function LineString(point) {
	  let points = Array.prototype.slice.call(arguments);
	  if (points.length === 1 && Array.isArray(points) && Array.isArray(points[0])) {
	    //The first argument is an array of the points
	    points = points[0];
	  }
	  if (points.length === 1) {
	    throw new TypeError('LineString can be either empty or contain 2 or more points');
	  }
	  /**
	   * Returns a frozen Array of points that represent the line.
	   * @type {Array.<Point>}
	   */
	  this.points = Object.freeze(points);
	}

	//noinspection JSCheckFunctionSignatures
	util.inherits(LineString, Geometry);

	/**
	 * Creates a {@link LineString} instance from
	 * a <a href="https://en.wikipedia.org/wiki/Well-known_text">Well-known Text (WKT)</a>
	 * representation of a line.
	 * @param {Buffer} buffer
	 * @returns {LineString}
	 */
	LineString.fromBuffer = function (buffer) {
	  if (!buffer || buffer.length < 9) {
	    throw new TypeError('A linestring buffer should contain at least 9 bytes');
	  }
	  const endianness = Geometry.getEndianness(buffer.readInt8(0, true));
	  let offset = 1;
	  if (Geometry.readInt32(buffer, endianness, offset) !== Geometry.types.LineString) {
	    throw new TypeError('Binary representation was not a LineString');
	  }
	  offset += 4;
	  const length = Geometry.readInt32(buffer, endianness, offset);
	  offset += 4;
	  if (buffer.length !== offset + length * 16) {
	    throw new TypeError(util.format('Length of the buffer does not match %d !== %d', buffer.length, offset + length * 8));
	  }
	  const points = new Array(length);
	  for (let i = 0; i < length; i++) {
	    points[i] = new Point(
	      Geometry.readDouble(buffer, endianness, offset),
	      Geometry.readDouble(buffer, endianness, offset + 8));
	    offset += 16;
	  }
	  //noinspection JSCheckFunctionSignatures
	  return new LineString(points);
	};

	/**
	 * Creates a {@link LineString} instance from
	 * a <a href="https://en.wikipedia.org/wiki/Well-known_text">Well-known Text (WKT)</a>
	 * representation of a line.
	 * @param {String} textValue
	 * @returns {LineString}
	 */
	LineString.fromString = function (textValue) {
	  const wktRegex = /^LINESTRING ?\(([-0-9. ,]+)\)+$/g;
	  const matches = wktRegex.exec(textValue);
	  if (!matches || matches.length !== 2) {
	    throw new TypeError('Invalid WKT: ' + textValue);
	  }
	  const points = LineString.parseSegments(matches[1]);
	  return new LineString(points);
	};

	/**
	 * Internal method that parses a series of WKT points.
	 * @param {String} textValue
	 * @returns {Array<Point>}
	 * @internal
	 * @ignore
	 */
	LineString.parseSegments = function (textValue) {
	  const points = [];
	  const pointParts = textValue.split(',');
	  for (let i = 0; i < pointParts.length; i++) {
	    const p = pointParts[i].trim();
	    if (p.length === 0) {
	      throw new TypeError('Invalid WKT segment: ' + textValue);
	    }
	    const xyText = p.split(' ').filter(function (element) {
	      return (element.trim().length > 0);
	    });
	    if (xyText.length !== 2) {
	      throw new TypeError('Invalid WKT segment: ' + textValue);
	    }
	    points.push(new Point(parseFloat(xyText[0]), parseFloat(xyText[1])));
	  }
	  return points;
	};

	/**
	 * Returns a <a href="https://en.wikipedia.org/wiki/Well-known_text#Well-known_binary">Well-known Binary</a> (WKB)
	 * representation of this instance.
	 * @returns {Buffer}
	 */
	LineString.prototype.toBuffer = function () {
	  const buffer = utils.allocBufferUnsafe(9 + this.points.length * 16);
	  this.writeEndianness(buffer, 0);
	  let offset = 1;
	  this.writeInt32(Geometry.types.LineString, buffer, offset);
	  offset += 4;
	  this.writeInt32(this.points.length, buffer, offset);
	  offset += 4;
	  this.points.forEach(function (p) {
	    this.writeDouble(p.x, buffer, offset);
	    this.writeDouble(p.y, buffer, offset + 8);
	    offset += 16;
	  }, this);
	  return buffer;
	};

	/**
	 * Returns true if the values of the linestrings are the same, otherwise it returns false.
	 * @param {LineString} other
	 * @returns {Boolean}
	 */
	LineString.prototype.equals = function (other) {
	  if (!(other instanceof LineString)) {
	    return false;
	  }
	  if (this.points.length !== other.points.length) {
	    return false;
	  }
	  for (let i = 0; i < this.points.length; i++) {
	    if (!this.points[i].equals(other.points[i])) {
	      return false;
	    }
	  }
	  return true;
	};

	/**
	 * Returns Well-known text (WKT) representation of the geometry object.
	 * @returns {String}
	 */
	LineString.prototype.toString = function () {
	  if (this.points.length === 0) {
	    return 'LINESTRING EMPTY';
	  }
	  return 'LINESTRING ('
	    + this.points.map(function (p) {
	      return p.x + ' ' + p.y;
	    }).join(', ')
	    + ')';
	};

	LineString.prototype.useBESerialization = function () {
	  return false;
	};

	/**
	 * Returns a JSON representation of this geo-spatial type.
	 */
	LineString.prototype.toJSON = function () {
	  return { type: 'LineString', coordinates: this.points.map(function (p) {
	    return [p.x, p.y];
	  })};
	};

	lineString = LineString;
	return lineString;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var polygon;
var hasRequiredPolygon;

function requirePolygon () {
	if (hasRequiredPolygon) return polygon;
	hasRequiredPolygon = 1;
	const util = require$$0$6;
	const utils = requireUtils$c();
	const Geometry = requireGeometry$1();
	const Point = requirePoint();
	const LineString = requireLineString();

	/**
	 * Creates a new {@link Polygon} instance.
	 * @classdesc
	 * Represents is a plane geometry figure that is bounded by a finite chain of straight line segments closing in a loop
	 * to form a closed chain or circuit.
	 * @param {...Array.<Point>}[ringPoints] A sequence of Array of [Point]{@link module:geometry~Point} items as arguments
	 * representing the rings of the polygon.
	 * @example
	 * new Polygon([ new Point(30, 10), new Point(40, 40), new Point(10, 20), new Point(30, 10) ]);
	 * @example
	 * //polygon with a hole
	 * new Polygon(
	 *  [ new Point(30, 10), new Point(40, 40), new Point(10, 20), new Point(30, 10) ],
	 *  [ new Point(25, 20), new Point(30, 30), new Point(20, 20), new Point(25, 20) ]
	 * );
	 * @alias module:geometry~Polygon
	 * @constructor
	 */
	function Polygon(ringPoints) {
	  const rings = Array.prototype.slice.call(arguments);
	  /**
	   * Returns a frozen Array of array of points that represent the different rings in the polygon.
	   * @type {Array}
	   */
	  this.rings = Object.freeze(rings);
	}

	//noinspection JSCheckFunctionSignatures
	util.inherits(Polygon, Geometry);

	/**
	 * Creates a {@link Polygon} instance from
	 * a <a href="https://en.wikipedia.org/wiki/Well-known_text">Well-known Text (WKT)</a>
	 * representation of a polygon.
	 * @param {Buffer} buffer
	 * @returns {Polygon}
	 */
	Polygon.fromBuffer = function (buffer) {
	  if (!buffer || buffer.length < 9) {
	    throw new TypeError('A Polygon buffer should contain at least 9 bytes');
	  }
	  const endianness = Geometry.getEndianness(buffer.readInt8(0, true));
	  let offset = 1;
	  if (Geometry.readInt32(buffer, endianness, offset) !== Geometry.types.Polygon) {
	    throw new TypeError('Binary representation was not a Polygon');
	  }
	  offset += 4;
	  const ringsLength = Geometry.readInt32(buffer, endianness, offset);
	  offset += 4;
	  const ringsArray = new Array(ringsLength);
	  for (let ringIndex = 0; ringIndex < ringsLength; ringIndex++) {
	    const pointsLength = Geometry.readInt32(buffer, endianness, offset);
	    offset += 4;
	    if (buffer.length < offset + pointsLength * 16) {
	      throw new TypeError(util.format('Length of the buffer does not match'));
	    }
	    const ring = new Array(pointsLength);
	    for (let i = 0; i < pointsLength; i++) {
	      ring[i] = new Point(
	        Geometry.readDouble(buffer, endianness, offset),
	        Geometry.readDouble(buffer, endianness, offset + 8));
	      offset += 16;
	    }
	    ringsArray[ringIndex] = ring;
	  }
	  //Invoke the constructor with each ring as a parameter
	  //ringsArray.unshift(null);
	  //return new (Function.prototype.bind.apply(Polygon, ringsArray));
	  return construct(ringsArray);
	};

	/**
	 * Creates a {@link Polygon} instance from
	 * a <a href="https://en.wikipedia.org/wiki/Well-known_text">Well-known Text (WKT)</a>
	 * representation of a shape.
	 * @param {String} textValue
	 * @returns {Polygon}
	 */
	Polygon.fromString = function (textValue) {
	  const wktRegex = /^POLYGON ?\((\(.*\))\)$/g;
	  const matches = wktRegex.exec(textValue);
	  function validateWkt(condition) {
	    if (condition) {
	      throw new TypeError('Invalid WKT: ' + textValue);
	    }
	  }
	  validateWkt(!matches || matches.length !== 2);

	  const ringsText = matches[1];
	  const ringsArray = [];
	  let ringStart = null;
	  for (let i = 0; i < ringsText.length; i++) {
	    const c = ringsText[i];
	    if (c === '(') {
	      validateWkt(ringStart !== null);
	      ringStart = i+1;
	      continue;
	    }
	    if (c === ')') {
	      validateWkt(ringStart === null);
	      ringsArray.push(ringsText.substring(ringStart, i));
	      ringStart = null;
	      continue;
	    }
	    validateWkt(ringStart === null && c !== ' ' && c !== ',');
	  }
	  return construct(ringsArray.map(LineString.parseSegments));
	};

	/**
	 * Creates a new instance of Polygon with each array item as a parameter
	 * @private
	 * @param {Array<Array<Point>>} argsArray
	 * @returns {Polygon}
	 */
	function construct(argsArray) {
	  function F() {
	    return Polygon.apply(this, argsArray);
	  }
	  F.prototype = Polygon.prototype;
	  return new F();
	}

	/**
	 * Returns a <a href="https://en.wikipedia.org/wiki/Well-known_text#Well-known_binary">Well-known Binary</a> (WKB)
	 * representation of this instance.
	 * @returns {Buffer}
	 */
	Polygon.prototype.toBuffer = function () {
	  let totalRingsLength = 0;
	  this.rings.forEach(function (ring) {
	    totalRingsLength += 4 + ring.length * 16;
	  }, this);
	  const buffer = utils.allocBufferUnsafe(9 + totalRingsLength);
	  this.writeEndianness(buffer, 0);
	  let offset = 1;
	  this.writeInt32(Geometry.types.Polygon, buffer, offset);
	  offset += 4;
	  this.writeInt32(this.rings.length, buffer, offset);
	  offset += 4;
	  this.rings.forEach(function (ring) {
	    this.writeInt32(ring.length, buffer, offset);
	    offset += 4;
	    ring.forEach(function (p) {
	      this.writeDouble(p.x, buffer, offset);
	      this.writeDouble(p.y, buffer, offset + 8);
	      offset += 16;
	    }, this);
	  }, this);
	  return buffer;
	};

	/**
	 * Returns true if the values of the polygons are the same, otherwise it returns false.
	 * @param {Polygon} other
	 * @returns {Boolean}
	 */
	Polygon.prototype.equals = function (other) {
	  if (!(other instanceof Polygon)) {
	    return false;
	  }
	  if (this.rings.length !== other.rings.length) {
	    return false;
	  }
	  for (let i = 0; i < this.rings.length; i++) {
	    const r1 = this.rings[i];
	    const r2 = other.rings[i];
	    if (r1.length !== r2.length) {
	      return false;
	    }
	    for (let j = 0; j < r1.length; j++) {
	      if (!r1[i].equals(r2[i])) {
	        return false;
	      }
	    }
	  }
	  return true;
	};

	Polygon.prototype.useBESerialization = function () {
	  return false;
	};

	/**
	 * Returns Well-known text (WKT) representation of the geometry object.
	 * @returns {String}
	 */
	Polygon.prototype.toString = function () {
	  if (this.rings.length === 0) {
	    return 'POLYGON EMPTY';
	  }
	  let ringStrings = '';
	  this.rings.forEach(function (r, i) {
	    if (i > 0) {
	      ringStrings += ', ';
	    }
	    ringStrings += '(' +
	      r.map(function (p) {
	        return p.x + ' ' + p.y;
	      }).join(', ')
	      + ')';
	  });
	  return 'POLYGON (' + ringStrings + ')';
	};

	/**
	 * Returns a JSON representation of this geo-spatial type.
	 */
	Polygon.prototype.toJSON = function () {
	  return { type: 'Polygon', coordinates: this.rings.map(function (r) {
	    return r.map(function (p) {
	      return [ p.x, p.y ];
	    });
	  })};
	};

	polygon = Polygon;
	return polygon;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredGeometry;

function requireGeometry () {
	if (hasRequiredGeometry) return geometry$1;
	hasRequiredGeometry = 1;

	/**
	 * Geometry module.
	 * <p>
	 *   Contains the classes to represent the set of additional CQL types for geospatial data that come with
	 *   DSE 5.0.
	 * </p>
	 * @module geometry
	 */

	geometry$1.Geometry = requireGeometry$1();
	geometry$1.LineString = requireLineString();
	geometry$1.Point = requirePoint();
	geometry$1.Polygon = requirePolygon();
	return geometry$1;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var encoder$1;
var hasRequiredEncoder$1;

function requireEncoder$1 () {
	if (hasRequiredEncoder$1) return encoder$1;
	hasRequiredEncoder$1 = 1;
	const util = require$$0$6;

	const types = requireTypes$2();
	const dataTypes = types.dataTypes;
	const Long = types.Long;
	const Integer = types.Integer;
	const BigDecimal = types.BigDecimal;
	const MutableLong = requireMutableLong();
	const utils = requireUtils$c();
	const token = requireToken$1();
	const { DateRange } = requireSearch$1();
	const geo = requireGeometry();
	const Geometry = geo.Geometry;
	const LineString = geo.LineString;
	const Point = geo.Point;
	const Polygon = geo.Polygon;

	const uuidRegex = /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;

	const buffers = {
	  int16Zero: utils.allocBufferFromArray([0, 0]),
	  int32Zero: utils.allocBufferFromArray([0, 0, 0, 0]),
	  int8Zero: utils.allocBufferFromArray([0]),
	  int8One: utils.allocBufferFromArray([1]),
	  int8MaxValue: utils.allocBufferFromArray([0xff])
	};

	// BigInt: Avoid using literals (e.g., 32n) as we must be able to compile with older engines
	const isBigIntSupported = typeof BigInt !== 'undefined';
	const bigInt32 = isBigIntSupported ? BigInt(32) : null;
	const bigInt8 = isBigIntSupported ? BigInt(8) : null;
	const bigInt0 = isBigIntSupported ? BigInt(0) : null;
	const bigIntMinus1 = isBigIntSupported ? BigInt(-1) : null;
	const bigInt32BitsOn = isBigIntSupported ? BigInt(0xffffffff) : null;
	const bigInt8BitsOn = isBigIntSupported ? BigInt(0xff) : null;

	const complexTypeNames = Object.freeze({
	  list      : 'org.apache.cassandra.db.marshal.ListType',
	  set       : 'org.apache.cassandra.db.marshal.SetType',
	  map       : 'org.apache.cassandra.db.marshal.MapType',
	  udt       : 'org.apache.cassandra.db.marshal.UserType',
	  tuple     : 'org.apache.cassandra.db.marshal.TupleType',
	  frozen    : 'org.apache.cassandra.db.marshal.FrozenType',
	  reversed  : 'org.apache.cassandra.db.marshal.ReversedType',
	  composite : 'org.apache.cassandra.db.marshal.CompositeType',
	  empty     : 'org.apache.cassandra.db.marshal.EmptyType',
	  collection: 'org.apache.cassandra.db.marshal.ColumnToCollectionType'
	});
	const cqlNames = Object.freeze({
	  frozen: 'frozen',
	  list: 'list',
	  'set': 'set',
	  map: 'map',
	  tuple: 'tuple',
	  empty: 'empty',
	  duration: 'duration',
	  vector: 'vector'
	});
	const singleTypeNames = Object.freeze({
	  'org.apache.cassandra.db.marshal.UTF8Type':           dataTypes.varchar,
	  'org.apache.cassandra.db.marshal.AsciiType':          dataTypes.ascii,
	  'org.apache.cassandra.db.marshal.UUIDType':           dataTypes.uuid,
	  'org.apache.cassandra.db.marshal.TimeUUIDType':       dataTypes.timeuuid,
	  'org.apache.cassandra.db.marshal.Int32Type':          dataTypes.int,
	  'org.apache.cassandra.db.marshal.BytesType':          dataTypes.blob,
	  'org.apache.cassandra.db.marshal.FloatType':          dataTypes.float,
	  'org.apache.cassandra.db.marshal.DoubleType':         dataTypes.double,
	  'org.apache.cassandra.db.marshal.BooleanType':        dataTypes.boolean,
	  'org.apache.cassandra.db.marshal.InetAddressType':    dataTypes.inet,
	  'org.apache.cassandra.db.marshal.SimpleDateType':     dataTypes.date,
	  'org.apache.cassandra.db.marshal.TimeType':           dataTypes.time,
	  'org.apache.cassandra.db.marshal.ShortType':          dataTypes.smallint,
	  'org.apache.cassandra.db.marshal.ByteType':           dataTypes.tinyint,
	  'org.apache.cassandra.db.marshal.DateType':           dataTypes.timestamp,
	  'org.apache.cassandra.db.marshal.TimestampType':      dataTypes.timestamp,
	  'org.apache.cassandra.db.marshal.LongType':           dataTypes.bigint,
	  'org.apache.cassandra.db.marshal.DecimalType':        dataTypes.decimal,
	  'org.apache.cassandra.db.marshal.IntegerType':        dataTypes.varint,
	  'org.apache.cassandra.db.marshal.CounterColumnType':  dataTypes.counter
	});
	const singleTypeNamesByDataType = invertObject(singleTypeNames);
	const singleFqTypeNamesLength = Object.keys(singleTypeNames).reduce(function (previous, current) {
	  return current.length > previous ? current.length : previous;
	}, 0);

	const customTypeNames = Object.freeze({
	  duration: 'org.apache.cassandra.db.marshal.DurationType',
	  lineString: 'org.apache.cassandra.db.marshal.LineStringType',
	  point: 'org.apache.cassandra.db.marshal.PointType',
	  polygon: 'org.apache.cassandra.db.marshal.PolygonType',
	  dateRange: 'org.apache.cassandra.db.marshal.DateRangeType',
	  vector: 'org.apache.cassandra.db.marshal.VectorType'
	});

	const nullValueBuffer = utils.allocBufferFromArray([255, 255, 255, 255]);
	const unsetValueBuffer = utils.allocBufferFromArray([255, 255, 255, 254]);

	/**
	 * For backwards compatibility, empty buffers as text/blob/custom values are supported.
	 * In the case of other types, they are going to be decoded as a <code>null</code> value.
	 * @private
	 * @type {Set}
	 */
	const zeroLengthTypesSupported = new Set([
	  dataTypes.text,
	  dataTypes.ascii,
	  dataTypes.varchar,
	  dataTypes.custom,
	  dataTypes.blob
	]);

	/**
	 * Serializes and deserializes to and from a CQL type and a Javascript Type.
	 * @param {Number} protocolVersion
	 * @param {ClientOptions} options
	 * @constructor
	 */
	function Encoder(protocolVersion, options) {
	  this.encodingOptions = options.encoding || utils.emptyObject;
	  defineInstanceMembers.call(this);
	  this.setProtocolVersion(protocolVersion);
	  setEncoders.call(this);
	  if (this.encodingOptions.copyBuffer) {
	    this.handleBuffer = handleBufferCopy;
	  }
	  else {
	    this.handleBuffer = handleBufferRef;
	  }
	}

	/**
	 * Declares the privileged instance members.
	 * @private
	 */
	function defineInstanceMembers() {
	  /**
	   * Sets the protocol version and the encoding/decoding methods depending on the protocol version
	   * @param {Number} value
	   * @ignore
	   * @internal
	   */
	  this.setProtocolVersion = function (value) {
	    this.protocolVersion = value;
	    //Set the collection serialization based on the protocol version
	    this.decodeCollectionLength = decodeCollectionLengthV3;
	    this.getLengthBuffer = getLengthBufferV3;
	    this.collectionLengthSize = 4;
	    if (!types.protocolVersion.uses4BytesCollectionLength(this.protocolVersion)) {
	      this.decodeCollectionLength = decodeCollectionLengthV2;
	      this.getLengthBuffer = getLengthBufferV2;
	      this.collectionLengthSize = 2;
	    }
	  };

	  const customDecoders = {
	    [customTypeNames.duration]: decodeDuration,
	    [customTypeNames.lineString]: decodeLineString,
	    [customTypeNames.point]: decodePoint,
	    [customTypeNames.polygon]: decodePolygon,
	    [customTypeNames.dateRange]: decodeDateRange
	  };

	  const customEncoders = {
	    [customTypeNames.duration]: encodeDuration,
	    [customTypeNames.lineString]: encodeLineString,
	    [customTypeNames.point]: encodePoint,
	    [customTypeNames.polygon]: encodePolygon,
	    [customTypeNames.dateRange]: encodeDateRange
	  };

	  // Decoding methods
	  this.decodeBlob = function (bytes) {
	    return this.handleBuffer(bytes);
	  };
	  this.decodeCustom = function (bytes, typeName) {

	    // Make sure we actually have something to process in typeName before we go any further
	    if (!typeName || typeName.length === 0) {
	      return this.handleBuffer(bytes);
	    }

	    // Special handling for vector custom types (since they have args)
	    if (typeName.startsWith(customTypeNames.vector)) {
	      return this.decodeVector(bytes, this.parseVectorTypeArgs(typeName, customTypeNames.vector, this.parseFqTypeName));
	    }
	    const handler = customDecoders[typeName];
	    if (handler) {
	      return handler.call(this, bytes);
	    }
	    return this.handleBuffer(bytes);
	  };
	  this.decodeUtf8String = function (bytes) {
	    return bytes.toString('utf8');
	  };
	  this.decodeAsciiString = function (bytes) {
	    return bytes.toString('ascii');
	  };
	  this.decodeBoolean = function (bytes) {
	    return !!bytes.readUInt8(0);
	  };
	  this.decodeDouble = function (bytes) {
	    return bytes.readDoubleBE(0);
	  };
	  this.decodeFloat = function (bytes) {
	    return bytes.readFloatBE(0);
	  };
	  this.decodeInt = function (bytes) {
	    return bytes.readInt32BE(0);
	  };
	  this.decodeSmallint = function (bytes) {
	    return bytes.readInt16BE(0);
	  };
	  this.decodeTinyint = function (bytes) {
	    return bytes.readInt8(0);
	  };

	  this._decodeCqlLongAsLong = function (bytes) {
	    return Long.fromBuffer(bytes);
	  };

	  this._decodeCqlLongAsBigInt = function (bytes) {
	    return BigInt.asIntN(64, (BigInt(bytes.readUInt32BE(0)) << bigInt32) | BigInt(bytes.readUInt32BE(4)));
	  };

	  this.decodeLong = this.encodingOptions.useBigIntAsLong
	    ? this._decodeCqlLongAsBigInt
	    : this._decodeCqlLongAsLong;

	  this._decodeVarintAsInteger = function (bytes) {
	    return Integer.fromBuffer(bytes);
	  };

	  this._decodeVarintAsBigInt = function decodeVarintAsBigInt(bytes) {
	    let result = bigInt0;
	    if (bytes[0] <= 0x7f) {
	      for (let i = 0; i < bytes.length; i++) {
	        const b = BigInt(bytes[bytes.length - 1 - i]);
	        result = result | (b << BigInt(i * 8));
	      }
	    } else {
	      for (let i = 0; i < bytes.length; i++) {
	        const b = BigInt(bytes[bytes.length - 1 - i]);
	        result = result | ((~b & bigInt8BitsOn) << BigInt(i * 8));
	      }
	      result = ~result;
	    }

	    return result;
	  };

	  this.decodeVarint = this.encodingOptions.useBigIntAsVarint
	    ? this._decodeVarintAsBigInt
	    : this._decodeVarintAsInteger;

	  this.decodeDecimal = function(bytes) {
	    return BigDecimal.fromBuffer(bytes);
	  };
	  this.decodeTimestamp = function(bytes) {
	    return new Date(this._decodeCqlLongAsLong(bytes).toNumber());
	  };
	  this.decodeDate = function (bytes) {
	    return types.LocalDate.fromBuffer(bytes);
	  };
	  this.decodeTime = function (bytes) {
	    return types.LocalTime.fromBuffer(bytes);
	  };
	  /*
	   * Reads a list from bytes
	   */
	  this.decodeList = function (bytes, subtype) {
	    const totalItems = this.decodeCollectionLength(bytes, 0);
	    let offset = this.collectionLengthSize;
	    const list = new Array(totalItems);
	    for (let i = 0; i < totalItems; i++) {
	      //bytes length of the item
	      const length = this.decodeCollectionLength(bytes, offset);
	      offset += this.collectionLengthSize;
	      //slice it
	      list[i] = this.decode(bytes.slice(offset, offset+length), subtype);
	      offset += length;
	    }
	    return list;
	  };
	  /*
	   * Reads a Set from bytes
	   */
	  this.decodeSet = function (bytes, subtype) {
	    const arr = this.decodeList(bytes, subtype);
	    if (this.encodingOptions.set) {
	      const setConstructor = this.encodingOptions.set;
	      return new setConstructor(arr);
	    }
	    return arr;
	  };
	  /*
	   * Reads a map (key / value) from bytes
	   */
	  this.decodeMap = function (bytes, subtypes) {
	    let map;
	    const totalItems = this.decodeCollectionLength(bytes, 0);
	    let offset = this.collectionLengthSize;
	    const self = this;
	    function readValues(callback, thisArg) {
	      for (let i = 0; i < totalItems; i++) {
	        const keyLength = self.decodeCollectionLength(bytes, offset);
	        offset += self.collectionLengthSize;
	        const key = self.decode(bytes.slice(offset, offset + keyLength), subtypes[0]);
	        offset += keyLength;
	        const valueLength = self.decodeCollectionLength(bytes, offset);
	        offset += self.collectionLengthSize;
	        if (valueLength < 0) {
	          callback.call(thisArg, key, null);
	          continue;
	        }
	        const value = self.decode(bytes.slice(offset, offset + valueLength), subtypes[1]);
	        offset += valueLength;
	        callback.call(thisArg, key, value);
	      }
	    }
	    if (this.encodingOptions.map) {
	      const mapConstructor = this.encodingOptions.map;
	      map = new mapConstructor();
	      readValues(map.set, map);
	    }
	    else {
	      map = {};
	      readValues(function (key, value) {
	        map[key] = value;
	      });
	    }
	    return map;
	  };
	  this.decodeUuid = function (bytes) {
	    return new types.Uuid(this.handleBuffer(bytes));
	  };
	  this.decodeTimeUuid = function (bytes) {
	    return new types.TimeUuid(this.handleBuffer(bytes));
	  };
	  this.decodeInet = function (bytes) {
	    return new types.InetAddress(this.handleBuffer(bytes));
	  };
	  /**
	   * Decodes a user defined type into an object
	   * @param {Buffer} bytes
	   * @param {{fields: Array}} udtInfo
	   * @private
	   */
	  this.decodeUdt = function (bytes, udtInfo) {
	    const result = {};
	    let offset = 0;
	    for (let i = 0; i < udtInfo.fields.length && offset < bytes.length; i++) {
	      //bytes length of the field value
	      const length = bytes.readInt32BE(offset);
	      offset += 4;
	      //slice it
	      const field = udtInfo.fields[i];
	      if (length < 0) {
	        result[field.name] = null;
	        continue;
	      }
	      result[field.name] = this.decode(bytes.slice(offset, offset+length), field.type);
	      offset += length;
	    }
	    return result;
	  };

	  this.decodeTuple = function (bytes, tupleInfo) {
	    const elements = new Array(tupleInfo.length);
	    let offset = 0;

	    for (let i = 0; i < tupleInfo.length && offset < bytes.length; i++) {
	      const length = bytes.readInt32BE(offset);
	      offset += 4;

	      if (length < 0) {
	        elements[i] = null;
	        continue;
	      }

	      elements[i] = this.decode(bytes.slice(offset, offset+length), tupleInfo[i]);
	      offset += length;
	    }

	    return types.Tuple.fromArray(elements);
	  };

	  //Encoding methods
	  this.encodeFloat = function (value) {
	    if (typeof value === 'string') {
	      // All numeric types are supported as strings for historical reasons
	      value = parseFloat(value);

	      if (Number.isNaN(value)) {
	        throw new TypeError(`Expected string representation of a number, obtained ${util.inspect(value)}`);
	      }
	    }

	    if (typeof value !== 'number') {
	      throw new TypeError('Expected Number, obtained ' + util.inspect(value));
	    }

	    const buf = utils.allocBufferUnsafe(4);
	    buf.writeFloatBE(value, 0);
	    return buf;
	  };

	  this.encodeDouble = function (value) {
	    if (typeof value === 'string') {
	      // All numeric types are supported as strings for historical reasons
	      value = parseFloat(value);

	      if (Number.isNaN(value)) {
	        throw new TypeError(`Expected string representation of a number, obtained ${util.inspect(value)}`);
	      }
	    }

	    if (typeof value !== 'number') {
	      throw new TypeError('Expected Number, obtained ' + util.inspect(value));
	    }

	    const buf = utils.allocBufferUnsafe(8);
	    buf.writeDoubleBE(value, 0);
	    return buf;
	  };

	  /**
	   * @param {Date|String|Long|Number} value
	   * @private
	   */
	  this.encodeTimestamp = function (value) {
	    const originalValue = value;
	    if (typeof value === 'string') {
	      value = new Date(value);
	    }
	    if (value instanceof Date) {
	      //milliseconds since epoch
	      value = value.getTime();
	      if (isNaN(value)) {
	        throw new TypeError('Invalid date: ' + originalValue);
	      }
	    }
	    if (this.encodingOptions.useBigIntAsLong) {
	      value = BigInt(value);
	    }
	    return this.encodeLong(value);
	  };
	  /**
	   * @param {Date|String|LocalDate} value
	   * @returns {Buffer}
	   * @throws {TypeError}
	   * @private
	   */
	  this.encodeDate = function (value) {
	    const originalValue = value;
	    try {
	      if (typeof value === 'string') {
	        value = types.LocalDate.fromString(value);
	      }
	      if (value instanceof Date) {
	        value = types.LocalDate.fromDate(value);
	      }
	    }
	    catch (err) {
	      //Wrap into a TypeError
	      throw new TypeError('LocalDate could not be parsed ' + err);
	    }
	    if (!(value instanceof types.LocalDate)) {
	      throw new TypeError('Expected Date/String/LocalDate, obtained ' + util.inspect(originalValue));
	    }
	    return value.toBuffer();
	  };
	  /**
	   * @param {String|LocalDate} value
	   * @returns {Buffer}
	   * @throws {TypeError}
	   * @private
	   */
	  this.encodeTime = function (value) {
	    const originalValue = value;
	    try {
	      if (typeof value === 'string') {
	        value = types.LocalTime.fromString(value);
	      }
	    }
	    catch (err) {
	      //Wrap into a TypeError
	      throw new TypeError('LocalTime could not be parsed ' + err);
	    }
	    if (!(value instanceof types.LocalTime)) {
	      throw new TypeError('Expected String/LocalTime, obtained ' + util.inspect(originalValue));
	    }
	    return value.toBuffer();
	  };
	  /**
	   * @param {Uuid|String|Buffer} value
	   * @private
	   */
	  this.encodeUuid = function (value) {
	    if (typeof value === 'string') {
	      try {
	        value = types.Uuid.fromString(value).getBuffer();
	      }
	      catch (err) {
	        throw new TypeError(err.message);
	      }
	    } else if (value instanceof types.Uuid) {
	      value = value.getBuffer();
	    } else {
	      throw new TypeError('Not a valid Uuid, expected Uuid/String/Buffer, obtained ' + util.inspect(value));
	    }

	    return value;
	  };
	  /**
	   * @param {String|InetAddress|Buffer} value
	   * @returns {Buffer}
	   * @private
	   */
	  this.encodeInet = function (value) {
	    if (typeof value === 'string') {
	      value = types.InetAddress.fromString(value);
	    }
	    if (value instanceof types.InetAddress) {
	      value = value.getBuffer();
	    }
	    if (!(value instanceof Buffer)) {
	      throw new TypeError('Not a valid Inet, expected InetAddress/Buffer, obtained ' + util.inspect(value));
	    }
	    return value;
	  };

	  /**
	   * @param {Long|Buffer|String|Number} value
	   * @private
	   */
	  this._encodeBigIntFromLong = function (value) {
	    if (typeof value === 'number') {
	      value = Long.fromNumber(value);
	    } else if (typeof value === 'string') {
	      value = Long.fromString(value);
	    }

	    let buf = null;

	    if (value instanceof Long) {
	      buf = Long.toBuffer(value);
	    } else if (value instanceof MutableLong) {
	      buf = Long.toBuffer(value.toImmutable());
	    }

	    if (buf === null) {
	      throw new TypeError('Not a valid bigint, expected Long/Number/String/Buffer, obtained ' + util.inspect(value));
	    }

	    return buf;
	  };

	  this._encodeBigIntFromBigInt = function (value) {
	    if (typeof value === 'string') {
	      // All numeric types are supported as strings for historical reasons
	      value = BigInt(value);
	    }

	    // eslint-disable-next-line valid-typeof
	    if (typeof value !== 'bigint') {
	      // Only BigInt values are supported
	      throw new TypeError('Not a valid BigInt value, obtained ' + util.inspect(value));
	    }

	    const buffer = utils.allocBufferUnsafe(8);
	    buffer.writeUInt32BE(Number(value >> bigInt32) >>> 0, 0);
	    buffer.writeUInt32BE(Number(value & bigInt32BitsOn), 4);
	    return buffer;
	  };

	  this.encodeLong = this.encodingOptions.useBigIntAsLong
	    ? this._encodeBigIntFromBigInt
	    : this._encodeBigIntFromLong;

	  /**
	   * @param {Integer|Buffer|String|Number} value
	   * @returns {Buffer}
	   * @private
	   */
	  this._encodeVarintFromInteger = function (value) {
	    if (typeof value === 'number') {
	      value = Integer.fromNumber(value);
	    }
	    if (typeof value === 'string') {
	      value = Integer.fromString(value);
	    }
	    let buf = null;
	    if (value instanceof Buffer) {
	      buf = value;
	    }
	    if (value instanceof Integer) {
	      buf = Integer.toBuffer(value);
	    }
	    if (buf === null) {
	      throw new TypeError('Not a valid varint, expected Integer/Number/String/Buffer, obtained ' + util.inspect(value));
	    }
	    return buf;
	  };

	  this._encodeVarintFromBigInt = function (value) {
	    if (typeof value === 'string') {
	      // All numeric types are supported as strings for historical reasons
	      value = BigInt(value);
	    }

	    // eslint-disable-next-line valid-typeof
	    if (typeof value !== 'bigint') {
	      throw new TypeError('Not a valid varint, expected BigInt, obtained ' + util.inspect(value));
	    }

	    if (value === bigInt0) {
	      return buffers.int8Zero;

	    }
	    else if (value === bigIntMinus1) {
	      return buffers.int8MaxValue;
	    }

	    const parts = [];

	    if (value > bigInt0){
	      while (value !== bigInt0) {
	        parts.unshift(Number(value & bigInt8BitsOn));
	        value = value >> bigInt8;
	      }

	      if (parts[0] > 0x7f) {
	        // Positive value needs a padding
	        parts.unshift(0);
	      }
	    } else {
	      while (value !== bigIntMinus1) {
	        parts.unshift(Number(value & bigInt8BitsOn));
	        value = value >> bigInt8;
	      }

	      if (parts[0] <= 0x7f) {
	        // Negative value needs a padding
	        parts.unshift(0xff);
	      }
	    }

	    return utils.allocBufferFromArray(parts);
	  };

	  this.encodeVarint = this.encodingOptions.useBigIntAsVarint
	    ? this._encodeVarintFromBigInt
	    : this._encodeVarintFromInteger;

	  /**
	   * @param {BigDecimal|Buffer|String|Number} value
	   * @returns {Buffer}
	   * @private
	   */
	  this.encodeDecimal = function (value) {
	    if (typeof value === 'number') {
	      value = BigDecimal.fromNumber(value);
	    } else if (typeof value === 'string') {
	      value = BigDecimal.fromString(value);
	    }

	    let buf = null;

	    if (value instanceof BigDecimal) {
	      buf = BigDecimal.toBuffer(value);
	    } else {
	      throw new TypeError('Not a valid varint, expected BigDecimal/Number/String/Buffer, obtained ' + util.inspect(value));
	    }

	    return buf;
	  };
	  this.encodeString = function (value, encoding) {
	    if (typeof value !== 'string') {
	      throw new TypeError('Not a valid text value, expected String obtained ' + util.inspect(value));
	    }
	    return utils.allocBufferFromString(value, encoding);
	  };
	  this.encodeUtf8String = function (value) {
	    return this.encodeString(value, 'utf8');
	  };
	  this.encodeAsciiString = function (value) {
	    return this.encodeString(value, 'ascii');
	  };
	  this.encodeBlob = function (value) {
	    if (!(value instanceof Buffer)) {
	      throw new TypeError('Not a valid blob, expected Buffer obtained ' + util.inspect(value));
	    }
	    return value;
	  };
	  this.encodeCustom = function (value, customTypeName) {

	    // Special handling for vector custom types (since they have args)
	    if (customTypeName.startsWith(customTypeNames.vector)) {
	      return this.encodeVector(value, this.parseVectorTypeArgs(customTypeName, customTypeNames.vector, this.parseFqTypeName));
	    }
	    const handler = customEncoders[customTypeName];
	    if (handler) {
	      return handler.call(this, value);
	    }
	    throw new TypeError('No encoding handler found for type ' + customTypeName);
	  };
	  /**
	   * @param {Boolean} value
	   * @returns {Buffer}
	   * @private
	   */
	  this.encodeBoolean = function (value) {
	    return value ? buffers.int8One : buffers.int8Zero;
	  };
	  /**
	   * @param {Number|String} value
	   * @private
	   */
	  this.encodeInt = function (value) {
	    if (isNaN(value)) {
	      throw new TypeError('Expected Number, obtained ' + util.inspect(value));
	    }
	    const buf = utils.allocBufferUnsafe(4);
	    buf.writeInt32BE(value, 0);
	    return buf;
	  };
	  /**
	   * @param {Number|String} value
	   * @private
	   */
	  this.encodeSmallint = function (value) {
	    if (isNaN(value)) {
	      throw new TypeError('Expected Number, obtained ' + util.inspect(value));
	    }
	    const buf = utils.allocBufferUnsafe(2);
	    buf.writeInt16BE(value, 0);
	    return buf;
	  };
	  /**
	   * @param {Number|String} value
	   * @private
	   */
	  this.encodeTinyint = function (value) {
	    if (isNaN(value)) {
	      throw new TypeError('Expected Number, obtained ' + util.inspect(value));
	    }
	    const buf = utils.allocBufferUnsafe(1);
	    buf.writeInt8(value, 0);
	    return buf;
	  };
	  this.encodeList = function (value, subtype) {
	    if (!Array.isArray(value)) {
	      throw new TypeError('Not a valid list value, expected Array obtained ' + util.inspect(value));
	    }
	    if (value.length === 0) {
	      return null;
	    }
	    const parts = [];
	    parts.push(this.getLengthBuffer(value));
	    for (let i = 0;i < value.length;i++) {
	      const val = value[i];
	      if (val === null || typeof val === 'undefined' || val === types.unset) {
	        throw new TypeError('A collection can\'t contain null or unset values');
	      }
	      const bytes = this.encode(val, subtype);
	      //include item byte length
	      parts.push(this.getLengthBuffer(bytes));
	      //include item
	      parts.push(bytes);
	    }
	    return Buffer.concat(parts);
	  };
	  this.encodeSet = function (value, subtype) {
	    if (this.encodingOptions.set && value instanceof this.encodingOptions.set) {
	      const arr = [];
	      value.forEach(function (x) {
	        arr.push(x);
	      });
	      return this.encodeList(arr, subtype);
	    }
	    return this.encodeList(value, subtype);
	  };
	  /**
	   * Serializes a map into a Buffer
	   * @param value
	   * @param {Array} [subtypes]
	   * @returns {Buffer}
	   * @private
	   */
	  this.encodeMap = function (value, subtypes) {
	    const parts = [];
	    let propCounter = 0;
	    let keySubtype = null;
	    let valueSubtype = null;
	    const self = this;
	    if (subtypes) {
	      keySubtype = subtypes[0];
	      valueSubtype = subtypes[1];
	    }
	    function addItem(val, key) {
	      if (key === null || typeof key === 'undefined' || key === types.unset) {
	        throw new TypeError('A map can\'t contain null or unset keys');
	      }
	      if (val === null || typeof val === 'undefined' || val === types.unset) {
	        throw new TypeError('A map can\'t contain null or unset values');
	      }
	      const keyBuffer = self.encode(key, keySubtype);
	      //include item byte length
	      parts.push(self.getLengthBuffer(keyBuffer));
	      //include item
	      parts.push(keyBuffer);
	      //value
	      const valueBuffer = self.encode(val, valueSubtype);
	      //include item byte length
	      parts.push(self.getLengthBuffer(valueBuffer));
	      //include item
	      if (valueBuffer !== null) {
	        parts.push(valueBuffer);
	      }
	      propCounter++;
	    }
	    if (this.encodingOptions.map && value instanceof this.encodingOptions.map) {
	      //Use Map#forEach() method to iterate
	      value.forEach(addItem);
	    }
	    else {
	      //Use object
	      for (const key in value) {
	        if (!value.hasOwnProperty(key)) {
	          continue;
	        }
	        const val = value[key];
	        addItem(val, key);
	      }
	    }

	    parts.unshift(this.getLengthBuffer(propCounter));
	    return Buffer.concat(parts);
	  };
	  this.encodeUdt = function (value, udtInfo) {
	    const parts = [];
	    let totalLength = 0;
	    for (let i = 0; i < udtInfo.fields.length; i++) {
	      const field = udtInfo.fields[i];
	      const item = this.encode(value[field.name], field.type);
	      if (!item) {
	        parts.push(nullValueBuffer);
	        totalLength += 4;
	        continue;
	      }
	      if (item === types.unset) {
	        parts.push(unsetValueBuffer);
	        totalLength += 4;
	        continue;
	      }
	      const lengthBuffer = utils.allocBufferUnsafe(4);
	      lengthBuffer.writeInt32BE(item.length, 0);
	      parts.push(lengthBuffer);
	      parts.push(item);
	      totalLength += item.length + 4;
	    }
	    return Buffer.concat(parts, totalLength);
	  };
	  this.encodeTuple = function (value, tupleInfo) {
	    const parts = [];
	    let totalLength = 0;
	    const length = Math.min(tupleInfo.length, value.length);

	    for (let i = 0; i < length; i++) {
	      const type = tupleInfo[i];
	      const item = this.encode(value.get(i), type);

	      if (!item) {
	        parts.push(nullValueBuffer);
	        totalLength += 4;
	        continue;
	      }

	      if (item === types.unset) {
	        parts.push(unsetValueBuffer);
	        totalLength += 4;
	        continue;
	      }

	      const lengthBuffer = utils.allocBufferUnsafe(4);
	      lengthBuffer.writeInt32BE(item.length, 0);
	      parts.push(lengthBuffer);
	      parts.push(item);
	      totalLength += item.length + 4;
	    }

	    return Buffer.concat(parts, totalLength);
	  };

	  this.decodeVector = function(buffer, params) {
	    const subtype = params["subtype"];
	    const dimensions = params["dimensions"];
	    const elemLength = 4; // TODO: figure this out based on the subtype
	    const expectedLength = buffer.length / elemLength;
	    if ((elemLength * dimensions) !== buffer.length) {
	      throw new TypeError(`Expected buffer of subtype ${subtype} with dimensions ${dimensions} to be of size ${expectedLength}, observed size ${buffer.length}`);
	    }
	    const rv = [];
	    let offset = 0;
	    for (let i = 0; i < dimensions; i++) {
	      offset = i * elemLength;
	      rv[i] = this.decode(buffer.slice(offset, offset + elemLength), subtype);
	    }
	    return new Float32Array(rv);
	  };

	  /**
	   * @param {CqlVector} value
	   * @param {Object} params
	   */
	  this.encodeVector = function(value, params) {

	    // Evaluate params to encodeVector(), returning the computed subtype
	    function evalParams() {

	      if (!(value instanceof Float32Array)) {
	        throw new TypeError("Driver only supports vectors of 4 byte floating point values");
	      }

	      // Perform client-side validation iff we were actually supplied with meaningful type info.  In practice
	      // this will only occur when using prepared statements.
	      if (params.hasOwnProperty("subtype") && params.hasOwnProperty("dimensions")) {

	        const subtype = params["subtype"];
	        const dimensions = params["dimensions"];
	        if (value.length !== dimensions) {
	          throw new TypeError(`Expected vector with ${dimensions} dimensions, observed size of ${value.length}`);
	        }
	        if (subtype.code !== dataTypes.float) {
	          throw new TypeError("Driver only supports vectors of 4 byte floating point values");
	        }
	        return subtype;
	      }

	      return { code: dataTypes.float };
	    }

	    if (!Encoder.isTypedArray(value)) {
	      throw new TypeError('Expected TypedArray subclass, obtained ' + util.inspect(value));
	    }
	    if (value.length === 0) {
	      throw new TypeError("Cannot encode empty array as vector");
	    }

	    const subtype = evalParams();

	    // TypedArrays are _not_ JS arrays so explicitly convert them here before trying to write them
	    // into a buffer
	    const elems = [];
	    for (const elem of value) {
	      elems.push(this.encode(elem, subtype));
	    }
	    return Buffer.concat(elems);
	  };

	  /**
	   * Extract the (typed) arguments from a vector type
	   *
	   * @param {String} typeName
	   * @param {String} stringToExclude Leading string indicating this is a vector type (to be excluded when eval'ing args)
	   * @param {Function} subtypeResolveFn Function used to resolve subtype type; varies depending on type naming convention
	   * @returns {Object}
	   * @internal
	   */
	  this.parseVectorTypeArgs = function(typeName, stringToExclude, subtypeResolveFn) {

	    const argsStartIndex = stringToExclude.length + 1;
	    const argsLength = typeName.length - (stringToExclude.length + 2);
	    const params = parseParams(typeName, argsStartIndex, argsLength);
	    if (params.length === 2) {
	      return {subtype: subtypeResolveFn(params[0]), dimensions: parseInt(params[1], 10)};
	    }
	    throw new TypeError('Not a valid type ' + typeName);
	  };

	  /**
	   * If not provided, it uses the array of buffers or the parameters and hints to build the routingKey
	   * @param {Array} params
	   * @param {ExecutionOptions} execOptions
	   * @param [keys] parameter keys and positions in the params array
	   * @throws TypeError
	   * @internal
	   * @ignore
	   */
	  this.setRoutingKeyFromUser = function (params, execOptions, keys) {
	    let totalLength = 0;
	    const userRoutingKey = execOptions.getRoutingKey();
	    if (Array.isArray(userRoutingKey)) {
	      if (userRoutingKey.length === 1) {
	        execOptions.setRoutingKey(userRoutingKey[0]);
	        return;
	      }

	      // Its a composite routing key
	      totalLength = 0;
	      for (let i = 0; i < userRoutingKey.length; i++) {
	        const item = userRoutingKey[i];
	        if (!item) {
	          // Invalid routing key part provided by the user, clear the value
	          execOptions.setRoutingKey(null);
	          return;
	        }
	        totalLength += item.length + 3;
	      }

	      execOptions.setRoutingKey(concatRoutingKey(userRoutingKey, totalLength));
	      return;
	    }
	    // If routingKey is present, ensure it is a Buffer, Token, or TokenRange.  Otherwise throw an error.
	    if (userRoutingKey) {
	      if (userRoutingKey instanceof Buffer || userRoutingKey instanceof token.Token
	        || userRoutingKey instanceof token.TokenRange) {
	        return;
	      }

	      throw new TypeError(`Unexpected routingKey '${util.inspect(userRoutingKey)}' provided. ` +
	        `Expected Buffer, Array<Buffer>, Token, or TokenRange.`);
	    }

	    // If no params are present, return as routing key cannot be determined.
	    if (!params || params.length === 0) {
	      return;
	    }

	    let routingIndexes = execOptions.getRoutingIndexes();
	    if (execOptions.getRoutingNames()) {
	      routingIndexes = execOptions.getRoutingNames().map(k => keys[k]);
	    }
	    if (!routingIndexes) {
	      return;
	    }

	    const parts = [];
	    const hints = execOptions.getHints() || utils.emptyArray;

	    const encodeParam = !keys ?
	      (i => this.encode(params[i], hints[i])) :
	      (i => this.encode(params[i].value, hints[i]));

	    try {
	      totalLength = this._encodeRoutingKeyParts(parts, routingIndexes, encodeParam);
	    } catch (e) {
	      // There was an error encoding a parameter that is part of the routing key,
	      // ignore now to fail afterwards
	    }

	    if (totalLength === 0) {
	      return;
	    }

	    execOptions.setRoutingKey(concatRoutingKey(parts, totalLength));
	  };

	  /**
	   * Sets the routing key in the options based on the prepared statement metadata.
	   * @param {Object} meta Prepared metadata
	   * @param {Array} params Array of parameters
	   * @param {ExecutionOptions} execOptions
	   * @throws TypeError
	   * @internal
	   * @ignore
	   */
	  this.setRoutingKeyFromMeta = function (meta, params, execOptions) {
	    const routingIndexes = execOptions.getRoutingIndexes();
	    if (!routingIndexes) {
	      return;
	    }
	    const parts = new Array(routingIndexes.length);
	    const encodeParam = i => {
	      const columnInfo = meta.columns[i];
	      return this.encode(params[i], columnInfo ? columnInfo.type : null);
	    };

	    let totalLength = 0;

	    try {
	      totalLength = this._encodeRoutingKeyParts(parts, routingIndexes, encodeParam);
	    } catch (e) {
	      // There was an error encoding a parameter that is part of the routing key,
	      // ignore now to fail afterwards
	    }

	    if (totalLength === 0) {
	      return;
	    }

	    execOptions.setRoutingKey(concatRoutingKey(parts, totalLength));
	  };

	  /**
	   * @param {Array} parts
	   * @param {Array} routingIndexes
	   * @param {Function} encodeParam
	   * @returns {Number} The total length
	   * @private
	   */
	  this._encodeRoutingKeyParts = function (parts, routingIndexes, encodeParam) {
	    let totalLength = 0;
	    for (let i = 0; i < routingIndexes.length; i++) {
	      const paramIndex = routingIndexes[i];
	      if (paramIndex === undefined) {
	        // Bad input from the user, ignore
	        return 0;
	      }

	      const item = encodeParam(paramIndex);
	      if (item === null || item === undefined || item === types.unset) {
	        // The encoded partition key should an instance of Buffer
	        // Let it fail later in the pipeline for null/undefined parameter values
	        return 0;
	      }

	      // Per each part of the routing key, 3 extra bytes are needed
	      totalLength += item.length + 3;
	      parts[i] = item;
	    }
	    return totalLength;
	  };

	  /**
	   * Parses a CQL name string into data type information
	   * @param {String} keyspace
	   * @param {String} typeName
	   * @param {Number} startIndex
	   * @param {Number|null} length
	   * @param {Function} udtResolver
	   * @returns {Promise<{err, info, options}>} callback Callback invoked with err and  {{code: number, info: Object|Array|null, options: {frozen: Boolean}}}
	   * @internal
	   * @ignore
	   */
	  this.parseTypeName = async function (keyspace, typeName, startIndex, length, udtResolver) {
	    startIndex = startIndex || 0;
	    if (!length) {
	      length = typeName.length;
	    }

	    const dataType = {
	      code: 0,
	      info: null,
	      options: {
	        frozen: false
	      }
	    };

	    let innerTypes;

	    if (typeName.indexOf("'", startIndex) === startIndex) {
	      //If quoted, this is a custom type.
	      dataType.info = typeName.substr(startIndex+1, length-2);
	      return dataType;
	    }

	    if (!length) {
	      length = typeName.length;
	    }

	    if (typeName.indexOf(cqlNames.frozen, startIndex) === startIndex) {
	      //Remove the frozen token
	      startIndex += cqlNames.frozen.length + 1;
	      length -= cqlNames.frozen.length + 2;
	      dataType.options.frozen = true;
	    }

	    if (typeName.indexOf(cqlNames.list, startIndex) === startIndex) {
	      //move cursor across the name and bypass the angle brackets
	      startIndex += cqlNames.list.length + 1;
	      length -= cqlNames.list.length + 2;
	      innerTypes = parseParams(typeName, startIndex, length, '<', '>');

	      if (innerTypes.length !== 1) {
	        throw new TypeError('Not a valid type ' + typeName);
	      }

	      dataType.code = dataTypes.list;
	      dataType.info = await this.parseTypeName(keyspace, innerTypes[0], 0, null, udtResolver);
	      return dataType;
	    }

	    if (typeName.indexOf(cqlNames.set, startIndex) === startIndex) {
	      //move cursor across the name and bypass the angle brackets
	      startIndex += cqlNames.set.length + 1;
	      length -= cqlNames.set.length + 2;
	      innerTypes = parseParams(typeName, startIndex, length, '<', '>');

	      if (innerTypes.length !== 1) {
	        throw new TypeError('Not a valid type ' + typeName);
	      }

	      dataType.code = dataTypes.set;
	      dataType.info = await this.parseTypeName(keyspace, innerTypes[0], 0, null, udtResolver);
	      return dataType;
	    }

	    if (typeName.indexOf(cqlNames.map, startIndex) === startIndex) {
	      //move cursor across the name and bypass the angle brackets
	      startIndex += cqlNames.map.length + 1;
	      length -= cqlNames.map.length + 2;
	      innerTypes = parseParams(typeName, startIndex, length, '<', '>');

	      //It should contain the key and value types
	      if (innerTypes.length !== 2) {
	        throw new TypeError('Not a valid type ' + typeName);
	      }

	      dataType.code = dataTypes.map;
	      dataType.info = await this._parseChildTypes(keyspace, innerTypes, udtResolver);
	      return dataType;
	    }

	    if (typeName.indexOf(cqlNames.tuple, startIndex) === startIndex) {
	      //move cursor across the name and bypass the angle brackets
	      startIndex += cqlNames.tuple.length + 1;
	      length -= cqlNames.tuple.length + 2;
	      innerTypes = parseParams(typeName, startIndex, length, '<', '>');

	      if (innerTypes.length < 1) {
	        throw new TypeError('Not a valid type ' + typeName);
	      }

	      dataType.code = dataTypes.tuple;
	      dataType.info = await this._parseChildTypes(keyspace, innerTypes, udtResolver);
	      return dataType;
	    }

	    if (typeName.indexOf(cqlNames.vector, startIndex) === startIndex) {
	      // It's a vector, so record the subtype and dimension.
	      dataType.code = dataTypes.custom;

	      // parseVectorTypeArgs is not an async function but we are.  To keep things simple let's ask the
	      // function to just return whatever it finds for an arg and we'll eval it after the fact
	      const params = this.parseVectorTypeArgs(typeName, cqlNames.vector, (arg) => arg );
	      params["subtype"] = await this.parseTypeName(keyspace, params["subtype"]);
	      dataType.info = params;

	      return dataType;
	    }

	    const quoted = typeName.indexOf('"', startIndex) === startIndex;
	    if (quoted) {
	      // Remove quotes
	      startIndex++;
	      length -= 2;
	    }

	    // Quick check if its a single type
	    if (startIndex > 0) {
	      typeName = typeName.substr(startIndex, length);
	    }

	    // Un-escape double quotes if quoted.
	    if (quoted) {
	      typeName = typeName.replace('""', '"');
	    }

	    const typeCode = dataTypes[typeName];
	    if (typeof typeCode === 'number') {
	      dataType.code = typeCode;
	      return dataType;
	    }

	    if (typeName === cqlNames.duration) {
	      dataType.info = customTypeNames.duration;
	      return dataType;
	    }

	    if (typeName === cqlNames.empty) {
	      // Set as custom
	      dataType.info = 'empty';
	      return dataType;
	    }

	    const udtInfo = await udtResolver(keyspace, typeName);
	    if (udtInfo) {
	      dataType.code = dataTypes.udt;
	      dataType.info = udtInfo;
	      return dataType;
	    }

	    throw new TypeError('Not a valid type "' + typeName + '"');
	  };

	  /**
	   * @param {String} keyspace
	   * @param {Array} typeNames
	   * @param {Function} udtResolver
	   * @returns {Promise}
	   * @private
	   */
	  this._parseChildTypes = function (keyspace, typeNames, udtResolver) {
	    return Promise.all(typeNames.map(name => this.parseTypeName(keyspace, name.trim(), 0, null, udtResolver)));
	  };

	  /**
	   * Parses a Cassandra fully-qualified class name string into data type information
	   * @param {String} typeName
	   * @param {Number} [startIndex]
	   * @param {Number} [length]
	   * @throws TypeError
	   * @returns {{code: number, info: Object|Array|null, options: {frozen: Boolean, reversed: Boolean}}}
	   * @internal
	   * @ignore
	   */
	  this.parseFqTypeName = function (typeName, startIndex, length) {
	    const dataType = {
	      code: 0,
	      info: null,
	      options: {
	        reversed: false,
	        frozen: false
	      }
	    };
	    startIndex = startIndex || 0;
	    let params;
	    if (!length) {
	      length = typeName.length;
	    }
	    if (length > complexTypeNames.reversed.length && typeName.indexOf(complexTypeNames.reversed) === startIndex) {
	      //Remove the reversed token
	      startIndex += complexTypeNames.reversed.length + 1;
	      length -= complexTypeNames.reversed.length + 2;
	      dataType.options.reversed = true;
	    }
	    if (length > complexTypeNames.frozen.length &&
	        typeName.indexOf(complexTypeNames.frozen, startIndex) === startIndex) {
	      //Remove the frozen token
	      startIndex += complexTypeNames.frozen.length + 1;
	      length -= complexTypeNames.frozen.length + 2;
	      dataType.options.frozen = true;
	    }
	    if (typeName === complexTypeNames.empty) {
	      //set as custom
	      dataType.info = 'empty';
	      return dataType;
	    }
	    //Quick check if its a single type
	    if (length <= singleFqTypeNamesLength) {
	      if (startIndex > 0) {
	        typeName = typeName.substr(startIndex, length);
	      }
	      const typeCode = singleTypeNames[typeName];
	      if (typeof typeCode === 'number') {
	        dataType.code = typeCode;
	        return dataType;
	      }
	      throw new TypeError('Not a valid type "' + typeName + '"');
	    }
	    if (typeName.indexOf(complexTypeNames.list, startIndex) === startIndex) {
	      //Its a list
	      //org.apache.cassandra.db.marshal.ListType(innerType)
	      //move cursor across the name and bypass the parenthesis
	      startIndex += complexTypeNames.list.length + 1;
	      length -= complexTypeNames.list.length + 2;
	      params = parseParams(typeName, startIndex, length);
	      if (params.length !== 1) {
	        throw new TypeError('Not a valid type ' + typeName);
	      }
	      dataType.code = dataTypes.list;
	      dataType.info = this.parseFqTypeName(params[0]);
	      return dataType;
	    }
	    if (typeName.indexOf(complexTypeNames.set, startIndex) === startIndex) {
	      //Its a set
	      //org.apache.cassandra.db.marshal.SetType(innerType)
	      //move cursor across the name and bypass the parenthesis
	      startIndex += complexTypeNames.set.length + 1;
	      length -= complexTypeNames.set.length + 2;
	      params = parseParams(typeName, startIndex, length);
	      if (params.length !== 1)
	      {
	        throw new TypeError('Not a valid type ' + typeName);
	      }
	      dataType.code = dataTypes.set;
	      dataType.info = this.parseFqTypeName(params[0]);
	      return dataType;
	    }
	    if (typeName.indexOf(complexTypeNames.map, startIndex) === startIndex) {
	      //org.apache.cassandra.db.marshal.MapType(keyType,valueType)
	      //move cursor across the name and bypass the parenthesis
	      startIndex += complexTypeNames.map.length + 1;
	      length -= complexTypeNames.map.length + 2;
	      params = parseParams(typeName, startIndex, length);
	      //It should contain the key and value types
	      if (params.length !== 2) {
	        throw new TypeError('Not a valid type ' + typeName);
	      }
	      dataType.code = dataTypes.map;
	      dataType.info = [this.parseFqTypeName(params[0]), this.parseFqTypeName(params[1])];
	      return dataType;
	    }
	    if (typeName.indexOf(complexTypeNames.udt, startIndex) === startIndex) {
	      //move cursor across the name and bypass the parenthesis
	      startIndex += complexTypeNames.udt.length + 1;
	      length -= complexTypeNames.udt.length + 2;
	      return this._parseUdtName(typeName, startIndex, length);
	    }
	    if (typeName.indexOf(complexTypeNames.tuple, startIndex) === startIndex) {
	      //move cursor across the name and bypass the parenthesis
	      startIndex += complexTypeNames.tuple.length + 1;
	      length -= complexTypeNames.tuple.length + 2;
	      params = parseParams(typeName, startIndex, length);
	      if (params.length < 1) {
	        throw new TypeError('Not a valid type ' + typeName);
	      }
	      dataType.code = dataTypes.tuple;
	      dataType.info = params.map(x => this.parseFqTypeName(x));
	      return dataType;
	    }

	    if (typeName.indexOf(customTypeNames.vector, startIndex) === startIndex) {
	      // It's a vector, so record the subtype and dimension.
	      dataType.code = dataTypes.custom;
	      dataType.info = this.parseVectorTypeArgs(typeName, customTypeNames.vector, this.parseFqTypeName);
	      return dataType;
	    }

	    // Assume custom type if cannot be parsed up to this point.
	    dataType.info = typeName.substr(startIndex, length);
	    return dataType;
	  };
	  /**
	   * Parses type names with composites
	   * @param {String} typesString
	   * @returns {{types: Array, isComposite: Boolean, hasCollections: Boolean}}
	   * @internal
	   * @ignore
	   */
	  this.parseKeyTypes = function (typesString) {
	    let i = 0;
	    let length = typesString.length;
	    const isComposite = typesString.indexOf(complexTypeNames.composite) === 0;
	    if (isComposite) {
	      i = complexTypeNames.composite.length + 1;
	      length--;
	    }
	    const types = [];
	    let startIndex = i;
	    let nested = 0;
	    let inCollectionType = false;
	    let hasCollections = false;
	    //as collection types are not allowed, it is safe to split by ,
	    while (++i < length) {
	      switch (typesString[i]) {
	        case ',':
	          if (nested > 0) {
	            break;
	          }
	          if (inCollectionType) {
	            //remove type id
	            startIndex = typesString.indexOf(':', startIndex) + 1;
	          }
	          types.push(typesString.substring(startIndex, i));
	          startIndex = i + 1;
	          break;
	        case '(':
	          if (nested === 0 && typesString.indexOf(complexTypeNames.collection, startIndex) === startIndex) {
	            inCollectionType = true;
	            hasCollections = true;
	            //skip collection type
	            i++;
	            startIndex = i;
	            break;
	          }
	          nested++;
	          break;
	        case ')':
	          if (inCollectionType && nested === 0){
	            types.push(typesString.substring(typesString.indexOf(':', startIndex) + 1, i));
	            startIndex = i + 1;
	            break;
	          }
	          nested--;
	          break;
	      }
	    }
	    if (startIndex < length) {
	      types.push(typesString.substring(startIndex, length));
	    }
	    return {
	      types: types.map(name => this.parseFqTypeName(name)),
	      hasCollections: hasCollections,
	      isComposite: isComposite
	    };
	  };
	  this._parseUdtName = function (typeName, startIndex, length) {
	    const udtParams = parseParams(typeName, startIndex, length);
	    if (udtParams.length < 2) {
	      //It should contain at least the keyspace, name of the udt and a type
	      throw new TypeError('Not a valid type ' + typeName);
	    }
	    const dataType = {
	      code: dataTypes.udt,
	      info: null
	    };
	    const udtInfo = {
	      keyspace: udtParams[0],
	      name: utils.allocBufferFromString(udtParams[1], 'hex').toString(),
	      fields: []
	    };
	    for (let i = 2; i < udtParams.length; i++) {
	      const p = udtParams[i];
	      const separatorIndex = p.indexOf(':');
	      const fieldType = this.parseFqTypeName(p, separatorIndex + 1, p.length - (separatorIndex + 1));
	      udtInfo.fields.push({
	        name: utils.allocBufferFromString(p.substr(0, separatorIndex), 'hex').toString(),
	        type: fieldType
	      });
	    }
	    dataType.info = udtInfo;
	    return dataType;
	  };
	}

	/**
	 * Sets the encoder and decoder methods for this instance
	 * @private
	 */
	function setEncoders() {
	  this.decoders = {
	    [dataTypes.custom]: this.decodeCustom,
	    [dataTypes.ascii]: this.decodeAsciiString,
	    [dataTypes.bigint]: this.decodeLong,
	    [dataTypes.blob]: this.decodeBlob,
	    [dataTypes.boolean]: this.decodeBoolean,
	    [dataTypes.counter]: this.decodeLong,
	    [dataTypes.decimal]: this.decodeDecimal,
	    [dataTypes.double]: this.decodeDouble,
	    [dataTypes.float]: this.decodeFloat,
	    [dataTypes.int]: this.decodeInt,
	    [dataTypes.text]: this.decodeUtf8String,
	    [dataTypes.timestamp]: this.decodeTimestamp,
	    [dataTypes.uuid]: this.decodeUuid,
	    [dataTypes.varchar]: this.decodeUtf8String,
	    [dataTypes.varint]: this.decodeVarint,
	    [dataTypes.timeuuid]: this.decodeTimeUuid,
	    [dataTypes.inet]: this.decodeInet,
	    [dataTypes.date]: this.decodeDate,
	    [dataTypes.time]: this.decodeTime,
	    [dataTypes.smallint]: this.decodeSmallint,
	    [dataTypes.tinyint]: this.decodeTinyint,
	    [dataTypes.duration]: decodeDuration,
	    [dataTypes.list]: this.decodeList,
	    [dataTypes.map]: this.decodeMap,
	    [dataTypes.set]: this.decodeSet,
	    [dataTypes.udt]: this.decodeUdt,
	    [dataTypes.tuple]: this.decodeTuple
	  };

	  this.encoders = {
	    [dataTypes.custom]: this.encodeCustom,
	    [dataTypes.ascii]: this.encodeAsciiString,
	    [dataTypes.bigint]: this.encodeLong,
	    [dataTypes.blob]: this.encodeBlob,
	    [dataTypes.boolean]: this.encodeBoolean,
	    [dataTypes.counter]: this.encodeLong,
	    [dataTypes.decimal]: this.encodeDecimal,
	    [dataTypes.double]: this.encodeDouble,
	    [dataTypes.float]: this.encodeFloat,
	    [dataTypes.int]: this.encodeInt,
	    [dataTypes.text]: this.encodeUtf8String,
	    [dataTypes.timestamp]: this.encodeTimestamp,
	    [dataTypes.uuid]: this.encodeUuid,
	    [dataTypes.varchar]: this.encodeUtf8String,
	    [dataTypes.varint]: this.encodeVarint,
	    [dataTypes.timeuuid]: this.encodeUuid,
	    [dataTypes.inet]: this.encodeInet,
	    [dataTypes.date]: this.encodeDate,
	    [dataTypes.time]: this.encodeTime,
	    [dataTypes.smallint]: this.encodeSmallint,
	    [dataTypes.tinyint]: this.encodeTinyint,
	    [dataTypes.duration]: encodeDuration,
	    [dataTypes.list]: this.encodeList,
	    [dataTypes.map]: this.encodeMap,
	    [dataTypes.set]: this.encodeSet,
	    [dataTypes.udt]: this.encodeUdt,
	    [dataTypes.tuple]: this.encodeTuple
	  };
	}

	/**
	 * Decodes Cassandra bytes into Javascript values.
	 * <p>
	 * This is part of an <b>experimental</b> API, this can be changed future releases.
	 * </p>
	 * @param {Buffer} buffer Raw buffer to be decoded.
	 * @param {Object} type An object containing the data type <code>code</code> and <code>info</code>.
	 * @param {Number} type.code Type code.
	 * @param {Object} [type.info] Additional information on the type for complex / nested types.
	 */
	Encoder.prototype.decode = function (buffer, type) {
	  if (buffer === null || (buffer.length === 0 && !zeroLengthTypesSupported.has(type.code))) {
	    return null;
	  }

	  const decoder = this.decoders[type.code];

	  if (!decoder) {
	    throw new Error('Unknown data type: ' + type.code);
	  }

	  return decoder.call(this, buffer, type.info);
	};

	/**
	 * Encodes Javascript types into Buffer according to the Cassandra protocol.
	 * <p>
	 * This is part of an <b>experimental</b> API, this can be changed future releases.
	 * </p>
	 * @param {*} value The value to be converted.
	 * @param {{code: number, info: *|Object}|String|Number} [typeInfo] The type information.
	 * <p>It can be either a:</p>
	 * <ul>
	 *   <li>A <code>String</code> representing the data type.</li>
	 *   <li>A <code>Number</code> with one of the values of {@link module:types~dataTypes dataTypes}.</li>
	 *   <li>An <code>Object</code> containing the <code>type.code</code> as one of the values of
	 *   {@link module:types~dataTypes dataTypes} and <code>type.info</code>.
	 *   </li>
	 * </ul>
	 * @returns {Buffer}
	 * @throws {TypeError} When there is an encoding error
	 */
	Encoder.prototype.encode = function (value, typeInfo) {
	  if (value === undefined) {
	    value = this.encodingOptions.useUndefinedAsUnset && this.protocolVersion >= 4 ? types.unset : null;
	  }

	  if (value === types.unset) {
	    if (!types.protocolVersion.supportsUnset(this.protocolVersion)) {
	      throw new TypeError('Unset value can not be used for this version of Cassandra, protocol version: ' +
	        this.protocolVersion);
	    }

	    return value;
	  }

	  if (value === null || value instanceof Buffer) {
	    return value;
	  }

	  /** @type {{code: Number, info: object}} */
	  let type = {
	    code: null,
	    info: null
	  };

	  if (typeInfo) {
	    if (typeof typeInfo === 'number') {
	      type.code = typeInfo;
	    }
	    else if (typeof typeInfo === 'string') {
	      type = dataTypes.getByName(typeInfo);
	    }
	    if (typeof typeInfo.code === 'number') {
	      type.code = typeInfo.code;
	      type.info = typeInfo.info;
	    }
	    if (typeof type.code !== 'number') {
	      throw new TypeError('Type information not valid, only String and Number values are valid hints');
	    }
	  }
	  else {
	    //Lets guess
	    type = Encoder.guessDataType(value);
	    if (!type) {
	      throw new TypeError('Target data type could not be guessed, you should use prepared statements for accurate type mapping. Value: ' + util.inspect(value));
	    }
	  }

	  const encoder = this.encoders[type.code];

	  if (!encoder) {
	    throw new Error('Type not supported ' + type.code);
	  }

	  return encoder.call(this, value, type.info);
	};

	/**
	 * Try to guess the Cassandra type to be stored, based on the javascript value type
	 * @param value
	 * @returns {{code: number, info: object}|null}
	 * @ignore
	 * @internal
	 */
	Encoder.guessDataType = function (value) {
	  let code = null;
	  let info = null;
	  const esTypeName = (typeof value);
	  if (esTypeName === 'number') {
	    code = dataTypes.double;
	  }
	  else if (esTypeName === 'string') {
	    code = dataTypes.text;
	    if (value.length === 36 && uuidRegex.test(value)){
	      code = dataTypes.uuid;
	    }
	  }
	  else if (esTypeName === 'boolean') {
	    code = dataTypes.boolean;
	  }
	  else if (value instanceof Buffer) {
	    code = dataTypes.blob;
	  }
	  else if (value instanceof Date) {
	    code = dataTypes.timestamp;
	  }
	  else if (value instanceof Long) {
	    code = dataTypes.bigint;
	  }
	  else if (value instanceof Integer) {
	    code = dataTypes.varint;
	  }
	  else if (value instanceof BigDecimal) {
	    code = dataTypes.decimal;
	  }
	  else if (value instanceof types.Uuid) {
	    code = dataTypes.uuid;
	  }
	  else if (value instanceof types.InetAddress) {
	    code = dataTypes.inet;
	  }
	  else if (value instanceof types.Tuple) {
	    code = dataTypes.tuple;
	  }
	  else if (value instanceof types.LocalDate) {
	    code = dataTypes.date;
	  }
	  else if (value instanceof types.LocalTime) {
	    code = dataTypes.time;
	  }
	  else if (value instanceof types.Duration) {
	    code = dataTypes.custom;
	    info = customTypeNames.duration;
	  }
	  // Map JS TypedArrays onto vectors
	  else if (Encoder.isTypedArray(value)) {
	    code = dataTypes.custom;
	    // TODO: another area that we have to generalize if we ever need to support vector subtypes other than float
	    info = buildParameterizedCustomType(customTypeNames.vector, [singleTypeNamesByDataType[dataTypes.float], value.length]);
	  }
	  else if (Array.isArray(value)) {
	    code = dataTypes.list;
	  }
	  else if (value instanceof Geometry) {
	    code = dataTypes.custom;
	    if (value instanceof LineString) {
	      info = customTypeNames.lineString;
	    } else if (value instanceof Point) {
	      info = customTypeNames.point;
	    } else if (value instanceof Polygon) {
	      info = customTypeNames.polygon;
	    }
	  }
	  else if (value instanceof DateRange) {
	    code = dataTypes.custom;
	    info = customTypeNames.dateRange;
	  }

	  if (code === null) {
	    return null;
	  }
	  return { code: code, info: info };
	};

	/**
	 * Gets a buffer containing with the bytes (BE) representing the collection length for protocol v2 and below
	 * @param {Buffer|Number} value
	 * @returns {Buffer}
	 * @private
	 */
	function getLengthBufferV2(value) {
	  if (!value) {
	    return buffers.int16Zero;
	  }
	  const lengthBuffer = utils.allocBufferUnsafe(2);
	  if (typeof value === 'number') {
	    lengthBuffer.writeUInt16BE(value, 0);
	  }
	  else {
	    lengthBuffer.writeUInt16BE(value.length, 0);
	  }
	  return lengthBuffer;
	}

	/**
	 * Gets a buffer containing with the bytes (BE) representing the collection length for protocol v3 and above
	 * @param {Buffer|Number} value
	 * @returns {Buffer}
	 * @private
	 */
	function getLengthBufferV3(value) {
	  if (!value) {
	    return buffers.int32Zero;
	  }
	  const lengthBuffer = utils.allocBufferUnsafe(4);
	  if (typeof value === 'number') {
	    lengthBuffer.writeInt32BE(value, 0);
	  }
	  else {
	    lengthBuffer.writeInt32BE(value.length, 0);
	  }
	  return lengthBuffer;
	}

	/**
	 * @param {Buffer} buffer
	 * @private
	 */
	function handleBufferCopy(buffer) {
	  if (buffer === null) {
	    return null;
	  }
	  return utils.copyBuffer(buffer);
	}

	/**
	 * @param {Buffer} buffer
	 * @private
	 */
	function handleBufferRef(buffer) {
	  return buffer;
	}
	/**
	 * Decodes collection length for protocol v3 and above
	 * @param bytes
	 * @param offset
	 * @returns {Number}
	 * @private
	 */
	function decodeCollectionLengthV3(bytes, offset) {
	  return bytes.readInt32BE(offset);
	}
	/**
	 * Decodes collection length for protocol v2 and below
	 * @param bytes
	 * @param offset
	 * @returns {Number}
	 * @private
	 */
	function decodeCollectionLengthV2(bytes, offset) {
	  return bytes.readUInt16BE(offset);
	}

	function decodeDuration(bytes) {
	  return types.Duration.fromBuffer(bytes);
	}

	function encodeDuration(value) {
	  if (!(value instanceof types.Duration)) {
	    throw new TypeError('Not a valid duration, expected Duration/Buffer obtained ' + util.inspect(value));
	  }
	  return value.toBuffer();
	}

	/**
	 * @private
	 * @param {Buffer} buffer
	 */
	function decodeLineString(buffer) {
	  return LineString.fromBuffer(buffer);
	}

	/**
	 * @private
	 * @param {LineString} value
	 */
	function encodeLineString(value) {
	  return value.toBuffer();
	}

	/**
	 * @private
	 * @param {Buffer} buffer
	 */
	function decodePoint(buffer) {
	  return Point.fromBuffer(buffer);
	}

	/**
	 * @private
	 * @param {LineString} value
	 */
	function encodePoint(value) {
	  return value.toBuffer();
	}

	/**
	 * @private
	 * @param {Buffer} buffer
	 */
	function decodePolygon(buffer) {
	  return Polygon.fromBuffer(buffer);
	}

	/**
	 * @private
	 * @param {Polygon} value
	 */
	function encodePolygon(value) {
	  return value.toBuffer();
	}

	function decodeDateRange(buffer) {
	  return DateRange.fromBuffer(buffer);
	}

	/**
	 * @private
	 * @param {DateRange} value
	 */
	function encodeDateRange(value) {
	  return value.toBuffer();
	}

	/**
	 * @param {String} value
	 * @param {Number} startIndex
	 * @param {Number} length
	 * @param {String} [open]
	 * @param {String} [close]
	 * @returns {Array}
	 * @private
	 */
	function parseParams(value, startIndex, length, open, close) {
	  open = open || '(';
	  close = close || ')';
	  const types = [];
	  let paramStart = startIndex;
	  let level = 0;
	  for (let i = startIndex; i < startIndex + length; i++) {
	    const c = value[i];
	    if (c === open) {
	      level++;
	    }
	    if (c === close) {
	      level--;
	    }
	    if (level === 0 && c === ',') {
	      types.push(value.substr(paramStart, i - paramStart));
	      paramStart = i + 1;
	    }
	  }
	  //Add the last one
	  types.push(value.substr(paramStart, length - (paramStart - startIndex)));
	  return types;
	}

	/**
	 * @param {Array.<Buffer>} parts
	 * @param {Number} totalLength
	 * @returns {Buffer}
	 * @private
	 */
	function concatRoutingKey(parts, totalLength) {
	  if (totalLength === 0) {
	    return null;
	  }
	  if (parts.length === 1) {
	    return parts[0];
	  }
	  const routingKey = utils.allocBufferUnsafe(totalLength);
	  let offset = 0;
	  for (let i = 0; i < parts.length; i++) {
	    const item = parts[i];
	    routingKey.writeUInt16BE(item.length, offset);
	    offset += 2;
	    item.copy(routingKey, offset);
	    offset += item.length;
	    routingKey[offset] = 0;
	    offset++;
	  }
	  return routingKey;
	}

	function buildParameterizedCustomType(customTypeName, args) {
	  return `${customTypeName}(${args.join(',')})`;
	}

	function invertObject(obj) {
	  const rv = {};
	  for(const k in obj){
	    if (obj.hasOwnProperty(k)) {
	      rv[obj[k]] = k;
	    }
	  }
	  return rv;
	}
	Encoder.isTypedArray = function(arg) {
	  // The TypedArray superclass isn't available directly so to detect an instance of a TypedArray
	  // subclass we have to access the prototype of a concrete instance.  There's nothing magical about
	  // Uint8Array here; we could just as easily use any of the other TypedArray subclasses.
	  return (arg instanceof Object.getPrototypeOf(Uint8Array));
	};

	encoder$1 = Encoder;
	return encoder$1;
}var streams$1 = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var readers;
var hasRequiredReaders;

function requireReaders () {
	if (hasRequiredReaders) return readers;
	hasRequiredReaders = 1;

	const util = require$$0$6;
	const utils = requireUtils$c();
	const types = requireTypes$2();
	const errors = requireErrors$c();

	/**
	 * Information on the formatting of the returned rows
	 */
	const resultFlag = {
	  globalTablesSpec:   0x0001,
	  hasMorePages:       0x0002,
	  noMetadata:         0x0004,
	  metadataChanged:    0x0008,
	  continuousPaging: 0x40000000,
	  lastContinuousPage: 0x80000000,
	};

	// templates for derived error messages.
	const _writeTimeoutQueryMessage = 'Server timeout during write query at consistency %s (%d peer(s) acknowledged the write over %d required)';
	const _writeTimeoutBatchLogMessage = 'Server timeout during batchlog write at consistency %s (%d peer(s) acknowledged the write over %d required)';
	const _writeFailureMessage = 'Server failure during write query at consistency %s (%d responses were required but only %d replicas responded, %d failed)';
	const _unavailableMessage = 'Not enough replicas available for query at consistency %s (%d required but only %d alive)';
	const _readTimeoutMessage = 'Server timeout during read query at consistency %s (%s)';
	const _readFailureMessage = 'Server failure during read query at consistency %s (%d responses were required but only %d replicas responded, %d failed)';

	/**
	 * Buffer forward reader of CQL binary frames
	 * @param {FrameHeader} header
	 * @param {Buffer} body
	 * @param {Number} [offset]
	 */
	class FrameReader {

	  /**
	   * Creates a new instance of the reader
	   * @param {FrameHeader} header
	   * @param {Buffer} body
	   * @param {Number} [offset]
	   */
	  constructor(header, body, offset) {
	    this.header = header;
	    this.opcode = header.opcode;
	    this.offset = offset || 0;
	    this.buf = body;
	  }

	  remainingLength() {
	    return this.buf.length - this.offset;
	  }

	  getBuffer() {
	    return this.buf;
	  }

	  /**
	   * Slices the underlining buffer
	   * @param {Number} begin
	   * @param {Number} [end]
	   * @returns {Buffer}
	   */
	  slice(begin, end) {
	    if (typeof end === 'undefined') {
	      end = this.buf.length;
	    }
	    return this.buf.slice(begin, end);
	  }

	  /**
	   * Modifies the underlying buffer, it concatenates the given buffer with the original (internalBuffer = concat(bytes, internalBuffer)
	   */
	  unshift(bytes) {
	    if (this.offset > 0) {
	      throw new Error('Can not modify the underlying buffer if already read');
	    }
	    this.buf = Buffer.concat([bytes, this.buf], bytes.length + this.buf.length);
	  }

	  /**
	   * Reads any number of bytes and moves the offset.
	   * if length not provided or it's larger than the remaining bytes, reads to end.
	   * @param length
	   * @returns {Buffer}
	   */
	  read(length) {
	    let end = this.buf.length;
	    if (typeof length !== 'undefined' && this.offset + length < this.buf.length) {
	      end = this.offset + length;
	    }
	    const bytes = this.slice(this.offset, end);
	    this.offset = end;
	    return bytes;
	  }

	  /**
	   * Moves the reader cursor to the end
	   */
	  toEnd() {
	    this.offset = this.buf.length;
	  }

	  /**
	   * Reads a BE Int and moves the offset
	   * @returns {Number}
	   */
	  readInt() {
	    const result = this.buf.readInt32BE(this.offset);
	    this.offset += 4;
	    return result;
	  }

	  /** @returns {Number} */
	  readShort() {
	    const result = this.buf.readUInt16BE(this.offset);
	    this.offset += 2;
	    return result;
	  }

	  readByte() {
	    const result = this.buf.readUInt8(this.offset);
	    this.offset += 1;
	    return result;
	  }

	  readString() {
	    const length = this.readShort();
	    this.checkOffset(length);
	    const result = this.buf.toString('utf8', this.offset, this.offset + length);
	    this.offset += length;
	    return result;
	  }

	  /**
	   * Checks that the new length to read is within the range of the buffer length. Throws a RangeError if not.
	   * @param {Number} newLength
	   */
	  checkOffset(newLength) {
	    if (this.offset + newLength > this.buf.length) {
	      const err = new RangeError('Trying to access beyond buffer length');
	      err.expectedLength = newLength;
	      throw err;
	    }
	  }

	  /**
	   * Reads a protocol string list
	   * @returns {Array}
	   */
	  readStringList() {
	    const length = this.readShort();
	    const list = new Array(length);
	    for (let i = 0; i < length; i++) {
	      list[i] = this.readString();
	    }
	    return list;
	  }

	  /**
	   * Reads the amount of bytes that the field has and returns them (slicing them).
	   * @returns {Buffer}
	   */
	  readBytes() {
	    const length = this.readInt();
	    if (length < 0) {
	      return null;
	    }
	    this.checkOffset(length);
	    return this.read(length);
	  }

	  readShortBytes() {
	    const length = this.readShort();
	    if (length < 0) {
	      return null;
	    }
	    this.checkOffset(length);
	    return this.read(length);
	  }

	  /**
	   * Reads an associative array of strings as keys and bytes as values
	   * @param {Number} length
	   * @param {Function} keyFn
	   * @param {Function} valueFn
	   * @returns {Object}
	   */
	  readMap(length, keyFn, valueFn) {
	    if (length < 0) {
	      return null;
	    }
	    const map = {};
	    for (let i = 0; i < length; i++) {
	      map[keyFn.call(this)] = valueFn.call(this);
	    }
	    return map;
	  }

	  /**
	   * Reads an associative array of strings as keys and string lists as values
	   * @returns {Object}
	   */
	  readStringMultiMap() {
	    //A [short] n, followed by n pair <k><v> where <k> is a
	    //[string] and <v> is a [string[]].
	    const length = this.readShort();
	    if (length < 0) {
	      return null;
	    }
	    const map = {};
	    for (let i = 0; i < length; i++) {
	      map[this.readString()] = this.readStringList();
	    }
	    return map;
	  }

	  /**
	   * Reads a data type definition
	   * @returns {{code: Number, info: Object|null}} An array of 2 elements
	   */
	  readType() {
	    let i;
	    const type = {
	      code: this.readShort(),
	      type: null
	    };
	    switch (type.code) {
	      case types.dataTypes.custom:
	        type.info = this.readString();
	        break;
	      case types.dataTypes.list:
	      case types.dataTypes.set:
	        type.info = this.readType();
	        break;
	      case types.dataTypes.map:
	        type.info = [this.readType(), this.readType()];
	        break;
	      case types.dataTypes.udt:
	        type.info = {
	          keyspace: this.readString(),
	          name: this.readString(),
	          fields: new Array(this.readShort())
	        };
	        for (i = 0; i < type.info.fields.length; i++) {
	          type.info.fields[i] = {
	            name: this.readString(),
	            type: this.readType()
	          };
	        }
	        break;
	      case types.dataTypes.tuple:
	        type.info = new Array(this.readShort());
	        for (i = 0; i < type.info.length; i++) {
	          type.info[i] = this.readType();
	        }
	        break;
	    }
	    return type;
	  }

	  /**
	   * Reads an Ip address and port
	   * @returns {{address: exports.InetAddress, port: Number}}
	   */
	  readInet() {
	    const length = this.readByte();
	    const address = this.read(length);
	    return { address: new types.InetAddress(address), port: this.readInt() };
	  }

	  /**
	   * Reads an Ip address
	   * @returns {InetAddress}
	   */
	  readInetAddress() {
	    const length = this.readByte();
	    return new types.InetAddress(this.read(length));
	  }

	  /**
	   * Reads the body bytes corresponding to the flags
	   * @returns {{traceId: Uuid, warnings: Array, customPayload}}
	   * @throws {RangeError}
	   */
	  readFlagsInfo() {
	    if (this.header.flags === 0) {
	      return utils.emptyObject;
	    }
	    const result = {};
	    if (this.header.flags & types.frameFlags.tracing) {
	      this.checkOffset(16);
	      result.traceId = new types.Uuid(utils.copyBuffer(this.read(16)));
	    }
	    if (this.header.flags & types.frameFlags.warning) {
	      result.warnings = this.readStringList();
	    }
	    if (this.header.flags & types.frameFlags.customPayload) {
	      // Custom payload is a Map<string, Buffer>
	      result.customPayload = this.readMap(this.readShort(), this.readString, this.readBytes);
	    }
	    return result;
	  }

	  /**
	   * Reads the metadata from a row or a prepared result response
	   * @param {Number} kind
	   * @returns {Object}
	   * @throws {RangeError}
	   */
	  readMetadata(kind) {
	    let i;
	    //Determines if its a prepared metadata
	    const isPrepared = (kind === types.resultKind.prepared);
	    const meta = {};
	    if (types.protocolVersion.supportsResultMetadataId(this.header.version) && isPrepared) {
	      meta.resultId = utils.copyBuffer(this.readShortBytes());
	    }
	    //as used in Rows and Prepared responses
	    const flags = this.readInt();
	    const columnLength = this.readInt();
	    if (types.protocolVersion.supportsPreparedPartitionKey(this.header.version) && isPrepared) {
	      //read the pk columns
	      meta.partitionKeys = new Array(this.readInt());
	      for (i = 0; i < meta.partitionKeys.length; i++) {
	        meta.partitionKeys[i] = this.readShort();
	      }
	    }
	    if (flags & resultFlag.hasMorePages) {
	      meta.pageState = utils.copyBuffer(this.readBytes());
	    }
	    if (flags & resultFlag.metadataChanged) {
	      meta.newResultId = utils.copyBuffer(this.readShortBytes());
	    }
	    if (flags & resultFlag.continuousPaging) {
	      meta.continuousPageIndex = this.readInt();
	      meta.lastContinuousPage = !!(flags & resultFlag.lastContinuousPage);
	    }
	    if (flags & resultFlag.globalTablesSpec) {
	      meta.global_tables_spec = true;
	      meta.keyspace = this.readString();
	      meta.table = this.readString();
	    }
	    meta.columns = new Array(columnLength);
	    meta.columnsByName = utils.emptyObject;
	    if (isPrepared) {
	      //for prepared metadata, we will need a index of the columns (param) by name
	      meta.columnsByName = {};
	    }
	    for (i = 0; i < columnLength; i++) {
	      const col = {};
	      if (!meta.global_tables_spec) {
	        col.ksname = this.readString();
	        col.tablename = this.readString();
	      }
	      col.name = this.readString();
	      col.type = this.readType();
	      meta.columns[i] = col;
	      if (isPrepared) {
	        meta.columnsByName[col.name] = i;
	      }
	    }
	    return meta;
	  }

	  /**
	   * Reads the error from the frame
	   * @throws {RangeError}
	   * @returns {ResponseError}
	   */
	  readError() {
	    const code = this.readInt();
	    const message = this.readString();
	    const err = new errors.ResponseError(code, message);
	    //read extra info
	    switch (code) {
	      case types.responseErrorCodes.unavailableException:
	        err.consistencies = this.readShort();
	        err.required = this.readInt();
	        err.alive = this.readInt();
	        err.message = util.format(_unavailableMessage, types.consistencyToString[err.consistencies], err.required, err.alive);
	        break;
	      case types.responseErrorCodes.readTimeout:
	      case types.responseErrorCodes.readFailure:
	        err.consistencies = this.readShort();
	        err.received = this.readInt();
	        err.blockFor = this.readInt();
	        if (code === types.responseErrorCodes.readFailure) {
	          if (types.protocolVersion.supportsFailureReasonMap(this.header.version)) {
	            err.failures = this.readInt();
	            err.reasons = this.readMap(err.failures, this.readInetAddress, this.readShort);
	          }
	          else {
	            err.failures = this.readInt();
	          }
	        }
	        err.isDataPresent = this.readByte();
	        if (code === types.responseErrorCodes.readTimeout) {
	          let details;
	          if (err.received < err.blockFor) {
	            details = util.format('%d replica(s) responded over %d required', err.received, err.blockFor);
	          }
	          else if (!err.isDataPresent) {
	            details = 'the replica queried for the data didn\'t respond';
	          }
	          else {
	            details = 'timeout while waiting for repair of inconsistent replica';
	          }
	          err.message = util.format(_readTimeoutMessage, types.consistencyToString[err.consistencies], details);
	        }
	        else {
	          err.message = util.format(_readFailureMessage, types.consistencyToString[err.consistencies], err.blockFor, err.received, err.failures);
	        }
	        break;
	      case types.responseErrorCodes.writeTimeout:
	      case types.responseErrorCodes.writeFailure:
	        err.consistencies = this.readShort();
	        err.received = this.readInt();
	        err.blockFor = this.readInt();
	        if (code === types.responseErrorCodes.writeFailure) {
	          if (types.protocolVersion.supportsFailureReasonMap(this.header.version)) {
	            err.failures = this.readInt();
	            err.reasons = this.readMap(err.failures, this.readInetAddress, this.readShort);
	          }
	          else {
	            err.failures = this.readInt();
	          }
	        }
	        err.writeType = this.readString();
	        if (code === types.responseErrorCodes.writeTimeout) {
	          const template = err.writeType === 'BATCH_LOG' ? _writeTimeoutBatchLogMessage : _writeTimeoutQueryMessage;
	          err.message = util.format(template, types.consistencyToString[err.consistencies], err.received, err.blockFor);
	        }
	        else {
	          err.message = util.format(_writeFailureMessage, types.consistencyToString[err.consistencies], err.blockFor, err.received, err.failures);
	        }
	        break;
	      case types.responseErrorCodes.unprepared:
	        err.queryId = utils.copyBuffer(this.readShortBytes());
	        break;
	      case types.responseErrorCodes.functionFailure:
	        err.keyspace = this.readString();
	        err.functionName = this.readString();
	        err.argTypes = this.readStringList();
	        break;
	      case types.responseErrorCodes.alreadyExists: {
	        err.keyspace = this.readString();
	        const table = this.readString();
	        if (table.length > 0) {
	          err.table = table;
	        }
	        break;
	      }
	    }
	    return err;
	  }

	  /**
	   * Reads an event from Cassandra and returns the detail
	   * @returns {{eventType: String, inet: {address: Buffer, port: Number}}, *}
	   */
	  readEvent() {
	    const eventType = this.readString();
	    switch (eventType) {
	      case types.protocolEvents.topologyChange:
	        return {
	          added: this.readString() === 'NEW_NODE',
	          inet: this.readInet(),
	          eventType: eventType
	        };
	      case types.protocolEvents.statusChange:
	        return {
	          up: this.readString() === 'UP',
	          inet: this.readInet(),
	          eventType: eventType
	        };
	      case types.protocolEvents.schemaChange:
	        return this.parseSchemaChange();
	    }
	    //Forward compatibility
	    return { eventType: eventType };
	  }

	  parseSchemaChange() {
	    let result;
	    if (!types.protocolVersion.supportsSchemaChangeFullMetadata(this.header.version)) {
	      //v1/v2: 3 strings, the table value can be empty
	      result = {
	        eventType: types.protocolEvents.schemaChange,
	        schemaChangeType: this.readString(),
	        keyspace: this.readString(),
	        table: this.readString()
	      };
	      result.isKeyspace = !result.table;
	      return result;
	    }
	    //v3+: 3 or 4 strings: change_type, target, keyspace and (table, type, functionName or aggregate)
	    result = {
	      eventType: types.protocolEvents.schemaChange,
	      schemaChangeType: this.readString(),
	      target: this.readString(),
	      keyspace: this.readString(),
	      table: null,
	      udt: null,
	      signature: null
	    };
	    result.isKeyspace = result.target === 'KEYSPACE';
	    switch (result.target) {
	      case 'TABLE':
	        result.table = this.readString();
	        break;
	      case 'TYPE':
	        result.udt = this.readString();
	        break;
	      case 'FUNCTION':
	        result.functionName = this.readString();
	        result.signature = this.readStringList();
	        break;
	      case 'AGGREGATE':
	        result.aggregate = this.readString();
	        result.signature = this.readStringList();
	    }
	    return result;
	  }
	}

	readers = { FrameReader };
	return readers;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredStreams$1;

function requireStreams$1 () {
	if (hasRequiredStreams$1) return streams$1;
	hasRequiredStreams$1 = 1;

	const util = require$$0$6;
	const { Transform, Writable } = require$$0$b;

	const types = requireTypes$2();
	const utils = requireUtils$c();
	const errors = requireErrors$c();
	const { FrameHeader } = types;
	const { FrameReader } = requireReaders();

	/**
	 * Transforms chunks, emits data objects {header, chunk}
	 * @param options Stream options
	 * @extends Transform
	 */
	function Protocol (options) {
	  Transform.call(this, options);
	  this.header = null;
	  this.bodyLength = 0;
	  this.clearHeaderChunks();
	  this.version = 0;
	  this.headerSize = 0;
	}

	util.inherits(Protocol, Transform);

	Protocol.prototype._transform = function (chunk, encoding, callback) {
	  let error = null;
	  try {
	    this.readItems(chunk);
	  }
	  catch (err) {
	    error = err;
	  }
	  callback(error);
	};

	/**
	 * Parses the chunk into frames (header and body).
	 * Emits (push) complete frames or frames with incomplete bodies. Following chunks containing the rest of the body will
	 * be emitted using the same frame.
	 * It buffers incomplete headers.
	 * @param {Buffer} chunk
	 */
	Protocol.prototype.readItems = function (chunk) {
	  if (!chunk || chunk.length === 0) {
	    return;
	  }
	  if (this.version === 0) {
	    //The server replies the first message with the max protocol version supported
	    this.version = FrameHeader.getProtocolVersion(chunk);
	    this.headerSize = FrameHeader.size(this.version);
	  }
	  let offset = 0;
	  let currentHeader = this.header;
	  this.header = null;
	  if (this.headerChunks.byteLength !== 0) {
	    //incomplete header was buffered try to read the header from the buffered chunks
	    this.headerChunks.parts.push(chunk);
	    if (this.headerChunks.byteLength + chunk.length < this.headerSize) {
	      this.headerChunks.byteLength += chunk.length;
	      return;
	    }
	    currentHeader = FrameHeader.fromBuffer(Buffer.concat(this.headerChunks.parts, this.headerSize));
	    offset = this.headerSize - this.headerChunks.byteLength;
	    this.clearHeaderChunks();
	  }
	  const items = [];
	  while (true) {
	    if (!currentHeader) {
	      if (this.headerSize > chunk.length - offset) {
	        if (chunk.length - offset <= 0) {
	          break;
	        }
	        //the header is incomplete, buffer it until the next chunk
	        const headerPart = chunk.slice(offset, chunk.length);
	        this.headerChunks.parts.push(headerPart);
	        this.headerChunks.byteLength = headerPart.length;
	        break;
	      }
	      //read header
	      currentHeader = FrameHeader.fromBuffer(chunk, offset);
	      offset += this.headerSize;
	    }
	    //parse body
	    const remaining = chunk.length - offset;
	    if (currentHeader.bodyLength <= remaining + this.bodyLength) {
	      items.push({ header: currentHeader, chunk: chunk, offset: offset, frameEnded: true });
	      offset += currentHeader.bodyLength - this.bodyLength;
	      //reset the body length
	      this.bodyLength = 0;
	    }
	    else if (remaining >= 0) {
	      //the body is not fully contained in this chunk
	      //will continue later
	      this.header = currentHeader;
	      this.bodyLength += remaining;
	      if (remaining > 0) {
	        //emit if there is at least a byte to emit
	        items.push({ header: currentHeader, chunk: chunk, offset: offset, frameEnded: false });
	      }
	      break;
	    }
	    currentHeader = null;
	  }
	  for (let i = 0; i < items.length; i++) {
	    this.push(items[i]);
	  }
	};

	Protocol.prototype.clearHeaderChunks = function () {
	  this.headerChunks = { byteLength: 0, parts: [] };
	};

	/**
	 * A stream that gets reads header + body chunks and transforms them into header + (row | error)
	 * @param {Object} streamOptions Node.js Stream options
	 * @param {Encoder} encoder Encoder instance for the parser to use
	 * @extends Transform
	 */
	function Parser (streamOptions, encoder) {
	  Transform.call(this, streamOptions);
	  //frames that are streaming, indexed by id
	  this.frames = {};
	  this.encoder = encoder;
	}

	util.inherits(Parser, Transform);

	Parser.prototype._transform = function (item, encoding, callback) {
	  const frameInfo = this.frameState(item);

	  let error = null;
	  try {
	    this.parseBody(frameInfo, item);
	  }
	  catch (err) {
	    error = err;
	  }
	  callback(error);

	  if (item.frameEnded) {
	    if (frameInfo.cellBuffer) {
	      //Frame was being streamed but an error force it to buffer the result
	      this.push({
	        header: frameInfo.header,
	        error: new errors.DriverInternalError('There was an problem while parsing streaming frame, opcode ' +
	          frameInfo.header.opcode)
	      });
	    }
	    //all the parsing finished and it was streamed down
	    //emit an item that signals it
	    this.push({ header: frameInfo.header, frameEnded: true});
	  }
	};

	/**
	 * @param frameInfo
	 * @param {{header: FrameHeader, chunk: Buffer, offset: Number}} item
	 */
	Parser.prototype.parseBody = function (frameInfo, item) {
	  frameInfo.isStreaming = frameInfo.byRow && item.header.opcode === types.opcodes.result;
	  if (!this.handleFrameBuffers(frameInfo, item)) {
	    // Frame isn't complete and we are not streaming the frame
	    return;
	  }
	  const reader = new FrameReader(item.header, item.chunk, item.offset);
	  // Check that flags have not been parsed yet for this frame
	  if (frameInfo.flagsInfo === undefined) {
	    const originalOffset = reader.offset;
	    try {
	      frameInfo.flagsInfo = reader.readFlagsInfo();
	    }
	    catch (e) {
	      return this.handleParsingError(e, frameInfo, reader, originalOffset);
	    }
	  }

	  //All the body for most operations is already buffered at this stage
	  //Except for RESULT
	  switch (item.header.opcode) {
	    case types.opcodes.result:
	      return this.parseResult(frameInfo, reader);
	    case types.opcodes.ready:
	    case types.opcodes.authSuccess:
	      return this.push({ header: frameInfo.header, ready: true });
	    case types.opcodes.authChallenge:
	      return this.push({ header: frameInfo.header, authChallenge: true, token: reader.readBytes()});
	    case types.opcodes.authenticate:
	      return this.push({ header: frameInfo.header, mustAuthenticate: true, authenticatorName: reader.readString()});
	    case types.opcodes.error:
	      return this.push({ header: frameInfo.header, error: reader.readError()});
	    case types.opcodes.supported:
	      return this.push({ header: frameInfo.header, supported: reader.readStringMultiMap()});
	    case types.opcodes.event:
	      return this.push({ header: frameInfo.header, event: reader.readEvent()});
	    default:
	      return this.push({ header: frameInfo.header, error: new Error('Received invalid opcode: ' + item.header.opcode) });
	  }
	};

	/**
	 * Buffers if needed and returns true if it has all the necessary data to continue parsing the frame.
	 * @param frameInfo
	 * @param {{header: FrameHeader, chunk: Buffer, offset: Number}} item
	 * @returns {Boolean}
	 */
	Parser.prototype.handleFrameBuffers = function (frameInfo, item) {
	  if (!frameInfo.isStreaming) {
	    // Handle buffering for complete frame bodies
	    const currentLength = (frameInfo.bufferLength || 0) + item.chunk.length - item.offset;
	    if (currentLength < item.header.bodyLength) {
	      //buffer until the frame is completed
	      this.addFrameBuffer(frameInfo, item);
	      return false;
	    }
	    //We have received the full frame body
	    if (frameInfo.buffers) {
	      item.chunk = this.getFrameBuffer(frameInfo, item);
	      item.offset = 0;
	    }
	    return true;
	  }
	  if (frameInfo.cellBuffer) {
	    // Handle buffering for frame cells (row cells or metadata cells)
	    if (item.offset !== 0) {
	      throw new errors.DriverInternalError('Following chunks can not have an offset greater than zero');
	    }
	    frameInfo.cellBuffer.parts.push(item.chunk);
	    if (!frameInfo.cellBuffer.expectedLength) {
	      //Its a buffer outside a row cell (metadata or other)
	      if (frameInfo.cellBuffer.parts.length !== 2) {
	        throw new errors.DriverInternalError('Buffer for streaming frame can not contain more than 1 item');
	      }
	      item.chunk = Buffer.concat(frameInfo.cellBuffer.parts, frameInfo.cellBuffer.byteLength + item.chunk.length);
	      frameInfo.cellBuffer = null;
	      return true;
	    }
	    if (frameInfo.cellBuffer.expectedLength > frameInfo.cellBuffer.byteLength + item.chunk.length) {
	      //We still haven't got the cell data
	      frameInfo.cellBuffer.byteLength += item.chunk.length;
	      return false;
	    }
	    item.chunk = Buffer.concat(frameInfo.cellBuffer.parts, frameInfo.cellBuffer.byteLength + item.chunk.length);
	    frameInfo.cellBuffer = null;
	  }
	  return true;
	};

	/**
	 * Adds this chunk to the frame buffers.
	 * @param frameInfo
	 * @param {{header: FrameHeader, chunk: Buffer, offset: Number}} item
	 */
	Parser.prototype.addFrameBuffer = function (frameInfo, item) {
	  if (!frameInfo.buffers) {
	    frameInfo.buffers = [ item.chunk.slice(item.offset) ];
	    frameInfo.bufferLength = item.chunk.length - item.offset;
	    return;
	  }
	  if (item.offset > 0) {
	    throw new errors.DriverInternalError('Following chunks can not have an offset greater than zero');
	  }
	  frameInfo.buffers.push(item.chunk);
	  frameInfo.bufferLength += item.chunk.length;
	};

	/**
	 * Adds the last chunk and concatenates the frame buffers
	 * @param frameInfo
	 * @param {{header: FrameHeader, chunk: Buffer, offset: Number}} item
	 */
	Parser.prototype.getFrameBuffer = function (frameInfo, item) {
	  frameInfo.buffers.push(item.chunk);
	  const result = Buffer.concat(frameInfo.buffers, frameInfo.bodyLength);
	  frameInfo.buffers = null;
	  return result;
	};

	/**
	 * Tries to read the result in the body of a message
	 * @param frameInfo Frame information, header / metadata
	 * @param {FrameReader} reader
	 */
	Parser.prototype.parseResult = function (frameInfo, reader) {
	  let result;
	  // As we might be streaming and the frame buffer might not be complete,
	  // read the metadata and different types of result values in a try-catch.
	  // Store the reader position
	  const originalOffset = reader.offset;
	  try {
	    if (!frameInfo.meta) {
	      frameInfo.kind = reader.readInt();
	      // Spec 4.2.5
	      switch (frameInfo.kind) {
	        case types.resultKind.voidResult:
	          result = { header: frameInfo.header, flags: frameInfo.flagsInfo };
	          break;
	        case types.resultKind.rows:
	          // Parse the rows metadata, the rest of the response is going to be parsed afterwards
	          frameInfo.meta = reader.readMetadata(frameInfo.kind);
	          break;
	        case types.resultKind.setKeyspace:
	          result = { header: frameInfo.header, keyspaceSet: reader.readString(), flags: frameInfo.flagsInfo };
	          break;
	        case types.resultKind.prepared:
	        {
	          const preparedId = utils.copyBuffer(reader.readShortBytes());
	          frameInfo.meta = reader.readMetadata(frameInfo.kind);
	          result = { header: frameInfo.header, id: preparedId, meta: frameInfo.meta, flags: frameInfo.flagsInfo };
	          break;
	        }
	        case types.resultKind.schemaChange:
	          result = { header: frameInfo.header, schemaChange: reader.parseSchemaChange(), flags: frameInfo.flagsInfo };
	          break;
	        default:
	          throw errors.DriverInternalError('Unexpected result kind: ' + frameInfo.kind);
	      }
	    }
	  }
	  catch (e) {
	    return this.handleParsingError(e, frameInfo, reader, originalOffset);
	  }
	  if (result) {
	    if (frameInfo.emitted) {
	      // It may contain additional metadata and info that it's not being parsed
	      return;
	    }
	    frameInfo.emitted = true;
	    return this.push(result);
	  }
	  if (reader.remainingLength() > 0) {
	    this.parseRows(frameInfo, reader);
	  }
	};

	/**
	 * @param frameInfo
	 * @param {FrameReader} reader
	 */
	Parser.prototype.parseRows = function (frameInfo, reader) {
	  if (frameInfo.parsingError) {
	    //No more processing on this frame
	    return;
	  }
	  if (frameInfo.rowLength === undefined) {
	    try {
	      frameInfo.rowLength = reader.readInt();
	    }
	    catch (e) {
	      return this.handleParsingError(e, frameInfo, reader);
	    }
	  }
	  if (frameInfo.rowLength === 0) {
	    return this.push({
	      header: frameInfo.header,
	      result: { rows: utils.emptyArray, meta: frameInfo.meta, flags: frameInfo.flagsInfo }
	    });
	  }
	  const meta = frameInfo.meta;
	  frameInfo.rowIndex = frameInfo.rowIndex || 0;
	  for (let i = frameInfo.rowIndex; i < frameInfo.rowLength; i++) {
	    const rowOffset = reader.offset;
	    const row = new types.Row(meta.columns);
	    let cellBuffer;
	    for (let j = 0; j < meta.columns.length; j++ ) {
	      const c = meta.columns[j];
	      try {
	        cellBuffer = reader.readBytes();
	      }
	      catch (e) {
	        return this.handleParsingError(e, frameInfo, reader, rowOffset, i);
	      }
	      try {
	        row[c.name] = this.encoder.decode(cellBuffer, c.type);
	      }
	      catch (e) {
	        //Something went wrong while decoding, we are not going to be able to recover
	        return this.handleParsingError(e, frameInfo, null);
	      }
	    }
	    this.push({
	      header: frameInfo.header,
	      row: row,
	      meta: frameInfo.meta,
	      byRow: frameInfo.byRow,
	      length: frameInfo.rowLength,
	      flags: frameInfo.flagsInfo
	    });
	  }
	  if (frameInfo.byRow) {
	    // Use an event item to identify that all the streaming rows have finished processing
	    this.push({
	      header: frameInfo.header,
	      byRowCompleted: true,
	      meta: frameInfo.meta,
	      length: frameInfo.rowLength,
	      flags: frameInfo.flagsInfo
	    });
	  }
	};

	/**
	 * Sets parser options (ie: how to yield the results as they are parsed)
	 * @param {Number} id Id of the stream
	 * @param options
	 */
	Parser.prototype.setOptions = function (id, options) {
	  if (this.frames[id.toString()]) {
	    throw new types.DriverError('There was already state for this frame');
	  }
	  this.frames[id.toString()] = options;
	};

	/**
	 * Manually clears the frame options.
	 * This class already clears the provided options when the frame ends, so it's usually not required to invoke this
	 * method.
	 * When manually setting the options for continuous paging, it's possible that the frame options are set while
	 * it's being cancelled.
	 * @param {Number} id The streamId
	 */
	Parser.prototype.clearOptions = function (id) {
	  delete this.frames[id.toString()];
	};

	/**
	 * Gets the frame info from the internal state.
	 * In case it is not there, it creates it.
	 * In case the frame ended
	 */
	Parser.prototype.frameState = function (item) {
	  let frameInfo = this.frames[item.header.streamId];
	  if (!frameInfo) {
	    frameInfo = {};
	    if (!item.frameEnded) {
	      //store it in the frames
	      this.frames[item.header.streamId] = frameInfo;
	    }
	  }
	  else if (item.frameEnded) {
	    //if it was already stored, remove it
	    delete this.frames[item.header.streamId];
	  }
	  frameInfo.header = item.header;
	  return frameInfo;
	};

	/**
	 * Handles parsing error: pushing an error if its unexpected or buffer the cell if its streaming
	 * @param {Error} e
	 * @param frameInfo
	 * @param {FrameReader} reader
	 * @param {Number} [originalOffset]
	 * @param {Number} [rowIndex]
	 */
	Parser.prototype.handleParsingError = function (e, frameInfo, reader, originalOffset, rowIndex) {
	  if (reader && frameInfo.isStreaming && (e instanceof RangeError)) {
	    //A controlled error, buffer from offset and move on
	    return this.bufferResultCell(frameInfo, reader, originalOffset, rowIndex, e.expectedLength);
	  }
	  frameInfo.parsingError = true;
	  frameInfo.cellBuffer = null;
	  this.push({ header: frameInfo.header, error: e });
	};

	/**
	 * When streaming, it buffers data since originalOffset.
	 * @param frameInfo
	 * @param {FrameReader} reader
	 * @param {Number} [originalOffset]
	 * @param {Number} [rowIndex]
	 * @param {Number} [expectedLength]
	 */
	Parser.prototype.bufferResultCell = function (frameInfo, reader, originalOffset, rowIndex, expectedLength) {
	  if (!originalOffset && originalOffset !== 0) {
	    originalOffset = reader.offset;
	  }
	  frameInfo.rowIndex = rowIndex;
	  const buffer = reader.slice(originalOffset);
	  frameInfo.cellBuffer = {
	    parts: [ buffer ],
	    byteLength: buffer.length,
	    expectedLength: expectedLength
	  };
	};

	/**
	 * Represents a writable streams that emits results
	 */
	function ResultEmitter(options) {
	  Writable.call(this, options);
	  /**
	   * Stores the rows for frames that needs to be yielded as one result with many rows
	   */
	  this.rowBuffer = {};
	}

	util.inherits(ResultEmitter, Writable);

	ResultEmitter.prototype._write = function (item, encoding, callback) {
	  let error = null;
	  try {
	    this.each(item);
	  }
	  catch (err) {
	    error = err;
	  }
	  callback(error);
	};


	/**
	 * Analyzes the item and emit the corresponding event
	 */
	ResultEmitter.prototype.each = function (item) {
	  if (item.error || item.result) {
	    //Its either an error or an empty array rows
	    //no transformation needs to be made
	    return this.emit('result', item.header, item.error, item.result);
	  }
	  if (item.frameEnded) {
	    return this.emit('frameEnded', item.header);
	  }
	  if (item.lastContinuousPage) {
	    return this.emit('lastContinuousPage', item.header);
	  }
	  if (item.byRowCompleted) {
	    return this.emit('byRowCompleted', item.header, item.row, item.meta, item.flags);
	  }
	  if (item.byRow) {
	    //it should be yielded by row
	    return this.emit('row', item.header, item.row, item.meta, item.length, item.flags);
	  }
	  if (item.row) {
	    //it should be yielded as a result
	    //it needs to be buffered to an array of rows
	    return this.bufferAndEmit(item);
	  }
	  if (item.event) {
	    //its an event from Cassandra
	    return this.emit('nodeEvent', item.header, item.event);
	  }
	  //its a raw response (object with flags)
	  return this.emit('result', item.header, null, item);
	};

	/**
	 * Buffers the rows until the result set is completed and emits the result event.
	 */
	ResultEmitter.prototype.bufferAndEmit = function (item) {
	  let rows = this.rowBuffer[item.header.streamId];
	  if (!rows) {
	    rows = this.rowBuffer[item.header.streamId] = [];
	  }
	  rows.push(item.row);
	  if (rows.length === item.length) {
	    this.emit('result', item.header, null, { rows: rows, meta: item.meta, flags: item.flags});
	    delete this.rowBuffer[item.header.streamId];
	  }
	};

	streams$1.Protocol = Protocol;
	streams$1.Parser = Parser;
	streams$1.ResultEmitter = ResultEmitter;
	return streams$1;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var streamIdStack;
var hasRequiredStreamIdStack;

function requireStreamIdStack () {
	if (hasRequiredStreamIdStack) return streamIdStack;
	hasRequiredStreamIdStack = 1;

	const types = requireTypes$2();

	/**
	 * Group size
	 * @type {number}
	 */
	const groupSize = 128;

	/**
	 * Number used to right shift ids to allocate them into groups
	 * @const
	 * @type {number}
	 */
	const shiftToGroup = 7;

	/**
	 * Amount of groups that can be released per time
	 * If it grows larger than 4 groups (128 * 4), groups can be released
	 * @const
	 * @type {number}
	 */
	const releasableSize = 4;

	/**
	 * 32K possible stream ids depending for protocol v3 and above
	 * @const
	 * @type {number}
	 */
	const maxGroupsFor2Bytes = 256;

	/**
	 * Delay used to check if groups can be released
	 * @const
	 * @type {number}
	 */
	const defaultReleaseDelay = 5000;

	/**
	 * Represents a queue of ids from 0 to maximum stream id supported by the protocol version.
	 * Clients can dequeue a stream id using {@link StreamIdStack#shift()} and enqueue (release) using
	 * {@link StreamIdStack#push()}
	 */
	class StreamIdStack {
	  /**
	   * Creates a new instance of StreamIdStack.
	   * @param {number} version Protocol version
	   * @constructor
	   */
	  constructor(version) {
	    //Ecmascript Number is 64-bit double, it can be optimized by the engine into a 32-bit int, but nothing below that.
	    //We try to allocate as few as possible in arrays of 128
	    this.currentGroup = generateGroup(0);
	    this.groupIndex = 0;
	    this.groups = [this.currentGroup];
	    this.releaseTimeout = null;
	    this.setVersion(version);
	    /**
	     * Returns the amount of ids currently in use
	     * @member {number}
	     */
	    this.inUse = 0;
	    this.releaseDelay = defaultReleaseDelay;
	  }

	  /**
	   * Sets the protocol version
	   * @param {Number} version
	   */
	  setVersion(version) {
	    //128 or 32K stream ids depending on the protocol version
	    this.maxGroups = types.protocolVersion.uses2BytesStreamIds(version) ? maxGroupsFor2Bytes : 1;
	  }

	  /**
	   * Dequeues an id.
	   * Similar to {@link Array#pop()}.
	   * @returns {Number} Returns an id or null
	   */
	  pop() {
	    let id = this.currentGroup.pop();
	    if (typeof id !== 'undefined') {
	      this.inUse++;
	      return id;
	    }
	    //try to use the following groups
	    while (this.groupIndex < this.groups.length - 1) {
	      //move to the following group
	      this.currentGroup = this.groups[++this.groupIndex];
	      //try dequeue
	      id = this.currentGroup.pop();
	      if (typeof id !== 'undefined') {
	        this.inUse++;
	        return id;
	      }
	    }
	    return this._tryCreateGroup();
	  }

	  /**
	   * Enqueue an id for future use.
	   * Similar to {@link Array#push()}.
	   * @param {Number} id
	   */
	  push(id) {
	    this.inUse--;
	    const groupIndex = id >> shiftToGroup;
	    const group = this.groups[groupIndex];
	    group.push(id);
	    if (groupIndex < this.groupIndex) {
	      //Set the lower group to be used to dequeue from
	      this.groupIndex = groupIndex;
	      this.currentGroup = group;
	    }
	    this._tryIssueRelease();
	  }

	  /**
	   * Clears all timers
	   */
	  clear() {
	    if (this.releaseTimeout) {
	      clearTimeout(this.releaseTimeout);
	      this.releaseTimeout = null;
	    }
	  }

	  /**
	   * Tries to create an additional group and returns a new id
	   * @returns {Number} Returns a new id or null if it's not possible to create a new group
	   * @private
	   */
	  _tryCreateGroup() {
	    if (this.groups.length === this.maxGroups) {
	      //we can have an additional group
	      return null;
	    }
	    //Add a new group at the last position
	    this.groupIndex = this.groups.length;
	    //Using 128 * groupIndex as initial value
	    this.currentGroup = generateGroup(this.groupIndex << shiftToGroup);
	    this.groups.push(this.currentGroup);
	    this.inUse++;
	    return this.currentGroup.pop();
	  }

	  _tryIssueRelease() {
	    if (this.releaseTimeout || this.groups.length <= releasableSize) {
	      //Nothing to release or a release delay has been issued
	      return;
	    }

	    this.releaseTimeout = setTimeout(() => this._releaseGroups(), this.releaseDelay);
	  }

	  _releaseGroups() {
	    let counter = 0;
	    let index = this.groups.length - 1;
	    //only release up to n groups (n = releasable size)
	    //shrink back up to n groups not all the way up to 1
	    while (counter++ < releasableSize && this.groups.length > releasableSize && index > this.groupIndex) {
	      if (this.groups[index].length !== groupSize) {
	        //the group is being used
	        break;
	      }
	      this.groups.pop();
	      index--;
	    }
	    this.releaseTimeout = null;
	    //Issue next release if applies
	    this._tryIssueRelease();
	  }
	}

	function generateGroup(initialValue) {
	  const arr = new Array(groupSize);
	  const upperBound = initialValue + groupSize - 1;
	  for (let i = 0; i < groupSize; i++) {
	    arr[i] = upperBound - i;
	  }
	  return arr;
	}

	streamIdStack = StreamIdStack;
	return streamIdStack;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var operationState;
var hasRequiredOperationState;

function requireOperationState () {
	if (hasRequiredOperationState) return operationState;
	hasRequiredOperationState = 1;

	const util = require$$0$6;
	const utils = requireUtils$c();
	const errors = requireErrors$c();
	const requests = requireRequests();
	const ExecuteRequest = requests.ExecuteRequest;
	const QueryRequest = requests.QueryRequest;

	const state = {
	  init: 0,
	  completed: 1,
	  timedOut: 2,
	  cancelled: 3
	};

	/**
	 * Maintains the state information of a request inside a Connection.
	 */
	class OperationState {
	  /**
	   * Creates a new instance of OperationState.
	   * @param {Request} request
	   * @param {Function} rowCallback
	   * @param {Function} callback
	   */
	  constructor(request, rowCallback, callback) {
	    this.request = request;
	    this._rowCallback = rowCallback;
	    this._callback = callback;
	    this._timeout = null;
	    this._state = state.init;
	    this._rowIndex = 0;
	    /**
	     * Stream id that is set right before being written.
	     * @type {number}
	     */
	    this.streamId = -1;
	  }

	  /**
	   * Marks the operation as cancelled, clearing all callbacks and timeouts.
	   */
	  cancel() {
	    if (this._state !== state.init) {
	      return;
	    }
	    if (this._timeout !== null) {
	      clearTimeout(this._timeout);
	    }
	    this._state = state.cancelled;
	    this._callback = utils.noop;
	  }

	  /**
	   * Determines if the operation can be written to the wire (when it hasn't been cancelled or it hasn't timed out).
	   */
	  canBeWritten() {
	    return this._state === state.init;
	  }

	  /**
	   * Determines if the response is going to be yielded by row.
	   * @return {boolean}
	   */
	  isByRow() {
	    return this._rowCallback && (this.request instanceof ExecuteRequest || this.request instanceof QueryRequest);
	  }

	  /**
	   * Creates the timeout for the request.
	   * @param {ExecutionOptions} execOptions
	   * @param {Number} defaultReadTimeout
	   * @param {String} address
	   * @param {Function} onTimeout The callback to be invoked when it times out.
	   * @param {Function} onResponse The callback to be invoked if a response is obtained after it timed out.
	   */
	  setRequestTimeout(execOptions, defaultReadTimeout, address, onTimeout, onResponse) {
	    if (this._state !== state.init) {
	      // No need to set the timeout
	      return;
	    }
	    const millis = execOptions.getReadTimeout() !== undefined ? execOptions.getReadTimeout() : defaultReadTimeout;
	    if (!(millis > 0)) {
	      // Read timeout disabled
	      return;
	    }
	    const self = this;
	    this._timeout = setTimeout(function requestTimedOut() {
	      onTimeout();
	      const message = util.format('The host %s did not reply before timeout %d ms', address, millis);
	      self._markAsTimedOut(new errors.OperationTimedOutError(message, address), onResponse);
	    }, millis);
	  }

	  setResultRow(row, meta, rowLength, flags, header) {
	    this._markAsCompleted();
	    if (!this._rowCallback) {
	      return this.setResult(new errors.DriverInternalError('RowCallback not found for streaming frame handler'));
	    }
	    this._rowCallback(this._rowIndex++, row, rowLength);
	    if (this._rowIndex === rowLength) {
	      this._swapCallbackAndInvoke(null, { rowLength: rowLength, meta: meta, flags: flags }, header.bodyLength);
	    }
	  }

	  /**
	   * Marks the current operation as timed out.
	   * @param {Error} err
	   * @param {Function} onResponse
	   * @private
	   */
	  _markAsTimedOut(err, onResponse) {
	    if (this._state !== state.init) {
	      return;
	    }
	    this._state = state.timedOut;
	    this._swapCallbackAndInvoke(err, null, null, onResponse);
	  }

	  _markAsCompleted() {
	    if (this._state !== state.init) {
	      return;
	    }
	    if (this._timeout !== null) {
	      clearTimeout(this._timeout);
	    }
	    this._state = state.completed;
	  }

	  /**
	   * Sets the result of this operation, declaring that no further input will be processed for this operation.
	   * @param {Error} err
	   * @param {Object} [result]
	   * @param {Number} [length]
	   */
	  setResult(err, result, length) {
	    this._markAsCompleted();
	    this._swapCallbackAndInvoke(err, result, length);
	  }

	  _swapCallbackAndInvoke(err, result, length, newCallback) {
	    const callback = this._callback;
	    this._callback = newCallback || utils.noop;
	    callback(err, result, length);
	  }
	}

	operationState = OperationState;
	return operationState;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var connection$6;
var hasRequiredConnection$6;

function requireConnection$6 () {
	if (hasRequiredConnection$6) return connection$6;
	hasRequiredConnection$6 = 1;

	const events = require$$0$8;
	const util = require$$0$6;
	const tls = require$$1$1;
	const net = require$$0$7;

	const Encoder = requireEncoder$1();
	const { WriteQueue } = requireWriters();
	const requests = requireRequests();
	const streams = requireStreams$1();
	const utils = requireUtils$c();
	const types = requireTypes$2();
	const errors = requireErrors$c();
	const StreamIdStack = requireStreamIdStack();
	const OperationState = requireOperationState();
	const promiseUtils = requirePromiseUtils();
	const { ExecutionOptions } = requireExecutionOptions();

	/**
	 * Represents a connection to a Cassandra node
	 */
	class Connection extends events.EventEmitter {

	  /**
	   * Creates a new instance of Connection.
	   * @param {String} endpoint An string containing ip address and port of the host
	   * @param {Number|null} protocolVersion
	   * @param {ClientOptions} options
	   */
	  constructor(endpoint, protocolVersion, options) {
	    super();

	    this.setMaxListeners(0);

	    if (!options) {
	      throw new Error('options is not defined');
	    }

	    /**
	     * Gets the ip and port of the server endpoint.
	     * @type {String}
	     */
	    this.endpoint = endpoint;

	    /**
	     * Gets the friendly name of the host, used to identify the connection in log messages.
	     * With direct connect, this is the address and port.
	     * With SNI, this will be the address and port of the proxy, plus the server name.
	     * @type {String}
	     */
	    this.endpointFriendlyName = this.endpoint;

	    if (options.sni) {
	      this._serverName = endpoint;
	      this.endpoint = `${options.sni.addressResolver.getIp()}:${options.sni.port}`;
	      this.endpointFriendlyName = `${this.endpoint} (${this._serverName})`;
	    }

	    if (!this.endpoint || this.endpoint.indexOf(':') < 0) {
	      throw new Error('EndPoint must contain the ip address and port separated by : symbol');
	    }

	    const portSeparatorIndex = this.endpoint.lastIndexOf(':');
	    this.address = this.endpoint.substr(0, portSeparatorIndex);
	    this.port = this.endpoint.substr(portSeparatorIndex + 1);

	    Object.defineProperty(this, "options", { value: options, enumerable: false, writable: false});

	    if (protocolVersion === null) {
	      // Set initial protocol version
	      protocolVersion = types.protocolVersion.maxSupported;
	      if (options.protocolOptions.maxVersion) {
	        // User provided the protocol version
	        protocolVersion = options.protocolOptions.maxVersion;
	      }
	      // Allow to check version using this connection instance
	      this._checkingVersion = true;
	    }

	    this.log = utils.log;
	    this.protocolVersion = protocolVersion;
	    this._operations = new Map();
	    this._pendingWrites = [];
	    this._preparing = new Map();

	    /**
	     * The timeout state for the idle request (heartbeat)
	     */
	    this._idleTimeout = null;
	    this.timedOutOperations = 0;
	    this._streamIds = new StreamIdStack(this.protocolVersion);
	    this._metrics = options.metrics;

	    this.encoder = new Encoder(protocolVersion, options);
	    this.keyspace = null;
	    this.emitDrain = false;
	    /**
	     * Determines if the socket is open and startup succeeded, whether the connection can be used to send requests /
	     * receive events
	     */
	    this.connected = false;
	    /**
	     * Determines if the socket can be considered as open
	     */
	    this.isSocketOpen = false;

	    this.send = util.promisify(this.sendStream);
	    this.closeAsync = util.promisify(this.close);
	    this.openAsync = util.promisify(this.open);
	    this.prepareOnceAsync = util.promisify(this.prepareOnce);
	  }

	  /**
	   * Binds the necessary event listeners for the socket
	   */
	  bindSocketListeners() {
	    //Remove listeners that were used for connecting
	    this.netClient.removeAllListeners('connect');
	    this.netClient.removeAllListeners('timeout');
	    // The socket is expected to be open at this point
	    this.isSocketOpen = true;
	    this.netClient.on('close', () => {
	      this.log('info', `Connection to ${this.endpointFriendlyName} closed`);
	      this.isSocketOpen = false;
	      const wasConnected = this.connected;
	      this.close();
	      if (wasConnected) {
	        // Emit only when it was closed unexpectedly
	        this.emit('socketClose');
	      }
	    });

	    this.protocol = new streams.Protocol({ objectMode: true });
	    this.parser = new streams.Parser({ objectMode: true }, this.encoder);
	    const resultEmitter = new streams.ResultEmitter({objectMode: true});
	    resultEmitter.on('result', this.handleResult.bind(this));
	    resultEmitter.on('row', this.handleRow.bind(this));
	    resultEmitter.on('frameEnded', this.freeStreamId.bind(this));
	    resultEmitter.on('nodeEvent', this.handleNodeEvent.bind(this));

	    this.netClient
	      .pipe(this.protocol)
	      .pipe(this.parser)
	      .pipe(resultEmitter);

	    this.writeQueue = new WriteQueue(this.netClient, this.encoder, this.options);
	  }

	  /**
	   * Connects a socket and sends the startup protocol messages.
	   * Note that when open() callbacks in error, the caller should immediately call {@link Connection#close}.
	   */
	  open(callback) {
	    const self = this;
	    this.log('info', `Connecting to ${this.endpointFriendlyName}`);

	    if (!this.options.sslOptions) {
	      this.netClient = new net.Socket({ highWaterMark: this.options.socketOptions.coalescingThreshold });
	      this.netClient.connect(this.port, this.address, function connectCallback() {
	        self.log('verbose', `Socket connected to ${self.endpointFriendlyName}`);
	        self.bindSocketListeners();
	        self.startup(callback);
	      });
	    }
	    else {
	      // Use TLS
	      const sslOptions = utils.extend({ rejectUnauthorized: false }, this.options.sslOptions);

	      if (this.options.sni) {
	        sslOptions.servername = this._serverName;
	      }

	      this.netClient = tls.connect(this.port, this.address, sslOptions, function tlsConnectCallback() {
	        self.log('verbose', `Secure socket connected to ${self.endpointFriendlyName} with protocol ${self.netClient.getProtocol()}`);
	        self.bindSocketListeners();
	        self.startup(callback);
	      });

	      // TLSSocket will validate for values from 512 to 16K (depending on the SSL protocol version)
	      this.netClient.setMaxSendFragment(this.options.socketOptions.coalescingThreshold);
	    }

	    this.netClient.once('error', function socketError(err) {
	      self.errorConnecting(err, false, callback);
	    });

	    this.netClient.once('timeout', function connectTimedOut() {
	      const err = new types.DriverError('Connection timeout');
	      self.errorConnecting(err, true, callback);
	    });

	    this.netClient.setTimeout(this.options.socketOptions.connectTimeout);

	    // Improve failure detection with TCP keep-alives
	    if (this.options.socketOptions.keepAlive) {
	      this.netClient.setKeepAlive(true, this.options.socketOptions.keepAliveDelay);
	    }

	    this.netClient.setNoDelay(!!this.options.socketOptions.tcpNoDelay);
	  }

	  /**
	   * Determines the protocol version to use and sends the STARTUP request
	   * @param {Function} callback
	   */
	  startup(callback) {
	    if (this._checkingVersion) {
	      this.log('info', 'Trying to use protocol version 0x' + this.protocolVersion.toString(16));
	    }

	    const self = this;
	    const request = new requests.StartupRequest({
	      noCompact: this.options.protocolOptions.noCompact,
	      clientId: this.options.id,
	      applicationName: this.options.applicationName,
	      applicationVersion: this.options.applicationVersion
	    });

	    this.sendStream(request, null, function responseCallback(err, response) {
	      if (err && self._checkingVersion) {
	        let invalidProtocol = (err instanceof errors.ResponseError &&
	          err.code === types.responseErrorCodes.protocolError &&
	          err.message.indexOf('Invalid or unsupported protocol version') >= 0);

	        if (!invalidProtocol && types.protocolVersion.canStartupResponseErrorBeWrapped(self.protocolVersion)) {
	          //For some versions of Cassandra, the error is wrapped into a server error
	          //See CASSANDRA-9451
	          invalidProtocol = (err instanceof errors.ResponseError &&
	            err.code === types.responseErrorCodes.serverError &&
	            err.message.indexOf('ProtocolException: Invalid or unsupported protocol version') > 0);
	        }

	        if (invalidProtocol) {
	          // The server can respond with a message using the lower protocol version supported
	          // or using the same version as the one provided
	          let lowerVersion = self.protocol.version;

	          if (lowerVersion === self.protocolVersion) {
	            lowerVersion = types.protocolVersion.getLowerSupported(self.protocolVersion);
	          } else if (!types.protocolVersion.isSupported(self.protocol.version)) {
	            // If we have an unsupported protocol version or a beta version we need to switch
	            // to something we can support.  Note that dseV1 and dseV2 are excluded from this
	            // logic as they are supported.  Also note that any v5 and greater beta protocols
	            // are included here since the beta flag was introduced in v5.
	            self.log('info',`Protocol version ${self.protocol.version} not supported by this driver, downgrading`);
	            lowerVersion = types.protocolVersion.getLowerSupported(self.protocol.version);
	          }

	          if (!lowerVersion) {
	            return startupCallback(
	              new Error('Connection was unable to STARTUP using protocol version ' + self.protocolVersion));
	          }

	          self.log('info', 'Protocol 0x' + self.protocolVersion.toString(16) + ' not supported, using 0x' + lowerVersion.toString(16));
	          self.decreaseVersion(lowerVersion);

	          // The host closed the connection, close the socket and start the connection flow again
	          setImmediate(function decreasingVersionClosing() {
	            self.close(function decreasingVersionOpening() {
	              // Attempt to open with the correct protocol version
	              self.open(callback);
	            });
	          });

	          return;
	        }
	      }

	      if (response && response.mustAuthenticate) {
	        return self.startAuthenticating(response.authenticatorName, startupCallback);
	      }

	      startupCallback(err);
	    });

	    function startupCallback(err) {
	      if (err) {
	        return self.errorConnecting(err, false, callback);
	      }
	      //The socket is connected and the connection is authenticated
	      return self.connectionReady(callback);
	    }
	  }

	  errorConnecting(err, destroy, callback) {
	    this.log('warning', `There was an error when trying to connect to the host ${this.endpointFriendlyName}`, err);
	    if (destroy) {
	      //there is a TCP connection that should be killed.
	      this.netClient.destroy();
	    }

	    this._metrics.onConnectionError(err);

	    callback(err);
	  }

	  /**
	   * Sets the connection to ready/connected status
	   */
	  connectionReady(callback) {
	    this.emit('connected');
	    this.connected = true;
	    // Remove existing error handlers as the connection is now ready.
	    this.netClient.removeAllListeners('error');
	    this.netClient.on('error', this.handleSocketError.bind(this));
	    callback();
	  }

	  /** @param {Number} lowerVersion */
	  decreaseVersion(lowerVersion) {
	    // The response already has the max protocol version supported by the Cassandra host.
	    this.protocolVersion = lowerVersion;
	    this.encoder.setProtocolVersion(lowerVersion);
	    this._streamIds.setVersion(lowerVersion);
	  }

	  /**
	   * Handle socket errors, if the socket is not readable invoke all pending callbacks
	   */
	  handleSocketError(err) {
	    this._metrics.onConnectionError(err);
	    this.clearAndInvokePending(err);
	  }

	  /**
	   * Cleans all internal state and invokes all pending callbacks of sent streams
	   */
	  clearAndInvokePending(innerError) {
	    if (this._idleTimeout) {
	      //Remove the idle request
	      clearTimeout(this._idleTimeout);
	      this._idleTimeout = null;
	    }
	    this._streamIds.clear();
	    if (this.emitDrain) {
	      this.emit('drain');
	    }
	    const err = new types.DriverError('Socket was closed');
	    err.isSocketError = true;
	    if (innerError) {
	      err.innerError = innerError;
	    }

	    // Get all handlers
	    const operations = Array.from(this._operations.values());
	    // Clear pending operation map
	    this._operations = new Map();

	    if (operations.length > 0) {
	      this.log('info', 'Invoking ' + operations.length + ' pending callbacks');
	    }

	    // Invoke all handlers
	    utils.each(operations, function (operation, next) {
	      operation.setResult(err);
	      next();
	    });

	    const pendingWritesCopy = this._pendingWrites;
	    this._pendingWrites = [];
	    utils.each(pendingWritesCopy, function (operation, next) {
	      operation.setResult(err);
	      next();
	    });
	  }

	  /**
	   * Starts the SASL flow
	   * @param {String} authenticatorName
	   * @param {Function} callback
	   */
	  startAuthenticating(authenticatorName, callback) {
	    if (!this.options.authProvider) {
	      return callback(new errors.AuthenticationError('Authentication provider not set'));
	    }
	    const authenticator = this.options.authProvider.newAuthenticator(this.endpoint, authenticatorName);
	    const self = this;
	    authenticator.initialResponse(function initialResponseCallback(err, token) {
	      // Start the flow with the initial token
	      if (err) {
	        return self.onAuthenticationError(callback, err);
	      }
	      self.authenticate(authenticator, token, callback);
	    });
	  }

	  /**
	   * Handles authentication requests and responses.
	   * @param {Authenticator} authenticator
	   * @param {Buffer} token
	   * @param {Function} callback
	   */
	  authenticate(authenticator, token, callback) {
	    const self = this;
	    let request = new requests.AuthResponseRequest(token);
	    if (this.protocolVersion === 1) {
	      //No Sasl support, use CREDENTIALS
	      if (!authenticator.username) {
	        return self.onAuthenticationError(
	          callback, new errors.AuthenticationError('Only plain text authenticator providers allowed under protocol v1'));
	      }

	      request = new requests.CredentialsRequest(authenticator.username, authenticator.password);
	    }

	    this.sendStream(request, null, function authResponseCallback(err, result) {
	      if (err) {
	        if (err instanceof errors.ResponseError && err.code === types.responseErrorCodes.badCredentials) {
	          const authError = new errors.AuthenticationError(err.message);
	          authError.additionalInfo = err;
	          err = authError;
	        }
	        return self.onAuthenticationError(callback, err);
	      }

	      if (result.ready) {
	        authenticator.onAuthenticationSuccess();
	        return callback();
	      }

	      if (result.authChallenge) {
	        return authenticator.evaluateChallenge(result.token, function evaluateCallback(err, t) {
	          if (err) {
	            return self.onAuthenticationError(callback, err);
	          }
	          //here we go again
	          self.authenticate(authenticator, t, callback);
	        });
	      }

	      callback(new errors.DriverInternalError('Unexpected response from Cassandra: ' + util.inspect(result)));
	    });
	  }

	  onAuthenticationError(callback, err) {
	    this._metrics.onAuthenticationError(err);
	    callback(err);
	  }

	  /**
	   * Executes a 'USE ' query, if keyspace is provided and it is different from the current keyspace
	   * @param {?String} keyspace
	   */
	  async changeKeyspace(keyspace) {
	    if (!keyspace || this.keyspace === keyspace) {
	      return;
	    }

	    if (this.toBeKeyspace === keyspace) {
	      // It will be invoked once the keyspace is changed
	      return promiseUtils.fromEvent(this, 'keyspaceChanged');
	    }

	    this.toBeKeyspace = keyspace;

	    const query = `USE "${keyspace}"`;

	    try {
	      await this.send(new requests.QueryRequest(query, null, null), null);
	      this.keyspace = keyspace;
	      this.emit('keyspaceChanged', null, keyspace);
	    } catch (err) {
	      this.log('error', `Connection to ${this.endpointFriendlyName} could not switch active keyspace: ${err}`, err);
	      this.emit('keyspaceChanged', err);
	      throw err;
	    } finally {
	      this.toBeKeyspace = null;
	    }
	  }

	  /**
	   * Prepares a query on a given connection. If its already being prepared, it queues the callback.
	   * @param {String} query
	   * @param {String} keyspace
	   * @param {function} callback
	   */
	  prepareOnce(query, keyspace, callback) {
	    const name = ( keyspace || '' ) + query;
	    let info = this._preparing.get(name);

	    if (info) {
	      // Its being already prepared
	      return info.once('prepared', callback);
	    }

	    info = new events.EventEmitter();
	    info.setMaxListeners(0);
	    info.once('prepared', callback);
	    this._preparing.set(name, info);

	    this.sendStream(new requests.PrepareRequest(query, keyspace), null, (err, response) => {
	      info.emit('prepared', err, response);
	      this._preparing.delete(name);
	    });
	  }

	  /**
	   * Queues the operation to be written to the wire and invokes the callback once the response was obtained or with an
	   * error (socket error or OperationTimedOutError or serialization-related error).
	   * @param {Request} request
	   * @param {ExecutionOptions|null} execOptions
	   * @param {function} callback Function to be called once the response has been received
	   * @return {OperationState}
	   */
	  sendStream(request, execOptions, callback) {
	    execOptions = execOptions || ExecutionOptions.empty();

	    // Create a new operation that will contain the request, callback and timeouts
	    const operation = new OperationState(request, execOptions.getRowCallback(), (err, response, length) => {
	      if (!err || !err.isSocketError) {
	        // Emit that a response was obtained when there is a valid response
	        // or when the error is not a socket error
	        this.emit('responseDequeued');
	      }
	      callback(err, response, length);
	    });

	    const streamId = this._getStreamId();

	    // Start the request timeout without waiting for the request to be written
	    operation.setRequestTimeout(execOptions, this.options.socketOptions.readTimeout, this.endpoint,
	      () => this.timedOutOperations++,
	      () => this.timedOutOperations--);

	    if (streamId === null) {
	      this.log('info',
	        'Enqueuing ' +
	        this._pendingWrites.length +
	        ', if this message is recurrent consider configuring more connections per host or lowering the pressure');
	      this._pendingWrites.push(operation);
	      return operation;
	    }
	    this._write(operation, streamId);
	    return operation;
	  }

	  /**
	   * Pushes the item into the queue.
	   * @param {OperationState} operation
	   * @param {Number} streamId
	   * @private
	   */
	  _write(operation, streamId) {
	    operation.streamId = streamId;
	    const self = this;
	    this.writeQueue.push(operation, function writeCallback (err) {
	      if (err) {
	        // The request was not written.
	        // There was a serialization error or the operation has already timed out or was cancelled
	        self._streamIds.push(streamId);
	        return operation.setResult(err);
	      }
	      self.log('verbose', 'Sent stream #' + streamId + ' to ' + self.endpointFriendlyName);
	      if (operation.isByRow()) {
	        self.parser.setOptions(streamId, { byRow: true });
	      }
	      self._setIdleTimeout();
	      self._operations.set(streamId, operation);
	    });
	  }

	  _setIdleTimeout() {
	    if (!this.options.pooling.heartBeatInterval) {
	      return;
	    }
	    const self = this;
	    // Scheduling the new timeout before de-scheduling the previous performs significantly better
	    // than de-scheduling first, see nodejs implementation: https://github.com/nodejs/node/blob/master/lib/timers.js
	    const previousTimeout = this._idleTimeout;
	    self._idleTimeout = setTimeout(() => self._idleTimeoutHandler(), self.options.pooling.heartBeatInterval);
	    if (previousTimeout) {
	      //remove the previous timeout for the idle request
	      clearTimeout(previousTimeout);
	    }
	  }

	  /**
	   * Function that gets executed once the idle timeout has passed to issue a request to keep the connection alive
	   */
	  _idleTimeoutHandler() {
	    if (this.sendingIdleQuery) {
	      //don't issue another
	      //schedule for next time
	      this._idleTimeout = setTimeout(() => this._idleTimeoutHandler(), this.options.pooling.heartBeatInterval);
	      return;
	    }

	    this.log('verbose', `Connection to ${this.endpointFriendlyName} idling, issuing a request to prevent disconnects`);
	    this.sendingIdleQuery = true;
	    this.sendStream(requests.options, null, (err) => {
	      this.sendingIdleQuery = false;
	      if (!err) {
	        //The sending succeeded
	        //There is a valid response but we don't care about the response
	        return;
	      }
	      this.log('warning', 'Received heartbeat request error', err);
	      this.emit('idleRequestError', err, this);
	    });
	  }

	  /**
	   * Returns an available streamId or null if there isn't any available
	   * @returns {Number}
	   */
	  _getStreamId() {
	    return this._streamIds.pop();
	  }

	  freeStreamId(header) {
	    const streamId = header.streamId;

	    if (streamId < 0) {
	      // Event ids don't have a matching request operation
	      return;
	    }

	    this._operations.delete(streamId);
	    this._streamIds.push(streamId);

	    if (this.emitDrain && this._streamIds.inUse === 0 && this._pendingWrites.length === 0) {
	      this.emit('drain');
	    }

	    this._writeNext();
	  }

	  _writeNext() {
	    if (this._pendingWrites.length === 0) {
	      return;
	    }
	    const streamId = this._getStreamId();
	    if (streamId === null) {
	      // No streamId available
	      return;
	    }
	    const self = this;
	    let operation;
	    while ((operation = this._pendingWrites.shift()) && !operation.canBeWritten()) {
	      // Trying to obtain an pending operation that can be written
	    }

	    if (!operation) {
	      // There isn't a pending operation that can be written
	      this._streamIds.push(streamId);
	      return;
	    }

	    // Schedule after current I/O callbacks have been executed
	    setImmediate(function writeNextPending() {
	      self._write(operation, streamId);
	    });
	  }

	  /**
	   * Returns the number of requests waiting for response
	   * @returns {Number}
	   */
	  getInFlight() {
	    return this._streamIds.inUse;
	  }

	  /**
	   * Handles a result and error response
	   */
	  handleResult(header, err, result) {
	    const streamId = header.streamId;
	    if(streamId < 0) {
	      return this.log('verbose', 'event received', header);
	    }
	    const operation = this._operations.get(streamId);
	    if (!operation) {
	      return this.log('error', 'The server replied with a wrong streamId #' + streamId);
	    }
	    this.log('verbose', 'Received frame #' + streamId + ' from ' + this.endpointFriendlyName);
	    operation.setResult(err, result, header.bodyLength);
	  }

	  handleNodeEvent(header, event) {
	    switch (event.eventType) {
	      case types.protocolEvents.schemaChange:
	        this.emit('nodeSchemaChange', event);
	        break;
	      case types.protocolEvents.topologyChange:
	        this.emit('nodeTopologyChange', event);
	        break;
	      case types.protocolEvents.statusChange:
	        this.emit('nodeStatusChange', event);
	        break;
	    }
	  }

	  /**
	   * Handles a row response
	   */
	  handleRow(header, row, meta, rowLength, flags) {
	    const streamId = header.streamId;
	    if(streamId < 0) {
	      return this.log('verbose', 'Event received', header);
	    }
	    const operation = this._operations.get(streamId);
	    if (!operation) {
	      return this.log('error', 'The server replied with a wrong streamId #' + streamId);
	    }
	    operation.setResultRow(row, meta, rowLength, flags, header);
	  }

	  /**
	   * Closes the socket (if not already closed) and cancels all in-flight requests.
	   * Multiple calls to this method have no additional side-effects.
	   * @param {Function} [callback]
	   */
	  close(callback) {
	    callback = callback || utils.noop;

	    if (!this.connected && !this.isSocketOpen) {
	      return callback();
	    }

	    this.connected = false;
	    // Drain is never going to be emitted, once it is set to closed
	    this.removeAllListeners('drain');
	    this.clearAndInvokePending();

	    if (!this.isSocketOpen) {
	      return callback();
	    }

	    // Set the socket as closed now (before socket.end() is called) to avoid being invoked more than once
	    this.isSocketOpen = false;
	    this.log('verbose', `Closing connection to ${this.endpointFriendlyName}`);
	    const self = this;

	    // If server doesn't acknowledge the half-close within connection timeout, destroy the socket.
	    const endTimeout = setTimeout(() => {
	      this.log('info', `${this.endpointFriendlyName} did not respond to connection close within ` +
	        `${this.options.socketOptions.connectTimeout}ms, destroying connection`);
	      this.netClient.destroy();
	    }, this.options.socketOptions.connectTimeout);

	    this.netClient.once('close', function (hadError) {
	      clearTimeout(endTimeout);
	      if (hadError) {
	        self.log('info', 'The socket closed with a transmission error');
	      }
	      setImmediate(callback);
	    });

	    // At this point, the error event can be triggered because:
	    // - It's connected and writes haven't completed yet
	    // - The server abruptly closed its end of the connection (ECONNRESET) as a result of protocol error / auth error
	    // We need to remove any listeners and make sure we callback are pending writes
	    this.netClient.removeAllListeners('error');
	    this.netClient.on('error', err => this.clearAndInvokePending(err));

	    // Half-close the socket, it will result in 'close' event being fired
	    this.netClient.end();
	  }

	  /**
	   * Gets the local IP address to which this connection socket is bound to.
	   * @returns {String|undefined}
	   */
	  getLocalAddress() {
	    if (!this.netClient) {
	      return undefined;
	    }

	    return this.netClient.localAddress;
	  }
	}

	connection$6 = Connection;
	return connection$6;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hostConnectionPool;
var hasRequiredHostConnectionPool;

function requireHostConnectionPool () {
	if (hasRequiredHostConnectionPool) return hostConnectionPool;
	hasRequiredHostConnectionPool = 1;
	const util = require$$0$6;
	const events = require$$0$8;

	const Connection = requireConnection$6();
	const utils = requireUtils$c();
	const promiseUtils = requirePromiseUtils();
	const errors = requireErrors$c();
	const clientOptions = requireClientOptions();

	// Used to get the index of the connection with less in-flight requests
	let connectionIndex = 0;
	const connectionIndexOverflow = Math.pow(2, 15);

	let defaultOptions;

	/**
	 * Represents the possible states of the pool.
	 * Possible state transitions:
	 *  - From initial to closing: The pool must be closed because the host is ignored.
	 *  - From initial to shuttingDown: The pool is being shutdown as a result of a client shutdown.
	 *  - From closing to initial state: The pool finished closing connections (is now ignored) and it resets to
	 *    initial state in case the host is marked as local/remote in the future.
	 *  - From closing to shuttingDown (rare): It was marked as ignored, now the client is being shutdown.
	 *  - From shuttingDown to shutdown: Finished shutting down, the pool should not be reused.
	 * @private
	 */
	const state = {
	  // Initial state: open / opening / ready to be opened
	  initial: 0,
	  // When the pool is being closed as part of a distance change
	  closing: 1,
	  // When the pool is being shutdown for good
	  shuttingDown: 2,
	  // When the pool has being shutdown
	  shutDown: 4
	};

	/**
	 * Represents a pool of connections to a host
	 */
	class HostConnectionPool extends events.EventEmitter {
	  /**
	   * Creates a new instance of HostConnectionPool.
	   * @param {Host} host
	   * @param {Number} protocolVersion Initial protocol version
	   * @extends EventEmitter
	   */
	  constructor(host, protocolVersion) {
	    super();
	    this._address = host.address;
	    this._newConnectionTimeout = null;
	    this._state = state.initial;
	    this._opening = false;
	    this._host = host;
	    this.responseCounter = 0;
	    this.options = host.options;
	    this.protocolVersion = protocolVersion;
	    this.coreConnectionsLength = 1;
	    /**
	     * An immutable array of connections
	     * @type {Array.<Connection>}
	     */
	    this.connections = utils.emptyArray;
	    this.setMaxListeners(0);
	    this.log = utils.log;
	  }

	  getInFlight() {
	    const length = this.connections.length;
	    if (length === 1) {
	      return this.connections[0].getInFlight();
	    }

	    let sum = 0;
	    for (let i = 0; i < length; i++) {
	      sum += this.connections[i].getInFlight();
	    }
	    return sum;
	  }

	  /**
	   * Gets the least busy connection from the pool.
	   * @param {Connection} [previousConnection] When provided, the pool should attempt to obtain a different connection.
	   * @returns {Connection!}
	   * @throws {Error}
	   * @throws {BusyConnectionError}
	   */
	  borrowConnection(previousConnection) {
	    if (this.connections.length === 0) {
	      throw new Error('No connection available');
	    }

	    const maxRequests = this.options.pooling.maxRequestsPerConnection;
	    const c = HostConnectionPool.minInFlight(this.connections, maxRequests, previousConnection);

	    if (c.getInFlight() >= maxRequests) {
	      throw new errors.BusyConnectionError(this._address, maxRequests, this.connections.length);
	    }

	    return c;
	  }

	  /**
	   * Gets the connection with the minimum number of in-flight requests.
	   * Only checks for 2 connections (round-robin) and gets the one with minimum in-flight requests, as long as
	   * the amount of in-flight requests is lower than maxRequests.
	   * @param {Array.<Connection>} connections
	   * @param {Number} maxRequests
	   * @param {Connection} previousConnection When provided, it will attempt to obtain a different connection.
	   * @returns {Connection!}
	   */
	  static minInFlight(connections, maxRequests, previousConnection) {
	    const length = connections.length;
	    if (length === 1) {
	      return connections[0];
	    }

	    // Use a single index for all hosts as a simplified way to balance the load between connections
	    connectionIndex++;
	    if (connectionIndex >= connectionIndexOverflow) {
	      connectionIndex = 0;
	    }

	    let current;
	    for (let index = connectionIndex; index < connectionIndex + length; index++) {
	      current = connections[index % length];
	      if (current === previousConnection) {
	        // Increment the index and skip
	        current = connections[(++index) % length];
	      }

	      let next = connections[(index + 1) % length];
	      if (next === previousConnection) {
	        // Skip
	        next = connections[(index + 2) % length];
	      }

	      if (next.getInFlight() < current.getInFlight()) {
	        current = next;
	      }

	      if (current.getInFlight() < maxRequests) {
	        // Check as few connections as possible, as long as the amount of in-flight
	        // requests is lower than maxRequests
	        break;
	      }
	    }
	    return current;
	  }

	  /**
	   * Creates all the connections in the pool and switches the keyspace of each connection if needed.
	   * @param {string} keyspace
	   */
	  async warmup(keyspace) {
	    if (this.connections.length < this.coreConnectionsLength) {
	      while (this.connections.length < this.coreConnectionsLength) {
	        await this._attemptNewConnection();
	      }

	      this.log('info',
	        `Connection pool to host ${this._address} created with ${this.connections.length} connection(s)`);
	    } else {
	      this.log('info', `Connection pool to host ${this._address} contains ${this.connections.length} connection(s)`);
	    }

	    if (keyspace) {
	      try {
	        for (const connection of this.connections) {
	          await connection.changeKeyspace(keyspace);
	        }
	      } catch (err) {
	        // Log it and move on, it could be a momentary schema mismatch failure
	        this.log('warning', `Connection(s) to host ${this._address} could not be switched to keyspace ${keyspace}`);
	      }
	    }
	  }

	  /** @returns {Connection} */
	  _createConnection() {
	    const endpointOrServerName = !this.options.sni
	      ? this._address : this._host.hostId.toString();

	    const c = new Connection(endpointOrServerName, this.protocolVersion, this.options);
	    this._addListeners(c);
	    return c;
	  }

	  /** @param {Connection} c */
	  _addListeners(c) {
	    c.on('responseDequeued', () => this.responseCounter++);

	    const self = this;
	    function connectionErrorCallback() {
	      // The socket is not fully open / can not send heartbeat
	      self.remove(c);
	    }
	    c.on('idleRequestError', connectionErrorCallback);
	    c.on('socketClose', connectionErrorCallback);
	  }

	  addExistingConnection(c) {
	    this._addListeners(c);
	    // Use a copy of the connections array
	    this.connections = this.connections.slice(0);
	    this.connections.push(c);
	  }

	  /**
	   * Prevents reconnection timeout from triggering
	   */
	  clearNewConnectionAttempt() {
	    if (!this._newConnectionTimeout) {
	      return;
	    }
	    clearTimeout(this._newConnectionTimeout);
	    this._newConnectionTimeout = null;
	  }

	  /**
	   * Tries to open a new connection.
	   * If a connection is being opened, it will resolve when the existing open task completes.
	   * @returns {Promise<void>}
	   */
	  async _attemptNewConnection() {
	    if (this._opening) {
	      // Wait for the event to fire
	      return await promiseUtils.fromEvent(this, 'open');
	    }

	    this._opening = true;

	    const c = this._createConnection();
	    let err;

	    try {
	      await c.openAsync();
	    } catch (e) {
	      err = e;
	      this.log('warning', `Connection to ${this._address} could not be created: ${err}`, err);
	    }

	    if (this.isClosing()) {
	      this.log('info', `Connection to ${this._address} opened successfully but pool was being closed`);
	      err = new Error('Connection closed');
	    }

	    if (!err) {
	      // Append the connection to the pool.
	      // Use a copy of the connections array.
	      const newConnections = this.connections.slice(0);
	      newConnections.push(c);
	      this.connections = newConnections;
	      this.log('info', `Connection to ${this._address} opened successfully`);
	    } else {
	      promiseUtils.toBackground(c.closeAsync());
	    }

	    // Notify that creation finished by setting the flag and emitting the event
	    this._opening = false;
	    this.emit('open', err, c);

	    if (err) {
	      // Opening failed
	      throw err;
	    }
	  }

	  attemptNewConnectionImmediate() {
	    const self = this;
	    function openConnection() {
	      self.clearNewConnectionAttempt();
	      self.scheduleNewConnectionAttempt(0);
	    }

	    if (this._state === state.initial) {
	      return openConnection();
	    }

	    if (this._state === state.closing) {
	      return this.once('close', openConnection);
	    }
	    // In the case the pool its being / has been shutdown for good
	    // Do not attempt to create a new connection.
	  }

	  /**
	   * Closes the connection and removes a connection from the pool.
	   * @param {Connection} connection
	   */
	  remove(connection) {
	    // locating an object by position in the array is O(n), but normally there should be between 1 to 8 connections.
	    const index = this.connections.indexOf(connection);
	    if (index < 0) {
	      // it was already removed from the connections and it's closing
	      return;
	    }
	    // remove the connection from the pool, using an pool copy
	    const newConnections = this.connections.slice(0);
	    newConnections.splice(index, 1);
	    this.connections = newConnections;
	    // close the connection
	    setImmediate(function removeClose() {
	      connection.close();
	    });
	    this.emit('remove');
	  }

	  /**
	   * @param {Number} delay
	   */
	  scheduleNewConnectionAttempt(delay) {
	    if (this.isClosing()) {
	      return;
	    }

	    const self = this;

	    this._newConnectionTimeout = setTimeout(function newConnectionTimeoutExpired() {
	      self._newConnectionTimeout = null;
	      if (self.connections.length >= self.coreConnectionsLength) {
	        // new connection can be scheduled while a new connection is being opened
	        // the pool has the appropriate size
	        return;
	      }

	      if (delay > 0 && self.options.sni) {
	        // We use delay > 0 as an indication that it's a reconnection.
	        // A reconnection schedule can use delay = 0 as well, but it's a good enough signal.
	        promiseUtils.toBackground(self.options.sni.addressResolver.refresh().then(() => self._attemptNewConnection()));
	        return;
	      }

	      promiseUtils.toBackground(self._attemptNewConnection());
	    }, delay);
	  }

	  hasScheduledNewConnection() {
	    return !!this._newConnectionTimeout || this._opening;
	  }

	  /**
	   * Increases the size of the connection pool in the background, if needed.
	   */
	  increaseSize() {
	    if (this.connections.length < this.coreConnectionsLength && !this.hasScheduledNewConnection()) {
	      // schedule the next connection in the background
	      this.scheduleNewConnectionAttempt(0);
	    }
	  }

	  /**
	   * Gets the amount of responses and resets the internal counter.
	   * @returns {number}
	   */
	  getAndResetResponseCounter() {
	    const temp = this.responseCounter;
	    this.responseCounter = 0;
	    return temp;
	  }

	  /**
	   * Gets a boolean indicating if the pool is being closed / shutting down or has been shutdown.
	   */
	  isClosing() {
	    return this._state !== state.initial;
	  }

	  /**
	   * Gracefully waits for all in-flight requests to finish and closes the pool.
	   */
	  drainAndShutdown() {
	    if (this.isClosing()) {
	      // Its already closing / shutting down
	      return;
	    }

	    this._state = state.closing;
	    this.clearNewConnectionAttempt();

	    if (this.connections.length === 0) {
	      return this._afterClosing();
	    }

	    const self = this;
	    const connections = this.connections;
	    this.connections = utils.emptyArray;
	    let closedConnections = 0;
	    this.log('info', util.format('Draining and closing %d connections to %s', connections.length, this._address));
	    let wasClosed = false;
	    // eslint-disable-next-line prefer-const
	    let checkShutdownTimeout;

	    for (let i = 0; i < connections.length; i++) {
	      const c = connections[i];
	      if (c.getInFlight() === 0) {
	        getDelayedClose(c)();
	        continue;
	      }
	      c.emitDrain = true;
	      c.once('drain', getDelayedClose(c));
	    }

	    function getDelayedClose(connection) {
	      return (function delayedClose() {
	        connection.close();
	        if (++closedConnections < connections.length) {
	          return;
	        }
	        if (wasClosed) {
	          return;
	        }
	        wasClosed = true;
	        if (checkShutdownTimeout) {
	          clearTimeout(checkShutdownTimeout);
	        }
	        self._afterClosing();
	      });
	    }

	    // Check that after sometime (readTimeout + 100ms) the connections have been drained
	    const delay = (this.options.socketOptions.readTimeout || getDefaultOptions().socketOptions.readTimeout) + 100;
	    checkShutdownTimeout = setTimeout(function checkShutdown() {
	      wasClosed = true;
	      connections.forEach(function connectionEach(c) {
	        c.close();
	      });
	      self._afterClosing();
	    }, delay);
	  }

	  _afterClosing() {
	    const self = this;

	    function resetState() {
	      if (self._state === state.shuttingDown) {
	        self._state = state.shutDown;
	      } else {
	        self._state = state.initial;
	      }

	      self.emit('close');

	      if (self._state === state.shutDown) {
	        self.emit('shutdown');
	      }
	    }

	    if (this._opening) {
	      // The pool is growing, reset the state back to init once the open finished (without any new connection)
	      return this.once('open', resetState);
	    }

	    resetState();
	  }

	  /**
	   * @returns {Promise<void>}
	   */
	  async shutdown() {
	    this.clearNewConnectionAttempt();

	    if (!this.connections.length) {
	      this._state = state.shutDown;
	      return;
	    }

	    const previousState = this._state;
	    this._state = state.shuttingDown;

	    if (previousState === state.closing || previousState === state.shuttingDown) {
	      // When previous state was closing, it will drain all connections and close them
	      // When previous state was "shuttingDown", it will close all the connections
	      // Once it's completed, shutdown event will be emitted
	      return promiseUtils.fromEvent(this, 'shutdown');
	    }

	    await this._closeAllConnections();

	    this._state = state.shutDown;
	    this.emit('shutdown');
	  }

	  async _closeAllConnections() {
	    const connections = this.connections;
	    // point to an empty array
	    this.connections = utils.emptyArray;
	    if (connections.length === 0) {
	      return;
	    }

	    this.log('info', util.format('Closing %d connections to %s', connections.length, this._address));

	    await Promise.all(connections.map(c => c.closeAsync()));
	  }
	}

	/** Lazily loads the default options */
	function getDefaultOptions() {
	  if (defaultOptions === undefined) {
	    defaultOptions = clientOptions.defaultOptions();
	  }
	  return defaultOptions;
	}

	hostConnectionPool = HostConnectionPool;
	return hostConnectionPool;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var prepareHandler;
var hasRequiredPrepareHandler;

function requirePrepareHandler () {
	if (hasRequiredPrepareHandler) return prepareHandler;
	hasRequiredPrepareHandler = 1;

	const errors = requireErrors$c();
	const utils = requireUtils$c();
	const types = requireTypes$2();
	const promiseUtils = requirePromiseUtils();

	/**
	 * Encapsulates the logic for dealing with the different prepare request and response flows, including failover when
	 * trying to prepare a query.
	 */
	class PrepareHandler {
	  /**
	   * Creates a new instance of PrepareHandler
	   * @param {Client} client
	   * @param {LoadBalancingPolicy} loadBalancing
	   */
	  constructor(client, loadBalancing) {
	    this._client = client;
	    this._loadBalancing = loadBalancing;
	    this.logEmitter = client.options.logEmitter;
	    this.log = utils.log;
	  }

	  /**
	   * Gets the query id and metadata for a prepared statement, preparing it on
	   * single host or on all hosts depending on the options.
	   * @param {Client} client
	   * @param {LoadBalancingPolicy} loadBalancing
	   * @param {String} query
	   * @param {String} keyspace
	   * @returns {Promise<{queryId, meta}>}
	   * @static
	   */
	  static async getPrepared(client, loadBalancing, query, keyspace) {
	    const info = client.metadata.getPreparedInfo(keyspace, query);
	    if (info.queryId) {
	      return info;
	    }

	    if (info.preparing) {
	      // It's already being prepared
	      return await promiseUtils.fromEvent(info, 'prepared');
	    }

	    const instance = new PrepareHandler(client, loadBalancing);
	    return await instance._prepare(info, query, keyspace);
	  }

	  /**
	   * @param {Client} client
	   * @param {LoadBalancingPolicy} loadBalancing
	   * @param {Array} queries
	   * @param {String} keyspace
	   * @static
	   */
	  static async getPreparedMultiple(client, loadBalancing, queries, keyspace) {
	    const result = [];

	    for (const item of queries) {
	      let query;

	      if (item) {
	        query = typeof item === 'string' ? item : item.query;
	      }

	      if (typeof query !== 'string') {
	        throw new errors.ArgumentError('Query item should be a string');
	      }

	      const { queryId, meta } = await PrepareHandler.getPrepared(client, loadBalancing, query, keyspace);
	      result.push({ query, params: utils.adaptNamedParamsPrepared(item.params, meta.columns), queryId, meta });
	    }

	    return result;
	  }

	  /**
	   * Prepares the query on a single host or on all hosts depending on the options.
	   * Uses the info 'prepared' event to emit the result.
	   * @param {Object} info
	   * @param {String} query
	   * @param {String} keyspace
	   * @returns {Promise<{queryId, meta}>}
	   */
	  async _prepare(info, query, keyspace) {
	    info.preparing = true;
	    let iterator;

	    try {
	      iterator = await promiseUtils.newQueryPlan(this._loadBalancing, keyspace, null);
	      return await this._prepareWithQueryPlan(info, iterator, query, keyspace);
	    } catch (err) {
	      info.preparing = false;
	      err.query = query;
	      info.emit('prepared', err);

	      throw err;
	    }
	  }

	  /**
	   * Uses the query plan to prepare the query on the first host and optionally on the rest of the hosts.
	   * @param {Object} info
	   * @param {Iterator} iterator
	   * @param {String} query
	   * @param {String} keyspace
	   * @returns {Promise<{queryId, meta}>}
	   * @private
	   */
	  async _prepareWithQueryPlan(info, iterator, query, keyspace) {
	    const triedHosts = {};

	    while (true) {
	      const host = PrepareHandler.getNextHost(iterator, this._client.profileManager, triedHosts);

	      if (host === null) {
	        throw new errors.NoHostAvailableError(triedHosts);
	      }

	      try {
	        const connection = await PrepareHandler._borrowWithKeyspace(host, keyspace);
	        const response = await connection.prepareOnceAsync(query, keyspace);

	        if (this._client.options.prepareOnAllHosts) {
	          await this._prepareOnAllHosts(iterator, query, keyspace);
	        }

	        // Set the prepared metadata
	        info.preparing = false;
	        info.queryId = response.id;
	        info.meta = response.meta;
	        this._client.metadata.setPreparedById(info);
	        info.emit('prepared', null, info);

	        return info;

	      } catch (err) {
	        triedHosts[host.address] = err;

	        if (!err.isSocketError && !(err instanceof errors.OperationTimedOutError)) {
	          // There's no point in retrying syntax errors and other response errors
	          throw err;
	        }
	      }
	    }
	  }

	  /**
	   * Gets the next host from the query plan.
	   * @param {Iterator} iterator
	   * @param {ProfileManager} profileManager
	   * @param {Object} [triedHosts]
	   * @return {Host|null}
	   */
	  static getNextHost(iterator, profileManager, triedHosts) {
	    let host;
	    // Get a host that is UP in a sync loop
	    while (true) {
	      const item = iterator.next();
	      if (item.done) {
	        return null;
	      }

	      host = item.value;

	      // set the distance relative to the client first
	      const distance = profileManager.getDistance(host);
	      if (distance === types.distance.ignored) {
	        //If its marked as ignore by the load balancing policy, move on.
	        continue;
	      }

	      if (host.isUp()) {
	        break;
	      }

	      if (triedHosts) {
	        triedHosts[host.address] = 'Host considered as DOWN';
	      }
	    }

	    return host;
	  }

	  /**
	   * Prepares all queries on a single host.
	   * @param {Host} host
	   * @param {Array} allPrepared
	   */
	  static async prepareAllQueries(host, allPrepared) {
	    const anyKeyspaceQueries = [];

	    const queriesByKeyspace = new Map();
	    allPrepared.forEach(info => {
	      let arr;
	      if (info.keyspace) {
	        arr = queriesByKeyspace.get(info.keyspace);

	        if (!arr) {
	          arr = [];
	          queriesByKeyspace.set(info.keyspace, arr);
	        }
	      } else {
	        arr = anyKeyspaceQueries;
	      }

	      arr.push(info.query);
	    });

	    for (const [keyspace, queries] of queriesByKeyspace) {
	      await PrepareHandler._borrowAndPrepare(host, keyspace, queries);
	    }

	    await PrepareHandler._borrowAndPrepare(host, null, anyKeyspaceQueries);
	  }

	  /**
	   * Borrows a connection from the host and prepares the queries provided.
	   * @param {Host} host
	   * @param {String} keyspace
	   * @param {Array} queries
	   * @returns {Promise<void>}
	   * @private
	   */
	  static async _borrowAndPrepare(host, keyspace, queries) {
	    if (queries.length === 0) {
	      return;
	    }

	    const connection = await PrepareHandler._borrowWithKeyspace(host, keyspace);

	    for (const query of queries) {
	      await connection.prepareOnceAsync(query, keyspace);
	    }
	  }

	  /**
	   * Borrows a connection and changes the active keyspace on the connection, if needed.
	   * It does not perform any retry or error handling.
	   * @param {Host!} host
	   * @param {string} keyspace
	   * @returns {Promise<Connection>}
	   * @throws {errors.BusyConnectionError} When the connection is busy.
	   * @throws {errors.ResponseError} For invalid keyspaces.
	   * @throws {Error} For socket errors.
	   * @private
	   */
	  static async _borrowWithKeyspace(host, keyspace) {
	    const connection = host.borrowConnection();

	    if (keyspace && connection.keyspace !== keyspace) {
	      await connection.changeKeyspace(keyspace);
	    }

	    return connection;
	  }

	  /**
	   * Prepares the provided query on all hosts, except the host provided.
	   * @param {Iterator} iterator
	   * @param {String} query
	   * @param {String} keyspace
	   * @private
	   */
	  _prepareOnAllHosts(iterator, query, keyspace) {
	    const queries = [ query ];
	    let h;
	    const hosts = [];

	    while ((h = PrepareHandler.getNextHost(iterator, this._client.profileManager)) !== null) {
	      hosts.push(h);
	    }

	    return Promise.all(hosts.map(h =>
	      PrepareHandler
	        ._borrowAndPrepare(h, keyspace, queries)
	        .catch(err => this.log('verbose', `Unexpected error while preparing query (${query}) on ${h.address}`, err))));
	  }
	}

	prepareHandler = PrepareHandler;
	return prepareHandler;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var host;
var hasRequiredHost;

function requireHost () {
	if (hasRequiredHost) return host;
	hasRequiredHost = 1;

	const events = require$$0$8;

	const utils = requireUtils$c();
	const types = requireTypes$2();
	const HostConnectionPool = requireHostConnectionPool();
	const PrepareHandler = requirePrepareHandler();
	const promiseUtils = requirePromiseUtils();

	const healthResponseCountInterval = 200;

	/**
	 * Represents a Cassandra node.
	 * @extends EventEmitter
	 */
	class Host extends events.EventEmitter {

	  /**
	   * Creates a new Host instance.
	   */
	  constructor(address, protocolVersion, options, metadata) {
	    super();
	    /**
	     * Gets ip address and port number of the node separated by `:`.
	     * @type {String}
	     */
	    this.address = address;
	    this.setDownAt = 0;
	    this.log = utils.log;

	    /**
	     * Gets the timestamp of the moment when the Host was marked as UP.
	     * @type {Number|null}
	     * @ignore
	     * @internal
	     */
	    this.isUpSince = null;
	    Object.defineProperty(this, 'options', { value: options, enumerable: false, writable: false });

	    /**
	     * The host pool.
	     * @internal
	     * @ignore
	     * @type {HostConnectionPool}
	     */
	    Object.defineProperty(this, 'pool', { value: new HostConnectionPool(this, protocolVersion), enumerable: false });

	    this.pool.on('open', err => promiseUtils.toBackground(this._onNewConnectionOpen(err)));
	    this.pool.on('remove', () => this._checkPoolState());

	    /**
	     * Gets string containing the Cassandra version.
	     * @type {String}
	     */
	    this.cassandraVersion = null;

	    /**
	     * Gets data center name of the node.
	     * @type {String}
	     */
	    this.datacenter = null;

	    /**
	     * Gets rack name of the node.
	     * @type {String}
	     */
	    this.rack = null;

	    /**
	     * Gets the tokens assigned to the node.
	     * @type {Array}
	     */
	    this.tokens = null;

	    /**
	     * Gets the id of the host.
	     * <p>This identifier is used by the server for internal communication / gossip.</p>
	     * @type {Uuid}
	     */
	    this.hostId = null;

	    /**
	     * Gets string containing the DSE version or null if not set.
	     * @type {String}
	     */
	    this.dseVersion = null;

	    /**
	     * Gets the DSE Workloads the host is running.
	     * <p>
	     *   This is based on the "workload" or "workloads" columns in {@code system.local} and {@code system.peers}.
	     * <p/>
	     * <p>
	     *   Workload labels may vary depending on the DSE version in use;e.g. DSE 5.1 may report two distinct workloads:
	     *   <code>Search</code> and <code>Analytics</code>, while DSE 5.0 would report a single
	     *   <code>SearchAnalytics</code> workload instead. The driver simply returns the workload labels as reported by
	     *   DSE, without any form of pre-processing.
	     * <p/>
	     * <p>When the information is unavailable, this property returns an empty array.</p>
	     * @type {Array<string>}
	     */
	    this.workloads = utils.emptyArray;

	    // the distance as last set using the load balancing policy
	    this._distance = types.distance.ignored;
	    this._healthResponseCounter = 0;

	    // Make some of the private instance variables not enumerable to prevent from showing when inspecting
	    Object.defineProperty(this, '_metadata', { value: metadata, enumerable: false });
	    Object.defineProperty(this, '_healthResponseCountTimer', { value: null, enumerable: false, writable: true });

	    this.reconnectionSchedule = this.options.policies.reconnection.newSchedule();
	    this.reconnectionDelay = 0;
	  }

	  /**
	   * Marks this host as not available for query coordination, when the host was previously marked as UP, otherwise its
	   * a no-op.
	   * @internal
	   * @ignore
	   */
	  setDown() {
	    // Multiple events signaling that a host is failing could cause multiple calls to this method
	    if (this.setDownAt !== 0) {
	      // the host is already marked as Down
	      return;
	    }
	    if (this.pool.isClosing()) {
	      // the pool is being closed/shutdown, don't mind
	      return;
	    }
	    this.setDownAt = Date.now();
	    if (this.pool.coreConnectionsLength > 0) {
	      // According to the distance, there should be connections open to it => issue a warning
	      this.log('warning', `Host ${this.address} considered as DOWN. Reconnection delay ${this.reconnectionDelay}ms.`);
	    }
	    else {
	      this.log('info', `Host ${this.address} considered as DOWN.`);
	    }
	    this.emit('down');
	    this._checkPoolState();
	  }

	  /**
	   * Marks this host as available for querying.
	   * @param {Boolean} [clearReconnection]
	   * @internal
	   * @ignore
	   */
	  setUp(clearReconnection) {
	    if (!this.setDownAt) {
	      //The host is already marked as UP
	      return;
	    }
	    this.log('info', `Setting host ${this.address} as UP`);
	    this.setDownAt = 0;
	    this.isUpSince = Date.now();
	    //if it was unhealthy and now it is not, lets reset the reconnection schedule.
	    this.reconnectionSchedule = this.options.policies.reconnection.newSchedule();
	    if (clearReconnection) {
	      this.pool.clearNewConnectionAttempt();
	    }
	    this.emit('up');
	  }

	  /**
	   * Resets the reconnectionSchedule and tries to issue a reconnection immediately.
	   * @internal
	   * @ignore
	   */
	  checkIsUp() {
	    if (this.isUp()) {
	      return;
	    }
	    this.reconnectionSchedule = this.options.policies.reconnection.newSchedule();
	    this.reconnectionDelay = 0;
	    this.pool.attemptNewConnectionImmediate();
	  }

	  /**
	   * @param {Boolean} [waitForPending] When true, it waits for in-flight operations to be finish before closing the
	   * connections.
	   * @returns {Promise<void>}
	   * @internal
	   * @ignore
	   */
	  shutdown(waitForPending) {
	    if (this._healthResponseCountTimer) {
	      clearInterval(this._healthResponseCountTimer);
	    }
	    if (waitForPending) {
	      this.pool.drainAndShutdown();
	      // Gracefully draining and shutting down the pool is being done in the background
	      return Promise.resolve();
	    }
	    return this.pool.shutdown();
	  }

	  /**
	   * Determines if the node is UP now (seen as UP by the driver).
	   * @returns {boolean}
	   */
	  isUp() {
	    return !this.setDownAt;
	  }

	  /**
	   * Determines if the host can be considered as UP.
	   * Deprecated: Use {@link Host#isUp()} instead.
	   * @returns {boolean}
	   */
	  canBeConsideredAsUp() {
	    const self = this;
	    function hasTimePassed() {
	      return new Date().getTime() - self.setDownAt >= self.reconnectionDelay;
	    }
	    return !this.setDownAt || hasTimePassed();
	  }

	  /**
	   * Sets the distance of the host relative to the client using the load balancing policy.
	   * @param {Number} distance
	   * @internal
	   * @ignore
	   */
	  setDistance(distance) {
	    const previousDistance = this._distance;
	    this._distance = distance || types.distance.local;
	    if (this.options.pooling.coreConnectionsPerHost) {
	      this.pool.coreConnectionsLength = this.options.pooling.coreConnectionsPerHost[this._distance] || 0;
	    }
	    else {
	      this.pool.coreConnectionsLength = 1;
	    }
	    if (this._distance === previousDistance) {
	      return this._distance;
	    }
	    if (this._healthResponseCountTimer) {
	      clearInterval(this._healthResponseCountTimer);
	    }
	    if (this._distance === types.distance.ignored) {
	      // this host was local/remote and now must be ignored
	      this.emit('ignore');
	      this.pool.drainAndShutdown();
	    }
	    else {
	      if (!this.isUp()) {
	        this.checkIsUp();
	      }
	      // Reset the health check timer
	      this._healthResponseCountTimer = setInterval(() => {
	        this._healthResponseCounter = this.pool.getAndResetResponseCounter();
	      }, healthResponseCountInterval);
	    }
	    return this._distance;
	  }

	  /**
	   * Changes the protocol version of a given host
	   * @param {Number} value
	   * @internal
	   * @ignore
	   */
	  setProtocolVersion(value) {
	    this.pool.protocolVersion = value;
	  }

	  /**
	   * Gets the least busy connection from the pool.
	   * @param {Connection} [previousConnection] When provided, the pool should attempt to obtain a different connection.
	   * @returns {Connection!}
	   * @throws {Error}
	   * @throws {BusyConnectionError}
	   * @internal
	   * @ignore
	   */
	  borrowConnection(previousConnection) {
	    return this.pool.borrowConnection(previousConnection);
	  }

	  /**
	   * Creates all the connection in the pool.
	   * @param {string} keyspace
	   * @internal
	   * @ignore
	   */
	  warmupPool(keyspace) {
	    return this.pool.warmup(keyspace);
	  }

	  /**
	   * Starts creating the pool in the background.
	   * @internal
	   * @ignore
	   */
	  initializePool() {
	    this.pool.increaseSize();
	  }
	  /**
	   * Gets any connection that is already opened or null if not found.
	   * @returns {Connection}
	   * @internal
	   * @ignore
	   */
	  getActiveConnection() {
	    if (!this.isUp() || !this.pool.connections.length) {
	      return null;
	    }
	    return this.pool.connections[0];
	  }

	  /**
	   * Internal method to get the amount of responses dequeued in the last interval (between 200ms and 400ms) on all
	   * connections to the host.
	   * @returns {Number}
	   * @internal
	   * @ignore
	   */
	  getResponseCount() {
	    // Last interval plus the current count
	    return this._healthResponseCounter + this.pool.responseCounter;
	  }

	  /**
	   * Checks the health of a connection in the pool
	   * @param {Connection} connection
	   * @internal
	   * @ignore
	   */
	  checkHealth(connection) {
	    if (connection.timedOutOperations <= this.options.socketOptions.defunctReadTimeoutThreshold) {
	      return;
	    }
	    this.removeFromPool(connection);
	  }

	  /**
	   * @param {Connection} connection
	   * @internal
	   * @ignore
	   */
	  removeFromPool(connection) {
	    this.pool.remove(connection);
	    this._checkPoolState();
	  }

	  /**
	   * Internal method that gets the amount of in-flight requests on all connections to the host.
	   * @internal
	   * @ignore
	   */
	  getInFlight() {
	    return this.pool.getInFlight();
	  }

	  /**
	   * Validates that the internal state of the connection pool.
	   * If the pool size is smaller than expected, schedule a new connection attempt.
	   * If the amount of connections is 0 for not ignored hosts, the host must be down.
	   * @private
	   */
	  _checkPoolState() {
	    if (this.pool.isClosing()) {
	      return;
	    }
	    if (this.pool.connections.length < this.pool.coreConnectionsLength) {
	      // the pool needs to grow / reconnect
	      if (!this.pool.hasScheduledNewConnection()) {
	        this.reconnectionDelay = this.reconnectionSchedule.next().value;
	        this.pool.scheduleNewConnectionAttempt(this.reconnectionDelay);
	      }
	    }
	    const shouldHaveConnections = this._distance !== types.distance.ignored && this.pool.coreConnectionsLength > 0;
	    if (shouldHaveConnections && this.pool.connections.length === 0) {
	      // Mark as DOWN, if its UP
	      this.setDown();
	    }
	  }

	  /**
	   * Executed after an scheduled new connection attempt finished
	   * @private
	   */
	  async _onNewConnectionOpen(err) {
	    if (err) {
	      this._checkPoolState();
	      return;
	    }
	    if (!this.isUp() && this.options.rePrepareOnUp) {
	      this.log('info', `Re-preparing all queries on host ${this.address} before setting it as UP`);
	      const allPrepared = this._metadata.getAllPrepared();
	      try {
	        await PrepareHandler.prepareAllQueries(this, allPrepared);
	      }
	      catch (err) {
	        this.log('warning', `Failed re-preparing on host ${this.address}: ${err}`, err);
	      }
	    }
	    this.setUp();
	    this.pool.increaseSize();
	  }

	  /**
	   * Returns an array containing the Cassandra Version as an Array of Numbers having the major version in the first
	   * position.
	   * @returns {Array.<Number>}
	   */
	  getCassandraVersion() {
	    if (!this.cassandraVersion) {
	      return utils.emptyArray;
	    }
	    return this.cassandraVersion.split('-')[0].split('.').map(x => parseInt(x, 10));
	  }

	  /**
	   * Gets the DSE version of the host as an Array, containing the major version in the first position.
	   * In case the cluster is not a DSE cluster, it returns an empty Array.
	   * @returns {Array}
	   */
	  getDseVersion() {
	    if (!this.dseVersion) {
	      return utils.emptyArray;
	    }
	    return this.dseVersion.split('-')[0].split('.').map(x => parseInt(x, 10));
	  }
	}

	/**
	 * Represents an associative-array of {@link Host hosts} that can be iterated.
	 * It creates an internal copy when adding or removing, making it safe to iterate using the values()
	 * method within async operations.
	 * @extends events.EventEmitter
	 * @constructor
	 */
	class HostMap extends events.EventEmitter{
	  constructor() {
	    super();

	    this._items = new Map();
	    this._values = null;

	    Object.defineProperty(this, 'length', { get: () => this.values().length, enumerable: true });

	    /**
	     * Emitted when a host is added to the map
	     * @event HostMap#add
	     */
	    /**
	     * Emitted when a host is removed from the map
	     * @event HostMap#remove
	     */
	  }

	  /**
	   * Executes a provided function once per map element.
	   * @param callback
	   */
	  forEach(callback) {
	    const items = this._items;
	    for (const [ key, value ] of items) {
	      callback(value, key);
	    }
	  }

	  /**
	   * Gets a {@link Host host} by key or undefined if not found.
	   * @param {String} key
	   * @returns {Host}
	   */
	  get(key) {
	    return this._items.get(key);
	  }

	  /**
	   * Returns an array of host addresses.
	   * @returns {Array.<String>}
	   */
	  keys() {
	    return Array.from(this._items.keys());
	  }

	  /**
	   * Removes an item from the map.
	   * @param {String} key The key of the host
	   * @fires HostMap#remove
	   */
	  remove(key) {
	    const value = this._items.get(key);
	    if (value === undefined) {
	      return;
	    }

	    // Clear cache
	    this._values = null;

	    // Copy the values
	    const copy = new Map(this._items);
	    copy.delete(key);

	    this._items = copy;
	    this.emit('remove', value);
	  }

	  /**
	   * Removes multiple hosts from the map.
	   * @param {Array.<String>} keys
	   * @fires HostMap#remove
	   */
	  removeMultiple(keys) {
	    // Clear value cache
	    this._values = null;

	    // Copy the values
	    const copy = new Map(this._items);
	    const removedHosts = [];

	    for (const key of keys) {
	      const h = copy.get(key);

	      if (!h) {
	        continue;
	      }

	      removedHosts.push(h);
	      copy.delete(key);
	    }

	    this._items = copy;
	    removedHosts.forEach(h => this.emit('remove', h));
	  }

	  /**
	   * Adds a new item to the map.
	   * @param {String} key The key of the host
	   * @param {Host} value The host to be added
	   * @fires HostMap#remove
	   * @fires HostMap#add
	   */
	  set(key, value) {
	    // Clear values cache
	    this._values = null;

	    const originalValue = this._items.get(key);
	    if (originalValue) {
	      //The internal structure does not change
	      this._items.set(key, value);
	      //emit a remove followed by a add
	      this.emit('remove', originalValue);
	      this.emit('add', value);
	      return;
	    }

	    // Copy the values
	    const copy = new Map(this._items);
	    copy.set(key, value);
	    this._items = copy;
	    this.emit('add', value);
	    return value;
	  }

	  /**
	   * Returns a shallow copy of a portion of the items into a new array object.
	   * Backward-compatibility.
	   * @param {Number} [begin]
	   * @param {Number} [end]
	   * @returns {Array}
	   * @ignore
	   */
	  slice(begin, end) {
	    if (!begin && !end) {
	      // Avoid making a copy of the copy
	      return this.values();
	    }

	    return this.values().slice(begin || 0, end);
	  }

	  /**
	   * Deprecated: Use set() instead.
	   * @ignore
	   * @deprecated
	   */
	  push(k, v) {
	    this.set(k, v);
	  }

	  /**
	   * Returns a shallow copy of the values of the map.
	   * @returns {Array.<Host>}
	   */
	  values() {
	    if (!this._values) {
	      // Cache the values
	      this._values = Object.freeze(Array.from(this._items.values()));
	    }

	    return this._values;
	  }

	  /**
	   * Removes all items from the map.
	   * @returns {Array.<Host>} The previous items
	   */
	  clear() {
	    const previousItems = this.values();

	    // Clear cache
	    this._values = null;

	    // Clear items
	    this._items = new Map();

	    // Emit events
	    previousItems.forEach(h => this.emit('remove', h));

	    return previousItems;
	  }

	  inspect() {
	    return this._items;
	  }

	  toJSON() {
	    // Node.js 10 and below don't support Object.fromEntries()
	    if (Object.fromEntries) {
	      return Object.fromEntries(this._items);
	    }

	    const obj = {};
	    for (const [ key, value ] of this._items) {
	      obj[key] = value;
	    }

	    return obj;
	  }
	}

	host = {
	  Host,
	  HostMap
	};
	return host;
}var tokenizer = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredTokenizer;

function requireTokenizer () {
	if (hasRequiredTokenizer) return tokenizer;
	hasRequiredTokenizer = 1;

	const types = requireTypes$2();
	const token = requireToken$1();
	const utils = requireUtils$c();
	const MutableLong = requireMutableLong();
	const { Integer } = types;

	// Murmur3 constants
	//-0x783C846EEEBDAC2B
	const mconst1 = new MutableLong(0x53d5, 0x1142, 0x7b91, 0x87c3);
	//0x4cf5ad432745937f
	const mconst2 = new MutableLong(0x937f, 0x2745, 0xad43, 0x4cf5);
	const mlongFive = MutableLong.fromNumber(5);
	//0xff51afd7ed558ccd
	const mconst3 = new MutableLong(0x8ccd, 0xed55, 0xafd7, 0xff51);
	//0xc4ceb9fe1a85ec53
	const mconst4 = new MutableLong(0xec53, 0x1a85, 0xb9fe, 0xc4ce);
	const mconst5 = MutableLong.fromNumber(0x52dce729);
	const mconst6 = MutableLong.fromNumber(0x38495ab5);

	/**
	 * Represents a set of methods that are able to generate and parse tokens for the C* partitioner.
	 * @abstract
	 */
	class Tokenizer {
	  constructor() {

	  }

	  /**
	   * Creates a token based on the Buffer value provided
	   * @abstract
	   * @param {Buffer|Array} value
	   * @returns {Token} Computed token
	   */
	  hash(value) {
	    throw new Error('You must implement a hash function for the tokenizer');
	  }

	  /**
	   * Parses a token string and returns a representation of the token
	   * @abstract
	   * @param {String} value
	   */
	  parse(value) {
	    throw new Error('You must implement a parse function for the tokenizer');
	  }

	  minToken() {
	    throw new Error('You must implement a minToken function for the tokenizer');
	  }

	  /**
	   * Splits the range specified by start and end into numberOfSplits equal parts.
	   * @param {Token} start Starting token
	   * @param {Token} end  End token
	   * @param {Number} numberOfSplits Number of splits to make.
	   */
	  split(start, end, numberOfSplits) {
	    throw new Error('You must implement a split function for the tokenizer');
	  }

	  /**
	   * Common implementation for splitting token ranges when start is in
	   * a shared Integer format.
	   *
	   * @param {Integer} start Starting token
	   * @param {Integer} range How large the range of the split is
	   * @param {Integer} ringEnd The end point of the ring so we know where to wrap
	   * @param {Integer} ringLength The total size of the ring
	   * @param {Number} numberOfSplits The number of splits to make
	   * @returns {Array<Integer>} The evenly-split points on the range
	   */
	  splitBase(start, range, ringEnd, ringLength, numberOfSplits) {
	    const numberOfSplitsInt = Integer.fromInt(numberOfSplits);
	    const divider = range.divide(numberOfSplitsInt);
	    let remainder = range.modulo(numberOfSplitsInt);

	    const results = [];
	    let current = start;
	    const dividerPlusOne = divider.add(Integer.ONE);

	    for(let i = 1; i < numberOfSplits; i++) {
	      if (remainder.greaterThan(Integer.ZERO)) {
	        current = current.add(dividerPlusOne);
	      } else {
	        current = current.add(divider);
	      }
	      if (ringLength && current.greaterThan(ringEnd)) {
	        current = current.subtract(ringLength);
	      }
	      results.push(current);
	      remainder = remainder.subtract(Integer.ONE);
	    }
	    return results;
	  }

	  /**
	   * Return internal string based representation of a Token.
	   * @param {Token} token 
	   */
	  stringify(token) {
	    return token.getValue().toString();
	  }
	}

	/**
	 * Uniformly distributes data across the cluster based on Cassandra flavored Murmur3 hashed values.
	 */
	class Murmur3Tokenizer extends Tokenizer {

	  constructor() {
	    super();
	  }

	  /**
	   * @param {Buffer} value
	   * @return {Murmur3Token}
	   */
	  hash(value) {
	    // This is an adapted version of the MurmurHash.hash3_x64_128 from Cassandra used
	    // for M3P. Compared to that methods, there's a few inlining of arguments and we
	    // only return the first 64-bits of the result since that's all M3 partitioner uses.

	    const data = value;
	    let offset = 0;
	    const length = data.length;

	    const nblocks = length >> 4; // Process as 128-bit blocks.

	    const h1 = new MutableLong();
	    const h2 = new MutableLong();
	    let k1 = new MutableLong();
	    let k2 = new MutableLong();

	    for (let i = 0; i < nblocks; i++) {
	      k1 = this.getBlock(data, offset, i * 2);
	      k2 = this.getBlock(data, offset, i * 2 + 1);

	      k1.multiply(mconst1);
	      this.rotl64(k1, 31);
	      k1.multiply(mconst2);

	      h1.xor(k1);
	      this.rotl64(h1, 27);
	      h1.add(h2);
	      h1.multiply(mlongFive).add(mconst5);

	      k2.multiply(mconst2);
	      this.rotl64(k2, 33);
	      k2.multiply(mconst1);
	      h2.xor(k2);
	      this.rotl64(h2, 31);
	      h2.add(h1);
	      h2.multiply(mlongFive).add(mconst6);
	    }
	    //----------
	    // tail

	    // Advance offset to the unprocessed tail of the data.
	    offset += nblocks * 16;

	    k1 = new MutableLong();
	    k2 = new MutableLong();

	    /* eslint-disable no-fallthrough */
	    switch(length & 15) {
	      case 15:
	        k2.xor(fromSignedByte(data[offset+14]).shiftLeft(48));
	      case 14:
	        k2.xor(fromSignedByte(data[offset+13]).shiftLeft(40));
	      case 13:
	        k2.xor(fromSignedByte(data[offset+12]).shiftLeft(32));
	      case 12:
	        k2.xor(fromSignedByte(data[offset+11]).shiftLeft(24));
	      case 11:
	        k2.xor(fromSignedByte(data[offset+10]).shiftLeft(16));
	      case 10:
	        k2.xor(fromSignedByte(data[offset+9]).shiftLeft(8));
	      case 9:
	        k2.xor(fromSignedByte(data[offset+8]));
	        k2.multiply(mconst2);
	        this.rotl64(k2, 33);
	        k2.multiply(mconst1);
	        h2.xor(k2);
	      case 8:
	        k1.xor(fromSignedByte(data[offset+7]).shiftLeft(56));
	      case 7:
	        k1.xor(fromSignedByte(data[offset+6]).shiftLeft(48));
	      case 6:
	        k1.xor(fromSignedByte(data[offset+5]).shiftLeft(40));
	      case 5:
	        k1.xor(fromSignedByte(data[offset+4]).shiftLeft(32));
	      case 4:
	        k1.xor(fromSignedByte(data[offset+3]).shiftLeft(24));
	      case 3:
	        k1.xor(fromSignedByte(data[offset+2]).shiftLeft(16));
	      case 2:
	        k1.xor(fromSignedByte(data[offset+1]).shiftLeft(8));
	      case 1:
	        k1.xor(fromSignedByte(data[offset]));
	        k1.multiply(mconst1);
	        this.rotl64(k1,31);
	        k1.multiply(mconst2);
	        h1.xor(k1);
	    }
	    /* eslint-enable no-fallthrough */

	    h1.xor(MutableLong.fromNumber(length));
	    h2.xor(MutableLong.fromNumber(length));

	    h1.add(h2);
	    h2.add(h1);


	    this.fmix(h1);
	    this.fmix(h2);

	    h1.add(h2);

	    return new token.Murmur3Token(h1);
	  }

	  /**
	   *
	   * @param {Array<Number>} key
	   * @param {Number} offset
	   * @param {Number} index
	   * @return {MutableLong}
	   */
	  getBlock(key, offset, index) {
	    const i8 = index << 3;
	    const blockOffset = offset + i8;
	    return new MutableLong(
	      (key[blockOffset]) | (key[blockOffset + 1] << 8),
	      (key[blockOffset + 2]) | (key[blockOffset + 3] << 8),
	      (key[blockOffset + 4]) | (key[blockOffset + 5] << 8),
	      (key[blockOffset + 6]) | (key[blockOffset + 7] << 8)
	    );
	  }

	  /**
	   * @param {MutableLong} v
	   * @param {Number} n
	   */
	  rotl64(v, n) {
	    const left = v.clone().shiftLeft(n);
	    v.shiftRightUnsigned(64 - n).or(left);
	  }

	  /** @param {MutableLong} k */
	  fmix(k) {
	    k.xor(new MutableLong(k.getUint16(2) >>> 1 | ((k.getUint16(3) << 15) & 0xffff), k.getUint16(3) >>> 1, 0, 0));
	    k.multiply(mconst3);
	    const other = new MutableLong(
	      (k.getUint16(2) >>> 1) | ((k.getUint16(3) << 15) & 0xffff),
	      k.getUint16(3) >>> 1,
	      0,
	      0
	    );
	    k.xor(other);
	    k.multiply(mconst4);
	    k.xor(new MutableLong(k.getUint16(2) >>> 1 | (k.getUint16(3) << 15 & 0xffff), k.getUint16(3) >>> 1, 0, 0));
	  }

	  /**
	   * Parses a int64 decimal string representation into a MutableLong.
	   * @param {String} value
	   * @returns {Murmur3Token}
	   */
	  parse(value) {
	    return new token.Murmur3Token(MutableLong.fromString(value));
	  }

	  minToken() {
	    if (!this._minToken) {
	      // minimum long value.
	      this._minToken = this.parse('-9223372036854775808');
	    }
	    return this._minToken;
	  }

	  maxToken() {
	    if (!this._maxToken) {
	      this._maxToken = this.parse('9223372036854775807');
	    }
	    return this._maxToken;
	  }

	  maxValue() {
	    if (!this._maxValue) {
	      this._maxValue = Integer.fromString('9223372036854775807');
	    }
	    return this._maxValue;
	  }

	  minValue() {
	    if (!this._minValue) {
	      this._minValue = Integer.fromString('-9223372036854775808');
	    }
	    return this._minValue;
	  }

	  ringLength() {
	    if (!this._ringLength) {
	      this._ringLength = this.maxValue().subtract(this.minValue());
	    }
	    return this._ringLength;
	  }

	  split(start, end, numberOfSplits) {
	    // ]min, min] means the whole ring.
	    if (start.equals(end) && start.equals(this.minToken())) {
	      end = this.maxToken();
	    }

	    const startVal = Integer.fromString(start.getValue().toString());
	    const endVal = Integer.fromString(end.getValue().toString());

	    let range = endVal.subtract(startVal);
	    if (range.isNegative()) {
	      range = range.add(this.ringLength());
	    }

	    const values = this.splitBase(startVal, range, this.maxValue(), this.ringLength(), numberOfSplits);
	    return values.map(v => this.parse(v.toString()));
	  }

	  stringify(token) {
	    // Get the underlying MutableLong
	    const value = token.getValue();
	    // We need a way to uniquely represent a token, it doesn't have to be the decimal string representation
	    // Using the uint16 avoids divisions and other expensive operations on the longs
	    return value.getUint16(0) + ',' + value.getUint16(1) + ',' + value.getUint16(2) + ',' + value.getUint16(3);
	  }
	}

	/**
	 * Uniformly distributes data across the cluster based on MD5 hash values.
	 */
	class RandomTokenizer extends Tokenizer {
	  constructor() {
	    super();
	    // eslint-disable-next-line
	    this._crypto = require$$0$a;
	  }

	  /**
	   * @param {Buffer|Array} value
	   * @returns {RandomToken}
	   */
	  hash(value) {
	    if (Array.isArray(value)) {
	      value = utils.allocBufferFromArray(value);
	    }
	    const hashedValue = this._crypto.createHash('md5').update(value).digest();
	    return new token.RandomToken(Integer.fromBuffer(hashedValue).abs());
	  }

	  /**
	   * @returns {Token}
	   */
	  parse(value) {
	    return new token.RandomToken(Integer.fromString(value));
	  }

	  minToken() {
	    if (!this._minToken) {
	      this._minToken = this.parse('-1');
	    }
	    return this._minToken;
	  }

	  maxValue() {
	    if (!this._maxValue) {
	      this._maxValue = Integer.fromNumber(Math.pow(2, 127));
	    }
	    return this._maxValue;
	  }

	  maxToken() {
	    if (!this._maxToken) {
	      this._maxToken = new token.RandomToken(this.maxValue());
	    }
	    return this._maxToken;
	  }

	  ringLength() {
	    if (!this._ringLength) {
	      this._ringLength = this.maxValue().add(Integer.ONE);
	    }
	    return this._ringLength;
	  }

	  split(start, end, numberOfSplits) {
	    // ]min, min] means the whole ring.
	    if (start.equals(end) && start.equals(this.minToken())) {
	      end = this.maxToken();
	    }

	    const startVal = start.getValue();
	    const endVal = end.getValue();

	    let range = endVal.subtract(startVal);
	    if (range.lessThan(Integer.ZERO)) {
	      range = range.add(this.ringLength());
	    }

	    const values = this.splitBase(startVal, range, this.maxValue(), this.ringLength(), numberOfSplits);
	    return values.map(v => new token.RandomToken(v));
	  }
	}

	class ByteOrderedTokenizer extends Tokenizer {
	  constructor() {
	    super();
	  }

	  /**
	   * @param {Buffer} value
	   * @returns {ByteOrderedToken}
	   */
	  hash(value) {
	    // strip any trailing zeros as tokens with trailing zeros are equivalent
	    // to those who don't have them.
	    if (Array.isArray(value)) {
	      value = utils.allocBufferFromArray(value);
	    }
	    let zeroIndex = value.length;
	    for(let i = value.length - 1; i > 0; i--) {
	      if(value[i] === 0) {
	        zeroIndex = i;
	      } else {
	        break;
	      }
	    }
	    return new token.ByteOrderedToken(value.slice(0, zeroIndex));
	  }

	  stringify(token) {
	    return token.getValue().toString('hex');
	  }

	  parse(value) {
	    return this.hash(utils.allocBufferFromString(value, 'hex'));
	  }

	  minToken() {
	    if (!this._minToken) {
	      this._minToken = this.hash([]);
	    }
	    return this._minToken;
	  }

	  _toNumber(buffer, significantBytes) {
	    // Convert a token's byte array to a number in order to perform computations.
	    // This depends on the number of significant bytes that is used to normalize all tokens
	    // to the same size.  For example if the token is 0x01 but significant bytes is 2, the
	    // result is 0x0100.
	    let target = buffer;
	    if(buffer.length !== significantBytes) {
	      target = Buffer.alloc(significantBytes);
	      buffer.copy(target);
	    }

	    // similar to Integer.fromBuffer except we force the sign to 0.
	    const bits = new Array(Math.ceil(target.length / 4));
	    for (let i = 0; i < bits.length; i++) {
	      let offset = target.length - ((i + 1) * 4);
	      let value;
	      if (offset < 0) {
	        //The buffer length is not multiple of 4
	        offset = offset + 4;
	        value = 0;
	        for (let j = 0; j < offset; j++) {
	          const byte = target[j];
	          value = value | (byte << (offset - j - 1) * 8);
	        }
	      }
	      else {
	        value = target.readInt32BE(offset);
	      }
	      bits[i] = value;
	    }
	    return new Integer(bits, 0);
	  }

	  _toBuffer(number, significantBytes) {
	    // Convert numeric representation back to a buffer.
	    const buffer = Integer.toBuffer(number);
	    if (buffer.length === significantBytes) {
	      return buffer;
	    }

	    // if first byte is a sign byte, skip it.
	    let start, length;
	    if (buffer[0] === 0) {
	      start = 1;
	      length = buffer.length - 1;
	    } else {
	      start = 0;
	      length = buffer.length;
	    }

	    const target = Buffer.alloc(significantBytes);
	    buffer.copy(target, significantBytes - length, start, length + start);
	    return target;
	  }

	  split(start, end, numberOfSplits) {
	    const tokenOrder = start.compare(end);

	    if (tokenOrder === 0 && start.equals(this.minToken())) {
	      throw new Error("Cannot split whole ring with ordered partitioner");
	    }

	    let startVal, endVal, range, ringLength, ringEnd;
	    const intNumberOfSplits = Integer.fromNumber(numberOfSplits);
	    // Since tokens are compared lexicographically, convert to numbers using the
	    // largest length (i.e. given 0x0A and 0x0BCD, switch to 0x0A00 and 0x0BCD)
	    let significantBytes = Math.max(start.getValue().length, end.getValue().length);
	    if (tokenOrder < 0) {
	      let addedBytes = 0;
	      while (true) {
	        startVal = this._toNumber(start.getValue(), significantBytes);
	        endVal = this._toNumber(end.getValue(), significantBytes);
	        range = endVal.subtract(startVal);
	        if (addedBytes === 4 || range.compare(intNumberOfSplits) >= 0) {
	          break;
	        }
	        significantBytes += 1;
	        addedBytes += 1;
	      }
	    } else {
	      let addedBytes = 0;
	      while (true) {
	        startVal = this._toNumber(start.getValue(), significantBytes);
	        endVal = this._toNumber(end.getValue(), significantBytes);
	        ringLength = Integer.fromNumber(Math.pow(2, significantBytes * 8));
	        ringEnd = ringLength.subtract(Integer.ONE);
	        range = endVal.subtract(startVal).add(ringLength);
	        if (addedBytes === 4 || range.compare(intNumberOfSplits) >= 0) {
	          break;
	        }
	        significantBytes += 1;
	        addedBytes += 1;
	      }
	    }

	    const values = this.splitBase(startVal, range, ringEnd, ringLength, numberOfSplits);
	    return values.map(v => new token.ByteOrderedToken(this._toBuffer(v, significantBytes)));
	  }
	}

	/**
	 * @param {Number} value
	 * @return {MutableLong}
	 */
	function fromSignedByte(value) {
	  if (value < 128) {
	    return new MutableLong(value, 0, 0, 0);
	  }
	  return new MutableLong((value - 256) & 0xffff, 0xffff, 0xffff, 0xffff);
	}

	tokenizer.Murmur3Tokenizer = Murmur3Tokenizer;
	tokenizer.RandomTokenizer = RandomTokenizer;
	tokenizer.ByteOrderedTokenizer = ByteOrderedTokenizer;
	return tokenizer;
}var schemaParser = {};/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var dataCollection;
var hasRequiredDataCollection;

function requireDataCollection () {
	if (hasRequiredDataCollection) return dataCollection;
	hasRequiredDataCollection = 1;
	const util = require$$0$6;
	const events = require$$0$8;
	/**
	 * Creates a new instance of DataCollection
	 * @param {String} name Name of the data object.
	 * @classdesc Describes a table or a view
	 * @alias module:metadata~DataCollection
	 * @constructor
	 * @abstract
	 */
	function DataCollection(name) {
	  events.EventEmitter.call(this);
	  this.setMaxListeners(0);
	  //private
	  Object.defineProperty(this, 'loading', { value: false, enumerable: false, writable: true });
	  Object.defineProperty(this, 'loaded', { value: false, enumerable: false, writable: true });
	  /**
	   * Name of the object
	   * @type {String}
	   */
	  this.name = name;
	  /**
	   * False-positive probability for SSTable Bloom filters.
	   * @type {number}
	   */
	  this.bloomFilterFalsePositiveChance = 0;
	  /**
	   * Level of caching: all, keys_only, rows_only, none
	   * @type {String}
	   */
	  this.caching = null;
	  /**
	   * A human readable comment describing the table.
	   * @type {String}
	   */
	  this.comment = null;
	  /**
	   * Specifies the time to wait before garbage collecting tombstones (deletion markers)
	   * @type {number}
	   */
	  this.gcGraceSeconds = 0;
	  /**
	   * Compaction strategy class used for the table.
	   * @type {String}
	   */
	  this.compactionClass = null;
	  /**
	   * Associative-array containing the compaction options keys and values.
	   * @type {Object}
	   */
	  this.compactionOptions = null;
	  /**
	   * Associative-array containing the compression options.
	   * @type {Object}
	   */
	  this.compression = null;
	  /**
	   * Specifies the probability of read repairs being invoked over all replicas in the current data center.
	   * @type {number}
	   */
	  this.localReadRepairChance = 0;
	  /**
	   * Specifies the probability with which read repairs should be invoked on non-quorum reads. The value must be
	   * between 0 and 1.
	   * @type {number}
	   */
	  this.readRepairChance = 0;
	  /**
	   * An associative Array containing extra metadata for the table.
	   * <p>
	   * For Apache Cassandra versions prior to 3.0.0, this method always returns <code>null</code>.
	   * </p>
	   * @type {Object}
	   */
	  this.extensions = null;
	  /**
	   * When compression is enabled, this option defines the probability
	   * with which checksums for compressed blocks are checked during reads.
	   * The default value for this options is 1.0 (always check).
	   * <p>
	   *   For Apache Cassandra versions prior to 3.0.0, this method always returns <code>null</code>.
	   * </p>
	   * @type {Number|null}
	   */
	  this.crcCheckChance = null;
	  /**
	   * Whether the populate I/O cache on flush is set on this table.
	   * @type {Boolean}
	   */
	  this.populateCacheOnFlush = false;
	  /**
	   * Returns the default TTL for this table.
	   * @type {Number}
	   */
	  this.defaultTtl = 0;
	  /**
	   * * Returns the speculative retry option for this table.
	   * @type {String}
	   */
	  this.speculativeRetry = 'NONE';
	  /**
	   * Returns the minimum index interval option for this table.
	   * <p>
	   *   Note: this option is available in Apache Cassandra 2.1 and above, and will return <code>null</code> for
	   *   earlier versions.
	   * </p>
	   * @type {Number|null}
	   */
	  this.minIndexInterval = 128;
	  /**
	   * Returns the maximum index interval option for this table.
	   * <p>
	   * Note: this option is available in Apache Cassandra 2.1 and above, and will return <code>null</code> for
	   * earlier versions.
	   * </p>
	   * @type {Number|null}
	   */
	  this.maxIndexInterval = 2048;
	  /**
	   * Array describing the table columns.
	   * @type {Array}
	   */
	  this.columns = null;
	  /**
	   * An associative Array of columns by name.
	   * @type {Object}
	   */
	  this.columnsByName = null;
	  /**
	   * Array describing the columns that are part of the partition key.
	   * @type {Array}
	   */
	  this.partitionKeys = [];
	  /**
	   * Array describing the columns that form the clustering key.
	   * @type {Array}
	   */
	  this.clusteringKeys = [];
	  /**
	   * Array describing the clustering order of the columns in the same order as the clusteringKeys.
	   * @type {Array}
	   */
	  this.clusteringOrder = [];
	  /**
	   * An associative Array containing nodesync options for this table.
	   * <p>
	   * For DSE versions prior to 6.0.0, this method always returns {@code null}.  If nodesync
	   * was not explicitly configured for this table this method will also return {@code null}.
	   * </p>
	   * @type {Object}
	   */
	  this.nodesync = null;
	}

	util.inherits(DataCollection, events.EventEmitter);

	dataCollection = DataCollection;
	return dataCollection;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var tableMetadata;
var hasRequiredTableMetadata;

function requireTableMetadata () {
	if (hasRequiredTableMetadata) return tableMetadata;
	hasRequiredTableMetadata = 1;

	const util = require$$0$6;
	const DataCollection = requireDataCollection();
	/**
	 * Creates a new instance of TableMetadata
	 * @classdesc Describes a table
	 * @param {String} name Name of the Table
	 * @augments {module:metadata~DataCollection}
	 * @alias module:metadata~TableMetadata
	 * @constructor
	 */
	function TableMetadata(name) {
	  DataCollection.call(this, name);
	  /**
	   * Applies only to counter tables.
	   * When set to true, replicates writes to all affected replicas regardless of the consistency level specified by
	   * the client for a write request. For counter tables, this should always be set to true.
	   * @type {Boolean}
	   */
	  this.replicateOnWrite = true;
	  /**
	   * Returns the memtable flush period (in milliseconds) option for this table.
	   * @type {Number}
	   */
	  this.memtableFlushPeriod = 0;
	  /**
	   * Returns the index interval option for this table.
	   * <p>
	   * Note: this option is only available in Apache Cassandra 2.0. It is deprecated in Apache Cassandra 2.1 and
	   * above, and will therefore return <code>null</code> for 2.1 nodes.
	   * </p>
	   * @type {Number|null}
	   */
	  this.indexInterval = null;
	  /**
	   * Determines  whether the table uses the COMPACT STORAGE option.
	   * @type {Boolean}
	   */
	  this.isCompact = false;
	  /**
	   *
	   * @type {Array.<Index>}
	   */
	  this.indexes = null;

	  /**
	   * Determines whether the Change Data Capture (CDC) flag is set for the table.
	   * @type {Boolean|null}
	   */
	  this.cdc = null;

	  /**
	   * Determines whether the table is a virtual table or not.
	   * @type {Boolean}
	   */
	  this.virtual = false;
	}

	util.inherits(TableMetadata, DataCollection);

	tableMetadata = TableMetadata;
	return tableMetadata;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var aggregate$1;
var hasRequiredAggregate$1;

function requireAggregate$1 () {
	if (hasRequiredAggregate$1) return aggregate$1;
	hasRequiredAggregate$1 = 1;

	/**
	 * Creates a new Aggregate.
	 * @classdesc Describes a CQL aggregate.
	 * @alias module:metadata~Aggregate
	 * @constructor
	 */
	function Aggregate() {
	  /**
	   * Name of the aggregate.
	   * @type {String}
	   */
	  this.name = null;
	  /**
	   * Name of the keyspace where the aggregate is declared.
	   */
	  this.keyspaceName = null;
	  /**
	   * Signature of the aggregate.
	   * @type {Array.<String>}
	   */
	  this.signature = null;
	  /**
	   * List of the CQL aggregate argument types.
	   * @type {Array.<{code, info}>}
	   */
	  this.argumentTypes = null;
	  /**
	   * State Function.
	   * @type {String}
	   */
	  this.stateFunction = null;
	  /**
	   * State Type.
	   * @type {{code, info}}
	   */
	  this.stateType = null;
	  /**
	   * Final Function.
	   * @type {String}
	   */
	  this.finalFunction = null;
	  this.initConditionRaw = null;
	  /**
	   * Initial state value of this aggregate.
	   * @type {String}
	   */
	  this.initCondition = null;
	  /**
	   * Type of the return value.
	   * @type {{code: number, info: (Object|Array|null)}}
	   */
	  this.returnType = null;
	  /**
	   * Indicates whether or not this aggregate is deterministic.  This means that
	   * given a particular input, the aggregate will always produce the same output.
	   * @type {Boolean}
	   */
	  this.deterministic = null;
	}

	aggregate$1 = Aggregate;
	return aggregate$1;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var schemaFunction;
var hasRequiredSchemaFunction;

function requireSchemaFunction () {
	if (hasRequiredSchemaFunction) return schemaFunction;
	hasRequiredSchemaFunction = 1;

	/**
	 * Creates a new SchemaFunction.
	 * @classdesc Describes a CQL function.
	 * @alias module:metadata~SchemaFunction
	 * @constructor
	 */
	function SchemaFunction() {
	  /**
	   * Name of the cql function.
	   * @type {String}
	   */
	  this.name = null;
	  /**
	   * Name of the keyspace where the cql function is declared.
	   */
	  this.keyspaceName = null;
	  /**
	   * Signature of the function.
	   * @type {Array.<String>}
	   */
	  this.signature = null;
	  /**
	   * List of the function argument names.
	   * @type {Array.<String>}
	   */
	  this.argumentNames = null;
	  /**
	   * List of the function argument types.
	   * @type {Array.<{code, info}>}
	   */
	  this.argumentTypes = null;
	  /**
	   * Body of the function.
	   * @type {String}
	   */
	  this.body = null;
	  /**
	   * Determines if the function is called when the input is null.
	   * @type {Boolean}
	   */
	  this.calledOnNullInput = null;
	  /**
	   * Name of the programming language, for example: java, javascript, ...
	   * @type {String}
	   */
	  this.language = null;
	  /**
	   * Type of the return value.
	   * @type {{code: number, info: (Object|Array|null)}}
	   */
	  this.returnType = null;
	  /**
	   * Indicates whether or not this function is deterministic.  This means that
	   * given a particular input, the function will always produce the same output.
	   * @type {Boolean}
	   */
	  this.deterministic = null;
	  /**
	   * Indicates whether or not this function is monotonic on all of its
	   * arguments.  This means that it is either entirely non-increasing or
	   * non-decreasing.  Even if the function is not monotonic on all of its
	   * arguments, it's possible to specify that it is monotonic on one of
	   * its arguments, meaning that partial applications of the function over
	   * that argument will be monotonic.
	   * 
	   * Monotonicity is required to use the function in a GROUP BY clause.
	   * @type {Boolean}
	   */
	  this.monotonic = null;
	  /**
	   * The argument names that the function is monotonic on.
	   * 
	   * If {@link monotonic} is true, this will return all argument names.
	   * Otherwise, this will return either one argument or an empty array.
	   * @type {Array.<String>}
	   */
	  this.monotonicOn = null;
	}

	schemaFunction = SchemaFunction;
	return schemaFunction;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var schemaIndex;
var hasRequiredSchemaIndex;

function requireSchemaIndex () {
	if (hasRequiredSchemaIndex) return schemaIndex;
	hasRequiredSchemaIndex = 1;
	const util = require$$0$6;
	const utils = requireUtils$c();
	const types = requireTypes$2();

	/** @private */
	const kind = {
	  custom: 0,
	  keys: 1,
	  composites: 2
	};
	/**
	 * Creates a new Index instance.
	 * @classdesc Describes a CQL index.
	 * @param {String} name
	 * @param {String} target
	 * @param {Number|String} kind
	 * @param {Object} options
	 * @alias module:metadata~Index
	 * @constructor
	 */
	function Index(name, target, kind, options) {
	  /**
	   * Name of the index.
	   * @type {String}
	   */
	  this.name = name;
	  /**
	   * Target of the index.
	   * @type {String}
	   */
	  this.target = target;
	  /**
	   * A numeric value representing index kind (0: custom, 1: keys, 2: composite);
	   * @type {Number}
	   */
	  this.kind = typeof kind === 'string' ? getKindByName(kind) : kind;
	  /**
	   * An associative array containing the index options
	   * @type {Object}
	   */
	  this.options = options;
	}

	/**
	 * Determines if the index is of composites kind
	 * @returns {Boolean}
	 */
	Index.prototype.isCompositesKind = function () {
	  return this.kind === kind.composites;
	};

	/**
	 * Determines if the index is of keys kind
	 * @returns {Boolean}
	 */
	Index.prototype.isKeysKind = function () {
	  return this.kind === kind.keys;
	};

	/**
	 * Determines if the index is of custom kind
	 * @returns {Boolean}
	 */
	Index.prototype.isCustomKind = function () {
	  return this.kind === kind.custom;
	};

	/**
	 * Parses Index information from rows in the 'system_schema.indexes' table
	 * @deprecated It will be removed in the next major version.
	 * @param {Array.<Row>} indexRows
	 * @returns {Array.<Index>}
	 */
	Index.fromRows = function (indexRows) {
	  if (!indexRows || indexRows.length === 0) {
	    return utils.emptyArray;
	  }
	  return indexRows.map(function (row) {
	    const options = row['options'];
	    return new Index(row['index_name'], options['target'], getKindByName(row['kind']), options);
	  });
	};

	/**
	 * Parses Index information from rows in the legacy 'system.schema_columns' table.
	 * @deprecated It will be removed in the next major version.
	 * @param {Array.<Row>} columnRows
	 * @param {Object.<String, {name, type}>} columnsByName
	 * @returns {Array.<Index>}
	 */
	Index.fromColumnRows = function (columnRows, columnsByName) {
	  const result = [];
	  for (let i = 0; i < columnRows.length; i++) {
	    const row = columnRows[i];
	    const indexName = row['index_name'];
	    if (!indexName) {
	      continue;
	    }
	    const c = columnsByName[row['column_name']];
	    let target;
	    const options = JSON.parse(row['index_options']);
	    if (options !== null && options['index_keys'] !== undefined) {
	      target = util.format("keys(%s)", c.name);
	    }
	    else if (options !== null && options['index_keys_and_values'] !== undefined) {
	      target = util.format("entries(%s)", c.name);
	    }
	    else if (c.type.options.frozen && (c.type.code === types.dataTypes.map || c.type.code === types.dataTypes.list ||
	      c.type.code === types.dataTypes.set)) {
	      target = util.format("full(%s)", c.name);
	    }
	    else {
	      target = c.name;
	    }
	    result.push(new Index(indexName, target, getKindByName(row['index_type']), options));
	  }
	  return result;
	};

	/**
	 * Gets the number representing the kind based on the name
	 * @param {String} name
	 * @returns {Number}
	 * @private
	 */
	function getKindByName(name) {
	  if (!name) {
	    return kind.custom;
	  }
	  return kind[name.toLowerCase()];
	}

	schemaIndex = Index;
	return schemaIndex;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var materializedView;
var hasRequiredMaterializedView;

function requireMaterializedView () {
	if (hasRequiredMaterializedView) return materializedView;
	hasRequiredMaterializedView = 1;
	const util = require$$0$6;
	const DataCollection = requireDataCollection();
	/**
	 * Creates a new MaterializedView.
	 * @param {String} name Name of the View.
	 * @classdesc Describes a CQL materialized view.
	 * @alias module:metadata~MaterializedView
	 * @augments {module:metadata~DataCollection}
	 * @constructor
	 */
	function MaterializedView(name) {
	  DataCollection.call(this, name);
	  /**
	   * Name of the table.
	   * @type {String}
	   */
	  this.tableName = null;
	  /**
	   * View where clause.
	   * @type {String}
	   */
	  this.whereClause = null;
	  /**
	   * Determines if all the table columns where are included in the view.
	   * @type {boolean}
	   */
	  this.includeAllColumns = false;
	}

	util.inherits(MaterializedView, DataCollection);

	materializedView = MaterializedView;
	return materializedView;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var hasRequiredSchemaParser;

function requireSchemaParser () {
	if (hasRequiredSchemaParser) return schemaParser;
	hasRequiredSchemaParser = 1;
	const util = require$$0$6;
	const events = require$$0$8;
	const types = requireTypes$2();
	const utils = requireUtils$c();
	const errors = requireErrors$c();
	const promiseUtils = requirePromiseUtils();
	const TableMetadata = requireTableMetadata();
	const Aggregate = requireAggregate$1();
	const SchemaFunction = requireSchemaFunction();
	const Index = requireSchemaIndex();
	const MaterializedView = requireMaterializedView();
	const { format } = util;

	/**
	 * @module metadata/schemaParser
	 * @ignore
	 */

	const _selectAllKeyspacesV1 = "SELECT * FROM system.schema_keyspaces";
	const _selectSingleKeyspaceV1 = "SELECT * FROM system.schema_keyspaces where keyspace_name = '%s'";
	const _selectAllKeyspacesV2 = "SELECT * FROM system_schema.keyspaces";
	const _selectSingleKeyspaceV2 = "SELECT * FROM system_schema.keyspaces where keyspace_name = '%s'";
	const _selectTableV1 = "SELECT * FROM system.schema_columnfamilies WHERE keyspace_name='%s' AND columnfamily_name='%s'";
	const _selectTableV2 = "SELECT * FROM system_schema.tables WHERE keyspace_name='%s' AND table_name='%s'";
	const _selectColumnsV1 = "SELECT * FROM system.schema_columns WHERE keyspace_name='%s' AND columnfamily_name='%s'";
	const _selectColumnsV2 = "SELECT * FROM system_schema.columns WHERE keyspace_name='%s' AND table_name='%s'";
	const _selectIndexesV2 = "SELECT * FROM system_schema.indexes WHERE keyspace_name='%s' AND table_name='%s'";
	const _selectUdtV1 = "SELECT * FROM system.schema_usertypes WHERE keyspace_name='%s' AND type_name='%s'";
	const _selectUdtV2 = "SELECT * FROM system_schema.types WHERE keyspace_name='%s' AND type_name='%s'";
	const _selectFunctionsV1 = "SELECT * FROM system.schema_functions WHERE keyspace_name = '%s' AND function_name = '%s'";
	const _selectFunctionsV2 = "SELECT * FROM system_schema.functions WHERE keyspace_name = '%s' AND function_name = '%s'";
	const _selectAggregatesV1 = "SELECT * FROM system.schema_aggregates WHERE keyspace_name = '%s' AND aggregate_name = '%s'";
	const _selectAggregatesV2 = "SELECT * FROM system_schema.aggregates WHERE keyspace_name = '%s' AND aggregate_name = '%s'";
	const _selectMaterializedViewV2 = "SELECT * FROM system_schema.views WHERE keyspace_name = '%s' AND view_name = '%s'";

	const _selectAllVirtualKeyspaces = "SELECT * FROM system_virtual_schema.keyspaces";
	const _selectSingleVirtualKeyspace = "SELECT * FROM system_virtual_schema.keyspaces where keyspace_name = '%s'";
	const _selectVirtualTable = "SELECT * FROM system_virtual_schema.tables where keyspace_name = '%s' and table_name='%s'";
	const _selectVirtualColumns = "SELECT * FROM system_virtual_schema.columns where keyspace_name = '%s' and table_name='%s'";


	/**
	 * @abstract
	 * @param {ClientOptions} options The client options
	 * @param {ControlConnection} cc
	 * @constructor
	 * @ignore
	 */
	class SchemaParser {
	  constructor(options, cc) {
	    this.cc = cc;
	    this.encodingOptions = options.encoding;
	    this.selectTable = null;
	    this.selectColumns = null;
	    this.selectIndexes = null;
	    this.selectUdt = null;
	    this.selectAggregates = null;
	    this.selectFunctions = null;
	    this.supportsVirtual = false;
	  }

	  /**
	   * @param name
	   * @param durableWrites
	   * @param strategy
	   * @param strategyOptions
	   * @param virtual
	   * @returns {{name, durableWrites, strategy, strategyOptions, tokenToReplica, udts, tables, functions, aggregates}}
	   * @protected
	   */
	  _createKeyspace(name, durableWrites, strategy, strategyOptions, virtual) {
	    return {
	      name,
	      durableWrites,
	      strategy,
	      strategyOptions,
	      virtual: virtual === true,
	      udts: {},
	      tables: {},
	      functions: {},
	      aggregates: {},
	      views: {},
	      tokenToReplica: getTokenToReplicaMapper(strategy, strategyOptions),
	      graphEngine: undefined
	    };
	  }

	  /**
	   * @abstract
	   * @param {String} name
	   * @returns {Promise<Object>}
	   */
	  getKeyspace(name) {
	  }

	  /**
	   * @abstract
	   * @param {Boolean} waitReconnect
	   * @returns {Promise<Object<string, Object>>}
	   */
	  getKeyspaces(waitReconnect) {
	  }

	  /**
	   * @param {String} keyspaceName
	   * @param {String} name
	   * @param {Object} cache
	   * @param {Boolean} virtual
	   * @returns {Promise<TableMetadata|null>}
	   */
	  async getTable(keyspaceName, name, cache, virtual) {
	    let tableInfo = cache && cache[name];
	    if (!tableInfo) {
	      tableInfo = new TableMetadata(name);
	      if (cache) {
	        cache[name] = tableInfo;
	      }
	    }
	    if (tableInfo.loaded) {
	      return tableInfo;
	    }
	    if (tableInfo.loading) {
	      // Wait for it to emit
	      return promiseUtils.fromEvent(tableInfo, 'load');
	    }
	    try {
	      // its not cached and not being retrieved
	      tableInfo.loading = true;
	      let indexRows;
	      let virtualTable = virtual;
	      const selectTable = virtualTable ? _selectVirtualTable : this.selectTable;
	      const query = util.format(selectTable, keyspaceName, name);
	      let tableRow = await this._getFirstRow(query);
	      // if we weren't sure if table was virtual or not, query virtual schema.
	      if (!tableRow && this.supportsVirtual && virtualTable === undefined) {
	        const query = util.format(_selectVirtualTable, keyspaceName, name);
	        try {
	          tableRow = await this._getFirstRow(query);
	        }
	        catch (err) {
	          // we can't error here as we can't be sure if the node
	          // supports virtual tables, in this case it is adequate
	          // to act as if there was no matching table.
	        }
	        if (tableRow) {
	          // We are fetching a virtual table
	          virtualTable = true;
	        }
	      }
	      if (!tableRow) {
	        tableInfo.loading = false;
	        tableInfo.emit('load', null, null);
	        return null;
	      }
	      const selectColumns = virtualTable ? _selectVirtualColumns : this.selectColumns;
	      const columnRows = await this._getRows(util.format(selectColumns, keyspaceName, name));
	      if (this.selectIndexes && !virtualTable) {
	        indexRows = await this._getRows(util.format(this.selectIndexes, keyspaceName, name));
	      }
	      await this._parseTableOrView(tableInfo, tableRow, columnRows, indexRows, virtualTable);
	      tableInfo.loaded = true;
	      tableInfo.emit('load', null, tableInfo);
	      return tableInfo;
	    }
	    catch (err) {
	      tableInfo.emit('load', err, null);
	      throw err;
	    }
	    finally {
	      tableInfo.loading = false;
	    }
	  }

	  async _getFirstRow(query) {
	    const rows = await this._getRows(query);
	    return rows[0];
	  }

	  async _getRows(query) {
	    const response = await this.cc.query(query);
	    return response.rows;
	  }

	  /**
	   * @param {String} keyspaceName
	   * @param {String} name
	   * @param {Object} cache
	   * @returns {Promise<Object|null>}
	   */
	  async getUdt(keyspaceName, name, cache) {
	    let udtInfo = cache && cache[name];
	    if (!udtInfo) {
	      udtInfo = new events.EventEmitter();
	      if (cache) {
	        cache[name] = udtInfo;
	      }
	      udtInfo.setMaxListeners(0);
	      udtInfo.loading = false;
	      udtInfo.name = name;
	      udtInfo.keyspace = keyspaceName;
	      udtInfo.fields = null;
	    }
	    if (udtInfo.fields) {
	      return udtInfo;
	    }
	    if (udtInfo.loading) {
	      return promiseUtils.fromEvent(udtInfo, 'load');
	    }
	    udtInfo.loading = true;
	    const query = format(this.selectUdt, keyspaceName, name);
	    try {
	      const row = await this._getFirstRow(query);
	      if (!row) {
	        udtInfo.loading = false;
	        udtInfo.emit('load', null, null);
	        return null;
	      }
	      await this._parseUdt(udtInfo, row);
	      udtInfo.emit('load', null, udtInfo);
	      return udtInfo;
	    }
	    catch (err) {
	      udtInfo.emit('load', err);
	      throw err;
	    }
	    finally {
	      udtInfo.loading = false;
	    }
	  }

	  /**
	   * Parses the udt information from the row
	   * @param udtInfo
	   * @param {Row} row
	   * @returns {Promise<void>}
	   * @abstract
	   */
	  _parseUdt(udtInfo, row) {
	  }

	  /**
	   * Builds the metadata based on the table and column rows
	   * @abstract
	   * @param {module:metadata~TableMetadata} tableInfo
	   * @param {Row} tableRow
	   * @param {Array.<Row>} columnRows
	   * @param {Array.<Row>} indexRows
	   * @param {Boolean} virtual
	   * @returns {Promise<void>}
	   * @throws {Error}
	   */
	  async _parseTableOrView(tableInfo, tableRow, columnRows, indexRows, virtual) {
	  }

	  /**
	   * @abstract
	   * @param {String} keyspaceName
	   * @param {String} name
	   * @param {Object} cache
	   * @returns {Promise<MaterializedView|null>}
	   */
	  getMaterializedView(keyspaceName, name, cache) {
	  }

	  /**
	   * @param {String} keyspaceName
	   * @param {String} name
	   * @param {Boolean} aggregate
	   * @param {Object} cache
	   * @returns {Promise<Map>}
	   */
	  async getFunctions(keyspaceName, name, aggregate, cache) {
	    /** @type {String} */
	    let query = this.selectFunctions;
	    let parser = row => this._parseFunction(row);
	    if (aggregate) {
	      query = this.selectAggregates;
	      parser = row => this._parseAggregate(row);
	    }
	    // if it's not already loaded, get all functions with that name
	    // cache it by name and, within name, by signature
	    let functionsInfo = cache && cache[name];
	    if (!functionsInfo) {
	      functionsInfo = new events.EventEmitter();
	      if (cache) {
	        cache[name] = functionsInfo;
	      }
	      functionsInfo.setMaxListeners(0);
	    }
	    if (functionsInfo.values) {
	      return functionsInfo.values;
	    }
	    if (functionsInfo.loading) {
	      return promiseUtils.fromEvent(functionsInfo, 'load');
	    }
	    functionsInfo.loading = true;
	    try {
	      const rows = await this._getRows(format(query, keyspaceName, name));
	      const funcs = await Promise.all(rows.map(parser));
	      const result = new Map();
	      if (rows.length > 0) {
	        // Cache positive hits
	        functionsInfo.values = result;
	      }

	      funcs.forEach(f => functionsInfo.values.set(f.signature.join(','), f));
	      functionsInfo.emit('load', null, result);
	      return result;
	    }
	    catch (err) {
	      functionsInfo.emit('load', err);
	      throw err;
	    }
	    finally {
	      functionsInfo.loading = false;
	    }
	  }

	  /**
	   * @abstract
	   * @param {Row} row
	   * @returns {Promise}
	   */
	  _parseAggregate(row) {
	  }

	  /**
	   * @abstract
	   * @param {Row} row
	   * @returns {Promise}
	   */
	  _parseFunction(row) {
	  }

	  /** @returns {Map} */
	  _asMap(obj) {
	    if (!obj) {
	      return new Map();
	    }
	    if (this.encodingOptions.map && obj instanceof this.encodingOptions.map) {
	      // Its already a Map or a polyfill of a Map
	      return obj;
	    }
	    return new Map(Object.keys(obj).map(k => [k, obj[k]]));
	  }

	  _mapAsObject(map) {
	    if (!map) {
	      return map;
	    }
	    if (this.encodingOptions.map && map instanceof this.encodingOptions.map) {
	      const result = {};
	      map.forEach((value, key) => result[key] = value);
	      return result;
	    }
	    return map;
	  }
	}

	/**
	 * Used to parse schema information for Cassandra versions 1.2.x, and 2.x
	 * @ignore
	 */
	class SchemaParserV1 extends SchemaParser {

	  /**
	   * @param {ClientOptions} options
	   * @param {ControlConnection} cc
	   */
	  constructor(options, cc) {
	    super(options, cc);
	    this.selectTable = _selectTableV1;
	    this.selectColumns = _selectColumnsV1;
	    this.selectUdt = _selectUdtV1;
	    this.selectAggregates = _selectAggregatesV1;
	    this.selectFunctions = _selectFunctionsV1;
	  }

	  async getKeyspaces(waitReconnect) {
	    const keyspaces = {};
	    const result = await this.cc.query(_selectAllKeyspacesV1, waitReconnect);
	    for (let i = 0; i < result.rows.length; i++) {
	      const row = result.rows[i];
	      const ksInfo = this._createKeyspace(row['keyspace_name'], row['durable_writes'], row['strategy_class'], JSON.parse(row['strategy_options'] || null));
	      keyspaces[ksInfo.name] = ksInfo;
	    }
	    return keyspaces;
	  }

	  async getKeyspace(name) {
	    const row = await this._getFirstRow(format(_selectSingleKeyspaceV1, name));
	    if (!row) {
	      return null;
	    }
	    return this._createKeyspace(row['keyspace_name'], row['durable_writes'], row['strategy_class'], JSON.parse(row['strategy_options']));
	  }

	  // eslint-disable-next-line require-await
	  async _parseTableOrView(tableInfo, tableRow, columnRows, indexRows, virtual) {
	    // All the tableInfo parsing in V1 is sync, it uses a async function because the super class defines one
	    // to support other versions.
	    let c, name, types;
	    const encoder = this.cc.getEncoder();
	    const columnsKeyed = {};
	    let partitionKeys = [];
	    let clusteringKeys = [];
	    tableInfo.bloomFilterFalsePositiveChance = tableRow['bloom_filter_fp_chance'];
	    tableInfo.caching = tableRow['caching'];
	    tableInfo.comment = tableRow['comment'];
	    tableInfo.compactionClass = tableRow['compaction_strategy_class'];
	    tableInfo.compactionOptions = JSON.parse(tableRow['compaction_strategy_options']);
	    tableInfo.compression = JSON.parse(tableRow['compression_parameters']);
	    tableInfo.gcGraceSeconds = tableRow['gc_grace_seconds'];
	    tableInfo.localReadRepairChance = tableRow['local_read_repair_chance'];
	    tableInfo.readRepairChance = tableRow['read_repair_chance'];
	    tableInfo.populateCacheOnFlush = tableRow['populate_io_cache_on_flush'] || tableInfo.populateCacheOnFlush;
	    tableInfo.memtableFlushPeriod = tableRow['memtable_flush_period_in_ms'] || tableInfo.memtableFlushPeriod;
	    tableInfo.defaultTtl = tableRow['default_time_to_live'] || tableInfo.defaultTtl;
	    tableInfo.speculativeRetry = tableRow['speculative_retry'] || tableInfo.speculativeRetry;
	    tableInfo.indexInterval = tableRow['index_interval'] || tableInfo.indexInterval;
	    if (typeof tableRow['min_index_interval'] !== 'undefined') {
	      //Cassandra 2.1+
	      tableInfo.minIndexInterval = tableRow['min_index_interval'] || tableInfo.minIndexInterval;
	      tableInfo.maxIndexInterval = tableRow['max_index_interval'] || tableInfo.maxIndexInterval;
	    }
	    else {
	      //set to null
	      tableInfo.minIndexInterval = null;
	      tableInfo.maxIndexInterval = null;
	    }
	    if (typeof tableRow['replicate_on_write'] !== 'undefined') {
	      //leave the default otherwise
	      tableInfo.replicateOnWrite = tableRow['replicate_on_write'];
	    }
	    tableInfo.columns = [];
	    for (let i = 0; i < columnRows.length; i++) {
	      const row = columnRows[i];
	      const type = encoder.parseFqTypeName(row['validator']);
	      c = {
	        name: row['column_name'],
	        type: type,
	        isStatic: false
	      };
	      tableInfo.columns.push(c);
	      columnsKeyed[c.name] = c;
	      switch (row['type']) {
	        case 'partition_key':
	          partitionKeys.push({ c: c, index: (row['component_index'] || 0) });
	          break;
	        case 'clustering_key':
	          clusteringKeys.push({
	            c: c,
	            index: (row['component_index'] || 0),
	            order: c.type.options.reversed ? 'DESC' : 'ASC'
	          });
	          break;
	        case 'static':
	          // C* 2.0.6+ supports static columns
	          c.isStatic = true;
	          break;
	      }
	    }
	    if (partitionKeys.length > 0) {
	      tableInfo.partitionKeys = partitionKeys.sort(utils.propCompare('index')).map(item => item.c);
	      clusteringKeys.sort(utils.propCompare('index'));
	      tableInfo.clusteringKeys = clusteringKeys.map(item => item.c);
	      tableInfo.clusteringOrder = clusteringKeys.map(item => item.order);
	    }
	    // In C* 1.2, keys are not stored on the schema_columns table
	    const keysStoredInTableRow = (tableInfo.partitionKeys.length === 0);
	    if (keysStoredInTableRow && tableRow['key_aliases']) {
	      //In C* 1.2, keys are not stored on the schema_columns table
	      partitionKeys = JSON.parse(tableRow['key_aliases']);
	      types = encoder.parseKeyTypes(tableRow['key_validator']).types;
	      for (let i = 0; i < partitionKeys.length; i++) {
	        name = partitionKeys[i];
	        c = columnsKeyed[name];
	        if (!c) {
	          c = {
	            name: name,
	            type: types[i]
	          };
	          tableInfo.columns.push(c);
	        }
	        tableInfo.partitionKeys.push(c);
	      }
	    }
	    const comparator = encoder.parseKeyTypes(tableRow['comparator']);
	    if (keysStoredInTableRow && tableRow['column_aliases']) {
	      clusteringKeys = JSON.parse(tableRow['column_aliases']);
	      for (let i = 0; i < clusteringKeys.length; i++) {
	        name = clusteringKeys[i];
	        c = columnsKeyed[name];
	        if (!c) {
	          c = {
	            name: name,
	            type: comparator.types[i]
	          };
	          tableInfo.columns.push(c);
	        }
	        tableInfo.clusteringKeys.push(c);
	        tableInfo.clusteringOrder.push(c.type.options.reversed ? 'DESC' : 'ASC');
	      }
	    }
	    tableInfo.isCompact = !!tableRow['is_dense'];
	    if (!tableInfo.isCompact) {
	      //is_dense column does not exist in previous versions of Cassandra
	      //also, compact pk, ck and val appear as is_dense false
	      // clusteringKeys != comparator types - 1
	      // or not composite (comparator)
	      tableInfo.isCompact = (
	        //clustering keys are not marked as composite
	        !comparator.isComposite ||
	        //only 1 column not part of the partition or clustering keys
	        (!comparator.hasCollections && tableInfo.clusteringKeys.length !== comparator.types.length - 1));
	    }
	    name = tableRow['value_alias'];
	    if (tableInfo.isCompact && name && !columnsKeyed[name]) {
	      //additional column in C* 1.2 as value_alias
	      c = {
	        name: name,
	        type: encoder.parseFqTypeName(tableRow['default_validator'])
	      };
	      tableInfo.columns.push(c);
	      columnsKeyed[name] = c;
	    }
	    tableInfo.columnsByName = columnsKeyed;
	    tableInfo.indexes = Index.fromColumnRows(columnRows, tableInfo.columnsByName);
	  }

	  getMaterializedView(keyspaceName, name, cache) {
	    return Promise.reject(new errors.NotSupportedError('Materialized views are not supported on Cassandra versions below 3.0'));
	  }

	  // eslint-disable-next-line require-await
	  async _parseAggregate(row) {
	    const encoder = this.cc.getEncoder();
	    const aggregate = new Aggregate();
	    aggregate.name = row['aggregate_name'];
	    aggregate.keyspaceName = row['keyspace_name'];
	    aggregate.signature = row['signature'] || utils.emptyArray;
	    aggregate.stateFunction = row['state_func'];
	    aggregate.finalFunction = row['final_func'];
	    aggregate.initConditionRaw = row['initcond'];
	    aggregate.argumentTypes = (row['argument_types'] || utils.emptyArray).map(name => encoder.parseFqTypeName(name));
	    aggregate.stateType = encoder.parseFqTypeName(row['state_type']);
	    const initConditionValue = encoder.decode(aggregate.initConditionRaw, aggregate.stateType);
	    if (initConditionValue !== null && typeof initConditionValue !== 'undefined') {
	      aggregate.initCondition = initConditionValue.toString();
	    }
	    aggregate.returnType = encoder.parseFqTypeName(row['return_type']);
	    return aggregate;
	  }

	  // eslint-disable-next-line require-await
	  async _parseFunction(row) {
	    const encoder = this.cc.getEncoder();
	    const func = new SchemaFunction();
	    func.name = row['function_name'];
	    func.keyspaceName = row['keyspace_name'];
	    func.signature = row['signature'] || utils.emptyArray;
	    func.argumentNames = row['argument_names'] || utils.emptyArray;
	    func.body = row['body'];
	    func.calledOnNullInput = row['called_on_null_input'];
	    func.language = row['language'];
	    func.argumentTypes = (row['argument_types'] || utils.emptyArray).map(name => encoder.parseFqTypeName(name));
	    func.returnType = encoder.parseFqTypeName(row['return_type']);
	    return func;
	  }

	  // eslint-disable-next-line require-await
	  async _parseUdt(udtInfo, row) {
	    const encoder = this.cc.getEncoder();
	    const fieldNames = row['field_names'];
	    const fieldTypes = row['field_types'];
	    const fields = new Array(fieldNames.length);
	    for (let i = 0; i < fieldNames.length; i++) {
	      fields[i] = {
	        name: fieldNames[i],
	        type: encoder.parseFqTypeName(fieldTypes[i])
	      };
	    }
	    udtInfo.fields = fields;
	    return udtInfo;
	  }
	}


	/**
	 * Used to parse schema information for Cassandra versions 3.x and above
	 * @param {ClientOptions} options The client options
	 * @param {ControlConnection} cc The control connection to be used
	 * @param {Function} udtResolver The function to be used to retrieve the udts.
	 * @ignore
	 */
	class SchemaParserV2 extends SchemaParser {

	  /**
	   * @param {ClientOptions} options The client options
	   * @param {ControlConnection} cc The control connection to be used
	   * @param {Function} udtResolver The function to be used to retrieve the udts.
	   */
	  constructor(options, cc, udtResolver) {
	    super(options, cc);
	    this.udtResolver = udtResolver;
	    this.selectTable = _selectTableV2;
	    this.selectColumns = _selectColumnsV2;
	    this.selectUdt = _selectUdtV2;
	    this.selectAggregates = _selectAggregatesV2;
	    this.selectFunctions = _selectFunctionsV2;
	    this.selectIndexes = _selectIndexesV2;
	  }

	  async getKeyspaces(waitReconnect) {
	    const keyspaces = {};
	    const result = await this.cc.query(_selectAllKeyspacesV2, waitReconnect);
	    for (let i = 0; i < result.rows.length; i++) {
	      const ksInfo = this._parseKeyspace(result.rows[i]);
	      keyspaces[ksInfo.name] = ksInfo;
	    }
	    return keyspaces;
	  }

	  async getKeyspace(name) {
	    const row = await this._getFirstRow(format(_selectSingleKeyspaceV2, name));
	    if (!row) {
	      return null;
	    }
	    return this._parseKeyspace(row);
	  }

	  async getMaterializedView(keyspaceName, name, cache) {
	    let viewInfo = cache && cache[name];
	    if (!viewInfo) {
	      viewInfo = new MaterializedView(name);
	      if (cache) {
	        cache[name] = viewInfo;
	      }
	    }
	    if (viewInfo.loaded) {
	      return viewInfo;
	    }
	    if (viewInfo.loading) {
	      return promiseUtils.fromEvent(viewInfo, 'load');
	    }
	    viewInfo.loading = true;
	    try {
	      const tableRow = await this._getFirstRow(format(_selectMaterializedViewV2, keyspaceName, name));
	      if (!tableRow) {
	        viewInfo.emit('load', null, null);
	        viewInfo.loading = false;
	        return null;
	      }
	      const columnRows = await this._getRows(format(this.selectColumns, keyspaceName, name));
	      await this._parseTableOrView(viewInfo, tableRow, columnRows, null, false);
	      viewInfo.loaded = true;
	      viewInfo.emit('load', null, viewInfo);
	      return viewInfo;
	    }
	    catch (err) {
	      viewInfo.emit('load', err);
	      throw err;
	    }
	    finally {
	      viewInfo.loading = false;
	    }
	  }

	  _parseKeyspace(row, virtual) {
	    const replication = row['replication'];
	    let strategy;
	    let strategyOptions;
	    if (replication) {
	      strategy = replication['class'];
	      strategyOptions = {};
	      for (const key in replication) {
	        if (!replication.hasOwnProperty(key) || key === 'class') {
	          continue;
	        }
	        strategyOptions[key] = replication[key];
	      }
	    }

	    const ks = this._createKeyspace(row['keyspace_name'], row['durable_writes'], strategy, strategyOptions, virtual);
	    ks.graphEngine = row['graph_engine'];
	    return ks;
	  }

	  async _parseTableOrView(tableInfo, tableRow, columnRows, indexRows, virtual) {
	    const encoder = this.cc.getEncoder();
	    const columnsKeyed = {};
	    const partitionKeys = [];
	    const clusteringKeys = [];
	    tableInfo.columns = await Promise.all(columnRows.map(async (row) => {
	      const type = await encoder.parseTypeName(tableRow['keyspace_name'], row['type'], 0, null, this.udtResolver);
	      const c = {
	        name: row['column_name'],
	        type: type,
	        isStatic: false
	      };
	      columnsKeyed[c.name] = c;
	      switch (row['kind']) {
	        case 'partition_key':
	          partitionKeys.push({ c, index: (row['position'] || 0) });
	          break;
	        case 'clustering':
	          clusteringKeys.push({
	            c, index: (row['position'] || 0), order: row['clustering_order'] === 'desc' ? 'DESC' : 'ASC'
	          });
	          break;
	        case 'static':
	          c.isStatic = true;
	          break;
	      }
	      return c;
	    }));
	    tableInfo.columnsByName = columnsKeyed;
	    tableInfo.partitionKeys = partitionKeys.sort(utils.propCompare('index')).map(item => item.c);
	    clusteringKeys.sort(utils.propCompare('index'));
	    tableInfo.clusteringKeys = clusteringKeys.map(item => item.c);
	    tableInfo.clusteringOrder = clusteringKeys.map(item => item.order);
	    if (virtual) {
	      // When table is virtual, the only relevant information to parse are the columns
	      // as the table itself has no configuration
	      tableInfo.virtual = true;
	      return;
	    }
	    const isView = tableInfo instanceof MaterializedView;
	    tableInfo.bloomFilterFalsePositiveChance = tableRow['bloom_filter_fp_chance'];
	    tableInfo.caching = JSON.stringify(tableRow['caching']);
	    tableInfo.comment = tableRow['comment'];
	    // Regardless of the encoding options, use always an Object to represent an associative Array
	    const compaction = this._asMap(tableRow['compaction']);
	    if (compaction) {
	      // compactionOptions as an Object<String, String>
	      tableInfo.compactionOptions = {};
	      tableInfo.compactionClass = compaction.get('class');
	      compaction.forEach((value, key) => {
	        if (key === 'class') {
	          return;
	        }
	        tableInfo.compactionOptions[key] = compaction.get(key);
	      });
	    }
	    // Convert compression to an Object<String, String>
	    tableInfo.compression = this._mapAsObject(tableRow['compression']);
	    tableInfo.gcGraceSeconds = tableRow['gc_grace_seconds'];
	    tableInfo.localReadRepairChance = tableRow['dclocal_read_repair_chance'];
	    tableInfo.readRepairChance = tableRow['read_repair_chance'];
	    tableInfo.extensions = this._mapAsObject(tableRow['extensions']);
	    tableInfo.crcCheckChance = tableRow['crc_check_chance'];
	    tableInfo.memtableFlushPeriod = tableRow['memtable_flush_period_in_ms'] || tableInfo.memtableFlushPeriod;
	    tableInfo.defaultTtl = tableRow['default_time_to_live'] || tableInfo.defaultTtl;
	    tableInfo.speculativeRetry = tableRow['speculative_retry'] || tableInfo.speculativeRetry;
	    tableInfo.minIndexInterval = tableRow['min_index_interval'] || tableInfo.minIndexInterval;
	    tableInfo.maxIndexInterval = tableRow['max_index_interval'] || tableInfo.maxIndexInterval;
	    tableInfo.nodesync = tableRow['nodesync'] || tableInfo.nodesync;
	    if (!isView) {
	      const cdc = tableRow['cdc'];
	      if (cdc !== undefined) {
	        tableInfo.cdc = cdc;
	      }
	    }
	    if (isView) {
	      tableInfo.tableName = tableRow['base_table_name'];
	      tableInfo.whereClause = tableRow['where_clause'];
	      tableInfo.includeAllColumns = tableRow['include_all_columns'];
	      return;
	    }
	    tableInfo.indexes = this._getIndexes(indexRows);
	    // flags can be an instance of Array or Set (real or polyfill)
	    let flags = tableRow['flags'];
	    if (Array.isArray(flags)) {
	      flags = new Set(flags);
	    }
	    const isDense = flags.has('dense');
	    const isSuper = flags.has('super');
	    const isCompound = flags.has('compound');
	    tableInfo.isCompact = isSuper || isDense || !isCompound;
	    // Remove the columns related to Thrift
	    const isStaticCompact = !isSuper && !isDense && !isCompound;
	    if (isStaticCompact) {
	      pruneStaticCompactTableColumns(tableInfo);
	    }
	    else if (isDense) {
	      pruneDenseTableColumns(tableInfo);
	    }
	  }

	  _getIndexes(indexRows) {
	    if (!indexRows || indexRows.length === 0) {
	      return utils.emptyArray;
	    }
	    return indexRows.map((row) => {
	      const options = this._mapAsObject(row['options']);
	      return new Index(row['index_name'], options['target'], row['kind'], options);
	    });
	  }

	  async _parseAggregate(row) {
	    const encoder = this.cc.getEncoder();
	    const aggregate = new Aggregate();
	    aggregate.name = row['aggregate_name'];
	    aggregate.keyspaceName = row['keyspace_name'];
	    aggregate.signature = row['argument_types'] || utils.emptyArray;
	    aggregate.stateFunction = row['state_func'];
	    aggregate.finalFunction = row['final_func'];
	    aggregate.initConditionRaw = row['initcond'];
	    aggregate.initCondition = aggregate.initConditionRaw;
	    aggregate.deterministic = row['deterministic'] || false;
	    aggregate.argumentTypes = await Promise.all(aggregate.signature.map(name => encoder.parseTypeName(row['keyspace_name'], name, 0, null, this.udtResolver)));
	    aggregate.stateType = await encoder.parseTypeName(row['keyspace_name'], row['state_type'], 0, null, this.udtResolver);
	    aggregate.returnType = await encoder.parseTypeName(row['keyspace_name'], row['return_type'], 0, null, this.udtResolver);
	    return aggregate;
	  }

	  async _parseFunction(row) {
	    const encoder = this.cc.getEncoder();
	    const func = new SchemaFunction();
	    func.name = row['function_name'];
	    func.keyspaceName = row['keyspace_name'];
	    func.signature = row['argument_types'] || utils.emptyArray;
	    func.argumentNames = row['argument_names'] || utils.emptyArray;
	    func.body = row['body'];
	    func.calledOnNullInput = row['called_on_null_input'];
	    func.language = row['language'];
	    func.deterministic = row['deterministic'] || false;
	    func.monotonic = row['monotonic'] || false;
	    func.monotonicOn = row['monotonic_on'] || utils.emptyArray;
	    func.argumentTypes = await Promise.all(func.signature.map(name => encoder.parseTypeName(row['keyspace_name'], name, 0, null, this.udtResolver)));
	    func.returnType = await encoder.parseTypeName(row['keyspace_name'], row['return_type'], 0, null, this.udtResolver);
	    return func;
	  }

	  async _parseUdt(udtInfo, row) {
	    const encoder = this.cc.getEncoder();
	    const fieldTypes = row['field_types'];
	    const keyspace = row['keyspace_name'];
	    udtInfo.fields = await Promise.all(row['field_names'].map(async (name, i) => {
	      const type = await encoder.parseTypeName(keyspace, fieldTypes[i], 0, null, this.udtResolver);
	      return { name, type };
	    }));
	    return udtInfo;
	  }
	}

	/**
	 * Used to parse schema information for Cassandra versions 4.x and above.
	 *
	 * This parser similar to [SchemaParserV2] expect it also parses virtual
	 * keyspaces.
	 * @ignore
	 */
	class SchemaParserV3 extends SchemaParserV2 {
	  /**
	   * @param {ClientOptions} options The client options
	   * @param {ControlConnection} cc The control connection to be used
	   * @param {Function} udtResolver The function to be used to retrieve the udts.
	   */
	  constructor(options, cc, udtResolver) {
	    super(options, cc, udtResolver);
	    this.supportsVirtual = true;
	  }

	  async getKeyspaces(waitReconnect) {
	    const keyspaces = {};
	    const queries = [
	      { query: _selectAllKeyspacesV2, virtual: false },
	      { query: _selectAllVirtualKeyspaces, virtual: true }
	    ];

	    await Promise.all(queries.map(async (q) => {
	      let result = null;
	      try {
	        result = await this.cc.query(q.query, waitReconnect);
	      }
	      catch (err) {
	        if (q.virtual) {
	          // Only throw error for non-virtual query as
	          // server reporting C* 4.0 may not actually implement
	          // virtual tables.
	          return;
	        }
	        throw err;
	      }
	      for (let i = 0; i < result.rows.length; i++) {
	        const ksInfo = this._parseKeyspace(result.rows[i], q.virtual);
	        keyspaces[ksInfo.name] = ksInfo;
	      }
	    }));
	    return keyspaces;
	  }

	  async getKeyspace(name) {
	    const ks = await this._getKeyspace(_selectSingleKeyspaceV2, name, false);
	    if (!ks) {
	      // if not found, attempt to retrieve as virtual keyspace.
	      return this._getKeyspace(_selectSingleVirtualKeyspace, name, true);
	    }
	    return ks;
	  }

	  async _getKeyspace(query, name, virtual) {
	    try {
	      const row = await this._getFirstRow(format(query, name));

	      if (!row) {
	        return null;
	      }

	      return this._parseKeyspace(row, virtual);
	    }
	    catch (err) {
	      if (virtual) {
	        // only throw error for non-virtual query as
	        // server reporting C* 4.0 may not actually implement
	        // virtual tables.
	        return null;
	      }
	      throw err;
	    }
	  }
	}

	/**
	 * Upon migration from thrift to CQL, we internally create a pair of surrogate clustering/regular columns
	 * for compact static tables. These columns shouldn't be exposed to the user but are currently returned by C*.
	 * We also need to remove the static keyword for all other columns in the table.
	 * @param {module:metadata~TableMetadata} tableInfo
	*/
	function pruneStaticCompactTableColumns(tableInfo) {
	  let i;
	  let c;
	  //remove "column1 text" clustering column
	  for (i = 0; i < tableInfo.clusteringKeys.length; i++) {
	    c = tableInfo.clusteringKeys[i];
	    const index = tableInfo.columns.indexOf(c);
	    tableInfo.columns.splice(index, 1);
	    delete tableInfo.columnsByName[c.name];
	  }
	  tableInfo.clusteringKeys = utils.emptyArray;
	  tableInfo.clusteringOrder = utils.emptyArray;
	  //remove regular columns and set the static columns to non-static
	  i = tableInfo.columns.length;
	  while (i--) {
	    c = tableInfo.columns[i];
	    if (!c.isStatic && tableInfo.partitionKeys.indexOf(c) === -1) {
	      // remove "value blob" regular column
	      tableInfo.columns.splice(i, 1);
	      delete tableInfo.columnsByName[c.name];
	      continue;
	    }
	    c.isStatic = false;
	  }
	}

	/**
	 * Upon migration from thrift to CQL, we internally create a surrogate column "value" of type custom.
	 * This column shouldn't be exposed to the user but is currently returned by C*.
	 * @param {module:metadata~TableMetadata} tableInfo
	 */
	function pruneDenseTableColumns(tableInfo) {
	  let i = tableInfo.columns.length;
	  while (i--) {
	    const c = tableInfo.columns[i];
	    if (!c.isStatic && c.type.code === types.dataTypes.custom && c.type.info === 'empty') {
	      // remove "value blob" regular column
	      tableInfo.columns.splice(i, 1);
	      delete tableInfo.columnsByName[c.name];
	      continue;
	    }
	    c.isStatic = false;
	  }
	}

	function getTokenToReplicaMapper(strategy, strategyOptions) {
	  if (/SimpleStrategy$/.test(strategy)) {
	    const rf = parseInt(strategyOptions['replication_factor'], 10);
	    if (rf > 1) {
	      return getTokenToReplicaSimpleMapper(rf);
	    }
	  }
	  if (/NetworkTopologyStrategy$/.test(strategy)) {
	    return getTokenToReplicaNetworkMapper(strategyOptions);
	  }
	  //default, wrap in an Array
	  return (function noStrategy(tokenizer, ring, primaryReplicas) {
	    const replicas = {};
	    for (const key in primaryReplicas) {
	      if (!primaryReplicas.hasOwnProperty(key)) {
	        continue;
	      }
	      replicas[key] = [primaryReplicas[key]];
	    }
	    return replicas;
	  });
	}

	/**
	 * @param {Number} replicationFactor
	 * @returns {function}
	 */
	function getTokenToReplicaSimpleMapper(replicationFactor) {
	  return (function tokenSimpleStrategy(tokenizer, ringTokensAsStrings, primaryReplicas) {
	    const ringLength = ringTokensAsStrings.length;
	    const rf = Math.min(replicationFactor, ringLength);
	    const replicas = {};
	    for (let i = 0; i < ringLength; i++) {
	      const key = ringTokensAsStrings[i];
	      const tokenReplicas = [primaryReplicas[key]];
	      for (let j = 1; j < ringLength && tokenReplicas.length < rf; j++) {
	        let nextReplicaIndex = i + j;
	        if (nextReplicaIndex >= ringLength) {
	          //circle back
	          nextReplicaIndex = nextReplicaIndex % ringLength;
	        }
	        const nextReplica = primaryReplicas[ringTokensAsStrings[nextReplicaIndex]];
	        // In the case of vnodes, consecutive sections of the ring can be assigned to the same host.
	        if (tokenReplicas.indexOf(nextReplica) === -1) {
	          tokenReplicas.push(nextReplica);
	        }
	      }
	      replicas[key] = tokenReplicas;
	    }
	    return replicas;
	  });
	}

	/**
	 * @param {Object} replicationFactors
	 * @returns {Function}
	 * @private
	 */
	function getTokenToReplicaNetworkMapper(replicationFactors) {
	  //                A(DC1)
	  //
	  //           H         B(DC2)
	  //                |
	  //      G       --+--       C(DC1)
	  //                |
	  //           F         D(DC2)
	  //
	  //                E(DC1)
	  return (function tokenNetworkStrategy(tokenizer, ringTokensAsStrings, primaryReplicas, datacenters) {
	    const replicas = {};
	    const ringLength = ringTokensAsStrings.length;

	    for (let i = 0; i < ringLength; i++) {
	      const key = ringTokensAsStrings[i];
	      const tokenReplicas = [];
	      const replicasByDc = {};
	      const racksPlaced = {};
	      const skippedHosts = [];
	      for (let j = 0; j < ringLength; j++) {
	        let nextReplicaIndex = i + j;
	        if (nextReplicaIndex >= ringLength) {
	          //circle back
	          nextReplicaIndex = nextReplicaIndex % ringLength;
	        }
	        const h = primaryReplicas[ringTokensAsStrings[nextReplicaIndex]];
	        // In the case of vnodes, consecutive sections of the ring can be assigned to the same host.
	        if (tokenReplicas.indexOf(h) !== -1) {
	          continue;
	        }
	        const dc = h.datacenter;
	        //Check if the next replica belongs to one of the targeted dcs
	        let dcRf = parseInt(replicationFactors[dc], 10);
	        if (!dcRf) {
	          continue;
	        }
	        dcRf = Math.min(dcRf, datacenters[dc].hostLength);
	        let dcReplicas = replicasByDc[dc] || 0;
	        //Amount of replicas per dc is greater than rf or the amount of host in the datacenter
	        if (dcReplicas >= dcRf) {
	          continue;
	        }
	        let racksPlacedInDc = racksPlaced[dc];
	        if (!racksPlacedInDc) {
	          racksPlacedInDc = racksPlaced[dc] = new utils.HashSet();
	        }
	        if (h.rack &&
	            racksPlacedInDc.contains(h.rack) &&
	            racksPlacedInDc.length < datacenters[dc].racks.length) {
	          // We already selected a replica for this rack
	          // Skip until replicas in other racks are added
	          if (skippedHosts.length < dcRf - dcReplicas) {
	            skippedHosts.push(h);
	          }
	          continue;
	        }
	        replicasByDc[h.datacenter] = ++dcReplicas;
	        tokenReplicas.push(h);
	        if (h.rack && racksPlacedInDc.add(h.rack) && racksPlacedInDc.length === datacenters[dc].racks.length) {
	          // We finished placing all replicas for all racks in this dc
	          // Add the skipped hosts
	          replicasByDc[dc] += addSkippedHosts(dcRf, dcReplicas, tokenReplicas, skippedHosts);
	        }
	        if (isDoneForToken(replicationFactors, datacenters, replicasByDc)) {
	          break;
	        }
	      }
	      replicas[key] = tokenReplicas;
	    }
	    return replicas;
	  });
	}

	/**
	 * @returns {Number} The number of skipped hosts added.
	 */
	function addSkippedHosts(dcRf, dcReplicas, tokenReplicas, skippedHosts) {
	  let i;
	  for (i = 0; i < dcRf - dcReplicas && i < skippedHosts.length; i++) {
	    tokenReplicas.push(skippedHosts[i]);
	  }
	  return i;
	}

	function isDoneForToken(replicationFactors, datacenters, replicasByDc) {
	  const keys = Object.keys(replicationFactors);
	  for (let i = 0; i < keys.length; i++) {
	    const dcName = keys[i];
	    const dc = datacenters[dcName];
	    if (!dc) {
	      // A DC is included in the RF but the DC does not exist in the topology
	      continue;
	    }
	    const rf = Math.min(parseInt(replicationFactors[dcName], 10), dc.hostLength);
	    if (rf > 0 && (!replicasByDc[dcName] || replicasByDc[dcName] < rf)) {
	      return false;
	    }
	  }
	  return true;
	}

	/**
	 * Creates a new instance if the currentInstance is not valid for the
	 * provided Cassandra version
	 * @param {ClientOptions} options The client options
	 * @param {ControlConnection} cc The control connection to be used
	 * @param {Function} udtResolver The function to be used to retrieve the udts.
	 * @param {Array.<Number>} [version] The cassandra version
	 * @param {SchemaParser} [currentInstance] The current instance
	 * @returns {SchemaParser}
	 */
	function getByVersion(options, cc, udtResolver, version, currentInstance) {
	  let parserConstructor = SchemaParserV1;
	  if (version && version[0] === 3) {
	    parserConstructor = SchemaParserV2;
	  } else if (version && version[0] >= 4) {
	    parserConstructor = SchemaParserV3;
	  }
	  if (!currentInstance || !(currentInstance instanceof parserConstructor)){
	    return new parserConstructor(options, cc, udtResolver);
	  }
	  return currentInstance;
	}

	schemaParser.getByVersion = getByVersion;
	schemaParser.isDoneForToken = isDoneForToken;
	return schemaParser;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var metadata;
var hasRequiredMetadata;

function requireMetadata () {
	if (hasRequiredMetadata) return metadata;
	hasRequiredMetadata = 1;

	const events = require$$0$8;
	const util = require$$0$6;

	/**
	 * Module containing classes and fields related to metadata.
	 * @module metadata
	 */

	const t = requireTokenizer();
	const utils = requireUtils$c();
	const errors = requireErrors$c();
	const types = requireTypes$2();
	const requests = requireRequests();
	const schemaParserFactory = requireSchemaParser();
	const promiseUtils = requirePromiseUtils();
	const { TokenRange } = requireToken$1();
	const { ExecutionOptions } = requireExecutionOptions();

	/**
	 * @const
	 * @private
	 */
	const _selectTraceSession = "SELECT * FROM system_traces.sessions WHERE session_id=%s";
	/**
	 * @const
	 * @private
	 */
	const _selectTraceEvents = "SELECT * FROM system_traces.events WHERE session_id=%s";
	/**
	 * @const
	 * @private
	 */
	const _selectSchemaVersionPeers = "SELECT schema_version FROM system.peers";
	/**
	 * @const
	 * @private
	 */
	const _selectSchemaVersionLocal = "SELECT schema_version FROM system.local";
	/**
	 * @const
	 * @private
	 */
	const _traceMaxAttemps = 5;
	/**
	 * @const
	 * @private
	 */
	const _traceAttemptDelay = 400;

	/**
	 * Represents cluster and schema information.
	 * The metadata class acts as a internal state of the driver.
	 */
	class Metadata {

	  /**
	   * Creates a new instance of {@link Metadata}.
	   * @param {ClientOptions} options
	   * @param {ControlConnection} controlConnection Control connection used to retrieve information.
	   */
	  constructor(options, controlConnection) {
	    if (!options) {
	      throw new errors.ArgumentError('Options are not defined');
	    }

	    Object.defineProperty(this, 'options', { value: options, enumerable: false, writable: false });
	    Object.defineProperty(this, 'controlConnection', { value: controlConnection, enumerable: false, writable: false });
	    this.keyspaces = {};
	    this.initialized = false;
	    this._isDbaas = false;
	    this._schemaParser = schemaParserFactory.getByVersion(options, controlConnection, this.getUdt.bind(this));
	    this.log = utils.log;
	    this._preparedQueries = new PreparedQueries(options.maxPrepared, (...args) => this.log(...args));
	  }

	  /**
	   * Sets the cassandra version
	   * @internal
	   * @ignore
	   * @param {Array.<Number>} version
	   */
	  setCassandraVersion(version) {
	    this._schemaParser = schemaParserFactory.getByVersion(
	      this.options, this.controlConnection, this.getUdt.bind(this), version, this._schemaParser);
	  }

	  /**
	   * Determines whether the cluster is provided as a service.
	   * @returns {boolean} true when the cluster is provided as a service (DataStax Astra), <code>false<code> when it's a
	   * different deployment (on-prem).
	   */
	  isDbaas() {
	    return this._isDbaas;
	  }

	  /**
	   * Sets the product type as DBaaS.
	   * @internal
	   * @ignore
	   */
	  setProductTypeAsDbaas() {
	    this._isDbaas = true;
	  }

	  /**
	   * @ignore
	   * @param {String} partitionerName
	   */
	  setPartitioner(partitionerName) {
	    if (/RandomPartitioner$/.test(partitionerName)) {
	      return this.tokenizer = new t.RandomTokenizer();
	    }
	    if (/ByteOrderedPartitioner$/.test(partitionerName)) {
	      return this.tokenizer = new t.ByteOrderedTokenizer();
	    }
	    return this.tokenizer = new t.Murmur3Tokenizer();
	  }

	  /**
	   * Populates the information regarding primary replica per token, datacenters (+ racks) and sorted token ring.
	   * @ignore
	   * @param {HostMap} hosts
	   */
	  buildTokens(hosts) {
	    if (!this.tokenizer) {
	      return this.log('error', 'Tokenizer could not be determined');
	    }
	    //Get a sorted array of tokens
	    const allSorted = [];
	    //Get a map of <token, primaryHost>
	    const primaryReplicas = {};
	    //Depending on the amount of tokens, this could be an expensive operation
	    const hostArray = hosts.values();
	    const stringify = this.tokenizer.stringify;
	    const datacenters = {};
	    hostArray.forEach((h) => {
	      if (!h.tokens) {
	        return;
	      }
	      h.tokens.forEach((tokenString) => {
	        const token = this.tokenizer.parse(tokenString);
	        utils.insertSorted(allSorted, token, (t1, t2) => t1.compare(t2));
	        primaryReplicas[stringify(token)] = h;
	      });
	      let dc = datacenters[h.datacenter];
	      if (!dc) {
	        dc = datacenters[h.datacenter] = {
	          hostLength: 0,
	          racks: new utils.HashSet()
	        };
	      }
	      dc.hostLength++;
	      dc.racks.add(h.rack);
	    });
	    //Primary replica for given token
	    this.primaryReplicas = primaryReplicas;
	    //All the tokens in ring order
	    this.ring = allSorted;
	    // Build TokenRanges.
	    const tokenRanges = new Set();
	    if (this.ring.length === 1) {
	      // If there is only one token, return the range ]minToken, minToken]
	      const min = this.tokenizer.minToken();
	      tokenRanges.add(new TokenRange(min, min, this.tokenizer));
	    }
	    else {
	      for (let i = 0; i < this.ring.length; i++) {
	        const start = this.ring[i];
	        const end = this.ring[(i + 1) % this.ring.length];
	        tokenRanges.add(new TokenRange(start, end, this.tokenizer));
	      }
	    }
	    this.tokenRanges = tokenRanges;
	    //Compute string versions as it's potentially expensive and frequently reused later
	    this.ringTokensAsStrings = new Array(allSorted.length);
	    for (let i = 0; i < allSorted.length; i++) {
	      this.ringTokensAsStrings[i] = stringify(allSorted[i]);
	    }
	    //Datacenter metadata (host length and racks)
	    this.datacenters = datacenters;
	  }

	  /**
	   * Gets the keyspace metadata information and updates the internal state of the driver.
	   * <p>
	   *   If a <code>callback</code> is provided, the callback is invoked when the keyspaces metadata refresh completes.
	   *   Otherwise, it returns a <code>Promise</code>.
	   * </p>
	   * @param {String} name Name of the keyspace.
	   * @param {Function} [callback] Optional callback.
	   */
	  refreshKeyspace(name, callback) {
	    return promiseUtils.optionalCallback(this._refreshKeyspace(name), callback);
	  }

	  /**
	   * @param {String} name
	   * @private
	   */
	  async _refreshKeyspace(name) {
	    if (!this.initialized) {
	      throw this._uninitializedError();
	    }
	    this.log('info', util.format('Retrieving keyspace %s metadata', name));
	    try {
	      const ksInfo = await this._schemaParser.getKeyspace(name);
	      if (!ksInfo) {
	        // the keyspace was dropped
	        delete this.keyspaces[name];
	        return null;
	      }
	      // Tokens are lazily init on the keyspace, once a replica from that keyspace is retrieved.
	      this.keyspaces[ksInfo.name] = ksInfo;
	      return ksInfo;
	    }
	    catch (err) {
	      this.log('error', 'There was an error while trying to retrieve keyspace information', err);
	      throw err;
	    }
	  }

	  /**
	   * Gets the metadata information of all the keyspaces and updates the internal state of the driver.
	   * <p>
	   *   If a <code>callback</code> is provided, the callback is invoked when the keyspace metadata refresh completes.
	   *   Otherwise, it returns a <code>Promise</code>.
	   * </p>
	   * @param {Boolean|Function} [waitReconnect] Determines if it should wait for reconnection in case the control connection is not
	   * connected at the moment. Default: true.
	   * @param {Function} [callback] Optional callback.
	   */
	  refreshKeyspaces(waitReconnect, callback) {
	    if (typeof waitReconnect === 'function' || typeof waitReconnect === 'undefined') {
	      callback = waitReconnect;
	      waitReconnect = true;
	    }
	    if (!this.initialized) {
	      const err = this._uninitializedError();
	      if (callback) {
	        return callback(err);
	      }
	      return Promise.reject(err);
	    }
	    return promiseUtils.optionalCallback(this.refreshKeyspacesInternal(waitReconnect), callback);
	  }

	  /**
	   * @param {Boolean} waitReconnect
	   * @returns {Promise<Object<string, Object>>}
	   * @ignore
	   * @internal
	   */
	  async refreshKeyspacesInternal(waitReconnect) {
	    this.log('info', 'Retrieving keyspaces metadata');
	    try {
	      this.keyspaces = await this._schemaParser.getKeyspaces(waitReconnect);
	      return this.keyspaces;
	    }
	    catch (err) {
	      this.log('error', 'There was an error while trying to retrieve keyspaces information', err);
	      throw err;
	    }
	  }

	  _getKeyspaceReplicas(keyspace) {
	    if (!keyspace.replicas) {
	      //Calculate replicas the first time for the keyspace
	      keyspace.replicas =
	        keyspace.tokenToReplica(this.tokenizer, this.ringTokensAsStrings, this.primaryReplicas, this.datacenters);
	    }
	    return keyspace.replicas;
	  }

	  /**
	   * Gets the host list representing the replicas that contain the given partition key, token or token range.
	   * <p>
	   *   It uses the pre-loaded keyspace metadata to retrieve the replicas for a token for a given keyspace.
	   *   When the keyspace metadata has not been loaded, it returns null.
	   * </p>
	   * @param {String} keyspaceName
	   * @param {Buffer|Token|TokenRange} token Can be Buffer (serialized partition key), Token or TokenRange
	   * @returns {Array}
	   */
	  getReplicas(keyspaceName, token) {
	    if (!this.ring) {
	      return null;
	    }
	    if (Buffer.isBuffer(token)) {
	      token = this.tokenizer.hash(token);
	    }
	    if (token instanceof TokenRange) {
	      token = token.end;
	    }
	    let keyspace;
	    if (keyspaceName) {
	      keyspace = this.keyspaces[keyspaceName];
	      if (!keyspace) {
	        // the keyspace was not found, the metadata should be loaded beforehand
	        return null;
	      }
	    }
	    let i = utils.binarySearch(this.ring, token, (t1, t2) => t1.compare(t2));
	    if (i < 0) {
	      i = ~i;
	    }
	    if (i >= this.ring.length) {
	      //it circled back
	      i = i % this.ring.length;
	    }
	    const closestToken = this.ringTokensAsStrings[i];
	    if (!keyspaceName) {
	      return [this.primaryReplicas[closestToken]];
	    }
	    const replicas = this._getKeyspaceReplicas(keyspace);
	    return replicas[closestToken];
	  }

	  /**
	   * Gets the token ranges that define data distribution in the ring.
	   *
	   * @returns {Set<TokenRange>} The ranges of the ring or empty set if schema metadata is not enabled.
	   */
	  getTokenRanges() {
	    return this.tokenRanges;
	  }

	  /**
	   * Gets the token ranges that are replicated on the given host, for
	   * the given keyspace.
	   *
	   * @param {String} keyspaceName The name of the keyspace to get ranges for.
	   * @param {Host} host The host.
	   * @returns {Set<TokenRange>|null} Ranges for the keyspace on this host or null if keyspace isn't found or hasn't been loaded.
	   */
	  getTokenRangesForHost(keyspaceName, host) {
	    if (!this.ring) {
	      return null;
	    }
	    let keyspace;
	    if (keyspaceName) {
	      keyspace = this.keyspaces[keyspaceName];
	      if (!keyspace) {
	        // the keyspace was not found, the metadata should be loaded beforehand
	        return null;
	      }
	    }
	    // If the ring has only 1 token, just return the ranges as we should only have a single node cluster.
	    if (this.ring.length === 1) {
	      return this.getTokenRanges();
	    }
	    const replicas = this._getKeyspaceReplicas(keyspace);
	    const ranges = new Set();
	    // for each range, find replicas for end token, if replicas include host, add range.
	    this.tokenRanges.forEach((tokenRange) => {
	      const replicasForToken = replicas[this.tokenizer.stringify(tokenRange.end)];
	      if (replicasForToken.indexOf(host) !== -1) {
	        ranges.add(tokenRange);
	      }
	    });
	    return ranges;
	  }

	  /**
	   * Constructs a Token from the input buffer(s) or string input.  If a string is passed in
	   * it is assumed this matches the token representation reported by cassandra.
	   * @param {Array<Buffer>|Buffer|String} components
	   * @returns {Token} constructed token from the input buffer.
	   */
	  newToken(components) {
	    if (!this.tokenizer) {
	      throw new Error('Partitioner not established.  This should only happen if metadata was disabled or you have not connected yet.');
	    }
	    if (Array.isArray(components)) {
	      return this.tokenizer.hash(Buffer.concat(components));
	    }
	    else if (util.isString(components)) {
	      return this.tokenizer.parse(components);
	    }
	    return this.tokenizer.hash(components);
	  }

	  /**
	   * Constructs a TokenRange from the given start and end tokens.
	   * @param {Token} start
	   * @param {Token} end
	   * @returns TokenRange build range spanning from start (exclusive) to end (inclusive).
	   */
	  newTokenRange(start, end) {
	    if (!this.tokenizer) {
	      throw new Error('Partitioner not established.  This should only happen if metadata was disabled or you have not connected yet.');
	    }
	    return new TokenRange(start, end, this.tokenizer);
	  }

	  /**
	   * Gets the metadata information already stored associated to a prepared statement
	   * @param {String} keyspaceName
	   * @param {String} query
	   * @internal
	   * @ignore
	   */
	  getPreparedInfo(keyspaceName, query) {
	    return this._preparedQueries.getOrAdd(keyspaceName, query);
	  }

	  /**
	   * Clears the internal state related to the prepared statements.
	   * Following calls to the Client using the prepare flag will re-prepare the statements.
	   */
	  clearPrepared() {
	    this._preparedQueries.clear();
	  }

	  /** @ignore */
	  getPreparedById(id) {
	    return this._preparedQueries.getById(id);
	  }

	  /** @ignore */
	  setPreparedById(info) {
	    return this._preparedQueries.setById(info);
	  }

	  /** @ignore */
	  getAllPrepared() {
	    return this._preparedQueries.getAll();
	  }

	  /** @ignore */
	  _uninitializedError() {
	    return new Error('Metadata has not been initialized.  This could only happen if you have not connected yet.');
	  }

	  /**
	   * Gets the definition of an user-defined type.
	   * <p>
	   *   If a <code>callback</code> is provided, the callback is invoked when the metadata retrieval completes.
	   *   Otherwise, it returns a <code>Promise</code>.
	   * </p>
	   * <p>
	   * When trying to retrieve the same UDT definition concurrently, it will query once and invoke all callbacks
	   * with the retrieved information.
	   * </p>
	   * @param {String} keyspaceName Name of the keyspace.
	   * @param {String} name Name of the UDT.
	   * @param {Function} [callback] The callback to invoke when retrieval completes.
	   */
	  getUdt(keyspaceName, name, callback) {
	    return promiseUtils.optionalCallback(this._getUdt(keyspaceName, name), callback);
	  }

	  /**
	   * @param {String} keyspaceName
	   * @param {String} name
	   * @returns {Promise<Object|null>}
	   * @private
	   */
	  async _getUdt(keyspaceName, name) {
	    if (!this.initialized) {
	      throw this._uninitializedError();
	    }
	    let cache;
	    if (this.options.isMetadataSyncEnabled) {
	      const keyspace = this.keyspaces[keyspaceName];
	      if (!keyspace) {
	        return null;
	      }
	      cache = keyspace.udts;
	    }
	    return await this._schemaParser.getUdt(keyspaceName, name, cache);
	  }

	  /**
	   * Gets the definition of a table.
	   * <p>
	   *   If a <code>callback</code> is provided, the callback is invoked when the metadata retrieval completes.
	   *   Otherwise, it returns a <code>Promise</code>.
	   * </p>
	   * <p>
	   * When trying to retrieve the same table definition concurrently, it will query once and invoke all callbacks
	   * with the retrieved information.
	   * </p>
	   * @param {String} keyspaceName Name of the keyspace.
	   * @param {String} name Name of the Table.
	   * @param {Function} [callback] The callback with the err as a first parameter and the {@link TableMetadata} as
	   * second parameter.
	   */
	  getTable(keyspaceName, name, callback) {
	    return promiseUtils.optionalCallback(this._getTable(keyspaceName, name), callback);
	  }

	  /**
	   * @param {String} keyspaceName
	   * @param {String} name
	   * @private
	   */
	  async _getTable(keyspaceName, name) {
	    if (!this.initialized) {
	      throw this._uninitializedError();
	    }
	    let cache;
	    let virtual;
	    if (this.options.isMetadataSyncEnabled) {
	      const keyspace = this.keyspaces[keyspaceName];
	      if (!keyspace) {
	        return null;
	      }
	      cache = keyspace.tables;
	      virtual = keyspace.virtual;
	    }
	    return await this._schemaParser.getTable(keyspaceName, name, cache, virtual);
	  }

	  /**
	   * Gets the definition of CQL functions for a given name.
	   * <p>
	   *   If a <code>callback</code> is provided, the callback is invoked when the metadata retrieval completes.
	   *   Otherwise, it returns a <code>Promise</code>.
	   * </p>
	   * <p>
	   * When trying to retrieve the same function definition concurrently, it will query once and invoke all callbacks
	   * with the retrieved information.
	   * </p>
	   * @param {String} keyspaceName Name of the keyspace.
	   * @param {String} name Name of the Function.
	   * @param {Function} [callback] The callback with the err as a first parameter and the array of {@link SchemaFunction}
	   * as second parameter.
	   */
	  getFunctions(keyspaceName, name, callback) {
	    return promiseUtils.optionalCallback(this._getFunctionsWrapper(keyspaceName, name), callback);
	  }

	  /**
	   * @param {String} keyspaceName
	   * @param {String} name
	   * @private
	   */
	  async _getFunctionsWrapper(keyspaceName, name) {
	    if (!keyspaceName || !name) {
	      throw new errors.ArgumentError('You must provide the keyspace name and cql function name to retrieve the metadata');
	    }
	    const functionsMap = await this._getFunctions(keyspaceName, name, false);
	    return Array.from(functionsMap.values());
	  }

	  /**
	   * Gets a definition of CQL function for a given name and signature.
	   * <p>
	   *   If a <code>callback</code> is provided, the callback is invoked when the metadata retrieval completes.
	   *   Otherwise, it returns a <code>Promise</code>.
	   * </p>
	   * <p>
	   * When trying to retrieve the same function definition concurrently, it will query once and invoke all callbacks
	   * with the retrieved information.
	   * </p>
	   * @param {String} keyspaceName Name of the keyspace
	   * @param {String} name Name of the Function
	   * @param {Array.<String>|Array.<{code, info}>} signature Array of types of the parameters.
	   * @param {Function} [callback] The callback with the err as a first parameter and the {@link SchemaFunction} as second
	   * parameter.
	   */
	  getFunction(keyspaceName, name, signature, callback) {
	    return promiseUtils.optionalCallback(this._getSingleFunction(keyspaceName, name, signature, false), callback);
	  }

	  /**
	   * Gets the definition of CQL aggregate for a given name.
	   * <p>
	   *   If a <code>callback</code> is provided, the callback is invoked when the metadata retrieval completes.
	   *   Otherwise, it returns a <code>Promise</code>.
	   * </p>
	   * <p>
	   * When trying to retrieve the same aggregates definition concurrently, it will query once and invoke all callbacks
	   * with the retrieved information.
	   * </p>
	   * @param {String} keyspaceName Name of the keyspace
	   * @param {String} name Name of the Function
	   * @param {Function} [callback] The callback with the err as a first parameter and the array of {@link Aggregate} as
	   * second parameter.
	   */
	  getAggregates(keyspaceName, name, callback) {
	    return promiseUtils.optionalCallback(this._getAggregates(keyspaceName, name), callback);
	  }

	  /**
	   * @param {String} keyspaceName
	   * @param {String} name
	   * @private
	   */
	  async _getAggregates(keyspaceName, name) {
	    if (!keyspaceName || !name) {
	      throw new errors.ArgumentError('You must provide the keyspace name and cql aggregate name to retrieve the metadata');
	    }
	    const functionsMap = await this._getFunctions(keyspaceName, name, true);
	    return Array.from(functionsMap.values());
	  }

	  /**
	   * Gets a definition of CQL aggregate for a given name and signature.
	   * <p>
	   *   If a <code>callback</code> is provided, the callback is invoked when the metadata retrieval completes.
	   *   Otherwise, it returns a <code>Promise</code>.
	   * </p>
	   * <p>
	   * When trying to retrieve the same aggregate definition concurrently, it will query once and invoke all callbacks
	   * with the retrieved information.
	   * </p>
	   * @param {String} keyspaceName Name of the keyspace
	   * @param {String} name Name of the aggregate
	   * @param {Array.<String>|Array.<{code, info}>} signature Array of types of the parameters.
	   * @param {Function} [callback] The callback with the err as a first parameter and the {@link Aggregate} as second parameter.
	   */
	  getAggregate(keyspaceName, name, signature, callback) {
	    return promiseUtils.optionalCallback(this._getSingleFunction(keyspaceName, name, signature, true), callback);
	  }

	  /**
	   * Gets the definition of a CQL materialized view for a given name.
	   * <p>
	   *   If a <code>callback</code> is provided, the callback is invoked when the metadata retrieval completes.
	   *   Otherwise, it returns a <code>Promise</code>.
	   * </p>
	   * <p>
	   *   Note that, unlike the rest of the {@link Metadata} methods, this method does not cache the result for following
	   *   calls, as the current version of the Cassandra native protocol does not support schema change events for
	   *   materialized views. Each call to this method will produce one or more queries to the cluster.
	   * </p>
	   * @param {String} keyspaceName Name of the keyspace
	   * @param {String} name Name of the materialized view
	   * @param {Function} [callback] The callback with the err as a first parameter and the {@link MaterializedView} as
	   * second parameter.
	   */
	  getMaterializedView(keyspaceName, name, callback) {
	    return promiseUtils.optionalCallback(this._getMaterializedView(keyspaceName, name), callback);
	  }

	  /**
	   * @param {String} keyspaceName
	   * @param {String} name
	   * @returns {Promise<MaterializedView|null>}
	   * @private
	   */
	  async _getMaterializedView(keyspaceName, name) {
	    if (!this.initialized) {
	      throw this._uninitializedError();
	    }
	    let cache;
	    if (this.options.isMetadataSyncEnabled) {
	      const keyspace = this.keyspaces[keyspaceName];
	      if (!keyspace) {
	        return null;
	      }
	      cache = keyspace.views;
	    }
	    return await this._schemaParser.getMaterializedView(keyspaceName, name, cache);
	  }

	  /**
	   * Gets a map of cql function definitions or aggregates based on signature.
	   * @param {String} keyspaceName
	   * @param {String} name Name of the function or aggregate
	   * @param {Boolean} aggregate
	   * @returns {Promise<Map>}
	   * @private
	   */
	  async _getFunctions(keyspaceName, name, aggregate) {
	    if (!this.initialized) {
	      throw this._uninitializedError();
	    }
	    let cache;
	    if (this.options.isMetadataSyncEnabled) {
	      const keyspace = this.keyspaces[keyspaceName];
	      if (!keyspace) {
	        return new Map();
	      }
	      cache = aggregate ? keyspace.aggregates : keyspace.functions;
	    }
	    return await this._schemaParser.getFunctions(keyspaceName, name, aggregate, cache);
	  }

	  /**
	   * Gets a single cql function or aggregate definition
	   * @param {String} keyspaceName
	   * @param {String} name
	   * @param {Array} signature
	   * @param {Boolean} aggregate
	   * @returns {Promise<SchemaFunction|Aggregate|null>}
	   * @private
	   */
	  async _getSingleFunction(keyspaceName, name, signature, aggregate) {
	    if (!keyspaceName || !name) {
	      throw new errors.ArgumentError('You must provide the keyspace name and cql function name to retrieve the metadata');
	    }
	    if (!Array.isArray(signature)) {
	      throw new errors.ArgumentError('Signature must be an array of types');
	    }
	    signature = signature.map(item => {
	      if (typeof item === 'string') {
	        return item;
	      }
	      return types.getDataTypeNameByCode(item);
	    });
	    const functionsMap = await this._getFunctions(keyspaceName, name, aggregate);
	    return functionsMap.get(signature.join(',')) || null;
	  }

	  /**
	   * Gets the trace session generated by Cassandra when query tracing is enabled for the
	   * query. The trace itself is stored in Cassandra in the <code>sessions</code> and
	   * <code>events</code> table in the <code>system_traces</code> keyspace and can be
	   * retrieve manually using the trace identifier.
	   * <p>
	   *   If a <code>callback</code> is provided, the callback is invoked when the metadata retrieval completes.
	   *   Otherwise, it returns a <code>Promise</code>.
	   * </p>
	   * @param {Uuid} traceId Identifier of the trace session.
	   * @param {Number} [consistency] The consistency level to obtain the trace.
	   * @param {Function} [callback] The callback with the err as first parameter and the query trace as second parameter.
	   */
	  getTrace(traceId, consistency, callback) {
	    if (!callback && typeof consistency === 'function') {
	      // Both callback and consistency are optional parameters
	      // In this case, the second parameter is the callback
	      callback = consistency;
	      consistency = null;
	    }

	    return promiseUtils.optionalCallback(this._getTrace(traceId, consistency), callback);
	  }

	  /**
	   * @param {Uuid} traceId
	   * @param {Number} consistency
	   * @returns {Promise<Object>}
	   * @private
	   */
	  async _getTrace(traceId, consistency) {
	    if (!this.initialized) {
	      throw this._uninitializedError();
	    }

	    let trace;
	    let attempts = 0;
	    const info = ExecutionOptions.empty();
	    info.getConsistency = () => consistency;

	    const sessionRequest = new requests.QueryRequest(util.format(_selectTraceSession, traceId), null, info);
	    const eventsRequest = new requests.QueryRequest(util.format(_selectTraceEvents, traceId), null, info);

	    while (!trace && (attempts++ < _traceMaxAttemps)) {
	      const sessionResponse = await this.controlConnection.query(sessionRequest);
	      const sessionRow = sessionResponse.rows[0];

	      if (!sessionRow || typeof sessionRow['duration'] !== 'number') {
	        await promiseUtils.delay(_traceAttemptDelay);
	        continue;
	      }

	      trace = {
	        requestType: sessionRow['request'],
	        coordinator: sessionRow['coordinator'],
	        parameters: sessionRow['parameters'],
	        startedAt: sessionRow['started_at'],
	        duration: sessionRow['duration'],
	        clientAddress: sessionRow['client'],
	        events: null
	      };

	      const eventsResponse = await this.controlConnection.query(eventsRequest);
	      trace.events = eventsResponse.rows.map(row => ({
	        id: row['event_id'],
	        activity: row['activity'],
	        source: row['source'],
	        elapsed: row['source_elapsed'],
	        thread: row['thread']
	      }));
	    }

	    if (!trace) {
	      throw new Error(`Trace ${traceId.toString()} could not fully retrieved after ${_traceMaxAttemps} attempts`);
	    }

	    return trace;
	  }

	  /**
	   * Checks whether hosts that are currently up agree on the schema definition.
	   * <p>
	   *   This method performs a one-time check only, without any form of retry; therefore
	   *   <code>protocolOptions.maxSchemaAgreementWaitSeconds</code> setting does not apply in this case.
	   * </p>
	   * @param {Function} [callback] A function that is invoked with a value
	   * <code>true</code> when all hosts agree on the schema and <code>false</code> when there is no agreement or when
	   * the check could not be performed (for example, if the control connection is down).
	   * @returns {Promise} Returns a <code>Promise</code> when a callback is not provided. The promise resolves to
	   * <code>true</code> when all hosts agree on the schema and <code>false</code> when there is no agreement or when
	   * the check could not be performed (for example, if the control connection is down).
	   */
	  checkSchemaAgreement(callback) {
	    return promiseUtils.optionalCallback(this._checkSchemaAgreement(), callback);
	  }

	  /**
	   * Async-only version of check schema agreement.
	   * @private
	   */
	  async _checkSchemaAgreement() {
	    const connection = this.controlConnection.connection;
	    if (!connection) {
	      return false;
	    }
	    try {
	      return await this.compareSchemaVersions(connection);
	    }
	    catch (err) {
	      return false;
	    }
	  }

	  /**
	   * Uses the metadata to fill the user provided parameter hints
	   * @param {String} keyspace
	   * @param {Array} hints
	   * @internal
	   * @ignore
	   */
	  async adaptUserHints(keyspace, hints) {
	    if (!Array.isArray(hints)) {
	      return;
	    }
	    const udts = [];
	    // Check for udts and get the metadata
	    for (let i = 0; i < hints.length; i++) {
	      const hint = hints[i];
	      if (typeof hint !== 'string') {
	        continue;
	      }

	      const type = types.dataTypes.getByName(hint);
	      this._checkUdtTypes(udts, type, keyspace);
	      hints[i] = type;
	    }

	    for (const type of udts) {
	      const udtInfo = await this.getUdt(type.info.keyspace, type.info.name);
	      if (!udtInfo) {
	        throw new TypeError('User defined type not found: ' + type.info.keyspace + '.' + type.info.name);
	      }
	      type.info = udtInfo;
	    }
	  }

	  /**
	   * @param {Array} udts
	   * @param {{code, info}} type
	   * @param {string} keyspace
	   * @private
	   */
	  _checkUdtTypes(udts, type, keyspace) {
	    if (type.code === types.dataTypes.udt) {
	      const udtName = type.info.split('.');
	      type.info = {
	        keyspace: udtName[0],
	        name: udtName[1]
	      };
	      if (!type.info.name) {
	        if (!keyspace) {
	          throw new TypeError('No keyspace specified for udt: ' + udtName.join('.'));
	        }
	        //use the provided keyspace
	        type.info.name = type.info.keyspace;
	        type.info.keyspace = keyspace;
	      }
	      udts.push(type);
	      return;
	    }

	    if (!type.info) {
	      return;
	    }
	    if (type.code === types.dataTypes.list || type.code === types.dataTypes.set) {
	      return this._checkUdtTypes(udts, type.info, keyspace);
	    }
	    if (type.code === types.dataTypes.map) {
	      this._checkUdtTypes(udts, type.info[0], keyspace);
	      this._checkUdtTypes(udts, type.info[1], keyspace);
	    }
	  }

	  /**
	   * Uses the provided connection to query the schema versions and compare them.
	   * @param {Connection} connection
	   * @internal
	   * @ignore
	   */
	  async compareSchemaVersions(connection) {
	    const versions = new Set();
	    const response1 = await connection.send(new requests.QueryRequest(_selectSchemaVersionLocal), null);
	    if (response1 && response1.rows && response1.rows.length === 1) {
	      versions.add(response1.rows[0]['schema_version'].toString());
	    }
	    const response2 = await connection.send(new requests.QueryRequest(_selectSchemaVersionPeers), null);
	    if (response2 && response2.rows) {
	      for (const row of response2.rows) {
	        const value = row['schema_version'];
	        if (!value) {
	          continue;
	        }
	        versions.add(value.toString());
	      }
	    }
	    return versions.size === 1;
	  }
	}

	/**
	 * Allows to store prepared queries and retrieval by query or query id.
	 * @ignore
	 */
	class PreparedQueries {

	  /**
	   * @param {Number} maxPrepared
	   * @param {Function} logger
	   */
	  constructor(maxPrepared, logger) {
	    this.length = 0;
	    this._maxPrepared = maxPrepared;
	    this._mapByKey = new Map();
	    this._mapById = new Map();
	    this._logger = logger;
	  }

	  _getKey(keyspace, query) {
	    return (keyspace || '') + query;
	  }

	  getOrAdd(keyspace, query) {
	    const key = this._getKey(keyspace, query);
	    let info = this._mapByKey.get(key);
	    if (info) {
	      return info;
	    }

	    this._validateOverflow();

	    info = new events.EventEmitter();
	    info.setMaxListeners(0);
	    info.query = query;
	    // The keyspace in which it was prepared
	    info.keyspace = keyspace;
	    this._mapByKey.set(key, info);
	    this.length++;
	    return info;
	  }

	  _validateOverflow() {
	    if (this.length < this._maxPrepared) {
	      return;
	    }

	    const toRemove = [];
	    this._logger('warning',
	      'Prepared statements exceeded maximum. This could be caused by preparing queries that contain parameters');

	    const toRemoveLength = this.length - this._maxPrepared + 1;

	    for (const [key, info] of this._mapByKey) {
	      if (!info.queryId) {
	        // Only remove queries that contain queryId
	        continue;
	      }

	      const length = toRemove.push([key, info]);
	      if (length >= toRemoveLength) {
	        break;
	      }
	    }

	    for (const [key, info] of toRemove) {
	      this._mapByKey.delete(key);
	      this._mapById.delete(info.queryId.toString('hex'));
	      this.length--;
	    }
	  }

	  setById(info) {
	    this._mapById.set(info.queryId.toString('hex'), info);
	  }

	  getById(id) {
	    return this._mapById.get(id.toString('hex'));
	  }

	  clear() {
	    this._mapByKey = new Map();
	    this._mapById = new Map();
	    this.length = 0;
	  }

	  getAll() {
	    return Array.from(this._mapByKey.values()).filter(info => !!info.queryId);
	  }
	}

	metadata = Metadata;
	return metadata;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var eventDebouncer;
var hasRequiredEventDebouncer;

function requireEventDebouncer () {
	if (hasRequiredEventDebouncer) return eventDebouncer;
	hasRequiredEventDebouncer = 1;

	const util = require$$0$6;
	const utils = requireUtils$c();
	const promiseUtils = requirePromiseUtils();

	const _queueOverflowThreshold = 1000;

	/**
	 * Debounce protocol events by acting on those events with a sliding delay.
	 * @ignore
	 * @constructor
	 */
	class EventDebouncer {

	  /**
	   * Creates a new instance of the event debouncer.
	   * @param {Number} delay
	   * @param {Function} logger
	   */
	  constructor(delay, logger) {
	    this._delay = delay;
	    this._logger = logger;
	    this._queue = null;
	    this._timeout = null;
	  }

	  /**
	   * Adds a new event to the queue and moves the delay.
	   * @param {{ handler: Function, all: boolean|undefined, keyspace: String|undefined,
	   * cqlObject: String|null|undefined }} event
	   * @param {Boolean} processNow
	   * @returns {Promise}
	   */
	  eventReceived(event, processNow) {
	    return new Promise((resolve, reject) => {
	      event.callback = promiseUtils.getCallback(resolve, reject);
	      this._queue = this._queue || { callbacks: [], keyspaces: {} };
	      const delay = !processNow ? this._delay : 0;
	      if (event.all) {
	        // when an event marked with all is received, it supersedes all the rest of events
	        // a full update (hosts + keyspaces + tokens) is going to be made
	        this._queue.mainEvent = event;
	      }
	      if (this._queue.callbacks.length === _queueOverflowThreshold) {
	        // warn once
	        this._logger('warn', util.format('Event debouncer queue exceeded %d events', _queueOverflowThreshold));
	      }
	      this._queue.callbacks.push(event.callback);
	      if (this._queue.mainEvent) {
	        // a full refresh is scheduled and the callback was added, nothing else to do.
	        return this._slideDelay(delay);
	      }
	      // Insert at keyspace level
	      let keyspaceEvents = this._queue.keyspaces[event.keyspace];
	      if (!keyspaceEvents) {
	        keyspaceEvents = this._queue.keyspaces[event.keyspace] = { events: [] };
	      }
	      if (event.cqlObject === undefined) {
	        // a full refresh of the keyspace, supersedes all child keyspace events
	        keyspaceEvents.mainEvent = event;
	      }
	      keyspaceEvents.events.push(event);
	      this._slideDelay(delay);
	    });
	  }

	  /**
	   * @param {Number} delay
	   * @private
	   * */
	  _slideDelay(delay) {
	    const self = this;
	    function process() {
	      const q = self._queue;
	      self._queue = null;
	      self._timeout = null;
	      processQueue(q);
	    }
	    if (delay === 0) {
	      // no delay, process immediately
	      if (this._timeout) {
	        clearTimeout(this._timeout);
	      }
	      return process();
	    }
	    const previousTimeout = this._timeout;
	    // Add the new timeout before removing the previous one performs better
	    this._timeout = setTimeout(process, delay);
	    if (previousTimeout) {
	      clearTimeout(previousTimeout);
	    }
	  }

	  /**
	   * Clears the timeout and invokes all pending callback.
	   */
	  shutdown() {
	    if (!this._queue) {
	      return;
	    }
	    this._queue.callbacks.forEach(function (cb) {
	      cb();
	    });
	    this._queue = null;
	    clearTimeout(this._timeout);
	    this._timeout = null;
	  }
	}

	/**
	 * @param {{callbacks: Array, keyspaces: Object, mainEvent: Object}} q
	 * @private
	 */
	function processQueue (q) {
	  if (q.mainEvent) {
	    // refresh all by invoking 1 handler and invoke all pending callbacks
	    return promiseUtils.toCallback(q.mainEvent.handler(), (err) => {
	      for (let i = 0; i < q.callbacks.length; i++) {
	        q.callbacks[i](err);
	      }
	    });
	  }

	  utils.each(Object.keys(q.keyspaces), function eachKeyspace(name, next) {
	    const keyspaceEvents = q.keyspaces[name];
	    if (keyspaceEvents.mainEvent) {
	      // refresh a keyspace
	      return promiseUtils.toCallback(keyspaceEvents.mainEvent.handler(), function mainEventCallback(err) {
	        for (let i = 0; i < keyspaceEvents.events.length; i++) {
	          keyspaceEvents.events[i].callback(err);
	        }

	        next();
	      });
	    }

	    // deal with individual handlers and callbacks
	    keyspaceEvents.events.forEach(event => {
	      // sync handlers
	      event.handler();
	      event.callback();
	    });

	    next();
	  });
	}

	eventDebouncer = EventDebouncer;
	return eventDebouncer;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var controlConnection;
var hasRequiredControlConnection;

function requireControlConnection () {
	if (hasRequiredControlConnection) return controlConnection;
	hasRequiredControlConnection = 1;
	const events = require$$0$8;
	const util = require$$0$6;
	const net = require$$0$7;
	const dns = require$$0$9;

	const errors = requireErrors$c();
	const { Host, HostMap } = requireHost();
	const Metadata = requireMetadata();
	const EventDebouncer = requireEventDebouncer();
	const Connection = requireConnection$6();
	const requests = requireRequests();
	const utils = requireUtils$c();
	const types = requireTypes$2();
	const promiseUtils = requirePromiseUtils();
	const f = util.format;

	const selectPeers = "SELECT * FROM system.peers";
	const selectLocal = "SELECT * FROM system.local WHERE key='local'";
	const newNodeDelay = 1000;
	const metadataQueryAbortTimeout = 2000;
	const schemaChangeTypes = {
	  created: 'CREATED',
	  updated: 'UPDATED',
	  dropped: 'DROPPED'
	};
	const supportedProductTypeKey = 'PRODUCT_TYPE';
	const supportedDbaas = 'DATASTAX_APOLLO';

	/**
	 * Represents a connection used by the driver to receive events and to check the status of the cluster.
	 * <p>It uses an existing connection from the hosts' connection pool to maintain the driver metadata up-to-date.</p>
	 */
	class ControlConnection extends events.EventEmitter {

	  /**
	   * Creates a new instance of <code>ControlConnection</code>.
	   * @param {Object} options
	   * @param {ProfileManager} profileManager
	   * @param {{borrowHostConnection: function, createConnection: function}} [context] An object containing methods to
	   * allow dependency injection.
	   */
	  constructor(options, profileManager, context) {
	    super();

	    this.protocolVersion = null;
	    this.hosts = new HostMap();
	    this.setMaxListeners(0);
	    this.log = utils.log;
	    Object.defineProperty(this, "options", { value: options, enumerable: false, writable: false});

	    /**
	     * Cluster metadata that is going to be shared between the Client and ControlConnection
	     */
	    this.metadata = new Metadata(this.options, this);
	    this.initialized = false;

	    /**
	     * Host used by the control connection
	     * @type {Host|null}
	     */
	    this.host = null;

	    /**
	     * Connection used to retrieve metadata and subscribed to events
	     * @type {Connection|null}
	     */
	    this.connection = null;

	    this._addressTranslator = this.options.policies.addressResolution;
	    this._reconnectionPolicy = this.options.policies.reconnection;
	    this._reconnectionSchedule = this._reconnectionPolicy.newSchedule();
	    this._isShuttingDown = false;

	    // Reference to the encoder of the last valid connection
	    this._encoder = null;
	    this._debouncer = new EventDebouncer(options.refreshSchemaDelay, this.log.bind(this));
	    this._profileManager = profileManager;
	    this._triedHosts = null;
	    this._resolvedContactPoints = new Map();
	    this._contactPoints = new Set();

	    // Timeout used for delayed handling of topology changes
	    this._topologyChangeTimeout = null;
	    // Timeout used for delayed handling of node status changes
	    this._nodeStatusChangeTimeout = null;

	    if (context && context.borrowHostConnection) {
	      this._borrowHostConnection = context.borrowHostConnection;
	    }

	    if (context && context.createConnection) {
	      this._createConnection = context.createConnection;
	    }
	  }

	  /**
	   * Stores the contact point information and what it resolved to.
	   * @param {String|null} address
	   * @param {String} port
	   * @param {String} name
	   * @param {Boolean} isIPv6
	   */
	  _addContactPoint(address, port, name, isIPv6) {
	    if (address === null) {
	      // Contact point could not be resolved, store that the resolution came back empty
	      this._resolvedContactPoints.set(name, utils.emptyArray);
	      return;
	    }

	    const portNumber = parseInt(port, 10) || this.options.protocolOptions.port;
	    const endpoint = `${address}:${portNumber}`;
	    this._contactPoints.add(endpoint);

	    // Use RFC 3986 for IPv4 and IPv6
	    const standardEndpoint = !isIPv6 ? endpoint : `[${address}]:${portNumber}`;

	    let resolvedAddressedByName = this._resolvedContactPoints.get(name);

	    // NODEJS-646
	    //
	    // We might have a frozen empty array if DNS resolution wasn't working when this name was
	    // initially added, and if that's the case we can't add anything.  Detect that case and
	    // reset to a mutable array.
	    if (resolvedAddressedByName === undefined || resolvedAddressedByName === utils.emptyArray) {
	      resolvedAddressedByName = [];
	      this._resolvedContactPoints.set(name, resolvedAddressedByName);
	    }

	    resolvedAddressedByName.push(standardEndpoint);
	  }

	  async _parseContactPoint(name) {
	    let addressOrName = name;
	    let port = null;

	    if (name.indexOf('[') === 0 && name.indexOf(']:') > 1) {
	      // IPv6 host notation [ip]:port (RFC 3986 section 3.2.2)
	      const index = name.lastIndexOf(']:');
	      addressOrName = name.substr(1, index - 1);
	      port = name.substr(index + 2);
	    } else if (name.indexOf(':') > 0) {
	      // IPv4 or host name with port notation
	      const parts = name.split(':');
	      if (parts.length === 2) {
	        addressOrName = parts[0];
	        port = parts[1];
	      }
	    }

	    if (net.isIP(addressOrName)) {
	      this._addContactPoint(addressOrName, port, name, net.isIPv6(addressOrName));
	      return;
	    }

	    const addresses = await this._resolveAll(addressOrName);
	    if (addresses.length > 0) {
	      addresses.forEach(addressInfo => this._addContactPoint(addressInfo.address, port, name, addressInfo.isIPv6));
	    } else {
	      // Store that we attempted resolving the name but was not found
	      this._addContactPoint(null, null, name, false);
	    }
	  }

	  /**
	   * Initializes the control connection by establishing a Connection using a suitable protocol
	   * version to be used and retrieving cluster metadata.
	   */
	  async init() {
	    if (this.initialized) {
	      // Prevent multiple serial initializations
	      return;
	    }

	    if (!this.options.sni) {
	      // Parse and resolve contact points
	      await Promise.all(this.options.contactPoints.map(name => this._parseContactPoint(name)));
	    } else {
	      this.options.contactPoints.forEach(cp => this._contactPoints.add(cp));
	      const address = this.options.sni.address;
	      const separatorIndex = address.lastIndexOf(':');

	      if (separatorIndex === -1) {
	        throw new new errors.DriverInternalError('The SNI endpoint address should contain ip/name and port');
	      }

	      const nameOrIp = address.substr(0, separatorIndex);
	      this.options.sni.port = address.substr(separatorIndex + 1);
	      this.options.sni.addressResolver = new utils.AddressResolver({ nameOrIp, dns });
	      await this.options.sni.addressResolver.init();
	    }

	    if (this._contactPoints.size === 0) {
	      throw new errors.NoHostAvailableError({}, 'No host could be resolved');
	    }

	    await this._initializeConnection();
	  }

	  _setHealthListeners(host, connection) {
	    const self = this;
	    let wasRefreshCalled = 0;

	    function removeListeners() {
	      host.removeListener('down', downOrIgnoredHandler);
	      host.removeListener('ignore', downOrIgnoredHandler);
	      connection.removeListener('socketClose', socketClosedHandler);
	    }

	    function startReconnecting(hostDown) {
	      if (wasRefreshCalled++ !== 0) {
	        // Prevent multiple calls to reconnect
	        return;
	      }

	      removeListeners();

	      if (self._isShuttingDown) {
	        // Don't attempt to reconnect when the ControlConnection is being shutdown
	        return;
	      }

	      if (hostDown) {
	        self.log('warning',
	          `Host ${host.address} used by the ControlConnection DOWN, ` +
	          `connection to ${connection.endpointFriendlyName} will not longer be used`);
	      } else {
	        self.log('warning', `Connection to ${connection.endpointFriendlyName} used by the ControlConnection was closed`);
	      }

	      promiseUtils.toBackground(self._refresh());
	    }

	    function downOrIgnoredHandler() {
	      startReconnecting(true);
	    }

	    function socketClosedHandler() {
	      startReconnecting(false);
	    }

	    host.once('down', downOrIgnoredHandler);
	    host.once('ignore', downOrIgnoredHandler);
	    connection.once('socketClose', socketClosedHandler);
	  }

	  /**
	   * Iterates through the hostIterator and Gets the following open connection.
	   * @param {Iterator<Host>} hostIterator
	   * @returns {Connection!}
	   */
	  _borrowAConnection(hostIterator) {
	    let connection = null;

	    while (!connection) {
	      const item = hostIterator.next();
	      const host = item.value;

	      if (item.done) {
	        throw new errors.NoHostAvailableError(this._triedHosts);
	      }

	      // Only check distance once the load-balancing policies have been initialized
	      const distance = this._profileManager.getDistance(host);
	      if (!host.isUp() || distance === types.distance.ignored) {
	        continue;
	      }

	      try {
	        connection = this._borrowHostConnection(host);
	      } catch (err) {
	        this._triedHosts[host.address] = err;
	      }
	    }

	    return connection;
	  }

	  /**
	   * Iterates through the contact points and tries to open a connection.
	   * @param {Iterator<string>} contactPointsIterator
	   * @returns {Promise<void>}
	   */
	  async _borrowFirstConnection(contactPointsIterator) {
	    let connection = null;

	    while (!connection) {
	      const item = contactPointsIterator.next();
	      const contactPoint = item.value;

	      if (item.done) {
	        throw new errors.NoHostAvailableError(this._triedHosts);
	      }

	      try {
	        connection = await this._createConnection(contactPoint);
	      } catch (err) {
	        this._triedHosts[contactPoint] = err;
	      }
	    }

	    if (!connection) {
	      const err = new errors.NoHostAvailableError(this._triedHosts);
	      this.log('error', 'ControlConnection failed to acquire a connection');
	      throw err;
	    }

	    this.protocolVersion = connection.protocolVersion;
	    this._encoder = connection.encoder;
	    this.connection = connection;
	  }

	  /** Default implementation for borrowing connections, that can be injected at constructor level */
	  _borrowHostConnection(host) {
	    // Borrow any open connection, regardless of the keyspace
	    return host.borrowConnection();
	  }

	  /**
	   * Default implementation for creating initial connections, that can be injected at constructor level
	   * @param {String} contactPoint
	   */
	  async _createConnection(contactPoint) {
	    const c = new Connection(contactPoint, null, this.options);

	    try {
	      await c.openAsync();
	    } catch (err) {
	      promiseUtils.toBackground(c.closeAsync());
	      throw err;
	    }

	    return c;
	  }

	  /**
	   * Gets the info from local and peer metadata, reloads the keyspaces metadata and rebuilds tokens.
	   * <p>It throws an error when there's a failure or when reconnecting and there's no connection.</p>
	   * @param {Boolean} initializing Determines whether this function was called in order to initialize the control
	   * connection the first time
	   * @param {Boolean} isReconnecting Determines whether the refresh is being done because the ControlConnection is
	   * switching to use this connection to this host.
	   */
	  async _refreshHosts(initializing, isReconnecting) {
	    // Get a reference to the current connection as it might change from external events
	    const c = this.connection;

	    if (!c) {
	      if (isReconnecting) {
	        throw new errors.DriverInternalError('Connection reference has been lost when reconnecting');
	      }

	      // it's possible that this was called as a result of a topology change, but the connection was lost
	      // between scheduling time and now. This will be called again when there is a new connection.
	      return;
	    }

	    this.log('info', 'Refreshing local and peers info');

	    const rsLocal = await c.send(new requests.QueryRequest(selectLocal), null);
	    this._setLocalInfo(initializing, isReconnecting, c, rsLocal);

	    if (!this.host) {
	      throw new errors.DriverInternalError('Information from system.local could not be retrieved');
	    }

	    const rsPeers = await c.send(new requests.QueryRequest(selectPeers), null);
	    await this.setPeersInfo(initializing, rsPeers);

	    if (!this.initialized) {
	      // resolve protocol version from highest common version among hosts.
	      const highestCommon = types.protocolVersion.getHighestCommon(c, this.hosts);
	      const reconnect = highestCommon !== this.protocolVersion;

	      // set protocol version on each host.
	      this.protocolVersion = highestCommon;
	      this.hosts.forEach(h => h.setProtocolVersion(this.protocolVersion));

	      // if protocol version changed, reconnect the control connection with new version.
	      if (reconnect) {
	        this.log('info', `Reconnecting since the protocol version changed to 0x${highestCommon.toString(16)}`);
	        c.decreaseVersion(this.protocolVersion);
	        await c.closeAsync();

	        try {
	          await c.openAsync();
	        } catch (err) {
	          // Close in the background
	          promiseUtils.toBackground(c.closeAsync());

	          throw err;
	        }
	      }

	      // To acquire metadata we need to specify the cassandra version
	      this.metadata.setCassandraVersion(this.host.getCassandraVersion());
	      this.metadata.buildTokens(this.hosts);

	      if (!this.options.isMetadataSyncEnabled) {
	        this.metadata.initialized = true;
	        return;
	      }

	      await this.metadata.refreshKeyspacesInternal(false);
	      this.metadata.initialized = true;
	    }
	  }

	  async _refreshControlConnection(hostIterator) {

	    if (this.options.sni) {
	      this.connection = this._borrowAConnection(hostIterator);
	    }
	    else {
	      try { this.connection = this._borrowAConnection(hostIterator); }
	      catch(err) {

	        /* NODEJS-632: refresh nodes before getting hosts for reconnect since some hostnames may have
	         * shifted during the flight. */
	        this.log("info", "ControlConnection could not reconnect using existing connections.  Refreshing contact points and retrying");
	        this._contactPoints.clear();
	        this._resolvedContactPoints.clear();
	        await Promise.all(this.options.contactPoints.map(name => this._parseContactPoint(name)));
	        const refreshedContactPoints = Array.from(this._contactPoints).join(',');
	        this.log('info', `Refreshed contact points: ${refreshedContactPoints}`);
	        await this._initializeConnection();
	      }
	    }
	  }

	  /**
	   * Acquires a new connection and refreshes topology and keyspace metadata.
	   * <p>When it fails obtaining a connection and there aren't any more hosts, it schedules reconnection.</p>
	   * <p>When it fails obtaining the metadata, it marks connection and/or host unusable and retries using the same
	   * iterator from query plan / host list</p>
	   * @param {Iterator<Host>} [hostIterator]
	   */
	  async _refresh(hostIterator) {
	    if (this._isShuttingDown) {
	      this.log('info', 'The ControlConnection will not be refreshed as the Client is being shutdown');
	      return;
	    }

	    // Reset host and connection
	    this.host = null;
	    this.connection = null;

	    try {
	      if (!hostIterator) {
	        this.log('info', 'Trying to acquire a connection to a new host');
	        this._triedHosts = {};
	        hostIterator = await promiseUtils.newQueryPlan(this._profileManager.getDefaultLoadBalancing(), null, null);
	      }

	      await this._refreshControlConnection(hostIterator);
	    } catch (err) {
	      // There was a failure obtaining a connection or during metadata retrieval
	      this.log('error', 'ControlConnection failed to acquire a connection', err);

	      if (!this._isShuttingDown) {
	        const delay = this._reconnectionSchedule.next().value;
	        this.log('warning', `ControlConnection could not reconnect, scheduling reconnection in ${delay}ms`);
	        setTimeout(() => this._refresh(), delay);
	        this.emit('newConnection', err);
	      }

	      return;
	    }

	    this.log('info',`ControlConnection connected to ${this.connection.endpointFriendlyName}`);

	    try {
	      await this._refreshHosts(false, true);

	      await this._registerToConnectionEvents();
	    } catch (err) {
	      this.log('error', 'ControlConnection failed to retrieve topology and keyspaces information', err);
	      this._triedHosts[this.connection.endpoint] = err;

	      if (err.isSocketError && this.host) {
	        this.host.removeFromPool(this.connection);
	      }

	      // Retry the whole thing with the same query plan
	      return await this._refresh(hostIterator);
	    }

	    this._reconnectionSchedule = this._reconnectionPolicy.newSchedule();
	    this._setHealthListeners(this.host, this.connection);
	    this.emit('newConnection', null, this.connection, this.host);

	    this.log('info', `ControlConnection connected to ${this.connection.endpointFriendlyName} and up to date`);
	  }

	  /**
	   * Acquires a connection and refreshes topology and keyspace metadata for the first time.
	   * @returns {Promise<void>}
	   */
	  async _initializeConnection() {
	    this.log('info', 'Getting first connection');

	    // Reset host and connection
	    this.host = null;
	    this.connection = null;
	    this._triedHosts = {};

	    // Randomize order of contact points resolved.
	    const contactPointsIterator = utils.shuffleArray(Array.from(this._contactPoints))[Symbol.iterator]();

	    while (true) {
	      await this._borrowFirstConnection(contactPointsIterator);

	      this.log('info', `ControlConnection using protocol version 0x${
	        this.protocolVersion.toString(16)}, connected to ${this.connection.endpointFriendlyName}`);

	      try {
	        await this._getSupportedOptions();
	        await this._refreshHosts(true, true);
	        await this._registerToConnectionEvents();

	        // We have a valid connection, leave the loop
	        break;

	      } catch (err) {
	        this.log('error', 'ControlConnection failed to retrieve topology and keyspaces information', err);
	        this._triedHosts[this.connection.endpoint] = err;
	      }
	    }

	    // The healthy connection used to initialize should be part of the Host pool
	    this.host.pool.addExistingConnection(this.connection);

	    this.initialized = true;
	    this._setHealthListeners(this.host, this.connection);
	    this.log('info', `ControlConnection connected to ${this.connection.endpointFriendlyName}`);
	  }

	  async _getSupportedOptions() {
	    const response = await this.connection.send(requests.options, null);

	    // response.supported is a string multi map, decoded as an Object.
	    const productType = response.supported && response.supported[supportedProductTypeKey];
	    if (Array.isArray(productType) && productType[0] === supportedDbaas) {
	      this.metadata.setProductTypeAsDbaas();
	    }
	  }

	  async _registerToConnectionEvents() {
	    this.connection.on('nodeTopologyChange', this._nodeTopologyChangeHandler.bind(this));
	    this.connection.on('nodeStatusChange', this._nodeStatusChangeHandler.bind(this));
	    this.connection.on('nodeSchemaChange', this._nodeSchemaChangeHandler.bind(this));
	    const request = new requests.RegisterRequest(['TOPOLOGY_CHANGE', 'STATUS_CHANGE', 'SCHEMA_CHANGE']);
	    await this.connection.send(request, null);
	  }

	  /**
	   * Handles a TOPOLOGY_CHANGE event
	   */
	  _nodeTopologyChangeHandler(event) {
	    this.log('info', 'Received topology change', event);

	    // all hosts information needs to be refreshed as tokens might have changed
	    clearTimeout(this._topologyChangeTimeout);

	    // Use an additional timer to make sure that the refresh hosts is executed only AFTER the delay
	    // In this case, the event debouncer doesn't help because it could not honor the sliding delay (ie: processNow)
	    this._topologyChangeTimeout = setTimeout(() =>
	      promiseUtils.toBackground(this._scheduleRefreshHosts()), newNodeDelay);
	  }

	  /**
	   * Handles a STATUS_CHANGE event
	   */
	  _nodeStatusChangeHandler(event) {
	    const self = this;
	    const addressToTranslate = event.inet.address.toString();
	    const port = this.options.protocolOptions.port;
	    this._addressTranslator.translate(addressToTranslate, port, function translateCallback(endPoint) {
	      const host = self.hosts.get(endPoint);
	      if (!host) {
	        self.log('warning', 'Received status change event but host was not found: ' + addressToTranslate);
	        return;
	      }
	      const distance = self._profileManager.getDistance(host);
	      if (event.up) {
	        if (distance === types.distance.ignored) {
	          return host.setUp(true);
	        }
	        clearTimeout(self._nodeStatusChangeTimeout);
	        // Waits a couple of seconds before marking it as UP
	        self._nodeStatusChangeTimeout = setTimeout(() => host.checkIsUp(), newNodeDelay);
	        return;
	      }
	      // marked as down
	      if (distance === types.distance.ignored) {
	        return host.setDown();
	      }
	      self.log('warning', 'Received status change to DOWN for host ' + host.address);
	    });
	  }

	  /**
	   * Handles a SCHEMA_CHANGE event
	   */
	  _nodeSchemaChangeHandler(event) {
	    this.log('info', 'Schema change', event);
	    if (!this.options.isMetadataSyncEnabled) {
	      return;
	    }

	    promiseUtils.toBackground(this.handleSchemaChange(event, false));
	  }

	  /**
	   * Schedules metadata refresh and callbacks when is refreshed.
	   * @param {{keyspace: string, isKeyspace: boolean, schemaChangeType, table, udt, functionName, aggregate}} event
	   * @param {Boolean} processNow
	   * @returns {Promise<void>}
	   */
	  handleSchemaChange(event, processNow) {
	    const self = this;
	    let handler, cqlObject;

	    if (event.isKeyspace) {
	      if (event.schemaChangeType === schemaChangeTypes.dropped) {
	        handler = function removeKeyspace() {
	          // if on the same event queue there is a creation, this handler is not going to be executed
	          // it is safe to remove the keyspace metadata
	          delete self.metadata.keyspaces[event.keyspace];
	        };

	        return this._scheduleObjectRefresh(handler, event.keyspace, null, processNow);
	      }

	      return this._scheduleKeyspaceRefresh(event.keyspace, processNow);
	    }

	    const ksInfo = this.metadata.keyspaces[event.keyspace];
	    if (!ksInfo) {
	      // it hasn't been loaded and it is not part of the metadata, don't mind
	      return Promise.resolve();
	    }

	    if (event.table) {
	      cqlObject = event.table;
	      handler = function clearTableState() {
	        delete ksInfo.tables[event.table];
	        delete ksInfo.views[event.table];
	      };
	    }
	    else if (event.udt) {
	      cqlObject = event.udt;
	      handler = function clearUdtState() {
	        delete ksInfo.udts[event.udt];
	      };
	    }
	    else if (event.functionName) {
	      cqlObject = event.functionName;
	      handler = function clearFunctionState() {
	        delete ksInfo.functions[event.functionName];
	      };
	    }
	    else if (event.aggregate) {
	      cqlObject = event.aggregate;
	      handler = function clearKeyspaceState() {
	        delete ksInfo.aggregates[event.aggregate];
	      };
	    }

	    if (!handler) {
	      // Forward compatibility
	      return Promise.resolve();
	    }

	    // It's a cql object change clean the internal cache
	    return this._scheduleObjectRefresh(handler, event.keyspace, cqlObject, processNow);
	  }

	  /**
	   * @param {Function} handler
	   * @param {String} keyspace
	   * @param {String} cqlObject
	   * @param {Boolean} processNow
	   * @returns {Promise<void>}
	   */
	  _scheduleObjectRefresh(handler, keyspace, cqlObject, processNow) {
	    return this._debouncer.eventReceived({ handler, keyspace, cqlObject }, processNow);
	  }

	  /**
	   * @param {String} keyspace
	   * @param {Boolean} processNow
	   * @returns {Promise<void>}
	   */
	  _scheduleKeyspaceRefresh(keyspace, processNow) {
	    return this._debouncer.eventReceived({
	      handler: () => this.metadata.refreshKeyspace(keyspace),
	      keyspace
	    }, processNow);
	  }

	  /** @returns {Promise<void>} */
	  _scheduleRefreshHosts() {
	    return this._debouncer.eventReceived({
	      handler: () => this._refreshHosts(false, false),
	      all: true
	    }, false);
	  }

	  /**
	   * Sets the information for the host used by the control connection.
	   * @param {Boolean} initializing
	   * @param {Connection} c
	   * @param {Boolean} setCurrentHost Determines if the host retrieved must be set as the current host
	   * @param result
	   */
	  _setLocalInfo(initializing, setCurrentHost, c, result) {
	    if (!result || !result.rows || !result.rows.length) {
	      this.log('warning', 'No local info could be obtained');
	      return;
	    }

	    const row = result.rows[0];

	    let localHost;

	    // Note that with SNI enabled, we can trust that rpc_address will contain a valid value.
	    const endpoint = !this.options.sni
	      ? c.endpoint
	      : `${row['rpc_address']}:${this.options.protocolOptions.port}`;

	    if (initializing) {
	      localHost = new Host(endpoint, this.protocolVersion, this.options, this.metadata);
	      this.hosts.set(endpoint, localHost);
	      this.log('info', `Adding host ${endpoint}`);
	    } else {
	      localHost = this.hosts.get(endpoint);

	      if (!localHost) {
	        this.log('error', 'Localhost could not be found');
	        return;
	      }
	    }

	    localHost.datacenter = row['data_center'];
	    localHost.rack = row['rack'];
	    localHost.tokens = row['tokens'];
	    localHost.hostId = row['host_id'];
	    localHost.cassandraVersion = row['release_version'];
	    setDseParameters(localHost, row);
	    this.metadata.setPartitioner(row['partitioner']);
	    this.log('info', 'Local info retrieved');

	    if (setCurrentHost) {
	      // Set the host as the one being used by the ControlConnection.
	      this.host = localHost;
	    }
	  }

	  /**
	   * @param {Boolean} initializing Determines whether this function was called in order to initialize the control
	   * connection the first time.
	   * @param {ResultSet} result
	   */
	  async setPeersInfo(initializing, result) {
	    if (!result || !result.rows) {
	      return;
	    }

	    // A map of peers, could useful for in case there are discrepancies
	    const peers = {};
	    const port = this.options.protocolOptions.port;
	    const foundDataCenters = new Set();

	    if (this.host && this.host.datacenter) {
	      foundDataCenters.add(this.host.datacenter);
	    }

	    for (const row of result.rows) {
	      const endpoint = await this.getAddressForPeerHost(row, port);

	      if (!endpoint) {
	        continue;
	      }

	      peers[endpoint] = true;
	      let host = this.hosts.get(endpoint);
	      let isNewHost = !host;

	      if (isNewHost) {
	        host = new Host(endpoint, this.protocolVersion, this.options, this.metadata);
	        this.log('info', `Adding host ${endpoint}`);
	        isNewHost = true;
	      }

	      host.datacenter = row['data_center'];
	      host.rack = row['rack'];
	      host.tokens = row['tokens'];
	      host.hostId = row['host_id'];
	      host.cassandraVersion = row['release_version'];
	      setDseParameters(host, row);

	      if (host.datacenter) {
	        foundDataCenters.add(host.datacenter);
	      }

	      if (isNewHost) {
	        // Add it to the map (and trigger events) after all the properties
	        // were set to avoid race conditions
	        this.hosts.set(endpoint, host);

	        if (!initializing) {
	          // Set the distance at Host level, that way the connection pool is created with the correct settings
	          this._profileManager.getDistance(host);

	          // When we are not initializing, we start with the node set as DOWN
	          host.setDown();
	        }
	      }
	    }

	    // Is there a difference in number between peers + local != hosts
	    if (this.hosts.length > result.rows.length + 1) {
	      // There are hosts in the current state that don't belong (nodes removed or wrong contactPoints)
	      this.log('info', 'Removing nodes from the pool');
	      const toRemove = [];

	      this.hosts.forEach(h => {
	        //It is not a peer and it is not local host
	        if (!peers[h.address] && h !== this.host) {
	          this.log('info', 'Removing host ' + h.address);
	          toRemove.push(h.address);
	          h.shutdown(true);
	        }
	      });

	      this.hosts.removeMultiple(toRemove);
	    }

	    if (initializing && this.options.localDataCenter) {
	      const localDc = this.options.localDataCenter;

	      if (!foundDataCenters.has(localDc)) {
	        throw new errors.ArgumentError(`localDataCenter was configured as '${
	          localDc}', but only found hosts in data centers: [${Array.from(foundDataCenters).join(', ')}]`);
	      }
	    }

	    this.log('info', 'Peers info retrieved');
	  }

	  /**
	   * Gets the address from a peers row and translates the address.
	   * @param {Object|Row} row
	   * @param {Number} defaultPort
	   * @returns {Promise<string>}
	   */
	  getAddressForPeerHost(row, defaultPort) {
	    return new Promise(resolve => {
	      let address = row['rpc_address'];
	      const peer = row['peer'];
	      const bindAllAddress = '0.0.0.0';

	      if (!address) {
	        this.log('error', f('No rpc_address found for host %s in %s\'s peers system table. %s will be ignored.',
	          peer, this.host.address, peer));
	        return resolve(null);
	      }

	      if (address.toString() === bindAllAddress) {
	        this.log('warning', f('Found host with 0.0.0.0 as rpc_address, using listen_address (%s) to contact it instead.' +
	          ' If this is incorrect you should avoid the use of 0.0.0.0 server side.', peer));
	        address = peer;
	      }

	      this._addressTranslator.translate(address.toString(), defaultPort, resolve);
	    });
	  }

	  /**
	   * Uses the DNS protocol to resolve a IPv4 and IPv6 addresses (A and AAAA records) for the hostname.
	   * It returns an Array of addresses that can be empty and logs the error.
	   * @private
	   * @param name
	   */
	  async _resolveAll(name) {
	    const addresses = [];
	    const resolve4 = util.promisify(dns.resolve4);
	    const resolve6 = util.promisify(dns.resolve6);
	    const lookup = util.promisify(dns.lookup);

	    // Ignore errors for resolve calls
	    const ipv4Promise = resolve4(name).catch(() => {}).then(r => r || utils.emptyArray);
	    const ipv6Promise = resolve6(name).catch(() => {}).then(r => r || utils.emptyArray);

	    let arr;
	    arr = await ipv4Promise;
	    arr.forEach(address => addresses.push({address, isIPv6: false}));

	    arr = await ipv6Promise;
	    arr.forEach(address => addresses.push({address, isIPv6: true}));

	    if (addresses.length === 0) {
	      // In case dns.resolve*() methods don't yield a valid address for the host name
	      // Use system call getaddrinfo() that might resolve according to host system definitions
	      try {
	        arr = await lookup(name, { all: true });
	        arr.forEach(({address, family}) => addresses.push({address, isIPv6: family === 6}));
	      } catch (err) {
	        this.log('error', `Host with name ${name} could not be resolved`, err);
	      }
	    }

	    return addresses;
	  }

	  /**
	   * Waits for a connection to be available. If timeout expires before getting a connection it callbacks in error.
	   * @returns {Promise<void>}
	   */
	  _waitForReconnection() {
	    return new Promise((resolve, reject) => {
	      const callback = promiseUtils.getCallback(resolve, reject);

	      // eslint-disable-next-line prefer-const
	      let timeout;

	      function newConnectionListener(err) {
	        clearTimeout(timeout);
	        callback(err);
	      }

	      this.once('newConnection', newConnectionListener);

	      timeout = setTimeout(() => {
	        this.removeListener('newConnection', newConnectionListener);
	        callback(new errors.OperationTimedOutError('A connection could not be acquired before timeout.'));
	      }, metadataQueryAbortTimeout);
	    });
	  }

	  /**
	   * Executes a query using the active connection
	   * @param {String|Request} cqlQuery
	   * @param {Boolean} [waitReconnect] Determines if it should wait for reconnection in case the control connection is not
	   * connected at the moment. Default: true.
	   */
	  async query(cqlQuery, waitReconnect = true) {
	    const queryOnConnection = async () => {
	      if (!this.connection || this._isShuttingDown) {
	        throw new errors.NoHostAvailableError({}, 'ControlConnection is not connected at the time');
	      }

	      const request = typeof cqlQuery === 'string' ? new requests.QueryRequest(cqlQuery, null, null) : cqlQuery;
	      return await this.connection.send(request, null);
	    };

	    if (!this.connection && waitReconnect) {
	      // Wait until its reconnected (or timer elapses)
	      await this._waitForReconnection();
	    }

	    return await queryOnConnection();
	  }

	  /** @returns {Encoder} The encoder used by the current connection */
	  getEncoder() {
	    if (!this._encoder) {
	      throw new errors.DriverInternalError('Encoder is not defined');
	    }
	    return this._encoder;
	  }

	  /**
	   * Cancels all timers and shuts down synchronously.
	   */
	  shutdown() {
	    this._isShuttingDown = true;
	    this._debouncer.shutdown();
	    // Emit a "newConnection" event with Error, as it may clear timeouts that were waiting new connections
	    this.emit('newConnection', new errors.DriverError('ControlConnection is being shutdown'));
	    // Cancel timers
	    clearTimeout(this._topologyChangeTimeout);
	    clearTimeout(this._nodeStatusChangeTimeout);
	  }

	  /**
	   * Resets the Connection to its initial state.
	   */
	  async reset() {
	    // Reset the internal state of the ControlConnection for future initialization attempts
	    const currentHosts = this.hosts.clear();

	    // Set the shutting down flag temporarily to avoid reconnects.
	    this._isShuttingDown = true;

	    // Shutdown all individual pools, ignoring any shutdown error
	    await Promise.all(currentHosts.map(h => h.shutdown()));

	    this.initialized = false;
	    this._isShuttingDown = false;
	  }

	  /**
	   * Gets a Map containing the original contact points and the addresses that each one resolved to.
	   */
	  getResolvedContactPoints() {
	    return this._resolvedContactPoints;
	  }

	  /**
	   * Gets the local IP address to which the control connection socket is bound to.
	   * @returns {String|undefined}
	   */
	  getLocalAddress() {
	    if (!this.connection) {
	      return undefined;
	    }

	    return this.connection.getLocalAddress();
	  }

	  /**
	   * Gets the address and port of host the control connection is connected to.
	   * @returns {String|undefined}
	   */
	  getEndpoint() {
	    if (!this.connection) {
	      return undefined;
	    }

	    return this.connection.endpoint;
	  }
	}

	/**
	 * Parses the DSE workload and assigns it to a host.
	 * @param {Host} host
	 * @param {Row} row
	 * @private
	 */
	function setDseParameters(host, row) {
	  if (row['workloads'] !== undefined) {
	    host.workloads = row['workloads'];
	  }
	  else if (row['workload']) {
	    host.workloads = [ row['workload'] ];
	  }
	  else {
	    host.workloads = utils.emptyArray;
	  }

	  if (row['dse_version'] !== undefined) {
	    host.dseVersion = row['dse_version'];
	  }
	}

	controlConnection = ControlConnection;
	return controlConnection;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var requestExecution;
var hasRequiredRequestExecution;

function requireRequestExecution () {
	if (hasRequiredRequestExecution) return requestExecution;
	hasRequiredRequestExecution = 1;

	const errors = requireErrors$c();
	const requests = requireRequests();
	const retry = requireRetry();
	const types = requireTypes$2();
	const utils = requireUtils$c();
	const promiseUtils = requirePromiseUtils();

	const retryOnCurrentHost = Object.freeze({
	  decision: retry.RetryPolicy.retryDecision.retry,
	  useCurrentHost: true,
	  consistency: undefined
	});

	const rethrowDecision = Object.freeze({ decision: retry.RetryPolicy.retryDecision.rethrow });

	/**
	 * An internal representation of an error that occurred during the execution of a request.
	 */
	const errorCodes = {
	  none: 0,
	  // Socket error
	  socketError: 1,
	  // Socket error before the request was written to the wire
	  socketErrorBeforeRequestWritten: 2,
	  // OperationTimedOutError
	  clientTimeout: 3,
	  // Response error "unprepared"
	  serverErrorUnprepared: 4,
	  // Response error "overloaded", "is_bootstrapping" and "truncateError":
	  serverErrorOverloaded: 5,
	  serverErrorReadTimeout: 6,
	  serverErrorUnavailable: 7,
	  serverErrorWriteTimeout: 8,
	  // Any other server error (different from the ones detailed above)
	  serverErrorOther: 9
	};

	const metricsHandlers = new Map([
	  [ errorCodes.none, (metrics, err, latency) => metrics.onSuccessfulResponse(latency) ],
	  [ errorCodes.socketError, (metrics, err) => metrics.onConnectionError(err) ],
	  [ errorCodes.clientTimeout, (metrics, err) => metrics.onClientTimeoutError(err) ],
	  [ errorCodes.serverErrorOverloaded, (metrics, err) => metrics.onOtherError(err) ],
	  [ errorCodes.serverErrorReadTimeout, (metrics, err) => metrics.onReadTimeoutError(err) ],
	  [ errorCodes.serverErrorUnavailable, (metrics, err) => metrics.onUnavailableError(err) ],
	  [ errorCodes.serverErrorWriteTimeout, (metrics, err) => metrics.onWriteTimeoutError(err) ],
	  [ errorCodes.serverErrorOther, (metrics, err) => metrics.onOtherError(err) ]
	]);

	const metricsRetryHandlers = new Map([
	  [ errorCodes.socketError, (metrics, err) => metrics.onOtherErrorRetry(err) ],
	  [ errorCodes.clientTimeout, (metrics, err) => metrics.onClientTimeoutRetry(err) ],
	  [ errorCodes.serverErrorOverloaded, (metrics, err) => metrics.onOtherErrorRetry(err) ],
	  [ errorCodes.serverErrorReadTimeout, (metrics, err) => metrics.onReadTimeoutRetry(err) ],
	  [ errorCodes.serverErrorUnavailable, (metrics, err) => metrics.onUnavailableRetry(err) ],
	  [ errorCodes.serverErrorWriteTimeout, (metrics, err) => metrics.onWriteTimeoutRetry(err) ],
	  [ errorCodes.serverErrorOther, (metrics, err) => metrics.onOtherErrorRetry(err) ]
	]);

	class RequestExecution {
	  /**
	   * Encapsulates a single flow of execution against a coordinator, handling individual retries and failover.
	   * @param {RequestHandler!} parent
	   * @param {Host!} host
	   * @param {Connection!} connection
	   */
	  constructor(parent, host, connection) {
	    this._parent = parent;
	    /** @type {OperationState} */
	    this._operation = null;
	    this._host = host;
	    this._connection = connection;
	    this._cancelled = false;
	    this._startTime = null;
	    this._retryCount = 0;
	    // The streamId information is not included in the request.
	    // A pointer to the parent request can be used, except when changing the consistency level from the retry policy
	    this._request = this._parent.request;

	    // Mark that it launched a new execution
	    parent.speculativeExecutions++;
	  }

	  /**
	   * Sends the request using the active connection.
	   */
	  start() {
	    this._sendOnConnection();
	  }

	  /**
	   * Borrows the next connection available using the query plan and sends the request.
	   * @returns {Promise<void>}
	   */
	  async restart() {
	    try {
	      const { host, connection } = this._parent.getNextConnection();

	      this._connection = connection;
	      this._host = host;
	    } catch (err) {
	      return this._parent.handleNoHostAvailable(err, this);
	    }

	    // It could be a new connection from the pool, we should make sure it's in the correct keyspace.
	    const keyspace = this._parent.client.keyspace;
	    if (keyspace && keyspace !== this._connection.keyspace) {
	      try {
	        await this._connection.changeKeyspace(keyspace);
	      } catch (err) {
	        // When its a socket error, attempt to retry.
	        // Otherwise, rethrow the error to the user.
	        return this._handleError(err, RequestExecution._getErrorCode(err));
	      }
	    }

	    if (this._cancelled) {
	      // No need to send the request or invoke any callback
	      return;
	    }

	    this._sendOnConnection();
	  }

	  /**
	   * Sends the request using the active connection.
	   * @private
	   */
	  _sendOnConnection() {
	    this._startTime = process.hrtime();

	    this._operation =
	      this._connection.sendStream(this._request, this._parent.executionOptions, (err, response, length) => {
	        const errorCode = RequestExecution._getErrorCode(err);

	        this._trackResponse(process.hrtime(this._startTime), errorCode, err, length);

	        if (this._cancelled) {
	          // Avoid handling the response / err
	          return;
	        }

	        if (errorCode !== errorCodes.none) {
	          return this._handleError(errorCode, err);
	        }

	        if (response.schemaChange) {
	          return promiseUtils.toBackground(
	            this._parent.client
	              .handleSchemaAgreementAndRefresh(this._connection, response.schemaChange)
	              .then(agreement => {
	                if (this._cancelled) {
	                  // After the schema agreement method was started, this execution was cancelled
	                  return;
	                }

	                this._parent.setCompleted(null, this._getResultSet(response, agreement));
	              })
	          );
	        }

	        if (response.keyspaceSet) {
	          this._parent.client.keyspace = response.keyspaceSet;
	        }

	        if (response.meta && response.meta.newResultId && this._request.queryId) {
	          // Update the resultId on the existing prepared statement.
	          // Eventually would want to update the result metadata as well (NODEJS-433)
	          const info = this._parent.client.metadata.getPreparedById(this._request.queryId);
	          info.meta.resultId = response.meta.newResultId;
	        }

	        this._parent.setCompleted(null, this._getResultSet(response));
	      });
	  }

	  _trackResponse(latency, errorCode, err, length) {
	    // Record metrics
	    RequestExecution._invokeMetricsHandler(errorCode, this._parent.client.metrics, err, latency);

	    // Request tracker
	    const tracker = this._parent.client.options.requestTracker;

	    if (tracker === null) {
	      return;
	    }

	    // Avoid using instanceof as property check is faster
	    const query = this._request.query || this._request.queries;
	    const parameters = this._request.params;
	    const requestLength = this._request.length;

	    if (err) {
	      tracker.onError(this._host, query, parameters, this._parent.executionOptions, requestLength, err, latency);
	    } else {
	      tracker.onSuccess(this._host, query, parameters, this._parent.executionOptions, requestLength, length, latency);
	    }
	  }

	  _getResultSet(response, agreement) {
	    const rs = new types.ResultSet(response, this._host.address, this._parent.triedHosts, this._parent.speculativeExecutions,
	      this._request.consistency, agreement === undefined || agreement);

	    if (rs.rawPageState) {
	      rs.nextPageAsync = this._parent.getNextPageHandler();
	    }

	    return rs;
	  }

	  /**
	   * Gets the method of the {ClientMetrics} instance depending on the error code and invokes it.
	   * @param {Number} errorCode
	   * @param {ClientMetrics} metrics
	   * @param {Error} err
	   * @param {Array} latency
	   * @private
	   */
	  static _invokeMetricsHandler(errorCode, metrics, err, latency) {
	    const handler = metricsHandlers.get(errorCode);
	    if (handler !== undefined) {
	      handler(metrics, err, latency);
	    }

	    if (!err || err instanceof errors.ResponseError) {
	      metrics.onResponse(latency);
	    }
	  }

	  /**
	   * Gets the method of the {ClientMetrics} instance related to retry depending on the error code and invokes it.
	   * @param {Number} errorCode
	   * @param {ClientMetrics} metrics
	   * @param {Error} err
	   * @private
	   */
	  static _invokeMetricsHandlerForRetry(errorCode, metrics, err) {
	    const handler = metricsRetryHandlers.get(errorCode);

	    if (handler !== undefined) {
	      handler(metrics, err);
	    }
	  }

	  /**
	   * Allows the handler to cancel the current request.
	   * When the request has been already written, we can unset the callback and forget about it.
	   */
	  cancel() {
	    this._cancelled = true;

	    if (this._operation === null) {
	      return;
	    }

	    this._operation.cancel();
	  }

	  /**
	   * Determines if the current execution was cancelled.
	   */
	  wasCancelled() {
	    return this._cancelled;
	  }

	  _handleError(errorCode, err) {
	    this._parent.triedHosts[this._host.address] = err;
	    err['coordinator'] = this._host.address;

	    if (errorCode === errorCodes.serverErrorUnprepared) {
	      return this._prepareAndRetry(err.queryId);
	    }

	    if (errorCode === errorCodes.socketError || errorCode === errorCodes.socketErrorBeforeRequestWritten) {
	      this._host.removeFromPool(this._connection);
	    } else if (errorCode === errorCodes.clientTimeout) {
	      this._parent.log('warning', err.message);
	      this._host.checkHealth(this._connection);
	    }

	    const decisionInfo = this._getDecision(errorCode, err);

	    if (!decisionInfo || decisionInfo.decision === retry.RetryPolicy.retryDecision.rethrow) {
	      if (this._request instanceof requests.QueryRequest || this._request instanceof requests.ExecuteRequest) {
	        err['query'] = this._request.query;
	      }
	      return this._parent.setCompleted(err);
	    }

	    const metrics = this._parent.client.metrics;

	    if (decisionInfo.decision === retry.RetryPolicy.retryDecision.ignore) {
	      metrics.onIgnoreError(err);

	      // Return an empty ResultSet
	      return this._parent.setCompleted(null, this._getResultSet(utils.emptyObject));
	    }

	    RequestExecution._invokeMetricsHandlerForRetry(errorCode, metrics, err);

	    return this._retry(decisionInfo.consistency, decisionInfo.useCurrentHost);
	  }

	  /**
	   * Gets a decision whether or not to retry based on the error information.
	   * @param {Number} errorCode
	   * @param {Error} err
	   * @returns {{decision, useCurrentHost, consistency}}
	   */
	  _getDecision(errorCode, err) {
	    const operationInfo = {
	      query: this._request && this._request.query,
	      executionOptions: this._parent.executionOptions,
	      nbRetry: this._retryCount
	    };

	    const retryPolicy = operationInfo.executionOptions.getRetryPolicy();

	    switch (errorCode) {
	      case errorCodes.socketErrorBeforeRequestWritten:
	        // The request was definitely not applied, it's safe to retry.
	        // Retry on the current host as there might be other connections open, in case it fails to obtain a connection
	        // on the current host, the driver will immediately retry on the next host.
	        return retryOnCurrentHost;
	      case errorCodes.socketError:
	      case errorCodes.clientTimeout:
	      case errorCodes.serverErrorOverloaded:
	        if (operationInfo.executionOptions.isIdempotent()) {
	          return retryPolicy.onRequestError(operationInfo, this._request.consistency, err);
	        }
	        return rethrowDecision;
	      case errorCodes.serverErrorUnavailable:
	        return retryPolicy.onUnavailable(operationInfo, err.consistencies, err.required, err.alive);
	      case errorCodes.serverErrorReadTimeout:
	        return retryPolicy.onReadTimeout(
	          operationInfo, err.consistencies, err.received, err.blockFor, err.isDataPresent);
	      case errorCodes.serverErrorWriteTimeout:
	        if (operationInfo.executionOptions.isIdempotent()) {
	          return retryPolicy.onWriteTimeout(
	            operationInfo, err.consistencies, err.received, err.blockFor, err.writeType);
	        }
	        return rethrowDecision;
	      default:
	        return rethrowDecision;
	    }
	  }

	  static _getErrorCode(err) {
	    if (!err) {
	      return errorCodes.none;
	    }

	    if (err.isSocketError) {
	      if (err.requestNotWritten) {
	        return errorCodes.socketErrorBeforeRequestWritten;
	      }
	      return errorCodes.socketError;
	    }

	    if (err instanceof errors.OperationTimedOutError) {
	      return errorCodes.clientTimeout;
	    }

	    if (err instanceof errors.ResponseError) {
	      switch (err.code) {
	        case types.responseErrorCodes.overloaded:
	        case types.responseErrorCodes.isBootstrapping:
	        case types.responseErrorCodes.truncateError:
	          return errorCodes.serverErrorOverloaded;
	        case types.responseErrorCodes.unavailableException:
	          return errorCodes.serverErrorUnavailable;
	        case types.responseErrorCodes.readTimeout:
	          return errorCodes.serverErrorReadTimeout;
	        case types.responseErrorCodes.writeTimeout:
	          return errorCodes.serverErrorWriteTimeout;
	        case types.responseErrorCodes.unprepared:
	          return errorCodes.serverErrorUnprepared;
	      }
	    }

	    return errorCodes.serverErrorOther;
	  }

	  /**
	   * @param {Number|undefined} consistency
	   * @param {Boolean} useCurrentHost
	   * @param {Object} [meta]
	   * @private
	   */
	  _retry(consistency, useCurrentHost, meta) {
	    if (this._cancelled) {
	      // No point in retrying
	      return;
	    }

	    this._parent.log('info', 'Retrying request');
	    this._retryCount++;

	    if (meta || (typeof consistency === 'number' && this._request.consistency !== consistency)) {
	      this._request = this._request.clone();
	      if (typeof consistency === 'number') {
	        this._request.consistency = consistency;
	      }
	      // possible that we are retrying because we had to reprepare.  In this case it is also possible
	      // that our known metadata had changed, therefore we update it on the request.
	      if (meta) {
	        this._request.meta = meta;
	      }
	    }

	    if (useCurrentHost !== false) {
	      // Reusing the existing connection is suitable for the most common scenarios, like server read timeouts that
	      // will be fixed with a new request.
	      // To cover all scenarios (e.g., where a different connection to the same host might mean something different),
	      // we obtain a new connection from the host pool.
	      // When there was a socket error, the connection provided was already removed from the pool earlier.
	      try {
	        this._connection = this._host.borrowConnection(this._connection);
	      } catch (err) {
	        // All connections are busy (`BusyConnectionError`) or there isn't a ready connection in the pool (`Error`)
	        // The retry policy declared the intention to retry on the current host but its not available anymore.
	        // Use the next host
	        return promiseUtils.toBackground(this.restart());
	      }

	      return this._sendOnConnection();
	    }

	    // Use the next host in the query plan to send the request in the background
	    promiseUtils.toBackground(this.restart());
	  }

	  /**
	   * Issues a PREPARE request on the current connection.
	   * If there's a socket or timeout issue, it moves to next host and executes the original request.
	   * @param {Buffer} queryId
	   * @private
	   */
	  _prepareAndRetry(queryId) {
	    const connection = this._connection;

	    this._parent.log('info',
	      `Query 0x${queryId.toString('hex')} not prepared on` +
	      ` host ${connection.endpointFriendlyName}, preparing and retrying`);

	    const info = this._parent.client.metadata.getPreparedById(queryId);

	    if (!info) {
	      return this._parent.setCompleted(new errors.DriverInternalError(
	        `Unprepared response invalid, id: 0x${queryId.toString('hex')}`));
	    }

	    const version = this._connection.protocolVersion;

	    if (!types.protocolVersion.supportsKeyspaceInRequest(version) && info.keyspace && info.keyspace !== connection.keyspace) {
	      return this._parent.setCompleted(
	        new Error(`Query was prepared on keyspace ${info.keyspace}, can't execute it on ${connection.keyspace} (${info.query})`));
	    }

	    const self = this;
	    this._connection.prepareOnce(info.query, info.keyspace, function (err, result) {
	      if (err) {
	        if (!err.isSocketError && err instanceof errors.OperationTimedOutError) {
	          self._parent.log('warning',
	            `Unexpected timeout error when re-preparing query on host ${connection.endpointFriendlyName}`);
	        }

	        // There was a failure re-preparing on this connection.
	        // Execute the original request on the next connection and forget about the PREPARE-UNPREPARE flow.
	        return self._retry(undefined, false);
	      }

	      // It's possible that when re-preparing we got new metadata (i.e. if schema changed), update cache.
	      info.meta = result.meta;
	      // pass the metadata so it can be used in retry.
	      self._retry(undefined, true, result.meta);
	    });
	  }
	}

	requestExecution = RequestExecution;
	return requestExecution;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var requestHandler;
var hasRequiredRequestHandler;

function requireRequestHandler () {
	if (hasRequiredRequestHandler) return requestHandler;
	hasRequiredRequestHandler = 1;
	const util = require$$0$6;

	const errors = requireErrors$c();
	const types = requireTypes$2();
	const utils = requireUtils$c();
	const RequestExecution = requireRequestExecution();
	const promiseUtils = requirePromiseUtils();

	/**
	 * Handles a BATCH, QUERY and EXECUTE request to the server, dealing with host fail-over and retries on error
	 */
	class RequestHandler {
	  /**
	   * Creates a new instance of RequestHandler.
	   * @param {Request} request
	   * @param {ExecutionOptions} execOptions
	   * @param {Client} client Client instance used to retrieve and set the keyspace.
	   */
	  constructor(request, execOptions, client) {
	    this.client = client;
	    this._speculativeExecutionPlan = client.options.policies.speculativeExecution.newPlan(
	      client.keyspace, request.query || request.queries);
	    this.logEmitter = client.options.logEmitter;
	    this.log = utils.log;
	    this.request = request;
	    this.executionOptions = execOptions;
	    this.stackContainer = null;
	    this.triedHosts = {};
	    // start at -1 as first request does not count.
	    this.speculativeExecutions = -1;
	    this._hostIterator = null;
	    this._resolveCallback = null;
	    this._rejectCallback = null;
	    this._newExecutionTimeout = null;
	    /** @type {RequestExecution[]} */
	    this._executions = [];
	  }

	  /**
	   * Sends a new BATCH, QUERY or EXECUTE request.
	   * @param {Request} request
	   * @param {ExecutionOptions} execOptions
	   * @param {Client} client Client instance used to retrieve and set the keyspace.
	   * @returns {Promise<ResultSet>}
	   */
	  static send(request, execOptions, client) {
	    const instance = new RequestHandler(request, execOptions, client);
	    return instance.send();
	  }

	  /**
	   * Gets a connection from the next host according to the query plan or throws a NoHostAvailableError.
	   * @returns {{host, connection}}
	   * @throws {NoHostAvailableError}
	   */
	  getNextConnection() {
	    let host;
	    let connection;
	    const iterator = this._hostIterator;

	    // Get a host that is UP in a sync loop
	    while (true) {
	      const item = iterator.next();
	      if (item.done) {
	        throw new errors.NoHostAvailableError(this.triedHosts);
	      }

	      host = item.value;

	      // Set the distance relative to the client first
	      const distance = this.client.profileManager.getDistance(host);
	      if (distance === types.distance.ignored) {
	        //If its marked as ignore by the load balancing policy, move on.
	        continue;
	      }

	      if (!host.isUp()) {
	        this.triedHosts[host.address] = 'Host considered as DOWN';
	        continue;
	      }

	      try {
	        connection = host.borrowConnection();
	        this.triedHosts[host.address] = null;
	        break;
	      } catch (err) {
	        this.triedHosts[host.address] = err;
	      }
	    }

	    return { connection, host };
	  }

	  /**
	   * Gets an available connection and sends the request
	   * @returns {Promise<ResultSet>}
	   */
	  send() {
	    if (this.executionOptions.getCaptureStackTrace()) {
	      Error.captureStackTrace(this.stackContainer = {});
	    }

	    return new Promise((resolve, reject) => {
	      this._resolveCallback = resolve;
	      this._rejectCallback = reject;

	      const lbp = this.executionOptions.getLoadBalancingPolicy();
	      const fixedHost = this.executionOptions.getFixedHost();

	      if (fixedHost) {
	        // if host is configured bypass load balancing policy and use
	        // a single host plan.
	        this._hostIterator = utils.arrayIterator([fixedHost]);
	        promiseUtils.toBackground(this._startNewExecution());
	      } else {
	        lbp.newQueryPlan(this.client.keyspace, this.executionOptions, (err, iterator) => {
	          if (err) {
	            return reject(err);
	          }

	          this._hostIterator = iterator;
	          promiseUtils.toBackground(this._startNewExecution());
	        });
	      }
	    });
	  }

	  /**
	   * Starts a new execution on the next host of the query plan.
	   * @param {Boolean} [isSpecExec]
	   * @returns {Promise<void>}
	   * @private
	   */
	  async _startNewExecution(isSpecExec) {
	    if (isSpecExec) {
	      this.client.metrics.onSpeculativeExecution();
	    }

	    let host;
	    let connection;

	    try {
	      ({ host, connection } = this.getNextConnection());
	    } catch (err) {
	      return this.handleNoHostAvailable(err, null);
	    }

	    if (isSpecExec && this._executions.length >= 0 && this._executions[0].wasCancelled()) {
	      // This method was called on the next tick and could not be cleared, the previous execution was cancelled so
	      // there's no point in launching a new execution.
	      return;
	    }

	    if (this.client.keyspace && this.client.keyspace !== connection.keyspace) {
	      try {
	        await connection.changeKeyspace(this.client.keyspace);
	      } catch (err) {
	        this.triedHosts[host.address] = err;
	        // The error occurred asynchronously
	        // We can blindly re-try to obtain a different host/connection.
	        return this._startNewExecution(isSpecExec);
	      }
	    }

	    const execution = new RequestExecution(this, host, connection);
	    this._executions.push(execution);
	    execution.start();

	    if (this.executionOptions.isIdempotent()) {
	      this._scheduleSpeculativeExecution(host);
	    }
	  }

	  /**
	   * Schedules next speculative execution, if any.
	   * @param {Host!} host
	   * @private
	   */
	  _scheduleSpeculativeExecution(host) {
	    const delay = this._speculativeExecutionPlan.nextExecution(host);
	    if (typeof delay !== 'number' || delay < 0) {
	      return;
	    }

	    if (delay === 0) {
	      // Parallel speculative execution
	      return process.nextTick(() => {
	        promiseUtils.toBackground(this._startNewExecution(true));
	      });
	    }

	    // Create timer for speculative execution
	    this._newExecutionTimeout = setTimeout(() =>
	      promiseUtils.toBackground(this._startNewExecution(true)), delay);
	  }

	  /**
	   * Sets the keyspace in any connection that is already opened.
	   * @param {Client} client
	   * @returns {Promise}
	   */
	  static setKeyspace(client) {
	    let connection;

	    for (const host of client.hosts.values()) {
	      connection = host.getActiveConnection();
	      if (connection) {
	        break;
	      }
	    }

	    if (!connection) {
	      throw new errors.DriverInternalError('No active connection found');
	    }

	    return connection.changeKeyspace(client.keyspace);
	  }

	  /**
	   * @param {Error} err
	   * @param {ResultSet} [result]
	   */
	  setCompleted(err, result) {
	    if (this._newExecutionTimeout !== null) {
	      clearTimeout(this._newExecutionTimeout);
	    }

	    // Mark all executions as cancelled
	    for (const execution of this._executions) {
	      execution.cancel();
	    }

	    if (err) {
	      if (this.executionOptions.getCaptureStackTrace()) {
	        utils.fixStack(this.stackContainer.stack, err);
	      }

	      // Reject the promise
	      return this._rejectCallback(err);
	    }

	    if (result.info.warnings) {
	      // Log the warnings from the response
	      result.info.warnings.forEach(function (message, i, warnings) {
	        this.log('warning', util.format(
	          'Received warning (%d of %d) "%s" for "%s"',
	          i + 1,
	          warnings.length,
	          message,
	          this.request.query || 'batch'));
	      }, this);
	    }

	    // We used to invoke the callback on next tick to allow stack unwinding and prevent the optimizing compiler to
	    // optimize read and write functions together.
	    // As we are resolving a Promise then() and catch() are always scheduled in the microtask queue
	    // We can invoke the resolve method directly.
	    this._resolveCallback(result);
	  }

	  /**
	   * @param {NoHostAvailableError} err
	   * @param {RequestExecution|null} execution
	   */
	  handleNoHostAvailable(err, execution) {
	    if (execution !== null) {
	      // Remove the execution
	      const index = this._executions.indexOf(execution);
	      this._executions.splice(index, 1);
	    }

	    if (this._executions.length === 0) {
	      // There aren't any other executions, we should report back to the user that there isn't
	      // a host available for executing the request
	      this.setCompleted(err);
	    }
	  }

	  /**
	   * Gets a long lived closure that can fetch the next page.
	   * @returns {Function}
	   */
	  getNextPageHandler() {
	    const request = this.request;
	    const execOptions = this.executionOptions;
	    const client = this.client;

	    return function nextPageHandler(pageState) {
	      execOptions.setPageState(pageState);
	      return new RequestHandler(request, execOptions, client).send();
	    };
	  }
	}

	requestHandler = RequestHandler;
	return requestHandler;
}/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var insightsClient;
var hasRequiredInsightsClient;

function requireInsightsClient () {
	if (hasRequiredInsightsClient) return insightsClient;
	hasRequiredInsightsClient = 1;

	const os = require$$0$c;
	const path = require$$1$2;
	const fs = require$$0$d;
	const utils = requireUtils$c();
	const promiseUtils = requirePromiseUtils();
	const types = requireTypes$2();
	const requests = requireRequests();
	const { ExecutionOptions } = requireExecutionOptions();
	const packageInfo = require$$17;
	const VersionNumber = requireVersionNumber();
	const { NoAuthProvider } = requireAuth();

	let kerberosModule;

	try {
	  // eslint-disable-next-line
	  kerberosModule = require('kerberos');
	}
	catch (err) {
	  // Kerberos is an optional dependency
	}

	const minDse6Version = new VersionNumber(6, 0, 5);
	const minDse51Version = new VersionNumber(5, 1, 13);
	const dse600Version = new VersionNumber(6, 0, 0);
	const rpc = "CALL InsightsRpc.reportInsight(?)";
	const maxStatusErrorLogs = 5;

	/**
	 * Contains methods and functionality to send events to DSE Insights.
	 */
	class InsightsClient {

	  /**
	   * Creates a new instance of the {@link InsightsClient} using the driver {@link Client}.
	   * @param {Client} client
	   * @param {Object} [options]
	   * @param {Number} [options.statusEventDelay]
	   * @param {Function} [options.errorCallback]
	   */
	  constructor(client, options) {
	    this._client = client;
	    this._sessionId = types.Uuid.random().toString();
	    this._enabled = false;
	    this._closed = false;
	    this._firstTimeout = null;
	    this._recurrentTimeout = null;
	    this._statusErrorLogs = 0;

	    options = options || {};

	    this._statusEventDelay = options.statusEventDelay || 300000;
	    this._errorCallback = options.errorCallback || utils.noop;
	  }

	  /**
	   * Initializes the insights client in the background by sending the startup event and scheduling status events at
	   * regular intervals.
	   * @returns {undefined}
	   */
	  init() {
	    this._enabled = this._client.options.monitorReporting.enabled && this._dseSupportsInsights();
	    if (!this._enabled) {
	      return;
	    }

	    promiseUtils.toBackground(this._init());
	  }

	  async _init() {
	    try {
	      await this._sendStartupEvent();

	      if (this._closed) {
	        // The client was shutdown
	        return;
	      }

	      // Send the status event the first time with a delay containing some random portion
	      // Initial delay should be statusEventDelay - (0 to 10%)
	      const firstDelay = Math.floor(this._statusEventDelay - 0.1 * this._statusEventDelay * Math.random());
	      // Schedule the first timer
	      this._firstTimeout = setTimeout(() => {
	        // Send the first status event, the promise will never be rejected
	        this._sendStatusEvent();
	        // The following status events are sent at regular intervals
	        this._recurrentTimeout = setInterval(() => this._sendStatusEvent(), this._statusEventDelay);
	      }, firstDelay);
	    } catch (err) {
	      if (this._closed) {
	        // Sending failed because the Client was shutdown
	        return;
	      }
	      // We shouldn't try to recover
	      this._client.log('verbose', `Insights startup message could not be sent (${err})`, err);
	      this._errorCallback(err);
	    }
	  }

	  /**
	   * Sends the startup event.
	   * @returns {Promise}
	   * @private
	   */
	  async _sendStartupEvent() {
	    const message = await this._getStartupMessage();
	    const request = new requests.QueryRequest(rpc, [message], ExecutionOptions.empty());
	    await this._client.controlConnection.query(request, false);
	  }

	  /**
	   * Sends the status event.
	   * @returns {Promise} A promise that is never rejected.
	   * @private
	   */
	  async _sendStatusEvent() {
	    const request = new requests.QueryRequest(rpc, [ this._getStatusEvent() ], ExecutionOptions.empty());

	    try {
	      await this._client.controlConnection.query(request, false);
	    } catch (err) {
	      if (this._closed) {
	        // Sending failed because the Client was shutdown
	        return;
	      }

	      if (this._statusErrorLogs < maxStatusErrorLogs) {
	        this._client.log('warning', `Insights status message could not be sent (${err})`, err);
	        this._statusErrorLogs++;
	      }

	      this._errorCallback(err);
	    }
	  }

	  /**
	   * Validates the minimum server version for all nodes in the cluster.
	   * @private
	   */
	  _dseSupportsInsights() {
	    if (this._client.hosts.length === 0) {
	      return false;
	    }

	    return this._client.hosts.values().reduce((acc, host) => {
	      if (!acc) {
	        return acc;
	      }

	      const versionArr = host.getDseVersion();

	      if (versionArr.length === 0) {
	        return false;
	      }

	      const version = new VersionNumber(...versionArr);

	      return version.compare(minDse6Version) >= 0 ||
	        (version.compare(dse600Version) < 0 && version.compare(minDse51Version) >= 0);

	    }, true);
	  }

	  /**
	   * @returns {Promise<String>} Returns a json string with the startup message.
	   * @private
	   */
	  async _getStartupMessage() {
	    const cc = this._client.controlConnection;
	    const options = this._client.options;


	    const appInfo = await this._getAppInfo(options);
	    const message = {
	      metadata: {
	        name: 'driver.startup',
	        insightMappingId: 'v1',
	        insightType: 'EVENT',
	        timestamp: Date.now(),
	        tags: { language: 'nodejs' }
	      },
	      data: {
	        driverName: packageInfo.description,
	        driverVersion: packageInfo.version,
	        clientId: options.id,
	        sessionId: this._sessionId,
	        applicationName: appInfo.applicationName,
	        applicationVersion: appInfo.applicationVersion,
	        applicationNameWasGenerated: appInfo.applicationNameWasGenerated,
	        contactPoints: mapToObject(cc.getResolvedContactPoints()),
	        dataCenters: this._getDataCenters(),
	        initialControlConnection: cc.host ? cc.host.address : undefined,
	        protocolVersion: cc.protocolVersion,
	        localAddress: cc.getLocalAddress(),
	        hostName: os.hostname(),
	        executionProfiles: getExecutionProfiles(this._client),
	        poolSizeByHostDistance: {
	          local: options.pooling.coreConnectionsPerHost[types.distance.local],
	          remote: options.pooling.coreConnectionsPerHost[types.distance.remote]
	        },
	        heartbeatInterval: options.pooling.heartBeatInterval,
	        compression: 'NONE',
	        reconnectionPolicy: getPolicyInfo(options.policies.reconnection),
	        ssl: {
	          enabled: !!options.sslOptions,
	          certValidation: options.sslOptions ? !!options.sslOptions.rejectUnauthorized : undefined
	        },
	        authProvider: {
	          type: !(options.authProvider instanceof NoAuthProvider) ? getConstructor(options.authProvider) : undefined,
	        },
	        otherOptions: {
	          coalescingThreshold: options.socketOptions.coalescingThreshold,
	        },
	        platformInfo: {
	          os: {
	            name: os.platform(),
	            version: os.release(),
	            arch: os.arch()
	          },
	          cpus: {
	            length: os.cpus().length,
	            model: os.cpus()[0].model
	          },
	          runtime: {
	            node: process.versions['node'],
	            v8: process.versions['v8'],
	            uv: process.versions['uv'],
	            openssl: process.versions['openssl'],
	            kerberos: kerberosModule ? kerberosModule.version : undefined
	          }
	        },
	        configAntiPatterns: this._getConfigAntiPatterns(),
	        periodicStatusInterval: Math.floor(this._statusEventDelay / 1000)
	      }
	    };

	    return JSON.stringify(message);
	  }

	  _getConfigAntiPatterns() {
	    const options = this._client.options;
	    const result = {};

	    if (options.sslOptions && !options.sslOptions.rejectUnauthorized) {
	      result.sslWithoutCertValidation =
	        'Client-to-node encryption is enabled but server certificate validation is disabled';
	    }

	    return result;
	  }

	  /**
	   * Gets an array of data centers the driver connects to.
	   * Whether the driver connects to a certain host is determined by the host distance (local and remote hosts)
	   * and the pooling options (whether connection length for remote hosts is greater than 0).
	   * @returns {Array}
	   * @private
	   */
	  _getDataCenters() {
	    const remoteConnectionsLength = this._client.options.pooling.coreConnectionsPerHost[types.distance.remote];
	    const dataCenters = new Set();

	    this._client.hosts.values().forEach(h => {
	      const distance = this._client.profileManager.getDistance(h);
	      if (distance === types.distance.local || (distance === types.distance.remote && remoteConnectionsLength > 0)) {
	        dataCenters.add(h.datacenter);
	      }
	    });

	    return Array.from(dataCenters);
	  }

	  /**
	   * Tries to obtain the application name and version from
	   * @param {DseClientOptions} options
	   * @returns {Promise}
	   * @private
	   */
	  async _getAppInfo(options) {
	    if (typeof options.applicationName === 'string') {
	      return Promise.resolve({
	        applicationName: options.applicationName,
	        applicationVersion: options.applicationVersion,
	        applicationNameWasGenerated: false
	      });
	    }

	    let readPromise = Promise.resolve();

	    if (require.main && require.main.filename) {
	      const packageInfoPath = path.dirname(require.main.filename);
	      readPromise = this._readPackageInfoFile(packageInfoPath);
	    }

	    const text = await readPromise;
	    let applicationName = 'Default Node.js Application';
	    let applicationVersion;

	    if (text) {
	      try {
	        const packageInfo = JSON.parse(text);
	        if (packageInfo.name) {
	          applicationName = packageInfo.name;
	          applicationVersion = packageInfo.version;
	        }
	      }
	      catch (err) {
	        // The package.json file could not be parsed
	        // Use the default name
	      }
	    }

	    return {
	      applicationName,
	      applicationVersion,
	      applicationNameWasGenerated: true
	    };
	  }

	  /**
	   * @private
	   * @returns {Promise<string>} A Promise that will never be rejected
	   */
	  _readPackageInfoFile(packageInfoPath) {
	    return new Promise(resolve => {
	      fs.readFile(path.join(packageInfoPath, 'package.json'), 'utf8', (err, data) => {
	        // Swallow error
	        resolve(data);
	      });
	    });
	  }

	  /**
	   * @returns {String} Returns a json string with the startup message.
	   * @private
	   */
	  _getStatusEvent() {
	    const cc = this._client.controlConnection;
	    const options = this._client.options;
	    const state = this._client.getState();
	    const connectedNodes = {};

	    state.getConnectedHosts().forEach(h => {
	      connectedNodes[h.address] = {
	        connections: state.getOpenConnections(h),
	        inFlightQueries: state.getInFlightQueries(h)
	      };
	    });

	    const message = {
	      metadata: {
	        name: 'driver.status',
	        insightMappingId: 'v1',
	        insightType: 'EVENT',
	        timestamp: Date.now(),
	        tags: { language: 'nodejs' }
	      },
	      data: {
	        clientId: options.id,
	        sessionId: this._sessionId,
	        controlConnection: cc.host ? cc.host.address : undefined,
	        connectedNodes
	      }
	    };

	    return JSON.stringify(message);
	  }

	  /**
	   * Cleans any timer used internally and sets the client as closed.
	   */
	  shutdown() {
	    if (!this._enabled) {
	      return;
	    }

	    this._closed = true;

	    if (this._firstTimeout !== null) {
	      clearTimeout(this._firstTimeout);
	    }

	    if (this._recurrentTimeout !== null) {
	      clearInterval(this._recurrentTimeout);
	    }
	  }
	}

	insightsClient = InsightsClient;

	function mapToObject(map) {
	  const result = {};
	  map.forEach((value, key) => result[key] = value);
	  return result;
	}

	function getPolicyInfo(policy) {
	  if (!policy) {
	    return undefined;
	  }

	  const options = policy.getOptions && policy.getOptions();

	  return {
	    type: policy.constructor.name,
	    options: (options instanceof Map) ? mapToObject(options) : utils.emptyObject
	  };
	}

	function getConsistencyString(c) {
	  if (typeof c !== 'number') {
	    return undefined;
	  }

	  return types.consistencyToString[c];
	}

	function getConstructor(instance) {
	  return instance ? instance.constructor.name : undefined;
	}

	function getExecutionProfiles(client) {
	  const executionProfiles = {};

	  const defaultProfile = client.profileManager.getDefault();
	  setExecutionProfileProperties(client, executionProfiles, defaultProfile, defaultProfile);

	  client.profileManager.getAll()
	    .filter(p => p !== defaultProfile)
	    .forEach(profile => setExecutionProfileProperties(client, executionProfiles, profile, defaultProfile));

	  return executionProfiles;
	}

	function setExecutionProfileProperties(client, parent, profile, defaultProfile) {
	  const output = parent[profile.name] = {};
	  setExecutionProfileItem(output, profile, defaultProfile, 'readTimeout');
	  setExecutionProfileItem(output, profile, defaultProfile, 'loadBalancing', getPolicyInfo);
	  setExecutionProfileItem(output, profile, defaultProfile, 'retry', getPolicyInfo);
	  setExecutionProfileItem(output, profile, defaultProfile, 'consistency', getConsistencyString);
	  setExecutionProfileItem(output, profile, defaultProfile, 'serialConsistency', getConsistencyString);

	  if (profile === defaultProfile) {
	    // Speculative execution policy is included in the profiles as some drivers support
	    // different spec exec policy per profile, in this case is fixed for all profiles
	    output.speculativeExecution = getPolicyInfo(client.options.policies.speculativeExecution);
	  }

	  if (profile.graphOptions) {
	    output.graphOptions = {};
	    const defaultGraphOptions = defaultProfile.graphOptions || utils.emptyObject;
	    setExecutionProfileItem(output.graphOptions, profile.graphOptions, defaultGraphOptions, 'language');
	    setExecutionProfileItem(output.graphOptions, profile.graphOptions, defaultGraphOptions, 'name');
	    setExecutionProfileItem(output.graphOptions, profile.graphOptions, defaultGraphOptions, 'readConsistency',
	      getConsistencyString);
	    setExecutionProfileItem(output.graphOptions, profile.graphOptions, defaultGraphOptions, 'source');
	    setExecutionProfileItem(output.graphOptions, profile.graphOptions, defaultGraphOptions, 'writeConsistency',
	      getConsistencyString);

	    if (Object.keys(output.graphOptions).length === 0) {
	      // Properties that are undefined will not be included in the JSON
	      output.graphOptions = undefined;
	    }
	  }
	}

	function setExecutionProfileItem(output, profile, defaultProfile, prop, valueGetter) {
	  const value = profile[prop];
	  valueGetter = valueGetter || (x => x);

	  if ((profile === defaultProfile && value !== undefined) || value !== defaultProfile[prop]) {
	    output[prop] = valueGetter(value);
	  }
	}
	return insightsClient;
}var util$b = {exports: {}};var fileSystem = {};var hasRequiredFileSystem;

function requireFileSystem () {
	if (hasRequiredFileSystem) return fileSystem;
	hasRequiredFileSystem = 1;
	fileSystem.require = function () {
	    if (typeof process === "object" && process.versions && process.versions["electron"]) {
	        try {
	            const originalFs = require("original-fs");
	            if (Object.keys(originalFs).length > 0) {
	                return originalFs;
	            }
	        } catch (e) {}
	    }
	    return require$$0$d;
	};
	return fileSystem;
}var constants$9;
var hasRequiredConstants$9;

function requireConstants$9 () {
	if (hasRequiredConstants$9) return constants$9;
	hasRequiredConstants$9 = 1;
	constants$9 = {
	    /* The local file header */
	    LOCHDR           : 30, // LOC header size
	    LOCSIG           : 0x04034b50, // "PK\003\004"
	    LOCVER           : 4,	// version needed to extract
	    LOCFLG           : 6, // general purpose bit flag
	    LOCHOW           : 8, // compression method
	    LOCTIM           : 10, // modification time (2 bytes time, 2 bytes date)
	    LOCCRC           : 14, // uncompressed file crc-32 value
	    LOCSIZ           : 18, // compressed size
	    LOCLEN           : 22, // uncompressed size
	    LOCNAM           : 26, // filename length
	    LOCEXT           : 28, // extra field length

	    /* The Data descriptor */
	    EXTSIG           : 0x08074b50, // "PK\007\008"
	    EXTHDR           : 16, // EXT header size
	    EXTCRC           : 4, // uncompressed file crc-32 value
	    EXTSIZ           : 8, // compressed size
	    EXTLEN           : 12, // uncompressed size

	    /* The central directory file header */
	    CENHDR           : 46, // CEN header size
	    CENSIG           : 0x02014b50, // "PK\001\002"
	    CENVEM           : 4, // version made by
	    CENVER           : 6, // version needed to extract
	    CENFLG           : 8, // encrypt, decrypt flags
	    CENHOW           : 10, // compression method
	    CENTIM           : 12, // modification time (2 bytes time, 2 bytes date)
	    CENCRC           : 16, // uncompressed file crc-32 value
	    CENSIZ           : 20, // compressed size
	    CENLEN           : 24, // uncompressed size
	    CENNAM           : 28, // filename length
	    CENEXT           : 30, // extra field length
	    CENCOM           : 32, // file comment length
	    CENDSK           : 34, // volume number start
	    CENATT           : 36, // internal file attributes
	    CENATX           : 38, // external file attributes (host system dependent)
	    CENOFF           : 42, // LOC header offset

	    /* The entries in the end of central directory */
	    ENDHDR           : 22, // END header size
	    ENDSIG           : 0x06054b50, // "PK\005\006"
	    ENDSUB           : 8, // number of entries on this disk
	    ENDTOT           : 10, // total number of entries
	    ENDSIZ           : 12, // central directory size in bytes
	    ENDOFF           : 16, // offset of first CEN header
	    ENDCOM           : 20, // zip file comment length

	    END64HDR         : 20, // zip64 END header size
	    END64SIG         : 0x07064b50, // zip64 Locator signature, "PK\006\007"
	    END64START       : 4, // number of the disk with the start of the zip64
	    END64OFF         : 8, // relative offset of the zip64 end of central directory
	    END64NUMDISKS    : 16, // total number of disks

	    ZIP64SIG         : 0x06064b50, // zip64 signature, "PK\006\006"
	    ZIP64HDR         : 56, // zip64 record minimum size
	    ZIP64LEAD        : 12, // leading bytes at the start of the record, not counted by the value stored in ZIP64SIZE
	    ZIP64SIZE        : 4, // zip64 size of the central directory record
	    ZIP64VEM         : 12, // zip64 version made by
	    ZIP64VER         : 14, // zip64 version needed to extract
	    ZIP64DSK         : 16, // zip64 number of this disk
	    ZIP64DSKDIR      : 20, // number of the disk with the start of the record directory
	    ZIP64SUB         : 24, // number of entries on this disk
	    ZIP64TOT         : 32, // total number of entries
	    ZIP64SIZB        : 40, // zip64 central directory size in bytes
	    ZIP64OFF         : 48, // offset of start of central directory with respect to the starting disk number
	    ZIP64EXTRA       : 56, // extensible data sector

	    /* Compression methods */
	    STORED           : 0, // no compression
	    SHRUNK           : 1, // shrunk
	    REDUCED1         : 2, // reduced with compression factor 1
	    REDUCED2         : 3, // reduced with compression factor 2
	    REDUCED3         : 4, // reduced with compression factor 3
	    REDUCED4         : 5, // reduced with compression factor 4
	    IMPLODED         : 6, // imploded
	    // 7 reserved for Tokenizing compression algorithm
	    DEFLATED         : 8, // deflated
	    ENHANCED_DEFLATED: 9, // enhanced deflated
	    PKWARE           : 10,// PKWare DCL imploded
	    // 11 reserved by PKWARE
	    BZIP2            : 12, //  compressed using BZIP2
	    // 13 reserved by PKWARE
	    LZMA             : 14, // LZMA
	    // 15-17 reserved by PKWARE
	    IBM_TERSE        : 18, // compressed using IBM TERSE
	    IBM_LZ77         : 19, // IBM LZ77 z
	    AES_ENCRYPT      : 99, // WinZIP AES encryption method

	    /* General purpose bit flag */
	    // values can obtained with expression 2**bitnr
	    FLG_ENC          : 1,    // Bit 0: encrypted file
	    FLG_COMP1        : 2,    // Bit 1, compression option
	    FLG_COMP2        : 4,    // Bit 2, compression option
	    FLG_DESC         : 8,    // Bit 3, data descriptor
	    FLG_ENH          : 16,   // Bit 4, enhanced deflating
	    FLG_PATCH        : 32,   // Bit 5, indicates that the file is compressed patched data.
	    FLG_STR          : 64,   // Bit 6, strong encryption (patented)
	                             // Bits 7-10: Currently unused.
	    FLG_EFS          : 2048, // Bit 11: Language encoding flag (EFS)
	                             // Bit 12: Reserved by PKWARE for enhanced compression.
	                             // Bit 13: encrypted the Central Directory (patented).
	                             // Bits 14-15: Reserved by PKWARE.
	    FLG_MSK          : 4096, // mask header values

	    /* Load type */
	    FILE             : 2,
	    BUFFER           : 1,
	    NONE             : 0,

	    /* 4.5 Extensible data fields */
	    EF_ID            : 0,
	    EF_SIZE          : 2,

	    /* Header IDs */
	    ID_ZIP64         : 0x0001,
	    ID_AVINFO        : 0x0007,
	    ID_PFS           : 0x0008,
	    ID_OS2           : 0x0009,
	    ID_NTFS          : 0x000a,
	    ID_OPENVMS       : 0x000c,
	    ID_UNIX          : 0x000d,
	    ID_FORK          : 0x000e,
	    ID_PATCH         : 0x000f,
	    ID_X509_PKCS7    : 0x0014,
	    ID_X509_CERTID_F : 0x0015,
	    ID_X509_CERTID_C : 0x0016,
	    ID_STRONGENC     : 0x0017,
	    ID_RECORD_MGT    : 0x0018,
	    ID_X509_PKCS7_RL : 0x0019,
	    ID_IBM1          : 0x0065,
	    ID_IBM2          : 0x0066,
	    ID_POSZIP        : 0x4690,

	    EF_ZIP64_OR_32   : 0xffffffff,
	    EF_ZIP64_OR_16   : 0xffff,
	    EF_ZIP64_SUNCOMP : 0,
	    EF_ZIP64_SCOMP   : 8,
	    EF_ZIP64_RHO     : 16,
	    EF_ZIP64_DSN     : 24
	};
	return constants$9;
}var errors$c;
var hasRequiredErrors$b;

function requireErrors$b () {
	if (hasRequiredErrors$b) return errors$c;
	hasRequiredErrors$b = 1;
	errors$c = {
	    /* Header error messages */
	    INVALID_LOC: "Invalid LOC header (bad signature)",
	    INVALID_CEN: "Invalid CEN header (bad signature)",
	    INVALID_END: "Invalid END header (bad signature)",

	    /* ZipEntry error messages*/
	    NO_DATA: "Nothing to decompress",
	    BAD_CRC: "CRC32 checksum failed",
	    FILE_IN_THE_WAY: "There is a file in the way: %s",
	    UNKNOWN_METHOD: "Invalid/unsupported compression method",

	    /* Inflater error messages */
	    AVAIL_DATA: "inflate::Available inflate data did not terminate",
	    INVALID_DISTANCE: "inflate::Invalid literal/length or distance code in fixed or dynamic block",
	    TO_MANY_CODES: "inflate::Dynamic block code description: too many length or distance codes",
	    INVALID_REPEAT_LEN: "inflate::Dynamic block code description: repeat more than specified lengths",
	    INVALID_REPEAT_FIRST: "inflate::Dynamic block code description: repeat lengths with no first length",
	    INCOMPLETE_CODES: "inflate::Dynamic block code description: code lengths codes incomplete",
	    INVALID_DYN_DISTANCE: "inflate::Dynamic block code description: invalid distance code lengths",
	    INVALID_CODES_LEN: "inflate::Dynamic block code description: invalid literal/length code lengths",
	    INVALID_STORE_BLOCK: "inflate::Stored block length did not match one's complement",
	    INVALID_BLOCK_TYPE: "inflate::Invalid block type (type == 3)",

	    /* ADM-ZIP error messages */
	    CANT_EXTRACT_FILE: "Could not extract the file",
	    CANT_OVERRIDE: "Target file already exists",
	    NO_ZIP: "No zip file was loaded",
	    NO_ENTRY: "Entry doesn't exist",
	    DIRECTORY_CONTENT_ERROR: "A directory cannot have content",
	    FILE_NOT_FOUND: "File not found: %s",
	    NOT_IMPLEMENTED: "Not implemented",
	    INVALID_FILENAME: "Invalid filename",
	    INVALID_FORMAT: "Invalid or unsupported zip format. No END header found"
	};
	return errors$c;
}var utils$b;
var hasRequiredUtils$b;

function requireUtils$b () {
	if (hasRequiredUtils$b) return utils$b;
	hasRequiredUtils$b = 1;
	const fsystem = requireFileSystem().require();
	const pth = require$$1$2;
	const Constants = requireConstants$9();
	const Errors = requireErrors$b();
	const isWin = typeof process === "object" && "win32" === process.platform;

	const is_Obj = (obj) => obj && typeof obj === "object";

	// generate CRC32 lookup table
	const crcTable = new Uint32Array(256).map((t, c) => {
	    for (let k = 0; k < 8; k++) {
	        if ((c & 1) !== 0) {
	            c = 0xedb88320 ^ (c >>> 1);
	        } else {
	            c >>>= 1;
	        }
	    }
	    return c >>> 0;
	});

	// UTILS functions

	function Utils(opts) {
	    this.sep = pth.sep;
	    this.fs = fsystem;

	    if (is_Obj(opts)) {
	        // custom filesystem
	        if (is_Obj(opts.fs) && typeof opts.fs.statSync === "function") {
	            this.fs = opts.fs;
	        }
	    }
	}

	utils$b = Utils;

	// INSTANCED functions

	Utils.prototype.makeDir = function (/*String*/ folder) {
	    const self = this;

	    // Sync - make directories tree
	    function mkdirSync(/*String*/ fpath) {
	        let resolvedPath = fpath.split(self.sep)[0];
	        fpath.split(self.sep).forEach(function (name) {
	            if (!name || name.substr(-1, 1) === ":") return;
	            resolvedPath += self.sep + name;
	            var stat;
	            try {
	                stat = self.fs.statSync(resolvedPath);
	            } catch (e) {
	                self.fs.mkdirSync(resolvedPath);
	            }
	            if (stat && stat.isFile()) throw Errors.FILE_IN_THE_WAY.replace("%s", resolvedPath);
	        });
	    }

	    mkdirSync(folder);
	};

	Utils.prototype.writeFileTo = function (/*String*/ path, /*Buffer*/ content, /*Boolean*/ overwrite, /*Number*/ attr) {
	    const self = this;
	    if (self.fs.existsSync(path)) {
	        if (!overwrite) return false; // cannot overwrite

	        var stat = self.fs.statSync(path);
	        if (stat.isDirectory()) {
	            return false;
	        }
	    }
	    var folder = pth.dirname(path);
	    if (!self.fs.existsSync(folder)) {
	        self.makeDir(folder);
	    }

	    var fd;
	    try {
	        fd = self.fs.openSync(path, "w", 438); // 0666
	    } catch (e) {
	        self.fs.chmodSync(path, 438);
	        fd = self.fs.openSync(path, "w", 438);
	    }
	    if (fd) {
	        try {
	            self.fs.writeSync(fd, content, 0, content.length, 0);
	        } finally {
	            self.fs.closeSync(fd);
	        }
	    }
	    self.fs.chmodSync(path, attr || 438);
	    return true;
	};

	Utils.prototype.writeFileToAsync = function (/*String*/ path, /*Buffer*/ content, /*Boolean*/ overwrite, /*Number*/ attr, /*Function*/ callback) {
	    if (typeof attr === "function") {
	        callback = attr;
	        attr = undefined;
	    }

	    const self = this;

	    self.fs.exists(path, function (exist) {
	        if (exist && !overwrite) return callback(false);

	        self.fs.stat(path, function (err, stat) {
	            if (exist && stat.isDirectory()) {
	                return callback(false);
	            }

	            var folder = pth.dirname(path);
	            self.fs.exists(folder, function (exists) {
	                if (!exists) self.makeDir(folder);

	                self.fs.open(path, "w", 438, function (err, fd) {
	                    if (err) {
	                        self.fs.chmod(path, 438, function () {
	                            self.fs.open(path, "w", 438, function (err, fd) {
	                                self.fs.write(fd, content, 0, content.length, 0, function () {
	                                    self.fs.close(fd, function () {
	                                        self.fs.chmod(path, attr || 438, function () {
	                                            callback(true);
	                                        });
	                                    });
	                                });
	                            });
	                        });
	                    } else if (fd) {
	                        self.fs.write(fd, content, 0, content.length, 0, function () {
	                            self.fs.close(fd, function () {
	                                self.fs.chmod(path, attr || 438, function () {
	                                    callback(true);
	                                });
	                            });
	                        });
	                    } else {
	                        self.fs.chmod(path, attr || 438, function () {
	                            callback(true);
	                        });
	                    }
	                });
	            });
	        });
	    });
	};

	Utils.prototype.findFiles = function (/*String*/ path) {
	    const self = this;

	    function findSync(/*String*/ dir, /*RegExp*/ pattern, /*Boolean*/ recursive) {
	        let files = [];
	        self.fs.readdirSync(dir).forEach(function (file) {
	            var path = pth.join(dir, file);

	            if (self.fs.statSync(path).isDirectory() && recursive) files = files.concat(findSync(path, pattern, recursive));

	            {
	                files.push(pth.normalize(path) + (self.fs.statSync(path).isDirectory() ? self.sep : ""));
	            }
	        });
	        return files;
	    }

	    return findSync(path, undefined, true);
	};

	Utils.prototype.getAttributes = function () {};

	Utils.prototype.setAttributes = function () {};

	// STATIC functions

	// crc32 single update (it is part of crc32)
	Utils.crc32update = function (crc, byte) {
	    return crcTable[(crc ^ byte) & 0xff] ^ (crc >>> 8);
	};

	Utils.crc32 = function (buf) {
	    if (typeof buf === "string") {
	        buf = Buffer.from(buf, "utf8");
	    }
	    // Generate crcTable
	    if (!crcTable.length) genCRCTable();

	    let len = buf.length;
	    let crc = ~0;
	    for (let off = 0; off < len; ) crc = Utils.crc32update(crc, buf[off++]);
	    // xor and cast as uint32 number
	    return ~crc >>> 0;
	};

	Utils.methodToString = function (/*Number*/ method) {
	    switch (method) {
	        case Constants.STORED:
	            return "STORED (" + method + ")";
	        case Constants.DEFLATED:
	            return "DEFLATED (" + method + ")";
	        default:
	            return "UNSUPPORTED (" + method + ")";
	    }
	};

	// removes ".." style path elements
	Utils.canonical = function (/*string*/ path) {
	    if (!path) return "";
	    // trick normalize think path is absolute
	    var safeSuffix = pth.posix.normalize("/" + path.split("\\").join("/"));
	    return pth.join(".", safeSuffix);
	};

	// make abolute paths taking prefix as root folder
	Utils.sanitize = function (/*string*/ prefix, /*string*/ name) {
	    prefix = pth.resolve(pth.normalize(prefix));
	    var parts = name.split("/");
	    for (var i = 0, l = parts.length; i < l; i++) {
	        var path = pth.normalize(pth.join(prefix, parts.slice(i, l).join(pth.sep)));
	        if (path.indexOf(prefix) === 0) {
	            return path;
	        }
	    }
	    return pth.normalize(pth.join(prefix, pth.basename(name)));
	};

	// converts buffer, Uint8Array, string types to buffer
	Utils.toBuffer = function toBuffer(/*buffer, Uint8Array, string*/ input) {
	    if (Buffer.isBuffer(input)) {
	        return input;
	    } else if (input instanceof Uint8Array) {
	        return Buffer.from(input);
	    } else {
	        // expect string all other values are invalid and return empty buffer
	        return typeof input === "string" ? Buffer.from(input, "utf8") : Buffer.alloc(0);
	    }
	};

	Utils.readBigUInt64LE = function (/*Buffer*/ buffer, /*int*/ index) {
	    var slice = Buffer.from(buffer.slice(index, index + 8));
	    slice.swap64();

	    return parseInt(`0x${slice.toString("hex")}`);
	};

	Utils.isWin = isWin; // Do we have windows system
	Utils.crcTable = crcTable;
	return utils$b;
}var fattr;
var hasRequiredFattr;

function requireFattr () {
	if (hasRequiredFattr) return fattr;
	hasRequiredFattr = 1;
	const fs = requireFileSystem().require();
	const pth = require$$1$2;

	fs.existsSync = fs.existsSync || pth.existsSync;

	fattr = function (/*String*/ path) {
	    var _path = path || "",
	        _obj = newAttr(),
	        _stat = null;

	    function newAttr() {
	        return {
	            directory: false,
	            readonly: false,
	            hidden: false,
	            executable: false,
	            mtime: 0,
	            atime: 0
	        };
	    }

	    if (_path && fs.existsSync(_path)) {
	        _stat = fs.statSync(_path);
	        _obj.directory = _stat.isDirectory();
	        _obj.mtime = _stat.mtime;
	        _obj.atime = _stat.atime;
	        _obj.executable = (0o111 & _stat.mode) !== 0; // file is executable who ever har right not just owner
	        _obj.readonly = (0o200 & _stat.mode) === 0; // readonly if owner has no write right
	        _obj.hidden = pth.basename(_path)[0] === ".";
	    } else {
	        console.warn("Invalid path: " + _path);
	    }

	    return {
	        get directory() {
	            return _obj.directory;
	        },

	        get readOnly() {
	            return _obj.readonly;
	        },

	        get hidden() {
	            return _obj.hidden;
	        },

	        get mtime() {
	            return _obj.mtime;
	        },

	        get atime() {
	            return _obj.atime;
	        },

	        get executable() {
	            return _obj.executable;
	        },

	        decodeAttributes: function () {},

	        encodeAttributes: function () {},

	        toJSON: function () {
	            return {
	                path: _path,
	                isDirectory: _obj.directory,
	                isReadOnly: _obj.readonly,
	                isHidden: _obj.hidden,
	                isExecutable: _obj.executable,
	                mTime: _obj.mtime,
	                aTime: _obj.atime
	            };
	        },

	        toString: function () {
	            return JSON.stringify(this.toJSON(), null, "\t");
	        }
	    };
	};
	return fattr;
}var hasRequiredUtil$a;

function requireUtil$a () {
	if (hasRequiredUtil$a) return util$b.exports;
	hasRequiredUtil$a = 1;
	util$b.exports = requireUtils$b();
	util$b.exports.Constants = requireConstants$9();
	util$b.exports.Errors = requireErrors$b();
	util$b.exports.FileAttr = requireFattr();
	return util$b.exports;
}var headers$1 = {};var entryHeader;
var hasRequiredEntryHeader;

function requireEntryHeader () {
	if (hasRequiredEntryHeader) return entryHeader;
	hasRequiredEntryHeader = 1;
	var Utils = requireUtil$a(),
	    Constants = Utils.Constants;

	/* The central directory file header */
	entryHeader = function () {
	    var _verMade = 20, // v2.0
	        _version = 10, // v1.0
	        _flags = 0,
	        _method = 0,
	        _time = 0,
	        _crc = 0,
	        _compressedSize = 0,
	        _size = 0,
	        _fnameLen = 0,
	        _extraLen = 0,
	        _comLen = 0,
	        _diskStart = 0,
	        _inattr = 0,
	        _attr = 0,
	        _offset = 0;

	    _verMade |= Utils.isWin ? 0x0a00 : 0x0300;

	    // Set EFS flag since filename and comment fields are all by default encoded using UTF-8.
	    // Without it file names may be corrupted for other apps when file names use unicode chars
	    _flags |= Constants.FLG_EFS;

	    var _dataHeader = {};

	    function setTime(val) {
	        val = new Date(val);
	        _time =
	            (((val.getFullYear() - 1980) & 0x7f) << 25) | // b09-16 years from 1980
	            ((val.getMonth() + 1) << 21) | // b05-08 month
	            (val.getDate() << 16) | // b00-04 hour
	            // 2 bytes time
	            (val.getHours() << 11) | // b11-15 hour
	            (val.getMinutes() << 5) | // b05-10 minute
	            (val.getSeconds() >> 1); // b00-04 seconds divided by 2
	    }

	    setTime(+new Date());

	    return {
	        get made() {
	            return _verMade;
	        },
	        set made(val) {
	            _verMade = val;
	        },

	        get version() {
	            return _version;
	        },
	        set version(val) {
	            _version = val;
	        },

	        get flags() {
	            return _flags;
	        },
	        set flags(val) {
	            _flags = val;
	        },

	        get method() {
	            return _method;
	        },
	        set method(val) {
	            switch (val) {
	                case Constants.STORED:
	                    this.version = 10;
	                case Constants.DEFLATED:
	                default:
	                    this.version = 20;
	            }
	            _method = val;
	        },

	        get time() {
	            return new Date(((_time >> 25) & 0x7f) + 1980, ((_time >> 21) & 0x0f) - 1, (_time >> 16) & 0x1f, (_time >> 11) & 0x1f, (_time >> 5) & 0x3f, (_time & 0x1f) << 1);
	        },
	        set time(val) {
	            setTime(val);
	        },
	        get timeHighByte() {
	            return (_time >>> 8) & 0xff;
	        },
	        get crc() {
	            return _crc;
	        },
	        set crc(val) {
	            _crc = Math.max(0, val) >>> 0;
	        },

	        get compressedSize() {
	            return _compressedSize;
	        },
	        set compressedSize(val) {
	            _compressedSize = Math.max(0, val) >>> 0;
	        },

	        get size() {
	            return _size;
	        },
	        set size(val) {
	            _size = Math.max(0, val) >>> 0;
	        },

	        get fileNameLength() {
	            return _fnameLen;
	        },
	        set fileNameLength(val) {
	            _fnameLen = val;
	        },

	        get extraLength() {
	            return _extraLen;
	        },
	        set extraLength(val) {
	            _extraLen = val;
	        },

	        get commentLength() {
	            return _comLen;
	        },
	        set commentLength(val) {
	            _comLen = val;
	        },

	        get diskNumStart() {
	            return _diskStart;
	        },
	        set diskNumStart(val) {
	            _diskStart = Math.max(0, val) >>> 0;
	        },

	        get inAttr() {
	            return _inattr;
	        },
	        set inAttr(val) {
	            _inattr = Math.max(0, val) >>> 0;
	        },

	        get attr() {
	            return _attr;
	        },
	        set attr(val) {
	            _attr = Math.max(0, val) >>> 0;
	        },

	        // get Unix file permissions
	        get fileAttr() {
	            return _attr ? (((_attr >>> 0) | 0) >> 16) & 0xfff : 0;
	        },

	        get offset() {
	            return _offset;
	        },
	        set offset(val) {
	            _offset = Math.max(0, val) >>> 0;
	        },

	        get encripted() {
	            return (_flags & 1) === 1;
	        },

	        get entryHeaderSize() {
	            return Constants.CENHDR + _fnameLen + _extraLen + _comLen;
	        },

	        get realDataOffset() {
	            return _offset + Constants.LOCHDR + _dataHeader.fnameLen + _dataHeader.extraLen;
	        },

	        get dataHeader() {
	            return _dataHeader;
	        },

	        loadDataHeaderFromBinary: function (/*Buffer*/ input) {
	            var data = input.slice(_offset, _offset + Constants.LOCHDR);
	            // 30 bytes and should start with "PK\003\004"
	            if (data.readUInt32LE(0) !== Constants.LOCSIG) {
	                throw new Error(Utils.Errors.INVALID_LOC);
	            }
	            _dataHeader = {
	                // version needed to extract
	                version: data.readUInt16LE(Constants.LOCVER),
	                // general purpose bit flag
	                flags: data.readUInt16LE(Constants.LOCFLG),
	                // compression method
	                method: data.readUInt16LE(Constants.LOCHOW),
	                // modification time (2 bytes time, 2 bytes date)
	                time: data.readUInt32LE(Constants.LOCTIM),
	                // uncompressed file crc-32 value
	                crc: data.readUInt32LE(Constants.LOCCRC),
	                // compressed size
	                compressedSize: data.readUInt32LE(Constants.LOCSIZ),
	                // uncompressed size
	                size: data.readUInt32LE(Constants.LOCLEN),
	                // filename length
	                fnameLen: data.readUInt16LE(Constants.LOCNAM),
	                // extra field length
	                extraLen: data.readUInt16LE(Constants.LOCEXT)
	            };
	        },

	        loadFromBinary: function (/*Buffer*/ data) {
	            // data should be 46 bytes and start with "PK 01 02"
	            if (data.length !== Constants.CENHDR || data.readUInt32LE(0) !== Constants.CENSIG) {
	                throw new Error(Utils.Errors.INVALID_CEN);
	            }
	            // version made by
	            _verMade = data.readUInt16LE(Constants.CENVEM);
	            // version needed to extract
	            _version = data.readUInt16LE(Constants.CENVER);
	            // encrypt, decrypt flags
	            _flags = data.readUInt16LE(Constants.CENFLG);
	            // compression method
	            _method = data.readUInt16LE(Constants.CENHOW);
	            // modification time (2 bytes time, 2 bytes date)
	            _time = data.readUInt32LE(Constants.CENTIM);
	            // uncompressed file crc-32 value
	            _crc = data.readUInt32LE(Constants.CENCRC);
	            // compressed size
	            _compressedSize = data.readUInt32LE(Constants.CENSIZ);
	            // uncompressed size
	            _size = data.readUInt32LE(Constants.CENLEN);
	            // filename length
	            _fnameLen = data.readUInt16LE(Constants.CENNAM);
	            // extra field length
	            _extraLen = data.readUInt16LE(Constants.CENEXT);
	            // file comment length
	            _comLen = data.readUInt16LE(Constants.CENCOM);
	            // volume number start
	            _diskStart = data.readUInt16LE(Constants.CENDSK);
	            // internal file attributes
	            _inattr = data.readUInt16LE(Constants.CENATT);
	            // external file attributes
	            _attr = data.readUInt32LE(Constants.CENATX);
	            // LOC header offset
	            _offset = data.readUInt32LE(Constants.CENOFF);
	        },

	        dataHeaderToBinary: function () {
	            // LOC header size (30 bytes)
	            var data = Buffer.alloc(Constants.LOCHDR);
	            // "PK\003\004"
	            data.writeUInt32LE(Constants.LOCSIG, 0);
	            // version needed to extract
	            data.writeUInt16LE(_version, Constants.LOCVER);
	            // general purpose bit flag
	            data.writeUInt16LE(_flags, Constants.LOCFLG);
	            // compression method
	            data.writeUInt16LE(_method, Constants.LOCHOW);
	            // modification time (2 bytes time, 2 bytes date)
	            data.writeUInt32LE(_time, Constants.LOCTIM);
	            // uncompressed file crc-32 value
	            data.writeUInt32LE(_crc, Constants.LOCCRC);
	            // compressed size
	            data.writeUInt32LE(_compressedSize, Constants.LOCSIZ);
	            // uncompressed size
	            data.writeUInt32LE(_size, Constants.LOCLEN);
	            // filename length
	            data.writeUInt16LE(_fnameLen, Constants.LOCNAM);
	            // extra field length
	            data.writeUInt16LE(_extraLen, Constants.LOCEXT);
	            return data;
	        },

	        entryHeaderToBinary: function () {
	            // CEN header size (46 bytes)
	            var data = Buffer.alloc(Constants.CENHDR + _fnameLen + _extraLen + _comLen);
	            // "PK\001\002"
	            data.writeUInt32LE(Constants.CENSIG, 0);
	            // version made by
	            data.writeUInt16LE(_verMade, Constants.CENVEM);
	            // version needed to extract
	            data.writeUInt16LE(_version, Constants.CENVER);
	            // encrypt, decrypt flags
	            data.writeUInt16LE(_flags, Constants.CENFLG);
	            // compression method
	            data.writeUInt16LE(_method, Constants.CENHOW);
	            // modification time (2 bytes time, 2 bytes date)
	            data.writeUInt32LE(_time, Constants.CENTIM);
	            // uncompressed file crc-32 value
	            data.writeUInt32LE(_crc, Constants.CENCRC);
	            // compressed size
	            data.writeUInt32LE(_compressedSize, Constants.CENSIZ);
	            // uncompressed size
	            data.writeUInt32LE(_size, Constants.CENLEN);
	            // filename length
	            data.writeUInt16LE(_fnameLen, Constants.CENNAM);
	            // extra field length
	            data.writeUInt16LE(_extraLen, Constants.CENEXT);
	            // file comment length
	            data.writeUInt16LE(_comLen, Constants.CENCOM);
	            // volume number start
	            data.writeUInt16LE(_diskStart, Constants.CENDSK);
	            // internal file attributes
	            data.writeUInt16LE(_inattr, Constants.CENATT);
	            // external file attributes
	            data.writeUInt32LE(_attr, Constants.CENATX);
	            // LOC header offset
	            data.writeUInt32LE(_offset, Constants.CENOFF);
	            // fill all with
	            data.fill(0x00, Constants.CENHDR);
	            return data;
	        },

	        toJSON: function () {
	            const bytes = function (nr) {
	                return nr + " bytes";
	            };

	            return {
	                made: _verMade,
	                version: _version,
	                flags: _flags,
	                method: Utils.methodToString(_method),
	                time: this.time,
	                crc: "0x" + _crc.toString(16).toUpperCase(),
	                compressedSize: bytes(_compressedSize),
	                size: bytes(_size),
	                fileNameLength: bytes(_fnameLen),
	                extraLength: bytes(_extraLen),
	                commentLength: bytes(_comLen),
	                diskNumStart: _diskStart,
	                inAttr: _inattr,
	                attr: _attr,
	                offset: _offset,
	                entryHeaderSize: bytes(Constants.CENHDR + _fnameLen + _extraLen + _comLen)
	            };
	        },

	        toString: function () {
	            return JSON.stringify(this.toJSON(), null, "\t");
	        }
	    };
	};
	return entryHeader;
}var mainHeader;
var hasRequiredMainHeader;

function requireMainHeader () {
	if (hasRequiredMainHeader) return mainHeader;
	hasRequiredMainHeader = 1;
	var Utils = requireUtil$a(),
	    Constants = Utils.Constants;

	/* The entries in the end of central directory */
	mainHeader = function () {
	    var _volumeEntries = 0,
	        _totalEntries = 0,
	        _size = 0,
	        _offset = 0,
	        _commentLength = 0;

	    return {
	        get diskEntries() {
	            return _volumeEntries;
	        },
	        set diskEntries(/*Number*/ val) {
	            _volumeEntries = _totalEntries = val;
	        },

	        get totalEntries() {
	            return _totalEntries;
	        },
	        set totalEntries(/*Number*/ val) {
	            _totalEntries = _volumeEntries = val;
	        },

	        get size() {
	            return _size;
	        },
	        set size(/*Number*/ val) {
	            _size = val;
	        },

	        get offset() {
	            return _offset;
	        },
	        set offset(/*Number*/ val) {
	            _offset = val;
	        },

	        get commentLength() {
	            return _commentLength;
	        },
	        set commentLength(/*Number*/ val) {
	            _commentLength = val;
	        },

	        get mainHeaderSize() {
	            return Constants.ENDHDR + _commentLength;
	        },

	        loadFromBinary: function (/*Buffer*/ data) {
	            // data should be 22 bytes and start with "PK 05 06"
	            // or be 56+ bytes and start with "PK 06 06" for Zip64
	            if (
	                (data.length !== Constants.ENDHDR || data.readUInt32LE(0) !== Constants.ENDSIG) &&
	                (data.length < Constants.ZIP64HDR || data.readUInt32LE(0) !== Constants.ZIP64SIG)
	            ) {
	                throw new Error(Utils.Errors.INVALID_END);
	            }

	            if (data.readUInt32LE(0) === Constants.ENDSIG) {
	                // number of entries on this volume
	                _volumeEntries = data.readUInt16LE(Constants.ENDSUB);
	                // total number of entries
	                _totalEntries = data.readUInt16LE(Constants.ENDTOT);
	                // central directory size in bytes
	                _size = data.readUInt32LE(Constants.ENDSIZ);
	                // offset of first CEN header
	                _offset = data.readUInt32LE(Constants.ENDOFF);
	                // zip file comment length
	                _commentLength = data.readUInt16LE(Constants.ENDCOM);
	            } else {
	                // number of entries on this volume
	                _volumeEntries = Utils.readBigUInt64LE(data, Constants.ZIP64SUB);
	                // total number of entries
	                _totalEntries = Utils.readBigUInt64LE(data, Constants.ZIP64TOT);
	                // central directory size in bytes
	                _size = Utils.readBigUInt64LE(data, Constants.ZIP64SIZE);
	                // offset of first CEN header
	                _offset = Utils.readBigUInt64LE(data, Constants.ZIP64OFF);

	                _commentLength = 0;
	            }
	        },

	        toBinary: function () {
	            var b = Buffer.alloc(Constants.ENDHDR + _commentLength);
	            // "PK 05 06" signature
	            b.writeUInt32LE(Constants.ENDSIG, 0);
	            b.writeUInt32LE(0, 4);
	            // number of entries on this volume
	            b.writeUInt16LE(_volumeEntries, Constants.ENDSUB);
	            // total number of entries
	            b.writeUInt16LE(_totalEntries, Constants.ENDTOT);
	            // central directory size in bytes
	            b.writeUInt32LE(_size, Constants.ENDSIZ);
	            // offset of first CEN header
	            b.writeUInt32LE(_offset, Constants.ENDOFF);
	            // zip file comment length
	            b.writeUInt16LE(_commentLength, Constants.ENDCOM);
	            // fill comment memory with spaces so no garbage is left there
	            b.fill(" ", Constants.ENDHDR);

	            return b;
	        },

	        toJSON: function () {
	            // creates 0x0000 style output
	            const offset = function (nr, len) {
	                let offs = nr.toString(16).toUpperCase();
	                while (offs.length < len) offs = "0" + offs;
	                return "0x" + offs;
	            };

	            return {
	                diskEntries: _volumeEntries,
	                totalEntries: _totalEntries,
	                size: _size + " bytes",
	                offset: offset(_offset, 4),
	                commentLength: _commentLength
	            };
	        },

	        toString: function () {
	            return JSON.stringify(this.toJSON(), null, "\t");
	        }
	    };
	};
	 // Misspelled
	return mainHeader;
}var hasRequiredHeaders$1;

function requireHeaders$1 () {
	if (hasRequiredHeaders$1) return headers$1;
	hasRequiredHeaders$1 = 1;
	headers$1.EntryHeader = requireEntryHeader();
	headers$1.MainHeader = requireMainHeader();
	return headers$1;
}var methods = {};var deflater;
var hasRequiredDeflater;

function requireDeflater () {
	if (hasRequiredDeflater) return deflater;
	hasRequiredDeflater = 1;
	deflater = function (/*Buffer*/ inbuf) {
	    var zlib = require$$0$e;

	    var opts = { chunkSize: (parseInt(inbuf.length / 1024) + 1) * 1024 };

	    return {
	        deflate: function () {
	            return zlib.deflateRawSync(inbuf, opts);
	        },

	        deflateAsync: function (/*Function*/ callback) {
	            var tmp = zlib.createDeflateRaw(opts),
	                parts = [],
	                total = 0;
	            tmp.on("data", function (data) {
	                parts.push(data);
	                total += data.length;
	            });
	            tmp.on("end", function () {
	                var buf = Buffer.alloc(total),
	                    written = 0;
	                buf.fill(0);
	                for (var i = 0; i < parts.length; i++) {
	                    var part = parts[i];
	                    part.copy(buf, written);
	                    written += part.length;
	                }
	                callback && callback(buf);
	            });
	            tmp.end(inbuf);
	        }
	    };
	};
	return deflater;
}var inflater;
var hasRequiredInflater;

function requireInflater () {
	if (hasRequiredInflater) return inflater;
	hasRequiredInflater = 1;
	inflater = function (/*Buffer*/ inbuf) {
	    var zlib = require$$0$e;

	    return {
	        inflate: function () {
	            return zlib.inflateRawSync(inbuf);
	        },

	        inflateAsync: function (/*Function*/ callback) {
	            var tmp = zlib.createInflateRaw(),
	                parts = [],
	                total = 0;
	            tmp.on("data", function (data) {
	                parts.push(data);
	                total += data.length;
	            });
	            tmp.on("end", function () {
	                var buf = Buffer.alloc(total),
	                    written = 0;
	                buf.fill(0);
	                for (var i = 0; i < parts.length; i++) {
	                    var part = parts[i];
	                    part.copy(buf, written);
	                    written += part.length;
	                }
	                callback && callback(buf);
	            });
	            tmp.end(inbuf);
	        }
	    };
	};
	return inflater;
}var zipcrypto;
var hasRequiredZipcrypto;

function requireZipcrypto () {
	if (hasRequiredZipcrypto) return zipcrypto;
	hasRequiredZipcrypto = 1;

	// node crypt, we use it for generate salt
	// eslint-disable-next-line node/no-unsupported-features/node-builtins
	const { randomFillSync } = require$$0$a;

	// generate CRC32 lookup table
	const crctable = new Uint32Array(256).map((t, crc) => {
	    for (let j = 0; j < 8; j++) {
	        if (0 !== (crc & 1)) {
	            crc = (crc >>> 1) ^ 0xedb88320;
	        } else {
	            crc >>>= 1;
	        }
	    }
	    return crc >>> 0;
	});

	// C-style uInt32 Multiply (discards higher bits, when JS multiply discards lower bits)
	const uMul = (a, b) => Math.imul(a, b) >>> 0;

	// crc32 byte single update (actually same function is part of utils.crc32 function :) )
	const crc32update = (pCrc32, bval) => {
	    return crctable[(pCrc32 ^ bval) & 0xff] ^ (pCrc32 >>> 8);
	};

	// function for generating salt for encrytion header
	const genSalt = () => {
	    if ("function" === typeof randomFillSync) {
	        return randomFillSync(Buffer.alloc(12));
	    } else {
	        // fallback if function is not defined
	        return genSalt.node();
	    }
	};

	// salt generation with node random function (mainly as fallback)
	genSalt.node = () => {
	    const salt = Buffer.alloc(12);
	    const len = salt.length;
	    for (let i = 0; i < len; i++) salt[i] = (Math.random() * 256) & 0xff;
	    return salt;
	};

	// general config
	const config = {
	    genSalt
	};

	// Class Initkeys handles same basic ops with keys
	function Initkeys(pw) {
	    const pass = Buffer.isBuffer(pw) ? pw : Buffer.from(pw);
	    this.keys = new Uint32Array([0x12345678, 0x23456789, 0x34567890]);
	    for (let i = 0; i < pass.length; i++) {
	        this.updateKeys(pass[i]);
	    }
	}

	Initkeys.prototype.updateKeys = function (byteValue) {
	    const keys = this.keys;
	    keys[0] = crc32update(keys[0], byteValue);
	    keys[1] += keys[0] & 0xff;
	    keys[1] = uMul(keys[1], 134775813) + 1;
	    keys[2] = crc32update(keys[2], keys[1] >>> 24);
	    return byteValue;
	};

	Initkeys.prototype.next = function () {
	    const k = (this.keys[2] | 2) >>> 0; // key
	    return (uMul(k, k ^ 1) >> 8) & 0xff; // decode
	};

	function make_decrypter(/*Buffer*/ pwd) {
	    // 1. Stage initialize key
	    const keys = new Initkeys(pwd);

	    // return decrypter function
	    return function (/*Buffer*/ data) {
	        // result - we create new Buffer for results
	        const result = Buffer.alloc(data.length);
	        let pos = 0;
	        // process input data
	        for (let c of data) {
	            //c ^= keys.next();
	            //result[pos++] = c; // decode & Save Value
	            result[pos++] = keys.updateKeys(c ^ keys.next()); // update keys with decoded byte
	        }
	        return result;
	    };
	}

	function make_encrypter(/*Buffer*/ pwd) {
	    // 1. Stage initialize key
	    const keys = new Initkeys(pwd);

	    // return encrypting function, result and pos is here so we dont have to merge buffers later
	    return function (/*Buffer*/ data, /*Buffer*/ result, /* Number */ pos = 0) {
	        // result - we create new Buffer for results
	        if (!result) result = Buffer.alloc(data.length);
	        // process input data
	        for (let c of data) {
	            const k = keys.next(); // save key byte
	            result[pos++] = c ^ k; // save val
	            keys.updateKeys(c); // update keys with decoded byte
	        }
	        return result;
	    };
	}

	function decrypt(/*Buffer*/ data, /*Object*/ header, /*String, Buffer*/ pwd) {
	    if (!data || !Buffer.isBuffer(data) || data.length < 12) {
	        return Buffer.alloc(0);
	    }

	    // 1. We Initialize and generate decrypting function
	    const decrypter = make_decrypter(pwd);

	    // 2. decrypt salt what is always 12 bytes and is a part of file content
	    const salt = decrypter(data.slice(0, 12));

	    // if bit 3 (0x08) of the general-purpose flags field is set, check salt[11] with the high byte of the header time
	    // 2 byte data block (as per Info-Zip spec), otherwise check with the high byte of the header entry
	    const verifyByte = ((header.flags & 0x8) === 0x8) ? header.timeHighByte : header.crc >>> 24;

	    //3. does password meet expectations
	    if (salt[11] !== verifyByte) {
	        throw "ADM-ZIP: Wrong Password";
	    }

	    // 4. decode content
	    return decrypter(data.slice(12));
	}

	// lets add way to populate salt, NOT RECOMMENDED for production but maybe useful for testing general functionality
	function _salter(data) {
	    if (Buffer.isBuffer(data) && data.length >= 12) {
	        // be aware - currently salting buffer data is modified
	        config.genSalt = function () {
	            return data.slice(0, 12);
	        };
	    } else if (data === "node") {
	        // test salt generation with node random function
	        config.genSalt = genSalt.node;
	    } else {
	        // if value is not acceptable config gets reset.
	        config.genSalt = genSalt;
	    }
	}

	function encrypt(/*Buffer*/ data, /*Object*/ header, /*String, Buffer*/ pwd, /*Boolean*/ oldlike = false) {
	    // 1. test data if data is not Buffer we make buffer from it
	    if (data == null) data = Buffer.alloc(0);
	    // if data is not buffer be make buffer from it
	    if (!Buffer.isBuffer(data)) data = Buffer.from(data.toString());

	    // 2. We Initialize and generate encrypting function
	    const encrypter = make_encrypter(pwd);

	    // 3. generate salt (12-bytes of random data)
	    const salt = config.genSalt();
	    salt[11] = (header.crc >>> 24) & 0xff;

	    // old implementations (before PKZip 2.04g) used two byte check
	    if (oldlike) salt[10] = (header.crc >>> 16) & 0xff;

	    // 4. create output
	    const result = Buffer.alloc(data.length + 12);
	    encrypter(salt, result);

	    // finally encode content
	    return encrypter(data, result, 12);
	}

	zipcrypto = { decrypt, encrypt, _salter };
	return zipcrypto;
}var hasRequiredMethods;

function requireMethods () {
	if (hasRequiredMethods) return methods;
	hasRequiredMethods = 1;
	methods.Deflater = requireDeflater();
	methods.Inflater = requireInflater();
	methods.ZipCrypto = requireZipcrypto();
	return methods;
}var zipEntry;
var hasRequiredZipEntry;

function requireZipEntry () {
	if (hasRequiredZipEntry) return zipEntry;
	hasRequiredZipEntry = 1;
	var Utils = requireUtil$a(),
	    Headers = requireHeaders$1(),
	    Constants = Utils.Constants,
	    Methods = requireMethods();

	zipEntry = function (/*Buffer*/ input) {
	    var _entryHeader = new Headers.EntryHeader(),
	        _entryName = Buffer.alloc(0),
	        _comment = Buffer.alloc(0),
	        _isDirectory = false,
	        uncompressedData = null,
	        _extra = Buffer.alloc(0);

	    function getCompressedDataFromZip() {
	        if (!input || !Buffer.isBuffer(input)) {
	            return Buffer.alloc(0);
	        }
	        _entryHeader.loadDataHeaderFromBinary(input);
	        return input.slice(_entryHeader.realDataOffset, _entryHeader.realDataOffset + _entryHeader.compressedSize);
	    }

	    function crc32OK(data) {
	        // if bit 3 (0x08) of the general-purpose flags field is set, then the CRC-32 and file sizes are not known when the header is written
	        if ((_entryHeader.flags & 0x8) !== 0x8) {
	            if (Utils.crc32(data) !== _entryHeader.dataHeader.crc) {
	                return false;
	            }
	        }
	        return true;
	    }

	    function decompress(/*Boolean*/ async, /*Function*/ callback, /*String, Buffer*/ pass) {
	        if (typeof callback === "undefined" && typeof async === "string") {
	            pass = async;
	            async = void 0;
	        }
	        if (_isDirectory) {
	            if (async && callback) {
	                callback(Buffer.alloc(0), Utils.Errors.DIRECTORY_CONTENT_ERROR); //si added error.
	            }
	            return Buffer.alloc(0);
	        }

	        var compressedData = getCompressedDataFromZip();

	        if (compressedData.length === 0) {
	            // File is empty, nothing to decompress.
	            if (async && callback) callback(compressedData);
	            return compressedData;
	        }

	        if (_entryHeader.encripted) {
	            if ("string" !== typeof pass && !Buffer.isBuffer(pass)) {
	                throw new Error("ADM-ZIP: Incompatible password parameter");
	            }
	            compressedData = Methods.ZipCrypto.decrypt(compressedData, _entryHeader, pass);
	        }

	        var data = Buffer.alloc(_entryHeader.size);

	        switch (_entryHeader.method) {
	            case Utils.Constants.STORED:
	                compressedData.copy(data);
	                if (!crc32OK(data)) {
	                    if (async && callback) callback(data, Utils.Errors.BAD_CRC); //si added error
	                    throw new Error(Utils.Errors.BAD_CRC);
	                } else {
	                    //si added otherwise did not seem to return data.
	                    if (async && callback) callback(data);
	                    return data;
	                }
	            case Utils.Constants.DEFLATED:
	                var inflater = new Methods.Inflater(compressedData);
	                if (!async) {
	                    const result = inflater.inflate(data);
	                    result.copy(data, 0);
	                    if (!crc32OK(data)) {
	                        throw new Error(Utils.Errors.BAD_CRC + " " + _entryName.toString());
	                    }
	                    return data;
	                } else {
	                    inflater.inflateAsync(function (result) {
	                        result.copy(result, 0);
	                        if (callback) {
	                            if (!crc32OK(result)) {
	                                callback(result, Utils.Errors.BAD_CRC); //si added error
	                            } else {
	                                callback(result);
	                            }
	                        }
	                    });
	                }
	                break;
	            default:
	                if (async && callback) callback(Buffer.alloc(0), Utils.Errors.UNKNOWN_METHOD);
	                throw new Error(Utils.Errors.UNKNOWN_METHOD);
	        }
	    }

	    function compress(/*Boolean*/ async, /*Function*/ callback) {
	        if ((!uncompressedData || !uncompressedData.length) && Buffer.isBuffer(input)) {
	            // no data set or the data wasn't changed to require recompression
	            if (async && callback) callback(getCompressedDataFromZip());
	            return getCompressedDataFromZip();
	        }

	        if (uncompressedData.length && !_isDirectory) {
	            var compressedData;
	            // Local file header
	            switch (_entryHeader.method) {
	                case Utils.Constants.STORED:
	                    _entryHeader.compressedSize = _entryHeader.size;

	                    compressedData = Buffer.alloc(uncompressedData.length);
	                    uncompressedData.copy(compressedData);

	                    if (async && callback) callback(compressedData);
	                    return compressedData;
	                default:
	                case Utils.Constants.DEFLATED:
	                    var deflater = new Methods.Deflater(uncompressedData);
	                    if (!async) {
	                        var deflated = deflater.deflate();
	                        _entryHeader.compressedSize = deflated.length;
	                        return deflated;
	                    } else {
	                        deflater.deflateAsync(function (data) {
	                            compressedData = Buffer.alloc(data.length);
	                            _entryHeader.compressedSize = data.length;
	                            data.copy(compressedData);
	                            callback && callback(compressedData);
	                        });
	                    }
	                    deflater = null;
	                    break;
	            }
	        } else if (async && callback) {
	            callback(Buffer.alloc(0));
	        } else {
	            return Buffer.alloc(0);
	        }
	    }

	    function readUInt64LE(buffer, offset) {
	        return (buffer.readUInt32LE(offset + 4) << 4) + buffer.readUInt32LE(offset);
	    }

	    function parseExtra(data) {
	        var offset = 0;
	        var signature, size, part;
	        while (offset < data.length) {
	            signature = data.readUInt16LE(offset);
	            offset += 2;
	            size = data.readUInt16LE(offset);
	            offset += 2;
	            part = data.slice(offset, offset + size);
	            offset += size;
	            if (Constants.ID_ZIP64 === signature) {
	                parseZip64ExtendedInformation(part);
	            }
	        }
	    }

	    //Override header field values with values from the ZIP64 extra field
	    function parseZip64ExtendedInformation(data) {
	        var size, compressedSize, offset, diskNumStart;

	        if (data.length >= Constants.EF_ZIP64_SCOMP) {
	            size = readUInt64LE(data, Constants.EF_ZIP64_SUNCOMP);
	            if (_entryHeader.size === Constants.EF_ZIP64_OR_32) {
	                _entryHeader.size = size;
	            }
	        }
	        if (data.length >= Constants.EF_ZIP64_RHO) {
	            compressedSize = readUInt64LE(data, Constants.EF_ZIP64_SCOMP);
	            if (_entryHeader.compressedSize === Constants.EF_ZIP64_OR_32) {
	                _entryHeader.compressedSize = compressedSize;
	            }
	        }
	        if (data.length >= Constants.EF_ZIP64_DSN) {
	            offset = readUInt64LE(data, Constants.EF_ZIP64_RHO);
	            if (_entryHeader.offset === Constants.EF_ZIP64_OR_32) {
	                _entryHeader.offset = offset;
	            }
	        }
	        if (data.length >= Constants.EF_ZIP64_DSN + 4) {
	            diskNumStart = data.readUInt32LE(Constants.EF_ZIP64_DSN);
	            if (_entryHeader.diskNumStart === Constants.EF_ZIP64_OR_16) {
	                _entryHeader.diskNumStart = diskNumStart;
	            }
	        }
	    }

	    return {
	        get entryName() {
	            return _entryName.toString();
	        },
	        get rawEntryName() {
	            return _entryName;
	        },
	        set entryName(val) {
	            _entryName = Utils.toBuffer(val);
	            var lastChar = _entryName[_entryName.length - 1];
	            _isDirectory = lastChar === 47 || lastChar === 92;
	            _entryHeader.fileNameLength = _entryName.length;
	        },

	        get extra() {
	            return _extra;
	        },
	        set extra(val) {
	            _extra = val;
	            _entryHeader.extraLength = val.length;
	            parseExtra(val);
	        },

	        get comment() {
	            return _comment.toString();
	        },
	        set comment(val) {
	            _comment = Utils.toBuffer(val);
	            _entryHeader.commentLength = _comment.length;
	        },

	        get name() {
	            var n = _entryName.toString();
	            return _isDirectory
	                ? n
	                      .substr(n.length - 1)
	                      .split("/")
	                      .pop()
	                : n.split("/").pop();
	        },
	        get isDirectory() {
	            return _isDirectory;
	        },

	        getCompressedData: function () {
	            return compress(false, null);
	        },

	        getCompressedDataAsync: function (/*Function*/ callback) {
	            compress(true, callback);
	        },

	        setData: function (value) {
	            uncompressedData = Utils.toBuffer(value);
	            if (!_isDirectory && uncompressedData.length) {
	                _entryHeader.size = uncompressedData.length;
	                _entryHeader.method = Utils.Constants.DEFLATED;
	                _entryHeader.crc = Utils.crc32(value);
	                _entryHeader.changed = true;
	            } else {
	                // folders and blank files should be stored
	                _entryHeader.method = Utils.Constants.STORED;
	            }
	        },

	        getData: function (pass) {
	            if (_entryHeader.changed) {
	                return uncompressedData;
	            } else {
	                return decompress(false, null, pass);
	            }
	        },

	        getDataAsync: function (/*Function*/ callback, pass) {
	            if (_entryHeader.changed) {
	                callback(uncompressedData);
	            } else {
	                decompress(true, callback, pass);
	            }
	        },

	        set attr(attr) {
	            _entryHeader.attr = attr;
	        },
	        get attr() {
	            return _entryHeader.attr;
	        },

	        set header(/*Buffer*/ data) {
	            _entryHeader.loadFromBinary(data);
	        },

	        get header() {
	            return _entryHeader;
	        },

	        packHeader: function () {
	            // 1. create header (buffer)
	            var header = _entryHeader.entryHeaderToBinary();
	            var addpos = Utils.Constants.CENHDR;
	            // 2. add file name
	            _entryName.copy(header, addpos);
	            addpos += _entryName.length;
	            // 3. add extra data
	            if (_entryHeader.extraLength) {
	                _extra.copy(header, addpos);
	                addpos += _entryHeader.extraLength;
	            }
	            // 4. add file comment
	            if (_entryHeader.commentLength) {
	                _comment.copy(header, addpos);
	            }
	            return header;
	        },

	        toJSON: function () {
	            const bytes = function (nr) {
	                return "<" + ((nr && nr.length + " bytes buffer") || "null") + ">";
	            };

	            return {
	                entryName: this.entryName,
	                name: this.name,
	                comment: this.comment,
	                isDirectory: this.isDirectory,
	                header: _entryHeader.toJSON(),
	                compressedData: bytes(input),
	                data: bytes(uncompressedData)
	            };
	        },

	        toString: function () {
	            return JSON.stringify(this.toJSON(), null, "\t");
	        }
	    };
	};
	return zipEntry;
}var zipFile;
var hasRequiredZipFile;

function requireZipFile () {
	if (hasRequiredZipFile) return zipFile;
	hasRequiredZipFile = 1;
	const ZipEntry = requireZipEntry();
	const Headers = requireHeaders$1();
	const Utils = requireUtil$a();

	zipFile = function (/*Buffer|null*/ inBuffer, /** object */ options) {
	    var entryList = [],
	        entryTable = {},
	        _comment = Buffer.alloc(0),
	        mainHeader = new Headers.MainHeader(),
	        loadedEntries = false;

	    // assign options
	    const opts = Object.assign(Object.create(null), options);

	    const { noSort } = opts;

	    if (inBuffer) {
	        // is a memory buffer
	        readMainHeader(opts.readEntries);
	    } else {
	        // none. is a new file
	        loadedEntries = true;
	    }

	    function iterateEntries(callback) {
	        const totalEntries = mainHeader.diskEntries; // total number of entries
	        let index = mainHeader.offset; // offset of first CEN header

	        for (let i = 0; i < totalEntries; i++) {
	            let tmp = index;
	            const entry = new ZipEntry(inBuffer);

	            entry.header = inBuffer.slice(tmp, (tmp += Utils.Constants.CENHDR));
	            entry.entryName = inBuffer.slice(tmp, (tmp += entry.header.fileNameLength));

	            index += entry.header.entryHeaderSize;

	            callback(entry);
	        }
	    }

	    function readEntries() {
	        loadedEntries = true;
	        entryTable = {};
	        entryList = new Array(mainHeader.diskEntries); // total number of entries
	        var index = mainHeader.offset; // offset of first CEN header
	        for (var i = 0; i < entryList.length; i++) {
	            var tmp = index,
	                entry = new ZipEntry(inBuffer);
	            entry.header = inBuffer.slice(tmp, (tmp += Utils.Constants.CENHDR));

	            entry.entryName = inBuffer.slice(tmp, (tmp += entry.header.fileNameLength));

	            if (entry.header.extraLength) {
	                entry.extra = inBuffer.slice(tmp, (tmp += entry.header.extraLength));
	            }

	            if (entry.header.commentLength) entry.comment = inBuffer.slice(tmp, tmp + entry.header.commentLength);

	            index += entry.header.entryHeaderSize;

	            entryList[i] = entry;
	            entryTable[entry.entryName] = entry;
	        }
	    }

	    function readMainHeader(/*Boolean*/ readNow) {
	        var i = inBuffer.length - Utils.Constants.ENDHDR, // END header size
	            max = Math.max(0, i - 0xffff), // 0xFFFF is the max zip file comment length
	            n = max,
	            endStart = inBuffer.length,
	            endOffset = -1, // Start offset of the END header
	            commentEnd = 0;

	        for (i; i >= n; i--) {
	            if (inBuffer[i] !== 0x50) continue; // quick check that the byte is 'P'
	            if (inBuffer.readUInt32LE(i) === Utils.Constants.ENDSIG) {
	                // "PK\005\006"
	                endOffset = i;
	                commentEnd = i;
	                endStart = i + Utils.Constants.ENDHDR;
	                // We already found a regular signature, let's look just a bit further to check if there's any zip64 signature
	                n = i - Utils.Constants.END64HDR;
	                continue;
	            }

	            if (inBuffer.readUInt32LE(i) === Utils.Constants.END64SIG) {
	                // Found a zip64 signature, let's continue reading the whole zip64 record
	                n = max;
	                continue;
	            }

	            if (inBuffer.readUInt32LE(i) === Utils.Constants.ZIP64SIG) {
	                // Found the zip64 record, let's determine it's size
	                endOffset = i;
	                endStart = i + Utils.readBigUInt64LE(inBuffer, i + Utils.Constants.ZIP64SIZE) + Utils.Constants.ZIP64LEAD;
	                break;
	            }
	        }

	        if (!~endOffset) throw new Error(Utils.Errors.INVALID_FORMAT);

	        mainHeader.loadFromBinary(inBuffer.slice(endOffset, endStart));
	        if (mainHeader.commentLength) {
	            _comment = inBuffer.slice(commentEnd + Utils.Constants.ENDHDR);
	        }
	        if (readNow) readEntries();
	    }

	    function sortEntries() {
	        if (entryList.length > 1 && !noSort) {
	            entryList.sort((a, b) => a.entryName.toLowerCase().localeCompare(b.entryName.toLowerCase()));
	        }
	    }

	    return {
	        /**
	         * Returns an array of ZipEntry objects existent in the current opened archive
	         * @return Array
	         */
	        get entries() {
	            if (!loadedEntries) {
	                readEntries();
	            }
	            return entryList;
	        },

	        /**
	         * Archive comment
	         * @return {String}
	         */
	        get comment() {
	            return _comment.toString();
	        },
	        set comment(val) {
	            _comment = Utils.toBuffer(val);
	            mainHeader.commentLength = _comment.length;
	        },

	        getEntryCount: function () {
	            if (!loadedEntries) {
	                return mainHeader.diskEntries;
	            }

	            return entryList.length;
	        },

	        forEach: function (callback) {
	            if (!loadedEntries) {
	                iterateEntries(callback);
	                return;
	            }

	            entryList.forEach(callback);
	        },

	        /**
	         * Returns a reference to the entry with the given name or null if entry is inexistent
	         *
	         * @param entryName
	         * @return ZipEntry
	         */
	        getEntry: function (/*String*/ entryName) {
	            if (!loadedEntries) {
	                readEntries();
	            }
	            return entryTable[entryName] || null;
	        },

	        /**
	         * Adds the given entry to the entry list
	         *
	         * @param entry
	         */
	        setEntry: function (/*ZipEntry*/ entry) {
	            if (!loadedEntries) {
	                readEntries();
	            }
	            entryList.push(entry);
	            entryTable[entry.entryName] = entry;
	            mainHeader.totalEntries = entryList.length;
	        },

	        /**
	         * Removes the entry with the given name from the entry list.
	         *
	         * If the entry is a directory, then all nested files and directories will be removed
	         * @param entryName
	         */
	        deleteEntry: function (/*String*/ entryName) {
	            if (!loadedEntries) {
	                readEntries();
	            }
	            var entry = entryTable[entryName];
	            if (entry && entry.isDirectory) {
	                var _self = this;
	                this.getEntryChildren(entry).forEach(function (child) {
	                    if (child.entryName !== entryName) {
	                        _self.deleteEntry(child.entryName);
	                    }
	                });
	            }
	            entryList.splice(entryList.indexOf(entry), 1);
	            delete entryTable[entryName];
	            mainHeader.totalEntries = entryList.length;
	        },

	        /**
	         *  Iterates and returns all nested files and directories of the given entry
	         *
	         * @param entry
	         * @return Array
	         */
	        getEntryChildren: function (/*ZipEntry*/ entry) {
	            if (!loadedEntries) {
	                readEntries();
	            }
	            if (entry && entry.isDirectory) {
	                const list = [];
	                const name = entry.entryName;
	                const len = name.length;

	                entryList.forEach(function (zipEntry) {
	                    if (zipEntry.entryName.substr(0, len) === name) {
	                        list.push(zipEntry);
	                    }
	                });
	                return list;
	            }
	            return [];
	        },

	        /**
	         * Returns the zip file
	         *
	         * @return Buffer
	         */
	        compressToBuffer: function () {
	            if (!loadedEntries) {
	                readEntries();
	            }
	            sortEntries();

	            const dataBlock = [];
	            const entryHeaders = [];
	            let totalSize = 0;
	            let dindex = 0;

	            mainHeader.size = 0;
	            mainHeader.offset = 0;

	            for (const entry of entryList) {
	                // compress data and set local and entry header accordingly. Reason why is called first
	                const compressedData = entry.getCompressedData();
	                // 1. construct data header
	                entry.header.offset = dindex;
	                const dataHeader = entry.header.dataHeaderToBinary();
	                const entryNameLen = entry.rawEntryName.length;
	                // 1.2. postheader - data after data header
	                const postHeader = Buffer.alloc(entryNameLen + entry.extra.length);
	                entry.rawEntryName.copy(postHeader, 0);
	                entry.extra.copy(postHeader, entryNameLen);

	                // 2. offsets
	                const dataLength = dataHeader.length + postHeader.length + compressedData.length;
	                dindex += dataLength;

	                // 3. store values in sequence
	                dataBlock.push(dataHeader);
	                dataBlock.push(postHeader);
	                dataBlock.push(compressedData);

	                // 4. construct entry header
	                const entryHeader = entry.packHeader();
	                entryHeaders.push(entryHeader);
	                // 5. update main header
	                mainHeader.size += entryHeader.length;
	                totalSize += dataLength + entryHeader.length;
	            }

	            totalSize += mainHeader.mainHeaderSize; // also includes zip file comment length
	            // point to end of data and beginning of central directory first record
	            mainHeader.offset = dindex;

	            dindex = 0;
	            const outBuffer = Buffer.alloc(totalSize);
	            // write data blocks
	            for (const content of dataBlock) {
	                content.copy(outBuffer, dindex);
	                dindex += content.length;
	            }

	            // write central directory entries
	            for (const content of entryHeaders) {
	                content.copy(outBuffer, dindex);
	                dindex += content.length;
	            }

	            // write main header
	            const mh = mainHeader.toBinary();
	            if (_comment) {
	                _comment.copy(mh, Utils.Constants.ENDHDR); // add zip file comment
	            }
	            mh.copy(outBuffer, dindex);

	            return outBuffer;
	        },

	        toAsyncBuffer: function (/*Function*/ onSuccess, /*Function*/ onFail, /*Function*/ onItemStart, /*Function*/ onItemEnd) {
	            try {
	                if (!loadedEntries) {
	                    readEntries();
	                }
	                sortEntries();

	                const dataBlock = [];
	                const entryHeaders = [];
	                let totalSize = 0;
	                let dindex = 0;

	                mainHeader.size = 0;
	                mainHeader.offset = 0;

	                const compress2Buffer = function (entryLists) {
	                    if (entryLists.length) {
	                        const entry = entryLists.pop();
	                        const name = entry.entryName + entry.extra.toString();
	                        if (onItemStart) onItemStart(name);
	                        entry.getCompressedDataAsync(function (compressedData) {
	                            if (onItemEnd) onItemEnd(name);

	                            entry.header.offset = dindex;
	                            // data header
	                            const dataHeader = entry.header.dataHeaderToBinary();
	                            const postHeader = Buffer.alloc(name.length, name);
	                            const dataLength = dataHeader.length + postHeader.length + compressedData.length;

	                            dindex += dataLength;

	                            dataBlock.push(dataHeader);
	                            dataBlock.push(postHeader);
	                            dataBlock.push(compressedData);

	                            const entryHeader = entry.packHeader();
	                            entryHeaders.push(entryHeader);
	                            mainHeader.size += entryHeader.length;
	                            totalSize += dataLength + entryHeader.length;

	                            compress2Buffer(entryLists);
	                        });
	                    } else {
	                        totalSize += mainHeader.mainHeaderSize; // also includes zip file comment length
	                        // point to end of data and beginning of central directory first record
	                        mainHeader.offset = dindex;

	                        dindex = 0;
	                        const outBuffer = Buffer.alloc(totalSize);
	                        dataBlock.forEach(function (content) {
	                            content.copy(outBuffer, dindex); // write data blocks
	                            dindex += content.length;
	                        });
	                        entryHeaders.forEach(function (content) {
	                            content.copy(outBuffer, dindex); // write central directory entries
	                            dindex += content.length;
	                        });

	                        const mh = mainHeader.toBinary();
	                        if (_comment) {
	                            _comment.copy(mh, Utils.Constants.ENDHDR); // add zip file comment
	                        }

	                        mh.copy(outBuffer, dindex); // write main header

	                        onSuccess(outBuffer);
	                    }
	                };

	                compress2Buffer(entryList);
	            } catch (e) {
	                onFail(e);
	            }
	        }
	    };
	};
	return zipFile;
}var admZip;
var hasRequiredAdmZip;

function requireAdmZip () {
	if (hasRequiredAdmZip) return admZip;
	hasRequiredAdmZip = 1;
	const Utils = requireUtil$a();
	const pth = require$$1$2;
	const ZipEntry = requireZipEntry();
	const ZipFile = requireZipFile();

	const get_Bool = (val, def) => (typeof val === "boolean" ? val : def);
	const get_Str = (val, def) => (typeof val === "string" ? val : def);

	const defaultOptions = {
	    // option "noSort" : if true it disables files sorting
	    noSort: false,
	    // read entries during load (initial loading may be slower)
	    readEntries: false,
	    // default method is none
	    method: Utils.Constants.NONE,
	    // file system
	    fs: null
	};

	admZip = function (/**String*/ input, /** object */ options) {
	    let inBuffer = null;

	    // create object based default options, allowing them to be overwritten
	    const opts = Object.assign(Object.create(null), defaultOptions);

	    // test input variable
	    if (input && "object" === typeof input) {
	        // if value is not buffer we accept it to be object with options
	        if (!(input instanceof Uint8Array)) {
	            Object.assign(opts, input);
	            input = opts.input ? opts.input : undefined;
	            if (opts.input) delete opts.input;
	        }

	        // if input is buffer
	        if (Buffer.isBuffer(input)) {
	            inBuffer = input;
	            opts.method = Utils.Constants.BUFFER;
	            input = undefined;
	        }
	    }

	    // assign options
	    Object.assign(opts, options);

	    // instanciate utils filesystem
	    const filetools = new Utils(opts);

	    // if input is file name we retrieve its content
	    if (input && "string" === typeof input) {
	        // load zip file
	        if (filetools.fs.existsSync(input)) {
	            opts.method = Utils.Constants.FILE;
	            opts.filename = input;
	            inBuffer = filetools.fs.readFileSync(input);
	        } else {
	            throw new Error(Utils.Errors.INVALID_FILENAME);
	        }
	    }

	    // create variable
	    const _zip = new ZipFile(inBuffer, opts);

	    const { canonical, sanitize } = Utils;

	    function getEntry(/**Object*/ entry) {
	        if (entry && _zip) {
	            var item;
	            // If entry was given as a file name
	            if (typeof entry === "string") item = _zip.getEntry(entry);
	            // if entry was given as a ZipEntry object
	            if (typeof entry === "object" && typeof entry.entryName !== "undefined" && typeof entry.header !== "undefined") item = _zip.getEntry(entry.entryName);

	            if (item) {
	                return item;
	            }
	        }
	        return null;
	    }

	    function fixPath(zipPath) {
	        const { join, normalize, sep } = pth.posix;
	        // convert windows file separators and normalize
	        return join(".", normalize(sep + zipPath.split("\\").join(sep) + sep));
	    }

	    return {
	        /**
	         * Extracts the given entry from the archive and returns the content as a Buffer object
	         * @param entry ZipEntry object or String with the full path of the entry
	         *
	         * @return Buffer or Null in case of error
	         */
	        readFile: function (/**Object*/ entry, /*String, Buffer*/ pass) {
	            var item = getEntry(entry);
	            return (item && item.getData(pass)) || null;
	        },

	        /**
	         * Asynchronous readFile
	         * @param entry ZipEntry object or String with the full path of the entry
	         * @param callback
	         *
	         * @return Buffer or Null in case of error
	         */
	        readFileAsync: function (/**Object*/ entry, /**Function*/ callback) {
	            var item = getEntry(entry);
	            if (item) {
	                item.getDataAsync(callback);
	            } else {
	                callback(null, "getEntry failed for:" + entry);
	            }
	        },

	        /**
	         * Extracts the given entry from the archive and returns the content as plain text in the given encoding
	         * @param entry ZipEntry object or String with the full path of the entry
	         * @param encoding Optional. If no encoding is specified utf8 is used
	         *
	         * @return String
	         */
	        readAsText: function (/**Object*/ entry, /**String=*/ encoding) {
	            var item = getEntry(entry);
	            if (item) {
	                var data = item.getData();
	                if (data && data.length) {
	                    return data.toString(encoding || "utf8");
	                }
	            }
	            return "";
	        },

	        /**
	         * Asynchronous readAsText
	         * @param entry ZipEntry object or String with the full path of the entry
	         * @param callback
	         * @param encoding Optional. If no encoding is specified utf8 is used
	         *
	         * @return String
	         */
	        readAsTextAsync: function (/**Object*/ entry, /**Function*/ callback, /**String=*/ encoding) {
	            var item = getEntry(entry);
	            if (item) {
	                item.getDataAsync(function (data, err) {
	                    if (err) {
	                        callback(data, err);
	                        return;
	                    }

	                    if (data && data.length) {
	                        callback(data.toString(encoding || "utf8"));
	                    } else {
	                        callback("");
	                    }
	                });
	            } else {
	                callback("");
	            }
	        },

	        /**
	         * Remove the entry from the file or the entry and all it's nested directories and files if the given entry is a directory
	         *
	         * @param entry
	         */
	        deleteFile: function (/**Object*/ entry) {
	            // @TODO: test deleteFile
	            var item = getEntry(entry);
	            if (item) {
	                _zip.deleteEntry(item.entryName);
	            }
	        },

	        /**
	         * Adds a comment to the zip. The zip must be rewritten after adding the comment.
	         *
	         * @param comment
	         */
	        addZipComment: function (/**String*/ comment) {
	            // @TODO: test addZipComment
	            _zip.comment = comment;
	        },

	        /**
	         * Returns the zip comment
	         *
	         * @return String
	         */
	        getZipComment: function () {
	            return _zip.comment || "";
	        },

	        /**
	         * Adds a comment to a specified zipEntry. The zip must be rewritten after adding the comment
	         * The comment cannot exceed 65535 characters in length
	         *
	         * @param entry
	         * @param comment
	         */
	        addZipEntryComment: function (/**Object*/ entry, /**String*/ comment) {
	            var item = getEntry(entry);
	            if (item) {
	                item.comment = comment;
	            }
	        },

	        /**
	         * Returns the comment of the specified entry
	         *
	         * @param entry
	         * @return String
	         */
	        getZipEntryComment: function (/**Object*/ entry) {
	            var item = getEntry(entry);
	            if (item) {
	                return item.comment || "";
	            }
	            return "";
	        },

	        /**
	         * Updates the content of an existing entry inside the archive. The zip must be rewritten after updating the content
	         *
	         * @param entry
	         * @param content
	         */
	        updateFile: function (/**Object*/ entry, /**Buffer*/ content) {
	            var item = getEntry(entry);
	            if (item) {
	                item.setData(content);
	            }
	        },

	        /**
	         * Adds a file from the disk to the archive
	         *
	         * @param localPath File to add to zip
	         * @param zipPath Optional path inside the zip
	         * @param zipName Optional name for the file
	         */
	        addLocalFile: function (/**String*/ localPath, /**String=*/ zipPath, /**String=*/ zipName, /**String*/ comment) {
	            if (filetools.fs.existsSync(localPath)) {
	                // fix ZipPath
	                zipPath = zipPath ? fixPath(zipPath) : "";

	                // p - local file name
	                var p = localPath.split("\\").join("/").split("/").pop();

	                // add file name into zippath
	                zipPath += zipName ? zipName : p;

	                // read file attributes
	                const _attr = filetools.fs.statSync(localPath);

	                // add file into zip file
	                this.addFile(zipPath, filetools.fs.readFileSync(localPath), comment, _attr);
	            } else {
	                throw new Error(Utils.Errors.FILE_NOT_FOUND.replace("%s", localPath));
	            }
	        },

	        /**
	         * Adds a local directory and all its nested files and directories to the archive
	         *
	         * @param localPath
	         * @param zipPath optional path inside zip
	         * @param filter optional RegExp or Function if files match will
	         *               be included.
	         * @param {number | object} attr - number as unix file permissions, object as filesystem Stats object
	         */
	        addLocalFolder: function (/**String*/ localPath, /**String=*/ zipPath, /**=RegExp|Function*/ filter, /**=number|object*/ attr) {
	            // Prepare filter
	            if (filter instanceof RegExp) {
	                // if filter is RegExp wrap it
	                filter = (function (rx) {
	                    return function (filename) {
	                        return rx.test(filename);
	                    };
	                })(filter);
	            } else if ("function" !== typeof filter) {
	                // if filter is not function we will replace it
	                filter = function () {
	                    return true;
	                };
	            }

	            // fix ZipPath
	            zipPath = zipPath ? fixPath(zipPath) : "";

	            // normalize the path first
	            localPath = pth.normalize(localPath);

	            if (filetools.fs.existsSync(localPath)) {
	                const items = filetools.findFiles(localPath);
	                const self = this;

	                if (items.length) {
	                    items.forEach(function (filepath) {
	                        var p = pth.relative(localPath, filepath).split("\\").join("/"); //windows fix
	                        if (filter(p)) {
	                            var stats = filetools.fs.statSync(filepath);
	                            if (stats.isFile()) {
	                                self.addFile(zipPath + p, filetools.fs.readFileSync(filepath), "", attr ? attr : stats);
	                            } else {
	                                self.addFile(zipPath + p + "/", Buffer.alloc(0), "", attr ? attr : stats);
	                            }
	                        }
	                    });
	                }
	            } else {
	                throw new Error(Utils.Errors.FILE_NOT_FOUND.replace("%s", localPath));
	            }
	        },

	        /**
	         * Asynchronous addLocalFile
	         * @param localPath
	         * @param callback
	         * @param zipPath optional path inside zip
	         * @param filter optional RegExp or Function if files match will
	         *               be included.
	         */
	        addLocalFolderAsync: function (/*String*/ localPath, /*Function*/ callback, /*String*/ zipPath, /*RegExp|Function*/ filter) {
	            if (filter instanceof RegExp) {
	                filter = (function (rx) {
	                    return function (filename) {
	                        return rx.test(filename);
	                    };
	                })(filter);
	            } else if ("function" !== typeof filter) {
	                filter = function () {
	                    return true;
	                };
	            }

	            // fix ZipPath
	            zipPath = zipPath ? fixPath(zipPath) : "";

	            // normalize the path first
	            localPath = pth.normalize(localPath);

	            var self = this;
	            filetools.fs.open(localPath, "r", function (err) {
	                if (err && err.code === "ENOENT") {
	                    callback(undefined, Utils.Errors.FILE_NOT_FOUND.replace("%s", localPath));
	                } else if (err) {
	                    callback(undefined, err);
	                } else {
	                    var items = filetools.findFiles(localPath);
	                    var i = -1;

	                    var next = function () {
	                        i += 1;
	                        if (i < items.length) {
	                            var filepath = items[i];
	                            var p = pth.relative(localPath, filepath).split("\\").join("/"); //windows fix
	                            p = p
	                                .normalize("NFD")
	                                .replace(/[\u0300-\u036f]/g, "")
	                                .replace(/[^\x20-\x7E]/g, ""); // accent fix
	                            if (filter(p)) {
	                                filetools.fs.stat(filepath, function (er0, stats) {
	                                    if (er0) callback(undefined, er0);
	                                    if (stats.isFile()) {
	                                        filetools.fs.readFile(filepath, function (er1, data) {
	                                            if (er1) {
	                                                callback(undefined, er1);
	                                            } else {
	                                                self.addFile(zipPath + p, data, "", stats);
	                                                next();
	                                            }
	                                        });
	                                    } else {
	                                        self.addFile(zipPath + p + "/", Buffer.alloc(0), "", stats);
	                                        next();
	                                    }
	                                });
	                            } else {
	                                process.nextTick(() => {
	                                    next();
	                                });
	                            }
	                        } else {
	                            callback(true, undefined);
	                        }
	                    };

	                    next();
	                }
	            });
	        },

	        /**
	         *
	         * @param {string} localPath - path where files will be extracted
	         * @param {object} props - optional properties
	         * @param {string} props.zipPath - optional path inside zip
	         * @param {regexp, function} props.filter - RegExp or Function if files match will be included.
	         */
	        addLocalFolderPromise: function (/*String*/ localPath, /* object */ props) {
	            return new Promise((resolve, reject) => {
	                const { filter, zipPath } = Object.assign({}, props);
	                this.addLocalFolderAsync(
	                    localPath,
	                    (done, err) => {
	                        if (err) reject(err);
	                        if (done) resolve(this);
	                    },
	                    zipPath,
	                    filter
	                );
	            });
	        },

	        /**
	         * Allows you to create a entry (file or directory) in the zip file.
	         * If you want to create a directory the entryName must end in / and a null buffer should be provided.
	         * Comment and attributes are optional
	         *
	         * @param {string} entryName
	         * @param {Buffer | string} content - file content as buffer or utf8 coded string
	         * @param {string} comment - file comment
	         * @param {number | object} attr - number as unix file permissions, object as filesystem Stats object
	         */
	        addFile: function (/**String*/ entryName, /**Buffer*/ content, /**String*/ comment, /**Number*/ attr) {
	            let entry = getEntry(entryName);
	            const update = entry != null;

	            // prepare new entry
	            if (!update) {
	                entry = new ZipEntry();
	                entry.entryName = entryName;
	            }
	            entry.comment = comment || "";

	            const isStat = "object" === typeof attr && attr instanceof filetools.fs.Stats;

	            // last modification time from file stats
	            if (isStat) {
	                entry.header.time = attr.mtime;
	            }

	            // Set file attribute
	            var fileattr = entry.isDirectory ? 0x10 : 0; // (MS-DOS directory flag)

	            // extended attributes field for Unix
	            // set file type either S_IFDIR / S_IFREG
	            let unix = entry.isDirectory ? 0x4000 : 0x8000;

	            if (isStat) {
	                // File attributes from file stats
	                unix |= 0xfff & attr.mode;
	            } else if ("number" === typeof attr) {
	                // attr from given attr values
	                unix |= 0xfff & attr;
	            } else {
	                // Default values:
	                unix |= entry.isDirectory ? 0o755 : 0o644; // permissions (drwxr-xr-x) or (-r-wr--r--)
	            }

	            fileattr = (fileattr | (unix << 16)) >>> 0; // add attributes

	            entry