(function()
{
	Sidebar.prototype.addFluidPowerPalette = function()
	{
		var w = 2;
		var h = 2;
		var s = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;aspect=fixed;html=1;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;fillColor=strokeColor;align=center;outlineConnect=0;shape=mxgraph.fluid_power.';
		var gn = 'mxgraph.fluid_power';
		var dt = '';
		this.setCurrentSearchEntryLibrary('fluid_power');
		
		this.addPaletteFunctions('fluid_power', 'Fluid Power (ISO 1219)', false,
		[
			this.createVertexTemplateEntry(s + 'x10010;points=[[0,0.68,0],[0.78,0,0],[1,0.51,0],[1,0.84,0]]', w * 20.95, h * 14.24, '', 'X10010 Control mechanism with detachable grip and detent', null, null, this.getTagsForStencil(gn, 'x10010 control mechanism with detachable grip and detent', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10020;points=[[0,0.5,0],[1,0.39,0],[1,0.61,0]]', w * 18.59, h * 21.42, '', 'X10020 Plunger with adjustable stroke limiter', null, null, this.getTagsForStencil(gn, 'x10020 plunger with adjustable stroke limiter', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10030;points=[[0,0.35,0],[0,1,0],[0.74,0,0],[1,0.5,0],[1,0.84,0]]', w * 17.62, h * 14.22, '', 'X10030 Push/pull control mechanism with detent', null, null, this.getTagsForStencil(gn, 'x10030 push pull control mechanism with detent', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10040;points=[[1,0.6,0]]', w * 9.35, h * 13.18, '', 'X10040 Control mechanism with locking manual override', null, null, this.getTagsForStencil(gn, 'x10040 control mechanism with locking manual override', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10050;points=[[1,0.64,0],[1,0.88,0]]', w * 17.67, h * 19.61, '', 'X10050 Turning control mechanism with five detent positions', null, null, this.getTagsForStencil(gn, 'x10050 turning control mechanism with five detent positions', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10060;points=[[1,0.72,0],[1,1,0]]', w * 31.3, h * 17.69, '', 'X10060 Roller lever for actuation in one direction of travel', null, null, this.getTagsForStencil(gn, 'x10060 roller lever for actuation in one direction of travel', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10070;points=[[1,0.38,0],[1,0.5,0],[1,0.62,0]]', w * 32.6, h * 18.64, '', 'X10070 Control mechanism using an electric stepping motor', null, null, this.getTagsForStencil(gn, 'x10070 control mechanism using an electric stepping motor', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10080;points=[[0,0,0],[0,0.5,0],[0,1,0],[1,0,0],[1,0.5,0],[1,1,0]]', w * 14.04, h * 9.35, '', 'X10080 Pneumatic spring, internal pressure supply using the valve-inlet port', null, null, this.getTagsForStencil(gn, 'x10080 pneumatic spring internal pressure supply using the valve inlet port', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10090;points=[[0,0,0],[0,0.5,0],[0,1,0],[1,0,0],[1,0.5,0],[1,1,0]]', w * 14.04, h * 9.35, '', 'X10090 Pneumatic spring, internal pressure supply using the pilot-supply port', null, null, this.getTagsForStencil(gn, 'X10090 pneumatic spring internal pressure supply using the pilot supply port', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10100;points=[[0,0,0],[0,0.5,0],[0,1,0],[1,0,0],[1,0.5,0],[1,1,0]]', w * 14.04, h * 9.35, '', 'X10100 Pneumatic spring, external pressure supply', null, null, this.getTagsForStencil(gn, 'X10090 pneumatic spring external pressure supply', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10110;points=[[0,0,0],[0,0.5,0],[0,1,0],[1,0,0],[1,0.5,0],[1,1,0],[0.5,0,0],[0.5,1,0]]', w * 13.94, h * 9.33, '', 'X10110 Solenoid coil with one winding, direction of actuation towards the valving element', null, null, this.getTagsForStencil(gn, 'x10110 solenoid coil with one winding direction of actuation towards the valving element', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10120;points=[[0,0,0],[0,0.5,0],[0,1,0],[1,0,0],[1,0.5,0],[1,1,0],[0.5,0,0],[0.5,1,0]]', w * 13.94, h * 9.33, '', 'X10120 Solenoid coil with one winding, direction of actuation away from the valving element', null, null, this.getTagsForStencil(gn, 'x10120 solenoid coil with one winding direction of actuation away from the valving element', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10130;points=[[0,0,0],[0,0.5,0],[0,1,0],[1,0,0],[1,0.5,0],[1,1,0],[0.5,0,0],[0.5,1,0]]', w * 13.94, h * 9.33, '', 'X10130 Electrical control mechanism with two coils, one acting towards the valving element and the other acting away from the valving element', null, null, this.getTagsForStencil(gn, 'x10130 electrical control mechanism with two coils one acting towards the valving element and the other acting away from the valving element', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10140;points=[[0,0.39,0],[0,0.605,0],[0,0.82,0]]', w * 17.84, h * 27.62, '', 'X10140 Solenoid coil with one winding, direction of actuation towards the valving element, continuously controlled', null, null, this.getTagsForStencil(gn, 'x10140 solenoid coil with one winding direction of actuation towards the valving element continuously controlled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10150;points=[[0,0.39,0],[0,0.605,0],[0,0.82,0]]', w * 17.84, h * 27.62, '', 'X10150 Solenoid coil with one winding, direction of actuation away from the valving element, continuously controlled', null, null, this.getTagsForStencil(gn, 'x10150 solenoid coil with one winding direction of actuation away from the valving element continuously controlled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10160;points=[[0,0.39,0],[0,0.605,0],[0,0.82,0]]', w * 17.84, h * 27.62, '', 'X10160 Electrical control mechanism with two coils, acting in both directions towards and away from the valving element, continuously controlled', null, null, this.getTagsForStencil(gn, 'x10160 electrical control mechanism with two coils acting in both directions towards and away from the valving element continuously controlled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10170;points=[[0,0,0],[0,0.5,0],[0,1,0],[1,0,0],[1,0.5,0],[1,1,0],[0.5,0,0],[0.5,1,0]]', w * 27.97, h * 9.31, '', 'X10170 Electrically operated pneumatic control mechanism', null, null, this.getTagsForStencil(gn, 'X10170 electrically operated pneumatic control mechanism', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10180;points=[[0,0,0],[0,0.25,0],[0,0.5,0],[1,0,0],[1,0.25,0],[1,0.5,0],[0.5,0,0],[0.5,1,0]]', w * 27.97, h * 18.61, '', 'X10180 Electrically operated hydraulic pilot stage with external pilot supply', null, null, this.getTagsForStencil(gn, 'x10180 electrically operated hydraulic pilot stage with external pilot supply', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10190;points=[[0.1,0.8,0],[0.55,0,0],[1,1,0]]', w * 15.54, h * 18.66, '', 'X10190 Mechanical feedback', null, null, this.getTagsForStencil(gn, 'x10190 mechanical feedback', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10200;points=[[0,0.31,0],[0,0.48,0],[0,0.65,0],[1,0.31,0],[1,0.48,0],[1,0.65,0],[0.43,1,0],[0.715,1,0]]', w * 32.41, h * 26.93, '', 'X10200 Hydraulic control mechanism with two successive pilot stages with external pilot supply and continuously controlled solenoid with two windings, working in both directions, in one assembly', null, null, this.getTagsForStencil(gn, 'x10200 hydraulic control mechanism with two successive pilot stages with external pilot supply and continuously controlled solenoid with two windings working in both directions in one assembly', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10210;points=[[0.67,0,0],[0.67,1,0],[0,0.62,0],[0.37,0.25,0],[0.37,0.75,0]]', w * 62.77, h * 37.61, '', 'X10210 2/2 (two-port, two-position) directional control valve, two ports, two shift positions for two directions of flow, a push control mechanism, spring return, normally closed', null, null, this.getTagsForStencil(gn, 'x10210 two port position directional control valve ports positions for two directions of flow push control mechanism spring return normally closed', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10220;points=[[0.665,0,0],[0.665,1,0],[0,0.62,0],[0.37,0.25,0],[0.37,0.75,0]]', w * 62.77, h * 37.3, '', 'X10220 2/2 directional control vavle, two ports, two shift positions, normally open, solenoid-actuated, spring return', null, null, this.getTagsForStencil(gn, 'x10220 directional control vavle two ports two shift positions normally open solenoid actuated spring return', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10230;points=[[0.59,0,0],[0.74,0,0],[0.59,1,0],[0.74,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[0.295,0.25,0],[0.295,0.75,0],[0.445,0.25,0],[0.445,0.75,0]]', w * 62.77, h * 37.24, '', 'X10230 4/2 directional control valve, solenoid-actuated, spring return', null, null, this.getTagsForStencil(gn, 'x10230 directional control valve solenoid-actuated spring return', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10240;points=[[0.725,0,0],[0.725,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[0.28,0.5,0],[0.28,0.75,0],[0.485,0.25,0],[0.485,0.75,0],[0.09,0.5,0],[0.09,0.75,0]]', w * 76.66, h * 37.33, '', 'X10240 Pneumatic soft-start valve, solenoidoperated, with internal pilot supply', null, null, this.getTagsForStencil(gn, 'X10240 pneumatic soft start valve solenoidoperated with internal pilot supply', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10250;points=[[0.665,0,0],[0.665,1,0]]', w * 83.63, h * 71.89, '', 'X10250 Pneumatic slow-start valve that is fitted at the inlet to a system, which allows fluid to enter the system at a reduced flow rate, until a pre-set pressure level is achieved, causing the valve to open to a full-flow condition', null, null, this.getTagsForStencil(gn, 'X10250 pneumatic slow start valve that is fitted at the inlet to system which allows fluid to enter the system at reduced flow rate until pre set pressure level is achieved causing the valve to open to full flow condition', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10260;points=[[0.645,0,0],[0.645,1,0],[0.76,1,0],[0.41,0.25,0],[0.41,0.75,0],[0.53,0.75,0],[1,0.5,0],[1,0.625,0],[1,0.75,0]]', w * 78.82, h * 37.24, '', 'X10260 3/2 lockout valve with a padlock', null, null, this.getTagsForStencil(gn, 'x10260 lockout valve with padlock', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10270;points=[[0.68,0,0],[0.68,1,0],[0.795,1,0],[0.445,0.25,0],[0.445,0.75,0],[0.56,0.75,0]]', w * 80.08, h * 37.24, '', 'X10270 3/2 directional control valve controlled by a roller lever in one direction of travel and spring return', null, null, this.getTagsForStencil(gn, 'x10270 directional control valve controlled by roller lever in one direction of travel and spring return', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10280;points=[[0.59,0,0],[0.59,1,0],[0.74,1,0],[0.44,0.75,0],[0.295,0.25,0],[0.295,0.75,0]]', w * 62.8, h * 37.24, '', 'X10280 3/2 directional control valve, with three ports and two positions, controlled by a solenoid and spring return', null, null, this.getTagsForStencil(gn, 'x10280 directional control valve with three ports and two positions controlled by solenoid and spring return', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10290;points=[[0.59,0,0],[0.59,1,0],[0.74,1,0],[0.44,0.75,0],[0.295,0.25,0],[0.295,0.75,0]]', w * 62.8, h * 37.24, '', 'X10290 3/2 directional control valve with single solenoid, directly controlled, spring return, and manual override with detent', null, null, this.getTagsForStencil(gn, 'X10290', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10300;points=[[0.745,0,0],[0.745,1,0],[0.835,1,0],[0,0.5,0],[0.558,0.25,0],[0.558,0.75,0],[0.65,0.75,0]]', w * 100.14, h * 37.24, '', 'X10300 Pulse counter with pneumatic output signal', null, null, this.getTagsForStencil(gn, 'x10300 pulse counter with pneumatic output signal', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10310;points=[[0.55,0,0],[0.55,1,0],[0,0.62,0],[1,0.62,0],[0.35,0.25,0],[0.35,0.75,0],[0.45,0.75,0],[0.65,1,0]]', w * 93.24, h * 37.24, '', 'X10310 3/2 directional control valve, differential pilot', null, null, this.getTagsForStencil(gn, 'x10310 3/2 directional control valve differential pilot', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10320;points=[[0.59,0,0],[0.59,1,0],[0.74,0,0],[0.74,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[0.3,0.25,0],[0.3,0.75,0],[0.44,0.25,0],[0.44,0.75,0]]', w * 62.8, h * 37.24, '', 'X10320 4/2 directional control valve with single solenoid, directly controlled, spring return, and manual override with detent', null, null, this.getTagsForStencil(gn, 'x10320 directional control valve with single solenoid directly controlled spring return and manual override with detent', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10330;points=[[0.57,0,0],[0.57,1,0],[0.71,0,0],[0.71,1,0],[0.285,0.25,0],[0.285,0.75,0],[0.43,0.25,0],[0.43,0.75,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[1,0.25,0],[1,0.5,0],[1,0.75,0]]', w * 65.09, h * 37.24, '', 'X10330 4/2 directional control valve, directly controlled by two solenoids, with detent (impulse valve)', null, null, this.getTagsForStencil(gn, 'x10330 directional control valve directly controlled by two solenoids with detent impulse valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10340;points=[[0.685,0,0],[0.685,1,0],[0.455,0.25,0],[0.455,0.75,0],[0.57,0.75,0],[0.8,1,0],[0,0.625,0]]', w * 81.61, h * 37.24, '', 'X10340 3/2 directional control valve with three ports, two distinct positions, controlled by pneumatic pilot control and torsion bar, spring return', null, null, this.getTagsForStencil(gn, 'x10340 directional control valve with three ports two distinct positions controlled by pneumatic pilot control and torsion bar spring return', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10350;points=[[0.665,0,0],[0.665,1,0],[0.785,0,0],[0.785,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[0.42,0.25,0],[0.42,0.75,0],[0.545,0.25,0],[0.545,0.75,0]]', w * 76.69, h * 37.24, '', 'X10350 4/2 directional control valve, two distinct positions, controlled by solenoid and hydraulic pilot, spring return', null, null, this.getTagsForStencil(gn, 'x10350 directional control valve two distinct positions controlled by solenoid and hydraulic pilot spring return', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10360;points=[[0.46,0,0],[0.46,1,0],[0.54,0,0],[0.54,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[0.29,0.25,0],[0.29,0.75,0],[0.375,0.25,0],[0.375,0.75,0],[1,0.5,0],[1,0.625,0],[1,0.75,0],[0.625,0.25,0],[0.625,0.75,0],[0.71,0.25,0],[0.71,0.75,0],[0.125,1,0],[0.79,1,0]]', w * 111.3, h * 37.51, '', 'X10360 4/3 directional control valve, with electrical operation of the pilot stage and hydraulic operation of the main stage, main stage and pilot stage with spring-centering, external pilot supply and pilot drain', null, null, this.getTagsForStencil(gn, 'x10360 directional control valve with electrical operation of the pilot stage and hydraulic operation of the main stage main stage and pilot stage with spring-centering external pilot supply and pilot drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10370;points=[[0.445,0,0],[0.445,1,0],[0.555,0,0],[0.555,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[1,0.5,0],[1,0.625,0],[1,0.75,0],[0.222,0.25,0],[0.222,0.75,0],[0.335,0.25,0],[0.335,0.75,0],[0.665,0.25,0],[0.665,0.75,0],[0.777,0.25,0],[0.777,0.75,0]]', w * 83.58, h * 37.24, '', 'X10370 4/3 directional control valve, directly controlled by two solenoids with spring-centered central position', null, null, this.getTagsForStencil(gn, 'x10370 directional control valve directly controlled by two solenoids with spring centered central position', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10380;points=[[0.66,0,0],[0.66,1,0],[0.785,0,0],[0.785,1,0],[0,1,0],[0.415,0.25,0],[0.415,0.75,0],[0.54,0.25,0],[0.54,0.75,0]]', w * 75.37, h * 37.53, '', 'X10380 4/2 directional control valve, hydraulically controlled, spring return', null, null, this.getTagsForStencil(gn, 'x10380 directional control valve hydraulically controlled spring return', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10390;points=[[0.457,0,0],[0.457,1,0],[0.545,0,0],[0.545,1,0],[0,1,0],[1,1,0],[0.287,0.25,0],[0.287,0.75,0],[0.373,0.25,0],[0.373,0.75,0],[0.627,0.25,0],[0.627,0.75,0],[0.713,0.25,0],[0.713,0.75,0]]', w * 109.23, h * 37.51, '', 'X10390 4/3 directional control valve, hydraulically controlled, spring-centered', null, null, this.getTagsForStencil(gn, 'x10390 directional control valve hydraulically controlled spring centered', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10400;points=[[0.68,0,0],[0.68,1,0],[0.938,0,0],[0.938,1,0],[0.81,1,0],[0.3,0.25,0],[0.425,0.75,0],[0.553,0.25,0],[0.553,0.75,0],[0.3,0.75,0]]', w * 72.6, h * 37.51, '', 'X10400 5/2 directional control valve, treadle-controlled', null, null, this.getTagsForStencil(gn, 'x10400 directional control valve treadle controlled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10410;points=[[0.62,0,0],[0.62,1,0],[0.808,0,0],[0.808,1,0],[0.713,1,0],[0.335,0.25,0],[0.333,0.75,0],[0.427,0.75,0],[0.522,0.25,0],[0.522,0.75,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[1,0.5,0],[1,0.625,0],[1,0.75,0]]', w * 97.5, h * 37.51, '', 'X10410 5/2 pneumatic directional control valve, pilot-operated, piezo-electric-controlled, return by pneumatic spring', null, null, this.getTagsForStencil(gn, 'x10410 pneumatic directional control valve pilot operated piezo electric controlled return by pneumatic spring', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10420;points=[[0.425,0,0],[0.425,1,0],[0.578,0,0],[0.578,1,0],[0.5,1,0],[0.195,0.25,0],[0.195,0.75,0],[0.27,0.75,0],[0.348,0.25,0],[0.348,0.75,0],[0.655,0.25,0],[0.655,0.75,0],[0.808,0.25,0],[0.732,0.75,0],[0.808,0.75,0]]', w * 121.13, h * 37.53, '', 'X10420 5/3 directional control valve, lever-controlled to each position, with detent', null, null, this.getTagsForStencil(gn, 'x10420 directional control valve lever controlled to each position with detent', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10430;points=[[0.634,0,0],[0.634,1,0],[0.83,0,0],[0.732,1,0],[0.83,1,0],[0.343,0.25,0],[0.341,0.75,0],[0.537,0.25,0],[0.537,0.75,0],[0.44,0.75,0],[0.145,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0]]', w * 95.18, h * 37.47, '', 'X10430 5/2 pneumatic directional control valve, single solenoid, pilot-operated with an external pilot supply, spring return, manual override', null, null, this.getTagsForStencil(gn, 'x10430 pneumatic directional control valve single solenoid pilot operated with an external pilot supply spring return manual override', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10440;points=[[0.62,0,0],[0.62,1,0],[0.81,0,0],[0.81,1,0],[0.715,1,0],[0.337,0.25,0],[0.335,0.75,0],[0.525,0.25,0],[0.525,0.75,0],[0.43,0.75,0],[0.145,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[1,0.5,0],[1,0.625,0],[1,0.75,0]]', w * 97.47, h * 37.47, '', 'X10440 5/2 pneumatic directional control valve with five ports and two distinct positions, control by solenoid and pneumatic pilot control, with external pilot supply, return by pneumatic spring, auxiliary manual control. Internal pressure supply using the valve supply port', null, null, this.getTagsForStencil(gn, 'x10440 pneumatic directional control valve with five ports and two distinct positions control by solenoid and pneumatic pilot control with external pilot supply return by pneumatic spring auxiliary manual control internal pressure supply using the valve supply port', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10441;points=[[0.62,0,0],[0.62,1,0],[0.81,0,0],[0.81,1,0],[0.715,1,0],[0.337,0.25,0],[0.335,0.75,0],[0.525,0.25,0],[0.525,0.75,0],[0.43,0.75,0],[0.145,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[1,0.5,0],[1,0.625,0],[1,0.75,0]]', w * 97.47, h * 37.47, '', 'X10441 5/2 pneumatic directional control valve with five ports and two distinct positions, control by solenoid and pneumatic pilot control, with external pilot supply, return by pneumatic spring, auxiliary manual control. Internal pressure supply using the pilot supply port', null, null, this.getTagsForStencil(gn, 'x10441 pneumatic directional control valve with five ports and two distinct positions control by solenoid and pneumatic pilot control with external pilot supply return by pneumatic spring auxiliary manual control internal pressure supply using the pilot supply port', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10442;points=[[0.62,0,0],[0.62,1,0],[0.81,0,0],[0.81,1,0],[0.715,1,0],[0.337,0.25,0],[0.335,0.75,0],[0.525,0.25,0],[0.525,0.75,0],[0.43,0.75,0],[0.145,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[1,0.5,0],[1,0.625,0],[1,0.75,0],[1,1,0]]', w * 97.47, h * 37.47, '', 'X10442 5/2 pneumatic directional control valve with five ports and two distinct positions, control by solenoid and pneumatic pilot control, with external pilot supply, return by pneumatic spring, auxiliary manual control. External pressure supply', null, null, this.getTagsForStencil(gn, 'x10442 pneumatic directional control valve with five ports and two distinct positions control by solenoid and pneumatic pilot control with external pilot supply return by pneumatic spring auxiliary manual control. External pressure supply', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10450;points=[[0.433,0,0],[0.433,1,0],[0.5,1,0],[0.567,0,0],[0.567,1,0],[0.233,0.25,0],[0.233,0.75,0],[0.298,0.75,0],[0.365,0.25,0],[0.365,0.75,0],[0.632,0.25,0],[0.632,0.75,0],[0.764,0.25,0],[0.7,0.75,0],[0.767,0.75,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[1,0.5,0],[1,0.625,0],[1,0.75,0]]', w * 139.22, h * 37.52, '', 'X10450 5/3 pneumatic directional control valve, closed centre position, controlled by solenoid pilots with internal pilot supply and manual overrides on both sides. Spring return to the centre position', null, null, this.getTagsForStencil(gn, 'x10450 pneumatic directional control valve closed centre position controlled by solenoid pilots with internal pilot supply and manual overrides on both sides spring return to the centre position', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10460;points=[[0.6,0,0],[0.6,1,0],[0.8,0,0],[0.8,1,0],[0.7,1,0],[0.3,0.25,0],[0.3,0.75,0],[0.4,0.75,0],[0.5,0.25,0],[0.5,0.75,0],[0,0.625,0],[1,0.5,0],[1,0.625,0],[1,0.75,0]]', w * 93, h * 37.54, '', 'X10460 Directly operated 5/2 pneumatic directional control valve, mechanical spring and air spring returned', null, null, this.getTagsForStencil(gn, 'x10460 directly operated pneumatic directional control valve mechanical spring and air spring returned', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10470;points=[[0.43,0,0],[0.572,0,0],[0.43,1,0],[0.5,1,0],[0.572,1,0],[0,0.625,0],[1,0.625,0],[0.217,0.25,0],[0.215,0.75,0],[0.287,0.75,0],[0.358,0.25,0],[0.358,0.75,0],[0.643,0.25,0],[0.643,0.75,0],[0.785,0.25,0],[0.715,0.75,0],[0.786,0.75,0]]', w * 130.19, h * 37.34, '', 'X10470 Directly operated 5/3 pneumatic directional control valve, spring centred, with outlet ports open to exhaust in the centre position', null, null, this.getTagsForStencil(gn, 'x10470 directly operated pneumatic directional control valve spring centred with outlet ports open to exhaust in the centre position', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10480;points=[[0.57,0,0],[0.57,1,0],[0.283,0.255,0],[0.425,0.75,0],[0.283,0.75,0],[0.712,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0]]', w * 65, h * 37.77, '', 'X10480 3/2 solenoid-actuated poppet valve, with limit switch', null, null, this.getTagsForStencil(gn, 'x10480 solenoid actuated poppet valve with limit switch', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10490;points=[[0.59,0,0],[0.59,1,0],[0.297,0.255,0],[0.442,0.75,0],[0.297,0.75,0],[0.74,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0]]', w * 62.79, h * 37.77, '', 'X10490 3/2 solenoid-actuated poppet valve', null, null, this.getTagsForStencil(gn, 'x10490 solenoid actuated poppet valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10500;points=[[0.47,0,0],[0.47,1,0]]', w * 39.53, h * 37.77, '', 'X10500 Directly controlled pressure-relief valve, in which the opening pressure is adjusted by means of a spring', null, null, this.getTagsForStencil(gn, 'x10500 directly controlled pressure relief valve in which the opening pressure is adjusted by means of spring', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10510;points=[[0.445,0,0],[0.445,1,0],[0.887,1,0]]', w * 41.78, h * 37.77, '', 'X10510 Sequence valve with manually adjustable set point', null, null, this.getTagsForStencil(gn, 'x10510 Sequence valve with manually adjustable set point', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10520;points=[[0.57,0,0],[0.57,1,0],[0.856,1,0]]', w * 65.04, h * 65.51, '', 'X10520 Sequence valve, with bypass valve', null, null, this.getTagsForStencil(gn, 'x10520 sequence valve with bypass valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10530;points=[[0.61,0,0],[0.61,1,0],[0,0.62,0]]', w * 53.94, h * 37.77, '', 'X10530 Sequence valve, externally controlled', null, null, this.getTagsForStencil(gn, 'x10530 sequence valve externally controlled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10540;points=[[0.35,0,0],[0.35,1,0]]', w * 39.59, h * 37.77, '', 'X10540 Pressure regulator, with internal reversible flow', null, null, this.getTagsForStencil(gn, 'x10540 pressure regulator with internal reversible flow', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10550;points=[[0.44,0,0],[0.44,1,0],[0.885,1,0]]', w * 41.78, h * 37.77, '', 'X10550 Directly controlled two-port pressure-reducing valve with external drain', null, null, this.getTagsForStencil(gn, 'x10550 directly controlled two port pressure reducing valve with external drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10560;points=[[0.348,0,0],[0.348,1,0],[0.778,1,0]]', w * 53.64, h * 37.77, '', 'X10560 Pitot-operated two-port pressure-reducing valve with external drain', null, null, this.getTagsForStencil(gn, 'x10560 pitot operated two port pressure reducing valve with external drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10570;points=[[0.335,0,0],[0.335,1,0],[1,1,0]]', w * 41.76, h * 37.72, '', 'X10570 Pressure regulator, remote pilot adjusted, relieving, forward flow only', null, null, this.getTagsForStencil(gn, 'x10570 pressure regulator remote pilot adjusted relieving forward flow only', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10580;points=[[0,0.355,0],[1,0.355,0],[0.5,1,0]]', w * 130.47, h * 71.93, '', 'X10580  Pressure-relief and anti-cavitation valves for protecting two supply lines', null, null, this.getTagsForStencil(gn, 'x10580 pressure relief and anti cavitation valves for protecting two supply lines', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10590;points=[[0.117,0,0],[0.117,1,0],[0.94,0.545,0]]', w * 79.01, h * 102.73, '', 'X10590 Accumulator-charging valve with a fixed switching-pressure differential', null, null, this.getTagsForStencil(gn, 'x10590 accumulator charging valve with fixed switching pressure differential', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10600;points=[[0.218,0,0],[0.218,1,0],[0.927,1,0]]', w * 127.79, h * 116.31, '', 'X10600 Hydraulic pilot-controlled pressure-relief valve with electrically operated activation to a set pressure', null, null, this.getTagsForStencil(gn, 'x10600 hydraulic pilot controlled pressure relief valve with electrically operated activation to set pressure', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10610;points=[[0.35,0,0],[0.35,1,0],[0.585,1,0]]', w * 39.53, h * 37.35, '', 'X10610 Three-port pressure-reducing valve', null, null, this.getTagsForStencil(gn, 'x10610 three port pressure reducing valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10620;points=[[0.5,0,0],[0,0.66,0],[1,0.66,0]]', w * 56.05, h * 27.92, '', 'X10620 Dual pressure valve (AND function), in which an output signal is only obtained when both inlets are under pressure. The weaker signal is fed to the output.', null, null, this.getTagsForStencil(gn, 'x10620 dual pressure valve and function in which an output signal is only obtained when both inlets are under pressure the weaker signal is fed to the output', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10630;points=[[0.36,0,0],[0.36,1,0]]', w * 16.99, h * 37.57, '', 'X10630 Flow-control valve, adjustable', null, null, this.getTagsForStencil(gn, 'x10630 flow control valve adjustable', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10640;points=[[0.25,0,0],[0.25,1,0]]', w * 37.03, h * 55.98, '', 'X10640 Flow-control valve, adjustable, with free flow in one direction', null, null, this.getTagsForStencil(gn, 'x10640 flow control valve adjustable with free flow in one direction', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10650;points=[[0.695,0,0],[0.695,1,0]]', w * 68.5, h * 37.46, '', 'X10650 Flow-control valve, operated by roller plunger, spring-returned', null, null, this.getTagsForStencil(gn, 'x10650 flow control valve operated by roller plunger spring returned', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10660;points=[[0.33,0,0],[0.33,1,0]]', w * 41.87, h * 74.67, '', 'X10660 Two-port flow-control valve, preset, for one direction of flow, largely independent of viscosity and pressure differential, adjustable, with bypass check valve', null, null, this.getTagsForStencil(gn, 'x10660 two port flow control valve preset for one direction of flow largely independent of viscosity and pressure differential adjustable with bypass check valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10670;points=[[0.372,0,0],[0.372,1,0],[0.812,0,0]]', w * 37.05, h * 60.4, '', 'X10670 Three-port flow-control valve, adjustable, that divides the inlet flow into a fixed flow and a residual flow', null, null, this.getTagsForStencil(gn, 'x10670 three port flow control valve adjustable that divides the inlet flow into a fixed flow and a residual flow', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10680;points=[[0.3,0,0],[0.7,0,0],[0.5,1,0]]', w * 46.39, h * 56.08, '', 'X10680 Flow divider that divides the inlet flow into two outlet flows', null, null, this.getTagsForStencil(gn, 'x10680 flow divider that divides the inlet into two outlet flows', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10690;points=[[0.5,0,0],[0.3,1,0],[0.7,1,0]]', w * 46.39, h * 56.08, '', 'X10690 Flow-combining valve that maintains the two inlet flows constant in relation to each other', null, null, this.getTagsForStencil(gn, 'x10690 flow combining valve that maintains the two inlet flows constant in relation to each other', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10700;points=[[0.5,0,0],[0.5,1,0]]', w * 9.48, h * 28.02, '', 'X10700 Non-return valve, free flow possible in only one direction', null, null, this.getTagsForStencil(gn, 'x10700 non return valve free flow possible in only one direction', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10710;points=[[0.5,0,0],[0.5,1,0]]', w * 9.48, h * 37.4, '', 'X10710 Non-return valve with spring, free flow possible in only one direction, normally closed', null, null, this.getTagsForStencil(gn, 'x10710 non return valve with spring, free flow possible in only one direction, normally closed', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10720;points=[[0.395,0,0],[0.395,1,0],[0.795,1,0]]', w * 23.2, h * 46.79, '', 'X10720 Pilot-operated non-return valve with spring, in which pilot pressure allows free flow in both directions', null, null, this.getTagsForStencil(gn, 'x10720 pilot operated non return valve with spring, in which pilot pressure allows free flow in both directions', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10730;points=[[0.248,0,0],[0.248,1,0],[0.75,0,0],[0.75,1,0]]', w * 36.92, h * 46.73, '', 'X10730 Double non-return valve, pilot-operated', null, null, this.getTagsForStencil(gn, 'x10730 double non return valve pilot operated', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10740;points=[[0,0.665,0],[1,0.665,0],[0.498,0,0]]', w * 55.86, h * 28, '', 'X10740 Shuttle valve (OR function), in which the inlet that experiences the higher pressure is automatically connected to the outlet', null, null, this.getTagsForStencil(gn, 'x10740 shuttle valve or function in which the inlet that experiences the higher pressure is automatically connected to the outlet', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10750;points=[[0.355,0,0],[0,0.75,0]]', w * 78.47, h * 37.33, '', 'X10750 Quick-exhaust valve', null, null, this.getTagsForStencil(gn, 'x10750 quick exhaust valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10760;points=[[0.445,0.01,0],[0.555,0.01,0],[0.445,1,0],[0.555,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0],[1,0.5,0],[1,0.625,0],[1,0.75,0]]', w * 83.62, h * 37.51, '', 'X10760 Proportional directional control valve, directly controlled', null, null, this.getTagsForStencil(gn, 'x10760 proportional directional control valve, directly controlled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10770;points=[[0.258,0,0],[0.258,1,0],[0.405,0,0],[0.405,1,0],[1,0.5,0],[1,0.625,0],[1,0.75,0]]', w * 62.72, h * 37.22, '', 'X10770 Proportional directional control valve, directly controlled', null, null, this.getTagsForStencil(gn, 'x10770 proportional directional control valve, directly controlled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10780;points=[[0.407,0.2,0],[0.48,0.2,0],[0.407,1,0],[0.48,1,0],[0,0.6,0],[0,0.7,0],[0,0.8,0]]', w * 125.57, h * 46.52, '', 'X10780 Proportional directional control valve, pilot operated, with closed-loop position control of the main and pilot stages, with integrated electronics', null, null, this.getTagsForStencil(gn, 'x10780 proportional directional control valve pilot operated with closed loop position control of the main and pilot stages with integrated electronics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10790;points=[[0.332,0.055,0],[0.416,0.055,0],[0.332,1,0],[0.416,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0]]', w * 125.57, h * 46.52, '', 'X10790 Servo-valve, pilot-operated, with closed-loop position control of the main and pilot stages, with integrated electronics', null, null, this.getTagsForStencil(gn, 'x10790 servo valve pilot operated with closed loop position control of the main and pilot stages with integrated electronics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10800;points=[[0.332,0.055,0],[0.416,0.055,0],[0.332,1,0],[0.416,1,0],[0,0.5,0],[0,0.625,0],[0,0.75,0]]', w * 111.51, h * 37.21, '', 'X10800 Servo-valve, pilot-operated, pilot stage with electrical control mechanism with two coils, continuously controlled in both directions, with mechanical feedback of the valve-spool position to the pilot stage, with integrated electronics', null, null, this.getTagsForStencil(gn, 'x10800 servo valve pilot operated pilot stage with electrical control mechanism with two coils continuously controlled in both directions with mechanical feedback of the valve spool position to the pilot stage with integrated electronics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10810;points=[[0.272,1,0],[0.364,1,0]]', w * 102.1, h * 78.82, '', 'X10810 Electro-hydraulic linear drive consisting of cylinder with servo-valve and stepping motor, mechanical feedback of the cylinder position', null, null, this.getTagsForStencil(gn, 'x10810 electro hydraulic linear drive consisting of cylinder with servo valve and stepping motor mechanical feedback of the cylinder position', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10820;points=[[0.143,0,0],[0.225,0,0],[0.143,1,0],[0.225,1,0]]', w * 113.78, h * 37.51, '', 'X10820 Servo-valve with preferred position in case of a power failure, electrical feedback and integral electronics', null, null, this.getTagsForStencil(gn, 'x10820 servo valve with preferred position in case of a power failure electrical feedback and integral electronics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10830;points=[[0.35,0,0],[0.35,1,0],[1,0.5,0],[1,0.625,0],[1,0.75,0]]', w * 53.33, h * 37.41, '', 'X10830 Proportional pressure-relief valve, directly controlled, in which the solenoid controls the valve poppet by means of a spring', null, null, this.getTagsForStencil(gn, 'x10830 proportional pressure relief valve directly controlled in which the solenoid controls the valve poppet by means of a spring', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10840;points=[[0.335,0,0],[0.335,1,0]]', w * 55.74, h * 37.41, '', 'X10840 Proportional pressure-relief valve, directly controlled by a solenoid acting on a valve poppet, with integral electronics', null, null, this.getTagsForStencil(gn, 'x10840 proportional pressure relief valve directly controlled by a solenoid acting on a valve poppet with integral electronics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10850;points=[[0.277,0,0],[0.277,1,0]]', w * 67.36, h * 37.41, '', 'X10850 Proportional pressure-relief valve, directly controlled, with closed-loop position control of the solenoid and with integral electronics', null, null, this.getTagsForStencil(gn, 'x10850 proportional pressure relief valve directly controlled with closed loop position control of the solenoid and with integral electronics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10860;points=[[0.23,0,0],[0.23,1,0],[0.515,1,0]]', w * 81.17, h * 37.5, '', 'X10860 Proportional pressure-relief valve, pilot-operated with electrical sensing of the solenoid position, with external pilot drain', null, null, this.getTagsForStencil(gn, 'x10860 proportional pressure relief valve pilot operated with electrical sensing of the solenoid position with external pilot drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10870;points=[[0.23,0,0],[0.17,1,0],[0.285,1,0]]', w * 81.19, h * 37.46, '', 'X10870 Three-port proportional pressure-reducing valve with closed-loop position control of the solenoid and integrated electronics', null, null, this.getTagsForStencil(gn, 'x10870 three port proportional pressure reducing valve with closed-loop position control of the solenoid and integrated electronics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10880;points=[[0.267,0.15,0],[0.267,1,0],[0.6,1,0]]', w * 69.57, h * 44.21, '', 'X10880 Proportional pressure-relief valve, pilotoperated, with integral electronics and additional pilot stage for manual pressure adjustment or maximum pressure-relief function, with external drain', null, null, this.getTagsForStencil(gn, 'x10880 proportional pressure relief valve pilotoperated with integral electronics and additional pilot stage for manual pressure adjustment or maximum pressure relief function with external drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10890;points=[[0.667,0,0],[0.667,1,0]]', w * 62.7, h * 37.51, '', 'X10890 Proportional flow-control valve, directly controlled', null, null, this.getTagsForStencil(gn, 'x10890 proportional flow control valve directly controlled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10900;points=[[0.665,0,0],[0.665,1,0],[0.785,0,0],[0.785,1,0]]', w * 76.63, h * 37.58, '', 'X10900 Proportional flow-control valve, directly controlled, with closed-loop position control of the solenoid and integrated electronics', null, null, this.getTagsForStencil(gn, 'x10900 proportional flow control valve directly controlled with closed-loop position control of the solenoid and integrated electronics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10910;points=[[0.768,0.197,0],[0.768,1,0]]', w * 90.65, h * 46.72, '', 'X10910 Proportional flow-control valve, pilot-operated, with position control of the main and pilot stage, integrated electronics', null, null, this.getTagsForStencil(gn, 'x10910 proportional flow control valve pilot operated with position control of the main and pilot stage integrated electronics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10920;points=[[0.77,0,0],[0.77,0.673,0]]', w * 30.2, h * 55.47, '', 'X10920 Adjustable-orifice flow-control valve using a proportional solenoid that is not affected by changes in viscosity', null, null, this.getTagsForStencil(gn, 'x10920 adjustable orifice flow control valve using a proportional solenoid that is not affected by changes in viscosity', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10930;points=[[0.335,1,0],[1,0.6,0]]', w * 28.05, h * 46.64, '', 'X10930 Pressure-control and directional control valve cartridge, poppet design, area ratio 1:1', null, null, this.getTagsForStencil(gn, 'x10930', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10940;points=[[0.335,1,0],[1,0.6,0]]', w * 28.05, h * 46.64, '', 'X10940 Pressure-control and directional control valve cartridge, poppet design, normally open, area ratio 1:1', null, null, this.getTagsForStencil(gn, 'x10940 pressure control and directional control valve cartridge poppet design normally open area ratio', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10950;points=[[0.335,1,0],[1,0.6,0]]', w * 28.05, h * 46.64, '', 'X10950 Directional control valve cartridge, poppet design, with throttle nose, area ratio <= 0,7', null, null, this.getTagsForStencil(gn, 'x10950 directional control valve cartridge poppet design with throttle nose area ratio', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10960;points=[[0.335,1,0],[1,0.6,0]]', w * 28.05, h * 46.64, '', 'X10960 Directional control valve cartridge, poppet design, with throttle nose, area ratio > 0,7', null, null, this.getTagsForStencil(gn, 'x10960 directional control valve cartridge poppet design with throttle nose area ratio', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10970;points=[[0.335,1,0],[1,0.6,0]]', w * 28.05, h * 46.64, '', 'X10970 Directional control valve cartridge, poppet design, area ratio <= 0,7', null, null, this.getTagsForStencil(gn, 'x10970 directional control valve cartridge poppet design area ratio', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10980;points=[[0.335,1,0],[1,0.6,0]]', w * 28.05, h * 46.64, '', 'X10980 Directional control valve cartridge, poppet design, area ratio < 0,7', null, null, this.getTagsForStencil(gn, 'x10980 directional control valve cartridge poppet design area ratio', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x10990;points=[[0.37,1,0],[1,0.39,0],[0.878,0.653,0]]', w * 37.18, h * 53.69, '', 'X10990 Active-control, directional control valve cartridge, poppet design, opened by pilot pressure', null, null, this.getTagsForStencil(gn, 'x10990 active control directional control valve cartridge poppet design opened by pilot pressure', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11000;points=[[0.37,1,0],[1,0.39,0],[0.878,0.653,0]]', w * 37.18, h * 53.69, '', 'X11000 Active-control, directional control valve cartridge without area difference on side B', null, null, this.getTagsForStencil(gn, 'x11000 active control directional control valve cartridge without area difference on side', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11010;points=[[0.335,1,0],[1,0.6,0]]', w * 28.03, h * 46.6, '', 'X11010 Directional control valve cartridge, non-return function, poppet design, internal pilot supply, with replaceable orifice (restrictor)', null, null, this.getTagsForStencil(gn, 'x11010 directional control valve cartridge non return function poppet design internal pilot supply with replaceable orifice restrictor', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11020;points=[[0.33,1,0],[1,0.5,0]]', w * 28.03, h * 46.6, '', 'X11020 Cartridge for pressure-relief and limitation functions, spool design, normally closed', null, null, this.getTagsForStencil(gn, 'x110020 cartridge for pressure relief and limitation functions spool design normally closed', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11030;points=[[0.33,1,0],[1,0.5,0]]', w * 28.03, h * 46.6, '', 'X11030 Pressure-reducing valve cartridge, spool design, normally closed, with integrated non-return valve', null, null, this.getTagsForStencil(gn, 'x11030 pressure reducing valve cartridge spool design normally closed with integrated non return valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11040;points=[[0.33,1,0],[1,0.6,0]]', w * 28.06, h * 46.6, '', 'X11040 Pressure-reducing valve cartridge, spool design, normally open, with integrated non-return valve', null, null, this.getTagsForStencil(gn, 'x11040 pressure reducing valve cartridge spool design normally open with integrated non return valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11050;', w * 148.47, h * 27.76, '', 'X11050 Control cover without ports', null, null, this.getTagsForStencil(gn, 'x11050 control cover without ports', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11060;points=[[0.061,1,0],[0.499,0.75,0]]', w * 148.47, h * 37.39, '', 'X11060 Control cover with pilot port', null, null, this.getTagsForStencil(gn, 'x11060 control cover with pilot port', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11070;points=[[0.13,1,0],[0.497,0.84,0]]', w * 177.75, h * 57.56, '', 'X11070 Control cover with pilot port, with adjustable stroke limiter and remote-control port', null, null, this.getTagsForStencil(gn, 'x11070 control cover with pilot port with adjustable stroke limiter and remote control port', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11080;points=[[0.062,1,0],[0.187,1,0],[0.5,0.76,0],[0.814,1,0],[0.937,1,0]]', w * 148.47, h * 37.46, '', 'X11080 Control cover for mounting additional elements', null, null, this.getTagsForStencil(gn, 'x11080 control cover for mounting additional elements', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11090;points=[[0.062,1,0],[0.187,1,0],[0.5,0.875,0],[0.814,1,0]]', w * 148.47, h * 74.46, '', 'X11090 Control cover with hydraulically controlled shuttle valve', null, null, this.getTagsForStencil(gn, 'x11090 control cover with hydraulically controlled shuttle valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11100;points=[[0.062,1,0],[0.187,1,0],[0.5,0.875,0],[0.814,1,0]]', w * 148.47, h * 74.46, '', 'X11100 Control cover with shuttle valve', null, null, this.getTagsForStencil(gn, 'x11100 control cover with shuttle valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11110;points=[[0.062,1,0],[0.187,1,0],[0.5,0.875,0],[0.814,1,0],[0.94,1,0]]', w * 148.47, h * 74.74, '', 'X11110 Control cover with shuttle valve for mounting additional elements', null, null, this.getTagsForStencil(gn, 'x11110 control cover with shuttle valve for mounting additional elements', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11120;points=[[0.062,1,0],[0.187,1,0],[0.5,0.86,0],[0.94,1,0]]', w * 148.47, h * 65.4, '', 'X11120 Control cover with pressure-relief function', null, null, this.getTagsForStencil(gn, 'x11120 control cover with pressure-relief function', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11130;points=[[0.062,1,0],[0.187,1,0],[0.5,0.88,0],[0.94,1,0]]', w * 148.47, h * 74.46, '', 'X11130 Control cover with pressure-relief function and hydraulic unloading', null, null, this.getTagsForStencil(gn, 'x11130 control cover with pressure relief function and hydraulic unloading', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11140;points=[[0.062,1,0],[0.187,1,0],[0.5,0.88,0],[0.94,1,0]]', w * 148.47, h * 74.46, '', 'X11140 Control cover with pressure-relief function with a flow-control valve for limiting the pilot flow', null, null, this.getTagsForStencil(gn, 'x11140 control cover with pressure-relief function with a flow-control valve for limiting the pilot flow', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11150;points=[[0,0.307,0],[0.13,0.61,0],[0.497,1,0],[0.603,0.803,0]]', w * 177.75, h * 94.56, '', 'X11150 Two-port cartridge valve with stroke limiter', null, null, this.getTagsForStencil(gn, 'x11150 two port cartridge valve with stroke limiter', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11160;points=[[0.062,0.733,0],[0.188,0.733,0],[0.5,1,0],[0.627,0.867,0],[0.812,0.733,0],[0.937,0.733,0]]', w * 148.55, h * 139.44, '', 'X11160 Two-port cartridge valve with builtin directional control valve', null, null, this.getTagsForStencil(gn, 'x11160 two port cartridge valve with builtin directional control valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11170;points=[[0.062,0.867,0],[0.5,1,0],[0.627,0.867,0],[0.937,0.867,0]]', w * 148.55, h * 139.44, '', 'X11170 Two-port cartridge valve with active control, with built-in directional control valve', null, null, this.getTagsForStencil(gn, 'x11170 two port cartridge valve with active control with built-in directional control valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11180;points=[[0,0.25,0],[0.543,1,0],[0.656,0.748,0],[0.943,0.58,0],[0.257,0.58,0]]', w * 162.55, h * 111.61, '', 'X11180 Two-port cartridge valve with pressure-relief function', null, null, this.getTagsForStencil(gn, 'x11180 two port cartridge valve with pressure relief function', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11190;points=[[0,0.624,0],[1,0.624,0],[0.5,1,0],[0.607,0.873,0],[0.86,0.79,0],[0.868,0.79,0]]', w * 176.51, h * 223.31, '', 'X11190 Two-port cartridge valve with pressure-relief function and selectable second pressure stage', null, null, this.getTagsForStencil(gn, 'x11190 two port cartridge valve with pressure relief function and selectable second pressure stage', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11200;points=[[0,0.5,0],[1,0.5,0],[0.5,1,0],[0.606,0.832,0],[0.868,0.722,0]]', w * 176.51, h * 167.41, '', 'X11200 Two-port cartridge valve with proportional pressure adjustment and manual maximum pressure relief function', null, null, this.getTagsForStencil(gn, 'x11200 two port cartridge valve with proportional pressure adjustment and manual maximum pressure relief function', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11210;points=[[0,0.843,0],[0.5,1,0],[0.936,0.693,0]]', w * 148.69, h * 120.85, '', 'X11210 Two-port cartridge valve with pressure-reducing function and flow-control valve, controlled by high pressure', null, null, this.getTagsForStencil(gn, 'x11210 two port cartridge valve with pressure reducing function and flow control valve controlled by high pressure', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11220;points=[[0.5,1,0],[0.625,0.784,0],[0.937,0.643,0]]', w * 148.69, h * 130.29, '', 'X11220 Two-port cartridge valve with pressure-reducing function, controlled by low pressure', null, null, this.getTagsForStencil(gn, 'x11220 two port cartridge valve with pressure reducing function controlled by low pressure', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11230;points=[[0.5,0,0],[0.5,1,0]]', w * 42.27, h * 46.97, '', 'X11230 Variable-displacement pump and one direction of rotation (clockwise)', null, null, this.getTagsForStencil(gn, 'x11230 variable displacement pump and one direction of rotation clockwise', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11240;points=[[0.567,0,0],[0.567,1,0],[0.95,1,0]]', w * 48.85, h * 46.97, '', 'X11240 Variable-displacement pump with two directions of flow, external drain line, and one direction of rotation (clockwise)', null, null, this.getTagsForStencil(gn, 'x11240 variable displacement pump with two directions of flow external drain line and one direction of rotation clockwise', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11250;points=[[0.567,0,0],[0.567,1,0],[0.95,1,0]]', w * 48.85, h * 46.97, '', 'X11250 Reversible pump/motor unit with two directions of flow and variable displacement, external drain line, and two directions of rotation', null, null, this.getTagsForStencil(gn, 'x11250 reversible pump motor unit with two directions of flow and variable displacement external drain line and two directions of rotation', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11260;points=[[0.57,0,0],[0.57,1,0]]', w * 48.42, h * 46.97, '', 'X11260 Fixed displacement pump/motor unit with one direction of rotation (clockwise)', null, null, this.getTagsForStencil(gn, 'x11260 fixed displacement pump motor unit with one direction of rotation clockwise', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11270;points=[[1,0.25,0],[1,0.75,0]]', w * 42.3, h * 27.87, '', 'X11270 Pump with a limited swivel angle, lever-operated', null, null, this.getTagsForStencil(gn, 'x11270 pump with a limited swivel angle lever operated', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11280;points=[[0,0.25,0],[0,0.75,0]]', w * 37.31, h * 27.87, '', 'X11280 Rotary actuator/swivel drive with a limited swivel angle and two directions of flow', null, null, this.getTagsForStencil(gn, 'x11280 rotary actuator swivel drive with a limited swivel angle and two directions of flow', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11290;points=[[0.053,0.25,0]]', w * 39.41, h * 27.87, '', 'X11290 Semi-rotary actuator/swivel drive, single-acting', null, null, this.getTagsForStencil(gn, 'x11290 semi rotary actuator swivel drive  single acting', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11300;points=[[0.03,0.895,0],[0.742,0,0],[0.742,0.815,0],[0.871,0.833,0]]', w * 143.98, h * 114.54, '', 'X11300 Variable-displacement pump, pilot-operated, with pressure compensation, one direction of rotation (clockwise) and an external drain line', null, null, this.getTagsForStencil(gn, 'x11300 variable displacement pump pilot operated with pressure compensation one direction of rotation clockwise and an external drain line', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11310;points=[[0.03,0.91,0],[0.75,0,0],[0.75,0.98,0],[0.874,1,0]]', w * 148.8, h * 133.09, '', 'X11310 Variable-displacement pump with combined pressure/flow control (load-sensing type), one drive direction (clockwise) and an external drain line', null, null, this.getTagsForStencil(gn, 'x11310 variable displacement pump with combined pressure flow control load sensing type, one drive direction clockwise and an external drain line', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11320;points=[[0.575,0,0],[0.575,1,0],[0.79,0.93,0]]', w * 88.39, h * 102.61, '', 'X11320 Variable-displacement pump with mechanical/hydraulic servo-control, one drive direction (counter-clockwise) and an external drain line', null, null, this.getTagsForStencil(gn, 'x11320 variable displacement pump with mechanical hydraulic servo control, one drive direction counter clockwise and an external drain line', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11330;points=[[0.575,0,0],[0.575,1,0],[0.79,0.93,0]]', w * 88.39, h * 102.61, '', 'X11330 Variable-displacement hydraulic pump with electro-hydraulic servo control, one drive direction (counter-clockwise) and an external drain line', null, null, this.getTagsForStencil(gn, 'x11330 variable displacement hydraulic pump with electro hydraulic servo control one drive direction counter clockwise and an external drain line', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11340;points=[[0.6,0,0],[0.6,1,0],[0.8,1,0]]', w * 92.92, h * 102.61, '', 'X11340 Variable-displacement pump with power control, one drive direction (clockwise) and an external drain line', null, null, this.getTagsForStencil(gn, 'x11340 variable displacement pump with power control one drive direction clockwise and an external drain line', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11350;points=[[0.69,0,0],[0.69,0.98,0],[0.845,1,0]]', w * 120.78, h * 104.8, '', 'X11350 Variable-displacement pump with a two-stage adjustable stroke limited pressure/flow control, internal pilot-operated, one drive direction (clockwise) and an external drain line', null, null, this.getTagsForStencil(gn, 'x11350 variable displacement pump with a two stage adjustable stroke limited pressure flow control internal pilot operated one drive direction clockwise and an external drain line', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11360;points=[[0.75,0,0],[0.75,0.982,0],[0.875,1,0]]', w * 148.69, h * 123.33, '', 'X11360 Variable-displacement pump with a two-stage adjustable limited-stroke pressure/flow-control element, electrical switchover, one drive direction (clockwise) and an external drain line', null, null, this.getTagsForStencil(gn, 'x11360', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11370;points=[[0.5,0,0],[0.5,1,0]]', w * 111.29, h * 83.91, '', 'X11370 Hydrostatic transmission (simplified representation), drive unit consisting of one reversible, variable-displacement pump with one input direction of rotation and one fixed displacement motor with two output directions of rotation', null, null, this.getTagsForStencil(gn, 'x11370 hydrostatic transmission simplified representation drive unit consisting of one reversible variable displacement pump with one input direction of rotation and one fixed displacement motor with two output directions of rotation', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11380;points=[[0.645,0,0],[0.645,0.74,0]]', w * 61.19, h * 62.84, '', 'X11380 Variable-displacement pump with one drive direction (clockwise)', null, null, this.getTagsForStencil(gn, 'x11380 variable displacement pump with one drive direction clockwise', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11390;points=[[0.334,0,0],[0.334,1,0]]', w * 41.69, h * 46.45, '', 'X11390 Motor', null, null, this.getTagsForStencil(gn, 'x11390 motor', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11400;points=[[0.666,0,0],[0.666,1,0]]', w * 41.61, h * 46.97, '', 'X11400 Compressor', null, null, this.getTagsForStencil(gn, 'x11400 compressor', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11410;points=[[0.387,0,0],[0.387,1,0]]', w * 52.95, h * 46.45, '', 'X11410 Motor with alternate directions of flow, fixed displacement and two directions of rotation', null, null, this.getTagsForStencil(gn, 'x11410 motor with alternate directions of flow fixed displacement and two directions of rotation', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11420;points=[[0.665,0,0],[0.665,1,0]]', w * 41.75, h * 46.45, '', 'X11420 Vacuum pump', null, null, this.getTagsForStencil(gn, 'x11420 vacuum pump', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11430;points=[[0,0.375,0],[1,0.375,0],[0.4,0.99,0],[0.6,1,0]]', w * 46.97, h * 37.36, '', 'X11430 Pressure intensifier, continuous, which converts a pneumatic pressure p1 into a higher hydraulic pressure p2', null, null, this.getTagsForStencil(gn, 'x11430 pressure intensifier continuous which converts a pneumatic pressure p1 into a higher hydraulic pressure p2', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11440;points=[[0.04,1,0],[0.707,1,0]]', w * 55.71, h * 28.02, '', 'X11440 Single-acting, single-rod cylinder, return stroke by spring force, spring chamber with connection', null, null, this.getTagsForStencil(gn, 'x11440 single acting single rod cylinder return stroke by spring force spring chamber with connection', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11450;points=[[0.04,1,0],[0.707,1,0]]', w * 55.71, h * 28.02, '', 'X11450 Double-acting, single-rod cylinder', null, null, this.getTagsForStencil(gn, 'x11450 double acting single rod cylinder', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11460;points=[[0.427,1,0],[0.81,1,0]]', w * 97.52, h * 36.78, '', 'X11460 Double-acting, double-rod cylinder, with different piston-rod diameters; cushioning on both sides with adjustment on right side only', null, null, this.getTagsForStencil(gn, 'x11460 double acting double rod cylinder with different piston rod diameters cushioning on both sides with adjustment on right side only', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11470;points=[[0.28,1,0],[0.76,1,0]]', w * 77.69, h * 30.32, '', 'X11470 Double-acting diaphragm cylinder with preset stroke limiter', null, null, this.getTagsForStencil(gn, 'x11470 double acting diaphragm cylinder with preset stroke limiter', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11480;points=[[0.53,1,0]]', w * 74.56, h * 28.02, '', 'X11480 Single-acting diaphragm cylinder with cushioning on rod end, vented cap end without the possibility of a connection', null, null, this.getTagsForStencil(gn, 'x11480 single acting diaphragm cylinder with cushioning on rod end vented cap end without the possibility of a connection', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11490;points=[[0.047,1,0]]', w * 51.07, h * 32.7, '', 'X11490 Single-acting cylinder, plunger cylinder', null, null, this.getTagsForStencil(gn, 'x11490 single acting cylinder plunger cylinder', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11500;points=[[0.025,1,0]]', w * 85.98, h * 32.7, '', 'X11500 Telescopic cylinder, single-acting', null, null, this.getTagsForStencil(gn, 'x11500 telescopic cylinder single a0cting', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11510;points=[[0.03,1,0],[0.53,1,0],[0.78,1,0]]', w * 74.26, h * 32.67, '', 'X11510 Telescopic cylinder, double-acting', null, null, this.getTagsForStencil(gn, 'x11510 telescopic cylinder double acting', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11520;points=[[0.05,1,0],[0.94,1,0]]', w * 41.75, h * 32.72, '', 'X11520 Double-acting band-type rodless cylinder with end-position cushioning on both sides of the piston', null, null, this.getTagsForStencil(gn, 'x11520 double acting band type rodless cylinder with end position cushioning on both sides of the piston', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11530;points=[[0.05,1,0],[0.94,1,0]]', w * 41.75, h * 36.9, '', 'X11530 Double-acting cable-type rodless cylinder with adjustable end-position cushioning on both sides of the piston', null, null, this.getTagsForStencil(gn, 'x11530 double acting cable type rodless cylinder with adjustable end position cushioning on both sides of the piston', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11540;points=[[0.04,1,0],[0.705,1,0]]', w * 55.73, h * 42.07, '', 'X11540 Double-acting magnetic-type rodless cylinder with position switch on right-hand end only', null, null, this.getTagsForStencil(gn, 'x11540 double acting magnetic type rodless cylinder with position switch on right hand end only', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11550;points=[[0.04,1,0],[0.705,1,0]]', w * 55.72, h * 28.06, '', 'X11550 Double-acting cylinder with detents at both ends of the stroke', null, null, this.getTagsForStencil(gn, 'x11550 double acting cylinder with detents at both ends of the stroke', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11560;points=[[0.34,1,0],[0.66,1,0]]', w * 116.04, h * 41.96, '', 'X11560 Double-acting cylinder, double rod, with internal limit switch on the left end, with internal mechanical control, external limit switch on the right end, tripped by the piston rod', null, null, this.getTagsForStencil(gn, 'x11560 double acting cylinder double rod with internal limit switch on the left end with internal mechanical control external limit switch on the right end tripped by the piston rod', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11570;points=[[0.027,1,0],[0.477,1,0]]', w * 82.45, h * 52.12, '', 'X11570 Pressure-medium converter, single-acting, which converts a pneumatic pressure into a hydraulic pressure of the same value', null, null, this.getTagsForStencil(gn, 'x11570 pressure medium converter single acting which converts a pneumatic pressure into a hydraulic pressure of the same value', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11580;points=[[0.053,1,0],[0.94,1,0]]', w * 41.74, h * 27.95, '', 'X11580 Pressure intensifier, single-acting, which converts a pneumatic pressure p1 into a higher hydraulic pressure p2', null, null, this.getTagsForStencil(gn, 'x11580 pressure intensifier single acting which converts a pneumatic pressure p1 into a higher hydraulic pressure p2', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11590;points=[[0.053,1,0],[0.94,1,0]]', w * 41.74, h * 36.03, '', 'X11590 Pressure intensifier, single-acting, which converts a pneumatic pressure p1 into a higher hydraulic pressure p2', null, null, this.getTagsForStencil(gn, 'x11590 pressure intensifier single acting which converts a pneumatic pressure p1 into a higher hydraulic pressure p2', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11600;points=[[0.5,1,0]]', w * 37.52, h * 28, '', 'X11600 Bellows cylinder', null, null, this.getTagsForStencil(gn, 'x11600 bellows cylinder', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11610;points=[[0,0.5,0]]', w * 46.69, h * 19.07, '', 'X11610 Hose cylinder', null, null, this.getTagsForStencil(gn, 'x11610 hose cylinder', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11620;points=[[0,0.25,0],[0,0.55,0],[0.55,1,0],[0.863,1,0]]', w * 118.47, h * 46.64, '', 'X11620 Semi-rotary linear drive, double-acting with permanent magnet on the piston', null, null, this.getTagsForStencil(gn, 'x11620 semi rotary linear drive double acting with permanent magnet on the piston', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11630;points=[[0.05,1,0],[0.65,1,0]]', w * 46.47, h * 27.91, '', 'X11630 Gripper, double-acting with permanent magnet on piston', null, null, this.getTagsForStencil(gn, 'x11630 gripper double acting with permanent magnet on piston', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11640;points=[[0.05,1,0],[0.65,1,0]]', w * 46.47, h * 27.91, '', 'X11640 Gripper, double-acting with permanent magnet on piston', null, null, this.getTagsForStencil(gn, 'x11640 gripper double acting with permanent magnet on piston', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11650;points=[[0.05,1,0]]', w * 46.47, h * 27.91, '', 'X11650 Gripper, single-acting with permanent magnet on piston', null, null, this.getTagsForStencil(gn, 'x11650 gripper single acting with permanent magnet on piston', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11660;points=[[0.65,1,0]]', w * 46.47, h * 27.91, '', 'X11660 Gripper, single-acting with permanent magnet on piston', null, null, this.getTagsForStencil(gn, 'x11660 gripper single acting with permanent magnet on piston', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11670;points=[[0,0.1,0],[1,0.1,0],[0.037,0,0],[0.963,0,0]]', w * 20.03, h * 6.68, '', 'X11670 Hose assembly', null, null, this.getTagsForStencil(gn, 'x11670 Hose assembly', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11680;points=[[0,0.27,0],[0,0.64,0],[0,1,0],[1,0.27,0],[1,0.64,0],[1,1,0]]', w * 46.83, h * 25.43, '', 'X11680 Three-way rotary connection', null, null, this.getTagsForStencil(gn, 'x11680 three way rotary connection', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11690;points=[[0.5,0,0],[0.5,1,0]]', w * 9.49, h * 51.39, '', 'X11690 Quick-action coupling without non-return valve, uncoupled', null, null, this.getTagsForStencil(gn, 'x11690 quick action coupling without non return valve uncoupled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11700;points=[[0.5,0,0],[0.5,1,0]]', w * 9.49, h * 51.39, '', 'X11700 Quick-action coupling with non-return valve, uncoupled', null, null, this.getTagsForStencil(gn, 'x11700 quick action coupling with non return valve uncoupled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11710;points=[[0.5,0,0],[0.5,1,0]]', w * 9.49, h * 51.43, '', 'X11710 Quick-action coupling with two non-return valves, uncoupled', null, null, this.getTagsForStencil(gn, 'x11710 quick action coupling with two non return valves uncoupled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11720;points=[[0.5,0,0],[0.5,1,0]]', w * 9.49, h * 46.89, '', 'X11720 Quick-action coupling without non-return valve, coupled', null, null, this.getTagsForStencil(gn, 'x11720 quick action coupling without non return valve coupled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11730;points=[[0.5,0,0],[0.5,1,0]]', w * 9.49, h * 46.89, '', 'X11730 Quick-action coupling with one non-return valve, coupled', null, null, this.getTagsForStencil(gn, 'x11730 quick action coupling with one non return valve coupled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11740;points=[[0.5,0,0],[0.5,1,0]]', w * 9.49, h * 46.89, '', 'X11740 Quick-action coupling with two non-return valves, coupled', null, null, this.getTagsForStencil(gn, 'x11740 quick action coupling with two non return valves coupled', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11750;points=[[0,0.58,0]]', w * 35.2, h * 21.37, '', 'X11750 Pressure switch, electro-mechanical, adjustable', null, null, this.getTagsForStencil(gn, 'x11750 pressure switch electro mechanical adjustable', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11760;points=[[0.4,0,0],[0,0.7,0]]', w * 23.41, h * 23.56, '', 'X11760 Pressure converter electronically adjustable switching signal output', null, null, this.getTagsForStencil(gn, 'x11760 pressure converter electronically adjustable switching signal output', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11770;points=[[0,0.5,0]]', w * 23.41, h * 13.98, '', 'X11770 Pressure sensor, analogue output signal', null, null, this.getTagsForStencil(gn, 'x11770 pressure sensor analogue output signal', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11780;points=[[0,0,0],[0.5,0,0],[1,0,0],[1,0.5,0],[1,1,0],[0.5,1,0],[0,1,0],[0,0.5,0]]', w * 13.88, h * 9.28, '', 'X11780 Piezo-electric control mechanism', null, null, this.getTagsForStencil(gn, 'x11780 piezo electric control mechanism', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11790;points=[[0,0,0],[0.5,0,0],[1,0,0],[1,0.5,0],[1,1,0],[0.5,1,0],[0,1,0],[0,0.5,0]]', w * 23.06, h * 13.87, '', 'X11790 Optical indicator', null, null, this.getTagsForStencil(gn, 'x11790 optical indicator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11800;points=[[0,0,0],[0.5,0,0],[1,0,0],[1,0.5,0],[1,1,0],[0.5,1,0],[0,1,0],[0,0.5,0]]', w * 23.06, h * 13.87, '', 'X11800 Indicator with digital display', null, null, this.getTagsForStencil(gn, 'x11800 indicator with digital display', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11810;points=[[0,0,0],[0.5,0,0],[1,0,0],[1,0.5,0],[1,1,0],[0.5,1,0],[0,1,0],[0,0.5,0]]', w * 23.06, h * 13.87, '', 'X11810 Acoustic indicator', null, null, this.getTagsForStencil(gn, 'x11810 acoustic indicator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11820;points=[[0.5,1,0]]', w * 18.67, h * 28.05, '', 'X11820 Pressure-measuring unit (pressure gauge)', null, null, this.getTagsForStencil(gn, 'x11820 pressure measuring unit pressure gauge', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11830;points=[[0.5,0,0],[0.5,1,0]]', w * 18.67, h * 37.38, '', 'X11830 Differential-pressure gauge', null, null, this.getTagsForStencil(gn, 'x11830 differential pressure gauge', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11840;points=[[0.07,0.485,0],[1,0.145,0],[1,0.315,0],[1,0.485,0],[1,0.66,0],[1,0.83,0],[1,1,0]]', w * 50.2, h * 54.27, '', 'X11840 Pressure gauge with select function', null, null, this.getTagsForStencil(gn, 'x11840 pressure gauge with select function', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11850;points=[[0.5,1,0]]', w * 18.67, h * 28.09, '', 'X11850 Thermometer', null, null, this.getTagsForStencil(gn, 'x11850 thermometer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11860;points=[[0.57,0,0],[0.28,1,0]]', w * 32.48, h * 35.29, '', 'X11860 Thermometer with two adjustable electrical break-contacts (contact thermometer)', null, null, this.getTagsForStencil(gn, 'x11860 thermometer with two adjustable electrical break contacts contact thermometer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11870;points=[[0.5,1,0]]', w * 18.72, h * 28.09, '', 'X11870 Fluid-level indicator (sight-glass)', null, null, this.getTagsForStencil(gn, 'x11870 fluid level indicator sight glass', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11880;points=[[0.28,1,0]]', w * 32.66, h * 28.09, '', 'X11880 Fluid-level switch with four break-contacts', null, null, this.getTagsForStencil(gn, 'x11880 fluid level switch with four break contacts', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11890;points=[[0.225,1,0]]', w * 41.93, h * 32.62, '', 'X11890 Electrical fluid-level monitor with analogue output signal and digital display', null, null, this.getTagsForStencil(gn, 'x11890 electrical fluid level monitor with analogue output signal and digital display', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11900;points=[[0.5,1,0]]', w * 18.67, h * 28.09, '', 'X11900 Flow indicator', null, null, this.getTagsForStencil(gn, 'x11900 flow indicator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11910;points=[[0.5,0,0],[0.5,1,0]]', w * 18.67, h * 37.52, '', 'X11910 Flow meter', null, null, this.getTagsForStencil(gn, 'x11910 flow meter', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11920;points=[[0.22,0,0],[0.22,1,0]]', w * 41.88, h * 37.52, '', 'X11920 Flow meter with digital display', null, null, this.getTagsForStencil(gn, 'x11920 flow meter with digital display', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11930;points=[[0,0.375,0],[0,0.625,0]]', w * 28.14, h * 18.71, '', 'X11930 Tachometer', null, null, this.getTagsForStencil(gn, 'x11930 tachometer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11940;points=[[0,0.37,0],[0,0.62,0],[1,0.37,0],[1,0.62,0]]', w * 37.47, h * 18.71, '', 'X11940 Torque meter', null, null, this.getTagsForStencil(gn, 'x11940 torque meter', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11950;points=[[0,0,0],[0.5,0,0],[1,0,0],[1,0.5,0],[1,1,0],[0.5,1,0],[0,1,0],[0,0.5,0]]', w * 23.11, h * 13.91, '', 'X11950 Time controller with switch', null, null, this.getTagsForStencil(gn, 'x11950 time controller with switch', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11960;points=[[0,0.5,0]]', w * 27.91, h * 18.57, '', 'X11960 Counter', null, null, this.getTagsForStencil(gn, 'x11960 counter', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11970;points=[[0,0.29,0],[1,0.145,0],[0.893,1,0]]', w * 88.64, h * 32.33, '', 'X11970 In-line particle counter', null, null, this.getTagsForStencil(gn, 'x11970 in line particle counter', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11980;points=[[0.5,0,0],[0.5,1,0]]', w * 26.22, h * 45.06, '', 'X11980 Filter', null, null, this.getTagsForStencil(gn, 'x11980 filter', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x11990;points=[[0.5,0,0],[0.5,1,0]]', w * 26.22, h * 47.81, '', 'X11990 Reservoir-breather filter', null, null, this.getTagsForStencil(gn, 'x11990 reservoir breather filter', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12000;points=[[0.5,0,0],[0.5,1,0]]', w * 26.22, h * 45.06, '', 'X12000 Filter with additional magnetic element', null, null, this.getTagsForStencil(gn, 'x12000 filter with additional magnetic element', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12010;points=[[0.255,0.045,0],[0.255,1,0]]', w * 51.35, h * 47.26, '', 'X12010 Filter with optical clogging indicator', null, null, this.getTagsForStencil(gn, 'x12010 filter with optical clogging indicator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12020;points=[[0.28,0.09,0],[0.28,1,0]]', w * 46.93, h * 49.61, '', 'X12020 Filter with pressure-measuring instrument', null, null, this.getTagsForStencil(gn, 'x12020 filter with pressure measuring instrument', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12030;points=[[0.62,0,0],[0.62,1,0]]', w * 48.7, h * 63.01, '', 'X12030 Filter with a throttled bypass flow', null, null, this.getTagsForStencil(gn, 'x12030 Filter with a throttled bypass flow', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12040;points=[[0.68,0,0],[0.68,1,0]]', w * 61.46, h * 73.5, '', 'X12040 Filter with bypass valve', null, null, this.getTagsForStencil(gn, 'x12040 filter with bypass valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12050;points=[[0.445,0,0],[0.445,1,0]]', w * 93.84, h * 73.5, '', 'X12050 Filter with bypass valve and digital indicator', null, null, this.getTagsForStencil(gn, 'x12050 filter with bypass valve and digital indicator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12060;points=[[0.34,0,0],[0.34,1,0]]', w * 123.13, h * 73.5, '', 'X12060 Filter with bypass valve with optical clogging indicator and electrical contact', null, null, this.getTagsForStencil(gn, 'x12060 filter with bypass valve with optical clogging indicator and electrical contact', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12070;points=[[0.225,0,0],[0.225,1,0]]', w * 58.42, h * 64.27, '', 'X12070 Filter with optical clogging indicator based on differential pressure', null, null, this.getTagsForStencil(gn, 'x12070 filter with optical clogging indicator based on differential pressure', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12080;points=[[0.167,0,0],[0.167,1,0]]', w * 78.16, h * 64.27, '', 'X12080 Filter with pressure-measuring instrument and electrical contact', null, null, this.getTagsForStencil(gn, 'x12080 filter with pressure measuring instrument and electrical contact', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12090;points=[[0,0.5,0],[1,0.5,0]]', w * 45.21, h * 26.2, '', 'X12090 Centrifugal separator', null, null, this.getTagsForStencil(gn, 'x12090 centrifugal separator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12100;points=[[0,0.365,0],[1,0.365,0],[0.5,1,0]]', w * 45.21, h * 35.63, '', 'X12100 Coalescing filter with automatic drain', null, null, this.getTagsForStencil(gn, 'x12100 coalescing filter with automatic drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12110;points=[[0,0.543,0],[1,0.543,0],[0.5,1,0]]', w * 45.21, h * 49.55, '', 'X12110 Coalescing filter with manual drain and clogging indicator', null, null, this.getTagsForStencil(gn, 'x12110 coalescing filter with manual drain and clogging indicator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12120;points=[[0,0.5,0],[1,0.5,0]]', w * 45.21, h * 26.2, '', 'X12120 Two-phase separator', null, null, this.getTagsForStencil(gn, 'x12120 two phase separator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12130;points=[[0,0.5,0],[1,0.5,0]]', w * 45.21, h * 26.2, '', 'X12130 vacuum separator', null, null, this.getTagsForStencil(gn, 'x12130 vacuum separator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12140;points=[[0,0.5,0],[1,0.5,0]]', w * 45.21, h * 26.2, '', 'X12140 Electrostatic separator', null, null, this.getTagsForStencil(gn, 'x12140 electrostatic separator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12150;points=[[0,0.43,0],[1,0.43,0],[0.335,1,0]]', w * 97.91, h * 64.35, '', 'X12150 Filter with manual drain, regulator with manual adjustment, nonrelieving, without pressure gauge', null, null, this.getTagsForStencil(gn, 'x12150 filter with manual drain regulator with manual adjustment nonrelieving without pressure gauge', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12160_detailed;points=[[0,0.505,0],[1,0.505,0],[0.236,1,0]]', w * 158.18, h * 73.73, '', 'X12160 Air conditioning unit (FRL unit), consisting of a filter with manual drain, a pressure-relieving pressure regulator with manual adjustment, a pressure gauge and a lubricator (detailed)', null, null, this.getTagsForStencil(gn, 'x12160 air conditioning unit frl unit consisting of filter with manual drain pressure relieving pressure regulator with manual adjustment pressure gauge and lubricator detailed', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12160_simplified;points=[[0,0.5,0],[1,0.5,0]]', w * 65.34, h * 27.89, '', 'X12160 Air conditioning unit (FRL unit), consisting of a filter with manual drain, a pressure-relieving pressure regulator with manual adjustment, a pressure gauge and a lubricator (simplified)', null, null, this.getTagsForStencil(gn, 'x12160 air conditioning unit frl unit consisting of filter with manual drain pressure relieving pressure regulator with manual adjustment pressure gauge and lubricator simplified', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12170;points=[[0.5,0,0],[0.5,1,0]]', w * 81.17, h * 96.39, '', 'X12170 Double filter with manual changeover feature', null, null, this.getTagsForStencil(gn, 'x12170 double filter with manual changeover feature', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12180;points=[[0,0.33,0],[1,0.33,0],[0.5,1,0]]', w * 45.21, h * 39.34, '', 'X12180 Fluid separator with manual drain', null, null, this.getTagsForStencil(gn, 'x12180 fluid separator with manual drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12190;points=[[0,0.33,0],[1,0.33,0],[0.5,1,0]]', w * 45.21, h * 39.34, '', 'X12190 Filter with separator with manual drain', null, null, this.getTagsForStencil(gn, 'x12190 filter with separator with manual drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12200;points=[[0,0.365,0],[1,0.365,0],[0.5,1,0]]', w * 45.21, h * 35.67, '', 'X12200 Fluid separator with automatic drain', null, null, this.getTagsForStencil(gn, 'x12200 fluid separator with automatic drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12210;points=[[0,0.365,0],[1,0.365,0],[0.5,1,0]]', w * 45.21, h * 35.67, '', 'X12210 Adsorber filter', null, null, this.getTagsForStencil(gn, 'x12210 adsorber filter', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12220;points=[[0,0.365,0],[1,0.365,0],[0.5,1,0]]', w * 45.21, h * 35.67, '', 'X12220 Oil mist separator', null, null, this.getTagsForStencil(gn, 'x12220 oil mist separator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12230;points=[[0,0.365,0],[1,0.365,0],[0.5,1,0]]', w * 45.21, h * 35.67, '', 'X12230 Air dryer', null, null, this.getTagsForStencil(gn, 'x12230 air dryer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12240;points=[[0,0.5,0],[1,0.5,0]]', w * 55.85, h * 26.2, '', 'X12240 Lubricator', null, null, this.getTagsForStencil(gn, 'x12240 lubricator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12250;points=[[0,0.33,0],[1,0.33,0],[0.5,1,0]]', w * 45.21, h * 39.34, '', 'X12250 Lubricator with manual drain', null, null, this.getTagsForStencil(gn, 'x12250 lubricator with manual drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12260;points=[[0.5,0,0],[0.5,1,0]]', w * 26.22, h * 49.8, '', 'X12260 cooler without indication of the flow paths of the coolant', null, null, this.getTagsForStencil(gn, 'x12260 cooler without indication of the flow paths of the coolant', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12270;points=[[0.302,0,0],[0.302,1,0],[1,0.41,0],[1,0.595,0]]', w * 43.5, h * 49.8, '', 'X12270 Cooler with liquid coolant', null, null, this.getTagsForStencil(gn, 'x12270 cooler with liquid coolant', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12280;points=[[0.791,0,0],[0.791,1,0]]', w * 105.57, h * 65.2, '', 'X12280 Cooler with electrically powered fan', null, null, this.getTagsForStencil(gn, 'x12280 cooler with electrically powered fan', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12290;points=[[0.5,0,0],[0.5,1,0]]', w * 26.22, h * 49.8, '', 'X12290 Heater', null, null, this.getTagsForStencil(gn, 'x12290 heater', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12300;points=[[0,0.5,0],[1,0.5,0]]', w * 49.8, h * 26.28, '', 'X12300 Temperature regulator', null, null, this.getTagsForStencil(gn, 'x12300 temperature regulator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12310;points=[[0,0.365,0],[1,0.365,0],[0.5,1,0]]', w * 55.85, h * 35.68, '', 'X12310 Reclassifier with manual drain', null, null, this.getTagsForStencil(gn, 'x12310 reclassifier with manual drain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12320;points=[[0.5,1,0]]', w * 18.53, h * 46.46, '', 'X12320 Gas-loaded accumulator in which the media are separated by a diaphragm (diaphragm-type accumulator)', null, null, this.getTagsForStencil(gn, 'x12320 gas loaded accumulator in which the media are separated by diaphragm type accumulator)', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12330;points=[[0.5,1,0]]', w * 18.53, h * 46.46, '', 'X12330 Gas-loaded accumulator in which the media are separated by a bladder (bladder-type accumulator)', null, null, this.getTagsForStencil(gn, 'x12330 gas loaded accumulator in which the media are separated by a bladder type accumulator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12340;points=[[0.5,1,0]]', w * 18.53, h * 46.46, '', 'X12340 Gas-loaded accumulator in which the media are separated by a piston and piston bladder (piston-type accumulator)', null, null, this.getTagsForStencil(gn, 'x12340 gas loaded accumulator in which the media are separated by a piston and piston bladder piston type accumulator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12350;points=[[0.5,1,0]]', w * 18.53, h * 46.46, '', 'X12350 Gas bottle', null, null, this.getTagsForStencil(gn, 'x12350 gas bottle', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12360;points=[[0.17,1,0]]', w * 54.44, h * 55.92, '', 'X12360 Piston-type accumulator with back-up bottle', null, null, this.getTagsForStencil(gn, 'x12360 piston type accumulator with back up bottle', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12370;points=[[0,0.5,0],[1,0.5,0]]', w * 56.27, h * 18.57, '', 'X12370 Air reservoir', null, null, this.getTagsForStencil(gn, 'x12370 air reservoir', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12380;points=[[0,0.335,0],[1,0.335,0],[0.5,1,0]]', w * 56.13, h * 27.96, '', 'X12380 Vacuum generator', null, null, this.getTagsForStencil(gn, 'x12380 vacuum generator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12390;points=[[0,0.18,0],[1,0.18,0],[0.5,1,0]]', w * 56.13, h * 51.18, '', 'X12390 Single stage vacuum generator with integrated non-return valve', null, null, this.getTagsForStencil(gn, 'x12390 single stage vacuum generator with integrated non return valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12400;points=[[0,0.195,0],[1,0.195,0],[0.25,1,0]]', w * 74.8, h * 46.79, '', 'X12400 Three stage vacuum generator with integrated non-return valves', null, null, this.getTagsForStencil(gn, 'x12400 three stage vacuum generator with integrated non return valves', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12410;points=[[0.59,0,0],[0.725,1,0],[1,0.555,0]]', w * 102.34, h * 84.04, '', 'X12410 Single stage vacuum generator with blow-off valve', null, null, this.getTagsForStencil(gn, 'x12410 single stage vacuum generator with blow off valve', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12420;points=[[0.5,0,0],[0,1,0],[1,1,0]]', w * 18.69, h * 28.39, '', 'X12420 Suction cup', null, null, this.getTagsForStencil(gn, 'x12420 suction cup', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'x12430;points=[[0.5,0,0],[0,1,0],[1,1,0]]', w * 18.69, h * 28.39, '', 'X12430 Suction cup with spring loaded stem and non-return valve', null, null, this.getTagsForStencil(gn, 'x12430 suction cup with spring loaded stem and non return valve', dt).join(' '))
		]);
		
		this.setCurrentSearchEntryLibrary();
	};
})();
