var indexes = 
[
   {
        "id": "Functions/abs.htm", 
        "title": "Fonction ABS", 
        "body": "La fonction ABS est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la valeur absolue d'un nombre. La syntaxe de la fonction ABS est : ABS(x) où x est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ABS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ABS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/accrint.htm", 
        "title": "Fonction INTERET.ACC", 
        "body": "La fonction INTERET.ACC est l'une des fonctions financières. Elle sert à calculer l'intérêt couru pour un titre qui paie des intérêts périodiques. La syntaxe de la fonction INTERET.ACC est : INTERET.ACC(issue, first-interest, settlement, rate, [par], frequency[, [basis]]) où issue est la date d'émission du titre. first-interest est la date à laquelle le premier intérêt est payé. settlement est la date à laquelle le titre est acheté. rate est le taux de coupon annuel du titre. par est la valeur nominale du titre. C'est un argument facultatif. En cas d'omission, par est estimé à 1000$. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction INTERET.ACC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction INTERET.ACC, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/accrintm.htm", 
        "title": "Fonction INTERET.ACC.MAT", 
        "body": "La fonction INTERET.ACC.MAT est l'une des fonctions financières. Elle sert à calculer les intérêts courus pour un titre qui rapporte des intérêts à l'échéance. La syntaxe de la fonction INTERET.ACC.MAT est : INTERET.ACC.MAT(issue, settlement, rate, [[par] [, [basis]]]) où issue est la date d'émission du titre. settlement est la date d'échéance du titre. rate est le taux d'intérêt annuel du titre. par est la valeur nominale du titre. C'est un argument facultatif. En cas d'omission, par est estimé à 1000$. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction INTERET.ACC.MAT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction INTERET.ACC.MAT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/acos.htm", 
        "title": "Fonction ACOS", 
        "body": "La fonction ACOS est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer l'arccosinus d'un nombre. La syntaxe de la fonction ACOS est : ACOS(x) où x est le cosinus de l'angle, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ACOS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ACOS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/acosh.htm", 
        "title": "Fonction ACOSH", 
        "body": "La fonction ACOSH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le cosinus hyperbolique inversé d'un nombre. La syntaxe de la fonction ACOSH est : ACOSH(x) où x est una valeur numérique supérieure ou égale à 1 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ACOSH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ACOSH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/acot.htm", 
        "title": "Fonction ACOT", 
        "body": "La fonction ACOT est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la valeur principale de l'arccotangente, ou cotangente inverse, d'un nombre. L'angle renvoyé est mesuré en radians dans l'intervalle de 0 à Pi. La syntaxe de la fonction ACOT est : ACOT(x) où x est la cotangente de l'angle, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ACOT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ACOT, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/acoth.htm", 
        "title": "Fonction ACOTH", 
        "body": "La fonction ACOTH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la cotangente hyperbolique inverse d'un nombre. La syntaxe de la fonction ACOTH est : ACOTH(x) où x est une valeur numérique inférieure à -1 ou supérieure à 1 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ACOTH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ACOTH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/address.htm", 
        "title": "Fonction ADRESSE", 
        "body": "La fonction ADRESSE est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer une représentation textuelle de l'adresse d'une cellule. La syntaxe de la fonction ADRESSE est : ADRESSE(no_lig, no_col, [no_abs], [a1], [feuille_texte]) où no_lig est un numéro de ligne à utiliser dans une adresse de cellule. no_col est un numéro de colonne à utiliser dans une adresse de cellule. no_abs est un type de référence. Il peut s'agir de l'une des valeurs numériques suivantes : Valeur numérique Signification 1 ou omise Référencement absolu 2 Ligne absolue ; colonne relative 3 Ligne relative ; colonne absolue 4 Référencement relatif a1 est une valeur logique optionnelle : TRUE (VRAI) ou FALSE (FAUX). Si elle est définie sur TRUE (VRAI) ou omise, la fonction analysera ref-text comme une référence de style A1. Si elle est définie sur FALSE (FAUX), la fonction interprétera ref-text comme une référence de style R1C1. feuille_texte est le nom de la feuille à utiliser dans une adresse de cellule. C'est un argument facultatif. En cas d'omission, la fonction renvoie l'adresse de la cellule sans mentionner le nom de la feuille. Ces arguments peuvent être saisis à la main ou inclus dans les cellules auxquelles il est fait référence. Pour appliquer la fonction ADRESSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction ADRESSE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/aggregate.htm", 
        "title": "Fonction AGREGAT", 
        "body": "La fonction AGREGAT est l'une des fonctions mathématiques et trigonométriques. Cette fonction est utilisée pour renvoyer un agrégat dans une liste ou une base de données. La fonction AGREGAT peut appliquer différentes fonctions d'agrégat à une liste ou une base de données avec l'option d'ignorer les lignes cachées et les valeurs d'erreur. La syntaxe de la fonction AGREGAT est : AGREGAT(function_num, options, ref1 [, ref2], ...) où function_num est une valeur numérique qui spécifie quelle fonction utiliser. Les valeurs possibles sont listées dans le tableau ci-dessous. function_num Fonction 1 MOYENNE 2 NB 3 NBVAL 4 MAX 5 MIN 6 PRODUIT 7 ECARTYPE.STANDARD 8 ECARTYPE.PEARSON 9 SOMME 10 VAR.S 11 VAR.P.N 12 MEDIANE 13 MODE.SIMPLE 14 GRANDE.VALEUR 15 PETITE.VALEUR 16 CENTILE.INCLURE 17 QUARTILE.INCLURE 18 CENTILE.EXCLURE 19 QUARTILE.EXCLURE options est une valeur numérique qui spécifie quelles valeurs doivent être ignorées. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Comportement 0 ou omise Ignorer les fonctions SOUS.TOTAL et AGREGAT imbriquées 1 Ignorer les lignes cachées, les fonctions SOUS.TOTAL et AGREGAT imbriquées 2 Ignorer les valeurs d'erreur, les fonctions SOUS.TOTAL et AGREGAT imbriquées 3 Ignorer les lignes cachées, les valeurs d'erreur, les fonctions SOUS.TOTAL et AGREGAT imbriquées 4 Ne rien ignorer 5 Ignorer les lignes cachées 6 Ignorer les valeurs d'erreur 7 Ignorer les lignes cachées et les valeurs d'erreur ref1(2) est une liste de jusqu'à 253 valeurs numériques ou une référence à la plage de cellules contenant les valeurs pour lesquelles vous voulez la valeur agrégée. Remarque : si vous souhaitez utiliser l'une des fonctions suivantes : GRANDE.VALEUR, PETITE.VALEUR, CENTILE.INCLURE, QUARTILE.INCLURE, CENTILE.EXCLURE ou QUARTILE.EXCLURE, ref1 doit être une référence à la plage de cellules et ref2 doit être le deuxième argument requis pour ces fonctions (k ou quart). Fonction Syntaxe GRANDE.VALEUR GRANDE.VALEUR(matrice, k) PETITE.VALEUR PETITE.VALEUR(matrice, k) CENTILE.INCLURE CENTILE.INCLURE(matrice, k) QUARTILE.INCLURE QUARTILE.INCLURE(matrice, quart) CENTILE.EXCLURE CENTILE.EXCLURE(matrice, k) QUARTILE.EXCLURE QUARTILE.EXCLURE(matrice, quart) Pour appliquer la fonction AGREGAT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction AGREGAT, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. La figure ci-dessous affiche le résultat renvoyé par la fonction AGREGAT lorsque la fonction SOMME est appliquée. La figure ci-dessous affiche le résultat renvoyé par la fonction AGREGAT lorsque la fonction GRANDE.VALEUR est appliquée, ref1 est une référence à la plage de cellules et k est égal à 2. La fonction renvoie la deuxième plus grande valeur dans les cellules A1-A4."
    },
   {
        "id": "Functions/amordegrc.htm", 
        "title": "Fonction AMORDEGRC", 
        "body": "La fonction AMORDEGRC est l'une des fonctions financières. Elle est utilisée pour calculer la dépréciation d'un actif pour chaque période comptable en utilisant une méthode d'amortissement dégressif. La syntaxe de la fonction AMORDEGRC est : AMORDEGRC(cost, date-purchased, first-period, salvage, period, rate[, [basis]]) où cost est le coût de l'actif. date-purchased est la date à laquelle l'actif est acheté. first-period est la date à laquelle la première période se termine. salvage est la valeur de récupération de l'actif à la fin de sa durée de vie. period est la période pour laquelle vous souhaitez calculer l'amortissement. rate est le taux d'amortissement. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction AMORDEGRC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction AMORDEGRC, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/amorlinc.htm", 
        "title": "Fonction AMORLINC", 
        "body": "La fonction AMORLINC est l'une des fonctions financières. Il est utilisé pour calculer l'amortissement d'un actif pour chaque période comptable en utilisant une méthode d'amortissement linéaire. La syntaxe de la fonction AMORLINC est : AMORLINC(cost, date-purchased, first-period, salvage, period, rate[, [basis]]) où cost est le coût de l'actif. date-purchased est la date à laquelle l'actif est acheté. first-period est la date à laquelle la première période se termine. salvage est la valeur de récupération de l'actif à la fin de sa durée de vie. period est la période pour laquelle vous souhaitez calculer l'amortissement. rate est le taux d'amortissement. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction AMORLINC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction AMORLINC, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/and.htm", 
        "title": "Fonction ET", 
        "body": "La fonction ET est l'une des fonctions logiques. Elle sert à vérifier si la valeur logique saisie est vraie (TRUE) ou fausse (FALSE). La fonction retourne vrai (TRUE) si tous les arguments sont vrais (TRUE). La syntaxe de la fonction ET est : ET(logical1, logical2, ...) où logical1/2/n est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ET, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction ET, insérez les arguments requis en les séparant par des virgules,Remarque: vous pouvez insérer jusqu'à 265 valeurs logiques. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. La fonction retourne faux (FALSE) si au moins l'un des arguments est faux (FALSE). Par exemple : Il y a trois arguments : logical1 = A1&lt;100, logical2 = 34&lt;100, logical3 = 50&lt;100, où A1 est 12. Toutes ces expressions logiques sont vraies TRUE. Ainsi, la fonction renvoie vrai TRUE. Si nous remplaçons la valeur de A1 12 par 112, la fonction renvoie faux FALSE:"
    },
   {
        "id": "Functions/arabic.htm", 
        "title": "Fonction CHIFFRE.ARABE", 
        "body": "La fonction CHIFFRE.ARABE est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour convertir un chiffre romain en nombre. La syntaxe de la fonction CHIFFRE.ARABE est : CHIFFRE.ARABE(x) où x est une représentation textuelle d'un nombre romain : une chaîne entre guillemets ou une référence à une cellule contenant du texte. Remarque : si une chaîne vide (\"\") est utilisée comme argument, la fonction renvoie la valeur 0. Pour appliquer la fonction CHIFFRE.ARABE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction CHIFFRE.ARABE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/arraytotext.htm", 
        "title": "Fonction TABLEAU.EN.TEXTE", 
        "body": "La fonction TABLEAU.EN.TEXTE appartient aux fonctions de données et texte. Cette fonction permet de renvoyer et convertir une plage de données en texte. Le syntaxe de la fonction TABLEAU.EN.TEXTE: =TABLEAU.EN.TEXTE(tableau, [format]) où: tableau est la plage de cellules à renvoyer sous forme de texte, [format] est un argument facultatif. Les valeurs disponibles: 0 sert à séparer les valeurs par une virgule dans la chaîne texte (valeur par défaut), 1 sert à placer chaque valeur entre guillemets doubles (sauf des nombres, des valeurs vrai/faux et des erreurs), utiliser le point-virgule en tant que délimiteur et place la chaîne de texte entière entre accolades. Pour appliquer la fonction TABLEAU.EN.TEXTE, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions de Données et texte depuis la liste, cliquez sur la fonction TABLEAU.EN.TEXTE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/asc.htm", 
        "title": "Fonction ASC", 
        "body": "La fonction ASC est l'une des fonctions de texte et de données. Permet de changer les caractères pleine largeur (double octet) en caractères demi-largeur (simple octet) pour les langues qui utilisent le jeu de caractères double octet (DBCS) comme le japonais, le chinois, le coréen etc. La syntaxe de la fonction ASC est : ASC(texte) où texte est une valeur de texte saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Si le texte ne contient pas de caractères pleine largeur, il reste inchangé. Pour appliquer la fonction ASC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction ASC, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/asin.htm", 
        "title": "Fonction ASIN", 
        "body": "La fonction ASIN est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer l'arcsinus d'un nombre. La syntaxe de la fonction ASIN est : ASIN(x) où x est le sinus de l'angle, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ASIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ASIN, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/asinh.htm", 
        "title": "Fonction ASINH", 
        "body": "La fonction ASINH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le sinus hyperbolique inverse d'un nombre. La syntaxe de la fonction ASINH est : ASINH(x) où x est une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ASINH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ASINH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/atan.htm", 
        "title": "Fonction ATAN", 
        "body": "La fonction ATAN est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer l'arctangente d'un nombre. La syntaxe de la fonction ATAN est : ATAN(x) où x est la tangente de l'angle, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ATAN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ATAN, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/atan2.htm", 
        "title": "Fonction ATAN2", 
        "body": "La fonction ATAN2 est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer l’arctangente des coordonnées x et y. La syntaxe de la fonction ATAN2 est : ATAN2(x, y) où x et y sont les coordonnées sur l'axe des x et des y, des valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction ATAN2, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ATAN2, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/atanh.htm", 
        "title": "Fonction ATANH", 
        "body": "La fonction ATANH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la tangente hyperbolique inverse d'un nombre. La syntaxe de la fonction ATANH est : ATANH(x) où x est una valeur numérique supérieure à - 1 mais inférieure à 1 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ATANH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ATANH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/avedev.htm", 
        "title": "Fonction ECART.MOYEN", 
        "body": "La fonction ECART.MOYEN est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer la moyenne des écarts absolus des nombres de leur moyenne. La syntaxe de la fonction ECART.MOYEN est : ECART.MOYEN(argument-list) où argument-list est une liste contenant jusqu'à 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est référence. Pour appliquer la fonction ECART.MOYEN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction ECART.MOYEN, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/average.htm", 
        "title": "Fonction MOYENNE", 
        "body": "La fonction MOYENNE est l'une des fonctions statistiques. Elle est utilisée pour analyser la plage de données et trouver la valeur moyenne. La syntaxe de la fonction MOYENNE est : MOYENNE(argument-list) où argument-list est une liste contenant jusqu'à 255 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Comment faire une MOYENNE Pour appliquer la fonction MOYENNE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MOYENNE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/averagea.htm", 
        "title": "Fonction AVERAGEA", 
        "body": "La fonction AVERAGEA est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données y compris du texte et des valeurs logiques et trouver la moyenne. La fonction AVERAGEA considère le texte et FALSE (FAUX) comme 0 et TRUE (VRAI) comme 1. La syntaxe de la fonction AVERAGEA est : AVERAGEA(argument-list) où argumenti-list est une liste contenant jusqu'à 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction AVERAGEA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction AVERAGEA, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/averageif.htm", 
        "title": "Fonction MOYENNE.SI - ONLYOFFICE", 
        "body": "Fonction MOYENNE.SI La fonction MOYENNE.SI est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et trouver la moyenne de tous les nombres dans une plage de cellules à la base du critère spécifié. La syntaxe de la fonction MOYENNE.SI est : MOYENNE.SI(cell-range, selection-criteria [,average-range]) où cell-range est une plage de cellules à laquelle on applique le critère. selection-criteria est le critère à appliquer, une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. average-range est la plage de cellule dont la moyenne vous souhaitez trouver. Remarque : average-range est un argument facultatif. S'il est omis, la fonction trouve la moyenne dans la cell-range. Comment faire formule MOYENNE.SI Pour appliquer la fonction MOYENNE.SI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MOYENNE.SI, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/averageifs.htm", 
        "title": "Fonction MOYENNE.SI.ENS", 
        "body": "La fonction MOYENNE.SI.ENS est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et trouver la moyenne de tous les nombres dans une plage de cellules en fonction de plusieurs critères. La syntaxe de la fonction MOYENNE.SI.ENS est : MOYENNE.SI.ENS(average-range, criteria-range-1, criteria-1, [criteria-range-2, criteria-2],...) où average-range est la plage de cellule dont vous souhaitez trouver la moyenne. criteria-range-1 est la première plage de cellules à laquelle on applique le critère criteria-1. C'est un argument obligatoire. criteria-1 est la première condition à remplir. Il est appliqué à la plage criteria-range-1 et utilisé pour déterminer les cellules de average-range dont on veut trouver la moyenne. Sa valeur peut être saisie à la main ou incluse dans la cellule à laquelle il est fait référence. C'est un argument obligatoire. criteria-range-2, criteria-2, ...sont des plages supplémentaires de cellules et leurs critères correspondants. Ces arguments sont facultatifs. Vous pouvez entrer jusqu'à 127 plages de cellules et critères correspondants. Remarque: vous pouvez utiliser des caractères génériques lorsque vous spécifiez des critères. Le point d'interrogation \" ? \" peut remplacer n'importe quel caractère et l'astérisque \" * \" peut être utilisé à la place de n'importe quel nombre de caractères. Comment faire une MOYENNE.SI.ENS Pour appliquer la fonction MOYENNE.SI.ENS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MOYENNE.SI.ENS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/base.htm", 
        "title": "Fonction BASE", 
        "body": "La fonction BASE est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour convertir un nombre en une représentation de texte avec la base donnée. La syntaxe de la fonction BASE est : BASE(number, base[, min-lenght]) où number est le nombre qui doit être converti. Une valeur entière supérieure ou égale à 0 mais inférieure à 2^53. base représente la base dans laquelle vous voulez effectuer la conversion. Une valeur entière supérieure ou égale à 2 mais inférieure ou égale à 36. min-lenght est la longueur minimale du texte renvoyé. Une valeur entière supérieure ou égale à 0 et inférieure à 256. C'est un paramètre optionnel. Si le résultat est plus petit que la longueurs minimale spécifiée, des zéros sont rajoutés au début de la chaine de caractères. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction BASE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction BASE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/besseli.htm", 
        "title": "Fonction BESSELI", 
        "body": "La fonction BESSELI est l'une des fonctions d'ingénierie. Elle est utilisée pour retourner la fonction de Bessel modifiée, qui est équivalente a la fonction de Bessel évaluée pour des arguments purement imaginaires. La syntaxe de la fonction BESSELI est : BESSELI(X, N) où X est la valeur pour laquelle vous voulez évaluer la fonction, N est l'ordre de la fonction de Bessel, une valeur numérique supérieure ou égale à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction BESSELI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BESSELI, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/besselj.htm", 
        "title": "Fonction BESSELJ", 
        "body": "La fonction BESSELJ est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la fonction de Bessel. La syntaxe de la fonction BESSELJ est : BESSELJ(X, N) où X est la valeur pour laquelle vous voulez évaluer la fonction, N est l'ordre de la fonction de Bessel, une valeur numérique supérieure ou égale à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction BESSELJ, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BESSELJ, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/besselk.htm", 
        "title": "Fonction BESSELK", 
        "body": "La fonction BESSELK est l'une des fonctions d'ingénierie. Elle est utilisée pour retourner la fonction de Bessel modifiée, qui est équivalente aux fonctions de Bessel évaluées pour des arguments purement imaginaires. La syntaxe de la fonction BESSELK est : BESSELK(X, N) où X est la valeur pour laquelle vous voulez évaluer la fonction, une valeur numérique supérieure 0. N est l'ordre de la fonction de Bessel, une valeur numérique supérieure ou égale à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction BESSELK, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BESSELK, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/bessely.htm", 
        "title": "Fonction BESSELY", 
        "body": "La fonction BESSELY est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la fonction de Bessel, également appelée fonction de Weber ou fonction de Neumann. La syntaxe de la fonction BESSELY est : BESSELY(X, N) où X est la valeur pour laquelle vous voulez évaluer la fonction, une valeur numérique supérieure 0. N est l'ordre de la fonction de Bessel, une valeur numérique supérieure ou égale à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction BESSELY, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BESSELY, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/beta-dist.htm", 
        "title": "Fonction LOI.BETA.N", 
        "body": "La fonction LOI.BETA.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la distribution bêta. La syntaxe de la fonction LOI.BETA.N est : LOI.BETA.N(x, alpha, beta, cumulative, [,[A] [,[B]]) où x est la valeur entre A et B pour laquelle la fonction doit être calculée. alpha est le premier paramètre de la distribution, une valeur numérique supérieure à 0. est le second paramètre de la distribution, une valeur numérique supérieure à 0. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de densité de probabilité. A est la limite inférieure de l'intervalle de x. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 0 est utilisée. B est la limite supérieure de l'intervalle de x. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 1 est utilisée. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.BETA.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.BETA.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/beta-inv.htm", 
        "title": "Fonction BETA.INVERSE.N", 
        "body": "La fonction BETA.INVERSE.N est l'une des fonctions statistiques. Elle est utilisée pour retourner l'inverse de la fonction de densité de probabilité cumulative bêta (BETA.DIST). La syntaxe de la fonction BETA.INVERSE.N est : BETA.INVERSE.N(probability, alpha, beta, [,[A] [,[B]]) où probability est la probabilité associée à la distribution beta. Une valeur numérique supérieure à 0 mais inférieure ou égale à 1. alpha est le premier paramètre de la distribution, une valeur numérique supérieure à 0. beta est le second paramètre de la distribution, une valeur numérique supérieure à 0. A est la limite inférieure de l'intervalle de x. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 0 est utilisée. B est la limite supérieure de l'intervalle de x. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 1 est utilisée. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction BETA.INVERSE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction BETA.INVERSE.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/betadist.htm", 
        "title": "Fonction LOI.BETA", 
        "body": "La fonction LOI.BETA est l'une des fonctions statistiques. Elle est utilisée pour retourner la fonction de densité de probabilité bêta cumulative. La syntaxe de la fonction LOI.BETA est : LOI.BETA(x, alpha, beta, [,[A] [,[B]]) où x est la valeur entre A et B pour laquelle la fonction doit être calculée. alpha est le premier paramètre de la distribution, une valeur numérique supérieure à 0. beta est le second paramètre de la distribution, une valeur numérique supérieure à 0. A est la limite inférieure de l'intervalle de x. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 0 est utilisée. B est la limite supérieure de l'intervalle de x. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 1 est utilisée. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.BETA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.BETA, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/betainv.htm", 
        "title": "Fonction BETA.INVERSE", 
        "body": "La fonction BETA.INVERSE est l'une des fonctions statistiques. Elle est utilisée pour retourner l'inverse de la fonction de densité de probabilité bêta cumulative pour une distribution bêta donnée. La syntaxe de la fonction BETA.INVERSE est : BETA.INVERSE(x;alpha;bêta;[A];[B]) où x est une probabilité associée à la distribution bêta. Une valeur numérique supérieure à 0 mais inférieure ou égale à 1. alpha est le premier paramètre de la distribution, une valeur numérique supérieure à 0. beta est le second paramètre de la distribution, une valeur numérique supérieure à 0. A est la limite inférieure de l'intervalle de x. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 0 est utilisée. B est la limite supérieure de l'intervalle de x. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 1 est utilisée. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction BETA.INVERSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction BETA.INVERSE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/bin2dec.htm", 
        "title": "Fonction BINDEC", 
        "body": "La fonction BINDEC est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre binaire en un nombre décimal. La syntaxe de la fonction BINDEC est : BINDEC(number) où number est un nombre binaire entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Remarque : si l'argument n'est pas reconnu comme un nombre binaire, ou contient plus de 10 caractères, la fonction retournera l'erreur #NOMBRE!. Pour appliquer la fonction BINDEC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BINDEC, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/bin2hex.htm", 
        "title": "Fonction BINHEX", 
        "body": "La fonction BINHEX est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre binaire en un nombre hexadécimal. La syntaxe de la fonction BINHEX est : BINHEX(number [, num-hex-digits]) où number est une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. num-hex-digits est le nombre de chiffres à afficher. Si omis, la fonction utilisera le nombre minimum. Remarque : si l'argument n'est pas reconnu comme un nombre binaire ou contient plus de 10 caractères, ou si le nombre hexadécimal obtenu nécessite plus de chiffres que vous avez spécifié, ou si le nombre num-hex-digits spécifié est inférieur ou égal à 0, le La fonction retournera l'erreur #NOMBRE!. Pour appliquer la fonction BINHEX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BINHEX, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/bin2oct.htm", 
        "title": "Fonction BINOCT", 
        "body": "La fonction BINOCT est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre binaire en un nombre octal. La syntaxe de la fonction BINOCT est : BINOCT(number [, num-hex-digits]) où number est un nombre binaire entré manuellement ou inclus dans la cellule à laquelle il est fait référence. num-hex-digits est le nombre de chiffres à afficher. Si omis, la fonction utilisera le nombre minimum. Remarque : si l'argument n'est pas reconnu comme un nombre binaire ou contient plus de 10 caractères, ou si le nombre octal obtenu nécessite plus de chiffres que vous avez spécifié, ou si le nombre num-hex-digits spécifié est inférieur ou égal à 0, le La fonction retournera l'erreur #NUM!. Pour appliquer la fonction BINOCT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BINOCT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/binom-dist-range.htm", 
        "title": "Fonction LOI.BINOMIALE.SERIE", 
        "body": "La fonction LOI.BINOMIALE.SERIE est l'une des fonctions statistiques. Elle est utilisée pour retourner la probabilité d'un résultat d'essai en utilisant une distribution binomiale. La syntaxe de la fonction LOI.BINOMIALE.SERIE est : LOI.BINOMIALE.SERIE(trials, probability-s, number-s [, number-s2]) où trials est le nombre d'essais, une valeur numérique supérieure ou égale à number-s. probability-s est la probabilité du succès de chaque essai, une valeur numérique supérieure ou égale à 0 mais inférieure ou égale à 1. number-s est le nombre minimal de suсcès pour les essais pour lesquels vous voulez calculer la probabilité, une valeur numérique supérieure ou égale à 0. number-s2 est un argument optionnel. Le nombre maximum de succès dans les essais pour lesquels vous voulez calculer la probabilité, une valeur numérique supérieure à number-s et inférieure ou égale à trials. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.BINOMIALE.SERIE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.BINOMIALE.SERIE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/binom-dist.htm", 
        "title": "Fonction LOI.BINOMIALE.N", 
        "body": "La fonction LOI.BINOMIALE.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la probabilité d'une variable aléatoire discrète suivant la loi binomiale. La syntaxe de la fonction LOI.BINOMIALE.N est : LOI.BINOMIALE.N(number-s, trials, probability-s, cumulative) où number-s est le nombre de suсcès des évaluations, une valeur numérique supérieure ou égale à 0. trials est le nombre d'essais, une valeur numérique supérieure ou égale à number-s. probability-s est la probabilité du succès de chaque essai, une valeur numérique supérieure ou égale à 0 mais inférieure ou égale à 1. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de probabilité de masse. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.BINOMIALE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.BINOMIALE.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/binom-inv.htm", 
        "title": "Fonction LOI.BINOMIALE.INVERSE", 
        "body": "La fonction LOI.BINOMIALE.INVERSE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la plus petite valeur pour laquelle la distribution binomiale cumulative est supérieure ou égale à une valeur de critère. La syntaxe de la fonction LOI.BINOMIALE.INVERSE est : LOI.BINOMIALE.INVERSE(trials, probability-s, alpha) où trials est le nombre d'essais, une valeur numérique supérieure à 0. probability-s est la probabilité de succès de chaque évaluation, une valeur numérique supérieure à 0, mais inférieure à 1. alpha est le critère, une valeur numérique supérieure à 0 mais inférieure à 1. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.BINOMIALE.INVERSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.BINOMIALE.INVERSE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/binomdist.htm", 
        "title": "Fonction LOI.BINOMIALE", 
        "body": "La fonction LOI.BINOMIALE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la probabilité d'une variable aléatoire discrète suivant la loi binomiale. La syntaxe de la fonction LOI.BINOMIALE est : LOI.BINOMIALE(number-successes, number-trials, success-probability, cumulative-flag) où number-successes est le nombre de suсcès des évaluations, une valeur numérique supérieure ou égale à 0. number-trials est le nombre d'évaluations, une valeur numériaue supérieure ou égale à number-successes. success-probability est la probabilité du succès de chaque évaluation, une valeur numérique supérieure ou égale à 0 mais inférieure ou égale à 1. cumulative-flag est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de probabilité de masse. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.BINOMIALE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.BINOMIALE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/bitand.htm", 
        "title": "Fonction BITET", 
        "body": "La fonction BITET est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le ET bit-à-bit de deux nombres. La syntaxe de la fonction BITET est : BITET(number1, number2) où number1 est une valeur numérique sous forme décimale supérieure ou égale à 0, number2 est une valeur numérique sous forme décimale supérieure ou égale à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. La valeur de chaque position de bit n'est comptée que si les bits des deux paramètres à cette position sont 1. Pour appliquer la fonction BITET, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BITET, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/bitlshift.htm", 
        "title": "Fonction BITDECALG", 
        "body": "La fonction BITDECALG est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer un nombre décalé à gauche du nombre de bits spécifié. La syntaxe de la fonction BITDECALG est : BITDECALG(number, shift_amount) où number est un nombre entier supérieur ou égal à 0, shift_amount est un nombre de bits par lequel vous voulez décaler number, un nombre entier. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Décaler un nombre à gauche équivaut à ajouter des zéros(0) à droite de la représentation binaire du nombre. Pour appliquer la fonction BITDECALG, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BITDECALG, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/bitor.htm", 
        "title": "Fonction BITOU", 
        "body": "La fonction BITOU est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le OU bit-à-bit de deux nombres. La syntaxe de la fonction BITOU est : BITOU(number1, number2) où number1 est une valeur numérique sous forme décimale supérieure ou égale à 0, number2 est une valeur numérique sous forme décimale supérieure ou égale à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. La valeur de chaque position de bit est comptée si l'un des paramètres a 1 à cette position. Pour appliquer la fonction BITOU, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BITOU, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/bitrshift.htm", 
        "title": "Fonction BITDECALD", 
        "body": "La fonction BITDECALD est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer un nombre décalé à droite du nombre de bits spécifié. La syntaxe de la fonction BITDECALD est : BITDECALD(number, shift_amount) où number est un nombre entier supérieur ou égal à 0, shift_amount est un nombre de bits par lequel vous voulez décaler number, un nombre entier. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Décaler un nombre à droite équivaut à retirer des chiffres à droite de la représentation binaire du nombre. Pour appliquer la fonction BITDECALD, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BITDECALD, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/bitxor.htm", 
        "title": "Fonction BITOUEXCLUSIF", 
        "body": "La fonction BITOUEXCLUSIF est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le OU exclusif bit-à-bit de deux nombres. La syntaxe de la fonction BITOUEXCLUSIF est : BITOUEXCLUSIF(number1, number2) où number1 est une valeur numérique sous forme décimale supérieure ou égale à 0, number2 est une valeur numérique sous forme décimale supérieure ou égale à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. La valeur de chaque position de bit est 1 lorsque les positions des bits des paramètres sont différentes. Pour appliquer la fonction BITOUEXCLUSIF, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction BITOUEXCLUSIF, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ceiling-math.htm", 
        "title": "Fonction PLAFOND.MATH", 
        "body": "La fonction PLAFOND.MATH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir le nombre à l'excès à l'entier ou au multiple significatif le plus proche. La syntaxe de la fonction PLAFOND.MATH est : PLAFOND.MATH(x [, [précision] [, [mode]]) où x est le nombre à arrondir. précision est le multiple significatif auquel le nombre doit être arrondi. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 1 est utilisée. mode définit si les nombres négatifs sont arrondis vers ou à partir de zéro. C'est un paramètre facultatif qui n'affecte pas les nombres positifs. Si la valeur est omise ou définie à 0, les nombres négatifs sont arrondis vers zéro. Si une autre valeur numérique est spécifiée, les nombres négatifs sont arrondis à partir de zéro. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PLAFOND.MATH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PLAFOND.MATH, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ceiling-precise.htm", 
        "title": "Fonction PLAFOND.PRECIS", 
        "body": "La fonction PLAFOND.PRECIS est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir le nombre à l'excès à l'entier ou au multiple significatif le plus proche. Le nombre est toujours arrondi à l'excès indépendamment de son signe. La syntaxe de la fonction PLAFOND.PRECIS est : PLAFOND.PRECIS(x [, précision]) où x est le nombre à arrondir. précision est le multiple significatif auquel le nombre doit être arrondi. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 1 est utilisée. Si elle est définie sur 0, la fonction renvoie 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PLAFOND.PRECIS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PLAFOND.PRECIS, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ceiling.htm", 
        "title": "Fonction PLAFOND", 
        "body": "La fonction PLAFOND est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir le nombre au multiple le plus proche de l'argument de précision. La syntaxe de la fonction PLAFOND est : PLAFOND(x, précision) où x est le nombre que vous souhaitez arrondir, précision multiple de l'argument précision auquel vous souhaitez arrondir, Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : si x et précision ont des signes différents, la fonction renvoie l'erreur #NOMBRE!. Pour appliquer la fonction PLAFOND, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PLAFOND, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/cell.htm", 
        "title": "La fonction CELLULE", 
        "body": "La fonction CELLULE est l'une des fonctions d'information. Cette fonction renvoie des informations sur la mise en forme, l’emplacement ou le contenu d’une cellule. La syntaxe de la fonction CELLULE est comme suit: CELLULE (info_type, [référence]) où: info_type est la valeur de texte qui spécifie quel type d'information est renvoyé. C'est un argument obligatoire. Les valeurs disponibles sont présentées dans le tableau ci-dessous. [référence] identifie la cellule sur laquelle vous souhaitez des informations. Si vous omettez cet argument, la fonction renvoie les informations pour la dernière cellule modifiée. Si l’argument référence est une plage de cellules, la fonction renvoie les informations de la cellule supérieur gauche de la plage sélectionnée. Les valeurs de texte Le type d'information \"adresse\" Renvoie la référence pour la cellule. \"col\" Renvoie le numéro de colonne de la cellule. \"couleur\" Renvoie 1 si la cellule est formatée en couleur pour les valeurs négatives; sinon renvoie 0. \"contenus\" Renvoi la valeur de la cellule. \"nomfichier\" Renvoie le nom du fichier qui contient une référence. \"format\" Renvoie une valeur de texte correspondant au format numérique de la cellule. Les valeurs pour les différents formats sont présentées dans le tableau ci-dessous. \"parenthèses\" Renvoie 1 si la cellule est mise en forme avec des parenthèses pour toutes les valeurs; sinon renvoie 0. \"prefix\" Renvoie un guillemet simple (') si la cellule contient du texte aligné à gauche, un guillemet double (\") si la cellule contient du texte aligné à droite, un caret (^) si la cellule contient du texte centré, et une cha&icirc;ne vide (\"\") si la cellule contient autre chose. \"protéger\" Renvoi 0 si la cellule n'est pas verrouillée et 1 si la cellule est verrouillée. \"ligne\" Renvoie le numéro de la ligne de la cellule. \"type\" Renvoie \"b\" si la cellule est vide, \"l\" si la cellule contient une valeur de texte et \"v\" si la cellule contient un autre type de données. \"largeur\" Renvoie la largeur de la cellule, arrondie à un entier. Le tableau ci-dessous affiche les valeurs de texte que la fonction renvoie lorsque l’argument est \"format\". Format numérique La valeur que la fonction renvoie Général G 0 F0 #,##0 ,0 0.00 F2 #,##0.00 ,2 $#,##0_);($#,##0) C0 $#,##0_);[Rouge]($#,##0) C0- $#,##0.00_);($#,##0.00) C2 $#,##0.00_);[Rouge]($#,##0.00) C2- 0% P0 0,00% P2 0.00E+00 S2 # ?/? ou # ??/?? G m/j/aa ou m/j/aa h:mm ou mm/jj/aa D4 j-mmm-aa ou jj-mmm-aa D1 j-mmm ou jj-mmm D2 mmm-aa D3 mm/jj D5 h:mm AM/PM D7 h:mm:ss AM/PM D6 h:mm D9 h:mm:ss D8 Pour utiliser la fonction CELLULE, sélectionnez la cellule où vous voulez afficher le résultat, appuyez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Information dans la liste, appuyez sur la fonction CELLULE, saisissez l'argument approprié et appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/char.htm", 
        "title": "Fonction CAR", 
        "body": "La focntion CAR est l'une des fonctions de texte et de données. Elle est utilisée pour renvoyer le caractère ASCII déterminé par un nombre. La syntaxe de la fonction CAR est : CAR(number) où number (de 1 à 255) est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction CAR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction CAR, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/chidist.htm", 
        "title": "Fonction LOI.KHIDEUX", 
        "body": "La fonction LOI.KHIDEUX est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la probabilité à droite de la distribution du khi-carré. La syntaxe de la fonction LOI.KHIDEUX est : LOI.KHIDEUX(x, deg-freedom) où x est la valeur pour laquelle vous voulez calculer la distribution du khi-carré. Une valeur numérique supérieure ou égale à 0. deg-freedom est le nombre de degrés de liberté. Une valeur numérique supérieure ou égale à 1 mais inférieure ou égale à 10^10. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.KHIDEUX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.KHIDEUX, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/chiinv.htm", 
        "title": "Fonction KHIDEUX.INVERSE", 
        "body": "La fonction KHIDEUX.INVERSE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la probabilité à droite de la distribution du khi-carré. La syntaxe de la fonction KHIDEUX.INVERSE est : KHIDEUX.INVERSE(probability, deg-freedom) où probability est la probabilité associée à la distribution du khi-carré. Une valeur numérique supérieure à 0 et inférieure à 1. deg-freedom est le nombre de degrés de liberté. Une valeur numérique supérieure ou égale à 1 mais inférieure ou égale à 10^10. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction KHIDEUX.INVERSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction KHIDEUX.INVERSE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/chisq-dist-rt.htm", 
        "title": "Fonction LOI.KHIDEUX.DROITE", 
        "body": "La fonction LOI.KHIDEUX.DROITE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la probabilité à droite de la distribution du khi-carré. La syntaxe de la fonction LOI.KHIDEUX.DROITE est : LOI.KHIDEUX.DROITE(x, deg-freedom) où x est la valeur pour laquelle vous voulez calculer la distribution du khi-carré. Une valeur numérique supérieure ou égale à 0. deg-freedom est le nombre de degrés de liberté. Une valeur numérique supérieure ou égale à 1 mais inférieure ou égale à 10^10. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.KHIDEUX.DROITE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.KHIDEUX.DROITE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/chisq-dist.htm", 
        "title": "Fonction LOI.KHIDEUX.N", 
        "body": "La fonction LOI.KHIDEUX.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la distribution du khi-carré. La syntaxe de la fonction LOI.KHIDEUX.N est : LOI.KHIDEUX.N(x, deg-freedom, cumulative) où x est la valeur pour laquelle vous voulez calculer la distribution du khi-carré. Une valeur numérique supérieure ou égale à 0. deg-freedom est le nombre de degrés de liberté. Une valeur numérique supérieure ou égale à 1 mais inférieure ou égale à 10^10. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de densité de probabilité. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.KHIDEUX.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.KHIDEUX.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/chisq-inv-rt.htm", 
        "title": "Fonction LOI.KHIDEUX.INVERSE.DROITE", 
        "body": "La fonction LOI.KHIDEUX.INVERSE.DROITE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la probabilité à droite de la distribution du khi-carré. La syntaxe de la fonction LOI.KHIDEUX.INVERSE.DROITE est : LOI.KHIDEUX.INVERSE.DROITE(probability, deg-freedom) où probability est la probabilité associée à la distribution du khi-carré. Une valeur numérique supérieure à 0 et inférieure à 1. deg-freedom est le nombre de degrés de liberté. Une valeur numérique supérieure ou égale à 1 mais inférieure ou égale à 10^10. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.KHIDEUX.INVERSE.DROITE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.KHIDEUX.INVERSE.DROITE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/chisq-inv.htm", 
        "title": "Fonction LOI.KHIDEUX.INVERSE", 
        "body": "La fonction LOI.KHIDEUX.INVERSE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la probabilité à gauche de la distribution du khi-carré. La syntaxe de la fonction LOI.KHIDEUX.INVERSE est : LOI.KHIDEUX.INVERSE(probability, deg-freedom) où probability est la probabilité associée à la distribution du khi-carré. Une valeur numérique supérieure à 0 et inférieure à 1. deg-freedom est le nombre de degrés de liberté. Une valeur numérique supérieure ou égale à 1 mais inférieure ou égale à 10^10. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.KHIDEUX.INVERSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.KHIDEUX.INVERSE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/chisq-test.htm", 
        "title": "Fonction CHISQ.TEST", 
        "body": "La fonction CHISQ.TEST est l'une des fonctions statistiques. Il est utilisé pour retourner le test d'indépendance, la valeur de la distribution du khi-deux (χ2) pour la statistique et les degrés de liberté appropriés. La syntaxe de la fonction CHISQ.TEST est : CHISQ.TEST(actual-range, expected-range) où actual-range est la plage des valeurs observées (réelles). expected-range est la plage des valeurs attendues. Les plages doivent contenir le même nombre de valeurs. Chacune des valeurs attendues doit être supérieure ou égale à 5. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction CHISQ.TEST, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction CHISQ.TEST, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/chitest.htm", 
        "title": "Fonction TEST.KHIDEUX", 
        "body": "La fonction TEST.KHIDEUX est l'une des fonctions statistiques. Il est utilisé pour retourner le test d'indépendance, la valeur de la distribution du khi-deux (χ2) pour la statistique et les degrés de liberté appropriés. La syntaxe de la fonction TEST.KHIDEUX est : TEST.KHIDEUX(actual-range, expected-range) où actual-range est la plage des valeurs observées (réelles). expected-range est la plage des valeurs attendues. Les plages doivent contenir le même nombre de valeurs. Chacune des valeurs attendues doit être supérieure ou égale à 5. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TEST.KHIDEUX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction TEST.KHIDEUX, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/choose.htm", 
        "title": "Fonction CHOISIR", 
        "body": "La fonction CHOISIR est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer une valeur à partir d'une liste de valeurs à la base d'un indice spécifié (position). La syntaxe de la fonction CHOISIR est : CHOISIR(index, argument-list) où index est la position d'une valeur dans argument-list, une valeur numérique supérieure ou égale à 1 mais inférieure au nombre de valeurs dans argument-list, argument-list est la liste des valeurs ou la plage de cellules sélectionnée que vous voulez analyser. Pour appliquer la fonction CHOISIR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction CHOISIR, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/choosecols.htm", 
        "title": "Fonction CHOISIRCOLS", 
        "body": "La fonction CHOISIRCOLS est l'une des fonctions de recherche et de référence. Cette fonction renvoie les colonnes à partir d'une matrice ou d'une référence. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction CHOISIRCOLS: =CHOISIRCOLS(tableau,col_num1, [col_num2],...) où: tableau sert à définir le tableau contenant les colonnes à retourner dans le nouveau tableau. col_num1 sert à définir la première colonne à retourner. col_num2 est un argument facultatif. Sert à définir des colonnes supplémentaires à retourner. Pour appliquer la fonction CHOISIRCOLS, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction CHOISIRCOLS, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/chooserows.htm", 
        "title": "Fonction CHOISIRLIGNES", 
        "body": "La fonction CHOISIRLIGNES est l'une des fonctions de recherche et de référence. Cette fonction renvoie les lignes à partir d'une matrice ou d'une référence. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction CHOISIRLIGNES: =CHOISIRLIGNES(tableau,ligne_num1,[ligne_num2],...) où: tableau sert à définir le tableau contenant les lignes à retourner dans le nouveau tableau. ligne_num1 sert à définir la première ligne à retourner. ligne_num2 est un argument facultatif. Sert à définir des lignes supplémentaires à retourner. Pour appliquer la fonction CHOISIRLIGNES, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction CHOISIRLIGNES, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/clean.htm", 
        "title": "Fonction EPURAGE", 
        "body": "La focntion EPURAGE est l'une des fonctions de texte et de données. Elle est utilisée pour supprimer tous les caractères de contrôle d'une chaîne sélectionnée. La syntaxe de la fonction EPURAGE est : EPURAGE(string) où string est une chaîne avec des caractères de contrôle à supprimer, incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction EPURAGE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction EPURAGE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/code.htm", 
        "title": "Fonction CODE", 
        "body": "La focntion CODE est l'une des fonctions de texte et de données. Elle est utilisée pour renvoyer la valeur ASCII d'un caractère déterminé ou d'un premier caractère dans la cellule. La syntaxe de la fonction CODE est : CODE(string) où string est une chaîne de caractères saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction CODE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction CODE, saisissez l'argument requis,Remarque: la fonction CODE respecte la casse. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/column.htm", 
        "title": "Fonction COLONNE", 
        "body": "La fonction COLONNE est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer le numéro de colonne d'une cellule. La syntaxe de la fonction COLONNE est : COLONNE([reference]) où reference est une référence à une cellule. Remarque : reference is an optional argument. En cas d'omission, la fonction renvoie le numéro de colonne d'une cellule sélectionnée pour afficher le résultat de la fonction COLONNE. Pour appliquer la fonction COLONNE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction COLONNE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/columns.htm", 
        "title": "Fonction COLONNES", 
        "body": "La fonction COLONNES est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer le nombre de colonnes dans une référence de cellule. La syntaxe de la fonction COLONNES est : COLONNES(array) où array est une référence à une plage de cellules. Pour appliquer la fonction COLONNES, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction COLONNES, sélectionnez une plage de cellules avec la souris ou insérez la à la main comme suit A1:B2, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/combin.htm", 
        "title": "Fonction COMBIN", 
        "body": "La fonction COMBIN est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le nombre de combinaisons pour un certain nombre d'éléments. La syntaxe de la fonction COMBIN est : COMBIN(number, number-chosen) où number est un nombre d'éléments, une valeur numérique supérieure ou égale à 0. number-chosen est un nombre d'éléments dans une combinaison, une valeur numérique supérieure ou égale à 0 mais inférieure à number. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction COMBIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction COMBIN, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/combina.htm", 
        "title": "Fonction COMBINA", 
        "body": "La fonction COMBINA est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le nombre de combinaisons(avec répétitions) pour un certain nombre d'éléments. La syntaxe de la fonction COMBINA est : COMBINA(number, number-chosen) où number est le nombre total d'éléments, une valeur numérique supérieure ou égale à 0. number-chosen est un nombre d'éléments dans une combinaison, une valeur numérique supérieure ou égale à 0 mais inférieure à number. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction COMBINA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction COMBINA, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/complex.htm", 
        "title": "Fonction COMPLEXE", 
        "body": "La fonction COMPLEXE est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir une partie réelle et une partie imaginaire en un nombre complexe exprimé sous la forme a+ bi ou a + bj. La syntaxe de la fonction COMPLEXE est : COMPLEXE(real-number, imaginary-number [, suffix]) où real-number est la partie réelle du nombre complexe. imaginary-number est la partie imaginaire du nombre complexe. suffix est un indicateur de la partie imaginaire du nombre complexe. Il peut être \"i\" ou \"j\" en minuscules. C'est un argument facultatif. En cas d'omission, la fonction suppose que suffix est \"i\". Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction COMPLEXE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/concat.htm", 
        "title": "Fonction CONCAT", 
        "body": "La fonction CONCAT est l'une des fonctions de texte et de données. Elle est utilisée pour combiner les données de deux ou plusieurs cellules en une seule. Cette fonction remplace la fonction CONCATENATE. La syntaxe de la fonction CONCAT est : CONCAT(text1, text2, ...) où text1(2) ce sont des données jusqu'à 256 valeurs saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction CONCAT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction CONCAT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Par exemple : Il y a trois arguments : text1 = A1 (John), text2 = \" \" (espace), text3 = B1 (Adams). La fonction va combiner le premier et le dernier nom dans une cellule et retourne le résultat John Adams."
    },
   {
        "id": "Functions/concatenate.htm", 
        "title": "Fonction CONCATENER", 
        "body": "La fonction CONCATENER est l'une des fonctions de texte et de données. Elle est utilisée pour combiner les données de deux ou plusieurs cellules en une seule. La syntaxe de la fonction CONCATENER est : CONCATENER(text1, text2, ...) où text1(2) ce sont des données jusqu'à 256 valeurs saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction CONCATENER, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction CONCATENER, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Par exemple : Il y a trois arguments : text1 = A1 (John), text2 = \" \" (espace), text3 = B1 (Adams). La fonction va combiner le premier et le dernier nom dans une cellule et retourne le résultat John Adams."
    },
   {
        "id": "Functions/confidence-norm.htm", 
        "title": "Fonction INTERVALLE.CONFIANCE.NORMAL", 
        "body": "La fonction INTERVALLE.CONFIANCE.NORMAL est l'une des fonctions statistiques. Elle est utilisée pour retourner l'intervalle de confiance pour une moyenne de population en utilisant une distribution binomiale. La syntaxe de la fonction INTERVALLE.CONFIANCE.NORMAL est : INTERVALLE.CONFIANCE.NORMAL(alpha, standard-dev, size) où alpha est le seuil de probabilité, une valeur numérique supérieure à 0 mais inférieure à 1. standard-dev est l'écart-type de la population, une valeur numérique supérieure à 0. size est la taille d'échantillon, une valeur numérique supérieure ou égale à 1. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction INTERVALLE.CONFIANCE.NORMAL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction INTERVALLE.CONFIANCE.NORMAL, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/confidence-t.htm", 
        "title": "Fonction INTERVALLE.CONFIANCE.STUDENT", 
        "body": "La fonction INTERVALLE.CONFIANCE.STUDENT est l'une des fonctions statistiques. Elle est utilisée pour retourner l'intervalle de confiance pour une moyenne de population, en utilisant la distribution en T de Student. La syntaxe de la fonction INTERVALLE.CONFIANCE.STUDENT est : INTERVALLE.CONFIANCE.STUDENT(alpha, standard-dev, size) où alpha est le seuil de probabilité, une valeur numérique supérieure à 0 mais inférieure à 1. standard-dev est l'écart-type de la population, une valeur numérique supérieure à 0. size est la taille d'échantillon, une valeur numérique supérieure à 1. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction INTERVALLE.CONFIANCE.STUDENT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction INTERVALLE.CONFIANCE.STUDENT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/confidence.htm", 
        "title": "Fonction INTERVALLE.CONFIANCE", 
        "body": "La fonction INTERVALLE.CONFIANCE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'intervalle de confiance. La syntaxe de la fonction INTERVALLE.CONFIANCE est : INTERVALLE.CONFIANCE(alpha, standard-dev, size) où alpha est le seuil de probabilité, une valeur numérique supérieure à 0 mais inférieure à 1. standard-dev est l'écart-type de la population, une valeur numérique supérieure à 0. size est la taille d'échantillon, une valeur numérique supérieure ou égale à 1. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction INTERVALLE.CONFIANCE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction INTERVALLE.CONFIANCE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/convert.htm", 
        "title": "Fonction CONVERT", 
        "body": "La fonction CONVERT est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre d’une unité de mesure à une autre. Par exemple, la CONVERT peut traduire un tableau de distances en miles en un tableau de distances en kilomètres. La syntaxe de la fonction CONVERT est : CONVERT(nombre, de_unité, à_unité) où nombre est un nombre à convertir. de_unité est l’unité de mesure initiale. Une chaine de caractères entre guillemets. Les valeurs possibles sont listées dans le tableau ci-dessous. à_unité est l’unité de mesure vers laquelle nombre devrait être converti. Une chaine de caractères entre guillemets. Les valeurs possibles sont listées dans le tableau ci-dessous. Remarque: et doivent être compatibles, c'est-à-dire qu'ils doivent appartenir au même type de mesure. Poids et masse Unité Valeur du texte Gramme \"g\" Slug \"sg\" Livre masse (avoirdupois) \"lbm\" U (unité de masse atomique) \"u\" Once (avoirdupois) \"ozm\" Grain \"grain\" Poids de cent livres (U.S.) \"cwt\" ou \"shweight\" Poids de cent-douze livres \"uk_cwt\" ou \"lcwt\" (\"hweight\") Stone \"stone\" Tonne \"ton\" Tonne britannique \"uk_ton\" ou \"LTON\" (\"brton\") Distance Unité Valeur du texte Mètre \"m\" Mille \"mi\" Mille nautique \"mn\" Pouce \"in\" Pied \"ft\" Yard (ou Verge) \"yd\" Angstrom \"ang\" Ell \"ell\" Année lumière \"ly\" Parsec \"parsec\" ou \"pc\" Pica (1/72 po) \"Picapt\" ou \"Pica\" Pica (1/6 po) \"pica\" Mille U.S (mille légal) \"survey_mi\" Temps Unité Valeur du texte Année \"aa\" Jour \"jour\" ou \"j\" Heure \"h\" Minute \"mn\" ou \"min\" Seconde \"sec\" ou \"s\" Pression Unité Valeur du texte Pascal \"Pa\" (ou \"p\") Atmosphère \"atm\" (ou \"at\") mm de mercure \"mmHg\" PSI \"psi\" Torr \"Torr\" Force Unité Valeur du texte Newton \"N\" Dyne \"dyn\" (ou \"dy\") Livre force \"lbf\" Livre \"livre\" Énergie Unité Valeur du texte Joule \"J\" Erg \"e\" Calorie (4,183991 J) \"c\" Calorie (4,186795 J) \"cal\" Électron volt \"eV\" (ou \"ev\") Cheval-heure \"HPh\" (ou \"hh\") Watt-heure \"Wh\" (ou \"wh\") Livre pied \"lpd\" British Thermal Unit \"BTU\" (ou \"btu\") Puisssance Unité Valeur du texte Chevaux-vapeur \"HP\" (ou \"h\") Pferdestärke \"PS\" Watt \"W\" (ou \"w\") Magnétisme Unité Valeur du texte Tesla \"T\" Gauss \"ga\" Température Unité Valeur du texte Degré Celsius \"C\" (ou \"cel\") Degré Fahrenheit \"F\" (ou \"fah\") Kelvin \"K\" (ou \"kel\") Degrés Rankine \"Rank\" Degrés Réaumur \"Reau\" Volume (ou mesure liquide ) Unité Valeur du texte Cuillère à thé \"clt\" Cuillère à thé moderne \"cltm\" Cuillère à soupe \"cls\" Once fluide \"oz\" Tasse \"Ta\" Pinte U.S.A. \"pt\" (ou \"us_pt\") Pinte R.U. \"pt-ru\" Quart \"qt\" Litre britannique (quart) \"uk_qt\" Gallon \"gal\" Gallon britannique \"uk_gal\" Litre \"l\" ou \"L\" (\"lt\") Angstrom cubique \"ang3\" ou \"ang^3\" Baril de pétrole U.S. \"baril\" Boisseau U.S. \"boisseau\" Pieds cubes \"ft3\" ou \"ft^3\" pouce cube \"in3\" ou \"in^3\" Année lumière cube \"ly3\" ou \"ly^3\" Mètre cube \"m3\" ou \"m^3\" Mille cube \"mi3\" ou \"mi^3\" Yard cube \"yd3\" ou \"yd^3\" Mille nautique cube \"Nmi3\" ou \"Nmi^3\" Pica cube \"Picapt3\", \"Picapt^3\", \"Pica3\" ou \"Pica^3\" Tonneau de jauge brut \"GRT\" (\"regton\") Tonne de mesure (tonne de fret) \"MTON\" Aire Unité Valeur du texte Acre international \"uk_acre\" Acre légal U.S. \"us_acre\" Angstrom carré \"ang2\" ou “ang^2\" Are \"ar\" Pieds carrés \"ft2\" ou \"ft^2 Hectare \"ha\" Pouces carrés \"in2\" ou \"in^2\" Année lumière cube \"ly2\" ou \"ly^2\" Mètres carrés \"m2\" ou \"m^2\" Morgen \"Morgen\" Milles carrés \"mi2\" ou \"mi^2 Milles nautiques carrés \"Nmi2\" ou \"Nmi^2 Pica carrés \"Picapt2\", \"Pica2\", \"Pica^2\" ou \"Picapt^2\" Yards carrés \"yd2\" ou \"yd^2\" Information Unité Valeur du texte Bit \"bit\" Byte (Octet) \"octet\" Vitesse Unité Valeur du texte Nœud marin \"admkn\" Nœud \"kn\" Mètres par heure \"m/h\" ou \"m/hr\" Mètres par seconde \"m/s\" ou \"m/sec\" Milles par heure \"mph\" Les préfixes d’unités abrégés suivants peuvent être ajoutés à n’importe quel argument de_unité ou , par exemple en ajoutant le préfixe \"k\" devant l’unité \"g\" on obtient la valeur \"kg\" qui symbolise les kilogrammes. Préfixes Préfixe Multiplicateur Valeur du texte yotta 1E+24 \"A\" zetta 1E+21 \"Z\" exa 1E+18 \"E\" peta 1E+15 \"P\" tera 1E+12 \"T\" giga 1E+09 \"S\" mega 1E+06 \"M\" kilo 1E+03 \"k\" hecto 1E+02 \"h\" deca 1E+01 \"da\" ou \"e\" deci 1E-01 \"d\" centi 1E-02 \"c\" milli 1E-03 \"m\" micro 1E-06 \"u\" nano 1E-09 \"n\" pico 1E-12 \"p\" femto 1E-15 \"f\" atto 1E-18 \"a\" zepto 1E-21 \"z\" yocto 1E-24 \"y\" Préfixes binaires Préfixe Valeur du préfixe Valeur du texte yobi 2^80 = 1 208 925 819 614 629 174 706 176 \"Yi\" zebi 2^70 = 1 180 591 620 717 411 303 424 \"Zi\" exbi 2^60 = 1 152 921 504 606 846 976 \"Ei\" pebi 2^50 = 1 125 899 906 842 624 \"Pi\" tebi 2^40 = 1 099 511 627 776 \"Ti\" gibi 2^30 = 1 073 741 824 \"Gi\" mebi 2^20 = 1 048 576 \"Mi\" kibi 2^10 = 1024 \"ki\" Pour appliquer la fonction CONVERT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction CONVERT, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/correl.htm", 
        "title": "Fonction COEFFICIENT.CORRELATION", 
        "body": "La fonction COEFFICIENT.CORRELATION est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer le coefficient de corrélation entre deux séries de données. La syntaxe de la fonction COEFFICIENT.CORRELATION est : COEFFICIENT.CORRELATION(array-1, array-2) où array-1(2) ce sont des plages de cellules sélectionnées avec le même nombre d'éléments. Remarque : si array-1(2) contient du texte, des valeurs logiques, des cellules vides, la fonction ignore ces valeurs, mais prend en considération les cellules avec les valeurs zéro. Pour appliquer la fonction COEFFICIENT.CORRELATION, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction COEFFICIENT.CORRELATION, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/cos.htm", 
        "title": "Fonction COS", 
        "body": "La fonction COS est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le cosinus de l'angle spécifié. La syntaxe de la fonction COS est : COS(x) où x est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction COS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/cosh.htm", 
        "title": "Fonction COSH", 
        "body": "La fonction COSH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le cosinus hyperbolique d'un nombre. La syntaxe de la fonction COSH est : COSH(x) où x est une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COSH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction COSH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/cot.htm", 
        "title": "Fonction COT", 
        "body": "La fonction COT est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la cotangente d'un angle spécifié en radians. La syntaxe de la fonction COT est : COT(x) où x est l'angle en radians pour lequel on veut calculer la cotangente. Une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Sa valeur absolue doit être inférieure à 2^27. Pour appliquer la fonction COT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction COT, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/coth.htm", 
        "title": "Fonction COTH", 
        "body": "La fonction COTH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la cotangente hyperbolique d'un angle hyperbolique. La syntaxe de la fonction COTH est : COTH(x) où x est l'angle en radians pour lequel on veut calculer la cotangente hyperbolique. Une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Sa valeur absolue doit être inférieure à 2^27. Pour appliquer la fonction COTH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction COTH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/count.htm", 
        "title": "Fonction NB", 
        "body": "La fonction NB est l'une des fonctions statistiques. Elle est utilisée pour compter le nombre de cellules sélectionnées qui contiennent des nombres en ignorant les cellules vides ou avec du texte. La syntaxe de la fonction NB est : NB(plage) où argument-list est une plage de cellules que vous souhaitez compter. Pour appliquer la fonction NB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction NB, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/counta.htm", 
        "title": "Fonction NBVAL", 
        "body": "La fonction NBVAL est l'une des fonctions statistiques. Elle est utilisée pour analyser la plage de cellules et compter le nombre de cellules qui ne sont pas vides. La syntaxe de la fonction NBVAL est : NBVAL(argument-list) où argument-list est une plage de cellules que vous souhaitez compter. Pour appliquer la fonction NBVAL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction NBVAL, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/countblank.htm", 
        "title": "Fonction NB.VIDE", 
        "body": "La fonction NB.VIDE est l'une des fonctions statistiques. Elle est utilisée pour analyser una plage de cellules et renvoyer le nombre de cellules vides. La syntaxe de la fonction NB.VIDE est : NB.VIDE(argument-list) où argument-list est une plage de cellules que vous souhaitez compter. Pour appliquer la fonction NB.VIDE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction NB.VIDE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/countif.htm", 
        "title": "Fonction NB.SI", 
        "body": "La fonction NB.SI est l'une des fonctions statistiques. Elle est utilisée pour compter le nombre de cellules sélectionnées à la base du critère spécifié. La syntaxe de la fonction NB.SI est : NB.SI(cell-range, selection-criteria) où cell-range est une plage de cellules sélectionnées que vous souhaitez compter en appliquant le critère spécifié, selection-criteria est le critère à appliquer saisi à la main ou inclus dans la cellule à laquelle il est fait référence. Remarque : selection-criteria peut contenir des caractères génériques — le point d'interrogation (?) qui correspond à un seul caractère et l'astérisque (*) qui correspond à plusieurs caractères. Si vous souhaitez trouver un point d'interrogation ou un astérisque, tapez un tilde (~) avant le caractère. Pour appliquer la fonction NB.SI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône sutuée sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction NB.SI, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/countifs.htm", 
        "title": "Fonction NB.SI.ENS", 
        "body": "La fonction NB.SI.ENS est l'une des fonctions statistiques. Elle est utilisée pour compter le nombre de cellules sélectionnées en fonction de critères multiples. La syntaxe de la fonction NB.SI.ENS est : NB.SI.ENS(criteria-range-1, criteria-1, [criteria-range-2, criteria-2], ...) où criteria-range-1 est la première plage de cellules à laquelle on applique le critère criteria-1. C'est un argument obligatoire. criteria-1 est la première condition à remplir. Elle est appliquée à la plage criteria-range-1 et utilisée pour déterminer les cellules dans à compter. Sa valeur peut être saisie à la main ou incluse dans la cellule à laquelle il est fait référence. C'est un argument obligatoire. criteria-range-2, criteria-2, ...sont des plages supplémentaires de cellules et leurs critères correspondants. Ces arguments sont facultatifs. Vous pouvez entrer jusqu'à 127 plages de cellules et critères correspondants. Remarque : vous pouvez utiliser des caractères génériques lorsque vous spécifiez des critères. Le point d'interrogation \"?\" peut remplacer n'importe quel caractère et l'astérisque \"*\" peut être utilisée à la place de n'importe quel nombre de caractères. Si vous souhaitez trouver un point d'interrogation ou un astérisque, tapez un tilde (~) avant le caractère. Comment faire une NB.SI.ENS Pour appliquer la fonction NB.SI.ENS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction NB.SI.ENS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/coupdaybs.htm", 
        "title": "Fonction NB.JOURS.COUPON.PREC", 
        "body": "La fonction NB.JOURS.COUPON.PREC est l'une des fonctions financières. Elle est utilisée pour calculer le nombre de jours depuis le début de la période de coupon jusqu'à la date de règlement. La syntaxe de la fonction NB.JOURS.COUPON.PREC est : NB.JOURS.COUPON.PREC(settlement, maturity, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction NB.JOURS.COUPON.PREC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction NB.JOURS.COUPON.PREC, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/coupdays.htm", 
        "title": "Fonction NB.JOURS.COUPONS", 
        "body": "La fonction NB.JOURS.COUPONS est l'une des fonctions financières. Elle est utilisée pour calculer le nombre de jours dans la période de coupon comprenant la date de règlement. La syntaxe de la fonction NB.JOURS.COUPONS est : NB.JOURS.COUPONS(settlement, maturity, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction NB.JOURS.COUPONS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction NB.JOURS.COUPONS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/coupdaysnc.htm", 
        "title": "Fonction NB.JOURS.COUPON.SUIV", 
        "body": "La fonction NB.JOURS.COUPON.SUIV est l'une des fonctions financières. Elle est utilisée pour calculer le nombre de jours entre la date de règlement et le prochain paiement du coupon. La syntaxe de la fonction NB.JOURS.COUPON.SUIV est : NB.JOURS.COUPON.SUIV(settlement, maturity, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction NB.JOURS.COUPON.SUIV, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction NB.JOURS.COUPON.SUIV, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/coupncd.htm", 
        "title": "Fonction DATE.COUPON.SUIV", 
        "body": "La fonction DATE.COUPON.SUIV est l'une des fonctions financières. Elle est utilisée pour calculer la date du coupon suivant après la date de règlement. La syntaxe de la fonction DATE.COUPON.SUIV est : DATE.COUPON.SUIV(settlement, maturity, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DATE.COUPON.SUIV, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction DATE.COUPON.SUIV, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/coupnum.htm", 
        "title": "Fonction NB.COUPONS", 
        "body": "La fonction NB.COUPONS est l'une des fonctions financières. Il est utilisé pour calculer le nombre de coupons entre la date de règlement et la date d'échéance. La syntaxe de la fonction NB.COUPONS est : NB.COUPONS(settlement, maturity, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction NB.COUPONS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction NB.COUPONS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/couppcd.htm", 
        "title": "Fonction DATE.COUPON.PREC", 
        "body": "La fonction DATE.COUPON.PREC est l'une des fonctions financières. Elle est utilisée pour calculer la date du coupon précédent avant la date de règlement. La syntaxe de la fonction DATE.COUPON.PREC est : DATE.COUPON.PREC(settlement, maturity, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DATE.COUPON.PREC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction DATE.COUPON.PREC, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/covar.htm", 
        "title": "Fonction COVARIANCE", 
        "body": "La fonction COVARIANCE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la covariance de deux plages de données. La syntaxe de la fonction COVARIANCE est : COVARIANCE(array-1, array-2) où array-1(2) ce sont des plages de cellules sélectionnées avec le même nombre d'éléments. Remarque : si array-1(2) contient du texte, des valeurs logiques, des cellules vides, la fonction ignore ces valeurs, mais prend en considération les cellules avec les valeurs zéro. Pour appliquer la fonction COVARIANCE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction COVARIANCE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/covariance-p.htm", 
        "title": "Fonction COVARIANCE.PEARSON", 
        "body": "La fonction COVARIANCE.PEARSON est l'une des fonctions statistiques. Elle est utilisée pour retourner la covariance de population, la moyenne des produits des écarts pour chaque paire de points de données dans deux ensembles de données; utilisez la covariance pour déterminer la relation entre deux ensembles de données. La syntaxe de la fonction COVARIANCE.PEARSON est : COVARIANCE.PEARSON(array-1, array-2) où array-1(2) ce sont des plages de cellules sélectionnées avec le même nombre d'éléments. Remarque : si array-1(2) contient du texte, des valeurs logiques, des cellules vides, la fonction ignore ces valeurs, mais prend en considération les cellules avec les valeurs zéro. Pour appliquer la fonction COVARIANCE.PEARSON, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction COVARIANCE.PEARSON, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/covariance-s.htm", 
        "title": "Fonction COVARIANCE.STANDARD", 
        "body": "La fonction COVARIANCE.STANDARD est l'une des fonctions statistiques. Elle est utilisée pour retourner la covariance de l'échantillon, la moyenne des produits des écarts pour chaque paire de points de données dans deux ensembles de données. La syntaxe de la fonction COVARIANCE.STANDARD est : COVARIANCE.STANDARD(array-1, array-2) où array-1(2) ce sont des plages de cellules sélectionnées avec le même nombre d'éléments. Remarque : si array-1(2) contient du texte, des valeurs logiques, des cellules vides, la fonction ignore ces valeurs, mais prend en considération les cellules avec les valeurs zéro. Pour appliquer la fonction COVARIANCE.STANDARD, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction COVARIANCE.STANDARD, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/critbinom.htm", 
        "title": "Fonction CRITERE.LOI.BINOMIALE", 
        "body": "La fonction CRITERE.LOI.BINOMIALE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la valeur plus petite pour laquelle la distribution binomiale cumulée est supérieure ou égale à la valeur alpha spécifiée. La syntaxe de la fonction CRITERE.LOI.BINOMIALE est : CRITERE.LOI.BINOMIALE(number-trials, success-probability, alpha) où number-trials est le nombre d'évaluations, une valeur supérieure ou égale à 0. success-probability est la probabilité du succès de chaque évaluation, une valeur numérique supérieure ou égale à 0 mais inférieure ou égale à 1. alpha est un critère, une valeur numérique supérieure ou égale à 0 mais inférieure ou égale à 1. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction CRITERE.LOI.BINOMIALE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction CRITERE.LOI.BINOMIALE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/csc.htm", 
        "title": "Fonction CSC", 
        "body": "La fonction CSC est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la cosécante d'un angle spécifié en radians. La syntaxe de la fonction CSC est : CSC(x) où x est l'angle en radians pour lequel on veut calculer la cosécante. Une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Sa valeur absolue doit être inférieure à 2^27. Pour appliquer la fonction CSC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction CSC, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/csch.htm", 
        "title": "Fonction CSCH", 
        "body": "La fonction CSCH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la cosécante hyperbolique d'un angle spécifié en radians. La syntaxe de la fonction CSCH est : CSCH(x) où x est l'angle en radians pour lequel on veut calculer la cosécante hyperbolique. Une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Sa valeur absolue doit être inférieure à 2^27. Pour appliquer la fonction CSCH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction CSCH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/cumipmt.htm", 
        "title": "Fonction CUMUL.INTER", 
        "body": "La fonction CUMUL.INTER est l'une des fonctions financières. Elle est utilisée pour calculer l'intérêt cumulé payé sur un investissement entre deux périodes en fonction d'un taux d'intérêt spécifié et d'un échéancier de paiement constant. La syntaxe de la fonction CUMUL.INTER est : CUMUL.INTER(rate, nper, pv, start_period, end_period, type) où rate est le taux d'intérêt pour l'investissement. nper est le nombre de paiements. pv est la valeur actuelle des paiements. start_period est la première période incluse dans le calcul. La valeur doit être comprise entre 1 et nper. end_period est la dernière période incluse dans le calcul. La valeur doit être comprise entre 1 et nper. type est la période au cours de laquelle les paiements doivent être versés. Si il est égal à 0 ou absent, la fonction estime que les paiements doivent être versés à la fin de la période. Si type est égal à 1, les paiements doivent être versés au début de la période. Remarque : les sommes versées ( telles que dépôts d'épargne ) sont représentées par des nombres négatifs ; les sommes reçues ( telles que dividendes ) sont représentées par des nombres positifs. Les unités pour rate et nper doivent être cohérentes : utilisez N%/12 pour rate et N*12 pour nper dans le cas de paiements mensuels, N%/4 pour rate et N*4 pour nper dans le cas de paiements trimestriels, N% pour rate et N pour nper en cas de paiements annuels. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction CUMUL.INTER, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction CUMUL.INTER, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/cumprinc.htm", 
        "title": "Fonction CUMUL.PRINCPER", 
        "body": "La fonction CUMUL.PRINCPER est l'une des fonctions financières. Elle est utilisée pour calculer le capital cumulé payé sur un investissement entre deux périodes en fonction d'un taux d'intérêt spécifié et d'un échéancier de paiement constant. La syntaxe de la fonction CUMUL.PRINCPER est : CUMUL.PRINCPER(rate, nper, pv, start_period, end_period, type) où rate est le taux d'intérêt pour l'investissement. nper est le nombre de paiements. pv est la valeur actuelle des paiements. start_period est la première période incluse dans le calcul. La valeur doit être comprise entre 1 et nper. end_period est la dernière période incluse dans le calcul. La valeur doit être comprise entre 1 et nper. type est la période au cours de laquelle les paiements doivent être versés. Si il est égal à 0 ou absent, la fonction estime que les paiements doivent être versés à la fin de la période. Si type est égal à 1, les paiements doivent être versés au début de la période. Remarque : les sommes versées ( telles que dépôts d'épargne ) sont représentées par des nombres négatifs ; les sommes reçues ( telles que dividendes ) sont représentées par des nombres positifs. Les unités pour rate et nper doivent être cohérentes : utilisez N%/12 pour rate et N*12 pour nper dans le cas de paiements mensuels, N%/4 pour rate et N*4 pour nper dans le cas de paiements trimestriels, N% pour rate et N pour nper en cas de paiements annuels. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction CUMUL.PRINCPER, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction CUMUL.PRINCPER, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/date.htm", 
        "title": "Fonction DATE", 
        "body": "La fonction DATE est l'une des fonctions de date et d’heure. Elle est utilisée pour ajouter des dates au format par défaut jj/MM/aaaa. La syntaxe de la fonction DATE est : DATE(année, mois, jour) où année, mois, jour sont des valeurs saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DATE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction DATE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/datedif.htm", 
        "title": "Fonction DATEDIF", 
        "body": "La fonction DATEDIF est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer la defférence entre deux dates (start-date et end-date) à la base d'un intervalle (unité) spécifié. La syntaxe de la fonction DATEDIF est : DATEDIF(start-date, end-date, unit) où start-date and end-date sont deux dates entre lesquelles vous voulez calculer la différence. unit est un intervalle spécifié : Unité Explication Y Le nombre d'années complètes. M Le nombre de mois complets. D Le nombre de jours. MD La différence entre les jours (les mois et les années sont ignorés). YM La différence entre les mois (les jours et les années sont ignorés). YD La différence entre les jours (les années sont ignorées) Pour appliquer la fonction DATEDIF, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction DATEDIF, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/datevalue.htm", 
        "title": "Fonction DATEVAL", 
        "body": "La fonction DATEVAL est l'une des fonctions de date et d'heure. Il est utilisé pour renvoyer le nombre de série de la date déterminée. La syntaxe de la fonction DATEVAL est : DATEVAL(date-time-string) où date-time-string est une date du 1 janvier, 1900 jusqu'au 31 décembre, 9999 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction DATEVAL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction DATEVAL, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/daverage.htm", 
        "title": "Fonction BDMOYENNE", 
        "body": "La fonction BDMOYENNE est l'une des fonctions de base de données. Elle est utilisée pour faire la moyenne des valeurs dans un champ(colonne) d'enregistrements dans une liste ou une base de données qui correspondent aux conditions que vous spécifiez. La syntaxe de la fonction BDMOYENNE est : BDMOYENNE(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDMOYENNE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDMOYENNE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/day.htm", 
        "title": "Fonction JOUR", 
        "body": "La fonction JOUR est l'une des fonctions de date et d'heure. Elle renvoie le jour (un nombre de 1 à 31) de la date indiquée au format numérique (jj/MM/aaaa par défaut). La syntaxe de la fonction JOUR est : JOUR(valeur_date) où valeur_date est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction JOUR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction JOUR, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/days.htm", 
        "title": "Fonction JOURS", 
        "body": "La fonction JOURS est l'une des fonctions de date et d'heure. Est utilisé pour retourner le nombre de jours entre deux dates. La syntaxe de la fonction JOURS est : JOURS(end-date, start-date) où start-date et end-date sont deux dates entre lesquelles vous voulez calculer le nombre de jours. Pour appliquer la fonction JOURS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction JOURS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/days360.htm", 
        "title": "Fonction JOURS360", 
        "body": "La fonction JOURS360 est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer le nombre de jours entre deux dates (start-date et end-date) à la base d'une année de 360 jours en utilisant un des modes de calcul (américain ou européen). La syntaxe de la fonction JOURS360 est : JOURS360(start-date, end-date [,method-flag]) où start-date et end-date sont deux dates entre lesquelles vous voulez calculer le nombre de jours. method-flag est une valeur logique facultative : TRUE (VRAI) ou FALSE (FAUX). S'il est défini sur TRUE (VRAI), le calcul sera effectué en utilisant le mode européen, selon lequel les dates de début et de fin qui ont lieu le 31 du mois deviennent égales au 30 du même mois. S'il est défini sur FALSE (FAUX) ou omis, le calcul sera effectué en utilisant le mode américain, selon lequel si la date de début est le dernier jour du mois, elle devient égale au 30 du même mois. Si la date de fin est le dernier jour du mois et la date de début va avant le 30 du mois, les dates de début et de fin deviennent égales au 1 du mois suivant. Au cas contraire la date de fin devient égale au 30 du même mois. Pour appliquer la fonction JOURS360, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction JOURS360, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/db.htm", 
        "title": "Fonction DB", 
        "body": "La fonction DB est l'une des fonctions financières. Elle est utilisée pour calculer la dépréciation d'un actif pour une période comptable spécifiée en utilisant la méthode du solde fixe-dégressif. La syntaxe de la fonction DB est : DB(cost, salvage, life, period[, [month]]) où cost est le coût de l'actif. salvage est la valeur de récupération de l'actif à la fin de sa durée de vie. life est le nombre total de périodes dans la durée de vie de l'actif. period est la période pour laquelle vous souhaitez calculer l'amortissement. La valeur doit être exprimée dans les mêmes unités que life. month est le nombre de mois de la première année. C'est un argument facultatif. En cas d'omission, month est estimé à 12. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction DB, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dcount.htm", 
        "title": "Fonction BCOMPTE", 
        "body": "La fonction BCOMPTE est l'une des fonctions de bases de données. Elle est utilisée pour compter les cellules contenant des nombres dans un champ (colonne) d'enregistrements dans une liste ou une base de données qui correspondent aux conditions que vous spécifiez. La syntaxe de la fonction BCOMPTE est : BCOMPTE(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BCOMPTE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BCOMPTE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dcounta.htm", 
        "title": "Fonction BDNBVAL", 
        "body": "La fonction BDNBVAL est l'une des fonctions de bases de données. Elle est utilisée pour compter les cellules non vides (les valeurs logiques et le texte sont également comptés) dans un champ (colonne) d'enregistrements dans une liste ou une base de données qui correspondent aux conditions que vous spécifiez. La syntaxe de la fonction BDNBVAL est : BDNBVAL(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDNBVAL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDNBVAL, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ddb.htm", 
        "title": "Fonction DDB", 
        "body": "La fonction DDB est l'une des fonctions financières. Elle est utilisée pour calculer la dépréciation d'un actif pour une période comptable donnée en utilisant la méthode du solde dégressif double. La syntaxe de la fonction DDB est : DDB(cost, salvage, life, period[, [factor]]) où cost est le coût de l'actif. salvage est la valeur de récupération de l'actif à la fin de sa durée de vie. life est le nombre total de périodes dans la durée de vie de l'actif. period est la période pour laquelle vous souhaitez calculer l'amortissement. La valeur doit être exprimée dans les mêmes unités que life. factor est le taux auquel le solde diminue. C'est un argument facultatif. En cas d'omission, factor est estimé à 2. Remarque : toutes les valeurs doivent être des nombres positifs. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DDB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction DDB, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dec2bin.htm", 
        "title": "Fonction DECBIN", 
        "body": "La fonction DECBIN est l'une des fonctions logiques. Elle est utilisée pour convertir un nombre décimal en un nombre binaire. La syntaxe de la fonction DECBIN est : DECBIN(number [, num-hex-digits]) où où number est un nombre décimal saisi à la main ou inclus dans la cellule à laquelle il est fait référence. num-hex-digits est le nombre de chiffres à afficher. Si omis, la fonction utilisera le nombre minimum. Remarque : si le nombre num-hex-digits spécifié est inférieur ou égal à 0, la function renverra l'erreur #NOMBRE!. Pour appliquer la fonction DECBIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction DECBIN, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dec2hex.htm", 
        "title": "Fonction DECHEX", 
        "body": "La fonction DECHEX est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre décimal en un nombre hexadécimal. La syntaxe de la fonction DECHEX est : DECHEX(number [, num-hex-digits]) où où number est un nombre décimal saisi à la main ou inclus dans la cellule à laquelle il est fait référence. num-hex-digits est le nombre de chiffres à afficher. Si omis, la fonction utilisera le nombre minimum. Remarque : si le nombre num-hex-digits spécifié est inférieur ou égal à 0, la function renverra l'erreur #NOMBRE!. Pour appliquer la fonction DECHEX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction DECHEX, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dec2oct.htm", 
        "title": "Fonction DECOCT", 
        "body": "La fonction DECOCT est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre décimal en un nombre octal. La syntaxe de la fonction DECOCT est : DECOCT(number [, num-hex-digits]) où où number est un nombre décimal saisi à la main ou inclus dans la cellule à laquelle il est fait référence. num-hex-digits est le nombre de chiffres à afficher. Si omis, la fonction utilisera le nombre minimum. Remarque : si le nombre num-hex-digits spécifié est inférieur ou égal à 0, la function renverra l'erreur #NOMBRE!. Pour appliquer la fonction DECOCT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction DECOCT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/decimal.htm", 
        "title": "Fonction DECIMAL", 
        "body": "La fonction DECIMAL est l'une des fonctions mathématiques et trigonométriques. Il est utilisé pour convertir une représentation textuelle d'un nombre dans une base donnée en un nombre décimal. La syntaxe de la fonction DECIMAL est : DECIMAL(text, base) où text est la représentation textuelle du nombre que vous voulez convertir. Sa longueur p*doit être inférieure ou égale à 255 caractères. base est la base du nombre. Une valeur entière supérieure ou égale à 2 mais inférieure ou égale à 36. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DECIMAL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction DECIMAL, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/degrees.htm", 
        "title": "Fonction DEGRES", 
        "body": "La focntion DEGRES est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour convertir les radians en degrés. La syntaxe de la fonction DEGRES est : DEGRES(angle) où angle est une valeur numérique (radians) saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction DEGRES, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction DEGRES, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/delta.htm", 
        "title": "Fonction DELTA", 
        "body": "La fonction DELTA est l'une des fonctions d'ingénierie. Il est utilisé pour tester si deux nombres sont égaux. La fonction renvoie 1 si les nombres sont égaux et 0 sinon. La syntaxe de la fonction DELTA est : DELTA(number-1 [, number-2]) où number-1 est le premier nombre. number-2 est le second nombre. C'est un argument facultatif. En cas d'omission, number-2 est estimé à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DELTA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction DELTA, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/devsq.htm", 
        "title": "Fonction SOMME.CARRES.ECARTS", 
        "body": "La fonction SOMME.CARRES.ECARTS est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et calculer la somme des carrés des déviations des nombres de leur moyenne. La syntaxe de la fonction SOMME.CARRES.ECARTS est : SOMME.CARRES.ECARTS(argument-list) où argument-list est une liste contenant jusqu'à 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction SOMME.CARRES.ECARTS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction SOMME.CARRES.ECARTS, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dget.htm", 
        "title": "Fonction BDLIRE", 
        "body": "La fonction BDLIRE est l'une des fonctions de base de données. Elle est utilisée pour extraire une seule valeur d'une colonne d'une liste ou d'une base de données qui correspond aux conditions que vous spécifiez. La syntaxe de la fonction BDLIRE est : BDLIRE(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDLIRE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDLIRE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/disc.htm", 
        "title": "Fonction TAUX.ESCOMPTE", 
        "body": "La fonction TAUX.ESCOMPTE est l'une des fonctions financières. Elle est utilisée pour calculer le taux d'actualisation d'un titre. La syntaxe de la fonction TAUX.ESCOMPTE est : TAUX.ESCOMPTE(settlement, maturity, pr, redemption[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. pr correspond au prix d'achat du titre, par tranche de 100$ de valeur nominale. redemptioncorrespond à la valeur de rachat du titre, par tranche de 100$ de valeur nominale. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TAUX.ESCOMPTE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction TAUX.ESCOMPTE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dmax.htm", 
        "title": "Fonction BDMAX", 
        "body": "La fonction BDMAX est l'une des fonctions de bases de données. Elle est utilisée pour renvoyer le plus grand nombre dans un champ (colonne) d'enregistrements dans une liste ou une base de données qui correspond aux conditions que vous spécifiez. La syntaxe de la fonction BDMAX est : BDMAX(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDMAX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDMAX, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dmin.htm", 
        "title": "Fonction BDMIN", 
        "body": "La fonction BDMIN est l'une des fonctions de bases de données. Elle est utilisée pour renvoyer le plus petit nombre dans un champ (colonne) d'enregistrements dans une liste ou une base de données qui correspond aux conditions que vous spécifiez. La syntaxe de la fonction BDMIN est : BDMIN(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDMIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDMIN, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dollar.htm", 
        "title": "Fonction DEVISE", 
        "body": "La focntion DEVISE est l'une des fonctions de texte et de données. Elle est utilisée pour convertir un nombre dans le texte en utilisant le format monétaire $#.##. La syntaxe de la fonction DEVISE est : DEVISE(number [, num-decimal]) où number est un nombre à convertir. num-decimal est un nombre de décimales à afficher. S'il est omis, la fonction l'assume d'être égal à 2. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DEVISE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction DEVISE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dollarde.htm", 
        "title": "Fonction PRIX.DEC", 
        "body": "La fonction PRIX.DEC est l'une des fonctions financières. Elle est utilisée pour convertir un prix en dollars représenté sous forme de fraction en un prix en dollars représenté par un nombre décimal. La syntaxe de la fonction PRIX.DEC est : PRIX.DEC(fractional-dollar, fraction) où fractional-dollar est une partie entière et une partie fractionnaire séparées par un symbole décimal. fraction est un entier que vous souhaitez utiliser comme dénominateur pour la partie fractionnaire de la valeur fractional-dollar. Remarque: par exemple, la valeur exprimée par 1.03, est interprétée comme 1 + 3/n, où n est la valeur de fraction. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PRIX.DEC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction PRIX.DEC, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dollarfr.htm", 
        "title": "Fonction PRIX.FRAC", 
        "body": "La fonction PRIX.FRAC est l'une des fonctions financières. Elle est utilisée pour convertir un prix en dollars représenté par un nombre décimal en un prix en dollars représenté sous forme de fraction. La syntaxe de la fonction PRIX.FRAC est : PRIX.FRAC(decimal-dollar, fraction) où decimal-dollar est un nombre décimal. fraction est un entier que vous souhaitez utiliser comme dénominateur pour la fraction retournée. Remarque: par exemple, si la valeur retournée est 1.03, elle est interprétée comme 1 + 3/n, où est la valeur de fraction. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PRIX.FRAC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction PRIX.FRAC, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dproduct.htm", 
        "title": "Fonction BDPRODUIT", 
        "body": "La fonction BDPRODUIT est l'une des fonctions de bases de données. Elle est utilisée pour multiplier les valeurs dans un champ (colonne) d'enregistrements dans une liste ou une base de données qui correspondent aux conditions que vous spécifiez. La syntaxe de la fonction BDPRODUIT est : BDPRODUIT(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDPRODUIT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDPRODUIT, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/drop.htm", 
        "title": "Fonction EXCLURE", 
        "body": "La fonction EXCLURE est l'une des fonctions de recherche et de référence. Sert à exclure des lignes ou des colonnes du début ou de la fin. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction EXCLURE</b></b>: =EXCLURE(tableau, lignes,[colonnes]) où: tableau sert à définir le tableau à partir duquel exclure des lignes ou des colonnes. lignes sert à définir le nombre de lignes à supprimer. Une valeur négative signifie la suppression en fin du tableau. colonnes sert à définir le nombre de colonnes à exclure. Une valeur négative signifie la suppression en fin du tableau. Pour appliquer la fonction EXCLURE, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction EXCLURE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/dstdev.htm", 
        "title": "Fonction BDECARTYPE", 
        "body": "La fonction BDECARTYPE est l'une des fonctions de bases de données. Elle est utilisée pour estimer l'écart-type d'une population en fonction d'un échantillon en utilisant les numéros d'un champ (colonne) d'enregistrements dans une liste ou une base de données qui correspondent aux conditions que vous spécifiez. La syntaxe de la fonction BDECARTYPE est : BDECARTYPE(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDECARTYPE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDECARTYPE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dstdevp.htm", 
        "title": "Fonction BDECARTYPEP", 
        "body": "La fonction BDECARTYPEP est l'une des fonctions de bases de données. Elle est utilisée pour calculer l'écart-type d'une population basée sur la population entière en utilisant les nombres dans un champ (colonne) d'enregistrements dans une liste ou une base de données qui correspondent aux conditions que vous spécifiez. La syntaxe de la fonction BDECARTYPEP est : BDECARTYPEP(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDECARTYPEP, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDECARTYPEP, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dsum.htm", 
        "title": "Fonction BDSOMME", 
        "body": "La fonction BDSOMME est l'une des fonctions de base de données. Elle est utilisée pour ajouter les numéros dans un champ(colonne) d'enregistrements dans une liste ou une base de données qui correspondent aux conditions que vous spécifiez. La syntaxe de la fonction BDSOMME est : BDSOMME(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDSOMME, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDSOMME, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/duration.htm", 
        "title": "Fonction DUREE", 
        "body": "La fonction DUREE est l'une des fonctions financières. Elle est utilisée pour calculer la duration de Macaulay d'un titre avec une valeur nominale de 100 $. La syntaxe de la fonction DUREE est : DUREE(settlement, maturity, coupon, yld, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. coupon est le taux de coupon annuel du titre. yld est le rendement annuel du titre. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DUREE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction DUREE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dvar.htm", 
        "title": "Fonction BDVAR", 
        "body": "La fonction BDVAR est l'une des fonctions de bases de données. Elle est utilisée pour estimer la variance d'une population en fonction d'un échantillon en utilisant les numéros d'un champ (colonne) d'enregistrements dans une liste ou une base de données qui correspondent aux conditions que vous spécifiez. La syntaxe de la fonction BDVAR est : BDVAR(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDVAR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDVAR, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/dvarp.htm", 
        "title": "Fonction BDVARP", 
        "body": "La fonction BDVARP est l'une des fonctions de bases de données. Elle est utilisée pour calculer la variance d'une population basée sur la population entière en utilisant les nombres dans un champ (colonne) d'enregistrements dans une liste ou une base de données qui correspondent aux conditions que vous spécifiez. La syntaxe de la fonction BDVARP est : BDVARP(database, field, criteria) où database est la plage de cellules qui composent la base de données. Elle doit contenir des en-têtes de colonne dans la première ligne. field est un argument qui spécifie quel champ (c'est-à-dire, colonne) doit être utilisé. Il peut être spécifié en tant que numéro de la colonne requise ou en-tête de colonne entre guillemets. criteria est la plage de cellules qui contiennent les conditions. Elle doit contenir au moins un nom de champ (en-tête de colonne) et au moins une cellule en dessous spécifiant la condition à appliquer à ce champ dans la base de données. La plage de cellules criteria ne doit pas chevaucher la plage de cellules database. Pour appliquer la fonction BDVARP, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Base de données depuis la liste, cliquez sur la fonction BDVARP, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ecma-ceiling.htm", 
        "title": "Fonction ECMA.PLAFOND", 
        "body": "La fonction ECMA.PLAFOND est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir le nombre au multiple le plus proche de l'argument de précision. Les nombres négatifs sont arrondis à zéro. La syntaxe de la fonction ECMA.PLAFOND est : ECMA.PLAFOND(x, précision) où x est le nombre que vous souhaitez arrondir, précision multiple de l'argument précision auquel vous souhaitez arrondir, Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction ECMA.PLAFOND, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ECMA.PLAFOND, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/edate.htm", 
        "title": "Fonction MOIS.DECALER", 
        "body": "La fonction MOIS.DECALER est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer le numéro de série de la date qui vient le nombre de mois spécifié (month-offset) avant ou après la date déterminée (start-date). La syntaxe de la fonction MOIS.DECALER est : MOIS.DECALER(start-date, month-offset) où start-date est un nombre représentant la première date de la période saisi à l'aide de la fonction Date ou une autre fonction de date et d'heure. month-offset est le nombre de mois avant ou après start-day. Si month-offset a le signe négatif, la fonction renvoie le numéro de série de la date qui va avant la start-date spécifiée. Si month-offset a le signe positif, la fonction renvoie le numéro de série de la date qui vient après la start-date spécifiée. Pour appliquer la fonction MOIS.DECALER, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction MOIS.DECALER, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/effect.htm", 
        "title": "Fonction TAUX.EFFECTIF", 
        "body": "La fonction TAUX.EFFECTIF est l'une des fonctions financières. Elle sert à calculer le taux d'intérêt annuel effectif d'un titre en fonction d'un taux d'intérêt annuel nominal déterminé et du nombre de périodes de composition par année. La syntaxe de la fonction TAUX.EFFECTIF est : TAUX.EFFECTIF(nominal-rate, npery) où nominal-rate est le taux d'intérêt annuel nominal du titre. npery est le nombre de périodes de composition par année. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TAUX.EFFECTIF, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction TAUX.EFFECTIF, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/eomonth.htm", 
        "title": "Fonction FIN.MOIS", 
        "body": "La fonction FIN.MOIS est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer le numéro de série du dernier jour du mois qui vient le nombre de mois spécifié avant ou après la date déterminée. La syntaxe de la fonction FIN.MOIS est : FIN.MOIS(start-date, month-offset) où start-date est un nombre représentant la première date de la période saisi à l'aide de la fonction Date ou une autre fonction de date et d'heure. month-offset est le nombre de mois avant ou après start-day. Si month-offset a le signe négatif, la fonction renvoie le numéro de série de la date qui va avant la start-date spécifiée. Si month-offset a le signe positif, la fonction renvoie le numéro de série de la date qui vient après la start-date spécifiée. Pour appliquer la fonction FIN.MOIS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction FIN.MOIS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/erf-precise.htm", 
        "title": "Fonction ERF.PRECIS", 
        "body": "La fonction ERF.PRECIS est l'une des fonctions d'ingénierie. Elle est utilisée pour retourner la fonction d'erreur intégrée entre 0 et la limite inférieure spécifiée. La syntaxe de la fonction ERF.PRECIS est : ERF.PRECIS(x) où x est la limite inférieure de l'intégration. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxqulles il est fait référence. Pour appliquer la fonction ERF.PRECIS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction ERF.PRECIS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/erf.htm", 
        "title": "Fonction ERF", 
        "body": "La fonction ERF est l'une des fonctions d'ingénierie. Il est utilisé pour calculer la fonction d'erreur intégrée entre les limites inférieure et supérieure spécifiées. La syntaxe de la fonction ERF est : ERF(lower-bound [, upper-bound]) où lower-bound est la limite inférieure de l'intégration. lower-bound est la limite supérieure de l'intégration. C'est un argument facultatif. En cas d'omission, la fonction calcule la fonction d'erreur intégrée entre 0 et lower-bound. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction ERF, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction ERF, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/erfc-precise.htm", 
        "title": "Fonction ERFC.PRECIS", 
        "body": "La fonction ERFC.PRECIS est l'une des fonctions logiques. Elle est utilisée pour calculer la fonction d'erreur complémentaire intégrée entre la limite inférieure et l'infini. La syntaxe de la fonction ERFC.PRECIS est : ERFC.PRECIS(x) où x est la limite inférieure de l'intégration saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ERFC.PRECIS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction ERFC.PRECIS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/erfc.htm", 
        "title": "Fonction ERFC", 
        "body": "La fonction ERFC est l'une des fonctions d'ingénierie. Elle est utilisée pour calculer la fonction d'erreur complémentaire intégrée entre la limite inférieure et l'infini. La syntaxe de la fonction ERFC est : ERFC(lower-bound) où lower-bound est la limite inférieure de l'intégration saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ERFC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction ERFC, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/error-type.htm", 
        "title": "Fonction TYPE.ERREUR", 
        "body": "La fonction TYPE.ERREUR est l'une des fonctions d'information. Elle est utilisée pour renvoyer un nombre correspondant à un type d'erreur. La syntaxe de la fonction TYPE.ERREUR est : TYPE.ERREUR(valeur) où où est une valeur d'erreur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. La valeur d'erreur peut être l'un des éléments suivants : Valeur de l'erreur Représentation numérique #NUL! 1 #DIV/0! 2 #VALEUR! 3 #REF! 4 #NOM? 5 #NOMBRE! 6 #N/A 7 #CHARGEMENT_DONNEES 8 Autre #N/A Pour appliquer la fonction TYPE.ERREUR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la focntion TYPE.ERREUR, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/even.htm", 
        "title": "Fonction PAIR", 
        "body": "La fonction PAIR est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir un nombre au nombre entier pair immédiatement supérieur. La syntaxe de la fonction PAIR est : PAIR(x) où x représente la valeur à arrondir, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction PAIR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PAIR, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/exact.htm", 
        "title": "Fonction EXACT", 
        "body": "La focntion EXACT est l'une des fonctions de texte et de données. Elle est utilisée pour comparer les données de deux cellules. La fonction renvoie vrai (TRUE) si les données sont identiques, et faux (FALSE) dans le cas contraire. La syntaxe de la fonction EXACT est : EXACT(text1, text2) où text1(2) ce sont les données saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction EXACT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction EXACT, insérez les arguments nécessaires en les séparant par des virgules,Remarque: la fonction EXACT respecte la casse. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Par exemple : Il y a deux arguments : text1 = A1; text2 = B1,où A1 is MyPassword, B1 est mypassword. La fonction renvoie FAUX (FALSE). Si on change les données de A1 en convertissant toutes les lettres majuscules en minuscules, la fonction renvoie VRAI (TRUE):"
    },
   {
        "id": "Functions/exp.htm", 
        "title": "Fonction EXP", 
        "body": "La fonction EXP est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la constante e élevée à la puissance désirée. La constante e est égale à 2,71828182845904. La syntaxe de la fonction EXP est : EXP(x) où x est une puissance à laquelle vous souhauter élever e, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction EXP, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction EXP, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/expand.htm", 
        "title": "Fonction EXPAND", 
        "body": "La fonction EXPAND appartient aux fonctions de recherche et de référence. Cette fonction permet d'agrandir la plage de données (le tableau) en insérant des lignes et des colonnes. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction EXPAND: =EXPAND(tableau, lignes, [colonnes], [pad_width]) où: tableau est la plage de cellules à agrandir, lignes est le nombre de lignes dans le tableau renvoyé, Bien qu'il s'agisse d'un argument obligatoire, s'il est omis, les lignes ne seront pas ajoutées et on doit indiquer le nombre de colonnes. [colonnes] est un argument facultatif indiquant le nombre de colonnes à renvoyer. Si cet argument est omis, les colonnes ne seront pas ajoutées et on doit indiquer le nombre de lignes. [pad_with] est la valeur avec laquelle on va remplir les cellules ajoutées. #N/A est la valeur par défaut. Pour appliquer la fonction EXPAND, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction EXPAND, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/expon-dist.htm", 
        "title": "Fonction LOI.EXPONENTIELLE.N", 
        "body": "La fonction LOI.EXPONENTIELLE.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer une distribution exponentielle. La syntaxe de la fonction LOI.EXPONENTIELLE.N est : LOI.EXPONENTIELLE.N(x, lambda, cumulative) où x est une valeur de la fonction, une valeur numériaue supérieure ou égale à 0, lambda est le paramètre de la valeur, une valeur numérique supérieure à 1, cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si cumulative est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative, s'il est FALSE (FAUX), elle renvoie la fonction de densité de probabilité. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.EXPONENTIELLE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.EXPONENTIELLE.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/expondist.htm", 
        "title": "Fonction LOI.EXPONENTIELLE", 
        "body": "La fonction LOI.EXPONENTIELLE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer une distribution exponentielle. La syntaxe de la fonction LOI.EXPONENTIELLE est : LOI.EXPONENTIELLE(x, lambda, cumulative-flag) où x est une valeur de la fonction, une valeur numériaue supérieure ou égale à 0, lambda est le paramètre de la valeur, une valeur numérique supérieure à 1, cumulative-flag est une forme de la fonction à renvoyer, une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si cumulative-flag est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative, s'il est FALSE (FAUX), elle renvoie la fonction de densité de probabilité. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.EXPONENTIELLE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.EXPONENTIELLE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/f-dist-rt.htm", 
        "title": "Fonction LOI.F.DROITE", 
        "body": "La fonction LOI.F.DROITE est l'une des fonctions statistiques. Il est utilisé pour renvoyer la distribution de probabilité F(droite), ou degré de diversité, pour deux ensembles de données. Vous pouvez utiliser cette fonction pour déterminer si deux ensembles de données ont des degrés de diversité différents. La syntaxe de la fonction LOI.F.DROITE est : LOI.F.DROITE(x, deg-freedom1, deg-freedom2) où x est la valeur pour laquelle la fonction doit être calculée. Une valeur numérique supérieure à 0. deg-freedom1 est le nombre de degrés de liberté du numérateur, une valeur numérique supérieure à 1. deg-freedom2 est le nombre de degrés de liberté du dénominateur, une valeur numérique supérieure à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.F.DROITE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.F.DROITE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/f-dist.htm", 
        "title": "Fonction LOI.F.N", 
        "body": "La fonction LOI.F.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la distribution de probabilité F. Vous pouvez utiliser cette fonction pour déterminer si deux ensembles de données ont des degrés de diversité différents. La syntaxe de la fonction LOI.F.N est : LOI.F.N(x, deg-freedom1, deg-freedom2, cumulative) où x est la valeur pour laquelle la fonction doit être calculée. Une valeur numérique supérieure à 0 deg-freedom1 est le nombre de degrés de liberté du numérateur, une valeur numérique supérieure à 0. est le nombre de degrés de liberté du dénominateur, une valeur numérique supérieure à 0. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de densité de probabilité. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.F.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.F.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/f-inv-rt.htm", 
        "title": "Fonction INVERSE.LOI.F.DROITE", 
        "body": "La fonction INVERSE.LOI.F.DROITE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la distribution de probabilité F (droite). La distribution F peut être utilisée dans un test F qui compare le degré de variabilité dans deux ensembles de données. La syntaxe de la fonction INVERSE.LOI.F.DROITE est : INVERSE.LOI.F.DROITE(probability, deg-freedom1, deg-freedom2) où probability est la probabilité associée à la distribution cumulative F. Une valeur numérique supérieure à 0 mais inférieure à 1. deg-freedom1 est le nombre de degrés de liberté du numérateur, une valeur numérique supérieure à 1. deg-freedom2 est le nombre de degrés de liberté du dénominateur, une valeur numérique supérieure à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction INVERSE.LOI.F.DROITE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction INVERSE.LOI.F.DROITE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/f-inv.htm", 
        "title": "Fonction INVERSE.LOI.F.N", 
        "body": "La fonction INVERSE.LOI.F.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la distribution de probabilité F (droite). La distribution F peut être utilisée dans un test F qui compare le degré de variabilité dans deux ensembles de données. La syntaxe de la fonction INVERSE.LOI.F.N est : INVERSE.LOI.F.N(probability, deg-freedom1, deg-freedom2) où probability est la probabilité associée à la distribution cumulative F. Une valeur numérique supérieure à 0 mais inférieure à 1. deg-freedom1 est le nombre de degrés de liberté du numérateur, une valeur numérique supérieure à 1. deg-freedom2 est le nombre de degrés de liberté du dénominateur, une valeur numérique supérieure à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction INVERSE.LOI.F.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction INVERSE.LOI.F.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/f-test.htm", 
        "title": "Fonction F.TEST", 
        "body": "La fonction F.TEST est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le résultat d’un test F, la probabilité bilatérale que les variances des arguments matrice1 et matrice2 ne présentent pas de différences significatives. Utilisez cette fonction pour comparer les variances de deux échantillons. La syntaxe de la fonction F.TEST est : F.TEST(matrice1, matrice2) où matrice1 est la première plage de valeurs numériques. matrice2 est la deuxième plage de valeurs numériques. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Le texte, les valeurs logiques et les cellules vides sont ignorés, les cellules contenant des valeurs nulles sont incluses. Si le nombre de valeurs dans une plage de données est inférieur à 2 ou si une variance d'un tableau est 0, la fonction renvoie la valeur d'erreur #DIV/0!. Pour appliquer la fonction F.TEST, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction F.TEST, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/fact.htm", 
        "title": "Fonction FACT", 
        "body": "La fonction FACT est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la factorielle d'un nombre. La syntaxe de la fonction FACT est : FACT(x) où x est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction FACT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction FACT, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/factdouble.htm", 
        "title": "Fonction FACTDOUBLE", 
        "body": "La fonction FACTDOUBLE est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la factorielle double d'un nombre. La syntaxe de la fonction FACTDOUBLE est : FACTDOUBLE(x) où x est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction FACTDOUBLE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction FACTDOUBLE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/false.htm", 
        "title": "Fonction FAUX", 
        "body": "La fonction FAUX est l'une des fonctions logiques. La fonction renvoie la valeur logique faux (FAUX) et n'exige aucun argument. La syntaxe de la fonction FAUX est : FAUX() Pour appliquer la fonction FAUX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction FAUX, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/fdist.htm", 
        "title": "Fonction LOI.F", 
        "body": "La fonction LOI.F est l'une des fonctions statistiques. Il est utilisé pour renvoyer la distribution de probabilité F(droite), ou degré de diversité, pour deux ensembles de données. Vous pouvez utiliser cette fonction pour déterminer si deux ensembles de données ont des degrés de diversité différents. La syntaxe de la fonction LOI.F est : LOI.F(x, deg-freedom1, deg-freedom2) où x est la valeur pour laquelle la fonction doit être calculée. Une valeur numérique supérieure à 0. deg-freedom1 est le nombre de degrés de liberté du numérateur, une valeur numérique supérieure à 1 et inférieure à 10^10. deg-freedom2 est le nombre de degrés de liberté du dénominateur, une valeur numérique supérieure à 1 et inférieure à 10^10. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.F, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.F, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/filter.htm", 
        "title": "Fonction FILTRE", 
        "body": "La fonction FILTRE appartient aux fonctions de recherche et de référence. Cette fonction permet de filtrer une plage de données et renvoyer les résultats qui répondent aux critères spécifiés. La fonction FILTRE extrait uniquement les données nécessaires et les résultats sont mis à jour lorsque les données source changent. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction FILTRE: =FILTRE(tableau; inclure; [si_vide]) où: tableau est la plage de cellules à trier. inclure est le critère de filtrage qui est une matrice booléenne (VRAI/FAUX) de la même hauteur (colonnes) et la même largeur (lignes) que le tableau. [si_vide] est la valeur à renvoyer lorsqu'il n'y a pas de résulats à renvoyer. C'est un argument facultatif. Pour appliquer la fonction FILTRE, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction FILTRE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/find.htm", 
        "title": "Fonction TROUVE/TROUVERB", 
        "body": "La focntion TROUVE/TROUVERB est l'une des fonctions de texte et de données. Elle est utilisée pour trouver une sous-chaîne déterminée (string-1) à l'intérieure d'une chaîne (string-2). La fonction TROUVE est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que TROUVERB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction TROUVE/TROUVERB est : TROUVE(string-1, string-2 [,start-pos]) TROUVERB(string-1, string-2 [,start-pos]) où string-1 est une chaîne à trouver, string-2 est une chaîne dans laquelle vous cherchez, start-pos est la position dans la chaîne à partir de laquelle vous voulez commencer la recherche. C'est un argument facultatif. S'il est omis, la fonction commence la recherche dès le début de la chaîne. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Note: s'il n'a pas de correspondances, la fonction renvoie l'erreur #VALUE!. Pour appliquer la fonction TROUVE/TROUVERB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction TROUVE/TROUVERB, insérez les arguments nécessaires en les séparant par des virgules,Remarque: la fonction TROUVE/TROUVERB respecte la casse. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/findb.htm", 
        "title": "Fonction TROUVE/TROUVERB", 
        "body": "La focntion TROUVE/TROUVERB est l'une des fonctions de texte et de données. Elle est utilisée pour trouver une sous-chaîne déterminée (string-1) à l'intérieure d'une chaîne (string-2). La fonction TROUVE est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que TROUVERB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction TROUVE/TROUVERB est : TROUVE(string-1, string-2 [,start-pos]) TROUVERB(string-1, string-2 [,start-pos]) où string-1 est une chaîne à trouver, string-2 est une chaîne dans laquelle vous cherchez, start-pos est la position dans la chaîne à partir de laquelle vous voulez commencer la recherche. C'est un argument facultatif. S'il est omis, la fonction commence la recherche dès le début de la chaîne. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Note: s'il n'a pas de correspondances, la fonction renvoie l'erreur #VALUE!. Pour appliquer la fonction TROUVE/TROUVERB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction TROUVE/TROUVERB, insérez les arguments nécessaires en les séparant par des virgules,Remarque: la fonction TROUVE/TROUVERB respecte la casse. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/finv.htm", 
        "title": "Fonction INVERSE.LOI.F", 
        "body": "La fonction INVERSE.LOI.F est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la distribution de probabilité F (droite). La distribution F peut être utilisée dans un test F qui compare le degré de variabilité dans deux ensembles de données. La syntaxe de la fonction INVERSE.LOI.F est : INVERSE.LOI.F(probability, deg-freedom1, deg-freedom2) où probability est la probabilité associée à la distribution cumulative F. Une valeur numérique supérieure à 0 mais inférieure à 1. deg-freedom1 est le nombre de degrés de liberté du numérateur, une valeur numérique supérieure à 1 et inférieure à 10^10. est le nombre de degrés de liberté du dénominateur, une valeur numérique supérieure à 1 et inférieure à 10^10. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction INVERSE.LOI.F, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction INVERSE.LOI.F, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/fisher.htm", 
        "title": "Fonction FISHER", 
        "body": "La fonction FISHER est l'une des fonctions statistiques. Elle est utilisée pour renvoyer une transformation Fisher d'un nombre. La syntaxe de la fonction FISHER est : FISHER(number) où number est une valeur numérique supérieure à - 1 mais inférieure à 1 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction FISHER, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction FISHER, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/fisherinv.htm", 
        "title": "Fonction FISHER.INVERSE", 
        "body": "La fonction FISHER.INVERSE est l'une des fonctions statistiques. Elle est utilisée pour effectuer une transformation inversée de Fisher. La syntaxe de la fonction FISHER.INVERSE est : FISHER.INVERSE(number) où number est une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction FISHER.INVERSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction FISHER.INVERSE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/fixed.htm", 
        "title": "Fonction CTXT", 
        "body": "La focntion CTXT est l'une des fonctions de texte et de données. Elle est utilisée pour renvoyer la représentation textuelle d'un nombre arrondi au nombre de décimales déterminé. La syntaxe de la fonction CTXT est : CTXT(number [,[num-decimal] [,suppress-commas-flag]) où number est un nombre à arrondir. num-decimal est un nombre de décimales à afficher. C'est un argument facultatif, s'il est omis, la fonction l'assume d'être égal à 2. suppress-commas-flag est une valeur logique. S'il est défini sur TRUE (VRAI), la fonction renvoie le résultat sans virgules. S'il est FALSE (FAUX) ou omis, le résultat est affiché avec des virgules. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction CTXT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction CTXT, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/floor-math.htm", 
        "title": "Fonction PLANCHER.MATH", 
        "body": "La fonction PLANCHER.MATH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir le nombre par défaut à l'entier ou au multiple significatif le plus proche. La syntaxe de la fonction PLANCHER.MATH est : PLANCHER.MATH(x [, [précision] [, [mode]]) où x est le nombre à arrondir. précision est le multiple significatif auquel le nombre doit être arrondi. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 1 est utilisée. mode définit si les nombres négatifs sont arrondis vers ou à partir de zéro. C'est un paramètre facultatif qui n'affecte pas les nombres positifs. Si la valeur est omise ou définie à 0, les nombres négatifs sont arrondis à partir de zéro. Si une autre valeur numérique est spécifiée, les nombres négatifs sont arrondis vers zéro. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PLANCHER.MATH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PLANCHER.MATH, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/floor-precise.htm", 
        "title": "Fonction PLANCHER.PRECIS", 
        "body": "La fonction PLANCHER.PRECIS est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir le nombre par défaut à l'entier ou au multiple significatif le plus proche. Le nombre est toujours arrondi par défaut indépendamment de son signe. La syntaxe de la fonction PLANCHER.PRECIS est : PLANCHER.PRECIS(x [, précision]) où x est le nombre à arrondir. précision est le multiple significatif auquel le nombre doit être arrondi. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 1 est utilisée. Si elle est définie sur 0, la fonction renvoie 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PLANCHER.PRECIS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PLANCHER.PRECIS, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/floor.htm", 
        "title": "Fonction PLANCHER", 
        "body": "La fonction PLANCHER est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir le nombre au multiple le plus proche de signification. La syntaxe de la fonction PLANCHER est : PLANCHER(x, précision) où x est un nombre à arrondir. précision est un multiple auquel le nombre doit être arrondi. Remarque : si x et précision ont des signes différents, la fonction renvoie l'erreur #NOMBRE!. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PLANCHER, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PLANCHER, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/forecast-ets-confint.htm", 
        "title": "Fonction PREVISION.ETS.CONFINT", 
        "body": "La fonction PREVISION.ETS.CONFINT est l'une des fonctions statistiques. Elle est utilisée pour retourner un intervalle de confiance pour la prévision à la date cible spécifiée. La syntaxe de la fonction PREVISION.ETS.CONFINT est : PREVISION.ETS.CONFINT (date_cible, valeurs, chronologie, [seuil_probabilité], [caractère_saisonnier], [saisie_semiautomatique_données], [agrégation]) où date_cible est une date pour laquelle vous voulez prédire une nouvelle valeur. Elle doit être postérieure à la dernière date de la chronologie. valeurs est une plage de valeurs historiques pour lesquelles vous voulez prédire un nouveau point. est une plage de valeurs date / heure qui correspondent aux valeurs historiques. La plage de la chronologie doit être de la même taille que la plage de valeurs. Les valeurs date/heure doivent avoir un pas constant entre elles (bien que jusqu'à 30% des valeurs manquantes puissent être traitées comme spécifié par l'argument saisie_semiautomatique_données et que les valeurs dupliquées puissent être agrégées comme spécifié par l'argument ). seuil_probabilité est une valeur numérique comprise entre 0 et 1 (exclusif) qui indique un seuil de probabilité pour l’intervalle de confiance calculé. C'est un argument facultatif. En cas d'omission, la valeur par défaut de 0,95 est utilisée. caractère_saisonnier est une valeur numérique qui spécifie quelle méthode devrait être utilisée pour détecter le caractère saisonnier. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Comportement 1 ou omise Le caractère saisonnier est détecté automatiquement. Des nombres entiers positifs sont utilisés pour la longueur du motif saisonnier. 0 Aucun caractère saisonnier, la prédiction sera linéaire. un nombre entier supérieur ou égal à 2 Le nombre spécifié est utilisé pour la longueur du motif saisonnier. saisie_semiautomatique_données est une valeur numérique qui spécifie comment traiter les points de données manquants dans la plage de données de la chronologie. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Comportement 1 ou omise Les points manquants sont calculés comme la moyenne des points voisins. 0 Les points manquants sont traités comme des valeurs nulles. agrégation est une valeur numérique qui spécifie quelle fonction doit être utilisée pour agréger des valeurs de temps identiques dans la plage de données chronologie. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Fonctions 1 ou omise MOYENNE 2 NB 3 NBVAL 4 MAX 5 MEDIANE 6 MIN 7 SOMME Pour appliquer la fonction PREVISION.ETS.CONFINT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PREVISION.ETS.CONFINT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/forecast-ets-seasonality.htm", 
        "title": "Fonction PREVISION.ETS.CARACTERESAISONNIER", 
        "body": "La fonction PREVISION.ETS.CARACTERESAISONNIER est l'une des fonctions statistiques. Elle est utilisée pour retourner la durée du modèle de répétition détecté par application pour la série chronologique spécifiée. La syntaxe de la fonction PREVISION.ETS.CARACTERESAISONNIER est : PREVISION.ETS.CARACTERESAISONNIER (valeurs, chronologie, [saisie_semiautomatique_données], [agrégation]) où valeurs est une plage de valeurs historiques pour lesquelles vous voulez prédire un nouveau point. chronologie est une plage de valeurs date / heure qui correspondent aux valeurs historiques. La plage de la chronologie doit être de la même taille que la plage de valeurs. Les valeurs date/heure doivent avoir un pas constant entre elles (bien que jusqu'à 30% des valeurs manquantes puissent être traitées comme spécifié par l'argument saisie_semiautomatique_données et que les valeurs dupliquées puissent être agrégées comme spécifié par l'argument ). saisie_semiautomatique_données est une valeur numérique qui spécifie comment traiter les points de données manquants dans la plage de données de la chronologie. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Comportement 1 ou omise Les points manquants sont calculés comme la moyenne des points voisins. 0 Les points manquants sont traités comme des valeurs nulles. agrégation est une valeur numérique qui spécifie quelle fonction doit être utilisée pour agréger des valeurs de temps identiques dans la plage de données chronologie. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Fonctions 1 ou omise MOYENNE 2 NB 3 NBVAL 4 MAX 5 MEDIANE 6 MIN 7 SOMME Pour appliquer la fonction PREVISION.ETS.CARACTERESAISONNIER, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PREVISION.ETS.CARACTERESAISONNIER, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/forecast-ets-stat.htm", 
        "title": "Fonction PREVISION.ETS.STAT", 
        "body": "La fonction PREVISION.ETS.STAT est l'une des fonctions statistiques. Elle est utilisée pour renvoyer une valeur statistique suite à la prévision de la série chronologique. Le type statistique indique quelle statistique est requise par cette fonction. La syntaxe de la fonction PREVISION.ETS.STAT est : PREVISION.ETS.STAT (valeurs, chronologie, type_statistique, [caractère_saisonnier], [saisie_semiautomatique_données], [agrégation]) où valeurs est une plage de valeurs historiques pour lesquelles vous voulez prédire un nouveau point. chronologie est une plage de valeurs date / heure qui correspondent aux valeurs historiques. La plage de la doit être de la même taille que la plage de . Les valeurs date/heure doivent avoir un pas constant entre elles (bien que jusqu'à 30% des valeurs manquantes puissent être traitées comme spécifié par l'argument saisie_semiautomatique_données et que les valeurs dupliquées puissent être agrégées comme spécifié par l'argument ). type_statistique est une valeur numérique comprise entre 1 et 8 qui spécifie quelle statistique sera retournée. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Statistique 1 Paramètre alpha de l'algorithme ETS - le paramètre de valeur de base. 2 Paramètre bêta de l'algorithme ETS - le paramètre de valeur de tendance. 3 Paramètre gamma de l'algorithme ETS - le paramètre de valeur de saisonnalité. 4 Métrique MASE (erreur moyenne absolue d'échelle) - une mesure de l'exactitude des prévisions. 5 Métrique SMAPE (erreur de pourcentage absolu moyen symétrique) - une mesure de la précision basée sur les erreurs en pourcentage. 6 Métrique MAE (erreur absolue moyenne) - une mesure de l'exactitude des prévisions. 7 Métrique RMSE (erreur quadratique moyenne) - une mesure des différences entre les valeurs prédites et observées. 8 Taille de l'incrément détecté dans la chronologie. caractère_saisonnier est une valeur numérique qui spécifie quelle méthode devrait être utilisée pour détecter le caractère saisonnier. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Comportement 1 ou omise Le caractère saisonnier est détecté automatiquement. Des nombres entiers positifs sont utilisés pour la longueur du motif saisonnier. 0 Aucun caractère saisonnier, la prédiction sera linéaire. un nombre entier supérieur ou égal à 2 Le nombre spécifié est utilisé pour la longueur du motif saisonnier. est une valeur numérique qui spécifie comment traiter les points de données manquants dans la plage de données de la chronologie. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Comportement 1 ou omise Les points manquants sont calculés comme la moyenne des points voisins. 0 Les points manquants sont traités comme des valeurs nulles. agrégation est une valeur numérique qui spécifie quelle fonction doit être utilisée pour agréger des valeurs de temps identiques dans la plage de données chronologie. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Fonctions 1 ou omise MOYENNE 2 NB 3 NBVAL 4 MAX 5 MEDIANE 6 MIN 7 SOMME Pour appliquer la fonction PREVISION.ETS.STAT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PREVISION.ETS.STAT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/forecast-ets.htm", 
        "title": "Fonction PREVISION.ETS", 
        "body": "La fonction PREVISION.ETS est l'une des fonctions statistiques. Elle est utilisée pour prédire une valeur future en fonction des valeurs existantes (historiques) à l’aide de la version AAA de l’algorithme de lissage exponentiel (Exponential Smoothing, ETS). La syntaxe de la fonction PREVISION.ETS est : PREVISION.ETS (date_cible, valeurs, chronologie, [caractère_saisonnier], [saisie_semiautomatique_données], [agrégation]) où date_cible est une date pour laquelle vous voulez prédire une nouvelle valeur. Elle doit être postérieure à la dernière date de la chronologie. valeurs est une plage de valeurs historiques pour lesquelles vous voulez prédire un nouveau point. chronologie est une plage de valeurs date / heure qui correspondent aux valeurs historiques. La plage de la chronologie doit être de la même taille que la plage de valeurs. Les valeurs date/heure doivent avoir un pas constant entre elles (bien que jusqu'à 30% des valeurs manquantes puissent être traitées comme spécifié par l'argument saisie_semiautomatique_données et que les valeurs dupliquées puissent être agrégées comme spécifié par l'argument ). caractère_saisonnier est une valeur numérique qui spécifie quelle méthode devrait être utilisée pour détecter le caractère saisonnier. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Comportement 1 ou omise Le caractère saisonnier est détecté automatiquement. Des nombres entiers positifs sont utilisés pour la longueur du motif saisonnier. 0 Aucun caractère saisonnier, la prédiction sera linéaire. un nombre entier supérieur ou égal à 2 Le nombre spécifié est utilisé pour la longueur du motif saisonnier. saisie_semiautomatique_données est une valeur numérique qui spécifie comment traiter les points de données manquants dans la plage de données de la chronologie. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Comportement 1 ou omise Les points manquants sont calculés comme la moyenne des points voisins. 0 Les points manquants sont traités comme des valeurs nulles. agrégation est une valeur numérique qui spécifie quelle fonction doit être utilisée pour agréger des valeurs de temps identiques dans la plage de données chronologie. C'est un argument facultatif. Les valeurs possibles sont listées dans le tableau ci-dessous. Valeur numérique Fonctions 1 ou omise MOYENNE 2 NB 3 NBVAL 4 MAX 5 MEDIANE 6 MIN 7 SOMME Pour appliquer la fonction PREVISION.ETS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PREVISION.ETS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/forecast-linear.htm", 
        "title": "Fonction PREVISION.LINEAIRE", 
        "body": "La fonction PREVISION.LINEAIRE est l'une des fonctions statistiques. Elle est utilisée pour calculer, ou prédire, une valeur future en utilisant des valeurs existantes; la valeur prédite est une valeur y pour une valeur x donnée. Les valeurs connues sont des valeurs x et des valeurs y existantes, et la nouvelle valeur est prédite en utilisant une régression linéaire. La syntaxe de la fonction PREVISION.LINEAIRE est : PREVISION.LINEAIRE(x, known_y's, known_x's) où x est une valeur x utilisée pour prédire la valeur y, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. known_y's est un tableau de valeurs y connues. known_x's est un tableau de valeurs x connues. Pour appliquer la fonction PREVISION.LINEAIRE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PREVISION.LINEAIRE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/forecast.htm", 
        "title": "Fonction PREVISION", 
        "body": "La fonction PREVISION est l'une des fonctions statistiques. Elle est utilisée pour prédire une valeur future à la base des valeurs existantes fournies. La syntaxe de la fonction PREVISION est : PREVISION(x, array-1, array-2) où x est une valeur x utilisée pour prédire la valeur y, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. array-1(2) ce sont des plages de cellules sélectionnées avec le même nombre d'éléments. Pour appliquer la fonction PREVISION, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PREVISION, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/formulatext.htm", 
        "title": "Fonction FORMULETEXTE", 
        "body": "La fonction FORMULETEXTE est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer une formule en tant que chaîne (c'est-à-dire la chaîne de texte affichée dans la barre de formule si vous sélectionnez la cellule contenant la formule). La syntaxe de la fonction FORMULETEXTE est : FORMULETEXTE(référence) référence est une référence à une cellule initiale ou à une plage de cellules. Si la plage de cellules référencée contient plusieurs formules, la fonction renvoie la valeur de la cellule supérieure gauche de cette plage. Si la cellule référencée ne contient pas de formule, la fonction renvoie la valeur d'erreur N/A. Pour appliquer la fonction FORMULETEXTE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction FORMULETEXTE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/frequency.htm", 
        "title": "Fonction FREQUENCE", 
        "body": "La fonction FREQUENCE est l'une des fonctions statistiques. Elle est utilisée pour calculer la fréquence de la présence des valeurs dans une plage de cellules sélectionnée et afficher la première valeur de la matrice de nombres renvoyée. La syntaxe de la fonction FREQUENCE est : FREQUENCE(data-array, bins-array) où data-array est une plage de cellules sélectionnée dont la fréquence vous souhaitez compter, bins-array est une plage de cellules sélectionnée contenant les intervalle dans lesquelles vous souhaitez grouper les valeurs de data-array. Pour appliquer la fonction FREQUENCE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction FREQUENCE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ftest.htm", 
        "title": "Fonction TEST.F", 
        "body": "La fonction TEST.F est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le résultat d’un test F. Un test F renvoie la probabilité bilatérale que les variances des arguments matrice1 et matrice2 ne présentent pas de différences significatives. Utilisez cette fonction pour comparer les variances de deux échantillons. La syntaxe de la fonction TEST.F est : TEST.F(matrice1, matrice2) où matrice1 est la première plage de valeurs numériques. matrice2 est la deuxième plage de valeurs numériques. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Le texte, les valeurs logiques et les cellules vides sont ignorés, les cellules contenant des valeurs nulles sont incluses. Si le nombre de valeurs dans une plage de données est inférieur à 2 ou si une variance d'un tableau est 0, la fonction renvoie la valeur d'erreur #DIV/0!. Pour appliquer la fonction TEST.F, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction TEST.F, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/fv.htm", 
        "title": "Fonction VC", 
        "body": "La fonction VC est l'une des fonctions financières. Elle est utilisée pour calculer la valeur future d'un investissement à la base du taux d'intérêt spécifié et d'un échéancier de paiement constant. La syntaxe de la fonction VC est : VC(rate, nper, pmt [, [pv] [,[type]]]) où rate est le taux d'intérêt pour l'investissement. nper est le nombre de paiements. pmt est le montant du paiement. pv est la valeur actuelle des paiements. C'est un argument facultatif. Si il est absent, la fonction estime pv égal à 0. type est la période au cours de laquelle les paiements doivent être versés. C'est un argument facultatif. Si il est égal à 0 ou absent, la fonction estime que les paiements doivent être versés à la fin de la période. Si type est égal à 1, les paiements doivent être versés au début de la période. Remarque : les sommes versées ( telles que dépôts d'épargne ) sont représentées par des nombres négatifs ; les sommes reçues ( telles que dividendes ) sont représentées par des nombres positifs. Les unités pour rate et nper doivent être cohérentes : utilisez N%/12 pour rate et N*12 pour nper dans le cas de paiements mensuels, N%/4 pour rate et N*4 pour nper dans le cas de paiements trimestriels, N% pour rate et N pour nper en cas de paiements annuels. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction VC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction VC, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/fvschedule.htm", 
        "title": "Fonction VC.PAIEMENTS", 
        "body": "La fonction VC.PAIEMENTS est l'une des fonctions financières. Elle est utilisée pour calculer la valeur future d'un investissement à la base d'une série de taux d'intérêt changeants. La syntaxe de la fonction VC.PAIEMENTS est : VC.PAIEMENTS(principal, schedule) où principal est la valeur actuelle d'un investissement. schedule est un tableau ou une plage de taux d'intérêt. Remarque : les valeurs peuvent être des nombres ou des cellules vides (elles sont interprétées comme 0). Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction VC.PAIEMENTS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction VC.PAIEMENTS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/gamma-dist.htm", 
        "title": "Fonction LOI.GAMMA.N", 
        "body": "La fonction LOI.GAMMA.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la distribution gamma. La syntaxe de la fonction LOI.GAMMA.N est : LOI.GAMMA.N(x, alpha, beta, cumulative) où x est la valeur pour laquelle la fonction doit être calculée. Une valeur numérique supérieure à 0. alpha est le premier paramètre de la distribution, une valeur numérique supérieure à 0. beta est le second paramètre de la distribution, une valeur numérique supérieure à 0. Si beta est défini sur 1, la fonction renvoie la distribution gamma standard. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de densité de probabilité. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.GAMMA.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.GAMMA.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/gamma-inv.htm", 
        "title": "Fonction LOI.GAMMA.INVERSE.N", 
        "body": "La fonction LOI.GAMMA.INVERSE.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la distribution cumulative gamma. La syntaxe de la fonction LOI.GAMMA.INVERSE.N est : LOI.GAMMA.INVERSE.N(probability, alpha, beta) où probability est la probabilité associée à la distribution gamma. Une valeur numérique supérieure à 0 mais inférieure à 1. alpha est le premier paramètre de la distribution, une valeur numérique supérieure à 0. beta est le second paramètre de la distribution, une valeur numérique supérieure à 0. Si beta est défini sur 1, la fonction renvoie la distribution gamma standard. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.GAMMA.INVERSE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.GAMMA.INVERSE.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/gamma.htm", 
        "title": "Fonction GAMMA", 
        "body": "La fonction GAMMA est l'une des fonctions statistiques. Elle est utilisée pour retourner la valeur de la fonction gamma. La syntaxe de la fonction GAMMA est : GAMMA(number) où number est une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Remarque : si est un entier négatif ou 0, la fonction retourne la valeur d'erreur #NOMBRE!. Pour appliquer la fonction , sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction GAMMA, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/gammadist.htm", 
        "title": "Fonction LOI.GAMMA", 
        "body": "La fonction LOI.GAMMA est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la distribution gamma. La syntaxe de la fonction LOI.GAMMA est : LOI.GAMMA(x, alpha, beta, cumulative) où x est la valeur pour laquelle la fonction doit être calculée. Une valeur numérique supérieure à 0. alpha est le premier paramètre de la distribution, une valeur numérique supérieure à 0. beta est le second paramètre de la distribution, une valeur numérique supérieure à 0. Si beta est défini sur 1, la fonction renvoie la distribution gamma standard. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de densité de probabilité. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.GAMMA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.GAMMA, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/gammainv.htm", 
        "title": "Fonction LOI.GAMMA.INVERSE", 
        "body": "La fonction LOI.GAMMA.INVERSE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la distribution cumulative gamma. La syntaxe de la fonction LOI.GAMMA.INVERSE est : LOI.GAMMA.INVERSE(probability, alpha, beta) où probability est la probabilité associée à la distribution gamma. Une valeur numérique supérieure à 0 mais inférieure à 1. alpha est le premier paramètre de la distribution, une valeur numérique supérieure à 0. beta est le second paramètre de la distribution, une valeur numérique supérieure à 0. Si beta est défini sur 1, la fonction renvoie la distribution gamma standard. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.GAMMA.INVERSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.GAMMA.INVERSE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/gammaln-precise.htm", 
        "title": "Fonction LNGAMMA.PRECIS", 
        "body": "La fonction LNGAMMA.PRECIS est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le logarithme népérien de la fonction Gamma. La syntaxe de la fonction LNGAMMA.PRECIS est : LNGAMMA.PRECIS(x) où x est une valeur numérique supérieure à 0 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction LNGAMMA.PRECIS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LNGAMMA.PRECIS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/gammaln.htm", 
        "title": "Fonction LNGAMMA", 
        "body": "La fonction LNGAMMA est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le logarithme népérien de la fonction Gamma. La syntaxe de la fonction LNGAMMA est : LNGAMMA(nombre) où nombre est une valeur numérique supérieure à 0 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction LNGAMMA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LNGAMMA, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/gauss.htm", 
        "title": "Fonction GAUSS", 
        "body": "La fonction GAUSS est l'une des fonctions statistiques. Elle est utilisée pour calculer la probabilité qu'un membre d'une population normale standard se situe entre la moyenne et les écarts-types z de la moyenne. La syntaxe de la fonction GAUSS est : GAUSS(z) où z est une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction GAUSS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction GAUSS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/gcd.htm", 
        "title": "Fonction PGCD", 
        "body": "La fonction PGCD est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le plus grand dénominateur commun de deux ou plusieurs nombres. La syntaxe de la fonction PGCD est : PGCD(argument-list) où argument-list est une liste contenant jusqu'à 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est référence. Pour appliquer la fonction PGCD, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PGCD, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/geomean.htm", 
        "title": "Fonction MOYENNE.GEOMETRIQUE", 
        "body": "La fonction MOYENNE.GEOMETRIQUE est l'une des fonctions statistiques. Elle est utilisée pour calculer la moyenne géométrique d'une série de données. La syntaxe de la fonction MOYENNE.GEOMETRIQUE est : MOYENNE.GEOMETRIQUE(argument-list) où argument-list est une liste contenant jusqu'à 30 valeurs numériques supérieures à 0 saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction MOYENNE.GEOMETRIQUE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MOYENNE.GEOMETRIQUE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/gestep.htm", 
        "title": "Fonction SUP.SEUIL", 
        "body": "La fonction SUP.SEUIL est l'une des fonctions d'ingénierie. Elle est utilisée pour tester si un nombre est supérieur à une valeur de seuil. La fonction renvoie 1 si le nombre est supérieur ou égal à la valeur de seuil et 0 sinon. La syntaxe de la fonction SUP.SEUIL est : SUP.SEUIL(number [, step]) où number est le nombre à comparer à step. step est la valeur de seuil. C'est un argument facultatif. En cas d'omission, step est estimé à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction SUP.SEUIL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction SUP.SEUIL, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/growth.htm", 
        "title": "Fonction CROISSANCE", 
        "body": "La fonction CROISSANCE est l'une des fonctions statistiques. La fonction CROISSANCE calcule la croissance exponentielle prévue à partir des données existantes. La syntaxe de la fonction CROISSANCE est comme suit: CROISSANCE(y_connus, [x_connus], [x_nouveaux], [constante]) où: y_connus représente la série des valeurs y déjà connues dans l'équation y = b*m^x. x_connus représente une série facultative de valeurs x, éventuellement déjà connues dans l'équation y = b*m^x. x_nouveaux représente la série facultative de variables x pour lesquelles vous voulez renvoyer les valeurs y correspondantes. constante représente un argument facultatif. C'est une valeur VRAI ou FAUX où si l'argument constante est VRAI ou omis, la constante b est calculée normalement, et si l'argument constante est FAUX, b est égal à 1 dans l'équation y = m^x. Pour utiliser la fonction CROISSANCE, sélectionnez la cellule où vous voulez afficher le résultat, appuyez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Statistiques dans la liste, appuyez sur la fonction CROISSANCE, saisissez l'argument approprié et appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/harmean.htm", 
        "title": "Fonction MOYENNE.HARMONIQUE", 
        "body": "La fonction MOYENNE.HARMONIQUE est l'une des fonctions statistiques. Elle est utilisée pour calculer la moyenne harmonique d'une série de données. La syntaxe de la fonction MOYENNE.HARMONIQUE est : MOYENNE.HARMONIQUE(argument-list) où argument-list est une liste contenant jusqu'à 30 valeurs numériques supérieures à 0 saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction MOYENNE.HARMONIQUE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MOYENNE.HARMONIQUE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/hex2bin.htm", 
        "title": "Fonction HEXBIN", 
        "body": "La fonction HEXBIN est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre hexadécimal en binaire. La syntaxe de la fonction HEXBIN est : HEXBIN(number [, num-hex-digits]) où number est un nombre hexadécimal saisie à la main ou incluse dans la cellule à laquelle il est fait référence. num-hex-digits est le nombre de chiffres à afficher. Si omis, la fonction utilisera le nombre minimum. Remarque : si l'argument n'est pas reconnu comme un nombre hexadécimal ou contient plus de 10 caractères, ou si le nombre binaire obtenu nécessite plus de chiffres que vous avez spécifié, ou si le nombre num-hex-digits spécifié est inférieur ou égal à 0, le La fonction retournera l'erreur #NOMBRE!. Pour appliquer la fonction HEXBIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction HEXBIN, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/hex2dec.htm", 
        "title": "Fonction HEXDEC", 
        "body": "La fonction HEXDEC est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre hexadécimal en nombre décimal. La syntaxe de la fonction HEXDEC est : HEXDEC(number) où number est un nombre hexadécimal saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Remarque : si l'argument n'est pas reconnu comme un nombre hexadécimal, ou contient plus de 10 caractères, la fonction retournera l'erreur #NOMBRE!. Pour appliquer la fonction HEXDEC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction HEXDEC, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/hex2oct.htm", 
        "title": "Fonction HEXOCT", 
        "body": "La fonction HEXOCT est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre hexadécimal en octal. La syntaxe de la fonction HEXOCT est : HEXOCT(number [, num-hex-digits]) où number est un nombre hexadécimal saisie à la main ou incluse dans la cellule à laquelle il est fait référence. num-hex-digits est le nombre de chiffres à afficher. Si omis, la fonction utilisera le nombre minimum. Remarque : si l'argument n'est pas reconnu comme un nombre binaire ou contient plus de 10 caractères, ou si le nombre octal obtenu nécessite plus de chiffres que vous avez spécifié, ou si le nombre num-hex-digits spécifié est inférieur ou égal à 0, le La fonction retournera l'erreur #NOMBRE!. Pour appliquer la fonction HEXOCT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction HEXOCT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/hlookup.htm", 
        "title": "Fonction RECHERCHEH - ONLYOFFICE", 
        "body": "Fonction RECHERCHEH La fonction RECHERCHEH est l'une des fonctions de recherche et de référence. Elle est utilisée pour effectuer la recherche horizontale d'une valeur dans la ligne supérieure d'un tableau ou renvoyer la valeur dans la même colonne à la base d'un numéro d'index de la ligne spécifié. La syntaxe de la fonction RECHERCHEH est : RECHERCHEH (lookup-value, table-array, row-index-num[, [range-lookup-flag]]) où lookup-value est une valeur à chercher. table-array ce sont deux ou plusieurs lignes contenant des données classées par ordre croissant. row-index-num est un numéro de ligne dans la même colonne de table-array, une valeur numériaue supérieure ou égale à 1 mais inférieure au nombre de lignes dans table-array. range-lookup-flag est un argument optionnel. C'est une valeur logique : TRUE (vrai) ou FALSE (faux). Entrez FALSE (faux) pour trouver une correspondance exacte. Entrez TRUE (vrai) pour trouver une correspondance approximative, au cas où il n'y a pas de valeur qui correspond strictement à lookup-value, la fonction choisit la valeur plus grande et plus proche inférieure à lookup-value. Si cet argument est absent, la fonction renvoie une correspondance approximative. Remarque : si range-lookup-flag est FALSE (faux), mais aucune correspondance n'est trouvée, alors la fonction renvoie l'erreur #N/A. Comment faire une RECHERCHEH Pour appliquer la fonction RECHERCHEH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction RECHERCHEH, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/hour.htm", 
        "title": "Fonction HEURE", 
        "body": "La fonction HEURE est l'une des fonctions de date et d'heure. Elle renvoie l'heure (nombre de 0 à 23) de la valeur de l'heure. La syntaxe de la fonction HEURE est : HEURE( valeur de temps ) où time-value est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Remarque: time-value peut être entrée sous la forme de chaînes de texte entre guillemets (par exemple \"13:39\"), de caractères décimaux (par exemple. 0.56 qui représente 13:26) , ou de résultats d'autres formules (par exemple le résultat de la fonction NOW au format prédéfini - 9/26/12 13:39) Pour appliquer la fonction HEURE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction HEURE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/hstack.htm", 
        "title": "Fonction ASSEMB.H", 
        "body": "La fonction ASSEMB.H est l'une des fonctions de recherche et de référence. Cette fonction retourne un tableau assemblant horizontalement plusieurs tableaux. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction ASSEMB.H: =ASSEMB.H(matrice1,[matrice2],...) où: matrice sert à définir les matrices à ajouter. Pour appliquer la fonction ASSEMB.H, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction ASSEMB.H, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/hyperlink.htm", 
        "title": "Fonction LIEN_HYPERTEXTE", 
        "body": "La fonction LIEN_HYPERTEXTE est l'une des fonctions de recherche et de référence. Elle est utilisée pour créer un raccourci qui saute à un autre emplacement dans le classeur actuel ou ouvre un document stocké sur un serveur réseau, un intranet ou internet. La syntaxe de la fonction LIEN_HYPERTEXTE est : LIEN_HYPERTEXTE(emplacement_lien, [nom_convivial]) où emplacement_lien est le chemin d'accès et le nom du fichier au document à ouvrir. Dans la version en ligne, le chemin peut être une adresse URL seulement. emplacement_lien peut également faire référence à un certain endroit dans le classeur actuel, par exemple, à une certaine cellule ou à une plage nommée. La valeur peut être spécifiée sous la forme d'une chaîne de texte jointe aux guillemets ou d'une référence à une cellule contenant le lien sous la forme d'une chaîne de texte. nom_convivial est un texte affiché dans la cellule. C'est un argument facultatif. Si elle est omise, la valeur nom_convivial est affichée dans la cellule. Pour appliquer la fonction LIEN_HYPERTEXTE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction LIEN_HYPERTEXTE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Pour ouvrir le lien, cliquez dessus. Pour sélectionner une cellule qui contient un lien sans ouvrir le lien, cliquez et maintenez le bouton de la souris enfoncé."
    },
   {
        "id": "Functions/hypgeom-dist.htm", 
        "title": "Fonction LOI.HYPERGEOMETRIQUE.N", 
        "body": "La fonction LOI.HYPERGEOMETRIQUE.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la probabilité d'une variable aléatoire discrète suivant une loi hypergéométrique. La syntaxe de la fonction LOI.HYPERGEOMETRIQUE.N est : LOI.HYPERGEOMETRIQUE.N(succès_échantillon, nombre_échantillon, succès_population, nombre_pop, cumulative) où succès_échantillon est le nombre de succès dans un échantillon donné, une valeur numérique supérieure à 0 mais inférieure à la plus petite valeur entre nombre_échantillon et succès_population. nombre_échantillon est la taille de l'échantillon, une valeur numérique supérieure à 0 mais inférieure à nombre_pop. succès_population est le nombre de succès dans la population, une valeur numérique supérieure à 0 mais inférieure à nombre_pop. nombre_pop est la taille de la population, une valeur numérique supérieure à 0. cumulative est une valeur logique (TRUE (VRAI) ou FALSE (FAUX)) qui détermine la forme de la fonction. Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de probabilité de masse. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.HYPERGEOMETRIQUE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.HYPERGEOMETRIQUE.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/hypgeomdist.htm", 
        "title": "Fonction LOI.HYPERGEOMETRIQUE", 
        "body": "La fonction LOI.HYPERGEOMETRIQUE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la probabilité d'une variable aléatoire discrète suivant une loi hypergéométrique. La syntaxe de la fonction LOI.HYPERGEOMETRIQUE est : LOI.HYPERGEOMETRIQUE(sample-successes , number-sample , population-successes , number-population) où sample-successes est le nombre de succès dans un échantillon donné, une valeur numérique supérieure à 0 mais inférieure à la plus petite valeur de number-sample ou de population-successes. number-sample est la taille de l'échantillon, une valeur numérique supérieure à 0 mais inférieure à number-population. population-successes est le nombre de succès dans la population, une valeur numérique supérieure à 0 mais inférieure à number-population. number-population est la taille de la population, une valeur numérique supérieure à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.HYPERGEOMETRIQUE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.HYPERGEOMETRIQUE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/if.htm", 
        "title": "Fonction SI", 
        "body": "La fonction SI est l'une des fonctions logiques. Elle sert à analyser une expression logique et renvoyer une valeur si elle est vraie ( TRUE ) et une autre valeur si elle est fausse ( FALSE ). La syntaxe de la fonction SI est : SI(logical_test, value_if_true, value_if_false) où logical_test, value_if_true, value_if_false sont les données saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction SI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction SI, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Par exemple : Il y a trois arguments : logical_test = A1&lt;100, value_if_true = 0, value_if_false = 1, où A1 est 12. Cette expression logique est vraie TRUE. Ainsi, la fonction renvoie 0. Si nous changeons la valeur de A1 de 12 à 112, la fonction renvoie 1 :"
    },
   {
        "id": "Functions/iferror.htm", 
        "title": "Fonction SIERREUR - ONLYOFFICE", 
        "body": "Fonction SIERREUR La fonction SIERREUR est l'une des fonctions logiques. Elle est utilisée pour vérifier s'il y a une erreur dans le premier argument de la formule. La fonction renvoie le résultat de la formule s'il n'y a pas d'erreur, ou la valeur_si_erreur si une formule génère une erreur. La syntaxe de la fonction SIERREUR est : SIERREUR(valeur,valeur_si_erreur,) où valeur et valeur_si_erreur sont les valeurs saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Comment faire formule SIERREUR Pour appliquer la fonction SIERREUR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction SIERREUR, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Par exemple : Il y a deux arguments : valeur = A1/B1, valeur_si_erreur = \"erreur\", où A1 est 12, B1 est 3. La formule dans le premier argument ne contient aucune erreur. Donc, la fonction renvoie le résultat du calcul. Si nous changeons la valeur de B1 3 à 0, comme la division par zéro n'est pas possible, la fonction renvoie erreur."
    },
   {
        "id": "Functions/ifna.htm", 
        "title": "Fonction SI.NON.DISP", 
        "body": "La fonction SI.NON.DISP est l'une des fonctions logiques. Elle est utilisée pour vérifier s'il y a une erreur dans le premier argument de la formule. La fonction renvoie la valeur que vous spécifiez si la formule renvoie la valeur d'erreur #N/A, sinon renvoie le résultat de la formule. La syntaxe de la fonction SI.NON.DISP est : SI.NON.DISP(value, value_if_na) où value est l'argument vérifié pour la valeur d'erreur #N/A. value_if_na est la valeur à renvoyer si la formule évalue à la valeur d'erreur #N/A. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction SI.NON.DISP, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction SI.NON.DISP, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ifs.htm", 
        "title": "Fonction SI.CONDITIONS", 
        "body": "La fonction SI.CONDITIONS est l'une des fonctions logiques. Elle est utilisée pour vérifier si une ou plusieurs conditions sont remplies et renvoie une valeur correspondant à la première condition VRAI. La syntaxe de la fonction SI.CONDITIONS est : IFS(test_logique1, valeur_si_vrai1, [test_logique2, valeur_si_vrai2], ...) où test_logique1 est la première condition à être évaluée à VRAI ou FAUX. valeur_si_vrai1 est la valeur renvoyée si le test_logique1 est VRAI. test_logique2, valeur_si_vrai2, ... sont des conditions et des valeurs supplémentaires à renvoyer. Ces arguments sont facultatifs. Vous pouvez évaluer jusqu’à 127 conditions. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Comment faire une SI.CONDITIONS Pour appliquer la fonction SI.CONDITIONS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction SI.CONDITIONS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Par exemple : Avec les arguments suivants: test_logique1 = A1&lt;100, valeur_si_vrai1 = 1, test_logique2 = A1&gt;100, valeur_si_vrai2 = 2, où est 120. La deuxième expression logique vaut VRAI. Ainsi, la fonction renvoie 2."
    },
   {
        "id": "Functions/imabs.htm", 
        "title": "Fonction COMPLEXE.MODULE", 
        "body": "La fonction COMPLEXE.MODULE est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la valeur absolue d'un nombre complexe. La syntaxe de la fonction COMPLEXE.MODULE est : COMPLEXE.MODULE(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.MODULE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.MODULE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imaginary.htm", 
        "title": "Fonction COMPLEXE.IMAGINAIRE", 
        "body": "La fonction COMPLEXE.IMAGINAIRE est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la partie entière du nombre complexe spécifié. La syntaxe de la fonction COMPLEXE.IMAGINAIRE est : COMPLEXE.IMAGINAIRE(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.IMAGINAIRE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.IMAGINAIRE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imargument.htm", 
        "title": "Fonction COMPLEXE.ARGUMENT", 
        "body": "La fonction COMPLEXE.ARGUMENT est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer l'argument Theta, un angle exprimé en radians. La syntaxe de la fonction COMPLEXE.ARGUMENT est : COMPLEXE.ARGUMENT(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.ARGUMENT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.ARGUMENT, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imconjugate.htm", 
        "title": "Fonction COMPLEXE.CONJUGUE", 
        "body": "La fonction COMPLEXE.CONJUGUE est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le conjugué complexe d’un nombre complexe. La syntaxe de la fonction COMPLEXE.CONJUGUE est : COMPLEXE.CONJUGUE(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x + yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.CONJUGUE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.CONJUGUE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imcos.htm", 
        "title": "Fonction COMPLEXE.COS", 
        "body": "La fonction COMPLEXE.COS est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le cosinus d’un nombre complexe. La syntaxe de la fonction COMPLEXE.COS est : COMPLEXE.COS(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.COS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.COS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imcosh.htm", 
        "title": "Fonction COMPLEXE.COSH", 
        "body": "La fonction COMPLEXE.COSH est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le cosinus hyperbolique d'un nombre complexe. La syntaxe de la fonction COMPLEXE.COSH est : COMPLEXE.COSH(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.COSH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.COSH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imcot.htm", 
        "title": "Fonction COMPLEXE.COT", 
        "body": "La fonction COMPLEXE.COT est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la cotangente d’un nombre complexe. La syntaxe de la fonction COMPLEXE.COT est : COMPLEXE.COT(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.COT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.COT, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imcsc.htm", 
        "title": "Fonction COMPLEXE.CSC", 
        "body": "La fonction COMPLEXE.CSC est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la cosécante d’un nombre complexe. La syntaxe de la fonction COMPLEXE.CSC est : COMPLEXE.CSC(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.CSC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.CSC, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imcsch.htm", 
        "title": "Fonction COMPLEXE.CSCH", 
        "body": "La fonction COMPLEXE.CSCH est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la cosécante hyperbolique d'un nombre complexe. La syntaxe de la fonction COMPLEXE.CSCH est : COMPLEXE.CSCH(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.CSCH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.CSCH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imdiv.htm", 
        "title": "Fonction COMPLEXE.DIV", 
        "body": "La fonction COMPLEXE.DIV est l'une des fonctions d'ingénierie. Elle est utilisée pour retourner le quotient de deux nombres complexes exprimés en forme x + yi ou x + yj. La syntaxe de la fonction COMPLEXE.DIV est : COMPLEXE.DIV(complex-number-1, complex-number-2) où complex-number-1 est un dividende. complex-number-2 est un diviseur. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction COMPLEXE.DIV, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.DIV, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imexp.htm", 
        "title": "Fonction COMPLEXE.EXP", 
        "body": "La fonction COMPLEXE.EXP est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la constante e élevée à la puissance spécifiée par un nombre complexe. La constante e est égale à 2,71828182845904. La syntaxe de la fonction COMPLEXE.EXP est : COMPLEXE.EXP(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.EXP, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.EXP, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imln.htm", 
        "title": "Fonction COMPLEXE.LN", 
        "body": "La fonction COMPLEXE.LN est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le logarithme naturel d'un nombre complexe. La syntaxe de la fonction COMPLEXE.LN est : COMPLEXE.LN(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.LN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.LN, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imlog10.htm", 
        "title": "Fonction COMPLEXE.LOG10", 
        "body": "La fonction COMPLEXE.LOG10 est l'une des fonctions d'ingénierie. Elle est utilisée pour calculer le logarithme en base 10 d'un nombre complexe. La syntaxe de la fonction COMPLEXE.LOG10 est : COMPLEXE.LOG10(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.LOG10, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.LOG10, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imlog2.htm", 
        "title": "Fonction COMPLEXE.LOG2", 
        "body": "La fonction COMPLEXE.LOG2 est l'une des fonctions d'ingénierie. Elle est utilisée pour calculer le logarithme en base 2 d'un nombre complexe. La syntaxe de la fonction COMPLEXE.LOG2 est : COMPLEXE.LOG2(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.LOG2, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.LOG2, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/impower.htm", 
        "title": "Fonction COMPLEXE.PUISSANCE", 
        "body": "La fonction COMPLEXE.PUISSANCE est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le résultat d'un nombre complexe élevé à la puissance désirée. La syntaxe de la fonction COMPLEXE.PUISSANCE est : COMPLEXE.PUISSANCE(complex-number, power) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. power représente l'exposant auquel le nombre complexe est élevé. Pour appliquer la fonction COMPLEXE.PUISSANCE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.PUISSANCE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/improduct.htm", 
        "title": "Fonction COMPLEXE.PRODUIT", 
        "body": "La fonction COMPLEXE.PRODUIT est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le produit des nombres complexes spécifiés. La syntaxe de la fonction COMPLEXE.PRODUIT est : COMPLEXE.PRODUIT(argument-list) où argument-list ce sont 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction COMPLEXE.PRODUIT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.PRODUIT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imreal.htm", 
        "title": "Fonction COMPLEXE.REEL", 
        "body": "La fonction COMPLEXE.REEL est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la partie entière du nombre complexe spécifié. La syntaxe de la fonction COMPLEXE.REEL est : COMPLEXE.REEL(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.REEL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.REEL, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imsec.htm", 
        "title": "Fonction COMPLEXE.SEC", 
        "body": "La fonction COMPLEXE.SEC est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la sécante d'un nombre complexe. La syntaxe de la fonction COMPLEXE.SEC est : COMPLEXE.SEC(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x + yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.SEC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.SEC, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imsech.htm", 
        "title": "Fonction COMPLEXE.SECH", 
        "body": "La fonction COMPLEXE.SECH est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la sécante hyperbolique d'un nombre complexe. La syntaxe de la fonction COMPLEXE.SECH est : COMPLEXE.SECH(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x + yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.SECH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.SECH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imsin.htm", 
        "title": "Fonction COMPLEXE.SIN", 
        "body": "La fonction COMPLEXE.SIN est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le sinus d’un nombre complexe. La syntaxe de la fonction COMPLEXE.SIN est : COMPLEXE.SIN(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.SIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.SIN, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imsinh.htm", 
        "title": "Fonction COMPLEXE.SINH", 
        "body": "La fonction COMPLEXE.SINH est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer le sinus hyperbolique d'un nombre complexe. La syntaxe de la fonction COMPLEXE.SINH est : COMPLEXE.SINH(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.SINH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.SINH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imsqrt.htm", 
        "title": "Fonction COMPLEXE.RACINE", 
        "body": "La fonction COMPLEXE.RACINE est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la racine carrée d'un nombre complexe. La syntaxe de la fonction COMPLEXE.RACINE est : COMPLEXE.RACINE(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x + yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.RACINE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.RACINE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imsub.htm", 
        "title": "Fonction COMPLEXE.DIFFERENCE", 
        "body": "La fonction COMPLEXE.DIFFERENCE est l'une des fonctions d'ingénierie. Elle est utilisée pour retourner la différence de deux nombres complexes exprimés sous la forme x + yi ou x + yj. La syntaxe de la fonction COMPLEXE.DIFFERENCE est : COMPLEXE.DIFFERENCE(complex-number-1, complex-number-2) où complex-number-1 est un nombre complexe d'où le nombre complex-number-2 doit être soustrait. complex-number-2 est un nombre complexe à soustraire de complex-number-1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction COMPLEXE.DIFFERENCE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.DIFFERENCE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imsum.htm", 
        "title": "Fonction COMPLEXE.SOMME", 
        "body": "La fonction COMPLEXE.SOMME est l'une des fonctions logiques. Elle est utilisée pour renvoyer la somme des nombres complexes spécifiés. La syntaxe de la fonction COMPLEXE.SOMME est : COMPLEXE.SOMME(argument-list) où argument-list ce sont 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction COMPLEXE.SOMME, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.SOMME, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/imtan.htm", 
        "title": "Fonction COMPLEXE.TAN", 
        "body": "La fonction COMPLEXE.TAN est l'une des fonctions d'ingénierie. Elle est utilisée pour renvoyer la tangente d’un nombre complexe. La syntaxe de la fonction COMPLEXE.TAN est : COMPLEXE.TAN(complex-number) où complex-number est un nombre complexe exprimé sous la forme x + yi ou x+ yj entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Pour appliquer la fonction COMPLEXE.TAN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction COMPLEXE.TAN, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/index.htm", 
        "title": "Fonction INDEX", 
        "body": "La fonction INDEX est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer une valeur dans une plage de cellules sur la base d'un numéro de ligne et de colonne spécifié. La fonction INDEX a deux formes. La syntaxe de la fonction INDEX sous forme de tableau est : INDEX(array, [row-number][, [column-number]]) La syntaxe de la fonction INDEX sous forme de référence est : INDEX(reference, [row-number][, [column-number][, [area-number]]]) où array est une plage de cellules. reference est une référence à une plage de cellules. row-number est le numéro de ligne dont vous souhaitez renvoyer une valeur. En cas d'omission, column-number est requis. column-number est le numéro de colonne dont vous souhaitez renvoyer une valeur. En cas d'omission, row-number est requis. area-number est une zone à utiliser dans le cas où le tableau contient plusieurs plages. C'est un argument facultatif. En cas d'omission, area-number est estimé à 1. Ces arguments peuvent être saisis à la main ou inclus dans les cellules auxquelles il est fait référence. Pour appliquer la fonction INDEX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction INDEX, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/indirect.htm", 
        "title": "Fonction INDIRECT", 
        "body": "La fonction INDIRECT est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer la référence à une cellule en fonction de sa représentation sous forme de chaîne. La syntaxe de la fonction INDIRECT est : INDIRECT(ref-text [, A1-ref-style-flag]) où ref-text is a text representation of a cell. A1-ref-style-flag is a representation style. It is an optional logical value: TRUE (VRAI) ou FALSE (FAUX). Si elle est définie sur TRUE (VRAI) ou omise, la fonction analysera ref-text comme une référence de style A1. Si FALSE (FAUX), la fonction interprétera ref-text comme une référence de style R1C1. Pour appliquer la fonction INDIRECT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction INDIRECT, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/int.htm", 
        "title": "Fonction ENT", 
        "body": "La fonction ENT est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour analyser et renvoyer la partie entière du nombre spécifié. La syntaxe de la fonction ENT est : ENT(x) où x est une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Remarque: si le x est négatif, la fonction renvoie le premier nombre négatif qui est inférieur ou égal au nombre sélectionné. Pour appliquer la fonction ENT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ENT, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/intercept.htm", 
        "title": "Fonction ORDONNEE.ORIGINE", 
        "body": "La fonction ORDONNEE.ORIGINE est l'une des fonctions statistiques. Elle est utilisée pour analyser les valeurs de la première matrice et de la deuxième pour calculer le point d'intersection. La syntaxe de la fonction ORDONNEE.ORIGINE est : ORDONNEE.ORIGINE(array-1, array-2) où array-1(2) ce sont des plages de cellules sélectionnées avec le même nombre d'éléments (colonnes et lignes). Pour appliquer la fonction ORDONNEE.ORIGINE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction ORDONNEE.ORIGINE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/intrate.htm", 
        "title": "Fonction TAUX.INTERET", 
        "body": "La fonction TAUX.INTERET est l'une des fonctions financières. Elle sert à calculer le taux d'intérêt d'un titre entièrement investi qui ne rapporte des intérêts à l'échéance. La syntaxe de la fonction TAUX.INTERET est : TAUX.INTERET(settlement, maturity, pr, redemption[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. pr est le montant payé pour le titre. redemption est le montant reçu pour la garantie à l'échéance. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TAUX.INTERET, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction TAUX.INTERET, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ipmt.htm", 
        "title": "Fonction INTPER", 
        "body": "La fonction INTPER est l'une des fonctions financières. Elle est utilisée pour calculer le paiement d'intérêts pour un investissement basé sur un taux d'intérêt spécifié et d'un échéancier de paiement constant. La syntaxe de la fonction INTPER est : INTPER(rate, per, nper, pv [, [fv] [,[type]]]) où rate est le taux d'intérêt pour l'investissement. per est la période pour laquelle vous voulez trouver le paiement d'intérêts. La valeur doit être comprise entre 1 et nper. nper est le nombre de paiements. pv est la valeur actuelle des paiements. fv est une valeur future (c'est-à-dire un solde de trésorerie restant après le dernier paiement). C'est un argument facultatif. Si il est absent, fv est estimé à 0. type est la période au cours de laquelle les paiements doivent être versés. C'est un argument facultatif. Si il est égal à 0 ou absent, la fonction estime que les paiements doivent être versés à la fin de la période. Si type est égal à 1, les paiements doivent être versés au début de la période. Remarque : les sommes versées ( telles que dépôts d'épargne ) sont représentées par des nombres négatifs ; les sommes reçues ( telles que dividendes ) sont représentées par des nombres positifs. Les unités pour rate et nper doivent être cohérentes : utilisez N%/12 pour rate et N*12 pour nper dans le cas de paiements mensuels, N%/4 pour rate et N*4 pour nper dans le cas de paiements trimestriels, N% pour rate et N pour nper en cas de paiements annuels. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction INTPER, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction INTPER, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/irr.htm", 
        "title": "Fonction TRI", 
        "body": "La fonction TRI est l'une des fonctions financières. Elle est utilisée pour calculer le taux de rendement interne d'une série de flux de trésorerie périodiques. La syntaxe de la fonction TRI est : TRI(values [,[guess]]) où values est un tableau qui contient la série de paiements survenant à des périodes régulières. Au moins une des valeurs doit être négative et au moins une positive. guess est une estimation du taux de rendement interne. C'est un argument facultatif. En cas d'omission, guess est estimé à 10%. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TRI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction TRI, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/isblank.htm", 
        "title": "Fonction ESTVIDE", 
        "body": "La focntion ESTVIDE est l'une des fonctions d'information. Elle est utilisée pour vérifier si la cellule est vide ou non. Si la cellule ne contient pas de valeur, la fonction renvoie vrai ( TRUE ), sinon la fonction renvoie faux ( FALSE ). La syntaxe de la fonction ESTVIDE est : ESTVIDE(valeur) où valeur est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ESTVIDE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction ESTVIDE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/iserr.htm", 
        "title": "Fonction ESTERR", 
        "body": "La fonction ESTERR est l'une des fonctions d'information. Elle est utilisée pour vérifier une valeur d'erreur. Si la cellule contient une valeur d'erreur (à l'exception de #N/A), la fonction renvoie vrai ( TRUE ), sinon la fonction renvoie faux ( FALSE ). La syntaxe de la fonction ESTERR est : ESTERR(valeur) où valeur est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ESTERR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction ESTERR, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/iserror.htm", 
        "title": "Fonction ESTERREUR", 
        "body": "La fonction ESTERREUR est l'une des fonctions d'information. Elle est utilisée pour vérifier une valeur d'erreur. Si la cellule contient une des valeurs d'erreur : #N/A, #VALEUR!, #REF!, #DIV/0!, #NOMBRE!, #NOM? ou #NUL!, la fonction renvoie vrai ( TRUE ), sinon la fonction renvoie faux ( FALSE ). La syntaxe de la fonction ESTERREUR est : ESTERREUR(valeur) où valeur est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ESTERREUR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction ESTERREUR, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/iseven.htm", 
        "title": "Fonction EST.PAIR", 
        "body": "La fonction EST.PAIR est l'une des fonctions d'information. Elle est utilisée pour vérifier une valeur paire. Si la cellule contient une valeur paire, la fonction renvoie vrai ( TRUE ). Si la valeur est impaire, elle renvoie faux ( FALSE ). La syntaxe de la fonction EST.PAIR est : EST.PAIR(nombre) où nombre est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Remarque: si nombre est une valeur non numérique, EST.PAIR renvoie la valeur d'erreur #VALEUR!. Pour appliquer la fonction EST.PAIR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction EST.PAIR, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/isformula.htm", 
        "title": "Fonction ESTFORMULE", 
        "body": "La fonction ESTFORMULE est l'une des fonctions d'information. Elle est utilisée pour vérifier s'il existe une référence à une cellule contenant une formule. Si la cellule contient une formule, la fonction renvoie vrai (TRUE), sinon la fonction renvoie faux (FALSE). La syntaxe de la fonction ESTFORMULE est : ESTFORMULE(value) où value est une référence à une cellule. Pour appliquer la fonction ESTFORMULE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction ESTFORMULE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/islogical.htm", 
        "title": "Fonction ESTLOGIQUE", 
        "body": "La fonction ESTLOGIQUE est l'une des fonctions d'information. Elle est utilisée pour vérifier une valeur logique (TRUE ou FALSE). Si la cellule contient une valeur logique, la fonction renvoie vrai ( TRUE ), sinon la fonction renvoie faux ( FALSE ). La syntaxe de la fonction ESTLOGIQUE est : ESTLOGIQUE(valeur) où valeur est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ESTLOGIQUE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction ESTLOGIQUE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/isna.htm", 
        "title": "Fonction ESTNA", 
        "body": "La fonction ESTNA est l'une des fonctions d'information. Elle est utilisée pour vérifier une erreur #N/A. Si la cellule contient une valeur d'erreur #N/A, la fonction renvoie vrai ( TRUE ), sinon la fonction renvoie faux ( FALSE ). La syntaxe de la fonction ESTNA est : ESTNA(valeur) où valeur est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ESTNA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction ESTNA, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/isnontext.htm", 
        "title": "Fonction ESTNONTEXTE", 
        "body": "La fonction ESTNONTEXTE est l'une des fonctions d'information. Elle est utilisée pour vérifier si une valeur ne correspond pas au texte. Si la cellule ne contient pas une valeur de texte, la fonction renvoie vrai ( TRUE ), sinon la fonction renvoie faux ( FALSE ). La syntaxe de la fonction ESTNONTEXTE est : ESTNONTEXTE(valeur) où valeur est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ESTNONTEXTE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction ESTNONTEXTE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/isnumber.htm", 
        "title": "Fonction ESTNUM", 
        "body": "La fonction ESTNUM est l'une des fonctions d'information. Elle est utilisée pour vérifier une valeur numérique. Si la cellule contient une valeur numérique, la fonction renvoie vrai ( TRUE ), sinon la fonction renvoie faux ( FALSE ). La syntaxe de la fonction ESTNUM est : ESTNUM(valeur) où valeur est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ESTNUM, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction ESTNUM, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/iso-ceiling.htm", 
        "title": "Fonction ISO.PLAFOND", 
        "body": "La fonction ISO.PLAFOND est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir le nombre à l'excès à l'entier ou au multiple significatif le plus proche. Le nombre est toujours arrondi à l'excès indépendamment de son signe. La syntaxe de la fonction ISO.PLAFOND est : ISO.PLAFOND(nombre [, précision]) où nombre est le nombre à arrondir. précision est le multiple significatif auquel le nombre doit être arrondi. C'est un paramètre optionnel. En cas d'omission, la valeur par défaut de 1 est utilisée. Si elle est définie sur 0, la fonction renvoie 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction ISO.PLAFOND, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ISO.PLAFOND, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/isodd.htm", 
        "title": "Fonction EST.IMPAIR", 
        "body": "La fonction EST.IMPAIR est l'une des fonctions d'information. Elle est utilisée pour vérifier une valeur impaire. Si la cellule contient une valeur impaire, la fonction renvoie vrai ( TRUE ). Si la valeur est paire elle renvoie faux ( FALSE ). La syntaxe de la fonction EST.IMPAIR est : EST.IMPAIR(nombre) où nombre est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Remarque: si nombre est une valeur non numérique, EST.IMPAIR renvoie la valeur d'erreur #VALEUR!. Pour appliquer la fonction EST.IMPAIR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction EST.IMPAIR, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/isoweeknum.htm", 
        "title": "Fonction NO.SEMAINE.ISO", 
        "body": "La fonction NO.SEMAINE.ISO est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer le numéro ISO de la semaine de l'année pour une date donnée. Renvoie un nombre entre 1 et 54. La syntaxe de la fonction NO.SEMAINE.ISO est : NO.SEMAINE.ISO(date) où date est une date à laquelle vous voulez trouver le numéro ISO de semaine. Peut être une référence à une cellule contenant une date ou une date renvoyée par la fonction Date ou une autre fonction de date et d'heure. Pour appliquer la fonction NO.SEMAINE.ISO, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction NO.SEMAINE.ISO, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ispmt.htm", 
        "title": "Fonction ISPMT", 
        "body": "La fonction ISPMT est l'une des fonctions financières. Elle est utilisée pour calculer le paiement d'intérêts pour une période déterminée d'un investissement basé sur un échéancier de paiement constant. La syntaxe de la fonction ISPMT est : ISPMT(rate, per, nper, pv) où rate est le taux d'intérêt pour l'investissement. per est la période pour laquelle vous voulez trouver le paiement d'intérêts. La valeur doit être comprise entre 1 et nper. nper est le nombre de paiements. pv est la valeur actuelle des paiements. Remarque : les sommes versées ( telles que dépôts d'épargne ) sont représentées par des nombres négatifs ; les sommes reçues ( telles que dividendes ) sont représentées par des nombres positifs. Les unités pour rate et nper doivent être cohérentes : utilisez N%/12 pour rate et N*12 pour nper dans le cas de paiements mensuels, N%/4 pour rate et N*4 pour nper dans le cas de paiements trimestriels, N% pour rate et N pour nper en cas de paiements annuels. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction ISPMT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction ISPMT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/isref.htm", 
        "title": "Fonction ESTREF", 
        "body": "La fonction ESTREF est l'une des fonctions d'information. Elle est utilisée pour vérifier une référence. La syntaxe de la fonction ESTREF est : ESTREF(valeur) où valeur est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ESTREF, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction ESTREF, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Si la cellule est une référence valide, la fonction renvoie vrai (TRUE). Sinon la fonction renvoie faux (FALSE)."
    },
   {
        "id": "Functions/istext.htm", 
        "title": "Fonction ESTTEXTE", 
        "body": "La fonction ESTTEXTE est l'une des fonctions d'information. Elle est utilisée pour vérifier une valeur de texte. Si la cellule contient une valeur de texte, la fonction renvoie vrai ( TRUE ), sinon la fonction renvoie faux ( FALSE ). La syntaxe de la fonction ESTTEXTE est : ESTTEXTE(valeur) où valeur est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ESTTEXTE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction ESTTEXTE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/kurt.htm", 
        "title": "Fonction KURTOSIS", 
        "body": "La fonction KURTOSIS est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le kurtosis d'une série de données. La syntaxe de la fonction KURTOSIS est : KURTOSIS(argument-list) où argument-list est une liste de valeurs numériques jusqu'à 30 valeurs saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction KURTOSIS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction KURTOSIS, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/large.htm", 
        "title": "Fonction GRANDE.VALEUR", 
        "body": "La fonction GRANDE.VALEUR est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de cellules et renvoyer la k-ième plus grande valeur. La syntaxe de la fonction GRANDE.VALEUR est : GRANDE.VALEUR(array, k) où array est une plage de cellules à analyser. k est la position du nombre à partir de la plus grande valeur, une valeur numérique supérieure à 0 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction GRANDE.VALEUR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction GRANDE.VALEUR, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/lcm.htm", 
        "title": "Fonction PPCM", 
        "body": "La fonction PPCM est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le plus petit dénominateur commun de deux ou plusieurs nombres. La syntaxe de la fonction PPCM est : PPCM(argument-list) où argument-list est une liste de valeurs numériques jusqu'à 30 valeurs saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PPCM, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PPCM, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/left.htm", 
        "title": "Fonction GAUCHE/GAUCHEB", 
        "body": "La focntion GAUCHE/GAUCHEB est l'une des fonctions de texte et de données. Elle est utilisée pour extraire la sous-chaîne de la chaîne spécifiée à partir du caractère gauche. La fonction GAUCHE est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que GAUCHEB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction GAUCHE/GAUCHEB est : GAUCHE(string [, number-chars]) GAUCHEB(string [, number-chars]) où string est la chaîne de laquelle vous voulez extraire la sous-chaîne, number-chars est le nombre de caractères dans la sous-chaîne. C'est un argument facultatif. S'il est omis, la fonction l'assume d'être égal à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction GAUCHE/GAUCHEB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction GAUCHE/GAUCHEB, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/leftb.htm", 
        "title": "Fonction GAUCHE/GAUCHEB", 
        "body": "La focntion GAUCHE/GAUCHEB est l'une des fonctions de texte et de données. Elle est utilisée pour extraire la sous-chaîne de la chaîne spécifiée à partir du caractère gauche. La fonction GAUCHE est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que GAUCHEB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction GAUCHE/GAUCHEB est : GAUCHE(string [, number-chars]) GAUCHEB(string [, number-chars]) où string est la chaîne de laquelle vous voulez extraire la sous-chaîne, number-chars est le nombre de caractères dans la sous-chaîne. C'est un argument facultatif. S'il est omis, la fonction l'assume d'être égal à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction GAUCHE/GAUCHEB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction GAUCHE/GAUCHEB, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/len.htm", 
        "title": "Fonction NBCAR/LENB", 
        "body": "La focntion NBCAR/LENB est l'une des fonctions de texte et de données. Elle est utilisée pour analyser une chaîne de caractères et renvoyer leur nombre. La fonction NBCAR est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que LENB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction NBCAR/LENB est : NBCAR(string) LENB(string) où string est une chaîne de caractères saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction NBCAR/LENB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction NBCAR/LENB, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/lenb.htm", 
        "title": "Fonction NBCAR/LENB", 
        "body": "La focntion NBCAR/LENB est l'une des fonctions de texte et de données. Elle est utilisée pour analyser une chaîne de caractères et renvoyer leur nombre. La fonction NBCAR est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que LENB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction NBCAR/LENB est : NBCAR(string) LENB(string) où string est une chaîne de caractères saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction NBCAR/LENB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction NBCAR/LENB, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/linest.htm", 
        "title": "La fonction DROITEREG", 
        "body": "La fonction DROITEREG est l'une des fonctions statistiques. Calcule les statistiques pour un modèle linéaire par la méthode des moindres carrés, afin de calculer une relation linéaire qui s'ajuste au plus près à vos données, puis renvoie une matrice décrivant cette droite. Dans la mesure où cette fonction renvoie une matrice de valeurs, elle doit être tapée sous la forme d’une formule matricielle. La syntaxe de la fonction DROITEREG est comme suit: DROITEREG(y_connus, [x_connus], [constante], [statistiques]) où: y_connus est la série des valeurs y déjà connues par la relation y = mx + b. C'est un argument obligatoire. x_connus est la série des valeurs x déjà connues par la relation y = mx + b. C'est un argument obligatoire. Si l’argument x_connus est omis, il est supposé égal à la matrice {1.2.3....}, de même ordre que l’argument y_connus. constante est une valeur qui indique si la constante b doit être égale à 0. C'est un argument facultatif. Si l'argument constante est VRAI ou omis, la constante b est calculée normalement. Si l'argument constante est FAUX, b est égal à 0. statistiques est une valeur logique indiquant si des statistiques de régression supplémentaires doivent être renvoyées. C'est un argument facultatif. Si l'argument statistique est VRAI, la fonction renvoie des statistiques de régression supplémentaires. Si l'argument statistique est FAUX ou omis, la fonction ne renvoie pas des statistiques de régression supplémentaires. Pour utiliser la fonction DROITEREG, sélectionnez la cellule où vous voulez afficher le résultat, appuyez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Statistiques dans la liste, appuyez sur la fonction DROITEREG, saisissez les arguments appropriés écrits avec des virgules pour les séparer ou sélectionnez une plage de cellules avec votre souris, appuyez sur la touche Entrée. La première valeur de la matrice résultante s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/ln.htm", 
        "title": "Fonction LN", 
        "body": "La fonction LN est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le logarithme naturel d'un nombre. La syntaxe de la fonction LN est : LN(x) où x est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Elle doit être supérieure à 0. Pour appliquer la fonction LN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction LN, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/log.htm", 
        "title": "Fonction LOG", 
        "body": "La fonction LOG est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le logarithme d'un nombre à la base spécifiée. La syntaxe de la fonction LOG est : LOG(x [,base]) où x est une valeur numérique supérieure à 0 base est la base utilisée pour calculer le logarithme d'un nombre. C'est un paramètre optionnel. Si base est omis, la valeur par défaut est 10. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOG, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction LOG, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/log10.htm", 
        "title": "Fonction LOG10", 
        "body": "La fonction LOG10 est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour calculer le logarithme en base 10 d'un nombre. La syntaxe de la fonction LOG10 est : LOG10(x) où x est une valeur numérique supérieure à 0 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction LOG10, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction LOG10, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/logest.htm", 
        "title": "Fonction LOGREG", 
        "body": "La fonction LOGREG est l'une des fonctions statistiques. La fonction LOGREG calcule une courbe exponentielle qui correspond à vos données et renvoie une matrice de valeurs qui décrivent la courbe. La syntaxe de la fonction LOGREG est comme suit: LOGREG(y_connus, [x_connus], [constante], [statistiques]) où: y_connus représente la série des valeurs y déjà connues dans l'équation y = b*m^x. x_connus représente une série facultative de valeurs x, éventuellement déjà connues dans l'équation y = b*m^x. constante représente un argument facultatif. C'est une valeur VRAI ou FAUX où si l'argument constante est VRAI ou omis, la constante b est calculée normalement, et si l'argument constante est FAUX, b est égal à 1 dans l'équation y = b*m^x et les valeurs m sont ajustées pour que y = m^x. statistiques représente un argument facultatif. C'est une valeur VRAI ou FAUX indiquant si d'autres statistiques de régression doivent être renvoyées. Pour utiliser la fonction LOGREG, sélectionnez la cellule où vous voulez afficher le résultat, appuyez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Statistiques dans la liste, appuyez sur la fonction LOGREG, saisissez l'argument approprié et appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/loginv.htm", 
        "title": "Fonction LOI.LOGNORMALE.INVERSE", 
        "body": "La fonction LOI.LOGNORMALE.INVERSE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la fonction de distribution de x suivant une loi lognormale cumulée en utilisant les paramètres spécifiés. La syntaxe de la fonction LOI.LOGNORMALE.INVERSE est : LOI.LOGNORMALE.INVERSE(x, mean, standard-deviation) où x est la probabilité associée à la distribution lognormale, une valeur numérique supérieure ou égale à 0 mais inférieure ou égale à 1. mean est la moyenne de la distribution de x suivant une loi lognormale, une valeur numérique. standard-deviation est l'écart type de la distribution de x suivant une loi lognormale, une valeur numérique supérieure à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.LOGNORMALE.INVERSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.LOGNORMALE.INVERSE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/lognorm-dist.htm", 
        "title": "Fonction LOI.LOGNORMALE.N", 
        "body": "La fonction LOI.LOGNORMALE.N est l'une des fonctions statistiques. Elle est utilisée pour retourner la distribution log-normale de x, où ln() est normalement distribué avec les paramètres mean et standard-dev. La syntaxe de la fonction LOI.LOGNORMALE.N est : LOI.LOGNORMALE.N(x, mean, standard-dev, cumulative) où x est la valeur pour laquelle la fonction doit être calculée. Une valeur numérique supérieure à 0. mean est la moyenne de la distribution de x suivant une loi lognormale, une valeur numérique. standard-dev est l'écart type de la distribution de ln(x) suivant une loi lognormale, une valeur numérique supérieure à 0. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de densité de probabilité. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.LOGNORMALE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.LOGNORMALE.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/lognorm-inv.htm", 
        "title": "Fonction LOI.LOGNORMALE.INVERSE.N", 
        "body": "La fonction LOI.LOGNORMALE.INVERSE.N est l'une des fonctions statistiques. Elle est utilisée pour retourner l'inverse de la fonction de distribution log-normale de x, où ln() est normalement distribué avec les paramètres mean et standard-dev. La syntaxe de la fonction LOI.LOGNORMALE.INVERSE.N est : LOI.LOGNORMALE.INVERSE.N(probability, mean, standard-dev) où probability est la probabilité associée à la distribution log-normale. Une valeur numérique supérieure à 0 mais inférieure à 1. mean est la moyenne de la distribution de x suivant une loi lognormale, une valeur numérique. standard-dev est l'écart type de la distribution de ln(x) suivant une loi lognormale, une valeur numérique supérieure à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.LOGNORMALE.INVERSE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.LOGNORMALE.INVERSE.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/lognormdist.htm", 
        "title": "Fonction LOI.LOGNORMALE", 
        "body": "La fonction LOI.LOGNORMALE est l'une des fonctions statistiques. Elle est utilisée pour analyser les données logarythmiquement trqnsformées et renvoyer la fonction de distribution de x suivant une loi lognormale cumulée en utilisant les paramètres spécifiés. La syntaxe de la fonction LOI.LOGNORMALE est : LOI.LOGNORMALE(x, mean, standard-deviation) où x est la valeur pour laquelle la fonction doit être calculée. Une valeur numérique supérieure à 0. mean est la moyenne de la distribution de x suivant une loi lognormale, une valeur numérique. standard-deviation est l'écart type de la distribution de x suivant une loi lognormale, une valeur numérique supérieure à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.LOGNORMALE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.LOGNORMALE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/lookup.htm", 
        "title": "Fonction RECHERCHE - ONLYOFFICE", 
        "body": "Fonction RECHERCHE La fonction RECHERCHE est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer une valeur à partir d'une plage sélectionnée (ligne ou colonne contenant les données dans l'ordre croissant). La syntaxe de la fonction RECHERCHE est : RECHERCHE(lookup-value, lookup-vector, result-vector) où lookup-value est une valeur à chercher. lookup-vector est une ligne ou une colonne contenant des données classées par ordre croissant. lookup-result est une ligne ou une colonne contenant des données qui est de la même taille que lookup-vector. La fonction cherche lookup-value dans lookup-vector et renvoie la valeur qui se trouve dans la même position dans lookup-result. Remarque : si lookup-value est plus petite que toutes les valeurs dans lookup-vector, la fonction renvoie l'erreur #N/A. S'il n'y a pas de valeur qui correspond strictement à lookup-value, la fonction choisit la plus grande valeur dans lookup-vector qui est inférieure ou égale à la valeur. Comment faire formule RECHERCHE Pour appliquer la fonction RECHERCHE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction RECHERCHE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/lower.htm", 
        "title": "Fonction MINUSCULE", 
        "body": "La fonction MINUSCULE est l'une des fonctions de texte et de données. Elle est utilisée pour convertir des majuscules en minuscules dans la cellule sélectionnée. La syntaxe de la fonction MINUSCULE est : MINUSCULE(texte) où texte ce sont les données incluses dans la cellule à laquelle il est fait référence. Pour appliquer la fonction MINUSCULE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction MINUSCULE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/match.htm", 
        "title": "Fonction EQUIV", 
        "body": "La fonction EQUIV est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer une position relative d'un élément spécifié dans une plage de cellules. La syntaxe de la fonction EQUIV est : EQUIV(lookup-value, lookup-array[ , [match-type]]) où lookup-value est une valeur à rechercher dans lookup-array. Il peut s'agir d'une valeur numérique, logique ou textuelle, ou d'une référence de cellule. lookup-array est une ligne ou une colonne unique que vous devez analyser. match-type est un type de correspondance. C'est un argument facultatif. Il peut s'agir de l'une des valeurs numériques suivantes : Valeur numérique Signification 1 ou omise Les valeurs doivent être triées par ordre croissant. Si la correspondance exacte n'est pas trouvée, la fonction renvoie la plus grande valeur inférieure à . 0 Les valeurs peuvent être triées dans n'importe quel ordre. Si la correspondance exacte n'est pas trouvée, la fonction renverra l'erreur #N/A. -1 Les valeurs doivent être triées par ordre décroissant. Si la correspondance exacte n'est pas trouvée, la fonction renvoie la plus petite valeur supérieure à . Pour appliquer la fonction EQUIV, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction EQUIV, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/max.htm", 
        "title": "Fonction MAX", 
        "body": "La fonction MAX est l'une des fonctions statistiques. Elle est utilisée pour analyser la plage de données et trouver le plus grand nombre. La syntaxe de la fonction MAX est : MAX(number1, number2, ...) où number1(2) est une série contenant jusqu'à 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction MAX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MAX, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/maxa.htm", 
        "title": "Fonction MAXA", 
        "body": "La fontion MAXA est l'une des functions statistiques. Elle est utilisée pour analyser la plage de données et trouver la plus grande valeur. La syntaxe de la fonction MAXA est : MAXA(nombre1, nombre2, ...) où nombre1(2) sont les données (nombre, texte, valeur logique) saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction MAXA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MAXA, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/maxifs.htm", 
        "title": "Fonction MAX.SI.ENS", 
        "body": "La fonction MAX.SI.ENS est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la valeur maximale parmi les cellules spécifiées par un ensemble donné de conditions ou de critères. La syntaxe de la fonction MAX.SI.ENS est : MAX.SI.ENS(max_range, criteria_range1, criteria1 [, criteria_range2, criteria2], ...) max_range est la plage de cellules dans laquelle le maximum sera déterminé. criteria_range1 est la première plage de cellules sélectionnée à laquelle on applique le critère criteria1. criteria1 est la première condition à remplir. Elle est appliquée à la plage criteria_range1 et utilisée pour déterminer les cellules de max_range qui seront évaluées en tant que maximum. Sa valeur peut être saisie à la main ou incluse dans la cellule à laquelle il est fait référence. criteria_range2, criteria2, ... sont des plages supplémentaires de cellules et leurs critères correspondants. Ces arguments sont facultatifs. Remarque: vous pouvez utiliser des caractères génériques lorsque vous spécifiez des critères. Le point d'interrogation \" ? \" peut remplacer n'importe quel caractère et l'astérisque \" * \" peut être utilisé à la place de n'importe quel nombre de caractères. Pour appliquer la fonction MAX.SI.ENS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MAX.SI.ENS, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mdeterm.htm", 
        "title": "Fonction DETERMAT", 
        "body": "La fonction DETERMAT est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le déterminant d'une matrice. La syntaxe de la fonction DETERMAT est : DETERMAT(array) où array est une matrice de nombres. Remarque : Si une des cellules est vide ou contient une valeur non numérique, la fonction renvoie l'erreur #N/A. Si le nombre de lignes dans la matrice n'est pas égal au nombre de colonnes, la fonction renvoie l'erreur #VALEUR!. Pour appliquer la fonction DETERMAT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction DETERMAT, sélectionnez une plage de cellules avec la souris ou insérez l'argument nécessaire à la main comme suit A1:B2, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mduration.htm", 
        "title": "Fonction DUREE.MODIFIEE", 
        "body": "La fonction DUREE.MODIFIEE est l'une des fonctions financières. Elle est utilisée pour calculer la duration de Macaulay modifiée d'un titre avec une valeur nominale de 100 $. La syntaxe de la fonction DUREE.MODIFIEE est : DUREE.MODIFIEE(settlement, maturity, coupon, yld, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. coupon est le taux de coupon annuel du titre. yld est le rendement annuel du titre. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DUREE.MODIFIEE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction DUREE.MODIFIEE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/median.htm", 
        "title": "Fonction MEDIANE", 
        "body": "La fonction MEDIANE est l'une des fonctions statistiques. Elle est utilisée pour calculer la valeur médiane de la liste d'arguments. La syntaxe de la fonction MEDIANE est : MEDIANE(argument-list) où argument-list est une liste contenant 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est référence. Pour appliquer la fonction MEDIANE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MEDIANE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mid.htm", 
        "title": "Fonction STXT/MIDB", 
        "body": "La fonction STXT/MIDB est l'une des fonctions de texte et de données. Elle est utilisée pour extraire les caractères de la chaîne déterminée à partir de n'importe quelle position. La fonction STXT est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que MIDB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction STXT/MIDB est : STXT(string, start-pos, number-chars]) MIDB(string, start-pos, number-chars]) où string est la chaîne de laquelle vous voulez extraire les caractères. start-pos est la position à partir de laquelle vous voulez extraire les caractères. number-chars est le nombre de caractères que vous voulez extraire. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction STXT/MIDB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction STXT/MIDB, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/midb.htm", 
        "title": "Fonction STXT/MIDB", 
        "body": "La fonction STXT/MIDB est l'une des fonctions de texte et de données. Elle est utilisée pour extraire les caractères de la chaîne déterminée à partir de n'importe quelle position. La fonction STXT est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que MIDB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction STXT/MIDB est : STXT(string, start-pos, number-chars]) MIDB(string, start-pos, number-chars]) où string est la chaîne de laquelle vous voulez extraire les caractères. start-pos est la position à partir de laquelle vous voulez extraire les caractères. number-chars est le nombre de caractères que vous voulez extraire. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction STXT/MIDB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction STXT/MIDB, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/min.htm", 
        "title": "Fonction MIN", 
        "body": "La fonction MIN est l'une des fonctions statistiques. Elle est utilisée pour analyser la plage de données et de trouver le plus petit nombre. La syntaxe de la fonction MIN est : MIN(number1, number2, ...) où number1(2) est une série contenant jusqu'à 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction MIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MIN, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mina.htm", 
        "title": "Fonction MINA", 
        "body": "La fonction MINA est l'une des functions statistiques. Elle est utilisée pour analyser la plage de données et trouver la plus petite valeur. La syntaxe de la fonction MINA est : MINA(nombre1, nombre2, ...) où nombre1(2) sont les données (nombre, texte, valeur logique) saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction MINA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MINA, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/minifs.htm", 
        "title": "Fonction MIN.SI.ENS", 
        "body": "La fonction MIN.SI.ENS est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la valeur minimale parmi les cellules spécifiées par un ensemble donné de conditions ou de critères. La syntaxe de la fonction MIN.SI.ENS est : MIN.SI.ENS(min_range, criteria_range1, criteria1 [, criteria_range2, criteria2], ...) min_range est la plage de cellules dans laquelle le minimum sera déterminé. criteria_range1 est la première plage de cellules sélectionnée à laquelle on applique le critère criteria1. criteria1 est la première condition à remplir. Elle est appliquée à la plage criteria_range1 et utilisée pour déterminer les cellules de min_range qui seront évaluées en tant que minimum. Sa valeur peut être saisie à la main ou incluse dans la cellule à laquelle il est fait référence. criteria_range2, criteria2, ...sont des plages supplémentaires de cellules et leurs critères correspondants. Ces arguments sont facultatifs. Remarque: vous pouvez utiliser des caractères génériques lorsque vous spécifiez des critères. Le point d'interrogation \" ? \" peut remplacer n'importe quel caractère et l'astérisque \" * \" peut être utilisé à la place de n'importe quel nombre de caractères. Pour appliquer la fonction MIN.SI.ENS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MIN.SI.ENS, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/minute.htm", 
        "title": "Fonction MINUTE", 
        "body": "La fonction MINUTE est l'une des fonctions de date et d'heure. Elle renvoie les minutes (un nombre de 0 à 59) correspondant à une valeur d'heure. La syntaxe de la fonction MINUTE est : MINUTE( time-value ) où time-value est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Remarque: time-value peut être entrée sous la forme de chaînes de texte entre guillemets (par exemple \"13:39\"), de caractères décimaux (par exemple. 0.56 qui représente 13:26) , ou de résultats d'autres formules (par exemple le résultat de la fonction NOW au format prédéfini - 9/26/12 13:39) Pour appliquer la fonction MINUTE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction MINUTE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/minverse.htm", 
        "title": "Fonction INVERSEMAT", 
        "body": "La fonction INVERSEMAT est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la matrice inversée de la matrice donnée et afficher la première valeur de la matrice de nombres renvoyée. La syntaxe de la fonction INVERSEMAT est : INVERSEMAT(array) où array est une matrice de nombres. Remarque : Si une des cellules est vide ou contient une valeur non numérique, la fonction renvoie l'erreur #N/A. Si le nombre de lignes dans la matrice n'est pas égal au nombre de colonnes, la fonction renvoie l'erreur #VALEUR!. Pour appliquer la fonction INVERSEMAT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction INVERSEMAT, sélectionnez une plage de cellules avec la souris ou insérez l'argument nécessaire à la main comme suit A1:B2, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mirr.htm", 
        "title": "Fonction TRIM", 
        "body": "La fonction TRIM est l'une des fonctions financières. Elle est utilisée pour calculer le taux de rendement interne d'une série de flux de trésorerie périodiques. La syntaxe de la fonction TRIM est : TRIM(values, finance-rate, reinvest-rate) où values est un tableau qui contient la série de paiements survenant à des périodes régulières. Au moins une des valeurs doit être négative et au moins une positive. finance-rate est le taux d'intérêt payé sur l'argent utilisé dans les flux de trésorerie. reinvest-rate est le taux d'intérêt reçu sur le réinvestissement de trésorerie. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TRIM, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction TRIM, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mmult.htm", 
        "title": "Fonction PRODUITMAT", 
        "body": "La fonction PRODUITMAT est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le produit de deux matrices et afficher la première valeur de la matrice de nombres renvoyée. La syntaxe de la fonction PRODUITMAT est : PRODUITMAT(array1, array2) où array1, array2 est une matrice de nombres. Remarque: Si une des cellules de la matrice contient une valeur non numérique ou vide, la fonction renvoie l'erreur #N/A. Si le nombre de colonnes dans array1 n'est pas le même que le nombre de lignes dans array2, la fonction renvoie l'erreur #VALEUR!. Pour appliquer la fonction PRODUITMAT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PRODUITMAT, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mod.htm", 
        "title": "Fonction MOD", 
        "body": "La fonction MOD est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le reste de la division de l'argument nombre par l'argument diviseur. La syntaxe de la fonction MOD est : MOD(x, y) où x est le nombre que vous voulez diviser pour trouver le reste. y est le diviseur. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque: si y est 0, la fonction renvoie l'erreur #DIV/0!. Pour appliquer la fonction MOD, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône sutuée sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction MOD, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mode-mult.htm", 
        "title": "Fonction MODE.MULTIPLE", 
        "body": "La fonction MODE.MULTIPLE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la valeur la plus fréquente ou répétitive dans un tableau ou une plage de données. La syntaxe de la fonction MODE.MULTIPLE est : MODE.MULTIPLE(number1, [, number2],...) où number1(2) est une série contenant jusqu'à 255 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : s'il n'a pas de valeurs répétitives dans la liste, la fonction renvoie l'erreur #VALEUR!. Pour appliquer la fonction MODE.MULTIPLE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MODE.MULTIPLE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mode-sngl.htm", 
        "title": "Fonction MODE.SIMPLE", 
        "body": "La fonction MODE.SIMPLE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la valeur la plus fréquente ou répétitive dans un tableau ou une plage de données. La syntaxe de la fonction MODE.SIMPLE est : MODE.SIMPLE(number1, [, number2],...) où number1(2) est une série contenant jusqu'à 255 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : s'il n'a pas de valeurs répétitives dans la liste, la fonction renvoie l'erreur #VALEUR!. Pour appliquer la fonction MODE.SIMPLE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MODE.SIMPLE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mode.htm", 
        "title": "Fonction MODE", 
        "body": "La fonction MODE est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer la valeur la plus fréquente. La syntaxe de la fonction MODE est : MODE(argument-list) où argument-list est une liste de valeurs numériques jusqu'à 255 valeurs saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : s'il n'a pas de valeurs répétitives dans la liste, la fonction renvoie l'erreur #VALEUR!. Pour appliquer la fonction MODE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MODE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/month.htm", 
        "title": "Fonction MOIS", 
        "body": "La fonction MOIS est l'une des fonctions de date et d'heure. Elle renvoie le mois (nombre de 1 à 12) d'une date indiquée au format numérique (jj/MM/aaaa par défault). La syntaxe de la fonction MOIS est : MOIS(date-value) où date-value est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction MOIS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction MOIS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/mround.htm", 
        "title": "Fonction ARRONDI.AU.MULTIPLE", 
        "body": "La fonction ARRONDI.AU.MULTIPLE est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour donner l'arrondi d'un nombre au multiple spécifié. La syntaxe de la fonction ARRONDI.AU.MULTIPLE est : ARRONDI.AU.MULTIPLE(x, multiple) où x est le nombre qui doit être arrondi. multiple représente le multiple auquel vous souhaitez arrondir le nombre. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque: si x et multiple ont des signes différents, la fonction renvoie l'erreur #NOMBRE!. Pour appliquer la fonction ARRONDI.AU.MULTIPLE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ARRONDI.AU.MULTIPLE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/multinomial.htm", 
        "title": "Fonction MULTINOMIALE", 
        "body": "La fonction MULTINOMIALE est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le rapport de la factorielle de la somme de nombres au produit de factorielles. La syntaxe de la fonction MULTINOMIALE est : MULTINOMIALE(argument-list) où argument-list est une liste des valeurs numériques jusqu'à 30 saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction MULTINOMIALE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction MULTINOMIALE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/munit.htm", 
        "title": "Fonction MATRICE.UNITAIRE", 
        "body": "La fonction MATRICE.UNITAIRE est l'une des fonctions mathématiques et trigonométriques. La fonction unitaire renvoie la matrice unitaire pour la dimension spécifiée. La syntaxe de la fonction MATRICE.UNITAIR est comme suit: MATRICE.UNITAIRE (dimension) où: dimension est un argument obligatoire. Dimension est un entier qui spécifie la dimension de la matrice unitaire que vous voulez renvoyer. Elle retourne un tableau. La dimension doit être supérieure à zéro. Pour utiliser la fonction MATRICE.UNITAIRE, sélectionnez la cellule où vous voulez afficher le résultat, appuyez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie dans la liste, appuyez sur la fonction MATRICE.UNITAIRE, saisissez l'argument approprié et appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie. Pour renvoyer la valeur une d'une matrice de cellules, sélectionnez une plage de cellules, entrez la formule et appuyez Ctrl+Maj+Entrée."
    },
   {
        "id": "Functions/n.htm", 
        "title": "Fonction N", 
        "body": "La fonction N est l'une des fonctions d'information. Elle est utilisée pour renvoyer une valeur convertie en nombre. La syntaxe de la fonction N est : N(value) où valeur est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Vous trouverez ci-dessous les valeurs possibles et le résultat de leur conversion : Valeur Nombre nombre nombre date date comme numéro de série VRAI 1 FAUX 0 erreur valeur d'erreur Autre 0 Pour appliquer la fonction N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction N, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/na.htm", 
        "title": "Fonction NA", 
        "body": "La fonction NA est l'une des fonctions d'information. Elle est utilisée pour renvoyer la valeur d'erreur #N/A. Cette fonction n'exige pas d'argument. La syntaxe de la fonction NA est : NA() Pour appliquer la fonction NA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction NA, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/negbinom-dist.htm", 
        "title": "Fonction LOI.BINOMIALE.NEG.N", 
        "body": "La fonction LOI.BINOMIALE.NEG.N est l'une des fonctions statistiques. Elle est utilisée pour retourner la distribution binomiale négative, la probabilité qu'il y aura Number_f échecs avant le Number_s-ème succès, avec une probabilité de succès Probability_s. La syntaxe de la fonction LOI.BINOMIALE.NEG.N est : LOI.BINOMIALE.NEG.N(number-f, number-s, probability-s, cumulative) où number-f est un nombre d'échecs, une valeur numérique supérieure ou égale à 0. number-s est le nombre de succès à obtenir, une valeur numérique supérieure ou égale à 1. success-probability est la probabilité de succès de chaque essai, une valeur numérique supérieure à 0, mais inférieure à 1. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de densité de probabilité. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.BINOMIALE.NEG.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.BINOMIALE.NEG.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/negbinomdist.htm", 
        "title": "Fonction LOI.BINOMIALE.NEG", 
        "body": "La fonction LOI.BINOMIALE.NEG est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la distribution négative binomiale. La syntaxe de la fonction LOI.BINOMIALE.NEG est : LOI.BINOMIALE.NEG(number-failures, number-successes, success-probability) où number-failures est un nombre d'échecs, une valeur numérique supérieure ou égale à 0. number-successes est le nombre de succès à obtenir, une valeur numérique supérieure ou égale à 0. success-probability est la probabilité de succès de chaque évaluation, une valeur numérique supérieure à 0, mais inférieure à 1. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.BINOMIALE.NEG, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.BINOMIALE.NEG, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/networkdays-intl.htm", 
        "title": "Fonction NB.JOURS.OUVRES.INTL", 
        "body": "La fonction NB.JOURS.OUVRES.INTL est l'une des fonctions de date et d'heure. Elle est utilisée pour retourner le nombre de jours de travail entiers entre deux dates en utilisant des paramètres pour indiquer quels jours et combien de jours sont des jours de week-end. La syntaxe de la fonction NB.JOURS.OUVRES.INTL est : WORKDAY.INTL(start_date, days, [, weekend], [, holidays]) où start_date est un nombre représentant la première date de la période, saisi en utilisant la fonction Date ou une autre fonction de date et d'heure. end_date est un nombre représentant la dernière date de la période, saisie en utilisant la fonction Date ou une autre fonction de date et d'heure. weekend est un argument facultatif, un nombre qui spécifie les jours à prendre en compte comme les week-ends. Les numéros possibles sont listés dans le tableau ci-dessous. Nombre Jours de week-end 1 ou omise Samedi, Dimanche 2 Dimanche, Lundi 3 Lundi, Mardi 4 Mardi, Mercredi 5 Mercredi, Jeudi 6 Jeudi, vendredi 7 Vendredi, Samedi 11 Dimanche seulement 12 Lundi seulement 13 Mardi seulement 14 Mercredi seulement 15 Jeudi seulement 16 Vendredi seulement 17 Samedi seulement Une chaîne qui spécifie les week-ends doit contenir 7 caractères. Chaque caractère représente un jour de la semaine, à partir du lundi. 0 représente une journée de travail, 1 représente un jour de week-end. Par exemple. \"0000011\" spécifie que les jours de week-end sont samedi et dimanche. La chaîne \"1111111\" n'est pas valide. holidays est un argument facultatif qui définit quelles dates en plus du weekend ne sont pas ouvrables. Les valeurs peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction NB.JOURS.OUVRES.INTL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure, cliquez sur la fonction NB.JOURS.OUVRES.INTL, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/networkdays.htm", 
        "title": "Fonction NB.JOURS.OUVRES", 
        "body": "La fonction NB.JOURS.OUVRES est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer le nombre de jours ouvrables entre deux dates (start date et end-date) à l'exclusion des week-ends et dates cosidérées comme jours fériés. La syntaxe de la fonction NB.JOURS.OUVRES est : NB.JOURS.OUVRES(start-date, end-date [,holidays]) où start-date est un nombre représentant la première date de la période, saisi en utilisant la fonction Date ou une autre fonction de date et d'heure. end-date est un nombre représentant la dernière date de la période, saisi en utilisant la fonction Date ou une autre fonction de date et d'heure. holidays est un argument optionnel qui spécifie les dates en dehors des week-ends qui sont chômés. Les valeurs peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction NB.JOURS.OUVRES, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction NB.JOURS.OUVRES, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/nominal.htm", 
        "title": "Fonction TAUX.NOMINAL", 
        "body": "La fonction TAUX.NOMINAL est l'une des fonctions financières. Elle sert à calculer le taux d'intérêt annuel nominal d'un titre en fonction d'un taux d'intérêt annuel effectif déterminé et du nombre de périodes de composition par année. La syntaxe de la fonction TAUX.NOMINAL est : TAUX.NOMINAL(effect-rate, npery) où effect-rate est le taux d'intérêt annuel effectif du titre. npery est le nombre de périodes de composition par année. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TAUX.NOMINAL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction TAUX.NOMINAL, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/norm-dist.htm", 
        "title": "Fonction LOI.NORMALE.N", 
        "body": "La fonction LOI.NORMALE.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la distribution normale pour la moyenne spécifiée et l'écart type. La syntaxe de la fonction LOI.NORMALE.N est : LOI.NORMALE.N(x, mean, standard-dev, cumulative) où x est la valeur pour laquelle vous souhaitez calculer la distribution, toute valeur numérique. mean est la moyenne arithmétique de la distribution, toute valeur numérique. standard-dev est l'écart type de la distribution, une valeur numérique supérieure à 0. cumulative est la forme de la fonction, une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si cumulative est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative ; s'il est FALSE (FAUX), elle renvoie la fonction de probabilité de masse. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.NORMALE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.NORMALE.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/norm-inv.htm", 
        "title": "Fonction LOI.NORMALE.INVERSE.N", 
        "body": "La fonction LOI.NORMALE.INVERSE.N est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la distribution cumulative normale pour la moyenne et l'écart-type spécifiés. La syntaxe de la fonction LOI.NORMALE.INVERSE.N est : LOI.NORMALE.INVERSE.N(probability, mean, standard-dev) où probability est la probabilité correspondant à la distribution normale, une valeur numérique supérieure ou égale à 0, mais inférieure ou égale à 1. mean est la moyenne arithmétique de la distribution, toute valeur numérique. standard-dev est l'écart type de la distribution, une valeur numérique supérieure à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.NORMALE.INVERSE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.NORMALE.INVERSE.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/norm-s-dist.htm", 
        "title": "Fonction LOI.NORMALE.STANDARD.N", 
        "body": "La fonction LOI.NORMALE.STANDARD.N est l'une des fonctions statistiques. Elle est utilisée pour retourner l'inverse de la distribution cumulative normale standard; la distribution a une moyenne de zéro et un écart-type de un. La syntaxe de la fonction LOI.NORMALE.STANDARD.N est : LOI.NORMALE.STANDARD.N(z, cumulative) où z est la valeur à laquelle la fonction devra être calculée, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de probabilité de masse. Pour appliquer la fonction LOI.NORMALE.STANDARD.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.NORMALE.STANDARD.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/norm-s-inv.htm", 
        "title": "Fonction LOI.NORMALE.STANDARD.INVERSE.N", 
        "body": "La fonction LOI.NORMALE.STANDARD.INVERSE.N est l'une des fonctions statistiques. Elle est utilisée pour retourner l'inverse de la distribution cumulative normale standard; la distribution a une moyenne de zéro et un écart-type de un. La syntaxe de la fonction LOI.NORMALE.STANDARD.INVERSE.N est : LOI.NORMALE.STANDARD.INVERSE.N(probability) où probability est une valeur numérique supérieure à 0 mais inférieure à 1 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction LOI.NORMALE.STANDARD.INVERSE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.NORMALE.STANDARD.INVERSE.N, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/normdist.htm", 
        "title": "Fonction LOI.NORMALE", 
        "body": "La fonction LOI.NORMALE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la distribution normale pour la moyenne spécifiée et l'écart type. La syntaxe de la fonction LOI.NORMALE est : LOI.NORMALE(x , mean , standard-deviation , cumulative-flag) où x est la valeur pour laquelle vous souhaitez calculer la distribution, toute valeur numérique. mean est la moyenne arithmétique de la distribution, toute valeur numérique. standard-deviation est l'écart type de la distribution, une valeur numérique supérieure à 0. cumulative-flag est la forme de la fonction, une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si cumulative-flag est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative ; s'il est FALSE (FAUX), elle renvoie la fonction de probabilité de masse. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.NORMALE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.NORMALE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/norminv.htm", 
        "title": "Fonction LOI.NORMALE.INVERSE", 
        "body": "La fonction LOI.NORMALE.INVERSE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la distribution cumulative normale pour la moyenne et l'écart-type spécifiés. La syntaxe de la fonction LOI.NORMALE.INVERSE est : LOI.NORMALE.INVERSE(x, mean, standard-deviation) où x est la probabilité correspondant à la distribution normale, une valeur numérique supérieure ou égale à 0, mais inférieure ou égale à 1. mean est la moyenne arithmétique de la distribution, toute valeur numérique. standard-deviation est l'écart type de la distribution, une valeur numérique supérieure à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.NORMALE.INVERSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.NORMALE.INVERSE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/normsdist.htm", 
        "title": "Fonction LOI.NORMALE.STANDARD", 
        "body": "La fonction LOI.NORMALE.STANDARD est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la fonction de distribution cumulative normale standard. La syntaxe de la fonction LOI.NORMALE.STANDARD est : LOI.NORMALE.STANDARD(number) où number est une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction LOI.NORMALE.STANDARD, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.NORMALE.STANDARD, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/normsinv.htm", 
        "title": "Fonction LOI.NORMALE.STANDARD.INVERSE", 
        "body": "La fonction LOI.NORMALE.STANDARD.INVERSE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'inverse de la distribution cumulative normale standard. La syntaxe de la fonction LOI.NORMALE.STANDARD.INVERSE est : LOI.NORMALE.STANDARD.INVERSE(probability) où probability est une valeur numérique supérieure à 0 mais inférieure à 1 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction LOI.NORMALE.STANDARD.INVERSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.NORMALE.STANDARD.INVERSE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/not.htm", 
        "title": "Fonction PAS", 
        "body": "La fonction PAS est l'une des fonctions logiques. Elle sert à vérifier si la valeur logique saisie est vraie ( TRUE ) ou fausse ( FALSE ). La fonction renvoie vrai ( TRUE ) si l'argument est faux ( FALSE ) et renvoie faux ( FALSE ) si l'argument est vrai ( TRUE ). La syntaxe de la fonction PAS est : PAS(logical) où logical est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction PAS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction PAS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Par exemple : Il y a un argument : logical = A1&lt;100, où A1 est 12. Cette expression logique est vraie TRUE. Donc la fonction renvoie faux FALSE. Si nous changeons la valeur de A1 de 12 à 112, la fonction renvoie vrai TRUE:"
    },
   {
        "id": "Functions/now.htm", 
        "title": "Fonction MAINTENANT", 
        "body": "La fonction MAINTENANT est l'une des fonctions de date et d'heure. Elle est utilisée pour ajouter la date et l'heure à votre feuille de calcul au format suivant MM/jj/aa hh:mm. Cette fonction n'exige pas d'argument. La syntaxe de la fonction MAINTENANT est : MAINTENANT() Pour appliquer la fonction MAINTENANT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction MAINTENANT, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/nper.htm", 
        "title": "Fonction NPM", 
        "body": "La fonction NPM est l'une des fonctions financières. Elle est utilisée pour calculer le nombre de périodes pour un investissement à la base du taux d'intérêt spécifié et d'un échéancier de paiement constant. La syntaxe de la fonction NPM est : NPM(rate, pmt, pv [, [fv] [,[type]]]) où rate est le taux d'intérêt. pmt est le montant du paiement. pv est la valeur actuelle des paiements. fv est la valeur future impayée d'un investissement. C'est un argument facultatif. Si il est absent, fv est estimé à 0. type est la période au cours de laquelle les paiements doivent être versés. C'est un argument facultatif. Si il est égal à 0 ou absent, la fonction estime que les paiements doivent être versés à la fin de la période. Si il est égal à 1, les paiements doivent être versés au début de la période. Remarque : les sommes versées ( telles que dépôts d'épargne ) sont représentées par des nombres négatifs ; les sommes reçues ( telles que dividendes ) sont représentées par des nombres positifs. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction NPM, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction NPM, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/npv.htm", 
        "title": "Fonction VAN", 
        "body": "La fonction VAN est l'une des fonctions financières. Elle est utilisée pour calculer la valeur nette actuelle d'un investissement à la base d'un taux d'escompte spécifié. La syntaxe de la fonction VAN est : VAN(rate, argument-list) où rate est le taux d'escompte. argument-list est la liste des paiements futures. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction VAN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction VAN, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/numbervalue.htm", 
        "title": "Fonction VALEURNOMBRE", 
        "body": "La fonction VALEURNOMBRE est l'une des fonctions de texte et de données. Elle sert à convertir le texte en nombre, de manière indépendante des paramètres régionaux. Si le texte à convertir ce n'est pas un nombre, la fonction renvoie l'erreur #VALUE!. La syntaxe de la fonction VALEURNOMBRE est : VALEURNOMBRE(text [, [decimal-separator] [, [group-separator]]) où text est une donnée textuelle représentant un nombre. decimal-separator est le caractère utilisé pour séparer l'entier et la partie fractionnaire du résultat. C'est un argument facultatif. En cas d'omission, le réglage de localisation courant est utilisé. group-separator est le caractère utilisé pour séparer des groupes de nombres, tels que les milliers des centaines et les millions des milliers. C'est un argument facultatif. En cas d'omission, le réglage de localisation courant est utilisé. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction VALEURNOMBRE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône sutuée sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction VALEURNOMBRE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/oct2bin.htm", 
        "title": "Fonction OCTBIN", 
        "body": "La fonction OCTBIN est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre octal en un nombre binaire. La syntaxe de la fonction OCTBIN est : OCTBIN(number [, num-hex-digits]) où number est un nombre octal entré manuellement ou inclus dans la cellule à laquelle il est fait référence. num-hex-digits est le nombre de chiffres à afficher. Si omis, la fonction utilisera le nombre minimum. Remarque : si l'argument n'est pas reconnu comme un nombre octal ou contient plus de 10 caractères, ou si le nombre binaire obtenu nécessite plus de chiffres que vous avez spécifié, ou si le nombre num-hex-digits spécifié est inférieur ou égal à 0, le La fonction retournera l'erreur #NOMBRE!. Pour appliquer la fonction OCTBIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction OCTBIN, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/oct2dec.htm", 
        "title": "Fonction OCTDEC", 
        "body": "La fonction OCTDEC est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre octal en un nombre décimal. La syntaxe de la fonction OCTDEC est : OCTDEC(number) où number est un nombre octal entré manuellement ou inclus dans la cellule à laquelle il est fait référence. Remarque : si l'argument n'est pas reconnu comme un nombre octal, ou contient plus de 10 caractères, la fonction retournera l'erreur #NOMBRE!. Pour appliquer la fonction OCTDEC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction OCTDEC, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/oct2hex.htm", 
        "title": "Fonction OCTHEX", 
        "body": "La fonction OCTHEX est l'une des fonctions d'ingénierie. Elle est utilisée pour convertir un nombre octal en un nombre hexadécimal. La syntaxe de la fonction OCTHEX est : OCTHEX(number [, num-hex-digits]) où number est une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. num-hex-digits est le nombre de chiffres à afficher. Si omis, la fonction utilisera le nombre minimum. Remarque : si l'argument n'est pas reconnu comme un nombre octal ou contient plus de 10 caractères, ou si le nombre hexadécimal obtenu nécessite plus de chiffres que vous avez spécifié, ou si le nombre num-hex-digits spécifié est inférieur ou égal à 0, le La fonction retournera l'erreur #NOMBRE!. Pour appliquer la fonction OCTHEX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Ingénierie depuis la liste, cliquez sur la fonction OCTHEX, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/odd.htm", 
        "title": "Fonction IMPAIR", 
        "body": "La fonction IMPAIR est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir le nombre au nombre entier impair le plus proche. La syntaxe de la fonction IMPAIR est : IMPAIR(x) où x représente la valeur à arrondir, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction IMPAIR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction IMPAIR, saisissez l'argument nécessaire, appuyez sur la touche Entrée Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/oddfprice.htm", 
        "title": "Fonction PRIX.PCOUPON.IRREG", 
        "body": "La fonction PRIX.PCOUPON.IRREG est l'une des fonctions financières. Elle est utilisée pour calculer le prix par valeur nominale de 100$ pour un titre qui paie des intérêts périodiques mais qui a une première période impaire (elle est plus courte ou plus longue que les autres périodes). La syntaxe de la fonction PRIX.PCOUPON.IRREG est : PRIX.PCOUPON.IRREG(settlement, maturity, issue, first-coupon, rate, yld, redemption, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. issue est la date d'émission du titre. first-coupon est la date du premier coupon. Cette date doit être postérieure à la date de règlement mais antérieure à la date d'échéance. rate est le taux d'intérêt du titre. yld est le rendement annuel du titre. redemption correspond à la valeur de rachat du titre, par tranche de 100$ de valeur nominale. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PRIX.PCOUPON.IRREG, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction PRIX.PCOUPON.IRREG, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/oddfyield.htm", 
        "title": "Fonction REND.PCOUPON.IRREG", 
        "body": "La fonction REND.PCOUPON.IRREG est l'une des fonctions financières. Elle est utilisée pour calculer le rendement pour un titre qui paie des intérêts périodiques mais qui a une première période impaire (elle est plus courte ou plus longue que les autres périodes). La syntaxe de la fonction REND.PCOUPON.IRREG est : REND.PCOUPON.IRREG(settlement, maturity, issue, first-coupon, rate, pr, redemption, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. issue est la date d'émission du titre. first-coupon est la date du premier coupon. Cette date doit être postérieure à la date de règlement mais antérieure à la date d'échéance. rate est le taux d'intérêt du titre. pr correspond au prix d'achat du titre, par tranche de 100$ de valeur nominale. redemption correspond à la valeur de rachat du titre, par tranche de 100$ de valeur nominale. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction REND.PCOUPON.IRREG, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction REND.PCOUPON.IRREG, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/oddlprice.htm", 
        "title": "Fonction PRIX.DCOUPON.IRREG", 
        "body": "La fonction PRIX.DCOUPON.IRREG est l'une des fonctions financières. Elle est utilisée pour calculer le prix par valeur nominale de 100$ pour un titre qui paie des intérêts périodiques mais qui a une dernière période impaire (plus courte ou plus longue que les autres périodes). La syntaxe de la fonction PRIX.DCOUPON.IRREG est : PRIX.DCOUPON.IRREG(settlement, maturity, last-interest, rate, yld, redemption, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. last-interest est la date du dernier coupon. Cette date doit être antérieure à la date de règlement. rate est le taux d'intérêt du titre. yld est le rendement annuel du titre. redemption correspond à la valeur de rachat du titre, par tranche de 100$ de valeur nominale. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PRIX.DCOUPON.IRREG, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction PRIX.DCOUPON.IRREG, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/oddlyield.htm", 
        "title": "Fonction REND.DCOUPON.IRREG", 
        "body": "La fonction REND.DCOUPON.IRREG est l'une des fonctions financières. Elle est utilisée pour calculer le rendement d'un titre qui paie des intérêts périodiques mais qui a une dernière période impaire(plus courte ou plus longue que les autres périodes). La syntaxe de la fonction REND.DCOUPON.IRREG est : REND.DCOUPON.IRREG(settlement, maturity, last-interest, rate, pr, redemption, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. last-interest est la date du dernier coupon. Cette date doit être antérieure à la date de règlement. rate est le taux d'intérêt du titre. pr correspond au prix d'achat du titre, par tranche de 100$ de valeur nominale. redemption correspond à la valeur de rachat du titre, par tranche de 100$ de valeur nominale. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction REND.DCOUPON.IRREG, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction REND.DCOUPON.IRREG, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/offset.htm", 
        "title": "Fonction DECALER", 
        "body": "La fonction DECALER est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer une référence à une cellule déplacée de la cellule spécifiée (ou de la cellule supérieure gauche dans la plage de cellules) à un certain nombre de lignes et de colonnes. La syntaxe de la fonction DECALER est : DECALER(reference, rows, cols[, [height] [, [width]]]) où reference est une référence à une cellule initiale ou à une plage de cellules. rows est un nombre de lignes, vers le haut ou vers le bas, auquel vous voulez faire référence dans la cellule supérieure gauche de la référence renvoyée. Les nombres positifs signifient que le résultat se déplacera sous la cellule initiale. Les valeurs négatives signifient qu'il se déplacera au-dessus de la cellule initiale. cols est un nombre de colonnes, à gauche ou à droite, que vous voulez faire référence à la cellule supérieure gauche de la référence renvoyée. Les nombres positifs signifient que le résultat se déplacera vers la droite de la cellule initiale. Les valeurs négatives signifient qu'elle se déplacera à gauche de la cellule initiale. height est un nombre de lignes dans la référence renvoyée. La valeur doit être un nombre positif. C'est un argument facultatif. S'il est omis, la fonction suppose qu'il correspond à la hauteur de la plage initiale. width est un nombre de colonnes dans la référence renvoyée. La valeur doit être un nombre positif. C'est un argument facultatif. S'il est omis, la fonction suppose qu'il correspond à la largeur de la plage initiale. Pour appliquer la fonction DECALER, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction DECALER, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/or.htm", 
        "title": "Fonction OU", 
        "body": "La fonction OU est l'une des fonctions logiques. Elle sert à vérifier si la valeur logique saisie est vraie (TRUE ) ou fausse (FALSE). La fonction renvoie faux ( FALSE ) si tous les arguments sont faux ( FALSE ). La syntaxe de la fonction OU est : OU(logical1, logical2, ...) où logical1 est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction OU, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction OU, insérez les arguments requis en les séparant par des virgules,Remarque: vous pouvez insérer jusqu'à 265 valeurs logiques. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. La fonction renvoie vrai ( TRUE ) si au moins l'un de l'argument est vrai ( TRUE ). Par exemple : Il y a trois arguments : logical1 = A1&lt;10, logical2 = 34&lt;10, logical3 = 50&lt;10, où A1 est 12. Toutes ces expressions logiques sont fausses FALSE. Donc la fonction renvoie faux FALSE. Si nous changeons la valeur de A1 de 12 à 2, la fonction renvoie vrai TRUE:"
    },
   {
        "id": "Functions/pduration.htm", 
        "title": "Fonction PDUREE", 
        "body": "La fonction PDUREE est l'une des fonctions financières. Elle est utilisée pour retourner le nombre de périodes requises pour qu’un investissement atteigne une valeur spécifiée. La syntaxe de la fonction PDUREE est : PDUREE(taux, va, vc) où taux est le taux d'intérêt pour l'investissement. va est la valeur actuelle de l'investissement. vc est la valeur future impayée d'un investissement. Remarque: tous les arguments doivent être représentés par des nombres positifs. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PDUREE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction PDUREE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/pearson.htm", 
        "title": "Fonction PEARSON", 
        "body": "La fonction PEARSON est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le coefficient de corrélation des moments du produit de Pearson. La syntaxe de la fonction PEARSON est : PEARSON(array-1, array-2) où array-1 et array-2 ce sont des plages de cellules sélectionnées avec le même nombre d'éléments. Remarque : si array-1(2) contient du texte, des valeurs logiques, des cellules vides, la fonction ignore ces valeurs, mais prend en considération les cellules avec les valeurs zéro. Pour appliquer la fonction PEARSON, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PEARSON, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/percentile-exc.htm", 
        "title": "Fonction CENTILE.EXCLURE", 
        "body": "La fonction CENTILE.EXCLURE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le kème centile des valeurs dans une plage, où k est dans l'intervalle ouvert 0..1. La syntaxe de la fonction CENTILE.EXCLURE est : CENTILE.EXCLURE(array, k) où array est une plage de cellules sélectionnée. k est la valeur de centile, une valeur numérique supérieure à 0 mais inférieure à 1 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction CENTILE.EXCLURE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction CENTILE.EXCLURE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/percentile-inc.htm", 
        "title": "Fonction CENTILE.INCLURE", 
        "body": "La fonction CENTILE.INCLURE est l'une des fonctions statistiques. Elle est utilisée pour retourner le kème percentile des valeurs dans une plage, où k est compris entre 0..1 inclus. La syntaxe de la fonction CENTILE.INCLURE est : CENTILE.INCLURE(array, k) où array est une plage de cellules sélectionnée. k est la valeur de centile, une valeur numérique supérieure à 0 mais inférieure à 1 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction CENTILE.INCLURE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction CENTILE.INCLURE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/percentile.htm", 
        "title": "Fonction CENTILE", 
        "body": "La fonction CENTILE est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer le nième centile. La syntaxe de la fonction CENTILE est : CENTILE(array, k) où array est une plage de cellules sélectionnée. k est la valeur de centile, une valeur numérique supérieure à 0 mais inférieure à 1 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction CENTILE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction CENTILE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/percentrank-exc.htm", 
        "title": "Fonction RANG.POURCENTAGE.EXCLURE", 
        "body": "La fonction RANG.POURCENTAGE.EXCLURE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le rang d'une valeur dans une série de valeurs en tant qu'un pourcentage(dans l'inervalle ouvert 0..1) de la série. La syntaxe de la fonction RANG.POURCENTAGE.EXCLURE est : RANG.POURCENTAGE.EXCLURE(array, x[, significance]) où array est une plage de cellules sélectionnée contenant des valeurs numériques. x est la valeur dont le rang vous souhaitez trouver, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. significance est le nombre de chiffres significatifs pour le rang à renvoyer. C'est un argument facultatif. S'il est omis, la fonction assume significance d'être égal à 3. Pour appliquer la fonction RANG.POURCENTAGE.EXCLURE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction RANG.POURCENTAGE.EXCLURE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/percentrank-inc.htm", 
        "title": "Fonction RANG.POURCENTAGE.INCLURE", 
        "body": "La fonction RANG.POURCENTAGE.INCLURE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le rang d'une valeur dans une série de valeurs en tant qu'un pourcentage(dans l'inervalle fermé 0..1) de la série. La syntaxe de la fonction RANG.POURCENTAGE.INCLURE est : RANG.POURCENTAGE.INCLURE(array, x[, significance]) où array est une plage de cellules sélectionnée contenant des valeurs numériques. x est la valeur dont le rang vous souhaitez trouver, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. significance est le nombre de chiffres significatifs pour le rang à renvoyer. C'est un argument facultatif. S'il est omis, la fonction assume significance d'être égal à 3. Pour appliquer la fonction RANG.POURCENTAGE.INCLURE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction RANG.POURCENTAGE.INCLURE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/percentrank.htm", 
        "title": "Fonction RANG.POURCENTAGE", 
        "body": "La fonction RANG.POURCENTAGE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le rang d'une valeur dans une série de valeurs en tant que pourcentage de la série. La syntaxe de la fonction RANG.POURCENTAGE est : RANG.POURCENTAGE(array, x[, significance]) où array est une plage de cellules sélectionnée contenant des valeurs numériques. x est la valeur dont le rang vous souhaitez trouver, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. significance est le nombre de chiffres significatifs pour le rang à renvoyer. C'est un argument facultatif. S'il est omis, la fonction assume significance d'être égal à 3. Pour appliquer la fonction RANG.POURCENTAGE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction RANG.POURCENTAGE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/permut.htm", 
        "title": "Fonction PERMUTATION", 
        "body": "La fonction PERMUTATION est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le nombre de permutations pour un nombre d'objets spécifié. La syntaxe de la fonction PERMUTATION est : PERMUTATION(number, number-chosen) où number est le nombre d'objets. number-chosen est le nombre d'objet dans une permutation. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PERMUTATION, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PERMUTATION, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/permutationa.htm", 
        "title": "Fonction PERMUTATIONA", 
        "body": "La fonction PERMUTATIONA est l'une des fonctions statistiques. Elle sert à retourner le nombre de permutations pour un nombre donné d'objets (avec des répétitions) qui peuvent être sélectionnés parmi les objets totaux. La syntaxe de la fonction PERMUTATIONA est : PERMUTATIONA(number, number-chosen) où number est un nombre d'éléments de l'ensemble, une valeur numérique supérieure ou égale à 0. number-chosen est un nombre d'éléments dans une permutation, une valeur numérique supérieure ou égale à 0 mais inférieure à number. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PERMUTATIONA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PERMUTATIONA, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/phi.htm", 
        "title": "Fonction PHI", 
        "body": "La fonction PHI est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la valeur de la fonction de densité pour une distribution normale standard. La syntaxe de la fonction PHI est : PHI(x) où x est la valeur pour laquelle vous souhaitez calculer la densité, toute valeur numérique. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PHI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PHI, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/pi.htm", 
        "title": "Fonction PI", 
        "body": "La fonction PI est l'une des fonctions mathématiques et trigonométriques. Elle renvoie la valeur 3.14159265358979, la constante mathématique pi. Elle ne prend aucun argument. La syntaxe de la fonction PI est : PI() Pour appliquer la fonction PI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PI, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/pmt.htm", 
        "title": "Fonction VPM", 
        "body": "La fonction VPM est l'une des fonctions financières. Elle est utilisée pour calculer le montant du paiement d'un emprunt à la base du taux d'intérêt spécifié et d'un échéancier de paiement constant. La syntaxe de la fonction VPM est : VPM(rate, nper, pv [, [fv] [,[type]]]) où rate est le taux d'intérêt. nper est le nombre de paiements. pv est la valeur actuelle. fv est la valeur future impayée une fois tous les paiements effectués. C'est un argument facultatif. Si il est absent, fv est estimé à 0. type est la période au cours de laquelle les paiements doivent être versés. C'est un argument facultatif. Si il est égal à 0 ou absent, la fonction estime que les paiements doivent être versés à la fin de la période. Si type est égal à 1, les paiements doivent être versés au début de la période. Remarque : les sommes versées ( telles que dépôts d'épargne ) sont représentées par des nombres négatifs ; les sommes reçues ( telles que dividendes ) sont représentées par des nombres positifs. Les unités pour rate et nper doivent être cohérentes : utilisez N%/12 pour rate et N*12 pour nper dans le cas de paiements mensuels, N%/4 pour rate et N*4 pour nper dans le cas de paiements trimestriels, N% pour rate et N pour nper en cas de paiements annuels. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction VPM, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction VPM, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/poisson-dist.htm", 
        "title": "Fonction LOI.POISSON.N", 
        "body": "La fonction LOI.POISSON.N est l'une des fonctions statistiques. Elle est utilisée pour retourner la distribution de Poisson; une application courante de la distribution de Poisson est de prédire le nombre d'événements sur une période donnée, comme le nombre de voitures arrivant sur un péage en 1 minute. La syntaxe de la fonction LOI.POISSON.N est : LOI.POISSON.N(x, mean, cumulative) où x est le nombre d'événements, une valeur numériaue supérieure à 0. mean est une valeur numérique prévue supérieure à 0. cumulative est la forme de la fonction, une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si cumulative est TRUE (VRAI), la fonction renvoie la probabilité de Poisson cumulative ; s'il est FALSE (FAUX), elle renvoie la fonction de probabilité de masse de Poisson. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.POISSON.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.POISSON.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/poisson.htm", 
        "title": "Fonction LOI.POISSON", 
        "body": "La fonction LOI.POISSON est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la probabilité d'une variable aléatoire suivant une loi de Poisson. La syntaxe de la fonction LOI.POISSON est : LOI.POISSON(x, mean, cumulative-flag) où x est le nombre d'événements, une valeur numérique supérieure à 0. mean est une valeur numérique prévue supérieure à 0. cumulative-flag est la forme de la fonction, une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si cumulative-flag est TRUE (VRAI), la fonction renvoie la probabilité de Poisson cumulative ; s'il est FALSE (FAUX), elle renvoie la fonction de probabilité de masse de Poisson. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.POISSON, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.POISSON, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/power.htm", 
        "title": "Fonction PUISSANCE", 
        "body": "La focntion PUISSANCE est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le résultat d'un nombre élevé à la puissance désirée. La syntaxe de la fonction PUISSANCE est : PUISSANCE(x, y) où x est un nombre qui doit être élevé. y représente l'exposant auquel le nombre de base est élevé. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PUISSANCE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction PUISSANCE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ppmt.htm", 
        "title": "Fonction PRINCPER", 
        "body": "La fonction PRINCPER est l'une des fonctions financières. Elle est utilisée pour calculer le paiement du capital pour un investissement basé sur un taux d'intérêt spécifié et d'un échéancier de paiement constant. La syntaxe de la fonction PRINCPER est : PRINCPER(rate, per, nper, pv [, [fv] [,[type]]]) où rate est le taux d'intérêt pour l'investissement. per est la période pour laquelle vous voulez trouver le paiement du capital. La valeur doit être comprise entre 1 et nper. nper est le nombre de paiements. pv est la valeur actuelle des paiements. fv est une valeur future (c'est-à-dire un solde de trésorerie restant après le dernier paiement). C'est un argument facultatif. Si il est absent, fv est estimé à 0. type est la période au cours de laquelle les paiements doivent être versés. C'est un argument facultatif. Si il est égal à 0 ou absent, la fonction estime que les paiements doivent être versés à la fin de la période. Si type est égal à 1, les paiements doivent être versés au début de la période. Remarque : les sommes versées ( telles que dépôts d'épargne ) sont représentées par des nombres négatifs ; les sommes reçues ( telles que dividendes ) sont représentées par des nombres positifs. Les unités pour rate et nper doivent être cohérentes : utilisez N%/12 pour rate et N*12 pour nper dans le cas de paiements mensuels, N%/4 pour rate et N*4 pour nper dans le cas de paiements trimestriels, N% pour rate et N pour nper en cas de paiements annuels. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PRINCPER, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction PRINCPER, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/price.htm", 
        "title": "Fonction PRIX.TITRE", 
        "body": "La fonction PRIX.TITRE est l'une des fonctions financières. Elle est utilisée pour calculer le prix par valeur nominale de 100 $ pour un titre qui paie des intérêts périodiques. La syntaxe de la fonction PRIX.TITRE est : PRIX.TITRE(settlement, maturity, rate, yld, redemption, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. rate est le taux de coupon annuel du titre. yld est le rendement annuel du titre. redemption correspond à la valeur de rachat du titre, par tranche de 100$ de valeur nominale. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PRIX.TITRE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction PRIX.TITRE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/pricedisc.htm", 
        "title": "Fonction VALEUR.ENCAISSEMENT", 
        "body": "La fonction VALEUR.ENCAISSEMENT est l'une des fonctions financières. Elle est utilisée pour calculer le prix par valeur nominale de 100 $ pour un titre à prix réduit. La syntaxe de la fonction VALEUR.ENCAISSEMENT est : VALEUR.ENCAISSEMENT(settlement, maturity, discount, redemption[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. discount est le taux d'actualisation du titre. redemption correspond à la valeur de rachat du titre, par tranche de 100$ de valeur nominale. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction VALEUR.ENCAISSEMENT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction VALEUR.ENCAISSEMENT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/pricemat.htm", 
        "title": "Fonction PRIX.TITRE.ECHEANCE", 
        "body": "La fonction PRIX.TITRE.ECHEANCE est l'une des fonctions financières. Elle est utilisée pour calculer le prix par valeur nominale de 100 $ pour un titre qui paie des intérêts à l'échéance. La syntaxe de la fonction PRIX.TITRE.ECHEANCE est : PRIX.TITRE.ECHEANCE(settlement, maturity, issue, rate, yld[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. issue est la date d'émission du titre. rate est le taux d'intérêt du titre à la date d'émission. yld est le rendement annuel du titre. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PRIX.TITRE.ECHEANCE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction PRIX.TITRE.ECHEANCE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/prob.htm", 
        "title": "Fonction PROBABILITE", 
        "body": "La fonction PROBABILITE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la probabilité dont les valeurs se trouvent dans une plage entre les limites inférieure et supérieure. La syntaxe de la fonction PROBABILITE est : PROBABILITE(x-range, probability-range, lower-limit[, upper-limit]) où x-range est une plage de cellules sélectionnée contenant les valeurs numériques auxquelles vous souhaitez associer la probabilité. probability-range est une série de probabilités associées aux valeurs dans la x-range, une plage de cellules sélectionnée contenant les valeurs numériques supérieures à 0 mais inférieures à 1. La somme des valeurs dans la probability-range doit être égale à 1, sinon la fonction renvoie l'erreur #NOMBRE!. Remarque : x-range doit contenir le même nombre d'objets que probability-range. lower-limit est la limite inférieure de la valeur, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. upper-limit est la limite supérieure de la valeur, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. C'est un argument facultatif. S'il est omis, la fonction renvoie la probabilité égale à lower-limit. Pour appliquer la fonction PROBABILITE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PROBABILITE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/product.htm", 
        "title": "Fonction PRODUIT", 
        "body": "La fonction PRODUIT est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour multiplier tous les nombres dans la plage de cellules sélectionnée et renvoyer le produit. La syntaxe de la fonction PRODUIT est : PRODUIT(number1, number2, ...) où number1(2) sont des valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PRODUIT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la focntion PRODUIT, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/proper.htm", 
        "title": "Fonction NOMPROPRE", 
        "body": "La fonction NOMPROPRE est l'une des fonctions de texte et de données. Elle est utilisée pour convertir le premier caractère de chaque mot en majuscules et tous les autres en minuscules. La syntaxe de la fonction NOMPROPRE est : NOMPROPRE(text) où text est une valeur de texte saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction NOMPROPRE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction NOMPROPRE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/pv.htm", 
        "title": "Fonction VA", 
        "body": "La fonction VA est l'une des fonctions financières. Elle est utilisée pour calculer la valeur actuelle d'un investissement à la base du taux d'intérêt spécifié et d'un échéancier de paiement constant. La syntaxe de la fonction VA est : VA(rate, nper, pmt [, [fv] [,[type]]]) où rate est le taux d'intérêt. nper est le nombre de paiements. pmt est le montant du paiement. fv est la valeur future. C'est un argument facultatif. Si il est absent, fv est estimé à 0. type est la période au cours de laquelle les paiements doivent être versés. C'est un argument facultatif. Si il est égal à 0 ou absent, la fonction estime que les paiements doivent être versés à la fin de la période. Si type est égal à 1, les paiements doivent être versés au début de la période. Remarque : les sommes versées ( telles que dépôts d'épargne ) sont représentées par des nombres négatifs ; les sommes reçues ( telles que dividendes ) sont représentées par des nombres positifs. Les unités pour rate et nper doivent être cohérentes : utilisez N%/12 pour rate et N*12 pour nper dans le cas de paiements mensuels, N%/4 pour rate et N*4 pour nper dans le cas de paiements trimestriels, N% pour rate et N pour nper en cas de paiements annuels. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction VA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction VA, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/quartile-exc.htm", 
        "title": "Fonction QUARTILE.EXCLURE", 
        "body": "La fonction QUARTILE.EXCLURE est l'une des fonctions statistiques. Elle est utilisée pour envoyer le quartile de l'ensemble de données, basé sur les valeurs de centile de l'intervalle ouvert 0..1. La syntaxe de la fonction QUARTILE.EXCLURE est : QUARTILE.EXCLURE(array, quart) où array est una plage de cellules à analyser, quart est une valeur de quartile à renvoyer, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. La valeur du quartile peut être l'un des éléments suivants : Valeur numérique Quartile 1 Premier quartile (25e centile) 2 Quartile moyen (50e centile) 3 Troisième quartile (75e centile) Pour appliquer la fonction QUARTILE.EXCLURE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction QUARTILE.EXCLURE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/quartile-inc.htm", 
        "title": "Fonction QUARTILE.INCLURE", 
        "body": "La fonction QUARTILE.INCLURE est l'une des fonctions statistiques. Elle est utilisée pour retourner le quartile de l'ensemble de données, en se basant sur les valeurs de centile de l'intervalle fermé 0..1. La syntaxe de la fonction QUARTILE.INCLURE est : QUARTILE.INCLURE(array, quart) où array est una plage de cellules à analyser, quart est une valeur de quartile à renvoyer, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. La valeur du quartile peut être l'un des éléments suivants : Valeur numérique Quartile 0 La plus petite valeur dans la plage de données 1 Premier quartile (25e centile) 2 Quartile moyen (50e centile) 3 Troisième quartile (75e centile) 4 La plus grande valeur dans la plage de données Pour appliquer la fonction QUARTILE.INCLURE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction QUARTILE.INCLURE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/quartile.htm", 
        "title": "Fonction QUARTILE", 
        "body": "La fonction QUARTILE est l'une des fonctions statistiques. Elle est utilisée pour analyser la plage de données et renvoyer le quartile. La syntaxe de la fonction QUARTILE est : QUARTILE(array , result-category) où array est una plage de cellules à analyser, result-category est une valeur de quartile à renvoyer, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. La valeur du quartile peut être l'un des éléments suivants : Valeur numérique Quartile 0 La plus petite valeur dans la plage de données 1 Premier quartile (25e centile) 2 Quartile moyen (50e centile) 3 Troisième quartile (75e centile) 4 La plus grande valeur dans la plage de données Pour appliquer la fonction QUARTILE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction QUARTILE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/quotient.htm", 
        "title": "Fonction QUOTIENT", 
        "body": "La fonction QUOTIENT est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la partie entière de la division. La syntaxe de la fonction QUOTIENT est : QUOTIENT(dividend, divisor) où dividend et divisor sont des valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction QUOTIENT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie à partir de la liste, cliquez sur la fonction QUOTIENT, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/radians.htm", 
        "title": "Fonction RADIANS", 
        "body": "La fonction RADIANS est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour convertir des degrés en radians. La syntaxe de la fonction RADIANS est : RADIANS(angle) où angle est une valeur numérique (degrés) saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction RADIANS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction RADIANS, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rand.htm", 
        "title": "Fonction ALEA", 
        "body": "La fonction ALEA est l'une des fonctions mathématiques et trigonométriques. La fonction renvoie un nombre aléatoire supérieur ou égal à 0 et inférieur à 1. Elle ne prend aucun argument. La syntaxe de la fonction ALEA est: ALEA() Pour appliquer la fonction ALEA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ALEA, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/randarray.htm", 
        "title": "Fonction TABLEAU.ALEAT", 
        "body": "La fonction TABLEAU.ALEAT est l'une des fonctions mathématiques et trigonométriques. Cette fonction renvoie un tableau de nombres aléatoires, on peut spécifier le nombre de lignes et colonnes pour remplissage, la plage de valeurs ou retourner des nombres entiers ou des valeurs décimales. La syntaxe de la fonction TABLEAU.ALEAT est comme suit: TABLEAU. ALEAT ([Rangées],[Colonnes],[min],[max],[nombre_entier]) où: lignes est un argument facultatif indiquant le nombre de lignes à renvoyer. Si vous n'entrez aucun argument, la fonction renverra une valeur unique comprise entre 0 et 1. colonne est un argument facultatif indiquant le nombre de colonnes à renvoyer. Si vous n'entrez aucun argument, la fonction renverra une valeur unique comprise entre 0 et 1. min est un argument facultatif indiquant le nombre minimal à renvoyer. Si vous n'entrez un argument, la fonction défaut à 0 et 1 respectivement. max est un argument facultatif indiquant le nombre maximal à renvoyer. Si vous n'entrez un argument, la fonction défaut à 0 et 1 respectivement. nombre_entier est un argument facultatif VRAI ou FAUX. Si VRAI, la fonction renverra un nombre entier; FAUX renverra un nombre décimal. Pour utiliser la fonction TABLEAU.ALEAT, sélectionnez la cellule où vous voulez afficher le résultat, appuyez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie dans la liste, appuyez sur la fonction TABLEAU.ALEAT, entrez les arguments en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/randbetween.htm", 
        "title": "Fonction ALEA.ENTRE.BORNES", 
        "body": "La fonction ALEA.ENTRE.BORNES est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer un nombre aléatoire supérieur ou égal à lower-bound et inférieur ou égal à upper-bound. La syntaxe de la fonction ALEA.ENTRE.BORNES est : ALEA.ENTRE.BORNES(lower-bound, upper-bound) où lower-bound est une valeur entière plus petite. upper-bound est une valeur entière plus grande. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : si lower-bound est supérieur à upper-bound, la fonction renvoie l'erreur #NOMBRE!. Pour appliquer la fonction ALEA.ENTRE.BORNES, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ALEA.ENTRE.BORNES, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rank-avg.htm", 
        "title": "Fonction MOYENNE.RANG", 
        "body": "La fonction MOYENNE.RANG est l'une des fonctions statistiques. Elle est utilisée pour retourner le rang d'un nombre dans une liste de nombres. Le rang d'un nombre est sa taille par rapport à d'autres valeurs dans une liste (si vous deviez trier la liste, le rang du nombre serait sa position). Si plusieurs valeurs occupent le même rang, le rang moyen est renvoyé. La syntaxe de la fonction MOYENNE.RANG est : MOYENNE.RANG(number, ref[, order]) où number est la valeur dont vous voulez trouver le rang. ref est une plage de cellules sélectionnée contenant le nombre number. order est la valeur numérique qui spécifie comment ordonner le tableau ref. C'est un argument facultatif. Si sa valeur est 0 ou omise, la fonction classe number comme si ref était une liste triée par ordre décroissant. Toute autre valeur numérique est traitée comme la valeur 1 et la fonction classe comme si était une liste triée par ordre croissant. Pour appliquer la fonction MOYENNE.RANG, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MOYENNE.RANG, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rank-eq.htm", 
        "title": "Fonction EQUATION.RANG", 
        "body": "La fonction EQUATION.RANG est l'une des fonctions statistiques. Elle est utilisée pour retourner le rang d'un nombre dans une liste de nombres. Le rang d'un nombre est sa taille par rapport à d'autres valeurs dans une liste (si vous deviez trier la liste, le rang du nombre serait sa position). Si plusieurs valeur occupent le même rang, le premier rang de cet ensemble de valeurs est renvoyé. La syntaxe de la fonction EQUATION.RANG est : EQUATION.RANG(number, ref[, order]) où number est la valeur dont vous voulez trouver le rang. ref est une plage de cellules sélectionnée contenant le nombre . order est la valeur numérique qui spécifie comment ordonner le tableau ref. C'est un argument facultatif. Si sa valeur est 0 ou omise, la fonction classe number comme si ref était une liste triée par ordre décroissant. Toute autre valeur numérique est traitée comme la valeur 1 et la fonction classe comme si était une liste triée par ordre croissant. Pour appliquer la fonction EQUATION.RANG, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction EQUATION.RANG, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rank.htm", 
        "title": "Fonction RANG", 
        "body": "La fonction RANG est l'une des fonctions statistiques. Elle est utilisée pour retourner le rang d'un nombre dans une liste de nombres. Le rang d'un nombre est sa taille par rapport à d'autres valeurs dans une liste (si vous deviez trier la liste, le rang du nombre serait sa position). La syntaxe de la fonction RANG est : RANG(number, ref[, order]) où number est la valeur dont vous voulez trouver le rang. ref est une plage de cellules sélectionnée contenant le nombre number. order est la valeur numérique qui spécifie comment ordonner le tableau ref. C'est un argument facultatif. Si sa valeur est 0 ou omise, la fonction classe number comme si ref était une liste triée par ordre décroissant. Toute autre valeur numérique est traitée comme la valeur 1 et la fonction classe comme si était une liste triée par ordre croissant. Pour appliquer la fonction RANG, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction RANG, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rate.htm", 
        "title": "Fonction TAUX", 
        "body": "La fonction TAUX est l'une des fonctions financières. Elle est utilisée pour calculer le taux d'intérêt d'un investissement basé sur un échéancier de paiement constant. La syntaxe de la fonction TAUX est : TAUX(nper, pmt, pv [, [[fv] [,[[type] [,[guess]]]]]]) où nper est le nombre de paiements. pmt est le montant du paiement. pv est la valeur actuelle des paiements. fv est une valeur future (c'est-à-dire un solde de trésorerie restant après le dernier paiement). C'est un argument facultatif. Si il est absent, fv est estimé à 0. type est la période au cours de laquelle les paiements doivent être versés. C'est un argument facultatif. Si il est égal à 0 ou absent, la fonction estime que les paiements doivent être versés à la fin de la période. Si type est égal à 1, les paiements doivent être versés au début de la période. guess est une estimation du taux. C'est un argument facultatif. En cas d'omission, guess est estimé à 10%. Remarque : les sommes versées ( telles que dépôts d'épargne ) sont représentées par des nombres négatifs ; les sommes reçues ( telles que dividendes ) sont représentées par des nombres positifs. Les unités pour guess et nper doivent être cohérentes : utilisez N%/12 pour guess et N*12 pour nper dans le cas de paiements mensuels, N%/4 pour guess et N*4 pour nper dans le cas de paiements trimestriels, N% pour guess et N pour nper en cas de paiements annuels. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TAUX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction TAUX, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/received.htm", 
        "title": "Fonction VALEUR.NOMINALE", 
        "body": "La fonction VALEUR.NOMINALE est l'une des fonctions financières. Il est utilisé pour calculer le montant reçu à l'échéance pour un titre entièrement investi. La syntaxe de la fonction VALEUR.NOMINALE est : VALEUR.NOMINALE(settlement, maturity, investment, discount[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. investment est le montant payé pour le titre. discount est le taux d'actualisation du titre. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction VALEUR.NOMINALE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction VALEUR.NOMINALE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/replace.htm", 
        "title": "Fonction REMPLACER/REMPLACERB", 
        "body": "La fonction REMPLACER/REMPLACERB est l'une des fonctions de texte et de données. Elle est utilisée pour remplacer un jeu de caractères à la base du nombre de caractères et la position initiale, par un nouveau jeu de caractères. La fonction REMPLACER est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que REMPLACERB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction REMPLACER/REMPLACERB est : REMPLACER(string-1, start-pos, number-chars, string-2) REMPLACERB(string-1, start-pos, number-chars, string-2) où string-1 est un texte à remplacer. start-pos est le commencement du jeu à remplacer. number-chars est le nombre de caractères à remplacer. string-2 est un nouveau texte. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction REMPLACER/REMPLACERB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction REMPLACER/REMPLACERB, insérez les arguments nécessaires en les séparant par des virgules,Remarque : la fonction REMPLACER respecte la casse. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/replaceb.htm", 
        "title": "Fonction REMPLACER/REMPLACERB", 
        "body": "La fonction REMPLACER/REMPLACERB est l'une des fonctions de texte et de données. Elle est utilisée pour remplacer un jeu de caractères à la base du nombre de caractères et la position initiale, par un nouveau jeu de caractères. La fonction REMPLACER est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que REMPLACERB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction REMPLACER/REMPLACERB est : REMPLACER(string-1, start-pos, number-chars, string-2) REMPLACERB(string-1, start-pos, number-chars, string-2) où string-1 est un texte à remplacer. start-pos est le commencement du jeu à remplacer. number-chars est le nombre de caractères à remplacer. string-2 est un nouveau texte. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction REMPLACER/REMPLACERB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction REMPLACER/REMPLACERB, insérez les arguments nécessaires en les séparant par des virgules,Remarque : la fonction REMPLACER respecte la casse. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rept.htm", 
        "title": "Fonction REPT", 
        "body": "La fonction REPT est l'une des fonctions de texte et de données. Elle est utilisée pour remplir une cellule avec plusieurs instances d'une chaîne de texte. La syntaxe de la fonction REPT est : REPT(text, number_of_times) où text sont des données à répéter, number_of_times représente un nombre indiquant le nombre de répétitions de la chaîne de texte. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction REPT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction REPT, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/right.htm", 
        "title": "Fonction DROITE/DROITEB", 
        "body": "La fonction DROITE/DROITEB est l'une des fonctions de texte et de données. Elle est utilisée pour extraire une sous-chaîne de la chaîne à partir du caractère droit à la base du nombre de caractères spécifié. La fonction DROITE est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que DROITEB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction DROITE/DROITEB est : DROITE(string [, number-chars]) DROITEB(string [, number-chars]) où string est la chaîne de laquelle vous voulez extraire la sous-chaîne, number-chars est le nombre de caractères dans la sous-chaîne. C'est un argument facultatif. S'il est omis, la fonction l'assume d'être égal à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DROITE/DROITEB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction DROITE/DROITEB, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rightb.htm", 
        "title": "Fonction DROITE/DROITEB", 
        "body": "La fonction DROITE/DROITEB est l'une des fonctions de texte et de données. Elle est utilisée pour extraire une sous-chaîne de la chaîne à partir du caractère droit à la base du nombre de caractères spécifié. La fonction DROITE est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que DROITEB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction DROITE/DROITEB est : DROITE(string [, number-chars]) DROITEB(string [, number-chars]) où string est la chaîne de laquelle vous voulez extraire la sous-chaîne, number-chars est le nombre de caractères dans la sous-chaîne. C'est un argument facultatif. S'il est omis, la fonction l'assume d'être égal à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction DROITE/DROITEB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction DROITE/DROITEB, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/roman.htm", 
        "title": "Fonction ROMAIN", 
        "body": "La fonction ROMAIN est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour convertir un nombre en un chiffre romain. La syntaxe de la fonction ROMAIN est : ROMAIN(nombre, [type]) où nombre est une valeur numérique supérieure ou égale à 1 et inférieure à 3999 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. type est le type de chiffre romain : Valeur Type 0 Classique 1 Plus concis 2 Plus concis 3 Plus concis 4 Simplifié TRUE (VRAI) Classique FALSE (FAUX) Simplifié Pour appliquer la fonction ROMAIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ROMAIN, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/round.htm", 
        "title": "Fonction ARRONDI", 
        "body": "La fonction ARRONDI est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir un nombre à un nombre de décimales spécifié. La syntaxe de la fonction ARRONDI est : ARRONDI(number, num_digits) où number est le nombre à arrondir. num_digits est le nombre de décimales auquel vous voulez arrondir. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction ARRONDI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ARRONDI, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rounddown.htm", 
        "title": "Fonction ARRONDI.INF", 
        "body": "La fonction ARRONDI.INF est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir au-dessous le nombre au nombre de décimales voulu. La syntaxe de la fonction ARRONDI.INF est : ARRONDI.INF(number, num_digits) où number est le nombre à arrondir. num_digits est le nombre de décimales auquel vous voulez arrondir. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction ARRONDI.INF, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ARRONDI.INF, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/roundup.htm", 
        "title": "Fonction ARRONDI.SUP", 
        "body": "La fonction ARRONDI.SUP est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour arrondir au-dessus le nombre au nombre de décimales voulu. La syntaxe de la fonction ARRONDI.SUP est : ARRONDI.SUP(number, num_digits) où number est le nombre à arrondir. num_digits est le nombre de décimales auquel vous voulez arrondir. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction ARRONDI.SUP, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction ARRONDI.SUP, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/row.htm", 
        "title": "Fonction LIGNE", 
        "body": "La fonction LIGNE est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer le numéro de ligne d'une cellule. La syntaxe de la fonction LIGNE est : LIGNE([reference]) où reference est une référence à une cellule. Remarque : reference is an optional argument. En cas d'omission, la fonction renvoie le numéro de colonne de la cellule dans laquelle la fonction LIGNE est entrée. Pour appliquer la fonction LIGNE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction LIGNE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rows.htm", 
        "title": "Fonction LIGNES", 
        "body": "La fonction LIGNES est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer le nombre de lignes dans une référence de cellule. La syntaxe de la fonction LIGNES est : LIGNES(array) où array est une référence à une plage de cellules. Pour appliquer la fonction LIGNES, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction LIGNES, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rri.htm", 
        "title": "Fonction TAUX.INT.EQUIV", 
        "body": "La fonction TAUX.INT.EQUIV est l'une des fonctions financières. Elle est utilisée pour retourner un taux d'intérêt équivalent pour la croissance d'un investissement. La syntaxe de la fonction TAUX.INT.EQUIV est : TAUX.INT.EQUIV(nper, pv, fv) où nper est un nombre de périodes pour l'investissement. pv est la valeur actuelle de l'investissement. fv est la valeur future impayée d'un investissement. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TAUX.INT.EQUIV, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction TAUX.INT.EQUIV, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/rsq.htm", 
        "title": "Fonction COEFFICIENT.DETERMINATION", 
        "body": "La fonction COEFFICIENT.DETERMINATION est l'une des fonctions statistiques. Elle est utilisée pour renvoyer le carré du coefficient de corrélation des moments du produit de Pearson. La syntaxe de la fonction COEFFICIENT.DETERMINATION est : COEFFICIENT.DETERMINATION(array-1 , array-2) où array-1 et array-2 ce sont des plages de cellules sélectionnées avec le même nombre d'éléments. Remarque : si array-1(2) contient du texte, des valeurs logiques, des cellules vides, la fonction ignore ces valeurs, mais prend en considération les cellules avec les valeurs zéro. Pour appliquer la fonction COEFFICIENT.DETERMINATION, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction COEFFICIENT.DETERMINATION, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/search.htm", 
        "title": "Fonction CHERCHE/CHERCHERB", 
        "body": "La fonction CHERCHE/CHERCHERB est l'une des fonctions de texte et de données. Elle est utilisée pour renvoyer la position de la sous-chaîne dans la chaîne. La fonction CHERCHE est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que CHERCHERB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction CHERCHE/CHERCHERB est : CHERCHE(string-1, string-2 [,start-pos]) CHERCHERB(string-1, string-2 [,start-pos]) où string-1 est la sous-chaîne à rechercher. string-2 est la chaîne dans laquelle vous voulez rechercher. start-pos est la position à partir de laquelle vous voulez commencer la recherche. C'est un argument facultatif. S'il est omis, la fonction effectue la recherche dès le commencement de la string-2. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : si la fonction ne trouve pas de correspondances, elle renvoie l'erreur #VALUE!. Pour appliquer la fonction CHERCHE/CHERCHERB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction CHERCHE/CHERCHERB, insérez les arguments nécessaires en les séparant par des virgules,Remarque : la fonction CHERCHE/CHERCHERB ne respecte pas la casse. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/searchb.htm", 
        "title": "Fonction CHERCHE/CHERCHERB", 
        "body": "La fonction CHERCHE/CHERCHERB est l'une des fonctions de texte et de données. Elle est utilisée pour renvoyer la position de la sous-chaîne dans la chaîne. La fonction CHERCHE est destinée pour les langues qui utilisent un jeu de caractères à un octet (SBCS), tendis que CHERCHERB est pour les langues qui utilisent un jeu de caractères à deux octets (DBCS) telles que japonais, chinois, coréen etc. La syntaxe de la fonction CHERCHE/CHERCHERB est : CHERCHE(string-1, string-2 [,start-pos]) CHERCHERB(string-1, string-2 [,start-pos]) où string-1 est la sous-chaîne à rechercher. string-2 est la chaîne dans laquelle vous voulez rechercher. start-pos est la position à partir de laquelle vous voulez commencer la recherche. C'est un argument facultatif. S'il est omis, la fonction effectue la recherche dès le commencement de la string-2. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : si la fonction ne trouve pas de correspondances, elle renvoie l'erreur #VALUE!. Pour appliquer la fonction CHERCHE/CHERCHERB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction CHERCHE/CHERCHERB, insérez les arguments nécessaires en les séparant par des virgules,Remarque : la fonction CHERCHE/CHERCHERB ne respecte pas la casse. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sec.htm", 
        "title": "Fonction SEC", 
        "body": "La fonction SEC est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la sécante d'un angle spécifié en radians. La syntaxe de la fonction SEC est : SEC(x) où x est l'angle en radians pour lequel on veut calculer la sécante. Une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Sa valeur absolue doit être inférieure à 2^27. Pour appliquer la fonction SEC, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SEC, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sech.htm", 
        "title": "Fonction SECH", 
        "body": "La fonction SECH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la sécante hyperbolique d'un angle spécifié en radians. La syntaxe de la fonction SECH est : SECH(x) où x est l'angle en radians pour lequel on veut calculer la sécante hyperbolique. Une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Sa valeur absolue doit être inférieure à 2^27. Pour appliquer la fonction SECH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SECH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/second.htm", 
        "title": "Fonction SECONDE", 
        "body": "La fonction SECONDE est l'une des fonctions de date et d'heure. Elle renvoie les secondes (un nombre de 0 à 59) d'une valeur de temps. La syntaxe de la fonction SECONDE est : SECONDE( time-value ) où time-value est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Remarque: time-value (valeur de temps) peut être exprimée comme une valeur de chaîne (par exemple \"13:39:15\"), un nombre décimal (par exemple 0.56 correspondant à 13:26:24) , ou le résultat d'une formule (par exemple le résultat de la fonction NOW - 9/26/12 13:39) Pour appliquer la fonction SECONDE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction SECONDE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sequence.htm", 
        "title": "Fonction SEQUENCE", 
        "body": "Fonction SEQUENCE est l'une des fonctions mathématiques et trigonométriques. Cette fonction permet de générer un tableau de nombres séquentiels. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction SEQUENCE: =SEQUENCE(lignes;[colonnes];[début];[étape]) où: lignes sert à définir le nombre de lignes à renvoyer. colonnes sert à définir le nombre de colonnes à renvoyer. début sert à définir le premier nombre de la séquence. étape sert à contrôler la valeur ajoutée à chaque valeur ultérieure par l'incrément. Pour appliquer la fonction SEQUENCE, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie dans la liste, cliquez sur la fonction SEQUENCE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/seriessum.htm", 
        "title": "Fonction SOMME.SERIES", 
        "body": "La fonction SOMME.SERIES est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la somme d'une série géométrique. La syntaxe de la fonction SOMME.SERIES est : SOMME.SERIES(input-value, intial-power, step, coefficients) où input-value est une valeur d'entrée de la série géométrique. intial-power est la puissance de départ de la variable input-value. step est l'intervalle à laquelle vous voulez augmenter intial-power pour chaque terme de la série. coefficients sont des coefficients par lesquelles chaque puissance successive de input-value sera multipliée. Le nombre de coefficients détermine le nombre de termes dans la série. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction SOMME.SERIES, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SOMME.SERIES, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sheet.htm", 
        "title": "Fonction FEUILLE", 
        "body": "La fonction FEUILLE est l'une des fonctions d'information. Elle est utilisée pour renvoyer le numéro de feuille d'une feuille de référence. La syntaxe de la fonction FEUILLE est : FEUILLE(value) où value est le nom d'une feuille ou d'une référence pour laquelle vous voulez le numéro de feuille. Si value est omise, le numéro de feuille actuel est renvoyé. Pour appliquer la fonction FEUILLE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction FEUILLE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sheets.htm", 
        "title": "Fonction FEUILLES", 
        "body": "La fonction FEUILLES est l'une des fonctions d'information. Elle est utilisée pour renvoyer le nombre de feuilles dans une référence. La syntaxe de la fonction FEUILLES est : FEUILLES(reference) où reference est une référence dont vous voulez connaître le nombre de feuilles. Si reference est omise, le nombre de feuilles dans le classeur courant est renvoyé. Pour appliquer la fonction FEUILLES, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction FEUILLES, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sign.htm", 
        "title": "Fonction SIGNE", 
        "body": "La fonction SIGNE est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le signe d’un nombre. Si le nombre est positif, la fonction renvoie 1. Si le nombre est négatif, la fonction renvoie -1. Si le nombre est 0, la fonction renvoie 0. La syntaxe de la fonction SIGNE est : SIGNE(x) où x est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction SIGNE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SIGNE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Par exemple : L'argument nécessaire est A1, où A1 est 12. Le nombre est positif, donc la fonction renvoie 1. Si nous changeons la valeur de A1 de 12 à -12, la fonction renvoie -1 :"
    },
   {
        "id": "Functions/sin.htm", 
        "title": "Fonction SIN", 
        "body": "La fonction SIN est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le sinus d'un angle donné. La syntaxe de la fonction SIN est : SIN(x) où x est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction SIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SIN, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sinh.htm", 
        "title": "Fonction SINH", 
        "body": "La fonction SINH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer le sinus hyperbolique d'un nombre. La syntaxe de la fonction SINH est : SINH(x) où x est une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction SINH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SINH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/skew-p.htm", 
        "title": "Fonction COEFFICIENT.ASYMETRIE.P", 
        "body": "La fonction COEFFICIENT.ASYMETRIE.P est l'une des fonctions statistiques. Elle est utilisée pour retourner l'asymétrie d'une distribution basée sur une population: une caractérisation du degré d'asymétrie d'une distribution autour de sa moyenne. La syntaxe de la fonction COEFFICIENT.ASYMETRIE.P est : COEFFICIENT.ASYMETRIE.P(number-1 [, number 2], ...) où number-1(2) est une série contenant jusqu'à 254 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : si un argument de référence contient du texte, des valeurs logiques ou des cellules vides, la fonction ignore ces valeurs, mais traite les cellules avec les valeurs nulles. Pour appliquer la fonction COEFFICIENT.ASYMETRIE.P, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction COEFFICIENT.ASYMETRIE.P, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/skew.htm", 
        "title": "Fonction COEFFICIENT.ASYMETRIE", 
        "body": "La fonction COEFFICIENT.ASYMETRIE est l'une des fonctions statistiques. Elle est utilisée pour analyser la plage de données et renvoyer l'asymétrie de la distribution de la liste d'arguments. La syntaxe de la fonction COEFFICIENT.ASYMETRIE est : COEFFICIENT.ASYMETRIE(argument-list) où argument-list est une liste contenant jusqu'à 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est référence. Pour appliquer la fonction COEFFICIENT.ASYMETRIE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction COEFFICIENT.ASYMETRIE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sln.htm", 
        "title": "Fonction AMORLIN", 
        "body": "La fonction AMORLIN est l'une des fonctions financières. Elle est utilisée pour calculer la dépréciation d'un actif pour une période comptable en utilisant la méthode d'amortissement linéaire. La syntaxe de la fonction AMORLIN est : AMORLIN(cost, salvage, life) où cost est le coût de l'actif. salvage est la valeur de récupération de l'actif à la fin de sa durée de vie. life est le nombre total de périodes dans la durée de vie de l'actif. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction AMORLIN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction AMORLIN, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/slope.htm", 
        "title": "Fonction PENTE", 
        "body": "La fonction PENTE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la pente d'une droite de régression linéaire à travers les données dans deux matrices. La syntaxe de la fonction PENTE est : PENTE(array-1 , array-2) où array-1 et array-2 ce sont des plages de cellules sélectionnées avec le même nombre d'éléments. Remarque : si array-1(2) contient du texte, des valeurs logiques, des cellules vides, la fonction ignore ces valeurs, mais prend en considération les cellules avec les valeurs zéro. Pour appliquer la fonction PENTE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PENTE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/small.htm", 
        "title": "Fonction PETITE.VALEUR", 
        "body": "La fonction PETITE.VALEUR est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de cellules et renvoyer la k-ième plus petite valeur. La syntaxe de la fonction PETITE.VALEUR est : PETITE.VALEUR(array , k) où array est une plage de cellules à analyser. k est la position du nombre à partir de la plus petite valeur, une valeur numérique supérieure à 0 saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction PETITE.VALEUR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction PETITE.VALEUR, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sort.htm", 
        "title": "Fonction TRIER", 
        "body": "La fonction TRIER appartient aux fonctions de recherche et de référence. Cette fonction est destinée au tri d'une plage de données ou d'un tableau et au renvoi du plage triée. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction TRIER: =TRIER(tableau;[index_tri];[ordre_tri];[par_col]) où: tableau est la plage de données à trier. [index_tri] est un argument facultatif. C'est le nombre de la colonne ou de la ligne à trier. [ordre_tri] est un argument facultatif. C'est un nombre définissant l'ordre de tri: 1 ou s'il est omis pour l'ordre croissant (par défaut), -1 pour l'ordre décroissant, [par_col] est un argument facultatif. C'est une valeur indiquant la direction de tri: FAUX ou si elle est omise pour trier les données qui sont organisées verticalement VRAI pour trier par colonne lorsque vos données sont organisées horizontalement. Pour appliquer la fonction TRIER, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction TRIER, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/sortby.htm", 
        "title": "Fonction TRIERPAR", 
        "body": "La fonction TRIERPAR est l'une des fonctions de recherche et référence. Cette fonction est destinée au tri d'une plage de données ou d'un tableau et au renvoi du plage triée. Syntaxe =TRIERPAR(tableau; tableau_tri [ordre_tri], ...) Les arguments de la fonction TRIEPAR sont les suivants: Argument Description tableau La plage de données à trier. tableau_tri Le tableau ou la plage à utiliser pour le tri. ordre_tri C'est un argument facultatif. C'est un nombre définissant l'ordre de tri. Les valeurs possibles sont énumérées dans le tableau ci-dessous. Les arguments ordre_tri peuvent être les suivants: Valeur numérique Signification 1 ou s'il est omis Ordre croissant -1 Ordre décroissant Remarques Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Comment utiliser la fonction TRIERPAR. Exemples La figure ci-dessous présente le résultat renvoyé par la fonction TRIERPAR."
    },
   {
        "id": "Functions/sqrt.htm", 
        "title": "Fonction RACINE", 
        "body": "La fonction RACINE est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la racine carrée d'un nombre. La syntaxe de la fonction RACINE est : RACINE(x) où x est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Remarque: si la valeur de x est négative, la fonction renvoie l'erreur #NOMBRE!. Pour appliquer la fonction RACINE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction RACINE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sqrtpi.htm", 
        "title": "Fonction RACINE.PI", 
        "body": "La fonction RACINE.PI est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la racine carrée de la constante pi (3.14159265358979) multipliée par le nombre spécifié. La syntaxe de la fonction RACINE.PI est : RACINE.PI(x) où x est un nombre que vous souhaitez multiplier par pi, une valeur numérique saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Remarque: si x (nombre) est négatif, la fonction renvoie l'erreur #NOMBRE!. Pour appliquer la fonction RACINE.PI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône sutuée sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction RACINE.PI, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/standardize.htm", 
        "title": "Fonction CENTREE.REDUITE", 
        "body": "La fonction CENTREE.REDUITE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la valeur normalisée de la distribution caractérisée par des paramètres spécifiés. La syntaxe de la fonction CENTREE.REDUITE est : CENTREE.REDUITE(x, mean, standard-deviation) où x est la valeur à normaliser. mean est la moyenne arithmétique de la distribution. standard-deviation est l'écart type de la distribution, supérieure à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction CENTREE.REDUITE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction CENTREE.REDUITE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/stdev-p.htm", 
        "title": "Fonction ECARTYPE.PEARSON", 
        "body": "La fonction ECARTYPE.PEARSON est l'une des fonctions statistiques. Elle est utilisée pour calculer l'écart-type basé sur la population entière donnée comme arguments (ignore les valeurs logiques et le texte). La syntaxe de la fonction ECARTYPE.PEARSON est : ECARTYPE.PEARSON(number1 [, number2], ...) où number-1(2) est une série contenant jusqu'à 254 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : si un argument de référence contient du texte, des valeurs logiques ou des cellules vides, la fonction ignore ces valeurs, mais traite les cellules avec les valeurs nulles. Pour appliquer la fonction ECARTYPE.PEARSON, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction ECARTYPE.PEARSON, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/stdev-s.htm", 
        "title": "Fonction ECARTYPE.STANDARD", 
        "body": "La fonction ECARTYPE.STANDARD est l'une des fonctions statistiques. Elle est utilisée pour estimer l'écart-type sur la base d'un échantillon (ignore les valeurs logiques et le texte de l'échantillon). La syntaxe de la fonction ECARTYPE.STANDARD est : ECARTYPE.STANDARD(number1 [, number2], ...) où number-1(2) est une série contenant jusqu'à 255 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : si un argument de référence contient du texte, des valeurs logiques ou des cellules vides, la fonction ignore ces valeurs, mais traite les cellules avec les valeurs nulles. Pour appliquer la fonction ECARTYPE.STANDARD, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction ECARTYPE.STANDARD, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/stdev.htm", 
        "title": "Fonction ECARTYPE", 
        "body": "La fonction ECARTYPE est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer l'écart type de la population à la base d'une série de nombres. La syntaxe de la fonction ECARTYPE est : ECARTYPE(argument-list) où argument-list est une liste contenant jusqu'à 255 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est référence. Remarque : si un argument de référence contient du texte, des valeurs logiques ou des cellules vides, la fonction ignore ces valeurs, mais traite les cellules avec les valeurs nulles. Pour appliquer la fonction ECARTYPE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction ECARTYPE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/stdeva.htm", 
        "title": "Fonction STDEVA", 
        "body": "La fonction STDEVA est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer l'écart type de la population à la base d'une série de nombres, textes et valeurs logiques (TRUE (VRAI) ou FALSE (FAUX)). La fonction STDEVA considère tout texte et FALSE (FAUX) d'être égal à 0 et TRUE (VRAI) d'être égal à 1. La syntaxe de la fonction STDEVA est : STDEVA(argument-list) où argument-list est une liste contenant jusqu'à 30 valeurs saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction STDEVA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction STDEVA, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/stdevp.htm", 
        "title": "Fonction ECARTYPEP", 
        "body": "La fonction ECARTYPEP est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer l'écart type de toute une population. La syntaxe de la fonction ECARTYPEP est : ECARTYPEP(argument-list) où argument-list est une liste contenant jusqu'à 255 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est référence. Pour appliquer la fonction ECARTYPEP, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction ECARTYPEP, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/stdevpa.htm", 
        "title": "Fonction STDEVPA", 
        "body": "La fonction STDEVPA est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer l'écart type de toute une population. La syntaxe de la fonction STDEVPA est : STDEVPA(argument-list) où argument-list est une liste contenant jusqu'à 255 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est référence. Remarque : les valeurs de texte et de FALSE (FAUX) sont comptées comme 0, les valeurs TRUE (VRAI) sont comptées comme 1, les cellules vides sont ignorées. Pour appliquer la fonction STDEVPA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction STDEVPA, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/steyx.htm", 
        "title": "Fonction ERREUR.TYPE.XY", 
        "body": "La fonction ERREUR.TYPE.XY est l'une des fonctions statistiques. Elle est utilisée pour renvoyer l'erreur standard de la valeur y prédite pour chaque x dans la ligne de régression. La syntaxe de la fonction ERREUR.TYPE.XY est : ERREUR.TYPE.XY(known-ys, known-xs) où known-ys est un tableau des variables dépendantes. known-xs est un tableau des variables indépendantes. Les données peuvent être saisies à la main ou incluses dans les cellules auxqulles il est fait référence. Les cellules vides, les valeurs logiques, le texte ou les valeurs d'erreur présentes dans n'importe lequel des tableaux sont ignorés. Si elles sont fournies directement à la fonction, les représentations textuelles des nombres et des valeurs logiques sont interprétées comme des nombres. Remarque : les arguments et doivent contenir le même nombre de valeurs de données sinon la fonction renverra la valeur d'erreur #N/A. Pour appliquer la fonction ERREUR.TYPE.XY, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction ERREUR.TYPE.XY, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/substitute.htm", 
        "title": "Fonction SUBSTITUE", 
        "body": "La fonction SUBSTITUE est l'une des fonctions de texte et de données. Elle est utilisée pour remplacer un jeu de caractères par un nouveau. La syntaxe de la fonction SUBSTITUE est : SUBSTITUE(string, old-string, new-string [, occurence]) où string est la chaîne dans laquelle vous voulez remplacer un jeu de caractères. old-string est la chaîne à remplacer. new-string est une nouvelle chaîne. occurence est le nombre d'occurrences à remplacer. C'est un argument facultatif, s'il est omis, la fonction remplace toutes les occurrences dans la string. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction SUBSTITUE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction SUBSTITUE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/subtotal.htm", 
        "title": "Fonction SOUS.TOTAL", 
        "body": "La fonction SOUS.TOTAL est l'une des fonctions mathématiques et trigonométriques. Cette fonction est utilisée pour renvoyer un sous-total dans une liste ou une base de données. La syntaxe de la fonction SOUS.TOTAL est : SOUS.TOTAL(function-number, argument-list) où function-number est une valeur numérique qui spécifie quelle fonction utiliser pour le sous-total. Les valeurs possibles sont listées dans le tableau ci-dessous. Pour les arguments function-number de 1 à 11, la fonction SOUS.TOTAL inclut les valeurs des lignes qui ont été masquées manuellement. Pour les arguments function-number de 101 à 111, la fonction SOUS.TOTAL ignore les valeurs des lignes qui ont été masquées manuellement. Les valeurs masquées par le filtre sont toujours exclues. argument-list est une référence à la plage de cellules contenant les valeurs pour lesquelles vous voulez le sous-total. function-number (inclut les valeurs cachées) function-number (exclut les valeurs cachées) Fonctions 1 101 MOYENNE 2 102 NB 3 103 NBVAL 4 104 MAX 5 105 MIN 6 106 PRODUIT 7 107 ECARTYPE 8 108 ECARTYPEP 9 109 SOMME 10 110 VAR 11 111 VAR.P Pour appliquer la fonction SOUS.TOTAL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SOUS.TOTAL, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. La figure ci-dessous affiche le résultat renvoyé par la fonction SOUS.TOTAL lorsque plusieurs lignes sont masquées."
    },
   {
        "id": "Functions/sum.htm", 
        "title": "Fonction SOMME", 
        "body": "La fonction SOMME est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour additionner tous les nombres contenus dans une plage de cellules et renvoyer le résultat. La syntaxe de la fonction SOMME est : SOMME(number1, number2, ...) où number1(2) sont des valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Comment faire une SOMME Pour appliquer la fonction SOMME, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule et sélectionnez la fonction SOMME du groupe de fonctions Maths et trigonométrie, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sumif.htm", 
        "title": "Fonction SOMME.SI - ONLYOFFICE", 
        "body": "Fonction SOMME.SI La fonction SOMME.SI est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour additionner tous les nombres dans la plage de cellules sélectionnée à la base d'un critère déterminé et renvoyer le résultat. La syntaxe de la fonction SOMME.SI est : SOMME.SI(cell-range, selection-criteria [, sum-range]) où cell-range est une plage de cellules à laquelle on applique le critère. selection-criteria est le critère utilisé pour déterminer les cellules à additionner, une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. sum-range est une plage de cellules à additionner. C'est un argument facultatif, s'il est omis, la fonction additionne les nombres dans cell-range. Remarque: vous pouvez utiliser des caractères génériques lorsque vous spécifiez des critères. Le point d'interrogation \" ? \" peut remplacer n'importe quel caractère et l'astérisque \" * \" peut être utilisé à la place de n'importe quel nombre de caractères. Comment faire formule SOMME.SI Pour appliquer la fonction SOMME.SI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SOMME.SI, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sumifs.htm", 
        "title": "Fonction SOMME.SI.ENS", 
        "body": "La fonction SOMME.SI.ENS est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour additionner tous les nombres dans la plage de cellules sélectionnée en fonction de plusieurs critères et renvoyer le résultat. La syntaxe de la fonction SOMME.SI.ENS est : SOMME.SI.ENS(sum-range, criteria-range1, criteria1, [criteria-range2, criteria2], ...) où sum-range est une plage de cellules à additionner. criteria-range1 est la première plage de cellules à laquelle on applique le critère criteria1. criteria1 est la première condition à remplir. Il est appliqué à la plage criteria-range1 et utilisé pour déterminer les cellules de sum-range à additionner. Sa valeur peut être saisie à la main ou incluse dans la cellule à laquelle il est fait référence. criteria-range2, criteria-2, ...sont des plages supplémentaires de cellules et leurs critères correspondants. Ces arguments sont facultatifs. Remarque: vous pouvez utiliser des caractères génériques lorsque vous spécifiez des critères. Le point d'interrogation \" ? \" peut remplacer n'importe quel caractère et l'astérisque \" * \" peut être utilisé à la place de n'importe quel nombre de caractères. Comment faire une SOMME.SI.ENS Pour appliquer la fonction SOMME.SI.ENS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SOMME.SI.ENS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sumproduct.htm", 
        "title": "Fonction SOMMEPROD", 
        "body": "La fonction SOMMEPROD est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour multiplier les valeurs de la plage de cellules sélectionnée ou matrices et renvoyer la somme des produits. La syntaxe de la fonction SOMMEPROD est : SOMMEPROD(argument-lists) où argument-lists sont des valeurs numériques incluses dans les cellules auxquelles il est fait référence. Vous pouvez entrer jusqu'à 30 plages de cellules ou matrices. Remarque : si argument-list contient des valeurs non numériques, la fonction les prend en considération comme 0. Pour appliquer la fonction SOMMEPROD, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SOMMEPROD, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sumsq.htm", 
        "title": "Fonction SOMME.CARRES", 
        "body": "La fonction SOMME.CARRES est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour additionner des carrés des nombres et renvoyer le résultat. La syntaxe de la fonction SOMME.CARRES est : SOMME.CARRES(argument-list) où argument-list est une liste de valeurs numériques jusqu'à 30 valeurs saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction SOMME.CARRES, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SOMME.CARRES, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sumx2my2.htm", 
        "title": "Fonction SOMME.X2MY2", 
        "body": "La fonction SOMME.X2MY2 est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour additionner la différence des carrés entre deux matrices. La syntaxe de la fonction SOMME.X2MY2 est : SOMME.X2MY2(array-1, array-2) où array-1 et array-2 sont deux plages de cellules avec le même nombre de colonnes et de lignes. Pour appliquer la fonction SOMME.X2MY2, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SOMME.X2MY2, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sumx2py2.htm", 
        "title": "Fonction SOMME.X2PY2", 
        "body": "La fonction SOMME.X2PY2 est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour additionner des carrés des nombres des matrices sélectionnées et renvoyer la somme des résultats. La syntaxe de la fonction SOMME.X2PY2 est : SOMME.X2PY2(array-1, array-2) où array-1 et array-2 sont deux plages de cellules avec le même nombre de colonnes et de lignes. Pour appliquer la fonction SOMME.X2PY2, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SOMME.X2PY2, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/sumxmy2.htm", 
        "title": "Fonction SOMME.XMY2", 
        "body": "La fonction SOMME.XMY2 est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la somme des carrés des différences de deux valeurs correspondantes des matrices. La syntaxe de la fonction SOMME.XMY2 est : SOMME.XMY2(array-1, array-2) où array-1 et array-2 sont deux plages de cellules avec le même nombre de colonnes et de lignes. Pour appliquer la fonction SOMME.XMY2, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction SOMME.XMY2, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/switch.htm", 
        "title": "Fonction SI.MULTIPLE", 
        "body": "La fonction SI.MULTIPLE est l'une des fonctions logiques. Elle est utilisée pour évaluer une valeur (appelée l'expression) par rapport à une liste de valeurs et renvoyer le résultat correspondant à la première valeur correspondante. Si aucune valeur ne correspond, une valeur par défaut est renvoyée. La syntaxe de la fonction SI.MULTIPLE est : SI.MULTIPLE(expression, value1, result1 [, [default or value2] [, [result2]], ...[default or value3, result3]]) où expression est la valeur qui sera comparée à value1 ...value126. value1 ...value126 est la valeur qui sera comparée à expression. result1 ...result126 est le résultat à renvoyer si la value1 ...value126 correspond à expression. default est le résultat à renvoyer s'il n'y a aucune correspondance. Si l'argument default n'est pas spécifié et qu'il n'y a pas de correspondance, la fonction renvoie l'erreur #N/A. Remarque : vous pouvez saisir jusqu'à 254 arguments, soit jusqu'à 126 paires de valeurs et de résultats. Pour appliquer la fonction SI.MULTIPLE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction SI.MULTIPLE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/syd.htm", 
        "title": "Fonction AMORANN", 
        "body": "La fonction AMORANN est l'une des fonctions financières. Elle est utilisée pour calculer la dépréciation d'un actif pour une période comptable donnée en utilisant la somme des chiffres de l'année. La syntaxe de la fonction AMORANN est : AMORANN(cost, salvage, life, per) où cost est le coût de l'actif. salvage est la valeur de récupération de l'actif à la fin de sa durée de vie. life est le nombre total de périodes dans la durée de vie de l'actif. per est la période pour laquelle vous souhaitez calculer l'amortissement. La valeur doit être exprimée dans les mêmes unités que life. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction AMORANN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction AMORANN, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/t-dist-2t.htm", 
        "title": "Fonction LOI.STUDENT.BILATERALE", 
        "body": "La fonction LOI.STUDENT.BILATERALE est l'une des fonctions statistiques. Renvoie la distribution bilatérale en T de Student. La distribution en T de Student est utilisée dans le test d'hypothèse de petits ensembles de données d'échantillons. Utilisez cette fonction à la place d'une table de valeurs critiques pour la distribution en T. La syntaxe de la fonction LOI.STUDENT.BILATERALE est : LOI.STUDENT.BILATERALE(x, deg-freedom) où x est la valeur pour laquelle la fonction doit être calculée. Une valeur numérique supérieure à 0. deg-freedom est le nombre de degrés de liberté, un nombre entier supérieur ou égal à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.STUDENT.BILATERALE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.STUDENT.BILATERALE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/t-dist-rt.htm", 
        "title": "Fonction LOI.STUDENT.DROITE", 
        "body": "La fonction LOI.STUDENT.DROITE est l'une des fonctions statistiques. Renvoie la distribution T de droite de Student. La distribution en T est utilisée dans le test d'hypothèses sur un petit échantillon de données. Utilisez cette fonction à la place d'une table de valeurs critiques pour la distribution en T. La syntaxe de la fonction LOI.STUDENT.DROITE est : LOI.STUDENT.DROITE(x, deg-freedom) où x est la valeur pour laquelle la fonction doit être calculée. deg-freedom est le nombre de degrés de liberté, un nombre entier supérieur ou égal à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.STUDENT.DROITE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.STUDENT.DROITE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/t-dist.htm", 
        "title": "Fonction LOI.STUDENT.N", 
        "body": "La fonction LOI.STUDENT.N est l'une des fonctions statistiques. Renvoie la distribution T de gauche de Student. La distribution en T est utilisée dans le test d'hypothèses sur un petit échantillon de données. Utilisez cette fonction à la place d'une table de valeurs critiques pour la distribution en T. La syntaxe de la fonction LOI.STUDENT.N est : LOI.STUDENT.N(x, deg-freedom, cumulative) où x est la valeur pour laquelle la fonction doit être calculée. deg-freedom est le nombre de degrés de liberté, un nombre entier supérieur ou égal à 1. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de densité de probabilité. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.STUDENT.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.STUDENT.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/t-inv-2t.htm", 
        "title": "Fonction LOI.STUDENT.INVERSE.BILATERALE", 
        "body": "La fonction LOI.STUDENT.INVERSE.BILATERALE est l'une des fonctions statistiques. Renvoie l'inverse de la distribution bilatérale en T de Student. La syntaxe de la fonction LOI.STUDENT.INVERSE.BILATERALE est : LOI.STUDENT.INVERSE.BILATERALE(probability, deg-freedom) où probability est la probabilité associée à la distribution en T de Student. Une valeur numérique supérieure à 0 mais inférieure ou égale à 1. deg-freedom est le nombre de degrés de liberté, un nombre entier supérieur ou égal à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.STUDENT.INVERSE.BILATERALE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.STUDENT.INVERSE.BILATERALE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/t-inv.htm", 
        "title": "Fonction LOI.STUDENT.INVERSE.N", 
        "body": "La fonction LOI.STUDENT.INVERSE.N est l'une des fonctions statistiques. Elle renvoie l'inverse de la distribution de gauche en T de Student. La syntaxe de la fonction LOI.STUDENT.INVERSE.N est : LOI.STUDENT.INVERSE.N(probability, deg-freedom) où probability est la probabilité associée à la distribution en T de Student. Une valeur numérique supérieure à 0 mais inférieure à 1. deg-freedom est le nombre de degrés de liberté, un nombre entier supérieur ou égal à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.STUDENT.INVERSE.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.STUDENT.INVERSE.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/t-test.htm", 
        "title": "Fonction T.TEST", 
        "body": "La fonction T.TEST est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la probabilité associée au test en T de Student. Utilisez T.TEST pour déterminer si deux échantillons sont susceptibles de provenir de deux mêmes populations identiques ayant la même moyenne. La syntaxe de la fonction T.TEST est : T.TEST(array1, array2, tails, type) où array1 est la première plage de valeurs numériques. array2 est la deuxième plage de valeurs numériques. tails spécifie le type de distribution à renvoyer. Si elle est définie sur 1, la fonction utilise la distribution unilatérale. Si elle est définie sur 2, la fonction utilise la distribution bilatérale. type est une valeur numérique qui spécifie le type de test en T à effectuer. La valeur peut être l'un des éléments suivants : Valeur numérique Le type de test en T 1 apparié 2 Variance égale à deux échantillons (homoscédastique) 3 Variance inégale à deux échantillons (hétéroscédastique) Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction T.TEST, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction T.TEST, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/t.htm", 
        "title": "Fonction T", 
        "body": "La fonction T est l'une des fonctions de texte et de données. Elle est utilisée pour vérifier si la valeur dans la cellule (ou utilisée comme argument) c'est un texte ou non. Si ce n'est pas un texte, la fonction renvoie un résultat vide. Si la valeur/argument est un texte, la fonction renvoie la même valeur du texte. La syntaxe de la fonction T est : T(value) où value représente les données saisies à la main ou incluses dans la cellule à laquelle il est fait référence. Pour appliquer la fonction T, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction T, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Par exemple : Il y a un argument : value = A1, où A1 est date et heure. Donc la fonction renvoie date et heure. Si nous changeons les données A1 du texte à la valeur numérique, la fonction renvoie le résultat vide."
    },
   {
        "id": "Functions/take.htm", 
        "title": "Fonction PRENDRE", 
        "body": "La fonction PRENDRE est l'une des fonctions de recherche et de référence. Cette fonction renvoie des lignes ou des colonnes du début ou de la fin du tableau. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction PRENDRE</b>: PRENDRE(tableau, lignes,[colonnes]) où: tableau sert à définir le tableau à partir duquel prendre des lignes ou des colonnes. lignes sert à définir le nombre de lignes à prendre. Une valeur négative signifie la prise en fin du tableau. colonnes sert à définir le nombre de colonnes à prendre. Une valeur négative signifie la prise en fin du tableau. Pour appliquer la fonction PRENDRE, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction PRENDRE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/tan.htm", 
        "title": "Fonction TAN", 
        "body": "La fonction TAN est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la tangente d'un angle donné. La syntaxe de la fonction TAN est : TAN(x) où x est l'angle en radians pour lequel on veut calculer la tangente. Une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. C'est un argument obligatoire. Pour appliquer la fonction TAN, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction TAN, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/tanh.htm", 
        "title": "Fonction TANH", 
        "body": "La fonction TANH est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer la tangente hyperbolique d'un nombre. La syntaxe de la fonction TANH est : TANH(x) où x est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction TANH, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction TANH, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/tbilleq.htm", 
        "title": "Fonction TAUX.ESCOMPTE.R", 
        "body": "La fonction TAUX.ESCOMPTE.R est l'une des fonctions financières. Elle est utilisée pour calculer le rendement équivalent en obligations d'un bon du Trésor. La syntaxe de la fonction TAUX.ESCOMPTE.R est : TAUX.ESCOMPTE.R(settlement, maturity, discount) où settlement est la date à laquelle le bon du Trésor est acheté. maturity est la date d'expiration du bon du Trésor. Cette date doit être à moins d'un an de la date de règlement. discount est le taux d'actualisation du bon du Trésor. Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TAUX.ESCOMPTE.R, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône sutuée sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction TAUX.ESCOMPTE.R, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/tbillprice.htm", 
        "title": "Fonction PRIX.BON.TRESOR", 
        "body": "La fonction PRIX.BON.TRESOR est l'une des fonctions financières. Elle est utilisée pour calculer le prix par valeur nominale de 100 $ pour un bon du Trésor. La syntaxe de la fonction PRIX.BON.TRESOR est : PRIX.BON.TRESOR(settlement, maturity, discount) où settlement est la date à laquelle le bon du Trésor est acheté. maturity est la date d'expiration du bon du Trésor. Cette date doit être à moins d'un an de la date de règlement. discount est le taux d'actualisation du bon du Trésor. Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction PRIX.BON.TRESOR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône sutuée sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction PRIX.BON.TRESOR, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/tbillyield.htm", 
        "title": "Fonction RENDEMENT.BON.TRESOR", 
        "body": "La fonction RENDEMENT.BON.TRESOR est l'une des fonctions financières. Elle est utilisée pour calculer le rendement d'un bon du Trésor. La syntaxe de la fonction RENDEMENT.BON.TRESOR est : RENDEMENT.BON.TRESOR(settlement, maturity, pr) où settlement est la date à laquelle le bon du Trésor est acheté. maturity est la date d'expiration du bon du Trésor. Cette date doit être à moins d'un an de la date de règlement. pr correspond au prix d'achat du bon du Trésor, par tranche de 100$ de valeur nominale. Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction RENDEMENT.BON.TRESOR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône sutuée sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction RENDEMENT.BON.TRESOR, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/tdist.htm", 
        "title": "Fonction LOI.STUDENT", 
        "body": "La fonction LOI.STUDENT est l'une des fonctions statistiques. Renvoie les points de pourcentage (probabilité) pour la distribution en T de Student où une valeur numérique (x) est une valeur calculée de T pour laquelle les points de pourcentage doivent être calculés. La distribution en T est utilisée dans le test d'hypothèses sur un petit échantillon de données. Utilisez cette fonction à la place d'une table de valeurs critiques pour la distribution en T. La syntaxe de la fonction LOI.STUDENT est : LOI.STUDENT(x, deg-freedom, tails) où x est la valeur pour laquelle la fonction doit être calculée. Une valeur numérique supérieure à 0. deg-freedom est le nombre de degrés de liberté, un nombre entier supérieur ou égal à 1. tails est une valeur numérique qui spécifie le type de distribution à renvoyer. Si elle est définie sur 1, la fonction renvoie la distribution unilatérale. Si elle est définie sur 2, la fonction renvoie la distribution bilatérale. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.STUDENT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.STUDENT, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/text.htm", 
        "title": "Fonction TEXTE", 
        "body": "La fonction TEXTE est l'une des fonctions de texte et de données. Elle est utilisée pour convertir une valeur au format spécifié. La syntaxe de la fonction TEXTE est : TEXTE(value, format) où value est une valeur à convertir. format est le format d'affichage du résultat. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TEXTE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction TEXTE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/textafter.htm", 
        "title": "Fonction TEXTE.APRES", 
        "body": "La fonction TEXTE.APRES est l'une des fonctions de données et texte. Cette fonction renvoie le texte qui se trouve après le caractère de délimitation. Le syntaxe de la fonction TEXTE.APRES: =TEXTE.APRES(texte,délimiteur,[no_position], [mode_correspondance], [fin_correspondance], [si_non_trouvé] où: texte est le texte dans lequel la recherche se réalise. Des caractères génériques ne sont pas autorisés. Lorsque la chaîne de caractères texte est vide, le texte renvoyé est vide. délimiteur est le texte qui marque le point après lequel la fonction extrait. no_position est un argument facultatif. Position du délimiteur après laquelle la fonction extrait le texte. Par défaut, no_position est égal à 1. Un nombre négatif commence à rechercher du texte à partir de la fin. mode_correspondance est un argument facultatif. Détermine si la recherche de texte est sensible à la casse. Par défaut, la recherche est sensible à la casse. Les valeurs utilisées: 0 sensible à la casse, 1 insensible à la casse. fin_correspondance est un argument facultatif. Considère la fin du texte comme un délimiteur. Par défaut, le texte correspond exactement. Les valeurs utilisées: 0 ne pas faire correspondre le délimiteur à la fin du texte, 1 faire correspondre le délimiteur à la fin du texte. si_non_trouvé est un argument facultatif. Détermine la valeur renvoyée si aucune correspondance n'est trouvée. Pour appliquer la fonction TEXTE.APRES, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions de Données et texte depuis la liste, cliquez sur la fonction TEXTE.APRES, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/textbefore.htm", 
        "title": "Fonction TEXTE.AVANT", 
        "body": "La fonction TEXTE.AVANTest l'une des fonctions de données et texte. Cette fonction renvoie le texte qui se trouve avant le caractère de délimitation. Le syntaxe de la fonction TEXTE.AVANT: =TEXTE.AVANT(texte,délimiteur,[no_position], [mode_correspondance], [fin_correspondance], [si_non_trouvé] où: texte est le texte dans lequel la recherche se réalise. Des caractères génériques ne sont pas autorisés. Lorsque la chaîne de caractères texte est vide, le texte renvoyé est vide. délimiteur est le texte qui marque le point avant lequel la fonction extrait. no_position est un argument facultatif. Position du délimiteur avant laquelle la fonction extrait le texte. Par défaut, no_position est égal à 1. Un nombre négatif commence à rechercher du texte à partir de la fin. mode_correspondance est un argument facultatif. Détermine si la recherche de texte est sensible à la casse. Par défaut, la recherche est sensible à la casse. Les valeurs utilisées: 0 sensible à la casse, 1 insensible à la casse. fin_correspondance est un argument facultatif. Considère la fin du texte comme un délimiteur. Par défaut, le texte correspond exactement. Les valeurs utilisées: 0 ne pas faire correspondre le délimiteur à la fin du texte, 1 faire correspondre le délimiteur à la fin du texte. si_non_trouvé est un argument facultatif. Détermine la valeur renvoyée si aucune correspondance n'est trouvée. Pour appliquer la fonction TEXTE.AVANT, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions de Données et texte depuis la liste, cliquez sur la fonction TEXTE.AVANT, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/textjoin.htm", 
        "title": "Fonction JOINDRE.TEXTE", 
        "body": "La fonction JOINDRE.TEXTE est l'une des fonctions de texte et de données. Elle est utilisée pour combiner le texte de plusieurs plages et/ou chaînes, et inclut un délimiteur que vous spécifiez entre chaque valeur de texte qui sera combinée. Si le délimiteur est une chaîne de texte vide, cette fonction concaténera les plages. Cette fonction est similaire à la fonction CONCAT, mais la différence est que la fonction CONCAT ne peut pas accepter un délimiteur. La syntaxe de la fonction JOINDRE.TEXTE est : JOINDRE.TEXTE(delimiter, ignore_empty, text1 [, text2], …) où delimiter est le délimiteur à insérer entre les valeurs de texte. Peut être spécifié comme une chaîne de texte entre guillemets (par exemple \",\" (virgule), \" \" (espace), \"\\\" (barre oblique inverse), etc.) ou comme référence à une cellule ou plage de cellules. ignore_empty est une valeur logique qui spécifie si les cellules vides doivent être ignorées. Lorsque la valeur est définie sur TRUE (VRAI), les cellules vides sont ignorées. text1(2) peut accepter jusqu'à 252 valeurs de données. Chaque valeur peut être une chaîne de texte ou une référence à une plage de cellules. Pour appliquer la fonction JOINDRE.TEXTE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction JOINDRE.TEXTE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/textsplit.htm", 
        "title": "Fonction FRACTIONNER.TEXTE", 
        "body": "La fonction FRACTIONNER.TEXTE est l'une des fonctions de données et texte. Cette fonction divise le texte en lignes ou en colonnes à l'aide de délimiteurs. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction FRACTIONNER.TEXTE: FRACTIONNER.TEXTE(texte,délimiteur_col,[délimiteur_ligne],[ignorer_vide], [mode_correspondance], [compléter_avec]) où: texte sert à définir le texte que vous souhaitez fractionner. délimiteur_col est un argument facultatif. Détermine le texte qui marque le point de division du texte sur colonnes. délimiteur_ligne est un argument facultatif. Détermine le texte qui marque le point de division du texte en lignes vers le bas. ignorer_vide est un argument facultatif. Permet de créer une cellule vide quand il n'y a aucun valeur entre deux délimiteurs consécutifs en inscrivant FAUX. Par défaut, la valeur VRAI ignore la valeur manquante entre deux délimiteurs consécutifs. mode_correspondance est un argument facultatif. Permet de rechercher la correspondance exacte du délimiteur. Par défaut, la recherche est sensible à la casse. compléter_avec définit la valeur à compléter le résultat. La valeur par défaut est #N/A. Pour appliquer la fonction FRACTIONNER.TEXTE, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions de Données et texte depuis la liste, cliquez sur la fonction FRACTIONNER.TEXTE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/time.htm", 
        "title": "Fonction TEMPS", 
        "body": "La fonction TEMPS est l'une des fonctions de date et d'heure. Elle est utilisée pour ajouter l'heure spécifiée au format sélectionnée (hh:mm tt par défaut). La syntaxe de la fonction TEMPS est : TEMPS(hour, minute, second) où hour est un nombre de 0 à 23. minute est un nombre de 0 à 59. second est un nombre de 0 à 59. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TEMPS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône sutuée sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction TEMPS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/timevalue.htm", 
        "title": "Fonction TEMPSVAL", 
        "body": "La fonction TEMPSVAL est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer le nombre de série d'une valeur de temps. La syntaxe de la fonction TEMPSVAL est : TEMPSVAL(date-time-string) où date-time-string est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction TEMPSVAL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction TEMPSVAL, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/tinv.htm", 
        "title": "Fonction LOI.STUDENT.INVERSE", 
        "body": "La fonction LOI.STUDENT.INVERSE est l'une des fonctions statistiques. Renvoie l'inverse de la distribution bilatérale en T de Student. La syntaxe de la fonction LOI.STUDENT.INVERSE est : LOI.STUDENT.INVERSE(probability, deg-freedom) où probability est la probabilité associée à la distribution bilatérale en T de Student. Une valeur numérique supérieure à 0 mais inférieure ou égale à 1. deg-freedom est le nombre de degrés de liberté, un nombre entier supérieur ou égal à 1. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.STUDENT.INVERSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.STUDENT.INVERSE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/tocol.htm", 
        "title": "Fonction DANSCOL", 
        "body": "La fonction DANSCOL est l'une des fonctions de recherche et de référence. Cette fonction renvoie le tableau dans une seule colonne. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction DANSCOL: DANSCOL (tableau, [ignorer], [parcourir_par_colonne) où: tableau est le tableau ou une plage à transformer en une colonne. ignorer permet d'ignorer certains types de valeurs. Par défaut conserve toute les valeurs. Les valeurs utilisées: 0 pour conserver toutes les valeurs (par défaut); 1 pour ignorer les vides; 2 pour ignorer les erreurs; 3 pour ignorer les vides et les erreurs. parcourir_par_colonne permet d'analyser le tableau par colonne. Par défaut, le tableau est analysé par ligne. Le façon d'analyser le tableau détermine l'ordre d'organisation des valeurs par lignes ou par colonnes. Pour appliquer la fonction DANSCOL, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction DANSCOL, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/today.htm", 
        "title": "Fonction AUJOURDHUI", 
        "body": "La fonction AUJOURDHUI est l'une des fonctions de date et d'heure. Elle est utilisée pour ajouter la date actuelle au format MM/jj/aa. Cette fonction n'exige pas d'argument. La syntaxe de la fonction AUJOURDHUI est : AUJOURDHUI() Pour appliquer la fonction AUJOURDHUI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction AUJOURDHUI, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/torow.htm", 
        "title": "Fonction DANSLIGNE", 
        "body": "La fonction DANSLIGNE est l'une des fonctions de recherche et de référence. Cette fonction renvoie le tableau dans une seule ligne. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction DANSLIGNE: DANSLIGNE (tableau, [ignorer], [parcourir_par_colonne) où: tableau est le tableau ou une plage à transformer en une ligne. ignorer permet d'ignorer certains types de valeurs. Par défaut conserve toute les valeurs. Les valeurs utilisées: 0 pour conserver toutes les valeurs (par défaut); 1 pour ignorer les vides; 2 pour ignorer les erreurs; 3 pour ignorer les vides et les erreurs. parcourir_par_colonne permet d'analyser le tableau par colonne. Par défaut, le tableau est analysé par ligne. Le façon d'analyser le tableau détermine l'ordre d'organisation des valeurs par lignes ou par colonnes. Pour appliquer la fonction DANSLIGNE, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction DANSLIGNE, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/transpose.htm", 
        "title": "Fonction TRANSPOSE", 
        "body": "La fonction TRANSPOSE est l'une des fonctions de recherche et de référence. Elle est utilisée pour renvoyer le premier élément d'un tableau. La syntaxe de la fonction TRANSPOSE est : TRANSPOSE(array) où array est une référence à une plage de cellules. Pour appliquer la fonction TRANSPOSE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction TRANSPOSE, sélectionnez une plage de cellules avec la souris ou insérez la à la main comme suit A1:B2, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/trend.htm", 
        "title": "Fonction TENDANCE", 
        "body": "La fonction TENDANCE est l'une des fonctions statistiques. La fonction TENDANCE renvoie des valeurs par rapport à une tendance linéaire. Elle s'adapte à une ligne droite à l'aide de la méthode des moindres carrés). La syntaxe de la fonction TENDANCE est comme suit: = TENDANCE (known_y, [known_x], [new_x], [constante]) où: y_connus représente l'ensemble des valeurs y que vous connaissez déjà dans la relation y = mx + b. x_connus représente l'ensemble facultatif de valeurs x que vous connaissez éventuellement dans la relation y = mx + b. x_nouveaux représente l'ensemble facultatif de variables x pour lesquelles vous voulez renvoyer les valeurs y correspondantes. constante représente un argument facultatif. C'est une valeur VRAI ou FAUX où si l'argument constante est VRAI ou omis, la constante b est calculée normalement, et si l'argument constante est FAUX, b est égal à 0 (zéro) dans l'équation y = mx + b et les valeurs m sont ajustées de façon à ce que y = mx. Pour utiliser la fonction TENDANCE, sélectionnez la cellule où vous voulez afficher le résultat, appuyez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Statistiques dans la liste, appuyez sur la fonction TENDANCE, saisissez l'argument approprié et appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/trim.htm", 
        "title": "Fonction SUPPRESPACE", 
        "body": "La fonction SUPPRESPACE est l'une des fonctions de texte et de données. Elle est utilisée pour supprimer des espaces à gauche ou à droite d'une chaîne. La syntaxe de la fonction SUPPRESPACE est : SUPPRESPACE(string) où string est une valeur de texte saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction SUPPRESPACE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction SUPPRESPACE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/trimmean.htm", 
        "title": "Fonction MOYENNE.REDUITE", 
        "body": "La fonction MOYENNE.REDUITE est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la moyenne de l'intérieur d'un ensemble de données. MOYENNE.REDUITE calcule la moyenne prise en excluant un pourcentage de points de données des queues supérieure et inférieure d'un ensemble de données. La syntaxe de la fonction MOYENNE.REDUITE est : MOYENNE.REDUITE(array, percent) où array est la plage de valeurs numériques à découper pour calculer la moyenne. percent est un pourcentage total de points de données à exclure du calcul. Une valeur numérique supérieure ou égale à 0 mais inférieure ou égale à 1. Le nombre de points de données exclus est arrondi au multiple de 2 le plus proche. Par exemple, si contient 30 valeurs et vaut 0,1, 10 % de 30 points est 3. Cette valeur est arrondie à 2, donc 1 point est retiré de chaque queue de l'ensemble de données : 1 à partir du haut et 1 à partir du bas de l'ensemble. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction MOYENNE.REDUITE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction MOYENNE.REDUITE, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/true.htm", 
        "title": "Fonction VRAI", 
        "body": "La fonction VRAI est l'une des fonctions logiques. La fonction renvoie TRUE (vrai) et n'exige aucun argument. La syntaxe de la fonction VRAI est : VRAI() Pour appliquer la fonction VRAI, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction VRAI, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/trunc.htm", 
        "title": "Fonction TRONQUE", 
        "body": "La fonction TRONQUE est l'une des fonctions mathématiques et trigonométriques. Elle est utilisée pour renvoyer un nombre tronqué au nombre de décimales spécifié. La syntaxe de la fonction TRONQUE est : TRONQUE(x [,number-digits]) où x est un nombre à tronquer. number-digits est le nombre de décimales à afficher. C'est un argument facultatif. S'il est omis, la fonction l'assume d'être égal à 0. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TRONQUE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Maths et trigonométrie depuis la liste, cliquez sur la fonction TRONQUE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ttest.htm", 
        "title": "Fonction TEST.STUDENT", 
        "body": "La fonction TEST.STUDENT est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la probabilité associée au test en T de Student. Utilisez TEST.STUDENT pour déterminer si deux échantillons sont susceptibles de provenir de deux mêmes populations identiques ayant la même moyenne. La syntaxe de la fonction TEST.STUDENT est : TEST.STUDENT(array1, array2, tails, type) où array1 est la première plage de valeurs numériques. array2 est la deuxième plage de valeurs numériques. tails spécifie le type de distribution à renvoyer. Si elle est définie sur 1, la fonction utilise la distribution unilatérale. Si elle est définie sur 2, la fonction utilise la distribution bilatérale. type est une valeur numérique qui spécifie le type de test en T à effectuer. La valeur peut être l'un des éléments suivants : Valeur numérique Le type de test en T 1 apparié 2 Variance égale à deux échantillons (homoscédastique) 3 Variance inégale à deux échantillons (hétéroscédastique) Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TEST.STUDENT, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction TEST.STUDENT, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/type.htm", 
        "title": "Fonction TYPE", 
        "body": "La fonction TYPE est l'une des fonctions d'information. Elle est utilisée pour déterminer le type de la valeur résultante ou affichée. La syntaxe de la fonction TYPE est : TYPE(value) où value est une valeur à tester saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Ci-dessous vous trouverez les valeurs possibles et le résultat que TYPE renvoie : Valeur Résultat nombre 1 texte 2 valeur logique 4 valeur d'erreur 16 tableau 64 Pour appliquer la fonction TYPE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Information, cliquez sur la fonction TYPE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/unichar.htm", 
        "title": "Fonction UNICAR", 
        "body": "La fonction UNICAR est l'une des fonctions de texte et de données. Est utilisé pour renvoyer le caractère Unicode référencé par la valeur numérique donnée. La syntaxe de la fonction UNICAR est : UNICAR(number) où number est le nombre Unicode qui représente le caractère. Les données peuvent être saisies à la main ou incluses dans la cellule à laquelle il est fait référence. Pour appliquer la fonction UNICAR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction UNICAR, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/unicode.htm", 
        "title": "Fonction UNICODE", 
        "body": "La fonction UNICODE est l'une des fonctions de texte et de données. Est utilisé pour retourner le nombre(valeur d'encodage) correspondant au premier caractère du texte. La syntaxe de la fonction UNICODE est : UNICODE(text) où text est la chaîne de texte commençant par le caractère pour lequel vous voulez obtenir la valeur Unicode. Les données peuvent être saisies à la main ou incluses dans la cellule à laquelle il est fait référence. Pour appliquer la fonction UNICODE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction UNICODE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/unique.htm", 
        "title": "Fonction UNIQUE", 
        "body": "La fonction UNIQUE est l'une des fonctions de référence. La fonction UNIQUE renvoie une liste de valeurs uniques au sein d'une liste ou d'une plage. La syntaxe de la fonction UNIQUE est comme suit: = UNIQUE (matrice, [by_col], [exactly_once]) où: matrice représente la plage à partir duquel retourner des valeurs uniques. [par_col] représente une valeur facultative VRAI ou FAUX indiquant le mode de comparaison. VRAI comparera les colonnes et FAUX comparera les lignes. [exactly_once] représente une valeur facultative VRAI ou FAUX indiquant le mode de renvoi. VRAI renvoie toutes les valeurs qui se produisent exactement une fois, et FAUX renvoie toutes les valeurs uniques. Pour utiliser la fonction UNIQUE, sélectionnez la cellule où vous voulez afficher le résultat, appuyez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence dans la liste, appuyez sur la fonction UNIQUE, saisissez l'argument approprié et appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie. Pour renvoyer la valeur une d'une matrice de cellules, sélectionnez une plage de cellules, entrez la formule et appuyez Ctrl+Maj+Entrée."
    },
   {
        "id": "Functions/upper.htm", 
        "title": "Fonction MAJUSCULE", 
        "body": "La fonction MAJUSCULE est l'une des fonctions de texte et de données. Elle est utilisée pour convertir les minuscules en majuscules dans la cellule sélectionnée. La syntaxe de la fonction MAJUSCULE est : MAJUSCULE(text) où text représente des données incluses dans la cellule à laquelle il est fait référence. Pour appliquer la fonction MAJUSCULE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction MAJUSCULE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/value.htm", 
        "title": "Fonction VALEUR", 
        "body": "La fonction VALEUR est l'une des fonctions de texte et de données. Elle est utilisée pour convertir une valeur de texte représentant un nombre à un nombre. Si le texte à convertir ce n'est pas un nombre, la fonction renvoie l'erreur #VALEUR!. La syntaxe de la fonction VALEUR est : VALEUR(string) où string est une chaîne de données représentant un nombre saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction VALEUR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Texte et données depuis la liste, cliquez sur la fonction VALEUR, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/var-p.htm", 
        "title": "Fonction VAR.P.N", 
        "body": "La fonction VAR.P.N est l'une des fonctions statistiques. Elle est utilisée pour calculer la variance sur la base de toute la population(ignore les valeurs logiques et le texte dans la population). La syntaxe de la fonction VAR.P.N est : VAR.P.N(number1 [, number2], ...) où number1(2) est une série contenant jusqu'à 254 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Les cellules vides, les valeurs logiques, le texte ou les valeurs d'erreur présentes dans n'importe lequel des tableaux sont ignorés. Si elles sont fournies directement à la fonction, les représentations textuelles des nombres et des valeurs logiques sont interprétées comme des nombres. Pour appliquer la fonction VAR.P.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction VAR.P.N, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/var-s.htm", 
        "title": "Fonction VAR.S", 
        "body": "La fonction VAR.S est l'une des fonctions statistiques. Elle est utilisée pour estimer la variance sur la base d'un échantillon (ignore les valeurs logiques et le texte de l'échantillon). La syntaxe de la fonction VAR.S est : VAR.S(number1 [, number2], ...) où number1(2) est une série contenant jusqu'à 254 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : les cellules vides, les valeurs logiques, le texte ou les valeurs d'erreur fournies dans le cadre d'un tableau sont ignorés. Si elles sont fournies directement à la fonction, les représentations textuelles des nombres et des valeurs logiques sont interprétées comme des nombres. Pour appliquer la fonction VAR.S, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction VAR.S, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/var.htm", 
        "title": "Fonction VAR", 
        "body": "La fonction VAR est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer la variance de la population à la base d'une série de nombres. La syntaxe de la fonction VAR est : VAR(argument-list) où argument-list est une liste contenant jusqu'à 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : les cellules vides, les valeurs logiques, le texte ou les valeurs d'erreur fournies dans le cadre d'un tableau sont ignorés. Si elles sont fournies directement à la fonction, les représentations textuelles des nombres et des valeurs logiques sont interprétées comme des nombres. Pour appliquer la fonction VAR, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction VAR, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/vara.htm", 
        "title": "Fonction VARA", 
        "body": "La fonction VARA est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer la variance de la population à la base d'une série de nombres. La syntaxe de la fonction VARA est : VARA(argument-list) où argument-list est un ensemble de valeurs entrées manuellement ou incluses dans les cellules auxquelles vous faites référence. Remarque : les valeurs de texte et de FALSE (FAUX) sont comptées comme 0, les valeurs TRUE (VRAI) sont comptées comme 1, les cellules vides sont ignorées. Pour appliquer la fonction VARA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction VARA, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/varp.htm", 
        "title": "Fonction VAR.P", 
        "body": "La fonction VAR.P est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et calculer la variance de la population totale. La syntaxe de la fonction VAR.P est : VAR.P(argument-list) où argument-list est une liste contenant jusqu'à 30 valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Les cellules vides, les valeurs logiques, le texte ou les valeurs d'erreur présentes dans n'importe lequel des tableaux sont ignorés. Si elles sont fournies directement à la fonction, les représentations textuelles des nombres et des valeurs logiques sont interprétées comme des nombres. Pour appliquer la fonction VAR.P, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction VAR.P, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/varpa.htm", 
        "title": "Fonction VARPA", 
        "body": "La fonction VARPA est l'une des fonctions statistiques. Elle est utilisée pour analyser une plage de données et renvoyer la variance de la population totale. La syntaxe de la fonction VARPA est : VARPA(argument-list) où number1(2) sont des valeurs numériques saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Remarque : les valeurs de texte et de FALSE (FAUX) sont comptées comme 0, les valeurs TRUE (VRAI) sont comptées comme 1, les cellules vides sont ignorées. Pour appliquer la fonction VARPA, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction VARPA, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/vdb.htm", 
        "title": "Fonction VDB", 
        "body": "La fonction VDB est l'une des fonctions financières. Elle est utilisée pour calculer la dépréciation d'un actif pour une période comptable spécifiée ou partielle en utilisant la méthode du solde dégressif variable. La syntaxe de la fonction VDB est : VDB(cost, salvage, life, start-period, end-period[, [[factor][, [no-switch-flag]]]]]) où cost est le coût de l'actif. salvage est la valeur de récupération de l'actif à la fin de sa durée de vie. life est le nombre total de périodes dans la durée de vie de l'actif. start-period est une période de départ pour laquelle vous souhaitez calculer l'amortissement. La valeur doit être exprimée dans les mêmes unités que life. end-period est une période d'arrivée pour laquelle vous souhaitez calculer l'amortissement. La valeur doit être exprimée dans les mêmes unités que life. factor est le taux auquel le solde diminue. C'est un argument facultatif. S'il est omis, la fonction suppose que factor est égal à 2. no-switch-flag est l'argument optionnel qui spécifie s'il faut utiliser l'amortissement linéaire lorsque l'amortissement est supérieur au calcul du solde dégressif. S'il est défini sur FALSE (FAUX) ou omis, la fonction utilise la méthode d'amortissement linéaire. S'il est défini sur TRUE (VRAI), la fonction utilise la méthode de l'amortissement dégressif. Remarque : toutes les valeurs numériques doivent être des nombres positifs. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction VDB, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction VDB, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/vlookup.htm", 
        "title": "Fonction RECHERCHEV", 
        "body": "La fonction RECHERCHEV est l'une des fonctions de recherche et de référence. Elle est utilisée pour effectuer la recherche verticale d'une valeur dans la première colonne à gauche d'un tableau et retourner la valeur qui se trouve dans la même ligne à la base d'un numéro d'index de colonne spécifié. La syntaxe de la fonction RECHERCHEV est : RECHERCHEV (lookup-value, table-array, col-index-num[, [range-lookup-flag]]) où lookup-value est une valeur à chercher. table-array ce sont deux ou plusieurs colonnes contenant des données triées dans l'ordre croissant. col-index-num est un numéro de colonne dans table-array, une valeur numérique supérieure ou égale à 1 mais inférieure au nombre de colonnes dans table-array. range-lookup-flag est une valeur logique TRUE (vrai) ou FALSE (faux). C'est un argument facultatif. Entrez FALSE (faux) pour trouver une correspondance exacte. Au cas où il n'y a pas de valeur qui correspond strictement à lookup-value, alors la fonction choisit la valeur plus grande et proche à lookup-value.Remarque : si range-lookup-flag est FALSE (faux), mais aucune correspondance n'est trouvée, alors la fonction renvoie l'erreur #N/A. Pour appliquer la fonction RECHERCHEV, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction RECHERCHEV, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/vstack.htm", 
        "title": "Fonction ASSEMB.V", 
        "body": "La fonction ASSEMB.V est l'une des fonctions de recherche et de référence. Cette fonction retourne un tableau assemblant verticalement plusieurs tableaux. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction ASSEMB.V: ASSEMB.V(matrice1,[matrice2],...) où: matrice sert à définir les matrices à ajouter. Pour appliquer la fonction ASSEMB.V, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction ASSEMB.V, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/weekday.htm", 
        "title": "Fonction JOURSEM", 
        "body": "La fonction JOURSEM est l'une des fonctions de date et d'heure. Elle est utilisée pour déterminer le jour de la semaine de la date spécifiée. La syntaxe de la fonction JOURSEM est : JOURSEM(serial-value [,weekday-start-flag]) où serial-value est un nombre représentant la date dont le jour vous voulez trouver, saisi en utilisant la fonction Date ou une autre fonction de date et d'heure. weekday-start-flag est une valeur numérique utilisée pour déterminer le type de la valeur à renvoyer : Il peut être l'un des éléments suivants : Valeur numérique Explication 1 ou omise Renvoie un nombre de 1 (Dimanche) à 7 (Samedi) 2 Renvoie un nombre de 1 (Lundi) à 7 (Dimanche). 3 Renvoie un nombre de 0 (Lundi) à 6 (Dimanche). sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction JOURSEM, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/weeknum.htm", 
        "title": "Fonction NO.SEMAINE", 
        "body": "La fonction NO.SEMAINE est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer le numéro de la semaine de l'année au cours de laquelle la date déterminée tombe. La syntaxe de la fonction NO.SEMAINE est : NO.SEMAINE(serial-value [,weekday-start-flag]) où serial-value est un nombre représentant la date au cours d'une semaine, saisi en utilisant la fonction Date ou une autre fonction de date et d'heure. weekday-start-flag est une valeur numérique utilisée pour déterminer le type de la valeur à renvoyer : Il peut être l'un des éléments suivants : Valeur numérique Séquence des jours de la semaine 1 ou omise du dimanche au samedi 2 du lundi au dimanche Pour appliquer la fonction NO.SEMAINE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône sutuée sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction NO.SEMAINE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/weibull-dist.htm", 
        "title": "Fonction LOI.WEIBULL.N", 
        "body": "La fonction LOI.WEIBULL.N est l'une des fonctions statistiques. Elle est utilisée pour retourner la distribution de Weibull. Utilisez cette distribution dans une analyse de fiabilité, telle que le calcul du délai moyen de défaillance d'un appareil. La syntaxe de la fonction LOI.WEIBULL.N est : LOI.WEIBULL.N(x, alpha, beta, cumulative) où x est la valeur intérieure pour laquelle la fonction doit être calculée, une valeur numérique supérieure ou égale à 0. alpha est le premier paramètre de la distribution, une valeur numérique supérieure à 0. beta est le second paramètre de la distribution, une valeur numérique supérieure à 0. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de densité de probabilité. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.WEIBULL.N, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.WEIBULL.N, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/weibull.htm", 
        "title": "Fonction LOI.WEIBULL", 
        "body": "La fonction LOI.WEIBULL est l'une des fonctions statistiques. Elle est utilisée pour retourner la distribution de Weibull. Utilisez cette distribution dans une analyse de fiabilité, telle que le calcul du délai moyen de défaillance d'un appareil. La syntaxe de la fonction LOI.WEIBULL est : LOI.WEIBULL(x, alpha, beta, cumulative) où x est la valeur intérieure pour laquelle la fonction doit être calculée, une valeur numérique supérieure ou égale à 0. alpha est le premier paramètre de la distribution, une valeur numérique supérieure à 0. beta est le second paramètre de la distribution, une valeur numérique supérieure à 0. cumulative est la forme de la fonction. C'est une valeur logique : TRUE (VRAI) ou FALSE (FAUX). Si elle est TRUE (VRAI), la fonction renvoie la fonction de distribution cumulative. Si elle est FALSE (FAUX), la fonction renvoie la fonction de densité de probabilité. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction LOI.WEIBULL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction LOI.WEIBULL, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/workday-intl.htm", 
        "title": "Fonction SERIE.JOUR.OUVRE.INTL", 
        "body": "La fonction SERIE.JOUR.OUVRE.INTL est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer la date avant ou après un nombre spécifié de jours de travail avec des paramètres de week-end personnalisés. Les paramètres de week-ends indiquent combien de jours et lesquels sont comptés dans le week-end. La syntaxe de la fonction SERIE.JOUR.OUVRE.INTL est : SERIE.JOUR.OUVRE.INTL(start_date, days, [, weekend], [, holidays]) où start_date est un nombre représentant la première date de la période, saisi en utilisant la fonction Date ou une autre fonction de date et d'heure. days est un nombre de jours de travail avant ou après start_date. Si days porte le signe négatif, la fonction renvoie la date correspondante avant la start_date spécifiée. Si days porte le signe positif, la fonction renvoie la date correspondante qui vient après la start-date spécifiée. weekend est un argument facultatif, un nombre qui spécifie les jours à prendre en compte comme les week-ends. Les numéros possibles sont listés dans le tableau ci-dessous. Nombre Jours de week-end 1 ou omise Samedi, Dimanche 2 Dimanche, Lundi 3 Lundi, Mardi 4 Mardi, Mercredi 5 Mercredi, Jeudi 6 Jeudi, vendredi 7 Vendredi, Samedi 11 Dimanche seulement 12 Lundi seulement 13 Mardi seulement 14 Mercredi seulement 15 Jeudi seulement 16 Vendredi seulement 17 Samedi seulement Une chaîne qui spécifie les week-ends doit contenir 7 caractères. Chaque caractère représente un jour de la semaine, à partir du lundi. 0 représente une journée de travail, 1 représente un jour de week-end. Par exemple. \"0000011\" spécifie que les jours de week-end sont samedi et dimanche. La chaîne \"1111111\" n'est pas valide. holidays est un argument facultatif qui définit quelles dates en plus du weekend ne sont pas ouvrables. Les valeurs peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction SERIE.JOUR.OUVRE.INTL, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure, cliquez sur la fonction SERIE.JOUR.OUVRE.INTL, insérez des arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/workday.htm", 
        "title": "Fonction SERIE.JOUR.OUVRE", 
        "body": "La fonction SERIE.JOUR.OUVRE est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer la date qui vient le nombre de jours indiqué (day-offset) avant ou après la date déterminée à l'exclusion des week-ends et des dates considérées comme jours fériés. La syntaxe de la fonction SERIE.JOUR.OUVRE est : SERIE.JOUR.OUVRE(start-day, day-offset [,holidays]) où start-day est un nombre représentant la première date de la période, saisi en utilisant la fonction Date ou une autre fonction de date et d'heure. day-offset est un nombre de jours sans week-ends avant ou après start-day. Si day-offset a le signe négatif, la fonction renvoie le nombre de série de la date qui va avant la start-date spécifiée. Si day-offset a le signe positif, la fonction renvoie le nombre de série de la date qui vient après la start-date spécifiée. holidays est un argument facultatif qui définit quelles dates exceptés les weekends sont des jours fériés. Les valeurs peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction SERIE.JOUR.OUVRE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure, cliquez sur la fonction SERIE.JOUR.OUVRE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/wrapcols.htm", 
        "title": "Fonction ORGA.COLS", 
        "body": "La fonction ORGA.COLS est l'une des fonctions de recherche et de référence. Cette fonction enveloppe un vecteur ligne ou colonne après un nombre spécifié de valeurs. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction ORGA.COLS: ORGA.COLS(vecteur, orga_no, [compléter_avec]) où: vecteur sert à définir le vecteur ou la référence à envelopper. orga_no sert à définir le nombre maximal de valeurs pour chaque colonne. compléter_avec définit la valeur à compléter le résultat. La valeur par défaut est #N/A. Pour appliquer la fonction ORGA.COLS, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction ORGA.COLS, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/wraprows.htm", 
        "title": "Fonction ORGA.LIGNES", 
        "body": "La fonction ORGA.LIGNES est l'une des fonctions de recherche et de référence. Cette fonction enveloppe un vecteur ligne ou colonne après un nombre spécifié de valeurs. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction ORGA.LIGNES: ORGA.LIGNES(vecteur, orga_no, [compléter_avec]) où: vecteur sert à définir le vecteur ou la référence à envelopper. orga_no sert à définir le nombre maximal de valeurs pour chaque ligne. compléter_avec définit la valeur à compléter le résultat. La valeur par défaut est #N/A. Pour appliquer la fonction ORGA.LIGNES, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction ORGA.LIGNES, insérez les arguments nécessaires en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/xirr.htm", 
        "title": "Fonction TRI.PAIEMENTS", 
        "body": "La fonction TRI.PAIEMENTS est l'une des fonctions financières. Elle est utilisée pour calculer le taux de rendement interne d'une série de flux de trésorerie irréguliers. La syntaxe de la fonction TRI.PAIEMENTS est : TRI.PAIEMENTS(values, dates [,[guess]]) où values est un tableau qui contient la série de paiements qui se produisent de manière irrégulière. Au moins une des valeurs doit être négative et au moins une positive. dates est un tableau qui contient les dates de paiement lorsque les paiements sont effectués ou reçus. Les dates doivent être saisies à l'aide de la fonction DATE. guess est une estimation du taux de rendement interne. C'est un argument facultatif. En cas d'omission, guess est estimé à 10%. Les valeurs numériques peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TRI.PAIEMENTS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction TRI.PAIEMENTS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/xlookup.htm", 
        "title": "Fonction XLOOKUP", 
        "body": "La fonction XLOOKUP (RECHERCHEX) est l'une des fonctions de recherche et de référence. Elle est utilisée pour rechercher des éléments par ligne verticalement et horizontalement. Cette fonction permet de renvoyer un résultat dans une autre colonne et de prendre en charge des feuilles de calcul à deux dimensions. Le syntaxe de la fonction XLOOKUP: XLOOKUP (lookup_value, lookup_array, return_array, [if_not_found], [match_mode], [search_mode]) où: valeur_cherchée est une valeur à chercher. lookup_array est matrice ou plage à rechercher. return_array est matrice ou plage à renvoyer. if_not_found est un argument facultatif. Lorsqu'aucune résultat n'est trouvée, cet argument renvoie le texte [if_not_found] que vous définissez. Si le texte est manquant, la #N/A est renvoyée. match_mode est un argument facultatif. Les valeurs disponibles: 0 (par défaut) renvoie une correspondance exacte, si aucune n'a été trouvée la #N/A est renvoyée. -1 renvoie une correspondance exacte, si aucune information n'a été trouvée, l'élément le plus petit suivant est renvoyé. 1 renvoie une correspondance exacte, si aucune information n'a été trouvée, l'élément plus grand suivant est renvoyé. 2 est une correspondance avec caractère générique. search_mode est un argument facultatif. Les valeurs disponibles: 1 la recherche est effectuée à partir du premier élément (valeurnpar défaut). -1 une recherche inverse est effectuée, c-à-d à partir du dernier élément. 2 une recherche binaire est effectuée quand lookup_array est triée dans l'ordre croissant. S'il n'est pas trié, des résultats non valides seront renvoyés. -2 une recherche binaire est effectuée quand lookup_array est triée dans l'ordre décroissant. S'il n'est pas trié, des résultats non valides seront renvoyés. Des caractères génériques sont (?) le point d'interrogation pour rechercher un seul caractère et (*) l'astérisque pour rechercher plusieurs caractères. Quand vous recherchez le point d'interrogation ou l'astérisque, saisissez un tilde (~) avant le caractère. Pour appliquer la fonction XLOOKUP, sélectionnez la cellule où vous voulez afficher le résultat, appuyez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction XLOOKUP, saisissez les arguments requis dans la fenêtre Argument de formule, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/xmatch.htm", 
        "title": "Fonction EQUIVX", 
        "body": "Fonction EQUIVX est l'une des fonctions de recherche et de référence. Cette fonction permet de renvoyer la position relative de l'élément dans un tableau. Par défaut, cette fonction nécessite une correspondance exacte. Veillez noter que c'est une formule de tableau. Pour en savoir plus, veuillez consulter le guide Insérer des formules de tableau. Le syntaxe de la fonction EQUIVX: =EQUIVX(valeur_recherche, tableau_recherche, [mode_correspondance], [mode_recherche]) où: valeur_recherche est la valeur à rechercher. tableau_recherche est la matrice ou la plage à rechercher. mode_correspondance est un argument facultatif. Les valeurs disponibles: 0 (par défaut) renvoie une correspondance exacte, si aucune n'a été trouvée la #N/A est renvoyée. -1 renvoie une correspondance exacte, si aucune information n'a été trouvée, l'élément le plus petit suivant est renvoyé. 1 renvoie une correspondance exacte, si aucune information n'a été trouvée, l'élément plus grand suivant est renvoyé. 2 est une correspondance avec caractère générique. mode_recherche est un argument facultatif. Les valeurs disponibles: 1 la recherche est effectuée à partir du premier élément (valeurnpar défaut). -1 une recherche inverse est effectuée, c-à-d à partir du dernier élément. 2 une recherche binaire est effectuée quand le tableau_recherche est triée dans l'ordre croissant. S'il n'est pas trié, des résultats non valides seront renvoyés. -2 une recherche binaire est effectuée quand le tableau_recherche est triée dans l'ordre décroissant. S'il n'est pas trié, des résultats non valides seront renvoyés. Des caractères génériques sont (?) le point d'interrogation pour rechercher un seul caractère et (*) l'astérisque pour rechercher plusieurs caractères. Quand vous recherchez le point d'interrogation ou l'astérisque, saisissez un tilde (~) avant le caractère. Pour appliquer la fonction EQUIVX, sélectionnez la cellule où vous voulez afficher le résultat, cliquez sur l'icône Insérer une fonction de la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule et choisissez l'option Insérer une fonction dans le menu, ou cliquez sur l'icône de la barre de formule, sélectionnez le groupe de fonctions Recherche et référence depuis la liste, cliquez sur la fonction EQUIVX, saisissez les arguments requis dans la fenêtre Arguments de la fonction, appuyez sur la touche Entrée. Le résultat s'affiche dans la cellule choisie."
    },
   {
        "id": "Functions/xnpv.htm", 
        "title": "Fonction VAN.PAIEMENTS", 
        "body": "La fonction VAN.PAIEMENTS est l'une des fonctions financières. Elle est utilisée pour calculer la valeur actuelle d'un investissement à la base du taux d'intérêt spécifié et d'un échéancier de paiement irréguliers. La syntaxe de la fonction VAN.PAIEMENTS est : VAN.PAIEMENTS(rate, values, dates) où rate est le taux d'actualisation de l'investissement. values est un tableau qui contient les montants de revenu (valeurs positives) ou de paiement (valeurs négatives). Au moins une des valeurs doit être négative et au moins une positive. dates est un tableau qui contient les dates de paiement lorsque les paiements sont effectués ou reçus. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction VAN.PAIEMENTS, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction VAN.PAIEMENTS, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/xor.htm", 
        "title": "Fonction OUX", 
        "body": "La fonction OUX est l'une des fonctions logiques. Elle est utilisée pour retourner un OU exclusif logique de tous les arguments. La fonction renvoie TRUE lorsque le nombre d'entrées valant TRUE est impair et FALSE lorsque le nombre d'entrées valant TRUE est pair. La syntaxe de la fonction OUX est : OUX(logical1 [, logical2], ...) où logical1 est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction OUX, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Logiques depuis la liste, cliquez sur la fonction OUX, insérez les arguments requis en les séparant par des virgules,Remarque: vous pouvez insérer jusqu'à 254 valeurs logiques. appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée. Par exemple : Il y a deux arguments : logical1 = 1&gt;0, logical2 = 2&gt;0. Le nombre d'entrées TRUE est pair, la fonction retourne donc FALSE. Il y a deux arguments : logical1 = 1&gt;0, logical2 = 2&lt;0. Le nombre d'entrées TRUE est impair, la fonction retourne donc TRUE."
    },
   {
        "id": "Functions/year.htm", 
        "title": "Fonction ANNEE", 
        "body": "La fonction ANNEE est l'une des fonctions de date et d'heure. Elle renvoie l'année (nombre de 1900 à 9999) du date au format numérique (jj/MM/aaaa par défault). La syntaxe de la fonction ANNEE est : ANNEE(date-value) où date-value est une valeur saisie à la main ou incluse dans la cellule à laquelle il est fait référence. Pour appliquer la fonction ANNEE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction ANNEE, saisissez l'argument requis, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/yearfrac.htm", 
        "title": "Fonction FRACTION.ANNEE", 
        "body": "La fonction FRACTION.ANNEE est l'une des fonctions de date et d'heure. Elle est utilisée pour renvoyer la fraction d'une année représentée par le nombre de jours complets à partir de la start-date jusqu'à l'end-date calculé à la base spécifiée. La syntaxe de la fonction FRACTION.ANNEE est : FRACTION.ANNEE(start-date, end-date [,basis]) où start-date est un nombre représentant la première date de la période, saisi en utilisant la fonction Date ou une autre fonction de date et d'heure. end-date est un nombre représentant la dernière date de la période, saisi en utilisant la fonction Date ou une autre fonction de date et d'heure. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : si start-date, end-date ou basis est une valeur décimale, la fonctions ignore les chiffres à droite de la virgule décimale. Pour appliquer la fonction FRACTION.ANNEE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Date et heure depuis la liste, cliquez sur la fonction FRACTION.ANNEE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/yield.htm", 
        "title": "Fonction RENDEMENT.TITRE", 
        "body": "La fonction RENDEMENT.TITRE est l'une des fonctions financières. Elle est utilisée pour calculer le rendement d'un titre qui paie des intérêts périodiques. La syntaxe de la fonction RENDEMENT.TITRE est : RENDEMENT.TITRE(settlement, maturity, rate, pr, redemption, frequency[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. rate est le taux de coupon annuel du titre. pr correspond au prix d'achat du titre, par tranche de 100$ de valeur nominale. redemption correspond à la valeur de rachat du titre, par tranche de 100$ de valeur nominale. frequency est le nombre de paiements d'intérêts par année. Les valeurs possibles sont : 1 pour les paiements annuels, 2 pour les paiements semestriels, 4 pour les paiements trimestriels. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction RENDEMENT.TITRE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction RENDEMENT.TITRE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/yielddisc.htm", 
        "title": "Fonction RENDEMENT.SIMPLE", 
        "body": "La fonction RENDEMENT.SIMPLE est l'une des fonctions financières. Elle est utilisée pour calculer le rendement annuel d'un titre à prix réduit. La syntaxe de la fonction RENDEMENT.SIMPLE est : RENDEMENT.SIMPLE(settlement, maturity, pr, redemption,[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. pr correspond au prix d'achat du titre, par tranche de 100$ de valeur nominale. redemption correspond à la valeur de rachat du titre, par tranche de 100$ de valeur nominale. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction RENDEMENT.SIMPLE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction RENDEMENT.SIMPLE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/yieldmat.htm", 
        "title": "Fonction RENDEMENT.TITRE.ECHEANCE", 
        "body": "La fonction RENDEMENT.TITRE.ECHEANCE est l'une des fonctions financières. Elle est utilisée pour calculer le rendement annuel d'un titre qui paie des intérêts à l'échéance. La syntaxe de la fonction RENDEMENT.TITRE.ECHEANCE est : RENDEMENT.TITRE.ECHEANCE(settlement, maturity, issue, rate, pr[, [basis]]) où settlement est la date à laquelle le titre est acheté. maturity est la date d'expiration du titre. issue est la date d'émission du titre. rate est le taux d'intérêt du titre à la date d'émission. pr correspond au prix d'achat du titre, par tranche de 100$ de valeur nominale. basis est la base de calcul utilisée, une valeur numérique supérieure ou égale à 0, main inférieure ou égale à 4 : C'est un argument facultatif. Il peut être l'un des éléments suivants : Valeur numérique Base de calcul 0 US (NASD) 30/360 1 Actuelle/actuelle 2 Actuelle/360 3 Actuelle/365 4 Européenne 30/360 Remarque : les dates doivent être saisies à l'aide de la fonction DATE. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction RENDEMENT.TITRE.ECHEANCE, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Financières depuis la liste, cliquez sur la fonction RENDEMENT.TITRE.ECHEANCE, insérez les arguments requis en les séparant par des virgules, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/z-test.htm", 
        "title": "Fonction Z.TEST", 
        "body": "La fonction Z.TEST est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la valeur de probabilité unilatérale d'un test z. Pour une moyenne de population hypothétique donnée, x, Z.TEST renvoie la probabilité que la moyenne de l'échantillon soit supérieure à la moyenne des observations dans l'ensemble de données(tableau), c'est-à-dire la moyenne de l'échantillon observé. La syntaxe de la fonction Z.TEST est : Z.TEST(array, x [, sigma]) où array est la plage de valeurs numériques à comparer à x. x est la valeur à tester. sigma est la déviation standard de la population. C'est un argument facultatif. En cas d'omission, l'écart-type de l'échantillon est utilisé. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction Z.TEST, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction Z.TEST, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "Functions/ztest.htm", 
        "title": "Fonction TEST.Z", 
        "body": "La fonction TEST.Z est l'une des fonctions statistiques. Elle est utilisée pour renvoyer la valeur de probabilité unilatérale d'un test z. Pour une moyenne de population hypothétique donnée, μ0, TEST.Z renvoie la probabilité que la moyenne de l'échantillon soit supérieure à la moyenne des observations dans l'ensemble de données(tableau), c'est-à-dire la moyenne de l'échantillon observé. La syntaxe de la fonction TEST.Z est : TEST.Z(array, x [, sigma]) où array est la plage de valeurs numériques à comparer à x. x est la valeur à tester. sigma est la déviation standard de la population. C'est un argument facultatif. En cas d'omission, l'écart-type de l'échantillon est utilisé. Les données peuvent être saisies à la main ou incluses dans les cellules auxquelles il est fait référence. Pour appliquer la fonction TEST.Z, sélectionnez la cellule où vous souhaitez afficher le résultat, cliquez sur l'icône Insérer une fonction située sur la barre d'outils supérieure, ou cliquez avec le bouton droit sur la cellule sélectionnée et sélectionnez l'option Insérer une fonction depuis le menu, ou cliquez sur l'icône située sur la barre de formule, sélectionnez le groupe de fonctions Statistique depuis la liste, cliquez sur la fonction TEST.Z, insérez les arguments nécessaires en les séparant par des virgules ou sélectionnez une plage de cellules avec la souris, appuyez sur la touche Entrée. Le résultat sera affiché dans la cellule sélectionnée."
    },
   {
        "id": "HelpfulHints/About.htm", 
        "title": "À propos de l'éditeur de classeurs", 
        "body": "L'éditeur de classeurs est une application en ligne qui vous permet de parcourir et de modifier des feuilles de calcul dans votre navigateur . En utilisant l'éditeur de classeurs, vous pouvez effectuer différentes opérations d'édition comme avec n'importe quel éditeur de bureau, imprimer les feuilles de calcul modifiées en gardant la mise en forme ou les télécharger sur votre disque dur au format XLSX, PDF, ODS, CSV, XLTX, PDF/A, OTS. Pour afficher la version actuelle du logiciel, le numéro de build et les informations de licence dans la version en ligne, cliquez sur l'icône À propos dans la barre latérale gauche. Pour afficher la version actuelle du logiciel et les informations de licence dans la version de bureau pour Windows, sélectionnez l'élément de menu À propos dans la barre latérale gauche de la fenêtre principale du programme. Dans la version de bureau pour Mac OS, accédez au menu ONLYOFFICE en haut de l'écran et sélectionnez l'élément de menu À propos d'ONLYOFFICE."
    },
   {
        "id": "HelpfulHints/AdvancedSettings.htm", 
        "title": "Paramètres avancés de l'éditeur de classeurs", 
        "body": "L'éditeur de classeurs vous permet de modifier ses paramètres avancés. Pour y accéder, ouvrez l'onglet Fichier de la barre d'outils supérieure et sélectionnez l'option Paramètres avancés. Les paramètres avancés sont groupés comme suit: Édition et enregistrement Enregistrement automatique est utilisé dans la version en ligne pour activer/désactiver l'enregistrement automatique des modifications que vous effectuez pendant l'édition. Récupération automatique - est utilisé dans la version de bureau pour activer/désactiver l'option qui permet de récupérer automatiquement les feuilles de calcul en cas de fermeture inattendue du programme. Afficher le bouton Options de collage lorsque le contenu est collé. L'icône correspondante sera affichée lorsque vous collez le contenu à la feuille de calcul. Afficher l'infobulle de la fonction - sert à activer les conseils lors de la saisie des fonctions. Collaboration La rubrique Mode de co-édition permet de sélectionner le mode d'affichage préférable des modifications effectuées lors de la collaboration sur la feuille de calcul. Rapide (par défaut). Les utilisateurs qui participent à la co-édition de la feuille de calcul verront les changements en temps réel une fois qu'ils sont faits par d'autres utilisateurs. Strict. Toutes les modifications apportées par d'autres co-auteurs ne seront affichées que lorsque vous cliquez sur l'icône Enregistrer pour vous informer de nouvelles modifications. Afficher les modifications apportées par d'autres utilisateurs. Cette option permet d'afficher les modifications apportées par d'autres utilisateurs dans une feuille de calcul disponible en lecture seule en mode Lecture seule en direct uniquement. Afficher les commentaires dans la feuille. Une fois cette option désactivée, les fragments commentés seront mis en surbrillance uniquement lorsque vous cliquez sur l'icône Commentaires. sur la barre latérale gauche. Afficher les commentaires résolus. Cette fonction est désactivée par défaut pour que les commentaires résolus soient cachés dans la feuille de calcul. Vous ne pourrez voir ces commentaires que si vous cliquez sur l'icône Commentaires sur la barre latérale gauche. Activez cette option si vous voulez afficher les commentaires résolus dans le texte du classeur. Apparence Thème d'interface permet de modifier les jeux de couleurs de l'interface d'éditeur. L'option Identique à système permet d'utiliser le thème système par l'éditeur. Le mode Claire comprend l'affichage des éléments de l'interface utilisateur en couleurs standards bleu, blanc et gris claire à contraste réduit et est destiné à un travail de jour. Le mode Claire classique comprend l'affichage en couleurs standards bleu, blanc et gris claire. Le mode Sombre comprend l'affichage en tons sombres noir, gris foncé et gris claire destinés à un travail de nuit. Le mode Contraste élevé sombre comprend l'affichage des éléments de l'interface utilisateur en couleurs noir, gris foncé et blanc à plus de contraste et est destiné à mettre en surbrillance la zone de travail du fichier. Le mode Gris comprend l'affichage en tons de gris plus claires et apparaît en couleurs uniformes claires. L'option Activer le mode sombre pour les documents rend l'espace de travail plus sombre lorsqu'on a définit le thème d'interface Sombre ou Contraste élevé sombre. Cochez la case Activer le mode sombre pour les documents pour activer cette option. Remarque: Outre les thèmes d'interface Claire, Classique claire, Sombre, Contraste élevé sombre et Gris il est possible de personnaliser le thème de vos éditeurs ONLYOFFICE. Pour en savoir plus, veuillez suivre ces instructions. Style d'onglet - sélectionnez l'option Remplissage pour rendre la couleur de remplissage de l'onglet actuel plus claire ou l'option Ligne pour souligner l'onglet actuel. Utiliser la couleur de la barre d'outils comme arrière-plan des onglets - la couleur de la barre d'outils sera la couleur d'arrière plan des onglets. La couleur de la barre d'outils dépend du thème d'interface actuel. Espace de travail L'option Activer la prise en charge du lecteur d'écran sert à activer la prise en charge du logiciel lecteur d'écran. L'option Style de référence R1C1 est désactivée et le style de référence A1 est utilisé. Lorsque le style de référence A1 est utilisé, les colonnes sont désignées par des lettres et les lignes par des chiffres. Si vous sélectionnez la cellule située dans la rangée 3 et la colonne 2, son adresse affichée dans la case à gauche de la barre de formule ressemble à ceci: B3. Si le style de référence R1C1 est activé, les lignes et les colonnes sont désignées par des numéros. Si vous sélectionnez la cellule à l'intersection de la ligne 3 et de la colonne 2, son adresse ressemblera à ceci: R3C2. La lettre R indique le numéro de ligne et la lettre C le numéro de colonne. Si vous vous référez à d'autres cellules en utilisant le style de référence R1C1, la référence à une cellule cible est formée en fonction de la distance à partir de la cellule active. Par exemple, lorsque vous sélectionnez la cellule de la ligne 5 et de la colonne 1 et faites référence à la cellule de la ligne 3 et de la colonne 2, la référence est R[-2]C[1]. Les chiffres entre crochets désignent la position de la cellule à laquelle vous vous référez par rapport à la position actuelle de la cellule, c'est-à-dire que la cellule cible est à 2 lignes plus haut et 1 colonne à droite de la cellule active. Si vous sélectionnez la cellule de la ligne 1 et de la colonne 2 et que vous vous référez à la même cellule de la ligne 3 et de la colonne 2, la référence est R[2]C, c'est-à-dire que la cellule cible est à 2 lignes en dessous de la cellule active et dans la même colonne. L'option Utiliser la touche Alt pour naviguer dans l'interface utilisateur à l'aide du clavier sert à activer l'utilisation de la touche Alt / Option dans raccourcis clavier. Afficher le bouton d'impression rapide dans l'en-tête de l'éditeur dans la version de bureau sert à activer l'impression rapide à l'aide du bouton approprié de la barre d'outils supérieure. Le fichier sera imprimé sur la dernière imprimante sélectionnée ou sur l'imprimante sélectionnée par défaut. L'option Interface RTL (Bêta) sert à modifier le sens d'écriture des éléments de l'interface. Cette option n'est disponible que pour l'environnement de droite à gauche. Accroché à la grille lors du défilement sert à activer l'alignement de la grille pendant le défilement. L'option Personnaliser l'accès rapide sert à choisir les boutons à afficher dans la barre d'outils, tels que Enregistrer, Imprimer, Annuler et Répéter. L'option Unité de mesure sert à spécifier les unités de mesure utilisées sur les règles et dans les fenêtres de paramètres pour les paramètres tels que largeur, hauteur, espacement, marges etc. Vous pouvez choisir l'option Centimètre, Point ou Pouce. L'option Valeur de zoom par défaut sert à définir la valeur de zoom par défaut en la sélectionnant de la liste des options disponibles entre 50% et 500%. Vous pouvez également choisir l'option Ajuster à la page, Ajuster à la largeur ou Récemment utilisés. L'option Récemment utilisé se réfère à la dernière mise à l'échelle au cours de la session actuelle. L'option Hinting de la police sert à sélectionner le type d'affichage de la police dans l'éditeur de classeurs. Choisissez Comme Windows si vous aimez la façon dont les polices sont habituellement affichées sous Windows, c'est à dire en utilisant la police de Windows. Choisissez Comme OS X si vous aimez la façon dont les polices sont habituellement affichées sous Mac, c'est à dire sans hinting. Choisissez Natif si vous voulez que votre texte sera affiché avec les hintings intégrés dans les fichiers de polices. Mise en cache par défaut sert à sélectionner cache de police. Il n'est pas recommandé de désactiver ce mode-ci sans raison évidente. C'est peut être utile dans certains cas, par exemple les problèmes d'accélération matérielle activé sous Google Chrome. L'éditer de classeurs gère deux modes de mise en cache: Dans le premier mode de mise en cache, chaque lettre est mis en cache comme une image indépendante. Dans le deuxième mode de mise en cache, l'image d'une certaine taille est sélectionnée avec les lettres dynamiques et avec de l'allocation/libération de la mémoire mis en place. La deuxième image est créée s'il y a de mémoire suffisante etc. Le Mode de mise en cache par défaut est activé pour chaque mode ci-dessus en fonction du navigateur utilisé: Avec la mise en cache par défaut activée, dans Internet Explorer (v. 9, 10, 11) le deuxième mode de mise en cache est utilisé, le premier mode de mise en cache est utilisé dans les autres navigateurs. Avec la mise en cache par défaut désactivée, dans Internet Explorer (v. 9, 10, 11) le premier mode de mise en cache est utilisé, le deuxième mode de mise en cache est utilisé dans les autres navigateurs. L'option Réglages macros sert à désactiver toutes les macros avec notification. Choisissez Désactiver tout pour désactiver toutes les macros dans votre feuille de calcul. Choisissez Montrer la notification pour afficher les notifications lorsque des macros sont présentes dans une feuille de calcul. Choisissez Activer tout pour exécuter automatiquement toutes les macros dans votre feuille de calcul. Paramètres régionaux L'option Langage de formule est utilisée pour sélectionner la langue d'affichage et de saisie des noms de formules, des noms et des descriptions d'arguments. Les formules sont pris en charge dans 33 langues: Aarménien, biélorusse, bulgare, catalan, chinois, tchèque, danois, néerlandais, anglais, finnois, français , allemand, grec, hongrois, indonésien, italien, japonais, coréen, lao, letton, norvégien, polonais, portugais (Brésil), portugais (Portugal), roumain, russe, slovaque, slovène, espagnol, suédois, turc, ukrainien, vietnamien. L'option Région permet de sélectionner le format d'affichage par défaut pour la devise, la date et l'heure. Régions disponibles: azerbaïdjan, bulgare, tchèque, danois, allemand (Autriche), allemand (Allemagne), allemand (Suisse), grec (Grèce), anglais (Australie), anglais (Indonésie), anglais (Royaume-Uni), anglais (USA), espagnol (Espagne), espagnol (Mexique), finnois (Finlande), français (France), français (Suisse), indonésien (Indonésie), italien (Italie), italien (Suisse), japonais, coréen, letton, hongrois, néerlandais (Pays-Bas), polonais (Pologne), portugais (Brésil), portugais (Portugal), slovaque, slovène, suédois (Finlande), suédois (Suède), turc, ukrainien, vietnamien, chinois, taïwanais. L'option Utiliser des séparateurs basés sur les paramètres régionaux est activée par défaut, les séparateurs correspondront à la région définie. Afin de définir les séparateurs personnalisés, désactivez cette option et saisissez les séparateurs requis dans les champs Séparateur décimal et Séparateur de milliers. Vérification L'option Langue du dictionnaire est utilisée afin de sélectionner le dictionnaire préféré pour la vérification de l'orthographe. Ignorer les mots en MAJUSCULES. Les mots tapés en majuscules sont ignorés lors de la vérification de l'orthographe. Ignorer les mots contenant des chiffres. Les mots contenant des chiffres sont ignorés lors de la vérification de l'orthographe. Le menu Options de correction automatique permet d'accéder aux paramètres de correction automatique tels que remplacement au cours de la frappe, fonctions de reconnaissance, mise en forme automatique etc. Calcul L'option Utiliser le calendrier depuis 1904 permet de calculer les dates à partir du 1er janvier 1904 comme point de départ. Elle peut être utile lorsque vous travaillez avec des feuilles de calcul créées dans la version MS Excel 2008 pour Mac ou des versions antérieures de MS Excel pour Mac. L'option Activer le calcul itératif sert à activer le calcul itératif. L'option Nombre maximal d'itérations sert à définir le nombre maximal de fois où la référence circulaire recalcule la formule de référence circulaire jusqu'à ce que ce cycle s'arrête. L'option Variation maximale sert à définir la précision des calculs itératifs. Une fois terminé, sauvegardez les modifications apportées."
    },
   {
        "id": "HelpfulHints/CollaborativeEditing.htm", 
        "title": " Collaborer sur des feuilles de calcul en temps réel", 
        "body": "Collaborer sur des feuilles de calcul en temps réel L'éditeur de classeurs permet de gérer le flux de travail continu par l'ensemble de l'équipe : partager des fichiers et des dossiers, communiquer directement depuis l'éditeur, laisser des commentaires pour des fragments de la feuille de calcul nécessitant la participation d'une tierce personne, sauvegarder des versions de la feuille de calcul pour une utilisation ultérieure. Dans l'éditeur de classeurs il y a deux modes de collaborer sur des feuilles de calcul en temps réel : Rapide et Strict. Vous pouvez basculer entre les modes depuis la section Paramètres avancés. Il est également possible de choisir le mode voulu à l'aide de l'icône Mode de coédition dans l'onglet Collaboration de la barre d'outils supérieure : Le nombre d'utilisateurs qui travaillent sur la feuille de calcul actuelle est spécifié sur le côté droit de l'en-tête de l'éditeur - . Pour afficher les personnes qui travaillent sur le fichier, cliquez sur cette icône pour ouvrir le panneau Chat avec la liste complète affichée. Mode Rapide Le mode Rapide est utilisé par défaut et affiche les modifications effectuées par d'autres utilisateurs en temps réel. Lorsque vous co-éditez une feuille de calcul en mode Rapide, la possibilité de Rétablir la dernière opération annulée n'est pas disponible. Ce mode affichera les actions et les noms des co-auteurs tandis qu'ils modifient les données des cellules. Les bordures des cellules s'affichent en différentes couleurs pour mettre en surbrillance des plages de cellules sélectionnées par un autre utilisateur à ce moment. Faites glisser le pointeur de la souris sur la plage sélectionnée pour afficher le nom de l'utilisateur qui fait la sélection. Mode Strict Le mode Strict est sélectionné pour masquer les modifications d'autres utilisateurs jusqu'à ce que vous cliquiez sur l'icône Enregistrer pour enregistrer vos propres modifications et accepter les modifications apportées par d'autres utilisateurs. Lorsqu'une feuille de calcul est en cours de modification par plusieurs utilisateurs simultanément dans le mode Strict, les cellules modifiées sont marqués avec des lignes pointillées de couleurs différentes, l'onglet de la feuille de calcul où se situent ces cellules est marqué de rouge. Faites glisser le curseur sur l'une des cellules modifiées, pour afficher le nom de l'utilisateur qui est en train de l'éditer à ce moment. Lorsque l'un des utilisateurs enregistre ses modifications en cliquant sur l'icône , les autres verront une note dans le coin supérieure gauche indiquant qu'il y a des mises à jour. Pour enregistrer les modifications apportées et récupérer les mises à jour de vos co-auteurs cliquez sur l'icône dans le coin supérieur gauche de la barre supérieure. Utilisateurs anonymes Les utilisateurs du portail qui ne sont pas enregistrés et n'ont pas du profil sont les utilisateurs anonymes qui quand même peuvent collaborer sur des documents. Pour affecter le nom à un utilisateur anonyme, ce dernier doit saisir le nom préféré dans le coin supérieur droit de l'écran lorsque l'on accède au document pour la première fois. Activez l'option \"Ne plus poser cette question\" pour enregistrer ce nom-ci."
    },
   {
        "id": "HelpfulHints/Commenting.htm", 
        "title": "Commentaires", 
        "body": "L'éditeur de classeurs permet de gérer le flux de travail continu par l'ensemble de l'équipe: partager des fichiers et dossiers, collaborer sur classeurs en temps réel, communiquer directement depuis l'éditeur, sauvegarder des versions du classeur pour une utilisation ultérieure. Dans l'éditeur de classeurs vous pouvez laisser les commentaires pour le contenue de classeurs sans le modifier. Contrairement au messages de chat, les commentaires sont stockés jusqu'à ce que vous décidiez de les supprimer. Laisser et répondre aux commentaires Pour laisser un commentaire: sélectionnez la cellule où vous pensez qu'il y a une erreur ou un problème, passez à l'onglet Insertion ou Collaboration sur la barre d'outils supérieure et cliquer sur le bouton Commentaires ou utilisez l'icône dans la barre latérale gauche pour ouvrir le panneau Commentaires et cliquez sur le bouton Ajouter un commentaire dans la barre d'outils du panneau ou cliquez sur le symbole Autres et sélectionnez Ajouter un commentaire au document pour laisser un commentaire au classeur en entier ou cliquez avec le bouton droit sur la cellule nécessaire et sélectionnez l'option Ajouter un commentaire dans le menu contextuel, saisissez le texte nécessaire, cliquez sur le bouton Ajouter commentaire/Ajouter. Si vous utilisez le mode de co-édition Strict, les nouveaux commentaires ajoutés par d'autres utilisateurs ne seront visibles qu'après un clic sur l'icône dans le coin supérieur gauche de la barre supérieure. Pour afficher le commentaire, cliquez sur la cellule. Tout utilisateur peut répondre au commentaire ajouté en posant une question ou en faisant référence au travail qu'il/elle a fait. Pour ce faire, utilisez le lien Ajouter une réponse, saisissez le texte de votre réponse dans le champ de saisie et appuyez sur le bouton Répondre. Désactiver l'affichage des commentaires Le commentaire sera affiché sur le panneau à gauche. Le triangle orange apparaîtra dans le coin supérieur droit de la cellule que vous avez commentée. Si vous souhaitez désactiver cette fonctionnalité, cliquez sur l'onglet Fichier de la barre d'outils supérieure, sélectionnez l'option Paramètres avancés..., décochez la case Activer l'affichage de commentaires. Dans ce cas, les cellules commentées ne seront marquées que si vous cliquez sur l'icône Commentaires . Gérer les commentaires Vous pouvez gérer les commentaires ajoutés en utilisant les icônes de la bulle de commentaire ou sur le panneau gauche Commentaires: trier les commentaires ajoutés en cliquant sur l'icône: par date: Plus récent ou Plus ancien. par auteur: Auteur de A à Z ou Auteur de Z à Z Filtrer par groupe: Tout ou sélectionnez un groupe dans la liste. Cette option de trie n'est disponible que si votre version prend en charge cette fonctionnalité. modifier le commentaire actuel en cliquant sur l'icône, supprimer le commentaire actuel en cliquant sur l'icône, fermer la discussion actuelle en cliquant sur l'icône si la tâche ou le problème décrit dans votre commentaire est résolu, après quoi la discussion ouverte par votre commentaire reçoit le statut résolu. Pour l'ouvrir à nouveau, cliquez sur l'icône . l'icône. Si vous souhaitez masquer les commentaires résolus, cliquez sur l'onglet Fichier dans la barre d'outils supérieure, sélectionnez l'option Paramètres avancés..., décochez la case Activer l'affichage des commentaires résolus puis cliquez sur Appliquer. Dans ce cas, les commentaires résolus ne seront mis en évidence que si vous cliquez sur l'icône, si vous souhaitez gérer plusieurs commentaires à la fois, ouvrez le menu contextuel Résoudre sous l'onglet Collaboration. Sélectionnez l'une des options disponibles: résoudre les commentaires actuels, marquer mes commentaires comme résolus ou marquer tous les commentaires comme résolus dans le classeur. Ajouter les mentions Ce n'est qu'au contenu d'un classeur que vous pouvez ajouter des mentions et pas au classeur lui-même. Lorsque vous ajoutez un commentaire sur lequel vous voulez attirer l'attention d'une personne, vous pouvez utiliser la fonction de mentions et envoyer une notification par courrier électronique ou Talk. Pour ajouter une mention, Saisissez \"+\" ou \"@\" n'importe où dans votre commentaire, alors la liste de tous les utilisateurs du portail s'affichera. Pour faire la recherche plus rapide, tapez le prénom approprié dans le champ de saisie, la liste propose les suggestions au cours de la frappe. Puis sélectionnez le nom souhaité dans la liste. Si la personne mentionnée n'a pas l'autorisation d'ouvrir ce fichier, la fenêtre Paramètres de partage va apparaître. Par défaut, un document est partagé en Lecture seule. Modifiez la permission, le cas échéant.. Cliquez sur OK. La personne mentionnée recevra une notification par courrier électronique informant que son nom est mentionné dans un commentaire. La personne recevra encore une notification lorsque un fichier commenté est partagé. Supprimer des commentaires Pour supprimer les commentaires, cliquez sur le bouton Supprimer sous l'onglet Collaboration dans la barre d'outils supérieure, sélectionnez l'option convenable du menu: Supprimer les commentaires actuels à supprimer la sélection du moment. Toutes les réponses qui déjà ont été ajoutées seront supprimés aussi. Supprimer mes commentaires à supprimer vos commentaire et laisser les commentaires d'autres. Toutes les réponses qui déjà ont été ajoutées à vos commentaires seront supprimés aussi. Supprimer tous les commentaires sert à supprimer tous les commentaires du document. Pour fermer le panneau avec les commentaires, cliquez sur l'icône de la barre latérale de gauche encore une foi."
    },
   {
        "id": "HelpfulHints/Communicating.htm", 
        "title": "Communiquer en temps réel", 
        "body": "L'éditeur de classeurs permet de gérer le flux de travail continu par l'ensemble de l'équipe: partager des fichiers et des dossiers, collaborer sur classeurs en temps réel, laisser des commentaires pour des fragments du classeur nécessitant la participation d'une tierce personne, sauvegarder des versions du classeur pour une utilisation ultérieure. Dans l'éditeur de classeurs, il est possible de communiquer avec vos co-auteurs en temps réel en utilisant l'outil intégré Chat et les modules complémentaires utiles tels que Telegram ou Rainbow. Pour accéder au Chat et laisser un message pour les autres utilisateurs, cliquez sur l'icône dans la barre latérale gauche ou passez à l'onglet Collaboration de la barre d'outils supérieure et cliquez sur le bouton Chat, saisissez le texte dans le champ correspondant, cliquez sur le bouton Envoyer. Les messages de chat sont stockés uniquement pendant une session. Pour discuter le contenu du classeur, il est préférable d'utiliser les commentaires, car ils sont stockés jusqu'à ce que vous décidiez de les supprimer. Tous les messages envoyés par les utilisateurs seront affichés sur le panneau à gauche. S'il y a de nouveaux messages à lire, l'icône chat sera affichée de la manière suivante - . Pour fermer le panneau avec les messages, cliquez sur l'icône encore une fois."
    },
   {
        "id": "HelpfulHints/ImportData.htm", 
        "title": "Obtenir des données à partir de fichiers Texte/CSV", 
        "body": "Quand vous avez besoin d'obtenir rapidement des données à partir d'un fichier .txt/.csv file et l'organiser et positionner correctement dans une feuille de calcul, utilisez l'option Récupérer les données à partir d'un fichier texte/CSV file sous l'onglet Données. Étape 1. Importer du fichier Cliquez sur l'option Obtenir les données sous l'onglet Données. Choisissez l'une des options disponibles: À partir d'un fichier local TXT/CSV: recherchez le fichier nécessaire sur votre ordinateur, sélectionnez-le et cliquer sur Ouvrir. À partir de l'URL du fichier TXT/CSV: collez le lien vers le fichier ou un site web dans le champ Coller l'URL de données et cliquez sur OK. Dans ce cas on ne peut pas utiliser le lien pour afficher et modifier un fichier stocké sur le portail ONLYOFFICE ou sur un stockage de nuage externe. Veuillez utiliser le lien pour télécharger le fichier. À partir du XML local:</b> recherchez le fichier nécessaire sur votre ordinateur, sélectionnez-le et cliquer sur Ouvrir. Actuellement, c'est uniquement la feuille de calcul XML 2003 qui est pris en charge. Étape 2. Configurer les paramètres Assistant importation de texte comporte trois sections: Codage, Délimiteur, Aperçu et Sélectionnez où placer les données. Codage. Le codage par défaut est UTF-8. Laissez la valeur par défaut ou sélectionnez le codage approprié dans la liste déroulante. Délimiteur. Utilisez ce paramètre pour définir le type de séparateur pour distribuer du texte sur cellules. Les séparateurs disponibles: Virgule, Point-virgule, Deux-points, Tabulation, Espace et Autre (saisissez manuellement). Cliquez sur le bouton Avancé à droite pour paramétrer les données reconnues en tant que des données numériques: Définissez le Séparateur décimal et le Séparateur de milliers. Les séparateurs par défaut sont “.”; pour décimal et “,”; pour milliers. Sélectionnez le Qualificateur de texte. Un Qualificateur de texte est le caractère utilisé pour marquer le début et la fin du texte lors de l'importation de données. Les options disponibles sont les suivantes: (aucun), guillemets doubles et virgule. Aperçu. Cette section affiche comment le texte sera organisé en cellules. Sélectionnez où placer les données. Saisissez une plage de donnés appropriée ou choisissez le bouton Sélectionner des données à droite. Cliquez sur OK pour importer le fichier et quitter l'assistant importation de texte."
    },
   {
        "id": "HelpfulHints/KeyboardShortcuts.htm", 
        "title": "Raccourcis clavier", 
        "body": "Raccourcis clavier pour les touches d'accès Utilisez les raccourcis clavier pour faciliter et accélérer l'accès à l'éditeur de classeurs sans l'aide de la souris. Appuyez sur la touche Alt (Option pour macOS) pour activer toutes les touches d'accès pour l'en-tête, la barre d'outils supérieure, les barres latérales et la barre d'état. Appuyez sur la lettre qui correspond à l'élément dont vous avez besoin. D'autres suggestions de touches peuvent s'afficher en fonction de la touche que vous appuyez. Les premières suggestions de touches se cachent lorsque les suggestions supplémentaires s'affichent. Par exemple, pour accéder à l'onglet Insertion, appuyez sur Alt (Option pour macOS) pour afficher les primaires suggestions de touches d'accès. Appuyez sur la lettre I pour accéder à l'onglet Insertion et activer tous les raccourcis clavier disponibles sous cet onglet. Appuyez sur la lettre qui correspond à l'élément que vous allez paramétrer. Appuyez sur Alt (Option pour macOS) pour masquer toutes les suggestions de touches d'accès ou appuyez sur Échap pour revenir au groupe de suggestions de touches précédent. Consultez ci-dessous les raccourcis clavier les plus courants: Veuillez noter: sur macOS, certains raccourcis comprennent les touches Début, Fin, Pg. préc et Pg. suiv qui ne sont disponibles que sur le clavier étendu. S'il vous manque ces touches sur le clavier, utilisez les raccourcis ci-dessus (ç-à-d utilisez ^ Ctrl/⌘ Cmd+← ou Fn+← au lieu de Début, ^ Ctrl/⌘ Cmd+→ ou Fn+→ au lieu de Fin, Fn+↑ au lieu de Pg. préc, Fn+↓ au lieu de Pg. suiv). Windows/Linux Mac OS En travaillant sur le classeur Ouvrir le panneau 'Fichier' Alt+F ^ Ctrl+⌥ Option+F Ouvrir le panneau Fichier pour enregistrer, télécharger, imprimer le classeur actuel, voir ses informations, créer un nouveau classeur ou ouvrir un classeur existant, accéder à l'aide de l'éditeur de classeurs ou aux paramètres avancés. Ouvrir la boîte de dialogue Rechercher Ctrl+F ^ Ctrl+F, ⌘ Cmd+F Ouvrir la fenêtre Rechercher pour commencer à rechercher une cellule contenant les caractères nécessaires. Ouvrir le menu (panneau) Rechercher et remplacer avec le champ de remplacement Ctrl+H ^ Ctrl+H Ouvrir le menu (panneau) Rechercher et remplacer avec le champ de remplacement pour remplacer une ou plusieurs occurrences des caractères trouvés. Ouvrir le panneau 'Commentaires' Ctrl+⇧ Maj+H ^ Ctrl+⇧ Maj+H, ⌘ Cmd+⇧ Maj+H Ouvrir le panneau Commentaires pour ajouter votre commentaire ou pour répondre aux commentaires des autres utilisateurs. Ouvrir le champ de commentaires Alt+H ⌘ Cmd+⌥ Option+A Ouvrir un champ de saisie où vous pouvez ajouter le texte de votre commentaire. Ouvrir le panneau Chat (éditeurs en ligne) Alt+A ^ Ctrl+⌥ Option+A Ouvrir le panneau Chat dans l'éditeur en ligne et envoyer un message: Enregistrer le classeur Ctrl+S ^ Ctrl+S, ⌘ Cmd+S Enregistrer toutes les modifications dans le classeur en cours d'édition dans l'éditeur de classeurs. Le fichier actif sera enregistré avec son nom de fichier actuel, son emplacement et son format de fichier. Imprimer le classeur Ctrl+P ^ Ctrl+P, ⌘ Cmd+P Imprimer le classeur avec l'une des imprimantes disponibles ou l'enregistrer sous forme de fichier. Télécharger comme... Ctrl+⇧ Maj+S ^ Ctrl+⇧ Maj+S, ⌘ Cmd+⇧ Maj+S Ouvrir l'onglet Télécharger comme... pour enregistrer le classeur actuellement affiché sur le disque dur de l'ordinateur dans l'un des formats pris en charge: XLSX, XLTX, PDF, PDF/A, ODS, OTS, CSV, PNG, JPG. Plein écran (éditeurs en ligne) F11 Passer à l'affichage en plein écran dans les éditeurs en ligne pour adapter l'éditeur de classeurs à votre écran. Menu d'aide F1 Fn+F1 Ouvrir le menu Aide dans l'éditeur de classeurs. Ouvrir un fichier existant Ctrl+O ⌘ Cmd+C Ouvrir la boîte de dialogue standard qui permet de sélectionner un fichier existant. Lorsque vous sélectionnez le fichier dans ce boîte de dialogue et cliquez sur Ouvrir, le fichier s'ouvrira dans un nouvel onglet ou dans une nouvelle fenêtre de l'éditeur du bureau. Passer à l'onglet suivant. Ctrl+↹ Tab ^ Ctrl+↹ Tab Passer à l'onglet suivant de l'éditer de bureau ou à l'onglet suivant du navigateur dans l'éditeur en ligne. Passer à l'onglet précédent Ctrl+Maj+↹ Tab ^ Ctrl+⇧ Maj+↹ Tab Passer à l'onglet précédent dans l'éditer de bureau ou à l'onglet précédent du navigateur dans l'éditeur en ligne. Fermer le fichier Ctrl+Z, Ctrl+F4 ⌘ Cmd+Z Fermer la fenêtre actuelle du classeur. Menu contextuel de l'élément ⇧ Maj+F10 ⇧ Maj+Fn+F10 Ouvrir le menu contextuel de l'élément sélectionné. Fermer le menu ou la fenêtre modale, réinitialiser le mode, etc. Échap Échap Fermer le menu ou la fenêtre modale. Suspendre la copie de formats. Réinitialiser le mode d'ajout de formes. Vider le presse-papiers lors de la découpe/copie des cellules. Masquer le bouton Collage spécial Réinitialiser le niveau de zoom Ctrl+0 ^ Ctrl+0 or ⌘ Cmd+0 Réinitialiser le niveau de zoom du classeur actuel par défaut à 100%. Copier une feuille de calcul Appuyer et maintenir la touche Ctrl+ faire glisser l'onglet de la feuille de calcul Appuyer et maintenir la touche ⌥ Option+ faire glisser l'onglet de la feuille de calcul Copier une feuille de calcul entière et déplacer-la pour modifier la position de l'onglet. Navigation Déplacer une cellule vers le haut, le bas, la gauche ou la droite ↑ ↓ ← → ↑ ↓ ← → Activer le contour d'une cellule au-dessus/en-dessous de la cellule sélectionnée ou à gauche/à droite de celle-ci. Déplacer la cellule active vers le bas ↵ Entrée ↵ Retour Passer à la cellule située en dessous. Déplacer la cellule active vers le haut ⇧ Maj+↵ Entrée ⇧ Maj+↵ Retour Passer à la cellule située en dessus. Déplacer la cellule active vers la droite ↹ Tab ↹ Tab Passer à la cellule située à droite. Déplacer la cellule active vers la gauche ⇧ Maj+↹ Tab ⇧ Maj+↹ Tab Passer à la cellule située à gauche . Sauter au bord de la zone visible de données ou à la cellule suivante comportant des données. Ctrl+← → ↑ ↓ ⌘ Cmd+← → ↑ ↓ Début Fin Pg. préc Pg. suiv Entourer la cellule au bord de la zone visible de données ou la cellule suivante comportant des données sur la feuille de calcul. S'il n'a a pas de données dans la zone, c'est la dernière cellule dans la zone visible qui sera sélectionnée. S'il y a des données dans la zone, la cellule suivante comportant des données sera sélectionnée. Sauter au début de la ligne Début Fn+← Début Activer une cellule dans la colonne A de la ligne courante. Sauter au début de la feuille de calcul Ctrl+Début ^ Ctrl+Fn+←, ⌘ Cmd+Fn+← ^ Ctrl+Début, ⌘ Cmd+Début Activer la cellule A1. Sauter à la fin de la ligne Fin, Ctrl+→ Fn+→, ⌘ Cmd+→ Fin Activer la dernière cellule de la ligne actuelle. Sauter à la fin de la feuille de calcul Ctrl+Fin ^ Ctrl+Fn+→, ⌘ Cmd+Fn+→ ^ Ctrl+Fin, ⌘ Cmd+Fin Activer la cellule utilisée en bas à droite de la feuille de calcul située en bas de la ligne du bas avec les données de la colonne la plus à droite avec les données. Si le curseur est sur la ligne de la formule, il sera placé à la fin du texte. Passer à la feuille précédente Alt+Pg. préc ⌥ Option+Fn+↑ ⌥ Option+Pg. préc Passer à la feuille précédente de votre classeur. Passer à la feuille suivante Alt+Pg. suiv ⌥ Option+Fn+↓ ⌥ Option+Pg. suiv Passer à la feuille suivante de votre classeur. Se déplacer d'une ligne vers le haut ↑, ⇧ Maj+↵ Entrée ⇧ Maj+↵ Retour Activer la cellule au-dessus de la cellule actuelle dans la même colonne. Se déplacer d'une ligne vers le bas ↓, ↵ Entrée ↵ Retour Activer la cellule au-dessous de la cellule actuelle dans la même colonne. Se déplacer d'une colonne vers la gauche ←, ⇧ Maj+↹ Tab ←, ⇧ Maj+↹ Tab Activer la cellule précédente de la ligne actuelle. Se déplacer d'une colonne vers la droite →, ↹ Tab →, ↹ Tab Activer la cellule suivante de la ligne actuelle. Déplacement vers le bas d'un écran Pg. suiv Fn+↓ Pg. suiv Déplacer un écran vers le bas dans la feuille de calcul. Déplacer vers le haut d'un écran Pg. préc Fn+↑ Pg. préc Déplacer un écran vers le haut dans la feuille de travail. Déplacer la barre de défilement verticale vers le haut/bas Faire défiler la souris vers le haut/bas Faire défiler la souris vers le haut/bas Déplacer la barre de défilement verticale vers le haut/bas Déplacer la barre de défilement horizontale vers la gauche/droite ⇧ Maj+Faire défiler la souris vers le haut/bas ⇧ Maj+Faire défiler la souris vers le haut/bas Déplacer la barre de défilement horizontale vers la gauche/droite Afin de déplacer la barre de défilement vers la droite, faites défiler la roulette de la souris vers le bas. Afin de déplacer la barre de défilement vers la gauche, faites défiler la roulette de la souris vers le haut. Zoom avant Ctrl++ ^ Ctrl++, ⌘ Cmd++ Zoom avant sur la feuille de calcul en cours d'édition. Zoom arrière Ctrl+- ^ Ctrl+-, ⌘ Cmd+- Zoom arrière sur la feuille de calcul en cours d'édition. Naviguer entre les contrôles dans un dialogue modal ↹ Tab/⇧ Maj+↹ Tab ↹ Tab/⇧ Maj+↹ Tab Naviguer entre les contrôles pour mettre en évidence le contrôle précédent ou suivant dans les dialogues modaux. Sélection de données Sélectionner toute la feuille de calcul Ctrl+A, Ctrl+⇧ Maj+␣ Barre d'espace ⌘ Cmd+A, ^ Ctrl+A Sélectionner la feuille de calcul entière (lorsque la mise au point est sur une cellule) Sélectionner une colonne Ctrl+␣ Barre d'espace ^ Ctrl+Fn+␣ Barre d'espace, ⌘ Cmd+Fn+␣ Barre d'espace Sélectionner une colonne entière d'une feuille de calcul. Sélectionner une ligne ⇧ Maj+␣ Barre d'espace ⇧ Maj+␣ Barre d'espace Sélectionner une ligne entière d'une feuille de calcul. Sélectionner une cellule à droite ⇧ Maj+→ ⇧ Maj+→ Sélectionner une cellule à droite. Sélectionner une cellule à gauche ⇧ Maj+← ⇧ Maj+← Sélectionner une cellule à gauche. Sélectionner une cellule en haut ⇧ Maj+↑ ⇧ Maj+↑ Sélectionner une cellule en haut. Sélectionner une cellule en bas ⇧ Maj+↓ ⇧ Maj+↓ Sélectionner une cellule en bas Sélectionner depuis le curseur jusqu'au début de la ligne ⇧ Maj+Début ⇧ Maj+Fn+← ⇧ Maj+Début Sélectionner une plage depuis le curseur jusqu'au début de la ligne actuelle. Sélectionner depuis le curseur jusqu'à la fin de la ligne ⇧ Maj+Fin ⇧ Maj+Fn+← ⇧ Maj+Début Sélectionner une plage depuis le curseur jusqu'à la fin de la ligne actuelle. Sélectionner jusqu'à la cellule non vierge la plus proche à droite Ctrl+⇧ Maj+→ ^ Ctrl+⇧ Maj+→, ⌘ Cmd+⇧ Maj+→ Sélectionner les cellules jusqu'à la cellule non vierge la plus proche à droite de la cellule active ou jusqu'à la fin de la zone visible. Sélectionner jusqu'à la cellule non vierge la plus proche à gauche Ctrl+⇧ Maj+← ^ Ctrl+⇧ Maj+←, ⌘ Cmd+⇧ Maj+← Sélectionner les cellules jusqu'à la cellule non vierge la plus proche à gauche de la cellule active ou jusqu'à la fin de la zone visible. Sélectionner jusqu'à la cellule non vierge la plus proche en haut Ctrl+⇧ Maj+↑ ^ Ctrl+⇧ Maj+↑, ⌘ Cmd+⇧ Maj+↑ Sélectionner les cellules jusqu'à la cellule non vierge la plus proche en haut de la cellule active ou jusqu'à la fin de la zone visible. Sélectionner jusqu'à la cellule non vierge la plus proche en bas Ctrl+⇧ Maj+↓ ^ Ctrl+⇧ Maj+↓, ⌘ Cmd+⇧ Maj+↓ Sélectionner les cellules jusqu'à la cellule non vierge la plus proche en bas de la cellule active ou jusqu'à la fin de la zone visible. Sélectionner jusqu'au début de la feuille de calcul Ctrl+⇧ Maj+Début ^ Ctrl+⇧ Maj+Fn+←, ⌘ Cmd+⇧ Maj+Fn+← ^ Ctrl+⇧ Maj+Début, ⌘ Cmd+⇧ Maj+Début Sélectionner une plage à partir des cellules sélectionnées jusqu'au début de la feuille de calcul. Sélectionner jusqu'à la dernière cellule utilisée Ctrl+⇧ Maj+Fin ^ Ctrl+⇧ Maj+Fn+→, ⌘ Cmd+⇧ Maj+Fn+→ ^ Ctrl+⇧ Maj+Fin, ⌘ Cmd+⇧ Maj+Fin Sélectionner un fragment à partir des cellules sélectionnées actuelles jusqu'à la dernière cellule utilisée sur la feuille de calcul (à la ligne du bas avec les données de la colonne la plus à droite avec les données). Si le curseur se trouve dans la barre de formule, tout le texte de la barre de formule sera sélectionné de la position du curseur jusqu'à la fin sans affecter la hauteur de la barre de formule. Étendre la sélection jusqu'à la cellule non vierge la plus proche à droite. ⇧ Maj+Fin, Ctrl+⇧ Maj+→ ⇧ Maj+Fn+← ⇧ Maj+Début Étendre la sélection jusqu'à la cellule non vierge la plus proche dans la même rangée à droite de la cellule active. Si la cellule suivante est vide, la sélection sera étendue à la cellule suivante non vide. Étendre la sélection jusqu'à la cellule non vierge à gauche Ctrl+⇧ Maj+← Étendre la sélection jusqu'à la cellule non vierge à gauche. Étendre la sélection jusqu'à la première colonne ⇧ Maj+Début ⇧ Maj+Fn+← ⇧ Maj+Début Étendre la sélection jusqu'à la première colonne (A). Étendre la sélection jusqu'à la cellule non vierge la plus proche en haut/en bas de la colonne Ctrl+⇧ Maj+↑ ↓ Étendre la sélection jusqu'à la cellule non vierge la plus proche dans la même colonne en haut/en bas à partir de la cellule active. Si la cellule suivante est vide, la sélection sera étendue à la cellule suivante non vide. Étendre la sélection d'un écran vers le bas ⇧ Maj+Pg. suiv ⇧ Maj+Fn+↓ ⇧ Maj+Pg. suiv Étendre la sélection à toutes les cellules situées à un écran en dessous de la cellule active. Toutes les cellules de colonnes incluses dans la plage sélectionnée auparavant seront sélectionnées. Étendre la sélection d'un écran vers le haut ⇧ Maj+Pg. préc ⇧ Maj+Fn+↑ ⇧ Maj+Pg. préc Étendre la sélection à toutes les cellules situées un écran plus haut que la cellule active. Toutes les cellules des colonnes incluses dans la plage sélectionnée auparavant seront sélectionnées. Annuler et Rétablir Annuler Ctrl+W ⌘ Cmd+W, ^ Ctrl+Z Inverser la dernière action effectuée. Rétablir Ctrl+Y ⌘ Cmd+Y, ^ Ctrl+Y Répéter la dernière action annulée. Couper, Copier et Coller Couper Ctrl+X, ⇧ Maj+Supprimer ⌘ Cmd+X Couper les données sélectionnées/graphiques et les envoyer vers le presse-papiers. Les données coupées peuvent être insérées ensuite dans un autre endroit du même classeur, dans un autre classeur, ou dans un autre programme. Copier Ctrl+C, Ctrl+Inser ⌘ Cmd+C Envoyer les données sélectionnées//graphiques sélectionnées vers le presse-papiers. Les données copiées peuvent être insérées ensuite dans un autre endroit du même classeur, dans un autre classeur, ou dans un autre programme. Coller Ctrl+V, ⇧ Maj+Inser ⌘ Cmd+V Insérer les données copiées/coupées/graphiques depuis le presse-papiers à la position actuelle du curseur. Les données peuvent être copiées à partir du même classeur, à partir d'un autre classeur, ou provenant d'un autre programme. Options de Collage spécial 1 Coller uniquement formule Ctrl ensuite F ^ Ctrl ensuite F Coller des formules sans coller la mise en forme des données. Coller formule + format de nombre Ctrl ensuite O ^ Ctrl ensuite O Coller des formules avec la mise en forme des nombres. Coller formule + toute mise en forme Ctrl ensuite K ^ Ctrl ensuite K Coller des formules avec la mise en forme des données. Coller la formule sans bordures Ctrl ensuite B ^ Ctrl ensuite B Coller des formules avec la mise en forme des données sans bordures de la cellule. Coller formule + largeur de colonne Ctrl ensuite W ^ Ctrl ensuite W Coller des formules avec toute la mise en forme des données et de définir la largeur de la colonne source pour la plage de cellules. Transposer Ctrl ensuite T ^ Ctrl ensuite T Coller des données en modifiant les colonnes en lignes et les lignes en colonnes. Cette option est disponible pour les plages de données normales, mais pas pour les tableaux mis en forme. Coller uniquement valeur Ctrl ensuite V ^ Ctrl ensuite V Coller des résultats de formules sans coller la mise en forme des données. Coller valeur + format de nombre Ctrl ensuite A ^ Ctrl ensuite A Coller les résultats des formules avec la mise en forme des nombres. Coller valeur + toute la mise en forme Ctrl ensuite E ^ Ctrl ensuite E Coller des résultats de formules avec la mise en forme des données. Coller uniquement mise en forme Ctrl ensuite R ^ Ctrl ensuite R Coller la mise en forme de cellule sans coller le contenu de la cellule. Coller lien Ctrl ensuite N ^ Ctrl ensuite N Coller le lien externe vers une cellule ou une plage de cellules dans une autre feuille de calcul sur le portail (à partir de l'éditeur en ligne) ou dans un fichier local (à partir de l'éditeur de bureau). Opérations sur des liens hypertexte Insérer un lien hypertexte Ctrl+K ⌘ Cmd+K, ^ Ctrl+K Insérer un lien hypertexte qui peut être utilisé pour accéder à une adresse web. Suivre lien hypertexte Entrée Retour Suivre un lien hypertexte (le curseur sur le lien hypertexte) Mise en forme des données Gras Ctrl+B ^ Ctrl+B, ⌘ Cmd+B Mettre la police du fragment de texte sélectionné en gras pour lui donner plus de poids. Italique Ctrl+I ⌘ Cmd+I Mettre la police du fragment de texte sélectionné en italique pour lui donner une certaine inclinaison à droite ou supprimer la mise en forme italique. Souligné Ctrl+U ^ Ctrl+U, ⌘ Cmd+U Souligner le fragment de texte sélectionné avec la ligne qui passe sous les lettres ou supprimer le soulignage. Barré Ctrl+5 ^ Ctrl+5, ⌘ Cmd+5 Barrer le fragment de texte sélectionné avec une ligne qui passe à travers les lettres ou supprimer la barre. Éditer la cellule active F2 Fn+F2 Éditer la cellule active et positionner le point d'insertion à la fin du contenu de la cellule. Si l'édition dans une cellule est désactivée, le point d'insertion sera déplacé dans la barre de formule. Filtrer des données Activer/Supprimer le filtre Ctrl+⇧ Maj+L ^ Ctrl+⇧ Maj+L, ⌘ Cmd+⇧ Maj+L Activer un filtre pour une plage de cellules sélectionnée ou supprimer le filtre. Ouvrir la fenêtre de filtre Alt+↓ ⌥ Option+↓ Dans l'en-tête d'une colonne avec un filtre, ouvrir la fenêtre de filtre. Mettre sous forme de modèle de tableau Ctrl+L ^ Ctrl+L, ⌘ Cmd+L Appliquer un modèle de table à une plage de cellules sélectionnée. Saisie des données Terminer la saisie de données dans une cellule et se déplacer vers le bas ↵ Entrée ↵ Retour Valider la saisie de données dans la cellule sélectionnée ou dans la barre de formule, et passer à la cellule située au-dessous. Valider la saisie de données dans une cellule et se déplacer vers le haut ⇧ Maj+↵ Entrée ⇧ Maj+↵ Retour Terminer la saisie de données dans la cellule sélectionnée, et passer à la cellule située au-dessus. Terminer la saisie de données dans la cellule et se déplacer vers la droite ↹ Tab ↹ Tab Terminer la saisie de données dans la cellule sélectionnée ou dans la barre de formule et se déplacer vers la cellule à droite. Terminer la saisie de données dans la cellule et se déplacer vers la gauche ⇧ Maj+↹ Tab ⇧ Maj+↹ Tab Terminer la saisie de données dans la cellule sélectionnée ou dans la barre de formule et passer à la cellule à gauche . Terminer la saisie de données et rester dans la cellule Ctrl+⇧ Maj+↵ Entrée, Ctrl+↵ Entrée ^ Ctrl+⇧ Maj+↵ Retour, ^ Ctrl+↵ Retour Terminer la saisie de données dans la cellule sélectionnée ou dans la barre de formule et rester dans la cellule. Remplir la plage de cellules sélectionnée avec la valeur actuelle Ctrl+↵ Entrée ^ Ctrl+↵ Retour Remplir la plage de cellules sélectionnée avec la valeur actuelle. Sélectionner une plage de cellules, saisir les données dans la cellule active et appuyer sur la touche appropriée pour remplir les cellules sélectionnées avec le données qu'on vient de saisir. Commencer une nouvelle ligne Alt+↵ Entrée ⌥ Option+↵ Retour Commencer une nouvelle ligne dans la même cellule. Ajouter un nouveau point d'insertion à l'argument d'équation Entrée Retour, ⇧ Maj+Retour Ajouter un nouveau point d'insertion à l'argument d'équation Annuler Échap Échap Annuler la saisie de données dans la cellule sélectionnée ou dans la barre de formule. Supprimer à gauche ← Retour arrière Supprimer Supprimer un caractère à gauche dans la barre de formule ou dans la cellule sélectionnée lorsque le mode d'édition de cellule est activé. Supprimer la sélection. Ce raccourci permet également de supprimer le contenu de la cellule active. Celui-ci peut également être utilisé avec des objets graphiques. Supprimer à droite Supprimer Fn+Supprimer Supprimer un caractère à droite dans la barre de formule ou dans la cellule sélectionnée lorsque le mode d'édition de cellule est activé. Supprimer la sélection. Supprimer le contenu (données et formules) des cellules sélectionnées en gardant la mise en forme des cellules ou les commentaires. Ce raccourci peut également être utilisé avec des objets graphiques. Effacer le contenu de cellule active Supprimer, ← Retour arrière Supprimer Supprimer le contenu (données et formules) de la cellule active en gardant la mise en forme des cellules ou les commentaires. Effacer tout le contenu dans des cellules sélectionnées Supprimer Fn+Supprimer Supprimer tout le contenu (données et formules) des cellules sélectionnées en gardant la mise en forme des cellules ou les commentaires. Insérer des cellules Ctrl+⇧ Maj++ Ctrl+⇧ Maj++, ⌘ Cmd+⇧ Maj++ Ouvrir la boîte de dialogue pur insérer de nouvelles cellules dans la feuille de calcul actuelle et spécifier les paramètres supplémentaires pour se déplacer vers la droite, vers le bas ou insérer une ligne ou une colonne entière. Supprimer les cellules Ctrl+⇧ Maj+- Ctrl+⇧ Maj+-, ⌘ Cmd+⇧ Maj+- Ouvrir la boîte de dialogue pour supprimer les cellules dans la feuille de calcul actuelle et spécifier les paramètres supplémentaires pour se déplacer vers la droite, vers le bas ou supprimer une ligne ou une colonne entière. Insérer la date actuelle Ctrl+; Ctrl+;, ⌘ Cmd+; Insérer la date courante dans la cellule sélectionnée. Insérer l'heure actuelle Ctrl+⇧ Maj+; Ctrl+⇧ Maj+;, ⌘ Cmd+⇧ Maj+; Insérer l'heure courante dans la cellule sélectionnée. Insérer la date et l'heure actuelles Ctrl+; ensuite ␣ Barre d'espace ensuite Ctrl+⇧ Maj+; Ctrl+; ensuite ␣ Barre d'espace ensuite Ctrl+⇧ Maj+;, ⌘ Cmd+; ensuite ␣ Barre d'espace ensuite ⌘ Cmd+⇧ Maj+; Insérer la date et l'heure courantes dans la cellule sélectionnée. Insérer séparateur Pavé numérique . Insérer un séparateur dans la cellule sélectionnée. Remplissage automatique (Ouvrir la liste déroulante) Alt+↓ ⌥ Option+↓ Utiliser ce raccourci dans une cellule vide au-dessous ou au-dessus les valeurs existantes dans la colonne. Une liste déroulante contenant les valeurs existantes s'affichera. Sélectionner l'une des valeurs de texte disponibles pour remplir une cellule vide. Insérer un tiret sur cadratin ⌥ Option+⇧ Maj+- Insérer un tiret sur cadratin ‘—’ dans la cellule actuelle. Insérer un tiret demi-cadratin ⌥ Option+- Insérer un tiret demi-cadratin ‘-’ dans la cellule actuelle. Utiliser le clavier prenant en charge la possibilité d'insérer les codes de caractères Unicode ⌥ Option+Q, ⌥ Option+F, ⇧ Maj+⌥ Option+7, et d'autres Lors de l'utilisation des raccourcis à l'aide de ⌥ Option+symbole clavier, pour les claviers qui prennent en charge la possibilité d'insérer les codes de caractères Unicode, les symboles clavier sont ajoutés. Consultez la liste ci-dessous pour exemples. Avec la disposition de clavier ABC, le raccourci ⌥ Option+Q insère le symbole \"œ\" symbole, le raccourci ⌥ Option+F insère le symbole fonction \"ƒ\". Avec la disposition de clavier multilingue officiel des États-Unis sans touches mortes, le raccourci ⌥ Option+Q insère le symbole “ä”. Avec la disposition suisse-allemand, le raccourci ⇧ Maj+⌥ Option+7 insère le symbole \"\\”. Opérations sur texte dans des cellules et des objets graphiques Supprimer un mot, une sélection à gauche Ctrl+Retour arrière ⌥ Option+Supprimer Supprimer un mot, une sélection à gauche du curseur. Supprimer un mot, une sélection à droite Ctrl+Supprimer Fn+⌥ Option+Supprimer Supprimer un mot, une sélection à gauche du curseur. Sélectionner tout Ctrl+A ⌘ Cmd+A, ^ Ctrl+A Sélectionner le contenu entier d'une forme (lorsque le curseur se trouve à l'intérieur de la forme). Sélectionner le contenu entier d'une cellule (lorsque le curseur se trouve à l'intérieur de la cellule). Déplacer d'un caractère vers la gauche/la droite ou en haut/en bas. ← → ↑ ↓ ← → ↑ ↓ Déplacer le curseur d'un caractère vers la gauche/la droite ou en haut/en bas. Sélectionner un caractère à droite ⇧ Maj+→ ⇧ Maj+→ Sélectionner un caractère à droite de la position du curseur. Sélectionner un caractère à gauche ⇧ Maj+← ⇧ Maj+← Sélectionner un caractère à gauche de la position du curseur. Déplacer le curseur d'un mot vers la gauche Ctrl+← ⌥ Option+← Déplacer le curseur d'un mot vers la gauche. Déplacer le curseur d'un mot vers la droite Ctrl+→ ⌥ Option+→ Déplacer le curseur d'un mot vers la droite. Sélectionner un mot à gauche Ctrl+⇧ Maj+← ⇧ Maj+⌥ Option+← Sélectionner un mot à gauche du curseur. Sélectionner un mot à droite Ctrl+⇧ Maj+→ ⇧ Maj+⌥ Option+→ Sélectionner un mot à droite du curseur. Sauter au début du texte Ctrl+Début ^ Ctrl+Fn+←, ⌘ Cmd+Fn+← ^ Ctrl+Début, ⌘ Cmd+Début Placer le curseur au début du texte dans une cellule ou une forme. Sauter à la fin du texte Ctrl+Fin ^ Ctrl+Fn+→, ⌘ Cmd+Fn+→ ^ Ctrl+Fin, ⌘ Cmd+Fin Placer le curseur à la fin du texte dans une cellule ou une forme. Sélectionner à partir de la position actuelle du curseur jusqu'au début du texte Ctrl+⇧ Maj+Début ^ Ctrl+⇧ Maj+Fn+←, ⌘ Cmd+⇧ Maj+Fn+← ^ Ctrl+⇧ Maj+Début, ⌘ Cmd+⇧ Maj+Début Sélectionner le fragment du texte à partir de la position du curseur jusqu'au début du texte dans une cellule ou une forme. Sélectionner à partir de la position du curseur jusqu'à la fin du texte Ctrl+⇧ Maj+Fin ^ Ctrl+⇧ Maj+Fn+→, ⌘ Cmd+⇧ Maj+Fn+→ ^ Ctrl+⇧ Maj+Fin, ⌘ Cmd+⇧ Maj+Fin Sélectionner le fragment du texte à partir de la position du curseur jusqu'à fin du texte dans une cellule ou une forme. Sauter au début de la ligne Début ⌘ Cmd+← Début Placer le curseur au début de la ligne en cours de modification Sauter à la fin de la ligne Fin ⌘ Cmd+→ Fin Placer le curseur à la fin de la ligne en cours de modification. Sélectionner à partir de la position du curseur jusqu'au début de la ligne ⇧ Maj+Début ⇧ Maj+Fn+← ⇧ Maj+Début Sélectionner le fragment du texte à partir de la position du curseur jusqu'au début de la ligne actuelle. Sélectionner à partir de la position du curseur jusqu'à la fin de la ligne ⇧ Maj+Fin ⇧ Maj+Fn+← ⇧ Maj+Début Sélectionner le fragment du texte à partir de la position du curseur jusqu'à la fin de la ligne actuelle. Sélectionner une ligne en haut ⇧ Maj+↑ ⇧ Maj+↑ Déplacer le curseur d'une ligne vers le haut pour sélectionner tous les symboles compris entre la position précédente du curseur et la position actuelle. Sélectionner une ligne en bas ⇧ Maj+↓ ⇧ Maj+↓ Déplacer le curseur d'une ligne vers le bas pour sélectionner tous les symboles compris entre la position précédente du curseur et la position actuelle. Tableaux croisés dynamiques Mettre à jour le tableau croisé dynamique. Alt+F5 ⌥ Option+Fn+F5 Actualiser le tableau croisé dynamique.sélectionné auparavant. Mettre à jour tous les tableaux croisés dynamiques Ctrl+Alt+F5 2 Ctrl+⌥ Option+Fn+F5 Mettre à jour tous les tableaux croisés dynamiques. Segments Effacer les valeurs sélectionnées Alt+C Ctrl+⌥ Option+C, ⌘ Cmd+⌥ Option+C Effacer les valeurs sélectionnées pour un segment. Activer la sélection multiple Alt+S Ctrl+⌥ Option+S, ⌘ Cmd+⌥ Option+S Activer/désactiver la sélection multiple pour un segment. Tableaux mis en forme Ajouter une ligne de synthèse Ctrl+⇧ Maj+R Ctrl+⇧ Maj+R, ⌘ Cmd+⇧ Maj+R Ajouter la ligne de synthèse au tableau mis en forme. Fonctions Insérer une fonction ⇧ Maj+F3 ⇧ Maj+Fn+F3 Ouvrir la boîte de dialogue pour insérer une nouvelle fonction de la liste prédéfinie. Fonction SOMME Alt++ ⌥ Option+Ctrl++ Insérer la fonction SOMME dans la cellule active. Recalculer des fonctions F9 Fn+F9 Recalculer le classeur entier. Recalculer des fonctions ⇧ Maj+F9 ⇧ Maj+Fn+F9 Recalculer la feuille de calcul actuelle. Afficher les fonctions sur une feuille de calcul Ctrl+` Ctrl+` Afficher les fonctions (non leurs valeurs) sur une feuille de calcul à imprimer. Activer le type de référence F4 Fn+F4 Activer le type de référence de cellule dans la barre de formule (absolue ou relative). Formats de données Ouvrir la boîte de dialogue 'Format de numéro' Ctrl+1 ^ Ctrl+1, ⌘ Cmd+1 Ouvrir la boîte de dialogue Format de numéro Appliquer le format Général Ctrl+⇧ Maj+ù ^ Ctrl+⇧ Maj+ù Appliquer le format de nombre Général. Appliquer le format Devise Ctrl+⇧ Maj+' ^ Ctrl+⇧ Maj+' Appliquer le format Devise avec deux décimales. Appliquer le format Pourcentage Ctrl+⇧ Maj+( ^ Ctrl+⇧ Maj+( Appliquer le format Pourcentage sans décimales. Appliquer le format Exponentiel Ctrl+⇧ Maj+- ^ Ctrl+⇧ Maj+- Appliquer le format des nombres exponentiels avec deux décimales. Appliquer le format Date Ctrl+⇧ Maj+\" ^ Ctrl+⇧ Maj+\" Appliquer le format Date avec le jour, le mois et l'année. Appliquer le format Heure Ctrl+⇧ Maj+é ^ Ctrl+⇧ Maj+é Appliquer le format Heure avec l'heure et les minutes, et le format AM ou PM. Appliquer un format de nombre Ctrl+⇧ Maj+& ^ Ctrl+⇧ Maj+& Appliquer le format Nombre avec deux décimales, un séparateur de milliers et le signe moins (-) pour les valeurs négatives. Modification des objets Opérations sur des formes ↵ Entrée Retour Lors la sélection d'une forme, s'il n'y a pas du contenu, créez le contenu et déplacez le curseur au début de la ligne. S'il n'y a pas de contenu, placez le curseur à l'intérieur sinon sélectionnez tout le contenu. Opérations sur des graphiques ↵ Entrée Lors de la sélection de titre du graphique, sélectionner le texte. Créer une copie lors du glisser-déposer Ctrl ^ Ctrl Sélectionner un objet et maintenir la touche nécessaire lors du glisser-déposer l'objet pour copier l'objet vers l'endroit de destination. Limiter le déplacement ⇧ Maj + faire glisser ⇧ Maj + faire glisser Limiter le déplacement de l'objet sélectionné horizontalement ou verticalement. Régler une rotation de 15 degrés ⇧ Maj + faire glisser (lors de la rotation) ⇧ Maj + faire glisser (lors de la rotation) Limiter la rotation à à des incréments de 15 degrés. Conserver les proportions ⇧ Maj + faire glisser (lors du redimensionnement) ⇧ Maj + faire glisser (lors du redimensionnement) Conserver les proportions de l'objet sélectionné lors du redimensionnement. Modifier l'angle de ligne/flèche pendant le dessin ⇧ Maj + faire glisser (lors du tracé de lignes/flèches) ⇧ Maj + faire glisser (lors du tracé de lignes/flèches) Maintenir la touche Maj enfoncée pendant le dessin de la ligne/flèche et faites pivoter la pointe de la flèche/la fin de la ligne pour modifier l'angle de la ligne/flèche lors du dessin. La ligne/flèche sera basculé de 45 degrés. Mouvement par incréments de 1 pixel Ctrl+← → ↑ ↓ ⌘ Cmd+← → ↑ ↓ Maintenir la touche nécessaire enfoncée et utiliser les touches fléchée pour déplacer l'objet sélectionné à gauche, à droite, en haut ou en bas d'un pixel à la fois. Déplacer la forme par grands incréments ← → ↑ ↓ ← → ↑ ↓ Utiliser les touches fléchées pour déplacer l'objet sélectionné par grands incréments à gauche, à droite, en haut ou en bas. Déplacer la mise au point vers l'objet suivant ↹ Tab ↹ Tab Déplacer la mise au point vers l'objet suivant après l'objet sélectionné. Déplacer la mise au point vers l'objet précédent ⇧ Maj+↹ Tab ⇧ Maj+↹ Tab Déplacer la mise au point vers l'objet précédent avant l'objet sélectionné. Sélectionner tout Ctrl+A ⌘ Cmd+A, ^ Ctrl+A Sélectionner toutes les formes (lorsque la mise au point est sur une forme). Ajouter un taquet de tabulation au contenu de l'objet ↹ Tab ↹ Tab Ajouter un taquet de tabulation au contenu de l'objet Indice Ctrl+. ^ Ctrl+., ⌘ Cmd+. Rendre le fragment du texte sélectionné plus petit et le placer à la partie inférieure de la ligne du texte, par exemple comme dans les formules chimiques. Ne fonctionne qu'avec le texte dans un objet graphique. Exposant Ctrl+, ^ Ctrl+,, ⌘ Cmd+, Sélectionner le fragment du texte et le placer sur la partie supérieure de la ligne de texte, par exemple comme dans les fractions. Ne fonctionne qu'avec le texte dans un objet graphique. Agrandir la police Ctrl+] ⌘ Cmd+], ^ Ctrl+] Augmenter la taille de la police du fragment de texte sélectionné de 1 point. Ne fonctionne qu'avec le texte dans un objet graphique. Réduire la police Ctrl+[ ⌘ Cmd+[, ^ Ctrl+[ Réduire la taille de la police du fragment de texte sélectionné de 1 point. Ne fonctionne qu'avec le texte dans un objet graphique. Alignement centré Ctrl+E ^ Ctrl+E, ⌘ Cmd+E Basculer entre l'alignement centré et l'alignement à gauche. Ne fonctionne qu'avec le texte dans un objet graphique. Justifié Ctrl+J ^ Ctrl+J, ⌘ Cmd+J Basculer entre l'alignement justifié et l'alignement à gauche. Ne fonctionne qu'avec le texte dans un objet graphique. Aligner à droite Ctrl+R ^ Ctrl+R, ⌘ Cmd+R Basculer entre l'alignement à droite et l'alignement à gauche. Ne fonctionne qu'avec le texte dans un objet graphique. Aligner à gauche Ctrl+L ^ Ctrl+L, ⌘ Cmd+L Aligner le paragraphe à gauche. Ne fonctionne qu'avec le texte dans un objet graphique. Mettre fin au paragraphe et commencer un nouveau paragraphe ↵ Entrée ↵ Retour Mettre fin au paragraphe actuel et commencer un nouveau paragraphe lors de la saisie du texte dans un objet graphique. Ajouter un saut de ligne ⇧ Maj+↵ Entrée ⇧ Maj+↵ Retour Ajouter un saut de page sans commencer un nouveau paragraphe lors de la saisie du texte dans un objet graphique. Supprimer l'objet graphique Supprimer, Ctrl+Supprimer, Retour arrière, Ctrl+Retour arrière Supprimer, ⌥ Option+Supprimer Supprimer un objet graphique. Quitter le mode d'ajout de forme, enlever graduellement la sélection Échap Échap Quitter le mode d'ajout de forme. Enlever graduellement la sélection (par exemple, lorsqu'on a sélectionné le contenu de la forme dans un groupe, d'abord, il faut retirer le curseur du contenu, ensuite de la forme et ensuite du groupe). 1 - Coller les données copiées en utilisant Ctrl+V sur Windows ou Cmd+V sur macOS. Une fois les données collées, utiliser Ctrl pour ouvrir le menu Collage spécial, ensuite appuyer sur une touche de type lettre correspondant à l'option nécessaire. 2 - Ce raccourci ne fonctionne pas sur Linux."
    },
   {
        "id": "HelpfulHints/Navigation.htm", 
        "title": "Paramètres d'affichage et outils de navigation", 
        "body": "Pour vous aider à afficher et sélectionner des cellules dans un grand classeur, l'éditeur de classeurs vous propose plusieurs outils de navigation: les barres de défilement, les boutons de défilement, les onglets de classeur et le zoom. Régler les paramètres d'affichage Pour régler les paramètres d'affichage par défaut et définir le mode le plus pratique pour travailler sur une feuille de calcul, passez à l'onglet Affichage. Les options disponibles sont les suivantes: Afficher une feuille permet configurer les paramètres d'affichage de feuille. Pour en savoir plus sur l'affichage des feuilles de calcul, veuillez consulter cet article. Zoom - sert à définir la valeur de zoom de 50% à 200% en sélectionnant de la liste des options disponibles. Thème d'interface - sélectionnez l'une des thèmes d'interface disponibles dans la liste déroulante: Identique à système, Claire, Classique claire, Sombre, Contraste élevé sombre. Verrouiller les volets - fige toutes les lignes au-dessus de la cellule active et toutes les colonnes à gauche de la cellule active afin qu'elles restent visibles lorsque vous faites défiler la feuille vers la droite ou vers le bas. Pour débloquer les volets, cliquez à nouveau sur cette option ou cliquez avec le bouton droit n'importe où dans la feuille de calcul et sélectionnez l'option Libérer les volets dans le menu. Masquer la barre de formule une fois désactivé, sert à masquer la barre au-dessous de la barre d'outils supérieure, utilisée pour saisir et réviser la formule et son contenu. Pour afficher la Barre de formule masquée cliquez sur cette option encore une fois. La Barre de formule est développée d'une ligne quand vous faites glisser le bas de la zone de formule pour l'élargir. En-têtes une fois désactivé, sert à masquer les en-têtes des colonnes en haut et les en-têtes des lignes à gauche de la feuille de calcul. Pour afficher les En-têtes masqués, cliquez sur cette option encore une fois. Quadrillage une fois désactivé, sert à masquer les lignes autour des cellules. Pour afficher le Quadrillage masqué cliquez sur cette option encore une fois. Afficher les zéros permet d'afficher 0 lors de la saisie dans une cellule. Décochez cette case pour désactiver cette option. Toujours afficher la barre d'outils - une fois désactivé, la barre d'outils supérieure comportant toutes les commandes sont masquée mais tous les onglets restent visibles. Vous pouvez également double-cliquer sur un onglet pour masquer la barre d'outils supérieure ou l'afficher à nouveau. Afficher les zéros permet d'afficher 0 lors de la saisie dans une cellule. Par défaut, cette option est activée. Une fois désactivée, la barre d'état s'affichera sur deux lignes. Panneau gauche - une fois désactivé, le panneau gauche comportant les onglets Rechercher, Commentaireset autres onglets sera masqué. Pour afficher le panneau gauche, cochez cette case. Panneau droit - une fois désactivé, le panneau droit comportant les options de configurations des Paramètres sera masqué. Pour afficher le panneau droit, cochez cette case. La barre latérale sur la droite est réduite par défaut. Pour l'agrandir, sélectionnez un objet (par exemple, image, graphique, forme) ou un passage de texte et cliquez sur l'icône de l'onglet actuellement activé sur la droite. Pour réduire la barre latérale sur la droite, cliquez à nouveau sur l'icône. Vous pouvez également modifier la taille du panneau Commentaires ou Chat ouvert en utilisant un simple glisser-déposer : placez le curseur de la souris sur le bord gauche de la barre latérale. Quand il se transforme dans la flèche bidirectionnelle, faites glisser le bord à droite pour augmenter la largeur de la barre latérale. Pour rétablir sa largeur originale faites glisser le bord à gauche. Utiliser les outils de navigation Pour naviguer à travers votre classeur, utilisez les outils suivants: Utilisez la touche Tab sur votre clavier pour vous déplacer à droite de la cellule sélectionnée. Les barres de défilement (horizontale et verticale) servent à faire défiler la feuille de calcul actuelle vers le haut /le bas et vers la gauche/la droite. Pour naviguer dans une feuille de calcul à l'aide des barres de défilement: cliquez sur la flèche vers le haut/bas ou vers la droite/gauche sur la barre de défilement; faites glisser la case de défilement; faites tourner la molette pour vous déplacer verticalement; utilisez la combinaison de touches Maj + molette de défilement de la souris pour vous déplacer horizontalement; cliquez n'importe où à gauche/à droite ou en haut/en bas de la case de défilement sur la barre de défilement. Vous pouvez également utiliser la molette de la souris pour faire défiler votre feuille de calcul vers le haut ou vers le bas. Les boutons de Navigation des feuilles sont situés dans le coin inférieur gauche et servent à faire défiler la liste de feuilles vers la droite/gauche et à naviguer parmi les onglets des feuilles. cliquez sur Faire défiler la liste des feuilles à gauche pour pour faire défiler la liste des feuilles de calcul du classeur actuel vers la gauche; cliquez sur Faire défiler la liste des feuilles à droite pour pour faire défiler la liste des feuilles de calcul du classeur actuel vers la droite; Utilisez sur la barre d'état pour ajouter une nouvelle feuille de calcul. Pour sélectionner une feuille de calcul nécessaire: cliquez sur le bouton sur la barre d'état pour ouvrir la liste des feuilles de calcul et sélectionner la feuille de calcul nécessaire. L'état de la feuille s'affiche aussi dans la liste des feuilles de calcul, ou cliquez sur l'onglet de la feuille approprié à côté du bouton . Les boutons Zoom sont situés en bas à droite et servent à faire un zoom avant ou un zoom arrière. Pour modifier la valeur de zoom sélectionnée en pourcentage, cliquez dessus et sélectionnez l'une des options de zoom disponibles dans la liste (50% / 75% / 100% / 125% / 150% / 175% / 200% / 300% / 400% / 500%) ou utilisez les boutons Zoom avant ou Zoom arrière . Les options de zoom sont également disponibles sous l'onglet Affichage. Le niveau de zoom défini sera conservé pendant la session actuelle pour tous les fichiers. Vous pouvez définir une valeur de zoom par défaut. Basculez vers l'onglet Fichier de la barre d'outils supérieure, passez à la section Paramètres avancés, choisissez la Valeur de zoom par défaut nécessaire dans la liste et cliquez sur le bouton Appliquer. Pour sélectionner le niveau de zoom précédent, faites défiler la liste déroulante en haut et sélectionnez l'option Récemment utilisés."
    },
   {
        "id": "HelpfulHints/Search.htm", 
        "title": "Fonctions de recherche et remplacement", 
        "body": "Pour rechercher les caractères, les mots et les phrases nécessaires dans l'éditeur de classeurs, cliquez sur l'icône Rechercher de la barre latérale gauche, sur l'icône dans le coin supérieur droit ou utilisez le raccourci Ctrl+F (Commande+F pour MacOS) pour ouvrir la petite barre de recherche ou le raccourci Ctrl+ H pour ouvrir le panneau de recherche. Une petite barre Recherche apparaîtra dans le coin supérieur droit de l'espace de travail. La barre inclut le champ de saisie de la requête de recherche, affiche le nombre de résultats de recherche et les contrôles pour basculer entre le résultat précédent ou suivant et masquer la barre. Pour accéder aux paramètres avancés, cliquez sur l'icône . Le panneau Rechercher et remplacer s'affiche. Saisissez le texte à rechercher dans le champ de saisie Rechercher. Pour naviguer à travers des occurrences, cliquez sur les boutons fléchés. Le bouton affiche l'occurrence suivante et le bouton affiche l'occurrence précédente. S'il vous faut remplacer une ou plusieurs occurrences des caractères trouvés, saisissez le texte de remplacement dans le champ de saisie Remplacer par. Vous pouvez remplacer une seule occurrence qui est mise en surbrillance ou toutes occurrences en cliquant sur le bouton correspondant Remplacer ou Remplacer tout. Le bouton Remplacer se trouve également sous l'onglet Accueil. Indiquez les paramètres de recherche en activant les options appropriées: Dans sert à rechercher des données dans la Feuille de calcul active, dans le Classeur entier ou dans une Plage spécifique. Dans ce dernier cas, le champ Sélectionner une plage de données deviendra disponible pour saisir la plage de données nécessaire. Recherche sert à définir la direction de la recherche: à droite dans lignes ou en bas dans colonnes. Rechercher dans sert à spécifier si vous voulez rechercher la Valeur des cellules ou les Formulessous-jacentes. Indiquez les paramètres de recherche en activant les options appropriées en dessous du champ de saisie: Sensible aux caractères sert à passer toutes les occurrences tenant compte de la casse (par exemple, quand vous rechercher le mot «Éditeur», les mots «éditeur» et «ÉDITEUR» ne sont pas affichés). Contenu complet de la cellule sert à rechercher des cellules contenant uniquement les caractères que vous avez indiqué dans votre requête de recherche (par ex. si vous recherchez '56' et cette option est active, les cellules contenant '0.56' ou '156' etc. ne seront pas renvoyées). Toutes les occurrences seront mises en surbrillance dans le fichier et seront affichés sous forme de liste sur le panneau Recherche de gauche. Utilisez la liste pour passer à l'occurrence nécessaire ou utilisez les boutons de navigation et ."
    },
   {
        "id": "HelpfulHints/SpellChecking.htm", 
        "title": "Vérification de l'orthographe", 
        "body": "L'éditeur de classeurs vous permet de vérifier l'orthographe du texte dans une certaine langue et de corriger les erreurs lors de l'édition. Dans la version de bureau, il est également possible d'ajouter des mots dans un dictionnaire personnalisé qui est commun aux trois éditeurs. À partir de la version 6.3, les éditeurs ONLYOFFICE prennent en charge l'interface SharedWorker pour un meilleur fonctionnement en évitant une utilisation élevée de la mémoire. Si votre navigateur ne prend pas en charge SharedWorker, alors c'est seulement Worker qui sera actif. Pour en savoir plus sur SharedWorker, veuillez consulter cette page. Cliquez sur l'icône Vérification de l'orthographe dans la barre latérale gauche pour ouvrir le panneau de vérification orthographique. La cellule supérieure gauche qui contient une valeur de texte mal orthographiée sera automatiquement sélectionnée dans la feuille de calcul actuelle. Le premier mot contenant une erreur sera affiché dans le champ de vérification orthographique, et les mots similaires avec une orthographe correcte apparaîtront dans le champ en-dessous. Utilisez le bouton Passer au mot suivant pour naviguer entre les mots dont l'orthographe est erronée. Remplacer les mots mal orthographiés Pour remplacer le mot sélectionné qui est actuellement mal orthographié par celui suggéré, choisissez l'un des mots similaires suggérés dont l'orthographe est correcte, et utilisez l'option Modification : cliquez sur le bouton Modification, ou cliquez sur la flèche vers le bas à côté du bouton Modification et sélectionnez l'option Modification Le mot actuel sera remplacé et vous passerez au mot suivant mal orthographié. Pour remplacer rapidement tous les mots identiques répétés sur la feuille de calcul, cliquez sur la flèche vers le bas à côté du bouton Modification et sélectionnez l'option Changer tout. Ignorer des mots Pour passer le mot actuel : cliquez sur le bouton Ignorer, ou cliquez sur la flèche vers le bas à côté du bouton Ignorer et sélectionnez l'option Ignorer. Le mot actuel sera ignoré et vous passerez au mot suivant mal orthographié. Pour ignorer tous les mots identiques répétés sur la feuille de calcul, cliquez sur la flèche vers le bas à côté du bouton Ignorer et sélectionnez l'option Ignorer tout. Si le mot actuel manque dans le dictionnaire, vous pouvez l'ajouter au dictionnaire personnalisé à l'aide du bouton Ajouter au dictionnaire dans le panneau de vérification de l'orthographe. Ce mot ne sera pas traité comme une erreur la prochaine fois. Cette option est disponible dans la version de bureau. La Langue du dictionnaire utilisée pour la vérification de l'orthographe s'affiche dans la liste ci-dessous. Vous pouvez le modifier si nécessaire. Une fois que vous avez vérifié tous les mots de la feuille de calcul, le message La vérification de l'orthographe est terminée s'affiche dans le panneau de vérification de l'orthographe. Pour fermer le panneau de vérification de l'orthographe, cliquez sur l'icône de Vérification de l'orthographe dans la barre latérale gauche. Modifier les paramètres de vérification de l'orthographe Pour modifier les paramètres de vérification de l'orthographe, accédez aux paramètres avancés de l'éditeur de feuille de calcul (onglet Fichier -> Paramètres avancés...) et passez à l'onglet Vérification de l'orthographe. Ici, vous pouvez régler les paramètres suivants : Langue du dictionnaire - sélectionnez l'une des langues disponibles dans la liste. La Langue du dictionnaire dans le panneau de vérification de l'orthographe sera modifiée en conséquence. Ignorer les mots en MAJUSCULES - cochez cette option pour ignorer les mots écrits en majuscules, par exemple des acronymes comme SMB. Ignorer les mots contenant des chiffres - cochez cette option pour ignorer les mots contenant des chiffres, p.e. des acronymes comme B2B. Vérification sert à remplacer automatiquement le mot ou le symbole saisi dans le champ Remplacer ou choisi de la liste par un nouveau mot ou symbole du champ Par. Pour sauvegarder les changements que vous avez faits, cliquez sur le bouton Appliquer."
    },
   {
        "id": "HelpfulHints/SupportedFormats.htm", 
        "title": "Formats des classeurs pris en charge", 
        "body": "Un classeur c'est une table de données organisées en lignes et en colonnes. Grâce à la capacité de recalculer automatiquement la feuille toute entière après un changement dans une seule cellule, elle est la plus souvent utilisée pour stocker l'information financière. L'éditeur de classeurs vous permet d'ouvrir et de modifier les formats les plus populaires. Lors du téléchargement ou de l'ouverture d'un fichier, celui-ci sera converti au format Office Open XML (XLSX). Cette conversion permet d'accélérer le traitement des fichiers et d'améliorer l'interopérabilité des données. Le tableau ci-dessous présente les formats de fichiers pour l'affichage et/ou pour l'édition. Formats Description Affichage au format natif Affichage lors de la conversion en OOXML Édition au format natif Édition lors de la conversion en OOXML CSV Valeurs séparées par une virgule Le format de fichier utilisé pour stocker des données tabulaires (des chiffres et du texte) sous forme de texte clair + + ET WPS Spreadsheets Workbook Un format de feuille de calcul inclus dans la suite WPS Office qui prend en charge des graphiques et des formules et organise des données par lignes et par colonnes. + + ETT WPS Spreadsheets Template Un format de feuille de calcul inclus dans la suite WPS Office. Les fichiers ETT sont similaires aux fichiers ET qu'on utilise pour organiser des données par lignes et par colonnes, créer des graphiques mais premièrement pour doubler les classeurs ayant la même disposition et les informations. + + FODS OpenDocument Flat XML Spreadsheet Format de fichier basé sur XML pour sauvegarder et échanger des feuilles de calcul. + + ODS L'extension de fichier pour un classeur utilisé par les suites OpenOffice et StarOffice, un standard ouvert pour les feuilles de calcul. + + OTS Modèle de feuille de calcul OpenDocument Format de fichier OpenDocument pour les modèles de feuilles de calcul. Un modèle OTS contient des paramètres de mise en forme, des styles, etc. et peut être utilisé pour créer plusieurs feuilles de calcul avec la même mise en forme + + SXC Sun XML Calc Un format de classeur basé sur XML qui fait partie de la suite bureautique OpenOffice et prend en charge des formules, des fonctions, des macros. + + XLS L'extension de fichier pour un classeur créé par Microsoft Excel + + XLSX L'extension de fichier par défaut pour un classeur créé par Microsoft Office Excel 2007 (ou la version ultérieure). + + XLTM Un fichier XLTM est une modèle de classeur prenant en charge les macros par Microsoft Excel. + + XLTX Modèle de feuille de calcul Excel Open XML Format de fichier zippé, basé sur XML, développé par Microsoft pour les modèles de feuilles de calcul. U Un modèle XLTX contient des paramètres de mise en forme, des styles, etc. et peut être utilisé pour créer plusieurs classeurs avec la même mise en forme. + + XML Extensible Markup Language (XML) Un format de fichier pour structurer, sauvegarder et transmettre des données. + + Le tableau ci-dessous présente les formats pris en charge pour le téléchargement d'un classeur dans le menu Fichier -> Télécharger comme. Format en entrée Téléchargeable comme CSV JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX ET CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX ETT CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX FODS CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX ODS CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX SXC CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX OTS CSV, JPG, ODS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX XLS CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX XLSM CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSX, XLTM, XLTX XLSX CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLTM, XLTX XLTM CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTX XML CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX Veuillez consulter la matrice de conversion sur api.onlyoffice.com pour vérifier s'il est possible de convertir vos classeurs dans des formats les plus populaires."
    },
   {
        "id": "HelpfulHints/VersionHistory.htm", 
        "title": "Historique des versions", 
        "body": "L'éditeur de classeurs permet de gérer le flux de travail continu par l'ensemble de l'équipe: partager des fichiers et des dossiers, collaborer sur des classeurs en temps réel, communiquer directement depuis l'éditeur, laisser des commentaires pour des fragments du classeur nécessitant la participation d'une tierce personne. Dans l'éditeur de classeurs, vous pouvez afficher l'historique des versions du classeur sur lequel vous collaborez. Afficher l'historique des versions: Pour afficher toutes les modifications apportées au classeur, passez à l'onglet Fichier, sélectionnez l'option Historique des versions sur la barre latérale gauche, ou passez à l'onglet Collaboration, accédez à l'historique des versions en utilisant l'icône Historique des versions de la barre d'outils supérieure. La liste des versions du classeur s'affichera à gauche comportant le nom de l'auteur de chaque version/révision, la date et l'heure de création. Pour les versions de classeur, le numéro de la version est également indiqué (par exemple ver. 2). Afficher la version Pour savoir exactement quelles modifications ont été apportés à chaque version/révision, vous pouvez voir celle qui vous intéresse en cliquant dessus dans la barre latérale de gauche. Les modifications apportées par l'auteur de la version/révision sont marquées avec la couleur d'avatar dans la fenêtre d'historique des versions. Pour revenir à la version actuelle du classeur, cliquez sur Fermer l'historique en haut de le liste des versions. Restaurer une version: Si vous souhaitez restaurer l'une des versions précédentes du classeur, cliquez sur Restaurer au-dessous de la version/révision sélectionnée. Pour en savoir plus sur la gestion des versions et des révisions intermédiaires, et sur la restauration des versions précédentes, veuillez consulter cet article."
    },
   {
        "id": "ProgramInterface/CollaborationTab.htm", 
        "title": "Onglet Collaboration", 
        "body": "L'onglet Collaboration permet d'organiser le travail collaboratif dans l'éditeur de classeurs. Dans l'éditeur en ligne, vous pouvez partager le fichier, sélectionner le mode de co-édition approprié, gérer les commentaires. En mode Commentaires, vous pouvez ajouter et supprimer les commentaires et utiliser le chat. Dans l'éditeur de bureau, vous ne pouvez que gérer des commentaires. L'onglet Collaboration dans l'éditeur de classeurs en ligne: L'onglet Collaboration dans l'éditeur de classeurs de bureau: En utilisant cet onglet, vous pouvez : configurer les paramètres de partage (disponible uniquement dans la version en ligne), basculer entre les modes d'édition collaborative Strict et Rapide (disponible uniquement dans la version en ligne), ajouter et supprimer des commentaires sur une feuille de calcul, ouvrir le panneau de Chat (disponible uniquement dans la version en ligne). suivre l'historique des versions  (disponible uniquement dans la version en ligne),"
    },
   {
        "id": "ProgramInterface/DataTab.htm", 
        "title": "Onglet Données", 
        "body": "L'onglet Données permet de gérer les données dans Spreadsheet Editor. Présentation de la fenêtre de de l'éditeur de classeurs en ligne: Fenêtre de l'éditeur de classeurs de bureau: En utilisant cet onglet, vous pouvez: trier et filtrer les données, transformer texte en colonnes, supprimer les valeurs en double de la plage de données, grouper et dissocier des données, régler les paramètres de validation de données, rechercher la valeur d'entrée appropriée pour le résultat que vous souhaitez obtenir, obtenir les données à partir d'un fichier TXT/CSV, afficher d'autres fichiers auxquels le classer est lié à l'aide du bouton Lien externe."
    },
   {
        "id": "ProgramInterface/DrawTab.htm", 
        "title": "Onglet Dessiner", 
        "body": "L'onglet Dessiner dans l'éditeur de classeurs permet d'effectuer les opérations dessin de base. L'onglet Dessiner dans l'éditeur de classeurs en ligne: L'onglet Dessiner dans l'éditeur de classeurs de bureau: En utilisant cet onglet, vous pouvez: utiliser l'outil de sélection pour redimensionner ou supprimer l'inscription, le dessin et la mise en surbrillance, utiliser l'outil Stylo et Surligneur pour dessiner ou ajouter les notes manuscrites ou la mise en surbrillance, utiliser l'outil Gomme pour effacer le dessin entier ou le texte manuscrit."
    },
   {
        "id": "ProgramInterface/FileTab.htm", 
        "title": "Onglet Fichier", 
        "body": "L'onglet Fichier dans l'éditeur de classeurs permet d'effectuer des opérations essentiels sur le fichier en cours. Fenêtre de l'éditeur de classeurs en ligne: Fenêtre de l'éditeur de classeurs de bureau: En utilisant cet onglet, vous pouvez effectuer les opérations suivantes: créer un nouveau classeur ou ouvrir un classeur récent (disponible dans la version en ligne uniquement), dans la version en ligne, enregistrer le fichier en cours (lorsque l'option Enregistrement automatique est désactivée), télécharger comme (enregistrer le classeur dans le format sélectionné sur votre ordinateur), enregistrer une copie comme (enregistrer le classeur dans le format sélectionné sur votre portail), imprimer ou renommer le fichier, dans la version de bureau, enregistrer le fichier actuel en conservant le format et l'emplacement actuel à l'aide de l'option Enregistrer ou enregistrer le fichier actuel avec un autre nom, emplacement ou format à l'aide de l'option Enregistrer sous, imprimer le fichier actuel. protéger le fichier avec un mot de passe, modifier ou supprimer le mot de passe; protéger un fichier avec une signature numérique (disponible dans la version de bureau uniquement) afficher le descriptif d'un classeur ou modifier les paramètres du fichier, suivre l'historique des versions (disponible dans la version en ligne uniquement), Passer à Documents - dans la version de bureau, ouvrez le dossier dans lequel le fichier est stocké, dans la fenêtre Explorateur de fichiers, dans la version en ligne, ouvrez le dossier du module Documents, dans lequel le fichier est stocké, sous un nouvel onglet du navigateur, accéder aux Paramètres avancés de l'éditeur, Aide - accéder au centre d'aide intégré."
    },
   {
        "id": "ProgramInterface/FormulaTab.htm", 
        "title": "L'onglet Formule", 
        "body": "L'onglet Formule dans l'éditeur de classeurs permet d'utiliser facilement toutes les fonctions. Présentation de la fenêtre de de l'éditeur de classeurs en ligne: Fenêtre de l'éditeur de classeurs de bureau: En utilisant cet onglet, vous pouvez: insérer des fonctions en utilisant la boîte de dialogue Insérer une fonction, accéder rapidement aux formules Somme automatique, accéder 10 formules qu'on a récemment utilisé, travailler sur des formules classifiées par catégories, travailler sur plages nommées, tracer des précédents et des dépendants, afficher la formule dans la cellule au lieu du résultat, utiliser la Fenêtre Espions, utiliser les options de calcul: calculer le classeur entier ou uniquement la feuille de calcul actuelle."
    },
   {
        "id": "ProgramInterface/HomeTab.htm", 
        "title": "Onglet Accueil", 
        "body": "L'onglet Accueil s'affiche par défaut lorsqu'on ouvre l'éditeur de classeurs. Sous cet onglet vous pouvez mettre en forme des cellules et des données, appliquer des filtres, insérer des fonctions etc. D'autres options sont également disponibles ici telles que Mettre sous forme de modèle de tableau et ainsi de suite. Fenêtre de l'éditeur de classeurs en ligne: Fenêtre de l'éditeur de classeurs de bureau: En utilisant cet onglet, vous pouvez: définir le type, la taille, le style et la couleur de la police, aligner des donnéesdans des cellules, ajouter des bordures de cellules et fusionner des cellules, insérer de fonctions et créer des plages nommées, utiliser l'outil Série pour remplir les plages avec les données, trier et filtrer les données, modifier le format de nombre, ajouter ou supprimer des lignes et des colonnes, copier/effacer la mise en forme d'une cellule, utiliser la mise en forme conditionnelle, appliquez un modèle de table à une plage de cellules sélectionnée."
    },
   {
        "id": "ProgramInterface/InsertTab.htm", 
        "title": "Onglet Insertion", 
        "body": "L'onglet Insertion permet d'insérer des objets visuels et des commentaires à partir de l'éditeur de classeurs. Fenêtre de l'éditeur de classeurs en ligne: Fenêtre de l'éditeur de classeurs de bureau: En utilisant cet onglet, vous pouvez: insérer des tableaux croisés dynamiques, insérer des tableaux mis en forme, insérer des images, des formes, des zones de texte et des objets Text Art, des graphiques SmartArt, insérer des graphiques recommandés, des graphiques, des graphiques sparkline, insérer des commentaires et des liens hypertexte, Insérer des en-têtes/pieds de page, insérer des équations et des symboles, insérer des segments."
    },
   {
        "id": "ProgramInterface/LayoutTab.htm", 
        "title": "Onglet Mise en page", 
        "body": "L'onglet Mise en page dans l'éditeur de classeurs permet de modifier l'apparence de la feuille de calcul: configurer les paramètres de la page et définir la mise en page des éléments visuels. Fenêtre de l'éditeur de classeurs en ligne: Fenêtre de l'éditeur de classeurs de bureau: En utilisant cet onglet, vous pouvez: paramétrer les marges, l'orientation et la taille de la page, indiquer la zone d'impression, Insérer des sauts de page, Insérer des en-têtes et des pieds de page, mettre à l'échelle une feuille de calcul, modifier l'orientation de la feuille de calcul pour que la première colonne soit sur le côté gauche utilisant le bouton Feuille de droite à gauche, imprimer les titres sur une page, aligner et organiser des objets (images, graphiques, formes), modifier le jeu de couleurs."
    },
   {
        "id": "ProgramInterface/PivotTableTab.htm", 
        "title": "L'onglet Tableau croisé dynamique", 
        "body": "L'onglet Tableau croisé dynamique dans l'éditeur de classeurs permet de créer et modifier des tableaux croisés dynamiques. À partir de la version 8.2 d'ONLYOFFICE Docs, l'onglet Tableau croisé dynamique est masqué par défaut et ne s'affiche que si on travaille sur des tableaux croisés dynamiques. Fenêtre de l'éditeur de classeurs en ligne: Fenêtre de l'éditeur de classeurs de bureau: En utilisant cet onglet, vous pouvez: créer un nouveau tableau croisé dynamique, sélectionner la mise en page nécessaire pour votre tableau croisé dynamique, mettre à jour le tableau croisé dynamique lors de la modification des données dans l'ensemble de données sources, sélectionner le tableau croisé dynamique entier en un seul clic, développer ou réduire les champs pour afficher/masquer les détails des éléments du tableau croisé dynamique, mettre en surbrillance certaines lignes/colonnes en utilisant un style pour la mise en forme, choisir l'un des styles de tableau prédéfinis."
    },
   {
        "id": "ProgramInterface/PluginsTab.htm", 
        "title": "Onglet Modules complémentaires", 
        "body": "L'onglet Modules complémentaires dans l'éditeur de classeurs permet d'accéder à des fonctions d'édition avancées à l'aide de composants tiers disponibles. Fenêtre de l'éditeur de classeurs en ligne: Fenêtre de l'éditeur de classeurs de bureau: Le bouton Gestionnaire de plugins permet d'ouvrir la fenêtre où vous pouvez visualiser et gérer toutes les extensions installées et ajouter vos propres modules. Le bouton Modules d'arrière-plan permet d'afficher la liste des modules complémentaires exécutés en arrière-plan. Dans la liste déroulante, vous pouvez activer ou désactiver les modules complémentaires à l'aide de sélecteurs appropriés et configurer les paramètres en cliquant sur le bouton Paramètres à côté du module complémentaire nécessaire. À partir de la version 8.2 ONLYOFFICE Docs, aucun module complémentaire n'est inclus dans l'éditeur par défaut. Il faut installer des modules complémentaires à l'aide du Gestionnaire de plugins. Actuellement, les modules suivants sont disponibles: Envoyer permet d'envoyer le classeur par e-mail à l'aide d'un client de messagerie installé sur votre ordinateur (disponible en version de bureau seulement), Code en surbrillance sert à surligner la syntaxe du code en sélectionnant la langue, le style, la couleur de fond approprié etc., Éditeur de photos sert à modifier les images: rogner, retourner, pivoter, dessiner les lignes et le formes, ajouter des icônes et du texte, charger l'image de masque et appliquer des filtres comme Niveaux de gris, Inverser, Sépia, Flou, Embosser, Affûter etc., Thésaurus sert à trouver les synonymes et les antonymes et les utiliser à remplacer le mot sélectionné, Traducteur sert à traduire le texte sélectionné dans des langues disponibles, Remarque: ce module complémentaire ne fonctionne pas sur Internet Explorer. You Tube permet d'ajouter les videos YouTube dans votre classeur. Il est possible d'ajouter plusieurs modules complémentaires graphiques à votre document. Une fois ajouté, le module complémentaire s'affichera sous forme d'une icône appropriée sur le panneau de gauche. Pour en savoir plus sur les modules complémentaires, veuillez vous référer à la documentation de notre API. Tous les exemples de modules open source actuels sont disponibles sur GitHub."
    },
   {
        "id": "ProgramInterface/ProgramInterface.htm", 
        "title": "Présentation de l'interface utilisateur de l'éditeur de classeurs", 
        "body": "L'éditeur de classeurs utilise une interface à onglets dans laquelle les commandes d'édition sont regroupées en onglets par fonctionnalité. Fenêtre principale de l'éditeur de classeurs en ligne: Fenêtre principale de l'éditeur de bureau: L'interface de l'éditeur est composée des éléments principaux suivants: L'en-tête de l'éditeur affiche le logo, les onglets de classeurs ouverts, et leurs noms, et les onglets de menu. Dans la partie gauche de l'en-tête de l'éditeur se trouvent les boutons Enregistrer, Imprimer le fichier, Annuler et Rétablir. Cliquez sur l'icône points de suspension à droite pour personnaliser les boutons à masquer, le cas échéant. Dans la partie droite de l'en-tête de l'éditeur, le nom de l'utilisateur est affiché ainsi que les icônes suivantes: Ouvrir l'emplacement de fichier - dans la version de bureau, permet d'ouvrir le dossier où le fichier est stocké, dans la fenêtre Explorateur de fichiers. Dans la version en ligne, elle permet d'ouvrir le dossier du module Documents où le fichier est stocké dans un nouvel onglet du navigateur. Partager - (disponible uniquement dans la version en ligne) permet de définir les droits d'accès aux documents stockés dans le cloud. Marquer en tant que favori - cliquez sur l'étoile pour ajouter le fichier aux favoris et pour le retrouver rapidement. Ce n'est qu'un fichier de raccourcis car le fichier lui-même est dans l'emplacement de stockage d'origine. Le fichier réel n'est pas supprimé quand vous le supprimez de Favoris. Rechercher - permet de rechercher un mot ou symbole dans un classeur. La barre d'outils supérieure affiche un ensemble de commandes d'édition en fonction de l'onglet de menu sélectionné. Actuellement, les onglets suivants sont disponibles: Fichier, Accueil, Insertion, Dessine, Mise en page, Formule, Données, Tableau croisé dynamique, Collaboration, Protection, Affichage, Modules complémentaires. Les options Copier, Coller, Couper et Copier le style sont toujours disponibles dans la partie gauche de la Barre d'outils supérieure quel que soit l'onglet sélectionné. Le bouton Sélectionner tout se trouve dans la partie gauche de la Barre d'outils supérieure sous l'onglet Accueil. La Barre de formule permet d'entrer et de modifier des formules ou des valeurs dans les cellules. La Barre de formule affiche le contenu de la cellule actuellement sélectionnée. La Barre d'état en bas de la fenêtre de l'éditeur contient des outils de navigation: boutons de navigation de feuille, bouton pour ajouter une feuille de calcul, bouton de la liste des feuilles de calcul, onglets de feuilles de calcul et boutons de zoom. La Barre d'état affiche également l'état d'enregistrement en arrière-plan et l'état de connexion lorsqu'il n'y a pas de connexion et l'éditeur tente de se connecter, le nombre d'enregistrements filtrés si un filtre est appliqué, ou des résultats des calculs automatiques si vous sélectionnez plusieurs cellules contenant des données. La barre latérale gauche contient les icônes suivantes: - permet d'utiliser l'outil Rechercher et remplacer, - permet d'ouvrir le panneau Commentaires, - (disponible uniquement dans la version en ligne ) permet d'ouvrir le panneau Chat, - permet de vérifier l'orthographe du texte dans une certaine langue et de corriger les erreurs lors de l'édition, - permet de contacter notre équipe d'assistance technique, - (disponible dans la version en ligne seulement) permet d'afficher les informations sur le programme. La barre latérale droite permet d'ajuster les paramètres supplémentaires de différents objets. Lorsque vous sélectionnez un objet particulier sur une feuille de calcul, l'icône correspondante est activée dans la barre latérale droite. Cliquez sur cette icône pour développer la barre latérale droite. La Zone de travail permet d'afficher le contenu du classeur, d'entrer et de modifier les données. Les Barres de défilement horizontales et verticales permettent de faire défiler la feuille actuelle de haut en bas ou de gauche à droite. Pour plus de commodité, vous pouvez masquer certains composants et les afficher à nouveau lorsque cela est nécessaire. Pour en savoir plus sur l'ajustement des paramètres d'affichage, reportez-vous à cette page. Lorsqu'il y a plusieurs icônes sur les panneaux de droit et de gauche, celles d'en dessous seront masquées et on peut les utiliser en cliquant sur le bouton Plus."
    },
   {
        "id": "ProgramInterface/ProtectionTab.htm", 
        "title": "Onglet Protection", 
        "body": "L'onglet Protection dans l'éditeur de classeurs permet d'empêcher tout accès non autorisé en utilisant le chiffrement ou la protection au niveau du classeur ou au niveau de la feuille de calcul. L'onglet Protection dans l'éditeur de classeurs en ligne: L'onglet Protection dans l'éditeur de classeurs de bureau: En utilisant cet onglet, vous pouvez: Chiffrer votre document en définissant un mot de passe, Protéger le classeur avec ou sans un mot de passe afin de protéger sa structure, Protéger la feuille de calcul en limitant les possibilités de modification dans une feuille de calcul avec ou sans un mot de passe, Activer et désactiver les options suivantes: Cellule verrouillée, Formules cachées, Forme verrouillé, Verrouiller le texte. Protéger la plage pour protéger les plages et limiter ou interdire l'édition."
    },
   {
        "id": "ProgramInterface/ViewTab.htm", 
        "title": "Onglet Affichage", 
        "body": "L'onglet Affichage dans l'éditeur de classeurs permet de configurer différents paramètres d'affichage de la feuille de calcul en fonction du filtre appliqué et des options d'affichage activées. L'onglet Affichage dans l'éditeur de classeurs en ligne: L'onglet Affichage dans l'éditeur de classeurs de bureau: Les options d'affichage disponibles sous cet onglet: Afficher une feuille permet configurer les paramètres d'affichage de feuille. Normal permet d'afficher la feuille de calcul entière. Aperçu des sauts de page permet d'afficher iniquement la zone d'impression d'une feuille de calcul. Zoom permet de zoomer et dézoomer sur une feuille de calcul. Thème d'interface permet de modifier le thème d'interface en choisissant le thème Identique à système, Clair, Classique clair, Sombre ou Contraste élevé sombre. Figer les volets permet de figer et libérer des certains volets ou des lignes et des colonnes. Les options suivantes permettent de choisir les éléments à afficher ou à cacher. Cachez les cases appropriées aux éléments que vous souhaitez rendre visible: Barre de formule permet d'afficher la barre de formule au dessus du classeur. E-têtes permet d'afficher des en-têtes, c-à-d des en-têtes des colonnes en haut et des en-têtes des lignes à gauche de la feuille de calcul. Quadrillage permet d'afficher les lignes de quadrillage, c-à-d les bordures des cellules. Afficher les zéros permet d'afficher 0 lors de la saisie dans une cellule. Toujours afficher la barre d'outils permet de rendre visible la barre d'outils supérieure. Combiner la barre de la feuille et la barre d'état permet d'afficher des outils de navigation dans la feuille de calcul et la barre d'état sur une seule ligne. Une fois désactivée, la barre d'état s'affichera sur deux lignes. Panneau gauche permet de rendre visible le panneau gauche. Panneau droit permet de rendre visible le panneau droit."
    },
   {
        "id": "UsageInstructions/AddBorders.htm", 
        "title": "Ajouter des bordures et l'arrière-plan d'une cellule", 
        "body": "Ajouter l'arrière-plan d'une cellule Pour ajouter et mettre en forme l'arrière-plan d'une cellule dans l'éditeur de classeurs, sélectionnez une cellule ou une plage de cellules avec la souris ou la feuille de calcul entière en appuyant Ctrl+A sur le clavier, Remarque: vous pouvez également sélectionner plusieurs cellules ou plages non adjacentes en maintenant la touche Ctrl enfoncée tout en sélectionnant les cellules/plages à l'aide de la souris. pour remplir la cellule avec une couleur unie, cliquez sur l'icône Couleur d'arrière plan sous l'onglet Accueil de la barre d'outil supérieure et sélectionnez la couleur appropriée. pour utiliser d'autres options de remplissage telles que remplissage en dégradé ou modèle, cliquez sur l'icône Paramètres de cellule de la barre latérale droite et sélectionnez la section Remplissage: Couleur de remplissage - sélectionnez cette option pour spécifier la couleur unie à utiliser pour remplir les cellules sélectionnées. Cliquez sur la case de couleur et sélectionnez une des palettes: Couleurs de thème - les couleurs qui correspondent à la palette de couleurs sélectionnée de la feuille de calcul. Couleurs standard - le jeu de couleurs par défaut. Le jeu de couleurs sélectionnée ne les affecte pas. Il y a deux façons d'appliquer une couleur personnalisée: Pipette - sert à sélectionner la couleur nécessaire en cliquant sur celle-ci dans la feuille de calcul. Plus de couleurs sert à rechercher la couleur manquante dans la palette. Sélectionnez la gamme de couleurs nécessaire en déplaçant le curseur vertical et définissez la couleur spécifique en faisant glisser le sélecteur de couleur dans le grand champ de couleur carré. Une fois que vous sélectionnez une couleur avec le sélecteur de couleur, les valeurs de couleur appropriées RGB et sRGB seront affichées dans les champs à droite. Vous pouvez également spécifier une couleur sur la base du modèle de couleur RGB en entrant les valeurs numériques nécessaires dans les champs R, G, B (rouge, vert, bleu) ou saisir le code hexadécimal dans le champ sRGB marqué par le signe #. La couleur sélectionnée apparaît dans la case de prévisualisation Nouveau. Si l'objet a déjà été rempli d'une couleur personnalisée, cette couleur sera affichée dans la case Actuel que vous puissiez comparer les couleurs originales et modifiées. Lorsque la couleur est spécifiée, cliquez sur le bouton Ajouter: La couleur personnalisée sera appliquée à l'élément sélectionné et sera ajoutée dans la palette Couleurs récentes. Remplissage en dégradé - remplir les cellules sélectionnées avec deux couleurs et une transition en douceur appliquée. Angle - spécifiez manuellement l'angle précis de la direction du dégradé (transition se fait en ligne de dégradé sous un certain angle). Direction - choisissez un modèle prédéfini du menu. Les directions disponibles: du haut à gauche vers le bas à droite (45°), de haut en bas (90°), du haut à droite vers le bas à gauche (135°), de droite à gauche (180°), du bas à droite vers le haut à gauche (225°), du bas en haut (270°), du bas à gauche vers le haut à droite (315°), de gauche à droite (0°). Point de dégradé est le point d'arrêt de d'une couleur et de la transition entre les couleurs. Utilisez le bouton Ajouter un point de dégradé ou le curseur de dégradé pour ajouter un point de dégradé. Vous pouvez ajouter 10 points de dégradé. Le nouveau arrêt de couleur n'affecte pas l'aspect actuel du dégradé. Utilisez le bouton Supprimer un point de dégradé pour supprimer un certain point de dégradé. Faites glisser le curseur de déragé pour changer l'emplacement des points de dégradé ou spécifiez la Position en pourcentage pour l'emplacement plus précis. Pour choisir la couleur au dégradé, cliquez sur l'arrêt concerné sur le curseur de dégradé, ensuite cliquez sur Couleur pour sélectionner la couleur appropriée. Modèle - sélectionnez cette option pour remplir la cellule sélectionnée avec un modèle à deux couleurs composé des éléments répétés. Modèle - sélectionnez un des modèles prédéfinis du menu. Couleur de premier plan - cliquez sur cette palette de couleurs pour changer la couleur des éléments du modèle. Couleur d'arrière-plan - cliquez sur cette palette de couleurs pour changer de l'arrière-plan du modèle. Pas de remplissage - sélectionnez cette option si vous ne voulez pas utiliser un remplissage. Ajouter des bordures Pour ajouter et mettre en forme des bordures dans une feuille de calcul, sélectionnez une cellule, une plage de cellules avec la souris ou la feuille de calcul entière en utilisant le raccourci clavier Ctrl+A, Remarque: vous pouvez également sélectionner plusieurs cellules ou plages non adjacentes en maintenant la touche Ctrl enfoncée tout en sélectionnant les cellules/plages à l'aide de la souris. cliquez sur l'icône Bordures sous l'onglet Accueil de la barre d'outil supérieure ou cliquez sur l'icône Paramètres de cellule de la barre latérale droite et utilisez la section Style des bordures, sélectionnez le style de bordure à ajouter: ouvrez le sous-menu Style des bordures et sélectionnez l'une des options disponibles, ouvrez le sous-menu Couleur de bordure ou utilisez la palette de Couleur de la barre latérale droite et sélectionnez la couleur nécessaire dans la palette. sélectionnez l'un des modèles de bordure disponibles: Bordures extérieures, Toutes les bordures, Bordures supérieures, Bordures inférieures, Bordures gauches, Bordures droites, Aucune bordure, Bordures intérieures, Bordures intérieures verticales, Bordures intérieures horizontales, Bordure diagonale ascendante, Bordure diagonale descendante ."
    },
   {
        "id": "UsageInstructions/AddExternalLinks.htm", 
        "title": "Ajouter des liens externes vers des cellules", 
        "body": "Dans l'éditeur de classeurs, il est possible de créer un lien externe vers une cellule ou une plage de cellules d'un autre classeur. C'est possible de créer des liens externes entre les fichiers stockés sur le portail actuel (depuis l'éditeur en ligne) ou sur l'ordinateur (depuis l'éditeur du bureau). Lors de la modification de données dans le classeur source, vous pouvez actualiser les données dans le classeur de destination sans les copier manuellement encore une fois. Pour ajouter un lien externe, ouvrez le classeur source et le classeur de destination, dans le classeur source, copiez la cellule ou la plage de cellules (Ctrl+C), dans le classeur de destination, collez les données copiés (Ctrl+V), cliquez sur le bouton Collage spécial et sélectionnez l'option Coller avec liaison (Ctrl+N). La liaison sera crée. Lorsque vous cliquez sur la cellule comportant un lien externe, cette cellule s'affiche dans la barre de formule ainsi: ='[SourceWorkbook.xlsx]Sheet1'!A1. Pour actualiser les liens externes que vous avez ajouté, passez à l'onglet Données, cliquez sur le bouton Liens externes, sélectionnez le lien nécessaire de la liste, cliquez sur Mettre à jour les valeurs ou cliquez sur la flèche à côté et sélectionnez Mettre à jour les valeurs (l'option sélectionnée actuellement) ou Tout mettre à jour. L'état va devenir OK. Un avertissement s'affichera lorsque vous ouvrez le classeur comportant les liens externes: Cliquez sur Mettre à jour pour actualiser tous les liens externes. Pour rompre la liaison, passez à l'onglet Données, cliquez sur le bouton Liens externes, sélectionnez le lien nécessaire de la liste, cliquez sur Rompre les liaisons ou cliquez sur la flèche à côté de ce bouton pour sélectionner Rompre les valeurs (l'option sélectionnée actuellement) ou Rompre toutes les liaisons. Les liaisons seront rompus et les valeurs ne seront pas actualisées."
    },
   {
        "id": "UsageInstructions/AddHyperlinks.htm", 
        "title": "Ajouter des liens hypertextes", 
        "body": "Pour insérer un lien hypertexte dans l'éditeur de classeurs, sélectionnez une cellule où un lien hypertexte sera ajouté, passez à l'onglet Insertion de la barre d'outils supérieure, cliquez sur l'icône Lien hypertexte de la barre d'outils supérieure, la fenêtre Paramètres du lien hypertexte s'affiche où vous pouvez configurer les paramètres du lien hypertexte: Sélectionnez le type de lien que vous voulez ajouter: Utilisez l'option Lien externe et entrez une URL au format http://www.example.com dans le champ Lien vers ci-dessous si vous avez besoin d'ajouter un lien hypertexte menant vers un site externe. S'il vous faut ajouter un lien hypertexte vers un fichier local, saisissez l'URL au format file://path/Spreadsheet.xlsx (pour Windows) ou file:///path/Spreadsheet.xlsx (pour MacOS et Linux) dans le champ Lien vers. Il est possible d'ouvrir le lien hypertexte du type file://path/Spreadsheet.xlsx ou file:///path/Spreadsheet.xlsx uniquement dans l'éditeur de bureau. Dans l'éditeur web, vous ne pouvez qu'ajouter le lien sans pouvoir l'ouvrir. Utilisez l'option Plage de données interne et sélectionnez une feuille et une plage dans les champs ci-dessous, ou une Plage nommée existante si vous avez besoin d'ajouter un lien hypertexte menant à une plage de cellules dans le même classeur. Il est également possible de générer un lien externe vers une cellule ou une plage de cellules en cliquant sur le bouton Obtenir un lien ou en utilisant l'option Obtenir le lien vers cette plage dans le menu contextuel de la plage de cellules nécessaire. L'option Obtenir le lien vers cette plage est également disponible en mode d'affichage. Afficher - saisissez le texte qui devient automatiquement cliquable renvoyant vers l'adresse spécifiée ci-dessus: Remarque: si la cellule sélectionnée contient déjà des données, elles seront automatiquement affichées dans ce champ. Texte de l'info-bulle - entrez un texte qui sera visible dans une petite fenêtre contextuelle offrant une courte note ou étiquette lorsque vous placez le curseur sur un lien hypertexte. cliquez sur OK. Pour ajouter un lien hypertexte, vous pouvez également utiliser la combinaison des touches Ctrl+K ou cliquer avec le bouton droit à l'emplacement choisi et sélectionner l'option Lien hypertexte du menu contextuel. Si vous placez le curseur sur le lien hypertexte ajouté, vous allez voir le texte de l'info-bulle spécifié. Pour suivre le lien, cliquez sur le lien dans votre feuille de calcul. Pour sélectionner une cellule qui contient un lien sans ouvrir le lien, cliquez et maintenez le bouton de la souris enfoncé. Pour supprimer le lien hypertexte ajouté, activez la cellule contenant le lien hypertexte ajouté et appuyez sur la touche Suppr ou cliquez avec le bouton droit sur la cellule et sélectionnez l'option Effacer tout dans la liste déroulante."
    },
   {
        "id": "UsageInstructions/AlignText.htm", 
        "title": "Aligner les données dans une cellule", 
        "body": "Dans l'éditeur de classeurs vous pouvez aligner vos données horizontalement ou verticalement ou même les faire pivoter dans une cellule. Sélectionnez une cellule ou une plage de cellules avec la souris ou la feuille de calcul entière en appuyant Ctrl+A sur le clavier, Remarque : vous pouvez également sélectionner plusieurs cellules ou plages non adjacentes en maintenant la touche Ctrl enfoncée tout en sélectionnant les cellules/plages à l'aide de la souris. Remarque : vous pouvez mettre en forme du texte à l'aide des icônes sous l'onglet Accueil de la barre d'outils supérieure. Appliquez l'une des options d'alignement horizontal dans la cellule, cliquez sur l'icône Aligner à gauche pour aligner les données sur le bord gauche de la cellule (le bord droit reste non aligné) ; cliquez sur l'icône Aligner au centre pour aligner les données par le centre de la cellule (les bords droit et gauche restent non alignés) ; cliquez sur l'icône Aligner à droite pour aligner les données sur le bord droit de la cellule (le bord gauche reste non aligné) ; cliquez sur l'icône Justifié pour aligner vos données sur le bord gauche et droit de la cellule (un espacement supplémentaire est ajouté si nécessaire pour garder l'alignement). Changez l'alignement vertical des données dans la cellule, cliquez sur l'icône Aligner en haut pour aligner vos données sur le bord supérieur de la cellule ; cliquez sur l'icône Aligner au milieu pour aligner vos données au milieu de la cellule ; cliquez sur l'icône Aligner en bas pour aligner vos données sur le bord inférieur de la cellule. Changez l'angle des données en cliquant sur l'icône Orientation et en choisissant l'une des options : utilisez l'option Texte horizontal pour positionner le texte à l'horizontale (par défaut), utilisez l'option Rotation dans le sens inverse des aiguilles d'une montre pour positionner le texte du coin inférieur gauche au coin supérieur droit d'une cellule, utilisez l'option Rotation dans le sens des aiguilles d'une montre pour positionner le texte du coin supérieur gauche au coin inférieur droit d'une cellule, utilisez l'option Texte vertical pour positionner le texte verticalement, utilisez l'option Rotation du texte vers le haut pour positionner le texte de bas en haut d'une cellule, utilisez l'option Rotation du texte vers le bas pour positionner le texte de haut en bas d'une cellule. Appliquez un retrait au contenu d'une cellule à l'aide de la section Retrait sur la barre latérale droite Paramètres de cellule. Définissez la valeur (c'est-à-dire le nombre de caractères) de déplacer le contenu de cellule à droite. Les retraits sont réinitialisés lorsque vous modifier l'orientation du texte. Lorsque vous modifiez les retraits du texte pivoté, l'orientation du texte est réinitialisée. Il est possible de définir les retraits seulement si le texte est orienté horizontalement ou verticalement. Pour faire pivoter le texte selon un angle exactement spécifié, cliquez sur l'icône Paramètres de cellule dans la barre latérale de droite et utilisez l'Orientation. Entrez la valeur souhaitée mesurée en degrés dans le champ Angle ou réglez-la à l'aide des flèches situées à droite. Adaptez vos données à la largeur de la colonne en cliquant sur l'icône Renvoyer à la ligne automatiquement sous l'onglet Accueil de la barre d'outil supérieure ou en activant la case à cocher Renvoyer à la ligne automatiquement sur la barre latérale droite. Si vous modifiez la largeur de la colonne, les données seront automatiquement ajustées en conséquence. Adaptez vos données à la largeur de la cellule en activant Réduire pour ajuster sur la barre latérale droite. Le contenu de la cellule est réduit pour s'adapter à la largeur de la cellule."
    },
   {
        "id": "UsageInstructions/ChangeNumberFormat.htm", 
        "title": "Modifier le format de nombre", 
        "body": "Appliquer un format de nombre Dans l'éditeur de classeurs, vous pouvez facilement modifier le format de nombre, c'est à dire l'apparence d'un nombre saisi dans votre feuille de calcul. Pour ce faire, sélectionnez une cellule, une plage de cellules avec la souris ou la feuille de calcul entière en utilisant la combinaison de touches Ctrl+A, Remarque: vous pouvez également sélectionner plusieurs cellules ou plages non adjacentes en maintenant la touche Ctrl enfoncée tout en sélectionnant les cellules/plages à l'aide de la souris. faites dérouler la liste Format de nombre située dans l'onglet Accueil de la barre d'outils supérieure ou cliquez avec le bouton droit sur les cellules sélectionnées et utilisez l'option Format de nombre du menu contextuel. Sélectionnez le format de nombre approprié: Général sert à afficher les données saisies en tant que nombres standards de façon la plus compacte, sans aucun signe supplémentaire, Nombre sert à afficher les nombres avec 0-30 chiffres après le point décimal où un séparateur de milliers ajouté entre chaque groupe de trois chiffres avant le point décimal, Scientifique (exponentiel) sert à exprimer le nombre sous la forme d.dddE+ddd ou d.dddE-ddd où chaque d c'est un chiffre de 0 à 9, Comptabilité - est utilisé pour afficher les valeurs monétaires avec le symbole monétaire par défaut et deux décimales. Pour appliquer un autre symbole monétaire ou nombre de décimales, suivez les instructions ci-dessous. Contrairement au format Devise, le format Comptabilité aligne les symboles monétaires sur le côté gauche de la cellule, représente les valeurs nulles sous forme de tirets et affiche les valeurs négatives entre parenthèses. Remarque: pour appliquer rapidement le format Comptabilité aux données sélectionnées, vous pouvez également cliquer sur l'icône Style comptable sous l'onglet Accueil de la barre d'outils supérieure et sélectionnez le symbole de devise approprié parmi les symboles monétaires suivants: &#36; Dollar, &euro; Euro,&pound Livre Sterling, &#8381; Rouble, &yen Yen, kn Kuna Croate. Monétaire - est utilisé pour afficher les valeurs monétaires avec le symbole monétaire par défaut et deux décimales. Pour appliquer un autre symbole monétaire ou nombre de décimales, suivez les instructions ci-dessous. Contrairement au format Comptabilité, le format Monétaire place un symbole de devise directement avant le premier chiffre et affiche des valeurs négatives avec le signe négatif (-). Date courte sert à afficher la date au format DD.MM.YYYY, Date longue sert à afficher la date au format DD.month in full.YYYY; Heure - est utilisé pour afficher les heures, Pourcentage sert à afficher les données en pourcentage avec un symbole de pourcentage %, Remarque: pour ajouter rapidement un symbole de pourcentage à vos données vous pouvez également utiliser l'icône Style de pourcentage sous l'onglet Accueil sur la barre d'outils supérieure. Fraction sert à afficher les nombres comme des fractions usuelles plutôt que des nombres décimaux. Texte sert à afficher les valeurs numériques qui sont traitées comme du texte simple avec la plus grande précision disponible. Autres formats - est utilisé pour créer un format de nombre personnalisé ou personnaliser les formats de nombres déjà appliqués en spécifiant des paramètres supplémentaires (voir la description ci-dessous). Personnalisé sert à créer le format personnalisé: sélectionnez une cellule, une plage de cellules ou la feuille de calcul entière contenant les valeurs à mettre en forme, sélectionnez l'option Personnalisé dans le menu Autre formats: saisissez les codes appropriés et vérifiez le résultat dans la zone d'aperçu ou choisissez un modèle et/ou combinez-les. Si vous voulez créer un format d'après un modèle, appliquez donc un format existant et modifiez-le selon votre préférence. cliquez sur OK. modifiez le nombre de décimales, si nécessaire: utilisez l'icône Ajouter une décimale sous l'onglet Accueil de la barre d'outils supérieure pour afficher plus de chiffres après la virgule, utilisez l'icône Réduire les décimales sous l'onglet Accueil de la barre d'outils supérieure pour afficher moins de chiffres après la virgule, utilisez l'icône Style de virgule sous l'onglet Accueil de la barre d'outils supérieure pour afficher plus de chiffres avec deux décimales et virgule comme séparateur de milliers. Remarque: pour modifier le format de nombre, vous pouvez aussi se servir des raccourcis clavier. Personnaliser un format de nombre Vous pouvez personnaliser le format numérique appliqué de la manière suivante: sélectionnez les cellules pour lesquelles vous souhaitez personnaliser le format de nombre, faites dérouler la liste Format de nombre sous l'onglet Accueil de la barre d'outils supérieure ou cliquez avec le bouton droit sur les cellules sélectionnées et utilisez l'option Format de nombre du menu contextuel. sélectionnez l'option Autres formats, Dans la fenêtre Format de nombre qui s'ouvre, ajustez les paramètres disponibles. Les options diffèrent en fonction du format numérique appliqué aux cellules sélectionnées. Vous pouvez utiliser la liste Catégorie pour modifier le format numérique. Pour le format Nombre, vous pouvez définir le nombre de Décimales, spécifier si vous souhaitez Utiliser le séparateur de milliers ou non et choisir l'un des Formats disponibles pour l'affichage des valeurs négatives. Pour les formats Scientifique et Pourcentage, vous pouvez définir le nombre de Décimales. Pour les formats Comptabilité et Monétaire, vous pouvez définir le nombre de Décimales, choisir l'un des Symboles de devise disponibles et l'un des Formats disponibles pour afficher les valeurs négatives. Pour le format Date, vous pouvez sélectionner l'un des formats de date disponibles: 4/15, 04/15, 4/15/06, 04/15/06, 4/15/2006, 04/15/2006, 4/15/06 0:00, 04/15/06 0:00, 4/15/06 12:00 AM, A, Avril15 2006, 15-Avr, 15-Avr-06, Avr-06, Avril-06, A-06, 06-Avr, 15-Avr-2006, 2006-Avr-15, 06-Avr-15, 06-4-15, 06-04-15, 2006-4-15, 2006-04-15, 15/Avr, 15/Avr/06, Avr/06, Avril/06, A/06, 06/Avr, 15/Avr/2006, 2006/Avr/15, 06/Avr/15, 06/4/15, 06/04/15, 2006/4/15, 2006/04/15, 15 Avr, 15 Avr 06, Avr 06, Avril 06, A 06, 06 Avr, 15 Avr 2006, 2006 Avr 15, 06 Avr 15, 06 4 15, 06 04 15, 2006 4 15, 2006 04 15. Pour le format Heure, vous pouvez sélectionner l'un des formats d'heure disponibles: 12:48:58 PM, 12:48, 12:48 PM, 12:48:58, 48:57.6, 36:48:58. Pour le format Fraction, vous pouvez sélectionner l'un des formats disponibles: D'un chiffre (1/3), De deux chiffres (12/25), De trois chiffres (131/135), Demis (1/2), Quarts (2/4), Huitièmes (4/8), Seizièmes (8/16), Dixièmes (5/10), Centièmes (50/100). cliquez sur le bouton OK pour valider les modifications."
    },
   {
        "id": "UsageInstructions/ChatGPT.htm", 
        "title": "ChatGPT", 
        "body": "Le module complémentaire ChatGPT permet d'utiliser l'agent conversationnel OpenAI pour effectuer les tâches visant à comprendre et à générer le langage naturel ou le code. À partir de la version 8.2 ONLYOFFICE Docs, aucun module complémentaire n'est inclus dans l'éditeur par défaut. Il faut installer des modules complémentaires à l'aide du Gestionnaire de plugins. Installation Pour installer le module complémentaire ChatGPT, Passez à l'onglet Modules complémentaires. Ouvrez le Gestionnaire de plugins. Rechercher ChatGPT sur marketplace et cliquez sur le bouton Installer au-dessous. Faites un clic droit n'importe où dans le document et recherchez ChatGPT dans le menu contextuel. Cliquez sur Réglages et poursuivez la configuration du module complémentaire. Configuration Créez votre clé API sur la page OpenAI API key. Copiez la clé API que vous avez généré dans le champ correspondant de la fenêtre Réglages. Utilisation ONLYOFFICE n'assume aucune responsabilité quant aux achèvements du ChatGPT qui peuvent contenir des erreurs, des omissions ou du contenu haineux ou inapproprié. Tout le texte envoyé depuis le module complémentaire est généré par ChatGPT et est fourni tel quel, sans filtrage d'aucune sorte par ONLYOFFICE. Une fois installé, ChatGPT sera ajouté dans le menu contextuel et toutes les fonctionnalités du ChatGPT deviennent accessibles en faisant un simple clic droit. Sélectionnez un fragment du texte ou un mot pour accéder au menu contextuel et sélectionner l'une des fonctionnalités ChatGPT disponible: Analyse du texte, Analyse des mots, Traduire, Générer une image à partir du texte, Thésaurus, Chat et Demande personnalisée. Chat L'intégration du ChatGPT dans le menu contextuel permet d'activer le ChatGPT à partir de n'importe quel endroit du document. Utilisez l'assistant virtuel pour interagir et mener une conversation, poser des questions et recevoir des réponses à vos demandes. Parcourez le menu contextuel ChatGPT jusqu'à l'option Chat et démarrez la conversation dans la zone de texte en bas de la fenêtre ChatGPT. Demande personnalisée La fonctionnalité Demande personnalisée permet de traiter et parser le langage naturel ou le code en une série de tokens (jetons). Cet outil transforme le texte en une liste de tokens, traite la demande, transforme les tokens générés en texte et renvoie la chaîne dans le document. Pour faire une demande, passez au menu contextuel ChatGPT et cliquez sur l'option Demande personnalisée. Dans la zone de texte Open AI, saisissez le texte à parser en tokens. Le nombre de tokens s'affiche en bas de la zone de texte. Cliquez sur Afficher les paramètres avancés pour configurer d'autres paramètres de la demande. Modèle - le modèle qui va produire la sortie. Certains modèles sont adaptés aux tâches liées au langage naturel et d'autres se spécialisent dans le code. Pour en savoir plus sur des modèles, veuillez consulter le site officiel de ChatGPT. Longueur maximale définit la limite de tokens dans la sortie produite. Température contrôle le caractère aléatoire de la génération, c-à-d la température basse rend une sortie moins aléatoire. La réduction de la température rendra les sorties répétitives et déterministes. Top P est une alternative à la production des sorties en utilisant la température également connu sous le nom d'échantillonnage de noyau (nucleus sampling) quend le modèle prend en compte la probabilité seuil top_p de tokens résultants. Séquences d'arrêt définit 1 à 4 séquences qui forcent l'API à s'arrêter lorsqu'elles sont générées. Le texte renvoyé n'inclut pas la séquence d'arrêt. Cliquez sur Envoyer pour démarrer le traitement du texte ou cliquez sur Nettoyer pour effacer la demande et saisir une autre."
    },
   {
        "id": "UsageInstructions/ClearFormatting.htm", 
        "title": "Effacer un texte ou une mise en forme d'une cellule", 
        "body": "Effacer la mise en forme Dans l'éditeur de classeurs, vous pouvez supprimer rapidement le texte ou la mise en forme de la cellule sélectionnée. Pour le faire, sélectionnez une cellule, une plage de cellules avec la souris ou la feuille de calcul entière en utilisant la combinaison de touches Ctrl+A, Remarque : vous pouvez également sélectionner plusieurs cellules ou plages non adjacentes en maintenant la touche Ctrl enfoncée tout en sélectionnant les cellules/plages à l'aide de la souris. cliquez sur l'icône Effacer située dans l'onglet Accueil de la barre d'outils supérieure et sélectionnez une des options disponibles : utilisez l'option Tout si vous souhaitez effacer complètement le contenu des cellules de la plage sélectionnée y compris le texte, la mise en forme, la fonction etc ; utilisez l'option Texte si vous souhaitez effacer le texte des cellules de la plage sélectionnée ; utilisez l'option Format si vous souhaitez effacer la mise en forme des cellules de la plage sélectionnée. Le texte et les fonctions, s'ils sont présents, seront gardés. utilisez l'option Commentaires si vous souhaitez retirer les commentaires de la plage sélectionnée ; utilisez l'option Hyperliens si vous souhaitez retirer les liens hypertexte de la plage sélectionnée. Remarque : toutes ces options sont également disponibles dans le menu contextuel. Copier la mise en forme de cellule Vous pouvez rapidement copier une certaine mise en forme de cellule et l'appliquer à d'autres cellules. Pour appliquer la mise en forme copiée à une seule cellule ou plusieurs cellules adjacentes, sélectionnez la cellule/plage de cellules dont vous souhaitez copier la mise en forme avec la souris ou en utilisant le clavier, cliquez sur l'icône Copier le style dans l'onglet Accueil de la barre d'outils supérieure ( le pointeur de la souris aura la forme suivante ), sélectionnez la cellule/plage de cellules à laquelle vous souhaitez appliquer la même mise en forme. Pour appliquer la mise en forme copiée à plusieurs cellules ou plages non adjacentes, sélectionnez la cellule/plage de cellules dont vous souhaitez copier la mise en forme avec la souris ou en utilisant le clavier, double-cliquez sur l'icône Copier le style dans l'onglet Accueil de la barre d'outils supérieure (le pointeur de la souris ressemblera à ceci et l'icône Copier le style restera sélectionnée ), cliquez sur des cellules individuelles ou sélectionnez les plages de cellules une par une pour appliquer le même format à chacune d'elles, pour quitter ce mode, cliquez à nouveau sur l'icône Copier le style ou appuyez sur la touche Échap du clavier."
    },
   {
        "id": "UsageInstructions/CommunicationPlugins.htm", 
        "title": "Communiquer lors de l'édition", 
        "body": "Dans l'éditeur de classeurs ONLYOFFICE, vous pouvez toujours rester en contact avec vos collègues et utiliser des messageries en ligne populaires, telles que Telegram et Rainbow. Les module complémentaires Telegram et Rainbow ne sont pas installés par défaut. Pour en savoir plus sur l'installation, veuillez consulter le guide approprié: Ajouter des modules complémentaires à l'éditeur de bureau ONLYOFFICE Ajouter des modules complémentaires au cloud ONLYOFFICE ou Ajouter de nouveaux modules complémentaires aux éditeurs de serveur ou installer les modules complémentaires à l'aide de Gestionnaire de plugins. Telegram Pour démarrer une nouvelle conversation sur Telegram à l'aide du module complémentaire, Passez à l'onglet Modules complémentaires et cliquez sur Telegram, saisissez votre numéro de téléphone dans le champ correspondant, cochez la case Rester connecté si vous souhaitez sauvegarder les informations d'identification pour la session en cours et cliquez sur le bouton Suivant, saisissez le code que vous avez reçu dans votre application Telegram, ou connectez-vous par code QR, ouvrez l'application Telegram sur votre téléphone, passez à Paramètres > Appareils > Scanner QR, scannez l'image pour vous connecter. Vous pouvez désormais utiliser Telegram pour la messagerie instantanée à partir des éditeurs ONLYOFFICE. Rainbow Pour démarrer une nouvelle conversation sur Rainbow à l'aide du module complémentaire, Passez à l'onglet Modules complémentaires et cliquez sur Rainbow, enregistrez le nouveau compte en cliquant sur le bouton Sign up (S'inscrire) ou connectez-vous à votre compte existant. Pour ce faire, saisissez votre adresse e-mail dans le champ approprié et cliquez sur Continue (Continuer), ensuite saisissez votre mot de passe pour ce compte, cochez la case Keep my session alive (Garder ma session active) si vous souhaitez sauvegarder les informations d'identification pour la session en cours et cliquez sur le bouton Connect (Connecter). remplissez les champs dans la fenêtre Your identity (Votre identifiants). Maintenant vous pouvez démarrer une conversation dans Rainbow et travailler à partir des éditeurs ONLYOFFICE."
    },
   {
        "id": "UsageInstructions/ConditionalFormatting.htm", 
        "title": "La mise en forme conditionnelle", 
        "body": "Mise en forme conditionnelle La mise en forme conditionnelle permet d'appliquer des différents styles de mise en forme (couleur, police, décoration, dégradé) de cellules pour travailler avec les données en tableaux : mettre en surbrillance, trier les données et les afficher selon un ou plusieurs critères. Adaptez les critères à vos besoins, créez de nouvelles règles de mise en forme, modifiez, gérez ou effacez des règles existantes. L'éditeur de classeurs ONLYOFFICE prend en charge les règles de mise en forme conditionnelle suivantes : Valeur est, Premiers/Derniers, Moyenne, Texte, Date, Vide/Erreur, Doublon/Unique, Barres de données, Échelle de couleurs, Formule. Pour un accès rapide ou si vous souhaitez choisir l'une des conditions prédéfinies ou accéder à toutes les options de mise en forme conditionnelle disponibles, passez à l'onglet Accueil et cliquez sur le bouton Mise en forme conditionnelle . Toutes les options de Mise en forme conditionnelle sont également disponibles sur la barre latérale droite sous l'onglet Paramètres de cellule. Cliquez sur la flèche vers le bas du bouton Mise en forme conditionnelle pour accéder à la liste déroulante avec toutes les options disponibles. Si vous souhaitez créer une nouvelle règle de mise en forme conditionnelle, cliquez avec le bouton droit sur une cellule et sélectionnez Mise en forme conditionnelle du menu contextuel pour afficher la fenêtre Nouvelle règle de mise en forme. Pour appliquer une mise en forme prédéfinie, sélectionnez une plage de cellules, ensuite cliquez sur le bouton Mise en forme conditionnelle de la barre d'outils supérieure, ou cliquez sur Mise en forme conditionnelle sous l'onglet Paramètres de cellule sur la barre latérale droite et choisissez une règle appropriée dans la liste déroulante. . La fenêtre Nouvelle règle de mise en forme s'affiche pour paramétrer les options de mise en surbrillance. Règle de mise en forme Valeur est La règle de mise en forme Valeur est s'utilise pour rechercher et mettre en surbrillance des cellules répondant à certaines conditions de comparaison : Supérieure à Supérieure ou égale à Inférieure à Inférieure ou égale à Égale à N'est pas égale à Entre Pas entre La section Règle affiche la règle et la condition de comparaison sélectionnées, en cliquant sur la flèche vers le bas vous pouvez accéder à la liste des règles et des conditions disponibles. Utilisez le champ Sélectionner des données pour sélectionner la valeur de comparaison. Utiliser la référence vers une cellule ou la référence avec une fonction de la feuille de calcul telle que SOMME (A1:B5). La section Format propose plusieurs options prédéfinies de mise en forme des cellules. Vous pouvez choisir l'un des Préréglages disponibles : ou personnalisez la mise en forme en utilisant les options de mise en forme de police (Gras, Italique, Souligné, Barré), couleur de texte, couleur de remplissage et bordures. Utilisez la liste déroulante Général pour choisir le format de nombre approprié (Général, Nombre, Scientifique, Comptabilité, Monétaire, Date, Heure, Pourcentage). Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur Effacer pour effacer la mise en forme définie. Cliquez sur OK pour valider. L'exemple ci-après illustre les règles prédéfinies de mise en forme telles que Supérieure à et Entre. Selon cette règle la mise en forme est appliquée aux cellules pour mettre en vert les montagnes dont la hauteur est supérieure à 6,960 et mettre en rose le centile entre 5,000 et 6,500. Règle de mise en forme Premiers/Derniers</b> La règle Premiers/Derniers s'utilise pour retrouver et afficher des valeurs les plus élevées et les moins élevées. Les 10 premiers Premiers 10% Les 10 derniers Derniers 10% La section Règle affiche la règle et la condition de comparaison sélectionnées, en cliquant sur la flèche vers le bas vous pouvez accéder à la liste des règles et des conditions disponibles pour définir des valeurs (pourcentage) supérieures ou inférieures à afficher et de définir si vous souhaitez mettre en surbrillance selon la quantité ou le pourcentage. La section Format propose plusieurs options prédéfinies de mise en forme des cellules. Vous pouvez choisir l'un des Préréglages disponibles : ou personnalisez la mise en forme en utilisant les options de mise en forme de police (Gras, Italique, Souligné, Barré), couleur de texte, couleur de remplissage et bordures. Utilisez la liste déroulante Général pour choisir le format de nombre approprié (Général, Nombre, Scientifique, Comptabilité, Monétaire, Date, Heure, Pourcentage). Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur Effacer pour effacer la mise en forme définie. Cliquez sur OK pour valider. L'exemple ci-après illustre les règles prédéfinies de mise en forme telles que Premiers 10% qui affiche 20% de valeurs les plus élevées et Les 10 derniers. Selon cette règle la mise en forme est appliquée aux cellules pour mettre en orange les premiers 20% de villes avec des frais les plus élevés et mette en bleu les derniers 10 villes où les livres sont moins vendus. Règle de mise en forme Moyenne La règle Moyenne s'utilise pour retrouver et afficher des valeurs au-dessus et en-dessous de la moyenne ou l'écart type. Au-dessus En dessous Si égale ou supérieure à Si égale ou en dessous 1 écart-type au-dessus 1 écart-type en dessous 2 écarts types au-dessus 2 écarts types en dessous 3 écarts types au-dessus 3 écarts types en dessous La section Règle affiche la règle et la condition sélectionnées, en cliquant sur la flèche vers le bas vous pouvez accéder à la liste des règles et des conditions disponibles. La section Format propose plusieurs options prédéfinies de mise en forme des cellules. Vous pouvez choisir l'un des Préréglages disponibles : ou personnalisez la mise en forme en utilisant les options de mise en forme de police (Gras, Italique, Souligné, Barré), couleur de texte, couleur de remplissage et bordures. Utilisez la liste déroulante Général pour choisir le format de nombre approprié (Général, Nombre, Scientifique, Comptabilité, Monétaire, Date, Heure, Pourcentage). Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur Effacer pour effacer la mise en forme définie. Cliquez sur OK pour valider. L'exemple ci-après illustre la règle prédéfinie de mise en forme telle que Au-dessus de la moyenne. Selon cette règle la mise en forme est appliquée aux cellules pour mettre en vert des villes visitées au-dessus de la moyenne. Règle de mise en forme Texte La règle de mise en forme Texte s'utilise pour retrouver et afficher des cellules comportant du texte répondant à certaines conditions de mise en forme : Contient Ne contient pas Commence par Se termine par La section Règle affiche la règle et la condition de mise en forme sélectionnées, en cliquant sur la flèche vers le bas vous pouvez accéder à la liste des règles et des conditions disponibles. Utilisez le champ Sélectionner des données pour sélectionner la valeur de comparaison. Utiliser la référence vers une cellule ou la référence avec une fonction de la feuille de calcul telle que SOMME (A1:B5). La section Format propose plusieurs options prédéfinies de mise en forme des cellules. Vous pouvez choisir l'un des Préréglages disponibles : ou personnalisez la mise en forme en utilisant les options de mise en forme de police (Gras, Italique, Souligné, Barré), couleur de texte, couleur de remplissage et bordures. Utilisez la liste déroulante Général pour choisir le format de nombre approprié (Général, Nombre, Scientifique, Comptabilité, Monétaire, Date, Heure, Pourcentage). Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur Effacer pour effacer la mise en forme définie. Cliquez sur OK pour valider. L'exemple ci-après illustre la règle prédéfinie de mise en forme telle que Contient. Selon cette règle la mise en forme est appliquée aux cellules comportant Danemark pour mettre en rose des ventes dans un région spécifique. Règle de mise en forme Date La règle de mise en forme Date s'utilise pour retrouver et afficher des cellules comportant de la date répondant à certaines conditions de mise en forme : Hier Aujourd'hui Demain Pendant le 7 derniers jours Semaine dernière Cette semaine Semaine suivante Mois dernier Ce mois Mois suivant La section Règle affiche la règle et la condition de mise en forme sélectionnées, en cliquant sur la flèche vers le bas vous pouvez accéder à la liste des règles et des conditions disponibles. La section Format propose plusieurs options prédéfinies de mise en forme des cellules. Vous pouvez choisir l'un des Préréglages disponibles : ou personnalisez la mise en forme en utilisant les options de mise en forme de police (Gras, Italique, Souligné, Barré), couleur de texte, couleur de remplissage et bordures. Utilisez la liste déroulante Général pour choisir le format de nombre approprié (Général, Nombre, Scientifique, Comptabilité, Monétaire, Date, Heure, Pourcentage). Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur Effacer pour effacer la mise en forme définie. Cliquez sur OK pour valider. L'exemple ci-après illustre la règle prédéfinie de mise en forme telle que Mois dernier. Selon cette règle la mise en forme est appliquée aux cellules comportant les dates du dernier mois pour mettre en jaune des ventes pendant une certaine période de temps. Règle de mise en forme Vide/Erreur La règle de mise en forme Vide/Erreur s'utilise pour retrouver et mettre en surbrillance des cellules vides ou erreurs. Contient les vides Ne contient pas les vides Contient les erreurs Ne contient pas les erreurs La section Règle affiche la règle et la condition de mise en forme sélectionnées, en cliquant sur la flèche vers le bas vous pouvez accéder à la liste des règles et des conditions disponibles. La section Format propose plusieurs options prédéfinies de mise en forme des cellules. Vous pouvez choisir l'un des Préréglages disponibles : ou personnalisez la mise en forme en utilisant les options de mise en forme de police (Gras, Italique, Souligné, Barré), couleur de texte, couleur de remplissage et bordures. Utilisez la liste déroulante Général pour choisir le format de nombre approprié (Général, Nombre, Scientifique, Comptabilité, Monétaire, Date, Heure, Pourcentage). Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur Effacer pour effacer la mise en forme définie. Cliquez sur OK pour valider. L'exemple ci-après illustre la règle prédéfinie de mise en forme telle que Contient les vides. Selon cette règle la mise en forme est appliquée aux cellules vides dans la colonne pour mettre en bleu la valeur de ventes. Règle de mise en forme Doublon/Unique La règle de mise en forme Doublon/Unique s'utilise pour afficher des cellules comportant des doublons dans une feuille de calcul ou dans une plage de cellule définie par la mise en forme conditionnelle disponible : Doublon Unique La section Règle affiche la règle et la condition de mise en forme sélectionnées, en cliquant sur la flèche vers le bas vous pouvez accéder à la liste des règles et des conditions disponibles. La section Format propose plusieurs options prédéfinies de mise en forme des cellules. Vous pouvez choisir l'un des Préréglages disponibles : ou personnalisez la mise en forme en utilisant les options de mise en forme de police (Gras, Italique, Souligné, Barré), couleur de texte, couleur de remplissage et bordures. Utilisez la liste déroulante Général pour choisir le format de nombre approprié (Général, Nombre, Scientifique, Comptabilité, Monétaire, Date, Heure, Pourcentage). Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur Effacer pour effacer la mise en forme définie. Cliquez sur OK pour valider. L'exemple ci-après illustre la règle prédéfinie de mise en forme telle que Doublon. Selon cette règle la mise en forme est appliquée aux cellules comportant des contacts en double pour les mettre en jaune. Mise en forme en utilisant des barres de données Barres de données s'utilisent pour comparer les valeurs sous la forme d'un graphique à barres. Par exemple, comparez l'altitude des sommets en affichant les valeurs par défaut en mètres (la barre verte) et les mêmes valeurs en pourcentage entre 0 et 100 (la barre jaune) ; rang-centile s'il y a des valeurs aberrantes (la barre bleu claire) ; les barres seulement au lieu de nombres (la barre bleu) ; analyse de donnés à deux colonnes pour voir les nombres aussi que les barres (la barre rouge). Mise en forme en utilisant des échelles de couleurs Échelle de couleurs s'utilise pour visualiser les données grâce à des dégradés de couleurs en fonction de la distribution des valeurs. L'exemple ci-après illustre toutes les colonnes de “Dairy” à “Beverage” comportant un dégradé bicolore jaune et rouge ; la colonne “Total Sales” comportant un dégradé tricolore, du fond moins foncé rouge pour les valeurs les plus faibles et au fond plus foncé bleu pour les valeurs les plus élevées. Mise en forme en utilisant des jeux d'icônes Jeux d'icônes s'utilisent pour afficher l'icône pour la cellule répondant aux critères définis. L'éditeur de classeurs prend en charge plusieurs jeux d'icônes : Directionnel Formes Indices Évaluations Les exemples ci-après montrent les jeux d'icône les plus courantes dans la mise en forme conditionnelle. Les cellules sont mis en forme en utilisant les flèches appropriées au lieu des nombres et pourcentage pour affichez votre chiffre d'affaires dans la colonne “Status” et son évolution dans la colonne “Trend”. L'outil de mise en forme conditionnelle affiche les icônes appropriés au lieux des nombres de 1 à 5 selon la légende en haut pour chaque élément sur la liste de classement. Il ne faut pas calculer manuellement et comparer les indicateurs mensuels d'évolution du chiffre d'affaires car ce fait est illustré par les flèches rouges ou verts dans les cellules mises en forme. Profitez des échelles de couleur (rouge, jaune, vert) pour visualiser l'évolution des ventes. Mise en forme en utilisant des formules La mise en forme basé sur une formule utilise plusieurs formules pour filtrer des données en fonction de vos besoins spécifiques. La section Règle affiche la règle et la condition de mise en forme sélectionnées, en cliquant sur la flèche vers le bas vous pouvez accéder à la liste des règles et des conditions disponibles. Utilisez le champ Sélectionner des données pour sélectionner la valeur de comparaison. Utiliser la référence vers une cellule ou la référence avec une fonction de la feuille de calcul telle que SOMME (A1:B5). La section Format propose plusieurs options prédéfinies de mise en forme des cellules. Vous pouvez choisir l'un des Préréglages disponibles : ou personnalisez la mise en forme en utilisant les options de mise en forme de police (Gras, Italique, Souligné, Barré), couleur de texte, couleur de remplissage et bordures. Utilisez la liste déroulante Général pour choisir le format de nombre approprié (Général, Nombre, Scientifique, Comptabilité, Monétaire, Date, Heure, Pourcentage). Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur Effacer pour effacer la mise en forme définie. Cliquez sur OK pour valider. Les exemples ci-après illustre les possibilité de mise en forme en utilisant des formules. Ombrer des lignes filtrées alternées, Comparer à la valeur de référence (ici c'est $55) et démontrer que celle-ci est au-dessus (vert) ou au-dessous (rouge), Appliquer la mise en forme aux lignes répondant aux critères que vous spécifiez (voir des objectifs à réaliser ce mois-ci, dans le cas d'espèce c'est octobre) Ou mette en forme seulement les lignes uniques Créer de nouveaux règles Lorsque vous devez créer une nouvelle règle de mise en forme conditionnelle, choisissez l'une de façons suivantes de procéder : Passez à l'onglet Accueil, cliquez sur le bouton Mise en forme conditionnelle et sélectionnez Nouvelle règle dans le menu déroulant. Cliquez sur l'onglet Paramètres de cellule sur la barre latérale gauche et cliquez sur la flèche en bas du bouton Mise en forme conditionnelle et sélectionnez Nouvelle règle dans le menu déroulant. Cliquez avec le bouton droit sur une cellule et sélectionnez Mise en forme conditionnelle du menu contextuel. Le fenêtre Nouvelle règle de mise en forme s'affiche tout de suite. Paramétrez la règle comme il est décrit précédemment, et cliquez sur OK. Gérer des règles de mise en forme conditionnelle Une fois la règle de mise en forme conditionnelle est définie, il est possible de la modifier, supprimer et afficher tout simplement en utilisant l'option Gérer les règles. Pour ce faire, cliquez sur le bouton Mise en forme conditionnelle sous l'onglet Accueil ou sous l'onglet Paramètres de cellule sur la barre latérale gauche. La fenêtre Mise en forme conditionnelle s'affiche : Afficher les règles de la mise en forme pour permet de sélectionner les règles à afficher : Sélection actuelle Cette feuille de calcul Ce tableau Ce tableau croisé dynamique Tous les règles de la zone choisi s'affichent dans l'ordre de priorité (de haut en bas) dans la liste Règles. Dans la colonne Appliquer à s'affiche la zone à laquelle cette règle s'applique, vous pouvez modifier la zone en cliquant sur l'icône Sélectionner des données . Dans la colonne Format s'affiche la mise en forme utilisée. Utilisez le bouton Nouvelle pour ajouter une nouvelle règle. Utilisez le bouton Modifier pour modifier une règle existante et accéder à la fenêtre Modifier les règles de mise en forme. Modifier la règle selon ce que vous jugez approprié et cliquez sur OK. Utilisez les flèches vers le haut et vers le bas pour modifier l'ordre de priorité. Cliquez sur Supprimer pour effacer la règle. Cliquez sur OK pour valider. Modifier la mise en forme conditionnelle Modifier des règles Valeur est, Premiers/Derniers, Moyenne, Texte, Date, Vide/Erreur, Doublon/Unique, Formule. La fenêtre Modifier les règles de mise en forme offre une gamme d'options communs pour les règles Valeur est, Premiers/Derniers, Moyenne, Texte, Date, Vide/Erreur, Doublon/Unique, Formule : Cliquez sur Règle pour modifier la règle et la condition définie ; Utilisez Sélectionner des données pour modifier la plage de cellules à laquelle on fait la référence. Utilisez des option de mise en forme de la Police et de la cellule (Gras, Italique, Souligné, Barré), Couleur de texte, Couleur de remplissage et Bordures. Cliquez sur la liste déroulante Général pour choisir le format de nombre approprié (Général, Nombre, Scientifique, Comptabilité, Monétaire, Date, Heure, Pourcentage). Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur OK pour valider. Modifier des barres de données La fenêtre Modifier les règles de mise en forme offre les options suivantes pour la mise en forme à l'aide des Barres de données : Cliquez sur Règle pour modifier la règle et la condition définie ; Minimum/Maximum pour modifier le type de valeur minimale et et maximale dans les barres de données si vous souhaitez mettre l'accent sur les différences. Les types de valeurs minimales et maximales disponibles : Minimum / Maximum Nombre Pour cent Formule Centile Automatique Sélectionnez Automatique pour fixer la valeur minimale à zéro et la valeur maximale au plus grand nombre dans la plage de données. Automatique est l'option par défaut. Cliquez sur Sélectionner des données pour modifier la plage de cellules pour les valeurs minimales et maximales. Apparence de la barre Personnalisez l'aspect des Barres de données en choisissant le type et la couleur de remplissage et de bordure, aussi que la direction des barres. Il y a deux types de Remplissage : Remplissage Solide ou Dégradé. Utilisez la flèche au-dessous pour sélectionner la couleur de remplissage pour des valeurs Positives et Négatives dans les barres de données. Il y a deux types de Bordures : Solide et Rien. Utilisez la flèche au-dessous pour sélectionner la couleur de bordure pour des valeurs Positives et Négatives dans les barres de données. Activez Même que positif pour utiliser la même couleur pour afficher les valeurs positives et négatives. Une fois cette case cochée, les options Négatif sont désactivées. Utilisez la Direction de la barre pour modifier l'orientation des barres de données. Contexte est l'option par défaut mais vous pouvez choisir De gauche à droite ou De droite à gauche en fonction de la représentation des données désirée. Activez Afficher la barre uniquement pour afficher uniquement la barre de données dans la cellule et masquer des valeurs. Axe Sélectionnez la Position de l'axe de la barre de données par rapport au milieu de la cellule. Il y a trois options de position : Automatique, Milieu de cellule et Rien. Cliquez sur la flèche vers le bas de la zone de couleur pour définir la couler d'axe. Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur OK pour valider. Modifier la mise en forme en utilisant une échelle de couleur Modifier la mise en forme en utilisant une échelle à deux couleurs La fenêtre Modifier les règles de mise en forme offre les options suivantes pour la mise en forme en utilisant une Échelle à deux couleurs : Cliquez sur Règle pour modifier la règle et la condition définie ; Cliquez sur Valeur minimum/maximum pour définir le type des valeurs minimales et maximales si vous souhaitez mettre l'accent sur les différences. Les types des valeurs minimales et maximales disponibles : Minimum / Maximum Numérique Pour cent Formule Centile Minimum / Maximum est l'option par défaut. Utilisez Sélectionner des données pour modifier la plage de cellules pour les valeurs minimales et maximales. Utilisez la flèche vers le bas au-dessous pour sélectionner la couleur pour chaque échelle. Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur OK pour valider. Modifier la mise en forme à trois couleurs La fenêtre Modifier les règles de mise en forme offre les options suivantes pour la mise en forme en utilisant une Échelle à trois couleurs : Cliquez sur Règle pour modifier la règle et la condition définie ; Cliquez sur Valeur minimum/médiane/maximum pour définir le type des valeurs minimales, médianes et maximales si vous souhaitez mettre l'accent sur les différences. Les types des valeurs minimales/maximales disponibles : Minimum / Maximum Numérique Pour cent Formule Centile Les types des valeurs médianes disponibles : Numérique Pour cent Formule Centile Minimum/Centile/Maximum est l'option par défaut pour la mise en forme en utilisant Échelle à trois couleurs Utilisez Sélectionner des données pour modifier la plage de cellules pour les valeurs minimales, médianes et maximales. Utilisez la flèche vers le bas au-dessous pour sélectionner la couleur pour chaque échelle. Le champ Aperçu vous aide de visualiser l'aspect final de la cellule. Cliquez sur OK pour valider. Modifier la mise en forme en utilisant des jeux d'icônes La fenêtre Modifier les règles de mise en forme offre les options suivantes pour la mise en forme en utilisant des Jeux d'icônes : Cliquez sur Règle pour modifier la règle et la condition définie ; Cliquez sur Style d'icône pour personnaliser le style d'icônes pour la règle créée. Activez Afficher les icônes seulement pour afficher uniquement les icônes dans la cellule et masquer des valeurs. Activez Mettre les icônes dans le sens inverse pour inverser l'ordre des icônes et les organiser de plus haut au plus bas. Par défaut, les icônes sont ordonnées de la plus basse à la plus élevée. Définissez la règle et l'opérateur de comparaison approprié (supérieure ou égale à, supérieure à) pour chaque icône, les valeurs des seuils et le type de valeur (Nombre, Pour cent, Formule, Centile) pour ordonner les valeurs de la plus basse à la plus élevée. Par défaut, les valeurs sont divisées de manière égale. Cliquez sur OK pour valider. Effacer la mise en forme conditionnelle Pour effacer la mise en forme conditionnelle, passez à l'onglet Accueil, cliquez sur le bouton Mise en forme conditionnelle , ou cliquez sur Mise en forme conditionnelle</b> sous l'onglet Paramètres de cellule sur la barre latérale droite, ensuite cliquez sur Effacer les règles dans le menu déroulante et sélectionnez l'option appropriée : De la sélection actuelle À partir de cette feuille de calcul À partir de ce tableau À partir d'un tableau croisé dynamique Veuillez noter que ce guide comprend des informations graphiques du manuel Microsoft Office La mise en forme conditionnelle : exemples et instructions. Téléchargez ce manuel et ouvrez-le avec l'éditeur de classeurs pour essayer ces règles de visualisation."
    },
   {
        "id": "UsageInstructions/CopyPasteData.htm", 
        "title": "Couper/copier/coller des données", 
        "body": "Utiliser les opérations de base du presse-papiers Pour couper, copier et coller les données dans le classeur actuel, utilisez le menu contextuel ou les icônes correspondantes sur la barre d'outils supérieure de l'éditeur de classeurs, Couper - sélectionnez les données et utilisez l'option Couper du menu contextuel ou l'icône Couper de la barre d'outils supérieure pour supprimer les données sélectionnées et les envoyer vers le presse-papiers. Les données coupées peuvent être insérées ensuite dans un autre endroit du même classeur. Copier - sélectionnez les données et utilisez l'icône Copier sur la barre d'outils supérieure ou cliquez avec le bouton droit et sélectionnez l'option Copier depuis le menu pour envoyer les données sélectionnées vers le presse-papiers. Les données copiées peuvent être insérées ensuite dans un autre endroit du même classeur. Coller - sélectionnez l'endroit et utilisez l'icône Coller sur la barre d'outils supérieure ou cliquez avec le bouton droit et sélectionnez l'option Coller du menu pour insérer les données copiées/coupées depuis le presse-papiers à la position actuelle du curseur. Les données peuvent être copiées à partir du même classeur. Dans la version en ligne, les combinaisons de touches suivantes ne sont utilisées que pour copier ou coller des données de/vers une autre feuille de calcul ou un autre programme, dans la version de bureau, les boutons/options de menu et les combinaisons de touches correspondantes peuvent être utilisées pour toute opération copier/coller: Raccourci clavier Ctrl+X pour couper (Cmd+X sous macOS); Raccourci clavier Ctrl+C pour copier (Cmd+C sous macOS); Raccourci clavier Ctrl+V pour coller (Cmd+V sous macOS); Remarque: au lieu de couper et coller des données dans la même feuille de calcul, vous pouvez sélectionner la cellule/plage de cellules requise, placez le pointeur de la souris sur la bordure de sélection pour qu'il devienne l'icône Flèche et faites glisser la sélection jusqu'au l'emplacement requis. Pour afficher ou masquer l'affichage automatique du bouton Collage spécial lors du collage, accédez à l'onglet Fichier > Paramètres avancés et activez/désactivez l'option Afficher le bouton Options de collage lorsque le contenu est collé. Utiliser la fonctionnalité Collage spécial Remarque: Pour l'édition collaborative, l'option Collage spécial est n'est disponible que lorsque le mode Strict est activé. Une fois les données collées, le bouton Collage spécial apparaît à côté du coin inférieur droit de la cellule/plage de cellules insérée. Cliquez sur ce bouton pour sélectionner l'option de collage nécessaire ou utilisez la touche Ctrl pour ouvrir le menu Collage spécial et appuyez en plus sur la touche de lettre appropriée qui apparaît à côté de l'option nécessaire. Lorsque vous collez une cellule/plage de cellules avec des données formatées, les options suivantes sont disponibles: Coller (Ctrl ensuite P) - permet de coller tout le contenu de la cellule, y compris la mise en forme des données. Cette option est sélectionnée par défaut. Les options suivantes peuvent être utilisées si les données copiées contiennent des formules: Coller uniquement la formule (Ctrl ensuite F) - permet de coller des formules sans coller la mise en forme des données. Formule + format numérique (Ctrl ensuite O) - permet de coller des formules en conservant la mise en forme des nombres. Formule + toute la mise en forme (Ctrl ensuite K) - permet de coller des formules en conservant la mise en forme des données. Formule sans bordures (Ctrl ensuite B) - permet de coller des formules en conservant la mise en forme des données sauf les bordures de cellules. Formule + largeur de colonne (Ctrl ensuite W) - permet de coller des formules en conservant la mise en forme des données et de définir la largeur de la colonne source pour la plage de cellules. Transposer (Ctrl ensuite T) - permet de coller des données en transposant les colonnes en lignes et les lignes en colonnes. Cette option est disponible pour les plages de données normales, mais pas pour les tableaux mis en forme. Les options suivantes permettent de coller le résultat renvoyé par la formule copiée sans coller la formule elle-même: Coller uniquement la valeur (Ctrl ensuite V) - permet de coller les résultats de la formule sans coller la mise en forme des données. Valeur + format numérique (Ctrl ensuite A) - permet de coller les résultats de la formule en conservant la mise en forme des nombres. Valeur + toute la mise en forme (Ctrl ensuite E) - permet de coller les résultats de la formule en conservant la mise en forme des données. Coller uniquement la mise en forme (Ctrl ensuite R) - permet de coller la mise en forme de la cellule uniquement sans coller le contenu de la cellule. Coller lien (Ctrl ensuite N) - permet de coller un lien externe vers une cellule ou une plage de cellules dans une autre feuille de calcul sur le portail (à partir de l'éditeur en ligne) ou dans un fichier local (à partir de l'éditeur de bureau). Coller Formule - permet de coller des formules sans coller le formatage des données. Valeurs - permet de coller les résultats de la formule sans coller la mise en forme des données. Formats - permet de conserver la mise en forme de la zone copiée. Commentaires - permet d'ajouter les commentaires de la zone copiée. Largeur de colonne - permet d'appliquer la largeur de colonne de la zone copiée. Tout sauf la bordure - permet de coller les formules, les résultats de formules et la mise en forme sauf les bordures. Formules et mise en forme - permet de coller les formules et conserver la mise en forme de la zone copiée. Formules et largeur de colonne - permet de coller les formules et d'appliquer la largeur de colonne de la zone copiée. Formules et format des chiffres - permet de coller les formules et le format des chiffres. Valeurs et format des chiffres - permet de coller les résultats de formules et d'appliquer le format des chiffres de la zone copiée. Valeurs et mise en forme - permet de coller les résultats de formules et de conserver la mise en forme de la zone copiée. Opération Additionner - permet d'additionner automatiquement tous les nombres de chaque cellule insérée. Soustraire - permet de soustraire automatiquement les nombres de chaque cellule insérée. Multiplier - permet de multiplier automatiquement les nombres de chaque cellule insérée. Diviser - permet de diviser automatiquement les nombres de chaque cellule insérée. Transposer - permet de coller des données en modifiant les colonnes en lignes et les lignes en colonnes. Ignorer les vides - permet d'ignorer les cellules vides et leur mise en forme. Lorsque vous collez le contenu d'une seule cellule ou du texte dans des formes automatiques, les options suivantes sont disponibles: Mise en forme de la source (Ctrl+K) - permet de conserver la mise en forme initiale des données copiées. Mise en forme de la destination (Ctrl+M) - permet d'appliquer la mise en forme déjà utilisée pour la cellule/forme automatique dans laquelle vous collez les données. Texte délimité Lorsque vous collez du texte délimité copié à partir d'un fichier .txt, les options suivantes sont disponibles: Le texte délimité peut contenir plusieurs enregistrements dont chaque enregistrement correspond à une seule ligne de table. Chaque enregistrement peut contenir plusieurs valeurs de texte séparées par des délimiteurs (tels que virgule, point-virgule, deux-points, tabulation, espace ou tout autre caractère). Le fichier doit être enregistré sous la forme d'un fichier .txt de texte brut. Conserver le texte uniquement (Ctrl+T) - permet de coller les valeurs de texte dans une colonne où le contenu de chaque cellule correspond à une ligne dans le fichier texte source. Utiliser l'assistant importation de texte - permet d'ouvrir l'assistant importation de texte</b> qui permet de diviser facilement les valeurs de texte en plusieurs colonnes où chaque valeur de texte qui est séparée par un délimiteur sera placé dans une cellule séparée. Lorsque la fenêtre Assistant importation de texte s'ouvre, sélectionnez le délimiteur de texte utilisé dans les données délimitées dans la liste déroulante Délimiteur. Les données divisées en colonnes seront affichées dans le champ Aperçu au-dessous. Si vous êtes satisfait du résultat, appuyez sur le bouton OK. Si vous avez collé des données délimitées à partir d'une source qui n'est pas un fichier texte brut (par exemple, du texte copié à partir d'une page Web, etc.), ou si vous avez appliqué la fonction Conserver uniquement le texte et que vous souhaitez maintenant fractionner les données d'une seule colonne en plusieurs colonnes, vous pouvez utiliser l'option Texte en colonnes. Pour diviser les données en plusieurs colonnes: Sélectionnez la cellule ou la colonne nécessaire qui contient les données avec délimiteurs. Passez à l'onglet Données. Cliquez sur le bouton Texte en colonnes dans la barre d'outils supérieure. L'assistant Texte en colonnes s'affiche. Dans la liste déroulante Délimiteur, sélectionnez le délimiteur utilisé dans les données délimitées. Cliquez sur le bouton Avancé pour ouvrir la fenêtre Paramètres avancés et spécifier le Séparateur décimal ou Séparateur de milliers. Affichez l'aperçu du résultat dans le champ en dessous et cliquez sur OK. Ensuite, chaque valeur de texte séparée par le délimiteur sera placée dans une cellule séparée. S'il y a des données dans les cellules à droite de la colonne que vous voulez fractionner, les données seront écrasées. Utiliser l'option Remplissage automatique Pour remplir rapidement plusieurs cellules avec les mêmes données, utilisez l'option Remplissage automatique: sélectionner une cellule/plage de cellules contenant les données ciblées, déplacez le curseur de la souris sur la poignée de remplissage dans le coin inférieur droit de la cellule. Le curseur va se transformer en croix noire: faites glisser la poignée sur les cellules adjacentes que vous souhaitez remplir avec les données sélectionnées. Remarque: si vous devez créer une série de nombres (tels que 1, 2, 3, 4 ..., 2, 4, 6, 8 ... etc.) ou des dates, vous pouvez entrer au moins deux valeurs de départ et étendre rapidement la série en sélectionnant ces cellules puis en faisant glisser la poignée de remplissage. Pour une série de jours dans une semaine ou mois, saisissez la valeur initiale et faites glisser la poignée de remplissage. Remplir les cellules de la colonne avec des valeurs textuelles Si une colonne de votre feuille de calcul contient des valeurs textuelles, vous pouvez facilement remplacer n'importe quelle valeur dans cette colonne ou remplir la cellule vide suivante en sélectionnant l'une des valeurs de texte existantes. Cliquez avec le bouton droit sur la cellule requise et choisissez l'option Sélectionner dans la liste déroulante dans le menu contextuel. Sélectionnez l'une des valeurs de texte disponibles pour remplacer la valeur actuelle ou remplir une cellule vide. Remplir des cellules à l'aide de l'outil Série Sélectionnez une cellule/plage de cellules comportant des données source et quelques cellules vides dans le sens nécessaire. Cliquez sur l'icône Remplir sous l'onglet Accueil de la barre d'outil supérieure et sélectionnez l'option Série. Vous pouvez sélectionner En bas, À droite, En haut, À gauche pour remplir les cellules vides sélectionnées. Il y a encore une façon d'accéder à la fenêtre Série. Vous pouvez sélectionner les données source, placez le curseur de la souris sur la poignée de remplissage dans le coin inférieur droit de la cellule, cliquez dessus et maintenez le bouton droit de la souris enfoncé, ensuite faites glisser vers le bas, vers le haut, vers la droite ou vers la gauche, relâchez le bouton de la souris et l'ensemble d'options Série s'affichera dans le menu contextuel. Vous pouvez également utiliser les options suivantes pour remplir les cellules vides sélectionnées: Copier les cellules sert à remplir les cellules avec les mêmes valeurs, Remplir la série sert à remplir les cellules d'incrément par défaut, Remplir les jours sert à remplir les cellules avec la série de dates, Tendance linéaire est disponible lorsque vous sélectionnez plusieurs valeurs de départ et sert à ajouter l'incrément par défaut à la valeur de départ, et ensuite à chaque valeur consécutive, Tendance de croissance est disponible lorsque vous sélectionnez plusieurs valeurs de départ et sert à multiplier la valeur de départ par l'incrément par défaut. Dans la boîte de dialogue Série, sélectionnez les options nécessaires et cliquez sur OK. Série dans: Lignes, Colonnes - sélectionnez le sens dans lequel remplir des cellules. Type: Linéaire sert à ajouter l'incrément à la valeur de départ, et ensuite à chaque valeur consécutive, Croissance sert à multiplier la valeur de départ par l'incrément, Date sert à remplir des cellules avec une série de dates, Remplissage automatique sert à remplir des cellules avec les données d'autres cellules. Unité de date: Jour, Jour ouvrable, Mois, Année - sélectionnez l'unité de date par laquelle incrémenter la série. Tendance - activez cette option s'il y a plusieurs valeurs de départ dans la série. Valeur de l'étape - sélectionnez le nombre par lequel la série sera incrémentée. La valeur par défaut est 1. Valeur limite - indiquez la dernière valeur dans la série."
    },
   {
        "id": "UsageInstructions/DataValidation.htm", 
        "title": "Validation des données", 
        "body": "L'éditeur de classeurs ONLYOFFICE vous fait bénéficier des fonctionnalités de validation des données pour contrôler les données saisies par les autres utilisateurs. Pour ce faire, sélectionnez la cellule, la plage de cellules ou la feuille de calcul entière dont vous voulez limiter la saisie, passez à l'onglet Données et cliquez sur icône Validation des données dans la barre d'outils supérieure. La fenêtre Validation des données avec trois onglets s'ouvre : Paramètres, Entrer le message et Avertissement d'erreur. Paramètres La section Paramètres permet de définir le type de données à contrôler : Remarque : Cochez la case Appliquer ces modifications à toutes les cellules ayant les mêmes paramètres pour limiter toutes les cellules sélectionnées ou la feuille de calcul entière. sélectionnez l'option convenable du menu Autoriser : Aucune valeur : saisie de données sans restrictions. Nombre entier : n'autoriser que la saisie de nombres entiers. Décimales : n'autoriser que la saisie de nombres décimaux. Liste : limiter les cellules à n'accepter que des données dans la liste déroulante que vous avez créé. Décochez Afficher une liste déroulante dans une cellule pour masquer la flèche de la liste déroulante. Date : n'autoriser que les dates dans les cellules. Temps : n'autoriser que les heures dans les cellules. Longueur du texte : permet de limiter la longueur du texte. Autre : permet de personnaliser la formule de validation. Remarque : Cochez la case Appliquer ces modifications à toutes les cellules ayant les mêmes paramètres pour limiter toutes les cellules sélectionnées ou la feuille de calcul entière. sélectionnez des conditions dans le menu Données : entre : la valeur doit être comprise dans l'intervalle de données selon la règle de validation définie. pas entre : la valeur ne doit pas être comprise dans l'intervalle de données selon la règle de validation définie. est égal : la valeur dans la cellule doit être égale à la valeur définie par la règle de validation. n'est pas égal : la valeur dans la cellule ne doit pas être égale à la valeur définie par la règle de validation. supérieur à : la valeur doit être supérieure à la valeur définie par la règle de validation. inférieur à : la valeur doit être inférieure à la valeur définie par la règle de validation. est supérieur ou égal à : la valeur dans la cellule doit être supérieure ou égale à la valeur définie par la règle de validation. est inférieur ou égal à : la valeur dans la cellule doit être inférieure ou égale à la valeur définie par la règle de validation. créez une règle de validation en fonction du type de données autorisé : Condition de validation Règle de validation Description Disponibilité Entre / pas entre Minimum / Maximum Définir un intervalle de données Nombre entier / Décimal / Longueur du texte Date de début / Date limite Définir un intervalle de dates Date Heure de début / Heure de fin Définir un intervalle de temps Temps Est égal / n'est pas égal Comparer à Définir la valeur à comparer à Nombre entier / Décimal Date Définir la date à comparer à Date Temps écoulé Définir l'heure à comparer à Temps Longueur Définir la longueur à comparer à Longueur du texte Supérieur à / est supérieur ou égal à Minimum Définir la limite inférieure, Nombre entier / Décimal / Longueur du texte Date de début Définir la date de début Date Heure de début Définir l'heure de début Temps Inférieur à / est inférieur ou égal à Maximum Définir la limite supérieure, Nombre entier / Décimal / Longueur du texte Date limite Définir la date limite Date Heure de fin Définir l'heure de fin Temps Ainsi que : Source : spécifiez la source de données pour limiter les entrées à une sélection dans une liste déroulante. Formule : entrez la formule à personnaliser la règle de validation sous l'option d'autorisation Autre. Entrer le message La section Entrer le message permet de personnaliser le message qui s'affichera chez les utilisateurs lorsqu'ils feront glisser la souris sur la cellule. Saisissez le Titre et le texte du Message de saisie. Décochez Affichez un message de saisie lorsqu'une cellule est sélectionnée pour désactiver l'affichage du message de saisie. Lassez la case active pour affiche le message. Avertissement d'erreur La section Avertissement d'erreur permet de personnaliser le message d'erreur avertissant les utilisateurs que les données entrées ne sont pas valides. Style : choisissez le type d'alerte parmi les options disponibles : Arrêter, Alerte ou Message : Titre : saisissez le titre du message d'alerte. Message d'erreur : saisissez le texte du message d'alerte. Décochez Affichez un avertissement d'erreur lorsque les données invalides sont saisies pour désactiver l'affichage des alertes."
    },
   {
        "id": "UsageInstructions/DrawingOperations.htm", 
        "title": "Dessiner à main levée dans un classeur", 
        "body": "L'onglet Dessiner de l'éditeur de classeurs permet de dessiner à main levée, ajouter des notes manuscrites, mettre en surbrillance du texte et effacer dans votre classeur. Pour dessiner, écrire ou mettre en surbrillance du texte, cliquez sur l'icône Stylo ou Surligneur et déplacez le curseur. Cliquez sur la flèche de déroulement pour personnaliser la couleur et l'épaisseur du trait. Cliquez sur Plus de couleurs lorsque la couleur nécessaire manque à la palette. Lorsque vous avez fini de dessiner, d'écrire ou de surligner, cliquez sur l'icône Stylo ou Surligneur encore une fois, ou appuyez sur la touche Echap. Cliquez sur l'outil Gomme et déplacez le curseur d'avant en arrière pour effacer le trait. La Gomme efface uniquement le trait entier. Utilisez le bouton Sélectionner pour sélectionner l'inscription, le dessin ou la mise en surbrillance. Une fois sélectionné, il est possible de redimensionner ou supprimer l'élément."
    },
   {
        "id": "UsageInstructions/FontTypeSizeStyle.htm", 
        "title": "Définir le type de police, la taille, le style et la couleur", 
        "body": "L'éditeur de classeurs permet de sélectionner le type et la taille de la police, appliquer l'un des styles de décoration et modifier les couleurs de la police et de l'arrière-plan en utilisant les icônes correspondantes sous l'onglet Accueil de la barre d'outils supérieure.. Remarque: si vous souhaitez appliquer la mise en forme aux données déjà présentes dans le classeur, sélectionnez-les avec la souris ou en utilisant le clavier et appliquez la mise en forme. Si vous souhaitez appliquer la mise en forme à plusieurs cellules ou plages non adjacentes en maintenant la touche Ctrl enfoncée tout en sélectionnant les cellules/plages à l'aide de la souris. Police Sert à sélectionner l'une des polices disponibles dans la liste. Si une police requise n'est pas disponible dans la liste, vous pouvez la télécharger et l'installer sur votre système d'exploitation, après quoi la police sera disponible pour utilisation dans la version de bureau. Taille de la police Sert à sélectionner la taille de la police parmi les valeurs disponibles dans la liste déroulante (les valeurs par défaut sont: 8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72 et 96). Il est également possible d'entrer manuellement une valeur personnalisée dans le champ de taille de police jusqu'à 409 pt. Appuyer sur la touche Entrée pour confirmer Augmenter la taille de la police Sert à augmenter la taille de police par incréments de 1 point à chaque clic sur le bouton. Diminuer la taille de la police Sert à augmenter la taille de police par incréments de 1 point à chaque clic sur le bouton. Modifier la casse Sert à modifier la casse du texte. Majuscule en début de phrase - la casse à correspondre la casse de la proposition ordinaire. minuscule - mettre en minuscule toutes les lettres MAJUSCULES - mettre en majuscule toutes les lettres Mettre en majuscule chaque mot - mettre en majuscule la première lettre de chaque mot Inverser la casse - basculer entre d'affichages de la casse du texte. Gras Sert à mettre la police en gras pour lui donner plus de poids. Italique Sert à mettre la police en italique pour lui donner une certaine inclinaison à droite. Souligné Sert à souligner le texte avec la ligne qui passe sous les lettres. Barré Sert à barrer le texte par la ligne passant par les lettres. Indice/Exposant Permet de choisir l'option Exposant ou Indice. L'option Exposant sert à rendre le texte plus petit et le déplacer vers la partie supérieure de la ligne du texte, comme par exemple dans les fractions. L'option Indice sert à rendre le texte plus petit et le déplacer vers la partie inférieure de la ligne du texte, comme par exemple dans les formules chimiques. Couleur de police Sert à changer la couleur des lettres et des caractères dans les cellules. Couleur de remplissage Sert à modifier la couleur d'arrière-plan de la cellule. Utilisez cette icône pour remplir une cellule avec une couleur unie. La couleur d'arrière-plan de la cellule peut également être modifiée à l'aide de la section Remplissage sous l'onglet Paramètres de cellule de la barre latérale de droite. Modifier le jeu de couleurs Ce bouton se trouve sous l'onglet Mise en page. Sert à modifier la palette de couleurs par défaut pour les éléments de classeur (police, arrière-plan, graphique et ses éléments) en sélectionnant l'option disponible: Aspect, Bleu vert, Bleu II, Bleu chaud, Bleu, Échelle de gris, Vert jaune, Vert, Capitaux, Médian, Office 2007-2010, Office 2013-2022, Bureau, Orange rouge, Orange, Papier, Rouge orange, Rouge violet, Rouge, Flux d'air, Violet II, Violet, Jaune orange, Jaune et Nouveau thème Office. Remarque: il est également possible d'appliquer une des mises en forme prédéfinies en sélectionnant la cellule que vous voulez mettre en forme et en choisissant la mise en forme désirée de la liste sous l'onglet Accueil de la barre d'outils supérieure: Pour modifier la couleur de police ou remplir la cellule avec une couleur unie, sélectionnez les caractères / cellules avec la souris ou une feuille de calcul entière en utilisant la combinaison de touches Ctrl+A, cliquez sur l'icône correspondante sur la barre d'outils supérieure, sélectionnez une couleur dans les palettes disponibles Couleurs de thème - les couleurs qui correspondent à la palette de couleurs sélectionnée de la feuille de calcul. Couleurs standard - le jeu de couleurs par défaut. Il y a deux façons d'appliquer une couleur personnalisée: Pipette - sert à sélectionner la couleur nécessaire en cliquant sur celle-ci dans la feuille de calcul. Plus de couleurs sert à rechercher la couleur manquante dans la palette. Sélectionnez la gamme de couleurs nécessaire en déplaçant le curseur vertical et définissez la couleur spécifique en faisant glisser le sélecteur de couleur dans le grand champ de couleur carré. Une fois que vous sélectionnez une couleur avec le sélecteur de couleur, les valeurs de couleur appropriées RGB et sRGB seront affichées dans les champs à droite. Vous pouvez également spécifier une couleur sur la base du modèle de couleur RGB en entrant les valeurs numériques nécessaires dans les champs R, G, B (rouge, vert, bleu) ou saisir le code hexadécimal dans le champ sRGB marqué par le signe #. La couleur sélectionnée s'affiche dans l'aperçu Nouveau. Si l'objet a déjà été rempli d'une couleur personnalisée, cette couleur sera affichée dans la case Actuel que vous puissiez comparer les couleurs originales et modifiées. Lorsque la couleur est spécifiée, cliquez sur le bouton Ajouter: La couleur personnalisée sera appliquée au texte/cellule et sera ajoutée dans la palette Couleurs récentes. Pour effacer une couleur d'arrière-plan d'une certaine cellule, sélectionnez une cellule, ou une plage de cellules avec la souris ou une feuille de calcul entière en utilisant la combinaison de touches Ctrl+A, cliquez sur l'icône Couleur de remplissage sous l'onglet Accueil de la barre d'outils supérieure, sélectionnez l'icône l'icône."
    },
   {
        "id": "UsageInstructions/FormattedTables.htm", 
        "title": "Mettre sous forme de modèle de tableau", 
        "body": "Créer un nouveau tableau mis en forme Pour faciliter le travail avec vos données, l'éditeur de classeurs vous permet d'appliquer un modèle de tableau à une plage de cellules sélectionnée en activant automatiquement le filtre. Pour ce faire, sélectionnez une plage de cellules que vous souhaitez mettre en forme, cliquez sur l'icône Mettre sous forme de modèle de tableau sous l'onglet Accueil dans la barre d'outils supérieure, Sélectionnez le modèle souhaité dans la galerie, dans la fenêtre contextuelle ouverte, vérifiez la plage de cellules à mettre en forme comme un tableau, cochez la case Titre si vous souhaitez inclure les en-têtes de tableau dans la plage de cellules sélectionnée, sinon la ligne d'en-tête sera ajoutée en haut tandis que la plage de cellules sélectionnée sera déplacée d'une ligne vers le bas, cliquez sur le bouton OK pour appliquer le modèle sélectionné. Le modèle sera appliqué à la plage de cellules sélectionnée et vous serez en mesure d'éditer les en-têtes de tableau et d'appliquer le filtre pour travailler avec vos données. Vous pouvez aussi appliquer un modèle de tableau en utilisant le bouton Tableau sous l'onglet Insérer. Dans ce cas, un modèle par défaut s'applique. Remarque : une fois que vous avez créé un nouveau tableau, un nom par défaut (Tableau1, Tableau2 etc.) lui sera automatiquement affecté. Vous pouvez changer ce nom pour le rendre plus significatif et l'utiliser pour d'autres travaux. Si vous entrez une nouvelle valeur dans une cellule sous la dernière ligne du tableau (si le tableau n'a pas la ligne Total) ou dans une cellule à droite de la dernière colonne du tableau, le tableau mis en forme sera automatiquement étendue pour inclure une nouvelle ligne ou colonne. Si vous ne souhaitez pas étendre le tableau, cliquez sur le bouton Coller qui s'affiche et sélectionnez l'option Annuler l'expansion automatique du tableau. Une fois cette action annulée, l'option Rétablir l&rsquo;expansion automatique du tableau sera disponible dans ce menu. Remarque : Pour activer ou désactiver l'option de développent automatique du tableau, accédez à Paramètres avancés -> Vérification de l'orthographe -> Vérification -> Options de correction automatique -> Mise en forme automatique au cours de la frappe et décochez la case Inclure nouvelles lignes et colonnes dans le tableau. Sélectionner les lignes et les colonnes Pour sélectionner la ligne entière, déplacez le curseur sur la bordure gauche de la ligne du tableau lorsque il se transforme en flèche noir , puis cliquez sur le bouton gauche de la souris. Pour sélectionner la colonne entière du tableau mis en forme, déplacez le curseur sur le bord inférieur de l'en-tête de la colonne lorsque il se transforme en flèche noir , puis cliquez sur le bouton gauche de la souris. Sur un clic unique toutes les données de la colonne sont sélectionnées (comme indiqué sur l'illustration ci-dessous); sur un double clic la colonne entière y compris l'en-tête est sélectionnée. Pour sélectionner le tableau entier, déplacez le curseur sur le coin supérieur gauche du tableau lorsque il se transforme en flèche noir en diagonale , puis cliquez sur le bouton gauche de la souris. Éditer un tableau mis en forme d'après un modèle Certains paramètres du tableau peuvent être modifiés dans l'onglet Paramètres du tableau de la barre latérale droite qui s'ouvre si vous sélectionnez au moins une cellule du tableau avec la souris et cliquez sur l'icône Paramètres du tableau sur la droite. Les sections Lignes et Colonnes en haut vous permettent de mettre en évidence certaines lignes/colonnes en leur appliquant une mise en forme spécifique ou de mettre en évidence différentes lignes/colonnes avec les différentes couleurs d'arrière-plan pour les distinguer clairement. Les options suivantes sont disponibles : En-tête - permet d'afficher la ligne d'en-tête. Total - ajoute la ligne Résumé en bas du tableau. Remarque : lorsque cette option est sélectionnée, on peut utiliser la fonction pour calculer le résumé des valeurs. Une fois la cellule pour la ligne Résumé sélectionnée, le bouton est disponible à droite de la cellule. Cliquez sur ce bouton et choisissez parmi les fonctions proposées dans la liste : Moyenne, Calculer, Max, Min, Somme, Ecartype ou Var. L'option Plus de fonctions permet d'ouvrir la fenêtre Insérer une fonction et de sélectionner une autre fonction. Si vous choisissez l'option Aucune le résumé des données de la colonne ne s'affiche pas dans la ligne Résumé. Bordé - permet l'alternance des couleurs d'arrière-plan pour les lignes paires et impaires. Bouton Filtre - permet d'afficher les flèches déroulantes dans les cellules de la ligne d'en-tête. Cette option est uniquement disponible lorsque l'option En-tête est sélectionnée. Première - accentue la colonne la plus à gauche du tableau avec un formatage spécial. Dernière - accentue la colonne la plus à droite du tableau avec un formatage spécial. Bordé - permet l'alternance des couleurs d'arrière-plan pour les colonnes paires et impaires. La section Sélectionner à partir d'un modèle vous permet de choisir l'un des styles de tableaux prédéfinis. Chaque modèle combine certains paramètres de formatage, tels qu'une couleur d'arrière-plan, un style de bordure, des lignes/colonnes en bandes, etc. Selon les options cochées dans les sections Lignes et/ou Colonnes ci-dessus, l'ensemble de modèles sera affiché différemment. Par exemple, si vous avez coché l'option En-tête dans la section Lignes et l'option Bordé dans la section Colonnes, la liste des modèles affichés inclura uniquement les modèles avec la ligne d'en-tête et les colonnes en bandes activées : Si vous souhaitez effacer le style de tableau actuel (couleur d'arrière-plan, bordures, etc.) sans supprimer le tableau lui-même, appliquez le modèle Aucun à partir de la liste des modèles : La section Redimensionner le tableau vous permet de modifier la plage de cellules auxquelles la mise en forme du tableau est appliquée. Cliquez sur le bouton Sélectionner des données - une nouvelle fenêtre s'ouvrira. Modifiez le lien vers la plage de cellules dans le champ de saisie ou sélectionnez la plage de cellules nécessaire dans la feuille de calcul avec la souris et cliquez sur le bouton OK. Remarque : Les en-têtes doivent rester sur la même ligne et la plage de valeurs du tableau de résultat doit se superposer à la plage de valeur du tableau d'origine. La section Lignes et colonnes vous permet d'effectuer les opérations suivantes : Sélectionner une ligne, une colonne, toutes les données de colonnes à l'exclusion de la ligne d'en-tête ou la table entière incluant la ligne d'en-tête. Insérer une nouvelle ligne au-dessus ou en dessous de celle sélectionnée ainsi qu'une nouvelle colonne à gauche ou à droite de celle sélectionnée. Supprimer une ligne, une colonne (en fonction de la position du curseur ou de la sélection) ou la totalité du tableau. Remarque : les options de la section Lignes et colonnes sont également accessibles depuis le menu contextuel. L'option Supprimer les valeurs dupliquées vous permet de supprimer les valeurs en double dans le tableau mis en forme. Pour plus de détails sur suppression des doublons, veuillez vous référer à cette page. L'option Conversion en plage peut être utilisée si vous souhaitez transformer le tableau en une plage de données normale en supprimant le filtre tout en préservant le style de la table (c'est-à-dire les couleurs de cellule et de police, etc.). Une fois que vous avez appliqué cette option, l'onglet Paramètres du tableau dans la barre latérale droite serait indisponible. L'option Insérer un segment vous permet de créer un segment pour filtrer les données du tableau. Pour plus de détails sur utilisation des segments, veuillez vous référer à cette page. L'option Insérer un tableau croisé dynamique vous permet de créer un tableau croisé dynamique à base du tableau auquel la mise en forme est appliqué. Pour plus de détails sur utilisation des tableaux croisés dynamiques, veuillez vous référer à cette page. Configurer les paramètres du tableau Pour changer les paramètres avancés du tableau, cliquez sur le lien Afficher les paramètres avancés sur la barre latérale droite. La fenêtre Tableau - Paramètres avancés s'ouvre : L'onglet Texte de remplacement permet de spécifier un Titre et une Description qui sera lue aux personnes avec des déficiences cognitives ou visuelles pour les aider à mieux comprendre l'information du tableau. Remarque : Pour activer ou désactiver l'option d'expansion automatique du tableau, accédez à Paramètres avancés -> Vérification de l'orthographe -> Vérification -> Options de correction automatique -> Mise en forme automatique au cours de la frappe. Utiliser la saisie automatique de formule pour ajouter des formules aux tableaux mis en forme d'après un modèle La liste de Saisie automatique de formule affiche des options disponibles pour des formules ajoutées aux tableaux mis en forme d'après un modèle. Vous pouvez faire un renvoi vers un tableau dans votre formules à l'intérieur ou en dehors du tableau. Les titres des colonnes et des éléments sont utilisés en tant que références au lieu des adresses de cellule. L'exemple ci-dessous illustre un renvoi vers le tableau dans la fonction SUM. Sélectionnez une cellule et commencez à saisir une formule qui commence par un signe égal, sélectionnez la fonction nécessaire dans la liste de Saisie automatique de formule. Après la parenthèse ouvrante, commencez à saisir le nom du tableau et sélectionnez-le dans la liste Saisie automatique de formule. Ensuite, saisissez le crochet ouvrant [ pour ouvrir la liste déroulante des colonnes et des éléments qu'on peut utiliser dans la formule. Une info-bulle avec la description de la référence s'affiche lorsque vous placez le pointeur de la souris sur la référence dans la liste. Remarque : Chaque référence doit comprendre un crochet ouvrant et un crochet fermant. Veuillez vérifier la syntaxe de la formule."
    },
   {
        "id": "UsageInstructions/GoalSeek.htm", 
        "title": "Valeur cible", 
        "body": "L'éditeur de classeurs ONLYOFFICE propose la fonctionnalité Valeur cible permettant de rechercher les nombres à substituer dans une formule pour produire un résultat que vous connaissez et que vous souhaitez obtenir. Passez à l'onglet Données et cliquez sur l'icône Valeur cible de la barre d'outils supérieure. Dans la fenêtre Valeur cible qui s'affiche, sélectionnez les options appropriées. Définir la cellule - saisissez la référence de la cellule comportant une formule. Vous pouvez utiliser l'icône pour sélectionner la cellule. Vers la valeur - saisissez le résultat que vous souhaitez obtenir dans la cellule comportant la formule. En modifiant la cellule - saisissez la référence de la cellule comportant la valeur que vous souhaitez modifier. Vous pouvez utiliser l'icône pour sélectionner la cellule. Cette cellule doit être référencée par la formule de la cellule que vous avez indiquée dans le champ Définir la cellule. Cliquez sur OK. Le résultat s'affichera dans la fenêtre Statut de la valeur cible. Cliquez sur OK pour remplacer les valeurs dans des cellules que vous avez indiquées dans les champs Définir la cellule et En modifiant la cellule."
    },
   {
        "id": "UsageInstructions/GroupData.htm", 
        "title": "Grouper des données", 
        "body": "La possibilité de regrouper les lignes et les colonnes ainsi que de créer un plan vous permet de travailler plus facilement avec une feuille de calcul contenant une grande quantité de données. Dans l'éditeur de classeurs, vous pouvez réduire ou agrandir les lignes et les colonnes groupées pour afficher uniquement les données nécessaires. Il est également possible de créer une structure à plusieurs niveaux des lignes /colonnes groupées. Lorsque c'est nécessaire, vous pouvez dissocier les lignes/colonnes précédemment groupées. Grouper les lignes et colonnes Pour grouper les lignes et colonnes : Sélectionnez la rangée de cellules que vous voulez regrouper. Basculez vers l'onglet de Données et utilisez l'une des options nécessaires dans la barre d'outils supérieure : cliquez sur le bouton Grouper puis choisissez l'option Lignes ou Colonnes dans la fenêtre Grouper qui apparaît et cliquez OK, cliquez sur la flèche vers le bas sous le bouton Grouper et choisissez l'option Grouper les lignes depuis le menu, cliquez sur la flèche vers le bas sous le bouton Grouper et choisissez l'option Grouper les colonnes depuis le menu. Les lignes et colonnes sélectionnées seront regroupées et le plan créé sera affiché à gauche des lignes et au-dessus des colonnes. Pour masquer les lignes/colonnes, cliquez sur l'icône Réduire. Pour afficher les lignes/colonnes réduites, cliquez sur l'icône Agrandir. Changer le plan Pour modifier le plan des lignes ou colonnes groupées, vous pouvez utiliser les options du menu déroulant Grouper. Les option Lignes de synthèse sous les lignes de détail et les Colonnes de synthèse à droite des colonnes de détail sont choisies par défaut. Elles permettent de modifier l'emplacement du bouton Réduire et du bouton Agrandir : Décrochez l'option Lignes de synthèse sous les lignes de détail si vous souhaitez afficher les lignes de synthèse au-dessus des lignes de détail. Décrochez l'option Colonnes de synthèse à droite des colonnes de détail si vous souhaitez afficher les colonnes de synthèse à gauches des colonnes de détail. Créer des groupes à plusieurs niveaux Pour créer une structure à plusieurs niveaux, sélectionnez une plage de celle-ci dans le groupe de lignes/ colonnes précédemment créé et regrouper la nouvelles plage sélectionnée comme décrit ci-dessus. Après cela, vous pouvez masquer et afficher les groupes par niveau en utilisant les icônes avec le numéro de niveau : . Par exemple, si vous créez un groupe imbriqué dans le groupe parent, trois niveaux seront disponibles. Il est possible de créer jusqu'à 8 niveaux. Cliquez sur la première icône de niveau pour passer au niveau qui masque toutes les données groupées : Cliquez sur la deuxième icône de niveau pour passer au niveau qui affiche les détails du groupe parent, mais masque les données du groupe imbriqué : Cliquez sur la troisième icône de niveau pour passer au niveau qui affiche tous les détails : Il est possible d'utiliser les icônes Réduire et Agrandir dans le plan pour afficher ou masquer les données correspondant à un certain niveau. Dissocier des lignes et des colonnes précédemment groupées Pour dissocier des lignes ou des colonnes précédemment groupées : Sélectionnez la plage de cellules groupées pour dissocier. Basculez vers l'onglet de Données et utilisez l'une des options nécessaires sur la barre d'outils supérieure : cliquez sur le bouton Dissocier puis choisissez l'option Lignes ou Colonnes dans la fenêtre Grouper qui apparaît et cliquez sur OK, cliquez sur la flèche vers le bas sous le bouton de Dissocier puis choisissez l'option Dissocier les lignes et Effacer le plan, cliquez sur la flèche vers le bas sous le bouton Dissocier et choisissez l'option Dissocier les colonnes depuis le menu pour dissocier les colonnes et effacer le plan de colonnes, cliquez sur la flèche vers le bas sous le bouton Dissocier et choisissez l'option Effacer le plan depuis le menu pour effacer le plan des lignes et des colonnes sans supprimer les groupes existants."
    },
   {
        "id": "UsageInstructions/HighlightedCode.htm", 
        "title": "Insérer le code en surbrillance", 
        "body": "Dans l'éditeur de classeurs, vous pouvez intégrer du code mis en surbrillance avec un style déjà appliqué selon le langage de programmation et le style de couleur dans l'application choisie. À partir de la version 8.2 ONLYOFFICE Docs, aucun module complémentaire n'est inclus dans l'éditeur par défaut. Il faut installer des modules complémentaires à l'aide du Gestionnaire de plugins. Accédez à votre feuille de calcul et placez le curseur à l'endroit où le code doit être inséré. Passez à l'onglet Modules complémentaires et sélectionnez Code en surbrillance. Spécifiez la Langue de programmation. Choisissez le Style du code pour qu'il apparaisse de manière à sembler celui dans le programme. Spécifiez si on va remplacer les tabulations par des espaces. Choisissez la Couleur de fond. Pour ce faire, déplacez manuellement le curseur sur la palette de couleurs ou ajoutez la valeur de type RBG/HSL/HEX. Cliquez sur OK pour insérer le code."
    },
   {
        "id": "UsageInstructions/InsertArrayFormulas.htm", 
        "title": "Insérer des formules de tableau", 
        "body": "L'éditeur de classeurs permet d'utiliser les formules de tableau. Les formules de tableau assurent la cohérence entre les formules dans une feuille de calcul, puisque vous pouvez saisir une seule formule au lieu de plusieurs formules habituelles, elles simplifient le travail sur une grande quantité de données et permettent de remplir une feuille avec des données, etc. Vous pouvez saisir des formules et des fonctions incorporées en tant que formules de tableau pour: effectuer plusieurs calculs à la fois et afficher un seul résultat, ou renvoyer une plage de valeurs affichées dans plusieurs lignes et/ou colonnes. Il existe également des fonctions désignées qui peuvent renvoyer plusieurs valeurs. Si vous les saisissez en appuyant sur Entrée, elles renvoient une seule valeur. Si vous sélectionnez une plage de sortie de cellules pour afficher les résultats, ensuite saisissez une fonction en appuyant sur Ctrl + Maj + Entrée, une plage de valeurs sera renvoyée (le nombre de valeurs renvoyées dépend de la taille de la plage de sortie précédemment sélectionnée). La liste ci-dessous contient des liens vers les descriptions détaillées de ces fonctions. Fonctions de tableau CELLULE CHOISIRLIGNES CHOISIRCOLS COLONNE EXCLURE EXPAND FILTRE FORMULETEXTE FREQUENCE CROISSANCE ASSEMB.H LIEN_HYPERTEXTE INDIRECT INDEX ESTFORMULE DROITEREG LOGREG INVERSEMAT PRODUITMAT MATRICE.UNITAIRE DECALER TABLEAU.ALEA LIGNE SEQUENCE TRIER PRENDRE FRACTIONNER.TEXTE DANSCOL DANSLIGNE TRANSPOSE TENDANCE ORGA.COLS ORGA.LIGNES UNIQUE ASSEMB.V EQUIVX RECHERCHEX Insérer des formules de tableau Pour insérer une formule de tableau, Sélectionnez une plage de cellules où vous souhaitez afficher les résultats. Saisissez la formule que vous souhaitez utiliser dans la barre de formule, en spécifiant les arguments nécessaires entre parenthèses (). Appuyez sur la combinaison de touches Ctrl + Maj + Entrée. Les résultats seront affichés dans la plage de cellules sélectionnée, et la formule dans la barre de formule sera automatiquement placée entre accolades { } pour indiquer qu'il s'agit d'une formule de tableau. Par exemple, {=UNIQUE(B2:D6)}. Les accolades ne peuvent pas être saisies manuellement. Créer des formules de tableau à cellule unique L'exemple qui suit permet de montrer le résultat de la formule de tableau affiché dans une seule cellule. Sélectionnez une cellule, saisissez =SOMME(C2:C11*D2:D11) et appuyez sur Ctrl + Maj + Entrée. Créer des formules de tableau à plusieurs cellules L'exemple qui suit permet de montrer le résultat de la formule de tableau affiché dans une plage de cellules. Sélectionnez une plage de cellules, saisissez =C2:C11*D2:D11 et appuyez sur Ctrl + Maj + Entrée. Modifier des formules de tableau Chaque fois que vous modifiez une formule de tableau saisie (par exemple, modifiez les arguments), vous avez besoin d'utiliser la combinaison de touches Ctrl + Maj + Entrée afin d'enregistrer les modifications. L'exemple qui suit explique comment développer une formule de tableau plusieurs cellules lorsque vous ajoutez de nouvelles données. Sélectionnez toutes les cellules qui contiennent une formule de tableau, ainsi que les cellules vides à côté des nouvelles données, modifiez les arguments dans la barre de formule afin qu'ils incluent les nouvelles données, ensuite appuyez sur Ctrl + Maj + Entrée. Si vous souhaitez appliquer une formule de tableau à plusieurs cellules dans une plage de cellules plus petite, il vous faut supprimer la formule de tableau actuelle, puis saisir une nouvelle formule de tableau. Une partie de matrice ne peut pas être modifiée ou supprimée. Si vous essayez de modifier, déplacer ou supprimer une seule cellule dans le tableau ou d'insérer une nouvelle cellule dans le tableau, vous obtenez l'avertissement: Impossible de modifier une partie de matrice. Afin de supprimer une formule de tableau, sélectionnez toutes les cellules avec la formule de tableau et cliquez sur Supprimer. Vou pouvez également sélectionner une formule de tableau dans la barre de formules, cliquez sur Supprimer et ensuite appuyez sur Ctrl + Maj + Entrée. Exemples d'utilisation de formules de tableau Cette section présente quelques exemples d'utilisation des formules de tableau pour accomplir certaines tâches. Compter le nombre de caractères dans une plage de cellules Vous pouvez utiliser la formule de tableau suivante, en remplaçant la plage de cellules dans l'argument par votre propre plage: =SOMME(NBCAR(B2:B11)). La fonction NBCAR permet de calculer la longueur de chaque chaîne de texte dans la plage de cellules. La fonction SOMME permet d'additionner les valeurs. Pour obtenir le nombre moyen de caractères, remplacez SOMME par MOYENNE. Trouver la chaîne la plus longue dans une plage de cellules Vous pouvez utiliser la formule de tableau suivante, en remplaçant la plage de cellules dans l'argument par votre propre plage: La fonction NBCAR calcule la longueur de chaque chaîne de texte dans la plage de cellules. =INDEX(B2:B11,EQUIV(MAX(NBCAR(B2:B11)),NBCAR(B2:B11),0),1). La fonction NBCAR permet de calculer la longueur de chaque chaîne de texte dans la plage de cellules. La fonction MAX permet de calculer la plus grande valeur. La fonction EQUIV trouve l'adresse de la cellule avec la chaîne la plus longue. La fonction INDEX retourne la valeur de la cellule trouvée. Pour trouver la chaîne la plus courte, remplacez MAX par MIN. Faire la somme des valeurs à base des conditions Pour faire la somme des valeurs supérieures à un nombre spécifié (2 dans cet exemple), vous pouvez utiliser la formule de tableau suivante, en remplaçant les plages de cellules dans les arguments par vos propres plages: =SOMME(IF(C2:C11>2,C2:C11)). La fonction SI permet de créer un tableau de valeurs vraies et fausses. La fonction SOMME permet d'ignorer les fausses valeurs et additionne les valeurs vraies."
    },
   {
        "id": "UsageInstructions/InsertAutoshapes.htm", 
        "title": "Insérer et mettre en forme des formes automatiques", 
        "body": "Insérer une forme automatique Pour insérer une forme dans l'éditeur de classeurs, passez à l'onglet Insertion de la barre d'outils supérieure, cliquez sur l'icône Forme de la barre d'outils supérieure, sélectionnez l'un des groupes des formes automatiques disponibles depuis la Galerie de formes: Récemment utilisé, Formes de base, Flèches figurées, Maths, Graphiques, Étoiles et rubans, Légendes, Boutons, Rectangles, Lignes, cliquez sur la forme automatique nécessaire du groupe sélectionné, placez le curseur de la souris là où vous voulez insérer la forme, une fois que la forme automatique est ajoutée vous pouvez modifier sa taille et sa position aussi bien que ses propriétés. Vous pouvez sauvegarder la forme en tant qu'image sur votre ordinateur à l'aide de l'option Enregistrer en tant qu'image dans le menu contextuel. Copier la mise en forme du style de la forme automatique Pour copier la mise en forme du style d'une forme automatique, sélectionnez la forme automatique dont vous souhaitez copier la mise en forme en utilisant la souris ou le clavier, cliquez l'icône Copier le style sous l'onglet Accueil de la barre d'outils supérieure ( le pointeur de la souris ressemblera à ceci ), sélectionnez la forme automatique à laquelle vous souhaitez appliquer la mise en forme. Régler les paramètres de la forme automatique Pour aligner et organiser les formes automatiques, utilisez le menu contextuel. Les options du menu sont les suivantes: Couper, Copier, Coller - les options nécessaires pour couper ou coller le texte / l'objet sélectionné et coller un passage de texte précédemment coupé / copié ou un objet à la position actuelle du curseur. Organiser sert à placer la forme sélectionnée au premier plan, envoyer à l'arrière-plan, avancer ou reculer ainsi que grouper ou dégrouper des formes pour effectuer des opérations avec plusieurs à la fois. . Pour en savoir plus sur l'organisation des objets, vous pouvez vous référer à cette page. Aligner sert à aligner la forme automatique à gauche, au centre, à droite, en haut, au milieu ou en bas. Pour en savoir plus sur l'alignement des objets, veuillez consulter cette page. Rotation permet de faire pivoter la forme automatique de 90 degrés dans le sens des aiguilles d'une montre ou dans le sens inverse des aiguilles d'une montre, ainsi que de retourner la forme automatique horizontalement ou verticalement. Affecter une macro sert à rendre l'accès à macro plus rapide et facile dans une feuille de calcul, vous pouvez affecter une macro à une forme. Une fois la macro affectée, la forme apparaît ainsi comme un bouton de contrôle et vous pouvez lancer la macro par un clic dessus. Pour en savoir plus, veuillez consulter la section Affecter une macro à une forme de ce guide-ci. Enregistrer en tant qu'image sert à sauvegarder la forme automatique en tant qu'image sur votre ordinateur. Modifier les points sert à personnaliser ou modifier le contour d'une forme. Pour activer les points d'ancrage modifiables, faites un clic droit sur la forme et sélectionnez Modifier les points dans le menu ou cliquez sur Modifier la forme > Modifier les points. Les carreaux noirs qui apparaissent sont les points de rencontre entre deux lignes et la ligne rouge trace le contour de la forme. Cliquez sur l'un de ces points et faites-le glisser pour repositionner et modifier le contour de la forme. Lorsque vous cliquez sur le point d'ancrage, deux lignes bleus avec des carreaux blancs apparaissent. Ce sont les points de contrôle Bézier permettant de créer une courbe et de modifier la finesse de la courbe. Autant que les points d'ancrage sont actifs, vous pouvez les modifier et supprimer. Pour ajouter un point de contrôle à une forme, maintenez la touche Ctrl enfoncée et cliquez sur l'emplacement du point de contrôle souhaité. Pour supprimer un point, maintenez la touche Ctrl enfoncée et cliquez sur le point superflu. Paramètres avancés de la forme automatique sert à ouvrir la fenêtre Forme - Paramètres avancés. Certains paramètres de la forme automatique peuvent être modifiés dans l'onglet Paramètres de la forme de la barre latérale droite qui s'ouvre si vous sélectionnez la forme automatique avec la souris et cliquez sur l'icône Paramètres de la forme . Vous pouvez y modifier les paramètres suivants: Remplissage - utilisez cette section pour sélectionner le remplissage de la forme automatique. Les options disponibles sont les suivantes: Couleur de remplissage - sélectionnez cette option pour spécifier la couleur unie à remplir l'espace intérieur de la forme. Cliquez sur la case de couleur en dessous et sélectionnez la couleur voulue à partir de l'ensemble de couleurs disponibles ou spécifiez n'importe quelle couleur de votre choix: Couleurs de thème - les couleurs qui correspondent à la palette de couleurs sélectionnée de la feuille de calcul. Couleurs standard - le jeu de couleurs par défaut. Il y a deux façons d'appliquer une couleur personnalisée: Pipette - sert à sélectionner la couleur nécessaire en cliquant sur celle-ci dans le document. Plus de couleurs sert à rechercher la couleur manquante dans la palette. Sélectionnez la gamme de couleurs nécessaire en déplaçant le curseur vertical et définissez la couleur spécifique en faisant glisser le sélecteur de couleur dans le grand champ de couleur carré. Une fois que vous sélectionnez une couleur avec le sélecteur de couleur, les valeurs de couleur appropriées RGB et sRGB seront affichées dans les champs à droite. Vous pouvez également spécifier une couleur sur la base du modèle de couleur RGB en entrant les valeurs numériques nécessaires dans les champs R, G, B (rouge, vert, bleu) ou saisir le code hexadécimal dans le champ sRGB marqué par le signe #. La couleur sélectionnée s'affiche dans l'aperçu Nouveau. Si l'objet a déjà été rempli d'une couleur personnalisée, cette couleur sera affichée dans la case Actuel que vous puissiez comparer les couleurs originales et modifiées. Lorsque la couleur est spécifiée, cliquez sur le bouton Ajouter: La couleur personnalisée sera appliquée à l'élément sélectionné et sera ajoutée dans la palette Couleurs récentes. Remplissage en dégradé - sélectionnez cette option pour spécifier deux couleurs pour créer une transition douce entre elles et remplir la forme. Personnaliser votre dégradé sans aucune contrainte. Cliquez sur l'icône Paramètres de la forme. pour ouvrir le menu Remplissage de la barre latérale sur la droite: Les options disponibles du menu: Style - choisissez Linéaire or Radial: Linéaire sert à remplir par un dégradé de gauche à droite, de bas en haut ou sous l'angle partant en direction définie. La fenêtre d'aperçu Direction affiche la couleur de dégradé sélectionnée, cliquez sur la flèche pour définir la direction du dégradé. Utilisez les paramètres Angle pour définir un angle précis du dégradé. Radial sert à remplir par un dégradé de forme circulaire entre le point de départ et le point d'arrivée. Point de dégradé est le point d'arrêt de d'une couleur et de la transition entre les couleurs. Utilisez le bouton Ajouter un point de dégradé ou le curseur de dégradé pour ajouter un point de dégradé. Vous pouvez ajouter 10 points de dégradé. Le nouveau arrêt de couleur n'affecte pas l'aspect actuel du dégradé. Utilisez le bouton Supprimer un point de dégradé pour supprimer un certain point de dégradé. Faites glisser le curseur de déragé pour changer l'emplacement des points de dégradé ou spécifiez la Position en pourcentage pour l'emplacement plus précis. Pour choisir la couleur au dégradé, cliquez sur l'arrêt concerné sur le curseur de dégradé, ensuite cliquez sur Couleur pour sélectionner la couleur appropriée. Image ou Texture - sélectionnez cette option pour utiliser une image ou une texture prédéfinie en tant que l'arrière-plan de la forme. Si vous souhaitez utiliser une image en tant que l'arrière-plan de la forme, cliquez sur le bouton Sélectionner l'image et ajoutez une image À partir d'un fichier en la sélectionnant sur votre ordinateur ou À partir d'une URL en insérant l'adresse URL appropriée dans la fenêtre ouverte, ou À partir de l'espace de stockage en sélectionnant l'image nécessaire sur votre portail. Si vous souhaitez utiliser une texture en tant que arrière-plan de la forme, utilisez le menu déroulant Avec texture et sélectionnez le préréglage de la texture nécessaire. Actuellement, les textures suivantes sont disponibles: Toile, Carton, Tissu foncé, Grain, Granit, Papier gris, Tricot, Cuir, Papier brun, Papyrus, Bois. Si l'image sélectionnée est plus grande ou plus petite que la forme automatique, vous pouvez profiter d'une des options Étirement ou Tuile depuis la liste déroulante. L'option Prolonger permet de régler la taille de l'image pour l'adapter à la taille de la forme automatique afin qu'elle puisse remplir tout l'espace uniformément. L'option Tuile permet d'afficher seulement une partie de l'image plus grande en gardant ses dimensions d'origine, ou de répéter l'image plus petite en conservant ses dimensions initiales sur la surface de la forme automatique ou de la diapositive afin qu'elle puisse remplir tout l'espace uniformément. Remarque: tout préréglage Texture sélectionné remplit l'espace de façon uniforme, mais vous pouvez toujours appliquer l'effet Prolonger, si nécessaire. Modèle - sélectionnez cette option pour sélectionner le modèle à deux couleurs composé des éléments répétés pour remplir l'espace intérieur de la forme. Modèle - sélectionnez un des modèles prédéfinis du menu. Couleur de premier plan - cliquez sur cette palette de couleurs pour changer la couleur des éléments du modèle. Couleur d'arrière-plan - cliquez sur cette palette de couleurs pour changer de l'arrière-plan du modèle. Aucun remplissage - sélectionnez cette option si vous ne voulez pas utiliser un remplissage. Opacité sert à régler le niveau d'Opacité des formes automatiques en faisant glisser le curseur ou en saisissant la valeur de pourcentage à la main. La valeur par défaut est 100%. Celle-ci correspond à l'opacité complète. La valeur 0% correspond à la transparence totale. Trait - sert à régler la taille, la couleur et le type du contour de la forme. Pour modifier la largeur du trait, sélectionnez l'une des options disponibles depuis la liste déroulante Taille. Les options disponibles sont les suivantes: 0,5 pt, 1 pt, 1,5 pt, 2,25 pt, 3 pt, 4,5 pt, 6 pt ou Pas de ligne si vous ne voulez pas utiliser de trait. Pour changer la couleur du contour, cliquez sur la case colorée et sélectionnez la couleur voulue. Pour modifier le type de contour, sélectionnez l'option voulue dans la liste déroulante correspondante (une ligne continue est appliquée par défaut, vous pouvez la remplacer par l'une des lignes pointillées disponibles). Pour modifier l'opacité du trait, saisissez la valeur manuellement ou utilisez le curseur approprié. Rotation permet de faire pivoter la forme de 90 degrés dans le sens des aiguilles d'une montre ou dans le sens inverse des aiguilles d'une montre, ainsi que de retourner l'image horizontalement ou verticalement. Cliquez sur l'un des boutons: pour faire pivoter la forme de 90 degrés dans le sens inverse des aiguilles d'une montre pour faire pivoter la forme de 90 degrés dans le sens des aiguilles d'une montre pour retourner la forme horizontalement (de gauche à droite) pour retourner la forme verticalement (à l'envers) Modifier la forme sert à modifier le contour de la forme ou à remplacer la forme actuelle par une autre en la sélectionnant de la liste déroulante. Modifier les points sert à personnaliser ou modifier le contour d'une forme. Lorsque vous cliquez sur le point d'ancrage, deux lignes bleus avec des carreaux blancs apparaissent. Ce sont les points de contrôle Bézier permettant de créer une courbe et de modifier la finesse de la courbe. Autant que les points d'ancrage sont actifs, vous pouvez les modifier et supprimer. Pour ajouter un point de contrôle à une forme, maintenez la touche Ctrl enfoncée et cliquez sur l'emplacement du point de contrôle souhaité. Pour supprimer un point, maintenez la touche Ctrl enfoncée et cliquez sur le point superflu. Modifier la forme sert à remplacer la forme existante. Sélectionnez une autre forme dans la galerie de formas de la liste déroulante, Ombre - accédez ce menu pour sélectionner l'un des styles d'ombre pour une forme. Aucune ombre - désactivez cette option pour afficher une ombre et vice versa. Couleur - sélectionnez l'une des couleurs disponibles de la palette Couleurs de thème ou Couleurs standard; utilisez l'outil Pipette pour copier la couleur d'un autre objet du document; ou cliquez sur Plus de couleurs dans le menu pour créer une couleur personnalisée. Ajuster l'ombre - créez une ombre personnalisée utilisant les curseurs suivants: Transparence - réglez la transparence de l'ombre. Taille - réglez la taille de l'ombre. Angle - réglez l'angle de l'ombre par rapport à l'objet. Distance - réglez la distance entre l'ombre et l'objet. Configurer les paramètres avancés de la forme Pour configurer les paramètres avancés de la forme automatique, cliquez sur le lien Afficher les paramètres avancés sur la barre latérale droite. La fenêtre Forme - Paramètres avancés s'ouvrira: L'onglet Taille comporte les paramètres suivants: Largeur et Hauteur utilisez ces options pour changer la largeur et/ou la hauteur de la forme. Lorsque le bouton Proportions constantes est activé (dans ce cas, il ressemble à ceci), la largeur et la hauteur seront changées en même temps et le ratio d'aspect de la forme automatique originale sera préservé. L'onglet Rotation comporte les paramètres suivants: Angle - utilisez cette option pour faire pivoter la forme d'un angle exactement spécifié. Entrez la valeur souhaitée mesurée en degrés dans le champ ou réglez-la à l'aide des flèches situées à droite. Retourné - cochez la case Horizontalement pour retourner la forme horizontalement (de gauche à droite) ou la case Verticalement pour retourner l'image verticalement (à l'envers). L'onglet Poids et flèches contient les paramètres suivants: Style de ligne - ce groupe d'options vous permet de spécifier les paramètres suivants: Type de lettrine - cette option permet de définir le style de la fin de la ligne, ainsi elle peut être appliquée seulement aux formes avec un contour ouvert telles que des lignes, des polylignes etc.: Plat - les points finaux seront plats. Arrondi - les points finaux seront arrondis. Carré - les points finaux seront carrés. Type de jointure - cette option permet de définir le style de l'intersection de deux lignes, par exemple, une polyligne, les coins du triangle ou le contour du rectangle: Arrondi - le coin sera arrondi. Plaque - le coin sera coupé d'une manière angulaire. Onglet - l'angle sera aiguisé. Bien adapté pour les formes à angles vifs. Remarque: l'effet sera plus visible si vous utilisez un contour plus épais. Flèches - ce groupe d'options est disponible pour les formes du groupe Lignes. Il permet de définir le Style de début et Style de fin aussi bien que la Taille des flèches en sélectionnant l'option appropriée de la liste déroulante. L'onglet Zone de texte vous permet de Redimensionner la forme pour contenir la texte, Autoriser le texte à sortir de la forme ou changer les marges internes En haut, En bas, A gauche et A droite (c'est-à-dire la distance entre le texte à l'intérieur de la forme et les bordures de la forme automatique). Remarque: cet onglet n'est disponible que si tu texte est ajouté dans la forme automatique, sinon l'onglet est désactivé. L'onglet Colonnes permet d'ajouter des colonnes de texte dans la forme automatique en spécifiant le Nombre de colonnes nécessaires (jusqu'à 16) et Espacement entre les colonnes. Une fois que vous avez cliqué sur OK, le texte qui existe déjà ou tout autre texte que vous entrez dans la forme automatique apparaîtra dans les colonnes et circulera d'une colonne à l'autre. L'onglet Alignement dans une cellule comprend les options suivantes: Déplacer et dimensionner avec des cellules - cette option permet de placer la forme derrière la cellule. Quand une cellule se déplace (par exemple: insertion ou suppression des lignes/colonnes), la forme se déplace aussi. Quand vous ajustez la largeur ou la hauteur de la cellule, la dimension de la forme s'ajuste aussi. Déplacer sans dimensionner avec les cellules - cette option permet de placé la forme derrière la cellule mais d'empêcher sa redimensionnement. Quand une cellule se déplace, la forme se déplace aussi, mais si vous redimensionnez la cellule, la forme demeure inchangée. Ne pas déplacer et dimensionner avec les cellules - cette option empêche le déplacement ou redimensionnement de la forme si la position ou la dimension de la cellule restent inchangées. L'onglet Texte de remplacement permet de spécifier un Titre et une Description qui sera lue aux personnes avec des déficiences cognitives ou visuelles pour les aider à mieux comprendre l'information de la forme. Insérer et mettre en forme du texte dans la forme automatique Pour insérer un texte dans la forme automatique, sélectionnez la forme avec la souris et commencez à taper votre texte. Le texte que vous ajoutez fait partie de la forme (ainsi si vous déplacez ou faites pivoter la forme, le texte change de position lui aussi). Toutes les options de mise en forme que vous pouvez appliquer au texte dans la forme automatique sont listées ici. Joindre des formes automatiques à l'aide de connecteurs Vous pouvez connecter des formes automatiques à l'aide de lignes munies de points de connexion pour démontrer les dépendances entre les objets (par exemple, si vous souhaitez créer un diagramme). Pour ce faire, cliquez sur Forme sous l'onglet Insertion de la barre d'outils supérieure, sélectionnez le groupe Lignes dans le menu, cliquez sur la forme souhaitée dans le groupe sélectionné (à l'exception des trois dernières formes qui ne sont pas des connecteurs, à savoir les formes Courbe, Dessin à main levée et Forme libre), faites glisser le curseur de la souris vers la première forme automatique et cliquez sur l'un des points de connexion qui s'affiche sur le contour de la forme, faites glisser le curseur de la souris vers la deuxième forme automatique et cliquez sur le point de connexion voulu sur son contour. Si vous déplacez les formes automatiques jointes, le connecteur reste attaché aux formes et se déplace avec elles. Vous pouvez également détacher le connecteur des formes, puis l'attacher à d'autres points de connexion. Affecter une macro à une forme Pour rendre l'accès à macro plus rapide et facile dans une feuille de calcul, vous pouvez affecter une macro à une forme. Une fois la macro affectée, la forme apparaît ainsi comme un bouton de contrôle et vous pouvez lancer la macro par un clic dessus. Pour affecter une macro: Cliquer avec le bouton droit de la souris sur la forme et sélectionnez l'option Affecter une macro dans le menu déroulant. La boîte de dialogue Affecter une macro s'affiche. Sélectionnez la macro dans la liste ou saisissez le nom et cliquez sur OK."
    },
   {
        "id": "UsageInstructions/InsertChart.htm", 
        "title": "Insérer des graphiques", 
        "body": "Insérer un graphique recommandé La façon la plus simple d'insérer un graphique dans l'éditeur de classeurs est à l'aide de l'outil Graphique recommandé qui fait fait des suggestions de graphiques selon vos données et affiche l'aperçu de données dans chaque type de graphique. Sélectionnez la plage de cellules comportant des données que vous souhaitez utiliser pour le graphique, Passez à l'onglet Insertion de la barre d'outils supérieure. Cliquez sur l'icône Graphique recommandé de la barre d'outils supérieure. Naviguez à travers des graphiques recommandés pour visualiser votre graphique. Utilisez les onglets de gauche pour afficher l'aperçu d'autres types de graphiques. Une fois le graphique sélectionné, cliquez sur OK. Insérer et configurer un graphique manuellement Pour insérer un graphique et configurer tous ces paramètres manuellement, Sélectionnez la plage de cellules comportant des données que vous souhaitez utiliser pour le graphique, Passez à l'onglet Insertion de la barre d'outils supérieure. Cliquez sur l'icône Graphique de la barre d'outils supérieure. Sélectionnez le type de graphique approprié: Graphique à colonnes Histogramme groupé Histogramme empilé Histogramme empilé 100 % Histogramme groupé en 3D Histogramme empilé en 3D Histogramme empilé 100 % en 3D Histogrammes en 3D Graphiques en ligne Ligne Lignes empilées Lignes empilées 100% Lignes avec marques de données Lignes empilées avec marques de données Lignes empilées 100 % avec des marques de données Lignes 3D Graphiques en secteurs Secteurs Donut Camembert 3D Graphiques à barres Barres groupées Barres empilées Barres empilées 100% Barres groupées en 3D Barres empilées en 3D Barres empilées 100% en 3D Graphiques en aires Surface Aires empilées Aires empilées 100% Graphiques boursiers Nuage de points (XY) Disperser Barres empilées Disperser avec lignes lissées et marqueurs Disperser avec lignes lissées Disperser avec des lignes droites et marqueurs Disperser avec des lignes droites Radars Radar Radar avec marqueurs Radar plein Graphiques Combo Histogramme groupé - lignes Histogramme groupé - ligne sur un axe secondaire Aires empilées - histogramme groupé Combinaison personnalisée Après cela, le graphique sera ajouté à la feuille de calcul. Remarque: L'éditeur de classeurs ONLYOFFICE prend en charge la modification des graphiques créés dans d'autres applications tels que: Graphiques en pyramides, à barres (pyramides), horizontal/vertical à cylindre, horizontal/vertical à cônes. Vous pouvez ouvrir le fichier comportant tels graphiques et les modifier en utilisant les outils disponibles. Les graphique suivants sont pris en charge en lecture seule: Histogramme, Graphique en cascade, Graphique en entonnoir. Régler les paramètres du graphique Vous pouvez maintenant modifier les propriétés du graphique inséré: Pour modifier le type de graphique, Sélectionnez le graphique avec la souris. Cliquez sur l'icône Paramètres du graphique. sur la barre latérale gauche, Ouvrez la liste déroulante Style et sélectionnez le style qui vous convient le mieux. Ouvrez la liste déroulante Modifier le type et sélectionnez le type approprié. Cliquez sur l'option Intervertir ligne/colonne pour repositionner les lignes et les colonnes du graphique. Le type et le style de graphique sélectionnés seront modifiés. En outre, la configuration de Rotation 3D est disponible pour des graphiques 3D: Rotation X - définissez la valeur de rotation de l'axe X en utilisant le clavier ou les flèches Gauche et Droite. Rotation Y - définissez la valeur de rotation de l'axe Y en utilisant le clavier ou les flèches Haut et Bas. Perspective - définissez la valeur appropriée de profondeur en utilisant le clavier ou les flèches Rétrécir le champ ou Élargir le champ. Axes à angle droit sert à définir l'angle de l'axe à droite. Mise à l'échelle automatique - activez cette option pour mettre automatiquement à l'échelle la profondeur et la hauteur du graphique ou désactivez cette option pour définir manuellement la profondeur et la hauteur. Profondeur (% de la base) - définissez la profondeur en utilisant le clavier ou le flèches. Hauteur (% de la base) - définissez la hauteur en utilisant le clavier ou le flèches. Rotation par défaut - restaurer les paramètres 3D par défaut. Veuillez noter que c'est pas possible de modifier chaque élément du graphique, tous paramètres seront appliqués au graphique dans son ensemble. Pour modifier les données du graphiques: Cliquez sur le bouton Sélectionner des données sur le panneau latéral droit. Utilisez la boîte de dialogue Données du graphique pour gérer la Plage de données du graphique, les Entrées de légende (Série), le Étiquette de l'axe horizontal (abscisse), et Intervertir ligne/colonne. Plage de données du graphique - sélectionnez les données pour votre graphique. Cliquez sur l'icône à droite de la boîte Plage de données du graphique pour sélectionner la plage de données. Entrées de légende (Série) - ajouter, modifier ou supprimer les entrées de légende. Tapez ou sélectionnez le nom de série des entrées de légende. Dans Entrées de légende (Série), cliquez sur le bouton Ajouter. Dans Modifier la série, saisissez une nouvelle entrée de légende ou cliquez sur l'icône à droite de la zone Nom de la série. Étiquette de l'axe horizontal (abscisse) - modifier le texte de l'étiquette de l'axe. Dans Étiquette de l'axe horizontal (abscisse), cliquez sur Modifier. Dans Plage de données de l'étiquette de l'axe, saisissez les étiquettes à ajouter ou cliquez sur l'icône à droite de la zone Plage de données de l'étiquette de l'axe pour sélectionner la plage de données. Intervertir ligne/colonne - réorganiser la configuration de données dans la feuille de calcul selon vos besoins. Changer de ligne ou de colonne pour afficher des données sur un autre axe. Cliquez sur OK pour appliquer toutes les modifications et fermer la fenêtre. Cliquez sur Afficher les paramètres avancés pour modifier les paramètres suivants: Disposition, Axe vertical, Axe vertical secondaire, Axe horizontal, Axe horizontal secondaire, Accrochage à la cellule et Texte de remplacement. L'onglet Mise en page vous permet de modifier la disposition des éléments de graphique. Définissez la position du Titre du graphique sur votre graphique en sélectionnant l'option appropriée dans la liste déroulante: Aucun - pour ne pas afficher le titre du graphique, Superposition pour superposer et centrer le titre sur la zone de tracé, Sans superposition pour afficher le titre au-dessus de la zone de tracé. Spécifiez la position de la Légende sur votre graphique en sélectionnant l'option voulue dans la liste déroulante: Aucun - pour ne pas afficher la légende, En bas pour afficher la légende et l'aligner au bas de la zone de tracé, En haut pour afficher la légende et l'aligner en haut de la zone de tracé, À droite pour afficher la légende et l'aligner à droite de la zone de tracé, À gauche pour afficher la légende et l'aligner à gauche de la zone de tracé, Superposition à gauche pour superposer et centrer la légende à gauche de la zone de tracé, Superposition à droite pour superposer et centrer la légende à droite de la zone de tracé. Spécifiez les paramètres des Étiquettes de données (c'est-à-dire les étiquettes de texte représentant les valeurs exactes des points de données): Définissez la position des Étiquettes de données par rapport aux points de données en sélectionnant l'option nécessaire dans la liste déroulante. Les options disponibles varient en fonction du type de graphique sélectionné. Pour les graphiques en Colonnes/Barres, vous pouvez choisir les options suivantes: Aucun, Au centre, En bas à l'intérieur, En haut à l'intérieur, En haut à l'extérieur. Pour les graphiques en Ligne/ Nuage de points (XY)/Boursier, vous pouvez choisir les options suivantes: Aucun, Centre, À gauche, À droite, En haut. Pour les graphiques Secteur, vous pouvez choisir les options suivantes: Aucun, Au centre, Ajuster à la largeur, En haut à l'intérieur, En haut à l'extérieur. Pour les graphiques En aire ainsi que pour les graphiques 3D en Colonnes, En ligne, Radar et En barres vous pouvez choisir les options suivantes: Aucun, Au centre. Sélectionnez les données que vous souhaitez inclure dans vos étiquettes en cochant les cases correspondantes: Nom de série, Nom de catégorie, Valeur, Saisissez un caractère (virgule, point-virgule, etc.) que vous souhaitez utiliser pour séparer plusieurs étiquettes dans le champ de saisie Séparateur des étiquettes de données. Lignes - permet de choisir un style de ligne pour les graphiques en Ligne/Nuage de points (XY). Vous pouvez choisir parmi les options suivantes: Droit pour utiliser des lignes droites entre les points de données, Lisse pour utiliser des courbes lisses entre les points de données, ou Rien pour ne pas afficher les lignes. Marqueurs - sert à spécifier si les marqueurs doivent être affichés (si la case est cochée) ou non (si la case n'est pas cochée) pour les graphiques Ligne/Nuage de points (XY). Remarque: les options Lignes et Marqueurs sont disponibles uniquement pour les graphiques en Ligne et Ligne/Nuage de points (XY). Options de la ligne de tendance - utilisez l'option Afficher l'équation sur le graphique pour représenter les équations sur la graphique. Cette option est disponible pour les graphiques comportant les courbes de tendance. L'onglet Axe vertical vous permet de modifier les paramètres de l'axe vertical, également appelés axe des valeurs ou axe y, qui affiche des valeurs numériques. Veuillez noter que l'axe vertical sera l'axe des catégories qui affiche des étiquettes de texte pour les graphiques En barres. Dans ce cas, les options de l'onglet Axe vertical correspondront à celles décrites dans la section suivante. Pour les Graphiques Nuage de points (XY), les deux axes sont des axes de valeur. Remarque: les sections Paramètres des axes et Quadrillage seront désactivées pour les Graphiques à secteurs, car les graphiques de ce type n'ont ni axes ni lignes de quadrillage. Sélectionnez Masquer pour masquer l'axe vertical du graphique, laissez cette option décochée pour afficher l'axe. Définissez l'orientation du Titre en choisissant l'option appropriée de la liste déroulante: Aucun - pour ne pas afficher le titre de l'axe vertical, Incliné pour afficher le titre de bas en haut à gauche de l'axe vertical, Horizontal pour afficher le titre horizontalement à gauche de l'axe vertical. Valeur minimale sert à définir la valeur la plus basse à afficher au début de l'axe vertical. L'option Auto est sélectionnée par défaut, dans ce cas la valeur minimale est calculée automatiquement en fonction de la plage de données sélectionnée. Vous pouvez sélectionner l'option Fixé dans la liste déroulante et spécifier une valeur différente dans le champ de saisie sur la droite. Valeur maximale sert à définir la valeur la plus élevée à afficher à la fin de l'axe vertical. L'option Auto est sélectionnée par défaut, dans ce cas la valeur maximale est calculée automatiquement en fonction de la plage de données sélectionnée. Vous pouvez sélectionner l'option Fixé dans la liste déroulante et spécifier une valeur différente dans le champ de saisie sur la droite. Croisement de l'axe - sert à spécifier un point sur l'axe vertical où l'axe horizontal doit le traverser. L'option Auto est sélectionnée par défaut, dans ce cas la valeur du point d'intersection est calculée automatiquement en fonction de la plage de données sélectionnée. Vous pouvez sélectionner l'option Valeur dans la liste déroulante et spécifier une valeur différente dans le champ de saisie à droite, ou définir le point d'intersection des axes à la Valeur minimum/maximum sur l'axe vertical. Unités d'affichage - sert à déterminer la représentation des valeurs numériques le long de l'axe vertical. Cette option peut être utile si vous travaillez avec de grands nombres et souhaitez que les valeurs sur l'axe soient affichées de manière plus compacte et plus lisible (par exemple, vous pouvez représenter 50 000 comme 50 en utilisant les unités d'affichage de Milliers). Sélectionnez les unités souhaitées dans la liste déroulante: Centaines, Milliers, 10 000, 100 000, Millions, 10 000 000, 100 000 000, Milliards, Billions, ou choisissez l'option Aucun pour retourner aux unités par défaut. Valeurs dans l'ordre inverse - sert à afficher les valeurs dans la direction opposée. Lorsque la case n'est pas cochée, la valeur la plus basse est en bas et la valeur la plus haute est en haut de l'axe. Lorsque la case est cochée, les valeurs sont triées de haut en bas. Échelle logarithmique - sert à activer l'échelle logarithmique pour la Base définie par l'utilisateur. La section Options de graduations permet d'ajuster l'apparence des graduations sur l'échelle verticale. Les graduations du type principal sont les divisions à plus grande échelle qui peuvent avoir des étiquettes affichant des valeurs numériques. Les graduations du type secondaire sont les subdivisions d'échelle qui sont placées entre les graduations principales et n'ont pas d'étiquettes. Les graduations définissent également l'endroit où le quadrillage peut être affiché, si l'option correspondante est définie dans l'onglet Disposition. Les listes déroulantes Type principal/secondaire contiennent les options de placement suivantes: Aucun pour ne pas afficher les graduations principales/secondaires, Sur l'axe pour afficher les graduations principales/secondaires des deux côtés de l'axe, Dans pour afficher les graduations principales/secondaires dans l'axe, À l'extérieur</b> pour afficher les graduations principales/secondaires à l'extérieur de l'axe. La section Options d'étiquettes permet d'ajuster l'apparence des étiquettes de graduations du type principal qui affichent des valeurs. Pour spécifier la Position de l'étiquette par rapport à l'axe vertical, sélectionnez l'option voulue dans la liste déroulante: Aucun pour ne pas afficher les étiquettes de graduations, En bas pour afficher les étiquettes de graduations à gauche de la zone de tracé, En haut pour afficher les étiquettes de graduations à droite de la zone de tracé, À côté de l'axe pour afficher les étiquettes de graduations à côté de l'axe. Pour définir le Format d'étiquette cliquez sur le bouton format d'étiquette et choisissez la catégorie appropriée. Les catégories du format d'étiquette disponibles: Général Nombre Scientifique Comptabilité Monétaire Date Temps Pourcentage Fraction Texte Personnalisé Les options du format d'étiquette varient en fonction de la catégorie sélectionné. Pour en savoir plus sur la modification du format de nombre, veuillez consulter cette page. Activez Lié à la source pour conserver la représentation de nombre de la source de données du graphique. Remarque: Les axes secondaires sont pris en charge par des graphiques Combo uniquement. Axes secondaires sont utiles pour des graphiques Combo lorsque les nombres varient considérablement, ou lorsque des types de données mixtes sont utilisés pour créer un graphique. Avec des axes secondaires on peut lire et comprendre un graphique combiné plus facilement. L'onglet Axe vertical/horizontal secondaire s'affiche lorsque vous choisissez une série de données appropriée pour votre graphique combiné. Les options et les paramètres disponibles sous l'onglet Axe vertical/horizontal secondaire sont les mêmes que ceux sous l'onglet Axe vertical/horizontal. Pour une description détaillée des options disponibles sous l'onglet Axe vertical/horizontal, veuillez consulter les sections appropriées ci-dessus/ci-dessous. L'onglet Axe horizontal vous permet de modifier les paramètres de l'axe horizontal, également appelés axe des catégories ou axe x, qui affiche des étiquettes textuels. Veuillez noter que l'axe horizontal sera l'axe des valeurs qui affiche des valeurs numériques pour les graphiques En barres. Dans ce cas, les options de l'onglet Axe horizontal correspondent à celles décrites dans la section précédente. Pour les Graphiques Nuage de points (XY), les deux axes sont des axes de valeur. Sélectionnez Masquer pour masquer l'axe horizontal du graphique, laissez cette option décochée pour afficher l'axe. Définissez l'orientation du Titre en choisissant l'option appropriée de la liste déroulante: Aucun pour ne pas afficher le titre de l'axe horizontal. Sans superposition pour afficher le titre en-dessous de l'axe horizontal. Quadrillage permet de spécifier les lignes du Quadrillage horizontal que vous souhaitez afficher en sélectionnant l'option voulue dans la liste déroulante: Aucun, Principal, Secondaire ou Principales et secondaires. Croisement de l'axe - sert à spécifier un point sur l'axe horizontal où l'axe vertical doit le traverser. L'option Auto est sélectionnée par défaut, dans ce cas la valeur du point d'intersection est calculée automatiquement en fonction de la plage de données sélectionnée. Vous pouvez sélectionner l'option Valeur dans la liste déroulante et spécifier une valeur différente dans le champ de saisie à droite, ou définir le point d'intersection des axes à la Valeur minimale/maximale (correspondant à la première et la dernière catégorie) sur l'axe vertical. Position de l'axe - sert à spécifier où les étiquettes de l'axe doivent être placés: Graduations ou Entre graduations. Valeurs dans l'ordre inverse - sert à afficher les catégories dans la direction opposée. Lorsque la case est désactivée, les valeurs sont affichées de gauche à droite. Lorsque la case est activée, les valeurs sont affichées de droite à gauche. La section Options de graduations permet d'ajuster l'apparence des graduations sur l'échelle horizontale. Les graduations principales sont les divisions à plus grande échelle qui peuvent avoir des étiquettes affichant des valeurs de catégorie. Les graduations secondaires sont les divisions à moins grande d'échelle qui sont placées entre les graduations principales et n'ont pas d'étiquettes. Les graduations définissent également l'endroit où le quadrillage peut être affiché, si l'option correspondante est définie dans l'onglet Disposition. Vous pouvez ajuster les paramètres de graduation suivants: Type principale/secondaire - sert à spécifier les options de placement suivantes: Aucun pour ne pas afficher les graduations principales/secondaires, Sur l'axe pour afficher les graduations principales/secondaires des deux côtés de l'axe, Dans pour afficher les graduations principales/secondaires dans l'axe, À l'extérieur pour afficher les graduations principales/secondaires à l'extérieur de l'axe. Intervalle entre les graduations - sert à spécifier le nombre de catégories à afficher entre deux marques de graduation adjacentes. La section Options d'étiquettes permet d'ajuster l'apparence des étiquettes qui affichent des catégories. Position de l'étiquette sert à spécifier où les étiquettes de l'axe doivent être placés par rapport à l'axe horizontal: Sélectionnez l'option souhaitée dans la liste déroulante: Aucun pour ne pas afficher les étiquettes de catégorie, En bas pour afficher les étiquettes de catégorie au bas de la zone de tracé, En haut pour afficher les étiquettes de catégorie en haut de la zone de tracé, À côté de l'axe pour afficher les étiquettes de catégorie à côté de l'axe. Distance de l'étiquette de l'axe - sert à spécifier la distance entre les étiquettes et l'axe. Spécifiez la valeur nécessaire dans le champ situé à droite. Plus la valeur que vous définissez est élevée, plus la distance entre l'axe et les étiquettes est grande. Intervalle entre les étiquettes - sert à spécifier la fréquence à laquelle les étiquettes doivent être affichés. L'option Auto est sélectionnée par défaut, dans ce cas les étiquettes sont affichés pour chaque catégorie. Vous pouvez sélectionner l'option Manuel dans la liste déroulante et spécifier la valeur voulue dans le champ de saisie sur la droite. Par exemple, entrez 2 pour afficher les étiquettes pour une catégorie sur deux. Pour définir le Format d'étiquette cliquez sur le bouton format d'étiquette et choisissez la catégorie appropriée. Les catégories du format d'étiquette disponibles: Général Nombre Scientifique Comptabilité Monétaire Date Temps Pourcentage Fraction Texte Personnalisé Les options du format d'étiquette varient en fonction de la catégorie sélectionné. Pour en savoir plus sur la modification du format de nombre, veuillez consulter cette page. Activez Lié à la source pour conserver la représentation de nombre de la source de données du graphique. L'onglet Accrochage à la cellule comprend les options suivantes: Déplacer et dimensionner avec des cellules - cette option permet de placer le graphique derrière la cellule. Quand une cellule se déplace (par exemple: insertion ou suppression des lignes/colonnes), le graphique se déplace aussi. Quand vous ajustez la largeur ou la hauteur de la cellule, la dimension du graphique s'ajuste aussi. Déplacer sans dimensionner avec les cellules - cette option permet de placer le graphique derrière la cellule mais d'empêcher son redimensionnement. Quand une cellule se déplace, le graphique se déplace aussi, mais si vous redimensionnez la cellule, le graphique demeure inchangé. Ne pas déplacer et dimensionner avec les cellules - cette option empêche le déplacement ou redimensionnement du graphique si la position ou la dimension de la cellule restent inchangées. L'onglet Texte de remplacement permet de spécifier un Titre et une Description qui sera lue aux personnes avec des déficiences cognitives ou visuelles pour les aider à mieux comprendre l'information du graphique. Modifier les éléments de graphique Pour modifier le Titre du graphique, sélectionnez le texte par défaut à l'aide de la souris et saisissez le vôtre à la place. Pour modifier la mise en forme de la police dans les éléments de texte, tels que le titre du graphique, les titres des axes, les entrées de légende, les étiquettes de données, etc., sélectionnez l'élément de texte nécessaire en cliquant dessus. Utilisez ensuite les icônes de l'onglet Accueil de la barre d'outils supérieure pour modifier le type de police, la taille, la couleur. Une fois le graphique sélectionné, l'icône Paramètres de la forme est aussi disponible à la droite car une forme est utilisé en arrière plan du graphique. Vous pouvez appuyer sur cette icône pour accéder à l'onglet Paramètres de la forme de la barre latérale droite et configurer le Remplissage et la Ligne de la forme. Veuillez noter qu'on ne peut pas modifier le type de la forme. Sous l'onglet Paramètres de la forme sur le panneau de droit, vous pouvez configurer la zone du graphique là-même aussi que les éléments du graphique tels que la zone de tracé, la série de données, le titre du graphique, la légende et les autres et ajouter les différents types de remplissage. Sélectionnez l'élément du graphique nécessaire en cliquant sur le bouton gauche de la souris et choisissez le type de remplissage approprié: couleur de remplissage, remplissage en dégradé, image ou texture, modèle. Configurez les paramètres du remplissage et spécifier le niveau d'opacité si nécessaire. Lorsque vous sélectionnez l'axe vertical ou horizontal ou le quadrillage, vous pouvez configurer le paramètres du trait seulement sous l'onglet Paramètres de la forme: couleur, largeur, taille et opacité. Pour plus de détails sur utilisation des couleurs de la forme, du remplissage et du trait veuillez accéder à cet page. Remarque: l'option Ajouter un ombre est aussi disponible sous l'onglet Paramètres de la forme, mais elle est désactivée pour les éléments du graphique. Si vous voulez redimensionner les éléments du graphique, sélectionnez l'élément nécessaire en cliquant sur le bouton gauche de la souris et faites glisser un des huit carreaux blancs le long du périmètre de l'élément. Pour modifier la position d'un élément, cliquez sur cet élément avec le bouton gauche de souris, vérifiez si le curseur est devenu , maintenez le bouton gauche de la souris enfoncé et faites-le glisser vers la position souhaité. Pour supprimer un élément de graphique, sélectionnez-le en cliquant sur le bouton gauche et appuyez sur la touche Suppr. Vous pouvez également faire pivoter les graphiques 3D à l'aide de la souris. Faites un clic gauche dans la zone de tracé et maintenez le bouton de la souris enfoncé. Faites glisser le curseur sans relâcher le bouton de la souris pour modifier l'orientation du graphique 3D. Si nécessaire, vous pouvez modifier la taille et la position du graphique. Pour supprimer un graphique inséré, cliquez sur celui-ci et appuyez sur la touche Suppr. Affecter une macro à un graphique Pour rendre l'accès à macro plus rapide et facile dans une feuille de calcul, vous pouvez affecter une macro à un graphique. Une fois la macro affectée, le graphique apparaît ainsi comme un bouton de contrôle et vous pouvez lancer la macro par un clic dessus. Pour affecter une macro: Cliquer avec le bouton droit de la souris sur le graphique et sélectionnez l'option Affecter une macro dans le menu déroulant. La boîte de dialogue Affecter une macro s'affiche. Sélectionnez la macro dans la liste ou saisissez le nom et cliquez sur OK. Une fois la macro affectée, vous pouvez toujours sélectionner le graphique pour effectuer d'autres opérations en cliquant avec le bouton gauche de la souris sur la surface du graphique. Utiliser des graphiques sparkline L'éditeur de classeurs ONLYOFFICE prend en charge des Graphiques sparkline. Un graphique sparkline est un graphique tout petit qui s'adapte à la taille de la cellule et est un excellent outil de représentation visuelle des données. Pour en savoir plus sur la création, la modification et mise en forme des graphiques sparkline, veuillez consulter des instructions Insérer des graphiques sparkline."
    },
   {
        "id": "UsageInstructions/InsertDeleteCells.htm", 
        "title": "Insérer ou supprimer des cellules, des lignes et des colonnes", 
        "body": "Dans l'éditeur de classeurs, vous pouvez insérer des cellules vides au-dessus ou à gauche de la cellule sélectionnée dans une feuille de calcul. Vous pouvez également insérer une ligne entière au-dessus de la ligne sélectionnée ou une colonne à gauche de la colonne sélectionnée. Pour faciliter la visualisation d'une grande quantité d'informations, vous pouvez masquer certaines lignes ou colonnes et les afficher à nouveau. Il est également possible de spécifier une certaine hauteur de ligne et largeur de colonne. Insérer une cellule, une ligne ou une colonne Pour insérer une cellule vide à gauche de la cellule sélectionnée: cliquez avec le bouton droit sur la cellule à gauche de laquelle vous souhaitez insérer une nouvelle cellule, cliquez sur l'icône Insérer les cellules située dans l'onglet Accueil de la barre d'outils supérieure ou sélectionnez l'élément Insérer dans le menu contextuel et utilisez l'option Décaler les cellules vers la droite. Le programme déplacera la cellule sélectionnée vers la droite pour insérer une cellule vide. Pour insérer une cellule vide au-dessus de la cellule sélectionnée: cliquez avec le bouton droit sur la cellule au-dessus de laquelle vous souhaitez insérer une nouvelle cellule, cliquez sur l'icône Insérer les cellules située dans l'onglet Accueil de la barre d'outils supérieure ou sélectionnez l'élément Insérer dans le menu contextuel et utilisez l'option Décaler les cellules vers la droite. Le programme déplacera la cellule sélectionnée vers le bas pour insérer une cellule vide. Pour insérer une ligne entière: sélectionnez une ligne entière ou une cellule de la ligne au-dessus de laquelle vous souhaitez insérer une nouvelle ligne, Remarque: pour insérer plusieurs lignes, sélectionnez le même nombre de lignes que vous souhaitez insérer. cliquez sur l'icône Insérer les cellules située dans l'onglet Accueil de la barre d'outils supérieure et utilisez l'option Ligne entière, ou cliquez avec le bouton droit sur la cellule sélectionnée, sélectionnez l'élément Insérer dans le menu contextuel, ensuite choisissez l'option Ligne entière, ou cliquez avec le bouton droit sur la(les) ligne(s) sélectionnée(s) et utilisez l'option Insérer haut du menu contextuel. Le programme déplacera la ligne sélectionnée vers le bas pour insérer une ligne vide. Pour insérer une colonne entière: cliquez avec le bouton droit sur la colonne à gauche de laquelle vous souhaitez insérer une nouvelle colonne, Remarque: pour insérer plusieurs colonnes, sélectionnez le même nombre de colonnes que vous souhaitez insérer. cliquez sur l'icône Insérer les cellules située dans l'onglet Accueil de la barre d'outils supérieure et utilisez l'option Colonne entière, ou cliquez avec le bouton droit sur la cellule sélectionnée, sélectionnez l'élément Insérer dans le menu contextuel, ensuite choisissez l'option Colonne entière, ou cliquez avec le bouton droit sur la(les) ligne(s) sélectionnée(s) et utilisez l'option Insérer à gauche du menu contextuel. Le programme déplacera la colonne sélectionnée vers la droite pour insérer une colonne vide. Vous pouvez également utiliser le raccourci Ctrl+Shift+= pour ouvrir la boîte de dialogue pour insérer de nouvelles cellules, sélectionnez Décaler les cellules vers la droite, Décaler les cellules vers le bas, Ligne entière, Colonne entière, et cliquez sur OK. Déplacer les lignes et les colonnes Pour déplacer le contenu d'une ligne ou d'une colonne, sélectionnez la ligne ou la colonne à déplacer en cliquant sur le numéro de la ligne ou l'en-tête de colonnes étiqueté à l'aide de lettre, maintenez le bouton gauche de la souris enfoncé et faites-le glisser vers la position souhaité sur la feuille de calcul. Masquer et afficher les lignes et les colonnes Pour masquer une ligne ou une colonne: sélectionnez les lignes ou les colonnes que vous souhaitez masquer, Cliquez avec le bouton droit sur les lignes ou les colonnes sélectionnées et utilisez l'option Masquer dans le menu contextuel. Pour afficher les lignes ou colonnes masquées, sélectionnez les lignes visibles au-dessus et en dessous des lignes cachées ou des colonnes visibles à gauche et à droite des colonnes masquées, cliquez dessus avec le bouton droit de la souris et utilisez l'option Afficher dans le menu contextuel. Changer la largeur de colonne et la hauteur de ligne La largeur de colonne détermine le nombre de caractères avec une mise en forme par défaut qui peuvent être affichés dans une cellule de la colonne. La valeur par défaut est de 8,43 symboles. Pour la changer: sélectionnez les colonnes que vous souhaitez modifier, cliquez avec le bouton droit sur les colonnes sélectionnées et utilisez l'option Définir la largeur de colonne dans le menu contextuel, Style - choisissez une des options disponibles: sélectionnez l'option Ajuster automatiquement la largeur de colonne pour ajuster automatiquement la largeur de chaque colonne en fonction de son contenu, ou sélectionnez l'option Largeur de colonne personnalisée et spécifiez une nouvelle valeur comprise entre 0 et 255 dans la fenêtre Largeur de colonne personnalisée, puis cliquez sur OK. Pour modifier manuellement la largeur d'une seule colonne, déplacez le curseur de la souris sur la bordure droite de l'en-tête de la colonne afin que le curseur devienne la flèche bidirectionnelle . Faites glisser la bordure vers la gauche ou la droite pour définir une largeur personnalisée ou double-cliquez sur la souris pour modifier automatiquement la largeur de la colonne en fonction de son contenu. La valeur de hauteur de ligne par défaut est 14,25 points. Pour la changer: sélectionnez les lignes que vous souhaitez modifier, cliquez avec le bouton droit sur les lignes sélectionnées et utilisez l'option Définir la hauteur de ligne dans le menu contextuel, Style - choisissez une des options disponibles: sélectionnez l'option Ajuster automatiquement la hauteur de ligne pour ajuster automatiquement la hauteur de chaque ligne en fonction de son contenu, ou sélectionnez l'option Hauteur de ligne personnalisée et spécifiez une nouvelle valeur comprise entre 0 et 408,75 dans la fenêtre Hauteur de ligne personnalisée, puis cliquez sur OK. Pour modifier manuellement la hauteur d'une seule ligne, faites glisser la bordure inférieure de l'en-tête de ligne. Supprimer une cellule, une ligne ou une colonne Pour supprimer une cellule, une ligne ou une colonne: sélectionnez les cellules, les lignes et les colonnes à supprimer cliquez sur l'icône Supprimer les cellules située dans l'onglet Accueil de la barre d'outils supérieure ou sélectionnez l'élément Supprimer dans le menu contextuel et sélectionnez l'option appropriée: si vous utilisez l'option Déplacer les cellules vers la gauche une cellule à droite de la cellule supprimée sera déplacée vers la gauche; si vous utilisez l'option Décaler les cellules vers le haut une cellule au-dessous de la cellule supprimée sera déplacée vers le haut; si vous utilisez l'option Ligne entière une ligne au-dessous de la ligne sélectionnée sera déplacée vers le haut; si vous utilisez l'option Colonne entière une colonne à droite de la colonne sélectionnée sera déplacée vers la gauche; Vous pouvez également utiliser le raccourci Ctrl+Shift+= pour ouvrir la boîte de dialogue pour supprimer des cellules, sélectionnez Décaler les cellules vers la gauche, Décaler les cellules vers le haut, Ligne entière, Colonne entière, et cliquez sur OK. Vous pouvez toujours restaurer les données supprimées en utilisant l'icône Annuler située sur la barre d'outils supérieure."
    },
   {
        "id": "UsageInstructions/InsertEquation.htm", 
        "title": "Insérer des équations", 
        "body": "L'éditeur de classeurs vous permet de créer des équations à l'aide des modèles intégrés, de les modifier, d'insérer des caractères spéciaux (à savoir des opérateurs mathématiques, des lettres grecques, des accents, etc.). Ajouter une nouvelle équation Pour insérer une équation depuis la galerie, positionnez le curseur sur la cellule nécessaire, passez à l'onglet Insertion de la barre d'outils supérieure, cliquez sur la flèche à côté de l'icône Équation de la barre d'outils supérieure, sélectionnez la catégorie de l'équation sur la barre d'outils supérieure au-dessus de l'équation ajoutée, ou sélectionnez la catégorie d'équation nécessaire dans la liste déroulante. Les catégories suivantes sont actuellement disponibles: Symboles, Fractions, Scripts, Radicaux, Intégrales, Grands opérateurs, Crochets, Fonctions, Accentuations, Limites et logarithmes, Opérateurs, Matrices, Cliquez sur Paramètres d'équations dans la barre d'outils au-dessus de l'équation ajoutée pour accéder à d'autres paramètres, tels que Unicode ou LaTeX, Professionnel ou Linéaire et passer à mode en ligne, cliquez sur le symbole/l'équation voulu(e) dans l'ensemble de modèles correspondant, pour masquer la barre d'outils, cliquez sur Masquer la barre d'outils d'équation dans Paramètres d'équations. Le symbole/équation sélectionné sera ajouté à la feuille de calcul. Le coin supérieur gauche de la zone d'équation coïncidera avec le coin supérieur gauche de la cellule actuellement sélectionnée mais la zone d'équation peut être librement déplacée, redimensionnée ou pivotée sur la feuille de calcul. Pour ce faire, cliquez sur la bordure de la zone d'équation (elle sera affichée en trait plein) et utilisez les poignées correspondantes. Chaque modèle d'équation comporte un ensemble d'emplacements. Un emplacement est une position pour chaque élément qui compose l'équation. Un emplacement vide (également appelé un espace réservé) a un contour en pointillé . Vous devez remplir tous les espaces réservés en spécifiant les valeurs nécessaires. Entrer des valeurs Le point d'insertion spécifie où le prochain caractère que vous entrez apparaîtra. Pour positionner le point d'insertion avec précision, cliquez dans un espace réservé et utilisez les flèches du clavier pour déplacer le point d'insertion d'un caractère vers la gauche/la droite. Une fois le point d'insertion positionné, vous pouvez remplir l'espace réservé: entrez la valeur numérique/littérale souhaitée à l'aide du clavier, insérez un caractère spécial de la palette des symboles du menu Équation sous l'onglet Insertion de la barre d'outils supérieure ou saisissez avec le clavier (consultez le guide Correction automatique), ajoutez un autre modèle d'équation à partir de la palette pour créer une équation imbriquée complexe. La taille de l'équation primaire sera automatiquement ajustée pour s'adapter à son contenu. La taille des éléments de l'équation imbriquée dépend de la taille de l'espace réservé de l'équation primaire, mais elle ne peut pas être inférieure à la taille de sous-indice. Pour ajouter de nouveaux éléments d'équation, vous pouvez également utiliser les options du menu contextuel: Pour ajouter un nouvel argument avant ou après celui existant dans les Crochets, vous pouvez cliquer avec le bouton droit sur l'argument existant et sélectionner l'option Insérer un argument avant/après dans le menu. Pour ajouter une nouvelle équation dans les Cas avec plusieurs conditions du groupe Crochets, vous pouvez cliquer avec le bouton droit de la souris sur un espace réservé vide ou une équation entrée et sélectionner l'option Insérer une équation avant/après dans le menu. Pour ajouter une nouvelle ligne ou une colonne dans une Matrice, vous pouvez cliquer avec le bouton droit de la souris sur un espace réservé, sélectionner l'option Insérer dans le menu, puis sélectionner Ligne au-dessus/en dessous ou Colonne à gauche/à droite. Remarque: actuellement, les équations ne peuvent pas être entrées en utilisant le format linéaire, c'est-à-dire \\sqrt(4&x^3). Lorsque vous entrez les valeurs des expressions mathématiques, vous n'avez pas besoin d'utiliser la Barre d'espace car les espaces entre les caractères et les signes des opérations sont définis automatiquement. Si l'équation est trop longue et ne tient pas en une seule ligne dans la zone d'équation, le saut de ligne automatique se produit pendant que vous tapez. Vous pouvez également insérer un saut de ligne à une position spécifique en cliquant avec le bouton droit sur un opérateur mathématique et en sélectionnant l'option Insérer un saut manuel dans le menu. L'opérateur sélectionné va commencer une nouvelle ligne. Pour supprimer le saut de ligne manuel ajouté, cliquez avec le bouton droit sur l'opérateur mathématique qui commence une nouvelle ligne et sélectionnez l'option Supprimer un saut manuel. Mise en forme des équations Par défaut, l'équation dans la zone d'équation est centrée horizontalement et alignée verticalement sur le haut de la zone d'équation. Pour modifier son alignement horizontal/vertical, placez le curseur dans la zone d'équation (les bordures de la zone d'équation seront affichées en pointillés) et utilisez les icônes correspondantes de la barre d'outils supérieure. Pour augmenter ou diminuer la taille de la police d'équation, cliquez n'importe où dans la zone d'équation et utilisez les boutons Augmenter la taille de la police et Réduire la taille de la police sous l'onglet Accueil de la barre d'outils supérieure ou sélectionnez la taille de police nécessaire dans la liste. Tous les éléments d'équation changeront en conséquence. Les lettres de l'équation sont en italique par défaut. Si nécessaire, vous pouvez changer le style de police (gras, italique, barré) ou la couleur pour une équation entière ou une portion. Le style souligné peut être appliqué uniquement à l'équation entière et non aux caractères individuels. Sélectionnez la partie de l'équation voulue en cliquant et en faisant glisser. La partie sélectionnée sera surlignée en bleu. Utilisez ensuite les boutons nécessaires dans l'onglet Accueil de la barre d'outils supérieure pour formater la sélection. Par exemple, vous pouvez supprimer le format italique pour les mots ordinaires qui ne sont pas des variables ou des constantes. Pour modifier certains éléments d'équation, vous pouvez également utiliser les options du menu contextuel: Pour modifier le format des Fractions, vous pouvez cliquer sur une fraction avec le bouton droit de la souris et sélectionner l'option Changer en fraction en biais/linéaire/empilée dans le menu (les options disponibles varient en fonction du type de fraction sélectionné). Pour modifier la position des Scripts par rapport au texte, vous pouvez faire un clic droit sur l'équation contenant des scripts et sélectionner l'option Scripts avant/après le texte dans le menu. Pour modifier la taille des arguments pour Scripts, Radicaux, Intégrales, Grands opérateurs, Limites et Logarithmes, Opérateurs ainsi que pour les accolades supérieures/inférieures et les Modèles avec des caractères de regroupement du groupe Accentuations, vous pouvez cliquer avec le bouton droit sur l'argument que vous souhaitez modifier et sélectionner l'option Augmenter/Diminuer la taille de l'argument dans le menu. Pour spécifier si un espace libre vide doit être affiché ou non pour un Radical, vous pouvez cliquer avec le bouton droit de la souris sur le radical et sélectionner l'option Masquer/Afficher le degré dans le menu. Pour spécifier si un espace réservé de limite vide doit être affiché ou non pour une Intégrale ou un Grand opérateur, vous pouvez cliquer sur l'équation avec le bouton droit de la souris et sélectionner l'option Masquer/Afficher la limite supérieure/inférieure dans le menu. Pour modifier la position des limites relative au signe d'intégrale ou d'opérateur pour les Intégrales ou les Grands opérateurs, vous pouvez cliquer avec le bouton droit sur l'équation et sélectionner l'option Modifier l'emplacement des limites dans le menu. Les limites peuvent être affichées à droite du signe de l'opérateur (sous forme d'indices et d'exposants) ou directement au-dessus et au-dessous du signe de l'opérateur. Pour modifier la position des limites par rapport au texte des Limites et des Logarithmes et des modèles avec des caractères de regroupement du groupe Accentuations, vous pouvez cliquer avec le bouton droit sur l'équation et sélectionner l'option Limites sur/sous le texte dans le menu. Pour choisir lequel des Crochets doit être affiché, vous pouvez cliquer avec le bouton droit de la souris sur l'expression qui s'y trouve et sélectionner l'option Masquer/Afficher les parenthèses ouvrantes/fermantes dans le menu. Pour contrôler la taille des Crochets, vous pouvez cliquer avec le bouton droit sur l'expression qui s'y trouve. L'option Étirer les parenthèses est sélectionnée par défaut afin que les parenthèses puissent croître en fonction de l'expression qu'elles contiennent, mais vous pouvez désélectionner cette option pour empêcher l'étirement des parenthèses. Lorsque cette option est activée, vous pouvez également utiliser l'option Faire correspondre les crochets à la hauteur de l'argument. Pour modifier la position du caractère par rapport au texte des accolades ou des barres supérieures/inférieures du groupe Accentuations, vous pouvez cliquer avec le bouton droit sur le modèle et sélectionner l'option Caractère/Barre sur/sous le texte dans le menu. Pour choisir les bordures à afficher pour une Formule encadrée du groupe Accentuations, vous pouvez cliquer sur l'équation avec le bouton droit de la souris et sélectionner l'option Propriétés de bordure dans le menu, puis sélectionner Masquer/Afficher bordure supérieure/inférieure/gauche/droite ou Ajouter/Masquer ligne horizontale/verticale/diagonale. Pour spécifier si un espace réservé vide doit être affiché ou non pour une Matrice, vous pouvez cliquer avec le bouton droit de la souris sur le radical et sélectionner l'option Masquer/Afficher l'espace réservé dans le menu. Pour aligner certains éléments d'équation, vous pouvez utiliser les options du menu contextuel: Pour aligner des équations dans les Cas avec plusieurs conditions du groupe Crochets, vous pouvez cliquer avec le bouton droit de la souris sur une équation, sélectionner l'option Alignement dans le menu, puis sélectionnez le type d'alignement: Haut, Centre ou Bas Pour aligner une Matrice verticalement, vous pouvez cliquer avec le bouton droit sur la matrice, sélectionner l'option Alignement de Matrice dans le menu, puis sélectionner le type d'alignement: Haut, Centre ou Bas Pour aligner les éléments d'une colonne Matrice horizontalement, vous pouvez cliquer avec le bouton droit sur la colonne, sélectionner l'option Alignement de Colonne dans le menu, puis sélectionner le type d'alignement: Gauche, Centre ou Droite. Supprimer les éléments d'une équation Pour supprimer une partie de l'équation, sélectionnez la partie que vous souhaitez supprimer en faisant glisser la souris ou en maintenant la touche Maj enfoncée et en utilisant les boutons fléchés, puis appuyez sur la touche Suppr. Un emplacement ne peut être supprimé qu'avec le modèle auquel il appartient. Pour ce faire, cliquez sur la bordure de la zone d'équation (elle sera affichée en trait plein) et utilisez appuyez sur la touche Suppr. Pour supprimer certains éléments d'équation, vous pouvez également utiliser les options du menu contextuel: Pour supprimer un Radical, vous pouvez faire un clic droit dessus et sélectionner l'option Supprimer radical dans le menu. Pour supprimer un Indice et/ou un Exposant, vous pouvez cliquer avec le bouton droit sur l'expression qui les contient et sélectionner l'option Supprimer indice/exposant dans le menu. Si l'expression contient des scripts qui viennent avant le texte, l'option Supprimer les scripts est disponible. Pour supprimer des Crochets, vous pouvez cliquer avec le bouton droit de la souris sur l'expression qu'ils contiennent et sélectionner l'option Supprimer les caractères englobants ou Supprimer les caractères et séparateurs englobants dans le menu. Si l'expression contenue dans les Crochets comprend plus d'un argument, vous pouvez cliquer avec le bouton droit de la souris sur l'argument que vous voulez supprimer et sélectionner l'option Supprimer l'argument dans le menu. Si les Crochets contiennent plus d'une équation (c'est-à-dire des Cas avec plusieurs conditions), vous pouvez cliquer avec le bouton droit sur l'équation que vous souhaitez supprimer et sélectionner l'option Supprimer l'équation dans le menu. Pour supprimer une Limite, vous pouvez faire un clic droit dessus et sélectionner l'option Supprimer limite dans le menu. Pour supprimer une Accentuation, vous pouvez cliquer avec le bouton droit de la souris et sélectionner l'option Supprimer le caractère d'accentuation, Supprimer le caractère ou Supprimer la barre dans le menu (les options disponibles varient en fonction de l'accent sélectionné). Pour supprimer une ligne ou une colonne d'une Matrice, vous pouvez cliquer avec le bouton droit de la souris sur l'espace réservé dans la ligne/colonne à supprimer, sélectionner l'option Supprimer dans le menu, puis sélectionner Supprimer la ligne/Colonne. Convertir des équations Si votre document comporte des équations qu'on a créé avec des versions antérieures de l'éditeur d'équations (par ex. des versions de MS Office lancées avant 2007), il vous faut les convertir au format Office Math ML pour avoir la possibilité de les modifier. Pour convertir une équation, faites un clic double dessus. Un message d'avertissement va apparaître. Pour convertir uniquement la équation sélectionnée, cliquez sur Oui dans le message d'avertissement. Pour convertir toutes équations du document, activez l'option Appliquer à toutes les équations et cliquez sur Oui. Une fois l'équation convertie, vous pouvez la modifier."
    },
   {
        "id": "UsageInstructions/InsertFunction.htm", 
        "title": "Insérer une fonction", 
        "body": "La possibilité d'accomplir les opérations de calcul de base est la raison principale d'utiliser l'éditeur de classeurs. Certaines d'entre elles sont exécutées automatiquement lorsque vous sélectionnez une plage de cellules dans votre feuille de calcul: MOYENNE est utilisée pour analyser la plage de données et trouver la valeur moyenne. NB est utilisée pour compter le nombre de cellules sélectionnées qui contiennent des nombres en ignorant les cellules vides. MIN est utilisée pour analyser la plage de données et de trouver le plus petit nombre. MAX est utilisée pour analyser la plage de données et trouver le plus grand nombre. SOMME est utilisée pour ajouter tous les nombres dans la plage sélectionnée en ignorant les cellules vides ou celles contenant du texte. Les résultats de ces calculs sont affichés dans le coin inférieur droit de la barre d'état. Pour personnaliser la barre d'état et choisir quelles fonctions sont visibles, cliquant avec le bouton droit de la souris sur la barre d'état. Pour effectuer les autres opérations de calcul, vous pouvez insérer une formule nécessaire à la main en utilisant des opérateurs mathématiques appropriés ou insérer une formule prédéfinie - Fonction. On peut accéder aux Fonctions et les utiliser sous l'onglet Accueil aussi que sous l'onglet Formule, ou en appuyant sur le raccourci Shift+F3. Sous l'onglet Accueil, vous pouvez utiliser le bouton Insérer une fonction pour ajouter l'une des fonctions d'usage courant (SOMME, MOYENNE, MIN, MAX, NB) ou ouvrez la fenêtre Insérer une fonction où on peut trouver toutes les fonctions disponibles classées en catégories. Utilisez la barre de recherche pour faire une recherche précise par nom de la fonction. Sous l'onglet Formule vous pouvez utiliser les boutons suivants: Fonction sert à ouvrir la fenêtre Insérer une fonction où on peut trouver toutes les fonctions disponibles classées en catégories. Somme automatique fournit un accès rapide aux fonctions SOMME, MIN, MAX, NB. Lorsque vous choisissez les fonctions de ce groupe, le calcul se produit automatiquement dans toutes les cellules de la colonne au-dessus de la cellule sélectionnée et on n'a pas besoin de saisir les arguments. Récemment utilisées fournit un accès rapide aux 10 fonctions récentes. Financier, Logique, Texte et données, Date et heure, Recherche et référence, Maths et trigonométrie fournit un accès rapide aux fonctions de ces catégories. Plus de fonctions fournit un accès aux fonctions des catégories suivantes: Base de données, Ingénierie, Information, Statistiques. Plages nommées sert à afficher le Gestionnaire de noms ou à définir un nom nouveau, ou coller un nom tels que l'argument d'une fonction. Pour en savoir plus, veiller consulter cette page. Tracer les précédents sert à afficher les flèches indiquant les cellules qui affectent la valeur de la cellule sélectionnée. Tracer les dépendants sert à afficher les flèches indiquant les cellules qui sont affectées par la valeur de la cellule sélectionnée. Supprimer les flèches sert à supprimer les flèches indiquant les précédents et les dépendants. Cliquez sur la flèche à côté de l'option Supprimer les flèches pour et sélectionnez l'une des options disponibles: supprimer toutes les flèches, supprimer les flèches de précédents ou de dépendance. Afficher les formules sert à afficher la formule dans une cellule au lieu du résultat. Fenêtre Espions sert à afficher les modifications apportées aux cellules qui se trouvent en dehors de la zone visible sur une feuille de calcul. Pour en savoir plus sur la Fenêtre Espions, veuillez consulter cet article. Calcul sert à forcer le recalcul sur toutes les fonctions. Comment appliquer une fonction Pour insérer une fonction, sélectionnez une cellule dans laquelle vous voulez insérer une fonction, Procédez de l'une des façons suivantes: passez à l'onglet Formule et accédez à la fonction du groupe approprié en utilisant les boutons disponibles sur la barre d'outils supérieure, ensuite cliquez sur la fonction appropriée pour ouvrir l'assistant Argument de formule. Vous pouvez aussi utiliser l'option Supplémentaire du menu ou cliquez sur le bouton Fonction de la barre d'outils supérieure pour ouvrir la fenêtre Insérer une fonction. passez à l'onglet Accueil de la barre d'outils supérieure, cliquez sur l'icône Insérer une fonction, sélectionnez l'une des fonctions d'usage courant (SOMME, MOYENNE, MIN, MAX, NB) ou cliquez sur l'option Supplémentaire pour ouvrir la fenêtre Insérer une fonction. faites un clic droit sur la cellule sélectionnée et utilisez l'option Insérer une fonction depuis le menu contextuel. cliquez sur l'icône avant la barre de formule, Dans la fenêtre Insérer une fonction qui s'affiche, saisissez le nom dans la barre de recherche ou sélectionnez le groupe de fonctions souhaité, puis choisissez la fonction dont vous avez besoin dans la liste et cliquez sur OK. Lorsque vous cliquez sur la fonction appropriée, la fenêtre Argument de formule s'affiche: Dans la fenêtre Argument de formule qui s'affiche, saisissez les valeurs de chaque argument. Vous pouvez saisir les arguments de la fonction manuellement ou sélectionnez une plage de cellules à inclure en tant qu'argument en cliquant sur l'icône . Remarque: en règle générale, les valeurs numériques, les valeurs logiques (TRUE, FALSE), les valeurs de texte (entre guillemets), les références de cellules, les références de plage de cellules, les plages nommées et autres fonctions peuvent être utilisés comme arguments d'une fonction. Le résultat de fonction s'affiche au-dessous. Lorsque tous les arguments sont introduits, cliquez sur OK dans la fenêtre Arguments de la fonction. Pour entrer manuellement une fonction à l'aide du clavier, sélectionner une cellule, entrez le signe égal (=) Chaque formule doit commencer par le signe égal (=). entrez le nom de la fonction Une fois que vous avez tapé les lettres initiales, la liste Autocomplétion de formule sera affichée. Au fur et à mesure que vous tapez, les éléments (formules et noms) correspondant aux caractères saisis sont affichés. Si vous passez le pointeur de la souris sur une formule, une info-bulle avec la description de la formule s'affiche. Vous pouvez sélectionner la formule nécessaire dans la liste et l'insérer en cliquant dessus ou en appuyant sur la touche Tabulation. Saisissez les arguments de la fonction manuellement ou en faisant glisser le curseur pour sélectionner une plage de cellules à inclure en tant que argument. Si la fonction nécessite plusieurs arguments, ils doivent être séparés par des virgules. Les arguments doivent être mis entre parenthèses. La parenthèse ouvrante '(' est ajoutée automatiquement si vous sélectionnez une fonction dans la liste. Lorsque vous saisissez des arguments, une infobulle contenant la syntaxe de la formule s'affiche également. Lorsque tous les arguments sont spécifiés, entrer la parenthèse fermante ')' et appuyer sur Entrée. Lorsque vous saisissez de nouveaux données ou modifiez les valeurs des arguments, par défaut le recalcul sur les fonctions se produit automatiquement. Il est possible de forcer le recalcul sur les fonctions à l'aide du bouton Calcul sous l'onglet Formule. Cliquez sur le bouton Calcul pour recalculer le classeur entier ou cliquez sur la flèche au-dessous du bouton et choisissez l'option appropriées dans le menu: Calculer le classeur ou Calculer la feuille courante. Vous pouvez également clavier comme suit: F9 à recalculer le classeur, Maj + F9 à recalculer la feuille courante. Voici la liste des fonctions disponibles regroupées par catégories: Catégorie de fonctions Description Fonctions Fonctions de données et texte Servent à afficher correctement les données de texte dans votre classeur. TABLEAU.EN.TEXTE; ASC; CHAR; EPURAGE; CODE; CONCATENER; CONCAT; DEVISE; EXACT; TROUVE; TROUVERB; CTXT; IMPORTRANGE; GAUCHE; GAUCHEB; NBCAR; LENB; MINUSCULE; STXT; STXTB; VALEURNOMBRE; NOMPROPRE; REMPLACER; REMPLACERB; REPT; DROITE; DROITEB; CHERCHE; CHERCHEB; SUBSTITUE; T; TEXTE; JOINDRE.TEXTE; SUPPRESPACE; UNICAR; UNICODE; MAJUSCULE; VALEUR; TEXTE.AVANT; TEXTE.APRES; FRACTIONNER.TEXTE Fonctions statistiques Servent à analyser les données: trouver la valeur moyenne, les valeurs plus grandes ou plus petites dans une plage de cellules. ECART.MOYEN; MOYENNE; AVERAGEA; MOYENNE.SI; MOYENNE.SI.ENS; LOI.BETA; LOI.BETA.N; BETA.INVERSE.N; BETA.INVERSE; LOI.BINOMIALE; LOI.BINOMIALE.N; LOI.BINOMIALE.SERIE; LOI.BINOMIALE.INVERSE; LOI.KHIDEUX; KHIDEUX.INVERSE; LOI.KHIDEUX.N; LOI.KHIDEUX.DROITE; LOI.KHIDEUX.INVERSE; LOI.KHIDEUX.INVERSE.DROITE; TEST.KHIDEUX; CHISQ.TEST; INTERVALLE.CONFIANCE; INTERVALLE.CONFIANCE.NORMAL; INTERVALLE.CONFIANCE.STUDENT; COEFFICIENT.CORRELATION; NB; NBVAL; NB.VIDE; NB.SI; NB.SI.ENS; COVARIANCE; COVARIANCE.PEARSON; COVARIANCE.STANDARD; CRITERE.LOI.BINOMIALE; SOMME.CARRES.ECARTS; LOI.EXPONENTIELLE.N; LOI.EXPONENTIELLE; LOI.F.N; LOI.F; LOI.F.DROITE; INVERSE.LOI.F.N; INVERSE.LOI.F; INVERSE.LOI.F.DROITE; FISHER; FISHER.INVERSE; PREVISION; PREVISION.ETS; PREVISION.ETS.CONFINT; PREVISION.ETS.CARACTERESAISONNIER; PREVISION.ETS.STAT; PREVISION.LINEAIRE; FREQUENCE; TEST.F; F.TEST; GAMMA; LOI.GAMMA.N; LOI.GAMMA; LOI.GAMMA.INVERSE.N; LOI.GAMMA.INVERSE; LNGAMMA; LNGAMMA.PRECIS; GAUSS; MOYENNE.GEOMETRIQUE; CROISSANCE; MOYENNE.HARMONIQUE; LOI.HYPERGEOMETRIQUE; LOI.HYPERGEOMETRIQUE.N; ORDONNEE.ORIGINE; KURTOSIS; GRANDE.VALEUR; DROITEREG; LOGREG; LOI.LOGNORMALE.INVERSE; LOI.LOGNORMALE.N; LOI.LOGNORMALE.INVERSE.N; LOI.LOGNORMALE; MAX; MAXA; MAX.SI.ENS; MEDIANE; MIN; MINA; MIN.SI.ENS; MODE; MODE.MULTIPLE; MODE.SIMPLE; LOI.BINOMIALE.NEG; LOI.BINOMIALE.NEG.N; LOI.NORMALE; LOI.NORMALE.N; LOI.NORMALE.INVERSE; LOI.NORMALE.INVERSE.N; LOI.NORMALE.STANDARD; LOI.NORMALE.STANDARD.N; LOI.NORMALE.STANDARD.INVERSE; LOI.NORMALE.STANDARD.INVERSE.N; PEARSON; CENTILE; CENTILE.EXCLURE; CENTILE.INCLURE; RANG.POURCENTAGE; RANG.POURCENTAGE.EXCLURE; RANG.POURCENTAGE.INCLURE; PERMUTATION; PERMUTATIONA; PHI; LOI.POISSON; LOI.POISSON.N; PROBABILITE; QUARTILE; QUARTILE.EXCLURE; QUARTILE.INCLURE; RANG; MOYENNE.RANG; EQUATION.RANG; COEFFICIENT.DETERMINATION; COEFFICIENT.ASYMETRIE; COEFFICIENT.ASYMETRIE.P; PENTE; PETITE.VALEUR; CENTREE.REDUITE; ECARTYPE; ECARTYPE.STANDARD; STDEVA; ECARTYPEP; ECARTYPE.PEARSON; STDEVPA; ERREUR.TYPE.XY; LOI.STUDENT; LOI.STUDENT.N; LOI.STUDENT.BILATERALE; LOI.STUDENT.DROITE; LOI.STUDENT.INVERSE.N; LOI.STUDENT.INVERSE.BILATERALE; LOI.STUDENT.INVERSE; TENDANCE, MOYENNE.REDUITE; TEST.STUDENT; T.TEST; VAR; VARA; VAR.P; VAR.P.N; VAR.S; VARPA; LOI.WEIBULL; LOI.WEIBULL.N; TEST.Z; Z.TEST Fonctions mathématiques et trigonométriques Servent à effectuer des opérations mathématiques et trigonométriques telles que l'ajout, la multiplication, la division, l'arrondissement, etc. ABS; ACOS; ACOSH; ACOT; ACOTH; AGREGAT; CHIFFRE.ARABE; ASIN; ASINH; ATAN; ATAN2; ATANH; BASE; PLAFOND; PLAFOND.MATH; PLAFOND.PRECIS; COMBIN; COMBINA; COS; COSH; COT; COTH; CSC; CSCH; DECIMAL; DEGRES; ECMA.PLAFOND; PAIR; EXP; FACT; FACTDOUBLE; PLANCHER; PLANCHER.PRECIS; PLANCHER.MATH; PGCD; ENT; ISO.PLAFOND; PPCM; LN; LOG; LOG10; DETERMAT; INVERSEMAT; PRODUITMAT; MOD; ARRONDI.AU.MULTIPLE; MULTINOMIALE; MATRICE.UNITAIRE; IMPAIR; PI; PUISSANCE; PRODUIT; QUOTIENT; RADIANS; ALEA; TABLEAU.ALEAT; ALEA.ENTRE.BORNES; ROMAN; ARRONDI; ARRONDI.INF; ARRONDI.SUP; SEC; SECH; SOMME.SERIES; SEQUENCE; SIGNE; SIN; SINH; RACINE; RACINE.PI; SOUS.TOTAL; SOMME; SOMME.SI; SOMME.SI.ENS; SOMMEPROD; SOMME.CARRES; SOMME.X2MY2; SOMME.X2PY2; SOMME.XMY2; TAN; TANH; TRONQUE Fonctions Date et Heure Servent à afficher correctement la date et l'heure dans votre classeur. DATE; DATEDIF; DATEVAL; JOUR; JOURS; JOURS360; MOIS.DECALER; FIN.MOIS; HEURE; NO.SEMAINE.ISO; MINUTE; MOIS; NB.JOURS.OUVRES; NB.JOURS.OUVRES.INTL; MAINTENANT; SECONDE; TEMPS; TEMPSVAL; AUJOURDHUI; JOURSEM; NO.SEMAINE; SERIE.JOUR.OUVRE; SERIE.JOUR.OUVRE.INTL; ANNEE; FRACTION.ANNEE Fonctions d'ingénierie Sont utilisés pour effectuer des calculs d'ingénierie: conversion entre différentes bases, recherche de nombres complexes, etc. BESSELI; BESSELJ; BESSELK; BESSELY; BINDEC; BINHEX; BINOCT; BITET; BITDECALG; BITOU; BITDECALD; BITOUEXCLUSIF; COMPLEXE; CONVERT; DECBIN; DECHEX; DECOCT; DELTA; ERF; ERF.PRECIS; ERFC; ERFC.PRECIS; SUP.SEUIL; HEXBIN; HEXDEC; HEXOCT; COMPLEXE.MODULE; COMPLEXE.IMAGINAIRE; COMPLEXE.ARGUMENT; COMPLEXE.CONJUGUE; COMPLEXE.COS; COMPLEXE.COSH; COMPLEXE.COT; COMPLEXE.CSC; COMPLEXE.CSCH; COMPLEXE.DIV; COMPLEXE.EXP; COMPLEXE.LN; COMPLEXE.LOG10; COMPLEXE.LOG2; COMPLEXE.PUISSANCE; COMPLEXE.PRODUIT; COMPLEXE.REEL; COMPLEXE.SEC; COMPLEXE.SECH; COMPLEXE.SIN; COMPLEXE.SINH; COMPLEXE.RACINE; COMPLEXE.DIFFERENCE; COMPLEXE.SOMME; COMPLEXE.TAN; OCTBIN; OCTDEC; OCTHEX Fonctions de base de données Sont utilisés pour effectuer des calculs sur les valeurs dans un certain champ de la base de données qui correspondent aux critères spécifiés. BDMOYENNE; BCOMPTE; BDNBVAL; BDLIRE; BDMAX; BDMIN; BDPRODUIT; BDECARTYPE; BDECARTYPEP; BDSOMME; BDVAR; BDVARP Fonctions financières Servent à effectuer certaines opérations financières, calculer la valeur nette actuelle, les paiements etc... INTERET.ACC; INTERET.ACC.MAT; AMORDEGRC; AMORLINC; NB.JOURS.COUPON.PREC; NB.JOURS.COUPONS; NB.JOURS.COUPON.SUIV; DATE.COUPON.SUIV; NB.COUPONSv; DATE.COUPON.PREC; CUMUL.INTER; CUMUL.PRINCPER; DB; DDB; TAUX.ESCOMPTE; PRIX.DEC; PRIX.FRAC; DUREE; TAUX.EFFECTIF; VC; VC.PAIEMENTS; TAUX.INTERET; INTPER; TRI; ISPMT; DUREE.MODIFIEE; TRIM; TAUX.NOMINAL; PM; VAN; PRIX.PCOUPON.IRREG; REND.PCOUPON.IRREG; PRIX.DCOUPON.IRREG; REND.DCOUPON.IRREG; PDUREE; VPM; PRINCPER; PRIX.TITRE; VALEUR.ENCAISSEMENT; PRIX.TITRE.ECHEANCE; VA; TAUX; VALEUR.NOMINALE; TAUX.INT.EQUIV; AMORLIN; AMORANN; TAUX.ESCOMPTE.R; PRIX.BON.TRESOR; RENDEMENT.BON.TRESOR; VDB; TRI.PAIEMENTS; VAN.PAIEMENTS; RENDEMENT.TITRE; RENDEMENT.SIMPLE; RENDEMENT.TITRE.ECHEANCE Fonctions de recherche et de référence Servent à trouver facilement les informations dans la liste de données. ADDRESSE; CHOISIR; CHOISIRCOLS; CHOISIRLIGNES; COLONNE; COLONNES; EXCLURE; ETENDRE; FILTRE; FORMULETEXTE; LIREDONNEESTABCROISDYNAMIQUE; RECHERCHEH; ASSEMB.H; LIEN_HYPERTEXTE; INDEX; INDIRECT; RECHERCHE; EQUIV; DECALER; LIGNE; LIGNES; TRIER; TRIERPAR; PRENDRE; DANSCOL; DANSLIGNE; TRANSPOSE; UNIQUE; RECHERCHEV; ASSEMB.V; ORGA.COLS; ORGA.LIGNES; RECHERCHEX; EQUIVX Fonctions d'information Servent à vous donner les informations sur les données de la cellule sélectionnée ou une plage de cellules. CELLULE; TYPE.ERREUR; ESTVIDE; ESTERR; ESTERREUR; EST.PAIR; ESTFORMULE; ESTLOGIQUE; ESTNA; ESTNONTEXTE; ESTNUM; EST.IMPAIR; ESTREF; ESTTEXTE; N; NA; FEUILLE; FEUILLES; TYPE Fonctions logiques Servent uniquement à vous donner une réponse VRAI ou FAUX. ET; FAUX; SI; SIERREUR; SI.NON.DISP; SI.CONDITIONS; PAS; OU; SI.MULTIPLE; VRAI; OUX Fonctions personnalisées Servent à accéder des fonctions personnalisées."
    },
   {
        "id": "UsageInstructions/InsertHeadersFooters.htm", 
        "title": "Insérer des en-têtes et des pieds de page", 
        "body": "Les en-têtes et pieds de page permettent d'ajouter des informations supplémentaires sur une feuille de calcul imprimée, telles que la date et l'heure, le numéro de page, le nom de la feuille, etc. Les en-têtes et pieds de pages sont affichés dans la version imprimée d'une feuille de calcul. Pour insérer un en-tête et un pied de page dans l'éditeur de classeurs, basculez vers l'onglet Insérer ou Mise en page, cliquez sur le bouton cliquez sur le bouton Modifier l'en-tête ou le pied de page dans la barre d'outils supérieure, la fenêtre des Paramètres des en-têtes/pieds de page s'ouvrira, où vous pouvez régler les paramètres suivants: cochez la case Première page différente pour appliquer un en-tête ou un pied de page différent à toute première page ou au cas où vous ne voulez y ajouter du tout d'en-tête ou pied de page. L'onglet Première page apparaîtra ci-dessous. cochez la case Pages paires et impaires différentes pour ajouter un en-tête/pied de page différent pour les pages paires et impaires. Les onglets Page paire et Page impaire apparaîtront ci-dessous. l'option Mettre à l'échelle du document permet de mettre à l'échelle l'en-tête et pied de page avec la feuille de calcul. Ce paramètre est activé par défaut. l'option Aligner avec les marges de page permet d'aligner l'en-tête/pied de page gauche sur la marge gauche et l'en-tête/pied de page droit sur la marge droite. Cette option est activée par défaut. Cette option est activée par défaut. insérez les données nécessaires. Selon les options sélectionnées, vous pouvez ajuster les paramètres pour Toutes les pages ou configurer l'en-tête/pied de page pour la première ainsi que pour les pages paires et impaires individuellement. Passez à l'onglet nécessaire et ajustez les paramètres disponibles. Vous pouvez utiliser l'un des préréglages prêts à l'emploi ou insérer manuellement les données nécessaires dans les champs d'en-tête/pied de page gauche, central et droit: choisissez l'un des Préréglages disponibles de la liste des préréglages: Page 1; Page 1 de?; Feuille 1; Confidentiel, jj/mm/aaaa, Page 1; Nom de la feuille de calcul.xlsx; Sheet1, Page 1; Sheet1, Confidential, Page 1; Nom de la feuille de calcul.xlsx, Page 1; Page 1, Feuille 1; Page 1, Nom de la feuille de calcul.xlsx; Auteur, Page 1, jj/mm/aaaa; préparé par Auteur jj/mm/aaaa, Page 1. Les variables correspondantes seront ajoutées. placez le curseur dans le champ gauche, central ou droit de l'en-tête/pied de page et utilisez la liste Insérer pour ajouter le Numéro de pages, le Compteur de page, la Date, l'Heure, le Nom de fichier, le Nom de feuille, l'Image. mettez en forme le texte de l'en-tête/pied de page à l'aide des commandes correspondantes. Vous pouvez changer la police par défaut, sa forme, couleur, appliquer certains styles de police, tels que gras, italique, souligné, barré, utiliser des caractères en exposant ou en indice. Lorsque vous êtes prêts, cliquez sur le bouton OK pour appliquer les modifications. Pour modifier les en-têtes/pieds de page ajoutés, cliquez sur le bouton Modifier l'en-tête/pied de page sur la barre d'outils supérieure, effectuez les modifications nécessaires dans la fenêtre Paramètre des en-têtes/pieds de page puis cliquez sur OK pour enregistrer les modifications. L'en-tête et / ou le pied de page seront affichés dans la version imprimée de la feuille de calcul."
    },
   {
        "id": "UsageInstructions/InsertImages.htm", 
        "title": "Insérer des images", 
        "body": "L'éditeur de classeurs vous permet d'insérer des images aux formats populaires dans votre feuille de calcul. Les formats d'image pris en charge sont les suivants: BMP, GIF, JPEG, JPG, PNG. Insérer une image Pour insérer une image dans votre classeur, placez le curseur à l'endroit où vous voulez insérer l'image, passez à l'onglet Insertion de la barre d'outils supérieure, cliquez sur l'icône l'icône Image de la barre d'outils supérieure, sélectionnez l'une des options suivantes pour charger l'image : l'option Image à partir d'un fichier ouvre la fenêtre de dialogue standard pour sélectionner le fichier. Sélectionnez le fichier de votre choix sur le disque dur de votre ordinateur et cliquez sur le bouton Ouvrir Dans l'éditeur en ligne, vous pouvez sélectionnez plusieurs images à la fois. l'option Image à partir d'une URL ouvre la fenêtre où vous pouvez saisir l'adresse Web de l'image et cliquer sur le bouton OK l'option Image de stockage ouvrira la fenêtre Sélectionner la source de données. Sélectionnez une image stockée sur votre portail et cliquez sur le bouton OK Après cela, l'image sera ajouté à la feuille de calcul. Vous pouvez sauvegarder l'image sur votre ordinateur à l'aide de l'option Enregistrer en tant qu'image dans le menu contextuel. Régler les paramètres de l'image Après avoir ajouté l'image, vous pouvez modifier sa taille et sa position. Pour spécifier les dimensions exactes de l'image: sélectionnez l'image avec la souris, cliquez sur l'icône Paramètres de l'image sur la barre latérale droite, Dans la section Taille, définissez les valeurs Largeur et Hauteur requises. Lorsque le bouton Proportions constantes est activé (dans ce cas, il ressemble à ceci ), la largeur et la hauteur seront changées en même temps, le ratio d'aspect du graphique original sera préservé. Pour rétablir la taille par défaut de l'image ajoutée, cliquez sur le bouton Taille actuelle. Pour rogner l'image: Cliquez sur le bouton Rogner pour activer les poignées de recadrage qui appairaient par chaque coin et sur les côtés. Faites glisser manuellement les pognées pour définir la zone de recadrage. Vous pouvez placer le curseur sur la bordure de la zone de rognage lorsque il se transforme en icône fléchée et faites glisser la zone. Pour rogner un seul côté, faites glisser la poignée située au milieu de ce côté. Pour rogner simultanément deux côtés adjacents, faites glisser l'une des poignées d'angle. Pour rogner également deux côtés opposés de l'image, maintenez la touche Ctrl enfoncée lorsque vous faites glisser la poignée au milieu de l'un de ces côtés. Pour rogner également tous les côtés de l'image, maintenez la touche Ctrl enfoncée lorsque vous faites glisser l'une des poignées d'angle. Lorsque la zone de recadrage est définie, cliquez à nouveau sur le bouton Rogner, ou appuyez sur la touche Echap, ou cliquez n'importe où à l'extérieur de la zone de recadrage pour appliquer les modifications. Une fois la zone de recadrage sélectionnée, il est également possible d'utiliser les options Rogner à la forme, Remplir et Ajuster disponibles dans le menu déroulant Rogner. Cliquez de nouveau sur le bouton Rogner et sélectionnez l'option de votre choix: Lorsque vous sélectionnez l'option Rogner à la forme, l'image va s'ajuster à une certaine forme. Vous pouvez sélectionner la forme appropriée dans la galerie qui s'affiche lorsque vous placez le pointeur de la souris sur l'option Rogner à la forme. Vous pouvez toujours utiliser les options Remplir et Ajuster pour choisir le façon d'ajuster votre image à la forme. Si vous sélectionnez l'option Remplissage, la partie centrale de l'image originale sera conservée et utilisée pour remplir la zone de cadrage sélectionnée, tandis que les autres parties de l'image seront supprimées. Si vous sélectionnez l'option Ajuster, l'image sera redimensionnée pour correspondre à la hauteur ou à la largeur de la zone de recadrage. Aucune partie de l'image originale ne sera supprimée, mais des espaces vides peuvent Pour faire pivoter l'image: sélectionnez l'image avec la souris, cliquez sur l'icône Paramètres de l'image sur la barre latérale droite, dans la section Rotation, cliquez sur l'un des boutons: pour faire pivoter l'image de 90 degrés dans le sens inverse des aiguilles d'une montre pour faire pivoter l'image de 90 degrés dans le sens des aiguilles d'une montre pour retourner l'image horizontalement (de gauche à droite) pour retourner l'image verticalement (à l'envers) Vous pouvez également cliquer avec le bouton droit sur l'image et utiliser l'option Faire pivoter dans le menu contextuel. Pour remplacer l'image insérée, sélectionnez l'image avec la souris, cliquez sur l'icône Paramètres de l'image sur la barre latérale droite, Cliquez sur le bouton Remplacer l'image, choisissez l'option appropriée: D'un fichier, À partir de l'espace de stockage ou D'une URL et sélectionnez l'image désirée. Vous pouvez également cliquer avec le bouton droit sur l'image et utiliser l'option Remplacer l'image dans le menu contextuel. L'image sélectionnée sera remplacée. Une fois l'image est sélectionnée, l'icône Paramètres de la forme deviendra aussi disponible à droite. Vous pouvez cliquer sur cette icône pour ouvrir l'onglet Paramètres de la forme dans la barre latérale droite et ajuster le type, la taille, la couleur et l'opacité de la Ligne ainsi que le type de la forme en sélectionnant une autre forme dans le menu Modifier la forme automatique. La forme de l'image changera en conséquence. Sous l'onglet Paramètres de la forme, vous pouvez utiliser l'option Ajouter une ombre pour créer une zone ombrée autour de l'image. Ajuster les paramètres avancés de l'image Pour modifier les paramètres avancés, cliquez sur l'image avec le bouton droit de la souris et sélectionnez Paramètres avancés de l'image du menu contextuel ou cliquez sur le lien de la barre latérale droite Afficher les paramètres avancés. La fenêtre paramètres de l'image s'ouvre: L'onglet Rotation comporte les paramètres suivants: Angle - utilisez cette option pour faire pivoter l'image d'un angle exactement spécifié. Entrez la valeur souhaitée mesurée en degrés dans le champ ou réglez-la à l'aide des flèches situées à droite. Retourné - cochez la case Horizontalement pour retourner l'image horizontalement (de gauche à droite) ou la case Verticalement pour retourner l'image verticalement (à l'envers). L'onglet Alignement dans une cellule comprend les options suivantes: Déplacer et dimensionner avec des cellules - cette option permet de placer l'image derrière la cellule. Quand une cellule se déplace (par exemple: insertion ou suppression des lignes/colonnes), l'image se déplace aussi. Quand vous ajustez la largeur ou la hauteur de la cellule, la dimension de l'image s'ajuste aussi. Déplacer sans dimensionner avec les cellules - cette option permet de placé l'image derrière la cellule mais d'empêcher le redimensionnement. Quand une cellule se déplace, l'image se déplace aussi, mais si vous redimensionnez la cellule, l'image demeure inchangé. Ne pas déplacer et dimensionner avec les cellules - cette option empêche le déplacement ou redimensionnement de l'image si la position ou la dimension de la cellule restent inchangées. L'onglet Texte de remplacement permet de spécifier un Titre et une Description qui sera lue aux personnes avec des déficiences cognitives ou visuelles pour les aider à mieux comprendre l'information de l'image. Pour supprimer l'image insérée, cliquez sur celle-ci et appuyez sur la touche Suppr. Affecter une macro à une image Pour rendre l'accès à macro plus rapide et facile dans une feuille de calcul, vous pouvez affecter une macro à une image. Une fois la macro affectée, l'image apparaît ainsi comme un bouton de contrôle et vous pouvez lancer la macro par un clic dessus. Pour affecter une macro: Cliquer avec le bouton droit de la souris sur l'image et sélectionnez l'option Affecter une macro dans le menu déroulant. La boîte de dialogue Affecter une macro s'affiche. Sélectionnez la macro dans la liste ou saisissez le nom et cliquez sur OK."
    },
   {
        "id": "UsageInstructions/InsertSmartArt.htm", 
        "title": "Insérer des graphiques SmartArt", 
        "body": "Un graphique SmartArt sert à créer une représentation visuelle de la structure hiérarchique en choisissant le type du graphique qui convient le mieux. Insérez des graphiques SmartArt ou modifiez des graphiques SmartArt qui ont été créés dans des logiciels d'éditeurs tiers. Pour ajouter un graphiques SmartArt, passez à l'onglet Insertion, cliquez sur le bouton SmartArt, placez le pointeur sur l'un des styles de mise en page disponibles, par ex. Liste ou Processus. sélectionnez le type de mise en page de la liste qui apparaît à droite de l'option du menu mis en surbrillance. Vous pouvez sauvegarder un graphique SmartArt en tant qu'image sur votre ordinateur à l'aide de l'option Enregistrer en tant qu'image dans le menu contextuel. Vous pouvez personnaliser la configuration SmartArt sur le panneau à droite: Veuillez noter qu'il est possible de personnaliser les paramètres de couleur, style et forme. Remplissage - utilisez cette section pour sélectionner le remplissage du graphique SmartArt. Les options disponibles sont les suivantes: Couleur de remplissage - sélectionnez cette option pour spécifier la couleur unie à utiliser pour remplir l'espace intérieur du graphique SmartArt. Remplissage en dégradé - sélectionnez cette option pour spécifier deux couleurs pour créer une transition douce entre elles et remplir la forme. Personnaliser votre dégradé sans aucune contrainte. Cliquez sur l'icône Paramètres de la forme. pour ouvrir le menu Remplissage de la barre latérale sur la droite: Les options disponibles du menu: Style - choisissez Linéaire or Radial: Linéaire sert à remplir par un dégradé de gauche à droite, de bas en haut ou sous l'angle partant en direction définie. La fenêtre d'aperçu Direction affiche la couleur de dégradé sélectionnée, cliquez sur la flèche pour définir la direction du dégradé. Utilisez les paramètres Angle pour définir un angle précis du dégradé. Radial sert à remplir par un dégradé de forme circulaire entre le point de départ et le point d'arrivée. Point de dégradé est le point d'arrêt de d'une couleur et de la transition entre les couleurs. Utilisez le bouton Ajouter un point de dégradé ou le curseur de dégradé pour ajouter un point de dégradé. Vous pouvez ajouter 10 points de dégradé. Le nouveau arrêt de couleur n'affecte pas l'aspect actuel du dégradé. Utilisez le bouton Supprimer un point de dégradé pour supprimer un certain point de dégradé. Faites glisser le curseur de déragé pour changer l'emplacement des points de dégradé ou spécifiez la Position en pourcentage pour l'emplacement plus précis. Pour choisir la couleur au dégradé, cliquez sur l'arrêt concerné sur le curseur de dégradé, ensuite cliquez sur Couleur pour sélectionner la couleur appropriée. Image ou Texture - sélectionnez cette option pour utiliser une image ou une texture prédéfinie en tant que l'arrière-plan du graphique SmartArt. Si vous souhaitez utiliser une image en tant que l'arrière-plan du graphique SmartArt, vous pouvez ajouter une image D'un fichier en la sélectionnant sur le disque dur de votre ordinateur ou D'une URL en insérant l'adresse URL appropriée dans la fenêtre ouverte, ou À partir de l'espace de stockage en sélectionnant l'image nécessaire sur votre portail. Si vous souhaitez utiliser une texture en tant que arrière-plan du graphique SmartArt, utilisez le menu déroulant D'une texture et sélectionnez le préréglage de la texture nécessaire. Actuellement, les textures suivantes sont disponibles: Toile, Carton, Tissu foncé, Grain, Granit, Papier gris, Tricot, Cuir, Papier brun, Papyrus, Bois. Si l'image sélectionnée est plus grande ou plus petite que le graphique SmartArt, vous pouvez utiliser l'une des options Prolonger ouTuile depuis la liste déroulante. L'option Prolonger permet de régler la taille de l'image pour l'adapter à la taille de la forme automatique afin qu'elle puisse remplir tout l'espace uniformément. L'option Tuile permet d'afficher seulement une partie de l'image plus grande en gardant ses dimensions d'origine, ou de répéter l'image plus petite en conservant ses dimensions initiales sur la surface du graphique SmartArt afin qu'elle puisse remplir tout l'espace uniformément. Remarque: tout préréglage Texture sélectionné remplit l'espace de façon uniforme, mais vous pouvez toujours appliquer l'effet Prolonger, si nécessaire. Modèle - sélectionnez cette option pour sélectionner le modèle à deux couleurs composé des éléments répétés pour remplir l'espace intérieur du graphique SmartArt. Modèle - sélectionnez un des modèles prédéfinis du menu. Couleur de premier plan - cliquez sur cette palette de couleurs pour changer la couleur des éléments du modèle. Couleur d'arrière-plan - cliquez sur cette palette de couleurs pour changer de l'arrière-plan du modèle. Pas de remplissage - sélectionnez cette option si vous ne voulez pas utiliser un remplissage. Trait - sert à régler la taille, la couleur et le type du contour du graphique SmartArt. Pour modifier la largeur du trait, sélectionnez l'une des options disponibles depuis la liste déroulante Taille. Les options disponibles sont les suivantes: 0,5 pt, 1 pt, 1,5 pt, 2,25 pt, 3 pt, 4,5 pt, 6 pt ou Pas de ligne si vous ne voulez pas utiliser de trait. Pour changer la couleur du contour, cliquez sur la case colorée et sélectionnez la couleur voulue. Pour modifier le type de contour, sélectionnez l'option voulue dans la liste déroulante correspondante (une ligne continue est appliquée par défaut, vous pouvez la remplacer par l'une des lignes pointillées disponibles). Pour modifier l'opacité du trait, saisissez la valeur manuellement ou utilisez la barre de curseur. Ajouter une ombre activez cette option pour ajouter une ombre portée à un graphique SmartArt. Cliquez sur Afficher les paramètres avancés pour accéder aux paramètres avancés."
    },
   {
        "id": "UsageInstructions/InsertSparklines.htm", 
        "title": "Insérer des graphiques sparkline", 
        "body": "Utiliser des graphiques sparkline Un graphique sparkline est un graphique tout petit qui s'adapte à la taille de la cellule et représente des tendances ou des variations des données. Les fonctionnalités des graphiques sparkline sont limitées par comparaison avec des graphiques habituels mais c'est un excellent outil d'analyse rapide des données et de représentation visuelle compacte. La taille d'un graphique sparkline dépend de la taille de la cellule, ajustez la largeur et la longueur de la cellule pour paramétrer la taille du graphique sparkline. Une fois le graphique sparkline ajouté, il est possible de saisir du texte ou appliquer une mise en forme conditionnelle dans la même cellule. L'éditeur de classeurs ONLYOFFICE vous propose trois types de graphiques sparkline: Colonne est similaire à un Graphique à colonnes ordinaire. Ligne est similaire à un Graphique à lignes ordinaire. Gain/Perte ce type est approprié pour représenter des données qui incluent à la fois des valeurs positives et négatives. Insérer des graphiques sparkline Pour insérer un Graphique sparkline, sélectionnez une plage de données à inclure dans le graphique sparkline ou cliquez sur une cellule vide où vous souhaitez placer le graphique sparkline, passez à l'onglet Insertion et cliquez sur le bouton Graphique sparkline de la barre d'outils supérieure. Choisissez le graphique sparkline selon vos besoins. La fenêtre Créer des graphiques sparkline s'affiche, cliquez sur l'icône Sélectionner des données pour définir une plage de données et l'emplacement du graphique sparkline, cliquez sur OK pour valider. Modifier et mettre en forme un graphique sparkline Une fois le graphique sparkline inséré, vous pouvez le personnaliser et modifier. Cliquez sur la cellule comprenant un graphique sparkline pour activer l'onglet Paramètres du graphique sparkline sur la barre latérale droite. Dans la section Type, vous pouvez sélectionner l'un des types de graphiques sparkline disponibles dans la liste déroulante : Colonne - ce type est similaire à un Graphique à colonnes ordinaire. Ligne - ce type est similaire à un Graphique à lignes ordinaire. Gain/Perte - ce type est approprié pour représenter des données qui incluent à la fois des valeurs positives et négatives. Dans la section Style, vous pouvez sélectionner le style qui vous convient le mieux dans la liste déroulante Modèle , la Couleur appropriée pour le graphique sparkline et Épaisseur de trait (disponible uniquement pour les graphiques sparklines en Ligne) Dans la section Afficher, vous pouvez mettre en surbrillance ou marquer les données dans un graphique sparkline : Point élevé - pour mettre en évidence les points qui représentent des valeurs maximales. Point bas - pour mettre en évidence les points qui représentent des valeurs maximales. Point négatif - pour mettre en évidence les points qui représentent des valeurs négatives, Premier point - pour mettre en évidence le point qui représente la première valeur. Dernier point - pour mettre en évidence le point qui représente la dernière valeur. Marqueurs est disponible uniquement pour des graphiques sparkline en Ligne pour mettre en surbrillance toutes les valeurs. Cliquez sur la flèche en bas dans la zone de couleur pour sélectionnez une couleur pour chaque valeur. Pour rendre votre graphique sparkline plus précis et facile à comprendre, cliquez sur l'option Afficher les paramètres avancés pour accéder à la fenêtre Graphique sparkline - Paramètres avancés. L'onglet Type et données vous permet de modifier le Type et le Style du graphique sparkline, ainsi que de spécifier les paramètres d'affichage des Cellules masquées et vides : Afficher les cellules vides comme - cette option permet de contrôler l'affichage des graphiques sparklines si certaines cellules d'une plage de données sont vides. Sélectionnez l'option souhaitée dans la liste : Vides - pour afficher le graphique sparkline avec des vides à la place des données manquantes, Zéro - pour afficher le graphique sparkline comme si la valeur dans une cellule vide était nulle, Connecter les points de données avec la ligne (disponible uniquement pour le type Ligne) - pour ignorer les cellules vides et afficher une ligne de connexion entre les points de données. Afficher les données dans les lignes et les colonnes masquées - cochez cette case si vous souhaitez inclure des valeurs provenant des cellules masquées dans les graphiques sparklines. L'onglet Options de l'axe vous permet de spécifier les paramètres d'Axe horizontal/vertical suivants : Dans la section Axe horizontal, les paramètres suivants sont disponibles : Afficher l'axe - cochez cette case pour afficher l'axe horizontal. Si les données source contiennent des valeurs négatives, cette option permet de les afficher plus clairement. Inverser l'ordre - cochez cette case pour afficher les données dans l'ordre inverse. Dans la section Axe vertical, les paramètres suivants sont disponibles pour définir la Valeur minimale/maximale : Valeur minimale/maximale Automatique pour chaque - cette option est sélectionnée par défaut. Elle permet d'utiliser des valeurs minimum/maximum propres pour chaque graphique sparkline. Les valeurs minimum/maximum sont extraites des séries de données séparées qui sont utilisées pour tracer chaque graphique sparkline. La valeur maximale pour chaque graphique sparkline sera située en haut de la cellule, et la valeur minimale sera en bas. La même pour tous - cette option permet d'utiliser la même valeur minimum/maximum pour tout le groupe de graphiques sparklines. Les valeurs minimum/maximum sont extraites de toute la plage de données et utilisées pour tracer toutes les graphiques sparklines. Les valeurs maximum/minimum pour chaque sparkline seront mises à l'échelle par rapport à la valeur la plus haute/la plus basse dans la plage. Si vous sélectionnez cette option, il sera plus facile de comparer plusieurs graphiques sparklines. Fixé - cette option permet de définir une valeur minimale/maximale personnalisée. Les valeurs inférieures ou supérieures à celles spécifiées ne sont pas affichées dans le graphique sparkline. Supprimer les graphiques sparkline Pour supprimer les graphiques sparkline, sélectionnez une ou plusieurs cellules comprenant des graphiques sparkline que vous souhaitez supprimer et cliquez avec le bouton droit de la souris. Sélectionnez Graphiques sparkline dans le menu déroulant et cliquez sur Supprimer les graphiques sparkline sélectionnés ou Supprimer les groupes de graphiques sparkline sélectionnés."
    },
   {
        "id": "UsageInstructions/InsertSymbols.htm", 
        "title": "Insérer des symboles et des caractères", 
        "body": "Pendant le travail dans l'éditeur de classeurs, il se peut que vous deviez insérer un symbole qui n'est pas sur votre clavier. Pour insérer de tels symboles dans votre feuille de calcul, utilisez l'option Insérer un symbole et suivez ces étapes simples: Placez le curseur à l'endroit où vous voulez ajouter un symbole spécifique. Passez à l'onglet Insertion de la barre d'outils supérieure. Cliquez sur l'icône Symbole. Cliquez sur l'option Autres symboles. Dans la boîte de dialogue Symbole qui s'affiche vous pouvez sélectionner le symbole approprié, Utilisez la section Plage pour rechercher rapidement le symbole nécessaire. Tous les symboles sont divisés en groupes spécifiques, par exemple, sélectionnez des «symboles monétaires» spécifiques si vous souhaitez insérer un caractère monétaire. Si le symbole n'est pas dans le jeu, sélectionnez une police différente. Plusieurs d'entre elles ont également des caractères différents que ceux du jeu standard. Vous pouvez également saisir la valeur hexadécimale Unicode du symbole souhaité dans le champ Valeur hexadécimale Unicode. Ce code se trouve dans la Carte des caractères. Vous pouvez aussi utiliser l'onglet Symboles spéciaux pour choisir un symbole spéciale proposé dans la liste. Les symboles précédemment utilisés sont également affichés dans le champ des Caractères spéciaux récemment utilisés, Cliquez sur Insérer. Le caractère sélectionné sera ajouté à la feuille de calcul. Pour insérer les symboles populaires ou récemment uti