/*
 * Copyright (C) Ascensio System SIA 2012-2026. All rights reserved
 *
 * https://www.onlyoffice.com/
 *
 * Version: 0.0.0 (build:0)
 */

var g_version="0.0.0-0";var pathnameParts=self.location.pathname.split("/");if(pathnameParts.length>1&&pathnameParts[pathnameParts.length-2])g_version=pathnameParts[pathnameParts.length-2];var g_cacheNamePrefix="document_editor_static_";var g_cacheName=g_cacheNamePrefix+g_version;var g_cacheablePrefixes=["web-apps/","sdkjs/","fonts/","sdkjs-plugins/","dictionaries/"];var isDesktopEditor=navigator.userAgent.indexOf("AscDesktopEditor")!==-1;var g_storageInfoCache=null;var g_storageInfoCacheTime=0;
var STORAGE_INFO_CACHE_DURATION=3E4;function safeToCache(request,response){return request.method==="GET"&&response&&response.ok&&(response.type==="basic"||response.type==="cors")&&!response.redirected}
function getStorageInfo(){var now=Date.now();if(g_storageInfoCache!==null&&now-g_storageInfoCacheTime<STORAGE_INFO_CACHE_DURATION)return Promise.resolve(g_storageInfoCache);if(!navigator.storage||!navigator.storage.estimate){g_storageInfoCache={maxEntrySize:50*1024*1024,isHealthy:true};g_storageInfoCacheTime=now;return Promise.resolve(g_storageInfoCache)}return navigator.storage.estimate().then(function(estimate){if(!estimate||typeof estimate.quota!=="number"||!isFinite(estimate.quota)||estimate.quota<=
0||typeof estimate.usage!=="number"||!isFinite(estimate.usage)){g_storageInfoCache={maxEntrySize:50*1024*1024,isHealthy:true};g_storageInfoCacheTime=Date.now();return g_storageInfoCache}var cacheSize=Math.min(estimate.quota*.1,1024*1024*1024);var maxEntrySize=cacheSize/8;var usageRatio=estimate.usage/estimate.quota;var isHealthy=usageRatio<.8;g_storageInfoCache={maxEntrySize:maxEntrySize,isHealthy:isHealthy};g_storageInfoCacheTime=Date.now();return g_storageInfoCache}).catch(function(error){g_storageInfoCache=
{maxEntrySize:50*1024*1024,isHealthy:true};g_storageInfoCacheTime=Date.now();return g_storageInfoCache})}function isReasonableSize(response){var size=Number(response.headers.get("content-length"))||0;if(size===0)return Promise.resolve(true);return getStorageInfo().then(function(info){return size<info.maxEntrySize})}function storageHealthy(){return getStorageInfo().then(function(info){return info.isHealthy})}
function putInCache(request,response,attempt){if(typeof attempt==="undefined")attempt=0;return caches.open(g_cacheName).then(function(cache){return cache.put(request,response.clone())}).catch(function(err){if(attempt<2)return(new Promise(function(resolve){setTimeout(resolve,250*Math.pow(2,attempt))})).then(function(){return putInCache(request,response,attempt+1)});else{var size=response.headers?response.headers.get("content-length"):"unknown";console.error("putInCache failed after max retries:",{url:request.url,
method:request.method,responseSize:size,responseType:response.type,cacheName:g_cacheName,error:err&&(err.message||err)})}})}
function cacheFirst(event){var request=event.request;return caches.match(request,{cacheName:g_cacheName}).then(function(cached){return cached||fetch(request).then(function(networkResp){var responseForCache=networkResp.clone();if(safeToCache(request,networkResp))event.waitUntil(getStorageInfo().then(function(info){var size=Number(networkResp.headers.get("content-length"))||0;var sizeOk=size===0||size<info.maxEntrySize;if(info.isHealthy&&sizeOk)return putInCache(request,responseForCache)}));return networkResp})})}
function activateWorker(event){return self.clients.claim().then(function(){return caches.keys()}).then(function(keys){var deletePromises=keys.filter(function(cache){return cache.includes(g_cacheNamePrefix)&&!cache.includes(g_cacheName)}).map(function(cache){return caches.delete(cache)});return Promise.all(deletePromises)}).catch(function(err){console.error("activateWorker failed with "+err)})}
function matchesCacheablePath(url){var g_versionNeedle="/"+g_version+"/";var versionIndex=url.indexOf(g_versionNeedle);if(versionIndex===-1)return false;var i=versionIndex+g_versionNeedle.length;var k=0;for(;k<g_cacheablePrefixes.length;k++)if(url.startsWith(g_cacheablePrefixes[k],i))return true;return false}self.addEventListener("install",function(event){event.waitUntil(self.skipWaiting())});self.addEventListener("activate",function(event){event.waitUntil(activateWorker())});
self.addEventListener("fetch",function(event){var request=event.request;var url=request.url;if(request.method!=="GET"||!matchesCacheablePath(url))return;if(isDesktopEditor&&url.indexOf("/sdkjs/common/AllFonts.js")!==-1)return;event.respondWith(cacheFirst(event))});
