var indexes = 
[
   {
        "id": "Functions/abs.htm", 
        "title": "ABS Function", 
        "body": "The ABS function is one of the math and trigonometry functions. It is used to return the absolute value of a number (i.e. the number without its sign). Syntax ABS(number) The ABS function has the following argument: Argument Description number A numeric value for which you want to get the absolute value. Notes How to apply the ABS function. Examples There is a single argument: number = A1 = -123.14. So the function returns 123.14 (-123.14 without its sign)."
    },
   {
        "id": "Functions/accrint.htm", 
        "title": "ACCRINT Function", 
        "body": "The ACCRINT function is one of the financial functions. It is used to calculate the accrued interest for a security that pays periodic interest. Syntax ACCRINT(issue, first_interest, settlement, rate, par, frequency, [basis], [calc_method]) The ACCRINT function has the following arguments: Argument Description issue The issue date of the security. first_interest The date when the first interest is paid. settlement The date when the security is purchased. rate The annual coupon rate of the security. par The par value of the security. It is an optional argument. If it is omitted, the function will assume par to be $1000. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. calc_method A logical value that specifies the way to calculate the accrued interest when the settlement date is later than the first_interest date. It is an optional argument. TRUE (1) returns the accrued interest from issue to settlement. FALSE (0) returns the accrued interest from first_interest to settlement. If the argument is omitted, TRUE is used by default. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the ACCRINT function. Examples The figure below displays the result returned by the ACCRINT function."
    },
   {
        "id": "Functions/accrintm.htm", 
        "title": "ACCRINTM Function", 
        "body": "The ACCRINTM function is one of the financial functions. It is used to calculate the accrued interest for a security that pays interest at maturity. Syntax ACCRINTM(issue, settlement, rate, par, [basis]) The ACCRINTM function has the following arguments: Argument Description issue The issue date of the security. settlement The maturity date of the security. rate The annual interest rate of the security. par The par value of the security. It is an optional argument. If it is omitted, the function will assume par to be $1000. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the ACCRINTM function. Examples The figure below displays the result returned by the ACCRINTM function."
    },
   {
        "id": "Functions/acos.htm", 
        "title": "ACOS Function", 
        "body": "The ACOS function is one of the math and trigonometry functions. It is used to return the arccosine of a number. Syntax ACOS(number) The ACOS function has the following argument: Argument Description number The cosine of the angle you wish to find, a numeric value greater than or equal to -1 but less than or equal to 1. Notes How to apply the ACOS function. Examples The figure below displays the result returned by the ACOS function."
    },
   {
        "id": "Functions/acosh.htm", 
        "title": "ACOSH Function", 
        "body": "The ACOSH function is one of the math and trigonometry functions. It is used to return the inverse hyperbolic cosine of a number. Syntax ACOSH(number) The ACOSH function has the following argument: Argument Description number A numeric value greater than or equal to 1. Notes How to apply the ACOSH function. Examples The figure below displays the result returned by the ACOSH function."
    },
   {
        "id": "Functions/acot.htm", 
        "title": "ACOT Function", 
        "body": "The ACOT function is one of the math and trigonometry functions. It is used to return the principal value of the arccotangent, or inverse cotangent, of a number. The returned angle is measured in radians in the range 0 to Pi. Syntax ACOT(number) The ACOT function has the following argument: Argument Description number The cotangent of the angle you wish to find, a numeric value. Notes How to apply the ACOT function. Examples The figure below displays the result returned by the ACOT function."
    },
   {
        "id": "Functions/acoth.htm", 
        "title": "ACOTH Function", 
        "body": "The ACOTH function is one of the math and trigonometry functions. It is used to return the inverse hyperbolic cotangent of a number. Syntax ACOTH(number) The ACOTH function has the following argument: Argument Description number A numeric value less than -1 or greater than 1. Notes How to apply the ACOTH function. Examples The figure below displays the result returned by the ACOTH function."
    },
   {
        "id": "Functions/address.htm", 
        "title": "ADDRESS Function", 
        "body": "The ADDRESS function is one of the lookup and reference functions. It is used to return a text representation of a cell address. Syntax ADDRESS(row_num, column_num, [abs_num], [a1], [sheet_text]) The ADDRESS function has the following arguments: Argument Description row_num A row number to use in a cell address. column_num A column number to use in a cell address. abs_num A type of reference. The possible values are listed in the table below. a1 An optional logical value: TRUE or FALSE. If it is set to TRUE or omitted, the function will return an A1-style reference. If it is set to FALSE, the function will return an R1C1-style reference. sheet_text The name of the sheet to use in a cell address. It's an optional value. If it is omitted, the function will return the cell address without the sheet name indicated. The abs_num argument can be one of the following: Numeric value Meaning 1 or omitted Absolute referencing 2 Absolute row; relative column 3 Relative row; absolute column 4 Relative referencing Notes How to apply the ADDRESS function. Examples The figure below displays the result returned by the ADDRESS function."
    },
   {
        "id": "Functions/aggregate.htm", 
        "title": "AGGREGATE Function", 
        "body": "The AGGREGATE function is one of the math and trigonometry functions. The function is used to return an aggregate in a list or database. The AGGREGATE function can apply different aggregate functions to a list or database with the option to ignore hidden rows and error values. Syntax AGGREGATE(function_num, options, ref1, [ref2], ...) The AGGREGATE function has the following arguments: Argument Description function_num A numeric value that specifies which function to use. The possible values are listed in the table below. options A numeric value that specifies which values should be ignored. The possible values are listed in the table below. ref1 The first numeric value for which you want the aggregate value. ref2 Up to 253 numeric values or a reference to the cell range containing the values for which you want the aggregate value. It is an optional argument. The function_num argument can be one of the following: function_num Function 1 AVERAGE 2 COUNT 3 COUNTA 4 MAX 5 MIN 6 PRODUCT 7 STDEV.S 8 STDEV.P 9 SUM 10 VAR.S 11 VAR.P 12 MEDIAN 13 MODE.SNGL 14 LARGE 15 SMALL 16 PERCENTILE.INC 17 QUARTILE.INC 18 PERCENTILE.EXC 19 QUARTILE.EXC The options argument can be one of the following: Numeric value Behavior 0 or omitted Ignore nested SUBTOTAL and AGGREGATE functions 1 Ignore hidden rows, nested SUBTOTAL and AGGREGATE functions 2 Ignore error values, nested SUBTOTAL and AGGREGATE functions 3 Ignore hidden rows, error values, nested SUBTOTAL and AGGREGATE functions 4 Ignore nothing 5 Ignore hidden rows 6 Ignore error values 7 Ignore hidden rows and error values Notes If you want to use one of the following functions: LARGE, SMALL, PERCENTILE.INC, QUARTILE.INC, PERCENTILE.EXC, or QUARTILE.EXC, ref1 must be a reference to the cell range and ref2 must be the second argument that is required for these functions (k or quart). Function Syntax LARGE LARGE(array, k) SMALL SMALL(array, k) PERCENTILE.INC PERCENTILE.INC(array, k) QUARTILE.INC QUARTILE.INC(array, quart) PERCENTILE.EXC PERCENTILE.EXC(array, k) QUARTILE.EXC QUARTILE.EXC(array, quart) How to apply the AGGREGATE function. Examples The figure below displays the result returned by the AGGREGATE function when the SUM function is applied. The figure below displays the result returned by the AGGREGATE function when the LARGE function is applied, ref1 is a reference to the cell range, and k is equal to 2. The function returns the second largest value in cells A1-A4."
    },
   {
        "id": "Functions/amordegrc.htm", 
        "title": "AMORDEGRC Function", 
        "body": "The AMORDEGRC function is one of the financial functions. It is used to calculate the depreciation of an asset for each accounting period using a degressive depreciation method. Syntax AMORDEGRC(cost, date_purchased, first_period, salvage, period, rate, [basis]) The AMORDEGRC function has the following arguments: Argument Description cost The cost of the asset. date_purchased The date when asset is purchased. first_period The date when the first period ends. salvage The salvage value of the asset at the end of its lifetime. period The period you wish to calculate depreciation for. rate The rate of depreciation. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the AMORDEGRC function. Examples"
    },
   {
        "id": "Functions/amorlinc.htm", 
        "title": "AMORLINC Function", 
        "body": "The AMORLINC function is one of the financial functions. It is used to calculate the depreciation of an asset for each accounting period using a linear depreciation method. Syntax AMORLINC(cost, date_purchased, first_period, salvage, period, rate, [basis]) The AMORLINC function has the following arguments: Argument Description cost The cost of the asset. date_purchased The date when asset is purchased. first_period The date when the first period ends. salvage The salvage value of the asset at the end of its lifetime. period The period you wish to calculate depreciation for. rate The rate of depreciation. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the AMORLINC function. Examples The figure below displays the result returned by the AMORLINC function."
    },
   {
        "id": "Functions/and.htm", 
        "title": "AND Function", 
        "body": "The AND function is one of the logical functions. It is used to check if the logical value you enter is TRUE or FALSE. The function returns TRUE if all the arguments are TRUE. Syntax AND(logical1, [logical2], ...) The AND function has the following arguments: Argument Description logical1/2/n A condition that you want to check if it is TRUE or FALSE Notes How to apply the AND function. The function returns FALSE if at least one of the arguments is FALSE. Examples There are three arguments: logical1 = A1&lt;100, logical2 = 34&lt;100, logical3 = 50&lt;100, where A1 is 12. All these logical expressions are TRUE. So the function returns TRUE. If we change the A1 value from 12 to 112, the function returns FALSE:"
    },
   {
        "id": "Functions/arabic.htm", 
        "title": "ARABIC Function", 
        "body": "The ARABIC function is one of the math and trigonometry functions. The function is used to convert a Roman numeral to an Arabic numeral. Syntax ARABIC(text) The ARABIC function has the following argument: Argument Description text A text representation of a Roman numeral: a string enclosed in quotation marks or a reference to a cell containing text. Notes If an empty string (\"\") is used as an argument, the function returns the value 0. How to apply the ARABIC function. Examples The figure below displays the result returned by the ARABIC function."
    },
   {
        "id": "Functions/arraytotext.htm", 
        "title": "ARRAYTOTEXT Function", 
        "body": "The ARRAYTOTEXT function is one of the text and data functions. It is used to return a range of data as a text string. Syntax ARRAYTOTEXT(array, [format]) The ARRAYTOTEXT function has the following arguments: Argument Description array The range of data to return as text. format An optional argument. The possible values are listed in the table below. The format argument can be one of the following: Format Explanation 0 The values in the text string will be separated by comma (set by default). 1 To enclose each text value in double quotes (except for numbers, true/false values and errors), to use a semicolon as a delimiter and to enclose the whole text string in curly braces. Notes How to apply the ARRAYTOTEXT function. Examples The figure below displays the result returned by the ARRAYTOTEXT function."
    },
   {
        "id": "Functions/asc.htm", 
        "title": "ASC Function", 
        "body": "The ASC function is one of the text and data functions. Is used to change full-width (double-byte) characters to half-width (single-byte) characters for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax ASC(text) The ASC function has the following argument: Argument Description text The text or a reference to a cell containing the text you want to change. If the text does not contain full-width characters it remains unchanged. Notes How to apply the ASC function. Examples The figure below displays the result returned by the ASC function."
    },
   {
        "id": "Functions/asin.htm", 
        "title": "ASIN Function", 
        "body": "The ASIN function is one of the math and trigonometry functions. It is used to return the arcsine of a number. Syntax ASIN(number) The ASIN function has the following argument: Argument Description number The sine of the angle you wish to find, a numeric value greater than or equal to -1 but less than or equal to 1 entered manually or included into the cell you make reference to. Notes How to apply the ASIN function. Examples The figure below displays the result returned by the ASIN function."
    },
   {
        "id": "Functions/asinh.htm", 
        "title": "ASINH Function", 
        "body": "The ASINH function is one of the math and trigonometry functions. It is used to return the inverse hyperbolic sine of a number. Syntax ASINH(number) The ASINH function has the following argument: Argument Description number Any numeric value entered manually or included into the cell you make reference to. Notes How to apply the ASINH function. Examples The figure below displays the result returned by the ASINH function."
    },
   {
        "id": "Functions/atan.htm", 
        "title": "ATAN Function", 
        "body": "The ATAN function is one of the math and trigonometry functions. It is used to return the arctangent of a number. Syntax ATAN(number) The ATAN function has the following argument: Argument Description number The tangent of the angle you wish to find, a numeric value entered manually or included into the cell you make reference to. Notes How to apply the ATAN function. Examples The figure below displays the result returned by the ATAN function."
    },
   {
        "id": "Functions/atan2.htm", 
        "title": "ATAN2 Function", 
        "body": "The ATAN2 function is one of the math and trigonometry functions. It is used to return the arctangent of x and y coordinates. Syntax ATAN2(x_num, y_num) The ATAN2 function has the following arguments: Argument Description x_num The x coordinate of a point, a numeric value entered manually or included into the cell you make reference to. y_num The y coordinate of a point, a numeric value entered manually or included into the cell you make reference to. Notes How to apply the ATAN2 function. Examples The figure below displays the result returned by the ATAN2 function."
    },
   {
        "id": "Functions/atanh.htm", 
        "title": "ATANH Function", 
        "body": "The ATANH function is one of the math and trigonometry functions. It is used to return the inverse hyperbolic tangent of a number. Syntax ATANH(number) The ATANH function has the following argument: Argument Description number A numeric value greater than - 1 but less than 1 entered manually or included into the cell you make reference to. Notes How to apply the ATANH function. Examples The figure below displays the result returned by the ATANH function."
    },
   {
        "id": "Functions/avedev.htm", 
        "title": "AVEDEV Function", 
        "body": "The AVEDEV function is one of the statistical functions. It is used to analyze the range of data and return the average of the absolute deviations of numbers from their mean. Syntax AVEDEV(number1, [number2], ...) The AVEDEV function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to find the average of the absolute deviations. Notes How to apply the AVEDEV function. Examples The figure below displays the result returned by the AVEDEV function."
    },
   {
        "id": "Functions/average.htm", 
        "title": "AVERAGE Function", 
        "body": "The AVERAGE function is one of the statistical functions. It is used to analyze the range of data and find the average value. Syntax AVERAGE(number1, [number2], ...) The AVERAGE function has the following arguments: Argument Description number1/2/n Up to 255 numerical values for which you want to find the average value. Notes How to apply the AVERAGE function. Examples The figure below displays the result returned by the AVERAGE function."
    },
   {
        "id": "Functions/averagea.htm", 
        "title": "AVERAGEA Function", 
        "body": "The AVERAGEA function is one of the statistical functions. It is used to analyze the range of data including text and logical values and find the average value. The AVERAGEA function treats text and FALSE as a value of 0 and TRUE as a value of 1. Syntax AVERAGEA(value1, [value2], ...) The AVERAGEA function has the following arguments: Argument Description value1/2/n Up to 255 values for which you want to find the average value. Notes How to apply the AVERAGEA function. Examples The figure below displays the result returned by the AVERAGEA function."
    },
   {
        "id": "Functions/averageif.htm", 
        "title": "AVERAGEIF Function", 
        "body": "The AVERAGEIF function is one of the statistical functions. It is used to analyze the range of data and find the average value of all numbers in a range of cells, based on the specified criterion. Syntax AVERAGEIF(range, criteria, [average_range]) The AVERAGEIF function has the following arguments: Argument Description range The selected range of cells to apply the criterion to. criteria The criterion you wish to apply, a value entered manually or included into the cell you make reference to. average_range The selected range of cells you need to find the average in. Notes average_range is an optional argument. If it is omitted, the function will find the average in range. How to apply the AVERAGEIF function. Examples The figure below displays the result returned by the AVERAGEIF function."
    },
   {
        "id": "Functions/averageifs.htm", 
        "title": "AVERAGEIFS Function", 
        "body": "The AVERAGEIFS function is one of the statistical functions. It is used to analyze the range of data and find the average value of all numbers in a range of cells, based on multiple criteria. Syntax AVERAGEIFS(average_range, criteria_range1, criteria1, [criteria_range2, criteria2], ...) The AVERAGEIFS function has the following arguments: Argument Description average_range The selected range of cells you need to find the average in. It is a required argument. criteria_range1 The first selected range of cells to apply the criteria1 to. It is a required argument. criteria1 The first condition that must be met. It is applied to the criteria_range1 and used to determine the cells in the average_range to average. It can be a value entered manually or included into the cell you make reference to. It is a required argument. criteria_range2, criteria2, ... Additional ranges of cells and their corresponding criteria. These arguments are optional. You can add up to 127 ranges and corresponding criteria. Notes You can use wildcard characters when specifying criteria. The question mark \"?\" can replace any single character and the asterisk \"*\" can be used instead of any number of characters. How to apply the AVERAGEIFS function. Examples The figure below displays the result returned by the AVERAGEIFS function."
    },
   {
        "id": "Functions/base.htm", 
        "title": "BASE Function", 
        "body": "The BASE function is one of the math and trigonometry functions. It is used to convert a number into a text representation with the given base. Syntax BASE(number, radix, [min_length]) The BASE function has the following arguments: Argument Description number A number you want to convert. An integer greater than or equal to 0 and less than 2^53. radix A base you want to convert the number to. An integer greater than or equal to 2 and less than or equal to 36. min_length A minimum length of the returned string. An integer greater than or equal to 0 and less than 256. It is an optional parameter. If the result is shorter than the minimum lenght specified, leading zeros are added to the string. Notes How to apply the BASE function. Examples The figure below displays the result returned by the BASE function."
    },
   {
        "id": "Functions/besseli.htm", 
        "title": "BESSELI Function", 
        "body": "The BESSELI function is one of the engineering functions. It is used to return the modified Bessel function, which is equivalent to the Bessel function evaluated for purely imaginary arguments. Syntax BESSELI(x, n) The BESSELI function has the following arguments: Argument Description x The value at which to evaluate the function. n The order of the Bessel function, a numeric value greater than or equal to 0. Notes How to apply the BESSELI function. Examples The figure below displays the result returned by the BESSELI function."
    },
   {
        "id": "Functions/besselj.htm", 
        "title": "BESSELJ Function", 
        "body": "The BESSELJ function is one of the engineering functions. It is used to return the Bessel function. Syntax BESSELJ(x, n) The BESSELJ function has the following arguments: Argument Description x The value at which to evaluate the function. n The order of the Bessel function, a numeric value greater than or equal to 0. Notes How to apply the BESSELJ function. Examples The figure below displays the result returned by the BESSELJ function."
    },
   {
        "id": "Functions/besselk.htm", 
        "title": "BESSELK Function", 
        "body": "The BESSELK function is one of the engineering functions. It is used to return the modified Bessel function, which is equivalent to the Bessel functions evaluated for purely imaginary arguments. Syntax BESSELK(x, n) The BESSELK function has the following arguments: Argument Description x The value at which to evaluate the function, a numeric value greater than 0. n The order of the Bessel function, a numeric value greater than or equal to 0. Notes How to apply the BESSELK function. Examples The figure below displays the result returned by the BESSELK function."
    },
   {
        "id": "Functions/bessely.htm", 
        "title": "BESSELY Function", 
        "body": "The BESSELY function is one of the engineering functions. It is used to return the Bessel function, which is also called the Weber function or the Neumann function. Syntax BESSELY(x, n) The BESSELY function has the following arguments: Argument Description x The value at which to evaluate the function, a numeric value greater than 0. n The order of the Bessel function, a numeric value greater than or equal to 0. Notes How to apply the BESSELY function. Examples The figure below displays the result returned by the BESSELY function."
    },
   {
        "id": "Functions/beta-dist.htm", 
        "title": "BETA.DIST Function", 
        "body": "The BETA.DIST function is one of the statistical functions. It is used to return the beta distribution. Syntax BETA.DIST(x, alpha, beta, cumulative, [A], [B]) The BETA.DIST function has the following arguments: Argument Description x The value between A and B at which the function should be calculated. alpha The first parameter of the distribution, a numeric value greater than 0. beta The second parameter of the distribution, a numeric value greater than 0. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability density function. A The lower bound to the interval of x. It is an optional parameter. If it is omitted, the default value of 0 is used. B The upper bound to the interval of x. It is an optional parameter. If it is omitted, the default value of 1 is used. Notes How to apply the BETA.DIST function. Examples The figure below displays the result returned by the BETA.DIST function."
    },
   {
        "id": "Functions/beta-inv.htm", 
        "title": "BETA.INV Function", 
        "body": "The BETA.INV function is one of the statistical functions. It is used to return the inverse of the beta cumulative probability density function (BETA.DIST). Syntax BETA.INV(probability, alpha, beta, [A], [B]) The BETA.INV function has the following arguments: Argument Description probability A probability associated with the beta distribution. A numeric value greater than 0 and less than or equal to 1. alpha The first parameter of the distribution, a numeric value greater than 0. beta The second parameter of the distribution, a numeric value greater than 0. A The lower bound to the interval of probability. It is an optional parameter. If it is omitted, the default value of 0 is used. B The upper bound to the interval of probability. It is an optional parameter. If it is omitted, the default value of 1 is used. Notes How to apply the BETA.INV function. Examples The figure below displays the result returned by the BETA.INV function."
    },
   {
        "id": "Functions/betadist.htm", 
        "title": "BETADIST Function", 
        "body": "The BETADIST function is one of the statistical functions. It is used to return the cumulative beta probability density function. Syntax BETADIST(x, alpha, beta, [A], [B]) The BETADIST function has the following arguments: Argument Description x The value between A and B at which the function should be calculated. alpha The first parameter of the distribution, a numeric value greater than 0. beta The second parameter of the distribution, a numeric value greater than 0. A The lower bound to the interval of x. It is an optional parameter. If it is omitted, the default value of 0 is used. B The upper bound to the interval of x. It is an optional parameter. If it is omitted, the default value of 1 is used. Notes How to apply the BETADIST function. Examples The figure below displays the result returned by the BETADIST function."
    },
   {
        "id": "Functions/betainv.htm", 
        "title": "BETAINV Function", 
        "body": "The BETAINV function is one of the statistical functions. It is used to return the inverse of the cumulative beta probability density function for a specified beta distribution. Syntax BETAINV(probability, alpha, beta, [A], [B]) The BETAINV function has the following arguments: Argument Description probability A probability associated with the beta distribution. A numeric value greater than 0 and less than or equal to 1. alpha The first parameter of the distribution, a numeric value greater than 0. beta The second parameter of the distribution, a numeric value greater than 0. A The lower bound to the interval of probability. It is an optional parameter. If it is omitted, the default value of 0 is used. B The upper bound to the interval of probability. It is an optional parameter. If it is omitted, the default value of 1 is used. Notes How to apply the BETAINV function. Examples The figure below displays the result returned by the BETAINV function."
    },
   {
        "id": "Functions/bin2dec.htm", 
        "title": "BIN2DEC Function", 
        "body": "The BIN2DEC function is one of the engineering functions. It is used to convert a binary number into a decimal number. Syntax BIN2DEC(number) The BIN2DEC function has the following argument: Argument Description number A binary number entered manually or included into the cell you make reference to. Notes If the argument is not recognised as a binary number, or contains more than 10 characters, the function will return the #NUM! error. How to apply the BIN2DEC function. Examples The figure below displays the result returned by the BIN2DEC function."
    },
   {
        "id": "Functions/bin2hex.htm", 
        "title": "BIN2HEX Function", 
        "body": "The BIN2HEX function is one of the engineering functions. It is used to convert a binary number into a hexadecimal number. Syntax BIN2HEX(number, [places]) The BIN2HEX function has the following arguments: Argument Description number A binary number entered manually or included into the cell you make reference to. places The number of digits to display. If omitted, the function will use the minimum number. Notes If the argument is not recognised as a binary number, or contains more than 10 characters, or the resulting hexadecimal number requires more digits than you specified, or the specified places number is less than or equal to 0, the function will return the #NUM! error. How to apply the BIN2HEX function. Examples The figure below displays the result returned by the BIN2HEX function."
    },
   {
        "id": "Functions/bin2oct.htm", 
        "title": "BIN2OCT Function", 
        "body": "The BIN2OCT function is one of the engineering functions. It is used to convert a binary number into an octal number. Syntax BIN2OCT(number, [places]) The BIN2OCT function has the following arguments: Argument Description number A binary number entered manually or included into the cell you make reference to. places The number of digits to display. If omitted, the function will use the minimum number. Notes If the argument is not recognised as a binary number, or contains more than 10 characters, or the resulting octal number requires more digits than you specified, or the specified places number is less than or equal to 0, the function will return the #NUM! error. How to apply the BIN2OCT function. Examples The figure below displays the result returned by the BIN2OCT function."
    },
   {
        "id": "Functions/binom-dist-range.htm", 
        "title": "BINOM.DIST.RANGE Function", 
        "body": "The BINOM.DIST.RANGE function is one of the statistical functions. It is used to return the probability of a trial result using a binomial distribution. Syntax BINOM.DIST.RANGE(trials, probability_s, number_s, [number_s2]) The BINOM.DIST.RANGE function has the following arguments: Argument Description trials The number of trials, a numeric value greater than or equal to number_s. probability The success probability of each trial, a numeric value greater than or equal to 0 but less than or equal to 1. number_s The minimum number of successes in the trials you want to calculate probability for, a numeric value greater than or equal to 0. number_s2 An optional argument. The maximum number of successes in the trials you want to calculate probability for, a numeric value greater than number_s and less than or equal to trials. Notes How to apply the BINOM.DIST.RANGE function. Examples The figure below displays the result returned by the BINOM.DIST.RANGE function."
    },
   {
        "id": "Functions/binom-dist.htm", 
        "title": "BINOM.DIST Function", 
        "body": "The BINOM.DIST function is one of the statistical functions. It is used to return the individual term binomial distribution probability. Syntax BINOM.DIST(number_s, trials, probability_s, cumulative) The BINOM.DIST function has the following arguments: Argument Description number_s The number of successes in the trials, a numeric value greater than or equal to 0. trials The number of trials, a numeric value greater than or equal to number_s. probability_s The success probability of each trial, a numeric value greater than or equal to 0 but less than or equal to 1. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability mass function. Notes How to apply the BINOM.DIST function. Examples The figure below displays the result returned by the BINOM.DIST function."
    },
   {
        "id": "Functions/binom-inv.htm", 
        "title": "BINOM.INV Function", 
        "body": "The BINOM.INV function is one of the statistical functions. It is used to return the smallest value for which the cumulative binomial distribution is greater than or equal to a criterion value. Syntax BINOM.INV(trials, probability_s, alpha) The BINOM.INV function has the following arguments: Argument Description trials The number of trials, a numeric value greater than 0. probability_s The success probability of each trial, a numeric value greater than 0 but less than 1. alpha The criterion, a numeric value greater than 0 but less than 1. Notes How to apply the BINOM.INV function. Examples The figure below displays the result returned by the BINOM.INV function."
    },
   {
        "id": "Functions/binomdist.htm", 
        "title": "BINOMDIST Function", 
        "body": "The BINOMDIST function is one of the statistical functions. It is used to return the individual term binomial distribution probability. Syntax BINOMDIST(number_s, trials, probability_s, cumulative) The BINOMDIST function has the following arguments: Argument Description number_s The number of successes in the trials, a numeric value greater than or equal to 0. trials The number of trials, a numeric value greater than or equal to number_s. probability_s The success probability of each trial, a numeric value greater than or equal to 0 but less than or equal to 1. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability mass function. Notes How to apply the BINOMDIST function. Examples The figure below displays the result returned by the BINOMDIST function."
    },
   {
        "id": "Functions/bitand.htm", 
        "title": "BITAND Function", 
        "body": "The BITAND function is one of the engineering functions. It is used to return a bitwise 'AND' of two numbers. Syntax BITAND(number1, number2) The BITAND function has the following arguments: Argument Description number1 A numeric value in decimal form greater than or equal to 0. number2 A numeric value in decimal form greater than or equal to 0. Notes The value of each bit position is counted only if both parameter's bits at that position are 1. How to apply the BITAND function. Examples The figure below displays the result returned by the BITAND function."
    },
   {
        "id": "Functions/bitlshift.htm", 
        "title": "BITLSHIFT Function", 
        "body": "The BITLSHIFT function is one of the engineering functions. It is used to return a number shifted left by the specified number of bits. Syntax BITLSHIFT(number, shift_amount) The BITLSHIFT function has the following arguments: Argument Description number An integer greater than or equal to 0. shift_amount A number of bits by which you want to shift number, an integer. Notes Shifting a number left is equivalent to adding zeros (0) to the right of the binary representation of the number. How to apply the BITLSHIFT function. Examples The figure below displays the result returned by the BITLSHIFT function."
    },
   {
        "id": "Functions/bitor.htm", 
        "title": "BITOR Function", 
        "body": "The BITOR function is one of the engineering functions. It is used to return a bitwise 'OR' of two numbers. Syntax BITOR(number1, number2) The BITOR function has the following arguments: Argument Description number1 A numeric value in decimal form greater than or equal to 0. number2 A numeric value in decimal form greater than or equal to 0. Notes The value of each bit position is counted if either of the parameters has 1 at that position. How to apply the BITOR function. Examples The figure below displays the result returned by the BITOR function."
    },
   {
        "id": "Functions/bitrshift.htm", 
        "title": "BITRSHIFT Function", 
        "body": "The BITRSHIFT function is one of the engineering functions. It is used to return a number shifted right by the specified number of bits. Syntax BITRSHIFT(number, shift_amount) The BITRSHIFT function has the following arguments: Argument Description number An integer greater than or equal to 0. shift_amount A number of bits by which you want to shift number, an integer. Notes Shifting a number right is equivalent to removing digits from the rightmost side of the binary representation of the number. How to apply the BITRSHIFT function. Examples The figure below displays the result returned by the BITRSHIFT function."
    },
   {
        "id": "Functions/bitxor.htm", 
        "title": "BITXOR Function", 
        "body": "The BITXOR function is one of the engineering functions. It is used to return a bitwise 'XOR' of two numbers. Syntax BITXOR(number1, number2) The BITXOR function has the following arguments: Argument Description number1 A numeric value in decimal form greater than or equal to 0. number2 A numeric value in decimal form greater than or equal to 0. Notes The value of each bit position is 1 when the bit positions of the parameters are different. How to apply the BITXOR function. Examples The figure below displays the result returned by the BITXOR function."
    },
   {
        "id": "Functions/ceiling-math.htm", 
        "title": "CEILING.MATH Function", 
        "body": "The CEILING.MATH function is one of the math and trigonometry functions. It is used to round a number up to the nearest integer or to the nearest multiple of significance. Syntax CEILING.MATH(number, [significance], [mode]) The CEILING.MATH function has the following arguments: Argument Description number The number you wish to round up. significance The multiple of significance you wish to round up to. It is an optional parameter. If it is omitted, the default value of 1 is used. mode Specifies if negative numbers are rounded towards or away from zero. It is an optional parameter that does not affect positive numbers. If it is omitted or set to 0, negative numbers are rounded towards zero. If any other numeric value is specified, negative numbers are rounded away from zero. Notes How to apply the CEILING.MATH function. Examples The figure below displays the result returned by the CEILING.MATH function."
    },
   {
        "id": "Functions/ceiling-precise.htm", 
        "title": "CEILING.PRECISE Function", 
        "body": "The CEILING.PRECISE function is one of the math and trigonometry functions. It is used to return a number that is rounded up to the nearest integer or to the nearest multiple of significance. The number is always rounded up regardless of its sing. Syntax CEILING.PRECISE(number, [significance]) The CEILING.PRECISE function has the following arguments: Argument Description number The number you wish to round up. significance The multiple of significance you wish to round up to. It is an optional parameter. If it is omitted, the default value of 1 is used. If it is set to zero, the function returns 0. Notes How to apply the CEILING.PRECISE function. Examples The figure below displays the result returned by the CEILING.PRECISE function."
    },
   {
        "id": "Functions/ceiling.htm", 
        "title": "CEILING Function", 
        "body": "The CEILING function is one of the math and trigonometry functions. It is used to round the number up to the nearest multiple of significance. Syntax CEILING(number, significance) The CEILING function has the following arguments: Argument Description number The number you wish to round up. significance The multiple of significance you wish to round up to. Notes If the values of number and significance have different signs, the function returns the #NUM! error. How to apply the CEILING function. Examples The figure below displays the result returned by the CEILING function."
    },
   {
        "id": "Functions/cell.htm", 
        "title": "CELL Function", 
        "body": "The CELL function is one of the information functions. It is used to return information about the formatting, location, or contents of a cell. Syntax CELL(info_type, [reference]) The CELL function has the following arguments: Argument Description info_type A text value that specifies which information about the cell you want to get. This is the required argument. The available values are listed in the table below. reference A cell that you want to get information about. If it is omitted, the information is returned for the last changed cell. If the reference argument is specified as a range of cells, the function returns the information for the upper-left cell of the range. The info_type argument can be one of the following: Text value Type of information \"address\" Returns the reference to the cell. \"col\" Returns the column number where the cell is located. \"color\" Returns 1 if the cell is formatted in color for negative values; otherwise returns 0. \"contents\" Returns the value that the cell contains. \"filename\" Returns the filename of the file that contains the cell. \"format\" Returns a text value corresponding to the number format of the cell. The text values are listed in the table below. \"parentheses\" Returns 1 if the cell is formatted with parentheses for positive or all values; otherwise returns 0. \"prefix\" Returns the single quotation mark (') if the text in the cell is left-aligned, the double quotation mark (\") if the text is right-aligned, the caret (^) if the text is centered, and an empty text (\"\") if the cell contains anything else. \"protect\" Returns 0 if the cell is not locked; returns 1 if the cell is locked. \"row\" Returns the row number where the cell is located. \"type\" Returns \"b\" for an empty cell, \"l\" for a text value, and \"v\" for any other value in the cell. \"width\" Returns the width of the cell, rounded off to an integer. Below you can see the text values which the function returns for the \"format\" argument Number format Returned text value General G 0 F0 #,##0 ,0 0.00 F2 #,##0.00 ,2 $#,##0_);($#,##0) C0 $#,##0_);[Red]($#,##0) C0- $#,##0.00_);($#,##0.00) C2 $#,##0.00_);[Red]($#,##0.00) C2- 0% P0 0.00% P2 0.00E+00 S2 # ?/? or # ??/?? G m/d/yy or m/d/yy h:mm or mm/dd/yy D4 d-mmm-yy or dd-mmm-yy D1 d-mmm or dd-mmm D2 mmm-yy D3 mm/dd D5 h:mm AM/PM D7 h:mm:ss AM/PM D6 h:mm D9 h:mm:ss D8 Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the CELL function. Examples The figure below displays the result returned by the CELL function."
    },
   {
        "id": "Functions/char.htm", 
        "title": "CHAR Function", 
        "body": "The CHAR function is one of the text and data functions. Is used to return the ASCII character specified by a number. Syntax CHAR(number) The CHAR function has the following argument: Argument Description number A number between 1 and 255 specifying a character from the computer character set. Notes How to apply the CHAR function. Examples The figure below displays the result returned by the CHAR function."
    },
   {
        "id": "Functions/chidist.htm", 
        "title": "CHIDIST Function", 
        "body": "The CHIDIST function is one of the statistical functions. It is used to return the right-tailed probability of the chi-squared distribution. Syntax CHIDIST(x, deg_freedom) The CHIDIST function has the following arguments: Argument Description x The value at which you want to evaluate the chi-squared distribution. A numeric value greater than or equal to 0. deg_freedom The number of degrees of freedom. A numeric value greater than or equal to 1 but less than or equal to 10^10. Notes How to apply the CHIDIST function. Examples The figure below displays the result returned by the CHIDIST function."
    },
   {
        "id": "Functions/chiinv.htm", 
        "title": "CHIINV Function", 
        "body": "The CHIINV function is one of the statistical functions. It is used to return the inverse of the right-tailed probability of the chi-squared distribution. Syntax CHIINV(probability, deg_freedom) The CHIINV function has the following arguments: Argument Description probability The probability associated with the chi-squared distribution. A numeric value greater than 0 and less than 1. deg_freedom The number of degrees of freedom. A numeric value greater than or equal to 1 but less than or equal to 10^10. Notes How to apply the CHIINV function. Examples The figure below displays the result returned by the CHIINV function."
    },
   {
        "id": "Functions/chisq-dist-rt.htm", 
        "title": "CHISQ.DIST.RT Function", 
        "body": "The CHISQ.DIST.RT function is one of the statistical functions. It is used to return the right-tailed probability of the chi-squared distribution. Syntax CHISQ.DIST.RT(x, deg_freedom) The CHISQ.DIST.RT function has the following arguments: Argument Description x The value at which you want to evaluate the chi-squared distribution. A numeric value greater than or equal to 0. deg_freedom The number of degrees of freedom. A numeric value greater than or equal to 1 but less than or equal to 10^10. Notes How to apply the CHISQ.DIST.RT function. Examples The figure below displays the result returned by the CHISQ.DIST.RT function."
    },
   {
        "id": "Functions/chisq-dist.htm", 
        "title": "CHISQ.DIST Function", 
        "body": "The CHISQ.DIST function is one of the statistical functions. It is used to return the chi-squared distribution. Syntax CHISQ.DIST(x, deg_freedom, cumulative) The CHISQ.DIST function has the following arguments: Argument Description x The value at which you want to evaluate the chi-squared distribution. A numeric value greater than or equal to 0. deg_freedom The number of degrees of freedom. A numeric value greater than or equal to 1 but less than or equal to 10^10. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability density function. Notes How to apply the CHISQ.DIST function. Examples The figure below displays the result returned by the CHISQ.DIST function."
    },
   {
        "id": "Functions/chisq-inv-rt.htm", 
        "title": "CHISQ.INV.RT Function", 
        "body": "The CHISQ.INV.RT function is one of the statistical functions. It is used to return the inverse of the right-tailed probability of the chi-squared distribution. Syntax CHISQ.INV.RT(probability, deg_freedom) The CHISQ.INV.RT function has the following arguments: Argument Description probability The probability associated with the chi-squared distribution. A numeric value greater than 0 and less than 1. deg_freedom The number of degrees of freedom. A numeric value greater than or equal to 1 but less than or equal to 10^10. Notes How to apply the CHISQ.INV.RT function. Examples The figure below displays the result returned by the CHISQ.INV.RT function."
    },
   {
        "id": "Functions/chisq-inv.htm", 
        "title": "CHISQ.INV Function", 
        "body": "The CHISQ.INV function is one of the statistical functions. It is used to return the inverse of the left-tailed probability of the chi-squared distribution. Syntax CHISQ.INV(probability, deg_freedom) The CHISQ.INV function has the following arguments: Argument Description probability The probability associated with the chi-squared distribution. A numeric value greater than 0 and less than 1. deg_freedom The number of degrees of freedom. A numeric value greater than or equal to 1 but less than or equal to 10^10. Notes How to apply the CHISQ.INV function. Examples The figure below displays the result returned by the CHISQ.INV function."
    },
   {
        "id": "Functions/chisq-test.htm", 
        "title": "CHISQ.TEST Function", 
        "body": "The CHISQ.TEST function is one of the statistical functions. It is used to return the test for independence, the value from the chi-squared (χ2) distribution for the statistic and the appropriate degrees of freedom. Syntax CHISQ.TEST(actual_range, expected_range) The CHISQ.TEST function has the following arguments: Argument Description actual_range The range of observed (actual) values. expected_range The range of expected values. Notes The ranges must contain the same number of values. Each of the expected values should be greater than or equal to 5. How to apply the CHISQ.TEST function. Examples The figure below displays the result returned by the CHISQ.TEST function."
    },
   {
        "id": "Functions/chitest.htm", 
        "title": "CHITEST Function", 
        "body": "The CHITEST function is one of the statistical functions. It is used to return the test for independence, the value from the chi-squared (χ2) distribution for the statistic and the appropriate degrees of freedom. Syntax CHITEST(actual_range, expected_range) The CHITEST function has the following arguments: Argument Description actual_range The range of observed (actual) values. expected_range The range of expected values. Notes The ranges must contain the same number of values. Each of the expected values should be greater than or equal to 5. How to apply the CHITEST function. Examples The figure below displays the result returned by the CHITEST function."
    },
   {
        "id": "Functions/choose.htm", 
        "title": "CHOOSE Function", 
        "body": "The CHOOSE function is one of the lookup and reference functions. It is used to return a value from a list of values based on a specified index (position). Syntax CHOOSE(index_num, value1, [value2], ...) The CHOOSE function has the following arguments: Argument Description index_num The position of the value in the list of values, a numeric value greater than or equal to 1 but less than the number of the number of values in the list of values. value1/2/n The list of values or the selected range of cells you need to analyze. Notes How to apply the CHOOSE function. Examples The figure below displays the result returned by the CHOOSE function."
    },
   {
        "id": "Functions/choosecols.htm", 
        "title": "CHOOSECOLS Function", 
        "body": "The CHOOSECOLS function is one of the lookup and reference functions. It is used to return columns from an array or reference. Syntax CHOOSECOLS(array, col_num1, [col_num2], …) The CHOOSECOLS function has the following arguments: Argument Description array Is used to set the array containing the columns to be returned in a new array. col_num1 Is used to set the first column number to be returned. col_num2 Is an optional argument. It is used to set additional column numbers to be returned. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the CHOOSECOLS function. Examples The figure below displays the result returned by the CHOOSECOLS function."
    },
   {
        "id": "Functions/chooserows.htm", 
        "title": "CHOOSEROWS Function", 
        "body": "The CHOOSEROWS function is one of the lookup and reference functions. It is used to return rows from an array or reference. Syntax CHOOSEROWS(array, row_num1, [row_num2], …) The CHOOSEROWS function has the following arguments: Argument Description array Is used to set the array containing the rows to be returned in a new array. row_num1 Is used to set the first row number to be returned. row_num2 Is an optional argument. It is used to set additional row numbers to be returned. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the CHOOSEROWS function. Examples The figure below displays the result returned by the CHOOSEROWS function."
    },
   {
        "id": "Functions/clean.htm", 
        "title": "CLEAN Function", 
        "body": "The CLEAN function is one of the text and data functions. Is used to remove all the nonprintable characters from the selected string. Syntax CLEAN(text) The CLEAN function has the following argument: Argument Description text A string with nonprintable characters you need to remove, data included into the cell you make reference to. Notes How to apply the CLEAN function. Examples The figure below displays the result returned by the CLEAN function."
    },
   {
        "id": "Functions/code.htm", 
        "title": "CODE Function", 
        "body": "The CODE function is one of the text and data functions. Is used to return the ASCII value of the specified character or the first character in a cell. Syntax CODE(text) The CODE function has the following argument: Argument Description text The text for which you want to get the code of the first character. Notes The CODE function is case-sensitive. How to apply the CODE function. Examples The figure below displays the result returned by the CODE function."
    },
   {
        "id": "Functions/column.htm", 
        "title": "COLUMN Function", 
        "body": "The COLUMN function is one of the lookup and reference functions. It is used to return the column number of a cell. Syntax COLUMN([reference]) The COLUMN function has the following argument: Argument Description reference A reference to a cell. Notes reference is an optional argument. If it is omitted, the function will return the column number of a cell selected to display the COLUMN function result. Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the COLUMN function. Examples The figure below displays the result returned by the COLUMN function."
    },
   {
        "id": "Functions/columns.htm", 
        "title": "COLUMNS Function", 
        "body": "The COLUMNS function is one of the lookup and reference functions. It is used to return the number of columns in a cell reference. Syntax COLUMNS(array) The COLUMNS function has the following argument: Argument Description array A reference to a range of cells. Notes How to apply the COLUMNS function. Examples The figure below displays the result returned by the COLUMNS function."
    },
   {
        "id": "Functions/combin.htm", 
        "title": "COMBIN Function", 
        "body": "The COMBIN function is one of the math and trigonometry functions. It is used to return the number of combinations for a specified number of items. Syntax COMBIN(number, number_chosen) The COMBIN function has the following arguments: Argument Description number A number of items, a numeric value greater than or equal to 0. number_chosen A number of items in a combination, a numeric value greater than or equal to 0 but less than number. Notes How to apply the COMBIN function. Examples The figure below displays the result returned by the COMBIN function."
    },
   {
        "id": "Functions/combina.htm", 
        "title": "COMBINA Function", 
        "body": "The COMBINA function is one of the math and trigonometry functions. It is used to return the number of combinations (with repetitions) for a given number of items. Syntax COMBINA(number, number_chosen) The COMBINA function has the following arguments: Argument Description number The total number of items, a numeric value greater than or equal to 0. number_chosen A number of items in a combination, a numeric value greater than or equal to 0 but less than number. Notes How to apply the COMBINA function. Examples The figure below displays the result returned by the COMBINA function."
    },
   {
        "id": "Functions/complex.htm", 
        "title": "COMPLEX Function", 
        "body": "The COMPLEX function is one of the engineering functions. It is used to convert a real part and an imaginary part into the complex number expressed in a + bi or a + bj form. Syntax COMPLEX(real_num, i_num, [suffix]) The COMPLEX function has the following arguments: Argument Description real_num The real part of the complex number. i_num The imaginary part of the complex number. suffix An indicator of the imaginary part of the complex number. It can be either \"i\" or \"j\" in lowercase. It is an optional argument. If it is omitted, the function will assume suffix to be \"i\". Notes How to apply the COMPLEX function. Examples The figure below displays the result returned by the COMPLEX function."
    },
   {
        "id": "Functions/concat.htm", 
        "title": "CONCAT Function", 
        "body": "The CONCAT function is one of the text and data functions. Is used to combine the data from two or more cells into a single one. This function replaces the CONCATENATE function. Syntax CONCAT(text1, [text2], ...) The CONCAT function has the following arguments: Argument Description text1/2/n Up to 255 data values that you want to combine. Notes How to apply the CONCAT function. Examples There are three arguments: text1 = A1 (John), text2 = \" \" (space), text3 = B1 (Adams). So the function will combine the first name, the space and the last name into one cell and return the result John Adams."
    },
   {
        "id": "Functions/concatenate.htm", 
        "title": "CONCATENATE Function", 
        "body": "The CONCATENATE function is one of the text and data functions. Is used to combine the data from two or more cells into a single one. Syntax CONCATENATE(text1, [text2], ...) The CONCATENATE function has the following arguments: Argument Description text1/2/n Up to 255 data values that you want to combine. Notes How to apply the CONCATENATE function. Examples There are three arguments: text1 = A1 (John), text2 = \" \" (space), text3 = B1 (Adams). So the function will combine the first name, the space and the last name into one cell and return the result John Adams."
    },
   {
        "id": "Functions/confidence-norm.htm", 
        "title": "CONFIDENCE.NORM Function", 
        "body": "The CONFIDENCE.NORM function is one of the statistical functions. It is used to return the confidence interval for a population mean, using a normal distribution. Syntax CONFIDENCE.NORM(alpha, standard_dev, size) The CONFIDENCE.NORM function has the following arguments: Argument Description alpha The significance level used to compute the confidence level, a numeric value greater than 0 but less than 1. standard_dev The population standard deviation, a numeric value greater than 0. size The sample size, a numeric value greater than or equal to 1. Notes How to apply the CONFIDENCE.NORM function. Examples The figure below displays the result returned by the CONFIDENCE.NORM function."
    },
   {
        "id": "Functions/confidence-t.htm", 
        "title": "CONFIDENCE.T Function", 
        "body": "The CONFIDENCE.T function is one of the statistical functions. It is used to return the confidence interval for a population mean, using a Student's t distribution. Syntax CONFIDENCE.T(alpha, standard_dev, size) The CONFIDENCE.T function has the following arguments: Argument Description alpha The significance level used to compute the confidence level, a numeric value greater than 0 but less than 1. standard_dev The population standard deviation, a numeric value greater than 0. size The sample size, a numeric value greater than or equal to 1. Notes How to apply the CONFIDENCE.T function. Examples The figure below displays the result returned by the CONFIDENCE.T function."
    },
   {
        "id": "Functions/confidence.htm", 
        "title": "CONFIDENCE Function", 
        "body": "The CONFIDENCE function is one of the statistical functions. It is used to return the confidence interval. Syntax CONFIDENCE(alpha, standard_dev, size) The CONFIDENCE function has the following arguments: Argument Description alpha The significance level used to compute the confidence level, a numeric value greater than 0 but less than 1. standard_dev The population standard deviation, a numeric value greater than 0. size The sample size, a numeric value greater than or equal to 1. Notes How to apply the CONFIDENCE function. Examples The figure below displays the result returned by the CONFIDENCE function."
    },
   {
        "id": "Functions/convert.htm", 
        "title": "CONVERT Function", 
        "body": "The CONVERT function is one of the engineering functions. It is used to convert a number from one measurement system to another. For example, CONVERT can translate a table of distances in miles to a table of distances in kilometers. Syntax CONVERT(number, from_unit, to_unit) The CONVERT function has the following arguments: Argument Description number The value to be converted. from_unit The original measurement unit. A text string enclosed in quotes. The possible values are listed in the table below. to_unit The measurement unit that the number should be converted to. A text string enclosed in quotes. The possible values are listed in the table below. Weight and mass Unit Text value Gram \"g\" Slug \"sg\" Pound mass (avoirdupois) \"lbm\" U (atomic mass unit) \"u\" Ounce mass (avoirdupois) \"ozm\" Grain \"grain\" U.S. (short) hundredweight \"cwt\" or \"shweight\" Imperial hundredweight \"uk_cwt\" or \"lcwt\" (\"hweight\") Stone \"stone\" Ton \"ton\" Imperial ton \"uk_ton\" or \"LTON\" (\"brton\") Distance Unit Text value Meter \"m\" Statute mile \"mi\" Nautical mile \"Nmi\" Inch \"in\" Foot \"ft\" Yard \"yd\" Angstrom \"ang\" Ell \"ell\" Light-year \"ly\" Parsec \"parsec\" or \"pc\" Pica (1/72 inch) \"Picapt\" or \"Pica\" Pica (1/6 inch) \"pica\" U.S survey mile (statute mile) \"survey_mi\" Time Unit Text value Year \"yr\" Day \"day\" or \"d\" Hour \"hr\" Minute \"mn\" or \"min\" Second \"sec\" or \"s\" Pressure Unit Text value Pascal \"Pa\" (or \"p\") Atmosphere \"atm\" (or \"at\") mm of Mercury \"mmHg\" PSI \"psi\" Torr \"Torr\" Force Unit Text value Newton \"N\" Dyne \"dyn\" (or \"dy\") Pound force \"lbf\" Pond \"pond\" Energy Unit Text value Joule \"J\" Erg \"e\" Thermodynamic calorie \"c\" IT calorie \"cal\" Electron volt \"eV\" (or \"ev\") Horsepower-hour \"HPh\" (or \"hh\") Watt-hour \"Wh\" (or \"wh\") Foot-pound \"flb\" BTU \"BTU\" (or \"btu\") Power Unit Text value Horsepower \"HP\" (or \"h\") Pferdestärke \"PS\" Watt \"W\" (or \"w\") Magnetism Unit Text value Tesla \"T\" Gauss \"ga\" Temperature Unit Text value Degree Celsius \"C\" (or \"cel\") Degree Fahrenheit \"F\" (or \"fah\") Kelvin \"K\" (or \"kel\") Degrees Rankine \"Rank\" Degrees Réaumur \"Reau\" Volume (or l iquid measure ) Unit Text value Teaspoon \"tsp\" Modern teaspoon \"tspm\" Tablespoon \"tbs\" Fluid ounce \"oz\" Cup \"cup\" U.S. pint \"pt\" (or \"us_pt\") U.K. pint \"uk_pt\" Quart \"qt\" Imperial quart (U.K.) \"uk_qt\" Gallon \"gal\" Imperial gallon (U.K.) \"uk_gal\" Liter \"l\" or \"L\" (\"lt\") Cubic angstrom \"ang3\" or \"ang^3\" U.S. oil barrel \"barrel\" U.S. bushel \"bushel\" Cubic feet \"ft3\" or \"ft^3\" Cubic inch \"in3\" or \"in^3\" Cubic light-year \"ly3\" or \"ly^3\" Cubic meter \"m3\" or \"m^3\" Cubic Mile \"mi3\" or \"mi^3\" Cubic yard \"yd3\" or \"yd^3\" Cubic nautical mile \"Nmi3\" or \"Nmi^3\" Cubic Pica \"Picapt3\", \"Picapt^3\", \"Pica3\" or \"Pica^3\" Gross Registered Ton \"GRT\" (\"regton\") Measurement ton (freight ton) \"MTON\" Area Unit Text value International acre \"uk_acre\" U.S. survey/statute acre \"us_acre\" Square angstrom \"ang2\" or \"ang^2\" Are \"ar\" Square feet \"ft2\" or \"ft^2\" Hectare \"ha\" Square inches \"in2\" or \"in^2\" Square light-year \"ly2\" or \"ly^2\" Square meters \"m2\" or \"m^2\" Morgen \"Morgen\" Square miles \"mi2\" or \"mi^2\" Square nautical miles \"Nmi2\" or \"Nmi^2\" Square Pica \"Picapt2\", \"Pica2\", \"Pica^2\" or \"Picapt^2\" Square yards \"yd2\" or \"yd^2\" Information Unit Text value Bit \"bit\" Byte \"byte\" Speed Unit Text value Admiralty knot \"admkn\" Knot \"kn\" Meters per hour \"m/h\" or \"m/hr\" Meters per second \"m/s\" or \"m/sec\" Miles per hour \"mph\" It's also possible to use prefixes with the from_unit and to_unit values, e.g. if you add the \"k\" prefix before the \"g\" unit, you'll get the \"kg\" value that denotes kilograms. Prefixes Prefix Multiplier Text value yotta 1E+24 \"Y\" zetta 1E+21 \"Z\" exa 1E+18 \"E\" peta 1E+15 \"P\" tera 1E+12 \"T\" giga 1E+09 \"G\" mega 1E+06 \"M\" kilo 1E+03 \"k\" hecto 1E+02 \"h\" dekao 1E+01 \"da\" or \"e\" deci 1E-01 \"d\" centi 1E-02 \"c\" milli 1E-03 \"m\" micro 1E-06 \"u\" nano 1E-09 \"n\" pico 1E-12 \"p\" femto 1E-15 \"f\" atto 1E-18 \"a\" zepto 1E-21 \"z\" yocto 1E-24 \"y\" Binary Prefixes Prefix Prefix value Text value yobi 2^80 = 1 208 925 819 614 629 174 706 176 \"Yi\" zebi 2^70 = 1 180 591 620 717 411 303 424 \"Zi\" exbi 2^60 = 1 152 921 504 606 846 976 \"Ei\" pebi 2^50 = 1 125 899 906 842 624 \"Pi\" tebi 2^40 = 1 099 511 627 776 \"Ti\" gibi 2^30 = 1 073 741 824 \"Gi\" mebi 2^20 = 1 048 576 \"Mi\" kibi 2^10 = 1024 \"ki\" Notes The from_unit and to_unit arguments must be compatible, i.e. they should belong to the same measurement type. How to apply the CONVERT function. Examples The figure below displays the result returned by the CONVERT function."
    },
   {
        "id": "Functions/correl.htm", 
        "title": "CORREL Function", 
        "body": "The CORREL function is one of the statistical functions. It is used to analyze the range of data and return the correlation coefficient of two range of cells. Syntax CORREL(array1, array2) The CORREL function has the following arguments: Argument Description array1/2 The selected ranges of cells with the same number of elements. Notes If array1/2 contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the CORREL function. Examples The figure below displays the result returned by the CORREL function."
    },
   {
        "id": "Functions/cos.htm", 
        "title": "COS Function", 
        "body": "The COS function is one of the math and trigonometry functions. It is used to return the cosine of an angle. Syntax COS(number) The COS function has the following argument: Argument Description number A numeric value for which you want to get the cosine. Notes How to apply the COS function. Examples The figure below displays the result returned by the COS function."
    },
   {
        "id": "Functions/cosh.htm", 
        "title": "COSH Function", 
        "body": "The COSH function is one of the math and trigonometry functions. It is used to return the hyperbolic cosine of a number. Syntax COSH(number) The COSH function has the following argument: Argument Description number A numeric value for which you want to get the hyperbolic cosine. Notes How to apply the COSH function. Examples The figure below displays the result returned by the COSH function."
    },
   {
        "id": "Functions/cot.htm", 
        "title": "COT Function", 
        "body": "The COT function is one of the math and trigonometry functions. It is used to return the cotangent of an angle specified in radians. Syntax COT(number) The COT function has the following argument: Argument Description number The angle in radians that you wish to calculate the cotangent of. A numeric value entered manually or included into the cell you make reference to. Its absolute value must be less than 2^27. Notes How to apply the COT function. Examples The figure below displays the result returned by the COT function."
    },
   {
        "id": "Functions/coth.htm", 
        "title": "COTH Function", 
        "body": "The COTH function is one of the math and trigonometry functions. It is used to return the hyperbolic cotangent of a hyperbolic angle. Syntax COTH(number) The COTH function has the following argument: Argument Description number The angle in radians that you wish to calculate the hyperbolic cotangent of. A numeric value entered manually or included into the cell you make reference to. Its absolute value must be less than 2^27. Notes How to apply the COTH function. Examples The figure below displays the result returned by the COTH function."
    },
   {
        "id": "Functions/count.htm", 
        "title": "COUNT Function", 
        "body": "The COUNT function is one of the statistical functions. It is used to count the number of the selected cells which contain numbers ignoring empty cells or those contaning text. Syntax COUNT(value1, [value2], ...) The COUNT function has the following arguments: Argument Description value1 The first value you wish to count. value2/n Additional values you wish to count. Notes How to apply the COUNT function. Examples The figure below displays the result returned by the COUNT function."
    },
   {
        "id": "Functions/counta.htm", 
        "title": "COUNTA Function", 
        "body": "The COUNTA function is one of the statistical functions. It is used to analyze the range of cells and count the number of cells that are not empty. Syntax COUNTA(value1, [value2], ...) The COUNTA function has the following arguments: Argument Description value1 The first value you wish to count. value2/n Additional values you wish to count. Notes How to apply the COUNTA function. Examples The figure below displays the result returned by the COUNTA function."
    },
   {
        "id": "Functions/countblank.htm", 
        "title": "COUNTBLANK Function", 
        "body": "The COUNTBLANK function is one of the statistical functions. It is used to analyze the range of cells and return the number of the empty cells. Syntax COUNTBLANK(range) The COUNTBLANK function has the following argument: Argument Description range A range of cells you wish to count. Notes How to apply the COUNTBLANK function. Examples The figure below displays the result returned by the COUNTBLANK function."
    },
   {
        "id": "Functions/countif.htm", 
        "title": "COUNTIF Function", 
        "body": "The COUNTIF function is one of the statistical functions. It is used to count the number of the selected cells based on the specified criterion. Syntax COUNTIF(range, criteria) The COUNTIF function has the following arguments: Argument Description range The selected range of cells you wish to count applying the specified criterion. criteria A criterion you wish to apply. Notes The criteria argument can include the wildcard characters — the question mark (?) that matches a single character and the asterisk (*) that matches multiple characters. If you want to find a question mark or asterisk, type a tilde (~) before the character. How to apply the COUNTIF function. Examples The figure below displays the result returned by the COUNTIF function."
    },
   {
        "id": "Functions/countifs.htm", 
        "title": "COUNTIFS Function", 
        "body": "The COUNTIFS function is one of the statistical functions. It is used to count the number of the selected cells based on multiple criteria. Syntax COUNTIFS(criteria_range1, criteria1, [criteria_range2, criteria2]...) The COUNTIFS function has the following arguments: Argument Description criteria_range1 The first selected range of cells to apply the criteria1 to. It is a required argument. criteria1 The first condition that must be met. It is applied to the criteria_range1 and used to determine the cells in the criteria_range1 to count. It can be a value entered manually or included into the cell you make reference to. It is a required argument. criteria_range2, criteria2 Additional ranges of cells and their corresponding criteria. These arguments are optional. You can add up to 127 ranges and corresponding criteria. Notes You can use wildcard characters when specifying criteria. The question mark \"?\" can replace any single character and the asterisk \"*\" can be used instead of any number of characters. If you want to find a question mark or asterisk, type a tilde (~) before the character. How to apply the COUNTIFS function. Examples The figure below displays the result returned by the COUNTIFS function."
    },
   {
        "id": "Functions/coupdaybs.htm", 
        "title": "COUPDAYBS Function", 
        "body": "The COUPDAYBS function is one of the financial functions. It is used to calculate the number of days from the beginning of the coupon period to the settlement date. Syntax COUPDAYBS(settlement, maturity, frequency, [basis]) The COUPDAYBS function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the COUPDAYBS function. Examples The figure below displays the result returned by the COUPDAYBS function."
    },
   {
        "id": "Functions/coupdays.htm", 
        "title": "COUPDAYS Function", 
        "body": "The COUPDAYS function is one of the financial functions. It is used to calculate the number of days in the coupon period that contains the settlement date. Syntax COUPDAYS(settlement, maturity, frequency, [basis]) The COUPDAYS function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the COUPDAYS function. Examples The figure below displays the result returned by the COUPDAYS function."
    },
   {
        "id": "Functions/coupdaysnc.htm", 
        "title": "COUPDAYSNC Function", 
        "body": "The COUPDAYSNC function is one of the financial functions. It is used to calculate the number of days from the settlement date to the next coupon payment. Syntax COUPDAYSNC(settlement, maturity, frequency, [basis]) The COUPDAYSNC function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the COUPDAYSNC function. Examples The figure below displays the result returned by the COUPDAYSNC function."
    },
   {
        "id": "Functions/coupncd.htm", 
        "title": "COUPNCD Function", 
        "body": "The COUPNCD function is one of the financial functions. It is used to calculate the next coupon date after the settlement date. Syntax COUPNCD(settlement, maturity, frequency, [basis]) The COUPNCD function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the COUPNCD function. Examples The figure below displays the result returned by the COUPNCD function."
    },
   {
        "id": "Functions/coupnum.htm", 
        "title": "COUPNUM Function", 
        "body": "The COUPNUM function is one of the financial functions. It is used to calculate the number of coupons between the settlement date and the maturity date. Syntax COUPNUM(settlement, maturity, frequency, [basis]) The COUPNUM function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the COUPNUM function. Examples The figure below displays the result returned by the COUPNUM function."
    },
   {
        "id": "Functions/couppcd.htm", 
        "title": "COUPPCD Function", 
        "body": "The COUPPCD function is one of the financial functions. It is used to calculate the previous coupon date before the settlement date. Syntax COUPPCD(settlement, maturity, frequency, [basis]) The COUPPCD function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the COUPPCD function. Examples The figure below displays the result returned by the COUPPCD function."
    },
   {
        "id": "Functions/covar.htm", 
        "title": "COVAR Function", 
        "body": "The COVAR function is one of the statistical functions. It is used to return the covariance of two ranges of data. Syntax COVAR(array1, array2) The COVAR function has the following argument: Argument Description array1(2) The selected ranges of cells with the same number of elements. Notes If array1(2) contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the COVAR function. Examples The figure below displays the result returned by the COVAR function."
    },
   {
        "id": "Functions/covariance-p.htm", 
        "title": "COVARIANCE.P Function", 
        "body": "The COVARIANCE.P function is one of the statistical functions. It is used to return population covariance, the average of the products of deviations for each data point pair in two data sets; use covariance to determine the relationship between two data sets. Syntax COVARIANCE.P(array1, array2) The COVARIANCE.P function has the following argument: Argument Description array1(2) The selected ranges of cells with the same number of elements. Notes If array1(2) contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the COVARIANCE.P function. Examples The figure below displays the result returned by the COVARIANCE.P function."
    },
   {
        "id": "Functions/covariance-s.htm", 
        "title": "COVARIANCE.S Function", 
        "body": "The COVARIANCE.S function is one of the statistical functions. It is used to return the sample covariance, the average of the products of deviations for each data point pair in two data sets. Syntax COVARIANCE.S(array1, array2) The COVARIANCE.S function has the following arguments: Argument Description array1(2) The selected ranges of cells with the same number of elements. Notes If array1(2) contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the COVARIANCE.S function. Examples The figure below displays the result returned by the COVARIANCE.S function."
    },
   {
        "id": "Functions/critbinom.htm", 
        "title": "CRITBINOM Function", 
        "body": "The CRITBINOM function is one of the statistical functions. It is used to return the smallest value for which the cumulative binomial distribution is greater than or equal to the specified alpha value. Syntax CRITBINOM(trials, probability_s, alpha) The CRITBINOM function has the following arguments: Argument Description trials The number of trials, a numeric value greater than or equal to 0. probability_s The success probability of each trial, a numeric value greater than or equal to 0 but less than or equal to 1. alpha The criterion, a numeric value greater than or equal to 0 but less than or equal to 1. Notes How to apply the CRITBINOM function. Examples The figure below displays the result returned by the CRITBINOM function."
    },
   {
        "id": "Functions/csc.htm", 
        "title": "CSC Function", 
        "body": "The CSC function is one of the math and trigonometry functions. It is used to return the cosecant of an angle specified in radians. Syntax CSC(number) The CSC function has the following argument: Argument Description number The angle in radians that you wish to calculate the cosecant of. A numeric value entered manually or included into the cell you make reference to. Its absolute value must be less than 2^27. Notes How to apply the CSC function. Examples The figure below displays the result returned by the CSC function."
    },
   {
        "id": "Functions/csch.htm", 
        "title": "CSCH Function", 
        "body": "The CSCH function is one of the math and trigonometry functions. It is used to return the hyperbolic cosecant of an angle specified in radians. Syntax CSCH(number) The CSCH function has the following argument: Argument Description number The angle in radians that you wish to calculate the hyperbolic cosecant of. A numeric value entered manually or included into the cell you make reference to. Its absolute value must be less than 2^27. Notes How to apply the CSCH function. Examples The figure below displays the result returned by the CSCH function."
    },
   {
        "id": "Functions/cumipmt.htm", 
        "title": "CUMIPMT Function", 
        "body": "The CUMIPMT function is one of the financial functions. It is used to calculate the cumulative interest paid on an investment between two periods based on a specified interest rate and a constant payment schedule. Syntax CUMIPMT(rate, nper, pv, start_period, end_period, type) The CUMIPMT function has the following arguments: Argument Description rate The interest rate for the investment. nper A number of payments. pv A present value of the payments. start_period The first period included into the calculation. The value must be from 1 to nper. end_period The last period included into the calculation. The value must be from 1 to nper. type A period when the payments are due. If it is set to 0 or omitted, the function will assume the payments to be due at the end of the period. If type is set to 1, the payments are due at the beginning of the period. Notes Cash paid out (such as deposits to savings) is represented by negative numbers; cash received (such as dividend checks) is represented by positive numbers. Units for rate and nper must be consistent: use N%/12 for rate and N*12 for nper in case of monthly payments, N%/4 for rate and N*4 for nper in case of quarterly payments, N% for rate and N for nper in case of annual payments. How to apply the CUMIPMT function. Examples The figure below displays the result returned by the CUMIPMT function."
    },
   {
        "id": "Functions/cumprinc.htm", 
        "title": "CUMPRINC Function", 
        "body": "The CUMPRINC function is one of the financial functions. It is used to calculate the cumulative principal paid on an investment between two periods based on a specified interest rate and a constant payment schedule. Syntax CUMPRINC(rate, nper, pv, start_period, end_period, type) The CUMPRINC function has the following arguments: Argument Description rate The interest rate for the investment. nper A number of payments. pv A present value of the payments. start_period The first period included into the calculation. The value must be from 1 to nper. end_period The last period included into the calculation. The value must be from 1 to nper. type A period when the payments are due. If it is set to 0 or omitted, the function will assume the payments to be due at the end of the period. If type is set to 1, the payments are due at the beginning of the period. Notes Cash paid out (such as deposits to savings) is represented by negative numbers; cash received (such as dividend checks) is represented by positive numbers. Units for rate and nper must be consistent: use N%/12 for rate and N*12 for nper in case of monthly payments, N%/4 for rate and N*4 for nper in case of quarterly payments, N% for rate and N for nper in case of annual payments. How to apply the CUMPRINC function. Examples The figure below displays the result returned by the CUMPRINC function."
    },
   {
        "id": "Functions/date.htm", 
        "title": "DATE Function", 
        "body": "The DATE function is one of the date and time functions. It is used to add dates in the default format MM/dd/yyyy. Syntax DATE(year, month, day) The DATE function has the following arguments: Argument Description year A numeric value representing the year (four digits). month A numeric value representing the month (from 1 to 12). day A numeric value representing the day (from 1 to 31). Notes How to apply the DATE function. Examples The figure below displays the result returned by the DATE function."
    },
   {
        "id": "Functions/datedif.htm", 
        "title": "DATEDIF Function", 
        "body": "The DATEDIF function is one of the date and time functions. It is used to return the difference between two date values (start date and end date), based on the interval (unit) specified. Syntax DATEDIF(start_date, end_date, unit) The DATEDIF function has the following arguments: Argument Description start_date The starting date of a period. end_date The ending date of a period. unit The specified interval. The possible values are listed in the table below. The unit argument can be one of the following: Unit Interval Explanation Y The number of complete years. M The number of complete months. D The number of days. MD The difference between the days (months and years are ignored). YM The difference between the months (days and years are ignored). YD The difference between the days (years are ignored). Notes If the start_date is greater than the end_date, the result will be #NUM!. How to apply the DATEDIF function. Examples There are three arguments: start-date = A1 = 3/16/2018; end-date = A2 = 9/16/2018; unit = \"D\". So the function returns the difference between two dates in days."
    },
   {
        "id": "Functions/datevalue.htm", 
        "title": "DATEVALUE Function", 
        "body": "The DATEVALUE function is one of the date and time functions. It is used to return a serial number of the specified date. Syntax DATEVALUE(date_text) The DATEVALUE function has the following argument: Argument Description date_text A date from January 1, 1900, to December 31, 9999. Notes How to apply the DATEVALUE function. Examples The figure below displays the result returned by the DATEVALUE function."
    },
   {
        "id": "Functions/daverage.htm", 
        "title": "DAVERAGE Function", 
        "body": "The DAVERAGE function is one of the database functions. It is used to average the values in a field (column) of records in a list or database that match conditions you specify. Syntax DAVERAGE(database, field, criteria) The DAVERAGE function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DAVERAGE function. Examples The figure below displays the result returned by the DAVERAGE function."
    },
   {
        "id": "Functions/day.htm", 
        "title": "DAY Function", 
        "body": "The DAY function is one of the date and time functions. It returns the day (a number from 1 to 31) of the date given in the numerical format (MM/dd/yyyy by default). Syntax DAY(serial_number) The DAY function has the following argument: Argument Description serial_number The date of the day you want to find. Notes How to apply the DAY function. Examples The figure below displays the result returned by the DAY function."
    },
   {
        "id": "Functions/days.htm", 
        "title": "DAYS Function", 
        "body": "The DAYS function is one of the date and time functions. Is used to return the number of days between two dates. Syntax DAYS(end_date, start_date) The DAYS function has the following arguments: Argument Description end_date end_date and start_date are two dates you wish to calculate the number of days between. start_date end_date and start_date are two dates you wish to calculate the number of days between. Notes How to apply the DAYS function. Examples The figure below displays the result returned by the DAYS function."
    },
   {
        "id": "Functions/days360.htm", 
        "title": "DAYS360 Function", 
        "body": "The DAYS360 function is one of the date and time functions. Is used to return the number of days between two dates (start-date and end-date) based on a 360-day year using one of the calculation method (US or European). Syntax DAYS360(start_date, end_date, [method]) The DAYS360 function has the following arguments: Argument Description start_date start_date and end_date are two dates you wish to calculate the number of days between. end_date start_date and end_date are two dates you wish to calculate the number of days between. method An optional logical value: TRUE or FALSE. If it is set to TRUE, the calculation will be performed using the European method, according to which the start and end dates that occur on the 31st of a month become equal to the 30th of the same month. If it is FALSE or omitted, the calculation will be performed using the US method, according to which if the start date is the last day of a month, it becomes equal to the 30th of the same month. If the end date is the last day of a month and the start date is earlier than the 30th of a month, the end date becomes equal to the 1st of the next month. Otherwise the end date becomes equal to the 30th of the same month. Notes How to apply the DAYS360 function. Examples The figure below displays the result returned by the DAYS360 function."
    },
   {
        "id": "Functions/db.htm", 
        "title": "DB Function", 
        "body": "The DB function is one of the financial functions. It is used to calculate the depreciation of an asset for a specified accounting period using the fixed-declining balance method. Syntax DB(cost, salvage, life, period, [month]) The DB function has the following arguments: Argument Description cost The cost of the asset. salvage The salvage value of the asset at the end of its lifetime. life The total number of the periods within the asset lifetime. period The period you wish to calculate depreciation for. The value must be expressed in the same units as life. month The number of months in the first year. It is an optional argument. If it is omitted, the function will assume month to be 12. Notes How to apply the DB function. Examples The figure below displays the result returned by the DB function."
    },
   {
        "id": "Functions/dcount.htm", 
        "title": "DCOUNT Function", 
        "body": "The DCOUNT function is one of the database functions. It is used to count the cells that contain numbers in a field (column) of records in a list or database that match conditions that you specify. Syntax DCOUNT(database, field, criteria) The DCOUNT function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DCOUNT function. Examples The figure below displays the result returned by the DCOUNT function."
    },
   {
        "id": "Functions/dcounta.htm", 
        "title": "DCOUNTA Function", 
        "body": "The DCOUNTA function is one of the database functions. It is used to count the nonblank cells (logical values and text are also counted) in a field (column) of records in a list or database that match conditions that you specify. Syntax DCOUNTA(database, field, criteria) The DCOUNTA function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DCOUNTA function. Examples The figure below displays the result returned by the DCOUNTA function."
    },
   {
        "id": "Functions/ddb.htm", 
        "title": "DDB Function", 
        "body": "The DDB function is one of the financial functions. It is used to calculate the depreciation of an asset for a specified accounting period using the double-declining balance method. Syntax DDB(cost, salvage, life, period, [factor]) The DDB function has the following arguments: Argument Description cost The cost of the asset. salvage The salvage value of the asset at the end of its lifetime. life The total number of the periods within the asset lifetime. period The period you wish to calculate depreciation for. The value must be expressed in the same units as life. factor The rate at which the balance declines. It is an optional argument. If it is omitted, the function will assume factor to be 2. Notes All the values must be positive numbers. How to apply the DDB function. Examples The figure below displays the result returned by the DDB function."
    },
   {
        "id": "Functions/dec2bin.htm", 
        "title": "DEC2BIN Function", 
        "body": "The DEC2BIN function is one of the engineering functions. It is used to convert a decimal number into a binary number. Syntax DEC2BIN(number, [places]) The DEC2BIN function has the following arguments: Argument Description number A decimal number entered manually or included into the cell you make reference to. places The number of digits to display. If omitted, the function will use the minimum number. Notes If the specified places number is less than or equal to 0, the function will return the #NUM! error. How to apply the DEC2BIN function. Examples The figure below displays the result returned by the DEC2BIN function."
    },
   {
        "id": "Functions/dec2hex.htm", 
        "title": "DEC2HEX Function", 
        "body": "The DEC2HEX function is one of the engineering functions. It is used to convert a decimal number into a hexadecimal number. Syntax DEC2HEX(number, [places]) The DEC2HEX function has the following arguments: Argument Description number A decimal number entered manually or included into the cell you make reference to. places The number of digits to display. If omitted, the function will use the minimum number. Notes If the specified places number is less than or equal to 0, the function will return the #NUM! error. How to apply the DEC2HEX function. Examples The figure below displays the result returned by the DEC2HEX function."
    },
   {
        "id": "Functions/dec2oct.htm", 
        "title": "DEC2OCT Function", 
        "body": "The DEC2OCT function is one of the engineering functions. It is used to convert a decimal number into an octal number. Syntax DEC2OCT(number, [places]) The DEC2OCT function has the following arguments: Argument Description number A decimal number entered manually or included into the cell you make reference to. places The number of digits to display. If omitted, the function will use the minimum number. Notes If the specified places number is less than or equal to 0, the function will return the #NUM! error. How to apply the DEC2OCT function. Examples The figure below displays the result returned by the DEC2OCT function."
    },
   {
        "id": "Functions/decimal.htm", 
        "title": "DECIMAL Function", 
        "body": "The DECIMAL function is one of the math and trigonometry functions. It is used to convert a text representation of a number in a given base into a decimal number. Syntax DECIMAL(text, radix) The DECIMAL function has the following arguments: Argument Description text The text representation of the number you want to convert. The string lenght must be less than or equal to 255 characters. radix The base of the number. An integer greater than or equal to 2 and less than or equal to 36. Notes How to apply the DECIMAL function. Examples The figure below displays the result returned by the DECIMAL function."
    },
   {
        "id": "Functions/degrees.htm", 
        "title": "DEGREES Function", 
        "body": "The DEGREES function is one of the math and trigonometry functions. It is used to convert radians into degrees. Syntax DEGREES(angle) The DEGREES function has the following argument: Argument Description angle A numeric value (radians) entered manually or included into the cell you make reference to. Notes How to apply the DEGREES function. Examples The figure below displays the result returned by the DEGREES function."
    },
   {
        "id": "Functions/delta.htm", 
        "title": "DELTA Function", 
        "body": "The DELTA function is one of the engineering functions. It is used to test if two numbers are equal. The function returns 1 if the numbers are equal and 0 otherwise. Syntax DELTA(number1, [number2]) The DELTA function has the following arguments: Argument Description number1 The first number. number2 The second number. It is an optional argument. If it is omitted, the function will assume number2 to be 0. Notes How to apply the DELTA function. Examples The figure below displays the result returned by the DELTA function."
    },
   {
        "id": "Functions/devsq.htm", 
        "title": "DEVSQ Function", 
        "body": "The DEVSQ function is one of the statistical functions. It is used to analyze the range of data and sum the squares of the deviations of numbers from their mean. Syntax DEVSQ(number1, [number2], ...) The DEVSQ function has the following arguments: Argument Description number1/2/n Up to 255 numerical values for which you want to find the sum of squares of deviations. Notes How to apply the DEVSQ function. Examples The figure below displays the result returned by the DEVSQ function."
    },
   {
        "id": "Functions/dget.htm", 
        "title": "DGET Function", 
        "body": "The DGET function is one of the database functions. It is used to extract a single value from a column of a list or database that matches conditions that you specify. Syntax DGET(database, field, criteria) The DGET function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DGET function. Examples The figure below displays the result returned by the DGET function."
    },
   {
        "id": "Functions/disc.htm", 
        "title": "DISC Function", 
        "body": "The DISC function is one of the financial functions. It is used to calculate the discount rate for a security. Syntax DISC(settlement, maturity, pr, redemption, [basis]) The DISC function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. pr The purchase price of the security, per $100 par value. redemption The redemption value of the security, per $100 par value. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the DISC function. Examples The figure below displays the result returned by the DISC function."
    },
   {
        "id": "Functions/dmax.htm", 
        "title": "DMAX Function", 
        "body": "The DMAX function is one of the database functions. It is used to return the largest number in a field (column) of records in a list or database that matches conditions that you specify. Syntax DMAX(database, field, criteria) The DMAX function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DMAX function. Examples The figure below displays the result returned by the DMAX function."
    },
   {
        "id": "Functions/dmin.htm", 
        "title": "DMIN Function", 
        "body": "The DMIN function is one of the database functions. It is used to return the smallest number in a field (column) of records in a list or database that matches conditions that you specify. Syntax DMIN(database, field, criteria) The DMIN function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DMIN function. Examples The figure below displays the result returned by the DMIN function."
    },
   {
        "id": "Functions/dollar.htm", 
        "title": "DOLLAR Function", 
        "body": "The DOLLAR function is one of the text and data functions. Is used to convert a number to text, using a currency format $#.##. Syntax DOLLAR(number, [decimals]) The DOLLAR function has the following arguments: Argument Description number Any number to convert. decimals A number of decimal places to display. If it is omitted, the function will assume it to be 2. Notes How to apply the DOLLAR function. Examples The figure below displays the result returned by the DOLLAR function."
    },
   {
        "id": "Functions/dollarde.htm", 
        "title": "DOLLARDE Function", 
        "body": "The DOLLARDE function is one of the financial functions. It is used to convert a dollar price represented as a fraction into a dollar price represented as a decimal number. Syntax DOLLARDE(fractional_dollar, fraction) The DOLLARDE function has the following arguments: Argument Description fractional_dollar An integer part and a fraction part separated by a decimal symbol. fraction An integer you wish to use as a denominator for the fraction part of the fractional_dollar value. Notes For example, the fractional_dollar value, expressed as 1.03, is interpreted as 1 + 3/n, where n is the fraction value. How to apply the DOLLARDE function. Examples The figure below displays the result returned by the DOLLARDE function."
    },
   {
        "id": "Functions/dollarfr.htm", 
        "title": "DOLLARFR Function", 
        "body": "The DOLLARFR function is one of the financial functions. It is used to convert a dollar price represented as a decimal number into a dollar price represented as a fraction. Syntax DOLLARFR(decimal_dollar, fraction) The DOLLARFR function has the following arguments: Argument Description decimal_dollar A decimal number. fraction An integer you wish to use as a denominator for a returned fraction. Notes For example, the returned value of 1.03 is interpreted as 1 + 3/n, where n is the fraction value. How to apply the DOLLARFR function. Examples The figure below displays the result returned by the DOLLARFR function."
    },
   {
        "id": "Functions/dproduct.htm", 
        "title": "DPRODUCT Function", 
        "body": "The DPRODUCT function is one of the database functions. It is used to multiply the values in a field (column) of records in a list or database that match conditions that you specify. Syntax DPRODUCT(database, field, criteria) The DPRODUCT function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DPRODUCT function. Examples The figure below displays the result returned by the DPRODUCT function."
    },
   {
        "id": "Functions/drop.htm", 
        "title": "DROP Function", 
        "body": "The DROP function is one of the lookup and reference functions. It is used to drop rows or columns from array start or end. Syntax DROP(array, rows, [columns]) The DROP function has the following arguments: Argument Description array Is used to set the array from which to drop rows or columns. rows Is used to set the number of rows to drop. A negative value drops from the end of the array. columns Is used to set the number of columns to drop. A negative value drops from the end of the array. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the DROP function. Examples The figure below displays the result returned by the DROP function."
    },
   {
        "id": "Functions/dstdev.htm", 
        "title": "DSTDEV Function", 
        "body": "The DSTDEV function is one of the database functions. It is used to estimate the standard deviation of a population based on a sample by using the numbers in a field (column) of records in a list or database that match conditions that you specify. Syntax DSTDEV(database, field, criteria) The DSTDEV function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DSTDEV function. Examples The figure below displays the result returned by the DSTDEV function."
    },
   {
        "id": "Functions/dstdevp.htm", 
        "title": "DSTDEVP Function", 
        "body": "The DSTDEVP function is one of the database functions. It is used to calculate the standard deviation of a population based on the entire population by using the numbers in a field (column) of records in a list or database that match conditions that you specify. Syntax DSTDEVP(database, field, criteria) The DSTDEVP function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DSTDEVP function. Examples The figure below displays the result returned by the DSTDEVP function."
    },
   {
        "id": "Functions/dsum.htm", 
        "title": "DSUM Function", 
        "body": "The DSUM function is one of the database functions. It is used to add the numbers in a field (column) of records in a list or database that match conditions that you specify. Syntax DSUM(database, field, criteria) The DSUM function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DSUM function. Examples The figure below displays the result returned by the DSUM function."
    },
   {
        "id": "Functions/duration.htm", 
        "title": "DURATION Function", 
        "body": "The DURATION function is one of the financial functions. It is used to calculate the Macaulay duration of a security with an assumed par value of $100. Syntax DURATION(settlement, maturity, coupon, yld, frequency, [basis]) The DURATION function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. coupon The annual coupon rate of the security. yld The annual yield of the security. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the DURATION function. Examples The figure below displays the result returned by the DURATION function."
    },
   {
        "id": "Functions/dvar.htm", 
        "title": "DVAR Function", 
        "body": "The DVAR function is one of the database functions. It is used to estimate the variance of a population based on a sample by using the numbers in a field (column) of records in a list or database that match conditions that you specify. Syntax DVAR(database, field, criteria) The DVAR function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DVAR function. Examples The figure below displays the result returned by the DVAR function."
    },
   {
        "id": "Functions/dvarp.htm", 
        "title": "DVARP Function", 
        "body": "The DVARP function is one of the database functions. It is used to calculate the variance of a population based on the entire population by using the numbers in a field (column) of records in a list or database that match conditions that you specify. Syntax DVARP(database, field, criteria) The DVARP function has the following arguments: Argument Description database The range of cells that make up a database. It must contain column headings in the first row. field An argument that specifies which field (i.e. column) should be used. It can be specified as a number of the necessary column, or the column heading enclosed in quotation marks. criteria The range of cells that contain conditions. It must contain at least one field name (column heading) and at least one cell below that specifies the condition to be applied to this field in the database. The criteria cell range should not overlap the database range. Notes How to apply the DVARP function. Examples The figure below displays the result returned by the DVARP function."
    },
   {
        "id": "Functions/ecma-ceiling.htm", 
        "title": "ECMA.CEILING Function", 
        "body": "The ECMA.CEILING function is one of the math and trigonometry functions. It is used to round the number up to the nearest multiple of significance. Negative numbers are rounded towards zero. Syntax ECMA.CEILING(x, significance) The ECMA.CEILING function has the following arguments: Argument Description x The number you wish to round up. significance The multiple of significance you wish to round up to. Notes How to apply the ECMA.CEILING function. Examples The figure below displays the result returned by the ECMA.CEILING function."
    },
   {
        "id": "Functions/edate.htm", 
        "title": "EDATE Function", 
        "body": "The EDATE function is one of the date and time functions. It is used to return the serial number of the date which comes the indicated number of months (months) before or after the specified date (start_date). Syntax EDATE(start_date, months) The EDATE function has the following arguments: Argument Description start_date A number representing the first date of the period entered using the DATE function or other date and time function. months A number of months before or after start_date. If the months has the negative sign, the function will return the serial number of the date which comes before the specified start_date. If the months has the positive sign, the function will return the serial number of the date which follows after the specified start_date. Notes How to apply the EDATE function. Examples The figure below displays the result returned by the EDATE function."
    },
   {
        "id": "Functions/effect.htm", 
        "title": "EFFECT Function", 
        "body": "The EFFECT function is one of the financial functions. It is used to calculate the effective annual interest rate for a security based on a specified nominal annual interest rate and the number of compounding periods per year. Syntax EFFECT(nominal_rate, npery) The EFFECT function has the following arguments: Argument Description nominal_rate The nominal annual interest rate of the security. npery The number of compounding periods per year. Notes How to apply the EFFECT function. Examples The figure below displays the result returned by the EFFECT function."
    },
   {
        "id": "Functions/eomonth.htm", 
        "title": "EOMONTH Function", 
        "body": "The EOMONTH function is one of the date and time functions. Is used to return the serial number of the last day of the month that comes the indicated number of months before or after the specified start date. Syntax EOMONTH(start_date, months) The EOMONTH function has the following arguments: Argument Description start_date A number representing the first date of the period entered using the DATE function or other date and time function. months A number of months before or after start_date. If the months has the negative sign, the function will return the serial number of the date which comes before the specified start_date. If the months has the positive sign, the function will return the serial number of the date which follows after the specified start_date. Notes How to apply the EOMONTH function. Examples The figure below displays the result returned by the EOMONTH function."
    },
   {
        "id": "Functions/erf-precise.htm", 
        "title": "ERF.PRECISE Function", 
        "body": "The ERF.PRECISE function is one of the engineering functions. It is used to return the error function integrated between 0 and the specified lower limit. Syntax ERF.PRECISE(x) The ERF.PRECISE function has the following argument: Argument Description x The lower limit of integration. Notes How to apply the ERF.PRECISE function. Examples The figure below displays the result returned by the ERF.PRECISE function."
    },
   {
        "id": "Functions/erf.htm", 
        "title": "ERF Function", 
        "body": "The ERF function is one of the engineering functions. It is used to calculate the error function integrated between the specified lower and upper limits. Syntax ERF(lower_limit, [upper_limit]) The ERF function has the following arguments: Argument Description lower_limit The lower limit of integration. upper_limit The upper limit of integration. It is an optional argument. If it is omitted, the function will calculate the error function integrated between 0 and lower_limit. Notes How to apply the ERF function. Examples The figure below displays the result returned by the ERF function."
    },
   {
        "id": "Functions/erfc-precise.htm", 
        "title": "ERFC.PRECISE Function", 
        "body": "The ERFC.PRECISE function is one of the engineering functions. It is used to calculate the complementary error function integrated between the specified lower limit and infinity. Syntax ERFC.PRECISE(x) The ERFC.PRECISE function has the following argument: Argument Description x The lower limit of integration. Notes How to apply the ERFC.PRECISE function. Examples The figure below displays the result returned by the ERFC.PRECISE function."
    },
   {
        "id": "Functions/erfc.htm", 
        "title": "ERFC Function", 
        "body": "The ERFC function is one of the engineering functions. It is used to calculate the complementary error function integrated between the specified lower limit and infinity. Syntax ERFC(x) The ERFC function has the following argument: Argument Description x The lower limit of integration. Notes How to apply the ERFC function. Examples The figure below displays the result returned by the ERFC function."
    },
   {
        "id": "Functions/error-type.htm", 
        "title": "ERROR.TYPE Function", 
        "body": "The ERROR.TYPE function is one of the information functions. It is used to return the numeric representation of one of the existing errors. Syntax ERROR.TYPE(error_val) The ERROR.TYPE function has the following argument: Argument Description error_val An error value. The possible values are listed in the table below. The error_val argument can be one of the following: Error value Numeric representation #NULL! 1 #DIV/0! 2 #VALUE! 3 #REF! 4 #NAME? 5 #NUM! 6 #N/A 7 #GETTING_DATA 8 Other #N/A Notes How to apply the ERROR.TYPE function. Examples The figure below displays the result returned by the ERROR.TYPE function."
    },
   {
        "id": "Functions/even.htm", 
        "title": "EVEN Function", 
        "body": "The EVEN function is one of the math and trigonometry functions. It is used to round the number up to the nearest even integer. Syntax EVEN(number) The EVEN function has the following argument: Argument Description number A number you wish to round up. Notes How to apply the EVEN function. Examples The figure below displays the result returned by the EVEN function."
    },
   {
        "id": "Functions/exact.htm", 
        "title": "EXACT Function", 
        "body": "The EXACT function is one of the text and data functions. Is used to compare data in two cells. The function returns TRUE if the data are the same, and FALSE if not. Syntax EXACT(text1, text2) The EXACT function has the following arguments: Argument Description text1(2) Two text strings you want to compare. Notes The EXACT function is case-sensitive. How to apply the EXACT function. Examples There are two arguments: text1 = A1; text2 = B1, where A1 is MyPassword, B1 is mypassword. So the function returns FALSE. If we change the A1 data converting all the uppercase letters to lowercase, the function returns TRUE:"
    },
   {
        "id": "Functions/exp.htm", 
        "title": "EXP Function", 
        "body": "The EXP function is one of the math and trigonometry functions. It is used to return the e constant raised to the desired power. The e constant is equal to 2,71828182845904. Syntax EXP(number) The EXP function has the following argument: Argument Description number A power you wish to raise e to. Notes How to apply the EXP function. Examples The figure below displays the result returned by the EXP function."
    },
   {
        "id": "Functions/expand.htm", 
        "title": "EXPAND Function", 
        "body": "The EXPAND function is one of the lookup and reference functions. It is used to expand a range of data (array) by adding rows and columns. Syntax EXPAND(array, rows, [columns], [pad_with]) The EXPAND function has the following arguments: Argument Description array The range of cells to be expanded. rows The number of rows in the returned array. Although this is a required argument, if omitted, rows will not be added and the number of columns must be specified. columns An optional argument identifying the number of columns in the returned array. If omitted, columns will not be added and the number of rows must be specified. pad_with The value to fill in the added cells. #N/A is the default value. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the EXPAND function. Examples The figure below displays the result returned by the EXPAND function."
    },
   {
        "id": "Functions/expon-dist.htm", 
        "title": "EXPON.DIST Function", 
        "body": "The EXPON.DIST function is one of the statistical functions. It is used to return the exponential distribution. Syntax EXPON.DIST(x, lambda, cumulative) The EXPON.DIST function has the following arguments: Argument Description x The value of the function, a numeric value greater than or equal to 0. lambda The parameter of the value, a numeric value greater than 0. cumulative A logical value (TRUE or FALSE) that determines the function form. If cumulative is TRUE, the function will return the cumulative distribution function, if it is FALSE, it will return the probability density function. Notes How to apply the EXPON.DIST function. Examples The figure below displays the result returned by the EXPON.DIST function."
    },
   {
        "id": "Functions/expondist.htm", 
        "title": "EXPONDIST Function", 
        "body": "The EXPONDIST function is one of the statistical functions. It is used to return the exponential distribution. Syntax EXPONDIST(x, lambda, cumulative) The EXPONDIST function has the following arguments: Argument Description x The value of the function, a numeric value greater than or equal to 0. lambda The parameter of the value, a numeric value greater than 0. cumulative A logical value (TRUE or FALSE) that determines the function form. If cumulative is TRUE, the function will return the cumulative distribution function, if it is FALSE, it will return the probability density function. Notes How to apply the EXPONDIST function. Examples The figure below displays the result returned by the EXPONDIST function."
    },
   {
        "id": "Functions/f-dist-rt.htm", 
        "title": "F.DIST.RT Function", 
        "body": "The F.DIST.RT function is one of the statistical functions. It is used to return the (right-tailed) F probability distribution (degree of diversity) for two data sets. You can use this function to determine whether two data sets have different degrees of diversity. Syntax F.DIST.RT(x, deg_freedom1, deg_freedom2) The F.DIST.RT function has the following arguments: Argument Description x The value at which the function should be calculated. A numeric value greater than 0. deg_freedom1 The numerator degrees of freedom, a numeric value greater than 1. deg_freedom2 The denominator degrees of freedom, a numeric value greater than 1. Notes How to apply the F.DIST.RT function. Examples The figure below displays the result returned by the F.DIST.RT function."
    },
   {
        "id": "Functions/f-dist.htm", 
        "title": "F.DIST Function", 
        "body": "The F.DIST function is one of the statistical functions. It is used to return the F probability distribution. You can use this function to determine whether two data sets have different degrees of diversity. Syntax F.DIST(x, deg_freedom1, deg_freedom2, cumulative) The F.DIST function has the following arguments: Argument Description x The value at which the function should be calculated. A numeric value greater than 0. deg_freedom1 The numerator degrees of freedom, a numeric value greater than 0. deg_freedom2 The denominator degrees of freedom, a numeric value greater than 0. cumulative A logical value (TRUE or FALSE) that determines the function form. If cumulative is TRUE, the function will return the cumulative distribution function. If it is FALSE, the function returns the probability density function. Notes How to apply the F.DIST function. Examples The figure below displays the result returned by the F.DIST function."
    },
   {
        "id": "Functions/f-inv-rt.htm", 
        "title": "F.INV.RT Function", 
        "body": "The F.INV.RT function is one of the statistical functions. It is used to return the inverse of the (right-tailed) F probability distribution. The F distribution can be used in an F-test that compares the degree of variability in two data sets. Syntax F.INV.RT(probability, deg_freedom1, deg_freedom2) The F.INV.RT function has the following arguments: Argument Description probability The probability associated with the F cumulative distribution. A numeric value greater than 0 but less than 1. deg_freedom1 The numerator degrees of freedom, a numeric value greater than 1. deg_freedom2 The denominator degrees of freedom, a numeric value greater than 1. Notes How to apply the F.INV.RT function. Examples The figure below displays the result returned by the F.INV.RT function."
    },
   {
        "id": "Functions/f-inv.htm", 
        "title": "F.INV Function", 
        "body": "The F.INV function is one of the statistical functions. It is used to return the inverse of the (right-tailed) F probability distribution. The F distribution can be used in an F-test that compares the degree of variability in two data sets. Syntax F.INV(probability, deg_freedom1, deg_freedom2) The F.INV function has the following arguments: Argument Description probability The probability associated with the F cumulative distribution. A numeric value greater than 0 but less than 1. deg_freedom1 The numerator degrees of freedom, a numeric value greater than 1. deg_freedom2 The denominator degrees of freedom, a numeric value greater than 1. Notes How to apply the F.INV function. Examples The figure below displays the result returned by the F.INV function."
    },
   {
        "id": "Functions/f-test.htm", 
        "title": "F.TEST Function", 
        "body": "The F.TEST function is one of the statistical functions. It is used to return the result of an F-test, the two-tailed probability that the variances in array1 and array2 are not significantly different. Use this function to determine whether two samples have different variances. Syntax F.TEST(array1, array2) The F.TEST function has the following arguments: Argument Description array1 The first range of values. array2 The second range of values. Notes Text, logical values and empty cells are ignored, cells that contain zero values are included. If the number of values in a data range is less than 2 or a variance of an array is 0, the function returns the #DIV/0! error value. How to apply the F.TEST function. Examples The figure below displays the result returned by the F.TEST function."
    },
   {
        "id": "Functions/fact.htm", 
        "title": "FACT Function", 
        "body": "The FACT function is one of the math and trigonometry functions. It is used to return the factorial of a number. Syntax FACT(number) The FACT function has the following argument: Argument Description number A numeric value for which you want to get the factorial. Notes How to apply the FACT function. Examples The figure below displays the result returned by the FACT function."
    },
   {
        "id": "Functions/factdouble.htm", 
        "title": "FACTDOUBLE Function", 
        "body": "The FACTDOUBLE function is one of the math and trigonometry functions. It is used to return the double factorial of a number. Syntax FACTDOUBLE(number) The FACTDOUBLE function has the following argument: Argument Description number A numeric value for which you want to get the double factorial. Notes How to apply the FACTDOUBLE function. Examples The figure below displays the result returned by the FACTDOUBLE function."
    },
   {
        "id": "Functions/false.htm", 
        "title": "FALSE Function", 
        "body": "The FALSE function is one of the logical functions. The function returns FALSE and does not require any argument. Syntax FALSE() Notes How to apply the FALSE function. Examples The figure below displays the result returned by the FALSE function."
    },
   {
        "id": "Functions/fdist.htm", 
        "title": "FDIST Function", 
        "body": "The FDIST function is one of the statistical functions. It is used to return the (right-tailed) F probability distribution (degree of diversity) for two data sets. You can use this function to determine whether two data sets have different degrees of diversity. Syntax FDIST(x, deg_freedom1, deg_freedom2) The FDIST function has the following arguments: Argument Description x The value at which the function should be calculated. A numeric value greater than 0. deg_freedom1 The numerator degrees of freedom, a numeric value greater than 1 and less than 10^10. deg_freedom2 The denominator degrees of freedom, a numeric value greater than 1 and less than 10^10. Notes How to apply the FDIST function. Examples The figure below displays the result returned by the FDIST function."
    },
   {
        "id": "Functions/filter.htm", 
        "title": "FILTER Function", 
        "body": "The FILTER function is one of the lookup and reference functions. It is used to filter a range of data and to return the results that match the criteria you specify. The FILTER function only extracts the necessary data and the results update when the original data change. Syntax FILTER(array, include, [if_empty]) The FILTER function has the following arguments: Argument Description array The range of cells to filter. include The filtering criteria supplied as a Boolean array (TRUE/FALSE) the same height (columns) and width (rows) as the array. if_empty The value to return when the filter returns no results. This argument is optional. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the FILTER function. Examples The figure below displays the result returned by the FILTER function."
    },
   {
        "id": "Functions/find.htm", 
        "title": "FIND/FINDB Function", 
        "body": "The FIND/FINDB function is one of the text and data functions. Is used to find the specified substring (find_text) within a string (within_text). The FIND function is intended for languages that use the single-byte character set (SBCS), while FINDB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax FIND(find_text, within_text, [start_num]) FINDB(find_text, within_text, [start_num]) The FIND/FINDB function has the following arguments: Argument Description find_text A string you are looking for. within_text A string you are searching within. start_num A position in a string where the search will start. It is an optional argument. If it is omitted, the funcion will start search from the beginning of the string. Notes The FIND/FINDB function is case-sensitive. If there are no matches, the function will return the #VALUE! error. How to apply the FIND/FINDB function. Examples The figure below displays the result returned by the FIND function."
    },
   {
        "id": "Functions/findb.htm", 
        "title": "FIND/FINDB Function", 
        "body": "The FIND/FINDB function is one of the text and data functions. Is used to find the specified substring (find_text) within a string (within_text). The FIND function is intended for languages that use the single-byte character set (SBCS), while FINDB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax FIND(find_text, within_text, [start_num]) FINDB(find_text, within_text, [start_num]) The FIND/FINDB function has the following arguments: Argument Description find_text A string you are looking for. within_text A string you are searching within. start_num A position in a string where the search will start. It is an optional argument. If it is omitted, the funcion will start search from the beginning of the string. Notes The FIND/FINDB function is case-sensitive. If there are no matches, the function will return the #VALUE! error. How to apply the FIND/FINDB function. Examples The figure below displays the result returned by the FIND function."
    },
   {
        "id": "Functions/finv.htm", 
        "title": "FINV Function", 
        "body": "The FINV function is one of the statistical functions. It is used to return the inverse of the (right-tailed) F probability distribution. The F distribution can be used in an F-test that compares the degree of variability in two data sets. Syntax FINV(probability, deg_freedom1, deg_freedom2) The FINV function has the following arguments: Argument Description probability The probability associated with the F cumulative distribution. A numeric value greater than 0 but less than 1. deg_freedom1 The numerator degrees of freedom, a numeric value greater than 1 and less than 10^10. deg_freedom2 The denominator degrees of freedom, a numeric value greater than 1 and less than 10^10. Notes How to apply the FINV function. Examples The figure below displays the result returned by the FINV function."
    },
   {
        "id": "Functions/fisher.htm", 
        "title": "FISHER Function", 
        "body": "The FISHER function is one of the statistical functions. It is used to return the Fisher transformation of a number. Syntax FISHER(x) The FISHER function has the following argument: Argument Description x A numeric value greater than - 1 but less than 1. Notes How to apply the FISHER function. Examples The figure below displays the result returned by the FISHER function."
    },
   {
        "id": "Functions/fisherinv.htm", 
        "title": "FISHERINV Function", 
        "body": "The FISHERINV function is one of the statistical functions. It is used to perform the inverse of the Fisher transformation. Syntax FISHERINV(y) The FISHERINV function has the following argument: Argument Description y A numeric value for which you want to perform the inverse of the Fisher transformation. Notes How to apply the FISHERINV function. Examples The figure below displays the result returned by the FISHERINV function."
    },
   {
        "id": "Functions/fixed.htm", 
        "title": "FIXED Function", 
        "body": "The FIXED function is one of the text and data functions. Is used to return the text representation of a number rounded to a specified number of decimal places. Syntax FIXED(number, [decimals], [no_commas]) The FIXED function has the following arguments: Argument Description number A number to round. decimals A number of decimal places to display. It is an optional argument, if it's omitted, the function will assume it to be 2. no_commas A logical value. If it is set to TRUE, the function will return the result without commas. If it is FALSE or omitted, the result will be displayed with commas. Notes How to apply the FIXED function. Examples The figure below displays the result returned by the FIXED function."
    },
   {
        "id": "Functions/floor-math.htm", 
        "title": "FLOOR.MATH Function", 
        "body": "The FLOOR.MATH function is one of the math and trigonometry functions. It is used to round a number down to the nearest integer or to the nearest multiple of significance. Syntax FLOOR.MATH(number, [significance], [mode]) The FLOOR.MATH function has the following arguments: Argument Description number A number you wish to round down. significance A multiple of significance you wish to round down to. It is an optional argument. If it is omitted, the default value of 1 is used. mode Specifies if negative numbers are rounded towards or away from zero. It is an optional parameter that does not affect positive numbers. If it is omitted or set to 0, negative numbers are rounded away from zero. If any other numeric value is specified, negative numbers are rounded towards zero. Notes How to apply the FLOOR.MATH function. Examples The figure below displays the result returned by the FLOOR.MATH function."
    },
   {
        "id": "Functions/floor-precise.htm", 
        "title": "FLOOR.PRECISE Function", 
        "body": "The FLOOR.PRECISE function is one of the math and trigonometry functions. It is used to return a number that is rounded down to the nearest integer or to the nearest multiple of significance. The number is always rounded down regardless of its sing. Syntax FLOOR.PRECISE(number, [significance]) The FLOOR.PRECISE function has the following arguments: Argument Description number A number you wish to round down. significance A multiple of significance you wish to round down to. It is an optional argument. If it is omitted, the default value of 1 is used. If it is set to zero, the function returns 0. Notes How to apply the FLOOR.PRECISE function. Examples The figure below displays the result returned by the FLOOR.PRECISE function."
    },
   {
        "id": "Functions/floor.htm", 
        "title": "FLOOR Function", 
        "body": "The FLOOR function is one of the math and trigonometry functions. It is used to round the number down to the nearest multiple of significance. Syntax FLOOR(number, significance) The FLOOR function has the following arguments: Argument Description number A number you wish to round down. significance A multiple of significance you wish to round down to. Notes If the values of x and significance have different signs, the function returns the #NUM! error. How to apply the FLOOR function. Examples The figure below displays the result returned by the FLOOR function."
    },
   {
        "id": "Functions/forecast-ets-confint.htm", 
        "title": "FORECAST.ETS.CONFINT Function", 
        "body": "The FORECAST.ETS.CONFINT function is one of the statistical functions. It is used to return a confidence interval for the forecast value at the specified target date. Syntax FORECAST.ETS.CONFINT(target_date, values, timeline, [confidence_level], [seasonality], [data_completion], [aggregation]) The FORECAST.ETS.CONFINT function has the following arguments: Argument Description target_date A date for which you want to predict a new value. Must be after the last date in the timeline. values A range of the historical values for which you want to predict a new point. timeline A range of date/time values that correspond to the historical values. The timeline range must be of the same size as the values range. Date/time values must have a constant step between them (although up to 30% of missing values can be processed as specified by the data_completion argument and duplicate values can be aggregated as specified by the aggregation argument). confidence_level A numeric value between 0 and 1 (exclusive) that specifies the confidence level for the calculated confidence interval. It is an optional argument. If it is omitted, the default value of 0.95 is used. seasonality A numeric value that specifies which method should be used to detect the seasonality. It is an optional argument. The possible values are listed in the table below. data_completion A numeric value that specifies how to process the missing data points in the timeline data range. It is an optional argument. The possible values are listed in the table below. aggregation A numeric value that specifies which function should be used to aggregate identical time values in the timeline data range. It is an optional argument. The possible values are listed in the table belows. The seasonality argument can be one of the following: Numeric value Behavior 1 or omitted Seasonality is detected automatically. Positive, whole numbers are used for the length of the seasonal pattern. 0 No seasonality, the prediction will be linear. an integer greater than or equal to 2 The specified number is used for the length of the seasonal pattern. The data_completion argument can be one of the following: Numeric value Behavior 1 or omitted Missing points are calculated as the average of the neighbouring points. 0 Missing points are treated as zero values. The aggregation argument can be one of the following: Numeric value Function 1 or omitted AVERAGE 2 COUNT 3 COUNTA 4 MAX 5 MEDIAN 6 MIN 7 SUM Notes How to apply the FORECAST.ETS.CONFINT function. Examples The figure below displays the result returned by the FORECAST.ETS.CONFINT function."
    },
   {
        "id": "Functions/forecast-ets-seasonality.htm", 
        "title": "FORECAST.ETS.SEASONALITY Function", 
        "body": "The FORECAST.ETS.SEASONALITY function is one of the statistical functions. It is used to return the length of the repetitive pattern the application detects for the specified time series. Syntax FORECAST.ETS.SEASONALITY(values, timeline, [data_completion], [aggregation]) The FORECAST.ETS.SEASONALITY function has the following arguments: Argument Description values A range of the historical values for which you want to predict a new point. timeline A range of date/time values that correspond to the historical values. The timeline range must be of the same size as the values range. Date/time values must have a constant step between them (although up to 30% of missing values can be processed as specified by the data_completion argument and duplicate values can be aggregated as specified by the aggregation argument). data_completion A numeric value that specifies how to process the missing data points in the timeline data range. It is an optional argument. The possible values are listed in the table below. aggregation A numeric value that specifies which function should be used to aggregate identical time values in the timeline data range. It is an optional argument. The possible values are listed in the table belows. The data_completion argument can be one of the following: Numeric value Behavior 1 or omitted Missing points are calculated as the average of the neighbouring points. 0 Missing points are treated as zero values. The aggregation argument can be one of the following: Numeric value Function 1 or omitted AVERAGE 2 COUNT 3 COUNTA 4 MAX 5 MEDIAN 6 MIN 7 SUM Notes How to apply the FORECAST.ETS.SEASONALITY function. Examples The figure below displays the result returned by the FORECAST.ETS.SEASONALITY function."
    },
   {
        "id": "Functions/forecast-ets-stat.htm", 
        "title": "FORECAST.ETS.STAT Function", 
        "body": "The FORECAST.ETS.STAT function is one of the statistical functions. It is used to return a statistical value as a result of time series forecasting. Statistic type indicates which statistic is requested by this function. Syntax FORECAST.ETS.STAT(values, timeline, statistic_type, [seasonality], [data_completion], [aggregation]) The FORECAST.ETS.STAT function has the following arguments: Argument Description values A range of the historical values for which you want to predict a new point. timeline A range of date/time values that correspond to the historical values. The timeline range must be of the same size as the values range. Date/time values must have a constant step between them (although up to 30% of missing values can be processed as specified by the data_completion argument and duplicate values can be aggregated as specified by the aggregation argument). statistic_type A numeric value between 1 and 8 that specifies which statistic will be returned. The possible values are listed in the table below. seasonality A numeric value that specifies which method should be used to detect the seasonality. It is an optional argument. The possible values are listed in the table below. data_completion A numeric value that specifies how to process the missing data points in the timeline data range. It is an optional argument. The possible values are listed in the table below. aggregation A numeric value that specifies which function should be used to aggregate identical time values in the timeline data range. It is an optional argument. The possible values are listed in the table belows. The statistic_type argument can be one of the following: Numeric value Statistic 1 Alpha parameter of ETS algorithm - the base value parameter. 2 Beta parameter of ETS algorithm - the trend value parameter. 3 Gamma parameter of ETS algorithm - the seasonality value parameter. 4 MASE (mean absolute scaled error) metric - a measure of the accuracy of forecasts. 5 SMAPE (symmetric mean absolute percentage error) metric - a measure of the accuracy based on percentage errors. 6 MAE (mean absolute error) metric - a measure of the accuracy of forecasts. 7 RMSE (root mean squared error) metric - a measure of the differences between predicted and observed values. 8 Step size detected in the timeline. The seasonality argument can be one of the following: Numeric value Behavior 1 or omitted Seasonality is detected automatically. Positive, whole numbers are used for the length of the seasonal pattern. 0 No seasonality, the prediction will be linear. an integer greater than or equal to 2 The specified number is used for the length of the seasonal pattern. The data_completion argument can be one of the following: Numeric value Behavior 1 or omitted Missing points are calculated as the average of the neighbouring points. 0 Missing points are treated as zero values. The aggregation argument can be one of the following: Numeric value Function 1 or omitted AVERAGE 2 COUNT 3 COUNTA 4 MAX 5 MEDIAN 6 MIN 7 SUM Notes How to apply the FORECAST.ETS.STAT function. Examples The figure below displays the result returned by the FORECAST.ETS.STAT function."
    },
   {
        "id": "Functions/forecast-ets.htm", 
        "title": "FORECAST.ETS Function", 
        "body": "The FORECAST.ETS function is one of the statistical functions. It is used to calculate or predict a future value based on existing (historical) values by using the AAA version of the Exponential Smoothing (ETS) algorithm. Syntax FORECAST.ETS(target_date, values, timeline, [seasonality], [data_completion], [aggregation]) The FORECAST.ETS function has the following arguments: Argument Description target_date A date for which you want to predict a new value. Must be after the last date in the timeline. values A range of the historical values for which you want to predict a new point. timeline A range of date/time values that correspond to the historical values. The timeline range must be of the same size as the values range. Date/time values must have a constant step between them (although up to 30% of missing values can be processed as specified by the data_completion argument and duplicate values can be aggregated as specified by the aggregation argument). seasonality A numeric value that specifies which method should be used to detect the seasonality. It is an optional argument. The possible values are listed in the table below. data_completion A numeric value that specifies how to process the missing data points in the timeline data range. It is an optional argument. The possible values are listed in the table below. aggregation A numeric value that specifies which function should be used to aggregate identical time values in the timeline data range. It is an optional argument. The possible values are listed in the table belows. The seasonality argument can be one of the following: Numeric value Behavior 1 or omitted Seasonality is detected automatically. Positive, whole numbers are used for the length of the seasonal pattern. 0 No seasonality, the prediction will be linear. an integer greater than or equal to 2 The specified number is used for the length of the seasonal pattern. The data_completion argument can be one of the following: Numeric value Behavior 1 or omitted Missing points are calculated as the average of the neighbouring points. 0 Missing points are treated as zero values. The aggregation argument can be one of the following: Numeric value Function 1 or omitted AVERAGE 2 COUNT 3 COUNTA 4 MAX 5 MEDIAN 6 MIN 7 SUM Notes How to apply the FORECAST.ETS function. Examples The figure below displays the result returned by the FORECAST.ETS function."
    },
   {
        "id": "Functions/forecast-linear.htm", 
        "title": "FORECAST.LINEAR Function", 
        "body": "The FORECAST.LINEAR function is one of the statistical functions. It is used to calculate, or predict, a future value by using existing values; the predicted value is a y-value for a given x-value. The known values are existing x-values and y-values, and the new value is predicted by using linear regression. Syntax FORECAST.LINEAR(x, known_y's, known_x's) The FORECAST.LINEAR function has the following arguments: Argument Description x An x-value used to predict the y-value. known_y's An array of known y-values. known_x's An array of known x-values. Notes How to apply the FORECAST.LINEAR function. Examples The figure below displays the result returned by the FORECAST.LINEAR function."
    },
   {
        "id": "Functions/forecast.htm", 
        "title": "FORECAST Function", 
        "body": "The FORECAST function is one of the statistical functions. It is used to predict a future value based on existing values provided. Syntax FORECAST(x, known_y's, known_x's) The FORECAST function has the following arguments: Argument Description x An x-value used to predict the y-value. known_y's The dependent data range. known_x's The independent data range with the same number of elements as known_y's contains. Notes How to apply the FORECAST function. Examples The figure below displays the result returned by the FORECAST function."
    },
   {
        "id": "Functions/formulatext.htm", 
        "title": "FORMULATEXT Function", 
        "body": "The FORMULATEXT function is one of the lookup and reference functions. It is used to return a formula as a string (i.e. the text string that is displayed in the formula bar if you select the cell that contains the formula). Syntax FORMULATEXT(reference) The FORMULATEXT function has the following argument: Argument Description reference A reference to a single cell or a range of cells. Notes If the referenced cell range contains more than one formula, the FORMULATEXT function returns the value from the upper left cell of this range. If the referenced cell does not contain a formula, the FORMULATEXT function returns the N/A error value. Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the FORMULATEXT function. Examples The figure below displays the result returned by the FORMULATEXT function."
    },
   {
        "id": "Functions/frequency.htm", 
        "title": "FREQUENCY Function", 
        "body": "The FREQUENCY function is one of the statistical functions. It is used to сalculate how often values occur within the selected range of cells and display the first value of the returned vertical array of numbers. Syntax FREQUENCY(data_array, bins_array) The FREQUENCY function has the following arguments: Argument Description data_array The selected range of cells you want to count the frequencies for. bins_array The selected range of cells containing intervals into which you want to group the values in data_array. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the FREQUENCY function. Examples The figure below displays the result returned by the FREQUENCY function."
    },
   {
        "id": "Functions/ftest.htm", 
        "title": "FTEST Function", 
        "body": "The FTEST function is one of the statistical functions. It is used to return the result of an F-test. An F-test returns the two-tailed probability that the variances in array1 and array2 are not significantly different. Use this function to determine whether two samples have different variances. Syntax FTEST(array1, array2) The FTEST function has the following arguments: Argument Description array1 The first range of values. array2 The second range of values. Notes Text, logical values and empty cells are ignored, cells that contain zero values are included. If the number of values in a data range is less than 2 or a variance of an array is 0, the function returns the #DIV/0! error value. How to apply the FTEST function. Examples The figure below displays the result returned by the FTEST function."
    },
   {
        "id": "Functions/fv.htm", 
        "title": "FV Function", 
        "body": "The FV function is one of the financial functions. It is used to calculate the future value of an investment based on a specified interest rate and a constant payment schedule. Syntax FV(rate, nper, pmt, [pv], [type]) The FV function has the following arguments: Argument Description rate The interest rate for the investment. nper A number of payments. pmt A payment amount. pv A present value of the payments. It is an optional argument. If it is omitted, the function will assume pv to be 0. type A period when the payments are due. It is an optional argument. If it is set to 0 or omitted, the function will assume the payments to be due at the end of the period. If type is set to 1, the payments are due at the beginning of the period. Notes Cash paid out (such as deposits to savings) is represented by negative numbers; cash received (such as dividend checks) is represented by positive numbers. Units for rate and nper must be consistent: use N%/12 for rate and N*12 for nper in case of monthly payments, N%/4 for rate and N*4 for nper in case of quarterly payments, N% for rate and N for nper in case of annual payments. How to apply the FV function. Examples The figure below displays the result returned by the FV function."
    },
   {
        "id": "Functions/fvschedule.htm", 
        "title": "FVSCHEDULE Function", 
        "body": "The FVSCHEDULE function is one of the financial functions. It is used to calculate the future value of an investment based on a series of changeable interest rates. Syntax FVSCHEDULE(principal, schedule) The FVSCHEDULE function has the following arguments: Argument Description principal The current value of an investment. schedule An array or a range of interest rates. Notes Schedule values can be numbers or empty cells (they are interpreted as 0). How to apply the FVSCHEDULE function. Examples The figure below displays the result returned by the FVSCHEDULE function."
    },
   {
        "id": "Functions/gamma-dist.htm", 
        "title": "GAMMA.DIST Function", 
        "body": "The GAMMA.DIST function is one of the statistical functions. It is used to return the gamma distribution. Syntax GAMMA.DIST(x, alpha, beta, cumulative) The GAMMA.DIST function has the following arguments: Argument Description x The value at which the function should be calculated. A numeric value greater than 0. alpha The first parameter of the distribution, a numeric value greater than 0. beta The second parameter of the distribution, a numeric value greater than 0. If beta is 1, the function returns the standard gamma distribution. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability density function. Notes How to apply the GAMMA.DIST function. Examples The figure below displays the result returned by the GAMMA.DIST function."
    },
   {
        "id": "Functions/gamma-inv.htm", 
        "title": "GAMMA.INV Function", 
        "body": "The GAMMA.INV function is one of the statistical functions. It is used to return the inverse of the gamma cumulative distribution. Syntax GAMMA.INV(probability, alpha, beta) The GAMMA.INV function has the following arguments: Argument Description probability The probability associated with the gamma distribution. A numeric value greater than 0 but less than 1. alpha The first parameter of the distribution, a numeric value greater than 0. beta The second parameter of the distribution, a numeric value greater than 0. If beta is 1, the function returns the standard gamma distribution. Notes How to apply the GAMMA.INV function. Examples The figure below displays the result returned by the GAMMA.INV function."
    },
   {
        "id": "Functions/gamma.htm", 
        "title": "GAMMA Function", 
        "body": "The GAMMA function is one of the statistical functions. It is used to return the gamma function value. Syntax GAMMA(number) The GAMMA function has the following argument: Argument Description number A numeric value. Notes If the number is a negative integer or 0 the function returns the #NUM! error value. How to apply the GAMMA function. Examples The figure below displays the result returned by the GAMMA function."
    },
   {
        "id": "Functions/gammadist.htm", 
        "title": "GAMMADIST Function", 
        "body": "The GAMMADIST function is one of the statistical functions. It is used to return the gamma distribution. Syntax GAMMADIST(x, alpha, beta, cumulative) The GAMMADIST function has the following arguments: Argument Description x The value at which the function should be calculated. A numeric value greater than 0. alpha The first parameter of the distribution, a numeric value greater than 0. beta The second parameter of the distribution, a numeric value greater than 0. If beta is 1, the function returns the standard gamma distribution. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability density function. Notes How to apply the GAMMADIST function. Examples The figure below displays the result returned by the GAMMADIST function."
    },
   {
        "id": "Functions/gammainv.htm", 
        "title": "GAMMAINV Function", 
        "body": "The GAMMAINV function is one of the statistical functions. It is used to return the inverse of the gamma cumulative distribution. Syntax GAMMAINV(probability, alpha, beta) The GAMMAINV function has the following arguments: Argument Description probability The probability associated with the gamma distribution. A numeric value greater than 0 but less than 1. alpha The first parameter of the distribution, a numeric value greater than 0. beta The second parameter of the distribution, a numeric value greater than 0. If beta is 1, the function returns the standard gamma distribution. Notes How to apply the GAMMAINV function. Examples The figure below displays the result returned by the GAMMAINV function."
    },
   {
        "id": "Functions/gammaln-precise.htm", 
        "title": "GAMMALN.PRECISE Function", 
        "body": "The GAMMALN.PRECISE function is one of the statistical functions. It is used to return the natural logarithm of the gamma function. Syntax GAMMALN.PRECISE(x) The GAMMALN.PRECISE function has the following argument: Argument Description x A numeric value greater than 0. Notes How to apply the GAMMALN.PRECISE function. Examples The figure below displays the result returned by the GAMMALN.PRECISE function."
    },
   {
        "id": "Functions/gammaln.htm", 
        "title": "GAMMALN Function", 
        "body": "The GAMMALN function is one of the statistical functions. It is used to return the natural logarithm of the gamma function. Syntax GAMMALN(x) The GAMMALN function has the following argument: Argument Description x A numeric value greater than 0. Notes How to apply the GAMMALN function. Examples The figure below displays the result returned by the GAMMALN function."
    },
   {
        "id": "Functions/gauss.htm", 
        "title": "GAUSS Function", 
        "body": "The GAUSS function is one of the statistical functions. It is used to calculate the probability that a member of a standard normal population will fall between the mean and z standard deviations from the mean. Syntax GAUSS(z) The GAUSS function has the following argument: Argument Description z A numeric value. Notes How to apply the GAUSS function. Examples The figure below displays the result returned by the GAUSS function."
    },
   {
        "id": "Functions/gcd.htm", 
        "title": "GCD Function", 
        "body": "The GCD function is one of the math and trigonometry functions. It is used to return the greatest common divisor of two or more numbers. Syntax GCD(number1, [number2], ...) The GCD function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to get the greatest common divisor. Notes How to apply the GCD function. Examples The figure below displays the result returned by the GCD function."
    },
   {
        "id": "Functions/geomean.htm", 
        "title": "GEOMEAN Function", 
        "body": "The GEOMEAN function is one of the statistical functions. It is used to calculate the geometric mean of the argument list. Syntax GEOMEAN(number1, [number2], ...) The GEOMEAN function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to get the geometric mean. Notes How to apply the GEOMEAN function. Examples The figure below displays the result returned by the GEOMEAN function."
    },
   {
        "id": "Functions/gestep.htm", 
        "title": "GESTEP Function", 
        "body": "The GESTEP function is one of the engineering functions. It is used to test if a number is greater than a threshold value. The function returns 1 if the number is greater than or equal to the threshold value and 0 otherwise. Syntax GESTEP(number, [step]) The GESTEP function has the following arguments: Argument Description number A number to compare with step. step A threshold value. It is an optional argument. If it is omitted, the function will assume step to be 0. Notes How to apply the GESTEP function. Examples The figure below displays the result returned by the GESTEP function."
    },
   {
        "id": "Functions/getpivotdata.htm", 
        "title": "GETPIVOTDATA Function", 
        "body": "The GETPIVOTDATA function is one of the lookup and reference functions. It is used to extract data stored in a PivotTable. Syntax GETPIVOTDATA(data_field, pivot_table, [field], [item], …) The GETPIVOTDATA function has the following arguments: Argument Description data_field Is used to set the name of the PivotTable field that contains the required data. The argument needs to be in quotes. pivot_table Is used to refer to any cell, range of cells, or named range of cells in a PivotTable. The argument is used to determine which PivotTable contains the required data. field, item A field/item pair. There are up to 126 pairs of field names and item names that may be used to describe the required data. The pairs can be in any order. Examples The figure below displays the result returned by the GETPIVOTDATA function."
    },
   {
        "id": "Functions/growth.htm", 
        "title": "GROWTH Function", 
        "body": "The GROWTH function is one of the statistical functions. It is used to calculate predicted exponential growth by using existing data. Syntax GROWTH(known_y’s, [known_x’s], [new_x’s], [const]) The GROWTH function has the following arguments: Argument Description known_y’s The set of y-values you already know in the y = b*m^x equation. known_x’s The optional set of x-values you might know in the y = b*m^x equation. new_x’s The optional set of x-values you want y-values to be returned to. const An optional argument. It is a TRUE or FALSE value where TRUE or lack of the argument forces b to be calculated normally and FALSE sets b to 1 in the y = b*m^x equation. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the GROWTH function. Examples The figure below displays the result returned by the GROWTH function."
    },
   {
        "id": "Functions/harmean.htm", 
        "title": "HARMEAN Function", 
        "body": "The HARMEAN function is one of the statistical functions. It is used to calculate the harmonic mean of the argument list. Syntax HARMEAN(number1, [number2], ...) The HARMEAN function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to get the harmonic mean. Notes How to apply the HARMEAN function. Examples The figure below displays the result returned by the HARMEAN function."
    },
   {
        "id": "Functions/hex2bin.htm", 
        "title": "HEX2BIN Function", 
        "body": "The HEX2BIN function is one of the engineering functions. It is used to convert a hexadecimal number to a binary number. Syntax HEX2BIN(number, [places]) The HEX2BIN function has the following arguments: Argument Description number A hexadecimal number entered manually or included into the cell you make reference to. places The number of digits to display. If omitted, the function will use the minimum number. Notes If the argument is not recognised as a hexadecimal number, or contains more than 10 characters, or the resulting binary number requires more digits than you specified, or the specified places number is less than or equal to 0, the function will return the #NUM! error. How to apply the HEX2BIN function. Examples The figure below displays the result returned by the HEX2BIN function."
    },
   {
        "id": "Functions/hex2dec.htm", 
        "title": "HEX2DEC Function", 
        "body": "The HEX2DEC function is one of the engineering functions. It is used to convert a hexadecimal number into a decimal number. Syntax HEX2DEC(number) The HEX2DEC function has the following argument: Argument Description number A hexadecimal number entered manually or included into the cell you make reference to. Notes If the argument is not recognised as a hexadecimal number, or contains more than 10 characters, the function will return the #NUM! error. How to apply the HEX2DEC function. Examples The figure below displays the result returned by the HEX2DEC function."
    },
   {
        "id": "Functions/hex2oct.htm", 
        "title": "HEX2OCT Function", 
        "body": "The HEX2OCT function is one of the engineering functions. It is used to convert a hexadecimal number to an octal number. Syntax HEX2OCT(number, [places]) The HEX2OCT function has the following arguments: Argument Description number A hexadecimal number entered manually or included into the cell you make reference to. places The number of digits to display. If omitted, the function will use the minimum number. Notes If the argument is not recognised as a hexadecimal number, or contains more than 10 characters, or the resulting octal number requires more digits than you specified, or the specified places number is less than or equal to 0, the function will return the #NUM! error. How to apply the HEX2OCT function. Examples The figure below displays the result returned by the HEX2OCT function."
    },
   {
        "id": "Functions/hlookup.htm", 
        "title": "HLOOKUP Function", 
        "body": "The HLOOKUP function is one of the lookup and reference functions. It is used to perform the horizontal search for a value in the top row of a table or an array and return the value in the same column based on a specified row index number. Syntax HLOOKUP (lookup_value, table_array, row_index_num, [range_lookup]) The HLOOKUP function has the following arguments: Argument Description lookup_value A value to search for. table_array Two or more rows containing data sorted in ascending order. row_index_num A row number in the same column of the table_array, a numeric value greater than or equal to 1 but less than the number of rows in the table_array. range_lookup An optional argument. It is a logical value: TRUE or FALSE. Enter FALSE to find an exact match. Enter TRUE to find an approximate match, in this case if there is not a value that strictly matches the lookup_value, then the function will choose the next largest value less than the lookup_value. If this argument is absent, the function will find an approximate match. Notes If the range_lookup is set to FALSE, but no exact match is found, then the function will return the #N/A error. How to apply the HLOOKUP function. Examples The figure below displays the result returned by the HLOOKUP function."
    },
   {
        "id": "Functions/hour.htm", 
        "title": "HOUR Function", 
        "body": "The HOUR function is one of the date and time functions. It returns the hour (a number from 0 to 23) of the time value. Syntax HOUR(serial_number) The HOUR function has the following argument: Argument Description serial_number The time value that contains the hour you want to find. Notes The serial_number may be expressed as a string value (e.g. \"13:39\"), a decimal number (e.g. 0.56 corresponds to 13:26) , or the result of a formula (e.g. the result of the NOW function in the default format - 9/26/12 13:39) How to apply the HOUR function. Examples The figure below displays the result returned by the HOUR function."
    },
   {
        "id": "Functions/hstack.htm", 
        "title": "HSTACK Function", 
        "body": "The HSTACK function is one of the lookup and reference functions. It is used to horizontally stack arrays into one array. Syntax HSTACK (array1, [array2], ...) The HSTACK function has the following arguments: Argument Description array1/2/n Is used to set the arrays to append. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the HSTACK function. Examples The figure below displays the result returned by the HSTACK function."
    },
   {
        "id": "Functions/hyperlink.htm", 
        "title": "HYPERLINK Function", 
        "body": "The HYPERLINK function is one of the lookup and reference functions. It is used to create a shortcut that jumps to another location in the current workbook, or opens a document stored on a network server, an intranet, or the Internet. Syntax HYPERLINK(link_location, [friendly_name]) The HYPERLINK function has the following arguments: Argument Description link_location The path and file name to the document to be opened. In the online version, the path can be a URL address only. link_location can also refer to a certain place in the current workbook, for example, to a certain cell or a named range. The value can be specified as a text string enclosed to the quotation marks or a reference to a cell containing the link as a text string. friendly_name A text displayed in the cell. It is an optional argument. If it is omitted, the link_location value is displayed in the cell. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the HYPERLINK function. Examples The figure below displays the result returned by the HYPERLINK function. To open the link click on it. To select a cell that contains a link without opening the link click and hold the mouse button."
    },
   {
        "id": "Functions/hypgeom-dist.htm", 
        "title": "HYPGEOM.DIST Function", 
        "body": "The HYPGEOM.DIST function is one of the statistical functions. It is used to return the hypergeometric distribution, the probability of a given number of sample successes, given the sample size, population successes, and population size. Syntax HYPGEOM.DIST(sample_s, number_sample, population_s, number_pop, cumulative) The HYPGEOM.DIST function has the following arguments: Argument Description sample_s The number of the successes in the given sample, a numeric value greater than 0, but less than the lesser of number_sample or population_s. number_sample The size of the sample, a numeric value greater than 0, but less than number_pop. population_s The number of the successes in the population, a numeric value greater than 0, but less than number_pop. number_pop The size of the population, a numeric value greater than 0. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability mass function. Notes How to apply the HYPGEOM.DIST function. Examples The figure below displays the result returned by the HYPGEOM.DIST function."
    },
   {
        "id": "Functions/hypgeomdist.htm", 
        "title": "HYPGEOMDIST Function", 
        "body": "The HYPGEOMDIST function is one of the statistical functions. It is used to return the hypergeometric distribution, the probability of a given number of sample successes, given the sample size, population successes, and population size. Syntax HYPGEOMDIST(sample_s, number_sample, population_s, number_pop, cumulative) The HYPGEOMDIST function has the following arguments: Argument Description sample_s The number of the successes in the given sample, a numeric value greater than 0, but less than the lesser of number_sample or population_s. number_sample The size of the sample, a numeric value greater than 0, but less than number_pop. population_s The number of the successes in the population, a numeric value greater than 0, but less than number_pop. number_pop The size of the population, a numeric value greater than 0. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability mass function. Notes How to apply the HYPGEOMDIST function. Examples The figure below displays the result returned by the HYPGEOMDIST function."
    },
   {
        "id": "Functions/if.htm", 
        "title": "IF Function", 
        "body": "The IF function is one of the logical functions. Is used to check the logical expression and return one value if it is TRUE, or another if it is FALSE. Syntax IF(logical_test, value_if_true, [value_if_false]) The IF function has the following arguments: Argument Description logical_test The condition that you want to test. value_if_true The value to be returned if the result is TRUE. value_if_false The value to be returned if the result is FALSE. Notes How to apply the IF function. Examples There are three arguments: logical_test = A1&lt;100, value_if_true = 0, value_if_false = 1, where A1 is 12. This logical expression is TRUE. So the function returns 0. If we change the A1 value from 12 to 112, the function returns 1:"
    },
   {
        "id": "Functions/iferror.htm", 
        "title": "IFERROR Function", 
        "body": "The IFERROR function is one of the logical functions. It is used to check if there is an error in the formula in the first argument. The function returns the result of the formula if there is no error, or the value_if_error if there is one. Syntax IFERROR(value, value_if_error) The IFERROR function has the following arguments: Argument Description value The value that is checked for an error. value_if_error The value to be returned if the formula evaluates to an error. The following errors are evaluated: #N/A, #VALUE!, #REF!, #DIV/0!, #NUM!, #NAME?, #NULL!. Notes How to apply the IFERROR function. Examples You have a list of available item stock and its overall value. To learn unit price, we will use the IFERROR function to see if there are any errors. The arguments are as follows: value = B2/A2, value_if_error = \"Out of stock\". The formula in the first argument does not contain any errors for cells C2:C9 and C11:C14 so the function returns the result of the calculation. However, it is the opposite for C10 and C11 since the formula tries to divide by zero, hence, we get \"Out of stock\" as a result."
    },
   {
        "id": "Functions/ifna.htm", 
        "title": "IFNA Function", 
        "body": "The IFNA function is one of the logical functions. It is used to check if there is an error in the formula in the first argument. The function returns the value you specify if the formula returns the #N/A error value, otherwise returns the result of the formula. Syntax IFNA(value, value_if_na) The IFNA function has the following arguments: Argument Description value The argument that is checked for the #N/A error value. value_if_na The value to return if the formula evaluates to the #N/A error value. Notes How to apply the IFNA function. Examples The figure below displays the result returned by the IFNA function."
    },
   {
        "id": "Functions/ifs.htm", 
        "title": "IFS Function", 
        "body": "The IFS function is one of the logical functions. It checks whether one or more conditions are met and returns a value that corresponds to the first TRUE condition. Syntax IFS(logical_test1, value_if_true1, [logical_test2, value_if_true2], ...) The IFS function has the following arguments: Argument Description logical_test1 The first condition to be evaluated to TRUE or FALSE. value_if_true1 The value that returns if the logical_test1 is TRUE. logical_test2, value_if_true2, ... Additional conditions and values to return. These arguments are optional. You can check up to 127 conditions. Notes How to apply the IFS function. Examples There are the following arguments: logical_test1 = A1&lt;100, value_if_true1 = 1, logical_test2 = A1&gt;100, value_if_true2 = 2, where A1 is 120. The second logical expression is TRUE. So the function returns 2."
    },
   {
        "id": "Functions/imabs.htm", 
        "title": "IMABS Function", 
        "body": "The IMABS function is one of the engineering functions. It is used to return the absolute value of a complex number. Syntax IMABS(inumber) The IMABS function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMABS function. Examples The figure below displays the result returned by the IMABS function."
    },
   {
        "id": "Functions/imaginary.htm", 
        "title": "IMAGINARY Function", 
        "body": "The IMAGINARY function is one of the engineering functions. It is used to return the imaginary part of the specified complex number. Syntax IMAGINARY(inumber) The IMAGINARY function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMAGINARY function. Examples The figure below displays the result returned by the IMAGINARY function."
    },
   {
        "id": "Functions/imargument.htm", 
        "title": "IMARGUMENT Function", 
        "body": "The IMARGUMENT function is one of the engineering functions. It is used to return the argument Theta, an angle expressed in radians. Syntax IMARGUMENT(inumber) The IMARGUMENT function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMARGUMENT function. Examples The figure below displays the result returned by the IMARGUMENT function."
    },
   {
        "id": "Functions/imconjugate.htm", 
        "title": "IMCONJUGATE Function", 
        "body": "The IMCONJUGATE function is one of the engineering functions. It is used to return the complex conjugate of a complex number. Syntax IMCONJUGATE(inumber) The IMCONJUGATE function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMCONJUGATE function. Examples The figure below displays the result returned by the IMCONJUGATE function."
    },
   {
        "id": "Functions/imcos.htm", 
        "title": "IMCOS Function", 
        "body": "The IMCOS function is one of the engineering functions. It is used to return the cosine of a complex number. Syntax IMCOS(inumber) The IMCOS function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMCOS function. Examples The figure below displays the result returned by the IMCOS function."
    },
   {
        "id": "Functions/imcosh.htm", 
        "title": "IMCOSH Function", 
        "body": "The IMCOSH function is one of the engineering functions. It is used to return the hyperbolic cosine of a complex number. Syntax IMCOSH(inumber) The IMCOSH function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMCOSH function. Examples The figure below displays the result returned by the IMCOSH function."
    },
   {
        "id": "Functions/imcot.htm", 
        "title": "IMCOT Function", 
        "body": "The IMCOT function is one of the engineering functions. It is used to return the cotangent of a complex number. Syntax IMCOT(inumber) The IMCOT function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMCOT function. Examples The figure below displays the result returned by the IMCOT function."
    },
   {
        "id": "Functions/imcsc.htm", 
        "title": "IMCSC Function", 
        "body": "The IMCSC function is one of the engineering functions. It is used to return the cosecant of a complex number. Syntax IMCSC(inumber) The IMCSC function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMCSC function. Examples The figure below displays the result returned by the IMCSC function."
    },
   {
        "id": "Functions/imcsch.htm", 
        "title": "IMCSCH Function", 
        "body": "The IMCSCH function is one of the engineering functions. It is used to return the hyperbolic cosecant of a complex number. Syntax IMCSCH(inumber) The IMCSCH function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMCSCH function. Examples The figure below displays the result returned by the IMCSCH function."
    },
   {
        "id": "Functions/imdiv.htm", 
        "title": "IMDIV Function", 
        "body": "The IMDIV function is one of the engineering functions. It is used to return the quotient of two complex numbers expressed in x + yi or x + yj form. Syntax IMDIV(inumber1, inumber2) The IMDIV function has the following arguments: Argument Description inumber1 A dividend. inumber2 A divisor. Notes How to apply the IMDIV function. Examples The figure below displays the result returned by the IMDIV function."
    },
   {
        "id": "Functions/imexp.htm", 
        "title": "IMEXP Function", 
        "body": "The IMEXP function is one of the engineering functions. It is used to return the e constant raised to the to the power specified by a complex number. The e constant is equal to 2,71828182845904. Syntax IMEXP(inumber) The IMEXP function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMEXP function. Examples The figure below displays the result returned by the IMEXP function."
    },
   {
        "id": "Functions/imln.htm", 
        "title": "IMLN Function", 
        "body": "The IMLN function is one of the engineering functions. It is used to return the natural logarithm of a complex number. Syntax IMLN(inumber) The IMLN function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMLN function. Examples The figure below displays the result returned by the IMLN function."
    },
   {
        "id": "Functions/imlog10.htm", 
        "title": "IMLOG10 Function", 
        "body": "The IMLOG10 function is one of the engineering functions. It is used to return the logarithm of a complex number to a base of 10. Syntax IMLOG10(inumber) The IMLOG10 function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMLOG10 function. Examples The figure below displays the result returned by the IMLOG10 function."
    },
   {
        "id": "Functions/imlog2.htm", 
        "title": "IMLOG2 Function", 
        "body": "The IMLOG2 function is one of the engineering functions. It is used to return the logarithm of a complex number to a base of 2. Syntax IMLOG2(inumber) The IMLOG2 function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMLOG2 function. Examples The figure below displays the result returned by the IMLOG2 function."
    },
   {
        "id": "Functions/importrange.htm", 
        "title": "IMPORTRANGE Function", 
        "body": "The IMPORTRANGE function is one of the text and data functions. It is used to import a range of cells from a specified spreadsheet. Syntax IMPORTRANGE(\"spreadsheet_url\", \"range_string\") The IMPORTRANGE function has the following arguments: Argument Description spreadsheet_url Is used to specify the URL of the spreadsheet the data is imported from. range_string A string specifying the range to import. Examples The figure below displays the result returned by the IMPORTRANGE function."
    },
   {
        "id": "Functions/impower.htm", 
        "title": "IMPOWER Function", 
        "body": "The IMPOWER function is one of the engineering functions. It is used to return the result of a complex number raised to the desired power. Syntax IMPOWER(inumber, number) The IMPOWER function has the following arguments: Argument Description inumber A complex number expressed in x + yi or x + yj form. number A power you wish to raise the complex number to. Notes How to apply the IMPOWER function. Examples The figure below displays the result returned by the IMPOWER function."
    },
   {
        "id": "Functions/improduct.htm", 
        "title": "IMPRODUCT Function", 
        "body": "The IMPRODUCT function is one of the engineering functions. It is used to return the product of the specified complex numbers. Syntax IMPRODUCT(inumber1, [inumber2], ...) The IMPRODUCT function has the following arguments: Argument Description inumber1/2/n Up to 255 complex numbers expressed in x + yi or x + yj form. Notes How to apply the IMPRODUCT function. Examples The figure below displays the result returned by the IMPRODUCT function."
    },
   {
        "id": "Functions/imreal.htm", 
        "title": "IMREAL Function", 
        "body": "The IMREAL function is one of the engineering functions. It is used to return the real part of the specified complex number. Syntax IMREAL(inumber) The IMREAL function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMREAL function. Examples The figure below displays the result returned by the IMREAL function."
    },
   {
        "id": "Functions/imsec.htm", 
        "title": "IMSEC Function", 
        "body": "The IMSEC function is one of the engineering functions. It is used to return the secant of a complex number. Syntax IMSEC(inumber) The IMSEC function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMSEC function. Examples The figure below displays the result returned by the IMSEC function."
    },
   {
        "id": "Functions/imsech.htm", 
        "title": "IMSECH Function", 
        "body": "The IMSECH function is one of the engineering functions. It is used to return the hyperbolic secant of a complex number. Syntax IMSECH(inumber) The IMSECH function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMSECH function. Examples The figure below displays the result returned by the IMSECH function."
    },
   {
        "id": "Functions/imsin.htm", 
        "title": "IMSIN Function", 
        "body": "The IMSIN function is one of the engineering functions. It is used to return the sine of a complex number. Syntax IMSIN(inumber) The IMSIN function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMSIN function. Examples The figure below displays the result returned by the IMSIN function."
    },
   {
        "id": "Functions/imsinh.htm", 
        "title": "IMSINH Function", 
        "body": "The IMSINH function is one of the engineering functions. It is used to return the hyperbolic sine of a complex number. Syntax IMSINH(inumber) The IMSINH function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMSINH function. Examples The figure below displays the result returned by the IMSINH function."
    },
   {
        "id": "Functions/imsqrt.htm", 
        "title": "IMSQRT Function", 
        "body": "The IMSQRT function is one of the engineering functions. It is used to return the square root of a complex number. Syntax IMSQRT(inumber) The IMSQRT function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMSQRT function. Examples The figure below displays the result returned by the IMSQRT function."
    },
   {
        "id": "Functions/imsub.htm", 
        "title": "IMSUB Function", 
        "body": "The IMSUB function is one of the engineering functions. It is used to return the difference of two complex numbers expressed in x + yi or x + yj form. Syntax IMSUB(inumber1, inumber2) The IMSUB function has the following arguments: Argument Description inumber1 A complex number from which inumber2 is to be subtracted. inumber2 A complex number to subtract from inumber1. Notes How to apply the IMSUB function. Examples The figure below displays the result returned by the IMSUB function."
    },
   {
        "id": "Functions/imsum.htm", 
        "title": "IMSUM Function", 
        "body": "The IMSUM function is one of the engineering functions. It is used to return the sum of the specified complex numbers. Syntax IMSUM(inumber1, [inumber2], ...) The IMSUM function has the following arguments: Argument Description inumber1/2/n Up to 255 complex numbers expressed in x + yi or x + yj form. Notes How to apply the IMSUM function. Examples The figure below displays the result returned by the IMSUM function."
    },
   {
        "id": "Functions/imtan.htm", 
        "title": "IMTAN Function", 
        "body": "The IMTAN function is one of the engineering functions. It is used to return the tangent of a complex number. Syntax IMTAN(inumber) The IMTAN function has the following argument: Argument Description inumber A complex number expressed in x + yi or x + yj form. Notes How to apply the IMTAN function. Examples The figure below displays the result returned by the IMTAN function."
    },
   {
        "id": "Functions/index.htm", 
        "title": "INDEX Function", 
        "body": "The INDEX function is one of the lookup and reference functions. It is used to return a value within a range of cells on the base of a specified row and column number. The INDEX function has two forms. The INDEX function syntax in the array form is: INDEX(array, row_num, [column_num]) The INDEX function has the following arguments: Argument Description array A range of cells. row_num A row number you wish to return a value from. If it is omitted, column_num is required. column_num A column number you wish to return a value from. If it is omitted, row_num is required. The INDEX function syntax in the reference form is: INDEX(reference, row_num, [column_num], [area_num]) The INDEX function has the following arguments: Argument Description reference A reference to a range of cells. row_num A row number you wish to return a value from. If it is omitted, column_num is required. column_num A column number you wish to return a value from. If it is omitted, row_num is required. area_num An area to use in case the array contains several ranges. It is an optional argument. If it is omitted, the function will assume area_num to be 1. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the INDEX function. Examples The figure below displays the result returned by the INDEX function."
    },
   {
        "id": "Functions/indirect.htm", 
        "title": "INDIRECT Function", 
        "body": "The INDIRECT function is one of the lookup and reference functions. It is used to return the reference to a cell based on its string representation. Syntax INDIRECT(ref_text, [a1]) The INDIRECT function has the following arguments: Argument Description ref_text A reference to a cell specified as a text strin. a1 A representation style. It is an optional logical value: TRUE or FALSE. If it is set to TRUE or omitted, the function will analyse ref_text as an A1-style reference. If FALSE, the function will interpret ref_text as an R1C1-style reference. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the INDIRECT function. Examples The figure below displays the result returned by the INDIRECT function."
    },
   {
        "id": "Functions/int.htm", 
        "title": "INT Function", 
        "body": "The INT function is one of the math and trigonometry functions. It is used to analyze and return the integer part of the specified number. Syntax INT(number) The INT function has the following argument: Argument Description number A numeric value for which you want to get the integer part. Notes If the number value is negative, the function returns the first negative number that is less than or equal to the selected one. How to apply the INT function. Examples The figure below displays the result returned by the INT function."
    },
   {
        "id": "Functions/intercept.htm", 
        "title": "INTERCEPT Function", 
        "body": "The INTERCEPT function is one of the statistical functions. It is used to analyze the first array values and second array values to calculate the intersection point. Syntax INTERCEPT(known_y's, known_x's) The INTERCEPT function has the following arguments: Argument Description known_y's The dependent data range. known_x's The independent data range with the same number of elements as known_y's contains. Notes If known_y's or known_x's contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the INTERCEPT function. Examples The figure below displays the result returned by the INTERCEPT function."
    },
   {
        "id": "Functions/intrate.htm", 
        "title": "INTRATE Function", 
        "body": "The INTRATE function is one of the financial functions. It is used to calculate the interest rate for a fully invested security that pays interest only at maturity. Syntax INTRATE(settlement, maturity, investment, redemption, [basis]) The INTRATE function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. investment The amount paid for the security. redemption The amount received for the security at maturity. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the INTRATE function. Examples The figure below displays the result returned by the INTRATE function."
    },
   {
        "id": "Functions/ipmt.htm", 
        "title": "IPMT Function", 
        "body": "The IPMT function is one of the financial functions. It is used to calculate the interest payment for an investment based on a specified interest rate and a constant payment schedule. Syntax IPMT(rate, per, nper, pv, [fv], [type]) The IPMT function has the following arguments: Argument Description rate The interest rate for the investment. per The period you want to find the interest payment for. The value must be from 1 to nper. nper A number of payments. pv A present value of the payments. fv A future value (i.e. a cash balance remaining after the last payment is made). It is an optional argument. If it is omitted, the function will assume fv to be 0. type A period when the payments are due. It is an optional argument. If it is set to 0 or omitted, the function will assume the payments to be due at the end of the period. If type is set to 1, the payments are due at the beginning of the period. Notes Cash paid out (such as deposits to savings) is represented by negative numbers; cash received (such as dividend checks) is represented by positive numbers. Units for rate and nper must be consistent: use N%/12 for rate and N*12 for nper in case of monthly payments, N%/4 for rate and N*4 for nper in case of quarterly payments, N% for rate and N for nper in case of annual payments. How to apply the IPMT function. Examples The figure below displays the result returned by the IPMT function."
    },
   {
        "id": "Functions/irr.htm", 
        "title": "IRR Function", 
        "body": "The IRR function is one of the financial functions. It is used to calculate the internal rate of return for a series of periodic cash flows. Syntax IRR(values, [guess]) The IRR function has the following arguments: Argument Description values An array that contains the series of payments occuring at regular periods. At least one of the values must be negative and at least one positive. guess An estimate at what the internal rate of return will be. It is an optional argument. If it is omitted, the function will assume guess to be 10%. Notes How to apply the IRR function. Examples The figure below displays the result returned by the IRR function."
    },
   {
        "id": "Functions/isblank.htm", 
        "title": "ISBLANK Function", 
        "body": "The ISBLANK function is one of the information functions. It is used to check if the cell is empty or not. If the cell does not contain any value, the function returns TRUE, otherwise the function returns FALSE. Syntax ISBLANK(value) The ISBLANK function has the following argument: Argument Description value The value that you want to test. The value can be an empty cell, error, logical value, text, number, reference value, or a name referring to any of these. Notes How to apply the ISBLANK function. Examples The figure below displays the result returned by the ISBLANK function."
    },
   {
        "id": "Functions/iserr.htm", 
        "title": "ISERR Function", 
        "body": "The ISERR function is one of the information functions. It is used to check for an error value. If the cell contains an error value (except #N/A), the function returns TRUE, otherwise the function returns FALSE. Syntax ISERR(value) The ISERR function has the following argument: Argument Description value The value that you want to test. The value can be an empty cell, error, logical value, text, number, reference value, or a name referring to any of these. Notes How to apply the ISERR function. Examples The figure below displays the result returned by the ISERR function."
    },
   {
        "id": "Functions/iserror.htm", 
        "title": "ISERROR Function", 
        "body": "The ISERROR function is one of the information functions. It is used to check for an error value. If the cell contains one of the error values: #N/A, #VALUE!, #REF!, #DIV/0!, #NUM!, #NAME? or #NULL!, the function returns TRUE, otherwise the function returns FALSE. Syntax ISERROR(value) The ISERROR function has the following argument: Argument Description value The value that you want to test. The value can be an empty cell, error, logical value, text, number, reference value, or a name referring to any of these. Notes How to apply the ISERROR function. Examples The figure below displays the result returned by the ISERROR function."
    },
   {
        "id": "Functions/iseven.htm", 
        "title": "ISEVEN Function", 
        "body": "The ISEVEN function is one of the information functions. It is used to check for an even value. If the cell contains an even value, the function returns TRUE. If the value is odd, it returns FALSE. Syntax ISEVEN(number) The ISEVEN function has the following argument: Argument Description number The numeric value that you want to test. Notes If number is a nonnumeric value, ISEVEN returns the #VALUE! error value. If number is not an integer, it is truncated. How to apply the ISEVEN function. Examples The figure below displays the result returned by the ISEVEN function."
    },
   {
        "id": "Functions/isformula.htm", 
        "title": "ISFORMULA Function", 
        "body": "The ISFORMULA function is one of the information functions. It is used to check whether there is a reference to a cell that contains a formula. If the cell contains a formula, the function returns TRUE, otherwise the function returns FALSE. Syntax ISFORMULA(reference) The ISFORMULA function has the following argument: Argument Description reference A reference to a cell that you want to test. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the ISFORMULA function. Examples The figure below displays the result returned by the ISFORMULA function."
    },
   {
        "id": "Functions/islogical.htm", 
        "title": "ISLOGICAL Function", 
        "body": "The ISLOGICAL function is one of the information functions. It is used to check for a logical value (TRUE or FALSE). If the cell contains a logical value, the function returns TRUE, otherwise the function returns FALSE. Syntax ISLOGICAL(value) The ISLOGICAL function has the following argument: Argument Description value The value that you want to test. The value can be an empty cell, error, logical value, text, number, reference value, or a name referring to any of these. Notes How to apply the ISLOGICAL function. Examples The figure below displays the result returned by the ISLOGICAL function."
    },
   {
        "id": "Functions/isna.htm", 
        "title": "ISNA Function", 
        "body": "The ISNA function is one of the information functions. It is used to check for a #N/A error. If the cell contains a #N/A error value, the function returns TRUE, otherwise the function returns FALSE. Syntax ISNA(value) The ISNA function has the following argument: Argument Description value The value that you want to test. The value can be an empty cell, error, logical value, text, number, reference value, or a name referring to any of these. Notes How to apply the ISNA function. Examples The figure below displays the result returned by the ISNA function."
    },
   {
        "id": "Functions/isnontext.htm", 
        "title": "ISNONTEXT Function", 
        "body": "The ISNONTEXT function is one of the information functions. It is used to check for a value that is not a text. If the cell does not contain a text value, the function returns TRUE, otherwise the function returns FALSE. Syntax ISNONTEXT(value) The ISNONTEXT function has the following argument: Argument Description value The value that you want to test. The value can be an empty cell, error, logical value, text, number, reference value, or a name referring to any of these. Notes How to apply the ISNONTEXT function. Examples The figure below displays the result returned by the ISNONTEXT function."
    },
   {
        "id": "Functions/isnumber.htm", 
        "title": "ISNUMBER Function", 
        "body": "The ISNUMBER function is one of the information functions. It is used to check for a numeric value. If the cell contains a numeric value, the function returns TRUE, otherwise the function returns FALSE. Syntax ISNUMBER(value) The ISNUMBER function has the following argument: Argument Description value The value that you want to test. The value can be an empty cell, error, logical value, text, number, reference value, or a name referring to any of these. Notes How to apply the ISNUMBER function. Examples The figure below displays the result returned by the ISNUMBER function."
    },
   {
        "id": "Functions/iso-ceiling.htm", 
        "title": "ISO.CEILING Function", 
        "body": "The ISO.CEILING function is one of the math and trigonometry functions. It is used to return a number that is rounded up to the nearest integer or to the nearest multiple of significance. The number is always rounded up regardless of its sing. Syntax ISO.CEILING(number, [significance]) The ISO.CEILING function has the following arguments: Argument Description number The number you wish to round up. significance The multiple of significance you wish to round up to. It is an optional parameter. If it is omitted, the default value of 1 is used. If it is set to zero, the function returns 0. Notes How to apply the ISO.CEILING function. Examples The figure below displays the result returned by the ISO.CEILING function."
    },
   {
        "id": "Functions/isodd.htm", 
        "title": "ISODD Function", 
        "body": "The ISODD function is one of the information functions. It is used to check for an odd value. If the cell contains an odd value, the function returns TRUE. If the value is even, it returns FALSE. Syntax ISODD(number) The ISODD function has the following argument: Argument Description number The numeric value that you want to test. Notes If number is a nonnumeric value, ISODD returns the #VALUE! error value. If number is not an integer, it is truncated. How to apply the ISODD function. Examples The figure below displays the result returned by the ISODD function."
    },
   {
        "id": "Functions/isoweeknum.htm", 
        "title": "ISOWEEKNUM Function", 
        "body": "The ISOWEEKNUM function is one of the date and time functions. It used to return number of the ISO week number of the year for a given date. Returns a number between 1 and 54. Syntax ISOWEEKNUM(date) The ISOWEEKNUM function has the following argument: Argument Description date A date you want to find the ISO week number of. Can be a reference to a cell containing a date or a date returned by the DATE function or other date and time function. Notes How to apply the ISOWEEKNUM function. Examples The figure below displays the result returned by the ISOWEEKNUM function."
    },
   {
        "id": "Functions/ispmt.htm", 
        "title": "ISPMT Function", 
        "body": "The ISPMT function is one of the financial functions. It is used to calculate the interest payment for a specified period of an investment based on a constant payment schedule. Syntax ISPMT(rate, per, nper, pv) The ISPMT function has the following arguments: Argument Description rate The interest rate for the investment. per The period you want to find the interest payment for. The value must be from 1 to nper. nper A number of payments. pv A present value of the payments. Notes Cash paid out (such as deposits to savings) is represented by negative numbers; cash received (such as dividend checks) is represented by positive numbers. Units for rate and nper must be consistent: use N%/12 for rate and N*12 for nper in case of monthly payments, N%/4 for rate and N*4 for nper in case of quarterly payments, N% for rate and N for nper in case of annual payments. How to apply the ISPMT function. Examples The figure below displays the result returned by the ISPMT function."
    },
   {
        "id": "Functions/isref.htm", 
        "title": "ISREF Function", 
        "body": "The ISREF function is one of the information functions. It is used to verify if the value is a valid cell reference. Syntax ISREF(value) The ISREF function has the following argument: Argument Description value The value that you want to test. The value can be an empty cell, error, logical value, text, number, reference value, or a name referring to any of these. Notes How to apply the ISREF function. Examples If the value is a valid reference, the function returns TRUE. Otherwise the function returns FALSE."
    },
   {
        "id": "Functions/istext.htm", 
        "title": "ISTEXT Function", 
        "body": "The ISTEXT function is one of the information functions. It is used to check for a text value. If the cell contains a text value, the function returns TRUE, otherwise the function returns FALSE. Syntax ISTEXT(value) The ISTEXT function has the following argument: Argument Description value The value that you want to test. The value can be an empty cell, error, logical value, text, number, reference value, or a name referring to any of these. Notes How to apply the ISTEXT function. Examples The figure below displays the result returned by the ISTEXT function."
    },
   {
        "id": "Functions/kurt.htm", 
        "title": "KURT Function", 
        "body": "The KURT function is one of the statistical functions. It is used to return the kurtosis of the argument list. Syntax KURT(number1, [number2], ...) The KURT function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate kurtosis. Notes How to apply the KURT function. Examples The figure below displays the result returned by the KURT function."
    },
   {
        "id": "Functions/large.htm", 
        "title": "LARGE Function", 
        "body": "The LARGE function is one of the statistical functions. It is used to analyze the range of cells and return the k-th largest value. Syntax LARGE(array, k) The LARGE function has the following arguments: Argument Description array The selected range of cells you want to analyze. k The position of the number from the largest one, a numeric value greater than 0. Notes How to apply the LARGE function. Examples The figure below displays the result returned by the LARGE function."
    },
   {
        "id": "Functions/lcm.htm", 
        "title": "LCM Function", 
        "body": "The LCM function is one of the math and trigonometry functions. It is used to return the lowest common multiple of one or more numbers. Syntax LCM(number1, [number2], ...) The LCM function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to find the lowest common multiple. Notes How to apply the LCM function. Examples The figure below displays the result returned by the LCM function."
    },
   {
        "id": "Functions/left.htm", 
        "title": "LEFT/LEFTB Function", 
        "body": "The LEFT/LEFTB function is one of the text and data functions. Is used to extract the substring from the specified string starting from the left character. The LEFT function is intended for languages that use the single-byte character set (SBCS), while LEFTB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax LEFT(text, [num_chars]) The LEFT function has the following arguments: Argument Description text A string you need to extract the substring from. num_chars A number of the substring characters. It must be greater than or equal to 0. It is an optional argument. If it is omitted, the function will assume it to be 1. LEFTB(text, [num_bytes]) The LEFTB function has the following arguments: Argument Description text A string you need to extract the substring from. num_bytes A number of the substring characters, based on bytes. It is an optional argument. Notes How to apply the LEFT/LEFTB function. Examples The figure below displays the result returned by the LEFT function."
    },
   {
        "id": "Functions/leftb.htm", 
        "title": "LEFT/LEFTB Function", 
        "body": "The LEFT/LEFTB function is one of the text and data functions. Is used to extract the substring from the specified string starting from the left character. The LEFT function is intended for languages that use the single-byte character set (SBCS), while LEFTB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax LEFT(text, [num_chars]) The LEFT function has the following arguments: Argument Description text A string you need to extract the substring from. num_chars A number of the substring characters. It must be greater than or equal to 0. It is an optional argument. If it is omitted, the function will assume it to be 1. LEFTB(text, [num_bytes]) The LEFTB function has the following arguments: Argument Description text A string you need to extract the substring from. num_bytes A number of the substring characters, based on bytes. It is an optional argument. Notes How to apply the LEFT/LEFTB function. Examples The figure below displays the result returned by the LEFT function."
    },
   {
        "id": "Functions/len.htm", 
        "title": "LEN/LENB Function", 
        "body": "The LEN/LENB function is one of the text and data functions. Is used to analyse the specified string and return the number of characters it contains. The LEN function is intended for languages that use the single-byte character set (SBCS), while LENB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax LEN(text) LENB(text) The LEN/LENB function has the following argument: Argument Description text The text whose length you want to find. Notes How to apply the LEN/LENB function. Examples The figure below displays the result returned by the LEN function."
    },
   {
        "id": "Functions/lenb.htm", 
        "title": "LEN/LENB Function", 
        "body": "The LEN/LENB function is one of the text and data functions. Is used to analyse the specified string and return the number of characters it contains. The LEN function is intended for languages that use the single-byte character set (SBCS), while LENB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax LEN(text) LENB(text) The LEN/LENB function has the following argument: Argument Description text The text whose length you want to find. Notes How to apply the LEN/LENB function. Examples The figure below displays the result returned by the LEN function."
    },
   {
        "id": "Functions/linest.htm", 
        "title": "LINEST Function", 
        "body": "The LINEST function is one of the statistical functions. It is used to calculate the statistics for a line by using the least squares method to calculate a straight line that best fits your data, and then returns an array that describes the line; because this function returns an array of values, it must be entered as an array formula. Syntax LINEST(known_y's, [known_x's], [const], [stats]) The LINEST function has the following argument: Argument Description known_y's A known range of y values in the equation y = mx + b. This is the required argument. known_x's A known range of x values in the equation y = mx + b. This is an optional argument. If it is omitted, known_x's is assumed to be the array {1,2,3,...} with the same number of values as known_y's. const A logical value that specifies if you want to set b equal to 0. This is an optional argument. If it is set to TRUE or omitted, b is calculated normally. If it is set to FALSE, b is set equal to 0. stats A logical value that specifies if you want to return additional regression statistics. This is an optional argument. If it is set to TRUE, the function returns the additional regression statistics. If it is set to FALSE or omitted, the function does not return the additional regression statistics. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the LINEST function. Examples The first value of the resulting array will be displayed in the selected cell."
    },
   {
        "id": "Functions/ln.htm", 
        "title": "LN Function", 
        "body": "The LN function is one of the math and trigonometry functions. It is used to return the natural logarithm of a number. Syntax LN(number) The LN function has the following argument: Argument Description number A numeric value for which you want to get the natural logarithm. It must be greater than 0. Notes How to apply the LN function. Examples The figure below displays the result returned by the LN function."
    },
   {
        "id": "Functions/log.htm", 
        "title": "LOG Function", 
        "body": "The LOG function is one of the math and trigonometry functions. It is used to return the logarithm of a number to a specified base. Syntax LOG(number, [base]) The LOG function has the following arguments: Argument Description number A numeric value for which you want to get the logarithm. It must be greater than 0. base The base used to calculate the logarithm of a number. It is an optional parameter. If it is omitted, the function will assume base to be 10. Notes How to apply the LOG function. Examples The figure below displays the result returned by the LOG function."
    },
   {
        "id": "Functions/log10.htm", 
        "title": "LOG10 Function", 
        "body": "The LOG10 function is one of the math and trigonometry functions. It is used to return the logarithm of a number to a base of 10. Syntax LOG10(number) The LOG10 function has the following argument: Argument Description number A numeric value for which you want to get the logarithm to a base of 10. It must be greater than 0. Notes How to apply the LOG10 function. Examples The figure below displays the result returned by the LOG10 function."
    },
   {
        "id": "Functions/logest.htm", 
        "title": "LOGEST Function", 
        "body": "The LOGEST function is one of the statistical functions. It is used to calculate an exponential curve that fits the data and returns an array of values that describes the curve. Syntax LOGEST(known_y’s, [known_x’s], [const], [stats]) The LOGEST function has the following arguments: Argument Description known_y’s The set of y-values you already know in the y = b*m^x equation. known_x’s The optional set of x-values you might know in the y = b*m^x equation. const An optional argument. It is a TRUE or FALSE value where TRUE or lack of the argument forces b to be calculated normally and FALSE sets b to 1 in the y = b*m^x equation and m-values correspond with the y = m^x equation. stats An optional argument. It is a TRUE or FALSE value that sets whether additional regression statistics should be returned. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the LOGEST function. Examples The figure below displays the result returned by the LOGEST function."
    },
   {
        "id": "Functions/loginv.htm", 
        "title": "LOGINV Function", 
        "body": "The LOGINV function is one of the statistical functions. It is used to return the inverse of the lognormal cumulative distribution function of the given x value with the specified parameters. Syntax LOGINV(probability, mean, standard_dev) The LOGINV function has the following arguments: Argument Description probability The probability associated with the lognormal distribution, a numeric value greater than 0 but less than 1. mean The mean of ln(x), a numeric value. standard_dev The standard deviation of ln(x), a numeric value greater than 0. Notes How to apply the LOGINV function. Examples The figure below displays the result returned by the LOGINV function."
    },
   {
        "id": "Functions/lognorm-dist.htm", 
        "title": "LOGNORM.DIST Function", 
        "body": "The LOGNORM.DIST function is one of the statistical functions. It is used to return the lognormal distribution of x, where ln(x) is normally distributed with parameters mean and standard_dev. Syntax LOGNORM.DIST(x, mean, standard_dev, cumulative) The LOGNORM.DIST function has the following arguments: Argument Description x The value at which the function should be calculated. A numeric value greater than 0. mean The mean of ln(x), a numeric value. standard_dev The standard deviation of ln(x), a numeric value greater than 0. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability density function. Notes How to apply the LOGNORM.DIST function. Examples The figure below displays the result returned by the LOGNORM.DIST function."
    },
   {
        "id": "Functions/lognorm-inv.htm", 
        "title": "LOGNORM.INV Function", 
        "body": "The LOGNORM.INV function is one of the statistical functions. It is used to return the inverse of the lognormal cumulative distribution function of x, where ln(x) is normally distributed with parameters mean and standard_dev. Syntax LOGNORM.INV(probability, mean, standard_dev) The LOGNORM.INV function has the following arguments: Argument Description probability The probability associated with the lognormal distribution, a numeric value greater than 0 but less than 1. mean The mean of ln(x), a numeric value. standard_dev The standard deviation of ln(x), a numeric value greater than 0. Notes How to apply the LOGNORM.INV function. Examples The figure below displays the result returned by the LOGNORM.INV function."
    },
   {
        "id": "Functions/lognormdist.htm", 
        "title": "LOGNORMDIST Function", 
        "body": "The LOGNORMDIST function is one of the statistical functions. It is used to analyze logarithmically transformed data and return the lognormal cumulative distribution function of the given x value with the specified parameters. Syntax LOGNORMDIST(x, mean, standard_dev) The LOGNORMDIST function has the following arguments: Argument Description x The value at which the function should be calculated. A numeric value greater than 0. mean The mean of ln(x), a numeric value. standard_dev The standard deviation of ln(x), a numeric value greater than 0. Notes How to apply the LOGNORMDIST function. Examples The figure below displays the result returned by the LOGNORMDIST function."
    },
   {
        "id": "Functions/lookup.htm", 
        "title": "LOOKUP Function", 
        "body": "The LOOKUP function is one of the lookup and reference functions. It is used to return a value from a selected range (row or column containing the data in ascending order). Syntax LOOKUP(lookup_value, lookup_vector, [result_vector]) The LOOKUP function has the following arguments: Argument Description lookup_value A value to search for. lookup_vector A single row or column containing data sorted in ascending order. result_vector A single row or column of data that is the same size as the lookup_vector. Notes The function searches for the lookup_value in the lookup_vector and returns the value from the same position in the result_vector. If the lookup_value is smaller than all of the values in the lookup_vector, the function will return the #N/A error. If there is not a value that strictly matches the lookup_value, the function chooses the largest value in the lookup_vector that is less than or equal to the value. How to apply the LOOKUP function. Examples The figure below displays the result returned by the LOOKUP function."
    },
   {
        "id": "Functions/lower.htm", 
        "title": "LOWER Function", 
        "body": "The LOWER function is one of the text and data functions. Is used to convert uppercase letters to lowercase in the selected cell. Syntax LOWER(text) The LOWER function has the following argument: Argument Description text The text you want to convert to lowercase. Notes How to apply the LOWER function. Examples The figure below displays the result returned by the LOWER function."
    },
   {
        "id": "Functions/match.htm", 
        "title": "MATCH Function", 
        "body": "The MATCH function is one of the lookup and reference functions. It is used to return a relative position of a specified item in a range of cells. Syntax MATCH(lookup_value, lookup_array, [match_type]) The MATCH function has the following arguments: Argument Description lookup_value A value in the lookup_array to search for. It can be a numeric, logical or text value, or a cell reference. lookup_array A single row or column you need to analyze. match_type A type of match. It's an optional argument. The possible values are listed in the table below. The match_type argument can be one of the following: Numeric value Meaning 1 or omitted The values must be sorted in ascending order. If the exact match is not found, the function will return the largest value that is less than lookup_value. 0 The values can be sorted in any order. If the exact match is not found, the function will return the #N/A error. -1 The values must be sorted in descending order. If the exact match is not found, the function will return the smallest value that is greater than lookup_value. Notes How to apply the MATCH function. Examples The figure below displays the result returned by the MATCH function."
    },
   {
        "id": "Functions/max.htm", 
        "title": "MAX Function", 
        "body": "The MAX function is one of the statistical functions. It is used to analyze the range of data and find the largest number. Syntax MAX(number1, [number2], ...) The MAX function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to find the largest number. Notes How to apply the MAX function. Examples The figure below displays the result returned by the MAX function."
    },
   {
        "id": "Functions/maxa.htm", 
        "title": "MAXA Function", 
        "body": "The MAXA function is one of the statistical functions. It is used to analyze the range of data and find the largest value. Syntax MAXA(value1, [value2], ...) The MAXA function has the following arguments: Argument Description value1/2/n Up to 255 values (number, text, logical value) for which you want to find the largest value. Notes How to apply the MAXA function. Examples The figure below displays the result returned by the MAXA function."
    },
   {
        "id": "Functions/maxifs.htm", 
        "title": "MAXIFS Function", 
        "body": "The MAXIFS function is one of the statistical functions. It is used to return the maximum value among cells specified by a given set of conditions or criteria. Syntax MAXIFS(max_range, criteria_range1, criteria1, [criteria_range2, criteria2], ...) The MAXIFS function has the following arguments: Argument Description max_range The range of cells in which the maximum will be determined. criteria_range1 The first selected range of cells to apply the criteria1 to. criteria1 The first condition that must be met. It is applied to the criteria_range1 and used to determine which cells in the max_range will be evaluated as maximum. criteria_range2, criteria2 Additional ranges of cells and their corresponding criteria. These arguments are optional. Notes You can use wildcard characters when specifying criteria. The question mark \"?\" can replace any single character and the asterisk \"*\" can be used instead of any number of characters. How to apply the MAXIFS function. Examples The figure below displays the result returned by the MAXIFS function."
    },
   {
        "id": "Functions/mdeterm.htm", 
        "title": "MDETERM Function", 
        "body": "The MDETERM function is one of the math and trigonometry functions. It is used to return the matrix determinant of an array. Syntax MDETERM(array) The MDETERM function has the following argument: Argument Description array An array of numbers. Notes If any of the cells in the array contain empty or non-numeric values, the function will return the #N/A error. If the number of rows in the array is not the same as the number of columns, the function will return the #VALUE! error. How to apply the MDETERM function. Examples The figure below displays the result returned by the MDETERM function."
    },
   {
        "id": "Functions/mduration.htm", 
        "title": "MDURATION Function", 
        "body": "The MDURATION function is one of the financial functions. It is used to calculate the modified Macaulay duration of a security with an assumed par value of $100. Syntax MDURATION(settlement, maturity, coupon, yld, frequency, [basis]) The MDURATION function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. coupon The annual coupon rate of the security. yld The annual yield of the security. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the MDURATION function. Examples The figure below displays the result returned by the MDURATION function."
    },
   {
        "id": "Functions/median.htm", 
        "title": "MEDIAN Function", 
        "body": "The MEDIAN function is one of the statistical functions. It is used to calculate the median of the argument list. Syntax MEDIAN(number1, [number2], ...) The MEDIAN function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate the median. Notes How to apply the MEDIAN function. Examples The figure below displays the result returned by the MEDIAN function."
    },
   {
        "id": "Functions/mid.htm", 
        "title": "MID/MIDB Function", 
        "body": "The MID/MIDB function is one of the text and data functions. Is used to extract the characters from the specified string starting from any position. The MID function is intended for languages that use the single-byte character set (SBCS), while MIDB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax MID(text, start_num, num_chars) The MID function has the following arguments: Argument Description text A string you need to extract the characters from. start_num A position you need to start extracting from. num_chars A number of the characters you need to extract. MIDB(text, start_num, num_bytes) The MIDB function has the following arguments: Argument Description text A string you need to extract the characters from. start_num A position you need to start extracting from. num_bytes A number of the characters you need to extract, based on bytes. Notes How to apply the MID/MIDB function. Examples The figure below displays the result returned by the MID function."
    },
   {
        "id": "Functions/midb.htm", 
        "title": "MID/MIDB Function", 
        "body": "The MID/MIDB function is one of the text and data functions. Is used to extract the characters from the specified string starting from any position. The MID function is intended for languages that use the single-byte character set (SBCS), while MIDB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax MID(text, start_num, num_chars) The MID function has the following arguments: Argument Description text A string you need to extract the characters from. start_num A position you need to start extracting from. num_chars A number of the characters you need to extract. MIDB(text, start_num, num_bytes) The MIDB function has the following arguments: Argument Description text A string you need to extract the characters from. start_num A position you need to start extracting from. num_bytes A number of the characters you need to extract, based on bytes. Notes How to apply the MID/MIDB function. Examples The figure below displays the result returned by the MID function."
    },
   {
        "id": "Functions/min.htm", 
        "title": "MIN Function", 
        "body": "The MIN function is one of the statistical functions. It is used to analyze the range of data and find the smallest number. Syntax MIN(number1, [number2], ...) The MIN function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to find the smallest number. Notes How to apply the MIN function. Examples The figure below displays the result returned by the MIN function."
    },
   {
        "id": "Functions/mina.htm", 
        "title": "MINA Function", 
        "body": "The MINA function is one of the statistical functions. It is used to analyze the range of data and find the smallest value. Syntax MINA(value1, [value2], ...) The MINA function has the following arguments: Argument Description value1/2/n Up to 255 values (number, text, logical value) for which you want to find the smallest value. Notes How to apply the MINA function. Examples The figure below displays the result returned by the MINA function."
    },
   {
        "id": "Functions/minifs.htm", 
        "title": "MINIFS Function", 
        "body": "The MINIFS function is one of the statistical functions. It is used to return the minimum value among cells specified by a given set of conditions or criteria. Syntax MINIFS(min_range, criteria_range1, criteria1, [criteria_range2, criteria2], ...) The MINIFS function has the following arguments: Argument Description min_range The range of cells in which the minimum will be determined. criteria_range1 The first selected range of cells to apply the criteria1 to. criteria1 The first condition that must be met. It is applied to the criteria_range1 and used to determine which cells in the min_range will be evaluated as minimum. criteria_range2, criteria2 Additional ranges of cells and their corresponding criteria. These arguments are optional. Notes You can use wildcard characters when specifying criteria. The question mark \"?\" can replace any single character and the asterisk \"*\" can be used instead of any number of characters. How to apply the MINIFS function. Examples The figure below displays the result returned by the MINIFS function."
    },
   {
        "id": "Functions/minute.htm", 
        "title": "MINUTE Function", 
        "body": "The MINUTE function is one of the date and time functions. It returns the minute (a number from 0 to 59) of the time value. Syntax MINUTE(serial_number) The MINUTE function has the following argument: Argument Description serial_number The time that contains the minute you want to find. Notes The serial_number may be expressed as a string value (e.g. \"13:39\"), a decimal number (e.g. 0.56 corresponds to 13:26) , or the result of a formula (e.g. the result of the NOW function in the default format - 9/26/12 13:39) How to apply the MINUTE function. Examples The figure below displays the result returned by the MINUTE function."
    },
   {
        "id": "Functions/minverse.htm", 
        "title": "MINVERSE Function", 
        "body": "The MINVERSE function is one of the math and trigonometry functions. It is used to return the inverse matrix for a given matrix and display the first value of the returned array of numbers. Syntax MINVERSE(array) The MINVERSE function has the following argument: Argument Description array An array of numbers. Notes If any of the cells in the array contain empty or non-numeric values, the function will return the #N/A error. If the number of rows in the array is not the same as the number of columns, the function will return the #VALUE! error. Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the MINVERSE function. Examples The figure below displays the result returned by the MINVERSE function."
    },
   {
        "id": "Functions/mirr.htm", 
        "title": "MIRR Function", 
        "body": "The MIRR function is one of the financial functions. It is used to calculate the modified internal rate of return for a series of periodic cash flows. Syntax MIRR(values, finance_rate, reinvest_rate) The MIRR function has the following arguments: Argument Description values An array that contains the series of payments occuring at regular periods. At least one of the values must be negative and at least one positive. finance_rate The interest rate paid on the money used in the cash flows. reinvest_rate The interest rate received on the cash reinvestment. Notes How to apply the MIRR function. Examples The figure below displays the result returned by the MIRR function."
    },
   {
        "id": "Functions/mmult.htm", 
        "title": "MMULT Function", 
        "body": "The MMULT function is one of the math and trigonometry functions. It is used to return the matrix product of two arrays and display the first value of the returned array of numbers. Syntax MMULT(array1, array2) The MMULT function has the following arguments: Argument Description array1, array2 An array of numbers. Notes If any of the cells in the array contain empty or non-numeric values, the function will return the #N/A error. If the number of columns in array1 is not the same as the number of rows in array2, the function will return the #VALUE! error. Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the MMULT function. Examples The figure below displays the result returned by the MMULT function."
    },
   {
        "id": "Functions/mod.htm", 
        "title": "MOD Function", 
        "body": "The MOD function is one of the math and trigonometry functions. It is used to return the remainder after the division of a number by the specified divisor. Syntax MOD(number, divisor) The MOD function has the following argument: Argument Description number A number you wish to divide and find the remainder. divisor A number you wish to divide by. Notes If divisor is 0, the function returns the #DIV/0! error. How to apply the MOD function. Examples The figure below displays the result returned by the MOD function."
    },
   {
        "id": "Functions/mode-mult.htm", 
        "title": "MODE.MULT Function", 
        "body": "The MODE.MULT function is one of the statistical functions. It is used to return the most frequently occurring, or repetitive values in an array or range of data. Syntax MODE.MULT(number1, [number2], ...) The MODE.MULT function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to find the most frequently occurring value. Notes Because this function returns an array of values, it must be entered as an array formula. To learn more, please read the Insert array formulas article. If there is no repetitive value in the argument list, the function will return the #VALUE! error. How to apply the MODE.MULT function. Examples The figure below displays the result returned by the MODE.MULT function."
    },
   {
        "id": "Functions/mode-sngl.htm", 
        "title": "MODE.SNGL Function", 
        "body": "The MODE.SNGL function is one of the statistical functions. It is used to return the most frequently occurring, or repetitive, value in an array or range of data. Syntax MODE.SNGL(number1, [number2], ...) The MODE.SNGL function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to find the most frequently occurring value. Notes If there is no repetitive value in the argument list, the function will return the #VALUE! error. How to apply the MODE.SNGL function. Examples The figure below displays the result returned by the MODE.SNGL function."
    },
   {
        "id": "Functions/mode.htm", 
        "title": "MODE Function", 
        "body": "The MODE function is one of the statistical functions. It is used to analyze the range of data and return the most frequently occurring value. Syntax MODE(number1, [number2], ...) The MODE function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to find the most frequently occurring value. Notes If there is no repetitive value in the argument list, the function will return the #VALUE! error. How to apply the MODE function. Examples The figure below displays the result returned by the MODE function."
    },
   {
        "id": "Functions/month.htm", 
        "title": "MONTH Function", 
        "body": "The MONTH function is one of the date and time functions. It returns the month (a number from 1 to 12) of the date given in the numerical format (MM/dd/yyyy by default). Syntax MONTH(serial_number) The MONTH function has the following argument: Argument Description serial_number The date of the month you want to find. Notes How to apply the MONTH function. Examples The figure below displays the result returned by the MONTH function."
    },
   {
        "id": "Functions/mround.htm", 
        "title": "MROUND Function", 
        "body": "The MROUND function is one of the math and trigonometry functions. It is used to round the number to the desired multiple. Syntax MROUND(number, multiple) The MROUND function has the following arguments: Argument Description number A number you wish to round. multiple A multiple you wish to round to. Notes If the values of number and multiple have different signs, the function returns the #NUM! error. How to apply the MROUND function. Examples The figure below displays the result returned by the MROUND function."
    },
   {
        "id": "Functions/multinomial.htm", 
        "title": "MULTINOMIAL Function", 
        "body": "The MULTINOMIAL function is one of the math and trigonometry functions. It is used to return the ratio of the factorial of a sum of numbers to the product of factorials. Syntax MULTINOMIAL(number1, [number2], ...) The MULTINOMIAL function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to find the multinomial. Notes How to apply the MULTINOMIAL function. Examples The figure below displays the result returned by the MULTINOMIAL function."
    },
   {
        "id": "Functions/munit.htm", 
        "title": "MUNIT Function", 
        "body": "The MUNIT function is one of the math and trigonometry functions. It is used to return the unit matrix for the specified dimension. Syntax MUNIT(dimension) The MUNIT function has the following argument: Argument Description dimension An integer specifying the dimension of the unit matrix that you want to return, and returns an array. The dimension has to be greater than zero. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the MUNIT function. Examples The figure below displays the result returned by the MUNIT function."
    },
   {
        "id": "Functions/n.htm", 
        "title": "N Function", 
        "body": "The N function is one of the information functions. It is used to convert a value to a number. Syntax N(value) The N function has the following argument: Argument Description value A value to test. The value argument can be one of the following: Value Number number number date date as serial number TRUE 1 FALSE 0 error error value Other 0 Notes How to apply the N function. Examples The figure below displays the result returned by the N function."
    },
   {
        "id": "Functions/na.htm", 
        "title": "NA Function", 
        "body": "The NA function is one of the information functions. It is used to return the #N/A error value. This function does not require an argument. Syntax NA() Notes How to apply the NA function. Examples The figure below displays the result returned by the NA function."
    },
   {
        "id": "Functions/negbinom-dist.htm", 
        "title": "NEGBINOM.DIST Function", 
        "body": "The NEGBINOM.DIST function is one of the statistical functions. It is used to return the negative binomial distribution, the probability that there will be Number_f failures before the Number_s-th success, with Probability_s probability of a success. Syntax NEGBINOM.DIST(number_f, number_s, probability_s, cumulative) The NEGBINOM.DIST function has the following arguments: Argument Description number_f The number of failures, a numeric value greater than or equal to 0. number_s The threshold number of successes, a numeric value greater than or equal to 1. probability_s The success propability of each trial, a numeric value greater than 0, but less than 1. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability density function. Notes How to apply the NEGBINOM.DIST function. Examples The figure below displays the result returned by the NEGBINOM.DIST function."
    },
   {
        "id": "Functions/negbinomdist.htm", 
        "title": "NEGBINOMDIST Function", 
        "body": "The NEGBINOMDIST function is one of the statistical functions. It is used to return the negative binomial distribution. Syntax NEGBINOMDIST(number_f, number_s, probability_s) The NEGBINOMDIST function has the following arguments: Argument Description number_f The number of failures, a numeric value greater than or equal to 0. number_s The threshold number of successes, a numeric value greater than or equal to 1. probability_s The success propability of each trial, a numeric value greater than 0, but less than 1. Notes How to apply the NEGBINOMDIST function. Examples The figure below displays the result returned by the NEGBINOMDIST function."
    },
   {
        "id": "Functions/networkdays-intl.htm", 
        "title": "NETWORKDAYS.INTL Function", 
        "body": "The NETWORKDAYS.INTL function is one of the date and time functions. It is used to return the number of whole workdays between two dates using parameters to indicate which and how many days are weekend days. Syntax NETWORKDAYS.INTL(start_date, end_date, [weekend], [holidays]) The NETWORKDAYS.INTL function has the following arguments: Argument Description start_date The first date of the period, entered using the DATE function or other date and time function. end_date The last date of the period, entered using the DATE function or other date and time function. weekend An optional argument, a number or a string that specifies which days to consider weekends. The possible numbers are listed in the table below. holidays An optional argument that specifies which dates in addition to weekend are nonworking. You can enter them using the DATE function or other date and time function or specify a reference to a range of cells containing dates. The weekend argument can be one of the following: Number Weekend days 1 or omitted Saturday, Sunday 2 Sunday, Monday 3 Monday, Tuesday 4 Tuesday, Wednesday 5 Wednesday, Thursday 6 Thursday, Friday 7 Friday, Saturday 11 Sunday only 12 Monday only 13 Tuesday only 14 Wednesday only 15 Thursday only 16 Friday only 17 Saturday only Notes A string that specifies weekend days must contain 7 characters. Each character represents a day of the week, starting from Monday. 0 represents a workday, 1 represents a weekend day. E.g. \"0000011\" specifies that weekend days are Saturday and Sunday. The string \"1111111\" is not valid. How to apply the NETWORKDAYS.INTL function. Examples The figure below displays the result returned by the NETWORKDAYS.INTL function."
    },
   {
        "id": "Functions/networkdays.htm", 
        "title": "NETWORKDAYS Function", 
        "body": "The NETWORKDAYS function is one of the date and time functions. It is used to return the number of the work days between two dates (start date and end-date) excluding weekends and dates considered as holidays. Syntax NETWORKDAYS(start_date, end_date, [holidays]) The NETWORKDAYS function has the following argument: Argument Description start_date The first date of the period, entered using the DATE function or other date and time function. end_date The last date of the period, entered using the DATE function or other date and time function. holidays An optional argument that specifies which dates besides weekends are nonworking. You can enter them using the DATE function or other date and time function or specify a reference to a range of cells containing dates. Notes How to apply the NETWORKDAYS function. Examples The figure below displays the result returned by the NETWORKDAYS function."
    },
   {
        "id": "Functions/nominal.htm", 
        "title": "NOMINAL Function", 
        "body": "The NOMINAL function is one of the financial functions. It is used to calculate the nominal annual interest rate for a security based on a specified effective annual interest rate and the number of compounding periods per year. Syntax NOMINAL(effect_rate, npery) The NOMINAL function has the following arguments: Argument Description effect_rate The effective annual interest rate of the security. npery The number of compounding periods per year. Notes How to apply the NOMINAL function. Examples The figure below displays the result returned by the NOMINAL function."
    },
   {
        "id": "Functions/norm-dist.htm", 
        "title": "NORM.DIST Function", 
        "body": "The NORM.DIST function is one of the statistical functions. It is used to return the normal distribution for the specified mean and standard deviation. Syntax NORM.DIST(x, mean, standard_dev, cumulative) The NORM.DIST function has the following arguments: Argument Description x The value you want to calculate the distribution for, any numeric value. mean The arithmetic mean of the distribution, any numeric value. standard_dev The standard deviation of the distribution, a numeric value greater than 0. cumulative The form of the function, a logical value: TRUE or FALSE. If cumulative is TRUE, the function will return the cumulative distribution function; if FALSE, it will return the probability mass function. Notes How to apply the NORM.DIST function. Examples The figure below displays the result returned by the NORM.DIST function."
    },
   {
        "id": "Functions/norm-inv.htm", 
        "title": "NORM.INV Function", 
        "body": "The NORM.INV function is one of the statistical functions. It is used to return the inverse of the normal cumulative distribution for the specified mean and standard deviation. Syntax NORM.INV(probability, mean, standard_dev) The NORM.INV function has the following arguments: Argument Description probability The probability corresponding to the normal distribution, any numeric value greater than 0, but less than 1. mean The arithmetic mean of the distribution, any numeric value. standard_dev The standard deviation of the distribution, a numeric value greater than 0. Notes How to apply the NORM.INV function. Examples The figure below displays the result returned by the NORM.INV function."
    },
   {
        "id": "Functions/norm-s-dist.htm", 
        "title": "NORM.S.DIST Function", 
        "body": "The NORM.S.DIST function is one of the statistical functions. It is used to return the standard normal distribution (has a mean of zero and a standard deviation of one). Syntax NORM.S.DIST(z, cumulative) The NORM.S.DIST function has the following arguments: Argument Description z A numeric value for which you want to find the standard normal distribution. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability mass function. Notes How to apply the NORM.S.DIST function. Examples The figure below displays the result returned by the NORM.S.DIST function."
    },
   {
        "id": "Functions/norm-s-inv.htm", 
        "title": "NORM.S.INV Function", 
        "body": "The NORM.S.INV function is one of the statistical functions. It is used to return the inverse of the standard normal cumulative distribution; the distribution has a mean of zero and a standard deviation of one. Syntax NORM.S.INV(probability) The NORM.S.INV function has the following argument: Argument Description probability A probability corresponding to the normal distribution. A numeric value greater than 0 but less than 1. Notes How to apply the NORM.S.INV function. Examples The figure below displays the result returned by the NORM.S.INV function."
    },
   {
        "id": "Functions/normdist.htm", 
        "title": "NORMDIST Function", 
        "body": "The NORMDIST function is one of the statistical functions. It is used to return the normal distribution for the specified mean and standard deviation. Syntax NORMDIST(x, mean, standard_dev, cumulative) The NORMDIST function has the following arguments: Argument Description x The value you want to calculate the distribution for, any numeric value. mean The arithmetic mean of the distribution, any numeric value. standard_dev The standard deviation of the distribution, a numeric value greater than 0. cumulative The form of the function, a logical value: TRUE or FALSE. If cumulative is TRUE, the function will return the cumulative distribution function; if FALSE, it will return the probability mass function. Notes How to apply the NORMDIST function. Examples The figure below displays the result returned by the NORMDIST function."
    },
   {
        "id": "Functions/norminv.htm", 
        "title": "NORMINV Function", 
        "body": "The NORMINV function is one of the statistical functions. It is used to return the inverse of the normal cumulative distribution for the specified mean and standard deviation. Syntax NORMINV(probability, mean, standard_dev) The NORMINV function has the following arguments: Argument Description probability The probability corresponding to the normal distribution, any numeric value greater than 0, but less than 1. mean The arithmetic mean of the distribution, any numeric value. standard_dev The standard deviation of the distribution, a numeric value greater than 0. Notes How to apply the NORMINV function. Examples The figure below displays the result returned by the NORMINV function."
    },
   {
        "id": "Functions/normsdist.htm", 
        "title": "NORMSDIST Function", 
        "body": "The NORMSDIST function is one of the statistical functions. It is used to return the standard normal cumulative distribution function. Syntax NORMSDIST(z) The NORMSDIST function has the following argument: Argument Description z A numeric value for which you want to find the standard normal cumulative distribution. Notes How to apply the NORMSDIST function. Examples The figure below displays the result returned by the NORMSDIST function."
    },
   {
        "id": "Functions/normsinv.htm", 
        "title": "NORMSINV Function", 
        "body": "The NORMSINV function is one of the statistical functions. It is used to return the inverse of the standard normal cumulative distribution. Syntax NORMSINV(probability) The NORMSINV function has the following argument: Argument Description probability A probability corresponding to the normal distribution. A numeric value greater than 0 but less than 1. Notes How to apply the NORMSINV function. Examples The figure below displays the result returned by the NORMSINV function."
    },
   {
        "id": "Functions/not.htm", 
        "title": "NOT Function", 
        "body": "The NOT function is one of the logical functions. It is used to check if the logical value you enter is TRUE or FALSE. The function returns TRUE if the argument is FALSE and FALSE if the argument is TRUE. Syntax NOT(logical) The NOT function has the following argument: Argument Description logical A value that can be evaluated to TRUE or FALSE. Notes How to apply the NOT function. Examples There is an argument: logical = A1&lt;100, where A1 is 12. This logical expression is TRUE. So the function returns FALSE. If we change the A1 value from 12 to 112, the function returns TRUE:"
    },
   {
        "id": "Functions/now.htm", 
        "title": "NOW Function", 
        "body": "The NOW function is one of the date and time functions. It is used to add the current date and time to your spreadsheet in the following format MM/dd/yy hh:mm. This function does not require an argument. Syntax NOW() Notes How to apply the NOW function. Examples The figure below displays the result returned by the NOW function."
    },
   {
        "id": "Functions/nper.htm", 
        "title": "NPER Function", 
        "body": "The NPER function is one of the financial functions. It is used to calculate the number of periods for an investment based on a specified interest rate and a constant payment schedule. Syntax NPER(rate, pmt, pv, [fv], [type]) The NPER function has the following arguments: Argument Description rate The interest rate. pmt A payment amount. pv A present value of the payments. fv The future value of an investment. It is an optional argument. If it is omitted, the function will assume fv to be 0. type A period when the payments are due. It is an optional argument. If it is set to 0 or omitted, the function will assume the payments to be due at the end of the period. If type is set to 1, the payments are due at the beginning of the period. Notes Cash paid out (such as deposits to savings) is represented by negative numbers; cash received (such as dividend checks) is represented by positive numbers. How to apply the NPER function. Examples The figure below displays the result returned by the NPER function."
    },
   {
        "id": "Functions/npv.htm", 
        "title": "NPV Function", 
        "body": "The NPV function is one of the financial functions. It is used to calculate the net present value of an investment based on a specified discount rate. Syntax NPV(rate, value1, [value2], ...) The NPV function has the following arguments: Argument Description rate The discount rate. value1/2/n Up to 255 arguments representing future payments (negative values) and income (positive values). Notes How to apply the NPV function. Examples The figure below displays the result returned by the NPV function."
    },
   {
        "id": "Functions/numbervalue.htm", 
        "title": "NUMBERVALUE Function", 
        "body": "The NUMBERVALUE function is one of the text and data functions. Is used to convert text to a number, in a locale-independent way. If the converted text is not a number, the function will return a #VALUE! error. Syntax NUMBERVALUE(text, [decimal_separator], [group_separator]) The NUMBERVALUE function has the following arguments: Argument Description text The text data that represents a number. decimal_separator The character used to separate the integer and fractional part of the result. It is an optional argument. If it is omitted, the current locale is used. group_separator The character used to separate groupings of numbers, such as thousands from hundreds and millions from thousands. It is an optional argument. If it is omitted, the current locale is used. Notes How to apply the NUMBERVALUE function. Examples The figure below displays the result returned by the NUMBERVALUE function."
    },
   {
        "id": "Functions/oct2bin.htm", 
        "title": "OCT2BIN Function", 
        "body": "The OCT2BIN function is one of the engineering functions. It is used to convert an octal number to a binary number. Syntax OCT2BIN(number, [places]) The OCT2BIN function has the following arguments: Argument Description number An octal number. places The number of digits to display. If omitted, the function will use the minimum number. Notes If the argument is not recognised as an octal number, or contains more than 10 characters, or the resulting binary number requires more digits than you specified, or the specified places number is less than or equal to 0, the function will return the #NUM! error. How to apply the OCT2BIN function. Examples The figure below displays the result returned by the OCT2BIN function."
    },
   {
        "id": "Functions/oct2dec.htm", 
        "title": "OCT2DEC Function", 
        "body": "The OCT2DEC function is one of the engineering functions. It is used to convert an octal number to a decimal number. Syntax OCT2DEC(number) The OCT2DEC function has the following argument: Argument Description number An octal number. Notes If the argument is not recognised as an octal number, or contains more than 10 characters, the function will return the #NUM! error. How to apply the OCT2DEC function. Examples The figure below displays the result returned by the OCT2DEC function."
    },
   {
        "id": "Functions/oct2hex.htm", 
        "title": "OCT2HEX Function", 
        "body": "The OCT2HEX function is one of the engineering functions. It is used to convert an octal number to a hexadecimal number. Syntax OCT2HEX(number, [places]) The OCT2HEX function has the following arguments: Argument Description number An octal number. places The number of digits to display. If omitted, the function will use the minimum number. Notes If the argument is not recognised as an octal number, or contains more than 10 characters, or the resulting hexadecimal number requires more digits than you specified, or the specified places number is less than or equal to 0, the function will return the #NUM! error. How to apply the OCT2HEX function. Examples The figure below displays the result returned by the OCT2HEX function."
    },
   {
        "id": "Functions/odd.htm", 
        "title": "ODD Function", 
        "body": "The ODD function is one of the math and trigonometry functions. It is used to round the number up to the nearest odd integer. Syntax ODD(number) The ODD function has the following argument: Argument Description number A number you wish to round up. Notes How to apply the ODD function. Examples The figure below displays the result returned by the ODD function."
    },
   {
        "id": "Functions/oddfprice.htm", 
        "title": "ODDFPRICE Function", 
        "body": "The ODDFPRICE function is one of the financial functions. It is used to calculate the price per $100 par value for a security that pays periodic interest but has an odd first period (it is shorter or longer than other periods). Syntax ODDFPRICE(settlement, maturity, issue, first_coupon, rate, yld, redemption, frequency, [basis]) The ODDFPRICE function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. issue The issue date of the security. first_coupon The first coupon date. This date must be after the settlement date but before the maturity date. rate The security interest rate. yld The annual yield of the security. redemption The redemption value of the security, per $100 par value. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the ODDFPRICE function. Examples The figure below displays the result returned by the ODDFPRICE function."
    },
   {
        "id": "Functions/oddfyield.htm", 
        "title": "ODDFYIELD Function", 
        "body": "The ODDFYIELD function is one of the financial functions. It is used to calculate the yield of a security that pays periodic interest but has an odd first period (it is shorter or longer than other periods). Syntax ODDFYIELD(settlement, maturity, issue, first_coupon, rate, pr, redemption, frequency, [basis]) The ODDFYIELD function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. issue The issue date of the security. first_coupon The first coupon date. This date must be after the settlement date but before the maturity date. rate The security interest rate. pr The purchase price of the security, per $100 par value. redemption The redemption value of the security, per $100 par value. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the ODDFYIELD function. Examples The figure below displays the result returned by the ODDFYIELD function."
    },
   {
        "id": "Functions/oddlprice.htm", 
        "title": "ODDLPRICE Function", 
        "body": "The ODDLPRICE function is one of the financial functions. It is used to calculate the price per $100 par value for a security that pays periodic interest but has an odd last period (it is shorter or longer than other periods). Syntax ODDLPRICE(settlement, maturity, last_interest, rate, yld, redemption, frequency, [basis]) The ODDLPRICE function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. last_interest The last coupon date. This date must be before the settlement date. rate The security interest rate. yld The annual yield of the security. redemption The redemption value of the security, per $100 par value. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the ODDLPRICE function. Examples The figure below displays the result returned by the ODDLPRICE function."
    },
   {
        "id": "Functions/oddlyield.htm", 
        "title": "ODDLYIELD Function", 
        "body": "The ODDLYIELD function is one of the financial functions. It is used to calculate the yield of a security that pays periodic interest but has an odd last period (it is shorter or longer than other periods). Syntax ODDLYIELD(settlement, maturity, last_interest, rate, pr, redemption, frequency, [basis]) The ODDLYIELD function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. last_interest The last coupon date. This date must be before the settlement date. rate The security interest rate. pr The purchase price of the security, per $100 par value. redemption The redemption value of the security, per $100 par value. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the ODDLYIELD function. Examples The figure below displays the result returned by the ODDLYIELD function."
    },
   {
        "id": "Functions/offset.htm", 
        "title": "OFFSET Function", 
        "body": "The OFFSET function is one of the lookup and reference functions. It is used to return a reference to a cell displaced from the specified cell (or the upper-left cell in the range of cells) to a certain number of rows and columns. Syntax OFFSET(reference, rows, cols, [height], [width]) The OFFSET function has the following arguments: Argument Description reference A reference to an initial cell or range of cells. rows A number of rows, up or down, that you want the upper-left cell in the returned reference to refer to. Positive numbers mean the result will shift below the initial cell. Negative values mean it will shift above the initial cell. cols A number of columns, to the left or right, that you want the upper-left cell in the returned reference to refer to. Positive numbers mean the result will shift to the right of the initial cell. Negative values mean it will shift to the left of the initial cell. height A number of rows in the returned reference. The value must be a positive number. It's an optional argument. If it is omitted, the function will assume it to be equal to the initial range height. width A number of columns in the returned reference. The value must be a positive number. It's an optional argument. If it is omitted, the function will assume it to be equal to the initial range width. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the OFFSET function. Examples The figure below displays the result returned by the OFFSET function."
    },
   {
        "id": "Functions/or.htm", 
        "title": "OR Function", 
        "body": "The OR function is one of the logical functions. It is used to check if the logical value you enter is TRUE or FALSE. The function returns FALSE if all the arguments are FALSE. Syntax OR(logical1, [logical2], ...) The OR function has the following arguments: Argument Description logical1/2/n A condition that you want to check if it is TRUE or FALSE Notes You can enter up to 255 logical values. How to apply the OR function. The function returns TRUE if at least one of the argument is TRUE. Examples There are three arguments: logical1 = A1&lt;10, logical2 = 34&lt;10, logical3 = 50&lt;10, where A1 is 12. All these logical expressions are FALSE. So the function returns FALSE. If we change the A1 value from 12 to 2, the function returns TRUE:"
    },
   {
        "id": "Functions/pduration.htm", 
        "title": "PDURATION Function", 
        "body": "The PDURATION function is one of the financial functions. It is used to calculate the number of periods required by an investment to reach a specified value. Syntax PDURATION(rate, pv, fv) The PDURATION function has the following arguments: Argument Description rate The interest rate per period. pv The present value of the investment. fv The desired future value of the investment. Notes All arguments must be represented by positive numbers. How to apply the PDURATION function. Examples The figure below displays the result returned by the PDURATION function."
    },
   {
        "id": "Functions/pearson.htm", 
        "title": "PEARSON Function", 
        "body": "The PEARSON function is one of the statistical functions. It is used to return the Pearson product moment correlation coefficient. Syntax PEARSON(array1, array2) The PEARSON function has the following argument: Argument Description array1/2 The selected ranges of cells with the same number of elements. Notes If array1/2 contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the PEARSON function. Examples The figure below displays the result returned by the PEARSON function."
    },
   {
        "id": "Functions/percentile-exc.htm", 
        "title": "PERCENTILE.EXC Function", 
        "body": "The PERCENTILE.EXC function is one of the statistical functions. It is used to return the k-th percentile of values in a range, where k is in the range 0..1, exclusive. Syntax PERCENTILE.EXC(array, k) The PERCENTILE.EXC function has the following arguments: Argument Description array The selected range of cells for which you want to calculate the k-th percentile. k The percentile value, a numeric value greater than 0 but less than 1. Notes How to apply the PERCENTILE.EXC function. Examples The figure below displays the result returned by the PERCENTILE.EXC function."
    },
   {
        "id": "Functions/percentile-inc.htm", 
        "title": "PERCENTILE.INC Function", 
        "body": "The PERCENTILE.INC function is one of the statistical functions. It is used to return the k-th percentile of values in a range, where k is in the range 0..1, inclusive. Syntax PERCENTILE.INC(array, k) The PERCENTILE.INC function has the following arguments: Argument Description array The selected range of cells for which you want to calculate the k-th percentile. k The percentile value, a numeric value greater than or equal to 0 but less than or equal to 1. Notes How to apply the PERCENTILE.INC function. Examples The figure below displays the result returned by the PERCENTILE.INC function."
    },
   {
        "id": "Functions/percentile.htm", 
        "title": "PERCENTILE Function", 
        "body": "The PERCENTILE function is one of the statistical functions. It is used to analyze the range of data and return the k-th percentile. Syntax PERCENTILE(array, k) The PERCENTILE function has the following arguments: Argument Description array The selected range of cells for which you want to calculate the k-th percentile. k The percentile value, a numeric value greater than or equal to 0 but less than or equal to 1. Notes How to apply the PERCENTILE function. Examples The figure below displays the result returned by the PERCENTILE function."
    },
   {
        "id": "Functions/percentrank-exc.htm", 
        "title": "PERCENTRANK.EXC Function", 
        "body": "The PERCENTRANK.EXC function is one of the statistical functions. It is used to return the rank of a value in a data set as a percentage (0..1, exclusive) of the data set. Syntax PERCENTRANK.EXC(array, x, [significance]) The PERCENTRANK.EXC function has the following arguments: Argument Description array The selected range of cells containing the numeric values. x The value you want to find the rank for, a numeric value. significance The number of significant digits to return the rank for. It is an optional argument. If it is omitted, the function will assume significance to be 3. Notes How to apply the PERCENTRANK.EXC function. Examples The figure below displays the result returned by the PERCENTRANK.EXC function."
    },
   {
        "id": "Functions/percentrank-inc.htm", 
        "title": "PERCENTRANK.INC Function", 
        "body": "The PERCENTRANK.INC function is one of the statistical functions. It is used to return the rank of a value in a data set as a percentage (0..1, inclusive) of the data set. Syntax PERCENTRANK.INC(array, x, [significance]) The PERCENTRANK.INC function has the following arguments: Argument Description array The selected range of cells containing the numeric values. x The value you want to find the rank for, a numeric value. significance The number of significant digits to return the rank for. It is an optional argument. If it is omitted, the function will assume significance to be 3. Notes How to apply the PERCENTRANK.INC function. Examples The figure below displays the result returned by the PERCENTRANK.INC function."
    },
   {
        "id": "Functions/percentrank.htm", 
        "title": "PERCENTRANK Function", 
        "body": "The PERCENTRANK function is one of the statistical functions. It is used to return the rank of a value in a set of values as a percentage of the set. Syntax PERCENTRANK(array, x, [significance]) The PERCENTRANK function has the following arguments: Argument Description array The selected range of cells containing the numeric values. x The value you want to find the rank for, a numeric value. significance The number of significant digits to return the rank for. It is an optional argument. If it is omitted, the function will assume significance to be 3. Notes How to apply the PERCENTRANK function. Examples The figure below displays the result returned by the PERCENTRANK function."
    },
   {
        "id": "Functions/permut.htm", 
        "title": "PERMUT Function", 
        "body": "The PERMUT function is one of the statistical functions. It is used to return the number of permutations for a specified number of items. Syntax PERMUT(number, number_chosen) The PERMUT function has the following arguments: Argument Description number A number of items. number_chosen A number of items in one permutation. Notes How to apply the PERMUT function. Examples The figure below displays the result returned by the PERMUT function."
    },
   {
        "id": "Functions/permutationa.htm", 
        "title": "PERMUTATIONA Function", 
        "body": "The PERMUTATIONA function is one of the statistical functions. It is used to return the number of permutations for a given number of objects (with repetitions) that can be selected from the total objects. Syntax PERMUTATIONA(number, number_chosenn) The PERMUTATIONA function has the following arguments: Argument Description number A number of items in the set, a numeric value greater than or equal to 0. number_chosen A number of items in one permutation, a numeric value greater than or equal to 0 and less than number. Notes How to apply the PERMUTATIONA function. Examples The figure below displays the result returned by the PERMUTATIONA function."
    },
   {
        "id": "Functions/phi.htm", 
        "title": "PHI Function", 
        "body": "The PHI function is one of the statistical functions. It is used to return the value of the density function for a standard normal distribution. Syntax PHI(x) The PHI function has the following arguments: Argument Description x The value you want to calculate the density function for, any numeric value. Notes How to apply the PHI function. Examples The figure below displays the result returned by the PHI function."
    },
   {
        "id": "Functions/pi.htm", 
        "title": "PI Function", 
        "body": "The PI function is one of the math and trigonometry functions. The function returns the mathematical constant pi, equal to 3.14159265358979. It does not require any argument. Syntax PI() Notes How to apply the PI function. Examples The figure below displays the result returned by the PI function."
    },
   {
        "id": "Functions/pmt.htm", 
        "title": "PMT Function", 
        "body": "The PMT function is one of the financial functions. It is used to calculate the payment amount for a loan based on a specified interest rate and a constant payment schedule. Syntax PMT(rate, nper, pv, [fv], [type) The PMT function has the following arguments: Argument Description rate The interest rate. nper The number of payments. pv The present value. fv The future value outstanding after all the payments are made. It is an optional argument. If it is omitted, the function will assume fv to be 0. type A period when the payments are due. It is an optional argument. If it is set to 0 or omitted, the function will assume the payments to be due at the end of the period. If type is set to 1, the payments are due at the beginning of the period. Notes Cash paid out (such as deposits to savings) is represented by negative numbers; cash received (such as dividend checks) is represented by positive numbers. Units for rate and nper must be consistent: use N%/12 for rate and N*12 for nper in case of monthly payments, N%/4 for rate and N*4 for nper in case of quarterly payments, N% for rate and N for nper in case of annual payments. How to apply the PMT function. Examples The figure below displays the result returned by the PMT function."
    },
   {
        "id": "Functions/poisson-dist.htm", 
        "title": "POISSON.DIST Function", 
        "body": "The POISSON.DIST function is one of the statistical functions. It is used to return the Poisson distribution; a common application of the Poisson distribution is predicting the number of events over a specific time, such as the number of cars arriving at a toll plaza in 1 minute. Syntax POISSON.DIST(x, mean, cumulative) The POISSON.DIST function has the following arguments: Argument Description x The number of events, a numeric value greater than 0. mean The expected numeric value greater than 0. cumulative The form of the function, a logical value: TRUE or FALSE. If cumulative is TRUE, the function will return the cumulative Poisson probability; if FALSE, it will return the Poisson probability mass function. Notes How to apply the POISSON.DIST function. Examples The figure below displays the result returned by the POISSON.DIST function."
    },
   {
        "id": "Functions/poisson.htm", 
        "title": "POISSON Function", 
        "body": "The POISSON function is one of the statistical functions. It is used to return the Poisson distribution. Syntax POISSON(x, mean, cumulative) The POISSON function has the following arguments: Argument Description x The number of events, a numeric value greater than 0. mean The expected numeric value greater than 0. cumulative The form of the function, a logical value: TRUE or FALSE. If cumulative is TRUE, the function will return the cumulative Poisson probability; if FALSE, it will return the Poisson probability mass function. Notes How to apply the POISSON function. Examples The figure below displays the result returned by the POISSON function."
    },
   {
        "id": "Functions/power.htm", 
        "title": "POWER Function", 
        "body": "The POWER function is one of the math and trigonometry functions. It is used to return the result of a number raised to the desired power. Syntax POWER(number, power) The POWER function has the following arguments: Argument Description number A number you wish to raise. power A power you wish to raise the number to. Notes How to apply the POWER function. Examples The figure below displays the result returned by the POWER function."
    },
   {
        "id": "Functions/ppmt.htm", 
        "title": "PPMT Function", 
        "body": "The PPMT function is one of the financial functions. It is used to calculate the principal payment for an investment based on a specified interest rate and a constant payment schedule. Syntax PPMT(rate, per, nper, pv, [fv] ,[type]) The PPMT function has the following arguments: Argument Description rate The interest rate for the investment. per The period you want to find the principal payment for. The value must be from 1 to nper. nper The number of payments. pv The present value of the payments. fv The future value (i.e. a cash balance remaining after the last payment is made). It is an optional argument. If it is omitted, the function will assume fv to be 0. type A period when the payments are due. It is an optional argument. If it is set to 0 or omitted, the function will assume the payments to be due at the end of the period. If type is set to 1, the payments are due at the beginning of the period. Notes Cash paid out (such as deposits to savings) is represented by negative numbers; cash received (such as dividend checks) is represented by positive numbers. Units for rate and nper must be consistent: use N%/12 for rate and N*12 for nper in case of monthly payments, N%/4 for rate and N*4 for nper in case of quarterly payments, N% for rate and N for nper in case of annual payments. How to apply the PPMT function. Examples The figure below displays the result returned by the PPMT function."
    },
   {
        "id": "Functions/price.htm", 
        "title": "PRICE Function", 
        "body": "The PRICE function is one of the financial functions. It is used to calculate the price per $100 par value for a security that pays periodic interest. Syntax PRICE(settlement, maturity, rate, yld, redemption, frequency, [basis]) The PRICE function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. rate The annual coupon rate of the security. yld The annual yield of the security. redemption The redemption value of the security, per $100 par value. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the PRICE function. Examples The figure below displays the result returned by the PRICE function."
    },
   {
        "id": "Functions/pricedisc.htm", 
        "title": "PRICEDISC Function", 
        "body": "The PRICEDISC function is one of the financial functions. It is used to calculate the price per $100 par value for a discounted security. Syntax PRICEDISC(settlement, maturity, discount, redemption, [basis]) The PRICEDISC function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. discount The security discount rate. redemption The redemption value of the security, per $100 par value. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the PRICEDISC function. Examples The figure below displays the result returned by the PRICEDISC function."
    },
   {
        "id": "Functions/pricemat.htm", 
        "title": "PRICEMAT Function", 
        "body": "The PRICEMAT function is one of the financial functions. It is used to calculate the price per $100 par value for a security that pays interest at maturity. Syntax PRICEMAT(settlement, maturity, issue, rate, yld, [basis]) The PRICEMAT function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. issue The issue date of the security. rate The security interest rate at the issue date. yld The annual yield of the security. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the PRICEMAT function. Examples The figure below displays the result returned by the PRICEMAT function."
    },
   {
        "id": "Functions/prob.htm", 
        "title": "PROB Function", 
        "body": "The PROB function is one of the statistical functions. It is used to return the probability that values in a range are between lower and upper limits. Syntax PROB(x_range, prob_range, [lower_limit], [upper_limit]) The PROB function has the following arguments: Argument Description x_range The selected range of cells containing numeric values you want to associate the probabilities with. prob_range A set of probabilities associated with values in x_range, the selected range of cells containing numeric values greater than 0 but less than 1. The sum of the values in prob_range should be equal to 1, otherwise the function will return the #NUM! error. lower_limit The lower bound of the value, a numeric value entered manually or included into the cell you make reference to. upper_limit The upper bound of the value, a numeric value entered manually or included into the cell you make reference to. It is an optional argument. If it is omitted, the function will return the probability equal to lower_limit. Notes x_range should contain the same number of elements as prob_range. How to apply the PROB function. Examples The figure below displays the result returned by the PROB function."
    },
   {
        "id": "Functions/product.htm", 
        "title": "PRODUCT Function", 
        "body": "The PRODUCT function is one of the math and trigonometry functions. It is used to multiply all the numbers in the selected range of cells and return the product. Syntax PRODUCT(number1, [number2], ...) The PRODUCT function has the following arguments: Argument Description number1/2/n Up to 255 numeric values that you want to multiply. Notes How to apply the PRODUCT function. Examples The figure below displays the result returned by the PRODUCT function."
    },
   {
        "id": "Functions/proper.htm", 
        "title": "PROPER Function", 
        "body": "The PROPER function is one of the text and data functions. Is used to convert the first character of each word to uppercase and all the remaining characters to lowercase. Syntax PROPER(text) The PROPER function has the following argument: Argument Description text The text that you want to partially capitalize. Notes How to apply the PROPER function. Examples The figure below displays the result returned by the PROPER function."
    },
   {
        "id": "Functions/pv.htm", 
        "title": "PV Function", 
        "body": "The PV function is one of the financial functions. It is used to calculate the present value of an investment based on a specified interest rate and a constant payment schedule. Syntax PV(rate, nper, pmt, [fv], [type]) The PV function has the following arguments: Argument Description rate The interest rate. nper The number of payments. pmt The payment amount. fv The future value. It is an optional argument. If it is omitted, the function will assume fv to be 0. type A period when the payments are due. It is an optional argument. If it is set to 0 or omitted, the function will assume the payments to be due at the end of the period. If type is set to 1, the payments are due at the beginning of the period. Notes Cash paid out (such as deposits to savings) is represented by negative numbers; cash received (such as dividend checks) is represented by positive numbers. Units for rate and nper must be consistent: use N%/12 for rate and N*12 for nper in case of monthly payments, N%/4 for rate and N*4 for nper in case of quarterly payments, N% for rate and N for nper in case of annual payments. How to apply the PV function. Examples The figure below displays the result returned by the PV function."
    },
   {
        "id": "Functions/quartile-exc.htm", 
        "title": "QUARTILE.EXC Function", 
        "body": "The QUARTILE.EXC function is one of the statistical functions. It is used to return the quartile of the data set, based on percentile values from 0..1, exclusive. Syntax QUARTILE.EXC(array, quart) The QUARTILE.EXC function has the following arguments: Argument Description array The selected range of cells you want to analyse. quart The quartile value that you wish to return, a numeric value. The possible values are listed in the table below. The quart argument can be one of the following: Numeric value Quartile 1 First quartile (25th percentile) 2 Second quartile (50th percentile) 3 Third quartile (75th percentile) Notes How to apply the QUARTILE.EXC function. Examples The figure below displays the result returned by the QUARTILE.EXC function."
    },
   {
        "id": "Functions/quartile-inc.htm", 
        "title": "QUARTILE.INC Function", 
        "body": "The QUARTILE.INC function is one of the statistical functions. It is used to return the quartile of the data set, based on percentile values from 0..1, inclusive. Syntax QUARTILE.INC(array, quart) The QUARTILE.INC function has the following arguments: Argument Description array The selected range of cells you want to analyse. quart The quartile value that you wish to return, a numeric value. The possible values are listed in the table below. The quart argument can be one of the following: Numeric value Quartile 0 Smallest value in the range of data 1 First quartile (25th percentile) 2 Second quartile (50th percentile) 3 Third quartile (75th percentile) 4 Largest value in the data set Notes How to apply the QUARTILE.INC function. Examples The figure below displays the result returned by the QUARTILE.INC function."
    },
   {
        "id": "Functions/quartile.htm", 
        "title": "QUARTILE Function", 
        "body": "The QUARTILE function is one of the statistical functions. It is used to analyze the range of data and return the quartile. Syntax QUARTILE(array, quart) The QUARTILE function has the following arguments: Argument Description array The selected range of cells you want to analyse. quart The quartile value that you wish to return, a numeric value. The possible values are listed in the table below. The quart argument can be one of the following: Numeric value Quartile 0 Smallest value in the range of data 1 First quartile (25th percentile) 2 Second quartile (50th percentile) 3 Third quartile (75th percentile) 4 Largest value in the data set Notes How to apply the QUARTILE function. Examples The figure below displays the result returned by the QUARTILE function."
    },
   {
        "id": "Functions/quotient.htm", 
        "title": "QUOTIENT Function", 
        "body": "The QUOTIENT function is one of the math and trigonometry functions. It is used to return the integer portion of a division. Syntax QUOTIENT(numerator, denominator) The QUOTIENT function has the following argument: Argument Description numerator The dividend, a numeric value. denominator The divisor, a numeric value. Notes How to apply the QUOTIENT function. Examples The figure below displays the result returned by the QUOTIENT function."
    },
   {
        "id": "Functions/radians.htm", 
        "title": "RADIANS Function", 
        "body": "The RADIANS function is one of the math and trigonometry functions. It is used to convert degrees into radians. Syntax RADIANS(angle) The RADIANS function has the following argument: Argument Description angle A numeric value (degrees). Notes How to apply the RADIANS function. Examples The figure below displays the result returned by the RADIANS function."
    },
   {
        "id": "Functions/rand.htm", 
        "title": "RAND Function", 
        "body": "The RAND function is one of the math and trigonometry functions. The function returns a random number greater than or equal to 0 and less than 1. It does not require any argument. Syntax RAND() Notes How to apply the RAND function. Examples The figure below displays the result returned by the RAND function. To generate a random real number between a and b, use the following formula replacing a and b with your own values: =RAND()*(b-a)+a"
    },
   {
        "id": "Functions/randarray.htm", 
        "title": "RANDARRAY Function", 
        "body": "The RANDARRAY function is one of the math and trigonometry functions. It is used to return an array of random numbers and can be configured to fill a certain number of rows and columns, set a range for values, or return whole/decimal numbers. Syntax RANDARRAY([rows], [columns], [min], [max], [whole_number]) The RANDARRAY function has the following arguments: Argument Description rows An optional argument indicating the number of rows to be returned. If the argument is not given, the function will return a value between 0 and 1. columns An optional argument indicating the number of columns to be returned. If the argument is not given, the function will return a value between 0 and 1. min An optional argument indicating the minimum number to be returned. If the argument is not given, the function will default to 0 and 1. max An optional argument indicating the maximum number to be returned. If the argument is not given, the function will default to 0 and 1. whole_number An optional TRUE or FALSE argument. If TRUE, the function will return a whole number; FALSE will return a decimal one. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the RANDARRAY function. Examples The figure below displays the result returned by the RANDARRAY function."
    },
   {
        "id": "Functions/randbetween.htm", 
        "title": "RANDBETWEEN Function", 
        "body": "The RANDBETWEEN function is one of the math and trigonometry functions. The function returns a random number greater than or equal to lower-bound and less than or equal to upper-bound. Syntax RANDBETWEEN(bottom, top) The RANDBETWEEN function has the following arguments: Argument Description bottom The smallest integer value. top The largest integer valuew. Notes If bottom is a greater than top, the function will return #NUM! error. How to apply the RANDBETWEEN function. Examples The figure below displays the result returned by the RANDBETWEEN function."
    },
   {
        "id": "Functions/rank-avg.htm", 
        "title": "RANK.AVG Function", 
        "body": "The RANK.AVG function is one of the statistical functions. It is used to return the rank of a number in a list of numbers. The rank of a number is its size relative to other values in a list (if you were to sort the list, the rank of the number would be its position). If more than one value has the same rank, the average rank is returned. Syntax RANK.AVG(number, ref, [order]) The RANK.AVG function has the following arguments: Argument Description number The value you want to find the rank for. ref The selected range of cells containing the specified number. order The numeric value that specifyes how to order the ref array. It is an optional argument. If it is 0 or omitted, the function ranks number as if ref were a list sorted in descending order. Any other numeric value is treated as the value 1 and the function ranks number as if ref were a list sorted in ascending order. Notes How to apply the RANK.AVG function. Examples The figure below displays the result returned by the RANK.AVG function."
    },
   {
        "id": "Functions/rank-eq.htm", 
        "title": "RANK.EQ Function", 
        "body": "The RANK.EQ function is one of the statistical functions. It is used to return the rank of a number in a list of numbers. The rank of a number is its size relative to other values in a list (if you were to sort the list, the rank of the number would be its position). If more than one value has the same rank, the top rank of that set of values is returned. Syntax RANK.EQ(number, ref, [order]) The RANK.EQ function has the following arguments: Argument Description number The value you want to find the rank for. ref The selected range of cells containing the specified number. order The numeric value that specifyes how to order the ref array. It is an optional argument. If it is 0 or omitted, the function ranks number as if ref were a list sorted in descending order. Any other numeric value is treated as the value 1 and the function ranks number as if ref were a list sorted in ascending order. Notes How to apply the RANK.EQ function. Examples The figure below displays the result returned by the RANK.EQ function."
    },
   {
        "id": "Functions/rank.htm", 
        "title": "RANK Function", 
        "body": "The RANK function is one of the statistical functions. It is used to return the rank of a number in a list of numbers. The rank of a number is its size relative to other values in a list (if you were to sort the list, the rank of the number would be its position). Syntax RANK(number, ref, [order]) The RANK function has the following arguments: Argument Description number The value you want to find the rank for. ref The selected range of cells containing the specified number. order The numeric value that specifyes how to order the ref array. It is an optional argument. If it is 0 or omitted, the function ranks number as if ref were a list sorted in descending order. Any other numeric value is treated as the value 1 and the function ranks number as if ref were a list sorted in ascending order. Notes How to apply the RANK function. Examples The figure below displays the result returned by the RANK function."
    },
   {
        "id": "Functions/rate.htm", 
        "title": "RATE Function", 
        "body": "The RATE function is one of the financial functions. It is used to calculate the interest rate for an investment based on a constant payment schedule. Syntax RATE(nper, pmt, pv, [fv], [type], [guess]) The RATE function has the following arguments: Argument Description nper The number of payments. pmt The payment amount. pv A present value of the payments. fv A future value (i.e. a cash balance remaining after the last payment is made). It is an optional argument. If it is omitted, the function will assume fv to be 0. type A period when the payments are due. It is an optional argument. If it is set to 0 or omitted, the function will assume the payments to be due at the end of the period. If type is set to 1, the payments are due at the beginning of the period. guess An estimate at what the rate will be. It is an optional argument. If it is omitted, the function will assume guess to be 10%. Notes Cash paid out (such as deposits to savings) is represented by negative numbers; cash received (such as dividend checks) is represented by positive numbers. Units for guess and nper must be consistent: use N%/12 for guess and N*12 for nper in case of monthly payments, N%/4 for guess and N*4 for nper in case of quarterly payments, N% for guess and N for nper in case of annual payments. How to apply the RATE function. Examples The figure below displays the result returned by the RATE function."
    },
   {
        "id": "Functions/received.htm", 
        "title": "RECEIVED Function", 
        "body": "The RECEIVED function is one of the financial functions. It is used to calculate the amount received at maturity for a fully invested security. Syntax RECEIVED(settlement, maturity, investment, discount, [basis]) The RECEIVED function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. investment The amount paid for the security. discount The security discount rate. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the RECEIVED function. Examples The figure below displays the result returned by the RECEIVED function."
    },
   {
        "id": "Functions/replace.htm", 
        "title": "REPLACE/REPLACEB Function", 
        "body": "The REPLACE/REPLACEB function is one of the text and data functions. Is used to replace a set of characters, based on the number of characters and the start position you specify, with a new set of characters. The REPLACE function is intended for languages that use the single-byte character set (SBCS), while REPLACEB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax REPLACE(old_text, start_num, num_chars, new_text) The REPLACE function has the following arguments: Argument Description old_text The original text to be replaced. start_num The beginning of the set to be replaced. num_chars The number of characters to be replaced. new_text The new text. REPLACEB(old_text, start_num, num_bytes, new_text) The REPLACEB function has the following arguments: Argument Description old_text The original text to be replaced. start_num The beginning of the set to be replaced. num_bytes The number of characters to be replaced, based on bytes. new_text The new text. Notes The REPLACE function is case-sensitive. How to apply the REPLACE/REPLACEB function. Examples The figure below displays the result returned by the REPLACE function."
    },
   {
        "id": "Functions/replaceb.htm", 
        "title": "REPLACE/REPLACEB Function", 
        "body": "The REPLACE/REPLACEB function is one of the text and data functions. Is used to replace a set of characters, based on the number of characters and the start position you specify, with a new set of characters. The REPLACE function is intended for languages that use the single-byte character set (SBCS), while REPLACEB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax REPLACE(old_text, start_num, num_chars, new_text) The REPLACE function has the following arguments: Argument Description old_text The original text to be replaced. start_num The beginning of the set to be replaced. num_chars The number of characters to be replaced. new_text The new text. REPLACEB(old_text, start_num, num_bytes, new_text) The REPLACEB function has the following arguments: Argument Description old_text The original text to be replaced. start_num The beginning of the set to be replaced. num_bytes The number of characters to be replaced, based on bytes. new_text The new text. Notes The REPLACE function is case-sensitive. Examples The figure below displays the result returned by the REPLACE function."
    },
   {
        "id": "Functions/rept.htm", 
        "title": "REPT Function", 
        "body": "The REPT function is one of the text and data functions. Is used to repeat the data in the selected cell as many time as you wish. Syntax REPT(text, number_time) The REPT function has the following arguments: Argument Description text The data to be repeated. number_time A number of times you wish to repeat the data you entered. Notes How to apply the REPT function. Examples The figure below displays the result returned by the REPT function."
    },
   {
        "id": "Functions/right.htm", 
        "title": "RIGHT/RIGHTB Function", 
        "body": "The RIGHT/RIGHTB function is one of the text and data functions. Is used to extract a substring from a string starting from the right-most character, based on the specified number of characters. The RIGHT function is intended for languages that use the single-byte character set (SBCS), while RIGHTB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax RIGHT(text, [num_chars]) The RIGHT function has the following arguments: Argument Description text A string you need to extract the substring from. num_chars A number of the substring characters. It must be greater than or equal to 0. It is an optional argument. If it is omitted, the function will assume it to be 1. RIGHTB(text, [num_bytes]) The RIGHTB function has the following arguments: Argument Description text A string you need to extract the substring from. num_bytes A number of the substring characters, based on bytes. It is an optional argument. Notes How to apply the RIGHT/RIGHTB function. Examples The figure below displays the result returned by the RIGHT function."
    },
   {
        "id": "Functions/rightb.htm", 
        "title": "RIGHT/RIGHTB Function", 
        "body": "The RIGHT/RIGHTB function is one of the text and data functions. Is used to extract a substring from a string starting from the right-most character, based on the specified number of characters. The RIGHT function is intended for languages that use the single-byte character set (SBCS), while RIGHTB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax RIGHT(text, [num_chars]) The RIGHT function has the following arguments: Argument Description text A string you need to extract the substring from. num_chars A number of the substring characters. It must be greater than or equal to 0. It is an optional argument. If it is omitted, the function will assume it to be 1. RIGHTB(text, [num_bytes]) The RIGHTB function has the following arguments: Argument Description text A string you need to extract the substring from. num_bytes A number of the substring characters, based on bytes. It is an optional argument. Notes How to apply the RIGHT/RIGHTB function. Examples The figure below displays the result returned by the RIGHT function."
    },
   {
        "id": "Functions/roman.htm", 
        "title": "ROMAN Function", 
        "body": "The ROMAN function is one of the math and trigonometry functions. The function is used to convert a number to a roman numeral. Syntax ROMAN(number, [form]) The ROMAN function has the following arguments: Argument Description number A numeric value greater than or equal to 1 and less than 3999. form A roman numeral type. It is an optional argument. The possible values are listed in the table below. The form argument can be one of the following: Value Type 0 Classic 1 More concise 2 More concise 3 More concise 4 Simplified TRUE Classic FALSE Simplified Notes How to apply the ROMAN function. Examples The figure below displays the result returned by the ROMAN function."
    },
   {
        "id": "Functions/round.htm", 
        "title": "ROUND Function", 
        "body": "The ROUND function is one of the math and trigonometry functions. It is used to round the number to the desired number of digits. Syntax ROUND(number, num_digits) The ROUND function has the following arguments: Argument Description number The number you wish to round. num_digits The number of digits you wish to round to. Notes How to apply the ROUND function. Examples The figure below displays the result returned by the ROUND function."
    },
   {
        "id": "Functions/rounddown.htm", 
        "title": "ROUNDDOWN Function", 
        "body": "The ROUNDDOWN function is one of the math and trigonometry functions. It is used to round the number down to the desired number of digits. Syntax ROUNDDOWN(number, num_digits) The ROUNDDOWN function has the following arguments: Argument Description number The number you wish to round down. num_digits The number of digits you wish to round down to. Notes How to apply the ROUNDDOWN function. Examples The figure below displays the result returned by the ROUNDDOWN function."
    },
   {
        "id": "Functions/roundup.htm", 
        "title": "ROUNDUP Function", 
        "body": "The ROUNDUP function is one of the math and trigonometry functions. It is used to round the number up to the desired number of digits. Syntax ROUNDUP(number, num_digits) The ROUNDUP function has the following arguments: Argument Description number The number you wish to round up. num_digits The number of digits you wish to round up to. Notes How to apply the ROUNDUP function. Examples The figure below displays the result returned by the ROUNDUP function."
    },
   {
        "id": "Functions/row.htm", 
        "title": "ROW Function", 
        "body": "The ROW function is one of the lookup and reference functions. It is used to return the row number of a cell reference. Syntax ROW([reference]) The ROW function has the following argument: Argument Description reference A reference to a cell. Notes reference is an optional argument. If the it is omitted, the function will return the row number of a cell in which the ROW function is entered. Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the ROW function. Examples The figure below displays the result returned by the ROW function."
    },
   {
        "id": "Functions/rows.htm", 
        "title": "ROWS Function", 
        "body": "The ROWS function is one of the lookup and reference functions. It is used to return the number of rows in a cell reference. Syntax ROWS(array) The ROWS function has the following argument: Argument Description array A reference to a range of cells. Notes How to apply the ROWS function. Examples The figure below displays the result returned by the ROWS function."
    },
   {
        "id": "Functions/rri.htm", 
        "title": "RRI Function", 
        "body": "The RRI function is one of the financial functions. It is used to return an equivalent interest rate for the growth of an investment. Syntax RRI(nper, pv, fv) The RRI function has the following arguments: Argument Description nper A number of periods for the investment. pv A present value of the investment. fv A future value of the investment. Notes How to apply the RRI function. Examples The figure below displays the result returned by the RRI function."
    },
   {
        "id": "Functions/rsq.htm", 
        "title": "RSQ Function", 
        "body": "The RSQ function is one of the statistical functions. It is used to return the square of the Pearson product moment correlation coefficient. Syntax RSQ(known_y's, known_x's) The RSQ function has the following arguments: Argument Description known_y's The dependent data range. known_x's The independent data range with the same number of elements as known_y's contains. Notes If known_y's or known_x's contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the RSQ function. Examples The figure below displays the result returned by the RSQ function."
    },
   {
        "id": "Functions/search.htm", 
        "title": "SEARCH/SEARCHB Function", 
        "body": "The SEARCH/SEARCHB function is one of the text and data functions. Is used to return the location of the specified substring in a string. The SEARCH function is intended for languages that use the single-byte character set (SBCS), while SEARCHB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax SEARCH(find_text, within_text, start_num) SEARCHB(find_text, within_text, start_num) The SEARCH/SEARCHB function has the following arguments: Argument Description find_text The substring to find. within_text The string to search within. start_num The position to start searching from. It is an optional argument. If it is omitted, the function will perform the search from the beginning of within_text. Notes The SEARCH/SEARCHB function is NOT case-sensitive. If the function does not find the matches, it will return a #VALUE! error. How to apply the SEARCH/SEARCHB function. Examples The figure below displays the result returned by the SEARCH function."
    },
   {
        "id": "Functions/searchb.htm", 
        "title": "SEARCH/SEARCHB Function", 
        "body": "The SEARCH/SEARCHB function is one of the text and data functions. Is used to return the location of the specified substring in a string. The SEARCH function is intended for languages that use the single-byte character set (SBCS), while SEARCHB - for languages that use the double-byte character set (DBCS) like Japanese, Chinese, Korean etc. Syntax SEARCH(find_text, within_text, start_num) SEARCHB(find_text, within_text, start_num) The SEARCH/SEARCHB function has the following arguments: Argument Description find_text The substring to find. within_text The string to search within. start_num The position to start searching from. It is an optional argument. If it is omitted, the function will perform the search from the beginning of within_text. Notes The SEARCH/SEARCHB function is NOT case-sensitive. If the function does not find the matches, it will return a #VALUE! error. How to apply the SEARCH/SEARCHB function. Examples The figure below displays the result returned by the SEARCH function."
    },
   {
        "id": "Functions/sec.htm", 
        "title": "SEC Function", 
        "body": "The SEC function is one of the math and trigonometry functions. It is used to return the secant of an angle specified in radians. Syntax SEC(number) The SEC function has the following argument: Argument Description number The angle in radians that you wish to calculate the secant of. Its absolute value must be less than 2^27. Notes How to apply the SEC function. Examples The figure below displays the result returned by the SEC function."
    },
   {
        "id": "Functions/sech.htm", 
        "title": "SECH Function", 
        "body": "The SECH function is one of the math and trigonometry functions. It is used to return the hyperbolic secant of an angle specified in radians. Syntax SECH(number) The SECH function has the following argument: Argument Description number The angle in radians that you wish to calculate the hyperbolic secant of. Its absolute value must be less than 2^27. Notes How to apply the SECH function. Examples The figure below displays the result returned by the SECH function."
    },
   {
        "id": "Functions/second.htm", 
        "title": "SECOND Function", 
        "body": "The SECOND function is one of the date and time functions. It returns the second (a number from 0 to 59) of the time value. Syntax SECOND(serial_number) The SECOND function has the following argument: Argument Description serial_number The time that contains the second you want to find. Notes The serial_number may be expressed as a string value (e.g. \"13:39:15\"), a decimal number (e.g. 0.56 corresponds to 13:26:24) , or the result of a formula (e.g. the result of the NOW function - 9/26/12 13:39) How to apply the SECOND function. Examples The figure below displays the result returned by the SECOND function."
    },
   {
        "id": "Functions/sequence.htm", 
        "title": "SEQUENCE Function", 
        "body": "The SEQUENCE function is one of the math and trigonometry functions. It is used to generate an array of sequential numbers. Syntax SEQUENCE(rows, [columns], [start], [step]) The SEQUENCE function has the following arguments: Argument Description rows Is used to set the number of rows to return. columns Is used to set the number of columns to return. start Is used to set the first number in the sequence. step Is used to control the increment for each subsequent value in the array. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the SEQUENCE function. Examples The figure below displays the result returned by the SEQUENCE function."
    },
   {
        "id": "Functions/seriessum.htm", 
        "title": "SERIESSUM Function", 
        "body": "The SERIESSUM function is one of the math and trigonometry functions. It is used to return the sum of a power series. Syntax SERIESSUM(x, n, m, coefficients) The SERIESSUM function has the following arguments: Argument Description x The input value to the power series. n The initial power to which you want to raise x. m The step by which you want to increase n for each term in the series. coefficients Coefficients by which each successive power of x is multiplied. The number of coefficients determines the number of terms in the power series. Notes How to apply the SERIESSUM function. Examples The figure below displays the result returned by the SERIESSUM function."
    },
   {
        "id": "Functions/sheet.htm", 
        "title": "SHEET Function", 
        "body": "The SHEET function is one of the information functions. It is used to return the sheet number of the reference sheet. Syntax SHEET([value]) The SHEET function has the following argument: Argument Description value The name of a sheet or a reference for which you want the sheet number. It is an optional argument. If value is omitted, the current sheet number is returned. Notes How to apply the SHEET function. Examples The figure below displays the result returned by the SHEET function."
    },
   {
        "id": "Functions/sheets.htm", 
        "title": "SHEETS Function", 
        "body": "The SHEETS function is one of the information functions. It is used to return the number of sheets in a reference. Syntax SHEETS([reference]) The SHEETS function has the following argument: Argument Description reference A reference for which you want to find out the number of sheets it contains. It is an optional argument. If reference is omitted, the number of sheets in the current workbook is returned. Notes How to apply the SHEETS function. Examples The figure below displays the result returned by the SHEETS function."
    },
   {
        "id": "Functions/sign.htm", 
        "title": "SIGN Function", 
        "body": "The SIGN function is one of the math and trigonometry functions. It is used to return the sign of a number. If the number is positive, the function returns 1. If the number is negative, the function returns -1. If the number is 0, the function returns 0. Syntax SIGN(number) The SIGN function has the following argument: Argument Description number A numeric value for which you want to get the sign. Notes How to apply the SIGN function. Examples The required argument is A1, where A1 is 12. The number is positive, so the function returns 1. If we change the A1 value from 12 to -12, the function returns -1:"
    },
   {
        "id": "Functions/sin.htm", 
        "title": "SIN Function", 
        "body": "The SIN function is one of the math and trigonometry functions. It is used to return the sine of an angle. Syntax SIN(number) The SIN function has the following argument: Argument Description number A numeric value for which you want to get the sine. Notes How to apply the SIN function. Examples The figure below displays the result returned by the SIN function."
    },
   {
        "id": "Functions/sinh.htm", 
        "title": "SINH Function", 
        "body": "The SINH function is one of the math and trigonometry functions. It is used to return the hyperbolic sine of a number. Syntax SINH(number) The SINH function has the following argument: Argument Description number A numeric value for which you want to get the hyperbolic sine. Notes How to apply the SINH function. Examples The figure below displays the result returned by the SINH function."
    },
   {
        "id": "Functions/skew-p.htm", 
        "title": "SKEW.P Function", 
        "body": "The SKEW.P function is one of the statistical functions. It is used to return the skewness of a distribution based on a population: a characterization of the degree of asymmetry of a distribution around its mean. Syntax SKEW.P(number1, [number2], ...) The SKEW.P function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to get the skewness of a distribution. Notes If a reference argument contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the SKEW.P function. Examples The figure below displays the result returned by the SKEW.P function."
    },
   {
        "id": "Functions/skew.htm", 
        "title": "SKEW Function", 
        "body": "The SKEW function is one of the statistical functions. It is used to analyze the range of data and return the skewness of a distribution of the argument list. Syntax SKEW(number1, [number2], ...) The SKEW function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to get the skewness of a distribution. Notes How to apply the SKEW function. Examples The figure below displays the result returned by the SKEW function."
    },
   {
        "id": "Functions/sln.htm", 
        "title": "SLN Function", 
        "body": "The SLN function is one of the financial functions. It is used to calculate the depreciation of an asset for one accounting period using the straight-line depreciation method. Syntax SLN(cost, salvage, life) The SLN function has the following arguments: Argument Description cost The cost of the asset. salvage The salvage value of the asset at the end of its lifetime. life The total number of the periods within the asset lifetime. Notes How to apply the SLN function. Examples The figure below displays the result returned by the SLN function."
    },
   {
        "id": "Functions/slope.htm", 
        "title": "SLOPE Function", 
        "body": "The SLOPE function is one of the statistical functions. It is used to return the slope of the linear regression line through data in two arrays. Syntax SLOPE(known_y's, known_x's) The SLOPE function has the following arguments: Argument Description known_y's The dependent data range. known_x's The independent data range with the same number of elements as known_y's contains. Notes If known_y's or known_x's contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the SLOPE function. Examples The figure below displays the result returned by the SLOPE function."
    },
   {
        "id": "Functions/small.htm", 
        "title": "SMALL Function", 
        "body": "The SMALL function is one of the statistical functions. It is used to analyze the range of data and find the k-th smallest value. Syntax SMALL(array , k) The SMALL function has the following arguments: Argument Description array The selected range of cells you want to analyze. k The position of the number from the smallest value, a numeric value greater than 0. Notes How to apply the SMALL function. Examples The figure below displays the result returned by the SMALL function."
    },
   {
        "id": "Functions/sort.htm", 
        "title": "SORT Function", 
        "body": "The SORT function is one of the lookup and reference functions. It is used to sort a range of data or an array and to return the sorted array. Syntax SORT(array, [sort_index], [sort_order], [by_col]) The SORT function has the following arguments: Argument Description array The range of data to sort. sort_index An optional argument. A number identifying the column or the row to sort by. sort_order An optional argument. A number determining the sorting order: 1 or omitted for ascending order (by default), -1 for descending order. by_col An optional argument. A value indicating the sorting direction: FALSE or omitted for sorting by rows when your data is organized vertically. TRUE for sorting by columns when your data is organized horizontally. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the SORT function. Examples The figure below displays the result returned by the SORT function."
    },
   {
        "id": "Functions/sortby.htm", 
        "title": "SORTBY Function", 
        "body": "The SORTBY function is one of the lookup and reference functions. It is used to sort a range of data or an array based on the values in a corresponding range or array. Syntax SORTBY(array, by_array, [sort_order], ...) The SORTBY function has the following arguments: Argument Description array A range of data to sort. by_array An array or range used for sorting. sort_order An optional argument. A number determining the sorting order. The possible values are listed in the table below. The sort_order argument can be one of the following: Numeric value Meaning 1 or omitted Ascending order (by default) -1 Descending order Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the SORTBY function. Examples The figure below displays the result returned by the SORTBY function."
    },
   {
        "id": "Functions/sqrt.htm", 
        "title": "SQRT Function", 
        "body": "The SQRT function is one of the math and trigonometry functions. It is used to return the square root of a number. Syntax SQRT(number) The SQRT function has the following argument: Argument Description number A numeric value for which you want to get the square root. Notes If the number value is negative, the function returns the #NUM! error. How to apply the SQRT function. Examples The figure below displays the result returned by the SQRT function."
    },
   {
        "id": "Functions/sqrtpi.htm", 
        "title": "SQRTPI Function", 
        "body": "The SQRTPI function is one of the math and trigonometry functions. It is used to return the square root of the pi constant (3.14159265358979) multiplied by the specified number. Syntax SQRTPI(number) The SQRTPI function has the following argument: Argument Description number The number you wish to multiply the pi constant by. Notes If the number value is negative, the function returns the #NUM! error. How to apply the SQRTPI function. Examples The figure below displays the result returned by the SQRTPI function."
    },
   {
        "id": "Functions/standardize.htm", 
        "title": "STANDARDIZE Function", 
        "body": "The STANDARDIZE function is one of the statistical functions. It is used to return a normalized value from a distribution characterized by the specified parameters. Syntax STANDARDIZE(x, mean, standard_dev) The STANDARDIZE function has the following arguments: Argument Description x The value you want to normalize. mean The arithmetic mean of the distribution. standard_dev The standard deviation of the distribution, greater than 0. Notes How to apply the STANDARDIZE function. Examples The figure below displays the result returned by the STANDARDIZE function."
    },
   {
        "id": "Functions/stdev-p.htm", 
        "title": "STDEV.P Function", 
        "body": "The STDEV.P function is one of the statistical functions. It is used to calculate standard deviation based on the entire population given as arguments (ignores logical values and text). Syntax STDEV.P(number1, [number2], ...) The STDEV.P function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate the standard deviation. Notes If a reference argument contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the STDEV.P function. Examples The figure below displays the result returned by the STDEV.P function."
    },
   {
        "id": "Functions/stdev-s.htm", 
        "title": "STDEV.S Function", 
        "body": "The STDEV.S function is one of the statistical functions. It is used to estimate standard deviation based on a sample (ignores logical values and text in the sample). Syntax STDEV.S(number1, [number2], ...) The STDEV.S function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate the standard deviation. Notes If a reference argument contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the STDEV.S function. Examples The figure below displays the result returned by the STDEV.S function."
    },
   {
        "id": "Functions/stdev.htm", 
        "title": "STDEV Function", 
        "body": "The STDEV function is one of the statistical functions. It is used to analyze the range of data and return the standard deviation of a population based on a set of numbers. Syntax STDEV(number1, [number2], ...) The STDEV function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate the standard deviation. Notes If a reference argument contains text, logical values, or empty cells, the function will ignore those values, but treat the cells with the zero values. How to apply the STDEV function. Examples The figure below displays the result returned by the STDEV function."
    },
   {
        "id": "Functions/stdeva.htm", 
        "title": "STDEVA Function", 
        "body": "The STDEVA function is one of the statistical functions. It is used to analyze the range of data and return the standard deviation of a population based on a set of numbers, text, and logical values (TRUE or FALSE). The STDEVA function treats text and FALSE as a value of 0 and TRUE as a value of 1. Syntax STDEVA(value1, [value2], ...) The STDEVA function has the following arguments: Argument Description value1/2/n Up to 255 values for which you want to calculate the standard deviation. Notes How to apply the STDEVA function. Examples The figure below displays the result returned by the STDEVA function."
    },
   {
        "id": "Functions/stdevp.htm", 
        "title": "STDEVP Function", 
        "body": "The STDEVP function is one of the statistical functions. It is used to analyze the range of data and return the standard deviation of an entire population. Syntax STDEVP(number1, [number2], ...) The STDEVP function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate the standard deviation. Notes How to apply the STDEVP function. Examples The figure below displays the result returned by the STDEVP function."
    },
   {
        "id": "Functions/stdevpa.htm", 
        "title": "STDEVPA Function", 
        "body": "The STDEVPA function is one of the statistical functions. It is used to analyze the range of data and return the standard deviation of an entire population. Syntax STDEVPA(value1, [value2], ...) The STDEVPA function has the following arguments: Argument Description value1/2/n Up to 255 values for which you want to calculate the standard deviation. Notes Text and FALSE values are counted as 0, TRUE values are counted as 1, empty cells are ignored. How to apply the STDEVPA function. Examples The figure below displays the result returned by the STDEVPA function."
    },
   {
        "id": "Functions/steyx.htm", 
        "title": "STEYX Function", 
        "body": "The STEYX function is one of the statistical functions. It is used to return the standard error of the predicted y-value for each x in the regression line. Syntax STEYX(known_y's, known_x's) The STEYX function has the following arguments: Argument Description known_y's An array of the dependent variables. known_x's An array of the independent variables with the same number of elements as known_y's contains. Notes Empty cells, logical values, text, or error values supplied as part of an array are ignored. If they are supplied directly to the function, text representations of numbers and logical values are interpreted as numbers. The known_y's and known_x's must contain the same number of data values otherwise the function will return the #N/A error value. How to apply the STEYX function. Examples The figure below displays the result returned by the STEYX function."
    },
   {
        "id": "Functions/substitute.htm", 
        "title": "SUBSTITUTE Function", 
        "body": "The SUBSTITUTE function is one of the text and data functions. Is used to replace a set of characters with a new one. Syntax SUBSTITUTE(text, old_text, new_text, [instance_num]) The SUBSTITUTE function has the following arguments: Argument Description text The string to perform the substitution within. old_text The string to replace. new_text The string to replace with. instance_num The number of occurences to repleace. It is an optional argument, if omitted, the function will replace all the occurences within text. Notes How to apply the SUBSTITUTE function. Examples The figure below displays the result returned by the SUBSTITUTE function."
    },
   {
        "id": "Functions/subtotal.htm", 
        "title": "SUBTOTAL Function", 
        "body": "The SUBTOTAL function is one of the math and trigonometry functions. The function is used to return a subtotal in a list or database. Syntax SUBTOTAL(function_num, ref1, [ref2], ...) The SUBTOTAL function has the following arguments: Argument Description function_num A numeric value that specifies which function to use for the subtotal. The possible values are listed in the table below. For the function_num arguments 1 to 11, the SUBTOTAL function includes values of the rows that have been hidden manually. For the function_num arguments 101 to 111, the SUBTOTAL function ignores values of the rows that have been hidden manually. Values hidden by the filter are always excluded. ref1/2/n Up to 255 references to the cell range containing the values for which you want the subtotal. The function_num argument can be one of the following: function-number (includes hidden values) function-number (excludes hidden values) Function 1 101 AVERAGE 2 102 COUNT 3 103 COUNTA 4 104 MAX 5 105 MIN 6 106 PRODUCT 7 107 STDEV 8 108 STDEVP 9 109 SUM 10 110 VAR 11 111 VARP Notes How to apply the SUBTOTAL function. Examples The figure below displays the result returned by the SUBTOTAL function. The figure below displays the result returned by the SUBTOTAL function when several rows are hidden."
    },
   {
        "id": "Functions/sum.htm", 
        "title": "SUM Function", 
        "body": "The SUM function is one of the math and trigonometry functions. It is used to add all the numbers in the selected range of cells and return the result. Syntax SUM(number1, [number2], ...) The SUM function has the following arguments: Argument Description number1/2/n Up to 255 numeric values that you want to add. Notes How to apply the SUM function. Examples The figure below displays the result returned by the SUM function."
    },
   {
        "id": "Functions/sumif.htm", 
        "title": "SUMIF Function", 
        "body": "The SUMIF function is one of the math and trigonometry functions. It is used to add all the numbers in the selected range of cells based on the specified criterion and return the result. Syntax SUMIF(range, criteria, [sum_range]) The SUMIF function has the following arguments: Argument Description range The selected range of cells to apply the criterion to. criteria The criterion used to determine the cells to sum, a value entered manually or included into the cell you make reference to. sum_range The range of cells to sum. It is an optional argument, if omitted, the function will sum the numbers of range. Notes You can use wildcard characters when specifying criteria. The question mark \"?\" can replace any single character and the asterisk \"*\" can be used instead of any number of characters. How to apply the SUMIF function. Examples The figure below displays the result returned by the SUMIF function."
    },
   {
        "id": "Functions/sumifs.htm", 
        "title": "SUMIFS Function", 
        "body": "The SUMIFS function is one of the math and trigonometry functions. It is used to add all the numbers in the selected range of cells based on multiple criteria and return the result. Syntax SUMIFS(sum_range, criteria_range1, criteria1, [criteria_range2, criteria2], ...) The SUMIFS function has the following arguments: Argument Description sum_range The range of cells to sum. criteria_range1 The first selected range of cells to apply the criteria1 to. criteria1 The first condition that must be met. It is applied to the criteria_range1 and used to determine the cells in the sum_range to sum. It can be a value entered manually or included into the cell you make reference to. criteria-range2, criteria2, ... Additional ranges of cells and their corresponding criteria. These arguments are optional. Notes You can use wildcard characters when specifying criteria. The question mark \"?\" can replace any single character and the asterisk \"*\" can be used instead of any number of characters. How to apply the SUMIFS function. Examples The figure below displays the result returned by the SUMIFS function."
    },
   {
        "id": "Functions/sumproduct.htm", 
        "title": "SUMPRODUCT Function", 
        "body": "The SUMPRODUCT function is one of the math and trigonometry functions. It is used to multiply the values in the selected ranges of cells or arrays and return the sum of the products. Syntax SUMPRODUCT(array1, [array2], [array3], ...) The SUMPRODUCT function has the following arguments: Argument Description array1/2/3/n Up to 255 ranges of cells or arrays containing numeric values. Notes If the array1/2/3/n contains non-numeric values, the function will treat them as 0. How to apply the SUMPRODUCT function. Examples The figure below displays the result returned by the SUMPRODUCT function."
    },
   {
        "id": "Functions/sumsq.htm", 
        "title": "SUMSQ Function", 
        "body": "The SUMSQ function is one of the math and trigonometry functions. It is used to add the squares of numbers and return the result. Syntax SUMSQ(number1, [number2], ...) The SUMSQ function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate the sum of the squares. Notes How to apply the SUMSQ function. Examples The figure below displays the result returned by the SUMSQ function."
    },
   {
        "id": "Functions/sumx2my2.htm", 
        "title": "SUMX2MY2 Function", 
        "body": "The SUMX2MY2 function is one of the math and trigonometry functions. It is used to sum the difference of squares between two arrays. Syntax SUMX2MY2(array_x, array_y) The SUMX2MY2 function has the following arguments: Argument Description array_x The first range of cells. array_y The second range of cells with the same number of columns and rows as array_x contains. Notes How to apply the SUMX2MY2 function. Examples The figure below displays the result returned by the SUMX2MY2 function."
    },
   {
        "id": "Functions/sumx2py2.htm", 
        "title": "SUMX2PY2 Function", 
        "body": "The SUMX2PY2 function is one of the math and trigonometry functions. It is used to sum the squares of numbers in the selected arrays and return the sum of the results. Syntax SUMX2PY2(array_x, array_y) The SUMX2PY2 function has the following arguments: Argument Description array_x The first range of cells. array_y The second range of cells with the same number of columns and rows as array_x contains. Notes How to apply the SUMX2PY2 function. Examples The figure below displays the result returned by the SUMX2PY2 function."
    },
   {
        "id": "Functions/sumxmy2.htm", 
        "title": "SUMXMY2 Function", 
        "body": "The SUMXMY2 function is one of the math and trigonometry functions. It is used to return the sum of the squares of the differences between corresponding items in the arrays. Syntax SUMXMY2(array_x, array_y) The SUMXMY2 function has the following arguments: Argument Description array_x The first range of cells. array_y The second range of cells with the same number of columns and rows as array_x contains. Notes How to apply the SUMXMY2 function. Examples The figure below displays the result returned by the SUMXMY2 function."
    },
   {
        "id": "Functions/switch.htm", 
        "title": "SWITCH Function", 
        "body": "The SWITCH function is one of the logical functions. It is used to evaluate one value (called the expression) against a list of values, and returns the result corresponding to the first matching value. If there is no match, an optional default value may be returned. Syntax SWITCH(expression, value1, result1, [default_or_value2, result2], ...) The SWITCH function has the following arguments: Argument Description expression The value that will be compared against value1 ...value126. value1 ...value126 The value that will be compared against expression. result1 ...result126 The result to be returned if the value1 ...value126 matches to the expression. default The result to be returned if there are no matches. If the default argument is not specified and there are no matches, the function returns the #N/A error. Notes You can enter up to 254 arguments i.e. up to 126 pairs of values and results. How to apply the SWITCH function. Examples The figure below displays the result returned by the SWITCH function."
    },
   {
        "id": "Functions/syd.htm", 
        "title": "SYD Function", 
        "body": "The SYD function is one of the financial functions. It is used to calculate the depreciation of an asset for a specified accounting period using the sum of the years' digits method. Syntax SYD(cost, salvage, life, per) The SYD function has the following arguments: Argument Description cost The cost of the asset. salvage The salvage value of the asset at the end of its lifetime. life The total number of the periods within the asset lifetime. per The period you wish to calculate depreciation for. The value must be expressed in the same units as life. Notes How to apply the SYD function. Examples The figure below displays the result returned by the SYD function."
    },
   {
        "id": "Functions/t-dist-2t.htm", 
        "title": "T.DIST.2T Function", 
        "body": "The T.DIST.2T function is one of the statistical functions. Returns the two-tailed Student's t-distribution. The Student's t-distribution is used in the hypothesis testing of small sample data sets. Use this function in place of a table of critical values for the t-distribution. Syntax T.DIST.2T(x, deg_freedom) The T.DIST.2T function has the following arguments: Argument Description x The value at which the function should be calculated. A numeric value greater than 0. deg_freedom The number of degrees of freedom, an integer greater than or equal to 1. Notes How to apply the T.DIST.2T function. Examples The figure below displays the result returned by the T.DIST.2T function."
    },
   {
        "id": "Functions/t-dist-rt.htm", 
        "title": "T.DIST.RT Function", 
        "body": "The T.DIST.RT function is one of the statistical functions. Returns the right-tailed Student's t-distribution. The t-distribution is used in the hypothesis testing of small sample data sets. Use this function in place of a table of critical values for the t-distribution. Syntax T.DIST.RT(x, deg_freedom) The T.DIST.RT function has the following arguments: Argument Description x The value at which the function should be calculated. deg_freedom The number of degrees of freedom, an integer greater than or equal to 1. Notes How to apply the T.DIST.RT function. Examples The figure below displays the result returned by the T.DIST.RT function."
    },
   {
        "id": "Functions/t-dist.htm", 
        "title": "T.DIST Function", 
        "body": "The T.DIST function is one of the statistical functions. Returns the Student's left-tailed t-distribution. The t-distribution is used in the hypothesis testing of small sample data sets. Use this function in place of a table of critical values for the t-distribution. Syntax T.DIST(x, deg_freedom, cumulative) The T.DIST function has the following arguments: Argument Description x The value at which the function should be calculated. deg_freedom The number of degrees of freedom, an integer greater than or equal to 1. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability density function. Notes How to apply the T.DIST function. Examples The figure below displays the result returned by the T.DIST function."
    },
   {
        "id": "Functions/t-inv-2t.htm", 
        "title": "T.INV.2T Function", 
        "body": "The T.INV.2T function is one of the statistical functions. Returns the two-tailed inverse of the Student's t-distribution. Syntax T.INV.2T(probability, deg_freedom) The T.INV.2T function has the following arguments: Argument Description probability The probability associated with the Student's t-distribution. A numeric value greater than 0 but less than 1. deg_freedom The number of degrees of freedom, an integer greater than or equal to 1. Notes How to apply the T.INV.2T function. Examples The figure below displays the result returned by the T.INV.2T function."
    },
   {
        "id": "Functions/t-inv.htm", 
        "title": "T.INV Function", 
        "body": "The T.INV function is one of the statistical functions. Returns the left-tailed inverse of the Student's t-distribution. Syntax T.INV(probability, deg_freedom) The T.INV function has the following arguments: Argument Description probability The probability associated with the Student's t-distribution. A numeric value greater than 0 but less than 1. deg_freedom The number of degrees of freedom, an integer greater than or equal to 1. Notes How to apply the T.INV function. Examples The figure below displays the result returned by the T.INV function."
    },
   {
        "id": "Functions/t-test.htm", 
        "title": "T.TEST Function", 
        "body": "The T.TEST function is one of the statistical functions. It is used to return the probability associated with a Student's t-Test. Use T.TEST to determine whether two samples are likely to have come from the same two underlying populations that have the same mean. Syntax T.TEST(array1, array2, tails, type) The T.TEST function has the following arguments: Argument Description array1 The first range of numeric values. array2 The second range of numeric values. tails The number of distribution tails. If it is 1, the function uses the one-tailed distribution. If it is 2, the function uses the two-tailed distribution. type A numeric value that specifies the kind of t-Test to be performed. The possible values are listed in the table below. The type argument can be one of the following: Numeric value The kind of t-Test 1 Paired 2 Two-sample equal variance (homoscedastic) 3 Two-sample unequal variance (heteroscedastic) Notes How to apply the T.TEST function. Examples The figure below displays the result returned by the T.TEST function."
    },
   {
        "id": "Functions/t.htm", 
        "title": "T Function", 
        "body": "The T function is one of the text and data functions. Is used to check whether the value in the cell (or used as argument) is text or not. In case it is not text, the function returns blank result. In case the value/argument is text, the function returns the same text value. Syntax T(value) The T function has the following argument: Argument Description value The value you want to test. Notes How to apply the T function. Examples There is an argument: value = A1, where A1 is date and time. So the function returns date and time. If we change the A1 data from text to numerical value, the function returns blank result."
    },
   {
        "id": "Functions/take.htm", 
        "title": "TAKE Function", 
        "body": "The TAKE function is one of the lookup and reference functions. It is used to return rows or columns from array start or end. Syntax TAKE(array, rows, [columns]) The TAKE function has the following arguments: Argument Description array Is used to set the array from which to take rows or columns. rows Is used to set the number of rows to take. A negative value takes from the end of the array. columns Is used to set the number of columns to take. A negative value takes from the end of the array. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the TAKE function. Examples The figure below displays the result returned by the TAKE function."
    },
   {
        "id": "Functions/tan.htm", 
        "title": "TAN Function", 
        "body": "The TAN function is one of the math and trigonometry functions. It is used to return the tangent of an angle. Syntax TAN(number) The TAN function has the following argument: Argument Description number The angle in radians that you wish to calculate the tangent of. Notes How to apply the TAN function. Examples The figure below displays the result returned by the TAN function."
    },
   {
        "id": "Functions/tanh.htm", 
        "title": "TANH Function", 
        "body": "The TANH function is one of the math and trigonometry functions. It is used to return the hyperbolic tangent of a number. Syntax TANH(number) The TANH function has the following argument: Argument Description number A numeric value for which you want to get the hyperbolic tangent. Notes How to apply the TANH function. Examples The figure below displays the result returned by the TANH function."
    },
   {
        "id": "Functions/tbilleq.htm", 
        "title": "TBILLEQ Function", 
        "body": "The TBILLEQ function is one of the financial functions. It is used to calculate the bond-equivalent yield of a Treasury bill. Syntax TBILLEQ(settlement, maturity, discount) The TBILLEQ function has the following arguments: Argument Description settlement The date when the Treasury bill is purchased. maturity The date when the Treasury bill expires. This date must be within one year of the settlement date. discount The discount rate of the Treasury bill. Notes Dates must be entered by using the DATE function. How to apply the TBILLEQ function. Examples The figure below displays the result returned by the TBILLEQ function."
    },
   {
        "id": "Functions/tbillprice.htm", 
        "title": "TBILLPRICE Function", 
        "body": "The TBILLPRICE function is one of the financial functions. It is used to calculate the price per $100 par value for a Treasury bill. Syntax TBILLPRICE(settlement, maturity, discount) The TBILLPRICE function has the following arguments: Argument Description settlement The date when the Treasury bill is purchased. maturity The date when the Treasury bill expires. This date must be within one year of the settlement date. discount The discount rate of the Treasury bill. Notes Dates must be entered by using the DATE function. How to apply the TBILLPRICE function. Examples The figure below displays the result returned by the TBILLPRICE function."
    },
   {
        "id": "Functions/tbillyield.htm", 
        "title": "TBILLYIELD Function", 
        "body": "The TBILLYIELD function is one of the financial functions. It is used to calculate the yield of a Treasury bill. Syntax TBILLYIELD(settlement, maturity, pr) The TBILLYIELD function has the following arguments: Argument Description settlement The date when the Treasury bill is purchased. maturity The date when the Treasury bill expires. This date must be within one year of the settlement date. pr The purchase price of the Treasury bill, per $100 par value. Notes Dates must be entered by using the DATE function. How to apply the TBILLYIELD function. Examples The figure below displays the result returned by the TBILLYIELD function."
    },
   {
        "id": "Functions/tdist.htm", 
        "title": "TDIST Function", 
        "body": "The TDIST function is one of the statistical functions. Returns the Percentage Points (probability) for the Student t-distribution where a numeric value (x) is a calculated value of t for which the Percentage Points are to be computed. The t-distribution is used in the hypothesis testing of small sample data sets. Use this function in place of a table of critical values for the t-distribution. Syntax TDIST(x, deg_freedom, tails) The TDIST function has the following arguments: Argument Description x The value at which the function should be calculated. A numeric value greater than 0. deg_freedom The number of degrees of freedom, an integer greater than or equal to 1. tails A numeric value that specifies the number of distribution tails to return. If it is set to 1, the function returns the one-tailed distribution. If it is set to 2, the function returns the two-tailed distribution. Notes How to apply the TDIST function. Examples The figure below displays the result returned by the TDIST function."
    },
   {
        "id": "Functions/text.htm", 
        "title": "TEXT Function", 
        "body": "The TEXT function is one of the text and data functions. Is used to convert a value to a text in the specified format. Syntax TEXT(value, format_text) The TEXT function has the following arguments: Argument Description value A value to convert to text. format_text A format to display the results in. Notes How to apply the TEXT function. Examples The figure below displays the result returned by the TEXT function."
    },
   {
        "id": "Functions/textafter.htm", 
        "title": "TEXTAFTER Function", 
        "body": "The TEXTAFTER function is one of the text and data functions. It is used to return text occurring after delimiting characters. Syntax TEXTAFTER(text, delimiter, [instance_num], [match_mode], [match_end], [if_not_found]) The TEXTAFTER function has the following argument: Argument Description text The text the search is conducted within. Wildcard characters are not allowed. If text is an empty string, the function returns empty text. delimiter The text that marks the point after which the function extracts the text. instance_num An optional argument. The instance of the delimiter after which the function extracts the text. By default, instance_num equals 1. A negative number will start the text search from the end. match_mode An optional argument. It is used to determine whether the text search is case-sensitive. The default is case-sensitive. The following values are used: 0 for case sensitive, 1 for case insensitive. match_end An optional argument. It treats the end of text as a delimiter. By default, the text is an exact match. The following values are used: 0 for not matching the delimiter against the end of the text, 1 for matching the delimiter against the end of the text. if_not_found An optional argument. It sets a value that is returned if no match is found. Notes How to apply the TEXTAFTER function. Examples The figure below displays the result returned by the TEXTAFTER function."
    },
   {
        "id": "Functions/textbefore.htm", 
        "title": "TEXTBEFORE Function", 
        "body": "The TEXTBEFORE function is one of the text and data functions. It is used to return text occurring before delimiting characters. Syntax TEXTBEFORE(text, delimiter, [instance_num], [match_mode], [match_end], [if_not_found]) The TEXTBEFORE function has the following argument: Argument Description text The text the search is conducted within. Wildcard characters are not allowed. If text is an empty string, the function returns empty text. delimiter The text that marks the point before which the function extracts the text. instance_num An optional argument. The instance of the delimiter before which the function extracts the text. By default, instance_num equals 1. A negative number will start the text search from the end. match_mode An optional argument. It is used to determine whether the text search is case-sensitive. The default is case-sensitive. The following values are used: 0 for case sensitive, 1 for case insensitive. match_end An optional argument. It treats the end of text as a delimiter. By default, the text is an exact match. The following values are used: 0 for not matching the delimiter against the end of the text, 1 for matching the delimiter against the end of the text. if_not_found An optional argument. It sets a value that is returned if no match is found. Notes How to apply the TEXTBEFORE function. Examples The figure below displays the result returned by the TEXTBEFORE function."
    },
   {
        "id": "Functions/textjoin.htm", 
        "title": "TEXTJOIN Function", 
        "body": "The TEXTJOIN function is one of the text and data functions. Is used to combine the text from multiple ranges and/or strings, and includes a delimiter you specify between each text value that will be combined; if the delimiter is an empty text string, this function will effectively concatenate the ranges. This function is similar to the CONCAT function, but the difference is that the CONCAT function cannot accept a delimiter. Syntax TEXTJOIN(delimiter, ignore_empty, text1, [text2], ...) The TEXTJOIN function has the following argument: Argument Description delimiter The delimiter to be inserted between the text values. Can be specified as a text string enclosed by double quotes (e.g. \",\" (comma), \" \" (space), \"\\\" (backslash) etc.) or as a reference to a cell or range of cells. ignore_empty A logical value that specifies whether empty cells should be ignored. When the value is set to TRUE, empty cells are ignored. text1/2/n Up to 253 data values. Each value can be a text string or a reference to a range of cells. Notes How to apply the TEXTJOIN function. Examples The figure below displays the result returned by the TEXTJOIN function."
    },
   {
        "id": "Functions/textsplit.htm", 
        "title": "TEXTSPLIT Function", 
        "body": "The TEXTSPLIT function is one of the text and data functions. It is used to split text strings through column and row delimiters. Syntax TEXTSPLIT(text, col_delimiter, [row_delimiter], [ignore_empty], [match_mode], [pad_with]) The TEXTSPLIT function has the following argument: Argument Description text The text you want to split. col_delimiter An optional argument. It is used to set the text that marks the point where to split the text across columns. row_delimiter An optional argument. It is used to set the text that marks the point where to split the text down rows. ignore_empty An optional argument. It is used to specify FALSE to create an empty cell when two delimiters are consecutive. Defaults to TRUE, which creates an empty cell. match_mode An optional argument. It is used to search the text for a delimiter match. By default, a case-sensitive match is done. pad_with Is used to set the value with which to pad the result. Defaults to #N/A. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the TEXTSPLIT function. Examples The figure below displays the result returned by the TEXTSPLIT function."
    },
   {
        "id": "Functions/time.htm", 
        "title": "TIME Function", 
        "body": "The TIME function is one of the date and time functions. It is used to add a particular time in the selected format (hh:mm tt by default). Syntax TIME(hour, minute, second) The TIME function has the following arguments: Argument Description hour A number from 0 to 23. minute A number from 0 to 59. second A number from 0 to 59. Notes How to apply the TIME function. Examples The figure below displays the result returned by the TIME function."
    },
   {
        "id": "Functions/timevalue.htm", 
        "title": "TIMEVALUE Function", 
        "body": "The TIMEVALUE function is one of the date and time functions. It is used to return the serial number of a time. Syntax TIMEVALUE(time_text) The TIMEVALUE function has the following argument: Argument Description time_text A text string that represents a time, e.g. \"4:30 PM\" or \"16:30\". Notes How to apply the TIMEVALUE function. Examples The figure below displays the result returned by the TIMEVALUE function."
    },
   {
        "id": "Functions/tinv.htm", 
        "title": "TINV Function", 
        "body": "The TINV function is one of the statistical functions. Returns the two-tailed inverse of the Student's t-distribution. Syntax TINV(probability, deg_freedom) The TINV function has the following arguments: Argument Description probability The probability associated with the two-tailed Student's t-distribution. A numeric value greater than 0 but less than or equal to 1. deg_freedom The number of degrees of freedom, an integer greater than or equal to 1. Notes How to apply the TINV function. Examples The figure below displays the result returned by the TINV function."
    },
   {
        "id": "Functions/tocol.htm", 
        "title": "TOCOL Function", 
        "body": "The TOCOL function is one of the lookup and reference functions. It is used to return the array as one column. Syntax TOCOL (array, [ignore], [scan_by_column]) The TOCOL function has the following arguments: Argument Description array The array or reference to return as a column. ignore Is used to set whether to ignore certain types of values. Defaults to ignoring no values. The following values are used: 0 to keep all values (default); 1 to ignore blanks; 2 to ignore errors; 3 to ignore blanks and errors. scan_by_column Is used to scan the array by column. By default, array scanning is conducted by row. Scanning determines whether the values are arranged in rows or columns. A logical value (TRUE or FALSE). Notes If scan_by_column is omitted or FALSE, the array is scanned by row. If it is TRUE, the array is scanned by column. Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the TOCOL function. Examples The figure below displays the result returned by the TOCOL function."
    },
   {
        "id": "Functions/today.htm", 
        "title": "TODAY Function", 
        "body": "The TODAY function is one of the date and time functions. It is used to add the current day in the following format MM/dd/yy. This function does not require an argument. Syntax TODAY() Notes How to apply the TODAY function. Examples The figure below displays the result returned by the TODAY function."
    },
   {
        "id": "Functions/torow.htm", 
        "title": "TOROW Function", 
        "body": "The TOROW function is one of the lookup and reference functions. It is used to return the array as one row. Syntax TOROW (array, [ignore], [scan_by_column]) The TOROW function has the following arguments: Argument Description array The array or reference to return as a row. ignore Is used to set whether to ignore certain types of values. Defaults to ignoring no values. The following values are used: 0 to keep all values (default); 1 to ignore blanks; 2 to ignore errors; 3 to ignore blanks and errors. scan_by_column Is used to scan the array by column. By default, array scanning is conducted by row. Scanning determines whether the values are arranged in rows or columns. A logical value (TRUE or FALSE). Notes If scan_by_column is omitted or FALSE, the array is scanned by row. If it is TRUE, the array is scanned by column. Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the TOROW function. Examples The figure below displays the result returned by the TOROW function."
    },
   {
        "id": "Functions/transpose.htm", 
        "title": "TRANSPOSE Function", 
        "body": "The TRANSPOSE function is one of the lookup and reference functions. It is used to convert columns into rows and rows into columns. Syntax TRANSPOSE(array) The TRANSPOSE function has the following arguments: Argument Description array A reference to a range of cells. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the TRANSPOSE function. Examples The figure below displays the result returned by the TRANSPOSE function."
    },
   {
        "id": "Functions/trend.htm", 
        "title": "TREND Function", 
        "body": "The TREND function is one of the statistical functions. It is used to calculate a linear trend line and returns values along it using the method of least squares. Syntax TREND(known_y’s, [known_x’s], [new_x’s], [const]) The TREND function has the following arguments: Argument Description known_y’s The set of y-values you already know in the y = mx + b equation. known_x’s The optional set of x-values you might know in the y = mx + b equation. new_x’s The optional set of x-values you want y-values to be returned to. const An optional argument. It is a TRUE or FALSE value where TRUE or lack of the argument forces b to be calculated normally and FALSE sets b to 0 in the y = mx + b equation and m-values correspond with the y = mx equation. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the TREND function. Examples The figure below displays the result returned by the TREND function."
    },
   {
        "id": "Functions/trim.htm", 
        "title": "TRIM Function", 
        "body": "The TRIM function is one of the text and data functions. Is used to remove the leading and trailing spaces from a string. Syntax TRIM(text) The TRIM function has the following argument: Argument Description text A text value from which you want to remove spaces. Notes How to apply the TRIM function. Examples The figure below displays the result returned by the TRIM function."
    },
   {
        "id": "Functions/trimmean.htm", 
        "title": "TRIMMEAN Function", 
        "body": "The TRIMMEAN function is one of the statistical functions. It is used to return the mean of the interior of a data set. TRIMMEAN calculates the mean taken by excluding a percentage of data points from the top and bottom tails of a data set. Syntax TRIMMEAN(array, percent) The TRIMMEAN function has the following arguments: Argument Description array The range of numeric values to trim and average. percent A total percent of data points to exclude from the calculation. A numeric value greater than or equal to 0 but less than 1. The number of excluded data points is rounded down to the nearest multiple of 2. E.g., if array contains 30 values and percent is 0.1, 10 percent of 30 points is 3. This value is rounded down to 2, so 1 point is trimmed from each tail of the data set: 1 from the top and 1 from the bottom of the set. Notes How to apply the TRIMMEAN function. Examples The figure below displays the result returned by the TRIMMEAN function."
    },
   {
        "id": "Functions/true.htm", 
        "title": "TRUE Function", 
        "body": "The TRUE function is one of the logical functions. The function returns TRUE and does not require any argument. Syntax TRUE() Notes How to apply the TRUE function. Examples The figure below displays the result returned by the TRUE function."
    },
   {
        "id": "Functions/trunc.htm", 
        "title": "TRUNC Function", 
        "body": "The TRUNC function is one of the math and trigonometry functions. It is used to return a number truncated to a specified number of digits. Syntax TRUNC(number, [num_digits]) The TRUNC function has the following arguments: Argument Description number A number to truncate. num_digits A number of decimal places to display. It is an optional argument. If omitted, the function will assume it to be 0. Notes How to apply the TRUNC function. Examples The figure below displays the result returned by the TRUNC function."
    },
   {
        "id": "Functions/ttest.htm", 
        "title": "TTEST Function", 
        "body": "The TTEST function is one of the statistical functions. It is used to return the probability associated with a Student's t-Test. Use TTEST to determine whether two samples are likely to have come from the same two underlying populations that have the same mean. Syntax TTEST(array1, array2, tails, type) The TTEST function has the following arguments: Argument Description array1 The first range of numeric values. array2 The second range of numeric values. tails The number of distribution tails. If it is 1, the function uses the one-tailed distribution. If it is 2, the function uses the two-tailed distribution. type A numeric value that specifies the kind of t-Test to be performed. The possible values are listed in the table below. The type argument can be one of the following: Numeric value The kind of t-Test 1 Paired 2 Two-sample equal variance (homoscedastic) 3 Two-sample unequal variance (heteroscedastic) Notes How to apply the TTEST function. Examples The figure below displays the result returned by the TTEST function."
    },
   {
        "id": "Functions/type.htm", 
        "title": "TYPE Function", 
        "body": "The TYPE function is one of the information functions. It is used to determine the type of the resulting or displayed value. Syntax TYPE(value) The TYPE function has the following argument: Argument Description value A value to test. The possible values are listed in the table below. The value argument can be one of the following: Value Result number 1 text 2 logical value 4 error value 16 array 64 Notes How to apply the TYPE function. Examples The figure below displays the result returned by the TYPE function."
    },
   {
        "id": "Functions/unichar.htm", 
        "title": "UNICHAR Function", 
        "body": "The UNICHAR function is one of the text and data functions. Is used to return the Unicode character that is referenced by the given numeric value. Syntax UNICHAR(number) The UNICHAR function has the following argument: Argument Description number The Unicode number that represents the character. Notes How to apply the UNICHAR function. Examples The figure below displays the result returned by the UNICHAR function."
    },
   {
        "id": "Functions/unicode.htm", 
        "title": "UNICODE Function", 
        "body": "The UNICODE function is one of the text and data functions. Is used to return the number (code point) corresponding to the first character of the text. Syntax UNICODE(text) The UNICODE function has the following argument: Argument Description text The text string beginning with the character you want to get the Unicode value for. Notes How to apply the UNICODE function. Examples The figure below displays the result returned by the UNICODE function."
    },
   {
        "id": "Functions/unique.htm", 
        "title": "UNIQUE Function", 
        "body": "The UNIQUE function is one of the lookup and reference functions. It is used to return a list of unique values from the specified range. Syntax UNIQUE(array, [by_col], [exactly_once]) The UNIQUE function has the following arguments: Argument Description array The range from which to extract unique values. by_col The optional TRUE or FALSE value indicating the method of comparison: TRUE for columns and FALSE for rows. exactly_once The optional TRUE or FALSE value indicating the returning method: TRUE for values occurring once and FALSE for all unique values. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the UNIQUE function. Examples The figure below displays the result returned by the UNIQUE function."
    },
   {
        "id": "Functions/upper.htm", 
        "title": "UPPER Function", 
        "body": "The UPPER function is one of the text and data functions. Is used to convert lowercase letters to uppercase in the selected cell. Syntax UPPER(text) The UPPER function has the following argument: Argument Description text The text you want to convert to uppercase. Notes How to apply the UPPER function. Examples The figure below displays the result returned by the UPPER function."
    },
   {
        "id": "Functions/value.htm", 
        "title": "VALUE Function", 
        "body": "The VALUE function is one of the text and data functions. Is used to convert a text value that represents a number to a number. If the converted text is not a number, the function will return a #VALUE! error. Syntax VALUE(text) The VALUE function has the following argument: Argument Description text Text data that represents a number. Notes How to apply the VALUE function. Examples The figure below displays the result returned by the VALUE function."
    },
   {
        "id": "Functions/var-p.htm", 
        "title": "VAR.P Function", 
        "body": "The VAR.P function is one of the statistical functions. It is used to calculate variance based on the entire population (ignores logical values and text in the population). Syntax VAR.P(number1, [number2], ...) The VAR.P function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate the variance. Notes Empty cells, logical values, text, or error values supplied as part of an array are ignored. If they are supplied directly to the function, text representations of numbers and logical values are interpreted as numbers. How to apply the VAR.P function. Examples The figure below displays the result returned by the VAR.P function."
    },
   {
        "id": "Functions/var-s.htm", 
        "title": "VAR.S Function", 
        "body": "The VAR.S function is one of the statistical functions. It is used to estimate variance based on a sample (ignores logical values and text in the sample). Syntax VAR.S(number1, [number2], ...) The VAR.S function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate the variance. Notes Empty cells, logical values, text, or error values supplied as part of an array are ignored. If they are supplied directly to the function, text representations of numbers and logical values are interpreted as numbers. How to apply the VAR.S function. Examples The figure below displays the result returned by the VAR.S function."
    },
   {
        "id": "Functions/var.htm", 
        "title": "VAR Function", 
        "body": "The VAR function is one of the statistical functions. It is used to analyze the set of values and calculate the sample variance. Syntax VAR(number1, [number2], ...) The VAR function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate the variance. Notes Empty cells, logical values, text, or error values supplied as part of an array are ignored. If they are supplied directly to the function, text representations of numbers and logical values are interpreted as numbers. How to apply the VAR function. Examples The figure below displays the result returned by the VAR function."
    },
   {
        "id": "Functions/vara.htm", 
        "title": "VARA Function", 
        "body": "The VARA function is one of the statistical functions. It is used to analyze the set of values and calculate the sample variance. Syntax VARA(value1, [value2], ...) The VARA function has the following arguments: Argument Description value1/2/n Up to 255 values for which you want to calculate the variance. Notes Text and FALSE values are counted as 0, TRUE values are counted as 1, empty cells are ignored. How to apply the VARA function. Examples The figure below displays the result returned by the VARA function."
    },
   {
        "id": "Functions/varp.htm", 
        "title": "VARP Function", 
        "body": "The VARP function is one of the statistical functions. It is used to analyze the set of values and calculate the variance of an entire population. Syntax VARP(number1, [number2], ...) The VARP function has the following arguments: Argument Description number1/2/n Up to 255 numeric values for which you want to calculate the variance. Notes Empty cells, logical values, text, or error values supplied as part of an array are ignored. If they are supplied directly to the function, text representations of numbers and logical values are interpreted as numbers. How to apply the VARP function. Examples The figure below displays the result returned by the VARP function."
    },
   {
        "id": "Functions/varpa.htm", 
        "title": "VARPA Function", 
        "body": "The VARPA function is one of the statistical functions. It is used to analyze the set of values and return the variance of an entire population. Syntax VARPA(value1, [value2], ...) The VARPA function has the following arguments: Argument Description value1/2/n Up to 255 values for which you want to calculate the variance. Notes Text and FALSE values are counted as 0, TRUE values are counted as 1, empty cells are ignored. How to apply the VARPA function. Examples The figure below displays the result returned by the VARPA function."
    },
   {
        "id": "Functions/vdb.htm", 
        "title": "VDB Function", 
        "body": "The VDB function is one of the financial functions. It is used to calculate the depreciation of an asset for a specified or partial accounting period using the variable declining balance method. Syntax VDB(cost, salvage, life, start_period, end_period, [factor], [no_switch]) The VDB function has the following arguments: Argument Description cost The cost of the asset. salvage The salvage value of the asset at the end of its lifetime. life The total number of the periods within the asset lifetime. start_period A starting period you wish to calculate depreciation for. The value must be expressed in the same units as life. end_period An ending period you wish to calculate depreciation for. The value must be expressed in the same units as life. factor The rate at which the balance declines. It is an optional argument. If it is omitted, the function will assume factor to be 2. no_switch The optional argument that specifies whether to use straight-line depreciation when depreciation is greater than the declining balance calculation. If it is set to FALSE or omitted, the function uses the straight-line depreciation method. If it is set to TRUE, the function uses the declining balance method. Notes All the numeric values must be positive numbers. How to apply the VDB function. Examples The figure below displays the result returned by the VDB function."
    },
   {
        "id": "Functions/vlookup.htm", 
        "title": "VLOOKUP Function", 
        "body": "The VLOOKUP function is one of the lookup and reference functions. It is used to perform the vertical search for a value in the left-most column of a table or an array and return the value in the same row based on a specified column index number. Syntax VLOOKUP (lookup_value, table_array, col_index_num, [range_lookup]) The VLOOKUP function has the following arguments: Argument Description lookup_value A value to search for. table_array Two or more columns containing data sorted in ascending order. col_index_num A column number in the table_array, a numeric value greater than or equal to 1 but less than the number of columns in the table_array. range_lookup A logical value TRUE or FALSE. It is an optional argument. Enter FALSE to find an exact match. Enter TRUE or omit this argument to find an approximate match, in this case if there is not a value that strictly matches the lookup_value, then the function will choose the next largest value less than the lookup_value. Notes If the range_lookup is set to FALSE, but no exact match is found, then the function will return the #N/A error. How to apply the VLOOKUP function. Examples The figure below displays the result returned by the VLOOKUP function."
    },
   {
        "id": "Functions/vstack.htm", 
        "title": "VSTACK Function", 
        "body": "The VSTACK function is one of the lookup and reference functions. It is used to vertically stack arrays into one array. Syntax VSTACK (array1, [array2], ...) The VSTACK function has the following arguments: Argument Description array1/2/n Is used to set the arrays to append. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the VSTACK function. Examples The figure below displays the result returned by the VSTACK function."
    },
   {
        "id": "Functions/weekday.htm", 
        "title": "WEEKDAY Function", 
        "body": "The WEEKDAY function is one of the date and time functions. It is used to determine which day of the week the specified date is. Syntax WEEKDAY(serial_number, [return_type]) The WEEKDAY function has the following arguments: Argument Description serial_number A number representing the date of the day you are trying to find, entered using the DATE function or other date and time function. return_type A numeric value used to determine the type of the value to be returned. The possible values are listed in the table below. The return_type argument can be one of the following: Numeric value Explanation 1 or omitted Returns a number from 1 (Sunday) to 7 (Saturday) 2 Returns a number from 1 (Monday) to 7 (Sunday). 3 Returns a number from 0 (Monday) to 6 (Sunday). Notes How to apply the WEEKDAY function. Examples The figure below displays the result returned by the WEEKDAY function."
    },
   {
        "id": "Functions/weeknum.htm", 
        "title": "WEEKNUM Function", 
        "body": "The WEEKNUM function is one of the date and time functions. It used to return the number of the week the specified date falls within the year. Syntax WEEKNUM(serial_number, [return_type]) The WEEKNUM function has the following arguments: Argument Description serial_number A number representing the date within the week, entered using the DATE function or other date and time function. return_type A numeric value used to determine on which day the week begins. The possible values are listed in the table below. The return_type argument can be one of the following: Numeric value Week begins on System 1 or omitted Sunday 1 2 Monday 1 11 Monday 1 12 Tuesday 1 13 Wednesday 1 14 Thursday 1 15 Friday 1 16 Saturday 1 17 Sunday 1 21 Monday 2 Notes When return_type is set to 1-17, System 1 is used. This means that the first week in a year is the week that contains January 1. When return_type is set to 21, System 2 is used. This means that the first week in a year is the week that contains the first Thursday of the year. System 2 is commonly used in Europe according to the ISO 8601 standard. How to apply the WEEKNUM function. Examples The figure below displays the result returned by the WEEKNUM function."
    },
   {
        "id": "Functions/weibull-dist.htm", 
        "title": "WEIBULL.DIST Function", 
        "body": "The WEIBULL.DIST function is one of the statistical functions. It is used to return the Weibull distribution. Use this distribution in reliability analysis, such as calculating a device's mean time to failure. Syntax WEIBULL.DIST(x, alpha, beta, cumulative) The WEIBULL.DIST function has the following arguments: Argument Description x The value between at which the function should be calculated, a numeric value greater than or equal to 0. alpha The first parameter of the distribution, a numeric value greater than 0. beta The second parameter of the distribution, a numeric value greater than 0. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability density function. Notes How to apply the WEIBULL.DIST function. Examples The figure below displays the result returned by the WEIBULL.DIST function."
    },
   {
        "id": "Functions/weibull.htm", 
        "title": "WEIBULL Function", 
        "body": "The WEIBULL function is one of the statistical functions. It is used to return the Weibull distribution. Use this distribution in reliability analysis, such as calculating a device's mean time to failure. Syntax WEIBULL(x, alpha, beta, cumulative) The WEIBULL function has the following arguments: Argument Description x The value between at which the function should be calculated, a numeric value greater than or equal to 0. alpha The first parameter of the distribution, a numeric value greater than 0. beta The second parameter of the distribution, a numeric value greater than 0. cumulative A logical value (TRUE or FALSE) that determines the function form. If it is TRUE, the function returns the cumulative distribution function. If it is FALSE, the function returns the probability density function. Notes How to apply the WEIBULL function. Examples The figure below displays the result returned by the WEIBULL function."
    },
   {
        "id": "Functions/workday-intl.htm", 
        "title": "WORKDAY.INTL Function", 
        "body": "The WORKDAY.INTL function is one of the date and time functions. It is used to return the date before or after a specified number of workdays with custom weekend parameters; weekend parameters indicate which and how many days are weekend days. Syntax WORKDAY.INTL(start_date, days, [weekend], [holidays]) The WORKDAY.INTL function has the following arguments: Argument Description start_date The first date of the period entered using the DATE function or other date and time function. days A number of nonweekend before or after start_date. If the days has the negative sign, the function will return the date which comes before the specified start_date. If the days has the positive sign, the function will return the date which follows after the specified start_date. weekend An optional argument, a number or a string that specifies which days to consider weekends. The possible numbers are listed in the table below. holidays An optional argument that specifies which dates besides weekends are nonworking. You can enter them using the DATE function or other date and time function or specify a reference to a range of cells containing dates. The weekend argument can be one of the following: Number Weekend days 1 or omitted Saturday, Sunday 2 Sunday, Monday 3 Monday, Tuesday 4 Tuesday, Wednesday 5 Wednesday, Thursday 6 Thursday, Friday 7 Friday, Saturday 11 Sunday only 12 Monday only 13 Tuesday only 14 Wednesday only 15 Thursday only 16 Friday only 17 Saturday only Notes A string that specifies weekend days must contain 7 characters. Each character represents a day of the week, starting from Monday. 0 represents a workday, 1 represents a weekend day. E.g. \"0000011\" specifies that weekend days are Saturday and Sunday. The string \"1111111\" is not valid. How to apply the WORKDAY.INTL function. Examples The figure below displays the result returned by the WORKDAY.INTL function."
    },
   {
        "id": "Functions/workday.htm", 
        "title": "WORKDAY Function", 
        "body": "The WORKDAY function is one of the date and time functions. It is used to return the date which comes the indicated number of days (day-offset) before or after the specified start date excluding weekends and dates considered as holidays. Syntax WORKDAY(start_date, days, [holidays]) The WORKDAY function has the following arguments: Argument Description start_date The first date of the period entered using the DATE function or other date and time function. days A number of nonweekend before or after start_date. If the days has the negative sign, the function will return the date which comes before the specified start_date. If the days has the positive sign, the function will return the date which follows after the specified start_date. holidays An optional argument that specifies which dates besides weekends are nonworking. You can enter them using the DATE function or other date and time function or specify a reference to a range of cells containing dates. Notes How to apply the WORKDAY function. Examples The figure below displays the result returned by the WORKDAY function."
    },
   {
        "id": "Functions/wrapcols.htm", 
        "title": "WRAPCOLS Function", 
        "body": "The WRAPCOLS function is one of the lookup and reference functions. It is used to wrap a row or column vector by columns after a specified number of values. Syntax WRAPCOLS(vector, wrap_count, [pad_with]) The WRAPCOLS function has the following arguments: Argument Description vector Is used to set the vector or reference to wrap. wrap_count Is used to set the maximum number of values for each column. pad_with Is used to set the value with which to pad. Defaults to #N/A. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the WRAPCOLS function. Examples The figure below displays the result returned by the WRAPCOLS function. It wraps the row in range A1:F1 to an array in range A3:C5 by columns."
    },
   {
        "id": "Functions/wraprows.htm", 
        "title": "WRAPROWS Function", 
        "body": "The WRAPROWS function is one of the lookup and reference functions. It is used to wrap a row or column vector by rows after a specified number of values. Syntax WRAPROWS(vector, wrap_count, [pad_with]) The WRAPROWS function has the following arguments: Argument Description vector Is used to set the vector or reference to wrap. wrap_count Is used to set the maximum number of values for each row. pad_with Is used to set the value with which to pad. Defaults to #N/A. Notes Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the WRAPROWS function. Examples The figure below displays the result returned by the WRAPROWS function. It wraps the row in range A1:F1 to an array in range A3:C5 by rows."
    },
   {
        "id": "Functions/xirr.htm", 
        "title": "XIRR Function", 
        "body": "The XIRR function is one of the financial functions. It is used to calculate the internal rate of return for a series of irregular cash flows. Syntax XIRR(values, dates, [guess]) The XIRR function has the following arguments: Argument Description values An array that contains the series of payments occuring irregularly. At least one of the values must be negative and at least one positive. dates An array that contains the payment dates when the payments are made or received. Dates must be entered by using the DATE function. guess An estimate at what the internal rate of return will be. It is an optional argument. If it is omitted, the function will assume guess to be 10%. Notes How to apply the XIRR function. Examples The figure below displays the result returned by the XIRR function."
    },
   {
        "id": "Functions/xlookup.htm", 
        "title": "XLOOKUP Function", 
        "body": "The XLOOKUP function is one of the lookup and reference functions. It is used to perform the search for a specific item by row both horizontally and vertically. The result is returned in another column and can accommodate two-dimensional datasets. Syntax XLOOKUP (lookup_value, lookup_array, return_array, [if_not_found], [match_mode], [search_mode]) The XLOOKUP function has the following arguments: Argument Description lookup_value A value to search for. lookup_array An array or range to search in. return_array An array or range to return the results to. if_not_found An optional argument. If there is no search result, the argument returns the text stated in [if_not_found]. In case the text is not specified, the “N/A” is returned. match_mode An optional argument. The possible values are listed in the table below. search_mode An optional argument. The possible values are listed in the table below. The match_mode argument can be one of the following: Value Description 0 Set by default. Returns the exact match; if there is no match, the “N/A” is returned instead. -1 Returns the exact match; if there is none, the next smaller item is returned. 1 Returns the exact match; if there is none, the next larger item is returned. 2 A wildcard match. The search_mode argument can be one of the following: Value Description 1 Set by default. Starts a search at the first item. -1 Starts a reverse search, i.e. at the last item. 2 Starts a binary search with the lookup_array sorted in ascending order. If not sorted, invalid results will be returned. -2 Starts a binary search with the lookup_array sorted in descending order. If not sorted, invalid results will be returned. Notes Wildcard characters include the question mark (?) that matches a single character and the asterisk (*) that matches multiple characters. If you want to find a question mark or asterisk, type a tilde (~) before the character. Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the XLOOKUP function. Examples The figure below displays the result returned by the XLOOKUP function."
    },
   {
        "id": "Functions/xmatch.htm", 
        "title": "XMATCH Function", 
        "body": "The XMATCH function is one of the lookup and reference functions. It is used to return the relative position of an item in an array. By default, an exact match is required. Syntax XMATCH(lookup_value, lookup_array, [match_mode], [search_mode]) The XMATCH function has the following arguments: Argument Description lookup_value A value to search for. lookup_array An array or range to search in. match_mode An optional argument. The possible values are listed in the table below. search_mode An optional argument. The possible values are listed in the table below. The match_mode argument can be one of the following: Value Description 0 Set by default. Returns the exact match; if there is no match, the “N/A” is returned instead. -1 Returns the exact match; if there is none, the next smaller item is returned. 1 Returns the exact match; if there is none, the next larger item is returned. 2 A wildcard match. The search_mode argument can be one of the following: Value Description 1 Set by default. Starts a search at the first item. -1 Starts a reverse search, i.e. at the last item. 2 Starts a binary search with the lookup_array sorted in ascending order. If not sorted, invalid results will be returned. -2 Starts a binary search with the lookup_array sorted in descending order. If not sorted, invalid results will be returned. Notes Wildcard characters include the question mark (?) that matches a single character and the asterisk (*) that matches multiple characters. If you want to find a question mark or asterisk, type a tilde (~) before the character. Please note that this is an array formula. To learn more, please read the Insert array formulas article. How to apply the XMATCH function. Examples The figure below displays the result returned by the XMATCH function."
    },
   {
        "id": "Functions/xnpv.htm", 
        "title": "XNPV Function", 
        "body": "The XNPV function is one of the financial functions. It is used to calculate the net present value for an investment based on a specified interest rate and a schedule of irregular payments. Syntax XNPV(rate, values, dates) The XNPV function has the following arguments: Argument Description rate The discount rate for the investment. values An array that contains the income (positive values) or payment (negative values) amounts. At least one of the values must be negative and at least one positive. dates An array that contains the payment dates when the payments are made or received. Notes How to apply the XNPV function. Examples The figure below displays the result returned by the XNPV function."
    },
   {
        "id": "Functions/xor.htm", 
        "title": "XOR Function", 
        "body": "The XOR function is one of the logical functions. It is used to return a logical Exclusive Or of all arguments. The function returns TRUE when the number of TRUE inputs is odd and FALSE when the number of TRUE inputs is even. Syntax XOR(logical1, [logical2], ...) The XOR function has the following arguments: Argument Description logical1/2/n A condition that you want to check if it is TRUE or FALSE Notes You can enter up to 255 logical values. How to apply the XOR function. Examples There are two arguments: logical1 = 1&gt;0, logical2 = 2&gt;0. The number of TRUE inputs is even, so the function returns FALSE. There are two arguments: logical1 = 1&gt;0, logical2 = 2&lt;0. The number of TRUE inputs is odd, so the function returns TRUE."
    },
   {
        "id": "Functions/year.htm", 
        "title": "YEAR Function", 
        "body": "The YEAR function is one of the date and time functions. It returns the year (a number from 1900 to 9999) of the date given in the numerical format (MM/dd/yyyy by default). Syntax YEAR(serial_number) The YEAR function has the following argument: Argument Description serial_number The date of the year you want to find. Notes How to apply the YEAR function. Examples The figure below displays the result returned by the YEAR function."
    },
   {
        "id": "Functions/yearfrac.htm", 
        "title": "YEARFRAC Function", 
        "body": "The YEARFRAC function is one of the date and time functions. It is used to return the fraction of a year represented by the number of whole days from start-date to end-date calculated on the specified basis. Syntax YEARFRAC(start_date, end_date, [basis]) The YEARFRAC function has the following arguments: Argument Description start_date A number representing the first date of the period, entered using the DATE function or other date and time function. end_date A number representing the last date of the period, entered using the DATE function or other date and time function. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes If the start_date, end_date or basis is a decimal value, the function will ignore the numbers to the right of the decimal point. How to apply the YEARFRAC function. Examples The figure below displays the result returned by the YEARFRAC function."
    },
   {
        "id": "Functions/yield.htm", 
        "title": "YIELD Function", 
        "body": "The YIELD function is one of the financial functions. It is used to calculate the yield of a security that pays periodic interest. Syntax YIELD(settlement, maturity, rate, pr, redemption, frequency, [basis]) The YIELD function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. rate The annual coupon rate of the security. pr The purchase price of the security, per $100 par value. redemption The redemption value of the security, per $100 par value. frequency The number of interest payments per year. The possible values are: 1 for annual payments, 2 for semiannual payments, 4 for quarterly payments. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the YIELD function. Examples The figure below displays the result returned by the YIELD function."
    },
   {
        "id": "Functions/yielddisc.htm", 
        "title": "YIELDDISC Function", 
        "body": "The YIELDDISC function is one of the financial functions. It is used to calculate the annual yield of a discounted security. Syntax YIELDDISC(settlement, maturity, pr, redemption, [basis]) The YIELDDISC function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. pr The purchase price of the security, per $100 par value. redemption The redemption value of the security, per $100 par value. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the YIELDDISC function. Examples The figure below displays the result returned by the YIELDDISC function."
    },
   {
        "id": "Functions/yieldmat.htm", 
        "title": "YIELDMAT Function", 
        "body": "The YIELDMAT function is one of the financial functions. It is used to calculate the annual yield of a security that pays interest at maturity. Syntax YIELDMAT(settlement, maturity, issue, rate, pr, [basis) The YIELDMAT function has the following arguments: Argument Description settlement The date when the security is purchased. maturity The date when the security expires. issue The issue date of the security. rate The interest rate of the security at the issue date. pr The purchase price of the security, per $100 par value. basis The day count basis to use, a numeric value greater than or equal to 0, but less than or equal to 4. It is an optional argument. The possible values are listed in the table below. The basis argument can be one of the following: Numeric value Count basis 0 US (NASD) 30/360 1 Actual/actual 2 Actual/360 3 Actual/365 4 European 30/360 Notes Dates must be entered by using the DATE function. How to apply the YIELDMAT function. Examples The figure below displays the result returned by the YIELDMAT function."
    },
   {
        "id": "Functions/z-test.htm", 
        "title": "Z.TEST Function", 
        "body": "The Z.TEST function is one of the statistical functions. It is used to return the one-tailed P-value of a z-test. For a given hypothesized population mean, x, Z.TEST returns the probability that the sample mean would be greater than the average of observations in the data set (array) — that is, the observed sample mean. Syntax Z.TEST(array, x, [sigma]) The Z.TEST function has the following arguments: Argument Description array The range of numeric values against which to test x. x The value to test. sigma A population standard deviation. This is an optional argument. If it is omitted, the sample standard deviation is used. Notes How to apply the Z.TEST function. Examples The figure below displays the result returned by the Z.TEST function."
    },
   {
        "id": "Functions/ztest.htm", 
        "title": "ZTEST Function", 
        "body": "The ZTEST function is one of the statistical functions. It is used to return the one-tailed probability-value of a z-test. For a given hypothesized population mean, μ0, ZTEST returns the probability that the sample mean would be greater than the average of observations in the data set (array) — that is, the observed sample mean. Syntax ZTEST(array, x, [sigma]) The ZTEST function has the following arguments: Argument Description array The range of numeric values against which to test x. x The value to test. sigma A population standard deviation. This is an optional argument. If it is omitted, the sample standard deviation is used. Notes How to apply the ZTEST function. Examples The figure below displays the result returned by the ZTEST function."
    },
   {
        "id": "HelpfulHints/About.htm", 
        "title": "About Spreadsheet Editor", 
        "body": "The Spreadsheet Editor is an online application that allows you to edit spreadsheets directly in your browser . Using the Spreadsheet Editor, you can perform various editing operations like in any desktop editor, print the edited spreadsheets keeping all the formatting details or download them onto your computer hard disk drive as XLSX, XLTX, PDF, PDF/A, ODS, OTS, CSV, PNG, JPG file. To view the current version of the software, build number, and licensor details in the online version, click the About icon on the left sidebar. To view the current version of the software and licensor details in the desktop version for Windows, select the About menu item on the left sidebar of the main program window. In the desktop version for Mac OS, open the ONLYOFFICE menu at the top of the screen and select the About ONLYOFFICE menu item."
    },
   {
        "id": "HelpfulHints/AdvancedSettings.htm", 
        "title": "Advanced Settings of the Spreadsheet Editor", 
        "body": "The Spreadsheet Editor allows you to change its general advanced settings. To access them, open the File tab on the top toolbar and select the Advanced Settings option. The advanced settings are grouped as follows: Editing and saving Autosave is used in the online version to turn on/off automatic saving of changes made during the editing process. Autorecover is used in the desktop version to turn on/off the option that allows you to automatically recover spreadsheets if the program closes unexpectedly. Show the Paste Options button when the content is pasted. The corresponding icon will appear when you paste content in the spreadsheet. Show function tooltip - enables tips for entering functions. Collaboration The Co-editing mode subsection allows you to set the preferable mode for seeing changes made to the spreadsheet when working in collaboration. Fast (by default). The users who take part in the spreadsheet co-editing will see the changes in real time once they are made by other users. Strict. All the changes made by co-editors will be shown only after you click the Save icon that will notify you about new changes. Show changes from other users. This feature allows seeing changes made by other users in the spreadsheet opened for viewing only in the Live Viewer mode. Show comments in text. If you disable this feature, the commented passages will be highlighted only if you click the Comments icon on the left sidebar. Show resolved comments. This feature is disabled by default so that the resolved comments are hidden in the spreadsheet. You can view such comments only if you click the Comments icon on the left sidebar. Enable this option if you want to display resolved comments in the spreadsheet. Appearance The Interface theme option is used to change the color scheme of the editor’s interface. The Same as system option makes the editor follow the interface theme of your system. The Light color scheme incorporates standard blue, white, and light gray colors with less contrast in UI elements suitable for working during daytime. The Classic Light color scheme incorporates standard blue, white, and light gray colors. The Dark color scheme incorporates black, dark gray, and light gray colors suitable for working during nighttime. The Contrast Dark color scheme incorporates black, dark gray, and white colors with more contrast in UI elements highlighting the working area of the file. The Gray color scheme incorporates lighter gray color and appears as a uniformly light color scheme. The Turn on document dark mode option is used to make the working area darker when the editor is set to Dark or Contrast Dark interface theme. Check the Turn on document dark mode box to enable it. Note: Apart from the available Light, Classic Light, Dark, Contrast Dark, and Gray interface themes, ONLYOFFICE editors can now be customized with your own color theme. Please follow these instructions to learn how you can do that. Tab style - choose whether you want the currently selected tab to be filled in with a lighter color with the Fill option or to be underlined with the Line option. Use toolbar color as tabs background - the color of the toolbar will be used as tabs background. The toolbar color depends on the currently selected interface theme. Workspace The Turn on screen reader support option is used to enable support of screen reader software. The R1C1 reference style option is disabled by default and the A1 reference style is used. When the A1 reference style is used, columns are designated by letters, and rows are designated by numbers. If you select the cell located in row 3 and column 2, its address displayed in the box to the left of the formula bar looks like this: B3. If the R1C1 reference style is enabled, both rows and columns are designated by numbers. If you select the cell at the intersection of row 3 and column 2, its address will look like this: R3C2. Letter R indicates the row number and letter C indicates the column number. In case you refer to other cells using the R1C1 reference style, the reference to a target cell is formed based on the distance from an active cell. For example, when you select the cell in row 5 and column 1 and refer to the cell in row 3 and column 2, the reference is R[-2]C[1]. The numbers in square brackets designate the position of the cell relative to the current cell position, i.e. the target cell is 2 rows up and 1 column to the right of the active cell. If you select the cell in row 1 and column 2 and refer to the same cell in row 3 and column 2, the reference is R[2]C, i.e. the target cell is 2 rows down from the active cell and in the same column. The Use Alt key to navigate the user interface using the keyboard option is used to enable using the Alt / Option key in keyboard shortcuts. Show the Quick Print button in the editor header is used in the desktop version to enable quick printing via the corresponding button at the top toolbar. The file will be printed on the last selected or default printer. Snapped to the grid while scrolling - enables grid snapping for the scrolling process. Show horizontal scroll bar - enables hiding/displaying the horizontal scroll bar. Show vertical scroll bar - enables hiding/displaying the vertical scroll bar. Default sheet direction - choose whether you want the sheet direction to be Left-to-right or Right-to-left. Please note that this setting will be applied only to the newly created sheets. The Customize quick access button is used to choose which buttons shall be available in the top toolbar, i.e., Save, Print, Undo, and Redo. The Unit of measurement option is used to specify what units are used on the rulers and in properties of objects when setting such parameters as width, height, spacing, margins etc. The available units are Centimeter, Point, and Inch. The Default zoom value option is used to set the default zoom value, selecting it in the list of available options from 50% to 500%. You can also choose the Fit to Page, Fit to Width, or Last Used option. The Last used option refers to the last set scaling value during the current session. The Font hinting option is used to select how fonts are displayed in the Spreadsheet Editor. Choose As Windows if you like the way fonts are usually displayed on Windows, i.e. using Windows font hinting. Choose As OS X if you like the way fonts are usually displayed on a Mac, i.e. without any font hinting at all. Choose Native to display the text with hinting embedded into the font files. Default cache mode - used to select the cache mode for the font characters. It’s not recommended to switch it without any reason. It can be helpful in some cases only, for example, when an issue with the enabled hardware acceleration in the Google Chrome browser occurs. The Spreadsheet Editor has two cache modes: In the first cache mode, each letter is cached as a separate picture. In the second cache mode, a picture of a certain size is selected where letters are placed dynamically and a mechanism of allocating/removing memory in this picture is also implemented. If there is not enough memory, a second picture is created, etc. The Default cache mode setting applies two above-mentioned cache modes separately for different browsers: When the Default cache mode setting is enabled, Internet Explorer (v. 9, 10, 11) uses the second cache mode, other browsers use the first cache mode. When the Default cache mode setting is disabled, Internet Explorer (v. 9, 10, 11) uses the first cache mode, other browsers use the second cache mode. The Macros settings option is used to set macros display with a notification. Choose Disable All to disable all macros within the spreadsheet. Choose Show notification to receive notifications about macros within the spreadsheet. Choose Enable all to automatically run all macros within the spreadsheet. Regional settings The Formula Language option is used to select the language for displaying and entering formula names, argument names, and descriptions. Formula language is supported for 33 languages: Armenian, Belarusian, Bulgarian, Catalan, Chinese, Czech, Danish, Dutch, English, Finnish, French, German, Greek, Hungarian, Indonesian, Italian, Japanese, Korean, Lao, Latvian, Norwegian, Polish, Portuguese (Brazil), Portuguese (Portugal), Romanian, Russian, Slovak, Slovenian, Spanish, Swedish, Turkish, Ukrainian, Vietnamese. The Region option is used to set the display mode for currency, date, and time. Available regions: Azerbaijani, Bulgarian, Czech, Danish, German (Austria), German (Germany), German (Switzerland), Greek (Greece), English (Australia), English (Indonesia), English (United Kingdom), English (USA), Spanish (Spain), Spanish (Mexico), Finnish (Finland), French (France), French (Switzerland), Indonesian (Indonesia), Italian (Italy), Italian (Switzerland), Japanese, Korean, Latvian, Hungarian, Dutch (Netherlands), Polish (Poland), Portuguese (Brazil), Portuguese (Portugal), Slovak, Slovenian, Swedish (Finland), Swedish (Sweden), Turkish, Ukrainian, Vietnamese, Chinese, Taiwanese. The Use separators based on regional settings option is enabled by default, the separators will correspond to the set region. To set custom separators, uncheck this option and enter the required separators in Decimal separator and Thousands separator fields. Proofing The Dictionary language option is used to set the preferred dictionary for the spell checking. Ignore words in UPPERCASE. Words typed in capital letters are ignored during the spell checking. Ignore words with numbers. Words with numbers in them are ignored during the spell checking. The AutoCorrect options menu allows you to access the autocorrect settings such as replacing text as you type, recognizing functions, automatic formatting etc. Calculating The Use 1904 date system option is used to calculate dates by using January 1, 1904, as a starting point. It can be useful when working with spreadsheets created in MS Excel 2008 for Mac and earlier MS Excel for Mac versions. The Enable iterative calculation option is used to activate iterative calculation. The Maximum iterations option is used to set the number of times formulae with circular reference will perform calculations until the cycle stops. The Maximum change option is used to set the precision of iterative calculations. The changes are saved as you go."
    },
   {
        "id": "HelpfulHints/CollaborativeEditing.htm", 
        "title": "Co-editing spreadsheets in real time", 
        "body": "The Spreadsheet Editor allows you to maintain constant team-wide approach to work flow: share files and folders, communicate right in the editor, comment certain parts of your spreadsheets that require additional third-party input, save spreadsheet versions for future use. In Spreadsheet Editor you can collaborate on spreadsheets in real time using two modes: Fast or Strict. The modes can be selected in the Advanced Settings. It's also possible to choose the necessary mode using the Co-editing Mode icon on the Collaboration tab of the top toolbar: The number of users who are working on the current spreadsheet is specified on the right side of the editor header - . If you want to see who exactly is editing the file now, you can click this icon or open the Chat panel with the full list of the users. Fast mode The Fast mode is used by default and shows the changes made by other users in real time. When you co-edit a spreadsheet in this mode, the possibility to Redo the last undone operation is not available. This mode will show the actions and the names of the co-editors when they are editing the data in cells. Different border colors also highlight the ranges of cells selected by someone else at the moment. Hover your mouse pointer over the selection to display the name of the user who is editing it. Strict mode The Strict mode is selected to hide changes made by other users until you click the Save   icon to save your changes and accept the changes made by co-authors. When a spreadsheet is being edited by several users simultaneously in the Strict mode, the edited cells are marked with dashed lines of different colors, the tab of the sheet where these cells are situated are marked with red marker. Hover the mouse cursor over one of the edited cells, to display the name of the user who is editing it at the moment. As soon as one of the users saves their changes by clicking the icon, the others will see a note in the upper left corner stating that they have updates. To save the changes you made, so that other users can view them, and get the updates saved by your co-editors, click the icon in the left upper corner of the top toolbar. Live Viewer mode The Live Viewer mode is used to see the changes made by other users in real time when the spreadsheet is opened by a user with the View only access rights. For the mode to function properly, make sure that the Show changes from other users checkbox is active in the editor's Advanced Settings. Anonymous Portal users who are not registered and do not have a profile are considered to be anonymous, although they still can collaborate on documents. To have a name assigned to them, the anonymous user should enter a name they prefer in the corresponding field appearing in the right top corner of the screen when they open the document for the first time. Activate the “Don’t ask me again” checkbox to preserve the name."
    },
   {
        "id": "HelpfulHints/Commenting.htm", 
        "title": "Commenting", 
        "body": "The Spreadsheet Editor allows you to maintain constant team-wide approach to work flow: share files and folders, collaborate on spreadsheets in real time, communicate right in the editor, save spreadsheet versions for future use. In Spreadsheet Editor you can leave comments to the content of spreadsheets without actually editing it. Unlike chat messages, the comments stay until deleted. Leaving comments and replying to them To leave a comment, select a cell where you think there is an error or problem, switch to the Insert or Collaboration tab of the top toolbar and click the Comment button, or use the icon on the left sidebar to open the Comments panel, and either click the Add comment button in the top toolbar of the panel, or click the More symbol and choose the Add Comment to Document option to leave a comment to the whole spreadsheet, or right-click within the selected cell and select the Add Сomment option from the menu, enter the needed text, click the Add Comment/Add button. If you are using the Strict co-editing mode, new comments added by other users will become visible only after you click the icon in the left upper corner of the top toolbar. To view the comment, just click within the cell. You or any other user can answer to the added comment asking questions or reporting on the work he/she has done. For this purpose, use the Add Reply link, type in your reply text in the entry field and press the Reply button. Disabling display of comments The comment will be seen on the panel on the left. The orange triangle will appear in the upper right corner of the cell you commented. If you need to disable this feature, click the File tab on the top toolbar, select the Advanced Settings... option, uncheck the Turn on display of the comments box. In this case, the commented cells will be marked only if you click the Comments icon. Managing comments You can manage the added comments using the icons in the comment balloon or on the Comments panel on the left: sort the added comments by clicking the icon: by date: Newest or Oldest by author: Author from A to Z or Author from Z to A by group: All or choose a certain group from the list. This sorting option is available if you are running a version that includes this functionality. edit the currently selected by clicking the icon, delete the currently selected by clicking the icon, close the currently selected discussion by clicking the icon if the task or problem you stated in your comment was solved, after that the discussion you opened with your comment gets the resolved status. To open it again, click the icon. If you want to hide resolved comments, click the File tab on the top toolbar, select the Advanced Settings... option, uncheck the Turn on display of the resolved comments box and click Apply. In this case the resolved comments will be highlighted only if you click the icon, if you want to manage comments in a bunch, open the Resolve drop-down menu on the Collaboration tab. Select one of the options for resolving comments: resolve current comments, resolve my comments or resolve all comments in the spreadsheet. Adding mentions You can only add mentions to the comments made to the spreadsheet content and not to the spreadsheet itself. When entering comments, you can use the mentions feature that allows you to attract somebody's attention to the comment and send a notification to the mentioned user via email and Talk. To add a mention, Enter the \"+\" or \"@\" sign anywhere in the comment text - a list of the portal users will open. To simplify the search process, you can start typing the required name in the comment field - the user list will change while you type. Select the necessary person from the list. If the file has not been shared with the mentioned user yet, the Sharing Settings window will open. The Read only access type is selected by default. Change it if necessary. Click OK. The mentioned user will receive an email notification that they have been mentioned in a comment. If the file has been shared, the user will also receive a corresponding notification. Removing comments To remove comments, click the Remove button on the Collaboration tab of the top toolbar, select the necessary option from the menu: Remove Current Comments - to remove the currently selected comment. If some replies have been added to the comment, all its replies will be removed as well. Remove My Comments - to remove comments you added without removing comments added by other users. If some replies have been added to your comment, all its replies will be removed as well. Remove All Comments - to remove all the comments in the spreadsheet that you and other users added. To close the panel with comments, click the Comments icon on the left sidebar once again."
    },
   {
        "id": "HelpfulHints/Communicating.htm", 
        "title": "Communicating in real time", 
        "body": "The Spreadsheet Editor allows you to maintain constant team-wide approach to work flow: share files and folders, collaborate on spreadsheets in real time, comment certain parts of your spreadsheets that require additional third-party input, save spreadsheet versions for future use. In Spreadsheet Editor you can communicate with your co-editors in real time using the built-in Chat tool as well as a number of useful plugins, i.e., Telegram or Rainbow. To access the Chat tool and leave a message for other users, click the icon on the left sidebar, or switch to the Collaboration tab of the top toolbar and click the Chat button, enter your text into the corresponding field below, press the Send button. The chat messages are stored during one session only. To discuss the spreadsheet content, it is better to use comments which are stored until they are deleted. All the messages left by users will be displayed on the panel on the left. If there are new messages you haven't read yet, the chat icon will look like this - . To close the panel with chat messages, click the icon once again."
    },
   {
        "id": "HelpfulHints/ImportData.htm", 
        "title": "Get data from TXT/CSV file", 
        "body": "If you need to quickly get data from a .txt/.csv file and have it all arranged properly in a spreadsheet, use the Get data from Text/CSV file option available on the Data tab. Step 1. Importing the file Click the Get data option on the Data tab. Choose one of the importing options: From Local TXT/CSV: find the needed file on your hard drive, select it and click Open. From TXT/CSV Web Address: paste the link to the file or web page into the Paste a data URL field and click OK. A link for viewing or editing a file stored on the ONLYOFFICE portal or in a third-party storage cannot be used in this case. Please use the link to download the file. From Local XML: find the needed file on your hard drive, select it and click Open. Currently, only XML spreadsheet 2003 is supported. Step 2. Configuring the settings The Text Import Wizard encompasses four sections: Encoding, Delimiter, Preview, and Choose where to put data. Encoding. The parameter is set to UTF-8 by default. Leave it at that or select the type you need using the drop-down menu. Delimiter. The parameter sets the type of delimiter used to distribute the plain text into different cells. The delimiters available are Comma, Semicolon, Colon, Tab, Space, and Other (enter manually). Click the Advanced button located to the right to configure settings for data recognized as numeric: Set a Decimal separator and a Thousands separator. The default separators are “.” for decimal and “,” for thousands. Select a Text qualifier. A Text qualifier is a character that is used to recognize where the text begins and ends when you are importing data. The available options: (none), double quotes, and single quote. Preview. The section shows how the text will be arranged in the spreadsheet cells. Choose where to put data. Enter the required range in the field or choose one using the Select data button to the right. Click OK to import the file and exit the Text Import Wizard."
    },
   {
        "id": "HelpfulHints/KeyboardShortcuts.htm", 
        "title": "Keyboard Shortcuts", 
        "body": "Keyboard Shortcuts for Key Tips Use keyboard shortcuts for a faster and easier access to the features of the Spreadsheet Editor without using a mouse. Press Alt (Option for macOS) key to turn on all key tips for the editor header, the top toolbar, the right and left sidebars and the status bar. Press the letter that corresponds to the item you wish to use. The additional key tips may appear depending on the key you press. The first key tips hide when additional key tips appear. For example, to access the Insert tab, press Alt (Option for macOS) to see all primary key tips. Press letter I to access the Insert tab and you will see all the available shortcuts for this tab. Then press the letter that corresponds to the item you wish to configure. Press Alt (Option for macOS) to hide all key tips, or press Escape to go back to the previous group of key tips. Find the most common keyboard shortcuts in the list below. Please note: for macOS, some shortcuts contain the Home, End, Page Up and Page Down keys which are only available on the extended keyboard. If you don't have these keys, use the keyboard shortcuts specified above (i.e. use ^ Ctrl/&#8984; Cmd+← or Fn+← instead of Home, ^ Ctrl/&#8984; Cmd+→ or Fn+→ instead of End, Fn+↑ instead of Page Up, Fn+↓ instead of Page Down). Windows/Linux macOS Working with Spreadsheet Open 'File' panel Alt+F ^ Ctrl+⌥ Option+F Open the File panel to save, download, print the current spreadsheet, view its info, create a new spreadsheet or open an existing one, access the help menu of the Spreadsheet Editor or its advanced settings. Open 'Find' dialog window Ctrl+F ^ Ctrl+F, &#8984; Cmd+F Open the Find dialog window to start searching for a cell containing the required characters. Open 'Find and Replace' menu (panel) with replacement field Ctrl+H ^ Ctrl+H Open the Find and Replace menu (panel) with the replacement field to replace one or more occurrences of the found characters. Open 'Comments' panel Ctrl+⇧ Shift+H ^ Ctrl+⇧ Shift+H, &#8984; Cmd+⇧ Shift+H Open the Comments panel to add your own comment or reply to other users' comments. Open comment field Alt+H &#8984; Cmd+⌥ Option+A Open a data entry field where you can add the text of your comment. Open 'Chat' panel (Online Editors) Alt+Q ^ Ctrl+⌥ Option+Q Open the Chat panel in the Online Editors and send a message. Save spreadsheet Ctrl+S ^ Ctrl+S, &#8984; Cmd+S Save all the changes to the spreadsheet currently edited with the Spreadsheet Editor. The active file will be saved with its current file name, location, and file format. Print spreadsheet Ctrl+P ^ Ctrl+P, &#8984; Cmd+P Print your spreadsheet with one of the available printers or save it to a file. Download as... Ctrl+⇧ Shift+S ^ Ctrl+⇧ Shift+S, &#8984; Cmd+⇧ Shift+S Open the Download as... panel to save the currently edited spreadsheet to the computer hard disk drive in one of the supported formats: XLSX, XLTX, PDF, PDF/A, ODS, OTS, CSV, PNG, JPG. Full screen (Online Editors) F11 Switch to the full screen view in the Online Editors to fit the Spreadsheet Editor on the screen. Help menu F1 Fn+F1 Open the Help menu of the Spreadsheet Editor. Open existing file Ctrl+O &#8984; Cmd+O Open the standard dialog box that allows selecting an existing file. If you select the file in this dialog box and click Open, the file will be opened in a new tab or window of Desktop Editors. Switch to the next tab Ctrl+↹ Tab ^ Ctrl+↹ Tab Switch to the next file tab in Desktop Editors or browser tab in Online Editors. Switch to the previous tab Ctrl+Shift+↹ Tab ^ Ctrl+⇧ Shift+↹ Tab Switch to the previous file tab in Desktop Editors or browser tab in Online Editors. Close file Ctrl+W, Ctrl+F4 &#8984; Cmd+W Close the current spreadsheet window. Element contextual menu ⇧ Shift+F10 ⇧ Shift+Fn+F10 Open the contextual menu of the selected element. Close menu or modal window, reset modes, etc. Esc Esc Close a menu or modal window. Suspend copying formats. Reset adding shapes mode. Clear clipboard when cutting/copying cells. Hide the Paste Special button. Reset the ‘Zoom’ parameter Ctrl+0 ^ Ctrl+0 or &#8984; Cmd+0 Reset the ‘Zoom’ parameter of the current spreadsheet to a default 100%. Duplicate a worksheet Press and hold down Ctrl+ drag the sheet tab Press and hold down ⌥ Option+ drag the sheet tab Copy an entire worksheet in a workbook and move it to the tab location you need. Navigation Move one cell up, down, left, or right ↑ ↓ ← → ↑ ↓ ← → Outline a cell above/below the currently selected one, or to the left/to the right of it. Move active cell down ↵ Enter ↵ Return Move to the cell below. Move active cell up ⇧ Shift+↵ Enter ⇧ Shift+↵ Return Move to the cell above. Move active cell to the right ↹ Tab ↹ Tab Move to the cell on the right. Move active cell to the left ⇧ Shift+↹ Tab ⇧ Shift+↹ Tab Move to the cell on the left . Jump to the edge of the visible data region or the next cell with data Ctrl+← → ↑ ↓ &#8984; Cmd+← → ↑ ↓ Home End Page Up Page Down Outline a cell at the edge of the visible data region or the next cell with data in a worksheet. If the region does not contain data, the last cell of the visible area will be selected. If the region contains data, the next cell with data will be selected. Jump to the beginning of the row Home Fn+← Home Outline a cell in the column A of the current row. Jump to the beginning of the spreadsheet Ctrl+Home ^ Ctrl+Fn+←, &#8984; Cmd+Fn+← ^ Ctrl+Home, &#8984; Cmd+Home Outline the cell A1. Jump to the end of the row End, Ctrl+→ Fn+→, &#8984; Cmd+→ End Outline the last cell of the current row. Jump to the end of the spreadsheet Ctrl+End ^ Ctrl+Fn+→, &#8984; Cmd+Fn+→ ^ Ctrl+End, &#8984; Cmd+End Outline the lower right used cell in the worksheet situated in the bottommost row with data from the rightmost column with data. If the cursor is in the formula bar, it will be placed to the end of the text. Move to the previous sheet Alt+Page Up ⌥ Option+Fn+↑ ⌥ Option+Page Up Move to the previous sheet in your spreadsheet. Move to the next sheet Alt+Page Down ⌥ Option+Fn+↓ ⌥ Option+Page Down Move to the next sheet in your spreadsheet. Move up one row ↑, ⇧ Shift+↵ Enter ⇧ Shift+↵ Return Outline the cell above the current one in the same column. Move down one row ↓, ↵ Enter ↵ Return Outline the cell below the current one in the same column. Move left one column ←, ⇧ Shift+↹ Tab ←, ⇧ Shift+↹ Tab Outline the previous cell of the current row. Move right one column →, ↹ Tab →, ↹ Tab Outline the next cell of the current row. Move down one screen Page Down Fn+↓ Page Down Move one screen down in the worksheet. Move up one screen Page Up Fn+↑ Page Up Move one screen up in the worksheet. Move vertical scrollbar Up/Down Mouse scroll Up/Down Mouse scroll Up/Down Move vertical scrollbar up/down. Move horizontal scrollbar Left/Right ⇧ Shift+Mouse scroll Up/Down ⇧ Shift+Mouse scroll Up/Down Move horizontal scrollbar left/right. To move the scrollbar to the right, scroll the mouse wheel down. To move the scrollbar to the left, scroll the mouse wheel up. Zoom In Ctrl++ ^ Ctrl+=, &#8984; Cmd+= Zoom in the currently edited spreadsheet. Zoom Out Ctrl+- ^ Ctrl+-, &#8984; Cmd+- Zoom out the currently edited spreadsheet. Navigate between controls in modal dialogues ↹ Tab/⇧ Shift+↹ Tab ↹ Tab/⇧ Shift+↹ Tab Navigate between controls to give focus to the next or previous control in modal dialogues. Data Selection Select the entire worksheet Ctrl+A, Ctrl+⇧ Shift+␣ Spacebar &#8984; Cmd+A, ^ Ctrl+A Select the entire worksheet (when the focus is on a cell). Select column Ctrl+␣ Spacebar ^ Ctrl+Fn+␣ Spacebar, &#8984; Cmd+Fn+␣ Spacebar Select an entire column in a worksheet. Select row ⇧ Shift+␣ Spacebar ⇧ Shift+␣ Spacebar Select an entire row in a worksheet. Select one cell to the right ⇧ Shift+→ ⇧ Shift+→ Select one cell to the right. Select one cell to the left ⇧ Shift+← ⇧ Shift+← Select one cell to the left. Select one cell up ⇧ Shift+↑ ⇧ Shift+↑ Select one cell up. Select one cell down ⇧ Shift+↓ ⇧ Shift+↓ Select one cell down. Select from cursor to beginning of row ⇧ Shift+Home ⇧ Shift+Fn+← ⇧ Shift+Home Select a fragment from the cursor to the beginning of the current row. Select from cursor to end of row ⇧ Shift+End ⇧ Shift+Fn+→ ⇧ Shift+End Select a fragment from the cursor to the end of the current row. Select to the next nonblank cell to the right Ctrl+⇧ Shift+→ ^ Ctrl+⇧ Shift+→, &#8984; Cmd+⇧ Shift+→ Select cells to the next nonblank cell to the right of the active cell or to the edge of the visible area. Select to the next nonblank cell to the left Ctrl+⇧ Shift+← ^ Ctrl+⇧ Shift+←, &#8984; Cmd+⇧ Shift+← Select cells to the next nonblank cell to the left of the active cell or to the edge of the visible area. Select to the next nonblank cell up Ctrl+⇧ Shift+↑ ^ Ctrl+⇧ Shift+↑, &#8984; Cmd+⇧ Shift+↑ Select cells to the next nonblank cell up from the active cell or to the edge of the visible area. Select to the next nonblank cell down Ctrl+⇧ Shift+↓ ^ Ctrl+⇧ Shift+↓, &#8984; Cmd+⇧ Shift+↓ Select cells to the next nonblank cell down from the active cell or to the edge of the visible area. Extend the selection to beginning of worksheet Ctrl+⇧ Shift+Home ^ Ctrl+⇧ Shift+Fn+←, &#8984; Cmd+⇧ Shift+Fn+← ^ Ctrl+⇧ Shift+Home, &#8984; Cmd+⇧ Shift+Home Select a fragment from the current selected cells to the beginning of the worksheet. Extend the selection to the last used cell Ctrl+⇧ Shift+End ^ Ctrl+⇧ Shift+Fn+→, &#8984; Cmd+⇧ Shift+Fn+→ ^ Ctrl+⇧ Shift+End, &#8984; Cmd+⇧ Shift+End Select a fragment from the current selected cells to the last used cell in the worksheet (in the bottommost row with data of the rightmost column with data). If the cursor is in the formula bar, this will select all text in the formula bar from the cursor position to the end without affecting the height of the formula bar. Extend the selection to the nearest nonblank cell to the right ⇧ Shift+End, Ctrl+⇧ Shift+→ ⇧ Shift+Fn+→ ⇧ Shift+End Extend the selection to the nearest nonblank cell in the same row to the right of the active cell. If the next cell is blank, the selection will be extended to the next nonblank cell. Extend the selection to the nonblank cell to the left Ctrl+⇧ Shift+← Extend the selection to the nonblank cell to the left. Extend the selection to the first column ⇧ Shift+Home ⇧ Shift+Fn+← ⇧ Shift+Home Extend the selection to the first column (A). Extend the selection to the nearest nonblank cell up/down the column Ctrl+⇧ Shift+↑ ↓ Extend the selection to the nearest nonblank cell in the same column up/down from the active cell. If the next cell is blank, the selection will be extended to the next nonblank cell. Extend the selection down one screen ⇧ Shift+Page Down ⇧ Shift+Fn+↓ ⇧ Shift+Page Down Extend the selection to include all the cells one screen down from the active cell. All cells in the columns of the previously selected range will be selected. Extend the selection up one screen ⇧ Shift+Page Up ⇧ Shift+Fn+↑ ⇧ Shift+Page Up Extend the selection to include all the cells one screen up from the active cell. All cells in the columns of the previously selected range will be selected. Undo and Redo Undo Ctrl+Z &#8984; Cmd+Z, ^ Ctrl+Z Reverse the latest performed action. Redo Ctrl+Y &#8984; Cmd+Y, ^ Ctrl+Y Repeat the latest undone action. Cut, Copy, and Paste Cut Ctrl+X, ⇧ Shift+Delete &#8984; Cmd+X Cut the selected data/graphics and send them to the computer clipboard memory. The cut data can be later inserted to another place in the same worksheet, into another spreadsheet, or into some other program. Copy Ctrl+C, Ctrl+Insert &#8984; Cmd+C Send the selected data/graphics to the computer clipboard memory. The copied data can be later inserted to another place in the same worksheet, into another spreadsheet, or into some other program. Paste Ctrl+V, ⇧ Shift+Insert &#8984; Cmd+V Insert the previously copied/cut data/graphics from the computer clipboard memory to the current cursor position. The data can be previously copied from the same worksheet, from another spreadsheet, or from some other program. Paste Special options 1 Paste only formula Ctrl then F ^ Ctrl then F Paste formulas without pasting the data formatting. Paste formula + number format Ctrl then O ^ Ctrl then O Paste formulas with the formatting applied to numbers. Paste formula + all formatting Ctrl then K ^ Ctrl then K Paste formulas with all the data formatting. Paste formula without borders Ctrl then B ^ Ctrl then B Paste formulas with all the data formatting except the cell borders. Paste formula + column width Ctrl then W ^ Ctrl then W Paste formulas with all the data formatting and set the source column's width for the cell range. Transpose Ctrl then T ^ Ctrl then T Paste data switching them from columns to rows, or vice versa. This option is available for regular data ranges, but not for formatted tables. Paste only value Ctrl then V ^ Ctrl then V Paste the formula results without pasting the data formatting. Paste value + number format Ctrl then A ^ Ctrl then A Paste the formula results with the formatting applied to numbers. Paste value + all formatting Ctrl then E ^ Ctrl then E Paste the formula results with all the data formatting. Paste only formatting Ctrl then R ^ Ctrl then R Paste the cell formatting only without pasting the cell contents. Paste link Ctrl then N ^ Ctrl then N Paste the external link to a cell or range of cells in another spreadsheet within the current portal (in the online editor) or in a local file (in the desktop editor). Working with Hyperlinks Insert hyperlink Ctrl+K &#8984; Cmd+K, ^ Ctrl+K Insert a hyperlink which can be used to go to a web address. Visit hyperlink Enter Return Visit a hyperlink (with the cursor in the hyperlink). Data Formatting Bold Ctrl+B ^ Ctrl+B, &#8984; Cmd+B Make the font of the selected text fragment darker and heavier than normal, or remove the bold formatting. Italic Ctrl+I &#8984; Cmd+I Make the font of the selected text fragment italicized and slightly slanted, or remove italic formatting. Underline Ctrl+U ^ Ctrl+U, &#8984; Cmd+U Make the selected text fragment underlined with a line going under the letters, or remove underlining. Strikeout Ctrl+5 ^ Ctrl+5, &#8984; Cmd+5 Make the selected text fragment struck out with a line going through the letters, or remove strikeout formatting. Edit active cell F2 Fn+F2 Edit the active cell and position the insertion point at the end of the cell contents. If editing in a cell is turned off, the insertion point will be moved into the Formula Bar. Data Filtering Enable/Remove Filter Ctrl+⇧ Shift+L ^ Ctrl+⇧ Shift+L, &#8984; Cmd+⇧ Shift+L Enable a filter for a selected cell range, or remove the filter. Open filter window Alt+↓ ⌥ Option+↓ In the header of a column with a filter, open the filter window. Format as table template Ctrl+L ^ Ctrl+L, &#8984; Cmd+L Apply a table template to a selected cell range. Data Entry Complete cell entry and move down ↵ Enter ↵ Return Complete a cell entry in the selected cell or the formula bar, and move to the cell below. Complete cell entry and move up ⇧ Shift+↵ Enter ⇧ Shift+↵ Return Complete a cell entry in the selected cell, and move to the cell above. Complete cell entry and move to the right ↹ Tab ↹ Tab Complete a cell entry in the selected cell or the formula bar and move to the cell on the right. Complete cell entry and move to the left ⇧ Shift+↹ Tab ⇧ Shift+↹ Tab Complete a cell entry in the selected cell or the formula bar and move to the cell on the left . Complete cell entry and stay in it Ctrl+⇧ Shift+↵ Enter, Ctrl+↵ Enter ^ Ctrl+⇧ Shift+↵ Return, ^ Ctrl+↵ Return Complete a cell entry in the selected cell or the formula bar and stay in it. Fill the selected cell range with the current entry Ctrl+↵ Enter ^ Ctrl+↵ Return Fill the selected cell range with the current entry. Select a cell range, type data to the active cell, and press the specified keys to fill all the selected cells with entered data. Start new line Alt+↵ Enter ⌥ Option+↵ Return Start a new line in the same cell. Add new placeholder to equation argument Enter Return, ⇧ Shift+Return Add a new placeholder to the equation argument. Cancel Esc Esc Cancel an entry in the selected cell or the formula bar. Delete to the left ← Backspace Delete Delete one character to the left in the formula bar or in the selected cell when the cell editing mode is activated. Remove the selection. Also removes the content of the active cell. It is also applicable to text in graphical objects. Delete to the right Delete Fn+Delete Delete one character to the right in the formula bar or in the selected cell when the cell editing mode is activated. Remove the selection. Also removes the cell contents (data and formulas) from selected cells without affecting cell formats or comments. It is also applicable to text in graphical objects. Clear active cell content Delete, ← Backspace Delete Remove the content (data and formulas) from the active cell without affecting the cell format or comments. Clear content of all selected cells Delete Fn+Delete Remove the content (data and formulas) from all selected cells without affecting the cell format or comments. Insert cells Ctrl+⇧ Shift+= Ctrl+⇧ Shift+=, &#8984; Cmd+⇧ Shift+= Open the dialog box for inserting new cells within the current spreadsheet with an added parameter of a shift to the right, a shift down, inserting an entire row or an entire column. Delete cells Ctrl+⇧ Shift+- Ctrl+⇧ Shift+-, &#8984; Cmd+⇧ Shift+- Open the dialog box for deleting cells within the current spreadsheet with an added parameter of a shift to the left, a shift up, deleting an entire row or an entire column. Insert the current date Ctrl+; Ctrl+;, &#8984; Cmd+; Insert the today date within an active cell. Insert the current time Ctrl+⇧ Shift+; Ctrl+⇧ Shift+;, &#8984; Cmd+⇧ Shift+; Insert the current time within an active cell. Insert the current date and time Ctrl+; then ␣ Spacebar then Ctrl+⇧ Shift+; Ctrl+; then ␣ Spacebar then Ctrl+⇧ Shift+;, &#8984; Cmd+; then ␣ Spacebar then &#8984; Cmd+⇧ Shift+; Insert the current date and time within an active cell. Insert separator Numpad . Insert a separator within an active cell. Auto Fill (Open drop-down list) Alt+↓ ⌥ Option+↓ Use this shortcut in an empty cell below or above existing values in the column. A drop-down list with existing values will appear. Select one of the available text values to fill an empty cell. Insert an em dash ⌥ Option+⇧ Shift+- Insert an em dash ‘—’ within the current cell. Insert an en dash ⌥ Option+- Insert an en dash ‘-’ within the current cell. Work with keyboard supporting the ability to insert Unicode symbols ⌥ Option+Q, ⌥ Option+F, ⇧ Shift+⌥ Option+7, and others When using the ⌥ Option+keyboard symbol shortcuts, for the keyboards supporting the ability to insert Unicode symbols, the keyboard symbols are added. The examples are listed below. With the English ABC layout, the ⌥ Option+Q shortcut inserts the \"œ\" symbol, the ⌥ Option+F shortcut inserts the “ƒ” function symbol. With the US International w/o deadkeys layout, the ⌥ Option+Q shortcut inserts the “ä” symbol. With the Swiss-german layout, the ⇧ Shift+⌥ Option+7 shortcut inserts the \"\\” symbol. Working with text in cells and graphical objects Remove word, selection to the left Ctrl+Backspace ⌥ Option+Delete Remove a word, selection to the left of the cursor. Remove word, selection to the right Ctrl+Delete Fn+⌥ Option+Delete Remove a word, selection to the right of the cursor. Select all Ctrl+A &#8984; Cmd+A, ^ Ctrl+A Select the entire shape content (when the cursor is within the shape content). Select the entire cell content (when the cursor is within the cell). Move one character to the left/right or one line up/down ← → ↑ ↓ ← → ↑ ↓ Move the cursor one character to the left/right or one line up/down. Select one character to the right ⇧ Shift+→ ⇧ Shift+→ Select one character to the right of the cursor position. Select one character to the left ⇧ Shift+← ⇧ Shift+← Select one character to the left of the cursor position. Move the cursor one word to the left Ctrl+← ⌥ Option+← Move the cursor one word to the left. Move the cursor one word to the right Ctrl+→ ⌥ Option+→ Move the cursor one word to the right. Select one word to the left Ctrl+⇧ Shift+← ⇧ Shift+⌥ Option+← Select one word to the left of the cursor. Select one word to the right Ctrl+⇧ Shift+→ ⇧ Shift+⌥ Option+→ Select one word to the right of the cursor. Jump to the beginning of the text Ctrl+Home ^ Ctrl+Fn+←, &#8984; Cmd+Fn+← ^ Ctrl+Home, &#8984; Cmd+Home Put the cursor to the very beginning of the text in a cell or shape. Jump to the end of the text Ctrl+End ^ Ctrl+Fn+→, &#8984; Cmd+Fn+→ ^ Ctrl+End, &#8984; Cmd+End Put the cursor to the very end of the text in a cell or shape. Select from cursor to beginning of text Ctrl+⇧ Shift+Home ^ Ctrl+⇧ Shift+Fn+←, &#8984; Cmd+⇧ Shift+Fn+← ^ Ctrl+⇧ Shift+Home, &#8984; Cmd+⇧ Shift+Home Select a text fragment from the cursor to the beginning of the text in a cell or shape. Select from cursor to end of text Ctrl+⇧ Shift+End ^ Ctrl+⇧ Shift+Fn+→, &#8984; Cmd+⇧ Shift+Fn+→ ^ Ctrl+⇧ Shift+End, &#8984; Cmd+⇧ Shift+End Select a text fragment from the cursor to the end of the text in a cell or shape. Jump to the beginning of the line Home &#8984; Cmd+← Home Put the cursor to the beginning of the currently edited line. Jump to the end of the line End &#8984; Cmd+→ End Put the cursor to the end of the currently edited line. Select from cursor to beginning of line ⇧ Shift+Home ⇧ Shift+Fn+← ⇧ Shift+Home Select a text fragment from the cursor to the beginning of the current line. Select from cursor to end of line ⇧ Shift+End ⇧ Shift+Fn+→ ⇧ Shift+End Select a text fragment from the cursor to the end of the current line. Select one line up ⇧ Shift+↑ ⇧ Shift+↑ Move the cursor one line up, selecting all symbols between the previous and current cursor position. Select one line down ⇧ Shift+↓ ⇧ Shift+↓ Move the cursor one line down, selecting all symbols between the previous and current cursor position. Pivot tables Update pivot table Alt+F5 ⌥ Option+Fn+F5 Update the previously selected pivot table. Update all pivot tables Ctrl+Alt+F5 2 Ctrl+⌥ Option+Fn+F5 Update all pivot tables. Slicers Clear selected values Alt+C Ctrl+⌥ Option+C, &#8984; Cmd+⌥ Option+C Clear selected values for a slicer. Switch multi-select Alt+S Ctrl+⌥ Option+S, &#8984; Cmd+⌥ Option+S Enable/disable multi-select for a slicer. Formatted tables Add summary row Ctrl+⇧ Shift+R Ctrl+⇧ Shift+R, &#8984; Cmd+⇧ Shift+R Add the Summary row for a formatted table. Functions Insert function ⇧ Shift+F3 ⇧ Shift+Fn+F3 Open the dialog box for inserting a new function by choosing from the provided list. SUM function Alt+= ⌥ Option+Ctrl+= Insert the SUM function into the selected cell. Recalculate functions F9 Fn+F9 Recalculate the entire workbook. Recalculate functions ⇧ Shift+F9 ⇧ Shift+Fn+F9 Recalculate the current worksheet. Display functions on sheet Ctrl+` Ctrl+` Display functions (not their values) on a sheet for printing them. Switch the type of reference F4 Fn+F4 Switch the type of a reference to a cell in the formula bar (absolute, relative). Data Formats Open the 'Number Format' dialog box Ctrl+1 ^ Ctrl+1, &#8984; Cmd+1 Open the Number Format dialog box. Apply the General format Ctrl+⇧ Shift+~ ^ Ctrl+⇧ Shift+~ Apply the General number format. Apply the Currency format Ctrl+⇧ Shift+$ ^ Ctrl+⇧ Shift+$ Apply the Currency format with two decimal places. Apply the Percentage format Ctrl+⇧ Shift+% ^ Ctrl+⇧ Shift+% Apply the Percentage format with no decimal places. Apply the Exponential format Ctrl+⇧ Shift+^ ^ Ctrl+⇧ Shift+^ Apply the Exponential number format with two decimal places. Apply the Date format Ctrl+⇧ Shift+# ^ Ctrl+⇧ Shift+# Apply the Date format with the day, month, and year. Apply the Time format Ctrl+⇧ Shift+@ ^ Ctrl+⇧ Shift+@ Apply the Time format with the hour and minute, and AM or PM. Apply the Number format Ctrl+⇧ Shift+! ^ Ctrl+⇧ Shift+! Apply the Number format with two decimal places, thousands separator, and minus sign (-) for negative values. Modifying Objects Working with shapes ↵ Enter Return When the shape is selected, if it does not contain content, create content and move the cursor to the beginning of the line. If the content is empty, move the cursor to it, otherwise select the entire content. Working with charts ↵ Enter When the chart title is selected, select the text. Create a copy when dragging Ctrl ^ Ctrl Select an object and hold down the specified key when dragging the object to create the copy of the object in the location where it was moved. Constrain movement ⇧ Shift + drag ⇧ Shift + drag Constrain the movement of the selected object horizontally or vertically. Set 15-degree rotation ⇧ Shift + drag (when rotating) ⇧ Shift + drag (when rotating) Constrain the rotation angle to 15-degree increments. Maintain proportions ⇧ Shift + drag (when resizing) ⇧ Shift + drag (when resizing) Maintain the proportions of the selected object when resizing. Change angle of line/arrow when drawing ⇧ Shift + drag (when drawing lines/arrows) ⇧ Shift + drag (when drawing lines/arrows) Hold down the Shift key while drawing the line/arrow and rotate the spout of the arrow/end of the line to change the angle of the line/arrow when drawing it. The line/arrow will be rotated exactly 45 degrees. Movement by one-pixel increments Ctrl+← → ↑ ↓ &#8984; Cmd+← → ↑ ↓ Hold down the specified key and use the keyboard arrows to move the selected object to the left, right, up, or down by one pixel at a time. Move shape by a big step ← → ↑ ↓ ← → ↑ ↓ Use the keyboard arrows to move the selected object by a big step to the left, right, up, or down. Move focus to the next object ↹ Tab ↹ Tab Move focus to the next object after the currently selected one. Move focus to the previous object ⇧ Shift+↹ Tab ⇧ Shift+↹ Tab Move focus to the previous object before the currently selected one. Select all Ctrl+A &#8984; Cmd+A, ^ Ctrl+A Select all shapes (when the focus is on a shape). Add tab character to the object content ↹ Tab ↹ Tab Add the tab character to the object content. Subscript Ctrl+. ^ Ctrl+., &#8984; Cmd+. Make the selected text fragment smaller and place it to the lower part of the text line, e.g. as in chemical formulas. Works only with text within a graphical object. Superscript Ctrl+, ^ Ctrl+,, &#8984; Cmd+, Make the selected text fragment smaller and place it to the upper part of the text line, e.g. as in fractions. Works only with text within a graphical object. Increase font Ctrl+] &#8984; Cmd+], ^ Ctrl+] Increase the size of the font for the selected text fragment 1 point. Works only with text within a graphical object. Decrease font Ctrl+[ &#8984; Cmd+[, ^ Ctrl+[ Decrease the size of the font for the selected text fragment 1 point. Works only with text within a graphical object. Align center Ctrl+E ^ Ctrl+E, &#8984; Cmd+E Switch a paragraph between centered and left-aligned. Works only with text within a graphical object. Align justified Ctrl+J ^ Ctrl+J, &#8984; Cmd+J Switch a paragraph between justified and left-aligned. Works only with text within a graphical object. Align right Ctrl+R ^ Ctrl+R, &#8984; Cmd+R Switch a paragraph between right-aligned and left-aligned. Works only with text within a graphical object. Align left Ctrl+L ^ Ctrl+L, &#8984; Cmd+L Align a paragraph left. Works only with text within a graphical object. End paragraph and start a new one ↵ Enter ↵ Return End the current paragraph and start a new one when entering text within a graphical object. Add line break ⇧ Shift+↵ Enter ⇧ Shift+↵ Return Add a line break without starting a new paragraph when entering text within a graphical object. Remove graphical object Delete, Ctrl+Delete, Backspace, Ctrl+Backspace Delete, ⌥ Option+Delete Remove graphical object. Exit from adding shapes mode, remove selection step by step Esc Esc Exit from adding shapes mode. Remove selection step by step (e.g., if the content of a shape within a group is selected, the cursor will be removed from the content first, then from the shape, then from the group). 1 - Paste the copied data using Ctrl+V on Windows or Cmd+V on macOS. After pasting the copied data, use the Ctrl key to open the Paste Special menu, then press the letter key which corresponds to the necessary option. 2 - This keyboard shortcut does not work on Linux."
    },
   {
        "id": "HelpfulHints/Navigation.htm", 
        "title": "View Settings and Navigation Tools", 
        "body": "To help you view and select cells in large spreadsheets, the Spreadsheet Editor offers several tools: adjustable bars, scrollbars, sheet navigation buttons, sheet tabs and zoom. Adjust the View Settings To adjust default view settings and to set the most convenient mode to work with the spreadsheet, go to the View tab. You can select the following options: Sheet View - to manage sheet views. To learn more about sheet views, please read the following article. Zoom - to set the required zoom value from 50% to 500% from the drop-down list. Interface Theme - choose one of the available interface themes from the drop-down menu: Same as system, Light, Classic Light, Dark, Contrast Dark. Freeze Panes - freezes all the rows above the active cell and all the columns to the left of the active cell so that they remain visible when you scroll the spreadsheet to the right or down. To unfreeze the panes, just click this option once again or right-click anywhere within the worksheet and select the Unfreeze Panes option from the menu. Formula Bar - when disabled, hides the bar below the top toolbar which is used to enter and review the formulas and their contents. To show the hidden Formula Bar, click this option once again. Dragging formula bar bottom line to expand it toggles Formula Bar height to show one row. Headings - when disabled, hides the column heading at the top and row heading on the left side of the worksheet. To show the hidden Headings, click this option once again. Gridlines - when disabled, hides the lines around the cells. To show the hidden Gridlines, click this option once again. Show Zeros - allows “0” to be visible when entered in a cell. TO disable this option, uncheck the box. Always Show Toolbar - when this option is disabled, the top toolbar that contains commands will be hidden while tab names remain visible. Alternatively, you can just double-click any tab to hide the top toolbar or display it again. Combine Sheet and Status Bars - displays all sheet navigation tools and status bar in a single line. By default, this option is active. If you disable it, the status bar will appear in two lines. Left Panel - when disabled, hides the left panel where Search, Comments, etc. buttons are located. To show the left panel, check this box. Right Panel - when disabled, hides the right panel where Settings are located. To show the right panel, check this box. The right sidebar is minimized by default. To expand it, select any object (e.g., image, chart, shape) and click the icon of the currently activated tab on the right. To minimize the right sidebar, click the icon once again. You can also change the size of the opened Comments or Chat panel using the simple drag-and-drop: move the mouse cursor over the left sidebar border so that it turns into the bidirectional arrow and drag the border to the right to extend the sidebar width. To restore its original width, move the border to the left. Use the Navigation Tools To navigate through your spreadsheet, use the following tools: Use the Tab key on your keyboard to move to the cell to the right of the selected one. The Scrollbars (at the bottom or on the right side) are used to scroll up/down and left/right the current sheet. To navigate a spreadsheet using the scrollbars: click the up/down or right/left arrows on the scrollbars; drag the scroll box; scroll the mouse wheel to move vertically; use the combination of the Shift key and the mouse Scroll wheel to move horizontally; click any area to the left/right or above/below the scroll box on the scrollbar. You can also use the mouse scroll wheel to scroll your spreadsheet up or down. The Sheet Navigation buttons are situated in the left lower corner and are used to scroll the sheet list to the right/left and navigate among the sheet tabs. click the Scroll sheet list left button to scroll the sheet list of the current spreadsheet to the left; click the Scroll sheet list right button to scroll the sheet list of the current spreadsheet to the right; Use the button on the status bar to add a new worksheet. To select the necessary sheet: click button on the status bar to open the list of all sheets and to select the sheet you need. The list of sheets also displays the sheet status, or click the appropriate Sheet Tab next to button. The Zoom buttons are situated in the lower right corner and are used to zoom in and out of the current sheet. To change the currently selected zoom value that is displayed in percent, click it and select one of the available zoom options from the list (50% / 75% / 100% / 125% / 150% / 175% / 200% / 300% / 400% / 500%) or use the Zoom in or Zoom out buttons. The Zoom settings are also available on the View tab. The set scaling is maintained for all files during the current session. You can set a default zoom value. Switch to the File tab of the top toolbar, go to the Advanced Settings section, choose the necessary Default Zoom Value from the list, and click the Apply button. To use the previously set scaling, scroll to the top of the drop-down list, and select the Last Used option."
    },
   {
        "id": "HelpfulHints/Search.htm", 
        "title": "Search and Replace Functions", 
        "body": "To search for the required characters, words or phrases in the Spreadsheet Editor, click the Search icon situated on the left sidebar, the icon situated in the upper right corner, or use the Ctrl+F (Command+F for MacOS) key combination to open the small Find panel or the Ctrl+H key combination to open the full Find panel. A small Find panel will open in the upper right corner of the working area.The panel includes the text field for typing in a search query, the number of search results, and controls for moving to the previous or the next result, and closing the bar. To access the advanced settings, click the icon. The Find and replace panel will open: Type in your inquiry into the corresponding Find data entry field. To navigate between the found occurrences, click one of the arrow buttons. The button shows the next occurrence while the button shows the previous one. If you need to replace one or more occurrences of the found characters, type in the replacement text into the corresponding Replace with data entry field. You can choose to replace a single currently selected occurrence or replace all occurrences by clicking the corresponding Replace and Replace All buttons. The Replace button can also be found on the Home tab. Specify search options by checking the necessary options: Within - is used to search within the active Sheet only, the whole Workbook, or the Specific range. In the latter case, the Select Data range field will become active where you can specify the required range. Search - is used to specify the direction that you want to search: to the right by rows or down by columns. Look in - is used to specify whether you want to search the Value of the cells or their underlying Formulas. Specify search parameters by checking the necessary options below the entry fields: Case sensitive - is used to find only the occurrences typed in the same case as your inquiry (e.g. if your inquiry is 'Editor' and this option is selected, such words as 'editor' or 'EDITOR' etc. will not be found). Entire cell contents - is used to find only the cells that do not contain any other characters besides the ones specified in your inquiry (e.g. if your inquiry is '56' and this option is selected, the cells containing such data as '0.56' or '156' etc. will not be found). All occurrences will be highlighted in the file and shown as a list in the Find panel to the left. Use the list to skip to the required occurrence, or use the navigation and buttons."
    },
   {
        "id": "HelpfulHints/SpellChecking.htm", 
        "title": "Spell-checking", 
        "body": "The Spreadsheet Editor allows you to check the spelling of the text in a certain language and correct mistakes while editing. In the desktop version, it's also possible to add words into a custom dictionary which is common for all three editors. Starting from version 6.3, the ONLYOFFICE editors support the SharedWorker interface for smoother operation without significant memory consumption. If your browser does not support SharedWorker then just Worker will be active. For more information about SharedWorker please refer to this article. Click the Spell checking icon on the left sidebar to open the spell checking panel. The upper left cell that contains a misspelled text value will be automatically selected in the current worksheet. The first misspelled word will be displayed in the spell checking field, and the suggested similar words with correct spelling will appear in the field below. Use the Go to the next word button to navigate through misspelled words. Replace misspelled words To replace the currently selected misspelled word with the suggested one, choose one of the suggested similar words spelled correctly and use the Change option: click the Change button, or click the downward arrow next to the Change button and select the Change option. The current word will be replaced and you will proceed to the next misspelled word. To quickly replace all the identical words repeated on the worksheet, click the downward arrow next to the Change button and select the Change all option. Ignore words To skip the current word: click the Ignore button, or click the downward arrow next to the Ignore button and select the Ignore option. The current word will be skipped, and you will proceed to the next misspelled word. To skip all the identical words repeated in the worksheet, click the downward arrow next to the Ignore button and select the Ignore all option. If the current word is missed in the dictionary, you can add it to the custom dictionary using the Add to Dictionary button on the spell checking panel. This word will not be treated as a mistake next time. This option is available in the desktop version. The Dictionary Language which is used for spell-checking is displayed in the list below. You can change it, if necessary. Once you verify all the words in the worksheet, the Spellcheck has been completed message will appear on the spell-checking panel. To close the spell-checking panel, click the Spell checking icon on the left sidebar. Change the spell check settings To change the spell-checking settings, go to the spreadsheet editor advanced settings (File tab -> Advanced Settings) and scroll down to the Proofing section. Here you can adjust the following parameters: Dictionary language - select one of the available languages from the list. The Dictionary Language on the spell-checking panel will be changed correspondingly. Ignore words in UPPERCASE - check this option to ignore words written in capital letters, e.g. acronyms like SMB. Ignore words with numbers - check this option to ignore words containing numbers, e.g. acronyms like B2B. AutoCorrect options... - to learn more about the available autocorrect options, please refer to the following article. To save the changes you made, click the Apply button."
    },
   {
        "id": "HelpfulHints/SupportedFormats.htm", 
        "title": "Supported Formats of Spreadsheets", 
        "body": "A spreadsheet is a table of data organized in rows and columns. It is most frequently used to store financial information because of its ability to re-calculate the entire sheet automatically after a change to a single cell is made. The Spreadsheet Editor allows you to open, view and edit the most popular spreadsheet file formats. While uploading or opening the file for editing, it will be converted to the Office Open XML (XLSX) format. It's done to speed up the file processing and increase the interoperability. The following table contains the formats which can be opened for viewing and/or editing. Formats Description View natively View after conversion to OOXML Edit natively Edit after conversion to OOXML CSV Comma Separated Values A file format used to store tabular data (numbers and text) in plain-text form. + + ET WPS Spreadsheets Workbook A spreadsheet file format included in the WPS Office suite that supports charts and formulas and stores data in rows and columns of cells. + + ETT WPS Spreadsheets Template A spreadsheet template included in the WPS Office suite. ETT files are similar to ET files, storing rows and columns of data, charts, and graphs, but they are primarily used for duplicating spreadsheets with similar layouts and information. + + FODS OpenDocument Flat XML Spreadsheet An XML-based file format for saving and exchanging spreadsheets. + + ODS A file extension for spreadsheet files used by OpenOffice and StarOffice suites, an open standard for spreadsheets. + + OTS OpenDocument Spreadsheet Template An OpenDocument file format for spreadsheet templates. An OTS template contains formatting settings, styles etc. and can be used to create multiple spreadsheets with the same formatting + + SXC Sun XML Calc An XML based spreadsheet file format that belongs to OpenOffice suite, supports formulas, functions, macros and charts. + + XLS File extension for spreadsheet files created by Microsoft Excel. + + XLSX Default file extension for spreadsheet files written in Microsoft Office Excel 2007 (or later versions). + + XLTM An XLTM file is a macro-enabled spreadsheet template created by Microsoft Excel. + + XLTX Excel Open XML Spreadsheet Template Zipped, XML-based file format developed by Microsoft for spreadsheet templates. An XLTX template contains formatting settings, styles etc. and can be used to create multiple spreadsheets with the same formatting. + + XML Extensible Markup Language (XML) A file format that is used for structuring, storing and transmitting data. + + The following table contains the formats in which you can download a spreadsheet from the File -> Download as menu. Input format Can be downloaded as CSV JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX ET CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX ETT CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX FODS CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX ODS CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX SXC CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX OTS CSV, JPG, ODS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX XLS CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX XLSM CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSX, XLTM, XLTX XLSX CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLTM, XLTX XLTM CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTX XML CSV, JPG, ODS, OTS, PDF, PDF/A, PNG, XLSM, XLSX, XLTM, XLTX You can also refer to the conversion matrix on api.onlyoffice.com to see possibility of conversion your spreadsheets into the most known file formats."
    },
   {
        "id": "HelpfulHints/VersionHistory.htm", 
        "title": "Version history", 
        "body": "The Spreadsheet Editor allows you to maintain constant team-wide approach to work flow: share files and folders, collaborate on spreadsheets in real time, communicate right in the editor, comment certain parts of your spreadsheets that require additional third-party input. In Spreadsheet Editor you can view the version history of the spreadsheet you collaborate on. Viewing version history: To view all the changes made to the spreadsheet, go to the File tab, select the Version History option at the left sidebar or go to the Collaboration tab, open the history of versions using the  Version History icon at the top toolbar. You'll see the list of the spreadsheet versions and revisions with the indication of each version/revision author and creation date and time. For spreadsheet versions, the version number is also specified (e.g., ver. 2). Viewing versions: To know exactly which changes have been made in each separate version/revision, you can view the one you need by clicking it on the left sidebar. The changes made by the version/revision author are highlighted with the same color as their avatar in the viewing version history window. To return to the current version of the spreadsheet, use the Close History option on the top of the version list. Restoring versions: If you need to roll back to one of the previous versions of the spreadsheet, click the Restore link below the selected version/revision. To learn more about managing versions and intermediate revisions, as well as restoring previous versions, please read the following article."
    },
   {
        "id": "ProgramInterface/CollaborationTab.htm", 
        "title": "Collaboration tab", 
        "body": "The Collaboration tab allows working collaboratively in the Spreadsheet Editor. In the online version, you can share the file, select the required co-editing mode and manage comments. In the commenting mode, you can add and remove comments and communicate via chat. In the desktop version, you can only manage comments. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: Using this tab, you can: adjust the sharing settings (available in the online version only), switch between the Strict and Fast co-editing modes (available in the online version only), add or remove comments left in the spreadsheet, open the Chat panel (available in the online version only), track version history (available in the online version only)."
    },
   {
        "id": "ProgramInterface/DataTab.htm", 
        "title": "Data tab", 
        "body": "The Data tab allows managing data in the Spreadsheet Editor. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: Using this tab, you can: sort and filter data, convert text to columns, remove duplicates from a data range, group and ungroup data, set data validation parameters, find the right input for the value that you want, get data from TXT/CSV file, view other files the spreadsheet is linked to via the External Links button."
    },
   {
        "id": "ProgramInterface/DrawTab.htm", 
        "title": "Draw tab", 
        "body": "The Draw tab of the Spreadsheet Editor allows users to perform basic drawing operations. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: Using this tab, you can: use the select tool to resize or delete the inscription, the drawing or the highlighting, use the pen and the highlighter tools to draw or to add handwritten notes and highlighting, use the eraser tool to remove the whole drawing or the handwritten text,"
    },
   {
        "id": "ProgramInterface/FileTab.htm", 
        "title": "File tab", 
        "body": "The File tab in the Spreadsheet Editor allows performing basic operations with the current file. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: Using this tab, you can perform the following operations: create a new spreadsheet or open a recently edited one (available in the online version only), in the online version, save the current file (in case the Autosave option is disabled), download as (save the spreadsheet in the selected format to hard disk drive of the computer), save copy as (save a copy of the spreadsheet in the selected format to the portal documents), print or rename it, in the desktop version, save the current file keeping the current format and location using the Save option or save the current file with a different name, location or format using the Save as option, print the file, protect the file using a password, change or remove the password, protect the file using a digital signature (available in the desktop version only), view the general information about the spreadsheet or change some file properties, track version history (available in the online version only), Go to Documents - in the desktop version, open the folder, where the file is stored, in the File explorer window, in the online version, open the folder in the Documents module, where the file is stored, in a new browser tab, access the Advanced Settings of the editor, Help - open the built-in help center."
    },
   {
        "id": "ProgramInterface/FormulaTab.htm", 
        "title": "Formula tab", 
        "body": "The Formula tab in the Spreadsheet Editor tab allows working easily with all functions. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: Using this tab, you can: insert functions using the Insert Function dialog window, quickly access Autosum formulas, access 10 recently used formulas, work with formulas classified into categories, work with named ranges, trace precedents and dependents, show formulas in the cells instead of the formula results, use the Watch Window, use the calculation options: calculate the entire workbook, or the current worksheet only."
    },
   {
        "id": "ProgramInterface/HomeTab.htm", 
        "title": "Home tab", 
        "body": "The Home tab opens by default when you open the Spreadsheet Editor. It allows you to format cells and data in them, apply filters, insert functions, etc. Some other options are also available here, such as Format as table template feature and so on. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: Using this tab, you can: set the font type, size, style, and colors, align data in cells, add cell borders and merge cells, insert functions and create named ranges, use the Series tool to fill in data ranges, sort and filter data, change the number format, add or remove cells, rows, columns, copy/clear the cell formatting, use conditional formatting, apply a table template to the selected cell range."
    },
   {
        "id": "ProgramInterface/InsertTab.htm", 
        "title": "Insert tab", 
        "body": "The Insert tab allows adding visual objects and comments in the Spreadsheet Editor. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: Using this tab, you can: insert pivot tables, insert formatted tables, insert images, shapes, text boxes and Text Art objects, SmartArt objects, insert recommended charts, charts, sparklines, insert comments and hyperlinks, insert headers/footers, insert equations and symbols, insert slicers."
    },
   {
        "id": "ProgramInterface/LayoutTab.htm", 
        "title": "Layout tab", 
        "body": "The Layout tab in the Spreadsheet Editor allows adjusting the appearance of a spreadsheet: setting up the page parameters and defining the arrangement of visual elements. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: Using this tab, you can: adjust page margins, orientation, size, specify a print area, insert page breaks, insert headers or footers, scale a worksheet, switch the sheet direction so that the first column is on the right side using the Sheet Right-to-Left button, print titles on a page, align and arrange objects (images, charts, shapes), change color scheme."
    },
   {
        "id": "ProgramInterface/PivotTableTab.htm", 
        "title": "Pivot Table tab", 
        "body": "The Pivot Table tab in the Spreadsheet Editor allows creating and editing pivot tables. Starting from ONLYOFFICE Docs version 8.2, the Pivot Table tab is hidden by default and will open only while working with pivot tables. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: Using this tab, you can: create a new pivot table, choose the necessary layout for your pivot table, update the pivot table if you change the data in your source data set, select an entire pivot table with a single click, expand or collapse fields to show/hide the details for the pivot table items, highlight certain rows/columns by applying a specific formatting style to them, choose one of the predefined tables styles."
    },
   {
        "id": "ProgramInterface/PluginsTab.htm", 
        "title": "Plugins tab", 
        "body": "The Plugins tab in the Spreadsheet Editor allows accessing the advanced editing features using the available third-party components. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: The Plugin Manager button allows you to open the window where you can view and manage all the installed plugins and add your own ones. The Background Plugins button allows viewing the list of plugins that work in the background. Here you can activate or disable them by activating/deactivating the corresponding switches, and adjust their settings by clicking the More button next to the required plugin. Starting with ONLYOFFICE Docs 8.2, no plugins come with the editors by default. The plugins shall be installed via Plugin Manager. Currently, the following plugins are available: Send allows to send the spreadsheet via email using the default desktop mail client (available in the desktop version only), Highlight code allows to highlight syntax of the code selecting the necessary language, style, background color, Photo Editor allows to edit images: crop, flip, rotate them, draw lines and shapes, add icons and text, load a mask and apply filters such as Grayscale, Invert, Sepia, Blur, Sharpen, Emboss, etc., Thesaurus allows to search for synonyms and antonyms of a word and replace it with the selected one, Translator allows to translate the selected text into other languages, Note: this plugin doesn't work in Internet Explorer. YouTube allows to embed YouTube videos into your spreadsheet. Several visual plugins can be added to your document. The added plugins will be displayed as corresponding icons on the left panel. To learn more about plugins, please refer to our API Documentation. All the existing open-source plugin examples are currently available on GitHub."
    },
   {
        "id": "ProgramInterface/ProgramInterface.htm", 
        "title": "Introducing the Spreadsheet Editor user interface", 
        "body": "The Spreadsheet Editor uses a tabbed interface where editing commands are grouped into tabs by functionality. Main window of the Online Spreadsheet Editor: Main window of the Desktop Spreadsheet Editor: The editor interface consists of the following main elements: The Editor header displays the logo, tabs for all opened spreadsheets, with their names and menu tabs. On the left side of the Editor header there are the Save, Print file, Undo and Redo buttons are located. Click the dots icon to the right to customize which buttons shall be hidden, if any. On the right side of the Editor header along with the username, the following icons are displayed: Open file location - in the desktop version, it allows opening the folder, where the file is stored, in the File explorer window. In the online version, it allows opening the folder in the Documents module where the file is stored, in a new browser tab. Share - (available in the online version only) allows setting access rights for the documents stored in the cloud. Mark as favorite - click the star to add a file to favorites as to make it easy to find. The added file is just a shortcut so the file itself remains stored in its original location. Deleting a file from favorites does not remove the file from its original location. Search - allows to search the spreadsheet for a particular word or symbol, etc. The top toolbar displays a set of editing commands depending on the selected menu tab. Currently, the following tabs are available: File, Home, Insert, Draw, Layout, Formula, Data, Pivot Table, Collaboration, Protection, View, Plugins. The Copy, Paste, Cut, and Copy style options are always available at the left part of the Top toolbar regardless of the selected tab. The Select All button is located at the left part of the Top toolbar of the Home tab. The Formula bar allows entering and editing formulas or values in the cells. The Formula bar displays the contents of the currently selected cell. The Status bar at the bottom of the editor window contains some navigation tools: sheet navigation buttons, add worksheet button, list of sheets button, sheet tabs, and zoom buttons. The Status bar also displays the background save status and connection status when there is no connection and the editor is trying to reconnect, the number of filtered records if you apply a filter, or the results of automatic calculations if you select several cells containing data. The Left sidebar contains the following icons: - allows using the Search and Replace tool, - allows opening the Comments panel, - (available in the online version only) allows opening the Chat panel, - allows to check the spelling of your text in a certain language and correct mistakes while editing. - allows contacting our support team, - (available in the online version only) allows viewing the information about the program. The Right sidebar allows adjusting additional parameters of different objects. When you select a particular object in a worksheet, the corresponding icon is activated on the right sidebar. Click this icon to expand the right sidebar. The Working area allows viewing the contents of a spreadsheet, as well as entering and editing data. The horizontal and vertical Scroll bars allow scrolling up/down and left/right. For your convenience, you can hide some components and display them again when necessary. To learn more on how to adjust view settings please refer to this page. When there are many icons on the left and right panels, the ones below will be hidden, and they can be accessed via the More button."
    },
   {
        "id": "ProgramInterface/ProtectionTab.htm", 
        "title": "Protection tab", 
        "body": "The Protection tab in the Spreadsheet Editor allows you to prevent unauthorized access by encrypting and protecting the workbook or the sheets. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: Using this tab, you can: Encrypt your document by setting a password, Protect workbook structure with or without a password, Protect sheet by restricting editing abilities within a sheet with or without a password, Enable and disable the following options: Locked Cell, Hidden Formulas, Shape Locked, Lock Text, Protect range to restrict editing ranges to selected users."
    },
   {
        "id": "ProgramInterface/ViewTab.htm", 
        "title": "View tab", 
        "body": "The View tab in the Spreadsheet Editor allows you to manage sheet view presets based on applied filters view options. The corresponding window of the Online Spreadsheet Editor: The corresponding window of the Desktop Spreadsheet Editor: View options available on this tab: Sheet View allows to manage sheet view presets. Normal allows to see the spreadsheet fully. Page Break Preview allows to see the printed area of the spreadsheet only. Zoom allows to zoom in and zoom out your spreadsheet. Interface Theme allows to change interface theme by choosing a Same as system, Light, Classic Light, Dark, Contrast Dark, or Gray theme. Freeze Panes allows to freeze and unfreeze certain panes or rows and columns. The following options allow you to configure the elements to display or to hide. Check the elements to make them visible: Formula Bar to show a formula bar above the spreadsheet. Headings to show headings, i.e., column headings at the top and row headings on the left. Gridlines to show gridlines, i.e., cell outlines. Show Zeros to always show \"0\" when entered in a cell. Always Show Toolbar to make the top toolbar always visible. Combine Sheet and Status Bars to display all sheet navigation tools and status bar in a single line. The status bar will appear in two lines when this box is unchecked. Left Panel to make the left panel visible. Right Panel to make the right panel visible. The Macros button allows you to open the window where you can create and run your own macros. To learn more about macros, please refer to our API Documentation."
    },
   {
        "id": "UsageInstructions/AddBorders.htm", 
        "title": "Add cell background and borders", 
        "body": "Add a cell background To apply and format a cell background in the Spreadsheet Editor, select a cell or a cell range with the mouse or the whole worksheet by pressing the Ctrl+A key combination, Note: you can also select multiple non-adjacent cells or cell ranges holding down the Ctrl key while selecting cells/ranges with the mouse. to apply a solid color fill to the cell background, click the Background color icon on the Home tab of the top toolbar and choose the required color. to use other fill types, such as a gradient fill or pattern, click the Cell settings icon on the right sidebar and use the Fill section: Color Fill - select this option to specify the solid color you want to fill the selected cells with. Click the colored box below and select one of the following palettes: Theme Colors - the colors that correspond to the selected color scheme of the spreadsheet. Standard Colors - a set of default colors. The selected color scheme does not affect them. You can also apply a custom color using two different options: Eyedropper - use this option to choose the required color by clicking it in the spreadsheet. More colors - click this caption if the required color is missing among the available palettes. Select the necessary color range moving the vertical color slider and set a specific color dragging the color picker within the large square color field. Once you select a color with the color picker, the appropriate RGB and sRGB color values will be displayed in the fields on the right. You can also define a color on the base of the RGB color model by entering the corresponding numeric values into the R, G, B (red, green, blue) fields or enter the sRGB hexadecimal code into the field marked with the # sign. The selected color appears in the New preview box. If the object was previously filled with any custom color, this color is displayed in the Current box so you can compare the original and modified colors. When the color is defined, click the Add button: The custom color will be applied to the selected element and added to the Recent colors palette. Gradient Fill - fill the selected cells with two colors which smoothly change from one to the other. Angle - manually specify an exact value in degrees that defines the gradient direction (colors change in a straight line at the specified angle). Direction - choose a predefined template from the menu. The following directions are available: top-left to bottom-right (45&deg;), top to bottom (90&deg;), top-right to bottom-left (135&deg;), right to left (180&deg;), bottom-right to top-left (225&deg;), bottom to top (270&deg;), bottom-left to top-right (315&deg;), left to right (0&deg;). Gradient Point is a specific point for transition from one color to another. Use the Add Gradient Point button or slider bar to add a gradient point. You can add up to 10 gradient points. Each next gradient point added will in no way affect the current gradient fill appearance. Use the Remove Gradient Point button to delete a certain gradient point. Use the slider bar to change the location of the gradient point or specify Position in percentage for precise location. To apply a color to a gradient point, click a point on the slider bar, and then click Color to choose the color you want. Pattern - select this option to fill the selected cells with a two-colored design composed of regularly repeated elements. Pattern - select one of the predefined designs from the menu. Foreground color - click this color box to change the color of the pattern elements. Background color - click this color box to change the color of the pattern background. No Fill - select this option if you don't want to use any fill. Add cell borders To add and format borders to a worksheet, select a cell, a range of cells with the mouse or the whole worksheet by pressing the Ctrl+A key combination, Note: you can also select multiple non-adjacent cells or cell ranges holding down the Ctrl key while selecting cells/ranges with the mouse. click the Borders icon on the Home tab of the top toolbar or click the Cell settings icon on the right sidebar and use the Borders Style section, select the border style you wish to apply: open the Border Style submenu and select one of the available options, open the Border Color icon submenu or use the Color palette on the right sidebar and select the required color from the palette, select one of the available border templates: Outside Borders , All Borders , Top Borders , Bottom Borders , Left Borders , Right Borders , No Borders , Inside Borders , Inside Vertical Borders , Inside Horizontal Borders , Diagonal Up Border , Diagonal Down Border ."
    },
   {
        "id": "UsageInstructions/AddExternalLinks.htm", 
        "title": "Add external links to cells", 
        "body": "In the Spreadsheet Editor, you can create an external link to a cell or a range of cells in another workbook. The external links to cells can be created between files within the current portal (in the online editor) or between local files (in the desktop editor). Note: in the online editor, the ability to insert data via an external link must also be implemented on the integrator side (e.g., in a third-party document management system). If data in the source workbook changes, you can update values in the destination workbook without copying them manually once again. To add an external link, open the source workbook and the destination workbook, in the source workbook, copy a cell or a range of cells (Ctrl+C), in the destination workbook, paste the copied data (Ctrl+V), click the Paste Special button and choose the Paste link option (or use the Ctrl key to open the Paste Special menu, then press N). The link will be added. If you click the cell which contains an external link, it looks like ='[SourceWorkbook.xlsx]Sheet1'!A1 in the formula bar. To update the added external links, switch to the Data tab, click the External Links button, activate the Automatically update data from the linked sources to keep all data constantly up-to-date, to update certain values, select them and click the Update values button. The status will be changed to 'OK'. In the same External links window, you can click the Open source button to go to the source workbook; or click the Change source button to change the source link. When you open the workbook which contains external links, the warning appears: Click Update to update all external links. To break the added external links, switch to the Data tab, click the External Links button, select the necessary link in the list, click the Break Links button or click the arrow next to it and choose whether you want to Break links (currently selected) or Break all links. The links will be broken, and the values will not be updated."
    },
   {
        "id": "UsageInstructions/AddHyperlinks.htm", 
        "title": "Add hyperlinks", 
        "body": "To add a hyperlink in the Spreadsheet Editor, select a cell where a hyperlink should be added, switch to the Insert tab of the top toolbar, click the Hyperlink icon on the top toolbar, the Hyperlink Settings window will appear, and you will be able to specify the hyperlink settings: Select the required link type: Use the External Link option and enter a URL in the http://www.example.com format in the Link to field below if you need to add a hyperlink leading to an external website. If you need to add a hyperlink to a local file, enter the URL in the file://path/Spreadsheet.xlsx (for Windows) or file:///path/Spreadsheet.xlsx (for MacOS and Linux) format in the Link to field. The file://path/Spreadsheet.xlsx or file:///path/Spreadsheet.xlsx hyperlink type can be opened only in the desktop version of the editor. In the web editor you can only add the link without being able to open it. Use the Internal Data Range option, select a worksheet and a cell range in the fields below, or a previously added Named range if you need to add a hyperlink leading to a certain cell range in the same spreadsheet. You can also generate an external link which will lead to a particular cell or a range of cells by clicking the Get Link button or using the Get link to this range option in the contextual right-click menu of the required cell range. The Get link to this range option is also available in the viewing mode. Display - enter a text that will become clickable and lead to the web address specified in the upper field. Note: if the selected cell already contains data, it will be automatically displayed in this field. ScreenTip Text - enter a text that will become visible in a small pop-up window with a brief note or label connected to the hyperlink. click the OK button. To add a hyperlink, you can also use the Ctrl+K key combination or click with the right mouse button the position where the hyperlink should be added and select the Hyperlink option in the right-click menu. When you hover the cursor over the added hyperlink, the ScreenTip will appear. To follow the link, click the link in the spreadsheet. To select a cell that contains a link without opening the link, click and hold the mouse button. To delete the added hyperlink, activate the cell containing the added hyperlink and press the Delete key, or right-click the cell and select the Clear All option from the drop-down list."
    },
   {
        "id": "UsageInstructions/AlignText.htm", 
        "title": "Align data in cells", 
        "body": "In the Spreadsheet Editor, you can align data horizontally and vertically or even rotate data within a cell. To do that, select a cell or a cell range with the mouse or the whole worksheet by pressing the Ctrl+A key combination. You can also select multiple non-adjacent cells or cell ranges holding down the Ctrl key while selecting cells/ranges with the mouse. Then perform one of the following operations using the icons situated on the Home tab of the top toolbar. Apply one of the horizontal alignment styles to the data within a cell, click the Align left icon to align the data to the left side of the cell (the right side remains unaligned); click the Align center icon to align the data in the center of the cell (the right and the left sides remains unaligned); click the Align right icon to align the data to the right side of the cell (the left side remains unaligned); click the Justified icon to align the data both to the left and the right sides of the cell (additional spacing is added where necessary to keep the alignment). Change the vertical alignment of the data within a cell, click the Align top icon to align your data to the top of the cell; click the Align middle icon to align your data to the middle of the cell; click the Align bottom icon to align your data to the bottom of the cell. Change the angle of the data within a cell by clicking the Orientation icon and choosing one of the following options: use the Horizontal Text option to place the text horizontally (default option), use the Angle Counterclockwise option to place the text from the bottom left corner to the top right corner of a cell, use the Angle Clockwise option to place the text from the top left corner to the bottom right corner of a cell, use the Vertical text option to place the text vertically, use the Rotate Text Up option to place the text from bottom to top of a cell, use the Rotate Text Down option to place the text from top to bottom of a cell. Indent text within a cell using the Indent section on the Cell Settings right sidebar. Specify the value (i.e. the number of characters) by which the contents will be moved to the right. If you change the orientation of the text, indents will be reset. If you change indents for the rotated text, the orientation of the text will be reset. Indents can only be set if the horizontal or vertical text orientation is selected. Rotate the text by an exactly specified angle, click the Cell settings icon on the right sidebar and use the Orientation. Enter the necessary value measured in degrees into the Angle field or adjust it using the arrows on the right. Fit your data to the column width by clicking the Wrap text icon on the Home tab of the top toolbar or by checking the Wrap text checkbox on the right sidebar. If you change the column width, data wrapping adjusts automatically. Fit your data to the cell width by checking the Shrink to fit checkbox on the right sidebar. The contents of the cell will be reduced in size to such an extent that it can fit in it."
    },
   {
        "id": "UsageInstructions/ChangeNumberFormat.htm", 
        "title": "Change number format", 
        "body": "Apply a number format In the Spreadsheet Editor, you can easily change the number format, i.e. the way the numbers appear in a spreadsheet. To do that, select a cell, a cell range with the mouse or the whole worksheet by pressing the Ctrl+A key combination, Note: you can also select multiple non-adjacent cells or cell ranges holding down the Ctrl key while selecting cells/ranges with the mouse. drop-down the Number format button list situated on the Home tab of the top toolbar or right-click the selected cells and use the Number Format option from the contextual menu. Select the number format you wish to apply: General - is used to display the data as plain numbers in the most compact way without any additional signs, Number - is used to display the numbers with 0-30 digits after the decimal point where a thousand separator is added between each group of three digits before the decimal point, Scientific (exponential) - is used to keep short the numbers converting in a string of type d.dddE+ddd or d.dddE-ddd where each d is a digit 0 to 9, Accounting - is used to display monetary values with the default currency symbol and two decimal places. To apply another currency symbol or number of decimal places, follow the instructions below. Unlike the Currency format, the Accounting format aligns currency symbols to the left side of the cell, represents zero values as dashes and displays negative values in parentheses. Note: to quickly apply the Accounting format to the selected data, you can also click the Accounting style icon on the Home tab of the top toolbar and select one of the following currency symbols: &#36; Dollar, &euro; Euro, &pound Pound, &#8381; Rouble, &yen Yen, kn Croatian Kuna. Currency - is used to display monetary values with the default currency symbol and two decimal places. To apply another currency symbol or number of decimal places, follow the instructions below. Unlike the Accounting format, the Currency format places a currency symbol directly before the first digit and displays negative values with the negative sign (-). Short Date - is used to display date in the DD.MM.YYYY format, Long Date - is used to display date in the DD.month in full.YYYY format, Time - is used to display time, Percentage - is used to display the data as a percentage accompanied by a percent sign %, Note: to quickly apply the percent style to the data, you can also use the Percent style icon on the Home tab of the top toolbar. Fraction - is used to display the numbers as common fractions rather than decimals. Text - is used to display the numeric values as a plain text with as much precision as possible. More formats - is used to create a custom number format or to customize the already applied number formats specifying additional parameters (see the description below). Custom - is used to create a custom format: select a cell, a range of cells, or the whole worksheet for values you want to format, choose the Custom option from the More formats menu, enter the required codes and check the result in the preview area or choose one of the templates and/or combine them. If you want to create a format based on the existing one, first apply the existing format and then edit the codes to your preference, click OK. change the number of decimal places if needed: use the Increase decimal icon situated on the Home tab of the top toolbar to display more digits after the decimal point, use the Decrease decimal icon situated on the Home tab of the top toolbar to display fewer digits after the decimal point. use the Comma style icon situated on the Home tab of the top toolbar to display numbers with two decimal places and thousands separated with a comma. Note: to change the number format, you can also use keyboard shortcuts. Customize the number format You can customize the applied number format in the following way: select the cells whose number format you want to customize, drop-down the Number format button list on the Home tab of the top toolbar or right-click the selected cells and use the Number Format option from the contextual menu, select the More formats option, in the opened Number Format window, adjust the available parameters. The options differ depending on the number format that is applied to the selected cells. You can use the Category list to change the number format. for the Number format, you can set the number of Decimal points, specify if you want to Use 1000 separator or not and choose one of the available Formats for displaying negative values. for the Scientific and Percentage formats, you can set the number of Decimal points. for the Accounting and Currency formats, you can set the number of Decimal points, choose one of the available currency Symbols and one of the available Formats for displaying negative values. for the Date format, you can select one of the available date formats: 4/15, 04/15, 4/15/06, 04/15/06, 4/15/2006, 04/15/2006, 4/15/06 0:00, 04/15/06 0:00, 4/15/06 12:00 AM, A, April 15 2006, 15-Apr, 15-Apr-06, Apr-06, April-06, A-06, 06-Apr, 15-Apr-2006, 2006-Apr-15, 06-Apr-15,  06-4-15, 06-04-15, 2006-4-15, 2006-04-15, 15/Apr, 15/Apr/06, Apr/06, April/06, A/06, 06/Apr, 15/Apr/2006, 2006/Apr/15, 06/Apr/15, 06/4/15, 06/04/15, 2006/4/15, 2006/04/15, 15 Apr, 15 Apr 06, Apr 06, April 06, A 06, 06 Apr, 15 Apr 2006, 2006 Apr 15, 06 Apr 15, 06 4 15, 06 04 15, 2006 4 15, 2006 04 15. for the Time format, you can select one of the available time formats: 12:48:58 PM, 12:48, 12:48 PM, 12:48:58, 48:57.6, 36:48:58. for the Fraction format, you can select one of the available formats: Up to one digit (1/3), Up to two digits (12/25), Up to three digits (131/135), As halves (1/2), As fourths (2/4), As eighths (4/8), As sixteenths (8/16), As tenths (5/10) , As hundredths (50/100). click the OK button to apply the changes."
    },
   {
        "id": "UsageInstructions/ChatGPT.htm", 
        "title": "ChatGPT", 
        "body": "The ChatGPT plugin allows you to use the OpenAI chatbot to perform tasks that involve understanding or generating natural language or code. Starting with ONLYOFFICE Docs 8.2, no plugins come with the editors by default. The plugins shall be installed via Plugin Manager. Installation To install the ChatGPT plugin, Go to the Plugins tab. Open the Plugin Manager. Find ChatGPT on the marketplace and click the Install button below. Right-click anywhere in the document and find ChatGPT in the context menu. Click Settings to proceed with the plugin configuration. Configuration Create your API key on the OpenAI API key page. Copy the generated API key into the corresponding field of the Settings window. How to use ONLYOFFICE assumes no responsibility for any ChatGPT completions that may contain errors or omissions as well as for any harassing and inappropriate content. The information contained in the plugin completions is generated by ChatGPT and is provided on the \"as is\" basis without additional filtering from ONLYOFFICE. Once installed ChatGPT will be added to the context menu, and all of the ChatGPT features will be accessed with a right mouse click. Select a piece of text or a word to access the context menu and to choose one of the ChatGPT features: Text Analysis, Word Analysis, Translation, Image Generation, Thesaurus, Chat, and Custom Request. Chat Integration of ChatGPT into the context menu allows you to invoke the Chat from anywhere in the document. Use chatbot to interact and carry on a conversation, ask questions, and receive responses to your requests. Navigate to the Chat option from the ChatGPT context menu, and start a conversation in the text box at the bottom of the ChatGPT window. Custom Request The Custom Request feature allows you to tokenize natural language or code. The tool converts the input text into a list of tokens, processes the request, converts the generated tokens back to the text, and returns the string in the document. To make a custom request, go to the ChatGPT context menu, and click Custom request. In the Open AI text box, enter the text you would like to tokenize. The tool shows the total number of tokens in the text. Click the Show advanced settings to configure the request settings: Model - the model which will generate the completion. Some models are suitable for natural language tasks, others specialize in code. To learn more about these models, please refer to the official ChatGPT website. Maximum length - the maximum number of tokens to generate in the completion. Temperature - this parameter controls randomness, e.g., lowering it results in less random completions. As the temperature approaches zero, the node will become deterministic and repetitive. Top P - an alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. Stop sequences - up to four sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence. Click the Submit button to process the text, or click the Clear button to delete the request and enter a new one."
    },
   {
        "id": "UsageInstructions/ClearFormatting.htm", 
        "title": "Clear text, format in a cell, copy cell format", 
        "body": "Clear format In the Spreadsheet Editor, you can quickly remove the text or format from the selected cell. To do that, select a cell, a cell range with the mouse or the whole worksheet by pressing the Ctrl+A key combination, Note: you can also select multiple non-adjacent cells or cell ranges holding down the Ctrl key while selecting cells/ranges with the mouse. click the Clear icon on the Home tab of the top toolbar and select one of the available options: use the All option if you wish to remove everything including the text, format, function etc; use the Text option if you wish to remove the text from the selected range of cell range; use the Format option if you wish to remove the format of the selected cell range. The text and all functions will remain; use the Comments option if you wish to remove comments from the selected cell range; use the Hyperlinks option if you wish to remove hyperlinks from the selected cell range. Note: all these options are also available in the right-click menu. Copy cell format You can quickly copy the format of a certain cell and apply it to other cells. To apply the copied format to a single cell or several adjacent cells, select the cell/cell range with the required format by clicking or using the keyboard, click the Copy style icon on the Home tab of the top toolbar, (the mouse pointer will look like this ), select the cell/cell range to apply the required format to. To apply the copied format to multiple non-adjacent cells or cell ranges, select the cell/cell range with the required format by clicking or using the keyboard, double-click the Copy style icon on the Home tab of the top toolbar, (the mouse pointer will look like this and the Copy style icon will remain selected: ), click the required cells or select the cell ranges one by one to apply the same format to all of them, to exit this mode, click the Copy style icon once again or press the Esc key on the keyboard."
    },
   {
        "id": "UsageInstructions/CommunicationPlugins.htm", 
        "title": "Communicate while editing", 
        "body": "In ONLYOFFICE Spreadsheet Editor, you can always keep in touch with colleagues and use popular online messengers, such as Telegram and Rainbow. Telegram and Rainbow plugins are not installed by default. To find information on how to install them, please, refer to the corresponding article: Adding plugins to the ONLYOFFICE Desktop Editors Adding plugins to ONLYOFFICE Cloud, or Adding new plugins to server editors , or install the plugin using the Plugin Manager.. Telegram To start chatting in the Telegram plugin, Switch to the Plugins tab and click Telegram, enter your phone number into the corresponding field, check the Keep me signed in checkbox if you want to save credentials for the current session and click the Next button, enter the code you've received in your Telegram app, or log in using the QR code, open Telegram app on your phone, go to Settings > Devices > Scan QR, scan the image to Log in. Now you can use Telegram for instant messaging within ONLYOFFICE editors interface. Rainbow To start chatting in the Rainbow plugin, Switch to the Plugins tab and click Rainbow, register a new account by clicking the Sign up button, or log into an already created one. To do this, enter your email into the corresponding field and click Continue, then enter your account password, check the Keep my session alive checkbox if you want to save credentials for the current session, and click the Connect button, fill in the fields in the Your identity window. Now you're all set and can simultaneously chat in Rainbow and work within ONLYOFFICE editors interface."
    },
   {
        "id": "UsageInstructions/ConditionalFormatting.htm", 
        "title": "Conditional Formatting", 
        "body": "Conditional formatting allows you to apply various formatting styles (color, font, decoration, gradient) to cells to work with data on the spreadsheet: highlight or sort through and display the data that meets the needed criteria. Specify the fit for purpose criteria and create new formatting rules, edit, manage or clear the existing rules. Conditional formatting rules supported by the ONLYOFFICE Spreadsheet Editor are: Value is, Top/Bottom, Average, Text, Date, Blank/Error, Duplicate/Unique, Data Bars, Color Scales, Icon Sets, Formula. For quick access, or if you want to choose one of the available preset conditions, or to access all the available conditional formatting options go to the Home tab and click the Conditional formatting button . All Conditional Formatting options are also available on the right sidebar in the Cell Settings tab. Click the Conditional Formatting control down arrow to open the drop-down menu containing all the available options. To open the New Formatting Rule window, you can right-click any cell and choose Conditional Formatting from the contextual menu. To apply a formatting rule condition, select the cell range then click the Conditional formatting button on the top toolbar, or click the Conditional Formatting control of the Cell Settings tab on the right sidebar, and choose the appropriate rule from the drop-down menu. . The New Formatting Rule window will open for you to format the highlighting criteria. Value is Formatting Rule The Value is formatting rule is used to find and highlight cells meeting a certain comparison condition: Greater than Greater than or equal to Less than Less than or equal to Equal to Not equal to Between Not between The Rule section shows the selected rule and the selected comparison condition, by clicking the down arrow you can access the list of the available rules and conditions. Use the Select Data box to define the cell value to compare with. Use the reference to a single cell, or the reference with the worksheet function such as =SUM(A1:B5). The Format section offers a range of cell formatting options. You can choose one of the available format Presets or customize the formatting using font format options (Bold, Italic, Underline, Strikeout), Text color, Fill color and Borders. Use the General drop-down list to choose the appropriate number format (General, Number, Scientific, Accounting, Currency, Date, Time, Percentage). The Preview box shows how the cell will look like after formatting. Click the Clear to delete all the formatting. Click OK to confirm. The example below illustrates the preset formatting criteria, such as Greater than, and Between. This formats mountains with a height greater than 6,960 with a green background and percentile between 5,000 and 6,500 with pink. Top/Bottom Formatting Rule The Top/Bottom rule is used to find and display the top and bottom values within the spreadsheet: Top 10 items Top 10% Bottom 10 items Bottom 10% The Rule section shows the selected rule and the selected condition, by clicking the down arrow you can access the list of the available rules and conditions, the number of items (percentage) to display, and choose either you want to highlight items or percentage. The Format section offers a range of cell formatting options. You can choose one of the available format Presets or customize the formatting using font format options (Bold, Italic, Underline, Strikeout), Text color, Fill color and Borders. Use the General drop-down list to choose the appropriate number format (General, Number, Scientific, Accounting, Currency, Date, Time, Percentage). The Preview box shows how the cell will look like after formatting. Click the Clear button to delete all the formatting. Click OK to confirm. The example below illustrates the preset formatting criteria, such as Top 10% set to show top 20% values, and Bottom 10 items. This formats Top 20% of fees in the cities you visited with an orange background and bottom values for cities where you sold a small number of books with a blue background. Average Formatting Rule The Average is used to find and display values above or below an average or standard deviation in a rating: Above Below Equal to or above Equal to or below 1 std dev above 1 std dev below 2 std dev above 2 std dev below 3 std dev above 3 std dev below The Rule section shows the selected rule and the selected condition, by clicking the down arrow you can access the list of the available rules and conditions. The Format section offers a range of cell formatting options. You can choose one of the available format Presets or customize the formatting using font format options (Bold, Italic, Underline, Strikeout), Text color, Fill color and Borders. Use the General drop-down list to choose the appropriate number format (General, Number, Scientific, Accounting, Currency, Date, Time, Percentage). The Preview box shows how the cell will look like after formatting. Click the Clear button to delete all the formatting. Click OK to confirm. The example below illustrates the preset formatting criteria, such as Above average. This formats the cities where the attendance was above average with a green background. Text Formatting Rule The Text formatting rule is used to find and highlight cells containing certain text and meeting one of the available formatting conditions: Contains Does not contain Begins with Ends with The Rule section shows the selected rule and the selected formatting condition, by clicking the down arrow you can access the list of the available rules and conditions. Use the Select Data box to define the cell value to compare with. Use the reference to a single cell, or the reference with the worksheet function such as =SUM(A1:B5). The Format section offers a range of cell formatting options. You can choose one of the available format Presets or customize the formatting using font format options (Bold, Italic, Underline, Strikeout), Text color, Fill color and Borders. Use the General drop-down list to choose the appropriate number format (General, Number, Scientific, Accounting, Currency, Date, Time, Percentage). The Preview box shows how the cell will look like after formatting. Click the Clear button to delete all the formatting. Click OK to confirm. The example below illustrates the preset formatting criteria, such as Contains. This formats cells containing Denmark with a pink background to highlight sales for a specific region. Date Formatting Rule The Date formatting rule is used to find and highlight cells containing a certain date and meeting one of the available formatting conditions: Yesterday Today Tomorrow In the last 7 days Last week This week Next week Last month This month Next month The Rule section shows the selected rule and the selected formatting condition, by clicking the down arrow you can access the list of the available rules and conditions. The Format section offers a range of cell formatting options. You can choose one of the available format Presets or customize the formatting using font format options (Bold, Italic, Underline, Strikeout), Text color, Fill color and Borders. Use the General drop-down list to choose the appropriate number format (General, Number, Scientific, Accounting, Currency, Date, Time, Percentage). The Preview box shows how the cell will look like after formatting. Click the Clear button to delete all the formatting. Click OK to confirm. The example below illustrates the preset formatting criteria, such as Last month. This formats cells containing dates from the previous month with a yellow background to highlight sales for a specific period of time. Blank/Error Formatting Rule The Blank/Error formatting rule is used to find and highlight cells containing or not containing blanks and errors: Contains blanks Does not contain blanks Contains errors Does not contain errors The Rule section shows the selected rule and the selected formatting condition, by clicking the down arrow you can access the list of the available rules and conditions. The Format section offers a range of cell formatting options. You can choose one of the available format Presets or customize the formatting using font format options (Bold, Italic, Underline, Strikeout), Text color, Fill color and Borders. Use the General drop-down list to choose the appropriate number format (General, Number, Scientific, Accounting, Currency, Date, Time, Percentage). The Preview box shows how the cell will look like after formatting. Click the Clear button to delete all the formatting. Click OK to confirm. The example below illustrates the preset formatting criteria, such as Contains blanks. This formats blank cells in the column showing the number of sales with a light blue background. Duplicate/Unique Formatting Rule The Duplicate/Unique formatting rule is used to display duplicate values within the spreadsheet and the cell range defined by the conditional formatting, the available options are: Duplicate Unique The Rule section shows the selected rule and the selected formatting condition, by clicking the down arrow you can access the list of the available rules and conditions. The Format section offers a range of cell formatting options. You can choose one of the available format Presets or customize the formatting using font format options (Bold, Italic, Underline, Strikeout), Text color, Fill color and Borders. Use the General drop-down list to choose the appropriate number format (General, Number, Scientific, Accounting, Currency, Date, Time, Percentage). The Preview box shows how the cell will look like after formatting. Click the Clear button to delete all the formatting. Click OK to confirm. The example below illustrates the preset formatting criteria, such as Duplicate. This formats duplicate contacts with a yellow background. Data Bars Formatting The Data Bars are used to compare values in the form of a diagram bar. For example, compare mountain heights by displaying their default value in meters (green bar) and the same value in 0 to 100 percent range (yellow bar); percentile when extreme values slant the data (light blue bar); bars only instead of numbers (blue bar); two-column data analysis to see both numbers and bars (red bar). Color Scales Formatting The Color Scales are used to highlight values within the spreadsheet through a gradient scale. The example below illustrates the columns from “Dairy” through “Beverage” that display data via a two-color scale with variation from yellow to red; the “Total Sales” column displays data via a three-color scale from the smallest amount in red to the largest amount in blue. Icon Sets Formatting The Icon Sets are used to show the data by displaying a corresponding icon in the cell that meets the criteria. The Spreadsheet Editor supports various icon sets: Directional Shapes Indicators Ratings Below you will find examples for the most common icon set conditional formatting cases. Instead of numbers and percent values, you see formatted cells with corresponding arrows showing you revenue achievement in the “Status” column and the dynamics for trends in the future in the “Trend” column. Instead of cells with rating numbers ranging from 1 to 5, the conditional formatting tool displays corresponding icons from the legend map at the top for each bike in the rating list. Instead of manually comparing monthly profit dynamics data, the formatted cells have a corresponding red or green arrow. Use the traffic lights system (red, yellow, and green circles) to visualize sales dynamics. Formatting Using Formulas The Formula-based formatting uses various formulas to filter data as per specific needs. The Rule section shows the selected rule and the selected formatting condition, by clicking the down arrow you can access the list of the available rules and conditions. Use the Select Data box to define the cell value to compare with. Use the reference to a single cell, or the reference with the worksheet function such as =SUM(A1:B5). The Format section offers a range of cell formatting options. You can choose one of the available format Presets or customize the formatting using font format options (Bold, Italic, Underline, Strikeout), Text color, Fill color and Borders. Use the General drop-down list to choose the appropriate number format (General, Number, Scientific, Accounting, Currency, Date, Time, Percentage). The Preview box shows how the cell will look like after formatting. Click the Clear button to delete all the formatting. Click OK to confirm. The examples below illustrate the formula formatting possibilities. Shade alternate rows, Compare with a reference value (here it is $55), and show if it is higher (green) or lower (red), Highlight the rows that meet the needed criteria (see what goals you shall achieve this month, in this case, it is October), Or, highlight unique rows only Create New Rule When you need to create a new rule for conditional formatting, you can do that in one of the following ways: Go to the Home tab, click the Conditional Formatting button , and choose New Rule from the drop-down menu. Click the Cell Settings tab on the right sidebar and click the Conditional formatting control down arrow, and choose New Rule from the drop-down menu. Right-click any cell and choose Conditional Formatting from the contextual menu. The New Formatting Rule window will open right away. Set the necessary options to configure the rule as described above, and click OK to confirm. Manage Conditional Formatting Rules Once you have set up the rules for conditional formatting, you can easily edit, delete and view them using the Manage Rule option by clicking the Conditional Formatting button on the Home tab, or the Conditional formatting control on the right sidebar Cell Settings tab. The Conditional Formatting window appears: Show formatting rules for allows choosing the rules you wish to display: Current selection This worksheet This table This pivot All rules found in the selected range will be shown in order of precedence (top to bottom) under Rules. The Apply to shows the range the rule is applied to, you can change the range by clicking the Select data icon . The Format shows the formatting rule applied. Use the New button to add a new rule. Use the Edit button, if you want to edit the existing rule, the Edit Formatting Rule window will open. Edit the rule as you deem it appropriate, and click OK. Use up and down arrows to change the place in the order of precedence. Click Delete to remove the rule. Click OK to confirm. Edit Conditional Formatting Editing Value is, Top/Bottom, Average, Text, Date, Blank/Error, Duplicate/Unique, Formula The Edit Formatting Rule window for Value is, Top/Bottom, Average, Text, Date, Blank/Error, Duplicate/Unique, Formula offers a range of regular settings: Click Rule to change the rule and the formatting condition applied previously; Use the Select data box to change the cell range to refer to (for Value is, Text and Formula) Use the Font and cell format options (Bold, Italic, Underline, Strikeout), Text color, Fill color and Borders. Click the General drop-down list to choose the appropriate number format (General, Number, Scientific, Accounting, Currency, Date, Time, Percentage). The Preview box shows how the cell will look like after formatting. Click OK to confirm. Editing Data Bars The Edit Formatting Rule window for Data Bar offers the following options: Rule to change the rule and the formatting condition applied previously; Minimum/Maximum to define the type of the minimum and the maximum values for data bars if you want to focus on differences. The maximum/minimum value types: Minimum/Maximum Number Percent Formula Percentile Automatic Choose Automatic to set the minimum value to zero, and the maximum value to the largest number in the range. Automatic is the default option. Click Select data box to change the cell range for the minimum/maximum values. Bar Appearance Customize the Data Bar appearance by choosing the type and the color of the fill and the border, and bar direction. There are two Fill type options: Solid fill and Gradient fill. Use the down arrow below to select the fill color for the bars representing Positive and Negative values. There are two Border type options: Solid and None. Use the down arrow below to select the border color for the bars representing Positive and Negative values. Enable Same as positive check box to display positive and negative using the same color. Color settings for Negative values will be disabled when this box is checked. Use Bar Direction to change the direction of data bars. Context is the option by default but you can choose Left to right or Right to left depending on your data representation preferences. Enable Show bar only check box to display only data bars in cells and hide values. Axis Select the data bar axis Position in relation to the cell midpoint to separate positive and negative values. There are three axis position options: Automatic, Cell midpoint and None. Click the color box down arrow to set the axis color. The Preview box shows how the cell will look like after formatting. Click OK to confirm. Editing Color Scales Editing 2 Color Scale Formatting The Edit Formatting Rule window for 2 Color Scale offers the following formatting options: Click Rule to change the rule and the formatting condition applied previously; Click Minpoint/Maxpoint to define the type of values for the color scale minimum and maximum points if you want to focus on differences. The minpoint/maxpoint value types: Minimum/Maximum Number Percent Formula Percentile Minimum/Maximum is the default option. Use Select data box to change the cell range for the minimum and maximum points. Use the down arrow below to select the color for each scale. The Preview box shows how the cell will look like after formatting. Click OK to confirm. Editing 3 Color Scale Formatting The Edit Formatting Rule window for 3 Color Scale offers the following formatting options: Click Rule to change the rule and the formatting condition applied previously; Click Minpoint/Midpoint/Maxpoint to define the type of values for the color scale minimum, middle and maximum points if you want to focus on differences. The minpoint/maxpoint value types: Minimum/Maximum Number Percent Formula Percentile The midpoint value types: Number Percent Formula Percentile Minimum/Percentile/Maximum is the default option for 3 Color Scale formatting. Use the Select data box to change the cell range for the minimum, the middle and the maximum points. Use the down arrow below to select the color for each scale. The Preview box shows how the cell will look like after formatting. Click OK to confirm. Editing Icon sets The Edit Formatting Rule window for Icon Sets offers the following formatting options: Click Rule to change the rule and the formatting condition applied previously; Click Icon Style to customize the style of the icons for the created rule. Enable the Show icon only to display only icons in cells and hide values. Enable Reverse Icons Order to change the order of icons and arrange them from the lowest to the highest value. By default the icons are arranged from the highest to the lowest value. Set the rule for each icon and adjust comparison operators (greater than or equal to, greater than), threshold values and value type (Number, Percent, Formula, Percentile) to arrange values in sequence from top to bottom. By default, values are divided equally. Click OK to confirm. Clear Conditional Formatting To clear all conditional formatting go to the Home tab, click the Conditional Formatting button , or click the Conditional Formatting control of the Cell Settings tab on the right sidebar, then click Clear Rules on the drop-down menu, and choose one of the appropriate actions: Current selection This worksheet This table This pivot Please note that this guide contains graphic information from the Microsoft Office Conditional Formatting Samples and guidelines workbook. Try the aforementioned rules display by downloading the workbook and opening it in the Spreadsheet Editor."
    },
   {
        "id": "UsageInstructions/CopyPasteData.htm", 
        "title": "Cut/copy/paste data", 
        "body": "Use basic clipboard operations To cut, copy and paste data in the current spreadsheet make use of the right-click menu or use the corresponding icons of the Spreadsheet Editor available on any tab of the top toolbar, Cut - select data and use the Cut option from the right-click menu, or the Cut icon on the top toolbar to delete the selected data and send them to the computer clipboard memory. The cut data can be later inserted to another place in the same spreadsheet. Copy - select data and either use the Copy icon at the top toolbar or right-click and select the Copy option from the menu to send the selected data to the computer clipboard memory. The copied data can be later inserted to another place in the same spreadsheet. Paste - select a place and either use the Paste icon on the top toolbar or right-click and select the Paste option to insert the previously copied/cut data from the computer clipboard memory to the current cursor position. The data can be previously copied from the same spreadsheet. In the online version, the following key combinations are only used to copy or paste data from/into another spreadsheet or some other program, in the desktop version, both the corresponding buttons/menu options and key combinations can be used for any copy/paste operations: Ctrl+X key combination for cutting (Cmd+X for macOS); Ctrl+C key combination for copying (Cmd+C for macOS); Ctrl+V key combination for pasting (Cmd+V for macOS). Note: instead of cutting and pasting data within the same worksheet you can select the required cell/cell range, hover the mouse cursor over the selection border so that it turns into the Arrow icon and drag and drop the selection to the necessary position. To enable / disable the automatic appearance of the Paste Special button after pasting, go to the File tab > Advanced Settings and check / uncheck the Show the Paste Options button when the content is pasted checkbox. Use the Paste Special feature Note: For collaborative editing, the Paste Special feature is available in the Strict co-editing mode only. Once the copied data is pasted, the Paste Special button appears next to the lower right corner of the inserted cell/cell range. Click this button to select the necessary paste option or use the Ctrl key to open the Paste Special menu, then press the letter key given in the brackets next to the required option. When pasting a cell/cell range with formatted data, the following options are available: Paste (Ctrl then P) - allows you to paste all the cell contents including data formatting. This option is selected by default. The following options can be used if the copied data contains formulas: Paste only formula (Ctrl then F) - allows you to paste formulas without pasting the data formatting. Formula + number format (Ctrl then O) - allows you to paste formulas with the formatting applied to numbers. Formula + all formatting (Ctrl then K) - allows you to paste formulas with all the data formatting. Formula without borders (Ctrl then B) - allows you to paste formulas with all the data formatting except the cell borders. Formula + column width (Ctrl then W) - allows you to paste formulas with all the data formatting and set the source column`s width for the cell range. Transpose (Ctrl then T) - allows you to paste data switching them from columns to rows, or vice versa. This option is available for regular data ranges, but not for formatted tables. The following options allow you to paste the result that the copied formula returns without pasting the formula itself: Paste only value (Ctrl then +V) - allows you to paste the formula results without pasting the data formatting. Value + number format (Ctrl then A) - allows to paste the formula results with the formatting applied to numbers. Value + all formatting (Ctrl then E) - allows you to paste the formula results with all the data formatting. Paste only formatting (Ctrl then R) - allows you to paste the cell formatting only without pasting the cell contents. Paste link (Ctrl then N) - allows you to paste the external link to a cell or range of cells in another spreadsheet within the current portal (in the online editor) or in a local file (in the desktop editor). Paste Formulas - allows you to paste formulas without pasting the data formatting. Values - allows you to paste the formula results without pasting the data formatting. Formats - allows you to apply the formatting of the copied area. Comments - allows you to add comments of the copied area. Column widths - allows you to set certal column widths of the copied area. All except borders - allows you to paste formulas, formula results with all its formatting except borders. Formulas &#38; formatting - allows you to paste formulas and apply formatting on them from the copied area. Formulas &#38; column widths - allows you to paste formulas and set certaln column widths of the copied area. Formulas &#38; number formulas - allows you to paste formulas and number formulas. Values &#38; number formats - allows you to paste formula results and apply the numbers formatting of the copied area. Values &#38; formatting - allows you to paste formula results and apply the formatting of the copied area. Operation Add - allows you to automatically add numeric values in each inserted cell. Subtract - allows you to automatically subtract numeric values in each inserted cell. Multiply - allows you to automatically multiply numeric values in each inserted cell. Divide - allows you to automatically divide numeric values in each inserted cell. Transpose - allows you to paste data switching them from columns to rows, or vice versa. Skip blanks - allows you to skip pasting empty cells and their formatting. When pasting the contents of a single cell or some text within autoshapes, the following options are available: Source formatting (Ctrl+K) - allows you to keep the source formatting of the copied data. Destination formatting (Ctrl+M) - allows you to apply the formatting that is already used for the cell/autoshape where the data are to be inserted to. Paste delimited text When pasting the delimited text copied from a .txt file, the following options are available: The delimited text can contain several records, and each record corresponds to a single table row. Each record can contain several text values separated with a delimiter (such as a comma, semicolon, colon, tab, space or other characters). The file should be saved as a plain text .txt file. Keep text only (Ctrl+T) - allows you to paste text values into a single column where each cell contents corresponds to a row in the source text file. Use text import wizard - allows you to open the Text Import Wizard which helps to easily split the text values into multiple columns where each text value separated by a delimiter will be placed into a separate cell. When the Text Import Wizard window opens, select the text delimiter used in the delimited data from the Delimiter drop-down list. The data split into columns will be displayed in the Preview field below. If you are satisfied with the result, click the OK button. If you pasted delimited data from a source that is not a plain text file (e.g. text copied from a web page etc.), or if you applied the Keep text only feature and now want to split the data from a single column into several columns, you can use the Text to Columns option. To split data into multiple columns: Select the necessary cell or column that contains data with delimiters. Switch to the Data tab. Click the Text to columns button on the top toolbar. The Text to Columns Wizard opens. In the Delimiter drop-down list, select the delimiter used in the delimited data. Click the Advanced button to open the Advanced Settings window in which you can specify the Decimal and Thousands separators. Preview the result in the field below and click OK. After that, each text value separated by the delimiter will be located in a separate cell. If there is some data in the cells to the right of the column you want to split, the data will be overwritten. Use the Auto Fill option To quickly fill multiple cells with the same data use the Auto Fill option: select a cell/cell range containing the required data, move the mouse cursor over the fill handle in the right lower corner of the cell. The cursor will turn into the black cross: drag the handle over the adjacent cells to fill them with the selected data. Note: if you need to create a series of numbers (such as 1, 2, 3, 4...; 2, 4, 6, 8... etc.) or dates, you can enter at least two starting values and quickly extend the series selecting these cells and dragging the fill handle. For a series of days of the week or months, enter the initial value and drag the fill handle. To further customize the cell autofilling, drag the range with the right mouse button to open the Auto Fill context menu: Copy cells - the cell range content will be copied into your clipboard. Fill series - autofill based on the established pattern in the selected cell range. Fill days - only days will follow the established pattern, e.g., 01/01/2025, 02/01/2025 ... (DD-MM-YYYY). Fill weekdays - only weekdays will follow the established pattern, the weekends will be omitted. Fill months - only months will follow the established pattern, e.g., 01/01/2025, 01/02/2025 ... (DD-MM-YYYY). Fill years - only years will follow the established pattern, e.g., 01/01/2025, 01/01/2026 ... (DD-MM-YYYY). Linear trend - the autofill will follow the linear trend (1, 2, 3 ...). Growth trend - the autofill will follow the exponential growth trend (1, 2, 4, 8, 16 ...). Series - opens the Series menu, where you can further customize the settings. Fill cells in the column with text values If a column in your spreadsheet contains some text values, you can easily replace any value within this column or fill the next blank cell selecting one of already existing text values. Right-click the necessary cell and choose the Select from drop-down list option in the contextual menu. Select one of the available text values to replace the current one or fill an empty cell. Fill cells using the Series tool Select a cell/cell range containing the initial data and some empty cells in the necessary direction. Click the Fill icon on the Home tab of the top toolbar and choose the Series option. You can also use the Down, Right, Up, Left options to fill the selected empty cells. There is another way to access the Series window. You can select the initial data, move the mouse cursor over the fill handle in the right lower corner of the cell, click and hold the right mouse button on the fill handle, then drag down, up, right, or left and release the right mouse button - the context menu appears with the Series option. In the Series dialog window, select the necessary options and click OK: Series in: Rows, Columns - select the direction to fill cells. Type: Linear is used to add the step value to the starting value and then to each subsequent value, Growth is used to multiply the starting value by the step value, Date is used to fill cells with a series of dates, AutoFill is used to fill cells with data based on other cells. Date unit: Day, Weekday, Month, Year - select the date unit you want to increase the series by. Trend - check this box if there is more than one starting value in the series. Step value - select the numerical value you want to increase the series by. By default, it is set to 1. Stop value - specify the last value in the series."
    },
   {
        "id": "UsageInstructions/DataValidation.htm", 
        "title": "Data validation", 
        "body": "ONLYOFFICE Spreadsheet Editor offers a data validation feature that controls the parameters of the information entered in cells by users. To access the data validation feature, choose a cell, a range of cells, or a whole spreadsheet you want to apply the feature to, open the Data tab, and click the Data Validation icon on the top toolbar. The opened Data Validation window contains three tabs: Settings, Input Message, and Error Alert. Settings The Settings section allows you to specify the type of data that can be entered: Note: Check the Apply these changes to all other cells with the same settings box to use the same settings to the selected range of cells or a whole worksheet. choose the required option in the Allow menu: Any value: no limitations on information type. Whole number: only whole numbers are allowed. Decimal: only numbers with a decimal point are allowed. List: only options from the drop-down list you created are allowed. Uncheck the Show drop-down list in cell box to hide the drop-down arrow. Date: only cells with the date format are allowed. Time: only cells with the time format are allowed. Text length: sets the characters limit. Other: sets the necessary validation parameter given as a formula. Note: Check the Apply these changes to all other cells with the same settings box to use the same settings to the selected range of cells or a whole worksheet. specify a validation condition in the Data menu: between: the data in cells should be within the range set by the validation rule. not between: the data in cells should not be within the range set by the validation rule. equals: the data in cells should be equal to the value set by the validation rule. does not equal: the data in cells should not be equal to the value set by the validation rule. greater than: the data in cells should exceed the values set by the validation rule. less than: the data in cells should be less than the values set by the validation rule. greater than or equal to: the data in cells should exceed or be equal to the value set by the validation rule. less than or equal to: the data in cells should be less than or equal to the value set by the validation rule. create a validation rule depending on the allowed information type: Validation condition Validation rule Description Availability Between / not between Minimum / Maximum Sets the value range Whole number / Decimal / Text length Start date / End date Sets the date range Date Start time / End time Sets the time period Time Equals / does not equal Compare to Sets the value for comparison Whole number / Decimal Date Sets the date for comparison Date Elapsed time Sets the time for comparison Time Length Sets the text length value for comparison Text length Greater than / greater than or equal to Minimum Sets the lower limit Whole number / Decimal / Text length Start date Sets the starting date Date Start time Sets the starting time Time Less than / less than or equal to Maximum Sets the higher limit Whole number / Decimal / Text length End date Sets the ending date Date End time Sets the ending time Time As well as: Source: provide the source of information for the List information type. Formula: enter the required formula to create a custom validation rule for the Other information type. Input Message The Input Message section allows you to create a customized message displayed when a user hovers their mouse pointer over the cell. Specify the Title and the body of your Input Message. Uncheck the Show input message when cell is selected to disable the display of the message. Leave it to display the message. Error Alert The Error Alert section allows you to specify the message displayed when the data given by users does not meet the validation rules. Style: choose one of the available presets, Stop, Alert, or Message. Title: specify the title of the alert message. Error Message: enter the text of the alert message. Uncheck the Show error alert after invalid data is entered box to disable the display of the alert message."
    },
   {
        "id": "UsageInstructions/DrawingOperations.htm", 
        "title": "Draw freehand on a spreadsheet", 
        "body": "In the Spreadsheet Editor, you can use the Draw tab to draw freehand, add handwritten notes, highlight text and erase on your spreadsheet. To draw, write, or highlight text, click the Pen or the Highlighter icon, and move your cursor. Click the drop-down arrow to customize the stroke color and thickness. Click More colors if the needed color is not in the palette. When you are done with drawing, writing or highlighting, click the Pen or the Highlighter icon again, or press the Esc button. Click the Eraser tool and move your cursor back and forth to delete a stroke. The Eraser deletes only the whole stroke. Use the Select button to select the inscription, the drawing or the highlighting. Once selected, you can resize or delete the selected element."
    },
   {
        "id": "UsageInstructions/FontTypeSizeStyle.htm", 
        "title": "Set font type, size, style, and colors", 
        "body": "In the Spreadsheet Editor, you can select the font type and its size, apply one of the decoration styles and change the font and background colors by clicking the corresponding icons on the Home tab of the top toolbar. Note: if you want to apply formatting to the data in the spreadsheet, select them with the mouse or use the keyboard and apply the required formatting. If you need to apply the formatting to multiple non-adjacent cells or cell ranges, hold down the Ctrl key while selecting cells/ranges with the mouse. Font Used to select one of the fonts from the list of the available fonts. If the required font is not available in the list, you can download and install it on your operating system, and the font will be available for use in the desktop version. Font size Used to select the preset font size values from the dropdown list (the default values are: 8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72 and 96). It's also possible to manually enter a custom value up to 409 pt in the font size field. Press Enter to confirm. Increment font size Used to change the font size making it one point bigger each time the icon is clicked. Decrement font size Used to change the font size making it one point smaller each time the icon is clicked. Change case Used to change the font case. Sentence case. - the case matches that of a common sentence. lowercase - all letters are small. UPPERCASE - all letters are capital. Capitalize Each Word - each word starts with a capital letter. tOGGLE cASE - reverse the case of the selected text or the word where the mouse cursor is positioned. Bold Used to make the font bold making it heavier. Italic Used to make the font slightly slanted to the right. Underline Used to make the text underlined with a line going below the letters. Strikethrough Used to make the text struck out with a line going through the letters. Subscript/Superscript Allows choosing the Superscript or Subscript option. The Superscript option is used to make the text smaller and place it to the upper part of the text line, e.g. as in fractions. The Subscript option is used to make the text smaller and place it to the lower part of the text line, e.g. as in chemical formulas. Font color Used to change the color of the letters/characters in cells. Fill color Used to change the color of the cell fill. Using this icon you can apply a solid color fill. The color of the cell fill can also be changed using the Fill section on the Cell settings tab of the right sidebar. Change color scheme This button is located on the Layout tab. Used to change the default color palette for worksheet elements (font, background, chats and chart elements) selecting from the available options: Aspect, Blue Green, Blue II, Blue Warm, Blue, Grayscale, Green Yellow, Green, Marquee, Median, Office 2007-2010, Office 2013-2022, Office, Orange Red, Orange, Paper, Red Orange, Red Violet, Red, Slipstream, Violet II, Violet, Yellow Orange, Yellow, and New Office. Note: it's also possible to apply one of the formatting presets selecting the cell you wish to format and choosing the desired preset from the list on the Home tab of the top toolbar: To change the font color or use a solid color fill as the cell background, select characters/cells with the mouse or the whole worksheet using the Ctrl+A key combination, click the corresponding icon on the top toolbar, select any color in the available palettes Theme Colors - the colors that correspond to the selected color scheme of the spreadsheet. Standard Colors - the default colors set. You can also apply a custom color using two different options: Eyedropper - use this option to choose the required color by clicking it in the spreadsheet. More colors - click this caption if the required color is missing among the available palettes. Select the necessary color range moving the vertical color slider and set a specific color dragging the color picker within the large square color field. Once you select a color with the color picker, the appropriate RGB and sRGB color values will be displayed in the fields on the right. You can also define a color on the base of the RGB color model by entering the corresponding numeric values into the R, G, B (red, green, blue) fields or enter the sRGB hexadecimal code into the field marked with the # sign. The selected color appears in the New preview box. If the object was previously filled with any custom color, this color is displayed in the Current box so you can compare the original and modified colors. When the color is defined, click the Add button: The custom color will be applied to the text/cell and added to the Recent colors palette. To remove the background color from a certain cell, select a cell, or a cell range with the mouse or the whole worksheet using the Ctrl+A key combination, click the Fill color icon on the Home tab of the top toolbar, select the icon."
    },
   {
        "id": "UsageInstructions/FormattedTables.htm", 
        "title": "Use formatted tables", 
        "body": "Create a new formatted table To make it easier for you to work with data, the Spreadsheet Editor allows you to apply a table template to the selected cell range and automatically enable the filter. To do that, select a range of cells you need to format, click the Format as table template icon situated on the Home tab of the top toolbar, select the required template in the gallery, in the opened pop-up window, check the cell range to be formatted as a table, check the Title if you wish the table headers to be included in the selected cell range, otherwise, the header row will be added at the top while the selected cell range will be moved one row down, click the OK button to apply the selected template. The template will be applied to the selected range of cells, and you will be able to edit the table headers and apply the filter to work with your data. It's also possible to insert a formatted table using the Table button on the Insert tab. In this case, the default table template is applied. Note: once you create a new formatted table, the default name (Table1, Table2, etc.) will be automatically assigned to the table. You can change this name making it more meaningful and use it for further work. If you enter a new value in the cell below the last row of the table (if the table does not have the Total row) or in the cell to the right of the last column of the table, the formatted table will be automatically extended to include a new row or column. If you do not want to expand the table, click the Paste special button that will appear and select the Undo table autoexpansion option. Once you undo this action, the Redo table autoexpansion option will be available in this menu. Note: To enable/disable table auto-expansion, select the Stop automatically expanding tables option in the Paste special button menu or go to Advanced Settings -> Spell Checking -> Proofing -> AutoCorrect Options -> AutoFormat As You Type. Select rows and columns To select an entire row in the formatted table, move the mouse cursor over the left border of the table row until it turns into the black arrow , then left-click. To select an entire column in the formatted table, move the mouse cursor over the top edge of the column header until it turns into the black arrow , then left-click. If you click once, the column data will be selected (as it is shown on the image below); if you click twice, the entire column including the header will be selected. To select an entire formatted table, move the mouse cursor over the upper left corner of the formatted table until it turns into the diagonal black arrow , then left-click. Edit formatted tables Some of the table settings can be changed using the Table settings tab of the right sidebar that will open if you select at least one cell within the table with the mouse and click the Table settings icon on the right. The Rows and Columns sections on the top allow you to emphasize certain rows/columns applying specific formatting to them, or highlight different rows/columns with different background colors to clearly distinguish them. The following options are available: Header - allows you to display the header row. Total - adds the Summary row at the bottom of the table. Note: if this option is selected, you can also select a function to calculate the summary values. Once you select a cell in the Summary row, the button will be available to the right of the cell. Click it and choose the necessary function from the list: Average, Count, Max, Min, Sum, StdDev, or Var. The More functions option allows you to open the Insert Function window and choose any other function. If you choose the None option, the currently selected cell in the Summary row will not display a summary value for this column. Banded - enables the background color alternation for odd and even rows. Filter button - allows you to display the drop-down arrows in each cell of the header row. This option is only available when the Header option is selected. First - emphasizes the leftmost column in the table with special formatting. Last - emphasizes the rightmost column in the table with special formatting. Banded - enables the background color alternation for odd and even columns. The Select From Template section allows you to choose one of the predefined tables styles. Each template combines certain formatting parameters, such as a background color, border style, row/column banding, etc. Depending on the options checked in the Rows and/or Columns sections above, the templates set will be displayed differently. For example, if you've checked the Header option in the Rows section and the Banded option in the Columns section, the displayed templates list will include only templates with the header row and banded columns enabled: If you want to remove the current table style (background color, borders, etc.) without removing the table itself, apply the None template from the template list: The Resize table section allows you to change the cell range the table formatting is applied to. Click the Select Data button - a new pop-up window will open. Change the link to the cell range in the entry field or select the necessary cell range in the worksheet with the mouse and click the OK button. Note: The headers must remain in the same row, and the resulting table range must overlap the original table range. The Rows & Columns section allows you to perform the following operations: Select a row, column, all columns data excluding the header row, or the entire table including the header row. Insert a new row above or below the selected one as well as a new column to the left or the right of the selected one. Delete a row, column (depending on the cursor position or the selection), or the entire table. Note: the options of the Rows & Columns section are also accessible from the right-click menu. The Remove duplicates option can be used if you want to remove duplicate values from the formatted table. For more details on removing duplicates, please refer to this page. The Convert to range option can be used if you want to transform the table into a regular data range removing the filter but preserving the table style (i.e. cell and font colors, etc.). Once you apply this option, the Table settings tab on the right sidebar will be unavailable. The Insert slicer option is used to create a slicer for the formatted table. For more details on working with slicers, please refer to this page. The Insert pivot table option is used to create a pivot table on the base of the formatted table. For more details on working with pivot tables, please refer to this page. Adjust formatted table advanced settings To change the advanced table properties, use the Show advanced settings link on the right sidebar. The 'Table - Advanced Settings' window will open: The Alternative Text tab allows you to specify the Title and the Description which will be read to people with vision or cognitive impairments to help them better understand what information the table contains. Note: To enable/disable table auto-expansion, go to Advanced Settings -> Spell Checking -> Proofing -> AutoCorrect Options -> AutoFormat As You Type. Use Formula Autocomplete to Add Formulas to Formatted Tables The Formula Autocomplete list displays all the available options when you apply formulas to formatted tables. You can add a reference to a table in your formula inside or outside a table. Columns and item names are used instead of cell addresses as references. The example below shows a reference to a table in the SUM function. Select a cell and start typing a formula beginning with an equal sign, select the necessary function from the Formula Autocomplete list. After the opening parenthesis, start typing the table name, and select the appropriate name from the Formula Autocomplete list. Then type an opening bracket [ to open the drop-down list that contains columns and items that can be used in the formula. A tooltip describing the reference appears when you hover the mouse pointer over it in the list. Note: Each reference must contain an opening and a closing bracket. Don’t forget to check formula syntax."
    },
   {
        "id": "UsageInstructions/GoalSeek.htm", 
        "title": "Goal Seek", 
        "body": "ONLYOFFICE Spreadsheet Editor offers a Goal Seek feature that allows you to determine which numbers should be substituted into the formula to obtain the desired and previously known result. Open the Data tab and click the Goal Seek icon on the top toolbar. In the opened Goal Seek window, select the necessary options: Set cell - enter the reference to the cell that contains a formula. You can use the icon to select the cell. To value - enter the result you want to get in the cell containing the formula. By changing cell - enter the reference to the cell that that contains the value you want to change. You can use the icon to select the cell. This cell must be referenced by the formula located in the cell which you specified in the Set cell field. Click OK. The  Goal Seek Status window will display the result. Click OK to replace the values in the the cells specified in the Set cell and By changing cell fields."
    },
   {
        "id": "UsageInstructions/GroupData.htm", 
        "title": "Group data", 
        "body": "The ability to group rows and columns as well as create an outline allows you to make it easier to work with a spreadsheet that contains a large amount of data. In the Spreadsheet Editor, you can collapse or expand grouped rows and columns to display the necessary data only. It's also possible to create the multi-level structure of grouped rows/columns. When necessary, you can ungroup the previously grouped rows or columns. Group rows and columns To group rows or columns: Select the cell range that you need to group. Switch to the Data tab and use one of the necessary options on the top toolbar: click the Group button, then choose the Rows or Columns option in the Group window that appears and click OK, click the downwards arrow below the Group button and choose the Group rows option from the menu, click the downwards arrow below the Group button and choose the Group columns option from the menu. The selected rows or columns will be grouped and the created outline will be displayed to the left of the rows or/and above the columns. To hide grouped rows/columns, click the Collapse icon. To show collapsed rows/columns, click the Expand icon. Change the outline To change the outline of grouped rows or columns, you can use options from the Group drop-down menu. The Summary rows below detail and Summary columns to the right of detail options are checked by default. They allow to change the location of the Collapse and Expand buttons: Uncheck the Summary rows below detail option if you want to display the summary rows above the details. Uncheck the Summary columns to right of detail option if you want to display the summary columns to the left of details. Create multi-level groups To create a multi-level structure, select a cell range within the previously created group of rows/columns, and group the newly selected range as described above. After that, you can hide and show groups by level using the icons with the level number: . For example, if you create a nested group within the parent group, three levels will be available. It's possible to create up to 8 levels. Click the first level icon to switch to the level which hides all grouped data: Click the second level icon to switch to the level which displays details of the parent group, but hides the nested group data: Click the third level icon to switch to the level which displays all details: It's also possible to use the Collapse and Expand icons within the outline to display or hide the data corresponding to a certain level. Ungroup previously grouped rows and columns To ungroup previously grouped rows or columns: Select the range of grouped cells that you need to ungroup. Switch to the Data tab and use one of the necessary options at the top toolbar: click the Ungroup button, then choose the Rows or Columns option in the Group window that appears and click OK, click the downwards arrow below the Ungroup button, then choose the Ungroup rows option from the menu to ungroup rows and clear the outline of rows, click the downwards arrow below the Ungroup button and choose the Ungroup columns option from the menu to ungroup columns and clear the outline of columns, click the downwards arrow below the Ungroup button and choose the Clear outline option from the menu to clear the outline of rows and columns without removing existing groups."
    },
   {
        "id": "UsageInstructions/HighlightedCode.htm", 
        "title": "Insert highlighted code", 
        "body": "In the Spreadsheet Editor, you can embed highlighted code with the already adjusted style in accordance with the programming language and coloring style of the program you have chosen. Starting with ONLYOFFICE Docs 8.2, no plugins come with the editors by default. The plugins shall be installed via Plugin Manager. Go to your spreadsheet and place the cursor at the location where you want to include the code. Switch to the Plugins tab and choose Highlight code. Specify the programming Language. Select a Style of the code so that it appears as if it were open in this program. Specify if you want to replace tabs with spaces. Choose Background color. To do this, manually move the cursor over the palette or insert the RGB/HSL/HEX value. Click OK to insert the code."
    },
   {
        "id": "UsageInstructions/InsertArrayFormulas.htm", 
        "title": "Insert array formulas", 
        "body": "The Spreadsheet Editor allows you to use array formulas. Array formulas ensure consistency among formulas in a spreadsheet, as you can enter a single array formula instead of several usual formulas, they simplify working with large amount of data, allow you to quickly fill a sheet with data, and much more. You can enter formulas and built-in functions as array formulas in order to: perform multiple calculations at once and display a single result, or return a range of values displayed in multiple rows or/and columns. There are also specially designated functions which can return multiple values. If you enter them by pressing Enter, they return a single value. If you select an output range of cells to display the results and then enter a function by pressing Ctrl + Shift + Enter, it returns a range of values (the number of returned values depends on the size of the previously selected output range). The list below contains links to detailed descriptions of these functions. Array functions CELL CHOOSEROWS CHOOSECOLS COLUMN DROP EXPAND FILTER FORMULATEXT FREQUENCY GROWTH HSTACK HYPERLINLK INDIRECT INDEX ISFORMULA LINEST LOGEST MINVERSE MMULT MUNIT OFFSET RANDARRAY ROW SEQUENCE SORT SORTBY TAKE TEXTSPLIT TOCOL TOROW TRANSPOSE TREND WRAPCOLS WRAPROWS UNIQUE VSTACK XMATCH XLOOKUP Insert array formulas To insert an array formula, Select a range of cells where you wish to display results. Enter the formula you want to use in the formula bar, specifying necessary arguments within parentheses (). Press the Ctrl + Shift + Enter key combination. The results will be displayed in the selected range of cells, and the formula in the formula bar will be automatically enclosed in the curly braces { } to indicate that it is an array formula. For example, {=UNIQUE(B2:D6)}. These braces cannot be entered manually. Create a single-cell array formula The following example illustrates the result of the array formula displayed in a single cell. Select a cell, enter =SUM(C2:C11*D2:D11), and press Ctrl + Shift + Enter. Create a multi-cell array formula The following example illustrates the results of the array formula displayed in a range of cells. Select a range of cells, enter =C2:C11*D2:D11, and press Ctrl + Shift + Enter. Edit array formulas Every time you edit an entered array formula (e.g., change arguments), you need to press the Ctrl + Shift + Enter key combination to save the changes. The following example explains how to expand a multi-cell array formula when you add new data. Select all the cells which contain an array formula, as well as empty cells next to new data, edit arguments in the formula bar so that they include new data, and press Ctrl + Shift + Enter. If you want to apply a multi-cell array formula to a smaller range of cells, you need to delete the current array formula and then enter a new array formula. A part of the array cannot be modified or deleted. If you try to edit, move, or delete a single cell within the array, or insert a new cell to the array, you get the following warning: You cannot change part of an array. To delete an array formula, select all the cells which contain the array formula and press Delete. Alternatively, select the array formula in the formula bar, press Delete and then press Ctrl + Shift + Enter. Examples of array formula usage This section provides some examples on how to use array formulas to perform certain tasks. Count a number of characters in a range of cells You can use the following array formula, replacing the cell range in the argument with your own one: =SUM(LEN(B2:B11)). The LEN function calculates the length of each text string in the range of cells. The SUM function adds the values together. To get the average number of characters, replace SUM with AVERAGE. Find the longest string in a range of cells You can use the following array formula, replacing cell ranges in arguments with your own ones: =INDEX(B2:B11,MATCH(MAX(LEN(B2:B11)),LEN(B2:B11),0),1). The LEN function calculates the length of each text string in the range of cells. The MAX function calculates the largest value. The MATCH function finds the address of the cell with the longest string. The INDEX function returns the value from the found cell. To find the shortest string, replace MAX with MIN. Sum values based on conditions To sum values greater than a specified number (2 in this example), you can use the following array formula, replacing cell ranges in arguments with your own ones: =SUM(IF(C2:C11>2,C2:C11)). The IF function creates an array of positive and false values. The SUM function ignores false values and adds the positive values together."
    },
   {
        "id": "UsageInstructions/InsertAutoshapes.htm", 
        "title": "Insert and format autoshapes", 
        "body": "Insert an autoshape To add an autoshape in the Spreadsheet Editor, switch to the Insert tab of the top toolbar, click the Shape icon on the top toolbar, select one of the available autoshape groups from the Shape Gallery: Recently Used, Basic Shapes, Figured Arrows, Math, Charts, Stars & Ribbons, Callouts, Buttons, Rectangles, Lines, click the necessary autoshape within the selected group, place the mouse cursor where the shape sholud be added, once the autoshape is added, you can change its size and position as well as its settings. You can save the autoshape as picture on your hard drive using the Save as picture option in the right-click menu. Copy autoshape style formatting To copy a certain autoshape style formatting, select the autoshape whose formatting you need to copy with the mouse or using the keyboard, click the Copy style icon on the Home tab of the top toolbar (the mouse pointer will look like this ), select the required autoshape to apply the same formatting. Adjust the autoshape settings To align and arrange autoshapes, use the right-click menu. The menu options are: Cut, Copy, Paste - standard options which are used to cut or copy the selected text/object and paste the previously cut/copied text passage or object to the current cursor position. Arrange is used to bring the selected autoshape to foreground, send it to background, move forward or backward as well as group or ungroup shapes to perform operations with several of them at once. To learn more on how to arrange objects, please refer to this page. Align is used to align the shape to the left, in the center, to the right, at the top, in the middle, at the bottom. To learn more on how to align objects, please refer to this page. Rotate is used to rotate the shape by 90 degrees clockwise or counterclockwise as well as to flip the shape horizontally or vertically. Assign Macro is used to provide a quick and easy access to a macro within a spreadsheet by assigning a macro to any shape. Once you assign a macro, the shape appears as a button control and you can run the macro whenever you click it. To learn more, please refer to the Assign a Macro to a Shape section of this guide. Save as picture is used to save the shape as a picture on your hard drive. Edit Points is used to customize or to change the curvature of your shape. To activate a shape’s editable anchor points, right-click the shape and choose Edit Points from the menu or click the Edit shape > Edit points option on the right panel. The black squares that become active are the points where two lines meet, and the red line outlines the shape. Click and drag it to reposition the point, and to change the shape outline. Once you click the anchor point, two blue lines with white squares at the ends will appear. These are Bezier handles that allow you to create a curve and to change a curve’s smoothness. As long as the anchor points are active, you can add and delete them. To add a point to a shape, hold Ctrl and click the position where you want to add an anchor point. To delete a point, hold Ctrl and click the unnecessary point. Shape Advanced Settings is used to open the 'Shape - Advanced Settings' window. Some of the autoshape settings can be changed using the Shape settings tab on the right sidebar that will open if you select the inserted autoshape with the mouse and click the Shape settings icon. The following settings can be changed: Fill - use this section to select the autoshape fill. You can choose the following options: Color fill - select this option to specify a solid color to fill the inner space of the selected autoshape. Click the colored box below and select the necessary color from the available color sets or specify any color you like: Theme colors - the colors that correspond to the selected color scheme of the spreadsheet. Standard colors - the default colors set. You can also apply a custom color using two different options: Eyedropper - use this option to choose the required color by clicking it in the document. More colors - click this caption if the required color is missing among the available palettes. Select the necessary color range moving the vertical color slider and set a specific color dragging the color picker within the large square color field. Once you select a color with the color picker, the appropriate RGB and sRGB color values will be displayed in the fields on the right. You can also define a color on the base of the RGB color model by entering the corresponding numeric values into the R, G, B (red, green, blue) fields or enter the sRGB hexadecimal code into the field marked with the # sign. The selected color appears in the New preview box. If the object was previously filled with any custom color, this color is displayed in the Current box so you can compare the original and modified colors. When the color is defined, click the Add button: The custom color will be applied to the selected element and added to the Recent colors palette. Gradient fill - use this option to fill the shape with two or more fading colors. Customize your gradient fill with no constraints. Click the Shape settings icon to open the Fill menu on the right sidebar: Available menu options: Style - choose between Linear or Radial: Linear is used  when you need your colors to flow from left-to-right, top-to-bottom, or at any angle you chose in a single direction. The Direction preview window displays the selected gradient color, click the arrow to choose a preset gradient direction. Use Angle settings for a precise gradient angle. Radial is used to move from the center as it starts at a single point and emanates outward. Gradient point is a specific point for transition from one color to another. Use the Add gradient point button or slider bar to add a gradient point. You can add up to 10 gradient points. Each next gradient point added will in no way affect the current gradient fill appearance. Use the Remove gradient point button to delete a certain gradient point. Use the slider bar to change the location of the gradient point or specify Position in percentage for precise location. To apply a color to a gradient point, click a point on the slider bar, and then click Color to choose the color you want. Picture or texture - select this option to use an image or a predefined texture as the shape background. If you wish to use an image as a background for the shape, open the Select picture dropdown menu; here, you can add an image From file by selecting it on your computer hard disk drive, From URL by inserting the appropriate URL address into the opened window, or From storage by selecting the required image stored on your portal. If you wish to use a texture as the shape background, open the From texture menu and select the necessary texture preset. Currently, the following textures are available: canvas, carton, dark fabric, grain, granite, grey paper, knit, leather, brown paper, papyrus, wood. In case the selected Picture has less or more dimensions than the autoshape has, you can choose the Stretch or Tile setting from the dropdown list. The Stretch option allows you to adjust the size of the image to fit the autoshape so that it could fill all the space completely. The Tile option allows you to display only a part of the bigger image keeping its original dimensions or repeat the smaller image keeping its original dimensions over the autoshape surface so that it could fill the space completely. Note: any selected Texture preset fills the space completely, but you can apply the Stretch effect if necessary. Pattern - select this option to fill the shape with a two-colored design composed of regularly repeated elements. Pattern - select one of the predefined designs from the menu. Foreground color - click this color box to change the color of the pattern elements. Background color - click this color box to change the color of the pattern background. No fill - select this option if you don't want to use any fill. Opacity - use this section to set the Opacity level by dragging the slider or entering the percent value manually. The default value is 100%. It means full opacity. The 0% value means full transparency. Line - use this section to change the width, color or type of the autoshape line. To change the line width, select one of the available options from the Size dropdown list. The available options are: 0.5 pt, 1 pt, 1.5 pt, 2.25 pt, 3 pt, 4.5 pt, 6 pt. Alternatively, select the No Line option if you don't want to use any line. To change the line color, click on the colored box below and select the necessary color. To change the line type, select the necessary option from the corresponding dropdown list (a solid line is applied by default, you can change it to one of the available dashed lines). To change the line opacity, enter the required value manually or use the corresponding slider bar. Rotation is used to rotate the shape by 90 degrees clockwise or counterclockwise as well as to flip the shape horizontally or vertically. Click one of the buttons: to rotate the shape by 90 degrees counterclockwise to rotate the shape by 90 degrees clockwise to flip the shape horizontally (left to right) to flip the shape vertically (upside down) Edit shape - use this section to edit the shape points or to replace the current autoshape with another one selected from the dropdown list. Edit points is used to customize or to change the curvature of your shape. Once you click the anchor point, two blue lines with white squares at the ends will appear. These are Bezier handles that allow you to create a curve and to change a curve’s smoothness. As long as the anchor points are active, you can add and delete them. To add a point to a shape, hold Ctrl and click the position where you want to add an anchor point. To delete a point, hold Ctrl and click the unnecessary point. Change shape is used to replace the current autoshape. Choose another autoshape from the dropdown list. Shadow - open this menu to choose one of the preset shadow styles used for the shape. No Shadow - uncheck this menu point to display a shadow, and vice versa. Color - choose one of the available colors either on the Theme colors or the Standard colors palette; use the Eyedropper tool to copy color from other objects in the document; or click the More colors menu item to create a custom color. Adjust Shadow - create a custom shadow using the following sliders: Transparency - adjust the transparency of the shadow. Size - adjust the size of the shadow. Angle - adjust the angle of the shadow relative to its object. Distance - adjust the distance of the shadow from its object. Adjust shape advanced settings To change the advanced settings of the autoshape, use the Show advanced settings link on the right sidebar. The 'Shape - Advanced Settings' window will open: The Size tab contains the following parameters: Width and Height - use these options to change the width and/or height of the autoshape. If the Constant proportions button is clicked (in this case it looks like this ), the width and height will be changed together preserving the original shape aspect ratio. The Rotation tab contains the following parameters: Angle - use this option to rotate the shape by an exactly specified angle. Enter the necessary value measured in degrees into the field or adjust it using the arrows on the right. Flipped - check the Horizontally box to flip the shape horizontally (left to right) or check the Vertically box to flip the shape vertically (upside down). The Weights &amp; Arrows tab contains the following parameters: Line Style - this option group allows you to specify the following parameters: Cap Type - this option allows you to set the style of the end of the line, therefore it can be applied only to the shapes with an open outline, such as lines, polylines etc.: Flat - the end points will be flat. Round - the end points will be rounded. Square - the end points will be square. Join Type - this option allows you to set the style of the intersection of two lines, for example, it can affect a polyline or the corners of a triangle or rectangle outline: Round - the corner will be rounded. Bevel - the corner will be cut off angularly. Miter - the corner will be pointed. It goes well to shapes with sharp angles. Note: the effect will be more noticeable if you use a large outline width. Arrows - this option group is available if a shape from the Lines shape group is selected. It allows you to set the arrow Start and End Style and Size by selecting the appropriate option from the dropdown lists. The Text Box tab allows you to Resize shape to fit text, Allow text to overflow shape or change the Top, Bottom, Left and Right internal margins of the autoshape (i.e. the distance between the text within the shape and the autoshape borders). Note: this tab is only available if text is added within the autoshape, otherwise the tab is disabled. The Columns tab allows you to add columns of text within the autoshape specifying the necessary Number of columns (up to 16) and Spacing between columns. Once you click OK, the text that already exists or any other text you enter within the autoshape will appear in columns and will flow from one column to another one. The Cell Snapping tab contains the following parameters: Move and size with cells - this option allows you to snap the shape to the cell behind it. If the cell moves (e.g. if you insert or delete some rows/columns), the shape will be moved together with the cell. If you increase or decrease the width or height of the cell, the shape will change its size as well. Move but don't size with cells - this option allows you to snap the shape to the cell behind it preventing the shape from being resized. If the cell moves, the shape will be moved together with the cell, but if you change the cell size, the shape dimensions remain unchanged. Don't move or size with cells - this option allows you to prevent the shape from being moved or resized if the cell position or size was changed. The Alternative Text tab allows you to specify the Title and Description which will be read to people with vision or cognitive impairments to help them better understand what information the shape contains. Insert and format text within the autoshape To insert a text into the autoshape, select the shape with the mouse and start typing your text. The text will become part of the autoshape (when you move or rotate the shape, the text also moves or rotates with it). All the formatting options you can apply to the text within the autoshape are listed here. Join autoshapes using connectors You can connect autoshapes using lines with connection points to demonstrate dependencies between the objects (e.g. if you want to create a flowchart). To do that, click the Shape icon on the Insert tab of the top toolbar, select the Lines group from the menu, click the necessary shape within the selected group (excepting the last three shapes which are not connectors, namely Curve, Scribble and Freeform), hover the mouse cursor over the first autoshape and click one of the connection points that appear on the shape outline, drag the mouse cursor towards the second autoshape and click the necessary connection point on its outline. If you move the joined autoshapes, the connector remains attached to the shapes and moves together with them. You can also detach the connector from the shapes and then attach it to any other connection points. Assign a Macro to a Shape You can provide a quick and easy access to a macro within a spreadsheet by assigning a macro to any shape. Once you assign a macro, the shape appears as a button control and you can run the macro whenever you click it. To assign a macro: Right-click the shape to assign a macro to and choose the Assign Macro option from the drop-down menu. The Assign Macro dialogue will open Choose a macro from the list, or type in the macro name, and click OK to confirm."
    },
   {
        "id": "UsageInstructions/InsertChart.htm", 
        "title": "Insert charts", 
        "body": "Insert a recommended chart The easiest way to insert a chart in the Spreadsheet Editor is to use the Recommended Chart tool which suggests using certain types of charts depending on the selected data as well as displays preview for all types of charts. Select the cell range that contain the data you wish to use for the chart. Switch to the Insert tab of the top toolbar. Click the Recommended Chart icon on the top toolbar. Switch between the recommended chart types to see how the chart will look like. You can also use tabs on the left to preview other chart types. When the chart type is selected, click OK. Insert and adjust a chart manually To insert a chart and manually adjust its parameters, Select the cell range that contain the data you wish to use for the chart. Switch to the Insert tab of the top toolbar. Click the Chart icon on the top toolbar. Select the needed chart type from the available ones: Column Charts Clustered column Stacked column 100% stacked column 3-D Clustered Column 3-D Stacked Column 3-D 100% stacked column 3-D Column Line Charts Line Stacked line 100% stacked line Line with markers Stacked line with markers 100% stacked line with markers 3-D Line Pie Charts Pie Doughnut 3-D Pie Bar Charts Clustered bar Stacked bar 100% stacked bar 3-D clustered bar 3-D stacked bar 3-D 100% stacked bar Area Charts Area Stacked area 100% stacked area Stock Charts XY (Scatter) Charts Scatter Stacked bar Scatter with smooth lines and markers Scatter with smooth lines Scatter with straight lines and markers Scatter with straight lines Radar Charts Radar Radar with markers Filled radar Combo Charts Clustered column - line Clustered column - line on secondary axis Stacked area - clustered column Custom combination After that the chart will be added to the worksheet. Note: ONLYOFFICE Spreadsheet Editor supports the following types of charts that were created with third-party editors: Pyramid, Bar (Pyramid), Horizontal/Vertical Cylinders, Horizontal/Vertical Cones. You can open the file containing such a chart and modify it using the available chart editing tools. The following types are supported for opening only: Histogram, Waterfall, Funnel. Adjust the chart settings Now you can change the settings of the inserted chart. To change the chart type, Select the chart with the mouse. Click the Chart settings icon on the right sidebar. Open the Style drop-down list below and select the style which suits you best. Open the Change type drop-down list and select the type you need. Click the Switch row/column option to change the positioning of chart rows and columns. The selected chart type and style will be changed. Additionally, 3D Rotation settings are available for 3D charts: X rotation - set the required value for the X axis rotation using the keyboard or via the Left and Right arrows to the right. Y rotation - set the required value for the Y axis rotation using the keyboard or via the Up and Down arrows to the right. Perspective - set the required value for depth rotation using the keyboard or via the Narrow field of view and Widen field of view arrows to the right. Right Angle Axis - is used to set the right angle axis view. Autoscale - check this box to autoscale the depth and height values of the chart, or uncheck this box to set the depth and height values manually. Depth (% of base) - set the required depth value using the keyboard or via the arrows. Height (% of base) - set the required height value using the keyboard or via the arrows. Default Rotation - set the 3D parameters to their default. Please note that you cannot edit each element of the chart; the settings will be applied to the chart as a whole. To edit chart data: Click the Select Data button on the right-side panel. Use the Chart data dialog to manage Chart data range, Legend entries (series), Horizontal (category) axis label and Switch row/column. Chart data range - select data for your chart. Click the icon on the right of the Chart data range box to select data range. Legend entries (series) - add, edit, or remove legend entries. Type or select series name for legend entries. In Legend entries (series), click Add button. In Edit series, type a new legend entry or click the icon on the right of the Series name box. Horizontal (category) axis labels - change text for category labels. In Horizontal (category) axis labels, click Edit. In Axis label range, type the labels you want to add or click the icon on the right of the Axis label range box to select data range. Switch row/column - rearrange the worksheet data that is configured in the chart not in the way that you want it. Switch rows to columns to display data on a different axis. Click OK button to apply the changes and close the window. Click Show advanced settings to change other settings such as Layout, Vertical axis, Secondary vertical axis, Horizontal axis, Secondary horizontal axis, Cell snapping and Alternative text. The Layout tab allows you to change the layout of chart elements. Specify the Chart title position in regard to your chart by selecting the necessary option from the drop-down list: None to display no chart title, Overlay to overlay and center the title in the plot area, No overlay to display the title above the plot area. Specify the Legend position in regard to your chart by selecting the necessary option from the drop-down list: None to display no legend, Bottom to display the legend and align it to the bottom of the plot area, Top to display the legend and align it to the top of the plot area, Right to display the legend and align it to the right of the plot area, Left to display the legend and align it to the left of the plot area, Left overlay to overlay and center the legend to the left in the plot area, Right overlay to overlay and center the legend to the right in the plot area. Specify the Data labels (i.e., text labels that represent exact values of data points) parameters: Specify the Data labels position relative to the data points by selecting the necessary option from the drop-down list. The available options vary depending on the selected chart type. For Column/Bar charts, you can choose the following options: None, Center, Inner bottom, Inner top, Outer top. For Line/XY (Scatter)/Stock charts, you can choose the following options: None, Center, Left, Right, Top, Bottom. For Pie charts, you can choose the following options: None, Center, Fit to width, Inner top, Outer top. For Area charts as well as for 3D Column, Line, Radar, and Bar charts, you can choose the following options: None, Center. Select the data you wish to include into your labels checking the corresponding boxes: Series name, Category name, Value, Enter a character (comma, semicolon, etc.) you wish to use for separating several labels into the Data labels separator entry field. Lines - is used to choose a line style for Line/XY (Scatter) charts. You can choose one of the following options: Straight to use straight lines between data points, Smooth to use smooth curves between data points, or None to not display lines. Markers - is used to specify whether the markers should be displayed (if the box is checked) or not (if the box is unchecked) for Line/XY (Scatter) charts. Note: the Lines and Markers options are available for Line charts and XY (Scatter) charts only. Trendline options - use the Display equation on chart option for the equations to appear on the diagram. This option is available for diagrams that include trendlines. The Vertical axis tab allows you to change the parameters of the vertical axis also referred to as the values axis or y-axis which displays numeric values. Note that the vertical axis will be the category axis which displays text labels for the Bar charts, therefore in this case the Vertical axis tab options will correspond to the ones described in the next section. For the XY (Scatter) charts, both axes are value axes. Note: the Axis settings and Gridlines sections will be disabled for Pie charts since charts of this type have no axes and gridlines. Select Hide to hide vertical axis in the chart, leave it unchecked to have vertical axis displayed. Specify Title orientation by selecting the necessary option from the drop-down list: None to display no vertical axis title, Rotated to display the title from bottom to top to the left of the vertical axis, Horizontal to display the title horizontally to the left of the vertical axis. Minimum value - is used to specify the lowest value displayed at the vertical axis start. The Auto option is selected by default, in this case the minimum value is calculated automatically depending on the selected data range. You can select the Fixed option from the drop-down list and specify a different value in the entry field on the right. Maximum value - is used to specify the highest value displayed at the vertical axis end. The Auto option is selected by default, in this case the maximum value is calculated automatically depending on the selected data range. You can select the Fixed option from the drop-down list and specify a different value in the entry field on the right. Axis crosses - is used to specify a point on the vertical axis where the horizontal axis should cross it. The Auto option is selected by default, in this case the axes intersection point value is calculated automatically depending on the selected data range. You can select the Value option from the drop-down list and specify a different value in the entry field on the right, or set the axes intersection point at the Minimum/Maximum Value on the vertical axis. Display units - is used to determine the representation of the numeric values along the vertical axis. This option can be useful if you're working with great numbers and wish the values on the axis to be displayed in a more compact and readable way (e.g. you can represent 50 000 as 50 by using the Thousands display units). Select desired units from the drop-down list: Hundreds, Thousands, 10 000, 100 000, Millions, 10 000 000, 100 000 000, Billions, Trillions, or choose the None option to return to the default units. Values in reverse order - is used to display values in the opposite direction. When the box is unchecked, the lowest value is at the bottom and the highest value is at the top of the axis. When the box is checked, the values are ordered from top to bottom. Logarithmic scale - is used to enable logarithmic scaling to the Base that is determined by the user. The Tick Options section allows adjusting the appearance of tick marks on the vertical scale. Major tick marks are the larger scale divisions which can have labels displaying numeric values. Minor tick marks are the scale subdivisions which are placed between the major tick marks and have no labels. Tick marks also define where gridlines can be displayed if the corresponding option is set on the Layout tab. The Major/minor type drop-down lists contain the following placement options: None to display no major/minor tick marks, Cross to display major/minor tick marks on both sides of the axis, In to display major/minor tick marks inside the axis, Out to display major/minor tick marks outside the axis. The Label options section allows adjusting the appearance of major tick mark labels which display values. To specify a Label position in regard to the vertical axis, select the necessary option from the drop-down list: None to display no tick mark labels, Low to display tick mark labels to the left of the plot area, High to display tick mark labels to the right of the plot area, Next to axis to display tick mark labels next to the axis. To specify a Label format click the Label Format button and choose a category as it deems appropriate. Available label format categories: General Number Scientific Accounting Currency Date Time Percentage Fraction Text Custom Label format options vary depending on the selected category. For more information on changing number format, go to this page. Check Linked to source to keep number formatting from the data source in the chart. Note: Secondary axes are supported in Combo charts only. Secondary axes are useful in Combo charts when data series vary considerably or mixed types of data are used to plot a chart. Secondary Axes make it easier to read and understand a combo chart. The Secondary vertical/horizontal axis tab appears when you choose an appropriate data series for a combo chart. All the settings and options on the Secondary vertical/horizontal axis tab are the same as the settings on the Vertical/Horizontal Axis. For a detailed description of the Vertical/horizontal axis options, see description above/below. The Horizontal axis tab allows you to change the parameters of the horizontal axis also referred to as the categories axis or x-axis which displays text labels. Note that the horizontal axis will be the value axis which displays numeric values for the Bar charts, therefore in this case the Horizontal axis tab options will correspond to the ones described in the previous section. For the XY (Scatter) charts, both axes are value axes. Select Hide to hide horizontal axis in the chart, leave it unchecked to have horizontal axis displayed. Specify Title orientation by selecting the necessary option from the drop-down list: None when you don’t want to display a horizontal axis title, No overlay  to display the title below the horizontal axis, Gridlines is used to specify the Horizontal gridlines to display by selecting the necessary option from the drop-down list: None,  Major, Minor, or Major and minor. Axis crosses - is used to specify a point on the horizontal axis where the vertical axis should cross it. The Auto option is selected by default, in this case the axes intersection point value is calculated automatically depending on the selected data range. You can select the Value option from the drop-down list and specify a different value in the entry field on the right, or set the axes intersection point at the Minimum/maximum value (that corresponds to the first and last category) on the horizontal axis. Axis position - is used to specify where the axis text labels should be placed: On tick marks or Between tick marks. Values in reverse order - is used to display categories in the opposite direction. When the box is unchecked, categories are displayed from left to right. When the box is checked, the categories are ordered from right to left. The Tick Options section allows adjusting the appearance of tick marks on the horizontal scale. Major tick marks are the larger divisions which can have labels displaying category values. Minor tick marks are the smaller divisions which are placed between the major tick marks and have no labels. Tick marks also define where gridlines can be displayed if the corresponding option is set on the Layout tab. You can adjust the following tick mark parameters: Major/minor type - is used to specify the following placement options: None to display no major/minor tick marks, Cross to display major/minor tick marks on both sides of the axis, In to display major/minor tick marks inside the axis, Out to display major/minor tick marks outside the axis. Interval between marks - is used to specify how many categories should be displayed between two adjacent tick marks. The Label options section allows adjusting the appearance of labels which display categories. Label position - is used to specify where the labels should be placed in regard to the horizontal axis. Select the necessary option from the drop-down list: None to display no category labels, Low to display category labels at the bottom of the plot area, High to display category labels at the top of the plot area, Next to axis to display category labels next to the axis. Axis label distance - is used to specify how closely the labels should be placed to the axis. You can specify the necessary value in the entry field. The more the value you set, the more the distance between the axis and labels is. Interval between labels - is used to specify how often the labels should be displayed. The Auto option is selected by default, in this case labels are displayed for every category. You can select the Manual option from the drop-down list and specify the necessary value in the entry field on the right. For example, enter 2 to display labels for every other category etc. To specify a Label format click the Label Format button and choose a category as it deems appropriate. Available label format categories: General Number Scientific Accounting Currency Date Time Percentage Fraction Text Custom Label format options vary depending on the selected category. For more information on changing number format, go to this page. Check Linked to source to keep number formatting from the data source in the chart. The Cell snapping tab contains the following parameters: Move and size with cells - this option allows you to snap the chart to the cell behind it. If the cell moves (e.g. if you insert or delete some rows/columns), the chart will be moved together with the cell. If you increase or decrease the width or height of the cell, the chart will change its size as well. Move but don't size with cells - this option allows to snap the chart to the cell behind it preventing the chart from being resized. If the cell moves, the chart will be moved together with the cell, but if you change the cell size, the chart dimensions remain unchanged. Don't move or size with cells - this option allows to prevent the chart from being moved or resized if the cell position or size was changed. The Alternative text tab allows to specify the Title and the Description which will be read to people with vision or cognitive impairments to help them better understand what information the chart contains. Edit chart elements To edit the chart Title, select the default text with the mouse and type in your own one instead. To change the font formatting within text elements, such as the chart title, axes titles, legend entries, data labels etc., select the necessary text element by left-clicking it. Then use icons on the Home tab of the top toolbar to change the font type, style, size, or color. When the chart is selected, the Shape settings icon is also available on the right, since the shape is used as a background for the chart. You can click this icon to open the Shape settings tab on the right sidebar and adjust the shape Fill and Line. Note that you cannot change the shape type. Using the Shape settings tab on the right panel you can not only adjust the chart area itself, but also change the chart elements, such as the plot area, data series, chart title, legend, etc. and apply different fill types to them. Select the chart element by clicking it with the left mouse button and choose the preferred fill type: solid color, gradient, texture or picture, pattern. Specify the fill parameters and set the Opacity level if necessary. When you select a vertical or horizontal axis or gridlines, the stroke settings are only available on the Shape Settings tab: color, width, type, and opacity. For more details on how to work with shape colors, fills and stroke, please refer to this page. Note: the Show shadow option is also available on the Shape settings tab, but it is disabled for chart elements. If you need to resize chart elements, left-click to select the needed element and drag one of 8 white squares located along the perimeter of the element. To change the position of the element, left-click on it, make sure your cursor changed to , hold the left mouse button and drag the element to the needed position. To delete a chart element, select it by left-clicking and press the Delete key on the keyboard. You can also rotate 3D charts using the mouse. Left-click within the plot area and hold the mouse button. Drag the cursor without releasing the mouse button to change the 3D chart orientation. If necessary, you can change the chart size and position. To delete the inserted chart, click it and press the Delete key. Assign a Macro to a Chart You can provide a quick and easy access to a macro within a spreadsheet by assigning a macro to any chart. Once you assign a macro, the chart appears as a button control and you can run the macro whenever you click it. To assign a macro: Right-click the chart to assign a macro to and choose the Assign Macro option from the drop-down menu. The Assign Macro dialogue will open Choose a macro from the list, or type in the macro name, and click OK to confirm. Once a macro is assigned, you can still select the chart to perform other operations by left-clicking on chart surface. Using sparklines ONLYOFFICE Spreadsheet Editor supports Sparklines. Sparklines are small charts that fit into a cell, and are an efficient data visualization tool. For more information about how to create, edit and format sparklines, please see our Insert Sparklines guidelines."
    },
   {
        "id": "UsageInstructions/InsertDeleteCells.htm", 
        "title": "Manage cells, rows, and columns", 
        "body": "In the Spreadsheet Editor you can insert blank cells above or on the left of the selected cell in a worksheet. You can also insert an entire row above the selected one or a column on the left of the selected column. To make it easy to view a large amount of information, you can hide some rows or columns and display them again. It's also possible to specify the height of a certain row and width of a column. Insert cells, rows, columns To insert a blank cell to the left of the selected cell: right-click the cell to the left of which you wish to insert a new one, click the Insert cells icon situated at the Home tab of the top toolbar or select the Insert item from the right-click menu and use the Shift Cells Right option. The program will shift the selected cell to the right to insert a blank one. To insert a blank cell above the selected cell: right-click the cell above which you wish to insert a new one, click the Insert cells icon situated on the Home tab of the top toolbar or select the Insert item from the right-click menu and use the Shift Cells Down option. The program will shift the selected cell down to insert a blank one. To insert an entire row: select either the whole row by clicking its heading or a cell in the row above which you wish to insert a new one, Note: to insert multiple rows, select the required number of rows. click the Insert cells icon situated on the Home tab of the top toolbar and use the Entire row option, or right-click the selected cell, select the Insert item from the right-click menu, then choose the Entire Row option, or right-click the selected row(s) and use the Insert Top option from the right-click menu. The program will shift the selected row down to insert a blank one. To insert an entire column: select either the whole column by clicking its heading or a cell in the column to the left of which you wish to insert a new one, Note: to insert multiple columns, select the required number of columns. click the Insert cells icon situated on the Home tab of the top toolbar and use the Entire column option, or right-click the selected cell, select the Insert item from the right-click menu, then choose the Entire Column option, or right-click the selected column(s) and use the Insert Left option from the right-click menu. The program will shift the selected column to the right to insert a blank one. You can also use the Ctrl+Shift+= keyboard shortcut to open the dialog box for inserting new cells, select the Shift Cells Right, Shift Cells Down, Entire Row, or Entire Column option and click OK. Move rows and columns To move the contents of a row or a column, select it via clicking its number (for rows) or its alphabetical header (for columns), hold the left mouse button, then drag-and-drop it to the desired location within the spreadsheet. Hide and show rows and columns To hide a row or column: select rows or columns you wish to hide, right-click the selected rows or columns and use the Hide option from the right-click menu. To display the hidden rows or columns, select the visible rows above and below the hidden rows or visible columns to the left and to the right of the hidden columns, right-click them and use the Show option from the right-click menu. Change column width and row height The column width determines how many characters with default formatting can be displayed in the column cell. The default value is set to 8.43 symbols. To change it: select columns you wish to change, right-click the selected columns and use the Set Column Width option from the right-click menu, choose one of the available options: select the Auto Fit Column Width option to automatically adjust the width of each column according to its content, or select the Custom Column Width option and specify a new value from 0 to 255 in the Custom Column Width window, then click OK. To change the width of a single column manually, move the mouse cursor over the right border of the column heading so that the cursor turns into the bidirectional arrow . Drag the border to the left or right to set a custom width or double-click the mouse to automatically change the column width according to its content. The default row height value is 14.25 points. To change it: select rows you wish to change, right-click the selected rows and use the Set Row Height option from the right-click menu, choose one of the available options: select the Auto Fit Row Height option to automatically adjust the height of each row according to its content, or select the Custom Row Height option and specify a new value from 0 to 408.75 in the Custom Row Height window, then click OK. To change the height of a single row manually, drag the bottom border of the row heading. Delete cells, rows, columns To delete an unnecessary cell, row, or column: select cells, rows, or columns you wish to delete, click the Delete cells icon situated on the Home tab of the top toolbar or select the Delete item from the right-click menu and select the appropriate option: if you use the Shift Cells Left option, a cell to the right of the deleted one will be moved to the left; if you use the Shift Cells Up option, a cell below the deleted one will be moved up; if you use the Entire Row option, a row below the selected one will be moved up; if you use the Entire Column option, a column to the right of the deleted one will be moved to the left; You can also use the Ctrl+Shift+- keyboard shortcut to open the dialog box for deleting cells, select the Shift Cells Left, Shift Cells Up, Entire Row, or Entire Column option and click OK. You can always restore the deleted data using the Undo icon on the top toolbar."
    },
   {
        "id": "UsageInstructions/InsertEquation.htm", 
        "title": "Insert equations", 
        "body": "The Spreadsheet Editor allows you to build equations using the built-in templates, edit them, insert special characters (including mathematical operators, Greek letters, accents etc.). Add a new equation To insert an equation from the gallery, put the cursor within the necessary cell, switch to the Insert tab of the top toolbar, click the arrow next to the Equation icon on the top toolbar, select the required equation category in the toolbar above the inserted equation, or in the opened drop-down list select the equation category you need. The following categories are currently available: Symbols, Fractions, Scripts, Radicals, Integrals, Large Operators, Brackets, Functions, Accents, Limits and Logarithms, Operators, Matrices, click the Equation Settings symbol in the toolbar above the inserted equation to access more settings, e.g., Unicode or LaTeX, Professional or Linear, and Change to Inline, click the certain symbol/equation in the corresponding set of templates, to hide the toolbar, click the Hide Equation Toolbar option in the Equation Settings. The selected symbol/equation will be added to the worksheet. The upper left corner of the equation box will coincide with the upper left corner of the currently selected cell, but the equation box can be freely moved, resized or rotated in the sheet. To do that, click on the equation box border (it will be displayed as a solid line) and use corresponding handles. Each equation template represents a set of slots. A slot is a position of each element that makes up the equation. An empty slot (also called as a placeholder) has a dotted outline . You need to fill in all the placeholders specifying the necessary values. Enter values The insertion point specifies where the next character will appear. To position the insertion point precisely, click within a placeholder and use the keyboard arrows to move the insertion point by one character left/right. Once the insertion point is positioned, you can fill in the placeholder: enter the desired numeric/literal value using the keyboard, insert a special character using the Symbols palette from the Equation menu on the Insert tab of the top toolbar or typing them from the keyboard (see the Math AutoСorrect option description), add another equation template from the palette to create a complex nested equation. The size of the primary equation will be automatically adjusted to fit its content. The size of the nested equation elements depends on the primary equation placeholder size, but it cannot be smaller than the sub-subscript size. To add some new equation elements, you can also use the right-click menu options: To add a new argument that goes before or after the existing one within Brackets, you can right-click on the existing argument and select the Insert argument before/after option from the menu. To add a new equation within Cases with several conditions from the Brackets group, you can right-click on an empty placeholder or entered equation within it and select the Insert equation before/after option from the menu. To add a new row or a column in a Matrix, you can right-click on a placeholder within it, select the Insert option from the menu, then select Row Above/Below or Column Left/Right. Note: currently, equations cannot be entered using the linear format, i.e. \\sqrt(4&x^3). When entering the values of the mathematical expressions, you do not need to use Spacebar because the spaces between the characters and signs of operations are set automatically. If the equation is too long and does not fit a single line within the equation box, automatic line breaking occurs while you type. You can also insert a line break in a specific position by right-clicking on a mathematical operator and selecting the Insert manual break option from the menu. The selected operator will start a new line. To delete the added manual line break, right-click on the mathematical operator that starts a new line and select the Delete manual break option. Format equations By default, the equation within the equation box is horizontally centered and vertically aligned to the top of the equation box. To change its horizontal/vertical alignment, put the cursor within the equation box (the equation box borders will be displayed as dashed lines) and use the corresponding icons at the top toolbar. To increase or decrease the equation font size, click anywhere within the equation box and use the Increment font size and Decrement font size buttons on the Home tab of the top toolbar or select the necessary font size from the list. All the equation elements will change correspondingly. The letters within the equation are italicized by default. If necessary, you can change the font style (bold, italic, strikeout) or color for a whole equation or its part. The underlined style can be applied to the entire equation only, not to individual characters. Select the necessary part of the equation by clicking and dragging. The selected part will be highlighted blue. Then use the necessary buttons on the Home tab of the top toolbar to format the selection. For example, you can remove the italic format for ordinary words that are not variables or constants. To modify some equation elements, you can also use the right-click menu options: To change the Fractions format, you can right-click on a fraction and select the Change to skewed/linear/stacked fraction option from the menu (the available options differ depending on the selected fraction type). To change the Scripts position relating to text, you can right-click on the equation that includes scripts and select the Scripts before/after text option from the menu. To change the argument size for Scripts, Radicals, Integrals, Large Operators, Limits and Logarithms, Operators as well as for overbraces/underbraces and templates with grouping characters from the Accents group, you can right-click on the argument you want to change and select the Increase/Decrease argument size option from the menu. To specify whether an empty degree placeholder should be displayed or not for a Radical, you can right-click on the radical and select the Hide/Show degree option from the menu. To specify whether an empty limit placeholder should be displayed or not for an Integral or Large Operator, you can right-click on the equation and select the Hide/Show top/bottom limit option from the menu. To change the limits position relating to the integral or operator sign for Integrals or Large Operators, you can right-click on the equation and select the Change limits location option from the menu. The limits can be displayed to the right of the operator sign (as subscripts and superscripts) or directly above and below the operator sign. To change the limits position relating to text for Limits and Logarithms and templates with grouping characters from the Accents group, you can right-click on the equation and select the Limit over/under text option from the menu. To choose which of the Brackets should be displayed, you can right-click on the expression within them and select the Hide/Show opening/closing bracket option from the menu. To control the Brackets size, you can right-click on the expression within them. The Stretch brackets option is selected by default so that the brackets can grow according to the expression within them, but you can deselect this option to prevent brackets from stretching. When this option is activated, you can also use the Match brackets to argument height option. To change the character position relating to text for overbraces/underbraces or overbars/underbars from the Accents group, you can right-click on the template and select the Char/Bar over/under text option from the menu. To choose which borders should be displayed for a Boxed formula from the Accents group, you can right-click on the equation and select the Border properties option from the menu, then select Hide/Show top/bottom/left/right border or Add/Hide horizontal/vertical/diagonal line. To specify whether empty placeholders should be displayed or not for a Matrix, you can right-click on it and select the Hide/Show placeholder option from the menu. To align some equation elements, you can use the right-click menu options: To align equations within Cases with several conditions from the Brackets group, you can right-click on an equation, select the Alignment option from the menu, then select the alignment type: Top, Center, or Bottom. To align a Matrix vertically, you can right-click on the matrix, select the Matrix Alignment option from the menu, then select the alignment type: Top, Center, or Bottom. To align elements within a Matrix column horizontally, you can right-click on a placeholder within the column, select the Column Alignment option from the menu, then select the alignment type: Left, Center, or Right. Delete equation elements To delete a part of the equation, select the part you want to delete by dragging the mouse or holding down the Shift key and using the arrow buttons, then press the Delete key on the keyboard. A slot can only be deleted together with the template it belongs to. To delete the entire equation, click on the equation box border (it will be displayed as a solid line) and and press the Delete key on the keyboard. To delete some equation elements, you can also use the right-click menu options: To delete a Radical, you can right-click on it and select the Delete radical option from the menu. To delete a Subscript and/or Superscript, you can right-click on the expression that contains them and select the Remove subscript/superscript option from the menu. If the expression contains scripts that go before text, the Remove scripts option is available. To delete Brackets, you can right-click on the expression within them and select the Delete enclosing characters or Delete enclosing characters and separators option from the menu. If the expression within Brackets inclides more than one argument, you can right-click on the argument you want to delete and select the Delete argument option from the menu. If Brackets enclose more than one equation (i.e. Cases with several conditions), you can right-click on the equation you want to delete and select the Delete equation option from the menu. To delete a Limit, you can right-click on it and select the Remove limit option from the menu. To delete an Accent, you can right-click on it and select the Remove accent character, Delete char or Remove bar option from the menu (the available options differ depending on the selected accent). To delete a row or a column of a Matrix, you can right-click on the placeholder within the row/column you need to delete, select the Delete option from the menu, then select Delete Row/Column. Convert equations If you open an existing document containing equations which were created with an old version of equation editor (for example, with MS Office versions before 2007), you need to convert these equations to the Office Math ML format to be able to edit them. To convert an equation, double-click it. The warning window will appear: To convert the selected equation only, click the Yes button in the warning window. To convert all equations in this document, check the Apply to all equations box and click Yes. Once the equation is converted, you can edit it."
    },
   {
        "id": "UsageInstructions/InsertFunction.htm", 
        "title": "Insert functions", 
        "body": "The ability to perform basic calculations is the principal reason for using the Spreadsheet Editor. Some of them are performed automatically when you select a cell range in your spreadsheet: Average is used to analyze the selected cell range and find the average value. Count is used to count the number of the selected cells with values ignoring the empty cells. Min is used to analyze the range of data and find the smallest number. Max is used to analyze the range of data and find the largest number. Sum is used to add all the numbers in the selected range, ignoring the empty cells or those containing text. The results of these calculations are displayed in the right lower corner of the status bar. You can manage the status bar by right-clicking on it and choosing only those functions to display that you need. To perform any other calculations, you can insert the required formula manually using the common mathematical operators or insert a predefined formula - Function. The abilities to work with Functions are accessible from both the Home and Formula tab or by pressing Shift+F3 key combination. On the Home tab, you can use the Insert function button to add one of the most commonly used functions (SUM, AVERAGE, MIN, MAX, COUNT) or open the Insert Function window that contains all the available functions classified by category. Use the search box to find the exact function by its name. On the Formula tab, you can use the following buttons: Function - to open the Insert Function window that contains all the available functions classified by category. Autosum - to quickly access the SUM, MIN, MAX, COUNT functions. When you select a function from this group, it automatically performs calculations for all cells in the column above the selected cell so that you don't need to enter arguments. Recently used - to quickly access 10 recently used functions. Financial, Logical, Text and data, Date and time, Lookup and references, Math and trigonometry - to quickly access functions that belong to the corresponding categories. More functions - to access the functions from the following groups: Database, Engineering, Information and Statistical. Named ranges - to open the Name Manager, or define a new name, or paste a name as a function argument. For more details, you can refer to this page. Trace Precedents - to show arrows that indicate which cells affect the value of the selected cell. Trace Dependents - to show arrows that indicate which cells are affected by the value of the selected cell. Remove Arrows - to remove the arrows used for precedents and dependents. Click the arrow next to the Remove Arrows option to choose whether to remove all arrows, precedent arrows, or dependent arrows. Show Formulas - to show the formulas used in the cells instead of the final results of the formulas. Watch Window - to display changes in the cells that are not currently in the visible area of the worksheet. To learn more about the Watch Window, please read the following article. Calculation - to force the program to recalculate functions. How to apply functions To insert a function, Select a cell where you wish to insert a function. Proceed in one of the following ways: switch to the Formula tab and use the buttons available on the top toolbar to access a function from a specific group, then click the necessary function to open the Function Arguments wizard. You can also use the Additional option from the menu, or click the Function button on the top toolbar to open the Insert Function window. switch to the Home tab, click the Insert function icon, select one of the commonly used functions (SUM, AVERAGE, MIN, MAX, COUNT) or click the Additional option to open the Insert Function window. right-click within the selected cell and select the Insert Function option from the contextual menu. click the icon before the formula bar. In the opened Insert Function window, enter its name in the search box or select the necessary function group, then choose the required function from the list and click OK. Once you click the necessary function, the Function Arguments window will open: In the opened Function Arguments window, enter the necessary values of each argument. You can enter the function arguments either manually, or by clicking the icon and selecting a cell or cell range to be included as an argument. Note: generally, numeric values, logical values (TRUE, FALSE), text values (must be quoted), cell references, cell range references, names assigned to ranges and other functions can be used as function arguments. The function result will be displayed below. When all the arguments are specified, click the OK button in the Function Arguments window. To enter a function manually using the keyboard, Select a cell. Enter the equal sign (=). Each formula must begin with the equal sign (=). Enter the function name. Once you type the initial letters, the Formula Autocomplete list will be displayed. As you type, the items (formulas and names) that match the entered characters are displayed in it. If you hover the mouse pointer over a formula, a tooltip with the formula description will be displayed. You can select the necessary formula from the list and insert it by clicking it or pressing the Tab key. Enter the function arguments either manually or by dragging to select a cell range to be included as an argument. If the function requires several arguments, they must be separated by commas. Arguments must be enclosed into parentheses. The opening parenthesis '(' is added automatically if you select a function from the list. When you enter arguments, a tooltip that contains the formula syntax is also displayed. When all the arguments are specified, enter the closing parenthesis ')' and press Enter. If you enter new data or change the values used as arguments, recalculation of functions is performed automatically by default. You can force the program to recalculate functions by using the Calculation button on the Formula tab. Click the Calculation button to recalculate the entire workbook, or click the arrow below the button and choose the necessary option from the menu: Calculate workbook or Calculate current sheet. You can also use the following key combinations: F9 to recalculate the workbook, Shift +F9 to recalculate the current worksheet. Here is the list of the available functions grouped by categories: Function Category Description Functions Text and Data Functions Used to correctly display the text data in the spreadsheet. ARRAYTOTEXT; ASC; CHAR; CLEAN; CODE; CONCATENATE; CONCAT; DOLLAR; EXACT; FIND; FINDB; FIXED; IMPORTRANGE; LEFT; LEFTB; LEN; LENB; LOWER; MID; MIDB; NUMBERVALUE; PROPER; REPLACE; REPLACEB; REPT; RIGHT; RIGHTB; SEARCH; SEARCHB; SUBSTITUTE; T; TEXT; TEXTJOIN; TRIM; UNICHAR; UNICODE; UPPER; VALUE; TEXTBEFORE; TEXTAFTER; TEXTSPLIT Statistical Functions Used to analyze data: finding the average value, the largest or smallest values in a cell range. AVEDEV; AVERAGE; AVERAGEA; AVERAGEIF; AVERAGEIFS; BETADIST; BETA.DIST; BETA.INV; BETAINV; BINOMDIST; BINOM.DIST; BINOM.DIST.RANGE; BINOM.INV; CHIDIST; CHIINV; CHISQ.DIST; CHISQ.DIST.RT; CHISQ.INV; CHISQ.INV.RT; CHITEST; CHISQ.TEST; CONFIDENCE; CONFIDENCE.NORM; CONFIDENCE.T; CORREL; COUNT; COUNTA; COUNBLANK; COUNTIF; COUNTIFS; COVAR; COVARIANCE.P; COVARIANCE.S; CRITBINOM; DEVSQ; EXPON.DIST; EXPONDIST; F.DIST; FDIST; F.DIST.RT; F.INV; FINV; F.INV.RT; FISHER; FISHERINV; FORECAST; FORECAST.ETS; FORECAST.ETS.CONFINT; FORECAST.ETS.SEASONALITY; FORECAST.ETS.STAT; FORECAST.LINEAR; FREQUENCY; FTEST; F.TEST; GAMMA; GAMMA.DIST; GAMMADIST; GAMMA.INV; GAMMAINV; GAMMALN; GAMMALN.PRECISE; GAUSS; GEOMEAN; GROWTH; HARMEAN; HYPGEOMDIST; HYPGEOM.DIST; INTERCEPT; KURT; LARGE; LINEST; LOGEST, LOGINV; LOGNORM.DIST; LOGNORM.INV; LOGNORMDIST; MAX; MAXA; MAXIFS; MEDIAN; MIN; MINA; MINIFS; MODE; MODE.MULT; MODE.SNGL; NEGBINOMDIST; NEGBINOM.DIST; NORMDIST; NORM.DIST; NORMINV; NORM.INV; NORMSDIST; NORM.S.DIST; NORMSINV; NORM.S.INV; PEARSON; PERCENTILE; PERCENTILE.EXC; PERCENTILE.INC; PERCENTRANK; PERCENTRANK.EXC; PERCENTRANK.INC; PERMUT; PERMUTATIONA; PHI; POISSON; POISSON.DIST; PROB; QUARTILE; QUARTILE.EXC; QUARTILE.INC; RANK; RANK.AVG; RANK.EQ; RSQ; SKEW; SKEW.P; SLOPE; SMALL; STANDARDIZE; STDEV; STDEV.S; STDEVA; STDEVP; STDEV.P; STDEVPA; STEYX; TDIST; T.DIST; T.DIST.2T; T.DIST.RT; T.INV; T.INV.2T; TINV; TREND, TRIMMEAN; TTEST; T.TEST; VAR; VARA; VARP; VAR.P; VAR.S; VARPA; WEIBULL; WEIBULL.DIST; ZTEST; Z.TEST Math and Trigonometry Functions Used to perform basic math and trigonometry operations such as adding, multiplying, dividing, rounding, etc. ABS; ACOS; ACOSH; ACOT; ACOTH; AGGREGATE; ARABIC; ASIN; ASINH; ATAN; ATAN2; ATANH; BASE; CEILING; CEILING.MATH; CEILING.PRECISE; COMBIN; COMBINA; COS; COSH; COT; COTH; CSC; CSCH; DECIMAL; DEGREES; ECMA.CEILING; EVEN; EXP; FACT; FACTDOUBLE; FLOOR; FLOOR.PRECISE; FLOOR.MATH; GCD; INT; ISO.CEILING; LCM; LN; LOG; LOG10; MDETERM; MINVERSE; MMULT; MOD; MROUND; MULTINOMIAL; MUNIT; ODD; PI; POWER; PRODUCT; QUOTIENT; RADIANS; RAND; RANDARRAY; RANDBETWEEN; ROMAN; ROUND; ROUNDDOWN; ROUNDUP; SEC; SECH; SERIESSUM; SEQUENCE; SIGN; SIN; SINH; SQRT; SQRTPI; SUBTOTAL; SUM; SUMIF; SUMIFS; SUMPRODUCT; SUMSQ; SUMX2MY2; SUMX2PY2; SUMXMY2; TAN; TANH; TRUNC Date and Time Functions Used to correctly display the date and time in the spreadsheet. DATE; DATEDIF; DATEVALUE; DAY; DAYS; DAYS360; EDATE; EOMONTH; HOUR; ISOWEEKNUM; MINUTE; MONTH; NETWORKDAYS; NETWORKDAYS.INTL; NOW; SECOND; TIME; TIMEVALUE; TODAY; WEEKDAY; WEEKNUM; WORKDAY; WORKDAY.INTL; YEAR; YEARFRAC Engineering Functions Used to perform some engineering calculations: converting between different bases number systems, finding complex numbers etc. BESSELI; BESSELJ; BESSELK; BESSELY; BIN2DEC; BIN2HEX; BIN2OCT; BITAND; BITLSHIFT; BITOR; BITRSHIFT; BITXOR; COMPLEX; CONVERT; DEC2BIN; DEC2HEX; DEC2OCT; DELTA; ERF; ERF.PRECISE; ERFC; ERFC.PRECISE; GESTEP; HEX2BIN; HEX2DEC; HEX2OCT; IMABS; IMAGINARY; IMARGUMENT; IMCONJUGATE; IMCOS; IMCOSH; IMCOT; IMCSC; IMCSCH; IMDIV; IMEXP; IMLN; IMLOG10; IMLOG2; IMPOWER; IMPRODUCT; IMREAL; IMSEC; IMSECH; IMSIN; IMSINH; IMSQRT; IMSUB; IMSUM; IMTAN; OCT2BIN; OCT2DEC; OCT2HEX Database Functions Used to perform calculations for the values in a certain field of the database that meet the specified criteria. DAVERAGE; DCOUNT; DCOUNTA; DGET; DMAX; DMIN; DPRODUCT; DSTDEV; DSTDEVP; DSUM; DVAR; DVARP Financial Functions Used to perform some financial calculations: calculating the net present value, payments etc. ACCRINT; ACCRINTM; AMORDEGRC; AMORLINC; COUPDAYBS; COUPDAYS; COUPDAYSNC; COUPNCD; COUPNUM; COUPPCD; CUMIPMT; CUMPRINC; DB; DDB; DISC; DOLLARDE; DOLLARFR; DURATION; EFFECT; FV; FVSCHEDULE; INTRATE; IPMT; IRR; ISPMT; MDURATION; MIRR; NOMINAL; NPER; NPV; ODDFPRICE; ODDFYIELD; ODDLPRICE; ODDLYIELD; PDURATION; PMT; PPMT; PRICE; PRICEDISC; PRICEMAT; PV; RATE; RECEIVED; RRI; SLN; SYD; TBILLEQ; TBILLPRICE; TBILLYIELD; VDB; XIRR; XNPV; YIELD; YIELDDISC; YIELDMAT Lookup and Reference Functions Used to easily find information from the data list. ADDRESS; CHOOSE; CHOOSECOLS; CHOOSEROWS; COLUMN; COLUMNS; DROP; EXPAND; FILTER; FORMULATEXT; GETPIVOTDATA; HLOOKUP; HSTACK; HYPERLINK; INDEX; INDIRECT; LOOKUP; MATCH; OFFSET; ROW; ROWS; SORT; SORTBY; TAKE; TOCOL; TOROW; TRANSPOSE; UNIQUE; VLOOKUP; VSTACK; WRAPCOLS; WRAPROWS; XLOOKUP; XMATCH Information Functions Used to provide information about the data in the selected cell or cell range. CELL; ERROR.TYPE; ISBLANK; ISERR; ISERROR; ISEVEN; ISFORMULA; ISLOGICAL; ISNA; ISNONTEXT; ISNUMBER; ISODD; ISREF; ISTEXT; N; NA; SHEET; SHEETS; TYPE Logical Functions Used to check if a condition is true or false. AND; FALSE; IF; IFERROR; IFNA; IFS; NOT; OR; SWITCH; TRUE; XOR Custom Functions Used to access custom functions."
    },
   {
        "id": "UsageInstructions/InsertHeadersFooters.htm", 
        "title": "Insert headers and footers", 
        "body": "Headers and footers allow adding some additional information to a printed worksheet, such as date and time, page number, sheet name, etc. Headers and footers are displayed in the printed version of a spreadsheet. To insert a header or footer in the Spreadsheet Editor: switch to the Insert or Layout tab, click the Edit Header/Footer button on the top toolbar, the Header/Footer Settings window will open, and you will be able to adjust the following settings: check the Different first page box to apply a different header or footer to the very first page or in case you don't want to add any header/ footer to it at all. The First page tab will appear below. check the Different odd and even page box to add different headers/footer for odd and even pages. The Odd page and Even page tabs will appear below. the Scale with document option allows scaling the header and footer together with the worksheet. This parameter is enabled by default. the Align with page margins option allows aligning the left header/footer to the left margin and the right header/footer to the right margin. This option is enabled by default. insert the necessary data. Depending on the selected options, you can adjust settings for All pages or set up the header/footer for the first page as well as for odd and even pages individually. Switch to the necessary tab and adjust the available parameters. You can use one of the ready-made presets or insert the necessary data to the left, center and right header/footer field manually: choose one of the available presets from the Presets list: Page 1; Page 1 of ?; Sheet1; Confidential, dd/mm/yyyy, Page 1; Spreadsheet name.xlsx; Sheet1, Page 1; Sheet1, Confidential, Page 1; Spreadsheet name.xlsx, Page 1; Page 1, Sheet1; Page 1, Spreadsheet name.xlsx; Author, Page 1, dd/mm/yyyy; Prepared by Author dd/mm/yyyy, Page 1. The corresponding variables will be added. place the cursor into the left, center, or right field of the header/footer and use the Insert list to add Page number, Page count, Date, Time, File name, Sheet name, Picture. format the text inserted into the header/footer using the corresponding controls. You can change the default font, its size, color, apply font styles, such as bold, italic, underlined, strikethrough, use subscript or superscript characters. when you finish, click the OK button to apply the changes. To edit the added headers and footers, click the Edit Header/Footer button on the top toolbar, make the necessary changes in the Header/Footer Settings window, and click OK to save the changes. The added header and/or footer will be displayed in the printed version of the spreadsheet."
    },
   {
        "id": "UsageInstructions/InsertImages.htm", 
        "title": "Insert images", 
        "body": "The Spreadsheet Editor allows you to insert images in the most popular formats into your worksheet. The following image formats are supported: BMP, GIF, JPEG, JPG, PNG. Insert an image To insert an image into the spreadsheet, place the cursor where the image should be added, switch to the Insert tab of the top toolbar, click the Image icon on the top toolbar, select one of the following options to load the image: the Image from File option will open the standard dialog window to select a file. Browse the hard disk drive of your computer to find the required file and click the Open button In the online editor, you can select several images at once. the Image from URL option will open the window where you can enter the web address of the required image and click the OK button the Image from Storage option will open the Select data source window. Select an image stored on your portal and click the OK button After that, the image will be added to the worksheet. You can save the image as a picture on your hard drive using the Save as picture option in the right-click menu. Adjust the image settings Once the image is added, you can change its size and position. To specify the exact dimensions of the image: select the required image with the mouse, click the Image settings icon on the right sidebar, in the Size section, set the necessary Width and Height values. If the Constant proportions button is clicked (in this case it looks like this ), the width and height will be changed together preserving the original image aspect ratio. To restore the actual size of the added image, click the Actual Size button. To crop the image: Click the Crop button to activate cropping handles that appear on the image corners and in the center of each side. Manually drag the handles to set the cropping area. You can move the mouse cursor over the cropping area border so that it turns into the Arrow icon and drag the area. To crop a single side, drag the handle located in the center of this side. To simultaneously crop two adjacent sides, drag one of the corner handles. To equally crop two opposite sides of the image, hold down the Ctrl key when dragging the handle in the center of one of these sides. To equally crop all sides of the image, hold down the Ctrl key when dragging any of the corner handles. When the cropping area is specified, click the Crop button once again, or press the Esc key, or click anywhere outside of the cropping area to apply the changes. After the cropping area is selected, it's also possible to use the Crop to shape, Fill, and Fit options available from the Crop drop-down menu. Click the Crop button once again and select the option you need: If you select the Crop to shape option, the picture will fill a certain shape. You can select a shape from the gallery, which opens when you hover your mouse pointer over the Crop to Shape option. You can still use the Fill and Fit options to choose the way your picture matches the shape. If you select the Fill option, the central part of the original image will be preserved and used to fill the selected cropping area, while other parts of the image will be removed. If you select the Fit option, the image will be resized so that it fits the height or width of the cropping area. No parts of the original image will be removed, but empty spaces may appear within the selected cropping area. To return the image to its default pixel dimensions, click the Reset crop button. Opacity - use this section to set an Opacity level dragging the slider or entering the percent value manually. The default value is 100%. It corresponds to the full opacity. The 0% value corresponds to the full transparency. To rotate the image: select the required image with the mouse, click the Image settings icon on the right sidebar, in the Rotation section, click one of the buttons: to rotate the image by 90 degrees counterclockwise to rotate the image by 90 degrees clockwise to flip the image horizontally (left to right) to flip the image vertically (upside down) Alternatively, you can right-click the image and use the Rotate option from the contextual menu. To replace the inserted image, select the required image with the mouse, click the Image settings icon on the right sidebar, click the Replace Image button, choose the necessary option: From File, From Storage, or From URL and select the desired image. Alternatively, you can right-click the image and use the Replace image option from the contextual menu. The selected image will be replaced. When the image is selected, the Shape settings icon is also available on the right. You can click this icon to open the Shape settings tab on the right sidebar and adjust the shape Line type, size, color, and opacity, as well as change the shape type by selecting another shape from the Change Autoshape menu. The shape of the image will change correspondingly. On the Shape Settings tab, you can also use the Show shadow option to add a shadow to the image. Adjust the image advanced settings To change its advanced settings, click the image with the right mouse button and select the Image Advanced Settings option from the right-click menu or just click the Show advanced settings link on the right sidebar. The image properties window will open: The Rotation tab contains the following parameters: Angle - use this option to rotate the image by an exactly specified angle. Enter the necessary value measured in degrees into the field or adjust it using the arrows on the right. Flipped - check the Horizontally box to flip the image horizontally (left to right) or check the Vertically box to flip the image vertically (upside down). The Cell Snapping tab contains the following parameters: Move and size with cells - this option allows you to snap the image to the cell behind it. If the cell moves (e.g. if you insert or delete some rows/columns), the image will be moved together with the cell. If you increase or decrease the width or height of the cell, the image will change its size as well. Move but don't size with cells - this option allows you to snap the image to the cell behind it preventing the image from being resized. If the cell moves, the image will be moved together with the cell, but if you change the cell size, the image dimensions remain unchanged. Don't move or size with cells - this option allows you to prevent the image from being moved or resized if the cell position or size was changed. The Alternative Text tab allows you to specify the Title and the Description which will be read to people with vision or cognitive impairments to help them better understand what information the image contains. To delete the inserted image, click it and press the Delete key. Assign a Macro to an Image You can provide quick and easy access to a macro within a spreadsheet by assigning a macro to any image. Once you assign a macro, the image appears as a button control and you can run the macro whenever you click it. To assign a macro: Right-click the image to assign a macro to and choose the Assign Macro option from the drop-down menu. The Assign Macro dialogue will open Choose a macro from the list, or type in the macro name, and click OK to confirm."
    },
   {
        "id": "UsageInstructions/InsertSmartArt.htm", 
        "title": "Insert SmartArt objects", 
        "body": "SmartArt graphics are used to create a visual representation of a hierarchical structure by choosing a layout that fits best. Insert SmartArt objects or edit the ones added in third-party editors. To insert a SmartArt object, go to the Insert tab, click the SmartArt button, hover over one of the available layout styles, e.g., List or Process, choose one of the available layout types from the list appeared to the right of the highlighted menu item, you can save the SmartArt object as picture on your hard drive using the Save as picture option in the right-click menu. You can customize the SmartArt settings in the right panel: Please note that color, style and form type settings can be customized individually. Fill - use this section to select the SmartArt object fill. You can choose the following options: Color Fill - select this option to specify the solid color to fill the inner space of the selected SmartArt object. Gradient Fill - use this option to fill the shape with two or more fading colors. Customize your gradient fill with no constraints. Click the Shape settings icon to open the Fill menu on the right sidebar: Available menu options: Style - choose between Linear or Radial: Linear is used  when you need your colors to flow from left-to-right, top-to-bottom, or at any angle you chose in a single direction. The Direction preview window displays the selected gradient color, click the arrow to choose a preset gradient direction. Use Angle settings for a precise gradient angle. Radial is used to move from the center as it starts at a single point and emanates outward. Gradient Point is a specific point for transition from one color to another. Use the Add Gradient Point button or slider bar to add a gradient point. You can add up to 10 gradient points. Each next gradient point added will in no way affect the current gradient fill appearance. Use the Remove Gradient Point button to delete a certain gradient point. Use the slider bar to change the location of the gradient point or specify Position in percentage for precise location. To apply a color to a gradient point, click a point on the slider bar, and then click Color to choose the color you want. Picture or Texture - select this option to use an image or a predefined texture as the SmartArt object background. If you wish to use an image as a background for the SmartArt object, you can add an image From File by selecting it on your computer hard disc drive, From URL by inserting the appropriate URL address into the opened window, or From Storage by selecting the required image stored on your portal. If you wish to use a texture as a background for the SmartArt object, open the From Texture menu and select the necessary texture preset. Currently, the following textures are available: canvas, carton, dark fabric, grain, granite, grey paper, knit, leather, brown paper, papyrus, wood. In case the selected Picture has less or more dimensions than the SmartArt object has, you can choose the Stretch or Tile setting from the dropdown list. The Stretch option allows you to adjust the image size to fit the SmartArt object size so that it could fill the space completely. The Tile option allows you to display only a part of the bigger image keeping its original dimensions or repeat the smaller image keeping its original dimensions over the SmartArt object surface so that it could fill the space completely. Note: any selected Texture preset fills the space completely, but you can apply the Stretch effect if necessary. Pattern - select this option to fill the SmartArt object with a two-colored design composed of regularly repeated elements. Pattern - select one of the predefined designs from the menu. Foreground color - click this color box to change the color of the pattern elements. Background color - click this color box to change the color of the pattern background. No Fill - select this option if you don't want to use any fill. Line - use this section to change the width, color or type of the SmartArt object line. To change the line width, select one of the available options from the Size dropdown list. The available options are: 0.5 pt, 1 pt, 1.5 pt, 2.25 pt, 3 pt, 4.5 pt, 6 pt. Alternatively, select the No Line option if you don't want to use any line. To change the line color, click on the colored box below and select the necessary color. To change the line type, select the necessary option from the corresponding dropdown list (a solid line is applied by default, you can change it to one of the available dashed lines). To change the line opacity, enter the required value manually or use the corresponding slider bar. Show shadow - check this box to make the SmartArt object cast a shadow. Click the Show advanced settings link to open the advanced settings."
    },
   {
        "id": "UsageInstructions/InsertSparklines.htm", 
        "title": "Insert Sparklines", 
        "body": "Using Sparklines Sparkline is a small chart that fits into a cell to represent trends or variations of data. Sparklines have limited functionality compared with regular charts but are an excellent tool to quickly analyze your data and to create a concise visual representation. Sparkline size depends on the size of the cell, change cell width and length to adjust the size. After adding a sparkline, you can still type text or add conditional formatting into the cell. ONLYOFFICE Spreadsheet Editor offers three types of sparklines: Column is similar to a regular Column Chart. Line is similar to a regular Line Chart. Win/Loss is suitable for representing data that include both positive and negative values. Insert Sparklines To insert a Sparkline chart, select the data range to include in the sparkline, or click a blank cell where to place it, go to the Insert tab and click the Sparkline button on the top toolbar. Choose a sparkline that serves your purpose. The Create Sparklines window will open, click the Select data icon to specify the data range, and the location of the sparkline, click OK to confirm Edit and Format Sparklines After inserting a sparkline, you can customize and edit it. Click the cell with a sparkline to enable the Sparkline settings tab on the right sidebar. In the Type section, you can select one of the available sparkline types drop-down list: Column - this type is similar to a regular Column Chart. Line - this type is similar to a regular Line Chart. Win/Loss - this type is suitable for representing data that include both positive and negative values. In the Style section, you can select the style which suits you best from the Template drop-down list, the necessary Color for the sparkline, and the necessary Line Weight (available for the Line sparkline only) In the Show section, you can highlight or mark certain data in the sparkline: High Point – use it to highlight the maximum value. Low Point – use it to highlight the minimum value. Negative Point – use it to highlight negative values. First Point – use it to highlight the starting point in the data range. Last Point - use it to highlight the end point in the data range. Markers – is available for Line sparklines only, use it to enable a marker for all points. Click the down arrow in the color box to select a color for each point. If you need to make your sparkline more accurate and easier to read, click the Show advanced settings option to open the Sparkline – Advanced Settings window. The Type &amp Data tab allows you to change the sparkline Type and Style as well as specify the Hidden and Empty cells display settings: Show empty cells as - this option allows you to control how sparklines are displayed if some cells in a data range are empty. Select the necessary option from the list: Gaps - to display the sparkline with gaps in place of missing data, Zero - to display the sparkline as if the value in an empty cell was zero, Connect data points with line (available for the Line type only) - to ignore empty cells and display a connecting line between data points. Show data in hidden rows and columns - check this box if you want to include values from the hidden cells into sparklines. The Axis Options tab allows you to specify the following Horizontal/Vertical Axis parameters: In the Horizontal Axis section, the following parameters are available: Show axis - check this box to display the horizontal axis. If the source data contain negative values, this option helps to display them more vividly. Reverse order - check this box to display data in the reverse sequence. In the Vertical Axis section, the following parameters are available to define the Minimum/Maximum Value: Minimum/Maximum Value Auto for Each - this option is selected by default. It allows you to use own minimum/maximum values for each sparkline. The minimum/maximum values are taken from the separate data series that are used to plot each sparkline. The maximum value for each sparkline will be located at the top of the cell, and the minimum value will be at the bottom. Same for All - this option allows you to use the same minimum/maximum value for the entire sparkline group. The minimum/maximum values are taken from the whole data range that is used to plot the sparkline group. The maximum/minimum values for each sparkline will be scaled relative to the highest/lowest value within the range. If you select this option, it will be easier to compare several sparklines. Fixed - this option allows you to set a custom minimum/maximum value. The values which are lower or higher than the specified ones are not displayed in the sparklines. Clear Sparklines To delete sparklines, select the cell(s) with the sparkline(s) to be removed and right-click on it. Choose Sparklines from the drop-down menu and click Clear Selected Sparklines or Clear the Selected Sparkline Groups."
    },
   {
        "id": "UsageInstructions/InsertSymbols.htm", 
        "title": "Insert symbols and characters", 
        "body": "During working process in the Spreadsheet Editor, you may need to insert a symbol that is not on your keyboard. To insert such symbols into your spreadsheet, use the Insert symbol option and follow these simple steps: Place the cursor where a special symbol should be inserted. Switch to the Insert tab of the top toolbar. Click the Symbol icon. Click the More symbols option. The Symbol dialog box will appear, and you will be able to select the required symbol, Use the Range section to quickly find the necessary symbol. All symbols are divided into specific groups, for example, select 'Currency Symbols' if you want to insert a currency character. If the required character is not in the set, select a different font. Many of them also have characters that differ from the standard set. You can also enter the Unicode hex value of the required symbol into the Unicode hex value field. This code can be found in the Character map. You can also use the Special characters tab to choose a special character from the list. The previously used symbols are also displayed in the Recently used symbols field. Click Insert. The selected character will be added to the spreadsheet. To insert a popular or recently used symbol, click the arrow below the Symbol icon. The most recent symbols will appear at the beginning of the list. Insert ASCII symbols The ASCII table is also used to add characters. To do this, hold down the ALT key and use the numeric keypad to enter the character code. Note: be sure to use the numeric keypad, not the numbers on the main keyboard. To enable the numeric keypad, press the Num Lock key. For example, to add a paragraph character (§), press and hold down ALT while typing 789, and then release the ALT key. Insert symbols using the Unicode table Additional characters and symbols can also be found in the Windows symbol table. To open this table, do the following: in the Search field, write 'Character table' and open it, simultaneously press Win+R, and then in the following window type charmap.exe and click OK. In the opened Character Map, select one of the Character sets, Groups, and Fonts. Next, click on the required characters, copy them to the clipboard, and paste where necessary."
    },
   {
        "id": "UsageInstructions/InsertTextObjects.htm", 
        "title": "Insert text objects", 
        "body": "In the Spreadsheet Editor, you can draw attention to a specific part of the spreadsheet, for this, insert a text box (a rectangular frame that allows you to enter the text within it) or a Text Art object (a text box with a predefined font style and color that allows you to apply some text effects). Add a text object You can add a text object anywhere in the worksheet. To do that: switch to the Insert tab of the top toolbar, select the necessary text object type: to add a text box, click the Text Box icon on the top toolbar, then click where the text box should be inserted, hold the mouse button, and drag the text box border to specify its size. When you release the mouse button, the insertion point will appear in the added text box, and you will be able to enter your text. It's also possible to insert a text box by clicking the Shape icon on the top toolbar and selecting the Insert Text autoshape from the Basic Shapes group. to add a Text Art object, click the Text Art icon on the top toolbar, then click on the desired style template – the Text Art object will be added in the center of the worksheet. Select the default text within the text box with the mouse and replace it with your own text. click outside of the text object to apply the changes and return to the worksheet. The text within the text object is a part of the latter (when you move or rotate the text object, the text moves or rotates with it). As an inserted text object represents a rectangular frame with text in it (Text Art objects have invisible text box borders by default) and this frame is a common autoshape, you can change both the shape and text properties. You can save the text object as a picture on your hard drive using the Save as picture option in the right-click menu. To delete the added text object, click on the text box border and press the Delete key on the keyboard. The text within the text box will also be deleted. Format a text box Select the text box by clicking on its border to change its properties. When the text box is selected, its borders are displayed as solid (not dashed) lines. to manually resize, move, rotate the text box, use the special handles on the edges of the shape. to edit the text box fill, line, replace the rectangular box with a different shape, or access the shape advanced settings, click the Shape settings icon on the right sidebar and use the corresponding options. to arrange text boxes as related to other objects, align several text boxes as related to each other, rotate or flip a text box, right-click on the text box border, and use the contextual menu options. To learn more on how to arrange and align objects, please refer to this page. to create columns of text within the text box, right-click on the text box border, click the Shape Advanced Settings option, and switch to the Columns tab in the Shape - Advanced Settings window. Format the text within the text box Click the text within the text box to change its properties. When the text is selected, the text box borders are displayed as dashed lines. It's also possible to change text formatting when the text box (not the text itself) is selected. In such a case, any changes will be applied to all the text within the text box. Some font formatting options (font type, size, color, and decoration styles) can be applied to a previously selected portion of the text separately. Adjust the font formatting settings (change the font type, size, color and apply decoration styles) using the corresponding icons situated on the Home tab of the top toolbar. Some additional font settings can be also changed on the Font tab of the paragraph properties window. To access it, right-click the text in the text box and select the Paragraph Advanced Settings option. Align the text horizontally within the text box by using the corresponding icons situated on the Home tab of the top toolbar or in the Paragraph - Advanced Settings window. Align the text vertically within the text box by using the corresponding icons situated on the Home tab of the top toolbar. You can also right-click the text, select the Vertical Alignment option and then choose one of the available options: Align Top, Align Center, or Align Bottom. Rotate the text within the text box. To do that, right-click the text, select the Text Direction option and then choose one of the available options: Horizontal (is selected by default), Rotate Text Down (sets a vertical direction, from top to bottom), or Rotate Text Up (sets a vertical direction, from bottom to top). Create a bulleted or numbered list. To do that, right-click the text, select the Bullets and Numbering option from the contextual menu, and then choose one of the available bullet characters or numbering styles. The List Settings option allows you to open the List Settings window where you can adjust the settings for a corresponding list type: Type (bulleted) - allows you to select the necessary character for the bulleted list. When you click the New bullet option, the Symbol window will open, and you will be able to choose one of the available characters. To learn more about how to work with symbols, please refer to this article. When you click the New image option, a new Import field appears where you can choose new images for bullets From File, From URL, or From Storage. Type (numbered) - allows you to select the necessary format for the numbered list. Size - allows you to select the necessary bullet/number size depending on the current size of the text. The value can vary from 25% up to 400%. Color - allows you to select the necessary bullet/number color. You can select one of the theme colors, or standard colors on the palette, or specify a custom color. Start at - allows you to set the necessary numeric value you want to start numbering with. Insert a hyperlink. Set line and paragraph spacing for the multi-line text within the text box by using the Paragraph settings tab of the right sidebar that will open if you click the Paragraph settings icon. Set the line height for the text lines within the paragraph as well as the margins between the current and the previous or the following paragraph. Line Spacing - set the line height for the text lines within the paragraph. You can select among two options: multiple (sets line spacing that can be expressed in numbers greater than 1), exactly (sets fixed line spacing). You can specify the necessary value in the field on the right. Paragraph Spacing - set the amount of space between paragraphs. Before - set the amount of space before the paragraph. After - set the amount of space after the paragraph. These parameters can also be found in the Paragraph - Advanced Settings window. Adjust paragraph advanced settings Change the advanced settings of the paragraph (you can adjust paragraph indents and tab stops for the multi-line text within the text box and apply some font formatting settings). Put the cursor within the required paragraph - the Paragraph settings tab will be activated on the right sidebar. Click the Show advanced settings link. It's also possible to right-click the text in a text box and use the Paragraph Advanced Settings item from the contextual menu. The paragraph properties window will be opened: The Indents & Spacing tab allows you to: change the alignment type for the paragraph text, change the paragraph indents as related to the internal margins of the text box, Left - set the paragraph offset from the left internal margin of the text box specifying the necessary numeric value, Right - set the paragraph offset from the right internal margin of the text box specifying the necessary numeric value, Special - set an indent for the first line of the paragraph: select the corresponding menu item ((none), First line, Hanging) and change the default numeric value specified for First Line or Hanging, change the paragraph line spacing. The Font tab contains the following parameters: Strikethrough is used to make the text struck out with a line going through the letters. Double strikethrough is used to make the text struck out with a double line going through the letters. Superscript is used to make the text smaller and place it to the upper part of the text line, e.g. as in fractions. Subscript is used to make the text smaller and place it to the lower part of the text line, e.g. as in chemical formulas. Small caps is used to make all letters lowercase. All caps is used to make all letters upper case. Character Spacing is used to set the space between the characters. Increase the default value to apply the Expanded spacing, or decrease the default value to apply the Condensed spacing. Use the arrow buttons or enter the necessary value in the box. All the changes will be displayed in the preview field below. The Tab tab allows you to change tab stops i.e. the position the cursor advances to when you press the Tab key on the keyboard. Default Tab is set at 2.54 cm. You can decrease or increase this value using the arrow buttons or enter the necessary value in the box. Tab Position - is used to set custom tab stops. Enter the necessary value in this box, adjust it more precisely using the arrow buttons, and click the Specify button. Your custom tab position will be added to the list in the field below. Alignment - is used to set the necessary alignment type for each of the tab positions in the list above. Select the necessary tab position in the list, choose the Left, Center or Right option in the Alignment drop-down list and click the Specify button. Left - lines up your text to the left side at the tab stop position; the text moves to the right from the tab stop while you type. Center - centers the text at the tab stop position. Right - lines up your text to the right side at the tab stop position; the text moves to the left from the tab stop while you type. To delete tab stops from the list select a tab stop and click the Remove or Remove All button. Assign a Macro to a Text Box You can provide quick and easy access to a macro within a spreadsheet by assigning a macro to any text box. Once you assign a macro, the text box appears as a button control and you can run the macro whenever you click it. To assign a macro: Right-click the text box to assign a macro to and choose the Assign Macro option from the drop-down menu. The Assign Macro dialogue will open Choose a macro from the list, or type in the macro name, and click OK to confirm. Edit a Text Art style Select a text object and click the Text Art settings icon on the right sidebar. Change the applied text style by selecting a new Template from the gallery. You can also change the basic style additionally by selecting a different font type, size, etc. Change the font fill and line. The available options are the same as the ones for autoshapes. Apply a text effect by selecting the necessary text transformation type from the Transform gallery. You can adjust the degree of text distortion by dragging the pink diamond-shaped handle."
    },
   {
        "id": "UsageInstructions/ManageSheets.htm", 
        "title": "Manage sheets", 
        "body": "By default, a newly created spreadsheet has a single sheet. The simplest way to add a new sheet into the Spreadsheet Editor is to click the Plus button located to the right of the Sheet Navigation buttons in the left lower corner. Another way to add a new sheet is to: right-click the sheet tab after which you wish to insert a new one, select the Insert option from the right-click menu. A new sheet will be inserted after the selected one. To activate the required sheet, use the sheet tabs in the left lower corner of each spreadsheet. Note: if you have a lot of sheets, you can find the necessary one by using the Sheet Navigation buttons situated in the left lower corner. To delete an unnecessary sheet: right-click the sheet tab you wish to delete, select the Delete option from the right-click menu. The selected sheet will be deleted from the current spreadsheet. To rename an existing sheet: right-click the sheet tab you wish to rename, select the Rename option from the right-click menu, enter the Sheet Name in the dialog box and click OK. The selected sheet name will be changed. To copy an existing sheet: right-click the sheet tab you wish to copy, select the Copy option from the right-click menu, select the sheet before which you wish to insert the copied one or use the Copy to end option to insert the copied sheet after all the existing ones, click the OK button to confirm your choice. or press and hold down the CTRL key and drag the sheet tab to the right to duplicate it and move the copy to the location you need. The selected sheet will be copied and inserted in the selected place. To move an existing sheet: right-click the sheet tab you wish to move, select the Move or copy option from the right-click menu, select the required workbook using the Spreadsheet drop-down menu, select the sheet before which you wish to insert the selected one, or use the Move to end option to move the selected sheet after all the existing ones, mark the Create a copy checkbox if you want to create a copy of the moved sheet, click the OK button to confirm your choice. Or simply drag the necessary sheet tab and drop it to a new location. The selected sheet will be moved. You can also manually drag'n'drop a sheet from one book to another. To do this, select the sheet you want to move and drag it to the sheet bar of another book. For example, you can drag a sheet from the online editor book to the desktop one: In this case, the sheet from the original spreadsheet will be deleted. Currently, it's not possible to drag'n'drop sheets to a new workbook in Desktop Editors on Linux. If you have a lot of sheets, you can hide some of them you don't need to facilitate your work. To do that, right-click the sheet tab you wish to hide, select the Hide option from the right-click menu, To display the hidden sheet tab, right-click any sheet tab, open the Hidden list and select the sheet tab you wish to display. To differentiate the sheets, you can assign different colors to the sheet tabs. To do that, right-click the sheet tab you wish to color, select the Tab Color option from the right-click menu, select any color in the available palettes Theme Colors - the colors that correspond to the selected color scheme of the spreadsheet. Standard Colors - the default colors set. Custom Color - click this caption if there is no needed color in the available palettes. Select the necessary color range moving the vertical color slider and set the specific color by dragging the color picker within the large square color field. Once you select a color with the color picker, the appropriate RGB and sRGB color values will be displayed in the fields on the right. You can also specify a color on the base of the RGB color model by entering the necessary numeric values into the R, G, B (red, green, blue) fields or enter the sRGB hexadecimal code into the field marked with the # sign. The selected color will appear in the New preview box. If the object was previously filled with any custom color, this color is displayed in the Current box, so you can compare the original and modified colors. When the color is specified, click the Add button: The custom color will be applied to the selected tab and added to the Custom color palette. You can work with multiple sheets simultaneously: select the first sheet you want to include into the group, press and hold the Shift key to select several adjacent sheets you want to group, or use the Ctrl key to select several non-adjacent sheets you want to group, right-click one of the selected sheets tab to open the contextual menu, choose the necessary option from the menu: Insert - to insert the same number of new blank sheets, as in the selected group, Delete - to delete all the selected sheets at once (you cannot delete all sheets in the workbook, as the workbook must contain at least one visible sheet), Rename - this option can be applied to each separate sheet only, Copy - to create copies of all the selected sheets at once and paste them to the selected place, Move - to move all the selected sheets at once and paste them to the selected place, Hide - to hide all the selected sheets at once (you cannot hide all sheets in the workbook, as the workbook must contain at least one visible sheet), Tab color - to assign the same color to all the selected sheet tabs at once, Select All Sheets - to select all the sheets in the current workbook, Ungroup Sheets - to ungroup the selected sheets. it's also possible to ungroup sheets by double-clicking on a sheet which is included into the group, or by clicking any sheet which is not included into the group."
    },
   {
        "id": "UsageInstructions/ManipulateObjects.htm", 
        "title": "Manipulate objects", 
        "body": "In the Spreadsheet Editor, you can resize, move, rotate and arrange autoshapes, images and charts inserted into your worksheet. Note: the list of keyboard shortcuts that can be used when working with objects is available here. Resize objects To change the size of an autoshape/image/chart, drag small squares situated on the edges of the object. To maintain the original proportions of the selected object while resizing, hold down the Shift key and drag one of the corner icons. Note: to resize the inserted chart or image you can also use the right sidebar that will be activated once you select the necessary object. To open it, click the Chart settings or the Image settings icon to the right. Move objects To change the position of an autoshape/image/chart, use the Arrow icon that appears after hovering the mouse cursor over the object. Drag the object to the necessary position without releasing the mouse button. To move the object by one-pixel increments, hold down the Ctrl key and use the keybord arrows. To move the object strictly horizontally/vertically and prevent it from moving in a perpendicular direction, hold down the Shift key when dragging. Rotate objects To manually rotate the autoshape/image, hover the mouse cursor over the rotation handle and drag it clockwise or counterclockwise. To constrain the rotation angle to 15 degree increments, hold down the Shift key while rotating. To rotate a shape or image by 90 degrees counterclockwise/clockwise or flip the object horizontally/vertically you can use the Rotation section of the right sidebar that will be activated once you select the necessary object. To open it, click the Shape settings icon or the Image settings icon to the right. Click one of the buttons: to rotate the object by 90 degrees counterclockwise to rotate the object by 90 degrees clockwise to flip the object horizontally (left to right) to flip the object vertically (upside down) It's also possible to right-click the image or shape, choose the Rotate option from the contextual menu and then use one of the available rotation options. To rotate a shape or image by an exactly specified angle, click the Show advanced settings link on the right sidebar and use the Rotation tab of the Advanced Settings window. Specify the necessary value measured in degrees in the Angle field and click OK. Reshape autoshapes When modifying some shapes, for example Figured arrows or Callouts, the yellow diamond-shaped icon is also available. It allows you to adjust some aspects of the shape, for example, the length of the head of an arrow. To reshape an autoshape, you can also use the Edit Points option from the context menu. The Edit Points option is used to customize or to change the curvature of your shape. To activate a shape’s editable anchor points, right-click the shape and choose Edit Points from the menu. The black squares that become active are the points where two lines meet, and the red line outlines the shape. Click and drag it to reposition the point, and to change the shape outline. Once you click the anchor point, two blue lines with white squares at the ends will appear. These are Bezier handles that allow you to create and a curve and to change a curve’s smoothness. As long as the anchor points are active, you can add and delete them: To add a point to a shape, hold Ctrl and click the position where you want to add an anchor point. To delete a point, hold Ctrl and click the unnecessary point. Align objects To align two or more selected objects in relation to each other, hold down the Ctrl key while selecting the objects with the mouse, then click the Align icon on the Layout tab of the top toolbar and select the necessary alignment type from the list: Align Left - to align objects relative to each other to the left edge of the leftmost object, Align Center - to align objects relative to each other in the center, Align Right - to align objects relative to each other to the right edge of the rightmost object, Align Top - to align objects relative to each other to the top edge of the topmost object, Align Middle - to align objects relative to each other in the middle, Align Bottom - to align objects relative to each other to the bottom edge of the bottommost object. Alternatively, you can right-click the selected objects, choose the Align option from the contextual menu and then use one of the available alignment options. Note: the alignment options are disabled if you select less than two objects. Distribute objects To distribute three or more selected objects horizontally or vertically between two outermost selected objects so that there is equal distance between them, click the Align icon on the Layout tab of the top toolbar and select the necessary distribution type from the list: Distribute Horizontally - to distribute objects evenly between the leftmost and rightmost selected objects. Distribute Vertically - to distribute objects evenly between the topmost and bottommost selected objects. Alternatively, you can right-click the selected objects, choose the Align option from the contextual menu and then use one of the available distribution options. Note: the distribution options are disabled if you select less than three objects. Group several objects To manipulate several objects at once, you can group them. Hold down the Ctrl key while selecting the objects with the mouse, then click the arrow next to the Group icon on the Layout tab of the top toolbar and select the necessary option from the list: Group - to combine several objects into a group so that they can be simultaneously rotated, moved, resized, aligned, arranged, copied, pasted, formatted like a single object. Ungroup - to ungroup the selected group of the previously combined objects. Alternatively, you can right-click the selected objects, choose the Arrange option from the contextual menu and then use the Group or Ungroup option. Note: the Group option is disabled if you select less than two objects. The Ungroup option is available only when a group of the previously combined objects is selected. Arrange several objects To arrange the selected object or several objects (e.g. to change their order when several objects overlap each other), you can use the Bring Forward and Send Backward icons on the Layout tab of the top toolbar and select the necessary arrangement type from the list. To move the selected object(s) forward, click the arrow next to the Bring Forward icon on the Layout tab of the top toolbar and select the necessary arrangement type from the list: Bring To Foreground - to move the object(s) in front of all other objects, Bring Forward - to move the selected object(s) by one level forward as related to other objects. To move the selected object(s) backward, click the arrow next to the Send Backward icon on the Layout tab of the top toolbar and select the necessary arrangement type from the list: Send To Background - to move the object(s) behind all other objects, Send Backward - to move the selected object(s) by one level backward as related to other objects. Alternatively, you can right-click the selected object(s), choose the Arrange option from the contextual menu and then use one of the available arrangement options. Boolean operations on shapes To access the logical operations on shapes, select the Merge shapes menu item in the context menu. The Boolean operations include the following: Union - the shapes will be united into one group and share one area. Combine - the shapes will be united into one group, but the shared area will be highlighted. Fragment - the shapes will be united into one group, but the shared area will be outlined. Intersect - creates a new shape from the areas where the selected shapes overlap. Subtract - removes the area of a shape from the one underneath it."
    },
   {
        "id": "UsageInstructions/MathAutoCorrect.htm", 
        "title": "AutoCorrect Features", 
        "body": "The AutoCorrect features in ONLYOFFICE Spreadsheet Editor are used to automatically format text when detected or insert special math symbols by recognizing particular character usage. The available AutoCorrect options are listed in the corresponding dialog box. To access it, go to the File tab -> Advanced Settings -> Spell Checking -> Proofing -> AutoCorrect Options. The AutoCorrect dialog box consists of three tabs: Math Autocorrect, Recognized Functions, and AutoFormat As You Type. Math AutoCorrect When working with equations, you can insert a lot of symbols, accents, and mathematical operation signs typing them on the keyboard instead of choosing a template from the gallery. In the equation editor, place the insertion point within the necessary placeholder, type a math autocorrect code, then press Spacebar. The entered code will be converted into the corresponding symbol, and the space will be eliminated. Note: The codes are case sensitive. You can add, modify, restore, and remove autocorrect entries from the AutoCorrect list. Go to the File tab -> Advanced Settings -> Spell Checking -> Proofing -> AutoCorrect Options -> Math AutoCorrect. Adding an entry to the AutoCorrect list Enter the autocorrect code you want to use in the Replace box. Enter the symbol to be assigned to the code you entered in the By box. Click the Add button. Modifying an entry on the AutoCorrect list Select the entry to be modified. You can change the information in both fields: the code in the Replace box or the symbol in the By box. Click the Replace button. Removing entries from the AutoCorrect list Select an entry to remove from the list. Click the Delete button. To restore the previously deleted entries, select the entry to be restored from the list and click the Restore button. Use the Reset to default button to restore default settings. Any autocorrect entry you added will be removed and the changed ones will be restored to their original values. To disable Math AutoCorrect and to avoid automatic changes and replacements, uncheck the Replace text as you type box. The table below contains all the currently supported codes available in the Spreadsheet Editor. The full list of the supported codes can also be found on the File tab in the Advanced Settings... -> Spell Checking -> Proofing section. The supported codes Code Symbol Category !! Symbols ... Dots :: Operators := Operators /< Relational operators /> Relational operators /= Relational operators \\above Above/Below scripts \\acute Accents \\aleph Hebrew letters \\alpha Greek letters \\Alpha Greek letters \\amalg Binary operators \\angle Geometry notation \\aoint Integrals \\approx Relational operators \\asmash Arrows \\ast Binary operators \\asymp Relational operators \\atop Operators \\bar Over/Underbar \\Bar Accents \\because Relational operators \\begin Delimiters \\below Above/Below scripts \\bet Hebrew letters \\beta Greek letters \\Beta Greek letters \\beth Hebrew letters \\bigcap Large operators \\bigcup Large operators \\bigodot Large operators \\bigoplus Large operators \\bigotimes Large operators \\bigsqcup Large operators \\biguplus Large operators \\bigvee Large operators \\bigwedge Large operators \\binomial Equations \\bot Logic notation \\bowtie Relational operators \\box Symbols \\boxdot Binary operators \\boxminus Binary operators \\boxplus Binary operators \\bra Delimiters \\break Symbols \\breve Accents \\bullet Binary operators \\cap Binary operators \\cbrt Square roots and radicals \\cases Symbols \\cdot Binary operators \\cdots Dots \\check Accents \\chi Greek letters \\Chi Greek letters \\circ Binary operators \\close Delimiters \\clubsuit Symbols \\coint Integrals \\cong Relational operators \\coprod Math operators \\cup Binary operators \\dalet Hebrew letters \\daleth Hebrew letters \\dashv Relational operators \\dd Double-struck letters \\Dd Double-struck letters \\ddddot Accents \\dddot Accents \\ddot Accents \\ddots Dots \\defeq Relational operators \\degc Symbols \\degf Symbols \\degree Symbols \\delta Greek letters \\Delta Greek letters \\Deltaeq Operators \\diamond Binary operators \\diamondsuit Symbols \\div Binary operators \\dot Accents \\doteq Relational operators \\dots Dots \\doublea Double-struck letters \\doubleA Double-struck letters \\doubleb Double-struck letters \\doubleB Double-struck letters \\doublec Double-struck letters \\doubleC Double-struck letters \\doubled Double-struck letters \\doubleD Double-struck letters \\doublee Double-struck letters \\doubleE Double-struck letters \\doublef Double-struck letters \\doubleF Double-struck letters \\doubleg Double-struck letters \\doubleG Double-struck letters \\doubleh Double-struck letters \\doubleH Double-struck letters \\doublei Double-struck letters \\doubleI Double-struck letters \\doublej Double-struck letters \\doubleJ Double-struck letters \\doublek Double-struck letters \\doubleK Double-struck letters \\doublel Double-struck letters \\doubleL Double-struck letters \\doublem Double-struck letters \\doubleM Double-struck letters \\doublen Double-struck letters \\doubleN Double-struck letters \\doubleo Double-struck letters \\doubleO Double-struck letters \\doublep Double-struck letters \\doubleP Double-struck letters \\doubleq Double-struck letters \\doubleQ Double-struck letters \\doubler Double-struck letters \\doubleR Double-struck letters \\doubles Double-struck letters \\doubleS Double-struck letters \\doublet Double-struck letters \\doubleT Double-struck letters \\doubleu Double-struck letters \\doubleU Double-struck letters \\doublev Double-struck letters \\doubleV Double-struck letters \\doublew Double-struck letters \\doubleW Double-struck letters \\doublex Double-struck letters \\doubleX Double-struck letters \\doubley Double-struck letters \\doubleY Double-struck letters \\doublez Double-struck letters \\doubleZ Double-struck letters \\downarrow Arrows \\Downarrow Arrows \\dsmash Arrows \\ee Double-struck letters \\ell Symbols \\emptyset Set notations \\emsp Space characters \\end Delimiters \\ensp Space characters \\epsilon Greek letters \\Epsilon Greek letters \\eqarray Symbols \\equiv Relational operators \\eta Greek letters \\Eta Greek letters \\exists Logic notations \\forall Logic notations \\fraktura Fraktur letters \\frakturA Fraktur letters \\frakturb Fraktur letters \\frakturB Fraktur letters \\frakturc Fraktur letters \\frakturC Fraktur letters \\frakturd Fraktur letters \\frakturD Fraktur letters \\frakture Fraktur letters \\frakturE Fraktur letters \\frakturf Fraktur letters \\frakturF Fraktur letters \\frakturg Fraktur letters \\frakturG Fraktur letters \\frakturh Fraktur letters \\frakturH Fraktur letters \\frakturi Fraktur letters \\frakturI Fraktur letters \\frakturk Fraktur letters \\frakturK Fraktur letters \\frakturl Fraktur letters \\frakturL Fraktur letters \\frakturm Fraktur letters \\frakturM Fraktur letters \\frakturn Fraktur letters \\frakturN Fraktur letters \\frakturo Fraktur letters \\frakturO Fraktur letters \\frakturp Fraktur letters \\frakturP Fraktur letters \\frakturq Fraktur letters \\frakturQ Fraktur letters \\frakturr Fraktur letters \\frakturR Fraktur letters \\frakturs Fraktur letters \\frakturS Fraktur letters \\frakturt Fraktur letters \\frakturT Fraktur letters \\frakturu Fraktur letters \\frakturU Fraktur letters \\frakturv Fraktur letters \\frakturV Fraktur letters \\frakturw Fraktur letters \\frakturW Fraktur letters \\frakturx Fraktur letters \\frakturX Fraktur letters \\fraktury Fraktur letters \\frakturY Fraktur letters \\frakturz Fraktur letters \\frakturZ Fraktur letters \\frown Relational operators \\funcapply Binary operators \\G Greek letters \\gamma Greek letters \\Gamma Greek letters \\ge Relational operators \\geq Relational operators \\gets Arrows \\gg Relational operators \\gimel Hebrew letters \\grave Accents \\hairsp Space characters \\hat Accents \\hbar Symbols \\heartsuit Symbols \\hookleftarrow Arrows \\hookrightarrow Arrows \\hphantom Arrows \\hsmash Arrows \\hvec Accents \\identitymatrix Matrices \\ii Double-struck letters \\iiint Integrals \\iint Integrals \\iiiint Integrals \\Im Symbols \\imath Symbols \\in Relational operators \\inc Symbols \\infty Symbols \\int Integrals \\integral Integrals \\iota Greek letters \\Iota Greek letters \\itimes Math operators \\j Symbols \\jj Double-struck letters \\jmath Symbols \\kappa Greek letters \\Kappa Greek letters \\ket Delimiters \\lambda Greek letters \\Lambda Greek letters \\langle Delimiters \\lbbrack Delimiters \\lbrace Delimiters \\lbrack Delimiters \\lceil Delimiters \\ldiv Fraction slashes \\ldivide Fraction slashes \\ldots Dots \\le Relational operators \\left Delimiters \\leftarrow Arrows \\Leftarrow Arrows \\leftharpoondown Arrows \\leftharpoonup Arrows \\leftrightarrow Arrows \\Leftrightarrow Arrows \\leq Relational operators \\lfloor Delimiters \\lhvec Accents \\limit Limits \\ll Relational operators \\lmoust Delimiters \\Longleftarrow Arrows \\Longleftrightarrow Arrows \\Longrightarrow Arrows \\lrhar Arrows \\lvec Accents \\mapsto Arrows \\matrix Matrices \\medsp Space characters \\mid Relational operators \\middle Symbols \\models Relational operators \\mp Binary operators \\mu Greek letters \\Mu Greek letters \\nabla Symbols \\naryand Operators \\nbsp Space characters \\ne Relational operators \\nearrow Arrows \\neq Relational operators \\ni Relational operators \\norm Delimiters \\notcontain Relational operators \\notelement Relational operators \\notin Relational operators \\nu Greek letters \\Nu Greek letters \\nwarrow Arrows \\o Greek letters \\O Greek letters \\odot Binary operators \\of Operators \\oiiint Integrals \\oiint Integrals \\oint Integrals \\omega Greek letters \\Omega Greek letters \\ominus Binary operators \\open Delimiters \\oplus Binary operators \\otimes Binary operators \\over Delimiters \\overbar Accents \\overbrace Accents \\overbracket Accents \\overline Accents \\overparen Accents \\overshell Accents \\parallel Geometry notation \\partial Symbols \\pmatrix Matrices \\perp Geometry notation \\phantom Symbols \\phi Greek letters \\Phi Greek letters \\pi Greek letters \\Pi Greek letters \\pm Binary operators \\pppprime Primes \\ppprime Primes \\pprime Primes \\prec Relational operators \\preceq Relational operators \\prime Primes \\prod Math operators \\propto Relational operators \\psi Greek letters \\Psi Greek letters \\qdrt Square roots and radicals \\quadratic Square roots and radicals \\rangle Delimiters \\Rangle Delimiters \\ratio Relational operators \\rbrace Delimiters \\rbrack Delimiters \\Rbrack Delimiters \\rceil Delimiters \\rddots Dots \\Re Symbols \\rect Symbols \\rfloor Delimiters \\rho Greek letters \\Rho Greek letters \\rhvec Accents \\right Delimiters \\rightarrow Arrows \\Rightarrow Arrows \\rightharpoondown Arrows \\rightharpoonup Arrows \\rmoust Delimiters \\root Symbols \\scripta Scripts \\scriptA Scripts \\scriptb Scripts \\scriptB Scripts \\scriptc Scripts \\scriptC Scripts \\scriptd Scripts \\scriptD Scripts \\scripte Scripts \\scriptE Scripts \\scriptf Scripts \\scriptF Scripts \\scriptg Scripts \\scriptG Scripts \\scripth Scripts \\scriptH Scripts \\scripti Scripts \\scriptI Scripts \\scriptk Scripts \\scriptK Scripts \\scriptl Scripts \\scriptL Scripts \\scriptm Scripts \\scriptM Scripts \\scriptn Scripts \\scriptN Scripts \\scripto Scripts \\scriptO Scripts \\scriptp Scripts \\scriptP Scripts \\scriptq Scripts \\scriptQ Scripts \\scriptr Scripts \\scriptR Scripts \\scripts Scripts \\scriptS Scripts \\scriptt Scripts \\scriptT Scripts \\scriptu Scripts \\scriptU Scripts \\scriptv Scripts \\scriptV Scripts \\scriptw Scripts \\scriptW Scripts \\scriptx Scripts \\scriptX Scripts \\scripty Scripts \\scriptY Scripts \\scriptz Scripts \\scriptZ Scripts \\sdiv Fraction slashes \\sdivide Fraction slashes \\searrow Arrows \\setminus Binary operators \\sigma Greek letters \\Sigma Greek letters \\sim Relational operators \\simeq Relational operators \\smash Arrows \\smile Relational operators \\spadesuit Symbols \\sqcap Binary operators \\sqcup Binary operators \\sqrt Square roots and radicals \\sqsubseteq Set notation \\sqsuperseteq Set notation \\star Binary operators \\subset Set notation \\subseteq Set notation \\succ Relational operators \\succeq Relational operators \\sum Math operators \\superset Set notation \\superseteq Set notation \\swarrow Arrows \\tau Greek letters \\Tau Greek letters \\therefore Relational operators \\theta Greek letters \\Theta Greek letters \\thicksp Space characters \\thinsp Space characters \\tilde Accents \\times Binary operators \\to Arrows \\top Logic notation \\tvec Arrows \\ubar Accents \\Ubar Accents \\underbar Accents \\underbrace Accents \\underbracket Accents \\underline Accents \\underparen Accents \\uparrow Arrows \\Uparrow Arrows \\updownarrow Arrows \\Updownarrow Arrows \\uplus Binary operators \\upsilon Greek letters \\Upsilon Greek letters \\varepsilon Greek letters \\varphi Greek letters \\varpi Greek letters \\varrho Greek letters \\varsigma Greek letters \\vartheta Greek letters \\vbar Delimiters \\vdash Relational operators \\vdots Dots \\vec Accents \\vee Binary operators \\vert Delimiters \\Vert Delimiters \\Vmatrix Matrices \\vphantom Arrows \\vthicksp Space characters \\wedge Binary operators \\wp Symbols \\wr Binary operators \\xi Greek letters \\Xi Greek letters \\zeta Greek letters \\Zeta Greek letters \\zwnj Space characters \\zwsp Space characters ~= Relational operators -+ Binary operators +- Binary operators << Relational operators <= Relational operators -> Arrows >= Relational operators >> Relational operators Recognized Functions In this tab, you will find the list of math expressions that will be recognized by the Equation editor as functions and therefore will not be automatically italicized. For the list of recognized functions go to the File tab -> Advanced Settings -> Spell Checking -> Proofing -> AutoCorrect Options -> Recognized Functions. To add an entry to the list of recognized functions, enter the function in the blank field and click the Add button. To remove an entry from the list of recognized functions, select the function to be removed and click the Delete button. To restore the previously deleted entries, select the entry to be restored from the list and click the Restore button. Use the Reset to default button to restore default settings. Any function you added will be removed and the removed ones will be restored. AutoFormat As You Type By default, the editor replace all network and internet paths with hyperlinks right as you enter new data in the cells. The editor also automatically includes new rows and columns in the formatted table when you enter new data in the row below the table or in the column next to it. If you need to disable auto-formatting presets, uncheck the box for the unnecessary options, go to the File tab -> Advanced Settings -> Spell Checking -> Proofing -> AutoCorrect Options -> AutoFormat As You Type."
    },
   {
        "id": "UsageInstructions/MergeCells.htm", 
        "title": "Merge cells", 
        "body": "If you need to merge cells to position your text better (e.g., the name of the table or a long text fragment within the table), use the Merge tool of ONLYOFFICE Spreadsheet Editor. Type 1. Merge and Align Center Click on the cell at the beginning of the needed range, hold the left mouse button, and drag until you select the cell range you need. The selected cells must be adjacent. Only the data in the upper-left cell of the selected range will remain in the merged cell. Data in other cells of the selected range will be deleted. Go to the Home tab and click on the Merge and center icon . Type 2. Merge Across Click on the cell at the beginning of the needed range, hold the left mouse button, and drag until you select the cell range you need. Go to the Home tab and click on the arrow next to the Merge and center icon to open a drop-down menu. Choose the Merge Across option to align the text left and preserve the rows without merging them. Type 3. Merge Cells Click on the cell at the beginning of the needed range, hold the left mouse button, and drag until you select the cell range you need. Go to the Home tab and click on the arrow next to the Merge and center icon to open a drop-down menu. Choose the Merge Cells option to preserve the preset alignment. Unmerge Cells Click on the merged area. Go to the Home tab and click on the arrow next to the Merge and center icon to open a drop-down menu. Choose the Unmerge Cells option to bring the cells back to their original state."
    },
   {
        "id": "UsageInstructions/OpenCreateNew.htm", 
        "title": "Create a new spreadsheet or open an existing one", 
        "body": "In the Spreadsheet Editor, you can open a recently edited spreadsheet, rename it, create a new one, or return to the list of existing spreadsheets. To create a new spreadsheet In the online editor click the File tab on the top toolbar, select the Create New option. In the desktop editor in the main program window, select the Spreadsheet menu item from the Create new section of the left sidebar - a new file will open in a new tab, when all the necessary changes are made, click the Save icon in the upper left corner or switch to the File tab and choose the Save as menu item. in the file manager window, select the location of the file, specify its name, choose the required format (XLSX, Spreadsheet template (XLTX), ODS, OTS, CSV, PDF or PDFA) and click the Save button. To open an existing document In the desktop editor in the main program window, select the Open local file menu item on the left sidebar, choose the necessary spreadsheet from the file manager window and click the Open button. You can also right-click the necessary spreadsheet in the file manager window, select the Open with option and choose the required application from the menu. If documents are associated with the required application, you can also open spreadsheets by double-clicking the file name in the file explorer window. All the directories that you have accessed using the desktop editor will be displayed in the Recent folders list so that you can quickly access them afterwards. Click the necessary folder to select one of the files stored in it. To open a recently edited spreadsheet In the online editor click the File tab on the top toolbar, select the Open Recent option, choose the required spreadsheet from the list of recently edited documents. In the desktop editor in the main program window, select the Recent files menu item on the left sidebar, choose the required spreadsheet from the list of recently edited documents. To rename an opened spreadsheet In the online editor click the spreadsheet name at the top of the page, enter a new spreadsheet name, press Enter to accept the changes. To open the folder, where the file is stored , in a new browser tab in the online version or in the file explorer window in the desktop version, click the Open file location icon on the right side of the editor header. Alternatively, you can switch to the File tab on the top toolbar and select the Open file location option."
    },
   {
        "id": "UsageInstructions/PageBreaks.htm", 
        "title": "Insert page breaks", 
        "body": "In the Spreadsheet Editor, you can add a page break to get your spreadsheet ready for printing in separate pages. To insert a page break at the current cursor position: click the arrow next to the Breaks icon on the Layout tab of the top toolbar, select the Insert page break option from the menu. The added page breaks are indicated in your spreadsheet with dotted lines. Page breaks depend on the set Margins, Orientation, and Size parameters. If you change the parameters, repeat steps 2 and 3 of the instructions above. To set the breaks back to default: click the arrow next to the Breaks icon on the Layout tab of the top toolbar, select the Reset all page breaks option, the default settings are as follows: Margin - Normal; Size - A4; Orientation - Portrait. To remove a page break: click the arrow next to the Breaks icon on the Layout tab of the top toolbar, select the Remove page break option."
    },
   {
        "id": "UsageInstructions/Password.htm", 
        "title": "Protecting spreadsheets with a password", 
        "body": "You can control access to a spreadsheet by setting a password that is required to enter the editing mode by your co-authors. The password can be changed or removed later on. There are two ways to password protect your spreadsheet: using the Protection tab or the File tab. The password cannot be restored if you lose or forget it. Please keep it in a safe place. Setting a password using the Protection tab. go to the Protection tab, and click the Encrypt button. in the Set Password window that opens, enter and confirm the password you will use to access this file. Click to show or hide password characters when entered. click OK to confirm. the Encrypt button on the top toolbar displays with an arrow when the file is encrypted. Click the arrow if you want to change or delete your password. Changing a password go to the Protection tab at the top toolbar, click the Encrypt button and select the Change password option from the drop-down list, set a password in the Password field and repeat it in the Repeat password field below, then click OK. Deleting a password go to the Protection tab at the top toolbar, click the Encrypt button and select the Delete password option from the drop-down list. Setting a password using the File tab. go to the File tab at the top toolbar, choose the Protect option, click the Add password button, set a password in the Password field and repeat it in the Repeat password field below, then click OK. Changing a password go to the File tab at the top toolbar, choose the Protect option, click the Change password button, set a password in the Password field and repeat it in the Repeat password field below, then click OK. Deleting a password go to the File tab at the top toolbar, choose the Protect option, click the Delete password button."
    },
   {
        "id": "UsageInstructions/PhotoEditor.htm", 
        "title": "Edit an image", 
        "body": "ONLYOFFICE Spreadsheet Editor comes with a very powerful photo editor, that allows you to adjust the image with filters and make all kinds of annotations. Starting with ONLYOFFICE Docs 8.2, no plugins come with the editors by default. The plugins shall be installed via Plugin Manager. Select an image in your spreadsheet. Switch to the Plugins tab and choose Photo Editor. You are now in the editing environment. Below the image you will find the following checkboxes and slider filters: Grayscale, Sepia, Sepia 2, Blur, Emboss, Invert, Sharpen; Remove White (Threshhold, Distance), Gradient transparency, Brightness, Noise, Pixelate, Color Filter; Tint, Multiply, Blend. Below the filters you will find buttons for Undo, Redo and Resetting; Delete, Delete all; Crop (Custom, Square, 3:2, 4:3, 5:4, 7:5, 16:9); Flip (Flip X, Flip Y, Reset); Rotate (30 degree, -30 degree,Manual rotation slider); Draw (Free, Straight, Color, Size slider); Shape (Recrangle, Circle, Triangle, Fill, Stroke, Stroke size); Icon (Arrows, Stars, Polygon, Location, Heart, Bubble, Custom icon, Color); Text (Bold, Italic, Underline, Left, Center, Right, Color, Text size); Mask. Feel free to try all of these and remember you can always undo them. When finished, click the OK button. The edited picture is now included in the spreadsheet."
    },
   {
        "id": "UsageInstructions/PivotTables.htm", 
        "title": "Create and edit pivot tables", 
        "body": "Pivot tables allow you to group and arrange data of large data sets to get summarized information. In the Spreadsheet Editor you can reorganize data in many different ways to display only the necessary information and focus on important aspects. Create a new pivot table To create a pivot table, Prepare the source data set you want to use for creating a pivot table. It should include column headers. The data set should not contain empty rows or columns. Select any cell within the source data range. Switch to the Pivot Table tab of the top toolbar and click the Insert Table icon. If you want to create a pivot table on the base of a formatted table, you can also use the Insert pivot table option on the Table settings tab of the right sidebar. The Create Pivot Table window will appear. The Source data range is already specified. In this case, all data from the source data range will be used. If you want to change the data range (e.g. to include only a part of source data), click the icon. In the Select Data Range window, enter the necessary data range in the following format: Sheet1!$A$1:$E$10. You can also select the necessary cell range on the sheet using the mouse. When ready, click OK. Specify where you want to place the pivot table. The New worksheet option is selected by default. It allows you to place the pivot table in a new worksheet. You can also select the Existing worksheet option and choose a certain cell. In this case, the selected cell will be the upper right cell of the created pivot table. To select a cell, click the icon. In the Select Data Range window, enter the cell address in the following format: Sheet1!$G$2. You can also click the necessary cell in the sheet. When ready, click OK. When you select the pivot table location, click OK in the Create Table window. An empty pivot table will be inserted in the selected location. The Pivot table settings tab on the right sidebar will be opened. You can hide or display this tab by clicking the icon. Pivot table settings are also available in the context menu that appears when you right click the table. The context menu options depend on the field you click. Select fields to display The Select Fields section contains the fields named according to the column headers in your source data set. Each field contains values from the corresponding column of the source table. The following four sections are available below: Filters, Columns, Rows, and Values. Check the fields you want to display in the pivot table. When you check a field, it will be added to one of the available sections on the right sidebar depending on the data type and will be displayed in the pivot table. Fields containing text values will be added to the Rows section; fields containing numeric values will be added to the Values section. You can simply drag fields to the necessary section as well as drag the fields between sections to quickly reorganize your pivot table. To remove a field from the current section, drag it out of this section. In order to add a field to the necessary section, it's also possible to click the black arrow to the right of a field in the Select Fields section and choose the necessary option from the menu: Add to Filters, Add to Rows, Add to Columns, Add to Values. Below you can see some examples of using the Filters, Columns, Rows, and Values sections. If you add a field to the Filters section, a separate filter will be added above the pivot table. It will be applied to the entire pivot table. If you click the drop-down arrow in the added filter, you'll see the values from the selected field. When you uncheck some values in the filter option window and click OK, the unchecked values will not be displayed in the pivot table. If you add a field to the Columns section, the pivot table will contain a number of columns equal to the number of values from the selected field. The Grand Total column will also be added. If you add a field to the Rows section, the pivot table will contain a number of rows equal to the number of values from the selected field. The Grand Total row will also be added. If you add a field to the Values section, the pivot table will display the summation value for all numeric values from the selected field. If the field contains text values, the count of values will be displayed. The function used to calculate the summation value can be changed in the field settings. To see more information regarding any value field, click it with the right mouse button to open the context menu and choose the Show details option, or double click the required value field with the left mouse button. The data that the value field is based on will open in a new sheet. Rearrange fields and adjust their properties Once the fields are added to the necessary sections, you can manage them to change the layout and format of the pivot table. Click the black arrow to the right of a field within the Filters, Columns, Rows, or Values sections to access the field context menu. It allows you to: Move the selected field Up, Down, to the Beginning, or to the End of the current section if you have added more than one field to the current section. Move the selected field to a different section - to Filters, Columns, Rows, or Values. The option that corresponds to the current section will be disabled. Remove the selected field from the current section. Adjust the selected field settings. The Filters, Columns, and Rows field settings look similarly: The Layout tab contains the following options: The Source name option allows you to view the field name corresponding to the column header from the source data set. The Custom name option allows you to change the name of the selected field displayed in the pivot table. The Report Form section allows you to change the way the selected field is displayed in the pivot table: Choose the necessary layout for the selected field in the pivot table: The Tabular form displays one column for each field and provides space for field headers. The Outline form displays one column for each field and provides space for field headers. It also allows you to display subtotals at the top of groups. The Compact form displays items from different row section fields in a single column. The Number format option allows you to choose the required number format for the value field. Click this button, choose the required format from the Category list, then click OK when ready. To learn more about number formats, please refer to the following article. The Repeat items labels at each row option allows you to visually group rows or columns together if you have multiple fields in the tabular form. The Insert blank rows after each item option allows you to add blank lines after items of the selected field. The Show subtotals option allows you to choose if you want to display subtotals for the selected field. You can select one of the options: Show at top of group or Show at bottom of group. The Show items with no data option allows you to show or hide blank items in the selected field. The Subtotals tab allows you to choose Functions for Subtotals. Check the necessary functions in the list: Sum, Count, Average, Max, Min, Product, Count Numbers, StdDev, StdDevp, Var, Varp. Values field settings The Source name option allows you to view the field name corresponding to the column header from the source data set. The Custom name option allows you to change the name of the selected field displayed in the pivot table. The Summarize value field by option allows you to choose the function used to calculate the summation value for all values from this field. By default, Sum is used for numeric values, Count is used for text values. The available functions are Sum, Count, Average, Max, Min, Product, Count Numbers, StdDev, StdDevp, Var, Varp. The Show values as option allows you to show instant custom calculations instead of adding a formula and creating a calculated field. No calculation is the default option that displays the actual value in the field. Other calculation options: % of grand total, % of column total, % of row total, % of, % of parent row total, % of parent column total, % of parent total, Difference from, % difference from, Running total in, % running total in, Rank smallest to largest, Rank largest to smallest, Index. Use Base field and Base item when these options are available for the calculation you selected (% of, % of parent total, Difference from, % difference from, Running total in, % running total in). The Number format option allows you to choose the required number format for the value field. Click this button, choose the required format from the Category list, then click OK when ready. To learn more about number formats, please refer to the following article. Group and ungroup data Data in pivot tables can be grouped according to custom requirements. Grouping is available for dates and basic numbers. Grouping dates To group dates, create a pivot table incorporating a set of needed dates. Right click any cell in a pivot table with a date, choose the Group option in the pop-up menu, and set the needed parameters in the opened window. Starting at - the first date in the source data is chosen by default. To change it, enter the needed date in this field. Deactivate this box to ignore the starting point. Ending at - the last date in the source data is chosen by default. To change it, enter the needed date in this field. Deactivate this box to ignore the ending point. By - the Seconds, Minutes, and Hours options group the data according to the time given in the source data. The Months option eliminates days and leaves months only. The Quarters option operates at a condition: four months constitute a quarter, thus providing Qtr1, Qtr2, etc. The Years option groups dates as per years given in the source data. Combine the options to achieve the needed result. Number of days - set the required value to determine a date range. Click OK when finished. Grouping numbers To group numbers, create a pivot table incorporating a set of needed numbers. Right click any cell in a pivot table with a number, choose the Group option in the pop-up menu, and set the needed parameters in the opened window. Starting at - the smallest number in the source data is chosen by default. To change it, enter the needed number in this field. Deactivate this box to ignore the smallest number. Ending at - the largest number in the source data is chosen by default. To change it, enter the needed number in this field. Deactivate this box to ignore the largest number. By - set the required interval for grouping numbers. E.g., “2” will group the set of numbers from 1 through 10 as “1-2”, “3-4”, etc. Click OK when finished. Ungrouping data To ungroup previously grouped data, right-click any cell that is in the group, select the Ungroup option in the context menu. Change the appearance of pivot tables You can use options available on the top toolbar to adjust the way your pivot table is displayed. These options are applied to the entire pivot table. Select at least one cell within the pivot table with the mouse to activate the editing tools on the top toolbar. The Report Layout drop-down list allows you to choose the necessary layout for your pivot table: Show in Compact Form - allows you to display items from different row section fields in a single column. Show in Outline Form - allows you to display the pivot table in the classic pivot table style. It displays one column for each field and provides space for field headers. It also allows you to display subtotals at the top of groups. Show in Tabular Form - allows you to display the pivot table in a traditional table format. It displays one column for each field and provides space for field headers. Repeat All Item Labels - allows you to visually group rows or columns together if you have multiple fields in the tabular form. Don't Repeat All Item Labels - allows you to hide item labels if you have multiple fields in the tabular form. The Blank Rows drop-down list allows you to choose if you want to display blank lines after items: Insert Blank Line after Each Item - allows you to add blank lines after items. Remove Blank Line after Each Item - allows you to remove the added blank lines. The Subtotals drop-down list allows you to choose if you want to display subtotals in the pivot table: Don't Show Subtotals - allows you to hide subtotals for all items. Show all Subtotals at Bottom of Group - allows you to display subtotals below the subtotaled rows. Show all Subtotals at Top of Group - allows you to display subtotals above the subtotaled rows. The Grand Totals drop-down list allows you to choose if you want to display grand totals in the pivot table: Off for Rows and Columns - allows you to hide grand totals for both rows and columns. On for Rows and Columns - allows you to display grand totals for both rows and columns. On for Rows Only - allows you to display grand totals for rows only. On for Columns Only - allows you to display grand totals for columns only. Note: the similar settings are also available in the pivot table advanced settings window in the Grand Totals section of the Name and Layout tab. The Select button allows you to select the entire pivot table. If you change the data in your source data set, select the pivot table and click the Refresh button to update the pivot table. Expand or collapse fields To expand or collapse data details, click a field with the right mouse button to open the context menu, choose the Expand/Collapse menu item, then select the necessary option: Expand - to show details for the currently selected item. Collapse - to hide details for the currently selected item. Expand Entire Field - to show details for all items in a field. The similar setting is also available at the top toolbar. Collapse Entire Field - to hide details for all items in a field. The similar setting is also available at the top toolbar. The groups are hidden behind the plus/minus icons. You can also expand/collapse fields by double-clicking the pivot table headers. The Expand option, when the last field of rows or columns is selected, opens a dialog window for adding a new field to the row or column. Choose the necessary field and click OK. Change the style of pivot tables You can change the appearance of pivot tables in a spreadsheet using the style editing tools available on the top toolbar. Select at least one cell within the pivot table with the mouse to activate the editing tools on the top toolbar. The rows and columns options allow you to emphasize certain rows/columns applying specific formatting to them, or highlight different rows/columns with different background colors to clearly distinguish them. The following options are available: Row Headers - allows you to highlight the row headers with special formatting. Column Headers - allows you to highlight the column headers with special formatting. Banded Rows - enables the background color alternation for odd and even rows. Banded Columns - enables the background color alternation for odd and even columns. The template list allows you to choose one of the predefined pivot table styles. Each template combines certain formatting parameters, such as a background color, border style, row/column banding, etc. Depending on the options checked for rows and columns, the templates set will be displayed differently. For example, if you've checked the Row Headers and Banded Columns options, the visible part of the templates list will include templates with the row headers highlighted and banded columns enabled, but you can expand the full list by clicking the arrow to see all the available templates. Filter, sort and add slicers in pivot tables You can filter pivot tables by labels or values and use the additional sort parameters. Filtering Click the drop-down arrow in the Row Labels or Column Labels of the pivot table. The Filter option list will open: Adjust the filter parameters. You can proceed in one of the following ways: select the data to display or filter the data by certain criteria. Select the data to display Uncheck the boxes near the data you need to hide. For your convenience, all the data within the Filter option list are sorted in ascending order. Note: the (blank) checkbox corresponds to the empty cells. It is available if the selected cell range contains at least one empty cell. To facilitate the process, make use of the search field on the top. Enter your query, entirely or partially, in the field - the values that include these characters will be displayed in the list below. The following two options will be also available: Select All Search Results - is checked by default. It allows selecting all the values that correspond to your query in the list. Add current selection to filter - if you check this box, the selected values will not be hidden when you apply the filter. After you select all the necessary data, click the OK button in the Filter option list to apply the filter. Filter data by certain criteria You can choose either the Label filter or the Value filter option on the right side of the Filter options list, and then select one of the options from the submenu: For the Label filter the following options are available: For texts: Equals..., Does not equal..., Begins with..., Does not begin with..., Ends with..., Does not end with..., Contains..., Does not contain... For numbers: Greater than..., Greater than or equal to..., Less than..., Less than or equal to..., Between, Not between. For the Value filter the following options are available: Equals..., Does not equal..., Greater than..., Greater than or equal to..., Less than..., Less than or equal to..., Between, Not between, Top 10. After you select one of the above options (apart from Top 10), the Label/Value Filter window will open. The corresponding field and criterion will be selected in the first and second drop-down lists. Enter the necessary value in the field on the right. Click OK to apply the filter. If you choose the Top 10 option from the Value filter option list, a new window will open: The first drop-down list allows choosing if you wish to display the highest (Top) or the lowest (Bottom) values. The second field allows specifying how many entries from the list or which percent of the overall entries number you want to display (you can enter a number from 1 to 500). The third drop-down list allows setting the units of measure: Item, Percent, or Sum. The fourth drop-down list displays the selected field name. Once the necessary parameters are set, click OK to apply the filter. The Filter button will appear in the Row Labels or Column Labels of the pivot table. It means that the filter is applied. Sorting You can sort your pivot table data using the sort options. Click the drop-down arrow in the Row Labels or Column Labels of the pivot table and then select Sort Lowest to Highest or Sort Highest to Lowest option from the submenu. The More Sort Options option allows you to open the Sort window where you can select the necessary sorting order - Ascending or Descending - and then select a certain field you want to sort. Adding slicers You can add slicers to filter data easier by displaying only what is needed. To learn more about slicers, please read the guide on creating slicers. Adjust pivot table advanced settings To change the advanced settings of the pivot table, use the Show advanced settings link on the right sidebar. The 'Pivot Table - Advanced Settings' window will open: The Name and Layout tab allows you to change the pivot table common properties. The Name option allows you to change the pivot table name. The Grand Totals section allows you to choose if you want to display grand totals in the pivot table. The Show for rows and Show for columns options are checked by default. You can uncheck either one of them or both these options to hide the corresponding grand totals from your pivot table. Note: the similar settings are available on the top toolbar in the Grand Totals menu. The Display fields in report filter area section allows you to adjust the report filters which appear when you add fields to the Filters section: The Down, then over option is used for column arrangement. It allows you to show the report filters across the column. The Over, then down option is used for row arrangement. It allows you to show the report filters across the row. The Report filter fields per column option allows you to select the number of filters to go in each column. The default value is set to 0. You can set the necessary numeric value. The Show field headers for rows and columns option allows you to choose if you want to display field headers in your pivot table. The option is enabled by default. Uncheck it to hide field headers from your pivot table. The Autofit column widths on update option allows you to enable/disable automatic adjusting of the column widths. The option is enabled by default. The Data Source tab allows you to change the data you wish to use to create the pivot table. Check the selected Data Range and modify it, if necessary. To do that, click the icon. In the Select Data Range window, enter the necessary data range in the following format: Sheet1!$A$1:$E$10. You can also select the necessary cell range in the sheet using the mouse. When ready, click OK. The Alternative Text tab allows specifying the Title and the Description which will be read to people with vision or cognitive impairments to help them better understand what information the pivot table contains. Delete a pivot table To delete a pivot table, Select the entire pivot table using the Select button on the top toolbar. Press the Delete key. Calculated items Calculated items are used for basic calculations between different items within a single field. To add a calculated item: Select the required field. Go to the Pivot Table tab and click the Calculated Items button on the top toolbar. Enter the Item Name, which will be displayed as a pivot table field name later. Edit the Formula field by typing in the required fields from the list below or by clicking the plus button to the right of them, and entering the required mathematical symbols, e.g., \"+\" or \"-\". Click OK. To further manage created calculated items, use the corresponding buttons at the top of the window: add a new one, duplicated, edit, or delete the currently selected one."
    },
   {
        "id": "UsageInstructions/Pixabay.htm", 
        "title": "Pixabay", 
        "body": "The Pixabay plugin allows you to add pictures to your spreadsheet from an open collection of Pixabay service that offers copyright free images. The plugin is compatible with the self-hosted and the desktop versions of the ONLYOFFICE editors and can be added to ONLYOFFICE instances manually using the Plugin Manager. Installation To install the Pixabay plugin, Go to the Plugins tab. Open the Plugin Manager. Find on the marketplace and click the Install button below. Click the Pixabay icon in the Plugins tab. Proceed with the plugin configuration. For more details, please refer to the ONLYOFFICE API documentation. Configuration Log in to your Pixabay account or register a new one. Go to the Search Images section of the Pixabay API page. Scroll down to the Parameters list and copy the link under the Key parameter. If you are not logged in, press Login next to the Key parameter. Paste the key to the API key field on the left panel of the Plugins tab in the Spreadsheet Editor. Click Save. How to use Go to the Plugins tab. Click the Pixabay icon. On the left panel that opens, type in the keyword you associate with the image you are looking for. Use the Show settings button to refine your search by Language, Image type, Orientation and Category. Click Hide settings to reduce the search section. Click Search. Scroll through search results and click the image to add it to your spreadsheet."
    },
   {
        "id": "UsageInstructions/ProtectRanges.htm", 
        "title": "Protect ranges", 
        "body": "The Protect Range option allows you to specify cell ranges that cannot be edited by users without corresponding editing rights that are granted by the creator of the file or a user with full access to it. To select a range of locked cells a user will be allowed to change: Click the Protect Range button on the top toolbar of the Protection tab. The Protected Ranges window will open. Use the Filter drop-down list to choose the required sheet. Click the New button in the Protected Ranges window to select and add a range of cells a user will be allowed to edit. In the New Range window, type the range Title, and select the range of cells by clicking the Select Range button. Select users to provide access to the range, set their access rights, and click OK to confirm. The available access rights are Edit and View. To edit or delete a range, select it in the Protected Ranges window and click the Edit or Delete button accordingly. Click the Close button in the Protected Ranges window when you are ready. To learn more about allowing users to edit ranges, please refer to the following article."
    },
   {
        "id": "UsageInstructions/ProtectSheet.htm", 
        "title": "Protecting a sheet", 
        "body": "The Protect Sheet option allows you to protect the sheets and to control changes made by other users in a sheet as to prevent the unwanted changes to data and to restrict the editing abilities of other users. You can protect a sheet with or without a password. If you don’t use a password, anyone can unprotect the protected sheet. Protect a sheet Go to the Protection tab, and click the Protect Sheet button on the top toolbar. or right-click the sheet tab you want to protect, and select Protect from the list of options In the Protect sheet window that opens, enter and confirm the password, if you want to set a password to unprotect this sheet. The password cannot be restored if you lose or forget it. Please keep it in a safe place. Check the boxes in the Allow all users of this sheet to list to select operations that users will be able to perform. The operations Select locked cells and Select unlocked cells are allowed by default. Operations a user may be allowed to perform. Select locked cells Select unlocked cells Format cells Format columns Format rows Insert columns Insert rows Insert hyperlink Delete columns Delete rows Sort Use Autofilter Use PivotTable and PivotChart Edit objects Edit scenarios Please note that when a sheet is protected, no user can sort or filter data within. For filtering to carry out properly, the filtering parameters shall be applied prior to protecting a sheet. click the Protect button to enable the protection. The Protect Sheet button on the top toolbar stays highlighted once the sheet is protected. Allow edit ranges Click the Protect Sheet button on the top toolbar of the Protection tab. The Protect sheet window will open. Click the Allow edit ranges button to specify ranges unlocked by the password when the sheet is protected. This option works for locked cells only. Click the New button to add a new range. The New range window will be opened. Specify the Title of the range, the range itself, and enter and repeat a password. Click OK when ready. The password cannot be restored if you lose or forget it. Please keep it in a safe place. When a sheet is not protected, you can still make changes to the allowed ranges: If you need to edit a created range, select it in the Allow users to edit ranges window and click the Edit button. To delete a created range, select it in the Allow users to edit ranges window and click the Delete button. Click the Protect button when ready. For ranges protected with a password, when someone is trying to edit the selected range of cells, the Unlock Range window appears, where the user is prompted to enter the password. To learn more about protecting ranges, please refer to the following article. Unprotect a sheet To unprotect the sheet: click the Protect Sheet button, or right-click the protected sheet tab and select Unprotect from the list of options enter a password and click OK in the Unprotect Sheet window if prompted."
    },
   {
        "id": "UsageInstructions/ProtectSpreadsheet.htm", 
        "title": "Protecting a spreadsheet", 
        "body": "The Spreadsheet Editor gives you an opportunity to protect a shared spreadsheet when you intend to restrict access or editing abilities for other users. Spreadsheet Editor offers different levels of protection to control both access to the file and editing abilities inside a workbook and within the sheets. Use the Protection tab to configure the available protection options as you deem it appropriate. The available protection options include: Encrypt to control access to the file and prevent it from being opened by other users. Protect Workbook to control user’s manipulations with the workbook and to prevent unwanted changes to the workbook structure. Protect Sheet to control user’s actions within a sheet and to prevent unwanted changes to data. Protect Range to protect ranges by restricting or prohibiting their editing. The editing rights can be granted to certain users. Users with no editing rights will be able to just view the protected range but they can edit the rest of the spreadsheet provided they have full access rights for the file. Use the Protection tab checkboxes to lock or unlock quickly the sheet contents in a protected sheet. Note: these options will not take effect until you enable sheet protection. By default, the cells, the shapes and the text inside a shape are locked in a sheet, uncheck the appropriate checkbox to unlock them. The unlocked objects can still be edited when a sheet is protected. The options Shape Locked and Lock Text become active when a shape is selected. The Shape Locked option is applicable both to shapes and other objects such as charts, images and text boxes. The Lock Text option locks text inside all graphical objects except charts. Check the Hidden Formulas box to hide formulas in a selected range or cell when a sheet is protected. The hidden formula will not appear in the formula bar when you click the cell."
    },
   {
        "id": "UsageInstructions/ProtectWorkbook.htm", 
        "title": "Protecting a workbook", 
        "body": "The Protect Workbook option allows you to protect workbook structure and to control user’s workbook manipulations so that no one can view hidden worksheets, add, move, delete, hide and rename worksheets. You can protect workbook with or without a password. If you don’t use a password, anyone can unprotect the workbook. To protect a workbook: Go to the Protection tab, and click the Protect Workbook button on the top toolbar. In the Protect Workbook structure window that opens, enter and confirm the password, if you want to set a password to unprotect this workbook. Click the Protect button to enable the protection with or without a password. The password cannot be restored if you lose or forget it. Please keep it in a safe place. The Protect Workbook button on the top toolbar stays highlighted once the workbook is protected. To unprotect the workbook: with a password protected workbook, click the Protect Workbook button on the top toolbar, enter the password in the Unprotect Workbook pop-up window and click OK. with a workbook protected without a password, just click the Protect Workbook button on the top toolbar."
    },
   {
        "id": "UsageInstructions/RemoveDuplicates.htm", 
        "title": "Remove duplicates", 
        "body": "In the Spreadsheet Editor, you can remove duplicate values from the selected data range or a formatted table. To remove duplicates: Select the necessary cell range containing duplicate values. Switch to the Data tab and click the Remove Duplicates button on the top toolbar. If you want to remove duplicates from a formatted table, you can also use the Remove duplicates option on the right sidebar. If you select a certain part of the data range, a warning window will appear where you will be asked if you want to expand the selection to include the entire data range or proceed with the currently selected data. Click the Expand or Remove in selected button. If you choose the Remove in selected option, duplicate values in cells adjacent to the selected range will not be removed. The Remove Duplicates window will open: Check the necessary options in the Remove Duplicates window: My data has headers - check this box to exclude column headers from the selection. Columns - leave the Select All option selected by default or uncheck it and select the necessary columns only. Click the OK button. The duplicate values from the selected data range will be removed, and you will see the window that contains the information on how many duplicate values have been removed and how many unique values have been left: If you want to restore the removed data right after deletion, use the Undo icon on the top toolbar or the Ctrl+Z key combination."
    },
   {
        "id": "UsageInstructions/SavePrintDownload.htm", 
        "title": "Save/print/download your spreadsheet", 
        "body": "Saving By default, the online Spreadsheet Editor automatically saves your file each 2 seconds when you are working on it preventing your data from loss if the program closes unexpectedly. If you co-edit the file in the Fast mode, the timer requests for updates 25 times a second and saves the changes if they have been made. When the file is being co-edited in the Strict mode, changes are automatically saved at 10-minute intervals. If you need, you can easily select the preferred co-editing mode or disable the Autosave feature on the Advanced Settings page. To save your current spreadsheet manually in the current format and location, click the Save icon on the left side of the editor header, or use the Ctrl+S key combination, or click the File tab of the top toolbar and select the Save option. In the desktop version, to prevent data loss if the program closes unexpectedly, you can turn on the Autorecover option on the Advanced Settings page. In the desktop version, you can save the spreadsheet with another name, in a new location or format, click the File tab of the top toolbar, select the Save as option, choose one of the available formats depending on your needs: XLSX, XLTX, ODS, OTS, CSV, PDF, PDF/A, XLTM, JPG, PNG. Downloading In the online version, you can download the resulting spreadsheet onto your computer hard disk drive, click the File tab of the top toolbar, select the Download as option, choose one of the available formats depending on your needs: XLSX, ODS, CSV, PDF, XLTX, OTS, PDF/A, JPG, PNG. Note: if you select the CSV format, all features (font formatting, formulas, etc.) except the plain text will not be preserved in the CSV file. If you continue saving, the Choose CSV Options window will open. By default, Unicode (UTF-8) is used as the Encoding type. The default Delimiter is comma (,), but the following options are also available: semicolon (;), colon (:), Tab, Space and Other (this option allows you to set a custom delimiter character). Saving a copy In the online version, you can save a copy of the file on your portal, click the File tab of the top toolbar, select the Save Copy as option, choose one of the available formats depending on your needs: XLSX, ODS, CSV, PDF, XLTX, OTS, PDF/A, JPG, PNG, select a location of the file on the portal and press Save. Printing To print out the current spreadsheet, click the Print icon on the left side of the editor header, or use the Ctrl+P key combination, or click the File tab of the top toolbar and select the Print option. The Firefox browser enables printing without downloading the document as a .pdf file first. The spreadsheet Preview and the available printing options will open. Some of these settings (page Margins, Orientation, Size, Print Area as well as Scale to Fit) are also available on the Layout tab of the top toolbar. Here you can adjust the following parameters. In the desktop version you can also define the Print sides option to print on one or two sides flipping the pages on long or short edge as well as print the file to PDF or use the Quick print button in the top toolbar to print the file on the last selected or default printer. Print range - specify what to print: Active sheets, All sheets or Selection. If you previously set a constant print area but want to print the entire sheet, check the Ignore print area box. Pages - specify the range of pages for printing. You can enter the numbers manually or use the corresponding arrows. Settings of sheet - specify individual print settings for each separate sheet, if you have selected the All Sheets option in the Print range drop-down list. Page size - select one of the available sizes from the drop-down list: US Letter (21,59cm x 27,94cm) US Legal (21,59cm x 35,56cm) A4 (21cm x 29,7cm) A5 (14,81cm x 20,99cm) B5 (17,6cm x 25,01cm) Envelope #10 (10,48cm x 24,13cm) Envelope DL (11,01cm x 22,01cm) Tabloid (27,94cm x 43,17cm) AЗ (29,7cm x 42,01cm) Tabloid Oversize (29,69cm x 45,72cm) ROC 16K (19,68cm x 27,3cm) Envelope Choukei 3 (12cm x 23,5cm) Super B/A3 (30,5cm x 48,7cm) Page orientation - choose the Portrait option if you wish to print vertically on the page, or use the Landscape option to print horizontally. Margins - choose one of the availabe presets: Normal, Narrow, or Wide, or choose the Custom option and specify the distance between the worksheet data and the edges of the printed page changing the default sizes in the Top, Bottom, Left and Right fields. To center data on the printed page, choose the Custom option from the Margins menu, check the Vertically/Horizontally box in the Center on page section, and click OK. Scaling - if you do not want some columns or rows to be printed on the second page, you can shrink sheet contents to fit it on one page by selecting the corresponding option: Actual Size, Fit Sheet on One Page, Fit All Columns on One Page or Fit All Rows on One Page. Leave the Actual Size option to print the sheet without adjusting. If you choose the Custom Options item from the menu, the Scale Settings window will open: Fit To: allows you to select the necessary number of pages you want to fit the printed worksheet to. Select the necessary number of pages from the Width and Height lists. Scale To: allows you to enlarge or reduce the scale of the worksheet to fit printed pages by manually specifying the percentage of normal size. Print titles - if you want to print row or column titles on every page, use Repeat rows at top and/or Repeat columns at left to indicate the row and the column with the title to repeat, or select one of the available options from the drop-down list: Frozen rows/columns, First row/column or Don't repeat. Gridlines and headings - specify the worksheet elements to print by checking the corresponding boxes: Print gridlines and Print row and column headings. Header/footer settings - allow to add some additional information to a printed worksheet, such as date and time, page number, sheet name, etc. First page number - specify the number of the first page printed. Toggle the Zoom to page switch in the bottom right corner of the screen to display the actual size of the sheets when deactivated, or zoom out when activated. After you have configured the printing settings click the Print button to save changes and print out the spreadsheet or the Save button to save changes made to printing settings. All changes you made will be lost if you don't print the spreadsheet or save the changes. The spreadsheet Preview allows you to navigate a spreadsheet using arrows at the bottom to see how your data will be displayed on a sheet when printed and to correct eventual faults using the print setting above. In the online version, a PDF file will be generated on the basis of the document. You can open and print it out, or save onto your computer hard disk drive or removable medium to print it out later. Some browsers (e.g. Chrome and Opera) support direct printing. Setting up the print area If you want to print the selected cell range only instead of the entire worksheet, you can use the Selection option from the Print range drop-down list. When the workbook is saved, this setting is not saved, it is intended for single use. If a cell range should be printed frequently, you can set a constant print area on the worksheet. When the workbook is saved, the print area is also saved, it can be used when you open the spreadsheet next time. It's also possible to set several constant print areas in a sheet, in this case each area will be printed on a separate page. To set the print area: select the necessary cell range on the worksheet. To select multiple cell ranges, hold down the Ctrl key, switch to the Layout tab of the top toolbar, click the arrow next to the Print Area button and select the Set Print Area option. The created print area is saved when the workbook is saved. When you open the file next time, the specified print area will be printed. When you create a print area, a Print_Area named range is also automatically created, which is displayed in the Name Manager. To highlight the borders of all the print areas on the current worksheet, you can click the arrow in the name box located to the left of the the formula bar and select the Print_Area name from the name list. To add cells to the print area: open the necessary worksheet where the print area is added, select the necessary cell range on the worksheet, switch to the Layout tab of the top toolbar, click the arrow next to the Print Area button and select the Add to Print Area option. A new print area will be added. Each print area will be printed on a separate page. To remove the print area: open the necessary worksheet where the print area is added, switch to the Layout tab of the top toolbar, click the arrow next to the Print Area button and select the Clear Print Area option. All the existing print areas in this sheet will be removed. Then the entire sheet will be printed."
    },
   {
        "id": "UsageInstructions/ScaleToFit.htm", 
        "title": "Scale a worksheet", 
        "body": "If you want to fit an entire spreadsheet on one page to print it, you can use the Scale to Fit function. This function of the Spreadsheet Editor helps scale data on the specified number of pages. To do so, follow these simple steps: on the top toolbar, enter the Layout tab and select the Scale to fit function, in the Height section select 1 page and set Width on Auto to print all sheets on one page. The scale value will be changed automatically. This value is displayed in the Scale section; you can also change the scale value manually. To do this, set the Height and Width parameters to Auto and use the «+» and «-» buttons to change the scale of the worksheet. The borders of the printing page will be covered with dashed lines in the spreadsheet, on the File tab, click Print, or use the keyboard shortcuts Ctrl + P and adjust the print settings in the opened window. For example, if there are many columns in a sheet, it might be useful to change the Page Orientation to Portrait. Or print the pre-selected cell range. Find out more about the print settings in this article. Note: keep in mind, however, that the printout may be difficult to read because the editor shrinks the data to fit."
    },
   {
        "id": "UsageInstructions/SheetView.htm", 
        "title": "Manage sheet view presets", 
        "body": "ONLYOFFICE Spreadsheet Editor offers a sheet view manager for view presets that are based on the applied filters. Now you can save the required filtering parameters as a view preset and use it afterwards together with your colleagues as well as create several presets and switch among them effortlessly. If you are collaborating on a spreadsheet, create individual view presets and continue working with the filters you need without being disrupted by other co-editors. Creating a new sheet view preset Since a view preset is designed to save customized filtering parameters, first you need to apply the said parameters to the sheet. To learn more about filtering, please refer to this page . There are two ways to create a new sheet view preset. You can either go to the View tab and click the Sheet View icon, choose the View manager option from the drop-down menu, click the New button in the opened Sheet View Manager window, specify the name of the sheet view preset, or click the New button on the View tab located at the top toolbar. The preset will be created under a default name “View1/2/3...”. To change the name, go to the Sheet View Manager, select the required preset, and click Rename. Click Go to view to activate the created view preset. Switching among sheet view presets Go to the View tab and click the Sheet View icon. Choose the View manager option from the drop-down menu. Select the sheet view preset you want to activate in the Sheet views field. Click Go to view to switch to the selected preset. To exit the current sheet view preset, Close icon on the View tab located at the top toolbar. Managing sheet view presets Go to the View tab and click the Sheet View icon. Choose the View manager option from the drop-down menu. Select the sheet view preset you want to edit in the opened Sheet View Manager window. Choose one of the editing options: Rename to rename the selected preset, Duplicate to create a copy of the selected preset, Delete to delete the selected preset. Click Go to view to activate the selected preset."
    },
   {
        "id": "UsageInstructions/Slicers.htm", 
        "title": "Create slicers for tables", 
        "body": "Create a new slicer Once you create a new formatted table in the Spreadsheet Editor or a pivot table, you can create slicers to quickly filter the data. To do that, select at least one cell within the table with the mouse and click the Table settings icon on the right. click the Insert slicer option on the Table settings tab of the right sidebar. Alternatively, you can switch to the Insert tab of the top toolbar and click the Slicer button. The Insert Slicers window will be opened: check the required columns in the Insert Slicers window. click the OK button. A slicer will be added for each of the selected columns. If you add several slicers, they will overlap each other. Once the slicer is added, you can change its size and position as well as its settings. A slicer contains buttons that you can click to filter the table. The buttons corresponding to empty cells are marked with the (blank) label. When you click a slicer button, other buttons will be unselected, and the corresponding column in the source table will be filtered to only display the selected item: If you have added several slicers, the changes made in one slicer can affect the items from another slicer. When one or more filters are applied to a slicer, items with no data can appear in a different slicer (with a lighter color): You can adjust the way to display items with no data in the slicer settings. To select multiple slicer buttons, use the Multi-Select icon in the upper right corner of the slicer or press Alt+S. Select necessary slicer buttons clicking them one by one. To clear the slicer filter, use the Clear Filter icon in the upper right corner of the slicer or press Alt+C. Edit slicers Some of the slicer settings can be changed using the Slicer settings tab of the right sidebar that will open if you select the slicer with the mouse. You can hide or display this tab by clicking the icon on the right. Change the slicer size and position The Width and Height options allow you to change the width and/or height of the slicer. If the Constant proportions button is clicked (in this case it looks like this ), the width and height will be changed together preserving the original slicer aspect ratio. The Position section allows you to change the Horizontal and/or Vertical slicer position. The Disable resizing or moving option allows you to prevent the slicer from being moved or resized. When this option is checked, the Width, Height, Position, and Buttons options are disabled. Change the slicer layout and style The Buttons section allows you to specify the necessary number of Columns and set the Width and Height of the buttons. By default, a slicer contains one column. If your items contain short text, you can change the column number to 2 or more: If you increase the button width, the slicer width will change correspondingly. If you increase the button height, the scroll bar will be added to the slicer: The Style section allows you to choose one of the predefined slicer styles. Apply sorting and filtering parameters Ascending (A to Z) is used to sort the data in ascending order - from A to Z alphabetically or from the smallest to the largest number for numerical data. Descending (Z to A) is used to sort the data in descending order - from Z to A alphabetically or from the largest to the smallest for numerical data. The Hide items with no data option allows you to hide items with no data from the slicer. When this option is checked, the Visually indicate items with no data and Show items with no data last options are disabled. When the Hide items with no data option is unchecked, you can use the following options: The Visually indicate items with no data option allows you to display items with no data with different formatting (with a lighter color). If you uncheck this option, all items will be displayed with the same formatting. The Show items with no data last option allows you to display items with no data at the end of the list. If you uncheck this option, all items will be displayed in the same order as in the source table. Adjust advanced slicer settings To change the advanced slicer properties, use the Show advanced settings link on the right sidebar. The 'Slicer - Advanced Settings' window will open: The Style &amp; Size tab contains the following parameters: The Header option allows you to change the slicer header. Uncheck the Display header option if you do not want to display the slicer header. The Style section allows you to choose one of the predefined slicer styles. The Width and Height options allow you to change the width and/or height of the slicer. If the Constant proportions button is clicked (in this case it looks like this ), the width and height will be changed together preserving the original slicer aspect ratio. The Buttons section allows you to specify the necessary number of Columns and set the Height of the buttons. The Sorting &amp; Filtering tab contains the following parameters: Ascending (A to Z) is used to sort the data in ascending order - from A to Z alphabetically or from the smallest to the largest number for numerical data. Descending (Z to A) is used to sort the data in descending order - from Z to A alphabetically or from the largest to the smallest for numerical data. The Hide items with no data option allows you to hide items with no data from the slicer. When this option is checked, the Visually indicate items with no data and Show items with no data last options are disabled. When the Hide items with no data option is unchecked, you can use the following options: The Visually indicate items with no data option allows you to display items with no data with different formatting (with a lighter color). The Show items with no data last option allows you to display items with no data at the end of the list. The References tab contains the following parameters: The Source name option allows you to view the field name corresponding to the column header from the source data set. The Name to use in formulas option allows you to view the slicer name which is displayed in the Name manager. The Name option allows you to set a custom name for a slicer to make it more meaningful and understandable. The Cell Snapping tab contains the following parameters: Move and size with cells - this option allows you to snap the slicer to the cell behind it. If the cell moves (e.g. if you insert or delete some rows/columns), the slicer will be moved together with the cell. If you increase or decrease the width or height of the cell, the slicer will change its size as well. Move but don't size with cells - this option allows you to snap the slicer to the cell behind it preventing the slicer from being resized. If the cell moves, the slicer will be moved together with the cell, but if you change the cell size, the slicer dimensions remain unchanged. Don't move or size with cells - this option allows you to prevent the slicer from being moved or resized if the cell position or size was changed. The Alternative Text tab allows you to specify the Title and the Description which will be read to people with vision or cognitive impairments to help them better understand what information the slicer contains. Delete a slicer To delete a slicer, Select the slicer by clicking it. Press the Delete key."
    },
   {
        "id": "UsageInstructions/SortData.htm", 
        "title": "Sort and filter data", 
        "body": "Sort Data You can quickly sort the data in the Spreadsheet Editor using one of the following options: Ascending is used to sort the data in ascending order - from A to Z alphabetically or from the smallest to the largest number for numerical data. Descending is used to sort the data in descending order - from Z to A alphabetically or from the largest to the smallest for numerical data. Note: the Sort options are accessible from both Home and Data tab. To sort the data, select a cell range you wish to sort (you can select a single cell in a range to sort the entire range), click the Sort ascending icon situated on the Home or Data tab of the top toolbar to sort the data in ascending order, OR click the Sort descending icon situated on the Home or Data tab of the top toolbar to sort the data in descending order. Note: if you select a single column/row within a cell range or a part of the column/row, you will be asked if you want to expand the selection to include adjacent cells or sort the selected data only. You can also sort your data using the contextual menu options. Right-click the selected range of cells, select the Sort option from the menu and then select Ascending or Descending option from the submenu. It's also possible to sort the data by color using the contextual menu: right-click a cell containing the color by which you want to sort the data, select the Sort option from the menu, select the necessary option from the submenu: Selected Cell Color on top - to display the entries with the same cell background color on the top of the column, Selected Font Color on top - to display the entries with the same font color on the top of the column. Filter Data To display only the rows that meet certain criteria and hide other ones, make use of the Filter option. Note: the Filter options are accessible from both Home and Data tab. To enable a filter, Select a cell range containing data to filter (you can select a single cell in a range to filter the entire range), Click the Filter icon situated at the Home or Data tab of the top toolbar. The drop-down arrow will appear in the first cell of each column of the selected cell range. It means that the filter is enabled. To apply a filter, Click the drop-down arrow . The Filter option list will open: Note: you can adjust the size of the filter window by dragging its right border to the right or to the left to display the data as convenient as possible. Adjust the filter parameters. You can proceed in one of the following ways: select the data to display, filter the data by certain criteria or filter data by color. Select the data to display Uncheck the boxes near the data you need to hide. For your convenience, all the data within the Filter option list are sorted in ascending order. The number of unique values in the filtered range is displayed to the right of each value within the filter window. Note: the {Blanks} check box corresponds to the empty cells. It is available if the selected cell range contains at least one empty cell. To facilitate the process, make use of the search field on the top. Enter your query, entirely or partially, in the field - the values that include these characters will be displayed in the list below. The following two options will be also available: Select All Search Results - is checked by default. It allows selecting all the values that correspond to your query in the list. Add current selection to filter - if you check this box, the selected values will not be hidden when you apply the filter. After you select all the necessary data, click the OK button in the Filter option list to apply the filter. Filter data by certain criteria Depending on the data in the selected column, you can choose either the Number filter or the Text filter option on the right side of the Filter options list, and then select one of the options from the submenu: For the Number filter the following options are available: Equals..., Does not equal..., Greater than..., Greater than or equal to..., Less than..., Less than or equal to..., Between, Top 10, Above Average, Below Average, Custom Filter.... For the Text filter the following options are available: Equals..., Does not equal..., Begins with..., Does not begin with..., Ends with..., Does not end with..., Contains..., Does not contain..., Custom Filter.... After you select one of the above options (apart from Top 10 and Above/Below Average), the Custom Filter window will open. The corresponding criterion will be selected in the upper drop-down list. Enter the necessary value in the field on the right. To add one more criterion, use the And radiobutton if you need the data to satisfy both criteria or click the Or radiobutton if either or both criteria can be satisfied. Then select the second criterion from the lower drop-down list and enter the necessary value on the right. Click OK to apply the filter. If you choose the Custom Filter... option from the Number/Text filter option list, the first criterion is not selected automatically, you can set it yourself. If you choose the Top 10 option from the Number filter option list, a new window will open: The first drop-down list allows choosing if you wish to display the highest (Top) or the lowest (Bottom) values. The second field allows specifying how many entries from the list or which percent of the overall entries number you want to display (you can enter a number from 1 to 500). The third drop-down list allows setting the units of measure: Item or Percent. Once the necessary parameters are set, click OK to apply the filter. If you choose the Above/Below Average option from the Number filter option list, the filter will be applied right now. Filter data by color If the cell range you want to filter contains some cells you have formatted changing their background or font color (manually or using predefined styles), you can use one of the following options: Filter by cells color - to display only the entries with a certain cell background color and hide other ones, Filter by font color - to display only the entries with a certain cell font color and hide other ones. When you select the necessary option, a palette that contains colors used in the selected cell range will open. Choose one of the colors to apply the filter. The Filter button will appear in the first cell of the column. It means that the filter is applied. The number of filtered records will be displayed at the status bar (e.g. 25 of 80 records filtered). Note: when the filter is applied, the rows that are filtered out cannot be modified when autofilling, formatting, deleting the visible contents. Such actions affect the visible rows only, the rows that are hidden by the filter remain unchanged. When copying and pasting the filtered data, only visible rows can be copied and pasted. This is not equivalent to manually hidden rows which are affected by all similar actions. Sort filtered data You can set the sorting order of the data you have enabled or applied filter for. Click the drop-down arrow or the Filter button and select one of the options in the Filter option list: Sort Lowest to Highest - allows sorting the data in ascending order, displaying the lowest value on the top of the column, Sort Highest to Lowest - allows sorting the data in descending order, displaying the highest value on the top of the column, Sort by cells color - allows selecting one of the colors and displaying the entries with the same cell background color on the top of the column, Sort by font color - allows selecting one of the colors and displaying the entries with the same font color on the top of the column. The latter two options can be used if the cell range you want to sort contains some cells you have formatted changing their background or font color (manually or using predefined styles). The sorting direction will be indicated by an arrow in the filter buttons. if the data is sorted in ascending order, the drop-down arrow in the first cell of the column looks like this: and the Filter button looks the following way: . if the data is sorted in descending order, the drop-down arrow in the first cell of the column looks like this: and the Filter button looks the following way: . You can also quickly sort the data by color using the contextual menu options: right-click a cell containing the color by which you want to sort the data, select the Sort option from the menu, select the necessary option from the submenu: Selected Cell Color on top - to display the entries with the same cell background color on the top of the column, Selected Font Color on top - to display the entries with the same font color on the top of the column. Filter by the selected cell contents You can also quickly filter your data by the selected cell contents using the contextual menu options. Right-click a cell, select the Filter option from the menu and then select one of the available options: Filter by Selected cell's value - to display only the entries with the same value as the selected cell contains. Filter by cell's color - to display only the entries with the same cell background color as the selected cell has. Filter by font color - to display only the entries with the same cell font color as the selected cell has. Format as Table Template To facilitate your work with data, the Spreadsheet Editor allows you to apply a table template to a selected cell range automatically enabling the filter. To do that, select a range of cells you need to format, click the Format as table template icon situated on the Home tab of the top toolbar. select the required template in the gallery, in the opened pop-up window check the cell range to be formatted as a table, check the Title if you wish the table headers to be included in the selected cell range, otherwise the header row will be added at the top while the selected cell range will be moved one row down, click the OK button to apply the selected template. The template will be applied to the selected range of cells and you will be able to edit the table headers and apply the filter to work with your data. To learn more on working with formatted tables, please refer to this page. Reapply Filter If the filtered data has been changed, you can refresh the filter to display an up-to-date result: click the Filter button in the first cell of the column that contains the filtered data, select the Reapply option in the opened Filter option list. You can also right-click a cell within the column that contains the filtered data and select the Reapply option from the contextual menu. Clear Filter To clear the filter, click the Filter button in the first cell of the column that contains the filtered data, select the Clear option in the opened Filter option list. You can also proceed in the following way: select the range of cells containing the filtered data, click the Clear filter icon situated on the Home or Data tab of the top toolbar. The filter will remain enabled, but all the applied filter parameters will be removed, and the Filter buttons in the first cells of the columns will change into the drop-down arrows . Remove Filter To remove the filter, select the range of cells containing the filtered data, click the Filter icon situated on the Home or Data tab of the top toolbar. The filter will be disabled, and the drop-down arrows will disappear from the first cells of the columns. Sort data by several columns/rows To sort data by several columns/rows you can create several sorting levels using the Custom Sort function. select a cell range you wish to sort (you can select a single cell to sort the entire range), click the Custom Sort icon situated on the Data tab of the top toolbar, the Sort window will appear. Sorting by columns is selected by default. use the Levels sections to add new levels and to manage the added levels. New button to add a new level, select the second column / row you want to sort and specify other sorting parameters in the Then by field as described above. If necessary, add more levels in the same way, Copy button to copy the selected level and to duplicate all the existing settings, Options button to change the sorting orientation (i.e. sorting data by rows instead of columns). Click the button to open the Sort Options window: check the My data has headers box, if necessary choose the necessary Orientation: Sort top to bottom to sort data by columns or Sort left to right to sort data by rows, click OK to apply the changes and close the window. Delete button to delete the selected level, Arrow buttons Move the level up / Move the level down to change the order of levels. set the first sorting level in the Sort by field: in the Column / Row section, select the first column / row you want to sort, in the Sort on list choose one of the following options: Values, Cell color, or Font color, in the Order list, specify the necessary sorting order. The available options differ depending on the option chosen in the Sort on list: if the Values option is selected, choose the Ascending / Descending option if the cell range contains numbers or A to Z / Z to A option if the cell range contains text values, if the Cell color option is selected, choose the necessary cell color and select the Top / Below option for columns or Left / Right option for rows, if the Font color option is selected, choose the necessary font color and select the Top / Below option for columns or Left / Right option for rows. click OK to apply the changes and close the window. The data will be sorted according to the specified sorting levels."
    },
   {
        "id": "UsageInstructions/Thesaurus.htm", 
        "title": "Replace a word by a synonym", 
        "body": "If you are using the same word multiple times, or a word is just not quite the word you are looking for, ONLYOFFICE Spreadsheet Editor lets you look up synonyms. It will show you the antonyms too. Starting with ONLYOFFICE Docs 8.2, no plugins come with the editors by default. The plugins shall be installed via Plugin Manager. Select the word in your spreadsheet. Switch to the Plugins tab and choose Thesaurus. The synonyms and antonyms will show up in the left sidebar. Click a word to replace the word in your spreadsheet."
    },
   {
        "id": "UsageInstructions/Translator.htm", 
        "title": "Translate text", 
        "body": "In the Spreadsheet Editor, you can translate your spreadsheet from and to numerous languages. Starting with ONLYOFFICE Docs 8.2, no plugins come with the editors by default. The plugins shall be installed via Plugin Manager. Select the text that you want to translate. Switch to the Plugins tab and choose Translator, the Translator appears in a sidebar on the left. Click the drop-down box and choose the preferred language. The text will be translated to the required language. Changing the language of your result: Click the drop-down box and choose the preferred language. The translation will change immediately."
    },
   {
        "id": "UsageInstructions/UndoRedo.htm", 
        "title": "Undo/redo your actions", 
        "body": "To perform the undo/redo operations, use the corresponding icons on the top left side of the Spreadsheet Editor: Undo – use the Undo icon to undo the last operation you performed. Redo – use the Redo icon to redo the last undone operation. The undo/redo operations can be also performed using the Keyboard Shortcuts. Note: when you co-edit a spreadsheet in the Fast mode, the possibility to Undo/Redo the last operation is not available."
    },
   {
        "id": "UsageInstructions/UseNamedRanges.htm", 
        "title": "Use named ranges", 
        "body": "Names are meaningful notations that can be assigned to a cell or cell range and used to simplify working with formulas in the Spreadsheet Editor. Creating a formula, you can insert a name as its argument instead of using a reference to a cell range. For example, if you assign the Annual_Income name to a cell range, it will be possible to enter =SUM(Annual_Income) instead of =SUM(B1:B12). Thus, formulas become clearer. This feature can also be useful in case a lot of formulas are referred to one and the same cell range. If the range address is changed, you can make the correction once by using the Name Manager instead of editing all the formulas one by one. There are two types of names that can be used: Defined name – an arbitrary name that you can specify for a certain cell range. Defined names also include the names created automatically when setting up print areas. Table name – a default name that is automatically assigned to a new formatted table (Table1, Table2 etc.). You can edit this name later. If you have created a slicer for a formatted table, an automatically assigned slicer name will also be displayed in the Name Manager (Slicer_Column1, Slicer_Column2 etc. This name consists of the Slicer_ part and the field name corresponding to the column header from the source data set). You can edit this name later. Names are also classified by Scope, i.e. the location where a name is recognized. A name can be scoped to the whole workbook (it will be recognized for any worksheet within this workbook) or to a separate worksheet (it will be recognized for the specified worksheet only). Each name must be unique within a single scope, the same names can be used within different scopes. Create new names To create a new defined name for a selection: Select a cell or cell range you want to assign a name to. Open a new name window in a suitable way: Right-click the selection and choose the Define Name option from the contextual menu, or click the Named ranges icon on the Home tab of the top toolbar and select the Define Name option from the menu. or click the  Named ranges button on the Formula tab of the top toolbar and select the Name manager option from the menu. Choose option New in the opened window. The New Name window will open: Enter the necessary Name in the text entry field. Note: a name cannot start with a number, contain spaces or punctuation marks. Underscores (_) are allowed. Case does not matter. Specify the name Scope. The Workbook scope is selected by default, but you can specify an individual worksheet selecting it from the list. Check the selected Data Range address. If necessary, you can change it. Click the icon - the Select Data Range window will open. Change the link to the cell range in the entry field or select a new range on the worksheet with the mouse and click OK. Click OK to save the new name. To quickly create a new name for the selected cell range, you can also enter the desired name into the name box located to the left of the the formula bar and press Enter. The name created in such a way is scoped to the Workbook. Manage names All the existing names can be accessed via the Name Manager. To open it: click the Named ranges icon on the Home tab of the top toolbar and select the Name manager option from the menu, or click the arrow in the name field and select the Name Manager option. The Name Manager window will open: For your convenience, you can filter the names selecting the name category you want to be displayed: All, Defined names, Table names, Names Scoped to Sheet or Names Scoped to Workbook. The names that belong to the selected category will be displayed in the list, the other names will be hidden. To change the sort order for the displayed list, you can click on the Named Ranges or Scope titles in this window. To edit a name, select it in the list and click the Edit button. The Edit Name window will open: For a defined name, you can change the name and the data range it refers to. For a table name, you can change the name only. When all the necessary changes are made, click OK to apply them. To discard the changes, click Cancel. If the edited name is used in a formula, the formula will be automatically changed accordingly. To delete a name, select it in the list and click the Delete button. Note: if you delete the name that is used in a formula, the formula will no longer work (it will return the #NAME? error). You can also create a new name in the Name Manager window by clicking the New button. Use names when working with the spreadsheet To quickly navigate through cell ranges, you can click the arrow in the name box and select the necessary name from the name list – the data range that corresponds to this name will be selected in the worksheet. Note: the name list displays the defined names and table names scoped to the current worksheet and to the whole workbook. To add a name as an argument of a formula: Place the insertion point where you need to add a name. Make one of the following steps: enter the name of the necessary named range manually using the keyboard. Once you type the initial letters, the Formula Autocomplete list will be displayed. As you type, the items (formulas and names) that match the entered characters are displayed in it. You can select the necessary defined name or table name from the list and insert it into the formula by double-clicking it or pressing the Tab key. or click the Named ranges icon on the Home tab of the top toolbar, select the Paste name option from the menu, choose the necessary name from the Paste Name window and click OK: Note: the Paste Name window displays the defined names and table names scoped to the current worksheet and to the whole workbook. To use a name as an internal hyperlink: Place the insertion point where you need to add a hyperlink. Go to the Insert tab and click the Hyperlink button. In the opened Hyperlink Settings window, select the Internal Data Range tab and choose a named range. Click OK."
    },
   {
        "id": "UsageInstructions/ViewDocInfo.htm", 
        "title": "View file information", 
        "body": "To access the detailed information about the currently edited spreadsheet in the Spreadsheet Editor, click the File tab of the top toolbar and select the Info option. Common Owner - the person who has created the file. Uploaded - the date when the file has been uploaded to the server. Last Modified - the date when the file has last been edited. Statistics This subsection displays the number of pages, paragraphs, words, symbols, and symbols with spaces within the file. Properties Author - you can enter the necessary name in this field. Press Enter to add a new field that allows you to specify one more author. To delete additional authors, click the cross button next to the corresponding fields. Title - enter the title of the spreadsheet. Please do not confuse it with the file name as these are different file properties. Tags - enter necessary tags for better file classification. Subject - enter the spreadsheet subject. Comment - enter the comment to the file. Please do not confuse it with the Comments as these are different features. Click the Add property button to add custom fields, entering the Title of the field, its Type, i.e., its format, and its Value. Click OK when ready. To delete additional fields, click the cross button next to them."
    },
   {
        "id": "UsageInstructions/WatchWindow.htm", 
        "title": "Watch Window", 
        "body": "Watch window When working with large worksheets in the Spreadsheet Editor, the Watch Window might come in handy to keep cells and their formulas in check. The Watch Window allows you to see changes in the cells that are not currently in the visible area of the worksheet. You can also quickly switch to the required cell with a double click in the Watch Window. The Watch Window allows you to monitor the following watch parameters: Book, Sheet, Name, Cell, Value, and Formula. To add a new watch, Go to the Formula tab. Click the Watch Window button. Click the Add watch button in the Watch window. Select the required data range to watch. Click Close to return to the worksheet or continue working in the worksheet with an opened watch. All changes in the cells will be visible in the watch. To delete a watch, Go to the Formula tab. Click the Watch Window button. Select the required watch or several watches by clicking them via a button combination Ctrl+Left Mouse Button. Click the Delete watch button and choose whether you want to Delete watch or Delete all."
    },
   {
        "id": "UsageInstructions/YouTube.htm", 
        "title": "Include a video", 
        "body": "In the Spreadsheet Editor, you can include a video in your spreadsheet. It will be shown as an image. By double-clicking the image the video dialog opens. Here you can start the video. Starting with ONLYOFFICE Docs 8.2, no plugins come with the editors by default. The plugins shall be installed via Plugin Manager. Copy the URL of the video you want to include. (the complete address shown in the address line of your browser) Go to your spreadsheet and place the cursor at the location where you want to include the video. Switch to the Plugins tab and choose YouTube. Paste the URL and click OK. Check if it is the correct video and click the OK button below the video. The video is now included in your spreadsheet."
    },
   {
        "id": "UsageInstructions/Zoom.htm", 
        "title": "Zoom", 
        "body": "The Zoom plugin allows you to host or schedule Zoom meetings directly in the editor in just a few clicks. The plugin is compatible with the self-hosted version of ONLYOFFICE editors and can be added to ONLYOFFICE instances manually using the Plugin Manager. Installation To install the Zoom plugin, Go to the Plugins tab. Open the Plugin Manager. Find Zoom on the marketplace and click the Install button below. Click the Zoom icon in the Plugins tab. Proceed with the plugin configuration. For more details, please refer to the ONLYOFFICE API documentation. Configuration Register the editor as the JWT app on the Zoom Develop page to use the meeting schedule. Fill in all the necessary fields and activate the app. A JWT token will be assigned to the app. If you need help filling in the fields, please refer to the official Zoom documentation. Create a Meeting SDK app on the Zoom Develop page to start joining meetings. Fill in all the necessary fields and activate the app. SDK credentials will be assigned to the app. If you need help filling in the fields, please refer to the official Zoom documentation. Enter the generated SDK Key, SDK Secret, and JWT Token into the corresponding fields in the left panel of the ONLYOFFICE editor and click Save. How to use Go to the Plugins tab. Click the Zoom icon. Add your meeting topic and choose whether you want to Start meeting or Schedule meeting. Start meeting - a new meeting will be created. All details are displayed in the editor chat. Press the Alt + Q key combination to access the chat quickly. Schedule meeting - set all required parameters for the upcoming meeting, such as time, date, duration. Access the Advanced settings for more parameters. Click Save when you are ready. Meeting notifications are sent to the Chat for online editors and to the Comments for desktop editors. Click the Reconfigure button to set the parameters once again. Click the Meeting mode button to enter the meeting menu where you can set such parameters as Name, Meeting ID, Email, and Password. Select your role, meeting region, and meeting language. Click the Join button to enter the meeting or click the Copy direct join link button to copy the meeting link to your clipboard. Once you enter the meeting, a Zoom window will open within the plugin panel. Like in your usual Zoom call, here you can enable or disable microphone and camera, perform various actions, and enter the full screen mode. A black window may appear in the Safari browser when joining a meeting. For the problem to disappear, you need to resize the plugin window or zoom in on the browser page."
    }
]