/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.online;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.ehcache.jsr107.EhcacheCachingProvider;
import org.memcached.jcache.MemcachedCachingProvider;

public class CacheFacade {
    private CacheFacade() {
    }

    public static Cache<String, String> createCache() {
        return CacheFacade.createCache("cache", 300);
    }

    public static Cache<String, String> createCache(String name, int expirationDelta) {
        CacheManager cacheManager;
        String memcachedEndpoint = System.getenv().get("DRAWIO_MEMCACHED_ENDPOINT");
        if (memcachedEndpoint != null && memcachedEndpoint.length() > 0) {
            CachingProvider provider = Caching.getCachingProvider((String)MemcachedCachingProvider.class.getName());
            Properties properties = provider.getDefaultProperties();
            properties.setProperty("servers", memcachedEndpoint);
            properties.setProperty(name + ".useSharedClientConnection", "true");
            cacheManager = provider.getCacheManager(provider.getDefaultURI(), null, properties);
        } else {
            CachingProvider provider = Caching.getCachingProvider((String)EhcacheCachingProvider.class.getName());
            cacheManager = provider.getCacheManager();
        }
        MutableConfiguration configuration = new MutableConfiguration().setStoreByValue(false).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, (long)expirationDelta)));
        return cacheManager.createCache(name, (Configuration)configuration);
    }

    public static String getStatistics() {
        return "NYI";
    }
}

