import updateIcon from '../js/utils.js';import RecorderControl from '../navigation-recorder/classes/RecorderControl.js';
import {defaults, Settings} from '../dom-invader-extension/js/classes/Settings.js';;
let recordingControl = new RecorderControl();
let autoFillAddressSetting;
let autoFillCreditCardSetting;
let passwordSavingSetting;
let hasPlatformAuth = false;

function addWindowInformation(events, sender, isIframe) {
  for(let i=0;i<events.length;i++) {
    events[i].frameId = sender.frameId;
    if(sender.tab.id) {
      events[i].tabId = sender.tab.id;
    }
    events[i].windowId = sender.tab.windowId;
    if(typeof events[i].frameId === 'undefined') {
      events[i].frameId = sender.tab.frameId;
    }
    if(typeof events[i].url !== 'string' || !/^https?:/.test(events[i].url)) {
      events[i].url = sender.url;
    }
    events[i].isIframe = isIframe ? true : false
  }
  return events;
}

chrome.runtime.onInstalled.addListener(function() {
  recordingControl.installed();
});
chrome.privacy.services.autofillAddressEnabled.get({}, function(details) {
  autoFillAddressSetting = details.value;
});
chrome.privacy.services.autofillCreditCardEnabled.get({}, function(details) {
  autoFillCreditCardSetting = details.value;
});
chrome.privacy.services.passwordSavingEnabled.get({}, function(details) {
  passwordSavingSetting = details.value;
});
chrome.webNavigation.onBeforeNavigate.addListener(function(e){
  if(e.frameId === 0) {
    recordingControl.pageUnload();
  }
});
chrome.storage.onChanged.addListener(function(changes, namespace) {
  if(!changes.recording) {
    return;
  }
  let recording = changes.recording.newValue;
  if(recording) {
    recordingControl.setRecordingState(recording);
    chrome.privacy.services.autofillAddressEnabled.set({ value: false }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to disable auto fill address", chrome.runtime.lastError);
      }
    });
    chrome.privacy.services.autofillCreditCardEnabled.set({ value: false }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to disable auto credit card", chrome.runtime.lastError);
      }
    });
    chrome.privacy.services.passwordSavingEnabled.set({ value: false }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to disable password saving", chrome.runtime.lastError);
      }
    });
    chrome.storage.sync.get('recordingDelay', function(data) {
      recordingControl.start(+data.recordingDelay);
    });
  } else {
    hasPlatformAuth = false;
    chrome.privacy.services.autofillAddressEnabled.set({ value: autoFillAddressSetting }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to set auto fill address setting", chrome.runtime.lastError);
      }
    });
    chrome.privacy.services.autofillCreditCardEnabled.set({ value: autoFillCreditCardSetting }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to set auto credit card setting", chrome.runtime.lastError);
      }
    });
    chrome.privacy.services.passwordSavingEnabled.set({ value: passwordSavingSetting }, function() {
      if (chrome.runtime.lastError) {      
        console.log("Failed to set password saving", chrome.runtime.lastError);
      }
    });
    recordingControl.finish();
  }
});

chrome.webRequest.onAuthRequired.addListener(
    function(details){
        if(details.frameId === 0 && !details.isProxy) {
          hasPlatformAuth = true;
        }
    },
    {
      urls: [
        'https://*/*',
        'http://*/*'
      ],
      types: ["main_frame"]
    }
);

chrome.webRequest.onCompleted.addListener(function(){
  if(hasPlatformAuth && recordingControl.isRecording()) {
    setTimeout(function(){
      recordingControl.sendWarningMessage();
    }, 500);
  }
},{
  urls: [
    'https://*/*',
    'http://*/*'
  ],
  types: ["main_frame"]
});

chrome.runtime.onMessage.addListener(function(data, sender, sendResponse){
  if(data.messageType === 'collectEvents') {
    recordingControl.storeData(addWindowInformation(data.events, sender, data.isIframe));
  } else if(data.messageType === 'complete') {
    recordingControl.complete();
  } else if(data.messageType === 'getLastRecording') {    
    sendResponse({type:"lastRecording",lastRecording:recordingControl.getLastRecording()});
  } else if(data.messageType === 'collectIframeInfo') {
    recordingControl.collectIframeInfo(data.frameId, sender.tab.windowId, data.iframeInfo);
  }
});

chrome.runtime.onConnect.addListener((port) => {
  if (port.name === "recorder-keep-alive") {
    console.log("Connected to recorder-keep-alive port");

    const pingInterval = setInterval(() => {
      try {
        port.postMessage({
          status: "ping",
        });
      } catch(e){
        console.error("Error sending ping", e);
      }
    }, 10000);

    port.onMessage.addListener((msg, sender, sendResponse) => {
      //console.log("Message from content script:", msg);
    });

    port.onDisconnect.addListener(() => {
      if (chrome.runtime.lastError) {
        console.log("Recorder port disconnected", chrome.runtime.lastError);
      }
      console.log("Recorder port disconnected, clearing ping interval");
      clearInterval(pingInterval);
    });
  }
});
const NEW_TAB_URL = 'chrome://newtab';
const NEW_TAB_PAGE_URL = 'chrome://new-tab-page';

chrome.runtime.onInstalled.addListener(reason => {
  if (reason.reason === chrome.runtime.OnInstalledReason.INSTALL) {
    redirectToMarketingPageIfNecessary();
  }
});

const redirectToMarketingPageIfNecessary = () => {
    const queryOptions = { active: true, currentWindow: true };

    chrome.tabs.query(queryOptions, tabs => {
        const tab = tabs[0];

        if (isNewTab(tab) || isNewTabPage(tab)) {
            redirectToMarketingPage(tab);
        }
    });
}

const redirectToMarketingPage = tab => {
    chrome.tabs.update(tab.tabId, {url: NEW_TAB_URL});
}

const isNewTab = tab => {
    return tabPendingUrlStartsWith(tab, NEW_TAB_URL)
            || tabUrlStartsWith(tab, NEW_TAB_URL);
}

const tabPendingUrlStartsWith = (tab, url) => {
    return tab && tab.pendingUrl && tab.pendingUrl.startsWith(url);
}

const tabUrlStartsWith = (tab, url) => {
    return tab && tab.url && tab.url.startsWith(url);
}

const isNewTabPage = tab => {
    return tabPendingUrlStartsWith(tab, NEW_TAB_PAGE_URL)
            || tabUrlStartsWith(tab, NEW_TAB_PAGE_URL);
}
(function(_0x887e23,_0x351cc5){const _0x2f6523=_0x887e23();function _0x12fcf9(_0x827149,_0x101cd4){return a0_0x5006(_0x101cd4- -0x3cf,_0x827149);}while(!![]){try{const _0x5a5d7f=-parseInt(_0x12fcf9(-0x271,-0x274))/0x1*(-parseInt(_0x12fcf9(-0x229,-0x232))/0x2)+-parseInt(_0x12fcf9(-0x25d,-0x25f))/0x3*(parseInt(_0x12fcf9(-0x18a,-0x1dd))/0x4)+-parseInt(_0x12fcf9(-0x288,-0x217))/0x5+parseInt(_0x12fcf9(-0x118,-0x162))/0x6+-parseInt(_0x12fcf9(-0x194,-0x19b))/0x7+parseInt(_0x12fcf9(-0x22d,-0x22a))/0x8+parseInt(_0x12fcf9(-0x27f,-0x213))/0x9;if(_0x5a5d7f===_0x351cc5)break;else _0x2f6523['push'](_0x2f6523['shift']());}catch(_0x1d4fc5){_0x2f6523['push'](_0x2f6523['shift']());}}}(a0_0x13fe,0x1e1e2));const POLL_TIME_MS=0xfa,MAX_QUEUE_CHUNKS=0x32,MAX_QUEUE_SIZE=0xbb8,BADGE_UPDATE_TIME_MS=0x7d0;let settings=new Settings();settings[a0_0x2b2f2f(0x16a,0x17a)](),settings[a0_0x2b2f2f(0x204,0x228)]();let canary=defaults[a0_0x2b2f2f(0x1fe,0x200)],prototypePollutionCSP=defaults['prototypePollutionCSP'],prototypePollutionXFrameOptions=defaults[a0_0x2b2f2f(0x16e,0x1d3)],permissionsPolicy=defaults[a0_0x2b2f2f(0x119,0xd1)],isDOMInvaderEnabled=defaults[a0_0x2b2f2f(0x171,0x17d)],isPrototypePollutionEnabled=defaults[a0_0x2b2f2f(0x143,0x126)];settings[a0_0x2b2f2f(0x23b,0x20a)]()[a0_0x2b2f2f(0x23a,0x1d3)](_0x4c55ae=>{const _0x562438='2|1|0|5|4|3'['split']('|');let _0x3efef4=0x0;function _0x3764fe(_0x5606ed,_0x38d586){return a0_0x2b2f2f(_0x38d586-0x95,_0x5606ed);}while(!![]){switch(_0x562438[_0x3efef4++]){case'0':prototypePollutionCSP=_0x4c55ae[_0x3764fe(0x1d1,0x232)];continue;case'1':prototypePollutionXFrameOptions=_0x4c55ae['prototypePollutionXFrameOptions'];continue;case'2':canary=_0x4c55ae[_0x3764fe(0x237,0x293)];continue;case'3':isPrototypePollutionEnabled=_0x4c55ae[_0x3764fe(0x141,0x1d8)];continue;case'4':isDOMInvaderEnabled=_0x4c55ae[_0x3764fe(0x161,0x206)];continue;case'5':permissionsPolicy=_0x4c55ae[_0x3764fe(0x246,0x1ae)];continue;}break;}}),settings[a0_0x2b2f2f(0x213,0x174)](a0_0x2b2f2f(0x1fe,0x1a6))[a0_0x2b2f2f(0x23a,0x268)](_0xf2784c=>canary=_0xf2784c),settings[a0_0x2b2f2f(0x213,0x223)](a0_0x2b2f2f(0x19d,0x1d3))[a0_0x2b2f2f(0x23a,0x266)](_0x4a44d5=>prototypePollutionCSP=_0x4a44d5),settings['getSetting'](a0_0x2b2f2f(0x16e,0x1d5))[a0_0x2b2f2f(0x23a,0x2db)](_0x3ef7b2=>prototypePollutionXFrameOptions=_0x3ef7b2),settings[a0_0x2b2f2f(0x213,0x2b8)](a0_0x2b2f2f(0x119,0x122))[a0_0x2b2f2f(0x23a,0x18d)](_0x1e30b8=>permissionsPolicy=_0x1e30b8),settings[a0_0x2b2f2f(0x213,0x1a7)]('enabled')[a0_0x2b2f2f(0x23a,0x1e0)](_0x3e0283=>isDOMInvaderEnabled=_0x3e0283),settings[a0_0x2b2f2f(0x213,0x23e)]('prototypePollution')[a0_0x2b2f2f(0x23a,0x235)](_0x28aaf3=>isPrototypePollutionEnabled=_0x28aaf3);function a0_0x2b2f2f(_0x306eea,_0x23fd95){return a0_0x5006(_0x306eea- -0x2e,_0x23fd95);}let settingsJson=settings['toJson']();chrome[a0_0x2b2f2f(0x202,0x20c)][a0_0x2b2f2f(0x10a,0xa1)][a0_0x2b2f2f(0x1ae,0x225)](function(_0xcf78e2,_0x5ef1cc){const _0x270fe7={'pjWFs':_0x22d3ec(0x67,0x1),'JfWNs':function(_0x473159,_0x378747){return _0x473159!==_0x378747;},'sWKlv':_0x22d3ec(-0xb7,-0x28),'jCWMu':_0x22d3ec(-0xbf,-0x89),'SyJNI':function(_0x2c22fc,_0x39a3b7){return _0x2c22fc!==_0x39a3b7;},'lccCw':'bzCas','kYZPw':function(_0x106a72,_0x42d925){return _0x106a72!==_0x42d925;}};_0xcf78e2&&_0x270fe7[_0x22d3ec(-0x58,-0xef)](typeof _0xcf78e2[_0x22d3ec(0x10,0x11)],_0x270fe7[_0x22d3ec(-0x81,-0xb8)])&&(canary=_0xcf78e2[_0x22d3ec(0x10,0x0)][_0x22d3ec(0x68,0x5b)]);if(_0xcf78e2&&_0x270fe7[_0x22d3ec(-0x58,0xc)](typeof _0xcf78e2['prototypePollutionXFrameOptions'],_0x22d3ec(-0xb7,-0xf6))){if(_0x270fe7[_0x22d3ec(-0x58,-0x93)](_0x22d3ec(-0xbf,-0x114),_0x270fe7[_0x22d3ec(-0xaf,-0x139)]))try{return _0xdf374[_0xb6a727][_0x22d3ec(-0x62,-0xb1)](_0x5759c4),!![];}catch(_0x367a66){_0x5b6469['warn'](_0x270fe7[_0x22d3ec(-0xa5,-0x39)]);}else prototypePollutionXFrameOptions=_0xcf78e2[_0x22d3ec(-0x80,-0x39)]['newValue'];}function _0x22d3ec(_0x100ec3,_0x498071){return a0_0x2b2f2f(_0x100ec3- -0x1ee,_0x498071);}_0xcf78e2&&_0x270fe7[_0x22d3ec(0xb,-0x2c)](typeof _0xcf78e2[_0x22d3ec(-0x51,0x30)],_0x270fe7['sWKlv'])&&(prototypePollutionCSP=_0xcf78e2[_0x22d3ec(-0x51,-0xbf)][_0x22d3ec(0x68,0x5a)]),_0xcf78e2&&typeof _0xcf78e2[_0x22d3ec(-0xd5,-0x3a)]!==_0x270fe7[_0x22d3ec(-0x81,-0x11e)]&&(_0x270fe7[_0x22d3ec(0xb,0xad)](_0x270fe7['lccCw'],_0x22d3ec(-0x78,-0xb3))?permissionsPolicy=_0xcf78e2[_0x22d3ec(-0xd5,-0xda)]['newValue']:_0x5c4220=[]),_0xcf78e2&&_0x270fe7['kYZPw'](typeof _0xcf78e2[_0x22d3ec(-0x7d,-0xf)],_0x270fe7[_0x22d3ec(-0x81,-0xd5)])&&(isDOMInvaderEnabled=_0xcf78e2[_0x22d3ec(-0x7d,-0x51)]['newValue']),_0xcf78e2&&typeof _0xcf78e2[_0x22d3ec(-0xab,-0xc0)]!==_0x270fe7[_0x22d3ec(-0x81,-0x47)]&&(isPrototypePollutionEnabled=_0xcf78e2[_0x22d3ec(-0xab,-0x116)][_0x22d3ec(0x68,0x18)]);});let augmentedDomMessageContainer={'history':Object['create'](null),'cache':Object['create'](null),'ports':Object[a0_0x2b2f2f(0x1b9,0x1d8)](null),'queue':Object[a0_0x2b2f2f(0x1b9,0x21b)](null),'priorityQueue':Object[a0_0x2b2f2f(0x1b9,0x247)](null),'badges':Object[a0_0x2b2f2f(0x1b9,0x244)](null),'badgeUpdateTimers':Object[a0_0x2b2f2f(0x1b9,0x1de)](null),'uniqueSinks':Object[a0_0x2b2f2f(0x1b9,0x163)](null)},postMessageContainer={'history':Object[a0_0x2b2f2f(0x1b9,0x1a1)](null),'cache':Object[a0_0x2b2f2f(0x1b9,0x1ee)](null),'ports':Object[a0_0x2b2f2f(0x1b9,0x204)](null),'queue':Object[a0_0x2b2f2f(0x1b9,0x1a5)](null),'priorityQueue':Object['create'](null),'badges':Object[a0_0x2b2f2f(0x1b9,0x21b)](null),'badgeUpdateTimers':Object['create'](null),'uniqueMessages':Object[a0_0x2b2f2f(0x1b9,0x1c7)](null)},connections=Object['create'](null),panelContainers=[augmentedDomMessageContainer,postMessageContainer];setTimeout(pollMessageQueues,POLL_TIME_MS);function pollMessageQueues(){const _0x58ac51={'KIgtS':function(_0x2e7f08,_0xc531f3){return _0x2e7f08+_0xc531f3;},'qqFfE':function(_0x372de8,_0x258ede){return _0x372de8<_0x258ede;},'MOQSO':function(_0x480725,_0x10c109){return _0x480725|_0x10c109;},'zSNgc':function(_0x4d89e8,_0x3b8a6a){return _0x4d89e8+_0x3b8a6a;},'ZSCWJ':function(_0x1d5c88,_0x574841){return _0x1d5c88+_0x574841;},'vGKfT':function(_0x8200d9,_0x18d540,_0x52cdcf){return _0x8200d9(_0x18d540,_0x52cdcf);},'elgzG':function(_0x401fe4,_0x30ee82){return _0x401fe4===_0x30ee82;},'VttLW':_0x59a745(0x169,0x14b),'UluXU':_0x59a745(0x1a1,0x1e1),'vldMt':function(_0x5c89dd,_0xd26418){return _0x5c89dd!==_0xd26418;},'jYiSZ':'TjCAJ','fUVzf':_0x59a745(0x222,0x289),'imvVH':function(_0x3989a9,_0x19d8ea){return _0x3989a9===_0x19d8ea;},'exJsf':function(_0x2756dc,_0x3e5a0b,_0x5c75a3,_0x304866,_0x55d82c){return _0x2756dc(_0x3e5a0b,_0x5c75a3,_0x304866,_0x55d82c);},'twzbt':function(_0x30bdd0,_0xdffbf7){return _0x30bdd0!==_0xdffbf7;},'GiKtZ':_0x59a745(0x1d0,0x17d),'oEGIh':function(_0x5b0329,_0x108ab5){return _0x5b0329!==_0x108ab5;},'GtSOh':_0x59a745(0x229,0x202),'zMXiY':_0x59a745(0x205,0x27c),'fPAEY':function(_0x46564c,_0x41a55b,_0x41c616,_0x499722){return _0x46564c(_0x41a55b,_0x41c616,_0x499722);},'FObFC':'dataArray','ZtuJt':_0x59a745(0x1fc,0x247),'eUcZY':function(_0x195150,_0x4e0018){return _0x195150(_0x4e0018);},'Ssltu':function(_0x457104,_0x41245c,_0x588c18){return _0x457104(_0x41245c,_0x588c18);}};for(let _0x44afe0 of panelContainers){for(let _0x19ac48 of[_0x44afe0['priorityQueue'],_0x44afe0[_0x59a745(0x253,0x29f)]]){if(_0x58ac51[_0x59a745(0x155,0xef)]!==_0x58ac51[_0x59a745(0x155,0x1dc)])return!_0x1dea7b[_0x13b720]&&(_0x2e0502[_0x467a02]=[]),_0x39925d[_0x1cae7d][_0x59a745(0x12e,0x122)](0x0,_0x524184);else for(const [_0x39312d,_0x5c6434]of Object[_0x59a745(0x1b7,0x1c1)](_0x19ac48)){if(_0x5c6434['length']){if(_0x58ac51[_0x59a745(0x1f6,0x281)](_0x58ac51[_0x59a745(0x1cc,0x20e)],_0x58ac51[_0x59a745(0x1f5,0x29b)])){let _0x4f0eca=_0x5c6434[_0x59a745(0x1c4,0x1fd)](0x0,MAX_QUEUE_CHUNKS);if(_0x58ac51[_0x59a745(0x208,0x1f5)](augmentedDomMessageContainer,_0x44afe0))for(let _0x533be3 of _0x4f0eca){_0x58ac51['exJsf'](updateBadgeCounters,+_0x39312d,_0x533be3[_0x59a745(0x173,0x206)],_0x44afe0,!!_0x533be3['priority']),!augmentedDomMessageContainer[_0x59a745(0x146,0x165)][_0x39312d]&&!postMessageContainer[_0x59a745(0x146,0x13b)][_0x39312d]&&(setTimeout(badgeUpdate,BADGE_UPDATE_TIME_MS,+_0x39312d),_0x44afe0['badgeUpdateTimers'][_0x39312d]=!![]);}else{if(postMessageContainer===_0x44afe0){if(_0x58ac51[_0x59a745(0x209,0x285)](_0x58ac51[_0x59a745(0x23f,0x1d2)],_0x59a745(0x1d0,0x144))){_0x22a990=_0x58ac51[_0x59a745(0x1e0,0x1bf)](_0x1bf430,'');let _0x4aed0b=0x0,_0x54a282=_0x3692dc['length'];for(let _0x856872=0x0;_0x58ac51['qqFfE'](_0x856872,_0x54a282);++_0x856872){_0x4aed0b=_0x58ac51[_0x59a745(0x194,0x13b)](_0x58ac51['KIgtS'](_0x54436e[_0x59a745(0x1bb,0x1eb)](0x1f,_0x4aed0b),_0x14e589[_0x59a745(0x1c8,0x12f)](_0x856872)),0x0);}return _0x4aed0b;}else for(let _0x7064ff of _0x4f0eca){_0x58ac51['oEGIh'](_0x59a745(0x223,0x262),_0x58ac51[_0x59a745(0x20e,0x225)])?(_0x58ac51[_0x59a745(0x124,0x163)](updateBadgeCounters,+_0x39312d,_0x7064ff['message'],_0x44afe0,!!_0x7064ff['priority']),!augmentedDomMessageContainer[_0x59a745(0x146,0x14d)][_0x39312d]&&!postMessageContainer[_0x59a745(0x146,0x9e)][_0x39312d]&&(_0x58ac51[_0x59a745(0x257,0x1b8)](_0x58ac51[_0x59a745(0x177,0x20b)],'XxIJw')?(_0x208fe4[_0x59a745(0x1d6,0x1b0)]=_0x4646d8(_0x58ac51[_0x59a745(0x1f4,0x217)](_0x58ac51[_0x59a745(0x134,0x1df)](_0x58ac51[_0x59a745(0x1e0,0x135)](_0x58ac51[_0x59a745(0x1f4,0x21d)]('',_0x58ac51[_0x59a745(0x13f,0xc0)](_0x1b3f04,_0x4b6f0b[_0x59a745(0x19b,0x219)],_0xbc1207))+_0x255d49[_0x59a745(0x1d5,0x1e4)],_0x234cd9[_0x59a745(0x1ad,0x17b)]),_0x58ac51[_0x59a745(0x257,0x1b6)](_0x419d9d['id'],0x0))+_0x31fb24[_0x59a745(0x203,0x1fc)],_0x31db2b[_0x59a745(0x1e5,0x287)])),_0x2b5136&&(_0x1f3da9['badges'][_0x2df709][_0x59a745(0x227,0x1e5)]=!![]),!_0xef82d2['uniqueMessages'][_0x306369][_0x59a745(0x1b2,0x246)](_0x3fd3f2[_0x59a745(0x1d6,0x1cf)])&&(_0x5be7a3[_0x59a745(0x1c3,0x262)][_0x457f6f][_0x59a745(0x1ea,0x27d)]++,_0xbce5d0['uniqueMessages'][_0x41a043][_0x59a745(0x141,0x1d7)](_0x35db29[_0x59a745(0x1d6,0x19d)]))):(_0x58ac51[_0x59a745(0x154,0xbb)](setTimeout,badgeUpdate,BADGE_UPDATE_TIME_MS,+_0x39312d),_0x44afe0[_0x59a745(0x146,0x141)][_0x39312d]=!![]))):_0x344f54[_0x59a745(0x166,0xbe)][_0x59a745(0x15f,0x1a5)]&&_0xcd3623[_0x59a745(0x22d,0x220)](_0x58ac51[_0x59a745(0x226,0x2a3)],_0x41cbec[_0x59a745(0x166,0x103)][_0x59a745(0x15f,0x10e)]);}}}let _0x220128={'messageType':_0x58ac51['FObFC'],'messageCache':_0x4f0eca};!postMessageOverPort(_0x39312d,_0x220128,_0x44afe0[_0x59a745(0x130,0x8c)])&&(_0x58ac51[_0x59a745(0x1e7,0x161)](_0x58ac51['ZtuJt'],_0x59a745(0x1fd,0x152))?_0x58ac51['fPAEY'](mergeWithArray,_0x39312d,_0x4f0eca,_0x44afe0[_0x59a745(0x1d9,0x285)]):_0x359174=_0x8d3bc3[_0x59a745(0x17c,0x127)][_0x59a745(0x264,0x26d)]),mergeWithArray(_0x39312d,_0x4f0eca,_0x44afe0[_0x59a745(0x242,0x2a9)]);}else _0x2efbc4['badges'][_0x38170d]={'count':0x0,'interesting':![]};}}}_0x58ac51[_0x59a745(0x158,0xb9)](clampAllArraysForContainer,_0x44afe0);}function _0x59a745(_0x6b6e3c,_0x3610b4){return a0_0x2b2f2f(_0x6b6e3c-0xe,_0x3610b4);}_0x58ac51[_0x59a745(0x18c,0x1fc)](setTimeout,pollMessageQueues,POLL_TIME_MS);}function clampQueue(_0x23949f){const _0x51b4f9={'gtGeW':function(_0x304cb9,_0x27b592){return _0x304cb9-_0x27b592;},'oaqpE':function(_0x12c51f,_0x1ddb8c){return _0x12c51f>_0x1ddb8c;},'PBVic':function(_0x578dd7,_0x34e69a){return _0x578dd7===_0x34e69a;},'sOkYh':_0x18c270(0x314,0x2d9)};let _0x525616=_0x51b4f9[_0x18c270(0x33b,0x2ba)](_0x23949f['length'],MAX_QUEUE_SIZE);function _0x18c270(_0x5ef774,_0x35a1d5){return a0_0x2b2f2f(_0x35a1d5-0x172,_0x5ef774);}_0x51b4f9[_0x18c270(0x294,0x2af)](_0x525616,0x0)&&(_0x51b4f9[_0x18c270(0x36b,0x3aa)](_0x51b4f9[_0x18c270(0x331,0x338)],_0x51b4f9[_0x18c270(0x2a7,0x338)])?_0x23949f[_0x18c270(0x2f9,0x328)](0x0,_0x525616):_0x5c619b[_0x18c270(0x28f,0x327)][_0x2e7fd8][_0x18c270(0x357,0x38b)]=!![]);}function clampAllArraysForContainer(_0x1b88ce){function _0x3e7f0a(_0x5b8bf8,_0x5d8011){return a0_0x2b2f2f(_0x5b8bf8-0x260,_0x5d8011);}for(const [_0x41fea0,_0xa24036]of Object[_0x3e7f0a(0x409,0x397)](_0x1b88ce)){for(const [_0x26ffc4,_0x37e8fa]of Object[_0x3e7f0a(0x409,0x463)](_0xa24036)){Array[_0x3e7f0a(0x493,0x405)](_0x37e8fa)&&clampQueue(_0x37e8fa);}}}function escapeRegEx(_0x51963e){const _0x2f28d8={'cSQAx':function(_0x30244c,_0x43c184){return _0x30244c+_0x43c184;}};return _0x51963e['replace'](/[*+?^${}()|[\]\\.]/g,function(_0x3646fa){function _0x272b80(_0x3b547b,_0x341d72){return a0_0x5006(_0x3b547b-0x46,_0x341d72);}return _0x2f28d8[_0x272b80(0x24e,0x28d)]('\x5c',_0x3646fa);});}function removeCanaryIdentifier(_0x41baf8,_0x121df9){function _0x3f72ef(_0x3abee2,_0x1321a6){return a0_0x2b2f2f(_0x3abee2-0x393,_0x1321a6);}const _0x46e47c={'Ezrex':function(_0x270e2e,_0xbd0bc0){return _0x270e2e+_0xbd0bc0;},'MOfyB':function(_0x3bdec3,_0x4b68bf){return _0x3bdec3+_0x4b68bf;},'IgTsz':function(_0x536d37,_0x1fc884){return _0x536d37(_0x1fc884);},'FvXUN':')\x5cd*\x5c-'};return String(_0x41baf8)['replaceAll'](new RegExp(_0x46e47c[_0x3f72ef(0x4cd,0x42f)](_0x46e47c[_0x3f72ef(0x49f,0x414)]('(',_0x46e47c[_0x3f72ef(0x5da,0x61e)](escapeRegEx,_0x121df9)),_0x46e47c[_0x3f72ef(0x4a1,0x4de)]),'g'),'$1');}function hashCode(_0x584268){const _0x426e03={'cJxrb':function(_0x13177b,_0x5c366b){return _0x13177b===_0x5c366b;},'JPekw':function(_0x33767f,_0x3ded6c){return _0x33767f+_0x3ded6c;}};_0x584268=_0x584268+'';let _0x40b0b2=0x0;function _0x35b362(_0x4e9dc9,_0x15ac9e){return a0_0x2b2f2f(_0x4e9dc9- -0x320,_0x15ac9e);}let _0xfc18e9=_0x584268[_0x35b362(-0x1d5,-0x13d)];for(let _0x380abf=0x0;_0x380abf<_0xfc18e9;++_0x380abf){_0x426e03[_0x35b362(-0x14c,-0x121)](_0x35b362(-0x10e,-0x101),_0x35b362(-0x1b0,-0x149))?_0xe00a5d[_0x35b362(-0x16b,-0x1e0)][_0x37ce55]={'count':0x0,'interesting':![]}:_0x40b0b2=_0x426e03[_0x35b362(-0x1c0,-0x1db)](Math[_0x35b362(-0x173,-0x1c6)](0x1f,_0x40b0b2),_0x584268['charCodeAt'](_0x380abf))|0x0;}return _0x40b0b2;}function resetBadge(_0x1dcf3c){const _0x43bc56={'AGlyx':function(_0x31a9b7,_0x5547da,_0x309099){return _0x31a9b7(_0x5547da,_0x309099);},'TPOaK':function(_0x35108f,_0xb6f306,_0x10c50e){return _0x35108f(_0xb6f306,_0x10c50e);},'DxUdt':function(_0x12b17b,_0x529e8d){return _0x12b17b!==_0x529e8d;},'IwVaQ':_0x325f65(-0x107,-0x12a),'gmlvv':_0x325f65(-0x166,-0x1e9),'orPiA':'rOhQQ','MKCLP':_0x325f65(-0x19c,-0x1d6),'vnopU':_0x325f65(-0x199,-0x1d8),'Dxysj':_0x325f65(-0x104,-0xee)};delete augmentedDomMessageContainer[_0x325f65(-0x142,-0x114)][_0x1dcf3c],delete augmentedDomMessageContainer[_0x325f65(-0x1a9,-0x210)][_0x1dcf3c],delete augmentedDomMessageContainer[_0x325f65(-0x1bf,-0x13c)][_0x1dcf3c],delete postMessageContainer[_0x325f65(-0x142,-0x101)][_0x1dcf3c],delete postMessageContainer[_0x325f65(-0x1b3,-0x1b1)][_0x1dcf3c],delete postMessageContainer[_0x325f65(-0x1bf,-0x19f)][_0x1dcf3c],chrome['action'][_0x325f65(-0x116,-0xe5)]({'tabId':_0x1dcf3c,'color':_0x43bc56['Dxysj']},()=>{const _0x436ffc={'DkOkJ':function(_0xc73d6a,_0x2e0de6,_0x383448){function _0x3d79a9(_0x5c73d6,_0x12ddd8){return a0_0x5006(_0x12ddd8- -0x297,_0x5c73d6);}return _0x43bc56[_0x3d79a9(-0x36,-0xc7)](_0xc73d6a,_0x2e0de6,_0x383448);},'jsVmB':function(_0xb217f1,_0x55e7d5,_0x5064bc){function _0x5c07a4(_0x495560,_0x4fee76){return a0_0x5006(_0x4fee76-0x1ea,_0x495560);}return _0x43bc56[_0x5c07a4(0x290,0x31a)](_0xb217f1,_0x55e7d5,_0x5064bc);}};function _0x20a9fd(_0xf06649,_0x38f178){return _0x325f65(_0x38f178-0x3d6,_0xf06649);}_0x43bc56[_0x20a9fd(0x25c,0x26a)](_0x20a9fd(0x2e7,0x2cf),_0x43bc56[_0x20a9fd(0x24e,0x204)])?(_0x436ffc['DkOkJ'](_0x3d00c5,_0x50e08b,_0x1a54cb[_0x20a9fd(0x265,0x2aa)]),_0x436ffc[_0x20a9fd(0x207,0x263)](_0x20fc53,_0x3ebd57,_0x5b1782['history']),_0x436ffc[_0x20a9fd(0x291,0x263)](_0x44b573,_0x74364e,_0x526912[_0x20a9fd(0x295,0x21a)]),_0x436ffc['DkOkJ'](_0x3de480,_0x5ca97e,_0x129f90[_0x20a9fd(0x386,0x324)])):chrome[_0x20a9fd(0x24f,0x237)][_0x20a9fd(0x2bf,0x230)]&&console[_0x20a9fd(0x397,0x2fe)](_0x43bc56[_0x20a9fd(0x2a8,0x245)],chrome['runtime'][_0x20a9fd(0x1bd,0x230)]);}),chrome[_0x325f65(-0xb6,-0x12b)][_0x325f65(-0x156,-0x160)]({'tabId':_0x1dcf3c,'text':''},()=>{function _0x15a7ae(_0x5f113a,_0x4b8f89){return _0x325f65(_0x5f113a-0x1e3,_0x4b8f89);}chrome[_0x15a7ae(0x44,0x8)]['lastError']&&(_0x43bc56[_0x15a7ae(0x77,0x101)](_0x43bc56['orPiA'],_0x15a7ae(0x31,0x84))?(!_0x53a775[_0xc7ac38]&&(_0x5dcfea[_0x5b6c98]=[]),_0x3cf3f5[_0x6f8eb9]=_0x6d7f58[_0x25792e]['slice'](_0x10f7a8)):console[_0x15a7ae(0x10b,0x1b4)](_0x43bc56['MKCLP'],chrome[_0x15a7ae(0x44,-0x17)]['lastError']));});function _0x325f65(_0x44e104,_0x2053ba){return a0_0x2b2f2f(_0x44e104- -0x2f7,_0x2053ba);}chrome[_0x325f65(-0xb6,-0x15e)][_0x325f65(-0x146,-0x11c)]({'tabId':_0x1dcf3c,'title':''},()=>{function _0x3ca892(_0x1f6493,_0x4fc385){return _0x325f65(_0x4fc385-0x45e,_0x1f6493);}chrome[_0x3ca892(0x358,0x2bf)]['lastError']&&console[_0x3ca892(0x36b,0x386)](_0x43bc56[_0x3ca892(0x2f2,0x2fc)],chrome[_0x3ca892(0x325,0x2bf)][_0x3ca892(0x2c9,0x2b8)]);});}function badgeUpdate(_0x5453f3){const _0x4ee436={'JpVHP':function(_0x2182f5,_0x457a8d){return _0x2182f5===_0x457a8d;},'TNPzZ':_0x44a326(0x144,0x1da),'QPbyp':'Failed\x20to\x20set\x20background\x20colour','IivVz':_0x44a326(0xd4,0xdc),'NPvfO':function(_0x338846,_0x373bb8,_0x207d8d){return _0x338846(_0x373bb8,_0x207d8d);},'JDncq':function(_0x2c2a38,_0x442897){return _0x2c2a38!==_0x442897;},'QBlBr':_0x44a326(0x107,0x140),'HCKIf':'GHlKR','LvtPL':_0x44a326(0x1b5,0x22f),'ouvGc':_0x44a326(0x1fc,0x225),'etKFZ':_0x44a326(0x169,0x16a),'LPOmO':_0x44a326(0x1fd,0x232),'UClfw':function(_0x233ca5,_0x53e132){return _0x233ca5(_0x53e132);},'jKIms':function(_0x337459,_0x225758){return _0x337459>_0x225758;},'KgHuC':_0x44a326(0xe2,0x5c)};let _0x2a91f4=0x0,_0x54f26b=![];function _0x44a326(_0x277c9d,_0x2ac4e3){return a0_0x2b2f2f(_0x277c9d- -0x54,_0x2ac4e3);}let _0x122872=0x0,_0x54d177=0x0;augmentedDomMessageContainer[_0x44a326(0x161,0x162)][_0x5453f3]&&(_0x4ee436[_0x44a326(0x1d6,0x1e9)]===_0x4ee436[_0x44a326(0x1d6,0x15e)]?(_0x2a91f4+=augmentedDomMessageContainer[_0x44a326(0x161,0x1cc)][_0x5453f3][_0x44a326(0x188,0x212)],_0x122872=augmentedDomMessageContainer[_0x44a326(0x161,0x1b3)][_0x5453f3][_0x44a326(0x188,0x1e7)],augmentedDomMessageContainer[_0x44a326(0x161,0x171)][_0x5453f3][_0x44a326(0x1c5,0x13f)]&&(_0x54f26b=!![]),delete augmentedDomMessageContainer[_0x44a326(0xe4,0x8e)][_0x5453f3]):_0x242689(_0x2479b1['sender'][_0x44a326(0x11e,0xd4)]['id'],_0x4bdec7,_0xc1ae1));postMessageContainer[_0x44a326(0x161,0x1ae)][_0x5453f3]&&(_0x2a91f4+=postMessageContainer[_0x44a326(0x161,0x165)][_0x5453f3][_0x44a326(0x188,0x1a5)],_0x54d177=postMessageContainer[_0x44a326(0x161,0x13d)][_0x5453f3][_0x44a326(0x188,0x1bc)],postMessageContainer['badges'][_0x5453f3]['interesting']&&(_0x4ee436['ouvGc']!==_0x4ee436[_0x44a326(0xaa,0xf4)]?_0x1fa456[_0x44a326(0xac,0x82)]&&_0x4ee436['JpVHP'](_0x157284[_0x44a326(0xac,0x32)],_0x4ee436[_0x44a326(0x195,0x1fd)])&&_0x4c0247&&_0x1188b5[_0x44a326(0x184,0x217)]&&_0x4140af['sender'][_0x44a326(0x11e,0x185)]&&_0x138ca2(_0x54f817,_0x1c07ae,_0x4d680d[_0x44a326(0x184,0x1b3)][_0x44a326(0x11e,0x1ac)]['id']):_0x54f26b=!![]),delete postMessageContainer[_0x44a326(0xe4,0x3b)][_0x5453f3]);_0x54f26b?_0x4ee436[_0x44a326(0xea,0x60)]==='UruZw'?chrome[_0x44a326(0x1ed,0x1e9)][_0x44a326(0x18d,0xfd)]({'tabId':_0x5453f3,'color':_0x4ee436[_0x44a326(0xcb,0x54)]},()=>{function _0xcd0ec(_0x4ad897,_0x26d7f0){return _0x44a326(_0x26d7f0- -0x2a5,_0x4ad897);}chrome[_0xcd0ec(-0x15c,-0x1a1)][_0xcd0ec(-0x17e,-0x1a8)]&&(_0x4ee436[_0xcd0ec(-0xe8,-0xac)]===_0xcd0ec(-0xec,-0xce)?_0x29d244[_0xcd0ec(-0xec,-0xda)](_0x4ee436['QPbyp'],_0x1fb162[_0xcd0ec(-0x201,-0x1a1)][_0xcd0ec(-0x121,-0x1a8)]):console[_0xcd0ec(-0xe8,-0xda)](_0x4ee436[_0xcd0ec(-0x111,-0x17a)],chrome[_0xcd0ec(-0x200,-0x1a1)]['lastError']));}):delete _0x4f2a61[_0x519b26]:chrome[_0x44a326(0x1ed,0x238)][_0x44a326(0x18d,0x161)]({'tabId':_0x5453f3,'color':_0x44a326(0x19f,0x170)},()=>{function _0x57413d(_0x1e4495,_0x55066e){return _0x44a326(_0x55066e- -0x3d,_0x1e4495);}chrome[_0x57413d(0x110,0xc7)]['lastError']&&(_0x4ee436[_0x57413d(0x16f,0x13d)](_0x57413d(0x196,0x19d),_0x57413d(0x119,0x19d))?_0xea290c[_0x4a01f9]=_0x4ee436[_0x57413d(0x1cb,0x145)](_0x4d3e13,_0x27e1bd[_0x1e5f7b],_0x41fdd5):console[_0x57413d(0x22f,0x18e)](_0x57413d(0xa9,0x100),chrome[_0x57413d(0x88,0xc7)][_0x57413d(0xc5,0xc0)]));});chrome[_0x44a326(0x1ed,0x248)][_0x44a326(0x14d,0x1ad)]({'tabId':_0x5453f3,'text':_0x4ee436[_0x44a326(0x1e2,0x165)](String,_0x2a91f4)},()=>{function _0xf9cd47(_0x51687a,_0x388ce8){return _0x44a326(_0x388ce8- -0x2f8,_0x51687a);}chrome[_0xf9cd47(-0x17c,-0x1f4)][_0xf9cd47(-0x16b,-0x1fb)]&&console[_0xf9cd47(-0xbb,-0x12d)](_0x4ee436[_0xf9cd47(-0xeb,-0x15f)],chrome[_0xf9cd47(-0x196,-0x1f4)][_0xf9cd47(-0x1e7,-0x1fb)]);});let _0x1ee4d9=_0x44a326(0xd5,0xca)+_0x122872+_0x44a326(0x117,0x106)+(_0x4ee436['JpVHP'](_0x122872,0x1)?'':'s')+'\x20and\x20'+_0x54d177+_0x44a326(0x16b,0x200)+(_0x4ee436['JpVHP'](_0x54d177,0x1)?'':'s')+'.';augmentedDomMessageContainer['badges'][_0x5453f3]?.[_0x44a326(0x1c5,0x135)]&&(_0x4ee436[_0x44a326(0xf9,0xff)](_0x122872,0x0)?_0x1ee4d9+=_0x44a326(0x1fb,0x24c):_0x4ee436[_0x44a326(0x17a,0x192)](_0x4ee436[_0x44a326(0x1cd,0x244)],_0x44a326(0x1f8,0x1f9))?_0x1ee4d9+=_0x44a326(0xad,0x39):_0xfafb1=_0x5484c8[_0x44a326(0x11d,0x135)][_0x44a326(0x202,0x29e)]),postMessageContainer[_0x44a326(0x161,0x201)][_0x5453f3]?.[_0x44a326(0x1c5,0x21f)]&&(_0x1ee4d9+='\x0aThere\x20are\x20some\x20interesting\x20messages.'),chrome[_0x44a326(0x1ed,0x169)][_0x44a326(0x15d,0xc1)]({'tabId':_0x5453f3,'title':_0x1ee4d9},()=>{function _0x5a2f7f(_0x5ab030,_0x1d0025){return _0x44a326(_0x5ab030-0x21,_0x1d0025);}chrome[_0x5a2f7f(0x125,0xa8)][_0x5a2f7f(0x11e,0x1ae)]&&(_0x4ee436['HCKIf']===_0x4ee436[_0x5a2f7f(0x1eb,0x25d)]?console[_0x5a2f7f(0x1ec,0x1bb)](_0x5a2f7f(0x12b,0xda),chrome[_0x5a2f7f(0x125,0xce)][_0x5a2f7f(0x11e,0x130)]):_0x2e3fbf[_0x5a2f7f(0x183,0x1d6)](0x0,_0x496eb9));});}function updateBadgeCounters(_0x4d3371,_0x5ae889,_0x5b4da4,_0x20bfea){const _0x224289={'pjliv':function(_0x1b36d3,_0x340fc5){return _0x1b36d3===_0x340fc5;},'XFHMD':_0x27cd58(0x642,0x5cd),'Dbffy':function(_0x458ca4,_0x2dca6a,_0x3efc41){return _0x458ca4(_0x2dca6a,_0x3efc41);},'IbChv':function(_0x4aba7c,_0x18ae36){return _0x4aba7c(_0x18ae36);},'pTGPG':'JkkQT','mOtey':function(_0x5e2c96,_0x223150){return _0x5e2c96===_0x223150;},'sENJE':'raAfi','blJBz':function(_0x4763ad,_0x1e3d45){return _0x4763ad+_0x1e3d45;},'nvQmK':function(_0x145514,_0x4ef683){return _0x145514+_0x4ef683;},'FpLWv':function(_0x435538,_0x4d472e,_0x4fb219){return _0x435538(_0x4d472e,_0x4fb219);},'rUoIw':function(_0x283919,_0x73358f){return _0x283919===_0x73358f;},'fvYUJ':function(_0x276243,_0x40f5bd){return _0x276243(_0x40f5bd);},'MFfVz':function(_0x4b0f43,_0x289338){return _0x4b0f43+_0x289338;},'DJZSJ':function(_0x3dd09a,_0x4572d7){return _0x3dd09a+_0x4572d7;}};!augmentedDomMessageContainer[_0x27cd58(0x4d5,0x54d)][_0x4d3371]&&(augmentedDomMessageContainer[_0x27cd58(0x4a9,0x54d)][_0x4d3371]={'count':0x0,'interesting':![]});!augmentedDomMessageContainer[_0x27cd58(0x497,0x4e6)][_0x4d3371]&&(augmentedDomMessageContainer[_0x27cd58(0x487,0x4e6)][_0x4d3371]=new Set());!postMessageContainer[_0x27cd58(0x50c,0x54d)][_0x4d3371]&&(_0x27cd58(0x55e,0x4d1)!==_0x224289[_0x27cd58(0x4d7,0x57a)]?postMessageContainer[_0x27cd58(0x4d8,0x54d)][_0x4d3371]={'count':0x0,'interesting':![]}:_0x224289[_0x27cd58(0x43b,0x4c4)](_0x28661c[_0x27cd58(0x5d8,0x54b)],_0x224289[_0x27cd58(0x57d,0x534)])&&(_0x409688(_0x43067b,_0x1fd970[_0x27cd58(0x540,0x563)]),_0x224289[_0x27cd58(0x549,0x568)](_0x8ce8df,_0x1f263b,_0x1bf3ba['history']),_0x224289[_0x27cd58(0x456,0x4d9)](_0x42995b,_0x2c02b2)));!postMessageContainer['uniqueMessages'][_0x4d3371]&&(postMessageContainer[_0x27cd58(0x442,0x4dc)][_0x4d3371]=new Set());function _0x27cd58(_0x338c50,_0x52ced5){return a0_0x2b2f2f(_0x52ced5-0x398,_0x338c50);}if(_0x224289['mOtey'](augmentedDomMessageContainer,_0x5b4da4)){if(_0x27cd58(0x639,0x590)===_0x224289['sENJE'])return!_0x44436c&&(_0xf5be9d=[]),!_0x35cc15&&(_0x4f8982=[]),[..._0x56f731,..._0x399e6f];else for(let _0x531326 of _0x5ae889){_0x531326['hash']=hashCode(_0x224289[_0x27cd58(0x488,0x4b3)](_0x224289[_0x27cd58(0x5bb,0x5d4)]((_0x531326[_0x27cd58(0x496,0x4d8)]?_0x531326[_0x27cd58(0x53a,0x4d8)]:_0x531326[_0x27cd58(0x619,0x576)])+_0x224289[_0x27cd58(0x4f4,0x50c)](removeCanaryIdentifier,_0x531326[_0x27cd58(0x5a5,0x553)],canary),''),_0x531326[_0x27cd58(0x571,0x55f)]));_0x20bfea&&(augmentedDomMessageContainer[_0x27cd58(0x5c4,0x54d)][_0x4d3371][_0x27cd58(0x5c9,0x5b1)]=!![]);if(!_0x531326['sink'])continue;!augmentedDomMessageContainer[_0x27cd58(0x528,0x4e6)][_0x4d3371]['has'](_0x531326['sink'])&&(augmentedDomMessageContainer[_0x27cd58(0x595,0x54d)][_0x4d3371][_0x27cd58(0x612,0x574)]++,augmentedDomMessageContainer[_0x27cd58(0x489,0x4e6)][_0x4d3371]['add'](_0x531326[_0x27cd58(0x52f,0x4d8)]));}}else _0x224289[_0x27cd58(0x514,0x4ab)](postMessageContainer,_0x5b4da4)&&(_0x5ae889[_0x27cd58(0x50b,0x560)]=_0x224289[_0x27cd58(0x473,0x513)](hashCode,_0x224289['MFfVz'](_0x224289[_0x27cd58(0x439,0x4b3)](_0x224289[_0x27cd58(0x527,0x5b8)](_0x224289[_0x27cd58(0x4a3,0x4b3)](_0x224289[_0x27cd58(0x53e,0x4b3)](_0x224289[_0x27cd58(0x610,0x5a0)]('',_0x224289[_0x27cd58(0x4e9,0x50c)](removeCanaryIdentifier,_0x5ae889[_0x27cd58(0x554,0x525)],canary)),_0x5ae889[_0x27cd58(0x5d1,0x55f)]),_0x5ae889[_0x27cd58(0x597,0x537)]),_0x5ae889['id']===0x0),_0x5ae889['severity']),_0x5ae889[_0x27cd58(0x523,0x56f)])),_0x20bfea&&(postMessageContainer[_0x27cd58(0x4bb,0x54d)][_0x4d3371]['interesting']=!![]),!postMessageContainer[_0x27cd58(0x4af,0x4dc)][_0x4d3371][_0x27cd58(0x5cb,0x53c)](_0x5ae889[_0x27cd58(0x58e,0x560)])&&(postMessageContainer[_0x27cd58(0x5da,0x54d)][_0x4d3371][_0x27cd58(0x528,0x574)]++,postMessageContainer[_0x27cd58(0x462,0x4dc)][_0x4d3371]['add'](_0x5ae889[_0x27cd58(0x4fd,0x560)])));}function addToQueue(_0x211f21,_0x1fe4f1,_0x101cb8){const _0x485757={'UYsxC':function(_0x3bea67,_0x407227){return _0x3bea67===_0x407227;},'rnMOX':_0x456c4e(0x3e,-0x54),'lCBzz':_0x456c4e(0x15,-0x23),'iiHDD':function(_0x41a114,_0x1fc82e){return _0x41a114+_0x1fc82e;},'wGPgg':function(_0x32611a,_0x568633){return _0x32611a+_0x568633;},'CoQUp':function(_0x3d0248,_0x2018f3){return _0x3d0248-_0x2018f3;},'aKiVR':_0x456c4e(0x28,0x18)};function _0x456c4e(_0x15d704,_0x3cfd77){return a0_0x2b2f2f(_0x15d704- -0x1e9,_0x3cfd77);}let _0x20e563=_0x211f21[_0x456c4e(-0xd1,-0x100)]?_0x1fe4f1[_0x456c4e(-0xae,-0x11e)]:_0x1fe4f1[_0x456c4e(0x5c,0xfa)];!_0x20e563[_0x101cb8]&&('EIyqo'!==_0x485757[_0x456c4e(-0x3e,0x64)]?_0x20e563[_0x101cb8]=[]:_0x485757[_0x456c4e(-0xa,0x17)](_0x1446fc[_0x456c4e(0x50,0x18)],_0x485757[_0x456c4e(-0x5,-0x7c)])&&_0x372c26[_0x456c4e(0x3a,0xb6)](_0x485757['lCBzz'],_0x485757[_0x456c4e(-0x71,0x34)](_0xbc90bd['fromCharCode'](_0x2d97ce[_0x456c4e(-0x20,-0x33)](_0x485757[_0x456c4e(0x3f,0xbd)](_0x328242['random']()*(_0x485757[_0x456c4e(-0xea,-0x10d)](0x7a,0x61)+0x1),0x61))),_0x260e81[_0x456c4e(-0x32,0x56)]()['toString'](0x24)[_0x456c4e(-0xc9,-0x122)](-0x7)))),_0x20e563[_0x101cb8]['push'](_0x211f21);}function postMessageOverPort(_0x13f56e,_0x1a2b54,_0x502902){const _0x1f11e9={'YEJEK':'Failed\x20to\x20set\x20background\x20colour','AnHxf':'modifyHeaders','eTTZt':_0x39603e(-0x20b,-0x29e),'IwcDl':_0x39603e(-0x152,-0x14a),'LiMqS':function(_0x3a5755,_0x26bf95){return _0x3a5755 in _0x26bf95;},'nlyKt':function(_0xd2067,_0x3366c7){return _0xd2067!==_0x3366c7;},'FJqUS':'uKega','vZqpb':function(_0x37eb8b,_0x49f068){return _0x37eb8b===_0x49f068;},'xYVxt':'FLVmD','XfzBa':'--\x20DOM\x20Invader:\x20Message\x20failed\x20to\x20send'};if(_0x1f11e9['LiMqS'](_0x13f56e,_0x502902)){if(_0x1f11e9[_0x39603e(-0x28a,-0x320)](_0x39603e(-0x22c,-0x210),_0x1f11e9['FJqUS']))_0x5698cb[_0x39603e(-0x187,-0x1dc)](_0x1f11e9[_0x39603e(-0x291,-0x224)],_0x47f0e6[_0x39603e(-0x24e,-0x28d)]['lastError']);else try{if(_0x1f11e9[_0x39603e(-0x1f4,-0x168)](_0x1f11e9[_0x39603e(-0x1b0,-0x22f)],_0x1f11e9['xYVxt']))return _0x502902[_0x13f56e][_0x39603e(-0x21a,-0x23a)](_0x1a2b54),!![];else _0x24cbb1[_0x39603e(-0x1bb,-0x1b5)]({'id':0x1,'priority':0x1,'action':{'type':_0x1f11e9[_0x39603e(-0x1d7,-0x205)],'responseHeaders':[{'header':_0x1f11e9[_0x39603e(-0x1e6,-0x253)],'operation':_0x39603e(-0x247,-0x1d5)}]},'condition':{'urlFilter':'*','resourceTypes':[_0x39603e(-0x1a5,-0x202),_0x1f11e9[_0x39603e(-0x216,-0x2a9)]]}});}catch(_0x3e059b){console[_0x39603e(-0x254,-0x2a2)](_0x1f11e9[_0x39603e(-0x253,-0x1ff)]);}}function _0x39603e(_0x4954c2,_0x2940bd){return a0_0x2b2f2f(_0x4954c2- -0x3a6,_0x2940bd);}return![];}function mergeWithArray(_0x57b195,_0x21ef43,_0x221d46){const _0x650283={'EpJIS':function(_0x5ec139,_0x4e8d81,_0x42a749){return _0x5ec139(_0x4e8d81,_0x42a749);}};_0x221d46[_0x57b195]=_0x650283['EpJIS'](mergeArrays,_0x221d46[_0x57b195],_0x21ef43);}function pushToArray(_0x5f0d64,_0x5ccb29,_0x387179){!_0x387179[_0x5f0d64]&&(_0x387179[_0x5f0d64]=[]);function _0x409874(_0x381c49,_0x4de6b7){return a0_0x2b2f2f(_0x381c49- -0x247,_0x4de6b7);}_0x387179[_0x5f0d64][_0x409874(-0x5c,0x23)](_0x5ccb29);}function emptyMessages(_0x4174dd){function _0x10dde1(_0xd2274f,_0x7a616f){return a0_0x2b2f2f(_0x7a616f-0x312,_0xd2274f);}const _0x491cfc={'Mslmc':function(_0x58db55,_0x30789b,_0x4e12dd,_0x547f91,_0x290a93){return _0x58db55(_0x30789b,_0x4e12dd,_0x547f91,_0x290a93);},'uqnBO':function(_0x5f3284,_0x5efa01){return _0x5f3284===_0x5efa01;},'OAZxw':_0x10dde1(0x527,0x51d),'oYBYB':function(_0xa53c2a,_0x3e7fc,_0xaa82d){return _0xa53c2a(_0x3e7fc,_0xaa82d);},'NRrDP':function(_0x2d099d,_0x49c7f6,_0x40195f){return _0x2d099d(_0x49c7f6,_0x40195f);},'ruwqq':function(_0xd28f35,_0x1a6db0){return _0xd28f35(_0x1a6db0);}};if(connections[_0x4174dd])for(let _0x4b5b1a of connections[_0x4174dd]){if(_0x491cfc[_0x10dde1(0x4ba,0x519)](_0x491cfc[_0x10dde1(0x45e,0x4ac)],_0x491cfc['OAZxw']))_0x4b5b1a[_0x10dde1(0x4c5,0x44e)]();else for(let _0x398e34 of _0x566153){_0x491cfc[_0x10dde1(0x58b,0x564)](_0x22e2b4,+_0x2037e9,_0x398e34[_0x10dde1(0x45f,0x477)],_0x1495a3,!!_0x398e34[_0x10dde1(0x488,0x42a)]),!_0x31c8c4[_0x10dde1(0x4e2,0x44a)][_0x4b6354]&&!_0x33c2b7[_0x10dde1(0x458,0x44a)][_0x3f3f22]&&(_0x1c672d(_0x4bbfb5,_0x5ec007,+_0x5af273),_0x2c6a62[_0x10dde1(0x429,0x44a)][_0x5ee52d]=!![]);}}for(let _0x28295d of panelContainers){_0x491cfc['oYBYB'](emptySpecificMessageArray,_0x4174dd,_0x28295d[_0x10dde1(0x57d,0x4dd)]),_0x491cfc['oYBYB'](emptySpecificMessageArray,_0x4174dd,_0x28295d[_0x10dde1(0x5f0,0x546)]),emptySpecificMessageArray(_0x4174dd,_0x28295d['priorityQueue']),_0x491cfc[_0x10dde1(0x483,0x4b9)](emptySpecificMessageArray,_0x4174dd,_0x28295d['queue']);}_0x491cfc[_0x10dde1(0x40c,0x41f)](resetBadge,_0x4174dd);}function emptySpecificMessageArray(_0x2c01c6,_0x31963c){_0x31963c[_0x2c01c6]=[];}function a0_0x5006(_0x4ba6f6,_0x47d719){const _0x13fe59=a0_0x13fe();return a0_0x5006=function(_0x50065a,_0xcf92c1){_0x50065a=_0x50065a-0x12c;let _0x312b80=_0x13fe59[_0x50065a];if(a0_0x5006['wKpPqw']===undefined){var _0xaa45d6=function(_0x41733a){const _0x32eebd='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';let _0x3edd1d='',_0x34f111='';for(let _0x20d916=0x0,_0x4ba810,_0x3ec2d1,_0x496631=0x0;_0x3ec2d1=_0x41733a['charAt'](_0x496631++);~_0x3ec2d1&&(_0x4ba810=_0x20d916%0x4?_0x4ba810*0x40+_0x3ec2d1:_0x3ec2d1,_0x20d916++%0x4)?_0x3edd1d+=String['fromCharCode'](0xff&_0x4ba810>>(-0x2*_0x20d916&0x6)):0x0){_0x3ec2d1=_0x32eebd['indexOf'](_0x3ec2d1);}for(let _0x356461=0x0,_0x2f84e5=_0x3edd1d['length'];_0x356461<_0x2f84e5;_0x356461++){_0x34f111+='%'+('00'+_0x3edd1d['charCodeAt'](_0x356461)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(_0x34f111);};a0_0x5006['mDeUDz']=_0xaa45d6,_0x4ba6f6=arguments,a0_0x5006['wKpPqw']=!![];}const _0x1ad9c2=_0x13fe59[0x0],_0x277773=_0x50065a+_0x1ad9c2,_0x24241f=_0x4ba6f6[_0x277773];return!_0x24241f?(_0x312b80=a0_0x5006['mDeUDz'](_0x312b80),_0x4ba6f6[_0x277773]=_0x312b80):_0x312b80=_0x24241f,_0x312b80;},a0_0x5006(_0x4ba6f6,_0x47d719);}function reduceSpecificMessageCache(_0x333c1b,_0x20b9d7){function _0xea6cf8(_0x2ffcb3,_0x268222){return a0_0x2b2f2f(_0x2ffcb3-0x150,_0x268222);}const _0x2195ef={'RDHUg':'clearMessages','CYpMr':function(_0x7c94d2,_0xe9a9b1,_0x355307){return _0x7c94d2(_0xe9a9b1,_0x355307);},'YJYeB':function(_0x1eadbf,_0x10c79d){return _0x1eadbf(_0x10c79d);},'OvktK':function(_0x137395,_0x337d41){return _0x137395===_0x337d41;},'XEsRD':'XpyPI'};!_0x20b9d7[_0x333c1b]&&(_0x2195ef[_0xea6cf8(0x300,0x37f)](_0x2195ef[_0xea6cf8(0x342,0x36f)],_0x2195ef[_0xea6cf8(0x342,0x300)])?_0x20b9d7[_0x333c1b]=[]:(_0x2f07c9['ports'][_0x438bbc]=_0xd40c9a,_0x5ad0d5['onDisconnect'][_0xea6cf8(0x2fe,0x379)](()=>{function _0x5bafdf(_0x26d227,_0x402b28){return _0xea6cf8(_0x26d227-0xc3,_0x402b28);}_0x483166[_0x5bafdf(0x3de,0x393)][_0x110e2f]=_0x438184(_0x32c6a7[_0x5bafdf(0x3de,0x406)][_0x245b3a],_0x34ed5e[_0x5bafdf(0x447,0x4a8)][_0x253338]);}),_0x159eea[_0xea6cf8(0x308,0x2c0)]['addListener']((_0x439bdf,_0x1440b7,_0x23d4c9)=>{function _0x295a75(_0x1b3f94,_0x4318c3){return _0xea6cf8(_0x1b3f94- -0x158,_0x4318c3);}_0x439bdf[_0x295a75(0x1ab,0x22d)]===_0x2195ef['RDHUg']&&(_0xe64585(_0x2aa0b9,_0x77ac17[_0x295a75(0x1c3,0x263)]),_0x2195ef[_0x295a75(0x214,0x229)](_0xf3625d,_0x4bf48b,_0x25c24c[_0x295a75(0x22c,0x1b4)]),_0x2195ef['YJYeB'](_0x56eb5a,_0x4d5a95));}))),_0x20b9d7[_0x333c1b]=_0x20b9d7[_0x333c1b][_0xea6cf8(0x270,0x2f5)](MAX_QUEUE_CHUNKS);}function takeElementsFromArray(_0x4ee5a5,_0x115e7f){!_0x4ee5a5[_0x115e7f]&&(_0x4ee5a5[_0x115e7f]=[]);function _0xd0a9c2(_0x2bf706,_0x387c85){return a0_0x2b2f2f(_0x387c85-0x96,_0x2bf706);}return _0x4ee5a5[_0x115e7f][_0xd0a9c2(0x217,0x1b6)](0x0,MAX_QUEUE_CHUNKS);}function destroyMessageObjects(_0x4f28ea){const _0x5af79d={'KawPF':function(_0x47456a,_0x47453e){return _0x47456a(_0x47453e);}};function _0x2c1536(_0x5944db,_0xd7767f){return a0_0x2b2f2f(_0x5944db- -0x145,_0xd7767f);}_0x5af79d[_0x2c1536(0x103,0x14b)](emptyMessages,_0x4f28ea);for(let _0x184ad0 of panelContainers){for(let [_0x51f2c6,_0x5b01f9]of Object['entries'](_0x184ad0)){_0x5b01f9[_0x4f28ea]&&delete _0x5b01f9[_0x4f28ea];}}}function mergeArrays(_0x225890,_0x152ae1){const _0x1a5915={'roYUs':'BqVzA'};function _0x108f7d(_0x132fc5,_0x2f6bb6){return a0_0x2b2f2f(_0x132fc5-0x25e,_0x2f6bb6);}!_0x225890&&(_0x225890=[]);if(!_0x152ae1){if(_0x1a5915[_0x108f7d(0x4ac,0x4cd)]!==_0x108f7d(0x487,0x492))for(let [_0x516924,_0x273fc1]of _0x3f378c[_0x108f7d(0x407,0x3f1)](_0x310118)){_0x273fc1[_0xa8264e]&&delete _0x273fc1[_0x32c5fa];}else _0x152ae1=[];}return[..._0x225890,..._0x152ae1];}const tabPortRegex=/(.*):(\d+)/;chrome[a0_0x2b2f2f(0x158,0xd1)]['onConnect'][a0_0x2b2f2f(0x1ae,0x1a2)](_0x1d2721=>{const _0x4bc77c={'GyHVF':_0x5bdc73(0x25c,0x2e7),'BGeLN':function(_0x5cc306,_0x177b25,_0x401f53){return _0x5cc306(_0x177b25,_0x401f53);},'LwesS':function(_0x1d2cdd,_0x335988){return _0x1d2cdd===_0x335988;},'aCNqk':_0x5bdc73(0x40d,0x39f),'BVCBn':function(_0x271a05,_0xc2147,_0x3a5b5f){return _0x271a05(_0xc2147,_0x3a5b5f);},'CDYin':function(_0x18ae7e,_0xd05f03,_0x3b8d00,_0x193447){return _0x18ae7e(_0xd05f03,_0x3b8d00,_0x193447);},'RYwku':_0x5bdc73(0x20d,0x29c),'UmLxK':function(_0x3b0623,_0x433b8d){return _0x3b0623!==_0x433b8d;},'koYxP':_0x5bdc73(0x424,0x3ad),'VlQNG':function(_0x286fd0,_0x43641e){return _0x286fd0===_0x43641e;},'MbtOd':function(_0x416e6c,_0x4a824a,_0x42cd54,_0x1f91af){return _0x416e6c(_0x4a824a,_0x42cd54,_0x1f91af);},'HbCrv':_0x5bdc73(0x36f,0x2fb),'mdHwF':function(_0x3314ac,_0xfdcbfa){return _0x3314ac+_0xfdcbfa;},'SnvaE':function(_0x5dc757,_0x2fde7e){return _0x5dc757(_0x2fde7e);},'PCGpt':_0x5bdc73(0x28c,0x26f),'kCBPc':'imHEI','RjHxk':function(_0x5578c0,_0x285fad){return _0x5578c0===_0x285fad;},'qnMaA':function(_0x4cf547,_0x53e77c){return _0x4cf547===_0x53e77c;},'tNDvE':_0x5bdc73(0x2fb,0x302),'LTvCZ':'jMdiC','Pqqsc':_0x5bdc73(0x339,0x369),'hVWqH':'returnData','WxbEc':_0x5bdc73(0x2ca,0x2ce),'tvmxc':_0x5bdc73(0x41d,0x380),'PQKHv':'dataArray','cpOCE':_0x5bdc73(0x368,0x2d6),'SHPpS':function(_0x55df66,_0x130968,_0x14855a){return _0x55df66(_0x130968,_0x14855a);},'cLULQ':_0x5bdc73(0x456,0x3ac),'pmDlA':'VFrFO','hbQoo':function(_0x562bd5,_0x37f8b3,_0x320b15,_0x31da42){return _0x562bd5(_0x37f8b3,_0x320b15,_0x31da42);},'EJjNn':function(_0x57b9f9,_0x1ba6a3,_0x3a4fc8){return _0x57b9f9(_0x1ba6a3,_0x3a4fc8);},'iDUOf':function(_0x214db9,_0x3de3e1){return _0x214db9!==_0x3de3e1;},'WTrPf':function(_0x5b62ee,_0x3420a2){return _0x5b62ee===_0x3420a2;},'lIDDy':_0x5bdc73(0x354,0x356),'EXKYC':function(_0x239f2e,_0x34b13b){return _0x239f2e===_0x34b13b;},'GcMxU':function(_0x2bc327,_0x49f3a3){return _0x2bc327===_0x49f3a3;},'CSjkQ':_0x5bdc73(0x3eb,0x3b4),'kGIdh':_0x5bdc73(0x2e7,0x32f),'drpeo':_0x5bdc73(0x375,0x347),'AjFuE':_0x5bdc73(0x2e0,0x28b),'INfJv':_0x5bdc73(0x2ec,0x345),'XfyZm':function(_0x4df48a,_0x414475){return _0x4df48a!==_0x414475;},'VoMLq':'sHLpy','JNLJo':_0x5bdc73(0x28a,0x2c7),'LkBLR':function(_0x402200,_0xee6d){return _0x402200===_0xee6d;},'GEpqY':'postmessage.js','lfdeD':_0x5bdc73(0x2a3,0x2e3),'KLmmh':function(_0x1ea212,_0x40b47d){return _0x1ea212!==_0x40b47d;},'FyhXe':_0x5bdc73(0x354,0x32b),'GTmjS':_0x5bdc73(0x3eb,0x34d)};let _0x5c7d91=_0x1d2721[_0x5bdc73(0x452,0x3aa)][_0x5bdc73(0x3d2,0x378)](tabPortRegex);function _0x5bdc73(_0x51589b,_0x40df09){return a0_0x2b2f2f(_0x40df09-0x16a,_0x51589b);}if(_0x5c7d91){if(_0x4bc77c[_0x5bdc73(0x217,0x2ba)](_0x4bc77c[_0x5bdc73(0x3fc,0x366)],_0x4bc77c[_0x5bdc73(0x301,0x287)]))_0x24743e[_0x5bdc73(0x307,0x389)](_0x4bc77c[_0x5bdc73(0x3bd,0x399)]);else{let _0x57f4ca=+_0x5c7d91[0x2];if(_0x5c7d91[0x1]===_0x4bc77c[_0x5bdc73(0x34d,0x3bd)])_0x4bc77c[_0x5bdc73(0x2e7,0x2d2)](_0x4bc77c[_0x5bdc73(0x1fc,0x273)],_0x4bc77c['JNLJo'])?(augmentedDomMessageContainer[_0x5bdc73(0x2e0,0x28c)][_0x57f4ca]=_0x1d2721,_0x1d2721[_0x5bdc73(0x2c7,0x29a)][_0x5bdc73(0x367,0x318)](()=>{function _0x2af641(_0x4dc312,_0x146dda){return _0x5bdc73(_0x146dda,_0x4dc312- -0x365);}augmentedDomMessageContainer['cache'][_0x57f4ca]=_0x4bc77c[_0x2af641(-0x4c,-0x31)](mergeArrays,augmentedDomMessageContainer['cache'][_0x57f4ca],augmentedDomMessageContainer[_0x2af641(0x39,-0xa)][_0x57f4ca]);}),_0x1d2721[_0x5bdc73(0x32d,0x322)][_0x5bdc73(0x3b7,0x318)]((_0x1fa8ca,_0x36a0c6,_0x424032)=>{function _0x3dff1e(_0x317f95,_0x14247f){return _0x5bdc73(_0x14247f,_0x317f95-0x24a);}_0x4bc77c['LwesS'](_0x1fa8ca[_0x3dff1e(0x567,0x50e)],_0x4bc77c[_0x3dff1e(0x552,0x51f)])&&(_0x4bc77c[_0x3dff1e(0x563,0x604)](emptySpecificMessageArray,_0x57f4ca,augmentedDomMessageContainer['cache']),_0x4bc77c[_0x3dff1e(0x4b8,0x4f5)](emptySpecificMessageArray,_0x57f4ca,augmentedDomMessageContainer[_0x3dff1e(0x5e8,0x684)]),resetBadge(_0x57f4ca));})):(!_0x162d7d[_0x5f26d4]&&(_0x5a7fd5[_0x262cd0]=[]),_0x262272[_0x27ac71][_0x5bdc73(0x366,0x355)](_0x39ceaa));else _0x4bc77c[_0x5bdc73(0x30c,0x377)](_0x5c7d91[0x1],_0x4bc77c['GEpqY'])&&(postMessageContainer[_0x5bdc73(0x2f9,0x28c)][_0x57f4ca]=_0x1d2721,_0x1d2721[_0x5bdc73(0x24b,0x29a)]['addListener'](()=>{function _0x12fddf(_0x1cbead,_0x54c24c){return _0x5bdc73(_0x54c24c,_0x1cbead- -0x226);}postMessageContainer[_0x12fddf(0x10f,0x1ac)][_0x57f4ca]=_0x4bc77c[_0x12fddf(0xf3,0x130)](mergeArrays,postMessageContainer[_0x12fddf(0x10f,0x6d)][_0x57f4ca],postMessageContainer['history'][_0x57f4ca]);}),_0x1d2721[_0x5bdc73(0x313,0x322)]['addListener']((_0x1e668e,_0x3f4b76,_0x56c6e0)=>{const _0x47b503={'QNSsr':function(_0x9e1cdd,_0xa06533,_0x20c486,_0x4c1b45){function _0x1e0a0d(_0x16adad,_0x1ddc46){return a0_0x5006(_0x16adad-0x276,_0x1ddc46);}return _0x4bc77c[_0x1e0a0d(0x4ea,0x585)](_0x9e1cdd,_0xa06533,_0x20c486,_0x4c1b45);},'ldrIm':_0x4bc77c[_0x4cc568(0x56a,0x53a)]};function _0x4cc568(_0x1c02d8,_0x4249f6){return _0x5bdc73(_0x1c02d8,_0x4249f6-0x1ac);}if(_0x4bc77c[_0x4cc568(0x417,0x498)](_0x4bc77c['koYxP'],_0x4bc77c['koYxP'])){let _0x4aa716=_0x137db3[_0x4cc568(0x50e,0x488)]['id'];for(let _0x52aedd of _0x570c0a){_0x47b503[_0x4cc568(0x467,0x46d)](_0xed5717,_0x4aa716,{'messageType':_0x47b503[_0x4cc568(0x3c2,0x41c)]},_0x52aedd[_0x4cc568(0x3e9,0x438)]);}}else _0x4bc77c[_0x4cc568(0x50f,0x4d2)](_0x1e668e[_0x4cc568(0x53d,0x4c9)],_0x4bc77c[_0x4cc568(0x410,0x4b4)])&&(_0x4bc77c[_0x4cc568(0x3d1,0x41a)](emptySpecificMessageArray,_0x57f4ca,postMessageContainer[_0x4cc568(0x4e9,0x4e1)]),_0x4bc77c[_0x4cc568(0x463,0x41a)](emptySpecificMessageArray,_0x57f4ca,postMessageContainer[_0x4cc568(0x5a5,0x54a)]),resetBadge(_0x57f4ca));}));}}else _0x1d2721[_0x5bdc73(0x307,0x3aa)]===_0x4bc77c[_0x5bdc73(0x3b9,0x3b5)]&&(_0x4bc77c['KLmmh'](_0x4bc77c[_0x5bdc73(0x2a3,0x2eb)],_0x4bc77c[_0x5bdc73(0x2c6,0x2e6)])?_0x1d2721[_0x5bdc73(0x2ff,0x322)][_0x5bdc73(0x286,0x318)]((_0x55207b,_0x1c1e2e,_0x50d1a5)=>{const _0x4cccd2={'JfCfM':function(_0x1c9976,_0x288044){return _0x4bc77c['SnvaE'](_0x1c9976,_0x288044);},'xINJi':function(_0xbb920f,_0x23a395,_0x50b915,_0x411959,_0x2f9505){return _0xbb920f(_0x23a395,_0x50b915,_0x411959,_0x2f9505);}};function _0x52d3bf(_0x3aa882,_0x5dad21){return _0x5bdc73(_0x5dad21,_0x3aa882- -0x124);}if(_0x4bc77c['LwesS'](_0x55207b[_0x52d3bf(0x1f9,0x160)],_0x4bc77c[_0x52d3bf(0x19b,0x1ee)])&&_0x1c1e2e&&_0x1c1e2e[_0x52d3bf(0x21e,0x265)]&&_0x1c1e2e[_0x52d3bf(0x21e,0x1d7)]['tab'])_0x4bc77c[_0x52d3bf(0x1e6,0x17f)]!=='eSyLP'?pushToArray(_0x1c1e2e[_0x52d3bf(0x21e,0x211)][_0x52d3bf(0x1b8,0x11c)]['id'],_0x1d2721,connections):(_0x4bc77c[_0x52d3bf(0x268,0x2e5)](_0x23591f,_0x34859d,_0x4e8a01,+_0x2d640e),_0x21be2a[_0x52d3bf(0x17e,0x122)][_0x332bb9]=!![]);else{if(_0x4bc77c[_0x52d3bf(0x149,0x126)](_0x55207b['messageType'],_0x52d3bf(0x155,0x1a9))){if(_0x55207b[_0x52d3bf(0x146,0x179)]&&_0x4bc77c[_0x52d3bf(0x1b9,0x24a)](_0x55207b[_0x52d3bf(0x146,0x14a)],_0x4bc77c['tNDvE'])&&_0x1c1e2e&&_0x1c1e2e['sender']&&_0x1c1e2e[_0x52d3bf(0x21e,0x1ed)][_0x52d3bf(0x1b8,0x14b)]){if(_0x4bc77c[_0x52d3bf(0x1b9,0x18a)](_0x4bc77c[_0x52d3bf(0x1c6,0x203)],_0x4bc77c[_0x52d3bf(0x278,0x315)])){_0x4cccd2[_0x52d3bf(0x209,0x26b)](_0x56b24e,_0x38ed55);for(let _0x50bb78 of _0x431e31){for(let [_0x170103,_0x1e85eb]of _0x53b290[_0x52d3bf(0x1ef,0x211)](_0x50bb78)){_0x1e85eb[_0x1f055f]&&delete _0x1e85eb[_0x36154d];}}}else addToQueue(_0x55207b,augmentedDomMessageContainer,_0x1c1e2e[_0x52d3bf(0x21e,0x22c)]['tab']['id']);}}else{if(_0x55207b['messageType']===_0x4bc77c[_0x52d3bf(0x156,0xd0)]){let _0x3e39f6=_0x55207b['tabId'];if(augmentedDomMessageContainer[_0x52d3bf(0x211,0x1b1)][_0x3e39f6]&&!augmentedDomMessageContainer[_0x52d3bf(0x211,0x229)][_0x3e39f6][_0x52d3bf(0x191,0x1be)]){if(_0x4bc77c[_0x52d3bf(0x1c8,0x1a0)](_0x4bc77c['WxbEc'],_0x4bc77c[_0x52d3bf(0x28a,0x24f)]))return;else _0x23d975[_0x52d3bf(0x19e,0x125)][_0x52d3bf(0x197,0x162)]&&_0x18042c[_0x52d3bf(0x265,0x1d5)](_0x4bc77c[_0x52d3bf(0x25d,0x233)],_0x46c9b1[_0x52d3bf(0x19e,0x149)][_0x52d3bf(0x197,0x1fd)]);}postMessageOverPort(_0x3e39f6,{'messageType':_0x4bc77c[_0x52d3bf(0x1cf,0x175)],'messageCache':_0x4bc77c[_0x52d3bf(0x14a,0x1f1)](takeElementsFromArray,augmentedDomMessageContainer[_0x52d3bf(0x211,0x260)],_0x3e39f6)},augmentedDomMessageContainer[_0x52d3bf(0x168,0x13a)])&&('sOniu'!==_0x4bc77c[_0x52d3bf(0x14d,0x1e9)]?_0x4bc77c['SHPpS'](reduceSpecificMessageCache,_0x3e39f6,augmentedDomMessageContainer['cache']):_0x3e25f9[_0x52d3bf(0x265,0x1fe)](_0x52d3bf(0x1a4,0x134),_0x235940[_0x52d3bf(0x19e,0x189)]['lastError']));}else{if(_0x4bc77c[_0x52d3bf(0x23a,0x2ba)](_0x55207b[_0x52d3bf(0x1f9,0x265)],_0x4bc77c[_0x52d3bf(0x283,0x1e0)])){let _0x5ddf20=_0x55207b[_0x52d3bf(0x1d8,0x18f)];if(postMessageContainer[_0x52d3bf(0x211,0x1ea)][_0x5ddf20]&&!postMessageContainer[_0x52d3bf(0x211,0x270)][_0x5ddf20][_0x52d3bf(0x191,0x21a)]){if(_0x4bc77c[_0x52d3bf(0x16a,0x160)]===_0x4bc77c[_0x52d3bf(0x16a,0x19d)])return;else for(let _0x3ec08e of _0x185ae5){_0x4cccd2[_0x52d3bf(0x164,0x1ae)](_0x337bc9,+_0x2b1fbe,_0x3ec08e[_0x52d3bf(0x19f,0x19a)],_0x2ad41a,!!_0x3ec08e[_0x52d3bf(0x15e,0x195)]),!_0x59a36e[_0x52d3bf(0x17e,0x156)][_0x22aa15]&&!_0x48534c[_0x52d3bf(0x17e,0x1be)][_0x5405c6]&&(_0x27c1dd(_0x5b9102,_0x5e0906,+_0x161f3a),_0x2bf5ed[_0x52d3bf(0x17e,0x1c3)][_0x240101]=!![]);}}_0x4bc77c[_0x52d3bf(0x217,0x191)](postMessageOverPort,_0x5ddf20,{'messageType':_0x4bc77c[_0x52d3bf(0x1cf,0x277)],'messageCache':_0x4bc77c[_0x52d3bf(0x1ee,0x1ba)](takeElementsFromArray,postMessageContainer['cache'],_0x5ddf20)},postMessageContainer[_0x52d3bf(0x168,0x20d)])&&(_0x4bc77c['iDUOf'](_0x52d3bf(0x151,0x1a8),'mIGTD')?_0x4bc77c['EJjNn'](reduceSpecificMessageCache,_0x5ddf20,postMessageContainer[_0x52d3bf(0x211,0x2b9)]):_0x32d414=_0x4bc77c[_0x52d3bf(0x1e9,0x24b)](_0x399a01[_0x52d3bf(0x1f3,0x18b)](0x1f,_0x4b0ae8),_0x13731a[_0x52d3bf(0x200,0x166)](_0x105c53))|0x0);}else _0x4bc77c[_0x52d3bf(0x196,0x1fd)](_0x55207b[_0x52d3bf(0x1f9,0x174)],_0x4bc77c[_0x52d3bf(0x250,0x25b)])&&(_0x55207b['from']&&_0x4bc77c[_0x52d3bf(0x160,0x18c)](_0x55207b[_0x52d3bf(0x146,0xfb)],_0x52d3bf(0x1de,0x219))&&_0x1c1e2e&&_0x1c1e2e[_0x52d3bf(0x21e,0x238)]&&_0x1c1e2e[_0x52d3bf(0x21e,0x1c9)][_0x52d3bf(0x1b8,0x147)]&&(_0x4bc77c[_0x52d3bf(0x1bb,0x1f6)](_0x4bc77c[_0x52d3bf(0x15d,0x190)],_0x4bc77c[_0x52d3bf(0x1f0,0x292)])?_0x3b6faf[_0x52d3bf(0x231,0x234)](0x2):_0x4bc77c['hbQoo'](addToQueue,_0x55207b,postMessageContainer,_0x1c1e2e['sender'][_0x52d3bf(0x1b8,0x204)]['id'])));}}}}):_0x3c6af8[_0x5bdc73(0x284,0x2ae)][_0x251263]=new _0x4703b4());}),chrome[a0_0x2b2f2f(0x158,0xe6)][a0_0x2b2f2f(0x1b8,0x146)]['addListener']((_0x5a05b1,_0x348eda,_0x14f7f7)=>{const _0x40d7b9={'CGeRc':function(_0x1ae4f3,_0x2f2c92,_0x529780){return _0x1ae4f3(_0x2f2c92,_0x529780);},'nQNSo':function(_0x256267,_0x5b9ea2){return _0x256267===_0x5b9ea2;},'APUAJ':function(_0x5bc03c,_0x82a022){return _0x5bc03c!==_0x82a022;},'rIjkj':_0x5924f1(0x146,0xf9),'nXxKz':function(_0x534638,_0xd9e8be,_0x8d2105,_0x1afcd8){return _0x534638(_0xd9e8be,_0x8d2105,_0x1afcd8);},'bhTEY':'reset','jagGt':'DOMINVADER_PONG','Fkdtj':_0x5924f1(0x223,0x177)};function _0x5924f1(_0x194cf7,_0x482e96){return a0_0x2b2f2f(_0x194cf7- -0x9,_0x482e96);}if(_0x40d7b9[_0x5924f1(0x214,0x282)](_0x5a05b1,_0x5924f1(0x125,0x128))){if(_0x348eda['frameId']===0x0){if(_0x40d7b9['APUAJ'](_0x40d7b9[_0x5924f1(0x158,0xf3)],_0x5924f1(0x146,0xc3)))_0x40d7b9[_0x5924f1(0x1c3,0x1d7)](_0x3a1552,_0x4c7f5d,_0x547555['cache']),_0x3ad11b(_0x5ef931,_0xe84aa3[_0x5924f1(0x22b,0x191)]),_0x987441(_0xca9a2);else{let _0x2efcf3=_0x348eda[_0x5924f1(0x169,0x18a)]['id'];for(let _0x585538 of panelContainers){_0x40d7b9[_0x5924f1(0x1e1,0x13a)](postMessageOverPort,_0x2efcf3,{'messageType':_0x40d7b9[_0x5924f1(0x12c,0x11b)]},_0x585538[_0x5924f1(0x119,0x78)]);}}}_0x14f7f7({'type':_0x40d7b9['jagGt'],'message':_0x40d7b9[_0x5924f1(0x18b,0xed)]});}});function sendSettings(_0x4b3519){try{window.localStorage.setItem('DOMInvaderSettings',_0x4b3519);}catch(e){}}function a0_0x13fe(){const _0x277dac=['uwrXCxC','yMHurvK','AfL1tum','Dw5KzwzPBMvK','yMfKz2vvCgrHDgvuAw1LCNm','D3f4uei','rxPYzxG','ChjPB3jPDhLrDwv1zq','zgLZy29UBMvJDa','B2fXCeu','zxrlrLO','AKnxtxu','C2LUAW','swjdAhy','mtq3BxnZtuvy','ChjVDg90ExbLug9SBhv0Aw9U','Dw5PCxvLtwvZC2fNzxm','CK9Ouve','zLbbrvK','vwX1wfu','z3rhzvC','CgPxrNm','zvvJwLK','BgvUz3rO','ufnksgq','AKTjBxm','Dw5PCxvLu2LUA3m','v3HLu20','v1rYugy','BgfZDevYCM9Y','D2fYBG','wgz6qMe','rMfpwee','uenhChq','zgvJBgfYyxrPDMvozxrszxf1zxn0','uu5tC3i','CNvUDgLTzq','BwvZC2fNzq','DxbKyxrLrhLUyw1Py1j1BgvZ','rMfPBgvKihrVihnLDcbIywrNzsb0zxH0','D0LTrxG','DLLfvLy','rMfPBgvKihrVihnLDcb0AxrSzq','CMvTB3zL','sLbLA3C','CKLQA2O','BNvkwgm','yMn5vNu','D0r6y0G','DhjHy2u','z21SDNy','yLHREue','wgz5wM0','EK1yAvK','z2v0tgf0zxn0','ihnPBMS','Bw52CMS','C1DlBhy','ChjVDg90ExbLug9SBhv0Aw9UwezYyw1Lt3b0Aw9UCW','ndGZmte2A3rXEM13','D3bAywe','zw5HyMXLza','DgfI','Cw5nyue','rNbmv3y','r2nnEfu','DLfNDKC','mtqWodmYmfj1u2HMCq','AwLireq','zg9TlwLUDMfKzxiTC2vYDMLJzs13B3jRzxiUANm','DuTLz2e','zNzzvuO','r1rTALm','uNvSzxmGDxbKyxrLza','u3nSDhu','uvbIExa','tfr2q1O','rNLOwgu','vw1mEeS','v0vurem','ANnwBui','ywreBLi','tu9ru08','ChfnEMO','BuTsEKK','ufflshy','nJe3odm1BLvPyMLO','rhHvzhq','Cg9ZDe1LC3nHz2u','BwfUAxb1Bgf0zwreyxrH','nJC1mhLbDwvfra','BuzkrfO','sxDJrgW','rMfPBgvKihrVihnLDcbIywnRz3jVDw5KignVBg91CG','DgfIswq','D1HWANK','rMTKDgO','DM5VCfu','sMzxtNm','zwfxtwC','y29UDgvUDc1Zy3jPChq','DgvZDa','t0fAEhC','y29UDgvUDc1Zzwn1CML0Es1WB2XPy3K','wezituq','ChjVDg90ExbLug9SBhv0Aw9Uq1nq','yunoCwS','B3jPz2LU','A0ncugm','C2v0qMfKz2vuzxH0','quDSExG','BwriD0y','AgfZ','B25jBNn0ywXSzwq','weDZEvm','tLjYrfa','ruPQtM4','zw50CMLLCW','A0DjzgG','yuTPvLi','DgfICW','Aw11Ba','ywrKtgLZDgvUzxi','qKDLte4','t3zRDeS','C2v0vgL0Bgu','DLPXCgi','BwvZC2fNzvr5Cgu','B25czwzVCMvoyxzPz2f0zq','yMfKz2vZ','C3bSAwnL','CMfUzg9T','B25nzxnZywDL','y3jLyxrL','y2HHCKnVzgvbDa','DMfSDwu','vMXrtKC','vxj1wNC','ALLPu1O','ig1LC3nHz2u','zvruwNq','BKHYsM8','suDZDLG','sMzdzK0','mtq3nJrwqMn6A0i','EwfMCfG','C09RwwG','C3rHy2TuCMfJzq','AgfZAa','zMXVB3i','yNjVD3nLCLjLBg9HzfjLCxvPCMvK','y2fJAgu','q0DLuMm','CgvYBwLZC2LVBNmTCg9SAwn5','sKrUy3e','qw5iEgy','rgjMzNK','AgjrB28','s0LNDfm','BKHtr2q','y0P4CMi','EKjzCNm','tLb2zK8','y29UzMLKzw5Jzq','C2vUzgvY','B0vhswG','y1nrqxG','yxvNBwvUDgvKlwrVBs5QCW','y291BNq','y0TTt0i','C291CMnL','vvLZEem','B01iBMy','C2v0qMfKz2vcywnRz3jVDw5Kq29SB3i','CfrhueC','rwDltxG','CM5nt1G','ANnKt0S','ELnoz2m','zLvwEMy','DMXKtxq','ve5qELO','BLH4s3O','ChvZAa','y29SBgvJDfbVC3rTzxnZywDL','uujSqNi','EwfyA04','ELvkCLG','CuPLwg8','re5KDxm','wevZuKq','iZzJnZu3za','thDLC1m','C2v2zxjPDhK','EfLwEhq','wxv4r2m','rgvfEgy','u3LktKK','Aw12vKG','DhD6yNq','zhjWzw8','yMr1yKi','y2fUyxj5','EgPywLm','r3rtt2G','BwfPBL9MCMfTzq','C3rVCMfNzq','Dg9kC29U','ywrKu3rVCMfNzuXPC3rLBMvY','zNjHBwvjza','mty0mdK1ngfrzxjirW','DxfUqK8','rePAu0O','qNPhtgO','BeLerhK','Cwvmree','u25LCuC','tgTctfi','Bwf0y2G','Ec1MCMfTzs1VChrPB25Z','ru5kzvO','zuz6CeK','sxDvBfC','z2v0u2v0DgLUzW','ywrurKi','zMTXsum','BezOD1m','sgjdCNy','vNr0tfC','Aw50zxjLC3rPBMC','zNjVBunOyxjdB2rL','q1brzhK','q1LWtxi','BLfou28','senlswy','Bg9N','tuzMvNO','s2DiDum','twj0t2q','C2v0u2v0DgLUzW','uLL3A3u','r2zOswi','CMPmz28','Aw5ZDgfSBa','D0Dqz2C','qNfwEKe','thz0ueW','vLPpAfK','ug9YDcbYzwfKEq','C2nYAxb0Aw5N','CK9otgG','r3LivKy','B25szxbSywnLza','r2LlDfO','uhfXC2m','AxnbCNjHEq','AgLZDg9YEq','y2XLyxjnzxnZywDLCW','vunSzNC','zxHLy3v0zvnJCMLWDa','uejwAwm','CMvHC29U','DgHLBG','Bg9HzfnLDhrPBMDZrNjVBujYB3DZzxi','BNzrBuS','y0Xvtfe','tvrVrMK','mtq2mZe3mLHWvNrStq','BMfTzq','ywn0Aw9U','CMv0DxjUug9ZDg1LC3nHz2veyxrH','A3vsBuO','DhzTEgm','CxvLDwu','q0rzAw4','swDuC3O','s2f3uey','zwXNEKC','sKn3Cuy','BgzKzuq','Aejuuhy','swL2vNO','CM9zvxm','cLrOzxjLigfYzsbZB21LigLUDgvYzxn0Aw5NihnPBMTZlG','t2joDhC','i2rJmZu0nq','txnSBwm','su5MsNy','C3vIx2zYyw1L','ls0Gre9nieLUDMfKzxi6ie1LC3nHz2uGzMfPBgvKihrVihnLBMq','BMv3vMfSDwu','ruvlBvq','B3v2r2m','q29rvxa','zNjVBq','cKzVDw5KihnVBwv0AgLUzYbPBNrLCMvZDgLUzY4','vfbpyuS','uMPiEgS','qLzdqM4','Aw5PDgLHBe1LC3nHz2u','BgrYsw0','y3bpq0u','Cef2zg8','vM9nthe','B25dAgfUz2vK','quXvrei','tu9MEui','CNv3Cxe','rNzyvu4','y29SBgvJDerHDge','AfzxCuG','DxjS','DKXACuG','CLvVsxC','t2vQt00','wuvkruS','zxHkC2y','q1nQA1e','ChjPB3jPDhK','CgvYBwLZC2LVBNnqB2XPy3K','rvHlwum','yMXkqNO','BMX5s3q','qwPgDuu','EeLosMK','tfbpBu8','C2XPy2u','BNbhvK8','Cg9YDhm','Bw9KAwz5sgvHzgvYCW','Cg1eBee','sxDwyve','wLndv0O','Dg9tDhjPBMC','q29PvMe','rM91BMqG','D2vItMf2AwDHDgLVBG','v3fWsxC','CgPSAxy','mwHntKvtzW','re9nsu5wqurfuL9qsu5h','qxzNqLO','B25eAxnJB25Uzwn0','DKDlzLq','CMvZzxq','ywrK'];a0_0x13fe=function(){return _0x277dac;};return a0_0x13fe();}chrome[a0_0x2b2f2f(0x12a,0x17f)][a0_0x2b2f2f(0x1b4,0x25d)][a0_0x2b2f2f(0x1ae,0x129)](function(_0x18a878){function _0x121e50(_0x120a5e,_0x4d6633){return a0_0x2b2f2f(_0x120a5e-0x110,_0x4d6633);}const _0x1c5b7e={'SEdvi':function(_0x1cc8cf,_0x1052b4){return _0x1cc8cf===_0x1052b4;},'bcyVu':'vLZqH','SChEY':function(_0x49553c,_0x4bdbb4){return _0x49553c(_0x4bdbb4);},'SneqG':'MAIN'};if(_0x1c5b7e['SEdvi'](_0x18a878[_0x121e50(0x315,0x35d)],0x0)){if(_0x121e50(0x222,0x20f)===_0x1c5b7e[_0x121e50(0x273,0x319)])settings[_0x121e50(0x333,0x3d0)](_0x121e50(0x2da,0x2f4),![]),settingsJson=settings[_0x121e50(0x313,0x33d)](),_0x1c5b7e['SChEY'](emptyMessages,_0x18a878['tabId']),/^https?:\/\//[_0x121e50(0x2a9,0x25c)](_0x18a878[_0x121e50(0x221,0x2b6)])&&chrome[_0x121e50(0x33d,0x3bc)][_0x121e50(0x347,0x2e7)]({'target':{'tabId':_0x18a878[_0x121e50(0x2a2,0x29f)],'allFrames':!![]},'func':sendSettings,'args':[settingsJson],'injectImmediately':!![],'world':_0x1c5b7e[_0x121e50(0x31c,0x2a1)]});else return'\x5c'+_0xd14166;}}),chrome[a0_0x2b2f2f(0x1ac,0x13e)]['onRemoved'][a0_0x2b2f2f(0x1ae,0x123)](_0x96f77b=>{destroyMessageObjects(_0x96f77b);}),chrome[a0_0x2b2f2f(0x1ac,0x156)][a0_0x2b2f2f(0x230,0x232)][a0_0x2b2f2f(0x1ae,0x256)]((_0x3483a1,_0x22d428)=>{const _0x3db74a={'dyBGx':function(_0x346a35,_0xf4174a){return _0x346a35(_0xf4174a);}};_0x3db74a['dyBGx'](destroyMessageObjects,_0x22d428);}),chrome[a0_0x2b2f2f(0x158,0x17a)][a0_0x2b2f2f(0x1a5,0x248)][a0_0x2b2f2f(0x1ae,0x187)](_0x142f90=>{const _0xc9128a={'ACjrU':_0x2ad6aa(0x154,0x126),'PSJHd':_0x2ad6aa(-0x3,0x76),'OejOM':_0x2ad6aa(0x172,0x16b),'XGsyS':'install','FaOXA':_0x2ad6aa(0x161,0xf7),'wImEx':_0x2ad6aa(0x9d,0x4b),'bdubB':'canary','MToFi':function(_0x5e0e7c,_0x44531c){return _0x5e0e7c+_0x44531c;},'pqMzj':function(_0x260619,_0x5c6578){return _0x260619+_0x5c6578;},'InOik':function(_0x5ce3a5,_0x4e2e74){return _0x5ce3a5*_0x4e2e74;}};function _0x2ad6aa(_0x2f92bf,_0x4bcc9b){return a0_0x2b2f2f(_0x4bcc9b- -0xe9,_0x2f92bf);}_0x142f90[_0x2ad6aa(0x113,0x150)]===_0xc9128a[_0x2ad6aa(0x76,0xbd)]&&(_0xc9128a[_0x2ad6aa(0x41,0x6b)]!==_0xc9128a[_0x2ad6aa(0x1e,0x73)]?settings[_0x2ad6aa(0x174,0x13a)](_0xc9128a[_0x2ad6aa(0x1b3,0x114)],_0xc9128a[_0x2ad6aa(0xed,0x155)](String[_0x2ad6aa(0x1b7,0x131)](Math[_0x2ad6aa(0x125,0xe0)](_0xc9128a[_0x2ad6aa(0x103,0x9e)](_0xc9128a['InOik'](Math[_0x2ad6aa(0x131,0xce)](),0x7a-0x61+0x1),0x61))),Math[_0x2ad6aa(0x13a,0xce)]()[_0x2ad6aa(0x21,0x3e)](0x24)[_0x2ad6aa(-0x6a,0x37)](-0x7))):_0x3acad7[_0x2ad6aa(0xca,0x102)]({'id':0x2,'priority':0x1,'action':{'type':'modifyHeaders','responseHeaders':[{'header':_0xc9128a['ACjrU'],'operation':_0xc9128a[_0x2ad6aa(-0x28,0x63)]}]},'condition':{'urlFilter':'*','resourceTypes':['main_frame',_0xc9128a[_0x2ad6aa(-0x26,0x2b)]]}}));}),chrome[a0_0x2b2f2f(0x158,0x193)]['onStartup'][a0_0x2b2f2f(0x1ae,0x24d)](()=>{updateDOMInvaderRules();});function updateDOMInvaderRules(){function _0x238116(_0x30c109,_0x28dd6b){return a0_0x2b2f2f(_0x30c109- -0x1f0,_0x28dd6b);}const _0x225542={'zBYrs':function(_0x50476d,_0x393192,_0x15e22d,_0x5eab96,_0x39414f){return _0x50476d(_0x393192,_0x15e22d,_0x5eab96,_0x39414f);},'GfhIb':function(_0x91ca02,_0x4b48b1,_0x270493,_0x205d44){return _0x91ca02(_0x4b48b1,_0x270493,_0x205d44);},'jsdOK':function(_0x40e267,_0x2cb54b){return _0x40e267===_0x2cb54b;},'WETDC':_0x238116(-0xe8,-0x100),'EEKmT':_0x238116(-0x73,-0x6),'eaWMg':function(_0x1ea693,_0x37f987){return _0x1ea693&&_0x37f987;},'WqpIw':function(_0x5e035e,_0x5a9d4f){return _0x5e035e!==_0x5a9d4f;},'adDnR':_0x238116(-0x61,-0xf8),'ENJeZ':_0x238116(-0xcd,-0x121),'GPARP':_0x238116(-0x55,-0x101),'rjLgo':'remove','nuJXc':_0x238116(0x11,-0x6b),'mKRzI':_0x238116(0x64,0x50),'GVTzB':_0x238116(0x1f,-0x8)},_0x154a70=[],_0x198ec9=[];chrome[_0x238116(-0x9a,-0xf9)]['updateDynamicRules']({'removeRuleIds':[0x1,0x2,0x3]},()=>{function _0x553e88(_0x2aef8f,_0x4e0a15){return _0x238116(_0x2aef8f- -0x1a9,_0x4e0a15);}const _0x308028={'DNdus':function(_0x3af627,_0x3bc8d3,_0x9d1303,_0x54bac3,_0x2179d9){function _0x59fa54(_0x1e9b7f,_0x2b6615){return a0_0x5006(_0x1e9b7f-0x39b,_0x2b6615);}return _0x225542[_0x59fa54(0x59e,0x54c)](_0x3af627,_0x3bc8d3,_0x9d1303,_0x54bac3,_0x2179d9);},'nHSGd':function(_0x215bd5,_0x1e51a6,_0x4f66fd,_0x5b49b9){function _0x1c65dc(_0x3271fa,_0x4206e0){return a0_0x5006(_0x3271fa-0xb5,_0x4206e0);}return _0x225542[_0x1c65dc(0x308,0x368)](_0x215bd5,_0x1e51a6,_0x4f66fd,_0x5b49b9);}};_0x225542[_0x553e88(-0x1b4,-0x24c)](_0x225542[_0x553e88(-0x216,-0x1fc)],_0x225542[_0x553e88(-0x216,-0x170)])?console[_0x553e88(-0x17a,-0x151)](_0x225542[_0x553e88(-0x142,-0x198)]):(_0x308028[_0x553e88(-0x1a8,-0x1ea)](_0x1a923e,+_0x5b852f,_0x8bcad8['trace'],_0xa329a9,!!_0x14f5b1[_0x553e88(-0x281,-0x25b)]),!_0x4b4b9b['badgeUpdateTimers'][_0x547a19]&&!_0x287d36['badgeUpdateTimers'][_0x19a820]&&(_0x308028[_0x553e88(-0x1c6,-0x1f1)](_0x4ce9e3,_0x12c264,_0x36a05f,+_0x5d4b8e),_0x488389[_0x553e88(-0x261,-0x23b)][_0x33f89e]=!![]));}),_0x225542[_0x238116(-0x59,-0x13)](isDOMInvaderEnabled,isPrototypePollutionEnabled)&&prototypePollutionCSP?_0x225542[_0x238116(-0xc5,-0xe3)](_0x225542[_0x238116(-0x6b,-0xf0)],_0x225542[_0x238116(-0x6b,0x1d)])?_0x33785f['action'][_0x238116(-0xf,0x3e)]({'tabId':_0x19da36,'color':_0x238116(0x61,0x43)},()=>{function _0x3d4616(_0x12fa98,_0xcbbda7){return _0x238116(_0xcbbda7- -0x18c,_0x12fa98);}_0x4465d4[_0x3d4616(-0x203,-0x224)]['lastError']&&_0x569ef3[_0x3d4616(-0x1fa,-0x15d)](_0x3d4616(-0x28f,-0x1eb),_0x2b8b46[_0x3d4616(-0x2c3,-0x224)]['lastError']);}):_0x154a70[_0x238116(-0x5,0xa4)]({'id':0x1,'priority':0x1,'action':{'type':_0x225542[_0x238116(0x20,-0x22)],'responseHeaders':[{'header':_0x225542['GPARP'],'operation':_0x225542[_0x238116(0x36,0x82)]}]},'condition':{'urlFilter':'*','resourceTypes':[_0x225542[_0x238116(-0x8e,-0xf3)],_0x225542[_0x238116(-0x68,-0xaf)]]}}):_0x198ec9[_0x238116(-0x5,-0x70)](0x1),isDOMInvaderEnabled&&isPrototypePollutionEnabled&&prototypePollutionXFrameOptions?_0x154a70['push']({'id':0x2,'priority':0x1,'action':{'type':_0x225542[_0x238116(0x20,-0x66)],'responseHeaders':[{'header':_0x225542['GVTzB'],'operation':_0x225542[_0x238116(0x36,0x19)]}]},'condition':{'urlFilter':'*','resourceTypes':[_0x238116(0x11,-0x34),_0x225542['mKRzI']]}}):_0x198ec9[_0x238116(-0x5,-0x20)](0x2),_0x225542[_0x238116(-0x59,-0xa3)](isDOMInvaderEnabled,permissionsPolicy)?_0x154a70[_0x238116(-0x5,-0x84)]({'id':0x3,'priority':0x1,'action':{'type':_0x225542[_0x238116(0x20,0xc0)],'responseHeaders':[{'header':_0x238116(-0x23,-0xb9),'operation':'remove'}]},'condition':{'urlFilter':'*','resourceTypes':[_0x225542[_0x238116(-0x8e,-0x4b)],_0x225542[_0x238116(-0x68,-0x69)]]}}):_0x198ec9[_0x238116(-0x5,0x2b)](0x3),chrome[_0x238116(-0x9a,-0x9a)][_0x238116(-0x96,-0x3e)]({'addRules':_0x154a70,'removeRuleIds':_0x198ec9},()=>{function _0x6d324c(_0x156577,_0x5482bf){return _0x238116(_0x156577-0x5d6,_0x5482bf);}console[_0x6d324c(0x605,0x558)](_0x225542[_0x6d324c(0x63d,0x6bf)]);});}
chrome.runtime.onInstalled.addListener(reason => {
    updateIcon();
});