/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import java.util.Arrays;
import java.util.Objects;

public class StyledString
implements CharSequence {
    private final String mValue;
    private final Span[] mSpans;

    public StyledString(String value, Span[] spans) {
        assert (value != null && spans != null);
        this.mValue = value;
        this.mSpans = spans;
    }

    public String getValue() {
        return this.mValue;
    }

    public Span[] getSpans() {
        return this.mSpans;
    }

    @Override
    public int length() {
        return this.mValue.length();
    }

    @Override
    public char charAt(int index) {
        return this.mValue.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.mValue.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.mValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StyledString) {
            StyledString other = (StyledString)obj;
            return this.mValue.equals(other.mValue) && Arrays.equals(this.mSpans, other.mSpans);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mValue, Arrays.hashCode(this.mSpans));
    }

    public static class Span {
        private final String mTag;
        private final int mFirstChar;
        private final int mLastChar;

        public Span(String tag, int firstChar, int lastChar) {
            assert (tag != null);
            this.mTag = tag;
            this.mFirstChar = firstChar;
            this.mLastChar = lastChar;
        }

        public String getTag() {
            return this.mTag;
        }

        public int getFirstChar() {
            return this.mFirstChar;
        }

        public int getLastChar() {
            return this.mLastChar;
        }
    }
}

